/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.util.List;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.forecast.model.ForecastResult;
import org.opensearch.forecast.ratelimit.ForecastResultWriteRequest;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.forecast.transport.ForecastResultBulkAction;
import org.opensearch.forecast.transport.ForecastResultBulkRequest;
import org.opensearch.index.IndexingPressure;
import org.opensearch.timeseries.transport.ResultBulkTransportAction;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class ForecastResultBulkTransportAction
extends ResultBulkTransportAction<ForecastResult, ForecastResultWriteRequest, ForecastResultBulkRequest> {
    @Inject
    public ForecastResultBulkTransportAction(TransportService transportService, ActionFilters actionFilters, IndexingPressure indexingPressure, Settings settings, ClusterService clusterService, Client client) {
        super(ForecastResultBulkAction.NAME, transportService, actionFilters, indexingPressure, settings, client, ((Float)ForecastSettings.FORECAST_INDEX_PRESSURE_SOFT_LIMIT.get(settings)).floatValue(), ((Float)ForecastSettings.FORECAST_INDEX_PRESSURE_HARD_LIMIT.get(settings)).floatValue(), ForecastIndex.RESULT.getIndexName(), ForecastResultBulkRequest::new);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.FORECAST_INDEX_PRESSURE_SOFT_LIMIT, it -> {
            this.softLimit = it.floatValue();
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.FORECAST_INDEX_PRESSURE_HARD_LIMIT, it -> {
            this.hardLimit = it.floatValue();
        });
    }

    @Override
    public BulkRequest prepareBulkRequest(float indexingPressurePercent, ForecastResultBulkRequest request) {
        BulkRequest bulkRequest = new BulkRequest();
        List results = request.getResults();
        if (indexingPressurePercent <= this.softLimit) {
            for (ForecastResultWriteRequest resultWriteRequest : results) {
                this.addResult(bulkRequest, (ToXContentObject)resultWriteRequest.getResult(), resultWriteRequest.getResultIndex());
                if (resultWriteRequest.getFlattenResultIndex() == null) continue;
                this.addResult(bulkRequest, (ToXContentObject)resultWriteRequest.getResult(), resultWriteRequest.getFlattenResultIndex());
            }
        } else if (indexingPressurePercent <= this.hardLimit) {
            float acceptProbability = 1.0f - indexingPressurePercent;
            for (ForecastResultWriteRequest resultWriteRequest : results) {
                ForecastResult result = (ForecastResult)resultWriteRequest.getResult();
                if (!(this.random.nextFloat() < acceptProbability)) continue;
                this.addResult(bulkRequest, result, resultWriteRequest.getResultIndex());
                if (resultWriteRequest.getFlattenResultIndex() == null) continue;
                this.addResult(bulkRequest, result, resultWriteRequest.getFlattenResultIndex());
            }
        } else {
            for (ForecastResultWriteRequest resultWriteRequest : results) {
                ForecastResult result = (ForecastResult)resultWriteRequest.getResult();
                if (!result.isHighPriority()) continue;
                this.addResult(bulkRequest, result, resultWriteRequest.getResultIndex());
                if (resultWriteRequest.getFlattenResultIndex() == null) continue;
                this.addResult(bulkRequest, result, resultWriteRequest.getFlattenResultIndex());
            }
        }
        return bulkRequest;
    }
}

