/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ForecastDescriptor;
import com.amazon.randomcutforest.parkservices.PredictorCorrector;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.calibration.ErrorHandler;
import com.amazon.randomcutforest.parkservices.config.Calibration;
import com.amazon.randomcutforest.parkservices.config.ScoringStrategy;
import com.amazon.randomcutforest.parkservices.returntypes.RCFComputeDescriptor;
import com.amazon.randomcutforest.preprocessor.Preprocessor;
import com.amazon.randomcutforest.returntypes.RangeVector;
import com.amazon.randomcutforest.returntypes.TimedRangeVector;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;

public class RCFCaster
extends ThresholdedRandomCutForest {
    public static double DEFAULT_ERROR_PERCENTILE = 0.1;
    public static Calibration DEFAULT_CALIBRATION = Calibration.SIMPLE;
    protected int forecastHorizon;
    protected ErrorHandler errorHandler;
    protected int errorHorizon;
    protected Calibration calibrationMethod;

    public static Builder builder() {
        return new Builder();
    }

    public RCFCaster(Builder builder) {
        super(builder);
        this.forecastHorizon = builder.forecastHorizon;
        this.errorHorizon = builder.errorHorizon;
        ErrorHandler.Builder errorBuilder = ErrorHandler.builder().dimensions(builder.dimensions).shingleSize(builder.shingleSize).forecastHorizon(builder.forecastHorizon).percentile(builder.percentile).errorHorizon(builder.errorHorizon).useRCF(builder.useRCF);
        builder.lowerLimit.ifPresent(errorBuilder::lowerLimit);
        builder.upperLimit.ifPresent(errorBuilder::upperLimit);
        this.errorHandler = new ErrorHandler(errorBuilder);
        this.calibrationMethod = builder.calibrationMethod;
    }

    public RCFCaster(ForestMode forestMode, TransformMethod transformMethod, ScoringStrategy scoringStrategy, RandomCutForest forest, PredictorCorrector predictorCorrector, Preprocessor preprocessor, RCFComputeDescriptor descriptor, int forecastHorizon, ErrorHandler errorHandler, int errorHorizon, Calibration calibrationMethod) {
        super(forestMode, transformMethod, scoringStrategy, forest, predictorCorrector, preprocessor, descriptor);
        this.forecastHorizon = forecastHorizon;
        this.errorHandler = errorHandler;
        this.errorHorizon = errorHorizon;
        this.calibrationMethod = calibrationMethod;
    }

    @Override
    public ForecastDescriptor process(double[] inputPoint, long timestamp) {
        return this.process(inputPoint, timestamp, null);
    }

    void augment(ForecastDescriptor answer) {
        super.augment(answer);
        TimedRangeVector timedForecast = new TimedRangeVector(this.forest.getDimensions() * this.forecastHorizon / this.preprocessor.getShingleSize(), this.forecastHorizon);
        if (this.forest.isOutputReady() && this.preprocessor.isOutputReady()) {
            if (this.errorHandler.getSequenceIndex() > 0) {
                this.errorHandler.updateActuals(answer.getCurrentInput(), answer.getPostDeviations());
                this.errorHandler.augmentDescriptor(answer);
            }
            timedForecast = this.extrapolate(this.forecastHorizon, true, 1.0);
            this.errorHandler.updateForecasts(timedForecast.rangeVector);
        }
        answer.setTimedForecast(timedForecast);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForecastDescriptor process(double[] inputPoint, long timestamp, int[] missingValues) {
        CommonUtils.checkArgument((missingValues == null ? 1 : 0) != 0, (String)"on the fly imputation and error estimation should not mix");
        ForecastDescriptor answer = new ForecastDescriptor(inputPoint, timestamp, this.forecastHorizon);
        answer.setScoringStrategy(this.scoringStrategy);
        boolean cacheDisabled = this.forest.getBoundingBoxCacheFraction() == 0.0;
        try {
            if (cacheDisabled) {
                this.forest.setBoundingBoxCacheFraction(1.0);
            }
            this.augment(answer);
        }
        finally {
            if (cacheDisabled) {
                this.forest.setBoundingBoxCacheFraction(0.0);
            }
        }
        return answer;
    }

    public void calibrate(double[] actuals, Calibration calibration, RangeVector ranges) {
        this.errorHandler.calibrate(actuals, calibration, ranges);
    }

    @Override
    public TimedRangeVector extrapolate(int horizon, boolean correct, double centrality) {
        return this.extrapolate(this.calibrationMethod, horizon, correct, centrality);
    }

    public TimedRangeVector extrapolate(Calibration calibration, int horizon, boolean correct, double centrality) {
        TimedRangeVector answer = super.extrapolate(horizon, correct, centrality);
        double[] last = this.getPreprocessor().getShingledInput(this.getPreprocessor().getShingleSize() - 1);
        this.calibrate(last, calibration, answer.rangeVector);
        return answer;
    }

    @Override
    public List<AnomalyDescriptor> processSequentially(double[][] data, Function<AnomalyDescriptor, Boolean> filter) {
        if (data == null || data.length == 0) {
            return new ArrayList<AnomalyDescriptor>();
        }
        long timestamp = this.preprocessor.getInternalTimeStamp();
        long[] timestamps = new long[data.length];
        for (int i = 0; i < data.length; ++i) {
            timestamps[i] = ++timestamp;
        }
        return this.processSequentially(data, timestamps, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AnomalyDescriptor> processSequentially(double[][] data, long[] timestamps, Function<AnomalyDescriptor, Boolean> filter) {
        CommonUtils.checkArgument((filter != null ? 1 : 0) != 0, (String)"filter must not be null");
        if (data != null && data.length > 0) {
            CommonUtils.checkArgument((timestamps != null ? 1 : 0) != 0, (String)"timestamps must not be null when data is non-empty");
            CommonUtils.checkArgument((timestamps.length == data.length ? 1 : 0) != 0, (String)String.format(Locale.ROOT, "timestamps length (%s) must equal data length (%s)", timestamps.length, data.length));
            for (int i = 1; i < timestamps.length; ++i) {
                CommonUtils.checkArgument((timestamps[i] > timestamps[i - 1] ? 1 : 0) != 0, (String)String.format(Locale.ROOT, "timestamps must be strictly ascending: timestamps[%s]=%s is not > timestamps[%s]=%s", i, timestamps[i], i - 1, timestamps[i - 1]));
            }
        }
        ArrayList<AnomalyDescriptor> answer = new ArrayList<AnomalyDescriptor>();
        if (data != null && data.length > 0) {
            boolean cacheDisabled = this.forest.getBoundingBoxCacheFraction() == 0.0;
            try {
                if (cacheDisabled) {
                    this.forest.setBoundingBoxCacheFraction(1.0);
                }
                int length = this.preprocessor.getInputLength();
                for (int i = 0; i < data.length; ++i) {
                    double[] point = data[i];
                    CommonUtils.checkArgument((point != null ? 1 : 0) != 0, (String)" data should not be null ");
                    CommonUtils.checkArgument((point.length == length ? 1 : 0) != 0, (String)" nonuniform lengths ");
                    ForecastDescriptor description = new ForecastDescriptor(point, timestamps[i], this.forecastHorizon);
                    this.augment(description);
                    if (!filter.apply(description).booleanValue()) continue;
                    answer.add(description);
                }
            }
            finally {
                if (cacheDisabled) {
                    this.forest.setBoundingBoxCacheFraction(0.0);
                }
            }
        }
        return answer;
    }

    public void setUpperLimit(float[] upperLimit) {
        this.errorHandler.setUpperLimit(upperLimit);
    }

    public void setLowerLimit(float[] lowerLimit) {
        this.errorHandler.setLowerLimit(lowerLimit);
    }

    @Generated
    public int getForecastHorizon() {
        return this.forecastHorizon;
    }

    @Generated
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Generated
    public int getErrorHorizon() {
        return this.errorHorizon;
    }

    @Generated
    public Calibration getCalibrationMethod() {
        return this.calibrationMethod;
    }

    @Generated
    public void setForecastHorizon(int forecastHorizon) {
        this.forecastHorizon = forecastHorizon;
    }

    @Generated
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Generated
    public void setErrorHorizon(int errorHorizon) {
        this.errorHorizon = errorHorizon;
    }

    @Generated
    public void setCalibrationMethod(Calibration calibrationMethod) {
        this.calibrationMethod = calibrationMethod;
    }

    public static class Builder
    extends ThresholdedRandomCutForest.Builder<Builder> {
        int forecastHorizon;
        int errorHorizon;
        double percentile = DEFAULT_ERROR_PERCENTILE;
        protected Calibration calibrationMethod = DEFAULT_CALIBRATION;
        protected boolean useRCF = false;
        Optional<float[]> upperLimit = Optional.empty();
        Optional<float[]> lowerLimit = Optional.empty();

        Builder() {
            this.transformMethod = TransformMethod.NORMALIZE;
        }

        public Builder forecastHorizon(int horizon) {
            this.forecastHorizon = horizon;
            return this;
        }

        public Builder errorHorizon(int errorHorizon) {
            this.errorHorizon = errorHorizon;
            return this;
        }

        public Builder percentile(double percentile) {
            this.percentile = percentile;
            return this;
        }

        public Builder calibration(Calibration calibrationMethod) {
            this.calibrationMethod = calibrationMethod;
            return this;
        }

        public Builder lowerLimit(float[] lowerLimit) {
            this.lowerLimit = Optional.of(lowerLimit);
            return this;
        }

        public Builder upperLimit(float[] upperLimit) {
            this.upperLimit = Optional.of(upperLimit);
            return this;
        }

        public Builder useRCFCallibration(boolean use) {
            this.useRCF = use;
            return this;
        }

        @Override
        public RCFCaster build() {
            CommonUtils.checkArgument((this.forecastHorizon > 0 ? 1 : 0) != 0, (String)"need non-negative horizon");
            CommonUtils.checkArgument((this.shingleSize > 0 ? 1 : 0) != 0, (String)"need shingle size > 1");
            CommonUtils.checkArgument((this.forestMode != ForestMode.STREAMING_IMPUTE ? 1 : 0) != 0, (String)"error estimation with on the fly imputation should not be abstracted, either estimate errors outside of this object or perform on the fly imputation outside this code");
            CommonUtils.checkArgument((this.forestMode != ForestMode.TIME_AUGMENTED ? 1 : 0) != 0, (String)"error estimation when time is used as a field in the forest should not be abstractedperform estimation outside this code");
            CommonUtils.checkArgument((!this.internalShinglingEnabled.isPresent() || (Boolean)this.internalShinglingEnabled.get() != false ? 1 : 0) != 0, (String)"internal shingling only");
            int inputLength = this.dimensions / this.shingleSize;
            if (this.errorHorizon == 0) {
                this.errorHorizon = Math.max(this.sampleSize, 2 * this.forecastHorizon);
            }
            this.validate();
            return new RCFCaster(this);
        }
    }
}

