/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.runner;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.runner.LineTransformer;
import com.amazon.randomcutforest.runner.SimpleRunner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class SimpleDensityRunner
extends SimpleRunner {
    public SimpleDensityRunner() {
        super(SimpleDensityRunner.class.getName(), "Compute directional density vectors from the input rows and append them to the output rows.", SimpleDensityTransformer::new);
    }

    public static void main(String ... args) throws IOException {
        SimpleDensityRunner runner = new SimpleDensityRunner();
        runner.parse(args);
        System.out.println("Reading from stdin... (Ctrl-c to exit)");
        runner.run(new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8)), new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8)));
        System.out.println("Done.");
    }

    public static class SimpleDensityTransformer
    implements LineTransformer {
        private final RandomCutForest forest;

        public SimpleDensityTransformer(RandomCutForest forest) {
            this.forest = forest;
        }

        @Override
        public List<String> getResultValues(double ... point) {
            DiVector densityFactors = this.forest.getSimpleDensity(point).getDirectionalDensity();
            this.forest.update(point);
            ArrayList<String> result = new ArrayList<String>(2 * this.forest.getDimensions());
            for (int i = 0; i < this.forest.getDimensions(); ++i) {
                result.add(String.format("%f", densityFactors.high[i]));
                result.add(String.format("%f", densityFactors.low[i]));
            }
            return result;
        }

        @Override
        public List<String> getEmptyResultValue() {
            ArrayList<String> result = new ArrayList<String>(2 * this.forest.getDimensions());
            for (int i = 0; i < 2 * this.forest.getDimensions(); ++i) {
                result.add("NA");
            }
            return result;
        }

        @Override
        public List<String> getResultColumnNames() {
            ArrayList<String> result = new ArrayList<String>(2 * this.forest.getDimensions());
            for (int i = 0; i < this.forest.getDimensions(); ++i) {
                result.add(String.format("prob_mass_%d_up", i));
                result.add(String.format("prob_mass_%d_down", i));
            }
            return result;
        }

        @Override
        public RandomCutForest getForest() {
            return this.forest;
        }
    }
}

