/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.IPointStoreView;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.IBoundingBoxView;
import com.amazon.randomcutforest.tree.INodeView;
import com.amazon.randomcutforest.tree.RandomCutTree;
import java.util.HashMap;

public class NodeView
implements INodeView {
    public static double SWITCH_FRACTION = 0.499;
    RandomCutTree tree;
    int currentNodeOffset;
    float[] leafPoint;
    BoundingBox currentBox;

    public NodeView(RandomCutTree tree, IPointStoreView<float[]> pointStoreView, int root) {
        this.currentNodeOffset = root;
        this.tree = tree;
    }

    @Override
    public int getMass() {
        return this.tree.getMass(this.currentNodeOffset);
    }

    @Override
    public IBoundingBoxView getBoundingBox() {
        if (this.currentBox == null) {
            return this.tree.getBox(this.currentNodeOffset);
        }
        return this.currentBox;
    }

    @Override
    public IBoundingBoxView getSiblingBoundingBox(float[] point) {
        return this.toLeft(point) ? this.tree.getBox(this.tree.nodeStore.getRightIndex(this.currentNodeOffset)) : this.tree.getBox(this.tree.nodeStore.getLeftIndex(this.currentNodeOffset));
    }

    @Override
    public int getCutDimension() {
        return this.tree.nodeStore.getCutDimension(this.currentNodeOffset);
    }

    @Override
    public double getCutValue() {
        return this.tree.nodeStore.getCutValue(this.currentNodeOffset);
    }

    @Override
    public float[] getLeafPoint() {
        return this.leafPoint;
    }

    @Override
    public HashMap<Long, Integer> getSequenceIndexes() {
        CommonUtils.checkState(this.isLeaf(), "can only be invoked for a leaf");
        if (this.tree.storeSequenceIndexesEnabled) {
            return this.tree.getSequenceMap(this.tree.getPointIndex(this.currentNodeOffset));
        }
        return new HashMap<Long, Integer>();
    }

    @Override
    public double probailityOfSeparation(float[] point) {
        return this.tree.probabilityOfCut(this.currentNodeOffset, point, this.currentBox);
    }

    @Override
    public int getLeafPointIndex() {
        return this.tree.getPointIndex(this.currentNodeOffset);
    }

    @Override
    public boolean isLeaf() {
        return this.tree.nodeStore.isLeaf(this.currentNodeOffset);
    }

    protected void setCurrentNode(int newNode, int index, boolean setBox) {
        this.currentNodeOffset = newNode;
        this.leafPoint = this.tree.pointStoreView.getNumericVector(index);
        if (setBox && this.tree.boundingBoxCacheFraction < SWITCH_FRACTION) {
            this.currentBox = new BoundingBox(this.leafPoint, this.leafPoint);
        }
    }

    protected void setCurrentNodeOnly(int newNode) {
        this.currentNodeOffset = newNode;
    }

    public void updateToParent(int parent, int currentSibling, boolean updateBox) {
        this.currentNodeOffset = parent;
        if (updateBox && this.tree.boundingBoxCacheFraction < SWITCH_FRACTION) {
            this.tree.growNodeBox(this.currentBox, this.tree.pointStoreView, parent, currentSibling);
        }
    }

    protected boolean toLeft(float[] point) {
        return (double)point[this.tree.nodeStore.getCutDimension(this.currentNodeOffset)] <= this.tree.nodeStore.getCutValue(this.currentNodeOffset);
    }
}

