"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    policyService
  } = services;
  router.get({
    path: _constants.NODE_API.POLICIES,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, policyService.getPolicies);
  router.put({
    path: `${_constants.NODE_API.POLICIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number()),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, policyService.putPolicy);
  router.get({
    path: `${_constants.NODE_API.POLICIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, policyService.getPolicy);
  router.delete({
    path: `${_constants.NODE_API.POLICIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, policyService.deletePolicy);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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