/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.h3;

import org.opensearch.geospatial.h3.Constants;
import org.opensearch.geospatial.h3.Vec2d;

final class CoordIJK {
    private static final int[][] UNIT_VECS = new int[][]{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}, {0, 1, 1}, {1, 0, 0}, {1, 0, 1}, {1, 1, 0}};
    int i;
    int j;
    int k;

    CoordIJK(int i, int j, int k) {
        this.i = i;
        this.j = j;
        this.k = k;
    }

    public Vec2d ijkToHex2d() {
        int i = this.i - this.k;
        int j = this.j - this.k;
        return new Vec2d((double)i - 0.5 * (double)j, (double)j * Constants.M_SQRT3_2);
    }

    public void ijkAdd(int i, int j, int k) {
        this.i += i;
        this.j += j;
        this.k += k;
    }

    public void ijkSub(int i, int j, int k) {
        this.i -= i;
        this.j -= j;
        this.k -= k;
    }

    public void ijkNormalize() {
        int min;
        if (this.i < 0) {
            this.j -= this.i;
            this.k -= this.i;
            this.i = 0;
        }
        if (this.j < 0) {
            this.i -= this.j;
            this.k -= this.j;
            this.j = 0;
        }
        if (this.k < 0) {
            this.i -= this.k;
            this.j -= this.k;
            this.k = 0;
        }
        if (this.j < (min = this.i)) {
            min = this.j;
        }
        if (this.k < min) {
            min = this.k;
        }
        if (min > 0) {
            this.i -= min;
            this.j -= min;
            this.k -= min;
        }
    }

    public void downAp7() {
        int i = this.i * 3 + this.j * 1 + this.k * 0;
        int j = this.i * 0 + this.j * 3 + this.k * 1;
        int k = this.i * 1 + this.j * 0 + this.k * 3;
        this.i = i;
        this.j = j;
        this.k = k;
        this.ijkNormalize();
    }

    public void downAp7r() {
        int i = this.i * 3 + this.j * 0 + this.k * 1;
        int j = this.i * 1 + this.j * 3 + this.k * 0;
        int k = this.i * 0 + this.j * 1 + this.k * 3;
        this.i = i;
        this.j = j;
        this.k = k;
        this.ijkNormalize();
    }

    public void downAp3() {
        int i = this.i * 2 + this.j * 1 + this.k * 0;
        int j = this.i * 0 + this.j * 2 + this.k * 1;
        int k = this.i * 1 + this.j * 0 + this.k * 2;
        this.i = i;
        this.j = j;
        this.k = k;
        this.ijkNormalize();
    }

    public void downAp3r() {
        int i = this.i * 2 + this.j * 0 + this.k * 1;
        int j = this.i * 1 + this.j * 2 + this.k * 0;
        int k = this.i * 0 + this.j * 1 + this.k * 2;
        this.i = i;
        this.j = j;
        this.k = k;
        this.ijkNormalize();
    }

    public void ijkRotate60cw() {
        int i = this.i * 1 + this.j * 1 + this.k * 0;
        int j = this.i * 0 + this.j * 1 + this.k * 1;
        int k = this.i * 1 + this.j * 0 + this.k * 1;
        this.i = i;
        this.j = j;
        this.k = k;
        this.ijkNormalize();
    }

    public void ijkRotate60ccw() {
        int i = this.i * 1 + this.j * 0 + this.k * 1;
        int j = this.i * 1 + this.j * 1 + this.k * 0;
        int k = this.i * 0 + this.j * 1 + this.k * 1;
        this.i = i;
        this.j = j;
        this.k = k;
        this.ijkNormalize();
    }

    public void neighbor(int digit) {
        if (digit > Direction.CENTER_DIGIT.digit() && digit < Direction.NUM_DIGITS.digit()) {
            this.ijkAdd(UNIT_VECS[digit][0], UNIT_VECS[digit][1], UNIT_VECS[digit][2]);
            this.ijkNormalize();
        }
    }

    public void upAp7r() {
        this.i -= this.k;
        this.j -= this.k;
        int i = (int)Math.round((double)(2 * this.i + this.j) / 7.0);
        int j = (int)Math.round((double)(3 * this.j - this.i) / 7.0);
        this.i = i;
        this.j = j;
        this.k = 0;
        this.ijkNormalize();
    }

    public void upAp7() {
        this.i -= this.k;
        this.j -= this.k;
        int i = (int)Math.round((double)(3 * this.i - this.j) / 7.0);
        int j = (int)Math.round((double)(this.i + 2 * this.j) / 7.0);
        this.i = i;
        this.j = j;
        this.k = 0;
        this.ijkNormalize();
    }

    public int unitIjkToDigit() {
        this.ijkNormalize();
        int digit = Direction.INVALID_DIGIT.digit();
        for (int i = Direction.CENTER_DIGIT.digit(); i < Direction.NUM_DIGITS.digit(); ++i) {
            if (!this.ijkMatches(UNIT_VECS[i])) continue;
            digit = i;
            break;
        }
        return digit;
    }

    private boolean ijkMatches(int[] c) {
        return this.i == c[0] && this.j == c[1] && this.k == c[2];
    }

    public static int rotate60cw(int digit) {
        switch (digit) {
            case 1: {
                return Direction.JK_AXES_DIGIT.digit();
            }
            case 3: {
                return Direction.J_AXES_DIGIT.digit();
            }
            case 2: {
                return Direction.IJ_AXES_DIGIT.digit();
            }
            case 6: {
                return Direction.I_AXES_DIGIT.digit();
            }
            case 4: {
                return Direction.IK_AXES_DIGIT.digit();
            }
            case 5: {
                return Direction.K_AXES_DIGIT.digit();
            }
        }
        return digit;
    }

    public static int rotate60ccw(int digit) {
        switch (digit) {
            case 1: {
                return Direction.IK_AXES_DIGIT.digit();
            }
            case 5: {
                return Direction.I_AXES_DIGIT.digit();
            }
            case 4: {
                return Direction.IJ_AXES_DIGIT.digit();
            }
            case 6: {
                return Direction.J_AXES_DIGIT.digit();
            }
            case 2: {
                return Direction.JK_AXES_DIGIT.digit();
            }
            case 3: {
                return Direction.K_AXES_DIGIT.digit();
            }
        }
        return digit;
    }

    public static enum Direction {
        CENTER_DIGIT(0),
        K_AXES_DIGIT(1),
        J_AXES_DIGIT(2),
        JK_AXES_DIGIT(J_AXES_DIGIT.digit() | K_AXES_DIGIT.digit()),
        I_AXES_DIGIT(4),
        IK_AXES_DIGIT(I_AXES_DIGIT.digit() | K_AXES_DIGIT.digit()),
        IJ_AXES_DIGIT(I_AXES_DIGIT.digit() | J_AXES_DIGIT.digit()),
        INVALID_DIGIT(7),
        NUM_DIGITS(INVALID_DIGIT.digit()),
        PENTAGON_SKIPPED_DIGIT(K_AXES_DIGIT.digit());

        private final int digit;

        private Direction(int digit) {
            this.digit = digit;
        }

        public int digit() {
            return this.digit;
        }
    }
}

