/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.geospatial.geojson.FeatureCollection;

public final class GeospatialParser {
    public static Map<String, Object> toStringObjectMap(Object input) {
        if (!(input instanceof Map)) {
            throw new IllegalArgumentException(String.valueOf(input) + " is not an instance of Map, but of type [ " + input.getClass().getName() + " ]");
        }
        Map inputMap = (Map)input;
        HashMap stringObjectMap = new HashMap();
        for (Map.Entry entry : inputMap.entrySet()) {
            stringObjectMap.put(entry.getKey().toString(), entry.getValue());
        }
        return Collections.unmodifiableMap(stringObjectMap);
    }

    public static String extractValueAsString(Map<String, Object> input, String key) {
        Objects.requireNonNull(key, "parameter 'key' cannot be null");
        Objects.requireNonNull(input, "parameter 'input' cannot be null");
        Object value = input.get(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException(String.valueOf(value) + " is not an instance of String, but of type [ " + value.getClass().getName() + " ]");
        }
        return value.toString();
    }

    public static Map<String, Object> convertToMap(BytesReference content) {
        Objects.requireNonNull(content);
        return Collections.unmodifiableMap((Map)XContentHelper.convertToMap((BytesReference)content, (boolean)false, (XContentType)XContentType.JSON).v2());
    }

    public static List<Map<String, Object>> getFeatures(Map<String, Object> geoJSON) {
        String type = GeospatialParser.extractValueAsString(geoJSON, "type");
        Objects.requireNonNull(type, "type cannot be null");
        if ("Feature".equalsIgnoreCase(type)) {
            return List.of(geoJSON);
        }
        if ("FeatureCollection".equalsIgnoreCase(type)) {
            return Collections.unmodifiableList(FeatureCollection.create(geoJSON).getFeatures());
        }
        return List.of();
    }
}

