/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.interceptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.BoostingQueryBuilder;
import org.opensearch.index.query.ConstantScoreQueryBuilder;
import org.opensearch.index.query.DisMaxQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.MatchPhraseQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.search.MatchQuery;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupFieldMapping;
import org.opensearch.indexmanagement.rollup.query.QueryStringQueryUtil;
import org.opensearch.indexmanagement.rollup.settings.RollupSettings;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MinAggregationBuilder;
import org.opensearch.search.aggregations.metrics.SumAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJH\u0010\u0016\u001a&\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001a0\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u001fH\u0002J.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0$H\u0002J\u001e\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0019H\u0002J2\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010\u001c2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0$H\u0002J>\u00101\u001a\b\u0012\u0004\u0012\u0002H302\"\b\b\u0000\u00103*\u0002042\u0006\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\u00112\f\u00108\u001a\b\u0012\u0004\u0012\u0002H302H\u0016J\u0016\u00109\u001a\u00020\u00192\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00190\u001aH\u0002J*\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0018\u0010?\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0018H\u0002J;\u0010@\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00182\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001c0B2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002\u00a2\u0006\u0002\u0010CR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0018\u0010\u0013\u001a\n \u000f*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006D"}, d2={"Lorg/opensearch/indexmanagement/rollup/interceptor/RollupInterceptor;", "Lorg/opensearch/transport/TransportInterceptor;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "(Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;)V", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getIndexNameExpressionResolver", "()Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "searchAllJobs", "", "Ljava/lang/Boolean;", "searchEnabled", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "findMatchingRollupJobs", "Lkotlin/Pair;", "", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "", "Lorg/opensearch/indexmanagement/rollup/model/RollupFieldMapping;", "", "fieldMappings", "rollupJobs", "", "getAggregationMetadata", "aggregationBuilders", "", "Lorg/opensearch/search/aggregations/AggregationBuilder;", "", "getConcreteSourceIndex", "sourceIndex", "resolver", "clusterState", "Lorg/opensearch/cluster/ClusterState;", "getEstimateRollupInterval", "", "rollup", "getQueryMetadata", "query", "Lorg/opensearch/index/query/QueryBuilder;", "concreteSourceIndexName", "interceptHandler", "Lorg/opensearch/transport/TransportRequestHandler;", "T", "Lorg/opensearch/transport/TransportRequest;", "action", "executor", "forceExecution", "actualHandler", "pickRollupJob", "rollups", "rewriteShardSearchForRollupJobs", "", "request", "Lorg/opensearch/search/internal/ShardSearchRequest;", "matchingRollupJobs", "validateIndicies", "concreteIndices", "", "([Ljava/lang/String;Ljava/util/Set;)Ljava/util/Map;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRollupInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupInterceptor.kt\norg/opensearch/indexmanagement/rollup/interceptor/RollupInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,346:1\n1855#2,2:347\n1855#2,2:349\n1855#2,2:351\n1855#2,2:353\n1855#2,2:355\n1855#2,2:357\n1549#2:359\n1620#2,3:360\n1855#2,2:363\n1549#2:368\n1620#2,3:369\n1855#2,2:376\n1549#2:378\n1620#2,3:379\n1855#2,2:382\n1045#2:384\n2661#2,7:385\n1208#2,2:392\n1238#2,4:394\n483#3,3:365\n486#3,4:372\n*S KotlinDebug\n*F\n+ 1 RollupInterceptor.kt\norg/opensearch/indexmanagement/rollup/interceptor/RollupInterceptor\n*L\n160#1:347,2\n218#1:349,2\n219#1:351,2\n220#1:353,2\n221#1:355,2\n231#1:357,2\n270#1:359\n270#1:360,3\n277#1:363,2\n286#1:368\n286#1:369,3\n293#1:376,2\n296#1:378\n296#1:379,3\n299#1:382,2\n317#1:384\n320#1:385,7\n337#1:392,2\n337#1:394,4\n285#1:365,3\n285#1:372,4\n*E\n"})
public final class RollupInterceptor
implements TransportInterceptor {
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Logger logger;
    private volatile Boolean searchEnabled;
    private volatile Boolean searchAllJobs;

    public RollupInterceptor(@NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull IndexNameExpressionResolver indexNameExpressionResolver) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        this.clusterService = clusterService;
        this.settings = settings;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.logger = LogManager.getLogger(this.getClass());
        this.searchEnabled = (Boolean)RollupSettings.Companion.getROLLUP_SEARCH_ENABLED().get(this.settings);
        this.searchAllJobs = (Boolean)RollupSettings.Companion.getROLLUP_SEARCH_ALL_JOBS().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.Companion.getROLLUP_SEARCH_ENABLED(), arg_0 -> RollupInterceptor._init_$lambda$0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.Companion.getROLLUP_SEARCH_ALL_JOBS(), arg_0 -> RollupInterceptor._init_$lambda$1(this, arg_0));
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final IndexNameExpressionResolver getIndexNameExpressionResolver() {
        return this.indexNameExpressionResolver;
    }

    @NotNull
    public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(@NotNull String action, @NotNull String executor, boolean forceExecution, @NotNull TransportRequestHandler<T> actualHandler) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(actualHandler, (String)"actualHandler");
        return new TransportRequestHandler<T>(this, actualHandler){
            final /* synthetic */ RollupInterceptor this$0;
            final /* synthetic */ TransportRequestHandler<T> $actualHandler;
            {
                this.this$0 = $receiver;
                this.$actualHandler = $actualHandler;
            }

            /*
             * WARNING - void declaration
             */
            public void messageReceived(@NotNull T request, @NotNull TransportChannel channel, @NotNull Task task) {
                Intrinsics.checkNotNullParameter(request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                Boolean bl = RollupInterceptor.access$getSearchEnabled$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"searchEnabled");
                if (bl.booleanValue() && request instanceof ShardSearchRequest) {
                    String index2 = ((ShardSearchRequest)request).shardId().getIndexName();
                    Intrinsics.checkNotNullExpressionValue((Object)index2, (String)"index");
                    ClusterState clusterState = this.this$0.getClusterService().state();
                    Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterService.state()");
                    boolean isRollupIndex = RollupUtilsKt.isRollupIndex(index2, clusterState);
                    if (isRollupIndex) {
                        void $this$toTypedArray$iv;
                        void $this$mapTo$iv$iv;
                        if (((ShardSearchRequest)request).source().size() != 0) {
                            throw new IllegalArgumentException("Rollup search must have size explicitly set to 0, but found " + ((ShardSearchRequest)request).source().size());
                        }
                        String[] stringArray = ((ShardSearchRequest)request).indices();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"request.indices()");
                        Object $this$map$iv = stringArray;
                        boolean $i$f$map = false;
                        Object[] objectArray = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(((Object[])$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        for (void item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(it.toString());
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        String[] indices = thisCollection$iv.toArray(new String[0]);
                        String[] concreteIndices = this.this$0.getIndexNameExpressionResolver().concreteIndexNames(this.this$0.getClusterService().state(), ((ShardSearchRequest)request).indicesOptions(), Arrays.copyOf(indices, indices.length));
                        IndexMetadata indexMetadata2 = this.this$0.getClusterService().state().getMetadata().index(index2);
                        Intrinsics.checkNotNullExpressionValue((Object)indexMetadata2, (String)"clusterService.state().metadata.index(index)");
                        List<Rollup> list = RollupUtilsKt.getRollupJobs(indexMetadata2);
                        if (list == null || (list = list.get(0)) == null) {
                            throw new IllegalArgumentException("No rollup job associated with target_index");
                        }
                        List<Rollup> rollupJob = list;
                        QueryBuilder queryBuilder = ((ShardSearchRequest)request).source().query();
                        String string = ((Rollup)((Object)rollupJob)).getSourceIndex();
                        IndexNameExpressionResolver indexNameExpressionResolver = this.this$0.getIndexNameExpressionResolver();
                        ClusterState clusterState2 = this.this$0.getClusterService().state();
                        Intrinsics.checkNotNullExpressionValue((Object)clusterState2, (String)"clusterService.state()");
                        Set queryFieldMappings = RollupInterceptor.getQueryMetadata$default(this.this$0, queryBuilder, this.this$0.getConcreteSourceIndex(string, indexNameExpressionResolver, clusterState2), null, 4, null);
                        AggregatorFactories.Builder builder = ((ShardSearchRequest)request).source().aggregations();
                        Set aggregationFieldMappings = RollupInterceptor.getAggregationMetadata$default(this.this$0, builder != null ? builder.getAggregatorFactories() : null, null, 2, null);
                        Set fieldMappings = SetsKt.plus((Set)queryFieldMappings, (Iterable)aggregationFieldMappings);
                        Intrinsics.checkNotNullExpressionValue((Object)concreteIndices, (String)"concreteIndices");
                        Map allMatchingRollupJobs = RollupInterceptor.access$validateIndicies(this.this$0, concreteIndices, fieldMappings);
                        if (!((Collection)fieldMappings).isEmpty()) {
                            RollupInterceptor.access$rewriteShardSearchForRollupJobs(this.this$0, (ShardSearchRequest)request, allMatchingRollupJobs);
                        }
                    }
                }
                this.$actualHandler.messageReceived(request, channel, task);
            }
        };
    }

    @NotNull
    public final String getConcreteSourceIndex(@NotNull String sourceIndex, @NotNull IndexNameExpressionResolver resolver, @NotNull ClusterState clusterState) {
        Intrinsics.checkNotNullParameter((Object)sourceIndex, (String)"sourceIndex");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
        String[] stringArray = new String[]{sourceIndex};
        String[] concreteIndexNames = resolver.concreteIndexNames(clusterState, IndicesOptions.LENIENT_EXPAND_OPEN, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)concreteIndexNames, (String)"concreteIndexNames");
        if (concreteIndexNames.length == 0) {
            this.logger.warn("Cannot resolve rollup sourceIndex [" + sourceIndex + "]");
            return "";
        }
        String concreteIndexName = "";
        if (concreteIndexNames.length == 1 && IndexUtils.Companion.isConcreteIndex(concreteIndexNames[0], clusterState)) {
            String string = concreteIndexNames[0];
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"concreteIndexNames[0]");
            concreteIndexName = string;
        } else if (concreteIndexNames.length > 1) {
            concreteIndexName = IndexUtils.Companion.getNewestIndexByCreationDate(concreteIndexNames, clusterState);
        } else if (IndexUtils.Companion.isAlias(sourceIndex, clusterState) || IndexUtils.Companion.isDataStream(sourceIndex, clusterState)) {
            String string = IndexUtils.Companion.getWriteIndex(sourceIndex, clusterState);
            if (string == null) {
                string = IndexUtils.Companion.getNewestIndexByCreationDate(concreteIndexNames, clusterState);
            }
            concreteIndexName = string;
        }
        return concreteIndexName;
    }

    private final Map<Rollup, Set<RollupFieldMapping>> validateIndicies(String[] concreteIndices, Set<RollupFieldMapping> fieldMappings) {
        Map allMatchingRollupJobs = MapsKt.emptyMap();
        for (String concreteIndex : concreteIndices) {
            List<Rollup> rollupJobs;
            IndexMetadata indexMetadata2 = this.clusterService.state().getMetadata().index(concreteIndex);
            Intrinsics.checkNotNullExpressionValue((Object)indexMetadata2, (String)"clusterService.state().m\u2026data.index(concreteIndex)");
            if (RollupUtilsKt.getRollupJobs(indexMetadata2) == null) {
                throw new IllegalArgumentException("Not all indices have rollup job");
            }
            Pair<Map<Rollup, Set<RollupFieldMapping>>, Set<String>> pair = this.findMatchingRollupJobs(fieldMappings, rollupJobs);
            Map matchingRollupJobs = (Map)pair.component1();
            Set issues = (Set)pair.component2();
            if (!((Collection)issues).isEmpty() || matchingRollupJobs.isEmpty()) {
                throw new IllegalArgumentException("Could not find a rollup job that can answer this query because " + issues);
            }
            allMatchingRollupJobs = MapsKt.plus((Map)allMatchingRollupJobs, (Map)matchingRollupJobs);
        }
        return allMatchingRollupJobs;
    }

    private final Set<RollupFieldMapping> getAggregationMetadata(Collection<? extends AggregationBuilder> aggregationBuilders, Set<RollupFieldMapping> fieldMappings) {
        block19: {
            Collection<? extends AggregationBuilder> collection = aggregationBuilders;
            if (collection == null) break block19;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                AggregationBuilder it = (AggregationBuilder)element$iv;
                boolean bl2 = false;
                Object object = it;
                if (object instanceof TermsAggregationBuilder) {
                    String string = ((TermsAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string2 = ((TermsAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, string2, null, 8, null));
                } else if (object instanceof DateHistogramAggregationBuilder) {
                    String string = ((DateHistogramAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string3 = ((DateHistogramAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, string3, null, 8, null));
                } else if (object instanceof HistogramAggregationBuilder) {
                    String string = ((HistogramAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string4 = ((HistogramAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, string4, null, 8, null));
                } else if (object instanceof SumAggregationBuilder) {
                    String string = ((SumAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string5 = ((SumAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string, string5, null, 8, null));
                } else if (object instanceof AvgAggregationBuilder) {
                    String string = ((AvgAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string6 = ((AvgAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string, string6, null, 8, null));
                } else if (object instanceof MaxAggregationBuilder) {
                    String string = ((MaxAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string7 = ((MaxAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string, string7, null, 8, null));
                } else if (object instanceof MinAggregationBuilder) {
                    String string = ((MinAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string8 = ((MinAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string, string8, null, 8, null));
                } else if (object instanceof ValueCountAggregationBuilder) {
                    String string = ((ValueCountAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string9 = ((ValueCountAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string, string9, null, 8, null));
                } else {
                    throw new IllegalArgumentException("The " + it.getType() + " aggregation is not currently supported in rollups");
                }
                Object object2 = object = it.getSubAggregations();
                if (object2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"subAggregations");
                    bl = !object.isEmpty();
                } else {
                    bl = false;
                }
                if (!bl) continue;
                this.getAggregationMetadata(it.getSubAggregations(), fieldMappings);
            }
        }
        return fieldMappings;
    }

    static /* synthetic */ Set getAggregationMetadata$default(RollupInterceptor rollupInterceptor, Collection collection, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return rollupInterceptor.getAggregationMetadata(collection, set);
    }

    private final Set<RollupFieldMapping> getQueryMetadata(QueryBuilder query, String concreteSourceIndexName, Set<RollupFieldMapping> fieldMappings) {
        if (query == null) {
            return fieldMappings;
        }
        QueryBuilder queryBuilder = query;
        if (queryBuilder instanceof TermQueryBuilder) {
            String string = ((TermQueryBuilder)query).fieldName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"query.fieldName()");
            fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, Dimension.Type.TERMS.getType(), null, 8, null));
        } else if (queryBuilder instanceof TermsQueryBuilder) {
            String string = ((TermsQueryBuilder)query).fieldName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"query.fieldName()");
            fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, Dimension.Type.TERMS.getType(), null, 8, null));
        } else if (queryBuilder instanceof RangeQueryBuilder) {
            String string = ((RangeQueryBuilder)query).fieldName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"query.fieldName()");
            fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, "unknown", null, 8, null));
        } else if (!(queryBuilder instanceof MatchAllQueryBuilder)) {
            if (queryBuilder instanceof BoolQueryBuilder) {
                QueryBuilder it;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                List list = ((BoolQueryBuilder)query).must();
                if (list != null) {
                    $this$forEach$iv = list;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (QueryBuilder)element$iv;
                        boolean bl = false;
                        this.getQueryMetadata(it, concreteSourceIndexName, fieldMappings);
                    }
                }
                List list2 = ((BoolQueryBuilder)query).mustNot();
                if (list2 != null) {
                    $this$forEach$iv = list2;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (QueryBuilder)element$iv;
                        boolean bl = false;
                        this.getQueryMetadata(it, concreteSourceIndexName, fieldMappings);
                    }
                }
                List list3 = ((BoolQueryBuilder)query).should();
                if (list3 != null) {
                    $this$forEach$iv = list3;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (QueryBuilder)element$iv;
                        boolean bl = false;
                        this.getQueryMetadata(it, concreteSourceIndexName, fieldMappings);
                    }
                }
                List list4 = ((BoolQueryBuilder)query).filter();
                if (list4 != null) {
                    $this$forEach$iv = list4;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (QueryBuilder)element$iv;
                        boolean bl = false;
                        this.getQueryMetadata(it, concreteSourceIndexName, fieldMappings);
                    }
                }
            } else if (queryBuilder instanceof BoostingQueryBuilder) {
                this.getQueryMetadata(((BoostingQueryBuilder)query).positiveQuery(), concreteSourceIndexName, fieldMappings);
                this.getQueryMetadata(((BoostingQueryBuilder)query).negativeQuery(), concreteSourceIndexName, fieldMappings);
            } else if (queryBuilder instanceof ConstantScoreQueryBuilder) {
                this.getQueryMetadata(((ConstantScoreQueryBuilder)query).innerQuery(), concreteSourceIndexName, fieldMappings);
            } else if (queryBuilder instanceof DisMaxQueryBuilder) {
                List list = ((DisMaxQueryBuilder)query).innerQueries();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"query.innerQueries()");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    QueryBuilder it = (QueryBuilder)element$iv;
                    boolean bl = false;
                    this.getQueryMetadata(it, concreteSourceIndexName, fieldMappings);
                }
            } else if (queryBuilder instanceof MatchPhraseQueryBuilder) {
                CharSequence charSequence = ((MatchPhraseQueryBuilder)query).analyzer();
                if (!(charSequence == null || charSequence.length() == 0) || ((MatchPhraseQueryBuilder)query).slop() != 0 || ((MatchPhraseQueryBuilder)query).zeroTermsQuery() != MatchQuery.DEFAULT_ZERO_TERMS_QUERY) {
                    throw new IllegalArgumentException("The " + ((MatchPhraseQueryBuilder)query).getName() + " query is currently not supported with analyzer/slop/zero_terms_query in rollups");
                }
                String string = ((MatchPhraseQueryBuilder)query).fieldName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"query.fieldName()");
                fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, Dimension.Type.TERMS.getType(), null, 8, null));
            } else if (queryBuilder instanceof QueryStringQueryBuilder) {
                Pair<List<String>, Map<String, Float>> pair = (Pair<List<String>, Map<String, Float>>)concreteSourceIndexName;
                if (pair == null || pair.length() == 0) {
                    throw new IllegalArgumentException("Can't parse query_string query without sourceIndex mappings!");
                }
                pair = QueryStringQueryUtil.INSTANCE.extractFieldsFromQueryString(query, concreteSourceIndexName);
                List queryFields = (List)pair.component1();
                Map otherFields = (Map)pair.component2();
                for (String field : queryFields) {
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, field, Dimension.Type.TERMS.getType(), null, 8, null));
                }
                for (String field : otherFields.keySet()) {
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, field, Dimension.Type.TERMS.getType(), null, 8, null));
                }
            } else {
                throw new IllegalArgumentException("The " + query.getName() + " query is currently not supported in rollups");
            }
        }
        return fieldMappings;
    }

    static /* synthetic */ Set getQueryMetadata$default(RollupInterceptor rollupInterceptor, QueryBuilder queryBuilder, String string, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new LinkedHashSet();
        }
        return rollupInterceptor.getQueryMetadata(queryBuilder, string, set);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final Pair<Map<Rollup, Set<RollupFieldMapping>>, Set<String>> findMatchingRollupJobs(Set<RollupFieldMapping> fieldMappings, List<Rollup> rollupJobs) {
        $this$map$iv = rollupJobs;
        $i$f$map = false;
        var6_6 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var11_18 = (Rollup)item$iv$iv;
            var24_27 = destination$iv$iv;
            $i$a$-map-RollupInterceptor$findMatchingRollupJobs$rollupFieldMappings$1 = false;
            var24_27.add(TuplesKt.to((Object)rollup, RollupUtilsKt.populateFieldMappings((Rollup)rollup)));
        }
        rollupFieldMappings = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        knownFieldMappings = new LinkedHashSet<E>();
        unknownFields = new LinkedHashSet<E>();
        $this$forEach$iv = fieldMappings;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (RollupFieldMapping)element$iv;
            $i$a$-forEach-RollupInterceptor$findMatchingRollupJobs$1 = false;
            if (Intrinsics.areEqual((Object)it.getMappingType(), (Object)"unknown")) {
                unknownFields.add(it.getFieldName());
                continue;
            }
            knownFieldMappings.add(it);
        }
        $this$filterValues$iv = rollupFieldMappings;
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap<K, V>();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            it = (Set)entry$iv.getValue();
            $i$a$-filterValues-RollupInterceptor$findMatchingRollupJobs$potentialRollupFieldMappings$1 = false;
            if (!it.containsAll(knownFieldMappings)) ** GOTO lbl-1000
            $this$map$iv = it;
            $i$f$map = false;
            var16_39 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var21_44 = (RollupFieldMapping)item$iv$iv;
                var22_45 = destination$iv$iv;
                $i$a$-map-RollupInterceptor$findMatchingRollupJobs$potentialRollupFieldMappings$1$1 = false;
                var22_45.add(rollupFieldMapping.getFieldName());
            }
            if (((List)destination$iv$iv).containsAll(unknownFields)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        potentialRollupFieldMappings = result$iv;
        issues = new LinkedHashSet<E>();
        if (potentialRollupFieldMappings.isEmpty()) {
            allFieldMappings = new LinkedHashSet<E>();
            $this$forEach$iv = rollupFieldMappings.values();
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (Set)element$iv;
                $i$a$-forEach-RollupInterceptor$findMatchingRollupJobs$2 = false;
                allFieldMappings.addAll(it);
            }
            $this$map$iv = allFieldMappings;
            $i$f$map = false;
            element$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv = (RollupFieldMapping)item$iv$iv;
                var24_27 = destination$iv$iv;
                $i$a$-map-RollupInterceptor$findMatchingRollupJobs$allFields$1 = false;
                var24_27.add(it.getFieldName());
            }
            allFields = (List)destination$iv$iv;
            $this$forEach$iv = fieldMappings;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (RollupFieldMapping)element$iv;
                $i$a$-forEach-RollupInterceptor$findMatchingRollupJobs$3 = false;
                if (!allFields.contains(it.getFieldName())) {
                    issues.add(it.toIssue(true));
                    continue;
                }
                if (Intrinsics.areEqual((Object)it.getMappingType(), (Object)"unknown") || allFieldMappings.contains(it)) continue;
                issues.add(RollupFieldMapping.toIssue$default(it, false, 1, null));
            }
        }
        return TuplesKt.to((Object)potentialRollupFieldMappings, (Object)issues);
    }

    /*
     * WARNING - void declaration
     */
    private final Rollup pickRollupJob(Set<Rollup> rollups2) {
        if (rollups2.size() == 1) {
            return (Rollup)CollectionsKt.first((Iterable)rollups2);
        }
        Iterable $this$sortedBy$iv = rollups2;
        boolean $i$f$sortedBy = false;
        List sortedRollups = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Rollup it = (Rollup)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getId());
                it = (Rollup)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
            }
        });
        Iterable $this$reduce$iv = sortedRollups;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void new_;
            Rollup rollup2 = (Rollup)iterator$iv.next();
            Rollup matched = (Rollup)accumulator$iv;
            boolean bl = false;
            accumulator$iv = this.getEstimateRollupInterval(matched) > this.getEstimateRollupInterval((Rollup)new_) ? matched : new_;
        }
        return (Rollup)accumulator$iv;
    }

    private final long getEstimateRollupInterval(Rollup rollup2) {
        return RollupUtilsKt.getDateHistogram(rollup2).getCalendarInterval() != null ? new DateHistogramInterval(RollupUtilsKt.getDateHistogram(rollup2).getCalendarInterval()).estimateMillis() : new DateHistogramInterval(RollupUtilsKt.getDateHistogram(rollup2).getFixedInterval()).estimateMillis();
    }

    /*
     * WARNING - void declaration
     */
    private final void rewriteShardSearchForRollupJobs(ShardSearchRequest request, Map<Rollup, ? extends Set<RollupFieldMapping>> matchingRollupJobs) {
        void $this$associateByTo$iv$iv;
        Rollup matchedRollup = this.pickRollupJob(matchingRollupJobs.keySet());
        Iterable $this$associateBy$iv = (Iterable)MapsKt.getValue(matchingRollupJobs, (Object)matchedRollup);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            RollupFieldMapping rollupFieldMapping = (RollupFieldMapping)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            RollupFieldMapping it = (RollupFieldMapping)element$iv$iv;
            String string = it.getFieldName();
            boolean bl2 = false;
            String string2 = it.getMappingType();
            map.put(string, string2);
        }
        Map fieldNameMappingTypeMap = destination$iv$iv;
        String string = matchedRollup.getSourceIndex();
        ClusterState clusterState = this.clusterService.state();
        Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterService.state()");
        String concreteSourceIndex = this.getConcreteSourceIndex(string, this.indexNameExpressionResolver, clusterState);
        Boolean bl = this.searchAllJobs;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"searchAllJobs");
        if (bl.booleanValue()) {
            SearchSourceBuilder searchSourceBuilder = request.source();
            Intrinsics.checkNotNullExpressionValue((Object)searchSourceBuilder, (String)"request.source()");
            request.source(RollupUtilsKt.rewriteSearchSourceBuilder(searchSourceBuilder, matchingRollupJobs.keySet(), (Map<String, String>)fieldNameMappingTypeMap, concreteSourceIndex));
        } else {
            SearchSourceBuilder searchSourceBuilder = request.source();
            Intrinsics.checkNotNullExpressionValue((Object)searchSourceBuilder, (String)"request.source()");
            request.source(RollupUtilsKt.rewriteSearchSourceBuilder(searchSourceBuilder, matchedRollup, (Map<String, String>)fieldNameMappingTypeMap, concreteSourceIndex));
        }
    }

    private static final void _init_$lambda$0(RollupInterceptor this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.searchEnabled = it;
    }

    private static final void _init_$lambda$1(RollupInterceptor this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.searchAllJobs = it;
    }

    public static final /* synthetic */ Boolean access$getSearchEnabled$p(RollupInterceptor $this) {
        return $this.searchEnabled;
    }

    public static final /* synthetic */ Map access$validateIndicies(RollupInterceptor $this, String[] concreteIndices, Set fieldMappings) {
        return $this.validateIndicies(concreteIndices, fieldMappings);
    }

    public static final /* synthetic */ void access$rewriteShardSearchForRollupJobs(RollupInterceptor $this, ShardSearchRequest request, Map matchingRollupJobs) {
        $this.rewriteShardSearchForRollupJobs(request, matchingRollupJobs);
    }
}

