/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import lombok.Generated;
import org.opensearch.knn.plugin.stats.KNNCounter;

public enum VectorQueryType {
    K("k"){

        @Override
        public KNNCounter getQueryStatCounter() {
            return KNNCounter.KNN_QUERY_REQUESTS;
        }

        @Override
        public KNNCounter getQueryWithFilterStatCounter() {
            return KNNCounter.KNN_QUERY_WITH_FILTER_REQUESTS;
        }
    }
    ,
    MIN_SCORE("min_score"){

        @Override
        public KNNCounter getQueryStatCounter() {
            return KNNCounter.MIN_SCORE_QUERY_REQUESTS;
        }

        @Override
        public KNNCounter getQueryWithFilterStatCounter() {
            return KNNCounter.MIN_SCORE_QUERY_WITH_FILTER_REQUESTS;
        }
    }
    ,
    MAX_DISTANCE("max_distance"){

        @Override
        public KNNCounter getQueryStatCounter() {
            return KNNCounter.MAX_DISTANCE_QUERY_REQUESTS;
        }

        @Override
        public KNNCounter getQueryWithFilterStatCounter() {
            return KNNCounter.MAX_DISTANCE_QUERY_WITH_FILTER_REQUESTS;
        }
    };

    private final String queryTypeName;

    private VectorQueryType(String queryTypeName) {
        this.queryTypeName = queryTypeName;
    }

    public abstract KNNCounter getQueryStatCounter();

    public abstract KNNCounter getQueryWithFilterStatCounter();

    public boolean isRadialSearch() {
        return this == MAX_DISTANCE || this == MIN_SCORE;
    }

    @Generated
    public String getQueryTypeName() {
        return this.queryTypeName;
    }
}

