/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN80Codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.codec.util.NativeMemoryCacheKeyHelper;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;

public class KNN80DocValuesProducer
extends DocValuesProducer {
    @Generated
    private static final Logger log = LogManager.getLogger(KNN80DocValuesProducer.class);
    private final DocValuesProducer delegate;
    private List<String> cacheKeys;

    public KNN80DocValuesProducer(DocValuesProducer delegate, SegmentReadState state) {
        this.delegate = delegate;
        this.cacheKeys = KNN80DocValuesProducer.getVectorCacheKeysFromSegmentReaderState(state);
    }

    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        return this.delegate.getBinary(field);
    }

    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        return this.delegate.getNumeric(field);
    }

    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        return this.delegate.getSorted(field);
    }

    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        return this.delegate.getSortedNumeric(field);
    }

    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        return this.delegate.getSortedSet(field);
    }

    public void checkIntegrity() throws IOException {
        this.delegate.checkIntegrity();
    }

    public void close() throws IOException {
        NativeMemoryCacheManager nativeMemoryCacheManager = NativeMemoryCacheManager.getInstance();
        this.cacheKeys.forEach(nativeMemoryCacheManager::invalidate);
        this.delegate.close();
    }

    public final List<String> getCacheKeys() {
        return new ArrayList<String>(this.cacheKeys);
    }

    private static List<String> getVectorCacheKeysFromSegmentReaderState(SegmentReadState segmentReadState) {
        ArrayList<String> cacheKeys = new ArrayList<String>();
        for (FieldInfo field : segmentReadState.fieldInfos) {
            String vectorIndexFileName;
            if (field.getDocValuesType() != DocValuesType.BINARY || field.hasVectorValues() || (vectorIndexFileName = KNNCodecUtil.getNativeEngineFileFromFieldInfo(field, segmentReadState.segmentInfo)) == null) continue;
            String cacheKey = NativeMemoryCacheKeyHelper.constructCacheKey(vectorIndexFileName, segmentReadState.segmentInfo);
            cacheKeys.add(cacheKey);
        }
        return cacheKeys;
    }
}

