/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.internal.shaded.reactor.pool;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.netty.internal.shaded.reactor.pool.AllocationStrategy;

final class AllocationStrategies {
    AllocationStrategies() {
    }

    static final class SizeBasedAllocationStrategy
    implements AllocationStrategy {
        final int min;
        final int max;
        final int warmupParallelism;
        volatile int permits;
        static final AtomicIntegerFieldUpdater<SizeBasedAllocationStrategy> PERMITS = AtomicIntegerFieldUpdater.newUpdater(SizeBasedAllocationStrategy.class, "permits");

        SizeBasedAllocationStrategy(int min, int max) {
            this(min, max, 1);
        }

        SizeBasedAllocationStrategy(int min, int max, int warmupParallelism) {
            if (min < 0) {
                throw new IllegalArgumentException("min must be positive or zero");
            }
            if (max < 1) {
                throw new IllegalArgumentException("max must be strictly positive");
            }
            if (min > max) {
                throw new IllegalArgumentException("min must be less than or equal to max");
            }
            if (min > 0 && warmupParallelism < 1) {
                throw new IllegalArgumentException("warmupParallelism must be greater than 0");
            }
            if (min > 0 && warmupParallelism > min) {
                throw new IllegalArgumentException("warmupParallelism must be less than or equal to min");
            }
            this.min = min;
            this.max = max;
            this.warmupParallelism = warmupParallelism;
            PERMITS.lazySet(this, this.max);
        }

        @Override
        public int getPermits(int desired) {
            int granted;
            int target;
            int p;
            if (desired < 0) {
                return 0;
            }
            do {
                p = this.permits;
                granted = this.max - p;
            } while (!PERMITS.compareAndSet(this, p, p - (target = desired >= p ? p : (granted < this.min ? Math.max(desired, this.min - granted) : desired))));
            return target;
        }

        @Override
        public int estimatePermitCount() {
            return PERMITS.get(this);
        }

        @Override
        public int permitMinimum() {
            return this.min;
        }

        @Override
        public int permitMaximum() {
            return this.max;
        }

        @Override
        public int permitGranted() {
            return this.max - PERMITS.get(this);
        }

        @Override
        public void returnPermits(int returned) {
            int p;
            do {
                if ((p = PERMITS.get(this)) + returned <= this.max) continue;
                throw new IllegalArgumentException("Too many permits returned: returned=" + returned + ", would bring to " + (p + returned) + "/" + this.max);
            } while (!PERMITS.compareAndSet(this, p, p + returned));
        }

        @Override
        public int warmupParallelism() {
            return this.warmupParallelism;
        }
    }

    static final class UnboundedAllocationStrategy
    extends AtomicInteger
    implements AllocationStrategy {
        UnboundedAllocationStrategy() {
        }

        @Override
        public int getPermits(int desired) {
            if (desired <= 0) {
                return 0;
            }
            int overflowCheck = this.addAndGet(desired);
            if (overflowCheck < 0) {
                this.compareAndSet(overflowCheck, Integer.MAX_VALUE);
            }
            return desired;
        }

        @Override
        public int estimatePermitCount() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void returnPermits(int returned) {
            int updated = this.addAndGet(-returned);
            if (updated < 0) {
                this.compareAndSet(updated, 0);
            }
        }

        @Override
        public int permitMinimum() {
            return 0;
        }

        @Override
        public int permitMaximum() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int permitGranted() {
            return this.get();
        }
    }
}

