/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.DtFetcher;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsDtFetcher
implements DtFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsDtFetcher.class);
    private static final String SERVICE_NAME = "hdfs";
    private static final String FETCH_FAILED = "Fetch of delegation token failed";

    public Text getServiceName() {
        return new Text(SERVICE_NAME);
    }

    public boolean isTokenRequired() {
        return UserGroupInformation.isSecurityEnabled();
    }

    public Token<?> addDelegationTokens(Configuration conf, Credentials creds, String renewer, String url) throws Exception {
        FileSystem fs;
        Token token;
        if (!url.startsWith(this.getServiceName().toString())) {
            url = this.getServiceName().toString() + "://" + url;
        }
        if ((token = (fs = FileSystem.get((URI)URI.create(url), (Configuration)conf)).getDelegationToken(renewer)) == null) {
            LOG.error(FETCH_FAILED);
            throw new IOException(FETCH_FAILED);
        }
        creds.addToken(token.getService(), token);
        return token;
    }
}

