/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class SchedulingRequest {
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static SchedulingRequest newInstance(long allocationRequestId, Priority priority, ExecutionTypeRequest executionType, Set<String> allocationTags, ResourceSizing resourceSizing, PlacementConstraint placementConstraintExpression) {
        return SchedulingRequest.newBuilder().allocationRequestId(allocationRequestId).priority(priority).executionType(executionType).allocationTags(allocationTags).resourceSizing(resourceSizing).placementConstraintExpression(placementConstraintExpression).build();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static SchedulingRequestBuilder newBuilder() {
        return new SchedulingRequestBuilder();
    }

    public abstract long getAllocationRequestId();

    public abstract void setAllocationRequestId(long var1);

    public abstract Priority getPriority();

    public abstract void setPriority(Priority var1);

    public abstract ExecutionTypeRequest getExecutionType();

    public abstract void setExecutionType(ExecutionTypeRequest var1);

    public abstract Set<String> getAllocationTags();

    public abstract void setAllocationTags(Set<String> var1);

    public abstract ResourceSizing getResourceSizing();

    public abstract void setResourceSizing(ResourceSizing var1);

    public abstract PlacementConstraint getPlacementConstraint();

    public abstract void setPlacementConstraint(PlacementConstraint var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static final class SchedulingRequestBuilder {
        private SchedulingRequest schedulingRequest = Records.newRecord(SchedulingRequest.class);

        private SchedulingRequestBuilder() {
            this.schedulingRequest.setAllocationRequestId(0L);
            this.schedulingRequest.setPriority(Priority.newInstance(0));
            this.schedulingRequest.setExecutionType(ExecutionTypeRequest.newInstance());
        }

        @InterfaceAudience.Public
        @InterfaceStability.Unstable
        public SchedulingRequestBuilder allocationRequestId(long allocationRequestId) {
            this.schedulingRequest.setAllocationRequestId(allocationRequestId);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Unstable
        public SchedulingRequestBuilder priority(Priority priority) {
            this.schedulingRequest.setPriority(priority);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Unstable
        public SchedulingRequestBuilder executionType(ExecutionTypeRequest executionType) {
            this.schedulingRequest.setExecutionType(executionType);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Unstable
        public SchedulingRequestBuilder allocationTags(Set<String> allocationTags) {
            this.schedulingRequest.setAllocationTags(allocationTags);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Unstable
        public SchedulingRequestBuilder resourceSizing(ResourceSizing resourceSizing) {
            this.schedulingRequest.setResourceSizing(resourceSizing);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Unstable
        public SchedulingRequestBuilder placementConstraintExpression(PlacementConstraint placementConstraintExpression) {
            this.schedulingRequest.setPlacementConstraint(placementConstraintExpression);
            return this;
        }

        @InterfaceAudience.Public
        @InterfaceStability.Unstable
        public SchedulingRequest build() {
            return this.schedulingRequest;
        }
    }
}

