/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.avro.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.avro.file.Codec;
import org.apache.hadoop.shaded.org.apache.avro.file.CodecFactory;
import org.apache.hadoop.shaded.org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.hadoop.shaded.org.apache.commons.compress.utils.IOUtils;

public class XZCodec
extends Codec {
    private ByteArrayOutputStream outputBuffer;
    private int compressionLevel;

    public XZCodec(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    public String getName() {
        return "xz";
    }

    @Override
    public ByteBuffer compress(ByteBuffer data) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(data.remaining());
        XZCompressorOutputStream ios = new XZCompressorOutputStream(baos, this.compressionLevel);
        this.writeAndClose(data, ios);
        return ByteBuffer.wrap(baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer decompress(ByteBuffer data) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(data.remaining());
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(data.array(), data.arrayOffset() + data.position(), data.remaining());
        XZCompressorInputStream ios = new XZCompressorInputStream(bytesIn);
        try {
            IOUtils.copy(ios, (OutputStream)baos);
        }
        finally {
            ((InputStream)ios).close();
        }
        return ByteBuffer.wrap(baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndClose(ByteBuffer data, OutputStream to) throws IOException {
        byte[] input = data.array();
        int offset = data.arrayOffset() + data.position();
        int length = data.remaining();
        try {
            to.write(input, offset, length);
        }
        finally {
            to.close();
        }
    }

    private ByteArrayOutputStream getOutputBuffer(int suggestedLength) {
        if (null == this.outputBuffer) {
            this.outputBuffer = new ByteArrayOutputStream(suggestedLength);
        }
        this.outputBuffer.reset();
        return this.outputBuffer;
    }

    @Override
    public int hashCode() {
        return this.compressionLevel;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XZCodec other = (XZCodec)obj;
        return this.compressionLevel == other.compressionLevel;
    }

    @Override
    public String toString() {
        return this.getName() + "-" + this.compressionLevel;
    }

    static class Option
    extends CodecFactory {
        private int compressionLevel;

        Option(int compressionLevel) {
            this.compressionLevel = compressionLevel;
        }

        @Override
        protected Codec createInstance() {
            return new XZCodec(this.compressionLevel);
        }
    }
}

