/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auth.AuthDomain;
import org.opensearch.security.auth.AuthFailureListener;
import org.opensearch.security.auth.AuthenticationBackend;
import org.opensearch.security.auth.AuthorizationBackend;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.auth.UserInjector;
import org.opensearch.security.auth.UserSubjectImpl;
import org.opensearch.security.auth.blocking.ClientBlockRegistry;
import org.opensearch.security.auth.internal.NoOpAuthenticationBackend;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.filter.SecurityRequestChannel;
import org.opensearch.security.filter.SecurityResponse;
import org.opensearch.security.http.XFFResolver;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.AuthCredentials;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class BackendRegistry {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private SortedSet<AuthDomain> restAuthDomains;
    private Set<AuthorizationBackend> restAuthorizers;
    private List<AuthFailureListener> ipAuthFailureListeners;
    private Multimap<String, AuthFailureListener> authBackendFailureListeners;
    private List<ClientBlockRegistry<InetAddress>> ipClientBlockRegistries;
    private Multimap<String, ClientBlockRegistry<String>> authBackendClientBlockRegistries;
    private String hostResolverMode;
    private volatile boolean initialized;
    private volatile boolean injectedUserEnabled = false;
    private final AdminDNs adminDns;
    private final XFFResolver xffResolver;
    private volatile boolean anonymousAuthEnabled = false;
    private final Settings opensearchSettings;
    private final AuditLog auditLog;
    private final ThreadPool threadPool;
    private final UserInjector userInjector;
    private final int ttlInMin;
    private Cache<AuthCredentials, User> userCache;
    private Cache<String, User> restImpersonationCache;
    private Cache<User, Set<String>> restRoleCache;

    private void createCaches() {
        this.userCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<AuthCredentials, User>(){

            public void onRemoval(RemovalNotification<AuthCredentials, User> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", (Object)((AuthCredentials)notification.getKey()).getUsername(), (Object)notification.getCause());
            }
        }).build();
        this.restImpersonationCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, User>(){

            public void onRemoval(RemovalNotification<String, User> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
        this.restRoleCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<User, Set<String>>(){

            public void onRemoval(RemovalNotification<User, Set<String>> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
    }

    public BackendRegistry(Settings settings, AdminDNs adminDns, XFFResolver xffResolver, AuditLog auditLog, ThreadPool threadPool) {
        this.adminDns = adminDns;
        this.opensearchSettings = settings;
        this.xffResolver = xffResolver;
        this.auditLog = auditLog;
        this.threadPool = threadPool;
        this.userInjector = new UserInjector(settings, threadPool, auditLog, xffResolver);
        this.restAuthDomains = Collections.emptySortedSet();
        this.ipAuthFailureListeners = Collections.emptyList();
        this.ttlInMin = settings.getAsInt("plugins.security.cache.ttl_minutes", Integer.valueOf(60));
        this.initialized = this.injectedUserEnabled = this.opensearchSettings.getAsBoolean("plugins.security.unsupported.inject_user.enabled", Boolean.valueOf(false)).booleanValue();
        this.createCaches();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void invalidateCache() {
        this.userCache.invalidateAll();
        this.restImpersonationCache.invalidateAll();
        this.restRoleCache.invalidateAll();
    }

    @Subscribe
    public void onDynamicConfigModelChanged(DynamicConfigModel dcm) {
        this.invalidateCache();
        this.anonymousAuthEnabled = dcm.isAnonymousAuthenticationEnabled() && this.opensearchSettings.getAsBoolean("plugins.security.compliance.disable_anonymous_authentication", Boolean.valueOf(false)) == false;
        this.restAuthDomains = Collections.unmodifiableSortedSet(dcm.getRestAuthDomains());
        this.restAuthorizers = Collections.unmodifiableSet(dcm.getRestAuthorizers());
        this.ipAuthFailureListeners = dcm.getIpAuthFailureListeners();
        this.authBackendFailureListeners = dcm.getAuthBackendFailureListeners();
        this.ipClientBlockRegistries = dcm.getIpClientBlockRegistries();
        this.authBackendClientBlockRegistries = dcm.getAuthBackendClientBlockRegistries();
        this.hostResolverMode = dcm.getHostsResolverMode();
        this.initialized = !this.restAuthDomains.isEmpty() || this.anonymousAuthEnabled || this.injectedUserEnabled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean authenticate(SecurityRequestChannel request) {
        boolean isDebugEnabled = this.log.isDebugEnabled();
        boolean isBlockedBasedOnAddress = request.getRemoteAddress().map(InetSocketAddress::getAddress).map(this::isBlocked).orElse(false);
        if (isBlockedBasedOnAddress) {
            if (isDebugEnabled) {
                InetSocketAddress ipAddress = request.getRemoteAddress().orElse(null);
                this.log.debug("Rejecting REST request because of blocked address: {}", ipAddress != null ? "/" + ipAddress.getAddress().getHostAddress() : null);
            }
            request.queueForSending(new SecurityResponse(401, "Authentication finally failed"));
            return false;
        }
        org.opensearch.common.util.concurrent.ThreadContext threadContext = this.threadPool.getThreadContext();
        String sslPrincipal = (String)threadContext.getTransient("_opendistro_security_ssl_principal");
        if (this.adminDns.isAdminDN(sslPrincipal)) {
            User superuser = new User(sslPrincipal);
            UserSubjectImpl subject = new UserSubjectImpl(this.threadPool, superuser);
            threadContext.putPersistent("_opendistro_security_authenticated_user", (Object)subject);
            threadContext.putTransient("_opendistro_security_user", (Object)superuser);
            this.auditLog.logSucceededLogin(sslPrincipal, true, null, request);
            return true;
        }
        if (this.userInjector.injectUser(request)) {
            return true;
        }
        if (!this.isInitialized()) {
            this.log.error("Not yet initialized (you may need to run securityadmin)");
            request.queueForSending(new SecurityResponse(503, "OpenSearch Security not initialized."));
            return false;
        }
        TransportAddress remoteAddress = this.xffResolver.resolve(request);
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (isTraceEnabled) {
            this.log.trace("Rest authentication request from {} [original: {}]", (Object)remoteAddress, request.getRemoteAddress().orElse(null));
        }
        this.threadPool.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)remoteAddress);
        boolean authenticated = false;
        User authenticatedUser = null;
        AuthCredentials authCredentials = null;
        HTTPAuthenticator firstChallengingHttpAuthenticator = null;
        for (AuthDomain authDomain : this.restAuthDomains) {
            AuthCredentials ac;
            block31: {
                Optional<SecurityResponse> restResponse;
                if (isDebugEnabled) {
                    this.log.debug("Check authdomain for rest {}/{} or {} in total", (Object)authDomain.getBackend().getType(), (Object)authDomain.getOrder(), (Object)this.restAuthDomains.size());
                }
                HTTPAuthenticator httpAuthenticator = authDomain.getHttpAuthenticator();
                if (authDomain.isChallenge() && firstChallengingHttpAuthenticator == null) {
                    firstChallengingHttpAuthenticator = httpAuthenticator;
                }
                if (isTraceEnabled) {
                    this.log.trace("Try to extract auth creds from {} http authenticator", (Object)httpAuthenticator.getType());
                }
                try {
                    ac = httpAuthenticator.extractCredentials(request, this.threadPool.getThreadContext());
                }
                catch (Exception e1) {
                    if (!isDebugEnabled) continue;
                    this.log.debug("'{}' extracting credentials from {} http authenticator", (Object)e1.toString(), (Object)httpAuthenticator.getType(), (Object)e1);
                    continue;
                }
                if (ac != null && this.isBlocked(authDomain.getBackend().getClass().getName(), ac.getUsername())) {
                    if (!isDebugEnabled) continue;
                    this.log.debug("Rejecting REST request because of blocked user: {}, authDomain: {}", (Object)ac.getUsername(), (Object)authDomain);
                    continue;
                }
                authCredentials = ac;
                if (ac == null) {
                    if (this.anonymousAuthEnabled && this.isRequestForAnonymousLogin(request.params(), request.getHeaders())) continue;
                    if (authDomain.isChallenge()) {
                        restResponse = httpAuthenticator.reRequestAuthentication(request, null);
                        if (restResponse.isPresent()) {
                            if (!authDomain.getHttpAuthenticator().getType().equals("saml")) {
                                this.auditLog.logFailedLogin("<NONE>", false, null, request);
                            }
                            if (isTraceEnabled) {
                                this.log.trace("No 'Authorization' header, send 401 and 'WWW-Authenticate Basic'");
                            }
                            this.notifyIpAuthFailureListeners(request, authCredentials);
                            request.queueForSending(restResponse.get());
                            return false;
                        }
                        break block31;
                    } else {
                        if (!isTraceEnabled) continue;
                        this.log.trace("No 'Authorization' header, send 403");
                        continue;
                    }
                }
                ThreadContext.put((String)"user", (String)ac.getUsername());
                if (!ac.isComplete()) {
                    restResponse = httpAuthenticator.reRequestAuthentication(request, ac);
                    if (!restResponse.isPresent()) continue;
                    this.notifyIpAuthFailureListeners(request, ac);
                    request.queueForSending(restResponse.get());
                    return false;
                }
            }
            if ((authenticatedUser = this.authcz(this.userCache, this.restRoleCache, ac, authDomain.getBackend(), this.restAuthorizers)) == null) {
                if (isDebugEnabled) {
                    this.log.debug("Cannot authenticate rest user {} (or add roles) with authdomain {}/{} of {}, try next", (Object)ac.getUsername(), (Object)authDomain.getBackend().getType(), (Object)authDomain.getOrder(), this.restAuthDomains);
                }
                for (AuthFailureListener authFailureListener : this.authBackendFailureListeners.get((Object)authDomain.getBackend().getClass().getName())) {
                    authFailureListener.onAuthFailure(request.getRemoteAddress().map(InetSocketAddress::getAddress).orElse(null), ac, request);
                }
                continue;
            }
            if (this.adminDns.isAdmin(authenticatedUser)) {
                this.log.error("Cannot authenticate rest user because admin user is not permitted to login via HTTP");
                this.auditLog.logFailedLogin(authenticatedUser.getName(), true, null, request);
                request.queueForSending(new SecurityResponse(403, "Cannot authenticate user because admin user is not permitted to login via HTTP"));
                return false;
            }
            String tenant = this.resolveTenantFrom(request);
            if (isDebugEnabled) {
                this.log.debug("Rest user '{}' is authenticated", (Object)authenticatedUser);
                this.log.debug("securitytenant '{}'", (Object)tenant);
            }
            authenticatedUser.setRequestedTenant(tenant);
            authenticated = true;
            break;
        }
        if (authenticated) {
            User impersonatedUser = this.impersonate(request, authenticatedUser);
            User effectiveUser = impersonatedUser == null ? authenticatedUser : impersonatedUser;
            this.threadPool.getThreadContext().putTransient("_opendistro_security_user", (Object)effectiveUser);
            UserSubjectImpl subject = new UserSubjectImpl(this.threadPool, effectiveUser);
            this.threadPool.getThreadContext().putPersistent("_opendistro_security_authenticated_user", (Object)subject);
            this.auditLog.logSucceededLogin(effectiveUser.getName(), false, authenticatedUser.getName(), request);
            return authenticated;
        }
        if (isDebugEnabled) {
            this.log.debug("User still not authenticated after checking {} auth domains", (Object)this.restAuthDomains.size());
        }
        Optional<Object> challengeResponse = Optional.empty();
        if (firstChallengingHttpAuthenticator != null) {
            if (isDebugEnabled) {
                this.log.debug("Rerequest with {}", firstChallengingHttpAuthenticator.getClass());
            }
            if ((challengeResponse = firstChallengingHttpAuthenticator.reRequestAuthentication(request, null)).isPresent() && isDebugEnabled) {
                this.log.debug("Rerequest {} failed", firstChallengingHttpAuthenticator.getClass());
            }
        }
        if (authCredentials == null && this.anonymousAuthEnabled && this.isRequestForAnonymousLogin(request.params(), request.getHeaders())) {
            String tenant = this.resolveTenantFrom(request);
            User anonymousUser = new User(User.ANONYMOUS.getName(), new HashSet<String>(User.ANONYMOUS.getRoles()), null);
            anonymousUser.setRequestedTenant(tenant);
            UserSubjectImpl subject = new UserSubjectImpl(this.threadPool, anonymousUser);
            this.threadPool.getThreadContext().putTransient("_opendistro_security_user", (Object)anonymousUser);
            this.threadPool.getThreadContext().putPersistent("_opendistro_security_authenticated_user", (Object)subject);
            this.auditLog.logSucceededLogin(anonymousUser.getName(), false, null, request);
            if (!isDebugEnabled) return true;
            this.log.debug("Anonymous User is authenticated");
            return true;
        }
        this.log.warn("Authentication finally failed for {} from {}", (Object)(authCredentials == null ? null : authCredentials.getUsername()), (Object)remoteAddress);
        this.auditLog.logFailedLogin(authCredentials == null ? null : authCredentials.getUsername(), false, null, request);
        this.notifyIpAuthFailureListeners(request, authCredentials);
        request.queueForSending(challengeResponse.orElseGet(() -> new SecurityResponse(401, "Authentication finally failed")));
        return false;
    }

    private boolean isRequestForAnonymousLogin(Map<String, String> params, Map<String, List<String>> headers) {
        if (params.containsKey("auth_type")) {
            return params.get("auth_type").equals("anonymous");
        }
        return !headers.containsKey("Authorization");
    }

    private String resolveTenantFrom(SecurityRequest request) {
        return Optional.ofNullable(request.header("securitytenant")).orElse(request.header("security_tenant"));
    }

    private void notifyIpAuthFailureListeners(SecurityRequestChannel request, AuthCredentials authCredentials) {
        this.notifyIpAuthFailureListeners(request.getRemoteAddress().map(InetSocketAddress::getAddress).orElse(null), authCredentials, request);
    }

    private void notifyIpAuthFailureListeners(InetAddress remoteAddress, AuthCredentials authCredentials, Object request) {
        for (AuthFailureListener authFailureListener : this.ipAuthFailureListeners) {
            authFailureListener.onAuthFailure(remoteAddress, authCredentials, request);
        }
    }

    private User checkExistsAndAuthz(Cache<String, User> cache, final User user, final AuthenticationBackend authenticationBackend, final Set<AuthorizationBackend> authorizers) {
        if (user == null) {
            return null;
        }
        final boolean isDebugEnabled = this.log.isDebugEnabled();
        final boolean isTraceEnabled = this.log.isTraceEnabled();
        try {
            return (User)cache.get((Object)user.getName(), (Callable)new Callable<User>(){

                @Override
                public User call() throws Exception {
                    if (isTraceEnabled) {
                        BackendRegistry.this.log.trace("Credentials for user {} not cached, return from {} backend directly", (Object)user.getName(), (Object)authenticationBackend.getType());
                    }
                    if (authenticationBackend.exists(user)) {
                        BackendRegistry.this.authz(user, null, authorizers);
                        return user;
                    }
                    if (isDebugEnabled) {
                        BackendRegistry.this.log.debug("User {} does not exist in {}", (Object)user.getName(), (Object)authenticationBackend.getType());
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                this.log.debug("Can not check and authorize {} due to ", (Object)user.getName(), (Object)e);
            }
            return null;
        }
    }

    private void authz(User authenticatedUser, Cache<User, Set<String>> roleCache, Set<AuthorizationBackend> authorizers) {
        Set cachedBackendRoles;
        if (authenticatedUser == null) {
            return;
        }
        if (roleCache != null && (cachedBackendRoles = (Set)roleCache.getIfPresent((Object)authenticatedUser)) != null) {
            authenticatedUser.addRoles(new HashSet<String>(cachedBackendRoles));
            return;
        }
        if (authorizers == null || authorizers.isEmpty()) {
            return;
        }
        boolean isTraceEnabled = this.log.isTraceEnabled();
        for (AuthorizationBackend ab : authorizers) {
            try {
                if (isTraceEnabled) {
                    this.log.trace("Backend roles for {} not cached, return from {} backend directly", (Object)authenticatedUser.getName(), (Object)ab.getType());
                }
                ab.fillRoles(authenticatedUser, new AuthCredentials(authenticatedUser.getName(), new String[0]));
            }
            catch (Exception e) {
                this.log.error("Cannot retrieve roles for {} from {} due to {}", (Object)authenticatedUser, (Object)ab.getType(), (Object)e.toString(), (Object)e);
            }
        }
        if (roleCache != null) {
            roleCache.put((Object)authenticatedUser, new HashSet<String>(authenticatedUser.getRoles()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User authcz(Cache<AuthCredentials, User> cache, final Cache<User, Set<String>> roleCache, final AuthCredentials ac, final AuthenticationBackend authBackend, final Set<AuthorizationBackend> authorizers) {
        if (ac == null) {
            return null;
        }
        try {
            if (authBackend.getClass() == NoOpAuthenticationBackend.class && authorizers.isEmpty()) {
                User user = authBackend.authenticate(ac);
                return user;
            }
            User user = (User)cache.get((Object)ac, (Callable)new Callable<User>(){

                @Override
                public User call() throws Exception {
                    if (BackendRegistry.this.log.isTraceEnabled()) {
                        BackendRegistry.this.log.trace("Credentials for user {} not cached, return from {} backend directly", (Object)ac.getUsername(), (Object)authBackend.getType());
                    }
                    User authenticatedUser = authBackend.authenticate(ac);
                    BackendRegistry.this.authz(authenticatedUser, (Cache<User, Set<String>>)roleCache, authorizers);
                    return authenticatedUser;
                }
            });
            return user;
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Can not authenticate {} due to exception", (Object)ac.getUsername(), (Object)e);
            }
            User user = null;
            return user;
        }
        finally {
            ac.clearSecrets();
        }
    }

    private User impersonate(SecurityRequest request, User originalUser) throws OpenSearchSecurityException {
        String impersonatedUserHeader = request.header("opendistro_security_impersonate_as");
        if (Strings.isNullOrEmpty((String)impersonatedUserHeader) || originalUser == null) {
            return null;
        }
        if (!this.isInitialized()) {
            throw new OpenSearchSecurityException("Could not check for impersonation because OpenSearch Security is not yet initialized", new Object[0]);
        }
        if (this.adminDns.isAdminDN(impersonatedUserHeader)) {
            throw new OpenSearchSecurityException("It is not allowed to impersonate as an adminuser  '" + impersonatedUserHeader + "'", RestStatus.FORBIDDEN, new Object[0]);
        }
        if (!this.adminDns.isRestImpersonationAllowed(originalUser.getName(), impersonatedUserHeader)) {
            throw new OpenSearchSecurityException("'" + originalUser.getName() + "' is not allowed to impersonate as '" + impersonatedUserHeader + "'", RestStatus.FORBIDDEN, new Object[0]);
        }
        boolean isDebugEnabled = this.log.isDebugEnabled();
        for (AuthDomain authDomain : this.restAuthDomains) {
            AuthenticationBackend authenticationBackend = authDomain.getBackend();
            if (!authDomain.getHttpAuthenticator().supportsImpersonation()) continue;
            User impersonatedUser = this.checkExistsAndAuthz(this.restImpersonationCache, new User(impersonatedUserHeader), authenticationBackend, this.restAuthorizers);
            if (impersonatedUser == null) {
                this.log.debug("Unable to impersonate rest user from '{}' to '{}' because the impersonated user does not exists in {}, try next ...", (Object)originalUser.getName(), (Object)impersonatedUserHeader, (Object)authenticationBackend.getType());
                continue;
            }
            if (isDebugEnabled) {
                this.log.debug("Impersonate rest user from '{}' to '{}'", (Object)originalUser.toStringWithAttributes(), (Object)impersonatedUser.toStringWithAttributes());
            }
            impersonatedUser.setRequestedTenant(originalUser.getRequestedTenant());
            return impersonatedUser;
        }
        this.log.debug("Unable to impersonate rest user from '{}' to '{}' because the impersonated user does not exists", (Object)originalUser.getName(), (Object)impersonatedUserHeader);
        throw new OpenSearchSecurityException("No such user:" + impersonatedUserHeader, RestStatus.FORBIDDEN, new Object[0]);
    }

    private boolean isBlocked(InetAddress address) {
        if (this.ipClientBlockRegistries == null || this.ipClientBlockRegistries.isEmpty()) {
            return false;
        }
        for (ClientBlockRegistry<InetAddress> clientBlockRegistry : this.ipClientBlockRegistries) {
            WildcardMatcher ignoreHostsMatcher = ((AuthFailureListener)((Object)clientBlockRegistry)).getIgnoreHostsMatcher();
            if (BackendRegistry.matchesHostPatterns(ignoreHostsMatcher, address, this.hostResolverMode)) {
                return false;
            }
            if (!clientBlockRegistry.isBlocked(address)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesHostPatterns(WildcardMatcher hostMatcher, InetAddress address, String hostResolverMode) {
        if (hostMatcher == null) {
            return false;
        }
        if (address != null) {
            ArrayList<String> valuesToCheck = new ArrayList<String>(List.of(address.getHostAddress()));
            if (hostResolverMode != null && (hostResolverMode.equalsIgnoreCase("ip-hostname") || hostResolverMode.equalsIgnoreCase("ip-hostname-lookup"))) {
                String hostName = address.getHostName();
                valuesToCheck.add(hostName);
            }
            return valuesToCheck.stream().anyMatch(hostMatcher);
        }
        return false;
    }

    private boolean isBlocked(String authBackend, String userName) {
        if (this.authBackendClientBlockRegistries == null) {
            return false;
        }
        Collection clientBlockRegistries = this.authBackendClientBlockRegistries.get((Object)authBackend);
        if (clientBlockRegistries.isEmpty()) {
            return false;
        }
        for (ClientBlockRegistry clientBlockRegistry : clientBlockRegistries) {
            if (!clientBlockRegistry.isBlocked(userName)) continue;
            return true;
        }
        return false;
    }
}

