/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.user;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.OpenSearchSecurityException;

public final class AuthCredentials {
    private static final String DIGEST_ALGORITHM = "SHA-256";
    private final String username;
    private byte[] password;
    private Object nativeCredentials;
    private final Set<String> securityRoles = new HashSet<String>();
    private final Set<String> backendRoles = new HashSet<String>();
    private boolean complete;
    private final byte[] internalPasswordHash;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public AuthCredentials(String username, Object nativeCredentials) {
        this(username, null, nativeCredentials, new String[0]);
        if (nativeCredentials == null) {
            throw new IllegalArgumentException("nativeCredentials must not be null or empty");
        }
    }

    public AuthCredentials(String username, byte[] password) {
        this(username, password, null, new String[0]);
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("password must not be null or empty");
        }
    }

    public AuthCredentials(String username, String ... backendRoles) {
        this(username, null, (Object)null, backendRoles);
    }

    public AuthCredentials(String username, List<String> securityRoles, String ... backendRoles) {
        this(username, null, (Object)null, backendRoles);
        this.securityRoles.addAll(securityRoles);
    }

    private AuthCredentials(String username, byte[] password, Object nativeCredentials, String ... backendRoles) {
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("username must not be null or empty");
        }
        this.username = username;
        byte[] byArray = this.password = password == null ? null : Arrays.copyOf(password, password.length);
        if (this.password != null) {
            try {
                MessageDigest digester = MessageDigest.getInstance(DIGEST_ALGORITHM);
                this.internalPasswordHash = digester.digest(this.password);
            }
            catch (NoSuchAlgorithmException e) {
                throw new OpenSearchSecurityException("Unable to digest password", (Exception)e, new Object[0]);
            }
        } else {
            this.internalPasswordHash = null;
        }
        if (password != null) {
            Arrays.fill(password, (byte)0);
            password = null;
        }
        this.nativeCredentials = nativeCredentials;
        nativeCredentials = null;
        if (backendRoles != null && backendRoles.length > 0) {
            this.backendRoles.addAll(Arrays.asList(backendRoles));
        }
    }

    public void clearSecrets() {
        if (this.password != null) {
            Arrays.fill(this.password, (byte)0);
            this.password = null;
        }
        this.nativeCredentials = null;
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getPassword() {
        return this.password == null ? null : Arrays.copyOf(this.password, this.password.length);
    }

    public Object getNativeCredentials() {
        return this.nativeCredentials;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.internalPasswordHash);
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthCredentials other = (AuthCredentials)obj;
        if (this.internalPasswordHash == null || other.internalPasswordHash == null || !MessageDigest.isEqual(this.internalPasswordHash, other.internalPasswordHash)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public String toString() {
        return "AuthCredentials [username=" + this.username + ", password empty=" + (this.password == null) + ", nativeCredentials empty=" + (this.nativeCredentials == null) + ",backendRoles=" + String.valueOf(this.backendRoles) + "]";
    }

    public Set<String> getBackendRoles() {
        return new HashSet<String>(this.backendRoles);
    }

    public Set<String> getSecurityRoles() {
        return Set.copyOf(this.securityRoles);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public AuthCredentials markComplete() {
        this.complete = true;
        return this;
    }

    public void addAttribute(String name, String value) {
        if (name != null && !name.isEmpty()) {
            this.attributes.put(name, value);
        }
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }
}

