/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.messaging.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.AbstractHeaderGeneratingMessageHandler;
import org.opensaml.soap.wssecurity.Created;
import org.opensaml.soap.wssecurity.Expires;
import org.opensaml.soap.wssecurity.Timestamp;
import org.opensaml.soap.wssecurity.messaging.WSSecurityContext;
import org.opensaml.soap.wssecurity.messaging.WSSecurityMessagingSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddTimestampHandler
extends AbstractHeaderGeneratingMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddTimestampHandler.class);
    @Nullable
    private Function<MessageContext, Instant> createdLookup;
    @Nullable
    private Function<MessageContext, Instant> expiresLookup;
    private boolean useCurrentTimeAsDefaultCreated;
    @Nullable
    private Duration expiresOffsetFromCreated;
    @Nullable
    private Instant createdValue;
    @Nullable
    private Instant expiresValue;

    @Nullable
    public Function<MessageContext, Instant> getCreatedLookup() {
        return this.createdLookup;
    }

    public void setCreatedLookup(@Nullable Function<MessageContext, Instant> lookup) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.createdLookup = lookup;
    }

    @Nullable
    public Function<MessageContext, Instant> getExpiresLookup() {
        return this.expiresLookup;
    }

    public void setExpiresLookup(@Nullable Function<MessageContext, Instant> lookup) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.expiresLookup = lookup;
    }

    public boolean isUseCurrentTimeAsDefaultCreated() {
        return this.useCurrentTimeAsDefaultCreated;
    }

    public void setUseCurrentTimeAsDefaultCreated(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.useCurrentTimeAsDefaultCreated = flag;
    }

    @Nullable
    public Duration getExpiresOffsetFromCreated() {
        return this.expiresOffsetFromCreated;
    }

    public void setExpiresOffsetFromCreated(@Nullable Duration value) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.expiresOffsetFromCreated = value;
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        this.createdValue = this.getCreatedValue(messageContext);
        this.expiresValue = this.getExpiresValue(messageContext, this.createdValue);
        if (this.createdValue == null && this.expiresValue == null) {
            this.log.debug("No WS-Security Timestamp Created or Expires values available, skipping further processing");
            return false;
        }
        return true;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.log.debug("Processing addition of outbound WS-Security Timestamp");
        Timestamp timestamp = (Timestamp)XMLObjectSupport.buildXMLObject((QName)Timestamp.ELEMENT_NAME);
        if (this.createdValue != null) {
            this.log.debug("WS-Security Timestamp Created value added was: {}", (Object)this.createdValue);
            Created created = (Created)XMLObjectSupport.buildXMLObject((QName)Created.ELEMENT_NAME);
            created.setDateTime(this.createdValue);
            timestamp.setCreated(created);
        }
        if (this.expiresValue != null) {
            this.log.debug("WS-Security Timestamp Expires value added was: {}", (Object)this.createdValue);
            Expires expires = (Expires)XMLObjectSupport.buildXMLObject((QName)Expires.ELEMENT_NAME);
            expires.setDateTime(this.expiresValue);
            timestamp.setExpires(expires);
        }
        WSSecurityMessagingSupport.addSecurityHeaderBlock((MessageContext)messageContext, (XMLObject)timestamp, (boolean)this.isEffectiveMustUnderstand(), (String)this.getEffectiveTargetNode(), (boolean)true);
    }

    @Nullable
    protected Instant getCreatedValue(@Nonnull MessageContext messageContext) {
        Instant value = null;
        WSSecurityContext security = (WSSecurityContext)messageContext.getSubcontext(WSSecurityContext.class, false);
        if (security != null) {
            value = security.getTimestampCreated();
        }
        if (value == null && this.getCreatedLookup() != null) {
            value = this.getCreatedLookup().apply(messageContext);
        }
        if (value == null && this.isUseCurrentTimeAsDefaultCreated()) {
            value = Instant.now();
        }
        return value;
    }

    @Nullable
    protected Instant getExpiresValue(@Nonnull MessageContext messageContext, @Nullable Instant created) {
        Instant value = null;
        WSSecurityContext security = (WSSecurityContext)messageContext.getSubcontext(WSSecurityContext.class, false);
        if (security != null) {
            value = security.getTimestampExpires();
        }
        if (value == null && this.getExpiresLookup() != null) {
            value = this.getExpiresLookup().apply(messageContext);
        }
        if (value == null && this.getExpiresOffsetFromCreated() != null && created != null) {
            return created.plus(this.getExpiresOffsetFromCreated());
        }
        return value;
    }
}

