/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;

public class CharacterOccurrencesRule
implements Rule {
    public static final String ERROR_CODE = "TOO_MANY_OCCURRENCES";
    protected int maxOccurrences;

    public CharacterOccurrencesRule(int maxAllowedOccurrences) {
        this.maxOccurrences = maxAllowedOccurrences;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult();
        String password = passwordData.getPassword() + '\uffff';
        char[] chars = password.toCharArray();
        Arrays.sort(chars);
        int repeat = 1;
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i] == chars[i - 1]) {
                ++repeat;
                continue;
            }
            if (repeat > this.maxOccurrences) {
                result.addError(ERROR_CODE, this.createRuleResultDetailParameters(chars[i - 1], repeat));
            }
            repeat = 1;
        }
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(char c, int occurrences) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("matchingCharacter", Character.valueOf(c));
        m.put("matchingCharacterCount", occurrences);
        m.put("maximumOccurrences", this.maxOccurrences);
        return m;
    }

    public String toString() {
        return String.format("%s@%h::maxOccurrences=%s", this.getClass().getName(), this.hashCode(), this.maxOccurrences);
    }
}

