/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.passay.dictionary.AbstractFileWordList;

public class MemoryMappedFileWordList
extends AbstractFileWordList {
    private final Buffer buffer;

    public MemoryMappedFileWordList(RandomAccessFile raf) throws IOException {
        this(raf, true);
    }

    public MemoryMappedFileWordList(RandomAccessFile raf, boolean caseSensitive) throws IOException {
        this(raf, caseSensitive, 5);
    }

    public MemoryMappedFileWordList(RandomAccessFile raf, boolean caseSensitive, int cachePercent) throws IOException {
        this(raf, caseSensitive, cachePercent, StandardCharsets.UTF_8.newDecoder());
    }

    public MemoryMappedFileWordList(RandomAccessFile raf, boolean caseSensitive, int cachePercent, CharsetDecoder decoder) throws IOException {
        this(raf, caseSensitive, cachePercent, decoder, false);
    }

    public MemoryMappedFileWordList(RandomAccessFile raf, boolean caseSensitive, int cachePercent, CharsetDecoder decoder, boolean allocateDirect) throws IOException {
        super(raf, caseSensitive, decoder);
        FileChannel channel = this.file.getChannel();
        this.buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        this.initialize(cachePercent, allocateDirect);
    }

    @Override
    protected void seek(long offset) {
        this.buffer.clear().position((int)offset);
    }

    @Override
    protected ByteBuffer buffer() {
        return (ByteBuffer)this.buffer;
    }

    @Override
    protected void fill() {
    }
}

