/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn;

import com.nulabinc.zxcvbn.Context;
import com.nulabinc.zxcvbn.Zxcvbn;
import com.nulabinc.zxcvbn.matchers.Dictionary;
import com.nulabinc.zxcvbn.matchers.Keyboard;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ZxcvbnBuilder {
    private final Map<String, Dictionary> dictionaryMap = new LinkedHashMap<String, Dictionary>();
    private final Map<String, Keyboard> keyboardMap = new LinkedHashMap<String, Keyboard>();

    public Zxcvbn build() {
        return new Zxcvbn(new Context(this.dictionaryMap, this.keyboardMap));
    }

    public ZxcvbnBuilder dictionary(Dictionary dictionary) {
        this.dictionaryMap.put(dictionary.getName(), dictionary);
        return this;
    }

    public ZxcvbnBuilder dictionaries(List<Dictionary> dictionaries) {
        for (Dictionary dictionary : dictionaries) {
            this.dictionary(dictionary);
        }
        return this;
    }

    public ZxcvbnBuilder keyboard(Keyboard keyboard) {
        this.keyboardMap.put(keyboard.getName(), keyboard);
        return this;
    }

    public ZxcvbnBuilder keyboards(List<Keyboard> keyboards) {
        for (Keyboard keyboard : keyboards) {
            this.keyboard(keyboard);
        }
        return this;
    }
}

