/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.AlgorithmFinder;
import com.password4j.Argon2Function;
import com.password4j.BadParametersException;
import com.password4j.BcryptFunction;
import com.password4j.CompressedPBKDF2Function;
import com.password4j.Hash;
import com.password4j.HashBuilder;
import com.password4j.HashChecker;
import com.password4j.HashUpdate;
import com.password4j.HashingFunction;
import com.password4j.ScryptFunction;

public class HashUpdater {
    protected HashChecker hashChecker;
    protected HashBuilder hashBuilder;
    private boolean force;

    HashUpdater(HashChecker hashChecker, HashBuilder hashBuilder) {
        this.hashChecker = hashChecker;
        this.hashBuilder = hashBuilder;
    }

    public HashUpdate with(HashingFunction oldHashingFunction, HashingFunction newHashingFunction) {
        boolean toBeUpdated;
        if (oldHashingFunction == null) {
            throw new BadParametersException("Starting hashing function cannot be null.");
        }
        if (newHashingFunction == null) {
            throw new BadParametersException("New hashing function cannot be null.");
        }
        boolean bl = toBeUpdated = this.force || !oldHashingFunction.equals(newHashingFunction) || this.hashBuilder.salt != null || this.hashBuilder.pepper != null;
        if (this.hashChecker.with(oldHashingFunction)) {
            if (toBeUpdated) {
                Hash hash = this.hashBuilder.with(newHashingFunction);
                return new HashUpdate(hash, true);
            }
            Hash hash = new Hash(oldHashingFunction, this.hashChecker.hashed, null, this.hashChecker.salt);
            return new HashUpdate(hash, false);
        }
        return HashUpdate.UNVERIFIED;
    }

    public HashUpdater addNewSalt(String salt) {
        this.hashBuilder.addSalt(salt);
        return this;
    }

    public HashUpdater addNewSalt(byte[] saltAsBytes) {
        this.hashBuilder.addSalt(saltAsBytes);
        return this;
    }

    public HashUpdater addNewRandomSalt() {
        this.hashBuilder.addRandomSalt();
        return this;
    }

    public HashUpdater addNewRandomSalt(int length) {
        this.hashBuilder.addRandomSalt(length);
        return this;
    }

    public HashUpdater addNewPepper() {
        this.hashBuilder.addPepper();
        return this;
    }

    public HashUpdater addNewPepper(CharSequence pepper) {
        this.hashBuilder.addPepper(pepper);
        return this;
    }

    public HashUpdater forceUpdate() {
        this.force = true;
        return this;
    }

    public HashUpdate withPBKDF2() {
        return this.withPBKDF2(AlgorithmFinder.getPBKDF2Instance());
    }

    public HashUpdate withPBKDF2(HashingFunction newHashingFunction) {
        return this.with(AlgorithmFinder.getPBKDF2Instance(), newHashingFunction);
    }

    public HashUpdate withCompressedPBKDF2() {
        CompressedPBKDF2Function pbkdf2 = AlgorithmFinder.getCompressedPBKDF2Instance();
        return this.withCompressedPBKDF2(pbkdf2);
    }

    public HashUpdate withCompressedPBKDF2(HashingFunction newHashingFunction) {
        CompressedPBKDF2Function pbkdf2 = CompressedPBKDF2Function.getInstanceFromHash(this.hashChecker.getHashed());
        return this.with(pbkdf2, newHashingFunction);
    }

    public HashUpdate withBcrypt() {
        return this.withBcrypt(AlgorithmFinder.getBcryptInstance());
    }

    public HashUpdate withBcrypt(HashingFunction newHashingFunction) {
        return this.with(BcryptFunction.getInstanceFromHash(this.hashChecker.getHashed()), newHashingFunction);
    }

    public HashUpdate withScrypt() {
        return this.withScrypt(AlgorithmFinder.getScryptInstance());
    }

    public HashUpdate withScrypt(HashingFunction newHashingFunction) {
        return this.with(ScryptFunction.getInstanceFromHash(this.hashChecker.getHashed()), newHashingFunction);
    }

    public HashUpdate withMessageDigest() {
        return this.withMessageDigest(AlgorithmFinder.getMessageDigestInstance());
    }

    public HashUpdate withMessageDigest(HashingFunction newHashingFunction) {
        return this.with(AlgorithmFinder.getMessageDigestInstance(), newHashingFunction);
    }

    public HashUpdate withArgon2() {
        return this.withArgon2(AlgorithmFinder.getArgon2Instance());
    }

    public HashUpdate withArgon2(HashingFunction newHashingFunction) {
        return this.with(Argon2Function.getInstanceFromHash(this.hashChecker.getHashed()), newHashingFunction);
    }

    public HashUpdate withBalloonHashing() {
        return this.withBalloonHashing(AlgorithmFinder.getBalloonHashingInstance());
    }

    public HashUpdate withBalloonHashing(HashingFunction newHashingFunction) {
        return this.with(AlgorithmFinder.getBalloonHashingInstance(), newHashingFunction);
    }
}

