/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadBitString<C extends Asn1Container>
extends GrammarAction<C> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadBitString.class);

    public AbstractReadBitString(String name) {
        super(name);
    }

    protected abstract void setBitString(byte[] var1, C var2);

    @Override
    public final void action(C container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() != 5) {
            String msg = I18n.err(I18n.ERR_01100_INCORRECT_LENGTH, 5, tlv.getLength());
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        byte[] data = tlv.getValue().getData();
        this.setBitString(data, container);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_01101_BITSTRING_VALUE, Strings.dumpBytes(data)));
        }
    }
}

