/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.controls;

import org.apache.directory.api.ldap.model.message.Control;

public abstract class AbstractControl
implements Control {
    private String oid;
    private boolean criticality = false;

    public AbstractControl(String oid) {
        this.oid = oid;
    }

    public AbstractControl(String oid, boolean criticality) {
        this.oid = oid;
        this.criticality = criticality;
    }

    @Override
    public String getOid() {
        return this.oid == null ? "" : this.oid;
    }

    @Override
    public boolean isCritical() {
        return this.criticality;
    }

    @Override
    public void setCritical(boolean criticality) {
        this.criticality = criticality;
    }

    public int hashCode() {
        int h = 17;
        h = h * 37 + (this.criticality ? 1 : 0);
        h = h * 37 + (this.oid == null ? 0 : this.oid.hashCode());
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Control)) {
            return false;
        }
        Control otherControl = (Control)o;
        if (!this.oid.equalsIgnoreCase(otherControl.getOid())) {
            return false;
        }
        return this.criticality == otherControl.isCritical();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append(this.getClass().getSimpleName()).append(" ");
        sb.append("Control\n");
        sb.append("        Type OID    : '").append(this.oid).append("'\n");
        sb.append("        Criticality : '").append(this.criticality).append("'\n");
        sb.append("'\n");
        return sb.toString();
    }
}

