/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.util.Version;

public class BundleInfo {
    public static final Version DEFAULT_VERSION = new Version(1, 0, 0, null);
    private String symbolicName;
    private Version version;
    private Set requirements = new LinkedHashSet();
    private Set capabilities = new LinkedHashSet();
    private List executionEnvironments = Collections.EMPTY_LIST;
    private String description;
    private URI uri;

    public BundleInfo(String string, Version version) {
        this.symbolicName = string;
        this.version = version;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BundleInfo [executionEnvironments=");
        stringBuffer.append(this.executionEnvironments);
        stringBuffer.append(", capabilities=");
        stringBuffer.append(this.capabilities);
        stringBuffer.append(", requirements=");
        stringBuffer.append(this.requirements);
        stringBuffer.append(", symbolicName=");
        stringBuffer.append(this.symbolicName);
        stringBuffer.append(", version=");
        stringBuffer.append(this.version);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        if (this.version == null) {
            return DEFAULT_VERSION;
        }
        return this.version;
    }

    public void setUri(URI uRI) {
        this.uri = uRI;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void addRequirement(BundleRequirement bundleRequirement) {
        this.requirements.add(bundleRequirement);
    }

    public Set getRequirements() {
        return this.requirements;
    }

    public void addCapability(BundleCapability bundleCapability) {
        this.capabilities.add(bundleCapability);
    }

    public List getExecutionEnvironments() {
        return this.executionEnvironments;
    }

    public void setExecutionEnvironments(List list) {
        this.executionEnvironments = list;
    }

    public int hashCode() {
        int n = 31 + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        n = n * 31 + (this.requirements == null ? 0 : this.requirements.hashCode());
        n = n * 31 + (this.symbolicName == null ? 0 : this.symbolicName.hashCode());
        n = n * 31 + (this.version == null ? 0 : this.version.hashCode());
        n = n * 31 + (this.executionEnvironments == null ? 0 : this.executionEnvironments.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BundleInfo)) {
            return false;
        }
        object = (BundleInfo)object;
        if (this.capabilities == null ? ((BundleInfo)object).capabilities != null : !this.capabilities.equals(((BundleInfo)object).capabilities)) {
            return false;
        }
        if (this.requirements == null ? ((BundleInfo)object).requirements != null : !this.requirements.equals(((BundleInfo)object).requirements)) {
            return false;
        }
        if (this.symbolicName == null ? ((BundleInfo)object).symbolicName != null : !this.symbolicName.equals(((BundleInfo)object).symbolicName)) {
            return false;
        }
        if (this.version == null ? ((BundleInfo)object).version != null : !this.version.equals(((BundleInfo)object).version)) {
            return false;
        }
        return !(this.executionEnvironments == null ? ((BundleInfo)object).executionEnvironments != null : !this.executionEnvironments.equals(((BundleInfo)object).executionEnvironments));
    }

    public Set getExports() {
        LinkedHashSet<ExportPackage> linkedHashSet = new LinkedHashSet<ExportPackage>();
        for (BundleCapability bundleCapability : this.capabilities) {
            if (!"package".equals(bundleCapability.getType())) continue;
            linkedHashSet.add((ExportPackage)bundleCapability);
        }
        return linkedHashSet;
    }
}

