/*
 * This declarations of the PIC16LF1619 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:10 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16LF1619_H__
#define __PIC16LF1619_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTB_ADDR              0x000D
#define PORTC_ADDR              0x000E
#define PIR1_ADDR               0x0010
#define PIR2_ADDR               0x0011
#define PIR3_ADDR               0x0012
#define PIR4_ADDR               0x0013
#define PIR5_ADDR               0x0014
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define T2TMR_ADDR              0x001A
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2PR_ADDR               0x001B
#define T2CON_ADDR              0x001C
#define T2HLT_ADDR              0x001D
#define T2CLKCON_ADDR           0x001E
#define T2RST_ADDR              0x001F
#define TRISA_ADDR              0x008C
#define TRISB_ADDR              0x008D
#define TRISC_ADDR              0x008E
#define PIE1_ADDR               0x0090
#define PIE2_ADDR               0x0091
#define PIE3_ADDR               0x0092
#define PIE4_ADDR               0x0093
#define PIE5_ADDR               0x0094
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define OSCTUNE_ADDR            0x0098
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define ADCON2_ADDR             0x009F
#define LATA_ADDR               0x010C
#define LATB_ADDR               0x010D
#define LATC_ADDR               0x010E
#define CM1CON0_ADDR            0x0111
#define CM1CON1_ADDR            0x0112
#define CM2CON0_ADDR            0x0113
#define CM2CON1_ADDR            0x0114
#define CMOUT_ADDR              0x0115
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define DAC1CON0_ADDR           0x0118
#define DAC1CON1_ADDR           0x0119
#define ZCD1CON_ADDR            0x011C
#define ANSELA_ADDR             0x018C
#define ANSELB_ADDR             0x018D
#define ANSELC_ADDR             0x018E
#define PMADR_ADDR              0x0191
#define PMADRL_ADDR             0x0191
#define PMADRH_ADDR             0x0192
#define PMDAT_ADDR              0x0193
#define PMDATL_ADDR             0x0193
#define PMDATH_ADDR             0x0194
#define PMCON1_ADDR             0x0195
#define PMCON2_ADDR             0x0196
#define RC1REG_ADDR             0x0199
#define RCREG_ADDR              0x0199
#define RCREG1_ADDR             0x0199
#define TX1REG_ADDR             0x019A
#define TXREG_ADDR              0x019A
#define TXREG1_ADDR             0x019A
#define SP1BRG_ADDR             0x019B
#define SP1BRGL_ADDR            0x019B
#define SPBRG_ADDR              0x019B
#define SPBRG1_ADDR             0x019B
#define SPBRGL_ADDR             0x019B
#define SP1BRGH_ADDR            0x019C
#define SPBRGH_ADDR             0x019C
#define SPBRGH1_ADDR            0x019C
#define RC1STA_ADDR             0x019D
#define RCSTA_ADDR              0x019D
#define RCSTA1_ADDR             0x019D
#define TX1STA_ADDR             0x019E
#define TXSTA_ADDR              0x019E
#define TXSTA1_ADDR             0x019E
#define BAUD1CON_ADDR           0x019F
#define BAUDCON_ADDR            0x019F
#define BAUDCON1_ADDR           0x019F
#define BAUDCTL_ADDR            0x019F
#define BAUDCTL1_ADDR           0x019F
#define WPUA_ADDR               0x020C
#define WPUB_ADDR               0x020D
#define WPUC_ADDR               0x020E
#define SSP1BUF_ADDR            0x0211
#define SSPBUF_ADDR             0x0211
#define SSP1ADD_ADDR            0x0212
#define SSPADD_ADDR             0x0212
#define SSP1MSK_ADDR            0x0213
#define SSPMSK_ADDR             0x0213
#define SSP1STAT_ADDR           0x0214
#define SSPSTAT_ADDR            0x0214
#define SSP1CON_ADDR            0x0215
#define SSP1CON1_ADDR           0x0215
#define SSPCON_ADDR             0x0215
#define SSPCON1_ADDR            0x0215
#define SSP1CON2_ADDR           0x0216
#define SSPCON2_ADDR            0x0216
#define SSP1CON3_ADDR           0x0217
#define SSPCON3_ADDR            0x0217
#define ODCONA_ADDR             0x028C
#define ODCONB_ADDR             0x028D
#define ODCONC_ADDR             0x028E
#define CCPR1_ADDR              0x0291
#define CCPR1L_ADDR             0x0291
#define CCPR1H_ADDR             0x0292
#define CCP1CON_ADDR            0x0293
#define CCP1CAP_ADDR            0x0294
#define CCPR2_ADDR              0x0298
#define CCPR2L_ADDR             0x0298
#define CCPR2H_ADDR             0x0299
#define CCP2CON_ADDR            0x029A
#define CCP2CAP_ADDR            0x029B
#define CCPTMRS_ADDR            0x029E
#define SLRCONA_ADDR            0x030C
#define SLRCONB_ADDR            0x030D
#define SLRCONC_ADDR            0x030E
#define INLVLA_ADDR             0x038C
#define INLVLB_ADDR             0x038D
#define INLVLC_ADDR             0x038E
#define IOCAP_ADDR              0x0391
#define IOCAN_ADDR              0x0392
#define IOCAF_ADDR              0x0393
#define IOCBP_ADDR              0x0394
#define IOCBN_ADDR              0x0395
#define IOCBF_ADDR              0x0396
#define IOCCP_ADDR              0x0397
#define IOCCN_ADDR              0x0398
#define IOCCF_ADDR              0x0399
#define HDRVC_ADDR              0x040E
#define T4TMR_ADDR              0x0413
#define TMR4_ADDR               0x0413
#define PR4_ADDR                0x0414
#define T4PR_ADDR               0x0414
#define T4CON_ADDR              0x0415
#define T4HLT_ADDR              0x0416
#define T4CLKCON_ADDR           0x0417
#define T4RST_ADDR              0x0418
#define T6TMR_ADDR              0x041A
#define TMR6_ADDR               0x041A
#define PR6_ADDR                0x041B
#define T6PR_ADDR               0x041B
#define T6CON_ADDR              0x041C
#define T6HLT_ADDR              0x041D
#define T6CLKCON_ADDR           0x041E
#define T6RST_ADDR              0x041F
#define TMR3_ADDR               0x0493
#define TMR3L_ADDR              0x0493
#define TMR3H_ADDR              0x0494
#define T3CON_ADDR              0x0495
#define T3GCON_ADDR             0x0496
#define TMR5L_ADDR              0x049A
#define TMR5H_ADDR              0x049B
#define T5CON_ADDR              0x049C
#define T5GCON_ADDR             0x049D
#define PID1SET_ADDR            0x058C
#define PID1SETL_ADDR           0x058C
#define PID1SETH_ADDR           0x058D
#define PID1IN_ADDR             0x058E
#define PID1INL_ADDR            0x058E
#define PID1INH_ADDR            0x058F
#define PID1K1_ADDR             0x0590
#define PID1K1L_ADDR            0x0590
#define PID1K1H_ADDR            0x0591
#define PID1K2_ADDR             0x0592
#define PID1K2L_ADDR            0x0592
#define PID1K2H_ADDR            0x0593
#define PID1K3_ADDR             0x0594
#define PID1K3L_ADDR            0x0594
#define PID1K3H_ADDR            0x0595
#define PID1OUT_ADDR            0x0596
#define PID1OUTLL_ADDR          0x0596
#define PID1OUTLH_ADDR          0x0597
#define PID1OUTHL_ADDR          0x0598
#define PID1OUTHH_ADDR          0x0599
#define PID1OUTU_ADDR           0x059A
#define PID1Z1_ADDR             0x059B
#define PID1Z1L_ADDR            0x059B
#define PID1Z1H_ADDR            0x059C
#define PID1Z1U_ADDR            0x059D
#define PID1Z2_ADDR             0x060C
#define PID1Z2L_ADDR            0x060C
#define PID1Z2H_ADDR            0x060D
#define PID1Z2U_ADDR            0x060E
#define PID1ACC_ADDR            0x060F
#define PID1ACCLL_ADDR          0x060F
#define PID1ACCLH_ADDR          0x0610
#define PID1ACCHL_ADDR          0x0611
#define PID1ACCHH_ADDR          0x0612
#define PID1ACCU_ADDR           0x0613
#define PID1CON_ADDR            0x0614
#define PWM3DCL_ADDR            0x0617
#define PWM3DCH_ADDR            0x0618
#define PWM3CON_ADDR            0x0619
#define PWM4DCL_ADDR            0x061A
#define PWM4DCH_ADDR            0x061B
#define PWM4CON_ADDR            0x061C
#define CWG1DBR_ADDR            0x0691
#define CWG1DBF_ADDR            0x0692
#define CWG1AS0_ADDR            0x0693
#define CWG1AS1_ADDR            0x0694
#define CWG1OCON0_ADDR          0x0695
#define CWG1CON0_ADDR           0x0696
#define CWG1CON1_ADDR           0x0697
#define CWG1CLKCON_ADDR         0x0699
#define CWG1ISM_ADDR            0x069A
#define WDTCON0_ADDR            0x0711
#define WDTCON1_ADDR            0x0712
#define WDTPSL_ADDR             0x0713
#define WDTPSH_ADDR             0x0714
#define WDTTMR_ADDR             0x0715
#define SCANLADR_ADDR           0x0718
#define SCANLADRL_ADDR          0x0718
#define SCANLADRH_ADDR          0x0719
#define SCANHADR_ADDR           0x071A
#define SCANHADRL_ADDR          0x071A
#define SCANHADRH_ADDR          0x071B
#define SCANCON0_ADDR           0x071C
#define SCANTRIG_ADDR           0x071D
#define CRCDAT_ADDR             0x0791
#define CRCDATL_ADDR            0x0791
#define CRCDATH_ADDR            0x0792
#define CRCACC_ADDR             0x0793
#define CRCACCL_ADDR            0x0793
#define CRCACCH_ADDR            0x0794
#define CRCSHIFT_ADDR           0x0795
#define CRCSHIFTL_ADDR          0x0795
#define CRCSHIFTH_ADDR          0x0796
#define CRCXOR_ADDR             0x0797
#define CRCXORL_ADDR            0x0797
#define CRCXORH_ADDR            0x0798
#define CRCCON0_ADDR            0x0799
#define CRCCON1_ADDR            0x079A
#define AT1RES_ADDR             0x080C
#define AT1RESL_ADDR            0x080C
#define AT1RESH_ADDR            0x080D
#define AT1MISS_ADDR            0x080E
#define AT1MISSL_ADDR           0x080E
#define AT1MISSH_ADDR           0x080F
#define AT1PER_ADDR             0x0810
#define AT1PERL_ADDR            0x0810
#define AT1PERH_ADDR            0x0811
#define AT1PHS_ADDR             0x0812
#define AT1PHSL_ADDR            0x0812
#define AT1PHSH_ADDR            0x0813
#define AT1CON0_ADDR            0x0814
#define AT1CON1_ADDR            0x0815
#define AT1IR0_ADDR             0x0816
#define AT1IE0_ADDR             0x0817
#define AT1IR1_ADDR             0x0818
#define AT1IE1_ADDR             0x0819
#define AT1STPT_ADDR            0x081A
#define AT1STPTL_ADDR           0x081A
#define AT1STPTH_ADDR           0x081B
#define AT1ERR_ADDR             0x081C
#define AT1ERRL_ADDR            0x081C
#define AT1ERRH_ADDR            0x081D
#define AT1CLK_ADDR             0x088C
#define AT1SIG_ADDR             0x088D
#define AT1CSEL1_ADDR           0x088E
#define AT1CC1_ADDR             0x088F
#define AT1CC1L_ADDR            0x088F
#define AT1CC1H_ADDR            0x0890
#define AT1CCON1_ADDR           0x0891
#define AT1CSEL2_ADDR           0x0892
#define AT1CC2_ADDR             0x0893
#define AT1CC2L_ADDR            0x0893
#define AT1CC2H_ADDR            0x0894
#define AT1CCON2_ADDR           0x0895
#define AT1CSEL3_ADDR           0x0896
#define AT1CC3_ADDR             0x0897
#define AT1CC3L_ADDR            0x0897
#define AT1CC3H_ADDR            0x0898
#define AT1CCON3_ADDR           0x0899
#define SMT1TMR_ADDR            0x0D8C
#define SMT1TMRL_ADDR           0x0D8C
#define SMT1TMRH_ADDR           0x0D8D
#define SMT1TMRU_ADDR           0x0D8E
#define SMT1CPR_ADDR            0x0D8F
#define SMT1CPRL_ADDR           0x0D8F
#define SMT1CPRH_ADDR           0x0D90
#define SMT1CPRU_ADDR           0x0D91
#define SMT1CPW_ADDR            0x0D92
#define SMT1CPWL_ADDR           0x0D92
#define SMT1CPWH_ADDR           0x0D93
#define SMT1CPWU_ADDR           0x0D94
#define SMT1PR_ADDR             0x0D95
#define SMT1PRL_ADDR            0x0D95
#define SMT1PRH_ADDR            0x0D96
#define SMT1PRU_ADDR            0x0D97
#define SMT1CON0_ADDR           0x0D98
#define SMT1CON1_ADDR           0x0D99
#define SMT1STAT_ADDR           0x0D9A
#define SMT1CLK_ADDR            0x0D9B
#define SMT1SIG_ADDR            0x0D9C
#define SMT1WIN_ADDR            0x0D9D
#define SMT2TMR_ADDR            0x0D9E
#define SMT2TMRL_ADDR           0x0D9E
#define SMT2TMRH_ADDR           0x0D9F
#define SMT2TMRU_ADDR           0x0DA0
#define SMT2CPR_ADDR            0x0DA1
#define SMT2CPRL_ADDR           0x0DA1
#define SMT2CPRH_ADDR           0x0DA2
#define SMT2CPRU_ADDR           0x0DA3
#define SMT2CPW_ADDR            0x0DA4
#define SMT2CPWL_ADDR           0x0DA4
#define SMT2CPWH_ADDR           0x0DA5
#define SMT2CPWU_ADDR           0x0DA6
#define SMT2PR_ADDR             0x0DA7
#define SMT2PRL_ADDR            0x0DA7
#define SMT2PRH_ADDR            0x0DA8
#define SMT2PRU_ADDR            0x0DA9
#define SMT2CON0_ADDR           0x0DAA
#define SMT2CON1_ADDR           0x0DAB
#define SMT2STAT_ADDR           0x0DAC
#define SMT2CLK_ADDR            0x0DAD
#define SMT2SIG_ADDR            0x0DAE
#define SMT2WIN_ADDR            0x0DAF
#define PPSLOCK_ADDR            0x0E0F
#define INTPPS_ADDR             0x0E10
#define T0CKIPPS_ADDR           0x0E11
#define T1CKIPPS_ADDR           0x0E12
#define T1GPPS_ADDR             0x0E13
#define CCP1PPS_ADDR            0x0E14
#define CCP2PPS_ADDR            0x0E15
#define ATINPPS_ADDR            0x0E16
#define CWGINPPS_ADDR           0x0E17
#define T2PPS_ADDR              0x0E18
#define T3CKIPPS_ADDR           0x0E19
#define T3GPPS_ADDR             0x0E1A
#define T4PPS_ADDR              0x0E1B
#define T5CKIPPS_ADDR           0x0E1C
#define T5GPPS_ADDR             0x0E1D
#define T6PPS_ADDR              0x0E1E
#define ATCC1PPS_ADDR           0x0E1F
#define SSPCLKPPS_ADDR          0x0E20
#define SSPDATPPS_ADDR          0x0E21
#define SSPSSPPS_ADDR           0x0E22
#define ATCC2PPS_ADDR           0x0E23
#define RXPPS_ADDR              0x0E24
#define CKPPS_ADDR              0x0E25
#define SMT1SIGPPS_ADDR         0x0E26
#define SMT1WINPPS_ADDR         0x0E27
#define CLCIN0PPS_ADDR          0x0E28
#define CLCIN1PPS_ADDR          0x0E29
#define CLCIN2PPS_ADDR          0x0E2A
#define CLCIN3PPS_ADDR          0x0E2B
#define SMT2SIGPPS_ADDR         0x0E2C
#define SMT2WINPPS_ADDR         0x0E2D
#define ATCC3PPS_ADDR           0x0E2E
#define RA0PPS_ADDR             0x0E90
#define RA1PPS_ADDR             0x0E91
#define RA2PPS_ADDR             0x0E92
#define RA4PPS_ADDR             0x0E94
#define RA5PPS_ADDR             0x0E95
#define RB4PPS_ADDR             0x0E9C
#define RB5PPS_ADDR             0x0E9D
#define RB6PPS_ADDR             0x0E9E
#define RB7PPS_ADDR             0x0E9F
#define RC0PPS_ADDR             0x0EA0
#define RC1PPS_ADDR             0x0EA1
#define RC2PPS_ADDR             0x0EA2
#define RC3PPS_ADDR             0x0EA3
#define RC4PPS_ADDR             0x0EA4
#define RC5PPS_ADDR             0x0EA5
#define RC6PPS_ADDR             0x0EA6
#define RC7PPS_ADDR             0x0EA7
#define CLCDATA_ADDR            0x0F0F
#define CLC1CON_ADDR            0x0F10
#define CLC1POL_ADDR            0x0F11
#define CLC1SEL0_ADDR           0x0F12
#define CLC1SEL1_ADDR           0x0F13
#define CLC1SEL2_ADDR           0x0F14
#define CLC1SEL3_ADDR           0x0F15
#define CLC1GLS0_ADDR           0x0F16
#define CLC1GLS1_ADDR           0x0F17
#define CLC1GLS2_ADDR           0x0F18
#define CLC1GLS3_ADDR           0x0F19
#define CLC2CON_ADDR            0x0F1A
#define CLC2POL_ADDR            0x0F1B
#define CLC2SEL0_ADDR           0x0F1C
#define CLC2SEL1_ADDR           0x0F1D
#define CLC2SEL2_ADDR           0x0F1E
#define CLC2SEL3_ADDR           0x0F1F
#define CLC2GLS0_ADDR           0x0F20
#define CLC2GLS1_ADDR           0x0F21
#define CLC2GLS2_ADDR           0x0F22
#define CLC2GLS3_ADDR           0x0F23
#define CLC3CON_ADDR            0x0F24
#define CLC3POL_ADDR            0x0F25
#define CLC3SEL0_ADDR           0x0F26
#define CLC3SEL1_ADDR           0x0F27
#define CLC3SEL2_ADDR           0x0F28
#define CLC3SEL3_ADDR           0x0F29
#define CLC3GLS0_ADDR           0x0F2A
#define CLC3GLS1_ADDR           0x0F2B
#define CLC3GLS2_ADDR           0x0F2C
#define CLC3GLS3_ADDR           0x0F2D
#define CLC4CON_ADDR            0x0F2E
#define CLC4POL_ADDR            0x0F2F
#define CLC4SEL0_ADDR           0x0F30
#define CLC4SEL1_ADDR           0x0F31
#define CLC4SEL2_ADDR           0x0F32
#define CLC4SEL3_ADDR           0x0F33
#define CLC4GLS0_ADDR           0x0F34
#define CLC4GLS1_ADDR           0x0F35
#define CLC4GLS2_ADDR           0x0F36
#define CLC4GLS3_ADDR           0x0F37
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x000D) __sfr PORTB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x000D) volatile __PORTBbits_t PORTBbits;

#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0010) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned SSP1IF               : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned TMR1GIF              : 1;
  } __PIR1bits_t;

extern __at(0x0010) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSP1IF                 0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0011) __sfr PIR2;

typedef struct
  {
  unsigned CCP2IF               : 1;
  unsigned TMR4IF               : 1;
  unsigned TMR6IF               : 1;
  unsigned BCL1IF               : 1;
  unsigned                      : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned OSFIF                : 1;
  } __PIR2bits_t;

extern __at(0x0011) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _TMR4IF                 0x02
#define _TMR6IF                 0x04
#define _BCL1IF                 0x08
#define _C1IF                   0x20
#define _C2IF                   0x40
#define _OSFIF                  0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0012) __sfr PIR3;

typedef struct
  {
  unsigned CLC1IF               : 1;
  unsigned CLC2IF               : 1;
  unsigned CLC3IF               : 1;
  unsigned CLC4IF               : 1;
  unsigned ZCDIF                : 1;
  unsigned CWGIF                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0012) volatile __PIR3bits_t PIR3bits;

#define _CLC1IF                 0x01
#define _CLC2IF                 0x02
#define _CLC3IF                 0x04
#define _CLC4IF                 0x08
#define _ZCDIF                  0x10
#define _CWGIF                  0x20

//==============================================================================


//==============================================================================
//        PIR4 Bits

extern __at(0x0013) __sfr PIR4;

typedef struct
  {
  unsigned SMT1IF               : 1;
  unsigned SMT1PRAIF            : 1;
  unsigned SMT1PWAIF            : 1;
  unsigned SMT2IF               : 1;
  unsigned SMT2PRAIF            : 1;
  unsigned SMT2PWAIF            : 1;
  unsigned CRCIF                : 1;
  unsigned SCANIF               : 1;
  } __PIR4bits_t;

extern __at(0x0013) volatile __PIR4bits_t PIR4bits;

#define _SMT1IF                 0x01
#define _SMT1PRAIF              0x02
#define _SMT1PWAIF              0x04
#define _SMT2IF                 0x08
#define _SMT2PRAIF              0x10
#define _SMT2PWAIF              0x20
#define _CRCIF                  0x40
#define _SCANIF                 0x80

//==============================================================================


//==============================================================================
//        PIR5 Bits

extern __at(0x0014) __sfr PIR5;

typedef struct
  {
  unsigned PID1DIF              : 1;
  unsigned PID1EIF              : 1;
  unsigned AT1IF                : 1;
  unsigned                      : 1;
  unsigned TMR5IF               : 1;
  unsigned TMR5GIF              : 1;
  unsigned TMR3IF               : 1;
  unsigned TMR3GIF              : 1;
  } __PIR5bits_t;

extern __at(0x0014) volatile __PIR5bits_t PIR5bits;

#define _PID1DIF                0x01
#define _PID1EIF                0x02
#define _AT1IF                  0x04
#define _TMR5IF                 0x10
#define _TMR5GIF                0x20
#define _TMR3IF                 0x40
#define _TMR3GIF                0x80

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned                    : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001A) __sfr T2TMR;
extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;
extern __at(0x001B) __sfr T2PR;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned T2CKPS2            : 1;
    unsigned T2ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR2ON             : 1;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T2OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T2CKPS             : 3;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _OUTPS0                 0x01
#define _T2OUTPS0               0x01
#define _OUTPS1                 0x02
#define _T2OUTPS1               0x02
#define _OUTPS2                 0x04
#define _T2OUTPS2               0x04
#define _OUTPS3                 0x08
#define _T2OUTPS3               0x08
#define _CKPS0                  0x10
#define _T2CKPS0                0x10
#define _CKPS1                  0x20
#define _T2CKPS1                0x20
#define _CKPS2                  0x40
#define _T2CKPS2                0x40
#define _ON                     0x80
#define _T2ON                   0x80
#define _TMR2ON                 0x80

//==============================================================================


//==============================================================================
//        T2HLT Bits

extern __at(0x001D) __sfr T2HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned MODE4              : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T2MODE0            : 1;
    unsigned T2MODE1            : 1;
    unsigned T2MODE2            : 1;
    unsigned T2MODE3            : 1;
    unsigned T2MODE4            : 1;
    unsigned T2CKSYNC           : 1;
    unsigned T2CKPOL            : 1;
    unsigned T2PSYNC            : 1;
    };

  struct
    {
    unsigned T2MODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MODE               : 5;
    unsigned                    : 3;
    };
  } __T2HLTbits_t;

extern __at(0x001D) volatile __T2HLTbits_t T2HLTbits;

#define _T2HLT_MODE0            0x01
#define _T2HLT_T2MODE0          0x01
#define _T2HLT_MODE1            0x02
#define _T2HLT_T2MODE1          0x02
#define _T2HLT_MODE2            0x04
#define _T2HLT_T2MODE2          0x04
#define _T2HLT_MODE3            0x08
#define _T2HLT_T2MODE3          0x08
#define _T2HLT_MODE4            0x10
#define _T2HLT_T2MODE4          0x10
#define _T2HLT_CKSYNC           0x20
#define _T2HLT_T2CKSYNC         0x20
#define _T2HLT_CKPOL            0x40
#define _T2HLT_T2CKPOL          0x40
#define _T2HLT_PSYNC            0x80
#define _T2HLT_T2PSYNC          0x80

//==============================================================================


//==============================================================================
//        T2CLKCON Bits

extern __at(0x001E) __sfr T2CLKCON;

typedef union
  {
  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CS0              : 1;
    unsigned T2CS1              : 1;
    unsigned T2CS2              : 1;
    unsigned T2CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T2CS               : 4;
    unsigned                    : 4;
    };
  } __T2CLKCONbits_t;

extern __at(0x001E) volatile __T2CLKCONbits_t T2CLKCONbits;

#define _T2CLKCON_CS0           0x01
#define _T2CLKCON_T2CS0         0x01
#define _T2CLKCON_CS1           0x02
#define _T2CLKCON_T2CS1         0x02
#define _T2CLKCON_CS2           0x04
#define _T2CLKCON_T2CS2         0x04
#define _T2CLKCON_CS3           0x08
#define _T2CLKCON_T2CS3         0x08

//==============================================================================


//==============================================================================
//        T2RST Bits

extern __at(0x001F) __sfr T2RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2RSEL0            : 1;
    unsigned T2RSEL1            : 1;
    unsigned T2RSEL2            : 1;
    unsigned T2RSEL3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RSEL               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T2RSEL             : 4;
    unsigned                    : 4;
    };
  } __T2RSTbits_t;

extern __at(0x001F) volatile __T2RSTbits_t T2RSTbits;

#define _RSEL0                  0x01
#define _T2RSEL0                0x01
#define _RSEL1                  0x02
#define _T2RSEL1                0x02
#define _RSEL2                  0x04
#define _T2RSEL2                0x04
#define _RSEL3                  0x08
#define _T2RSEL3                0x08

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 6;
    unsigned                    : 2;
    };
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x008D) __sfr TRISB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x008D) volatile __TRISBbits_t TRISBbits;

#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0090) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned SSP1IE               : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned TMR1GIE              : 1;
  } __PIE1bits_t;

extern __at(0x0090) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSP1IE                 0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0091) __sfr PIE2;

typedef struct
  {
  unsigned CCP2IE               : 1;
  unsigned TMR4IE               : 1;
  unsigned TMR6IE               : 1;
  unsigned BCL1IE               : 1;
  unsigned                      : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned OSCFIE               : 1;
  } __PIE2bits_t;

extern __at(0x0091) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _TMR4IE                 0x02
#define _TMR6IE                 0x04
#define _BCL1IE                 0x08
#define _C1IE                   0x20
#define _C2IE                   0x40
#define _OSCFIE                 0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0092) __sfr PIE3;

typedef struct
  {
  unsigned CLC1IE               : 1;
  unsigned CLC2IE               : 1;
  unsigned CLC3IE               : 1;
  unsigned CLC4IE               : 1;
  unsigned ZCDIE                : 1;
  unsigned CWGIE                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0092) volatile __PIE3bits_t PIE3bits;

#define _CLC1IE                 0x01
#define _CLC2IE                 0x02
#define _CLC3IE                 0x04
#define _CLC4IE                 0x08
#define _ZCDIE                  0x10
#define _CWGIE                  0x20

//==============================================================================


//==============================================================================
//        PIE4 Bits

extern __at(0x0093) __sfr PIE4;

typedef struct
  {
  unsigned SMT1IE               : 1;
  unsigned SMT1PRAIE            : 1;
  unsigned SMT1PWAIE            : 1;
  unsigned SMT2IE               : 1;
  unsigned SMT2PRAIE            : 1;
  unsigned SMT2PWAIE            : 1;
  unsigned CRCIE                : 1;
  unsigned SCANIE               : 1;
  } __PIE4bits_t;

extern __at(0x0093) volatile __PIE4bits_t PIE4bits;

#define _SMT1IE                 0x01
#define _SMT1PRAIE              0x02
#define _SMT1PWAIE              0x04
#define _SMT2IE                 0x08
#define _SMT2PRAIE              0x10
#define _SMT2PWAIE              0x20
#define _CRCIE                  0x40
#define _SCANIE                 0x80

//==============================================================================


//==============================================================================
//        PIE5 Bits

extern __at(0x0094) __sfr PIE5;

typedef struct
  {
  unsigned PID1DIE              : 1;
  unsigned PID1EIE              : 1;
  unsigned AT1IE                : 1;
  unsigned                      : 1;
  unsigned TMR5IE               : 1;
  unsigned TMR5GIE              : 1;
  unsigned TMR3IE               : 1;
  unsigned TMR3GIE              : 1;
  } __PIE5bits_t;

extern __at(0x0094) volatile __PIE5bits_t PIE5bits;

#define _PID1DIE                0x01
#define _PID1EIE                0x02
#define _AT1IE                  0x04
#define _TMR5IE                 0x10
#define _TMR5GIE                0x20
#define _TMR3IE                 0x40
#define _TMR3GIE                0x80

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _OPTION_REG_PS0         0x01
#define _OPTION_REG_PS1         0x02
#define _OPTION_REG_PS2         0x04
#define _OPTION_REG_PSA         0x08
#define _OPTION_REG_TMR0SE      0x10
#define _OPTION_REG_T0SE        0x10
#define _OPTION_REG_TMR0CS      0x20
#define _OPTION_REG_T0CS        0x20
#define _OPTION_REG_INTEDG      0x40
#define _OPTION_REG_NOT_WPUEN   0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned NOT_WDTWV            : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _NOT_WDTWV              0x20
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0098) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0098) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned SPLLEN             : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40
#define _SPLLEN                 0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned MFIOFR               : 1;
  unsigned HFIOFL               : 1;
  unsigned HFIOFR               : 1;
  unsigned OSTS                 : 1;
  unsigned PLLR                 : 1;
  unsigned                      : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _MFIOFR                 0x04
#define _HFIOFL                 0x08
#define _HFIOFR                 0x10
#define _OSTS                   0x20
#define _PLLR                   0x40

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _ADGO                   0x02
#define _GO                     0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON2 Bits

extern __at(0x009F) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned TRIGSEL3           : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 4;
    };
  } __ADCON2bits_t;

extern __at(0x009F) volatile __ADCON2bits_t ADCON2bits;

#define _TRIGSEL0               0x10
#define _TRIGSEL1               0x20
#define _TRIGSEL2               0x40
#define _TRIGSEL3               0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef union
  {
  struct
    {
    unsigned LATA0              : 1;
    unsigned LATA1              : 1;
    unsigned LATA2              : 1;
    unsigned LATA3              : 1;
    unsigned LATA4              : 1;
    unsigned LATA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATA               : 6;
    unsigned                    : 2;
    };
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x010D) __sfr LATB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x010D) volatile __LATBbits_t LATBbits;

#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0111) __sfr CM1CON0;

typedef struct
  {
  unsigned C1SYNC               : 1;
  unsigned C1HYS                : 1;
  unsigned C1SP                 : 1;
  unsigned                      : 1;
  unsigned C1POL                : 1;
  unsigned                      : 1;
  unsigned C1OUT                : 1;
  unsigned C1ON                 : 1;
  } __CM1CON0bits_t;

extern __at(0x0111) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1SYNC                 0x01
#define _C1HYS                  0x02
#define _C1SP                   0x04
#define _C1POL                  0x10
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0112) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned C1NCH0             : 1;
    unsigned C1NCH1             : 1;
    unsigned C1NCH2             : 1;
    unsigned                    : 1;
    unsigned C1PCH0             : 1;
    unsigned C1PCH1             : 1;
    unsigned C1INTN             : 1;
    unsigned C1INTP             : 1;
    };

  struct
    {
    unsigned C1NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C1PCH              : 2;
    unsigned                    : 2;
    };
  } __CM1CON1bits_t;

extern __at(0x0112) volatile __CM1CON1bits_t CM1CON1bits;

#define _C1NCH0                 0x01
#define _C1NCH1                 0x02
#define _C1NCH2                 0x04
#define _C1PCH0                 0x10
#define _C1PCH1                 0x20
#define _C1INTN                 0x40
#define _C1INTP                 0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0113) __sfr CM2CON0;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned C2HYS                : 1;
  unsigned C2SP                 : 1;
  unsigned                      : 1;
  unsigned C2POL                : 1;
  unsigned                      : 1;
  unsigned C2OUT                : 1;
  unsigned C2ON                 : 1;
  } __CM2CON0bits_t;

extern __at(0x0113) volatile __CM2CON0bits_t CM2CON0bits;

#define _C2SYNC                 0x01
#define _C2HYS                  0x02
#define _C2SP                   0x04
#define _C2POL                  0x10
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0114) __sfr CM2CON1;

typedef union
  {
  struct
    {
    unsigned C2NCH0             : 1;
    unsigned C2NCH1             : 1;
    unsigned C2NCH2             : 1;
    unsigned                    : 1;
    unsigned C2PCH0             : 1;
    unsigned C2PCH1             : 1;
    unsigned C2INTN             : 1;
    unsigned C2INTP             : 1;
    };

  struct
    {
    unsigned C2NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C2PCH              : 2;
    unsigned                    : 2;
    };
  } __CM2CON1bits_t;

extern __at(0x0114) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2NCH0                 0x01
#define _C2NCH1                 0x02
#define _C2NCH2                 0x04
#define _C2PCH0                 0x10
#define _C2PCH1                 0x20
#define _C2INTN                 0x40
#define _C2INTP                 0x80

//==============================================================================


//==============================================================================
//        CMOUT Bits

extern __at(0x0115) __sfr CMOUT;

typedef struct
  {
  unsigned MC1OUT               : 1;
  unsigned MC2OUT               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMOUTbits_t;

extern __at(0x0115) volatile __CMOUTbits_t CMOUTbits;

#define _MC1OUT                 0x01
#define _MC2OUT                 0x02

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned CDAFVR0            : 1;
    unsigned CDAFVR1            : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CDAFVR             : 2;
    unsigned                    : 4;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _CDAFVR0                0x04
#define _CDAFVR1                0x08
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        DAC1CON0 Bits

extern __at(0x0118) __sfr DAC1CON0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D1PSS0             : 1;
    unsigned D1PSS1             : 1;
    unsigned                    : 1;
    unsigned DAC1OE             : 1;
    unsigned                    : 1;
    unsigned DAC1EN             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned D1PSS              : 2;
    unsigned                    : 4;
    };
  } __DAC1CON0bits_t;

extern __at(0x0118) volatile __DAC1CON0bits_t DAC1CON0bits;

#define _D1PSS0                 0x04
#define _D1PSS1                 0x08
#define _DAC1OE                 0x20
#define _DAC1EN                 0x80

//==============================================================================


//==============================================================================
//        DAC1CON1 Bits

extern __at(0x0119) __sfr DAC1CON1;

typedef struct
  {
  unsigned DAC1R0               : 1;
  unsigned DAC1R1               : 1;
  unsigned DAC1R2               : 1;
  unsigned DAC1R3               : 1;
  unsigned DAC1R4               : 1;
  unsigned DAC1R5               : 1;
  unsigned DAC1R6               : 1;
  unsigned DAC1R7               : 1;
  } __DAC1CON1bits_t;

extern __at(0x0119) volatile __DAC1CON1bits_t DAC1CON1bits;

#define _DAC1R0                 0x01
#define _DAC1R1                 0x02
#define _DAC1R2                 0x04
#define _DAC1R3                 0x08
#define _DAC1R4                 0x10
#define _DAC1R5                 0x20
#define _DAC1R6                 0x40
#define _DAC1R7                 0x80

//==============================================================================


//==============================================================================
//        ZCD1CON Bits

extern __at(0x011C) __sfr ZCD1CON;

typedef struct
  {
  unsigned ZCD1INTN             : 1;
  unsigned ZCD1INTP             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ZCD1POL              : 1;
  unsigned ZCD1OUT              : 1;
  unsigned                      : 1;
  unsigned ZCD1EN               : 1;
  } __ZCD1CONbits_t;

extern __at(0x011C) volatile __ZCD1CONbits_t ZCD1CONbits;

#define _ZCD1INTN               0x01
#define _ZCD1INTP               0x02
#define _ZCD1POL                0x10
#define _ZCD1OUT                0x20
#define _ZCD1EN                 0x80

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned                      : 1;
  unsigned ANSA4                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA4                  0x10

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x018D) __sfr ANSELB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSB4                : 1;
  unsigned ANSB5                : 1;
  unsigned ANSB6                : 1;
  unsigned ANSB7                : 1;
  } __ANSELBbits_t;

extern __at(0x018D) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB4                  0x10
#define _ANSB5                  0x20
#define _ANSB6                  0x40
#define _ANSB7                  0x80

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x018E) __sfr ANSELC;

typedef struct
  {
  unsigned ANSC0                : 1;
  unsigned ANSC1                : 1;
  unsigned ANSC2                : 1;
  unsigned ANSC3                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSC6                : 1;
  unsigned ANSC7                : 1;
  } __ANSELCbits_t;

extern __at(0x018E) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC0                  0x01
#define _ANSC1                  0x02
#define _ANSC2                  0x04
#define _ANSC3                  0x08
#define _ANSC6                  0x40
#define _ANSC7                  0x80

//==============================================================================

extern __at(0x0191) __sfr PMADR;
extern __at(0x0191) __sfr PMADRL;
extern __at(0x0192) __sfr PMADRH;
extern __at(0x0193) __sfr PMDAT;
extern __at(0x0193) __sfr PMDATL;
extern __at(0x0194) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0195) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x0195) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0196) __sfr PMCON2;
extern __at(0x0199) __sfr RC1REG;
extern __at(0x0199) __sfr RCREG;
extern __at(0x0199) __sfr RCREG1;
extern __at(0x019A) __sfr TX1REG;
extern __at(0x019A) __sfr TXREG;
extern __at(0x019A) __sfr TXREG1;
extern __at(0x019B) __sfr SP1BRG;
extern __at(0x019B) __sfr SP1BRGL;
extern __at(0x019B) __sfr SPBRG;
extern __at(0x019B) __sfr SPBRG1;
extern __at(0x019B) __sfr SPBRGL;
extern __at(0x019C) __sfr SP1BRGH;
extern __at(0x019C) __sfr SPBRGH;
extern __at(0x019C) __sfr SPBRGH1;

//==============================================================================
//        RC1STA Bits

extern __at(0x019D) __sfr RC1STA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RC1STAbits_t;

extern __at(0x019D) volatile __RC1STAbits_t RC1STAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x019D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x019D) volatile __RCSTAbits_t RCSTAbits;

#define _RCSTA_RX9D             0x01
#define _RCSTA_OERR             0x02
#define _RCSTA_FERR             0x04
#define _RCSTA_ADDEN            0x08
#define _RCSTA_CREN             0x10
#define _RCSTA_SREN             0x20
#define _RCSTA_RX9              0x40
#define _RCSTA_SPEN             0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x019D) __sfr RCSTA1;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTA1bits_t;

extern __at(0x019D) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_SPEN            0x80

//==============================================================================


//==============================================================================
//        TX1STA Bits

extern __at(0x019E) __sfr TX1STA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TX1STAbits_t;

extern __at(0x019E) volatile __TX1STAbits_t TX1STAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x019E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x019E) volatile __TXSTAbits_t TXSTAbits;

#define _TXSTA_TX9D             0x01
#define _TXSTA_TRMT             0x02
#define _TXSTA_BRGH             0x04
#define _TXSTA_SENDB            0x08
#define _TXSTA_SYNC             0x10
#define _TXSTA_TXEN             0x20
#define _TXSTA_TX9              0x40
#define _TXSTA_CSRC             0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x019E) __sfr TXSTA1;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTA1bits_t;

extern __at(0x019E) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_CSRC            0x80

//==============================================================================


//==============================================================================
//        BAUD1CON Bits

extern __at(0x019F) __sfr BAUD1CON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUD1CONbits_t;

extern __at(0x019F) volatile __BAUD1CONbits_t BAUD1CONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x019F) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x019F) volatile __BAUDCONbits_t BAUDCONbits;

#define _BAUDCON_ABDEN          0x01
#define _BAUDCON_WUE            0x02
#define _BAUDCON_BRG16          0x08
#define _BAUDCON_SCKP           0x10
#define _BAUDCON_RCIDL          0x40
#define _BAUDCON_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x019F) __sfr BAUDCON1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON1bits_t;

extern __at(0x019F) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_SCKP          0x10
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x019F) __sfr BAUDCTL;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTLbits_t;

extern __at(0x019F) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_SCKP           0x10
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCTL1 Bits

extern __at(0x019F) __sfr BAUDCTL1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTL1bits_t;

extern __at(0x019F) volatile __BAUDCTL1bits_t BAUDCTL1bits;

#define _BAUDCTL1_ABDEN         0x01
#define _BAUDCTL1_WUE           0x02
#define _BAUDCTL1_BRG16         0x08
#define _BAUDCTL1_SCKP          0x10
#define _BAUDCTL1_RCIDL         0x40
#define _BAUDCTL1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x020C) __sfr WPUA;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned WPUA3              : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUA               : 6;
    unsigned                    : 2;
    };
  } __WPUAbits_t;

extern __at(0x020C) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x020D) __sfr WPUB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x020D) volatile __WPUBbits_t WPUBbits;

#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        WPUC Bits

extern __at(0x020E) __sfr WPUC;

typedef struct
  {
  unsigned WPUC0                : 1;
  unsigned WPUC1                : 1;
  unsigned WPUC2                : 1;
  unsigned WPUC3                : 1;
  unsigned WPUC4                : 1;
  unsigned WPUC5                : 1;
  unsigned WPUC6                : 1;
  unsigned WPUC7                : 1;
  } __WPUCbits_t;

extern __at(0x020E) volatile __WPUCbits_t WPUCbits;

#define _WPUC0                  0x01
#define _WPUC1                  0x02
#define _WPUC2                  0x04
#define _WPUC3                  0x08
#define _WPUC4                  0x10
#define _WPUC5                  0x20
#define _WPUC6                  0x40
#define _WPUC7                  0x80

//==============================================================================


//==============================================================================
//        SSP1BUF Bits

extern __at(0x0211) __sfr SSP1BUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSP1BUFbits_t;

extern __at(0x0211) volatile __SSP1BUFbits_t SSP1BUFbits;

#define _SSP1BUF0               0x01
#define _BUF0                   0x01
#define _SSP1BUF1               0x02
#define _BUF1                   0x02
#define _SSP1BUF2               0x04
#define _BUF2                   0x04
#define _SSP1BUF3               0x08
#define _BUF3                   0x08
#define _SSP1BUF4               0x10
#define _BUF4                   0x10
#define _SSP1BUF5               0x20
#define _BUF5                   0x20
#define _SSP1BUF6               0x40
#define _BUF6                   0x40
#define _SSP1BUF7               0x80
#define _BUF7                   0x80

//==============================================================================


//==============================================================================
//        SSPBUF Bits

extern __at(0x0211) __sfr SSPBUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSPBUFbits_t;

extern __at(0x0211) volatile __SSPBUFbits_t SSPBUFbits;

#define _SSPBUF_SSP1BUF0        0x01
#define _SSPBUF_BUF0            0x01
#define _SSPBUF_SSP1BUF1        0x02
#define _SSPBUF_BUF1            0x02
#define _SSPBUF_SSP1BUF2        0x04
#define _SSPBUF_BUF2            0x04
#define _SSPBUF_SSP1BUF3        0x08
#define _SSPBUF_BUF3            0x08
#define _SSPBUF_SSP1BUF4        0x10
#define _SSPBUF_BUF4            0x10
#define _SSPBUF_SSP1BUF5        0x20
#define _SSPBUF_BUF5            0x20
#define _SSPBUF_SSP1BUF6        0x40
#define _SSPBUF_BUF6            0x40
#define _SSPBUF_SSP1BUF7        0x80
#define _SSPBUF_BUF7            0x80

//==============================================================================


//==============================================================================
//        SSP1ADD Bits

extern __at(0x0212) __sfr SSP1ADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSP1ADDbits_t;

extern __at(0x0212) volatile __SSP1ADDbits_t SSP1ADDbits;

#define _SSP1ADD0               0x01
#define _ADD0                   0x01
#define _SSP1ADD1               0x02
#define _ADD1                   0x02
#define _SSP1ADD2               0x04
#define _ADD2                   0x04
#define _SSP1ADD3               0x08
#define _ADD3                   0x08
#define _SSP1ADD4               0x10
#define _ADD4                   0x10
#define _SSP1ADD5               0x20
#define _ADD5                   0x20
#define _SSP1ADD6               0x40
#define _ADD6                   0x40
#define _SSP1ADD7               0x80
#define _ADD7                   0x80

//==============================================================================


//==============================================================================
//        SSPADD Bits

extern __at(0x0212) __sfr SSPADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSPADDbits_t;

extern __at(0x0212) volatile __SSPADDbits_t SSPADDbits;

#define _SSPADD_SSP1ADD0        0x01
#define _SSPADD_ADD0            0x01
#define _SSPADD_SSP1ADD1        0x02
#define _SSPADD_ADD1            0x02
#define _SSPADD_SSP1ADD2        0x04
#define _SSPADD_ADD2            0x04
#define _SSPADD_SSP1ADD3        0x08
#define _SSPADD_ADD3            0x08
#define _SSPADD_SSP1ADD4        0x10
#define _SSPADD_ADD4            0x10
#define _SSPADD_SSP1ADD5        0x20
#define _SSPADD_ADD5            0x20
#define _SSPADD_SSP1ADD6        0x40
#define _SSPADD_ADD6            0x40
#define _SSPADD_SSP1ADD7        0x80
#define _SSPADD_ADD7            0x80

//==============================================================================


//==============================================================================
//        SSP1MSK Bits

extern __at(0x0213) __sfr SSP1MSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSP1MSKbits_t;

extern __at(0x0213) volatile __SSP1MSKbits_t SSP1MSKbits;

#define _SSP1MSK0               0x01
#define _MSK0                   0x01
#define _SSP1MSK1               0x02
#define _MSK1                   0x02
#define _SSP1MSK2               0x04
#define _MSK2                   0x04
#define _SSP1MSK3               0x08
#define _MSK3                   0x08
#define _SSP1MSK4               0x10
#define _MSK4                   0x10
#define _SSP1MSK5               0x20
#define _MSK5                   0x20
#define _SSP1MSK6               0x40
#define _MSK6                   0x40
#define _SSP1MSK7               0x80
#define _MSK7                   0x80

//==============================================================================


//==============================================================================
//        SSPMSK Bits

extern __at(0x0213) __sfr SSPMSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSPMSKbits_t;

extern __at(0x0213) volatile __SSPMSKbits_t SSPMSKbits;

#define _SSPMSK_SSP1MSK0        0x01
#define _SSPMSK_MSK0            0x01
#define _SSPMSK_SSP1MSK1        0x02
#define _SSPMSK_MSK1            0x02
#define _SSPMSK_SSP1MSK2        0x04
#define _SSPMSK_MSK2            0x04
#define _SSPMSK_SSP1MSK3        0x08
#define _SSPMSK_MSK3            0x08
#define _SSPMSK_SSP1MSK4        0x10
#define _SSPMSK_MSK4            0x10
#define _SSPMSK_SSP1MSK5        0x20
#define _SSPMSK_MSK5            0x20
#define _SSPMSK_SSP1MSK6        0x40
#define _SSPMSK_MSK6            0x40
#define _SSPMSK_SSP1MSK7        0x80
#define _SSPMSK_MSK7            0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x0214) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0214) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0214) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0214) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1CON Bits

extern __at(0x0215) __sfr SSP1CON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CONbits_t;

extern __at(0x0215) volatile __SSP1CONbits_t SSP1CONbits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0215) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0215) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSP1CON1_SSPM0         0x01
#define _SSP1CON1_SSPM1         0x02
#define _SSP1CON1_SSPM2         0x04
#define _SSP1CON1_SSPM3         0x08
#define _SSP1CON1_CKP           0x10
#define _SSP1CON1_SSPEN         0x20
#define _SSP1CON1_SSPOV         0x40
#define _SSP1CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0215) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0215) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSPM0           0x01
#define _SSPCON_SSPM1           0x02
#define _SSPCON_SSPM2           0x04
#define _SSPCON_SSPM3           0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0215) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0215) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0216) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0216) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0216) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0216) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0217) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0217) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0217) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0217) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================


//==============================================================================
//        ODCONA Bits

extern __at(0x028C) __sfr ODCONA;

typedef struct
  {
  unsigned ODA0                 : 1;
  unsigned ODA1                 : 1;
  unsigned ODA2                 : 1;
  unsigned                      : 1;
  unsigned ODA4                 : 1;
  unsigned ODA5                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ODCONAbits_t;

extern __at(0x028C) volatile __ODCONAbits_t ODCONAbits;

#define _ODA0                   0x01
#define _ODA1                   0x02
#define _ODA2                   0x04
#define _ODA4                   0x10
#define _ODA5                   0x20

//==============================================================================


//==============================================================================
//        ODCONB Bits

extern __at(0x028D) __sfr ODCONB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ODB4                 : 1;
  unsigned ODB5                 : 1;
  unsigned ODB6                 : 1;
  unsigned ODB7                 : 1;
  } __ODCONBbits_t;

extern __at(0x028D) volatile __ODCONBbits_t ODCONBbits;

#define _ODB4                   0x10
#define _ODB5                   0x20
#define _ODB6                   0x40
#define _ODB7                   0x80

//==============================================================================


//==============================================================================
//        ODCONC Bits

extern __at(0x028E) __sfr ODCONC;

typedef struct
  {
  unsigned ODC0                 : 1;
  unsigned ODC1                 : 1;
  unsigned ODC2                 : 1;
  unsigned ODC3                 : 1;
  unsigned ODC4                 : 1;
  unsigned ODC5                 : 1;
  unsigned ODC6                 : 1;
  unsigned ODC7                 : 1;
  } __ODCONCbits_t;

extern __at(0x028E) volatile __ODCONCbits_t ODCONCbits;

#define _ODC0                   0x01
#define _ODC1                   0x02
#define _ODC2                   0x04
#define _ODC3                   0x08
#define _ODC4                   0x10
#define _ODC5                   0x20
#define _ODC6                   0x40
#define _ODC7                   0x80

//==============================================================================

extern __at(0x0291) __sfr CCPR1;
extern __at(0x0291) __sfr CCPR1L;
extern __at(0x0292) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0293) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned FMT                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CCP1MODE0          : 1;
    unsigned CCP1MODE1          : 1;
    unsigned CCP1MODE2          : 1;
    unsigned CCP1MODE3          : 1;
    unsigned CCP1FMT            : 1;
    unsigned CCP1OUT            : 1;
    unsigned                    : 1;
    unsigned CCP1EN             : 1;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CCP1MODE           : 4;
    unsigned                    : 4;
    };
  } __CCP1CONbits_t;

extern __at(0x0293) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1CON_MODE0          0x01
#define _CCP1CON_CCP1MODE0      0x01
#define _CCP1CON_MODE1          0x02
#define _CCP1CON_CCP1MODE1      0x02
#define _CCP1CON_MODE2          0x04
#define _CCP1CON_CCP1MODE2      0x04
#define _CCP1CON_MODE3          0x08
#define _CCP1CON_CCP1MODE3      0x08
#define _CCP1CON_FMT            0x10
#define _CCP1CON_CCP1FMT        0x10
#define _CCP1CON_OUT            0x20
#define _CCP1CON_CCP1OUT        0x20
#define _CCP1CON_EN             0x80
#define _CCP1CON_CCP1EN         0x80

//==============================================================================


//==============================================================================
//        CCP1CAP Bits

extern __at(0x0294) __sfr CCP1CAP;

typedef union
  {
  struct
    {
    unsigned CTS0               : 1;
    unsigned CTS1               : 1;
    unsigned CTS2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1CTS0           : 1;
    unsigned CCP1CTS1           : 1;
    unsigned CCP1CTS2           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1CTS            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CTS                : 3;
    unsigned                    : 5;
    };
  } __CCP1CAPbits_t;

extern __at(0x0294) volatile __CCP1CAPbits_t CCP1CAPbits;

#define _CTS0                   0x01
#define _CCP1CTS0               0x01
#define _CTS1                   0x02
#define _CCP1CTS1               0x02
#define _CTS2                   0x04
#define _CCP1CTS2               0x04

//==============================================================================

extern __at(0x0298) __sfr CCPR2;
extern __at(0x0298) __sfr CCPR2L;
extern __at(0x0299) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x029A) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned FMT                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CCP2MODE0          : 1;
    unsigned CCP2MODE1          : 1;
    unsigned CCP2MODE2          : 1;
    unsigned CCP2MODE3          : 1;
    unsigned CCP2FMT            : 1;
    unsigned CCP2OUT            : 1;
    unsigned                    : 1;
    unsigned CCP2EN             : 1;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CCP2MODE           : 4;
    unsigned                    : 4;
    };
  } __CCP2CONbits_t;

extern __at(0x029A) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2CON_MODE0          0x01
#define _CCP2CON_CCP2MODE0      0x01
#define _CCP2CON_MODE1          0x02
#define _CCP2CON_CCP2MODE1      0x02
#define _CCP2CON_MODE2          0x04
#define _CCP2CON_CCP2MODE2      0x04
#define _CCP2CON_MODE3          0x08
#define _CCP2CON_CCP2MODE3      0x08
#define _CCP2CON_FMT            0x10
#define _CCP2CON_CCP2FMT        0x10
#define _CCP2CON_OUT            0x20
#define _CCP2CON_CCP2OUT        0x20
#define _CCP2CON_EN             0x80
#define _CCP2CON_CCP2EN         0x80

//==============================================================================


//==============================================================================
//        CCP2CAP Bits

extern __at(0x029B) __sfr CCP2CAP;

typedef union
  {
  struct
    {
    unsigned CTS0               : 1;
    unsigned CTS1               : 1;
    unsigned CTS2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2CTS0           : 1;
    unsigned CCP2CTS1           : 1;
    unsigned CCP2CTS2           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CTS                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CCP2CTS            : 3;
    unsigned                    : 5;
    };
  } __CCP2CAPbits_t;

extern __at(0x029B) volatile __CCP2CAPbits_t CCP2CAPbits;

#define _CCP2CAP_CTS0           0x01
#define _CCP2CAP_CCP2CTS0       0x01
#define _CCP2CAP_CTS1           0x02
#define _CCP2CAP_CCP2CTS1       0x02
#define _CCP2CAP_CTS2           0x04
#define _CCP2CAP_CCP2CTS2       0x04

//==============================================================================


//==============================================================================
//        CCPTMRS Bits

extern __at(0x029E) __sfr CCPTMRS;

typedef union
  {
  struct
    {
    unsigned CCP1TSEL0          : 1;
    unsigned CCP1TSEL1          : 1;
    unsigned CCP2TSEL0          : 1;
    unsigned CCP2TSEL1          : 1;
    unsigned P3TSEL0            : 1;
    unsigned P3TSEL1            : 1;
    unsigned P4TSEL0            : 1;
    unsigned P4TSEL1            : 1;
    };

  struct
    {
    unsigned CCP1TSEL           : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CCP2TSEL           : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned P3TSEL             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P4TSEL             : 2;
    };
  } __CCPTMRSbits_t;

extern __at(0x029E) volatile __CCPTMRSbits_t CCPTMRSbits;

#define _CCP1TSEL0              0x01
#define _CCP1TSEL1              0x02
#define _CCP2TSEL0              0x04
#define _CCP2TSEL1              0x08
#define _P3TSEL0                0x10
#define _P3TSEL1                0x20
#define _P4TSEL0                0x40
#define _P4TSEL1                0x80

//==============================================================================


//==============================================================================
//        SLRCONA Bits

extern __at(0x030C) __sfr SLRCONA;

typedef struct
  {
  unsigned SLRA0                : 1;
  unsigned SLRA1                : 1;
  unsigned SLRA2                : 1;
  unsigned                      : 1;
  unsigned SLRA4                : 1;
  unsigned SLRA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __SLRCONAbits_t;

extern __at(0x030C) volatile __SLRCONAbits_t SLRCONAbits;

#define _SLRA0                  0x01
#define _SLRA1                  0x02
#define _SLRA2                  0x04
#define _SLRA4                  0x10
#define _SLRA5                  0x20

//==============================================================================


//==============================================================================
//        SLRCONB Bits

extern __at(0x030D) __sfr SLRCONB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned SLRB4                : 1;
  unsigned SLRB5                : 1;
  unsigned SLRB6                : 1;
  unsigned SLRB7                : 1;
  } __SLRCONBbits_t;

extern __at(0x030D) volatile __SLRCONBbits_t SLRCONBbits;

#define _SLRB4                  0x10
#define _SLRB5                  0x20
#define _SLRB6                  0x40
#define _SLRB7                  0x80

//==============================================================================


//==============================================================================
//        SLRCONC Bits

extern __at(0x030E) __sfr SLRCONC;

typedef struct
  {
  unsigned SLRC0                : 1;
  unsigned SLRC1                : 1;
  unsigned SLRC2                : 1;
  unsigned SLRC3                : 1;
  unsigned SLRC4                : 1;
  unsigned SLRC5                : 1;
  unsigned SLRC6                : 1;
  unsigned SLRC7                : 1;
  } __SLRCONCbits_t;

extern __at(0x030E) volatile __SLRCONCbits_t SLRCONCbits;

#define _SLRC0                  0x01
#define _SLRC1                  0x02
#define _SLRC2                  0x04
#define _SLRC3                  0x08
#define _SLRC4                  0x10
#define _SLRC5                  0x20
#define _SLRC6                  0x40
#define _SLRC7                  0x80

//==============================================================================


//==============================================================================
//        INLVLA Bits

extern __at(0x038C) __sfr INLVLA;

typedef union
  {
  struct
    {
    unsigned INLVLA0            : 1;
    unsigned INLVLA1            : 1;
    unsigned INLVLA2            : 1;
    unsigned INLVLA3            : 1;
    unsigned INLVLA4            : 1;
    unsigned INLVLA5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INLVLA             : 6;
    unsigned                    : 2;
    };
  } __INLVLAbits_t;

extern __at(0x038C) volatile __INLVLAbits_t INLVLAbits;

#define _INLVLA0                0x01
#define _INLVLA1                0x02
#define _INLVLA2                0x04
#define _INLVLA3                0x08
#define _INLVLA4                0x10
#define _INLVLA5                0x20

//==============================================================================


//==============================================================================
//        INLVLB Bits

extern __at(0x038D) __sfr INLVLB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned INLVLB4              : 1;
  unsigned INLVLB5              : 1;
  unsigned INLVLB6              : 1;
  unsigned INLVLB7              : 1;
  } __INLVLBbits_t;

extern __at(0x038D) volatile __INLVLBbits_t INLVLBbits;

#define _INLVLB4                0x10
#define _INLVLB5                0x20
#define _INLVLB6                0x40
#define _INLVLB7                0x80

//==============================================================================


//==============================================================================
//        INLVLC Bits

extern __at(0x038E) __sfr INLVLC;

typedef struct
  {
  unsigned INLVLC0              : 1;
  unsigned INLVLC1              : 1;
  unsigned INLVLC2              : 1;
  unsigned INLVLC3              : 1;
  unsigned INLVLC4              : 1;
  unsigned INLVLC5              : 1;
  unsigned INLVLC6              : 1;
  unsigned INLVLC7              : 1;
  } __INLVLCbits_t;

extern __at(0x038E) volatile __INLVLCbits_t INLVLCbits;

#define _INLVLC0                0x01
#define _INLVLC1                0x02
#define _INLVLC2                0x04
#define _INLVLC3                0x08
#define _INLVLC4                0x10
#define _INLVLC5                0x20
#define _INLVLC6                0x40
#define _INLVLC7                0x80

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0391) __sfr IOCAP;

typedef union
  {
  struct
    {
    unsigned IOCAP0             : 1;
    unsigned IOCAP1             : 1;
    unsigned IOCAP2             : 1;
    unsigned IOCAP3             : 1;
    unsigned IOCAP4             : 1;
    unsigned IOCAP5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAP              : 6;
    unsigned                    : 2;
    };
  } __IOCAPbits_t;

extern __at(0x0391) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0392) __sfr IOCAN;

typedef union
  {
  struct
    {
    unsigned IOCAN0             : 1;
    unsigned IOCAN1             : 1;
    unsigned IOCAN2             : 1;
    unsigned IOCAN3             : 1;
    unsigned IOCAN4             : 1;
    unsigned IOCAN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAN              : 6;
    unsigned                    : 2;
    };
  } __IOCANbits_t;

extern __at(0x0392) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0393) __sfr IOCAF;

typedef union
  {
  struct
    {
    unsigned IOCAF0             : 1;
    unsigned IOCAF1             : 1;
    unsigned IOCAF2             : 1;
    unsigned IOCAF3             : 1;
    unsigned IOCAF4             : 1;
    unsigned IOCAF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAF              : 6;
    unsigned                    : 2;
    };
  } __IOCAFbits_t;

extern __at(0x0393) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20

//==============================================================================


//==============================================================================
//        IOCBP Bits

extern __at(0x0394) __sfr IOCBP;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBP4               : 1;
  unsigned IOCBP5               : 1;
  unsigned IOCBP6               : 1;
  unsigned IOCBP7               : 1;
  } __IOCBPbits_t;

extern __at(0x0394) volatile __IOCBPbits_t IOCBPbits;

#define _IOCBP4                 0x10
#define _IOCBP5                 0x20
#define _IOCBP6                 0x40
#define _IOCBP7                 0x80

//==============================================================================


//==============================================================================
//        IOCBN Bits

extern __at(0x0395) __sfr IOCBN;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBN4               : 1;
  unsigned IOCBN5               : 1;
  unsigned IOCBN6               : 1;
  unsigned IOCBN7               : 1;
  } __IOCBNbits_t;

extern __at(0x0395) volatile __IOCBNbits_t IOCBNbits;

#define _IOCBN4                 0x10
#define _IOCBN5                 0x20
#define _IOCBN6                 0x40
#define _IOCBN7                 0x80

//==============================================================================


//==============================================================================
//        IOCBF Bits

extern __at(0x0396) __sfr IOCBF;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBF4               : 1;
  unsigned IOCBF5               : 1;
  unsigned IOCBF6               : 1;
  unsigned IOCBF7               : 1;
  } __IOCBFbits_t;

extern __at(0x0396) volatile __IOCBFbits_t IOCBFbits;

#define _IOCBF4                 0x10
#define _IOCBF5                 0x20
#define _IOCBF6                 0x40
#define _IOCBF7                 0x80

//==============================================================================


//==============================================================================
//        IOCCP Bits

extern __at(0x0397) __sfr IOCCP;

typedef struct
  {
  unsigned IOCCP0               : 1;
  unsigned IOCCP1               : 1;
  unsigned IOCCP2               : 1;
  unsigned IOCCP3               : 1;
  unsigned IOCCP4               : 1;
  unsigned IOCCP5               : 1;
  unsigned IOCCP6               : 1;
  unsigned IOCCP7               : 1;
  } __IOCCPbits_t;

extern __at(0x0397) volatile __IOCCPbits_t IOCCPbits;

#define _IOCCP0                 0x01
#define _IOCCP1                 0x02
#define _IOCCP2                 0x04
#define _IOCCP3                 0x08
#define _IOCCP4                 0x10
#define _IOCCP5                 0x20
#define _IOCCP6                 0x40
#define _IOCCP7                 0x80

//==============================================================================


//==============================================================================
//        IOCCN Bits

extern __at(0x0398) __sfr IOCCN;

typedef struct
  {
  unsigned IOCCN0               : 1;
  unsigned IOCCN1               : 1;
  unsigned IOCCN2               : 1;
  unsigned IOCCN3               : 1;
  unsigned IOCCN4               : 1;
  unsigned IOCCN5               : 1;
  unsigned IOCCN6               : 1;
  unsigned IOCCN7               : 1;
  } __IOCCNbits_t;

extern __at(0x0398) volatile __IOCCNbits_t IOCCNbits;

#define _IOCCN0                 0x01
#define _IOCCN1                 0x02
#define _IOCCN2                 0x04
#define _IOCCN3                 0x08
#define _IOCCN4                 0x10
#define _IOCCN5                 0x20
#define _IOCCN6                 0x40
#define _IOCCN7                 0x80

//==============================================================================


//==============================================================================
//        IOCCF Bits

extern __at(0x0399) __sfr IOCCF;

typedef struct
  {
  unsigned IOCCF0               : 1;
  unsigned IOCCF1               : 1;
  unsigned IOCCF2               : 1;
  unsigned IOCCF3               : 1;
  unsigned IOCCF4               : 1;
  unsigned IOCCF5               : 1;
  unsigned IOCCF6               : 1;
  unsigned IOCCF7               : 1;
  } __IOCCFbits_t;

extern __at(0x0399) volatile __IOCCFbits_t IOCCFbits;

#define _IOCCF0                 0x01
#define _IOCCF1                 0x02
#define _IOCCF2                 0x04
#define _IOCCF3                 0x08
#define _IOCCF4                 0x10
#define _IOCCF5                 0x20
#define _IOCCF6                 0x40
#define _IOCCF7                 0x80

//==============================================================================


//==============================================================================
//        HDRVC Bits

extern __at(0x040E) __sfr HDRVC;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned HIDC4                : 1;
  unsigned HIDC5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __HDRVCbits_t;

extern __at(0x040E) volatile __HDRVCbits_t HDRVCbits;

#define _HIDC4                  0x10
#define _HIDC5                  0x20

//==============================================================================

extern __at(0x0413) __sfr T4TMR;
extern __at(0x0413) __sfr TMR4;
extern __at(0x0414) __sfr PR4;
extern __at(0x0414) __sfr T4PR;

//==============================================================================
//        T4CON Bits

extern __at(0x0415) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned T4CKPS2            : 1;
    unsigned T4ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR4ON             : 1;
    };

  struct
    {
    unsigned T4OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T4CKPS             : 3;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0415) volatile __T4CONbits_t T4CONbits;

#define _T4CON_OUTPS0           0x01
#define _T4CON_T4OUTPS0         0x01
#define _T4CON_OUTPS1           0x02
#define _T4CON_T4OUTPS1         0x02
#define _T4CON_OUTPS2           0x04
#define _T4CON_T4OUTPS2         0x04
#define _T4CON_OUTPS3           0x08
#define _T4CON_T4OUTPS3         0x08
#define _T4CON_CKPS0            0x10
#define _T4CON_T4CKPS0          0x10
#define _T4CON_CKPS1            0x20
#define _T4CON_T4CKPS1          0x20
#define _T4CON_CKPS2            0x40
#define _T4CON_T4CKPS2          0x40
#define _T4CON_ON               0x80
#define _T4CON_T4ON             0x80
#define _T4CON_TMR4ON           0x80

//==============================================================================


//==============================================================================
//        T4HLT Bits

extern __at(0x0416) __sfr T4HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned MODE4              : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T4MODE0            : 1;
    unsigned T4MODE1            : 1;
    unsigned T4MODE2            : 1;
    unsigned T4MODE3            : 1;
    unsigned T4MODE4            : 1;
    unsigned T4CKSYNC           : 1;
    unsigned T4CKPOL            : 1;
    unsigned T4PSYNC            : 1;
    };

  struct
    {
    unsigned T4MODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MODE               : 5;
    unsigned                    : 3;
    };
  } __T4HLTbits_t;

extern __at(0x0416) volatile __T4HLTbits_t T4HLTbits;

#define _T4HLT_MODE0            0x01
#define _T4HLT_T4MODE0          0x01
#define _T4HLT_MODE1            0x02
#define _T4HLT_T4MODE1          0x02
#define _T4HLT_MODE2            0x04
#define _T4HLT_T4MODE2          0x04
#define _T4HLT_MODE3            0x08
#define _T4HLT_T4MODE3          0x08
#define _T4HLT_MODE4            0x10
#define _T4HLT_T4MODE4          0x10
#define _T4HLT_CKSYNC           0x20
#define _T4HLT_T4CKSYNC         0x20
#define _T4HLT_CKPOL            0x40
#define _T4HLT_T4CKPOL          0x40
#define _T4HLT_PSYNC            0x80
#define _T4HLT_T4PSYNC          0x80

//==============================================================================


//==============================================================================
//        T4CLKCON Bits

extern __at(0x0417) __sfr T4CLKCON;

typedef union
  {
  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CS0              : 1;
    unsigned T4CS1              : 1;
    unsigned T4CS2              : 1;
    unsigned T4CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T4CS               : 4;
    unsigned                    : 4;
    };
  } __T4CLKCONbits_t;

extern __at(0x0417) volatile __T4CLKCONbits_t T4CLKCONbits;

#define _T4CLKCON_CS0           0x01
#define _T4CLKCON_T4CS0         0x01
#define _T4CLKCON_CS1           0x02
#define _T4CLKCON_T4CS1         0x02
#define _T4CLKCON_CS2           0x04
#define _T4CLKCON_T4CS2         0x04
#define _T4CLKCON_CS3           0x08
#define _T4CLKCON_T4CS3         0x08

//==============================================================================


//==============================================================================
//        T4RST Bits

extern __at(0x0418) __sfr T4RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4RSEL0            : 1;
    unsigned T4RSEL1            : 1;
    unsigned T4RSEL2            : 1;
    unsigned T4RSEL3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RSEL               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T4RSEL             : 4;
    unsigned                    : 4;
    };
  } __T4RSTbits_t;

extern __at(0x0418) volatile __T4RSTbits_t T4RSTbits;

#define _T4RST_RSEL0            0x01
#define _T4RST_T4RSEL0          0x01
#define _T4RST_RSEL1            0x02
#define _T4RST_T4RSEL1          0x02
#define _T4RST_RSEL2            0x04
#define _T4RST_T4RSEL2          0x04
#define _T4RST_RSEL3            0x08
#define _T4RST_T4RSEL3          0x08

//==============================================================================

extern __at(0x041A) __sfr T6TMR;
extern __at(0x041A) __sfr TMR6;
extern __at(0x041B) __sfr PR6;
extern __at(0x041B) __sfr T6PR;

//==============================================================================
//        T6CON Bits

extern __at(0x041C) __sfr T6CON;

typedef union
  {
  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned T6OUTPS0           : 1;
    unsigned T6OUTPS1           : 1;
    unsigned T6OUTPS2           : 1;
    unsigned T6OUTPS3           : 1;
    unsigned T6CKPS0            : 1;
    unsigned T6CKPS1            : 1;
    unsigned T6CKPS2            : 1;
    unsigned T6ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR6ON             : 1;
    };

  struct
    {
    unsigned T6OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T6CKPS             : 3;
    unsigned                    : 1;
    };
  } __T6CONbits_t;

extern __at(0x041C) volatile __T6CONbits_t T6CONbits;

#define _T6CON_OUTPS0           0x01
#define _T6CON_T6OUTPS0         0x01
#define _T6CON_OUTPS1           0x02
#define _T6CON_T6OUTPS1         0x02
#define _T6CON_OUTPS2           0x04
#define _T6CON_T6OUTPS2         0x04
#define _T6CON_OUTPS3           0x08
#define _T6CON_T6OUTPS3         0x08
#define _T6CON_CKPS0            0x10
#define _T6CON_T6CKPS0          0x10
#define _T6CON_CKPS1            0x20
#define _T6CON_T6CKPS1          0x20
#define _T6CON_CKPS2            0x40
#define _T6CON_T6CKPS2          0x40
#define _T6CON_ON               0x80
#define _T6CON_T6ON             0x80
#define _T6CON_TMR6ON           0x80

//==============================================================================


//==============================================================================
//        T6HLT Bits

extern __at(0x041D) __sfr T6HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned MODE4              : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T6MODE0            : 1;
    unsigned T6MODE1            : 1;
    unsigned T6MODE2            : 1;
    unsigned T6MODE3            : 1;
    unsigned T6MODE4            : 1;
    unsigned T6CKSYNC           : 1;
    unsigned T6CKPOL            : 1;
    unsigned T6PSYNC            : 1;
    };

  struct
    {
    unsigned T6MODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MODE               : 5;
    unsigned                    : 3;
    };
  } __T6HLTbits_t;

extern __at(0x041D) volatile __T6HLTbits_t T6HLTbits;

#define _T6HLT_MODE0            0x01
#define _T6HLT_T6MODE0          0x01
#define _T6HLT_MODE1            0x02
#define _T6HLT_T6MODE1          0x02
#define _T6HLT_MODE2            0x04
#define _T6HLT_T6MODE2          0x04
#define _T6HLT_MODE3            0x08
#define _T6HLT_T6MODE3          0x08
#define _T6HLT_MODE4            0x10
#define _T6HLT_T6MODE4          0x10
#define _T6HLT_CKSYNC           0x20
#define _T6HLT_T6CKSYNC         0x20
#define _T6HLT_CKPOL            0x40
#define _T6HLT_T6CKPOL          0x40
#define _T6HLT_PSYNC            0x80
#define _T6HLT_T6PSYNC          0x80

//==============================================================================


//==============================================================================
//        T6CLKCON Bits

extern __at(0x041E) __sfr T6CLKCON;

typedef union
  {
  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6CS0              : 1;
    unsigned T6CS1              : 1;
    unsigned T6CS2              : 1;
    unsigned T6CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T6CS               : 4;
    unsigned                    : 4;
    };
  } __T6CLKCONbits_t;

extern __at(0x041E) volatile __T6CLKCONbits_t T6CLKCONbits;

#define _T6CLKCON_CS0           0x01
#define _T6CLKCON_T6CS0         0x01
#define _T6CLKCON_CS1           0x02
#define _T6CLKCON_T6CS1         0x02
#define _T6CLKCON_CS2           0x04
#define _T6CLKCON_T6CS2         0x04
#define _T6CLKCON_CS3           0x08
#define _T6CLKCON_T6CS3         0x08

//==============================================================================


//==============================================================================
//        T6RST Bits

extern __at(0x041F) __sfr T6RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6RSEL0            : 1;
    unsigned T6RSEL1            : 1;
    unsigned T6RSEL2            : 1;
    unsigned T6RSEL3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RSEL               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T6RSEL             : 4;
    unsigned                    : 4;
    };
  } __T6RSTbits_t;

extern __at(0x041F) volatile __T6RSTbits_t T6RSTbits;

#define _T6RST_RSEL0            0x01
#define _T6RST_T6RSEL0          0x01
#define _T6RST_RSEL1            0x02
#define _T6RST_T6RSEL1          0x02
#define _T6RST_RSEL2            0x04
#define _T6RST_T6RSEL2          0x04
#define _T6RST_RSEL3            0x08
#define _T6RST_T6RSEL3          0x08

//==============================================================================

extern __at(0x0493) __sfr TMR3;
extern __at(0x0493) __sfr TMR3L;
extern __at(0x0494) __sfr TMR3H;

//==============================================================================
//        T3CON Bits

extern __at(0x0495) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned                    : 1;
    unsigned T3SYNC             : 1;
    unsigned                    : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned TMR3CS0            : 1;
    unsigned TMR3CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR3CS             : 2;
    };
  } __T3CONbits_t;

extern __at(0x0495) volatile __T3CONbits_t T3CONbits;

#define _TMR3ON                 0x01
#define _T3SYNC                 0x04
#define _T3CKPS0                0x10
#define _T3CKPS1                0x20
#define _TMR3CS0                0x40
#define _TMR3CS1                0x80

//==============================================================================


//==============================================================================
//        T3GCON Bits

extern __at(0x0496) __sfr T3GCON;

typedef union
  {
  struct
    {
    unsigned T3GSS0             : 1;
    unsigned T3GSS1             : 1;
    unsigned T3GVAL             : 1;
    unsigned T3GGO_NOT_DONE     : 1;
    unsigned T3GSPM             : 1;
    unsigned T3GTM              : 1;
    unsigned T3GPOL             : 1;
    unsigned TMR3GE             : 1;
    };

  struct
    {
    unsigned T3GSS              : 2;
    unsigned                    : 6;
    };
  } __T3GCONbits_t;

extern __at(0x0496) volatile __T3GCONbits_t T3GCONbits;

#define _T3GSS0                 0x01
#define _T3GSS1                 0x02
#define _T3GVAL                 0x04
#define _T3GGO_NOT_DONE         0x08
#define _T3GSPM                 0x10
#define _T3GTM                  0x20
#define _T3GPOL                 0x40
#define _TMR3GE                 0x80

//==============================================================================

extern __at(0x049A) __sfr TMR5L;
extern __at(0x049B) __sfr TMR5H;

//==============================================================================
//        T5CON Bits

extern __at(0x049C) __sfr T5CON;

typedef union
  {
  struct
    {
    unsigned TMR5ON             : 1;
    unsigned                    : 1;
    unsigned T5SYNC             : 1;
    unsigned                    : 1;
    unsigned T5CKPS0            : 1;
    unsigned T5CKPS1            : 1;
    unsigned TMR5CS0            : 1;
    unsigned TMR5CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T5CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR5CS             : 2;
    };
  } __T5CONbits_t;

extern __at(0x049C) volatile __T5CONbits_t T5CONbits;

#define _TMR5ON                 0x01
#define _T5SYNC                 0x04
#define _T5CKPS0                0x10
#define _T5CKPS1                0x20
#define _TMR5CS0                0x40
#define _TMR5CS1                0x80

//==============================================================================


//==============================================================================
//        T5GCON Bits

extern __at(0x049D) __sfr T5GCON;

typedef union
  {
  struct
    {
    unsigned T5GSS0             : 1;
    unsigned T5GSS1             : 1;
    unsigned T5GVAL             : 1;
    unsigned T5GGO_NOT_DONE     : 1;
    unsigned T5GSPM             : 1;
    unsigned T5GTM              : 1;
    unsigned T5GPOL             : 1;
    unsigned TMR5GE             : 1;
    };

  struct
    {
    unsigned T5GSS              : 2;
    unsigned                    : 6;
    };
  } __T5GCONbits_t;

extern __at(0x049D) volatile __T5GCONbits_t T5GCONbits;

#define _T5GSS0                 0x01
#define _T5GSS1                 0x02
#define _T5GVAL                 0x04
#define _T5GGO_NOT_DONE         0x08
#define _T5GSPM                 0x10
#define _T5GTM                  0x20
#define _T5GPOL                 0x40
#define _TMR5GE                 0x80

//==============================================================================

extern __at(0x058C) __sfr PID1SET;

//==============================================================================
//        PID1SETL Bits

extern __at(0x058C) __sfr PID1SETL;

typedef union
  {
  struct
    {
    unsigned PID1SET0           : 1;
    unsigned PID1SET1           : 1;
    unsigned PID1SET2           : 1;
    unsigned PID1SET3           : 1;
    unsigned PID1SET4           : 1;
    unsigned PID1SET5           : 1;
    unsigned PID1SET6           : 1;
    unsigned PID1SET7           : 1;
    };

  struct
    {
    unsigned SET0               : 1;
    unsigned SET1               : 1;
    unsigned SET2               : 1;
    unsigned SET3               : 1;
    unsigned SET4               : 1;
    unsigned SET5               : 1;
    unsigned SET6               : 1;
    unsigned SET7               : 1;
    };
  } __PID1SETLbits_t;

extern __at(0x058C) volatile __PID1SETLbits_t PID1SETLbits;

#define _PID1SET0               0x01
#define _SET0                   0x01
#define _PID1SET1               0x02
#define _SET1                   0x02
#define _PID1SET2               0x04
#define _SET2                   0x04
#define _PID1SET3               0x08
#define _SET3                   0x08
#define _PID1SET4               0x10
#define _SET4                   0x10
#define _PID1SET5               0x20
#define _SET5                   0x20
#define _PID1SET6               0x40
#define _SET6                   0x40
#define _PID1SET7               0x80
#define _SET7                   0x80

//==============================================================================


//==============================================================================
//        PID1SETH Bits

extern __at(0x058D) __sfr PID1SETH;

typedef union
  {
  struct
    {
    unsigned PID1SET8           : 1;
    unsigned PID1SET9           : 1;
    unsigned PID1SET10          : 1;
    unsigned PID1SET11          : 1;
    unsigned PID1SET12          : 1;
    unsigned PID1SET13          : 1;
    unsigned PID1SET14          : 1;
    unsigned PID1SET15          : 1;
    };

  struct
    {
    unsigned SET8               : 1;
    unsigned SET9               : 1;
    unsigned SET10              : 1;
    unsigned SET11              : 1;
    unsigned SET12              : 1;
    unsigned SET13              : 1;
    unsigned SET14              : 1;
    unsigned SET15              : 1;
    };
  } __PID1SETHbits_t;

extern __at(0x058D) volatile __PID1SETHbits_t PID1SETHbits;

#define _PID1SET8               0x01
#define _SET8                   0x01
#define _PID1SET9               0x02
#define _SET9                   0x02
#define _PID1SET10              0x04
#define _SET10                  0x04
#define _PID1SET11              0x08
#define _SET11                  0x08
#define _PID1SET12              0x10
#define _SET12                  0x10
#define _PID1SET13              0x20
#define _SET13                  0x20
#define _PID1SET14              0x40
#define _SET14                  0x40
#define _PID1SET15              0x80
#define _SET15                  0x80

//==============================================================================

extern __at(0x058E) __sfr PID1IN;

//==============================================================================
//        PID1INL Bits

extern __at(0x058E) __sfr PID1INL;

typedef union
  {
  struct
    {
    unsigned PID1IN0            : 1;
    unsigned PID1IN1            : 1;
    unsigned PID1IN2            : 1;
    unsigned PID1IN3            : 1;
    unsigned PID1IN4            : 1;
    unsigned PID1IN5            : 1;
    unsigned PID1IN6            : 1;
    unsigned PID1IN7            : 1;
    };

  struct
    {
    unsigned IN0                : 1;
    unsigned IN1                : 1;
    unsigned IN2                : 1;
    unsigned IN3                : 1;
    unsigned IN4                : 1;
    unsigned IN5                : 1;
    unsigned IN6                : 1;
    unsigned IN7                : 1;
    };
  } __PID1INLbits_t;

extern __at(0x058E) volatile __PID1INLbits_t PID1INLbits;

#define _PID1IN0                0x01
#define _IN0                    0x01
#define _PID1IN1                0x02
#define _IN1                    0x02
#define _PID1IN2                0x04
#define _IN2                    0x04
#define _PID1IN3                0x08
#define _IN3                    0x08
#define _PID1IN4                0x10
#define _IN4                    0x10
#define _PID1IN5                0x20
#define _IN5                    0x20
#define _PID1IN6                0x40
#define _IN6                    0x40
#define _PID1IN7                0x80
#define _IN7                    0x80

//==============================================================================


//==============================================================================
//        PID1INH Bits

extern __at(0x058F) __sfr PID1INH;

typedef union
  {
  struct
    {
    unsigned PID1IN8            : 1;
    unsigned PID1IN9            : 1;
    unsigned PID1IN10           : 1;
    unsigned PID1IN11           : 1;
    unsigned PID1IN12           : 1;
    unsigned PID1IN13           : 1;
    unsigned PID1IN14           : 1;
    unsigned PID1IN15           : 1;
    };

  struct
    {
    unsigned IN8                : 1;
    unsigned IN9                : 1;
    unsigned IN10               : 1;
    unsigned IN11               : 1;
    unsigned IN12               : 1;
    unsigned IN13               : 1;
    unsigned IN14               : 1;
    unsigned IN15               : 1;
    };
  } __PID1INHbits_t;

extern __at(0x058F) volatile __PID1INHbits_t PID1INHbits;

#define _PID1IN8                0x01
#define _IN8                    0x01
#define _PID1IN9                0x02
#define _IN9                    0x02
#define _PID1IN10               0x04
#define _IN10                   0x04
#define _PID1IN11               0x08
#define _IN11                   0x08
#define _PID1IN12               0x10
#define _IN12                   0x10
#define _PID1IN13               0x20
#define _IN13                   0x20
#define _PID1IN14               0x40
#define _IN14                   0x40
#define _PID1IN15               0x80
#define _IN15                   0x80

//==============================================================================

extern __at(0x0590) __sfr PID1K1;

//==============================================================================
//        PID1K1L Bits

extern __at(0x0590) __sfr PID1K1L;

typedef union
  {
  struct
    {
    unsigned PID1K10            : 1;
    unsigned PID1K11            : 1;
    unsigned PID1K12            : 1;
    unsigned PID1K13            : 1;
    unsigned PID1K14            : 1;
    unsigned PID1K15            : 1;
    unsigned PID1K16            : 1;
    unsigned PID1K17            : 1;
    };

  struct
    {
    unsigned K10                : 1;
    unsigned K11                : 1;
    unsigned K12                : 1;
    unsigned K13                : 1;
    unsigned K14                : 1;
    unsigned K15                : 1;
    unsigned K16                : 1;
    unsigned K17                : 1;
    };
  } __PID1K1Lbits_t;

extern __at(0x0590) volatile __PID1K1Lbits_t PID1K1Lbits;

#define _PID1K10                0x01
#define _K10                    0x01
#define _PID1K11                0x02
#define _K11                    0x02
#define _PID1K12                0x04
#define _K12                    0x04
#define _PID1K13                0x08
#define _K13                    0x08
#define _PID1K14                0x10
#define _K14                    0x10
#define _PID1K15                0x20
#define _K15                    0x20
#define _PID1K16                0x40
#define _K16                    0x40
#define _PID1K17                0x80
#define _K17                    0x80

//==============================================================================


//==============================================================================
//        PID1K1H Bits

extern __at(0x0591) __sfr PID1K1H;

typedef union
  {
  struct
    {
    unsigned PID1K18            : 1;
    unsigned PID1K19            : 1;
    unsigned PID1K110           : 1;
    unsigned PID1K111           : 1;
    unsigned PID1K112           : 1;
    unsigned PID1K113           : 1;
    unsigned PID1K114           : 1;
    unsigned PID1K115           : 1;
    };

  struct
    {
    unsigned K18                : 1;
    unsigned K19                : 1;
    unsigned K110               : 1;
    unsigned K111               : 1;
    unsigned K112               : 1;
    unsigned K113               : 1;
    unsigned K114               : 1;
    unsigned K115               : 1;
    };
  } __PID1K1Hbits_t;

extern __at(0x0591) volatile __PID1K1Hbits_t PID1K1Hbits;

#define _PID1K18                0x01
#define _K18                    0x01
#define _PID1K19                0x02
#define _K19                    0x02
#define _PID1K110               0x04
#define _K110                   0x04
#define _PID1K111               0x08
#define _K111                   0x08
#define _PID1K112               0x10
#define _K112                   0x10
#define _PID1K113               0x20
#define _K113                   0x20
#define _PID1K114               0x40
#define _K114                   0x40
#define _PID1K115               0x80
#define _K115                   0x80

//==============================================================================

extern __at(0x0592) __sfr PID1K2;

//==============================================================================
//        PID1K2L Bits

extern __at(0x0592) __sfr PID1K2L;

typedef union
  {
  struct
    {
    unsigned PID1K20            : 1;
    unsigned PID1K21            : 1;
    unsigned PID1K22            : 1;
    unsigned PID1K23            : 1;
    unsigned PID1K24            : 1;
    unsigned PID1K25            : 1;
    unsigned PID1K26            : 1;
    unsigned PID1K27            : 1;
    };

  struct
    {
    unsigned K20                : 1;
    unsigned K21                : 1;
    unsigned K22                : 1;
    unsigned K23                : 1;
    unsigned K24                : 1;
    unsigned K25                : 1;
    unsigned K26                : 1;
    unsigned K27                : 1;
    };
  } __PID1K2Lbits_t;

extern __at(0x0592) volatile __PID1K2Lbits_t PID1K2Lbits;

#define _PID1K20                0x01
#define _K20                    0x01
#define _PID1K21                0x02
#define _K21                    0x02
#define _PID1K22                0x04
#define _K22                    0x04
#define _PID1K23                0x08
#define _K23                    0x08
#define _PID1K24                0x10
#define _K24                    0x10
#define _PID1K25                0x20
#define _K25                    0x20
#define _PID1K26                0x40
#define _K26                    0x40
#define _PID1K27                0x80
#define _K27                    0x80

//==============================================================================


//==============================================================================
//        PID1K2H Bits

extern __at(0x0593) __sfr PID1K2H;

typedef union
  {
  struct
    {
    unsigned PID1K28            : 1;
    unsigned PID1K29            : 1;
    unsigned PID1K210           : 1;
    unsigned PID1K211           : 1;
    unsigned PID1K212           : 1;
    unsigned PID1K213           : 1;
    unsigned PID1K214           : 1;
    unsigned PID1K215           : 1;
    };

  struct
    {
    unsigned K28                : 1;
    unsigned K29                : 1;
    unsigned K210               : 1;
    unsigned K211               : 1;
    unsigned K212               : 1;
    unsigned K213               : 1;
    unsigned K214               : 1;
    unsigned K215               : 1;
    };
  } __PID1K2Hbits_t;

extern __at(0x0593) volatile __PID1K2Hbits_t PID1K2Hbits;

#define _PID1K28                0x01
#define _K28                    0x01
#define _PID1K29                0x02
#define _K29                    0x02
#define _PID1K210               0x04
#define _K210                   0x04
#define _PID1K211               0x08
#define _K211                   0x08
#define _PID1K212               0x10
#define _K212                   0x10
#define _PID1K213               0x20
#define _K213                   0x20
#define _PID1K214               0x40
#define _K214                   0x40
#define _PID1K215               0x80
#define _K215                   0x80

//==============================================================================

extern __at(0x0594) __sfr PID1K3;

//==============================================================================
//        PID1K3L Bits

extern __at(0x0594) __sfr PID1K3L;

typedef union
  {
  struct
    {
    unsigned PID1K30            : 1;
    unsigned PID1K31            : 1;
    unsigned PID1K32            : 1;
    unsigned PID1K33            : 1;
    unsigned PID1K34            : 1;
    unsigned PID1K35            : 1;
    unsigned PID1K36            : 1;
    unsigned PID1K37            : 1;
    };

  struct
    {
    unsigned K30                : 1;
    unsigned K31                : 1;
    unsigned K32                : 1;
    unsigned K33                : 1;
    unsigned K34                : 1;
    unsigned K35                : 1;
    unsigned K36                : 1;
    unsigned K37                : 1;
    };
  } __PID1K3Lbits_t;

extern __at(0x0594) volatile __PID1K3Lbits_t PID1K3Lbits;

#define _PID1K30                0x01
#define _K30                    0x01
#define _PID1K31                0x02
#define _K31                    0x02
#define _PID1K32                0x04
#define _K32                    0x04
#define _PID1K33                0x08
#define _K33                    0x08
#define _PID1K34                0x10
#define _K34                    0x10
#define _PID1K35                0x20
#define _K35                    0x20
#define _PID1K36                0x40
#define _K36                    0x40
#define _PID1K37                0x80
#define _K37                    0x80

//==============================================================================


//==============================================================================
//        PID1K3H Bits

extern __at(0x0595) __sfr PID1K3H;

typedef union
  {
  struct
    {
    unsigned PID1K38            : 1;
    unsigned PID1K39            : 1;
    unsigned PID1K310           : 1;
    unsigned PID1K311           : 1;
    unsigned PID1K312           : 1;
    unsigned PID1K313           : 1;
    unsigned PID1K314           : 1;
    unsigned PID1K315           : 1;
    };

  struct
    {
    unsigned K38                : 1;
    unsigned K39                : 1;
    unsigned K310               : 1;
    unsigned K311               : 1;
    unsigned K312               : 1;
    unsigned K313               : 1;
    unsigned K314               : 1;
    unsigned K315               : 1;
    };
  } __PID1K3Hbits_t;

extern __at(0x0595) volatile __PID1K3Hbits_t PID1K3Hbits;

#define _PID1K38                0x01
#define _K38                    0x01
#define _PID1K39                0x02
#define _K39                    0x02
#define _PID1K310               0x04
#define _K310                   0x04
#define _PID1K311               0x08
#define _K311                   0x08
#define _PID1K312               0x10
#define _K312                   0x10
#define _PID1K313               0x20
#define _K313                   0x20
#define _PID1K314               0x40
#define _K314                   0x40
#define _PID1K315               0x80
#define _K315                   0x80

//==============================================================================

extern __at(0x0596) __sfr PID1OUT;

//==============================================================================
//        PID1OUTLL Bits

extern __at(0x0596) __sfr PID1OUTLL;

typedef union
  {
  struct
    {
    unsigned PID1OUT0           : 1;
    unsigned PID1OUT1           : 1;
    unsigned PID1OUT2           : 1;
    unsigned PID1OUT3           : 1;
    unsigned PID1OUT4           : 1;
    unsigned PID1OUT5           : 1;
    unsigned PID1OUT6           : 1;
    unsigned PID1OUT7           : 1;
    };

  struct
    {
    unsigned OUT0               : 1;
    unsigned OUT1               : 1;
    unsigned OUT2               : 1;
    unsigned OUT3               : 1;
    unsigned OUT4               : 1;
    unsigned OUT5               : 1;
    unsigned OUT6               : 1;
    unsigned OUT7               : 1;
    };
  } __PID1OUTLLbits_t;

extern __at(0x0596) volatile __PID1OUTLLbits_t PID1OUTLLbits;

#define _PID1OUT0               0x01
#define _OUT0                   0x01
#define _PID1OUT1               0x02
#define _OUT1                   0x02
#define _PID1OUT2               0x04
#define _OUT2                   0x04
#define _PID1OUT3               0x08
#define _OUT3                   0x08
#define _PID1OUT4               0x10
#define _OUT4                   0x10
#define _PID1OUT5               0x20
#define _OUT5                   0x20
#define _PID1OUT6               0x40
#define _OUT6                   0x40
#define _PID1OUT7               0x80
#define _OUT7                   0x80

//==============================================================================


//==============================================================================
//        PID1OUTLH Bits

extern __at(0x0597) __sfr PID1OUTLH;

typedef union
  {
  struct
    {
    unsigned PID1OUT8           : 1;
    unsigned PID1OUT9           : 1;
    unsigned PID1OUT10          : 1;
    unsigned PID1OUT11          : 1;
    unsigned PID1OUT12          : 1;
    unsigned PID1OUT13          : 1;
    unsigned PID1OUT14          : 1;
    unsigned PID1OUT15          : 1;
    };

  struct
    {
    unsigned OUT8               : 1;
    unsigned OUT9               : 1;
    unsigned OUT10              : 1;
    unsigned OUT11              : 1;
    unsigned OUT12              : 1;
    unsigned OUT13              : 1;
    unsigned OUT14              : 1;
    unsigned OUT15              : 1;
    };
  } __PID1OUTLHbits_t;

extern __at(0x0597) volatile __PID1OUTLHbits_t PID1OUTLHbits;

#define _PID1OUT8               0x01
#define _OUT8                   0x01
#define _PID1OUT9               0x02
#define _OUT9                   0x02
#define _PID1OUT10              0x04
#define _OUT10                  0x04
#define _PID1OUT11              0x08
#define _OUT11                  0x08
#define _PID1OUT12              0x10
#define _OUT12                  0x10
#define _PID1OUT13              0x20
#define _OUT13                  0x20
#define _PID1OUT14              0x40
#define _OUT14                  0x40
#define _PID1OUT15              0x80
#define _OUT15                  0x80

//==============================================================================


//==============================================================================
//        PID1OUTHL Bits

extern __at(0x0598) __sfr PID1OUTHL;

typedef union
  {
  struct
    {
    unsigned PID1OUT16          : 1;
    unsigned PID1OUT17          : 1;
    unsigned PID1OUT18          : 1;
    unsigned PID1OUT19          : 1;
    unsigned PID1OUT20          : 1;
    unsigned PID1OUT21          : 1;
    unsigned PID1OUT22          : 1;
    unsigned PID1OUT23          : 1;
    };

  struct
    {
    unsigned OUT16              : 1;
    unsigned OUT17              : 1;
    unsigned OUT18              : 1;
    unsigned OUT19              : 1;
    unsigned OUT20              : 1;
    unsigned OUT21              : 1;
    unsigned OUT22              : 1;
    unsigned OUT23              : 1;
    };
  } __PID1OUTHLbits_t;

extern __at(0x0598) volatile __PID1OUTHLbits_t PID1OUTHLbits;

#define _PID1OUT16              0x01
#define _OUT16                  0x01
#define _PID1OUT17              0x02
#define _OUT17                  0x02
#define _PID1OUT18              0x04
#define _OUT18                  0x04
#define _PID1OUT19              0x08
#define _OUT19                  0x08
#define _PID1OUT20              0x10
#define _OUT20                  0x10
#define _PID1OUT21              0x20
#define _OUT21                  0x20
#define _PID1OUT22              0x40
#define _OUT22                  0x40
#define _PID1OUT23              0x80
#define _OUT23                  0x80

//==============================================================================


//==============================================================================
//        PID1OUTHH Bits

extern __at(0x0599) __sfr PID1OUTHH;

typedef union
  {
  struct
    {
    unsigned PID1OUT24          : 1;
    unsigned PID1OUT25          : 1;
    unsigned PID1OUT26          : 1;
    unsigned PID1OUT27          : 1;
    unsigned PID1OUT28          : 1;
    unsigned PID1OUT29          : 1;
    unsigned PID1OUT30          : 1;
    unsigned PID1OUT31          : 1;
    };

  struct
    {
    unsigned OUT24              : 1;
    unsigned OUT25              : 1;
    unsigned OUT26              : 1;
    unsigned OUT27              : 1;
    unsigned OUT28              : 1;
    unsigned OUT29              : 1;
    unsigned OUT30              : 1;
    unsigned OUT31              : 1;
    };
  } __PID1OUTHHbits_t;

extern __at(0x0599) volatile __PID1OUTHHbits_t PID1OUTHHbits;

#define _PID1OUT24              0x01
#define _OUT24                  0x01
#define _PID1OUT25              0x02
#define _OUT25                  0x02
#define _PID1OUT26              0x04
#define _OUT26                  0x04
#define _PID1OUT27              0x08
#define _OUT27                  0x08
#define _PID1OUT28              0x10
#define _OUT28                  0x10
#define _PID1OUT29              0x20
#define _OUT29                  0x20
#define _PID1OUT30              0x40
#define _OUT30                  0x40
#define _PID1OUT31              0x80
#define _OUT31                  0x80

//==============================================================================


//==============================================================================
//        PID1OUTU Bits

extern __at(0x059A) __sfr PID1OUTU;

typedef union
  {
  struct
    {
    unsigned PID1OUT32          : 1;
    unsigned PID1OUT33          : 1;
    unsigned PID1OUT34          : 1;
    unsigned PID1OUT35          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned OUT32              : 1;
    unsigned OUT33              : 1;
    unsigned OUT34              : 1;
    unsigned OUT35              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PID1OUTUbits_t;

extern __at(0x059A) volatile __PID1OUTUbits_t PID1OUTUbits;

#define _PID1OUT32              0x01
#define _OUT32                  0x01
#define _PID1OUT33              0x02
#define _OUT33                  0x02
#define _PID1OUT34              0x04
#define _OUT34                  0x04
#define _PID1OUT35              0x08
#define _OUT35                  0x08

//==============================================================================

extern __at(0x059B) __sfr PID1Z1;

//==============================================================================
//        PID1Z1L Bits

extern __at(0x059B) __sfr PID1Z1L;

typedef union
  {
  struct
    {
    unsigned PID1Z10            : 1;
    unsigned PID1Z11            : 1;
    unsigned PID1Z12            : 1;
    unsigned PID1Z13            : 1;
    unsigned PID1Z14            : 1;
    unsigned PID1Z15            : 1;
    unsigned PID1Z16            : 1;
    unsigned PID1Z17            : 1;
    };

  struct
    {
    unsigned Z10                : 1;
    unsigned Z11                : 1;
    unsigned Z12                : 1;
    unsigned Z13                : 1;
    unsigned Z14                : 1;
    unsigned Z15                : 1;
    unsigned Z16                : 1;
    unsigned Z17                : 1;
    };
  } __PID1Z1Lbits_t;

extern __at(0x059B) volatile __PID1Z1Lbits_t PID1Z1Lbits;

#define _PID1Z10                0x01
#define _Z10                    0x01
#define _PID1Z11                0x02
#define _Z11                    0x02
#define _PID1Z12                0x04
#define _Z12                    0x04
#define _PID1Z13                0x08
#define _Z13                    0x08
#define _PID1Z14                0x10
#define _Z14                    0x10
#define _PID1Z15                0x20
#define _Z15                    0x20
#define _PID1Z16                0x40
#define _Z16                    0x40
#define _PID1Z17                0x80
#define _Z17                    0x80

//==============================================================================


//==============================================================================
//        PID1Z1H Bits

extern __at(0x059C) __sfr PID1Z1H;

typedef union
  {
  struct
    {
    unsigned PID1Z18            : 1;
    unsigned PID1Z19            : 1;
    unsigned PID1Z110           : 1;
    unsigned PID1Z111           : 1;
    unsigned PID1Z112           : 1;
    unsigned PID1Z113           : 1;
    unsigned PID1Z114           : 1;
    unsigned PID1Z115           : 1;
    };

  struct
    {
    unsigned Z18                : 1;
    unsigned Z19                : 1;
    unsigned Z110               : 1;
    unsigned Z111               : 1;
    unsigned Z112               : 1;
    unsigned Z113               : 1;
    unsigned Z114               : 1;
    unsigned Z115               : 1;
    };
  } __PID1Z1Hbits_t;

extern __at(0x059C) volatile __PID1Z1Hbits_t PID1Z1Hbits;

#define _PID1Z18                0x01
#define _Z18                    0x01
#define _PID1Z19                0x02
#define _Z19                    0x02
#define _PID1Z110               0x04
#define _Z110                   0x04
#define _PID1Z111               0x08
#define _Z111                   0x08
#define _PID1Z112               0x10
#define _Z112                   0x10
#define _PID1Z113               0x20
#define _Z113                   0x20
#define _PID1Z114               0x40
#define _Z114                   0x40
#define _PID1Z115               0x80
#define _Z115                   0x80

//==============================================================================


//==============================================================================
//        PID1Z1U Bits

extern __at(0x059D) __sfr PID1Z1U;

typedef union
  {
  struct
    {
    unsigned PID1Z116           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned Z116               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PID1Z1Ubits_t;

extern __at(0x059D) volatile __PID1Z1Ubits_t PID1Z1Ubits;

#define _PID1Z116               0x01
#define _Z116                   0x01

//==============================================================================

extern __at(0x060C) __sfr PID1Z2;

//==============================================================================
//        PID1Z2L Bits

extern __at(0x060C) __sfr PID1Z2L;

typedef union
  {
  struct
    {
    unsigned PID1Z20            : 1;
    unsigned PID1Z21            : 1;
    unsigned PID1Z22            : 1;
    unsigned PID1Z23            : 1;
    unsigned PID1Z24            : 1;
    unsigned PID1Z25            : 1;
    unsigned PID1Z26            : 1;
    unsigned PID1Z27            : 1;
    };

  struct
    {
    unsigned Z20                : 1;
    unsigned Z21                : 1;
    unsigned Z22                : 1;
    unsigned Z23                : 1;
    unsigned Z24                : 1;
    unsigned Z25                : 1;
    unsigned Z26                : 1;
    unsigned Z27                : 1;
    };
  } __PID1Z2Lbits_t;

extern __at(0x060C) volatile __PID1Z2Lbits_t PID1Z2Lbits;

#define _PID1Z20                0x01
#define _Z20                    0x01
#define _PID1Z21                0x02
#define _Z21                    0x02
#define _PID1Z22                0x04
#define _Z22                    0x04
#define _PID1Z23                0x08
#define _Z23                    0x08
#define _PID1Z24                0x10
#define _Z24                    0x10
#define _PID1Z25                0x20
#define _Z25                    0x20
#define _PID1Z26                0x40
#define _Z26                    0x40
#define _PID1Z27                0x80
#define _Z27                    0x80

//==============================================================================


//==============================================================================
//        PID1Z2H Bits

extern __at(0x060D) __sfr PID1Z2H;

typedef union
  {
  struct
    {
    unsigned PID1Z28            : 1;
    unsigned PID1Z29            : 1;
    unsigned PID1Z210           : 1;
    unsigned PID1Z211           : 1;
    unsigned PID1Z212           : 1;
    unsigned PID1Z213           : 1;
    unsigned PID1Z214           : 1;
    unsigned PID1Z215           : 1;
    };

  struct
    {
    unsigned Z28                : 1;
    unsigned Z29                : 1;
    unsigned Z210               : 1;
    unsigned Z211               : 1;
    unsigned Z212               : 1;
    unsigned Z213               : 1;
    unsigned Z214               : 1;
    unsigned Z215               : 1;
    };
  } __PID1Z2Hbits_t;

extern __at(0x060D) volatile __PID1Z2Hbits_t PID1Z2Hbits;

#define _PID1Z28                0x01
#define _Z28                    0x01
#define _PID1Z29                0x02
#define _Z29                    0x02
#define _PID1Z210               0x04
#define _Z210                   0x04
#define _PID1Z211               0x08
#define _Z211                   0x08
#define _PID1Z212               0x10
#define _Z212                   0x10
#define _PID1Z213               0x20
#define _Z213                   0x20
#define _PID1Z214               0x40
#define _Z214                   0x40
#define _PID1Z215               0x80
#define _Z215                   0x80

//==============================================================================


//==============================================================================
//        PID1Z2U Bits

extern __at(0x060E) __sfr PID1Z2U;

typedef union
  {
  struct
    {
    unsigned PID1Z216           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned Z216               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PID1Z2Ubits_t;

extern __at(0x060E) volatile __PID1Z2Ubits_t PID1Z2Ubits;

#define _PID1Z216               0x01
#define _Z216                   0x01

//==============================================================================

extern __at(0x060F) __sfr PID1ACC;

//==============================================================================
//        PID1ACCLL Bits

extern __at(0x060F) __sfr PID1ACCLL;

typedef union
  {
  struct
    {
    unsigned PID1ACC0           : 1;
    unsigned PID1ACC1           : 1;
    unsigned PID1ACC2           : 1;
    unsigned PID1ACC3           : 1;
    unsigned PID1ACC4           : 1;
    unsigned PID1ACC5           : 1;
    unsigned PID1ACC6           : 1;
    unsigned PID1ACC7           : 1;
    };

  struct
    {
    unsigned ACC0               : 1;
    unsigned ACC1               : 1;
    unsigned ACC2               : 1;
    unsigned ACC3               : 1;
    unsigned ACC4               : 1;
    unsigned ACC5               : 1;
    unsigned ACC6               : 1;
    unsigned ACC7               : 1;
    };
  } __PID1ACCLLbits_t;

extern __at(0x060F) volatile __PID1ACCLLbits_t PID1ACCLLbits;

#define _PID1ACCLL_PID1ACC0     0x01
#define _PID1ACCLL_ACC0         0x01
#define _PID1ACCLL_PID1ACC1     0x02
#define _PID1ACCLL_ACC1         0x02
#define _PID1ACCLL_PID1ACC2     0x04
#define _PID1ACCLL_ACC2         0x04
#define _PID1ACCLL_PID1ACC3     0x08
#define _PID1ACCLL_ACC3         0x08
#define _PID1ACCLL_PID1ACC4     0x10
#define _PID1ACCLL_ACC4         0x10
#define _PID1ACCLL_PID1ACC5     0x20
#define _PID1ACCLL_ACC5         0x20
#define _PID1ACCLL_PID1ACC6     0x40
#define _PID1ACCLL_ACC6         0x40
#define _PID1ACCLL_PID1ACC7     0x80
#define _PID1ACCLL_ACC7         0x80

//==============================================================================


//==============================================================================
//        PID1ACCLH Bits

extern __at(0x0610) __sfr PID1ACCLH;

typedef union
  {
  struct
    {
    unsigned PID1ACC8           : 1;
    unsigned PID1ACC9           : 1;
    unsigned PID1ACC10          : 1;
    unsigned PID1ACC11          : 1;
    unsigned PID1ACC12          : 1;
    unsigned PID1ACC13          : 1;
    unsigned PID1ACC14          : 1;
    unsigned PID1ACC15          : 1;
    };

  struct
    {
    unsigned ACC8               : 1;
    unsigned ACC9               : 1;
    unsigned ACC10              : 1;
    unsigned ACC11              : 1;
    unsigned ACC12              : 1;
    unsigned ACC13              : 1;
    unsigned ACC14              : 1;
    unsigned ACC15              : 1;
    };
  } __PID1ACCLHbits_t;

extern __at(0x0610) volatile __PID1ACCLHbits_t PID1ACCLHbits;

#define _PID1ACCLH_PID1ACC8     0x01
#define _PID1ACCLH_ACC8         0x01
#define _PID1ACCLH_PID1ACC9     0x02
#define _PID1ACCLH_ACC9         0x02
#define _PID1ACCLH_PID1ACC10    0x04
#define _PID1ACCLH_ACC10        0x04
#define _PID1ACCLH_PID1ACC11    0x08
#define _PID1ACCLH_ACC11        0x08
#define _PID1ACCLH_PID1ACC12    0x10
#define _PID1ACCLH_ACC12        0x10
#define _PID1ACCLH_PID1ACC13    0x20
#define _PID1ACCLH_ACC13        0x20
#define _PID1ACCLH_PID1ACC14    0x40
#define _PID1ACCLH_ACC14        0x40
#define _PID1ACCLH_PID1ACC15    0x80
#define _PID1ACCLH_ACC15        0x80

//==============================================================================


//==============================================================================
//        PID1ACCHL Bits

extern __at(0x0611) __sfr PID1ACCHL;

typedef union
  {
  struct
    {
    unsigned PID1ACC16          : 1;
    unsigned PID1ACC17          : 1;
    unsigned PID1ACC18          : 1;
    unsigned PID1ACC19          : 1;
    unsigned PID1ACC20          : 1;
    unsigned PID1ACC21          : 1;
    unsigned PID1ACC22          : 1;
    unsigned PID1ACC23          : 1;
    };

  struct
    {
    unsigned ACC16              : 1;
    unsigned ACC17              : 1;
    unsigned ACC18              : 1;
    unsigned ACC19              : 1;
    unsigned ACC20              : 1;
    unsigned ACC21              : 1;
    unsigned ACC22              : 1;
    unsigned ACC23              : 1;
    };
  } __PID1ACCHLbits_t;

extern __at(0x0611) volatile __PID1ACCHLbits_t PID1ACCHLbits;

#define _PID1ACC16              0x01
#define _ACC16                  0x01
#define _PID1ACC17              0x02
#define _ACC17                  0x02
#define _PID1ACC18              0x04
#define _ACC18                  0x04
#define _PID1ACC19              0x08
#define _ACC19                  0x08
#define _PID1ACC20              0x10
#define _ACC20                  0x10
#define _PID1ACC21              0x20
#define _ACC21                  0x20
#define _PID1ACC22              0x40
#define _ACC22                  0x40
#define _PID1ACC23              0x80
#define _ACC23                  0x80

//==============================================================================


//==============================================================================
//        PID1ACCHH Bits

extern __at(0x0612) __sfr PID1ACCHH;

typedef union
  {
  struct
    {
    unsigned PID1ACC24          : 1;
    unsigned PID1ACC25          : 1;
    unsigned PID1ACC26          : 1;
    unsigned PID1ACC27          : 1;
    unsigned PID1ACC28          : 1;
    unsigned PID1ACC29          : 1;
    unsigned PID1ACC30          : 1;
    unsigned PID1ACC31          : 1;
    };

  struct
    {
    unsigned ACC24              : 1;
    unsigned ACC25              : 1;
    unsigned ACC26              : 1;
    unsigned ACC27              : 1;
    unsigned ACC28              : 1;
    unsigned ACC29              : 1;
    unsigned ACC30              : 1;
    unsigned ACC31              : 1;
    };
  } __PID1ACCHHbits_t;

extern __at(0x0612) volatile __PID1ACCHHbits_t PID1ACCHHbits;

#define _PID1ACC24              0x01
#define _ACC24                  0x01
#define _PID1ACC25              0x02
#define _ACC25                  0x02
#define _PID1ACC26              0x04
#define _ACC26                  0x04
#define _PID1ACC27              0x08
#define _ACC27                  0x08
#define _PID1ACC28              0x10
#define _ACC28                  0x10
#define _PID1ACC29              0x20
#define _ACC29                  0x20
#define _PID1ACC30              0x40
#define _ACC30                  0x40
#define _PID1ACC31              0x80
#define _ACC31                  0x80

//==============================================================================


//==============================================================================
//        PID1ACCU Bits

extern __at(0x0613) __sfr PID1ACCU;

typedef union
  {
  struct
    {
    unsigned PID1ACC32          : 1;
    unsigned PID1ACC33          : 1;
    unsigned PID1ACC34          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ACC32              : 1;
    unsigned ACC33              : 1;
    unsigned ACC34              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PID1ACCUbits_t;

extern __at(0x0613) volatile __PID1ACCUbits_t PID1ACCUbits;

#define _PID1ACC32              0x01
#define _ACC32                  0x01
#define _PID1ACC33              0x02
#define _ACC33                  0x02
#define _PID1ACC34              0x04
#define _ACC34                  0x04

//==============================================================================


//==============================================================================
//        PID1CON Bits

extern __at(0x0614) __sfr PID1CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PID1BUSY           : 1;
    unsigned PID1EN             : 1;
    };

  struct
    {
    unsigned PID1MODE0          : 1;
    unsigned PID1MODE1          : 1;
    unsigned PID1MODE2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned BUSY               : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned PID1MODE           : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __PID1CONbits_t;

extern __at(0x0614) volatile __PID1CONbits_t PID1CONbits;

#define _PID1CON_MODE0          0x01
#define _PID1CON_PID1MODE0      0x01
#define _PID1CON_MODE1          0x02
#define _PID1CON_PID1MODE1      0x02
#define _PID1CON_MODE2          0x04
#define _PID1CON_PID1MODE2      0x04
#define _PID1CON_PID1BUSY       0x40
#define _PID1CON_BUSY           0x40
#define _PID1CON_PID1EN         0x80
#define _PID1CON_EN             0x80

//==============================================================================


//==============================================================================
//        PWM3DCL Bits

extern __at(0x0617) __sfr PWM3DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC0                : 1;
    unsigned DC1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM3DC0            : 1;
    unsigned PWM3DC1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWMPW0             : 1;
    unsigned PWMPW1             : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned DC                 : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWMPW              : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM3DC             : 2;
    };
  } __PWM3DCLbits_t;

extern __at(0x0617) volatile __PWM3DCLbits_t PWM3DCLbits;

#define _DC0                    0x40
#define _PWM3DC0                0x40
#define _PWMPW0                 0x40
#define _DC1                    0x80
#define _PWM3DC1                0x80
#define _PWMPW1                 0x80

//==============================================================================


//==============================================================================
//        PWM3DCH Bits

extern __at(0x0618) __sfr PWM3DCH;

typedef union
  {
  struct
    {
    unsigned DC2                : 1;
    unsigned DC3                : 1;
    unsigned DC4                : 1;
    unsigned DC5                : 1;
    unsigned DC6                : 1;
    unsigned DC7                : 1;
    unsigned DC8                : 1;
    unsigned DC9                : 1;
    };

  struct
    {
    unsigned PWM3DC2            : 1;
    unsigned PWM3DC3            : 1;
    unsigned PWM3DC4            : 1;
    unsigned PWM3DC5            : 1;
    unsigned PWM3DC6            : 1;
    unsigned PWM3DC7            : 1;
    unsigned PWM3DC8            : 1;
    unsigned PWM3DC9            : 1;
    };

  struct
    {
    unsigned PWMPW2             : 1;
    unsigned PWMPW3             : 1;
    unsigned PWMPW4             : 1;
    unsigned PWMPW5             : 1;
    unsigned PWMPW6             : 1;
    unsigned PWMPW7             : 1;
    unsigned PWMPW8             : 1;
    unsigned PWMPW9             : 1;
    };
  } __PWM3DCHbits_t;

extern __at(0x0618) volatile __PWM3DCHbits_t PWM3DCHbits;

#define _DC2                    0x01
#define _PWM3DC2                0x01
#define _PWMPW2                 0x01
#define _DC3                    0x02
#define _PWM3DC3                0x02
#define _PWMPW3                 0x02
#define _DC4                    0x04
#define _PWM3DC4                0x04
#define _PWMPW4                 0x04
#define _DC5                    0x08
#define _PWM3DC5                0x08
#define _PWMPW5                 0x08
#define _DC6                    0x10
#define _PWM3DC6                0x10
#define _PWMPW6                 0x10
#define _DC7                    0x20
#define _PWM3DC7                0x20
#define _PWMPW7                 0x20
#define _DC8                    0x40
#define _PWM3DC8                0x40
#define _PWMPW8                 0x40
#define _DC9                    0x80
#define _PWM3DC9                0x80
#define _PWMPW9                 0x80

//==============================================================================


//==============================================================================
//        PWM3CON Bits

extern __at(0x0619) __sfr PWM3CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM3POL            : 1;
    unsigned PWM3OUT            : 1;
    unsigned                    : 1;
    unsigned PWM3EN             : 1;
    };
  } __PWM3CONbits_t;

extern __at(0x0619) volatile __PWM3CONbits_t PWM3CONbits;

#define _PWM3CON_POL            0x10
#define _PWM3CON_PWM3POL        0x10
#define _PWM3CON_OUT            0x20
#define _PWM3CON_PWM3OUT        0x20
#define _PWM3CON_EN             0x80
#define _PWM3CON_PWM3EN         0x80

//==============================================================================


//==============================================================================
//        PWM4DCL Bits

extern __at(0x061A) __sfr PWM4DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC0                : 1;
    unsigned DC1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM4DC0            : 1;
    unsigned PWM4DC1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWMPW0             : 1;
    unsigned PWMPW1             : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM4DC             : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWMPW              : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned DC                 : 2;
    };
  } __PWM4DCLbits_t;

extern __at(0x061A) volatile __PWM4DCLbits_t PWM4DCLbits;

#define _PWM4DCL_DC0            0x40
#define _PWM4DCL_PWM4DC0        0x40
#define _PWM4DCL_PWMPW0         0x40
#define _PWM4DCL_DC1            0x80
#define _PWM4DCL_PWM4DC1        0x80
#define _PWM4DCL_PWMPW1         0x80

//==============================================================================


//==============================================================================
//        PWM4DCH Bits

extern __at(0x061B) __sfr PWM4DCH;

typedef union
  {
  struct
    {
    unsigned DC2                : 1;
    unsigned DC3                : 1;
    unsigned DC4                : 1;
    unsigned DC5                : 1;
    unsigned DC6                : 1;
    unsigned DC7                : 1;
    unsigned DC8                : 1;
    unsigned DC9                : 1;
    };

  struct
    {
    unsigned PWM4DC2            : 1;
    unsigned PWM4DC3            : 1;
    unsigned PWM4DC4            : 1;
    unsigned PWM4DC5            : 1;
    unsigned PWM4DC6            : 1;
    unsigned PWM4DC7            : 1;
    unsigned PWM4DC8            : 1;
    unsigned PWM4DC9            : 1;
    };

  struct
    {
    unsigned PWMPW2             : 1;
    unsigned PWMPW3             : 1;
    unsigned PWMPW4             : 1;
    unsigned PWMPW5             : 1;
    unsigned PWMPW6             : 1;
    unsigned PWMPW7             : 1;
    unsigned PWMPW8             : 1;
    unsigned PWMPW9             : 1;
    };
  } __PWM4DCHbits_t;

extern __at(0x061B) volatile __PWM4DCHbits_t PWM4DCHbits;

#define _PWM4DCH_DC2            0x01
#define _PWM4DCH_PWM4DC2        0x01
#define _PWM4DCH_PWMPW2         0x01
#define _PWM4DCH_DC3            0x02
#define _PWM4DCH_PWM4DC3        0x02
#define _PWM4DCH_PWMPW3         0x02
#define _PWM4DCH_DC4            0x04
#define _PWM4DCH_PWM4DC4        0x04
#define _PWM4DCH_PWMPW4         0x04
#define _PWM4DCH_DC5            0x08
#define _PWM4DCH_PWM4DC5        0x08
#define _PWM4DCH_PWMPW5         0x08
#define _PWM4DCH_DC6            0x10
#define _PWM4DCH_PWM4DC6        0x10
#define _PWM4DCH_PWMPW6         0x10
#define _PWM4DCH_DC7            0x20
#define _PWM4DCH_PWM4DC7        0x20
#define _PWM4DCH_PWMPW7         0x20
#define _PWM4DCH_DC8            0x40
#define _PWM4DCH_PWM4DC8        0x40
#define _PWM4DCH_PWMPW8         0x40
#define _PWM4DCH_DC9            0x80
#define _PWM4DCH_PWM4DC9        0x80
#define _PWM4DCH_PWMPW9         0x80

//==============================================================================


//==============================================================================
//        PWM4CON Bits

extern __at(0x061C) __sfr PWM4CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM4POL            : 1;
    unsigned PWM4OUT            : 1;
    unsigned                    : 1;
    unsigned PWM4EN             : 1;
    };
  } __PWM4CONbits_t;

extern __at(0x061C) volatile __PWM4CONbits_t PWM4CONbits;

#define _PWM4CON_POL            0x10
#define _PWM4CON_PWM4POL        0x10
#define _PWM4CON_OUT            0x20
#define _PWM4CON_PWM4OUT        0x20
#define _PWM4CON_EN             0x80
#define _PWM4CON_PWM4EN         0x80

//==============================================================================


//==============================================================================
//        CWG1DBR Bits

extern __at(0x0691) __sfr CWG1DBR;

typedef union
  {
  struct
    {
    unsigned DBR0               : 1;
    unsigned DBR1               : 1;
    unsigned DBR2               : 1;
    unsigned DBR3               : 1;
    unsigned DBR4               : 1;
    unsigned DBR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBR0           : 1;
    unsigned CWG1DBR1           : 1;
    unsigned CWG1DBR2           : 1;
    unsigned CWG1DBR3           : 1;
    unsigned CWG1DBR4           : 1;
    unsigned CWG1DBR5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DBR                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned CWG1DBR            : 6;
    unsigned                    : 2;
    };
  } __CWG1DBRbits_t;

extern __at(0x0691) volatile __CWG1DBRbits_t CWG1DBRbits;

#define _DBR0                   0x01
#define _CWG1DBR0               0x01
#define _DBR1                   0x02
#define _CWG1DBR1               0x02
#define _DBR2                   0x04
#define _CWG1DBR2               0x04
#define _DBR3                   0x08
#define _CWG1DBR3               0x08
#define _DBR4                   0x10
#define _CWG1DBR4               0x10
#define _DBR5                   0x20
#define _CWG1DBR5               0x20

//==============================================================================


//==============================================================================
//        CWG1DBF Bits

extern __at(0x0692) __sfr CWG1DBF;

typedef union
  {
  struct
    {
    unsigned DBF0               : 1;
    unsigned DBF1               : 1;
    unsigned DBF2               : 1;
    unsigned DBF3               : 1;
    unsigned DBF4               : 1;
    unsigned DBF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBF0           : 1;
    unsigned CWG1DBF1           : 1;
    unsigned CWG1DBF2           : 1;
    unsigned CWG1DBF3           : 1;
    unsigned CWG1DBF4           : 1;
    unsigned CWG1DBF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBF            : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DBF                : 6;
    unsigned                    : 2;
    };
  } __CWG1DBFbits_t;

extern __at(0x0692) volatile __CWG1DBFbits_t CWG1DBFbits;

#define _DBF0                   0x01
#define _CWG1DBF0               0x01
#define _DBF1                   0x02
#define _CWG1DBF1               0x02
#define _DBF2                   0x04
#define _CWG1DBF2               0x04
#define _DBF3                   0x08
#define _CWG1DBF3               0x08
#define _DBF4                   0x10
#define _CWG1DBF4               0x10
#define _DBF5                   0x20
#define _CWG1DBF5               0x20

//==============================================================================


//==============================================================================
//        CWG1AS0 Bits

extern __at(0x0693) __sfr CWG1AS0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LSAC0              : 1;
    unsigned LSAC1              : 1;
    unsigned LSBD0              : 1;
    unsigned LSBD1              : 1;
    unsigned REN                : 1;
    unsigned SHUTDOWN           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG1LSAC0          : 1;
    unsigned CWG1LSAC1          : 1;
    unsigned CWG1LSBD0          : 1;
    unsigned CWG1LSBD1          : 1;
    unsigned CWG1REN            : 1;
    unsigned CWG1SHUTDOWN       : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned LSAC               : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CWG1LSAC           : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LSBD               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CWG1LSBD           : 2;
    unsigned                    : 2;
    };
  } __CWG1AS0bits_t;

extern __at(0x0693) volatile __CWG1AS0bits_t CWG1AS0bits;

#define _LSAC0                  0x04
#define _CWG1LSAC0              0x04
#define _LSAC1                  0x08
#define _CWG1LSAC1              0x08
#define _LSBD0                  0x10
#define _CWG1LSBD0              0x10
#define _LSBD1                  0x20
#define _CWG1LSBD1              0x20
#define _REN                    0x40
#define _CWG1REN                0x40
#define _SHUTDOWN               0x80
#define _CWG1SHUTDOWN           0x80

//==============================================================================


//==============================================================================
//        CWG1AS1 Bits

extern __at(0x0694) __sfr CWG1AS1;

typedef union
  {
  struct
    {
    unsigned INAS               : 1;
    unsigned C1AS               : 1;
    unsigned C2AS               : 1;
    unsigned                    : 1;
    unsigned TMR2AS             : 1;
    unsigned TMR4AS             : 1;
    unsigned TMR6AS             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1INAS           : 1;
    unsigned CWG1C1AS           : 1;
    unsigned CWG1C2AS           : 1;
    unsigned                    : 1;
    unsigned CWG1TMR2AS         : 1;
    unsigned CWG1TMR4AS         : 1;
    unsigned CWG1TMR6AS         : 1;
    unsigned                    : 1;
    };
  } __CWG1AS1bits_t;

extern __at(0x0694) volatile __CWG1AS1bits_t CWG1AS1bits;

#define _INAS                   0x01
#define _CWG1INAS               0x01
#define _C1AS                   0x02
#define _CWG1C1AS               0x02
#define _C2AS                   0x04
#define _CWG1C2AS               0x04
#define _TMR2AS                 0x10
#define _CWG1TMR2AS             0x10
#define _TMR4AS                 0x20
#define _CWG1TMR4AS             0x20
#define _TMR6AS                 0x40
#define _CWG1TMR6AS             0x40

//==============================================================================


//==============================================================================
//        CWG1OCON0 Bits

extern __at(0x0695) __sfr CWG1OCON0;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned OVRA               : 1;
    unsigned OVRB               : 1;
    unsigned OVRC               : 1;
    unsigned OVRD               : 1;
    };

  struct
    {
    unsigned CWG1STRA           : 1;
    unsigned CWG1STRB           : 1;
    unsigned CWG1STRC           : 1;
    unsigned CWG1STRD           : 1;
    unsigned CWG1OVRA           : 1;
    unsigned CWG1OVRB           : 1;
    unsigned CWG1OVRC           : 1;
    unsigned CWG1OVRD           : 1;
    };
  } __CWG1OCON0bits_t;

extern __at(0x0695) volatile __CWG1OCON0bits_t CWG1OCON0bits;

#define _STRA                   0x01
#define _CWG1STRA               0x01
#define _STRB                   0x02
#define _CWG1STRB               0x02
#define _STRC                   0x04
#define _CWG1STRC               0x04
#define _STRD                   0x08
#define _CWG1STRD               0x08
#define _OVRA                   0x10
#define _CWG1OVRA               0x10
#define _OVRB                   0x20
#define _CWG1OVRB               0x20
#define _OVRC                   0x40
#define _CWG1OVRC               0x40
#define _OVRD                   0x80
#define _CWG1OVRD               0x80

//==============================================================================


//==============================================================================
//        CWG1CON0 Bits

extern __at(0x0696) __sfr CWG1CON0;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LD                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CWG1MODE0          : 1;
    unsigned CWG1MODE1          : 1;
    unsigned CWG1MODE2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG1LD             : 1;
    unsigned G1EN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG1EN             : 1;
    };

  struct
    {
    unsigned CWG1MODE           : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CWG1CON0bits_t;

extern __at(0x0696) volatile __CWG1CON0bits_t CWG1CON0bits;

#define _CWG1CON0_MODE0         0x01
#define _CWG1CON0_CWG1MODE0     0x01
#define _CWG1CON0_MODE1         0x02
#define _CWG1CON0_CWG1MODE1     0x02
#define _CWG1CON0_MODE2         0x04
#define _CWG1CON0_CWG1MODE2     0x04
#define _CWG1CON0_LD            0x40
#define _CWG1CON0_CWG1LD        0x40
#define _CWG1CON0_EN            0x80
#define _CWG1CON0_G1EN          0x80
#define _CWG1CON0_CWG1EN        0x80

//==============================================================================


//==============================================================================
//        CWG1CON1 Bits

extern __at(0x0697) __sfr CWG1CON1;

typedef union
  {
  struct
    {
    unsigned POLA               : 1;
    unsigned POLB               : 1;
    unsigned POLC               : 1;
    unsigned POLD               : 1;
    unsigned                    : 1;
    unsigned IN                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1POLA           : 1;
    unsigned CWG1POLB           : 1;
    unsigned CWG1POLC           : 1;
    unsigned CWG1POLD           : 1;
    unsigned                    : 1;
    unsigned CWG1IN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG1CON1bits_t;

extern __at(0x0697) volatile __CWG1CON1bits_t CWG1CON1bits;

#define _POLA                   0x01
#define _CWG1POLA               0x01
#define _POLB                   0x02
#define _CWG1POLB               0x02
#define _POLC                   0x04
#define _CWG1POLC               0x04
#define _POLD                   0x08
#define _CWG1POLD               0x08
#define _IN                     0x20
#define _CWG1IN                 0x20

//==============================================================================


//==============================================================================
//        CWG1CLKCON Bits

extern __at(0x0699) __sfr CWG1CLKCON;

typedef union
  {
  struct
    {
    unsigned CS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1CS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG1CLKCONbits_t;

extern __at(0x0699) volatile __CWG1CLKCONbits_t CWG1CLKCONbits;

#define _CWG1CLKCON_CS          0x01
#define _CWG1CLKCON_CWG1CS      0x01

//==============================================================================


//==============================================================================
//        CWG1ISM Bits

extern __at(0x069A) __sfr CWG1ISM;

typedef union
  {
  struct
    {
    unsigned IS0                : 1;
    unsigned IS1                : 1;
    unsigned IS2                : 1;
    unsigned IS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1IS0            : 1;
    unsigned CWG1IS1            : 1;
    unsigned CWG1IS2            : 1;
    unsigned CWG1IS3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1IS             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned IS                 : 4;
    unsigned                    : 4;
    };
  } __CWG1ISMbits_t;

extern __at(0x069A) volatile __CWG1ISMbits_t CWG1ISMbits;

#define _IS0                    0x01
#define _CWG1IS0                0x01
#define _IS1                    0x02
#define _CWG1IS1                0x02
#define _IS2                    0x04
#define _CWG1IS2                0x04
#define _IS3                    0x08
#define _CWG1IS3                0x08

//==============================================================================


//==============================================================================
//        WDTCON0 Bits

extern __at(0x0711) __sfr WDTCON0;

typedef union
  {
  struct
    {
    unsigned SEN                : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SWDTEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WDTSEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCON0bits_t;

extern __at(0x0711) volatile __WDTCON0bits_t WDTCON0bits;

#define _WDTCON0_SEN            0x01
#define _WDTCON0_SWDTEN         0x01
#define _WDTCON0_WDTSEN         0x01
#define _WDTCON0_WDTPS0         0x02
#define _WDTCON0_WDTPS1         0x04
#define _WDTCON0_WDTPS2         0x08
#define _WDTCON0_WDTPS3         0x10
#define _WDTCON0_WDTPS4         0x20

//==============================================================================


//==============================================================================
//        WDTCON1 Bits

extern __at(0x0712) __sfr WDTCON1;

typedef union
  {
  struct
    {
    unsigned WINDOW0            : 1;
    unsigned WINDOW1            : 1;
    unsigned WINDOW2            : 1;
    unsigned                    : 1;
    unsigned WDTCS0             : 1;
    unsigned WDTCS1             : 1;
    unsigned WDTCS2             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WDTWINDOW0         : 1;
    unsigned WDTWINDOW1         : 1;
    unsigned WDTWINDOW2         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WINDOW             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned WDTWINDOW          : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned WDTCS              : 3;
    unsigned                    : 1;
    };
  } __WDTCON1bits_t;

extern __at(0x0712) volatile __WDTCON1bits_t WDTCON1bits;

#define _WINDOW0                0x01
#define _WDTWINDOW0             0x01
#define _WINDOW1                0x02
#define _WDTWINDOW1             0x02
#define _WINDOW2                0x04
#define _WDTWINDOW2             0x04
#define _WDTCS0                 0x10
#define _WDTCS1                 0x20
#define _WDTCS2                 0x40

//==============================================================================


//==============================================================================
//        WDTPSL Bits

extern __at(0x0713) __sfr WDTPSL;

typedef union
  {
  struct
    {
    unsigned PSCNT0             : 1;
    unsigned PSCNT1             : 1;
    unsigned PSCNT2             : 1;
    unsigned PSCNT3             : 1;
    unsigned PSCNT4             : 1;
    unsigned PSCNT5             : 1;
    unsigned PSCNT6             : 1;
    unsigned PSCNT7             : 1;
    };

  struct
    {
    unsigned WDTPSCNT0          : 1;
    unsigned WDTPSCNT1          : 1;
    unsigned WDTPSCNT2          : 1;
    unsigned WDTPSCNT3          : 1;
    unsigned WDTPSCNT4          : 1;
    unsigned WDTPSCNT5          : 1;
    unsigned WDTPSCNT6          : 1;
    unsigned WDTPSCNT7          : 1;
    };
  } __WDTPSLbits_t;

extern __at(0x0713) volatile __WDTPSLbits_t WDTPSLbits;

#define _PSCNT0                 0x01
#define _WDTPSCNT0              0x01
#define _PSCNT1                 0x02
#define _WDTPSCNT1              0x02
#define _PSCNT2                 0x04
#define _WDTPSCNT2              0x04
#define _PSCNT3                 0x08
#define _WDTPSCNT3              0x08
#define _PSCNT4                 0x10
#define _WDTPSCNT4              0x10
#define _PSCNT5                 0x20
#define _WDTPSCNT5              0x20
#define _PSCNT6                 0x40
#define _WDTPSCNT6              0x40
#define _PSCNT7                 0x80
#define _WDTPSCNT7              0x80

//==============================================================================


//==============================================================================
//        WDTPSH Bits

extern __at(0x0714) __sfr WDTPSH;

typedef union
  {
  struct
    {
    unsigned PSCNT8             : 1;
    unsigned PSCNT9             : 1;
    unsigned PSCNT10            : 1;
    unsigned PSCNT11            : 1;
    unsigned PSCNT12            : 1;
    unsigned PSCNT13            : 1;
    unsigned PSCNT14            : 1;
    unsigned PSCNT15            : 1;
    };

  struct
    {
    unsigned WDTPSCNT8          : 1;
    unsigned WDTPSCNT9          : 1;
    unsigned WDTPSCNT10         : 1;
    unsigned WDTPSCNT11         : 1;
    unsigned WDTPSCNT12         : 1;
    unsigned WDTPSCNT13         : 1;
    unsigned WDTPSCNT14         : 1;
    unsigned WDTPSCNT15         : 1;
    };
  } __WDTPSHbits_t;

extern __at(0x0714) volatile __WDTPSHbits_t WDTPSHbits;

#define _PSCNT8                 0x01
#define _WDTPSCNT8              0x01
#define _PSCNT9                 0x02
#define _WDTPSCNT9              0x02
#define _PSCNT10                0x04
#define _WDTPSCNT10             0x04
#define _PSCNT11                0x08
#define _WDTPSCNT11             0x08
#define _PSCNT12                0x10
#define _WDTPSCNT12             0x10
#define _PSCNT13                0x20
#define _WDTPSCNT13             0x20
#define _PSCNT14                0x40
#define _WDTPSCNT14             0x40
#define _PSCNT15                0x80
#define _WDTPSCNT15             0x80

//==============================================================================


//==============================================================================
//        WDTTMR Bits

extern __at(0x0715) __sfr WDTTMR;

typedef union
  {
  struct
    {
    unsigned PSCNT16            : 1;
    unsigned PSCNT17            : 1;
    unsigned STATE              : 1;
    unsigned WDTTMR0            : 1;
    unsigned WDTTMR1            : 1;
    unsigned WDTTMR2            : 1;
    unsigned WDTTMR3            : 1;
    unsigned WDTTMR4            : 1;
    };

  struct
    {
    unsigned WDTPSCNT16         : 1;
    unsigned WDTPSCNT17         : 1;
    unsigned WDTSTATE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned WDTTMR             : 5;
    };
  } __WDTTMRbits_t;

extern __at(0x0715) volatile __WDTTMRbits_t WDTTMRbits;

#define _PSCNT16                0x01
#define _WDTPSCNT16             0x01
#define _PSCNT17                0x02
#define _WDTPSCNT17             0x02
#define _STATE                  0x04
#define _WDTSTATE               0x04
#define _WDTTMR0                0x08
#define _WDTTMR1                0x10
#define _WDTTMR2                0x20
#define _WDTTMR3                0x40
#define _WDTTMR4                0x80

//==============================================================================

extern __at(0x0718) __sfr SCANLADR;

//==============================================================================
//        SCANLADRL Bits

extern __at(0x0718) __sfr SCANLADRL;

typedef union
  {
  struct
    {
    unsigned LDAR0              : 1;
    unsigned LDAR1              : 1;
    unsigned LADR2              : 1;
    unsigned LADR3              : 1;
    unsigned LADR4              : 1;
    unsigned LADR5              : 1;
    unsigned LADR6              : 1;
    unsigned LADR7              : 1;
    };

  struct
    {
    unsigned SCANLADR0          : 1;
    unsigned SCANLADR1          : 1;
    unsigned SCANLADR2          : 1;
    unsigned SCANLADR3          : 1;
    unsigned SCANLADR4          : 1;
    unsigned SCANLADR5          : 1;
    unsigned SCANLADR6          : 1;
    unsigned SCANLADR7          : 1;
    };

  struct
    {
    unsigned LDAR               : 2;
    unsigned                    : 6;
    };
  } __SCANLADRLbits_t;

extern __at(0x0718) volatile __SCANLADRLbits_t SCANLADRLbits;

#define _LDAR0                  0x01
#define _SCANLADR0              0x01
#define _LDAR1                  0x02
#define _SCANLADR1              0x02
#define _LADR2                  0x04
#define _SCANLADR2              0x04
#define _LADR3                  0x08
#define _SCANLADR3              0x08
#define _LADR4                  0x10
#define _SCANLADR4              0x10
#define _LADR5                  0x20
#define _SCANLADR5              0x20
#define _LADR6                  0x40
#define _SCANLADR6              0x40
#define _LADR7                  0x80
#define _SCANLADR7              0x80

//==============================================================================


//==============================================================================
//        SCANLADRH Bits

extern __at(0x0719) __sfr SCANLADRH;

typedef union
  {
  struct
    {
    unsigned LADR8              : 1;
    unsigned LADR9              : 1;
    unsigned LADR10             : 1;
    unsigned LADR11             : 1;
    unsigned LADR12             : 1;
    unsigned LADR13             : 1;
    unsigned LADR14             : 1;
    unsigned LADR15             : 1;
    };

  struct
    {
    unsigned SCANLADR8          : 1;
    unsigned SCANLADR9          : 1;
    unsigned SCANLADR10         : 1;
    unsigned SCANLADR11         : 1;
    unsigned SCANLADR12         : 1;
    unsigned SCANLADR13         : 1;
    unsigned SCANLADR14         : 1;
    unsigned SCANLADR15         : 1;
    };
  } __SCANLADRHbits_t;

extern __at(0x0719) volatile __SCANLADRHbits_t SCANLADRHbits;

#define _LADR8                  0x01
#define _SCANLADR8              0x01
#define _LADR9                  0x02
#define _SCANLADR9              0x02
#define _LADR10                 0x04
#define _SCANLADR10             0x04
#define _LADR11                 0x08
#define _SCANLADR11             0x08
#define _LADR12                 0x10
#define _SCANLADR12             0x10
#define _LADR13                 0x20
#define _SCANLADR13             0x20
#define _LADR14                 0x40
#define _SCANLADR14             0x40
#define _LADR15                 0x80
#define _SCANLADR15             0x80

//==============================================================================

extern __at(0x071A) __sfr SCANHADR;

//==============================================================================
//        SCANHADRL Bits

extern __at(0x071A) __sfr SCANHADRL;

typedef union
  {
  struct
    {
    unsigned HADR0              : 1;
    unsigned HADR1              : 1;
    unsigned HARD2              : 1;
    unsigned HADR3              : 1;
    unsigned HADR4              : 1;
    unsigned HADR5              : 1;
    unsigned HADR6              : 1;
    unsigned HADR7              : 1;
    };

  struct
    {
    unsigned SCANHADR0          : 1;
    unsigned SCANHADR1          : 1;
    unsigned SCANHADR2          : 1;
    unsigned SCANHADR3          : 1;
    unsigned SCANHADR4          : 1;
    unsigned SCANHADR5          : 1;
    unsigned SCANHADR6          : 1;
    unsigned SCANHADR7          : 1;
    };
  } __SCANHADRLbits_t;

extern __at(0x071A) volatile __SCANHADRLbits_t SCANHADRLbits;

#define _HADR0                  0x01
#define _SCANHADR0              0x01
#define _HADR1                  0x02
#define _SCANHADR1              0x02
#define _HARD2                  0x04
#define _SCANHADR2              0x04
#define _HADR3                  0x08
#define _SCANHADR3              0x08
#define _HADR4                  0x10
#define _SCANHADR4              0x10
#define _HADR5                  0x20
#define _SCANHADR5              0x20
#define _HADR6                  0x40
#define _SCANHADR6              0x40
#define _HADR7                  0x80
#define _SCANHADR7              0x80

//==============================================================================


//==============================================================================
//        SCANHADRH Bits

extern __at(0x071B) __sfr SCANHADRH;

typedef union
  {
  struct
    {
    unsigned HADR8              : 1;
    unsigned HADR9              : 1;
    unsigned HADR10             : 1;
    unsigned HADR11             : 1;
    unsigned HADR12             : 1;
    unsigned HADR13             : 1;
    unsigned HADR14             : 1;
    unsigned HADR15             : 1;
    };

  struct
    {
    unsigned SCANHADR8          : 1;
    unsigned SCANHADR9          : 1;
    unsigned SCANHADR10         : 1;
    unsigned SCANHADR11         : 1;
    unsigned SCANHADR12         : 1;
    unsigned SCANHADR13         : 1;
    unsigned SCANHADR14         : 1;
    unsigned SCANHADR15         : 1;
    };
  } __SCANHADRHbits_t;

extern __at(0x071B) volatile __SCANHADRHbits_t SCANHADRHbits;

#define _HADR8                  0x01
#define _SCANHADR8              0x01
#define _HADR9                  0x02
#define _SCANHADR9              0x02
#define _HADR10                 0x04
#define _SCANHADR10             0x04
#define _HADR11                 0x08
#define _SCANHADR11             0x08
#define _HADR12                 0x10
#define _SCANHADR12             0x10
#define _HADR13                 0x20
#define _SCANHADR13             0x20
#define _HADR14                 0x40
#define _SCANHADR14             0x40
#define _HADR15                 0x80
#define _SCANHADR15             0x80

//==============================================================================


//==============================================================================
//        SCANCON0 Bits

extern __at(0x071C) __sfr SCANCON0;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned                    : 1;
    unsigned INTM               : 1;
    unsigned INVALID            : 1;
    unsigned BUSY               : 1;
    unsigned SCANGO             : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned SCANMODE0          : 1;
    unsigned SCANMODE1          : 1;
    unsigned                    : 1;
    unsigned SCANINTM           : 1;
    unsigned SCANINVALID        : 1;
    unsigned SCANBUSY           : 1;
    unsigned                    : 1;
    unsigned SCANEN             : 1;
    };

  struct
    {
    unsigned MODE               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned SCANMODE           : 2;
    unsigned                    : 6;
    };
  } __SCANCON0bits_t;

extern __at(0x071C) volatile __SCANCON0bits_t SCANCON0bits;

#define _SCANCON0_MODE0         0x01
#define _SCANCON0_SCANMODE0     0x01
#define _SCANCON0_MODE1         0x02
#define _SCANCON0_SCANMODE1     0x02
#define _SCANCON0_INTM          0x08
#define _SCANCON0_SCANINTM      0x08
#define _SCANCON0_INVALID       0x10
#define _SCANCON0_SCANINVALID   0x10
#define _SCANCON0_BUSY          0x20
#define _SCANCON0_SCANBUSY      0x20
#define _SCANCON0_SCANGO        0x40
#define _SCANCON0_EN            0x80
#define _SCANCON0_SCANEN        0x80

//==============================================================================


//==============================================================================
//        SCANTRIG Bits

extern __at(0x071D) __sfr SCANTRIG;

typedef union
  {
  struct
    {
    unsigned TSEL0              : 1;
    unsigned TSEL1              : 1;
    unsigned TSEL2              : 1;
    unsigned TSEL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SCANTSEL0          : 1;
    unsigned SCANTSEL1          : 1;
    unsigned SCANTSEL2          : 1;
    unsigned SCANTSEL3          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TSEL               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned SCANTSEL           : 4;
    unsigned                    : 4;
    };
  } __SCANTRIGbits_t;

extern __at(0x071D) volatile __SCANTRIGbits_t SCANTRIGbits;

#define _TSEL0                  0x01
#define _SCANTSEL0              0x01
#define _TSEL1                  0x02
#define _SCANTSEL1              0x02
#define _TSEL2                  0x04
#define _SCANTSEL2              0x04
#define _TSEL3                  0x08
#define _SCANTSEL3              0x08

//==============================================================================

extern __at(0x0791) __sfr CRCDAT;

//==============================================================================
//        CRCDATL Bits

extern __at(0x0791) __sfr CRCDATL;

typedef union
  {
  struct
    {
    unsigned DAT0               : 1;
    unsigned DAT1               : 1;
    unsigned DAT2               : 1;
    unsigned DAT3               : 1;
    unsigned DAT4               : 1;
    unsigned DAT5               : 1;
    unsigned DAT6               : 1;
    unsigned DAT7               : 1;
    };

  struct
    {
    unsigned CRCDAT0            : 1;
    unsigned CRCDAT1            : 1;
    unsigned CRCDAT2            : 1;
    unsigned CRCDAT3            : 1;
    unsigned CRCDAT4            : 1;
    unsigned CRCDAT5            : 1;
    unsigned CRCDAT6            : 1;
    unsigned CRDCDAT7           : 1;
    };

  struct
    {
    unsigned CRCDAT             : 7;
    unsigned                    : 1;
    };
  } __CRCDATLbits_t;

extern __at(0x0791) volatile __CRCDATLbits_t CRCDATLbits;

#define _DAT0                   0x01
#define _CRCDAT0                0x01
#define _DAT1                   0x02
#define _CRCDAT1                0x02
#define _DAT2                   0x04
#define _CRCDAT2                0x04
#define _DAT3                   0x08
#define _CRCDAT3                0x08
#define _DAT4                   0x10
#define _CRCDAT4                0x10
#define _DAT5                   0x20
#define _CRCDAT5                0x20
#define _DAT6                   0x40
#define _CRCDAT6                0x40
#define _DAT7                   0x80
#define _CRDCDAT7               0x80

//==============================================================================


//==============================================================================
//        CRCDATH Bits

extern __at(0x0792) __sfr CRCDATH;

typedef union
  {
  struct
    {
    unsigned DAT8               : 1;
    unsigned DAT9               : 1;
    unsigned DAT10              : 1;
    unsigned DAT11              : 1;
    unsigned DAT12              : 1;
    unsigned DAT13              : 1;
    unsigned DAT14              : 1;
    unsigned DAT15              : 1;
    };

  struct
    {
    unsigned CRCDAT8            : 1;
    unsigned CRCDAT9            : 1;
    unsigned CRCDAT10           : 1;
    unsigned CRCDAT11           : 1;
    unsigned CRCDAT12           : 1;
    unsigned CRCDAT13           : 1;
    unsigned CRCDAT14           : 1;
    unsigned CRCDAT15           : 1;
    };
  } __CRCDATHbits_t;

extern __at(0x0792) volatile __CRCDATHbits_t CRCDATHbits;

#define _DAT8                   0x01
#define _CRCDAT8                0x01
#define _DAT9                   0x02
#define _CRCDAT9                0x02
#define _DAT10                  0x04
#define _CRCDAT10               0x04
#define _DAT11                  0x08
#define _CRCDAT11               0x08
#define _DAT12                  0x10
#define _CRCDAT12               0x10
#define _DAT13                  0x20
#define _CRCDAT13               0x20
#define _DAT14                  0x40
#define _CRCDAT14               0x40
#define _DAT15                  0x80
#define _CRCDAT15               0x80

//==============================================================================

extern __at(0x0793) __sfr CRCACC;

//==============================================================================
//        CRCACCL Bits

extern __at(0x0793) __sfr CRCACCL;

typedef union
  {
  struct
    {
    unsigned ACC0               : 1;
    unsigned ACC1               : 1;
    unsigned ACC2               : 1;
    unsigned ACC3               : 1;
    unsigned ACC4               : 1;
    unsigned ACC5               : 1;
    unsigned ACC6               : 1;
    unsigned ACC7               : 1;
    };

  struct
    {
    unsigned CRCACC0            : 1;
    unsigned CRCACC1            : 1;
    unsigned CRCACC2            : 1;
    unsigned CRCACC3            : 1;
    unsigned CRCACC4            : 1;
    unsigned CRCACC5            : 1;
    unsigned CRCACC6            : 1;
    unsigned CRCACC7            : 1;
    };
  } __CRCACCLbits_t;

extern __at(0x0793) volatile __CRCACCLbits_t CRCACCLbits;

#define _ACC0                   0x01
#define _CRCACC0                0x01
#define _ACC1                   0x02
#define _CRCACC1                0x02
#define _ACC2                   0x04
#define _CRCACC2                0x04
#define _ACC3                   0x08
#define _CRCACC3                0x08
#define _ACC4                   0x10
#define _CRCACC4                0x10
#define _ACC5                   0x20
#define _CRCACC5                0x20
#define _ACC6                   0x40
#define _CRCACC6                0x40
#define _ACC7                   0x80
#define _CRCACC7                0x80

//==============================================================================


//==============================================================================
//        CRCACCH Bits

extern __at(0x0794) __sfr CRCACCH;

typedef union
  {
  struct
    {
    unsigned ACC8               : 1;
    unsigned ACC9               : 1;
    unsigned ACC10              : 1;
    unsigned ACC11              : 1;
    unsigned ACC12              : 1;
    unsigned ACC13              : 1;
    unsigned ACC14              : 1;
    unsigned ACC15              : 1;
    };

  struct
    {
    unsigned CRCACC8            : 1;
    unsigned CRCACC9            : 1;
    unsigned CRCACC10           : 1;
    unsigned CRCACC11           : 1;
    unsigned CRCACC12           : 1;
    unsigned CRCACC13           : 1;
    unsigned CRCACC14           : 1;
    unsigned CRCACC15           : 1;
    };
  } __CRCACCHbits_t;

extern __at(0x0794) volatile __CRCACCHbits_t CRCACCHbits;

#define _ACC8                   0x01
#define _CRCACC8                0x01
#define _ACC9                   0x02
#define _CRCACC9                0x02
#define _ACC10                  0x04
#define _CRCACC10               0x04
#define _ACC11                  0x08
#define _CRCACC11               0x08
#define _ACC12                  0x10
#define _CRCACC12               0x10
#define _ACC13                  0x20
#define _CRCACC13               0x20
#define _ACC14                  0x40
#define _CRCACC14               0x40
#define _ACC15                  0x80
#define _CRCACC15               0x80

//==============================================================================

extern __at(0x0795) __sfr CRCSHIFT;

//==============================================================================
//        CRCSHIFTL Bits

extern __at(0x0795) __sfr CRCSHIFTL;

typedef union
  {
  struct
    {
    unsigned SHIFT0             : 1;
    unsigned SHIFT1             : 1;
    unsigned SHIFT2             : 1;
    unsigned SHIFT3             : 1;
    unsigned SHIFT4             : 1;
    unsigned SHIFT5             : 1;
    unsigned SHIFT6             : 1;
    unsigned SHIFT7             : 1;
    };

  struct
    {
    unsigned CRCSHIFT0          : 1;
    unsigned CRCSHIFT1          : 1;
    unsigned CRCSHIFT2          : 1;
    unsigned CRCSHIFT3          : 1;
    unsigned CRCSHIFT4          : 1;
    unsigned CRCSHIFT5          : 1;
    unsigned CRCSHIFT6          : 1;
    unsigned CRCSHIFT7          : 1;
    };
  } __CRCSHIFTLbits_t;

extern __at(0x0795) volatile __CRCSHIFTLbits_t CRCSHIFTLbits;

#define _SHIFT0                 0x01
#define _CRCSHIFT0              0x01
#define _SHIFT1                 0x02
#define _CRCSHIFT1              0x02
#define _SHIFT2                 0x04
#define _CRCSHIFT2              0x04
#define _SHIFT3                 0x08
#define _CRCSHIFT3              0x08
#define _SHIFT4                 0x10
#define _CRCSHIFT4              0x10
#define _SHIFT5                 0x20
#define _CRCSHIFT5              0x20
#define _SHIFT6                 0x40
#define _CRCSHIFT6              0x40
#define _SHIFT7                 0x80
#define _CRCSHIFT7              0x80

//==============================================================================


//==============================================================================
//        CRCSHIFTH Bits

extern __at(0x0796) __sfr CRCSHIFTH;

typedef union
  {
  struct
    {
    unsigned SHIFT8             : 1;
    unsigned SHIFT9             : 1;
    unsigned SHIFT10            : 1;
    unsigned SHIFT11            : 1;
    unsigned SHIFT12            : 1;
    unsigned SHIFT13            : 1;
    unsigned SHIFT14            : 1;
    unsigned SHIFT15            : 1;
    };

  struct
    {
    unsigned CRCSHIFT8          : 1;
    unsigned CRCSHIFT9          : 1;
    unsigned CRCSHIFT10         : 1;
    unsigned CRCSHIFT11         : 1;
    unsigned CRCSHIFT12         : 1;
    unsigned CRCSHIFT13         : 1;
    unsigned CRCSHIFT14         : 1;
    unsigned CRCSHIFT15         : 1;
    };
  } __CRCSHIFTHbits_t;

extern __at(0x0796) volatile __CRCSHIFTHbits_t CRCSHIFTHbits;

#define _SHIFT8                 0x01
#define _CRCSHIFT8              0x01
#define _SHIFT9                 0x02
#define _CRCSHIFT9              0x02
#define _SHIFT10                0x04
#define _CRCSHIFT10             0x04
#define _SHIFT11                0x08
#define _CRCSHIFT11             0x08
#define _SHIFT12                0x10
#define _CRCSHIFT12             0x10
#define _SHIFT13                0x20
#define _CRCSHIFT13             0x20
#define _SHIFT14                0x40
#define _CRCSHIFT14             0x40
#define _SHIFT15                0x80
#define _CRCSHIFT15             0x80

//==============================================================================

extern __at(0x0797) __sfr CRCXOR;

//==============================================================================
//        CRCXORL Bits

extern __at(0x0797) __sfr CRCXORL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned XOR1               : 1;
    unsigned XOR2               : 1;
    unsigned XOR3               : 1;
    unsigned XOR4               : 1;
    unsigned XOR5               : 1;
    unsigned XOR6               : 1;
    unsigned XOR7               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned CRCXOR1            : 1;
    unsigned CRCXOR2            : 1;
    unsigned CRCXOR3            : 1;
    unsigned CRCXOR4            : 1;
    unsigned CRCXOR5            : 1;
    unsigned CRCXOR6            : 1;
    unsigned CRCXOR7            : 1;
    };
  } __CRCXORLbits_t;

extern __at(0x0797) volatile __CRCXORLbits_t CRCXORLbits;

#define _XOR1                   0x02
#define _CRCXOR1                0x02
#define _XOR2                   0x04
#define _CRCXOR2                0x04
#define _XOR3                   0x08
#define _CRCXOR3                0x08
#define _XOR4                   0x10
#define _CRCXOR4                0x10
#define _XOR5                   0x20
#define _CRCXOR5                0x20
#define _XOR6                   0x40
#define _CRCXOR6                0x40
#define _XOR7                   0x80
#define _CRCXOR7                0x80

//==============================================================================


//==============================================================================
//        CRCXORH Bits

extern __at(0x0798) __sfr CRCXORH;

typedef union
  {
  struct
    {
    unsigned XOR8               : 1;
    unsigned XOR9               : 1;
    unsigned XOR10              : 1;
    unsigned XOR11              : 1;
    unsigned XOR12              : 1;
    unsigned XOR13              : 1;
    unsigned XOR14              : 1;
    unsigned XOR15              : 1;
    };

  struct
    {
    unsigned CRCXOR8            : 1;
    unsigned CRCXOR9            : 1;
    unsigned CRCXOR10           : 1;
    unsigned CRCXOR11           : 1;
    unsigned CRCXOR12           : 1;
    unsigned CRCXOR13           : 1;
    unsigned CRCXOR14           : 1;
    unsigned CRCXOR15           : 1;
    };
  } __CRCXORHbits_t;

extern __at(0x0798) volatile __CRCXORHbits_t CRCXORHbits;

#define _XOR8                   0x01
#define _CRCXOR8                0x01
#define _XOR9                   0x02
#define _CRCXOR9                0x02
#define _XOR10                  0x04
#define _CRCXOR10               0x04
#define _XOR11                  0x08
#define _CRCXOR11               0x08
#define _XOR12                  0x10
#define _CRCXOR12               0x10
#define _XOR13                  0x20
#define _CRCXOR13               0x20
#define _XOR14                  0x40
#define _CRCXOR14               0x40
#define _XOR15                  0x80
#define _CRCXOR15               0x80

//==============================================================================


//==============================================================================
//        CRCCON0 Bits

extern __at(0x0799) __sfr CRCCON0;

typedef union
  {
  struct
    {
    unsigned FULL               : 1;
    unsigned SHIFTM             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ACCM               : 1;
    unsigned BUSY               : 1;
    unsigned CRCGO              : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CRCFULL            : 1;
    unsigned CRCSHIFTM          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CRCACCM            : 1;
    unsigned CRCBUSY            : 1;
    unsigned                    : 1;
    unsigned CRCEN              : 1;
    };
  } __CRCCON0bits_t;

extern __at(0x0799) volatile __CRCCON0bits_t CRCCON0bits;

#define _CRCCON0_FULL           0x01
#define _CRCCON0_CRCFULL        0x01
#define _CRCCON0_SHIFTM         0x02
#define _CRCCON0_CRCSHIFTM      0x02
#define _CRCCON0_ACCM           0x10
#define _CRCCON0_CRCACCM        0x10
#define _CRCCON0_BUSY           0x20
#define _CRCCON0_CRCBUSY        0x20
#define _CRCCON0_CRCGO          0x40
#define _CRCCON0_EN             0x80
#define _CRCCON0_CRCEN          0x80

//==============================================================================


//==============================================================================
//        CRCCON1 Bits

extern __at(0x079A) __sfr CRCCON1;

typedef union
  {
  struct
    {
    unsigned PLEN0              : 1;
    unsigned PLEN1              : 1;
    unsigned PLEN2              : 1;
    unsigned PLEN3              : 1;
    unsigned DLEN0              : 1;
    unsigned DLEN1              : 1;
    unsigned DLEN2              : 1;
    unsigned DLEN3              : 1;
    };

  struct
    {
    unsigned CRCPLEN0           : 1;
    unsigned CRCPLEN1           : 1;
    unsigned CRCPLEN2           : 1;
    unsigned CRCPLEN3           : 1;
    unsigned CRCDLEN0           : 1;
    unsigned CRCDLEN1           : 1;
    unsigned CRCDLEN2           : 1;
    unsigned CRCDLEN3           : 1;
    };

  struct
    {
    unsigned CRCPLEN            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned PLEN               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CRCDLEN            : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DLEN               : 4;
    };
  } __CRCCON1bits_t;

extern __at(0x079A) volatile __CRCCON1bits_t CRCCON1bits;

#define _PLEN0                  0x01
#define _CRCPLEN0               0x01
#define _PLEN1                  0x02
#define _CRCPLEN1               0x02
#define _PLEN2                  0x04
#define _CRCPLEN2               0x04
#define _PLEN3                  0x08
#define _CRCPLEN3               0x08
#define _DLEN0                  0x10
#define _CRCDLEN0               0x10
#define _DLEN1                  0x20
#define _CRCDLEN1               0x20
#define _DLEN2                  0x40
#define _CRCDLEN2               0x40
#define _DLEN3                  0x80
#define _CRCDLEN3               0x80

//==============================================================================

extern __at(0x080C) __sfr AT1RES;

//==============================================================================
//        AT1RESL Bits

extern __at(0x080C) __sfr AT1RESL;

typedef union
  {
  struct
    {
    unsigned AT1RES0            : 1;
    unsigned AT1RES1            : 1;
    unsigned AT1RES2            : 1;
    unsigned AT1RES3            : 1;
    unsigned AT1RES4            : 1;
    unsigned AT1RES5            : 1;
    unsigned AT1RES6            : 1;
    unsigned AT1RES7            : 1;
    };

  struct
    {
    unsigned RES0               : 1;
    unsigned RES1               : 1;
    unsigned RES2               : 1;
    unsigned RES3               : 1;
    unsigned RES4               : 1;
    unsigned RES5               : 1;
    unsigned RES6               : 1;
    unsigned RES7               : 1;
    };
  } __AT1RESLbits_t;

extern __at(0x080C) volatile __AT1RESLbits_t AT1RESLbits;

#define _AT1RES0                0x01
#define _RES0                   0x01
#define _AT1RES1                0x02
#define _RES1                   0x02
#define _AT1RES2                0x04
#define _RES2                   0x04
#define _AT1RES3                0x08
#define _RES3                   0x08
#define _AT1RES4                0x10
#define _RES4                   0x10
#define _AT1RES5                0x20
#define _RES5                   0x20
#define _AT1RES6                0x40
#define _RES6                   0x40
#define _AT1RES7                0x80
#define _RES7                   0x80

//==============================================================================


//==============================================================================
//        AT1RESH Bits

extern __at(0x080D) __sfr AT1RESH;

typedef union
  {
  struct
    {
    unsigned AT1RES8            : 1;
    unsigned AT1RES9            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RES8               : 1;
    unsigned RES9               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __AT1RESHbits_t;

extern __at(0x080D) volatile __AT1RESHbits_t AT1RESHbits;

#define _AT1RES8                0x01
#define _RES8                   0x01
#define _AT1RES9                0x02
#define _RES9                   0x02

//==============================================================================

extern __at(0x080E) __sfr AT1MISS;

//==============================================================================
//        AT1MISSL Bits

extern __at(0x080E) __sfr AT1MISSL;

typedef union
  {
  struct
    {
    unsigned AT1MISS0           : 1;
    unsigned AT1MISS1           : 1;
    unsigned AT1MISS2           : 1;
    unsigned AT1MISS3           : 1;
    unsigned AT1MISS4           : 1;
    unsigned AT1MISS5           : 1;
    unsigned AT1MISS6           : 1;
    unsigned AT1MISS7           : 1;
    };

  struct
    {
    unsigned MISS0              : 1;
    unsigned MISS1              : 1;
    unsigned MISS2              : 1;
    unsigned MISS3              : 1;
    unsigned MISS4              : 1;
    unsigned MISS5              : 1;
    unsigned MISS6              : 1;
    unsigned MISS7              : 1;
    };
  } __AT1MISSLbits_t;

extern __at(0x080E) volatile __AT1MISSLbits_t AT1MISSLbits;

#define _AT1MISS0               0x01
#define _MISS0                  0x01
#define _AT1MISS1               0x02
#define _MISS1                  0x02
#define _AT1MISS2               0x04
#define _MISS2                  0x04
#define _AT1MISS3               0x08
#define _MISS3                  0x08
#define _AT1MISS4               0x10
#define _MISS4                  0x10
#define _AT1MISS5               0x20
#define _MISS5                  0x20
#define _AT1MISS6               0x40
#define _MISS6                  0x40
#define _AT1MISS7               0x80
#define _MISS7                  0x80

//==============================================================================


//==============================================================================
//        AT1MISSH Bits

extern __at(0x080F) __sfr AT1MISSH;

typedef union
  {
  struct
    {
    unsigned AT1MISS8           : 1;
    unsigned AT1MISS9           : 1;
    unsigned AT1MISS10          : 1;
    unsigned AT1MISS11          : 1;
    unsigned AT1MISS12          : 1;
    unsigned AT1MISS13          : 1;
    unsigned AT1MISS14          : 1;
    unsigned AT1MISS15          : 1;
    };

  struct
    {
    unsigned MISS8              : 1;
    unsigned MISS9              : 1;
    unsigned MISS10             : 1;
    unsigned MISS11             : 1;
    unsigned MISS12             : 1;
    unsigned MISS13             : 1;
    unsigned MISS14             : 1;
    unsigned MISS15             : 1;
    };
  } __AT1MISSHbits_t;

extern __at(0x080F) volatile __AT1MISSHbits_t AT1MISSHbits;

#define _AT1MISS8               0x01
#define _MISS8                  0x01
#define _AT1MISS9               0x02
#define _MISS9                  0x02
#define _AT1MISS10              0x04
#define _MISS10                 0x04
#define _AT1MISS11              0x08
#define _MISS11                 0x08
#define _AT1MISS12              0x10
#define _MISS12                 0x10
#define _AT1MISS13              0x20
#define _MISS13                 0x20
#define _AT1MISS14              0x40
#define _MISS14                 0x40
#define _AT1MISS15              0x80
#define _MISS15                 0x80

//==============================================================================

extern __at(0x0810) __sfr AT1PER;

//==============================================================================
//        AT1PERL Bits

extern __at(0x0810) __sfr AT1PERL;

typedef union
  {
  struct
    {
    unsigned AT1PER0            : 1;
    unsigned AT1PER1            : 1;
    unsigned AT1PER2            : 1;
    unsigned AT1PER3            : 1;
    unsigned AT1PER4            : 1;
    unsigned AT1PER5            : 1;
    unsigned AT1PER6            : 1;
    unsigned AT1PER7            : 1;
    };

  struct
    {
    unsigned PER0               : 1;
    unsigned PER1               : 1;
    unsigned PER2               : 1;
    unsigned PER3               : 1;
    unsigned PER4               : 1;
    unsigned PER5               : 1;
    unsigned PER6               : 1;
    unsigned PER7               : 1;
    };

  struct
    {
    unsigned PERL0              : 1;
    unsigned PERL1              : 1;
    unsigned PERL2              : 1;
    unsigned PERL3              : 1;
    unsigned PERL4              : 1;
    unsigned PERL5              : 1;
    unsigned PERL6              : 1;
    unsigned PERL7              : 1;
    };
  } __AT1PERLbits_t;

extern __at(0x0810) volatile __AT1PERLbits_t AT1PERLbits;

#define _AT1PER0                0x01
#define _PER0                   0x01
#define _PERL0                  0x01
#define _AT1PER1                0x02
#define _PER1                   0x02
#define _PERL1                  0x02
#define _AT1PER2                0x04
#define _PER2                   0x04
#define _PERL2                  0x04
#define _AT1PER3                0x08
#define _PER3                   0x08
#define _PERL3                  0x08
#define _AT1PER4                0x10
#define _PER4                   0x10
#define _PERL4                  0x10
#define _AT1PER5                0x20
#define _PER5                   0x20
#define _PERL5                  0x20
#define _AT1PER6                0x40
#define _PER6                   0x40
#define _PERL6                  0x40
#define _AT1PER7                0x80
#define _PER7                   0x80
#define _PERL7                  0x80

//==============================================================================


//==============================================================================
//        AT1PERH Bits

extern __at(0x0811) __sfr AT1PERH;

typedef union
  {
  struct
    {
    unsigned AT1PER8            : 1;
    unsigned AT1PER9            : 1;
    unsigned AT1PER10           : 1;
    unsigned AT1PER11           : 1;
    unsigned AT1PER12           : 1;
    unsigned AT1PER13           : 1;
    unsigned AT1PER14           : 1;
    unsigned AT1POV             : 1;
    };

  struct
    {
    unsigned PER8               : 1;
    unsigned PER9               : 1;
    unsigned PER10              : 1;
    unsigned PER11              : 1;
    unsigned PER12              : 1;
    unsigned PER13              : 1;
    unsigned PER14              : 1;
    unsigned PER15              : 1;
    };

  struct
    {
    unsigned PERH0              : 1;
    unsigned PERH1              : 1;
    unsigned PERH2              : 1;
    unsigned PERH3              : 1;
    unsigned PERH4              : 1;
    unsigned PERH5              : 1;
    unsigned PERH6              : 1;
    unsigned PERH7              : 1;
    };
  } __AT1PERHbits_t;

extern __at(0x0811) volatile __AT1PERHbits_t AT1PERHbits;

#define _AT1PER8                0x01
#define _PER8                   0x01
#define _PERH0                  0x01
#define _AT1PER9                0x02
#define _PER9                   0x02
#define _PERH1                  0x02
#define _AT1PER10               0x04
#define _PER10                  0x04
#define _PERH2                  0x04
#define _AT1PER11               0x08
#define _PER11                  0x08
#define _PERH3                  0x08
#define _AT1PER12               0x10
#define _PER12                  0x10
#define _PERH4                  0x10
#define _AT1PER13               0x20
#define _PER13                  0x20
#define _PERH5                  0x20
#define _AT1PER14               0x40
#define _PER14                  0x40
#define _PERH6                  0x40
#define _AT1POV                 0x80
#define _PER15                  0x80
#define _PERH7                  0x80

//==============================================================================

extern __at(0x0812) __sfr AT1PHS;

//==============================================================================
//        AT1PHSL Bits

extern __at(0x0812) __sfr AT1PHSL;

typedef union
  {
  struct
    {
    unsigned AT1PHS0            : 1;
    unsigned AT1PHS1            : 1;
    unsigned AT1PHS2            : 1;
    unsigned AT1PHS3            : 1;
    unsigned AT1PHS4            : 1;
    unsigned AT1PHS5            : 1;
    unsigned AT1PHS6            : 1;
    unsigned AT1PHS7            : 1;
    };

  struct
    {
    unsigned PHS0               : 1;
    unsigned PHS1               : 1;
    unsigned PHS2               : 1;
    unsigned PHS3               : 1;
    unsigned PHS4               : 1;
    unsigned PHS5               : 1;
    unsigned PHS6               : 1;
    unsigned PHS7               : 1;
    };
  } __AT1PHSLbits_t;

extern __at(0x0812) volatile __AT1PHSLbits_t AT1PHSLbits;

#define _AT1PHS0                0x01
#define _PHS0                   0x01
#define _AT1PHS1                0x02
#define _PHS1                   0x02
#define _AT1PHS2                0x04
#define _PHS2                   0x04
#define _AT1PHS3                0x08
#define _PHS3                   0x08
#define _AT1PHS4                0x10
#define _PHS4                   0x10
#define _AT1PHS5                0x20
#define _PHS5                   0x20
#define _AT1PHS6                0x40
#define _PHS6                   0x40
#define _AT1PHS7                0x80
#define _PHS7                   0x80

//==============================================================================


//==============================================================================
//        AT1PHSH Bits

extern __at(0x0813) __sfr AT1PHSH;

typedef union
  {
  struct
    {
    unsigned AT1PHS8            : 1;
    unsigned AT1PHS9            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PHS8               : 1;
    unsigned PHS9               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PHSL8              : 1;
    unsigned PHSL9              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __AT1PHSHbits_t;

extern __at(0x0813) volatile __AT1PHSHbits_t AT1PHSHbits;

#define _AT1PHS8                0x01
#define _PHS8                   0x01
#define _PHSL8                  0x01
#define _AT1PHS9                0x02
#define _PHS9                   0x02
#define _PHSL9                  0x02

//==============================================================================


//==============================================================================
//        AT1CON0 Bits

extern __at(0x0814) __sfr AT1CON0;

typedef union
  {
  struct
    {
    unsigned MODE               : 1;
    unsigned APMOD              : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PREC               : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned AT1MODE            : 1;
    unsigned AT1APMOD           : 1;
    unsigned                    : 1;
    unsigned AT1POL             : 1;
    unsigned AT1PS0             : 1;
    unsigned AT1PS1             : 1;
    unsigned AT1PREC            : 1;
    unsigned AT1EN              : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned AT1PS              : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PS                 : 2;
    unsigned                    : 2;
    };
  } __AT1CON0bits_t;

extern __at(0x0814) volatile __AT1CON0bits_t AT1CON0bits;

#define _MODE                   0x01
#define _AT1MODE                0x01
#define _APMOD                  0x02
#define _AT1APMOD               0x02
#define _POL                    0x08
#define _AT1POL                 0x08
#define _PS0                    0x10
#define _AT1PS0                 0x10
#define _PS1                    0x20
#define _AT1PS1                 0x20
#define _PREC                   0x40
#define _AT1PREC                0x40
#define _EN                     0x80
#define _AT1EN                  0x80

//==============================================================================


//==============================================================================
//        AT1CON1 Bits

extern __at(0x0815) __sfr AT1CON1;

typedef union
  {
  struct
    {
    unsigned VALID              : 1;
    unsigned ACCS               : 1;
    unsigned MPP                : 1;
    unsigned                    : 1;
    unsigned PRP                : 1;
    unsigned                    : 1;
    unsigned PHP                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AT1VALID           : 1;
    unsigned AT1ACCS            : 1;
    unsigned AT1MPP             : 1;
    unsigned                    : 1;
    unsigned AT1PRP             : 1;
    unsigned                    : 1;
    unsigned AT1PHP             : 1;
    unsigned                    : 1;
    };
  } __AT1CON1bits_t;

extern __at(0x0815) volatile __AT1CON1bits_t AT1CON1bits;

#define _VALID                  0x01
#define _AT1VALID               0x01
#define _ACCS                   0x02
#define _AT1ACCS                0x02
#define _MPP                    0x04
#define _AT1MPP                 0x04
#define _PRP                    0x10
#define _AT1PRP                 0x10
#define _PHP                    0x40
#define _AT1PHP                 0x40

//==============================================================================


//==============================================================================
//        AT1IR0 Bits

extern __at(0x0816) __sfr AT1IR0;

typedef struct
  {
  unsigned AT1PERIF             : 1;
  unsigned AT1MISSIF            : 1;
  unsigned AT1PHSIF             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __AT1IR0bits_t;

extern __at(0x0816) volatile __AT1IR0bits_t AT1IR0bits;

#define _AT1PERIF               0x01
#define _AT1MISSIF              0x02
#define _AT1PHSIF               0x04

//==============================================================================


//==============================================================================
//        AT1IE0 Bits

extern __at(0x0817) __sfr AT1IE0;

typedef struct
  {
  unsigned AT1PERIE             : 1;
  unsigned AT1MISSIE            : 1;
  unsigned AT1PHSIE             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __AT1IE0bits_t;

extern __at(0x0817) volatile __AT1IE0bits_t AT1IE0bits;

#define _AT1PERIE               0x01
#define _AT1MISSIE              0x02
#define _AT1PHSIE               0x04

//==============================================================================


//==============================================================================
//        AT1IR1 Bits

extern __at(0x0818) __sfr AT1IR1;

typedef struct
  {
  unsigned AT1CC1IF             : 1;
  unsigned AT1CC2IF             : 1;
  unsigned AT1CC3IF             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __AT1IR1bits_t;

extern __at(0x0818) volatile __AT1IR1bits_t AT1IR1bits;

#define _AT1CC1IF               0x01
#define _AT1CC2IF               0x02
#define _AT1CC3IF               0x04

//==============================================================================


//==============================================================================
//        AT1IE1 Bits

extern __at(0x0819) __sfr AT1IE1;

typedef struct
  {
  unsigned AT1CC1IE             : 1;
  unsigned AT1CC2IE             : 1;
  unsigned AT1CC3IE             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __AT1IE1bits_t;

extern __at(0x0819) volatile __AT1IE1bits_t AT1IE1bits;

#define _AT1CC1IE               0x01
#define _AT1CC2IE               0x02
#define _AT1CC3IE               0x04

//==============================================================================

extern __at(0x081A) __sfr AT1STPT;

//==============================================================================
//        AT1STPTL Bits

extern __at(0x081A) __sfr AT1STPTL;

typedef union
  {
  struct
    {
    unsigned AT1STPT0           : 1;
    unsigned AT1STPT1           : 1;
    unsigned AT1STPT2           : 1;
    unsigned AT1STPT3           : 1;
    unsigned AT1STPT4           : 1;
    unsigned AT1STPT5           : 1;
    unsigned AT1STPT6           : 1;
    unsigned AT1STPT7           : 1;
    };

  struct
    {
    unsigned STPT0              : 1;
    unsigned STPT1              : 1;
    unsigned STPT2              : 1;
    unsigned STPT3              : 1;
    unsigned STPT4              : 1;
    unsigned STPT5              : 1;
    unsigned STPT6              : 1;
    unsigned STPT7              : 1;
    };
  } __AT1STPTLbits_t;

extern __at(0x081A) volatile __AT1STPTLbits_t AT1STPTLbits;

#define _AT1STPT0               0x01
#define _STPT0                  0x01
#define _AT1STPT1               0x02
#define _STPT1                  0x02
#define _AT1STPT2               0x04
#define _STPT2                  0x04
#define _AT1STPT3               0x08
#define _STPT3                  0x08
#define _AT1STPT4               0x10
#define _STPT4                  0x10
#define _AT1STPT5               0x20
#define _STPT5                  0x20
#define _AT1STPT6               0x40
#define _STPT6                  0x40
#define _AT1STPT7               0x80
#define _STPT7                  0x80

//==============================================================================


//==============================================================================
//        AT1STPTH Bits

extern __at(0x081B) __sfr AT1STPTH;

typedef union
  {
  struct
    {
    unsigned AT1STPT8           : 1;
    unsigned AT1STPT9           : 1;
    unsigned AT1STPT10          : 1;
    unsigned AT1STPT11          : 1;
    unsigned AT1STPT12          : 1;
    unsigned AT1STPT13          : 1;
    unsigned AT1STPT14          : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned STPT8              : 1;
    unsigned STPT9              : 1;
    unsigned STPT10             : 1;
    unsigned STPT11             : 1;
    unsigned STPT12             : 1;
    unsigned STPT13             : 1;
    unsigned STPT14             : 1;
    unsigned                    : 1;
    };
  } __AT1STPTHbits_t;

extern __at(0x081B) volatile __AT1STPTHbits_t AT1STPTHbits;

#define _AT1STPT8               0x01
#define _STPT8                  0x01
#define _AT1STPT9               0x02
#define _STPT9                  0x02
#define _AT1STPT10              0x04
#define _STPT10                 0x04
#define _AT1STPT11              0x08
#define _STPT11                 0x08
#define _AT1STPT12              0x10
#define _STPT12                 0x10
#define _AT1STPT13              0x20
#define _STPT13                 0x20
#define _AT1STPT14              0x40
#define _STPT14                 0x40

//==============================================================================

extern __at(0x081C) __sfr AT1ERR;

//==============================================================================
//        AT1ERRL Bits

extern __at(0x081C) __sfr AT1ERRL;

typedef union
  {
  struct
    {
    unsigned AT1ERR0            : 1;
    unsigned AT1ERR1            : 1;
    unsigned AT1ERR2            : 1;
    unsigned AT1ERR3            : 1;
    unsigned AT1ERR4            : 1;
    unsigned AT1ERR5            : 1;
    unsigned AT1ERR6            : 1;
    unsigned AT1ERR7            : 1;
    };

  struct
    {
    unsigned ERR0               : 1;
    unsigned ERR1               : 1;
    unsigned ERR2               : 1;
    unsigned ERR3               : 1;
    unsigned ERR4               : 1;
    unsigned ERR5               : 1;
    unsigned ERR6               : 1;
    unsigned ERR7               : 1;
    };

  struct
    {
    unsigned ERRL0              : 1;
    unsigned ERRL1              : 1;
    unsigned ERRL2              : 1;
    unsigned ERRL3              : 1;
    unsigned ERRL4              : 1;
    unsigned ERRL5              : 1;
    unsigned ERRL6              : 1;
    unsigned ERRL7              : 1;
    };
  } __AT1ERRLbits_t;

extern __at(0x081C) volatile __AT1ERRLbits_t AT1ERRLbits;

#define _AT1ERR0                0x01
#define _ERR0                   0x01
#define _ERRL0                  0x01
#define _AT1ERR1                0x02
#define _ERR1                   0x02
#define _ERRL1                  0x02
#define _AT1ERR2                0x04
#define _ERR2                   0x04
#define _ERRL2                  0x04
#define _AT1ERR3                0x08
#define _ERR3                   0x08
#define _ERRL3                  0x08
#define _AT1ERR4                0x10
#define _ERR4                   0x10
#define _ERRL4                  0x10
#define _AT1ERR5                0x20
#define _ERR5                   0x20
#define _ERRL5                  0x20
#define _AT1ERR6                0x40
#define _ERR6                   0x40
#define _ERRL6                  0x40
#define _AT1ERR7                0x80
#define _ERR7                   0x80
#define _ERRL7                  0x80

//==============================================================================


//==============================================================================
//        AT1ERRH Bits

extern __at(0x081D) __sfr AT1ERRH;

typedef union
  {
  struct
    {
    unsigned AT1ERR8            : 1;
    unsigned AT1ERR9            : 1;
    unsigned AT1ERR10           : 1;
    unsigned AT1ERR11           : 1;
    unsigned AT1ERR12           : 1;
    unsigned AT1ERR13           : 1;
    unsigned AT1ERR14           : 1;
    unsigned AT1ERR15           : 1;
    };

  struct
    {
    unsigned ERR8               : 1;
    unsigned ERR9               : 1;
    unsigned ERR10              : 1;
    unsigned ERR11              : 1;
    unsigned ERR12              : 1;
    unsigned ERR13              : 1;
    unsigned ERR14              : 1;
    unsigned ERR15              : 1;
    };

  struct
    {
    unsigned ERRH0              : 1;
    unsigned ERRH1              : 1;
    unsigned ERRH2              : 1;
    unsigned ERRH3              : 1;
    unsigned ERRH4              : 1;
    unsigned ERRH5              : 1;
    unsigned ERRH6              : 1;
    unsigned ERRH7              : 1;
    };
  } __AT1ERRHbits_t;

extern __at(0x081D) volatile __AT1ERRHbits_t AT1ERRHbits;

#define _AT1ERR8                0x01
#define _ERR8                   0x01
#define _ERRH0                  0x01
#define _AT1ERR9                0x02
#define _ERR9                   0x02
#define _ERRH1                  0x02
#define _AT1ERR10               0x04
#define _ERR10                  0x04
#define _ERRH2                  0x04
#define _AT1ERR11               0x08
#define _ERR11                  0x08
#define _ERRH3                  0x08
#define _AT1ERR12               0x10
#define _ERR12                  0x10
#define _ERRH4                  0x10
#define _AT1ERR13               0x20
#define _ERR13                  0x20
#define _ERRH5                  0x20
#define _AT1ERR14               0x40
#define _ERR14                  0x40
#define _ERRH6                  0x40
#define _AT1ERR15               0x80
#define _ERR15                  0x80
#define _ERRH7                  0x80

//==============================================================================


//==============================================================================
//        AT1CLK Bits

extern __at(0x088C) __sfr AT1CLK;

typedef union
  {
  struct
    {
    unsigned CS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AT1CS              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AT1CS0             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __AT1CLKbits_t;

extern __at(0x088C) volatile __AT1CLKbits_t AT1CLKbits;

#define _CS                     0x01
#define _AT1CS                  0x01
#define _CS0                    0x01
#define _AT1CS0                 0x01

//==============================================================================


//==============================================================================
//        AT1SIG Bits

extern __at(0x088D) __sfr AT1SIG;

typedef union
  {
  struct
    {
    unsigned AT1SSEL0           : 1;
    unsigned AT1SSEL1           : 1;
    unsigned AT1SSEL2           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSEL0              : 1;
    unsigned SSEL1              : 1;
    unsigned SSEL2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AT1SSEL            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned SSEL               : 3;
    unsigned                    : 5;
    };
  } __AT1SIGbits_t;

extern __at(0x088D) volatile __AT1SIGbits_t AT1SIGbits;

#define _AT1SSEL0               0x01
#define _SSEL0                  0x01
#define _AT1SSEL1               0x02
#define _SSEL1                  0x02
#define _AT1SSEL2               0x04
#define _SSEL2                  0x04

//==============================================================================


//==============================================================================
//        AT1CSEL1 Bits

extern __at(0x088E) __sfr AT1CSEL1;

typedef union
  {
  struct
    {
    unsigned AT1CP1S0           : 1;
    unsigned AT1CP1S1           : 1;
    unsigned AT1CP1S2           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CP1S0              : 1;
    unsigned CP1S1              : 1;
    unsigned CP1S2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CP1S               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned AT1CP1S            : 3;
    unsigned                    : 5;
    };
  } __AT1CSEL1bits_t;

extern __at(0x088E) volatile __AT1CSEL1bits_t AT1CSEL1bits;

#define _AT1CP1S0               0x01
#define _CP1S0                  0x01
#define _AT1CP1S1               0x02
#define _CP1S1                  0x02
#define _AT1CP1S2               0x04
#define _CP1S2                  0x04

//==============================================================================

extern __at(0x088F) __sfr AT1CC1;

//==============================================================================
//        AT1CC1L Bits

extern __at(0x088F) __sfr AT1CC1L;

typedef union
  {
  struct
    {
    unsigned AT1CC10            : 1;
    unsigned AT1CC11            : 1;
    unsigned AT1CC12            : 1;
    unsigned AT1CC13            : 1;
    unsigned AT1CC14            : 1;
    unsigned AT1CC15            : 1;
    unsigned AT1CC16            : 1;
    unsigned AT1CC17            : 1;
    };

  struct
    {
    unsigned CC10               : 1;
    unsigned CC11               : 1;
    unsigned CC12               : 1;
    unsigned CC13               : 1;
    unsigned CC14               : 1;
    unsigned CC15               : 1;
    unsigned CC16               : 1;
    unsigned CC17               : 1;
    };
  } __AT1CC1Lbits_t;

extern __at(0x088F) volatile __AT1CC1Lbits_t AT1CC1Lbits;

#define _AT1CC10                0x01
#define _CC10                   0x01
#define _AT1CC11                0x02
#define _CC11                   0x02
#define _AT1CC12                0x04
#define _CC12                   0x04
#define _AT1CC13                0x08
#define _CC13                   0x08
#define _AT1CC14                0x10
#define _CC14                   0x10
#define _AT1CC15                0x20
#define _CC15                   0x20
#define _AT1CC16                0x40
#define _CC16                   0x40
#define _AT1CC17                0x80
#define _CC17                   0x80

//==============================================================================


//==============================================================================
//        AT1CC1H Bits

extern __at(0x0890) __sfr AT1CC1H;

typedef union
  {
  struct
    {
    unsigned AT1CC18            : 1;
    unsigned AT1CC19            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CC18               : 1;
    unsigned CC19               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __AT1CC1Hbits_t;

extern __at(0x0890) volatile __AT1CC1Hbits_t AT1CC1Hbits;

#define _AT1CC18                0x01
#define _CC18                   0x01
#define _AT1CC19                0x02
#define _CC19                   0x02

//==============================================================================


//==============================================================================
//        AT1CCON1 Bits

extern __at(0x0891) __sfr AT1CCON1;

typedef union
  {
  struct
    {
    unsigned AT1CC1MODE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AT1CAP1P           : 1;
    unsigned AT1CC1POL          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AT1CC1EN           : 1;
    };

  struct
    {
    unsigned CC1MODE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CAP1P              : 1;
    unsigned CC1POL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CC1EN              : 1;
    };
  } __AT1CCON1bits_t;

extern __at(0x0891) volatile __AT1CCON1bits_t AT1CCON1bits;

#define _AT1CC1MODE             0x01
#define _CC1MODE                0x01
#define _AT1CAP1P               0x08
#define _CAP1P                  0x08
#define _AT1CC1POL              0x10
#define _CC1POL                 0x10
#define _AT1CC1EN               0x80
#define _CC1EN                  0x80

//==============================================================================


//==============================================================================
//        AT1CSEL2 Bits

extern __at(0x0892) __sfr AT1CSEL2;

typedef union
  {
  struct
    {
    unsigned AT1CP2S0           : 1;
    unsigned AT1CP2S1           : 1;
    unsigned AT1CP2S2           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CP2S0              : 1;
    unsigned CP2S1              : 1;
    unsigned CP2S2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AT1CP2S            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CP2S               : 3;
    unsigned                    : 5;
    };
  } __AT1CSEL2bits_t;

extern __at(0x0892) volatile __AT1CSEL2bits_t AT1CSEL2bits;

#define _AT1CP2S0               0x01
#define _CP2S0                  0x01
#define _AT1CP2S1               0x02
#define _CP2S1                  0x02
#define _AT1CP2S2               0x04
#define _CP2S2                  0x04

//==============================================================================

extern __at(0x0893) __sfr AT1CC2;

//==============================================================================
//        AT1CC2L Bits

extern __at(0x0893) __sfr AT1CC2L;

typedef union
  {
  struct
    {
    unsigned AT1CC20            : 1;
    unsigned AT1CC21            : 1;
    unsigned AT1CC22            : 1;
    unsigned AT1CC23            : 1;
    unsigned AT1CC24            : 1;
    unsigned AT1CC25            : 1;
    unsigned AT1CC26            : 1;
    unsigned AT1CC27            : 1;
    };

  struct
    {
    unsigned CC20               : 1;
    unsigned CC21               : 1;
    unsigned CC22               : 1;
    unsigned CC13               : 1;
    unsigned CC24               : 1;
    unsigned CCW5               : 1;
    unsigned CC26               : 1;
    unsigned CC27               : 1;
    };
  } __AT1CC2Lbits_t;

extern __at(0x0893) volatile __AT1CC2Lbits_t AT1CC2Lbits;

#define _AT1CC2L_AT1CC20        0x01
#define _AT1CC2L_CC20           0x01
#define _AT1CC2L_AT1CC21        0x02
#define _AT1CC2L_CC21           0x02
#define _AT1CC2L_AT1CC22        0x04
#define _AT1CC2L_CC22           0x04
#define _AT1CC2L_AT1CC23        0x08
#define _AT1CC2L_CC13           0x08
#define _AT1CC2L_AT1CC24        0x10
#define _AT1CC2L_CC24           0x10
#define _AT1CC2L_AT1CC25        0x20
#define _AT1CC2L_CCW5           0x20
#define _AT1CC2L_AT1CC26        0x40
#define _AT1CC2L_CC26           0x40
#define _AT1CC2L_AT1CC27        0x80
#define _AT1CC2L_CC27           0x80

//==============================================================================


//==============================================================================
//        AT1CC2H Bits

extern __at(0x0894) __sfr AT1CC2H;

typedef union
  {
  struct
    {
    unsigned AT1CC28            : 1;
    unsigned AT1CC29            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CC28               : 1;
    unsigned CC29               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __AT1CC2Hbits_t;

extern __at(0x0894) volatile __AT1CC2Hbits_t AT1CC2Hbits;

#define _AT1CC28                0x01
#define _CC28                   0x01
#define _AT1CC29                0x02
#define _CC29                   0x02

//==============================================================================


//==============================================================================
//        AT1CCON2 Bits

extern __at(0x0895) __sfr AT1CCON2;

typedef union
  {
  struct
    {
    unsigned AT1CC2MODE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AT1CAP2P           : 1;
    unsigned AT1CC2POL          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AT1CC2EN           : 1;
    };

  struct
    {
    unsigned CC2MODE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CAP2P              : 1;
    unsigned CC2POL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CC2EN              : 1;
    };
  } __AT1CCON2bits_t;

extern __at(0x0895) volatile __AT1CCON2bits_t AT1CCON2bits;

#define _AT1CC2MODE             0x01
#define _CC2MODE                0x01
#define _AT1CAP2P               0x08
#define _CAP2P                  0x08
#define _AT1CC2POL              0x10
#define _CC2POL                 0x10
#define _AT1CC2EN               0x80
#define _CC2EN                  0x80

//==============================================================================


//==============================================================================
//        AT1CSEL3 Bits

extern __at(0x0896) __sfr AT1CSEL3;

typedef union
  {
  struct
    {
    unsigned AT1CP3S0           : 1;
    unsigned AT1CP3S1           : 1;
    unsigned AT1CP3S2           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CP3S0              : 1;
    unsigned CP3S1              : 1;
    unsigned CP3S2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CP3S               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned AT1CP3S            : 3;
    unsigned                    : 5;
    };
  } __AT1CSEL3bits_t;

extern __at(0x0896) volatile __AT1CSEL3bits_t AT1CSEL3bits;

#define _AT1CP3S0               0x01
#define _CP3S0                  0x01
#define _AT1CP3S1               0x02
#define _CP3S1                  0x02
#define _AT1CP3S2               0x04
#define _CP3S2                  0x04

//==============================================================================

extern __at(0x0897) __sfr AT1CC3;

//==============================================================================
//        AT1CC3L Bits

extern __at(0x0897) __sfr AT1CC3L;

typedef union
  {
  struct
    {
    unsigned AT1CC30            : 1;
    unsigned AT1CC31            : 1;
    unsigned AT1CC32            : 1;
    unsigned AT1CC33            : 1;
    unsigned AT1CC34            : 1;
    unsigned AT1CC35            : 1;
    unsigned AT1CC36            : 1;
    unsigned AT1CC37            : 1;
    };

  struct
    {
    unsigned CC30               : 1;
    unsigned CC31               : 1;
    unsigned CC32               : 1;
    unsigned CC33               : 1;
    unsigned CC34               : 1;
    unsigned CC35               : 1;
    unsigned CC36               : 1;
    unsigned CC37               : 1;
    };
  } __AT1CC3Lbits_t;

extern __at(0x0897) volatile __AT1CC3Lbits_t AT1CC3Lbits;

#define _AT1CC30                0x01
#define _CC30                   0x01
#define _AT1CC31                0x02
#define _CC31                   0x02
#define _AT1CC32                0x04
#define _CC32                   0x04
#define _AT1CC33                0x08
#define _CC33                   0x08
#define _AT1CC34                0x10
#define _CC34                   0x10
#define _AT1CC35                0x20
#define _CC35                   0x20
#define _AT1CC36                0x40
#define _CC36                   0x40
#define _AT1CC37                0x80
#define _CC37                   0x80

//==============================================================================


//==============================================================================
//        AT1CC3H Bits

extern __at(0x0898) __sfr AT1CC3H;

typedef union
  {
  struct
    {
    unsigned AT1CC38            : 1;
    unsigned AT1CC39            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CC38               : 1;
    unsigned CC39               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __AT1CC3Hbits_t;

extern __at(0x0898) volatile __AT1CC3Hbits_t AT1CC3Hbits;

#define _AT1CC38                0x01
#define _CC38                   0x01
#define _AT1CC39                0x02
#define _CC39                   0x02

//==============================================================================


//==============================================================================
//        AT1CCON3 Bits

extern __at(0x0899) __sfr AT1CCON3;

typedef union
  {
  struct
    {
    unsigned AT1CC3MODE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AT1CAP3P           : 1;
    unsigned AT1CC3POL          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AT1CC3EN           : 1;
    };

  struct
    {
    unsigned CC3MODE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CAP3P              : 1;
    unsigned CC3POL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CC3EN              : 1;
    };
  } __AT1CCON3bits_t;

extern __at(0x0899) volatile __AT1CCON3bits_t AT1CCON3bits;

#define _AT1CC3MODE             0x01
#define _CC3MODE                0x01
#define _AT1CAP3P               0x08
#define _CAP3P                  0x08
#define _AT1CC3POL              0x10
#define _CC3POL                 0x10
#define _AT1CC3EN               0x80
#define _CC3EN                  0x80

//==============================================================================

extern __at(0x0D8C) __sfr SMT1TMR;

//==============================================================================
//        SMT1TMRL Bits

extern __at(0x0D8C) __sfr SMT1TMRL;

typedef struct
  {
  unsigned SMT1TMR0             : 1;
  unsigned SMT1TMR1             : 1;
  unsigned SMT1TMR2             : 1;
  unsigned SMT1TMR3             : 1;
  unsigned SMT1TMR4             : 1;
  unsigned SMT1TMR5             : 1;
  unsigned SMT1TMR6             : 1;
  unsigned SMT1TMR7             : 1;
  } __SMT1TMRLbits_t;

extern __at(0x0D8C) volatile __SMT1TMRLbits_t SMT1TMRLbits;

#define _SMT1TMR0               0x01
#define _SMT1TMR1               0x02
#define _SMT1TMR2               0x04
#define _SMT1TMR3               0x08
#define _SMT1TMR4               0x10
#define _SMT1TMR5               0x20
#define _SMT1TMR6               0x40
#define _SMT1TMR7               0x80

//==============================================================================


//==============================================================================
//        SMT1TMRH Bits

extern __at(0x0D8D) __sfr SMT1TMRH;

typedef struct
  {
  unsigned SMT1TMR8             : 1;
  unsigned SMT1TMR9             : 1;
  unsigned SMT1TMR10            : 1;
  unsigned SMT1TMR11            : 1;
  unsigned SMT1TMR12            : 1;
  unsigned SMT1TMR13            : 1;
  unsigned SMT1TMR14            : 1;
  unsigned SMT1TMR15            : 1;
  } __SMT1TMRHbits_t;

extern __at(0x0D8D) volatile __SMT1TMRHbits_t SMT1TMRHbits;

#define _SMT1TMR8               0x01
#define _SMT1TMR9               0x02
#define _SMT1TMR10              0x04
#define _SMT1TMR11              0x08
#define _SMT1TMR12              0x10
#define _SMT1TMR13              0x20
#define _SMT1TMR14              0x40
#define _SMT1TMR15              0x80

//==============================================================================


//==============================================================================
//        SMT1TMRU Bits

extern __at(0x0D8E) __sfr SMT1TMRU;

typedef struct
  {
  unsigned SMT1TMR16            : 1;
  unsigned SMT1TMR17            : 1;
  unsigned SMT1TMR18            : 1;
  unsigned SMT1TMR19            : 1;
  unsigned SMT1TMR20            : 1;
  unsigned SMT1TMR21            : 1;
  unsigned SMT1TMR22            : 1;
  unsigned SMT1TMR23            : 1;
  } __SMT1TMRUbits_t;

extern __at(0x0D8E) volatile __SMT1TMRUbits_t SMT1TMRUbits;

#define _SMT1TMR16              0x01
#define _SMT1TMR17              0x02
#define _SMT1TMR18              0x04
#define _SMT1TMR19              0x08
#define _SMT1TMR20              0x10
#define _SMT1TMR21              0x20
#define _SMT1TMR22              0x40
#define _SMT1TMR23              0x80

//==============================================================================

extern __at(0x0D8F) __sfr SMT1CPR;

//==============================================================================
//        SMT1CPRL Bits

extern __at(0x0D8F) __sfr SMT1CPRL;

typedef struct
  {
  unsigned SMT1CPR0             : 1;
  unsigned SMT1CPR1             : 1;
  unsigned SMT1CPR2             : 1;
  unsigned SMT1CPR3             : 1;
  unsigned SMT1CPR4             : 1;
  unsigned SMT1CPR5             : 1;
  unsigned SMT1CPR6             : 1;
  unsigned SMT1CPR7             : 1;
  } __SMT1CPRLbits_t;

extern __at(0x0D8F) volatile __SMT1CPRLbits_t SMT1CPRLbits;

#define _SMT1CPR0               0x01
#define _SMT1CPR1               0x02
#define _SMT1CPR2               0x04
#define _SMT1CPR3               0x08
#define _SMT1CPR4               0x10
#define _SMT1CPR5               0x20
#define _SMT1CPR6               0x40
#define _SMT1CPR7               0x80

//==============================================================================


//==============================================================================
//        SMT1CPRH Bits

extern __at(0x0D90) __sfr SMT1CPRH;

typedef struct
  {
  unsigned SMT1CPR8             : 1;
  unsigned SMT1CPR9             : 1;
  unsigned SMT1CPR10            : 1;
  unsigned SMT1CPR11            : 1;
  unsigned SMT1CPR12            : 1;
  unsigned SMT1CPR13            : 1;
  unsigned SMT1CPR14            : 1;
  unsigned SMT1CPR15            : 1;
  } __SMT1CPRHbits_t;

extern __at(0x0D90) volatile __SMT1CPRHbits_t SMT1CPRHbits;

#define _SMT1CPR8               0x01
#define _SMT1CPR9               0x02
#define _SMT1CPR10              0x04
#define _SMT1CPR11              0x08
#define _SMT1CPR12              0x10
#define _SMT1CPR13              0x20
#define _SMT1CPR14              0x40
#define _SMT1CPR15              0x80

//==============================================================================


//==============================================================================
//        SMT1CPRU Bits

extern __at(0x0D91) __sfr SMT1CPRU;

typedef struct
  {
  unsigned SMT1CPR16            : 1;
  unsigned SMT1CPR17            : 1;
  unsigned SMT1CPR18            : 1;
  unsigned SMT1CPR19            : 1;
  unsigned SMT1CPR20            : 1;
  unsigned SMT1CPR21            : 1;
  unsigned SMT1CPR22            : 1;
  unsigned SMT1CPR23            : 1;
  } __SMT1CPRUbits_t;

extern __at(0x0D91) volatile __SMT1CPRUbits_t SMT1CPRUbits;

#define _SMT1CPR16              0x01
#define _SMT1CPR17              0x02
#define _SMT1CPR18              0x04
#define _SMT1CPR19              0x08
#define _SMT1CPR20              0x10
#define _SMT1CPR21              0x20
#define _SMT1CPR22              0x40
#define _SMT1CPR23              0x80

//==============================================================================

extern __at(0x0D92) __sfr SMT1CPW;

//==============================================================================
//        SMT1CPWL Bits

extern __at(0x0D92) __sfr SMT1CPWL;

typedef struct
  {
  unsigned SMT1CPW0             : 1;
  unsigned SMT1CPW1             : 1;
  unsigned SMT1CPW2             : 1;
  unsigned SMT1CPW3             : 1;
  unsigned SMT1CPW4             : 1;
  unsigned SMT1CPW5             : 1;
  unsigned SMT1CPW6             : 1;
  unsigned SMT1CPW7             : 1;
  } __SMT1CPWLbits_t;

extern __at(0x0D92) volatile __SMT1CPWLbits_t SMT1CPWLbits;

#define _SMT1CPW0               0x01
#define _SMT1CPW1               0x02
#define _SMT1CPW2               0x04
#define _SMT1CPW3               0x08
#define _SMT1CPW4               0x10
#define _SMT1CPW5               0x20
#define _SMT1CPW6               0x40
#define _SMT1CPW7               0x80

//==============================================================================


//==============================================================================
//        SMT1CPWH Bits

extern __at(0x0D93) __sfr SMT1CPWH;

typedef struct
  {
  unsigned SMT1CPW8             : 1;
  unsigned SMT1CPW9             : 1;
  unsigned SMT1CPW10            : 1;
  unsigned SMT1CPW11            : 1;
  unsigned SMT1CPW12            : 1;
  unsigned SMT1CPW13            : 1;
  unsigned SMT1CPW14            : 1;
  unsigned SMT1CPW15            : 1;
  } __SMT1CPWHbits_t;

extern __at(0x0D93) volatile __SMT1CPWHbits_t SMT1CPWHbits;

#define _SMT1CPW8               0x01
#define _SMT1CPW9               0x02
#define _SMT1CPW10              0x04
#define _SMT1CPW11              0x08
#define _SMT1CPW12              0x10
#define _SMT1CPW13              0x20
#define _SMT1CPW14              0x40
#define _SMT1CPW15              0x80

//==============================================================================


//==============================================================================
//        SMT1CPWU Bits

extern __at(0x0D94) __sfr SMT1CPWU;

typedef struct
  {
  unsigned SMT1CPW16            : 1;
  unsigned SMT1CPW17            : 1;
  unsigned SMT1CPW18            : 1;
  unsigned SMT1CPW19            : 1;
  unsigned SMT1CPW20            : 1;
  unsigned SMT1CPW21            : 1;
  unsigned SMT1CPW22            : 1;
  unsigned SMT1CPW23            : 1;
  } __SMT1CPWUbits_t;

extern __at(0x0D94) volatile __SMT1CPWUbits_t SMT1CPWUbits;

#define _SMT1CPW16              0x01
#define _SMT1CPW17              0x02
#define _SMT1CPW18              0x04
#define _SMT1CPW19              0x08
#define _SMT1CPW20              0x10
#define _SMT1CPW21              0x20
#define _SMT1CPW22              0x40
#define _SMT1CPW23              0x80

//==============================================================================

extern __at(0x0D95) __sfr SMT1PR;

//==============================================================================
//        SMT1PRL Bits

extern __at(0x0D95) __sfr SMT1PRL;

typedef struct
  {
  unsigned SMT1PR0              : 1;
  unsigned SMT1PR1              : 1;
  unsigned SMT1PR2              : 1;
  unsigned SMT1PR3              : 1;
  unsigned SMT1PR4              : 1;
  unsigned SMT1PR5              : 1;
  unsigned SMT1PR6              : 1;
  unsigned SMT1PR7              : 1;
  } __SMT1PRLbits_t;

extern __at(0x0D95) volatile __SMT1PRLbits_t SMT1PRLbits;

#define _SMT1PR0                0x01
#define _SMT1PR1                0x02
#define _SMT1PR2                0x04
#define _SMT1PR3                0x08
#define _SMT1PR4                0x10
#define _SMT1PR5                0x20
#define _SMT1PR6                0x40
#define _SMT1PR7                0x80

//==============================================================================


//==============================================================================
//        SMT1PRH Bits

extern __at(0x0D96) __sfr SMT1PRH;

typedef struct
  {
  unsigned SMT1PR8              : 1;
  unsigned SMT1PR9              : 1;
  unsigned SMT1PR10             : 1;
  unsigned SMT1PR11             : 1;
  unsigned SMT1PR12             : 1;
  unsigned SMT1PR13             : 1;
  unsigned SMT1PR14             : 1;
  unsigned SMT1PR15             : 1;
  } __SMT1PRHbits_t;

extern __at(0x0D96) volatile __SMT1PRHbits_t SMT1PRHbits;

#define _SMT1PR8                0x01
#define _SMT1PR9                0x02
#define _SMT1PR10               0x04
#define _SMT1PR11               0x08
#define _SMT1PR12               0x10
#define _SMT1PR13               0x20
#define _SMT1PR14               0x40
#define _SMT1PR15               0x80

//==============================================================================


//==============================================================================
//        SMT1PRU Bits

extern __at(0x0D97) __sfr SMT1PRU;

typedef struct
  {
  unsigned SMT1PR16             : 1;
  unsigned SMT1PR17             : 1;
  unsigned SMT1PR18             : 1;
  unsigned SMT1PR19             : 1;
  unsigned SMT1PR20             : 1;
  unsigned SMT1PR21             : 1;
  unsigned SMT1PR22             : 1;
  unsigned SMT1PR23             : 1;
  } __SMT1PRUbits_t;

extern __at(0x0D97) volatile __SMT1PRUbits_t SMT1PRUbits;

#define _SMT1PR16               0x01
#define _SMT1PR17               0x02
#define _SMT1PR18               0x04
#define _SMT1PR19               0x08
#define _SMT1PR20               0x10
#define _SMT1PR21               0x20
#define _SMT1PR22               0x40
#define _SMT1PR23               0x80

//==============================================================================


//==============================================================================
//        SMT1CON0 Bits

extern __at(0x0D98) __sfr SMT1CON0;

typedef union
  {
  struct
    {
    unsigned SMT1PS0            : 1;
    unsigned SMT1PS1            : 1;
    unsigned CPOL               : 1;
    unsigned SPOL               : 1;
    unsigned WPOL               : 1;
    unsigned STP                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned SMT1PS             : 2;
    unsigned                    : 6;
    };
  } __SMT1CON0bits_t;

extern __at(0x0D98) volatile __SMT1CON0bits_t SMT1CON0bits;

#define _SMT1CON0_SMT1PS0       0x01
#define _SMT1CON0_SMT1PS1       0x02
#define _SMT1CON0_CPOL          0x04
#define _SMT1CON0_SPOL          0x08
#define _SMT1CON0_WPOL          0x10
#define _SMT1CON0_STP           0x20
#define _SMT1CON0_EN            0x80

//==============================================================================


//==============================================================================
//        SMT1CON1 Bits

extern __at(0x0D99) __sfr SMT1CON1;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned REPEAT             : 1;
    unsigned SMT1GO             : 1;
    };

  struct
    {
    unsigned SMT1MODE0          : 1;
    unsigned SMT1MODE1          : 1;
    unsigned SMT1MODE2          : 1;
    unsigned SMT1MODE3          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SMT1REPEAT         : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned SMT1MODE           : 4;
    unsigned                    : 4;
    };
  } __SMT1CON1bits_t;

extern __at(0x0D99) volatile __SMT1CON1bits_t SMT1CON1bits;

#define _SMT1CON1_MODE0         0x01
#define _SMT1CON1_SMT1MODE0     0x01
#define _SMT1CON1_MODE1         0x02
#define _SMT1CON1_SMT1MODE1     0x02
#define _SMT1CON1_MODE2         0x04
#define _SMT1CON1_SMT1MODE2     0x04
#define _SMT1CON1_MODE3         0x08
#define _SMT1CON1_SMT1MODE3     0x08
#define _SMT1CON1_REPEAT        0x40
#define _SMT1CON1_SMT1REPEAT    0x40
#define _SMT1CON1_SMT1GO        0x80

//==============================================================================


//==============================================================================
//        SMT1STAT Bits

extern __at(0x0D9A) __sfr SMT1STAT;

typedef union
  {
  struct
    {
    unsigned AS                 : 1;
    unsigned WS                 : 1;
    unsigned TS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RST                : 1;
    unsigned CPWUP              : 1;
    unsigned CPRUP              : 1;
    };

  struct
    {
    unsigned SMT1AS             : 1;
    unsigned SMT1WS             : 1;
    unsigned SMT1TS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SMT1RESET          : 1;
    unsigned SMT1CPWUP          : 1;
    unsigned SMT1CPRUP          : 1;
    };
  } __SMT1STATbits_t;

extern __at(0x0D9A) volatile __SMT1STATbits_t SMT1STATbits;

#define _AS                     0x01
#define _SMT1AS                 0x01
#define _WS                     0x02
#define _SMT1WS                 0x02
#define _TS                     0x04
#define _SMT1TS                 0x04
#define _RST                    0x20
#define _SMT1RESET              0x20
#define _CPWUP                  0x40
#define _SMT1CPWUP              0x40
#define _CPRUP                  0x80
#define _SMT1CPRUP              0x80

//==============================================================================


//==============================================================================
//        SMT1CLK Bits

extern __at(0x0D9B) __sfr SMT1CLK;

typedef union
  {
  struct
    {
    unsigned CSEL0              : 1;
    unsigned CSEL1              : 1;
    unsigned CSEL2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1CSEL0          : 1;
    unsigned SMT1CSEL1          : 1;
    unsigned SMT1CSEL2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CSEL               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned SMT1CSEL           : 3;
    unsigned                    : 5;
    };
  } __SMT1CLKbits_t;

extern __at(0x0D9B) volatile __SMT1CLKbits_t SMT1CLKbits;

#define _CSEL0                  0x01
#define _SMT1CSEL0              0x01
#define _CSEL1                  0x02
#define _SMT1CSEL1              0x02
#define _CSEL2                  0x04
#define _SMT1CSEL2              0x04

//==============================================================================


//==============================================================================
//        SMT1SIG Bits

extern __at(0x0D9C) __sfr SMT1SIG;

typedef union
  {
  struct
    {
    unsigned SSEL0              : 1;
    unsigned SSEL1              : 1;
    unsigned SSEL2              : 1;
    unsigned SSEL3              : 1;
    unsigned SSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1SSEL0          : 1;
    unsigned SMT1SSEL1          : 1;
    unsigned SMT1SSEL2          : 1;
    unsigned SMT1SSEL3          : 1;
    unsigned SMT1SSEL4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1SSEL           : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned SSEL               : 5;
    unsigned                    : 3;
    };
  } __SMT1SIGbits_t;

extern __at(0x0D9C) volatile __SMT1SIGbits_t SMT1SIGbits;

#define _SMT1SIG_SSEL0          0x01
#define _SMT1SIG_SMT1SSEL0      0x01
#define _SMT1SIG_SSEL1          0x02
#define _SMT1SIG_SMT1SSEL1      0x02
#define _SMT1SIG_SSEL2          0x04
#define _SMT1SIG_SMT1SSEL2      0x04
#define _SMT1SIG_SSEL3          0x08
#define _SMT1SIG_SMT1SSEL3      0x08
#define _SMT1SIG_SSEL4          0x10
#define _SMT1SIG_SMT1SSEL4      0x10

//==============================================================================


//==============================================================================
//        SMT1WIN Bits

extern __at(0x0D9D) __sfr SMT1WIN;

typedef union
  {
  struct
    {
    unsigned WSEL0              : 1;
    unsigned WSEL1              : 1;
    unsigned WSEL2              : 1;
    unsigned WSEL3              : 1;
    unsigned WSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1WSEL0          : 1;
    unsigned SMT1WSEL1          : 1;
    unsigned SMT1WSEL2          : 1;
    unsigned SMT1WSEL3          : 1;
    unsigned SMT1WSEL4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WSEL               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned SMT1WSEL           : 5;
    unsigned                    : 3;
    };
  } __SMT1WINbits_t;

extern __at(0x0D9D) volatile __SMT1WINbits_t SMT1WINbits;

#define _WSEL0                  0x01
#define _SMT1WSEL0              0x01
#define _WSEL1                  0x02
#define _SMT1WSEL1              0x02
#define _WSEL2                  0x04
#define _SMT1WSEL2              0x04
#define _WSEL3                  0x08
#define _SMT1WSEL3              0x08
#define _WSEL4                  0x10
#define _SMT1WSEL4              0x10

//==============================================================================

extern __at(0x0D9E) __sfr SMT2TMR;

//==============================================================================
//        SMT2TMRL Bits

extern __at(0x0D9E) __sfr SMT2TMRL;

typedef struct
  {
  unsigned SMT2TMR0             : 1;
  unsigned SMT2TMR1             : 1;
  unsigned SMT2TMR2             : 1;
  unsigned SMT2TMR3             : 1;
  unsigned SMT2TMR4             : 1;
  unsigned SMT2TMR5             : 1;
  unsigned SMT2TMR6             : 1;
  unsigned SMT2TMR7             : 1;
  } __SMT2TMRLbits_t;

extern __at(0x0D9E) volatile __SMT2TMRLbits_t SMT2TMRLbits;

#define _SMT2TMR0               0x01
#define _SMT2TMR1               0x02
#define _SMT2TMR2               0x04
#define _SMT2TMR3               0x08
#define _SMT2TMR4               0x10
#define _SMT2TMR5               0x20
#define _SMT2TMR6               0x40
#define _SMT2TMR7               0x80

//==============================================================================


//==============================================================================
//        SMT2TMRH Bits

extern __at(0x0D9F) __sfr SMT2TMRH;

typedef struct
  {
  unsigned SMT2TMR8             : 1;
  unsigned SMT2TMR9             : 1;
  unsigned SMT2TMR10            : 1;
  unsigned SMT2TMR11            : 1;
  unsigned SMT2TMR12            : 1;
  unsigned SMT2TMR13            : 1;
  unsigned SMT2TMR14            : 1;
  unsigned SMT2TMR15            : 1;
  } __SMT2TMRHbits_t;

extern __at(0x0D9F) volatile __SMT2TMRHbits_t SMT2TMRHbits;

#define _SMT2TMR8               0x01
#define _SMT2TMR9               0x02
#define _SMT2TMR10              0x04
#define _SMT2TMR11              0x08
#define _SMT2TMR12              0x10
#define _SMT2TMR13              0x20
#define _SMT2TMR14              0x40
#define _SMT2TMR15              0x80

//==============================================================================


//==============================================================================
//        SMT2TMRU Bits

extern __at(0x0DA0) __sfr SMT2TMRU;

typedef struct
  {
  unsigned SMT2TMR16            : 1;
  unsigned SMT2TMR17            : 1;
  unsigned SMT2TMR18            : 1;
  unsigned SMT2TMR19            : 1;
  unsigned SMT2TMR20            : 1;
  unsigned SMT2TMR21            : 1;
  unsigned SMT2TMR22            : 1;
  unsigned SMT2TMR23            : 1;
  } __SMT2TMRUbits_t;

extern __at(0x0DA0) volatile __SMT2TMRUbits_t SMT2TMRUbits;

#define _SMT2TMR16              0x01
#define _SMT2TMR17              0x02
#define _SMT2TMR18              0x04
#define _SMT2TMR19              0x08
#define _SMT2TMR20              0x10
#define _SMT2TMR21              0x20
#define _SMT2TMR22              0x40
#define _SMT2TMR23              0x80

//==============================================================================

extern __at(0x0DA1) __sfr SMT2CPR;

//==============================================================================
//        SMT2CPRL Bits

extern __at(0x0DA1) __sfr SMT2CPRL;

typedef struct
  {
  unsigned SMT2CPR0             : 1;
  unsigned SMT2CPR1             : 1;
  unsigned SMT2CPR2             : 1;
  unsigned SMT2CPR3             : 1;
  unsigned SMT2CPR4             : 1;
  unsigned SMT2CPR5             : 1;
  unsigned SMT2CPR6             : 1;
  unsigned SMT2CPR7             : 1;
  } __SMT2CPRLbits_t;

extern __at(0x0DA1) volatile __SMT2CPRLbits_t SMT2CPRLbits;

#define _SMT2CPR0               0x01
#define _SMT2CPR1               0x02
#define _SMT2CPR2               0x04
#define _SMT2CPR3               0x08
#define _SMT2CPR4               0x10
#define _SMT2CPR5               0x20
#define _SMT2CPR6               0x40
#define _SMT2CPR7               0x80

//==============================================================================


//==============================================================================
//        SMT2CPRH Bits

extern __at(0x0DA2) __sfr SMT2CPRH;

typedef struct
  {
  unsigned SMT2CPR8             : 1;
  unsigned SMT2CPR9             : 1;
  unsigned SMT2CPR10            : 1;
  unsigned SMT2CPR11            : 1;
  unsigned SMT2CPR12            : 1;
  unsigned SMT2CPR13            : 1;
  unsigned SMT2CPR14            : 1;
  unsigned SMT2CPR15            : 1;
  } __SMT2CPRHbits_t;

extern __at(0x0DA2) volatile __SMT2CPRHbits_t SMT2CPRHbits;

#define _SMT2CPR8               0x01
#define _SMT2CPR9               0x02
#define _SMT2CPR10              0x04
#define _SMT2CPR11              0x08
#define _SMT2CPR12              0x10
#define _SMT2CPR13              0x20
#define _SMT2CPR14              0x40
#define _SMT2CPR15              0x80

//==============================================================================


//==============================================================================
//        SMT2CPRU Bits

extern __at(0x0DA3) __sfr SMT2CPRU;

typedef struct
  {
  unsigned SMT2CPR16            : 1;
  unsigned SMT2CPR17            : 1;
  unsigned SMT2CPR18            : 1;
  unsigned SMT2CPR19            : 1;
  unsigned SMT2CPR20            : 1;
  unsigned SMT2CPR21            : 1;
  unsigned SMT2CPR22            : 1;
  unsigned SMT2CPR23            : 1;
  } __SMT2CPRUbits_t;

extern __at(0x0DA3) volatile __SMT2CPRUbits_t SMT2CPRUbits;

#define _SMT2CPR16              0x01
#define _SMT2CPR17              0x02
#define _SMT2CPR18              0x04
#define _SMT2CPR19              0x08
#define _SMT2CPR20              0x10
#define _SMT2CPR21              0x20
#define _SMT2CPR22              0x40
#define _SMT2CPR23              0x80

//==============================================================================

extern __at(0x0DA4) __sfr SMT2CPW;

//==============================================================================
//        SMT2CPWL Bits

extern __at(0x0DA4) __sfr SMT2CPWL;

typedef struct
  {
  unsigned SMT2CPW0             : 1;
  unsigned SMT2CPW1             : 1;
  unsigned SMT2CPW2             : 1;
  unsigned SMT2CPW3             : 1;
  unsigned SMT2CPW4             : 1;
  unsigned SMT2CPW5             : 1;
  unsigned SMT2CPW6             : 1;
  unsigned SMT2CPW7             : 1;
  } __SMT2CPWLbits_t;

extern __at(0x0DA4) volatile __SMT2CPWLbits_t SMT2CPWLbits;

#define _SMT2CPW0               0x01
#define _SMT2CPW1               0x02
#define _SMT2CPW2               0x04
#define _SMT2CPW3               0x08
#define _SMT2CPW4               0x10
#define _SMT2CPW5               0x20
#define _SMT2CPW6               0x40
#define _SMT2CPW7               0x80

//==============================================================================


//==============================================================================
//        SMT2CPWH Bits

extern __at(0x0DA5) __sfr SMT2CPWH;

typedef struct
  {
  unsigned SMT2CPW8             : 1;
  unsigned SMT2CPW9             : 1;
  unsigned SMT2CPW10            : 1;
  unsigned SMT2CPW11            : 1;
  unsigned SMT2CPW12            : 1;
  unsigned SMT2CPW13            : 1;
  unsigned SMT2CPW14            : 1;
  unsigned SMT2CPW15            : 1;
  } __SMT2CPWHbits_t;

extern __at(0x0DA5) volatile __SMT2CPWHbits_t SMT2CPWHbits;

#define _SMT2CPW8               0x01
#define _SMT2CPW9               0x02
#define _SMT2CPW10              0x04
#define _SMT2CPW11              0x08
#define _SMT2CPW12              0x10
#define _SMT2CPW13              0x20
#define _SMT2CPW14              0x40
#define _SMT2CPW15              0x80

//==============================================================================


//==============================================================================
//        SMT2CPWU Bits

extern __at(0x0DA6) __sfr SMT2CPWU;

typedef struct
  {
  unsigned SMT2CPW16            : 1;
  unsigned SMT2CPW17            : 1;
  unsigned SMT2CPW18            : 1;
  unsigned SMT2CPW19            : 1;
  unsigned SMT2CPW20            : 1;
  unsigned SMT2CPW21            : 1;
  unsigned SMT2CPW22            : 1;
  unsigned SMT2CPW23            : 1;
  } __SMT2CPWUbits_t;

extern __at(0x0DA6) volatile __SMT2CPWUbits_t SMT2CPWUbits;

#define _SMT2CPW16              0x01
#define _SMT2CPW17              0x02
#define _SMT2CPW18              0x04
#define _SMT2CPW19              0x08
#define _SMT2CPW20              0x10
#define _SMT2CPW21              0x20
#define _SMT2CPW22              0x40
#define _SMT2CPW23              0x80

//==============================================================================

extern __at(0x0DA7) __sfr SMT2PR;

//==============================================================================
//        SMT2PRL Bits

extern __at(0x0DA7) __sfr SMT2PRL;

typedef struct
  {
  unsigned SMT2PR0              : 1;
  unsigned SMT2PR1              : 1;
  unsigned SMT2PR2              : 1;
  unsigned SMT2PR3              : 1;
  unsigned SMT2PR4              : 1;
  unsigned SMT2PR5              : 1;
  unsigned SMT2PR6              : 1;
  unsigned SMT2PR7              : 1;
  } __SMT2PRLbits_t;

extern __at(0x0DA7) volatile __SMT2PRLbits_t SMT2PRLbits;

#define _SMT2PR0                0x01
#define _SMT2PR1                0x02
#define _SMT2PR2                0x04
#define _SMT2PR3                0x08
#define _SMT2PR4                0x10
#define _SMT2PR5                0x20
#define _SMT2PR6                0x40
#define _SMT2PR7                0x80

//==============================================================================


//==============================================================================
//        SMT2PRH Bits

extern __at(0x0DA8) __sfr SMT2PRH;

typedef struct
  {
  unsigned SMT2PR8              : 1;
  unsigned SMT2PR9              : 1;
  unsigned SMT2PR10             : 1;
  unsigned SMT2PR11             : 1;
  unsigned SMT2PR12             : 1;
  unsigned SMT2PR13             : 1;
  unsigned SMT2PR14             : 1;
  unsigned SMT2PR15             : 1;
  } __SMT2PRHbits_t;

extern __at(0x0DA8) volatile __SMT2PRHbits_t SMT2PRHbits;

#define _SMT2PR8                0x01
#define _SMT2PR9                0x02
#define _SMT2PR10               0x04
#define _SMT2PR11               0x08
#define _SMT2PR12               0x10
#define _SMT2PR13               0x20
#define _SMT2PR14               0x40
#define _SMT2PR15               0x80

//==============================================================================


//==============================================================================
//        SMT2PRU Bits

extern __at(0x0DA9) __sfr SMT2PRU;

typedef struct
  {
  unsigned SMT2PR16             : 1;
  unsigned SMT2PR17             : 1;
  unsigned SMT2PR18             : 1;
  unsigned SMT2PR19             : 1;
  unsigned SMT2PR20             : 1;
  unsigned SMT2PR21             : 1;
  unsigned SMT2PR22             : 1;
  unsigned SMT2PR23             : 1;
  } __SMT2PRUbits_t;

extern __at(0x0DA9) volatile __SMT2PRUbits_t SMT2PRUbits;

#define _SMT2PR16               0x01
#define _SMT2PR17               0x02
#define _SMT2PR18               0x04
#define _SMT2PR19               0x08
#define _SMT2PR20               0x10
#define _SMT2PR21               0x20
#define _SMT2PR22               0x40
#define _SMT2PR23               0x80

//==============================================================================


//==============================================================================
//        SMT2CON0 Bits

extern __at(0x0DAA) __sfr SMT2CON0;

typedef union
  {
  struct
    {
    unsigned SMT2PS0            : 1;
    unsigned SMT2PS1            : 1;
    unsigned CPOL               : 1;
    unsigned SPOL               : 1;
    unsigned WPOL               : 1;
    unsigned STP                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned SMT2PS             : 2;
    unsigned                    : 6;
    };
  } __SMT2CON0bits_t;

extern __at(0x0DAA) volatile __SMT2CON0bits_t SMT2CON0bits;

#define _SMT2CON0_SMT2PS0       0x01
#define _SMT2CON0_SMT2PS1       0x02
#define _SMT2CON0_CPOL          0x04
#define _SMT2CON0_SPOL          0x08
#define _SMT2CON0_WPOL          0x10
#define _SMT2CON0_STP           0x20
#define _SMT2CON0_EN            0x80

//==============================================================================


//==============================================================================
//        SMT2CON1 Bits

extern __at(0x0DAB) __sfr SMT2CON1;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned REPEAT             : 1;
    unsigned SMT2GO             : 1;
    };

  struct
    {
    unsigned SMT2MODE0          : 1;
    unsigned SMT2MODE1          : 1;
    unsigned SMT2MODE2          : 1;
    unsigned SMT2MODE3          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SMT2REPEAT         : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT2MODE           : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };
  } __SMT2CON1bits_t;

extern __at(0x0DAB) volatile __SMT2CON1bits_t SMT2CON1bits;

#define _SMT2CON1_MODE0         0x01
#define _SMT2CON1_SMT2MODE0     0x01
#define _SMT2CON1_MODE1         0x02
#define _SMT2CON1_SMT2MODE1     0x02
#define _SMT2CON1_MODE2         0x04
#define _SMT2CON1_SMT2MODE2     0x04
#define _SMT2CON1_MODE3         0x08
#define _SMT2CON1_SMT2MODE3     0x08
#define _SMT2CON1_REPEAT        0x40
#define _SMT2CON1_SMT2REPEAT    0x40
#define _SMT2CON1_SMT2GO        0x80

//==============================================================================


//==============================================================================
//        SMT2STAT Bits

extern __at(0x0DAC) __sfr SMT2STAT;

typedef union
  {
  struct
    {
    unsigned AS                 : 1;
    unsigned WS                 : 1;
    unsigned TS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RST                : 1;
    unsigned CPWUP              : 1;
    unsigned CPRUP              : 1;
    };

  struct
    {
    unsigned SMT2AS             : 1;
    unsigned SMT2WS             : 1;
    unsigned SMT2TS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SMT2RESET          : 1;
    unsigned SMT2CPWUP          : 1;
    unsigned SMT2CPRUP          : 1;
    };
  } __SMT2STATbits_t;

extern __at(0x0DAC) volatile __SMT2STATbits_t SMT2STATbits;

#define _SMT2STAT_AS            0x01
#define _SMT2STAT_SMT2AS        0x01
#define _SMT2STAT_WS            0x02
#define _SMT2STAT_SMT2WS        0x02
#define _SMT2STAT_TS            0x04
#define _SMT2STAT_SMT2TS        0x04
#define _SMT2STAT_RST           0x20
#define _SMT2STAT_SMT2RESET     0x20
#define _SMT2STAT_CPWUP         0x40
#define _SMT2STAT_SMT2CPWUP     0x40
#define _SMT2STAT_CPRUP         0x80
#define _SMT2STAT_SMT2CPRUP     0x80

//==============================================================================


//==============================================================================
//        SMT2CLK Bits

extern __at(0x0DAD) __sfr SMT2CLK;

typedef union
  {
  struct
    {
    unsigned CSEL0              : 1;
    unsigned CSEL1              : 1;
    unsigned CSEL2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT2CSEL0          : 1;
    unsigned SMT2CSEL1          : 1;
    unsigned SMT2CSEL2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CSEL               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned SMT2CSEL           : 3;
    unsigned                    : 5;
    };
  } __SMT2CLKbits_t;

extern __at(0x0DAD) volatile __SMT2CLKbits_t SMT2CLKbits;

#define _SMT2CLK_CSEL0          0x01
#define _SMT2CLK_SMT2CSEL0      0x01
#define _SMT2CLK_CSEL1          0x02
#define _SMT2CLK_SMT2CSEL1      0x02
#define _SMT2CLK_CSEL2          0x04
#define _SMT2CLK_SMT2CSEL2      0x04

//==============================================================================


//==============================================================================
//        SMT2SIG Bits

extern __at(0x0DAE) __sfr SMT2SIG;

typedef union
  {
  struct
    {
    unsigned SSEL0              : 1;
    unsigned SSEL1              : 1;
    unsigned SSEL2              : 1;
    unsigned SSEL3              : 1;
    unsigned SSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT2SSEL0          : 1;
    unsigned SMT2SSEL1          : 1;
    unsigned SMT2SSEL2          : 1;
    unsigned SMT2SSEL3          : 1;
    unsigned SMT2SSEL4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSEL               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned SMT2SSEL           : 5;
    unsigned                    : 3;
    };
  } __SMT2SIGbits_t;

extern __at(0x0DAE) volatile __SMT2SIGbits_t SMT2SIGbits;

#define _SMT2SIG_SSEL0          0x01
#define _SMT2SIG_SMT2SSEL0      0x01
#define _SMT2SIG_SSEL1          0x02
#define _SMT2SIG_SMT2SSEL1      0x02
#define _SMT2SIG_SSEL2          0x04
#define _SMT2SIG_SMT2SSEL2      0x04
#define _SMT2SIG_SSEL3          0x08
#define _SMT2SIG_SMT2SSEL3      0x08
#define _SMT2SIG_SSEL4          0x10
#define _SMT2SIG_SMT2SSEL4      0x10

//==============================================================================


//==============================================================================
//        SMT2WIN Bits

extern __at(0x0DAF) __sfr SMT2WIN;

typedef union
  {
  struct
    {
    unsigned WSEL0              : 1;
    unsigned WSEL1              : 1;
    unsigned WSEL2              : 1;
    unsigned WSEL3              : 1;
    unsigned WSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT2WSEL0          : 1;
    unsigned SMT2WSEL1          : 1;
    unsigned SMT2WSEL2          : 1;
    unsigned SMT2WSEL3          : 1;
    unsigned SMT2WSEL4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT2WSEL           : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned WSEL               : 5;
    unsigned                    : 3;
    };
  } __SMT2WINbits_t;

extern __at(0x0DAF) volatile __SMT2WINbits_t SMT2WINbits;

#define _SMT2WIN_WSEL0          0x01
#define _SMT2WIN_SMT2WSEL0      0x01
#define _SMT2WIN_WSEL1          0x02
#define _SMT2WIN_SMT2WSEL1      0x02
#define _SMT2WIN_WSEL2          0x04
#define _SMT2WIN_SMT2WSEL2      0x04
#define _SMT2WIN_WSEL3          0x08
#define _SMT2WIN_SMT2WSEL3      0x08
#define _SMT2WIN_WSEL4          0x10
#define _SMT2WIN_SMT2WSEL4      0x10

//==============================================================================


//==============================================================================
//        PPSLOCK Bits

extern __at(0x0E0F) __sfr PPSLOCK;

typedef struct
  {
  unsigned PPSLOCKED            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PPSLOCKbits_t;

extern __at(0x0E0F) volatile __PPSLOCKbits_t PPSLOCKbits;

#define _PPSLOCKED              0x01

//==============================================================================


//==============================================================================
//        INTPPS Bits

extern __at(0x0E10) __sfr INTPPS;

typedef union
  {
  struct
    {
    unsigned INTPPS0            : 1;
    unsigned INTPPS1            : 1;
    unsigned INTPPS2            : 1;
    unsigned INTPPS3            : 1;
    unsigned INTPPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INTPPS             : 5;
    unsigned                    : 3;
    };
  } __INTPPSbits_t;

extern __at(0x0E10) volatile __INTPPSbits_t INTPPSbits;

#define _INTPPS0                0x01
#define _INTPPS1                0x02
#define _INTPPS2                0x04
#define _INTPPS3                0x08
#define _INTPPS4                0x10

//==============================================================================


//==============================================================================
//        T0CKIPPS Bits

extern __at(0x0E11) __sfr T0CKIPPS;

typedef union
  {
  struct
    {
    unsigned T0CKIPPS0          : 1;
    unsigned T0CKIPPS1          : 1;
    unsigned T0CKIPPS2          : 1;
    unsigned T0CKIPPS3          : 1;
    unsigned T0CKIPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T0CKIPPS           : 5;
    unsigned                    : 3;
    };
  } __T0CKIPPSbits_t;

extern __at(0x0E11) volatile __T0CKIPPSbits_t T0CKIPPSbits;

#define _T0CKIPPS0              0x01
#define _T0CKIPPS1              0x02
#define _T0CKIPPS2              0x04
#define _T0CKIPPS3              0x08
#define _T0CKIPPS4              0x10

//==============================================================================


//==============================================================================
//        T1CKIPPS Bits

extern __at(0x0E12) __sfr T1CKIPPS;

typedef union
  {
  struct
    {
    unsigned T1CKIPPS0          : 1;
    unsigned T1CKIPPS1          : 1;
    unsigned T1CKIPPS2          : 1;
    unsigned T1CKIPPS3          : 1;
    unsigned T1CKIPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1CKIPPS           : 5;
    unsigned                    : 3;
    };
  } __T1CKIPPSbits_t;

extern __at(0x0E12) volatile __T1CKIPPSbits_t T1CKIPPSbits;

#define _T1CKIPPS0              0x01
#define _T1CKIPPS1              0x02
#define _T1CKIPPS2              0x04
#define _T1CKIPPS3              0x08
#define _T1CKIPPS4              0x10

//==============================================================================


//==============================================================================
//        T1GPPS Bits

extern __at(0x0E13) __sfr T1GPPS;

typedef union
  {
  struct
    {
    unsigned T1GPPS0            : 1;
    unsigned T1GPPS1            : 1;
    unsigned T1GPPS2            : 1;
    unsigned T1GPPS3            : 1;
    unsigned T1GPPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GPPS             : 5;
    unsigned                    : 3;
    };
  } __T1GPPSbits_t;

extern __at(0x0E13) volatile __T1GPPSbits_t T1GPPSbits;

#define _T1GPPS0                0x01
#define _T1GPPS1                0x02
#define _T1GPPS2                0x04
#define _T1GPPS3                0x08
#define _T1GPPS4                0x10

//==============================================================================


//==============================================================================
//        CCP1PPS Bits

extern __at(0x0E14) __sfr CCP1PPS;

typedef union
  {
  struct
    {
    unsigned CCP1PPS0           : 1;
    unsigned CCP1PPS1           : 1;
    unsigned CCP1PPS2           : 1;
    unsigned CCP1PPS3           : 1;
    unsigned CCP1PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1PPS            : 5;
    unsigned                    : 3;
    };
  } __CCP1PPSbits_t;

extern __at(0x0E14) volatile __CCP1PPSbits_t CCP1PPSbits;

#define _CCP1PPS0               0x01
#define _CCP1PPS1               0x02
#define _CCP1PPS2               0x04
#define _CCP1PPS3               0x08
#define _CCP1PPS4               0x10

//==============================================================================


//==============================================================================
//        CCP2PPS Bits

extern __at(0x0E15) __sfr CCP2PPS;

typedef union
  {
  struct
    {
    unsigned CCP2PPS0           : 1;
    unsigned CCP2PPS1           : 1;
    unsigned CCP2PPS2           : 1;
    unsigned CCP2PPS3           : 1;
    unsigned CCP2PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2PPS            : 5;
    unsigned                    : 3;
    };
  } __CCP2PPSbits_t;

extern __at(0x0E15) volatile __CCP2PPSbits_t CCP2PPSbits;

#define _CCP2PPS0               0x01
#define _CCP2PPS1               0x02
#define _CCP2PPS2               0x04
#define _CCP2PPS3               0x08
#define _CCP2PPS4               0x10

//==============================================================================


//==============================================================================
//        ATINPPS Bits

extern __at(0x0E16) __sfr ATINPPS;

typedef union
  {
  struct
    {
    unsigned ATINPPS0           : 1;
    unsigned ATINPPS1           : 1;
    unsigned ATINPPS2           : 1;
    unsigned ATINPPS3           : 1;
    unsigned ATINPPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ATINPPS            : 5;
    unsigned                    : 3;
    };
  } __ATINPPSbits_t;

extern __at(0x0E16) volatile __ATINPPSbits_t ATINPPSbits;

#define _ATINPPS0               0x01
#define _ATINPPS1               0x02
#define _ATINPPS2               0x04
#define _ATINPPS3               0x08
#define _ATINPPS4               0x10

//==============================================================================


//==============================================================================
//        CWGINPPS Bits

extern __at(0x0E17) __sfr CWGINPPS;

typedef union
  {
  struct
    {
    unsigned CWGINPPS0          : 1;
    unsigned CWGINPPS1          : 1;
    unsigned CWGINPPS2          : 1;
    unsigned CWGINPPS3          : 1;
    unsigned CWGINPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWGINPPS           : 5;
    unsigned                    : 3;
    };
  } __CWGINPPSbits_t;

extern __at(0x0E17) volatile __CWGINPPSbits_t CWGINPPSbits;

#define _CWGINPPS0              0x01
#define _CWGINPPS1              0x02
#define _CWGINPPS2              0x04
#define _CWGINPPS3              0x08
#define _CWGINPPS4              0x10

//==============================================================================


//==============================================================================
//        T2PPS Bits

extern __at(0x0E18) __sfr T2PPS;

typedef union
  {
  struct
    {
    unsigned T2PPS0             : 1;
    unsigned T2PPS1             : 1;
    unsigned T2PPS2             : 1;
    unsigned T2PPS3             : 1;
    unsigned T2PPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2PPS              : 5;
    unsigned                    : 3;
    };
  } __T2PPSbits_t;

extern __at(0x0E18) volatile __T2PPSbits_t T2PPSbits;

#define _T2PPS0                 0x01
#define _T2PPS1                 0x02
#define _T2PPS2                 0x04
#define _T2PPS3                 0x08
#define _T2PPS4                 0x10

//==============================================================================


//==============================================================================
//        T3CKIPPS Bits

extern __at(0x0E19) __sfr T3CKIPPS;

typedef union
  {
  struct
    {
    unsigned T3CKIPPS0          : 1;
    unsigned T3CKIPPS1          : 1;
    unsigned T3CKIPPS2          : 1;
    unsigned T3CKIPPS3          : 1;
    unsigned T3CKIPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3CKIPPS           : 5;
    unsigned                    : 3;
    };
  } __T3CKIPPSbits_t;

extern __at(0x0E19) volatile __T3CKIPPSbits_t T3CKIPPSbits;

#define _T3CKIPPS0              0x01
#define _T3CKIPPS1              0x02
#define _T3CKIPPS2              0x04
#define _T3CKIPPS3              0x08
#define _T3CKIPPS4              0x10

//==============================================================================


//==============================================================================
//        T3GPPS Bits

extern __at(0x0E1A) __sfr T3GPPS;

typedef union
  {
  struct
    {
    unsigned T3GPPS0            : 1;
    unsigned T3GPPS1            : 1;
    unsigned T3GPPS2            : 1;
    unsigned T3GPPS3            : 1;
    unsigned T3GPPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3GPPS             : 5;
    unsigned                    : 3;
    };
  } __T3GPPSbits_t;

extern __at(0x0E1A) volatile __T3GPPSbits_t T3GPPSbits;

#define _T3GPPS0                0x01
#define _T3GPPS1                0x02
#define _T3GPPS2                0x04
#define _T3GPPS3                0x08
#define _T3GPPS4                0x10

//==============================================================================


//==============================================================================
//        T4PPS Bits

extern __at(0x0E1B) __sfr T4PPS;

typedef union
  {
  struct
    {
    unsigned T4PPS0             : 1;
    unsigned T4PPS1             : 1;
    unsigned T4PPS2             : 1;
    unsigned T4PPS3             : 1;
    unsigned T4PPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4PPS              : 5;
    unsigned                    : 3;
    };
  } __T4PPSbits_t;

extern __at(0x0E1B) volatile __T4PPSbits_t T4PPSbits;

#define _T4PPS0                 0x01
#define _T4PPS1                 0x02
#define _T4PPS2                 0x04
#define _T4PPS3                 0x08
#define _T4PPS4                 0x10

//==============================================================================


//==============================================================================
//        T5CKIPPS Bits

extern __at(0x0E1C) __sfr T5CKIPPS;

typedef union
  {
  struct
    {
    unsigned T5CKIPPS0          : 1;
    unsigned T5CKIPPS1          : 1;
    unsigned T5CKIPPS2          : 1;
    unsigned T5CKIPPS3          : 1;
    unsigned T5CKIPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T5CKIPPS           : 5;
    unsigned                    : 3;
    };
  } __T5CKIPPSbits_t;

extern __at(0x0E1C) volatile __T5CKIPPSbits_t T5CKIPPSbits;

#define _T5CKIPPS0              0x01
#define _T5CKIPPS1              0x02
#define _T5CKIPPS2              0x04
#define _T5CKIPPS3              0x08
#define _T5CKIPPS4              0x10

//==============================================================================


//==============================================================================
//        T5GPPS Bits

extern __at(0x0E1D) __sfr T5GPPS;

typedef union
  {
  struct
    {
    unsigned T5GPPS0            : 1;
    unsigned T5GPPS1            : 1;
    unsigned T5GPPS2            : 1;
    unsigned T5GPPS3            : 1;
    unsigned T5GPPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T5GPPS             : 5;
    unsigned                    : 3;
    };
  } __T5GPPSbits_t;

extern __at(0x0E1D) volatile __T5GPPSbits_t T5GPPSbits;

#define _T5GPPS0                0x01
#define _T5GPPS1                0x02
#define _T5GPPS2                0x04
#define _T5GPPS3                0x08
#define _T5GPPS4                0x10

//==============================================================================


//==============================================================================
//        T6PPS Bits

extern __at(0x0E1E) __sfr T6PPS;

typedef union
  {
  struct
    {
    unsigned T6PPS0             : 1;
    unsigned T6PPS1             : 1;
    unsigned T6PPS2             : 1;
    unsigned T6PPS3             : 1;
    unsigned T6PPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6PPS              : 5;
    unsigned                    : 3;
    };
  } __T6PPSbits_t;

extern __at(0x0E1E) volatile __T6PPSbits_t T6PPSbits;

#define _T6PPS0                 0x01
#define _T6PPS1                 0x02
#define _T6PPS2                 0x04
#define _T6PPS3                 0x08
#define _T6PPS4                 0x10

//==============================================================================


//==============================================================================
//        ATCC1PPS Bits

extern __at(0x0E1F) __sfr ATCC1PPS;

typedef union
  {
  struct
    {
    unsigned ATCC1PPS0          : 1;
    unsigned ATCC1PPS1          : 1;
    unsigned ATCC1PPS2          : 1;
    unsigned ATCC1PPS3          : 1;
    unsigned ATCC1PPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ATCC1PPS           : 5;
    unsigned                    : 3;
    };
  } __ATCC1PPSbits_t;

extern __at(0x0E1F) volatile __ATCC1PPSbits_t ATCC1PPSbits;

#define _ATCC1PPS0              0x01
#define _ATCC1PPS1              0x02
#define _ATCC1PPS2              0x04
#define _ATCC1PPS3              0x08
#define _ATCC1PPS4              0x10

//==============================================================================


//==============================================================================
//        SSPCLKPPS Bits

extern __at(0x0E20) __sfr SSPCLKPPS;

typedef union
  {
  struct
    {
    unsigned SSPCLKPPS0         : 1;
    unsigned SSPCLKPPS1         : 1;
    unsigned SSPCLKPPS2         : 1;
    unsigned SSPCLKPPS3         : 1;
    unsigned SSPCLKPPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSPCLKPPS          : 5;
    unsigned                    : 3;
    };
  } __SSPCLKPPSbits_t;

extern __at(0x0E20) volatile __SSPCLKPPSbits_t SSPCLKPPSbits;

#define _SSPCLKPPS0             0x01
#define _SSPCLKPPS1             0x02
#define _SSPCLKPPS2             0x04
#define _SSPCLKPPS3             0x08
#define _SSPCLKPPS4             0x10

//==============================================================================


//==============================================================================
//        SSPDATPPS Bits

extern __at(0x0E21) __sfr SSPDATPPS;

typedef union
  {
  struct
    {
    unsigned SSPDATPPS0         : 1;
    unsigned SSPDATPPS1         : 1;
    unsigned SSPDATPPS2         : 1;
    unsigned SSPDATPPS3         : 1;
    unsigned SSPDATPPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSPDATPPS          : 5;
    unsigned                    : 3;
    };
  } __SSPDATPPSbits_t;

extern __at(0x0E21) volatile __SSPDATPPSbits_t SSPDATPPSbits;

#define _SSPDATPPS0             0x01
#define _SSPDATPPS1             0x02
#define _SSPDATPPS2             0x04
#define _SSPDATPPS3             0x08
#define _SSPDATPPS4             0x10

//==============================================================================


//==============================================================================
//        SSPSSPPS Bits

extern __at(0x0E22) __sfr SSPSSPPS;

typedef union
  {
  struct
    {
    unsigned SSPSSPPS0          : 1;
    unsigned SSPSSPPS1          : 1;
    unsigned SSPSSPPS2          : 1;
    unsigned SSPSSPPS3          : 1;
    unsigned SSPSSPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSPSSPPS           : 5;
    unsigned                    : 3;
    };
  } __SSPSSPPSbits_t;

extern __at(0x0E22) volatile __SSPSSPPSbits_t SSPSSPPSbits;

#define _SSPSSPPS0              0x01
#define _SSPSSPPS1              0x02
#define _SSPSSPPS2              0x04
#define _SSPSSPPS3              0x08
#define _SSPSSPPS4              0x10

//==============================================================================


//==============================================================================
//        ATCC2PPS Bits

extern __at(0x0E23) __sfr ATCC2PPS;

typedef union
  {
  struct
    {
    unsigned ATCC2PPS0          : 1;
    unsigned ATCC2PPS1          : 1;
    unsigned ATCC2PPS2          : 1;
    unsigned ATCC2PPS3          : 1;
    unsigned ATCC2PPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ATCC2PPS           : 5;
    unsigned                    : 3;
    };
  } __ATCC2PPSbits_t;

extern __at(0x0E23) volatile __ATCC2PPSbits_t ATCC2PPSbits;

#define _ATCC2PPS0              0x01
#define _ATCC2PPS1              0x02
#define _ATCC2PPS2              0x04
#define _ATCC2PPS3              0x08
#define _ATCC2PPS4              0x10

//==============================================================================


//==============================================================================
//        RXPPS Bits

extern __at(0x0E24) __sfr RXPPS;

typedef union
  {
  struct
    {
    unsigned RXPPS0             : 1;
    unsigned RXPPS1             : 1;
    unsigned RXPPS2             : 1;
    unsigned RXPPS3             : 1;
    unsigned RXPPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RXPPS              : 5;
    unsigned                    : 3;
    };
  } __RXPPSbits_t;

extern __at(0x0E24) volatile __RXPPSbits_t RXPPSbits;

#define _RXPPS0                 0x01
#define _RXPPS1                 0x02
#define _RXPPS2                 0x04
#define _RXPPS3                 0x08
#define _RXPPS4                 0x10

//==============================================================================


//==============================================================================
//        CKPPS Bits

extern __at(0x0E25) __sfr CKPPS;

typedef union
  {
  struct
    {
    unsigned CKPPS0             : 1;
    unsigned CKPPS1             : 1;
    unsigned CKPPS2             : 1;
    unsigned CKPPS3             : 1;
    unsigned CKPPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CKPPS              : 5;
    unsigned                    : 3;
    };
  } __CKPPSbits_t;

extern __at(0x0E25) volatile __CKPPSbits_t CKPPSbits;

#define _CKPPS0                 0x01
#define _CKPPS1                 0x02
#define _CKPPS2                 0x04
#define _CKPPS3                 0x08
#define _CKPPS4                 0x10

//==============================================================================


//==============================================================================
//        SMT1SIGPPS Bits

extern __at(0x0E26) __sfr SMT1SIGPPS;

typedef union
  {
  struct
    {
    unsigned SMT1SIGPPS0        : 1;
    unsigned SMT1SIGPPS1        : 1;
    unsigned SMT1SIGPPS2        : 1;
    unsigned SMT1SIGPPS3        : 1;
    unsigned SMT1SIGPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1SIGPPS         : 5;
    unsigned                    : 3;
    };
  } __SMT1SIGPPSbits_t;

extern __at(0x0E26) volatile __SMT1SIGPPSbits_t SMT1SIGPPSbits;

#define _SMT1SIGPPS0            0x01
#define _SMT1SIGPPS1            0x02
#define _SMT1SIGPPS2            0x04
#define _SMT1SIGPPS3            0x08
#define _SMT1SIGPPS4            0x10

//==============================================================================


//==============================================================================
//        SMT1WINPPS Bits

extern __at(0x0E27) __sfr SMT1WINPPS;

typedef union
  {
  struct
    {
    unsigned SMTWINPPS0         : 1;
    unsigned SMTWINPPS1         : 1;
    unsigned SMTWINPPS2         : 1;
    unsigned SMTWINPPS3         : 1;
    unsigned SMTWINPPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMTWINPPS          : 5;
    unsigned                    : 3;
    };
  } __SMT1WINPPSbits_t;

extern __at(0x0E27) volatile __SMT1WINPPSbits_t SMT1WINPPSbits;

#define _SMTWINPPS0             0x01
#define _SMTWINPPS1             0x02
#define _SMTWINPPS2             0x04
#define _SMTWINPPS3             0x08
#define _SMTWINPPS4             0x10

//==============================================================================


//==============================================================================
//        CLCIN0PPS Bits

extern __at(0x0E28) __sfr CLCIN0PPS;

typedef union
  {
  struct
    {
    unsigned CLCIN0PPS0         : 1;
    unsigned CLCIN0PPS1         : 1;
    unsigned CLCIN0PPS2         : 1;
    unsigned CLCIN0PPS3         : 1;
    unsigned CLCIN0PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CLCIN0PPS          : 5;
    unsigned                    : 3;
    };
  } __CLCIN0PPSbits_t;

extern __at(0x0E28) volatile __CLCIN0PPSbits_t CLCIN0PPSbits;

#define _CLCIN0PPS0             0x01
#define _CLCIN0PPS1             0x02
#define _CLCIN0PPS2             0x04
#define _CLCIN0PPS3             0x08
#define _CLCIN0PPS4             0x10

//==============================================================================


//==============================================================================
//        CLCIN1PPS Bits

extern __at(0x0E29) __sfr CLCIN1PPS;

typedef union
  {
  struct
    {
    unsigned CLCIN1PPS0         : 1;
    unsigned CLCIN1PPS1         : 1;
    unsigned CLCIN1PPS2         : 1;
    unsigned CLCIN1PPS3         : 1;
    unsigned CLCIN1PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CLCIN1PPS          : 5;
    unsigned                    : 3;
    };
  } __CLCIN1PPSbits_t;

extern __at(0x0E29) volatile __CLCIN1PPSbits_t CLCIN1PPSbits;

#define _CLCIN1PPS0             0x01
#define _CLCIN1PPS1             0x02
#define _CLCIN1PPS2             0x04
#define _CLCIN1PPS3             0x08
#define _CLCIN1PPS4             0x10

//==============================================================================


//==============================================================================
//        CLCIN2PPS Bits

extern __at(0x0E2A) __sfr CLCIN2PPS;

typedef union
  {
  struct
    {
    unsigned CLCIN2PPS0         : 1;
    unsigned CLCIN2PPS1         : 1;
    unsigned CLCIN2PPS2         : 1;
    unsigned CLCIN2PPS3         : 1;
    unsigned CLCIN2PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CLCIN2PPS          : 5;
    unsigned                    : 3;
    };
  } __CLCIN2PPSbits_t;

extern __at(0x0E2A) volatile __CLCIN2PPSbits_t CLCIN2PPSbits;

#define _CLCIN2PPS0             0x01
#define _CLCIN2PPS1             0x02
#define _CLCIN2PPS2             0x04
#define _CLCIN2PPS3             0x08
#define _CLCIN2PPS4             0x10

//==============================================================================


//==============================================================================
//        CLCIN3PPS Bits

extern __at(0x0E2B) __sfr CLCIN3PPS;

typedef union
  {
  struct
    {
    unsigned CLCIN3PPS0         : 1;
    unsigned CLCIN3PPS1         : 1;
    unsigned CLCIN3PPS2         : 1;
    unsigned CLCIN3PPS3         : 1;
    unsigned CLCIN3PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CLCIN3PPS          : 5;
    unsigned                    : 3;
    };
  } __CLCIN3PPSbits_t;

extern __at(0x0E2B) volatile __CLCIN3PPSbits_t CLCIN3PPSbits;

#define _CLCIN3PPS0             0x01
#define _CLCIN3PPS1             0x02
#define _CLCIN3PPS2             0x04
#define _CLCIN3PPS3             0x08
#define _CLCIN3PPS4             0x10

//==============================================================================


//==============================================================================
//        SMT2SIGPPS Bits

extern __at(0x0E2C) __sfr SMT2SIGPPS;

typedef union
  {
  struct
    {
    unsigned SMT2SIGPPS0        : 1;
    unsigned SMT2SIGPPS1        : 1;
    unsigned SMT2SIGPPS2        : 1;
    unsigned SMT2SIGPPS3        : 1;
    unsigned SMT2SIGPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT2SIGPPS         : 5;
    unsigned                    : 3;
    };
  } __SMT2SIGPPSbits_t;

extern __at(0x0E2C) volatile __SMT2SIGPPSbits_t SMT2SIGPPSbits;

#define _SMT2SIGPPS0            0x01
#define _SMT2SIGPPS1            0x02
#define _SMT2SIGPPS2            0x04
#define _SMT2SIGPPS3            0x08
#define _SMT2SIGPPS4            0x10

//==============================================================================


//==============================================================================
//        SMT2WINPPS Bits

extern __at(0x0E2D) __sfr SMT2WINPPS;

typedef union
  {
  struct
    {
    unsigned SMT2WINPPS0        : 1;
    unsigned SMT2WINPPS1        : 1;
    unsigned SMT2WINPPS2        : 1;
    unsigned SMT2WINPPS3        : 1;
    unsigned SMT2WINPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT2WINPPS         : 5;
    unsigned                    : 3;
    };
  } __SMT2WINPPSbits_t;

extern __at(0x0E2D) volatile __SMT2WINPPSbits_t SMT2WINPPSbits;

#define _SMT2WINPPS0            0x01
#define _SMT2WINPPS1            0x02
#define _SMT2WINPPS2            0x04
#define _SMT2WINPPS3            0x08
#define _SMT2WINPPS4            0x10

//==============================================================================


//==============================================================================
//        ATCC3PPS Bits

extern __at(0x0E2E) __sfr ATCC3PPS;

typedef union
  {
  struct
    {
    unsigned ATCC3PPS0          : 1;
    unsigned ATCC3PPS1          : 1;
    unsigned ATCC3PPS2          : 1;
    unsigned ATCC3PPS3          : 1;
    unsigned ATCC3PPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ATCC3PPS           : 5;
    unsigned                    : 3;
    };
  } __ATCC3PPSbits_t;

extern __at(0x0E2E) volatile __ATCC3PPSbits_t ATCC3PPSbits;

#define _ATCC3PPS0              0x01
#define _ATCC3PPS1              0x02
#define _ATCC3PPS2              0x04
#define _ATCC3PPS3              0x08
#define _ATCC3PPS4              0x10

//==============================================================================


//==============================================================================
//        RA0PPS Bits

extern __at(0x0E90) __sfr RA0PPS;

typedef union
  {
  struct
    {
    unsigned RA0PPS0            : 1;
    unsigned RA0PPS1            : 1;
    unsigned RA0PPS2            : 1;
    unsigned RA0PPS3            : 1;
    unsigned RA0PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA0PPS             : 5;
    unsigned                    : 3;
    };
  } __RA0PPSbits_t;

extern __at(0x0E90) volatile __RA0PPSbits_t RA0PPSbits;

#define _RA0PPS0                0x01
#define _RA0PPS1                0x02
#define _RA0PPS2                0x04
#define _RA0PPS3                0x08
#define _RA0PPS4                0x10

//==============================================================================


//==============================================================================
//        RA1PPS Bits

extern __at(0x0E91) __sfr RA1PPS;

typedef union
  {
  struct
    {
    unsigned RA1PPS0            : 1;
    unsigned RA1PPS1            : 1;
    unsigned RA1PPS2            : 1;
    unsigned RA1PPS3            : 1;
    unsigned RA1PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA1PPS             : 5;
    unsigned                    : 3;
    };
  } __RA1PPSbits_t;

extern __at(0x0E91) volatile __RA1PPSbits_t RA1PPSbits;

#define _RA1PPS0                0x01
#define _RA1PPS1                0x02
#define _RA1PPS2                0x04
#define _RA1PPS3                0x08
#define _RA1PPS4                0x10

//==============================================================================


//==============================================================================
//        RA2PPS Bits

extern __at(0x0E92) __sfr RA2PPS;

typedef union
  {
  struct
    {
    unsigned RA2PPS0            : 1;
    unsigned RA2PPS1            : 1;
    unsigned RA2PPS2            : 1;
    unsigned RA2PPS3            : 1;
    unsigned RA2PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA2PPS             : 5;
    unsigned                    : 3;
    };
  } __RA2PPSbits_t;

extern __at(0x0E92) volatile __RA2PPSbits_t RA2PPSbits;

#define _RA2PPS0                0x01
#define _RA2PPS1                0x02
#define _RA2PPS2                0x04
#define _RA2PPS3                0x08
#define _RA2PPS4                0x10

//==============================================================================


//==============================================================================
//        RA4PPS Bits

extern __at(0x0E94) __sfr RA4PPS;

typedef union
  {
  struct
    {
    unsigned RA4PPS0            : 1;
    unsigned RA4PPS1            : 1;
    unsigned RA4PPS2            : 1;
    unsigned RA4PPS3            : 1;
    unsigned RA4PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA4PPS             : 5;
    unsigned                    : 3;
    };
  } __RA4PPSbits_t;

extern __at(0x0E94) volatile __RA4PPSbits_t RA4PPSbits;

#define _RA4PPS0                0x01
#define _RA4PPS1                0x02
#define _RA4PPS2                0x04
#define _RA4PPS3                0x08
#define _RA4PPS4                0x10

//==============================================================================


//==============================================================================
//        RA5PPS Bits

extern __at(0x0E95) __sfr RA5PPS;

typedef union
  {
  struct
    {
    unsigned RA5PPS0            : 1;
    unsigned RA5PPS1            : 1;
    unsigned RA5PPS2            : 1;
    unsigned RA5PPS3            : 1;
    unsigned RA5PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA5PPS             : 5;
    unsigned                    : 3;
    };
  } __RA5PPSbits_t;

extern __at(0x0E95) volatile __RA5PPSbits_t RA5PPSbits;

#define _RA5PPS0                0x01
#define _RA5PPS1                0x02
#define _RA5PPS2                0x04
#define _RA5PPS3                0x08
#define _RA5PPS4                0x10

//==============================================================================


//==============================================================================
//        RB4PPS Bits

extern __at(0x0E9C) __sfr RB4PPS;

typedef union
  {
  struct
    {
    unsigned RB4PPS0            : 1;
    unsigned RB4PPS1            : 1;
    unsigned RB4PPS2            : 1;
    unsigned RB4PPS3            : 1;
    unsigned RB4PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB4PPS             : 5;
    unsigned                    : 3;
    };
  } __RB4PPSbits_t;

extern __at(0x0E9C) volatile __RB4PPSbits_t RB4PPSbits;

#define _RB4PPS0                0x01
#define _RB4PPS1                0x02
#define _RB4PPS2                0x04
#define _RB4PPS3                0x08
#define _RB4PPS4                0x10

//==============================================================================


//==============================================================================
//        RB5PPS Bits

extern __at(0x0E9D) __sfr RB5PPS;

typedef union
  {
  struct
    {
    unsigned RB5PPS0            : 1;
    unsigned RB5PPS1            : 1;
    unsigned RB5PPS2            : 1;
    unsigned RB5PPS3            : 1;
    unsigned RB5PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB5PPS             : 5;
    unsigned                    : 3;
    };
  } __RB5PPSbits_t;

extern __at(0x0E9D) volatile __RB5PPSbits_t RB5PPSbits;

#define _RB5PPS0                0x01
#define _RB5PPS1                0x02
#define _RB5PPS2                0x04
#define _RB5PPS3                0x08
#define _RB5PPS4                0x10

//==============================================================================


//==============================================================================
//        RB6PPS Bits

extern __at(0x0E9E) __sfr RB6PPS;

typedef union
  {
  struct
    {
    unsigned RB6PPS0            : 1;
    unsigned RB6PPS1            : 1;
    unsigned RB6PPS2            : 1;
    unsigned RB6PPS3            : 1;
    unsigned RB6PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB6PPS             : 5;
    unsigned                    : 3;
    };
  } __RB6PPSbits_t;

extern __at(0x0E9E) volatile __RB6PPSbits_t RB6PPSbits;

#define _RB6PPS0                0x01
#define _RB6PPS1                0x02
#define _RB6PPS2                0x04
#define _RB6PPS3                0x08
#define _RB6PPS4                0x10

//==============================================================================


//==============================================================================
//        RB7PPS Bits

extern __at(0x0E9F) __sfr RB7PPS;

typedef union
  {
  struct
    {
    unsigned RB7PPS0            : 1;
    unsigned RB7PPS1            : 1;
    unsigned RB7PPS2            : 1;
    unsigned RB7PPS3            : 1;
    unsigned RB7PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB7PPS             : 5;
    unsigned                    : 3;
    };
  } __RB7PPSbits_t;

extern __at(0x0E9F) volatile __RB7PPSbits_t RB7PPSbits;

#define _RB7PPS0                0x01
#define _RB7PPS1                0x02
#define _RB7PPS2                0x04
#define _RB7PPS3                0x08
#define _RB7PPS4                0x10

//==============================================================================


//==============================================================================
//        RC0PPS Bits

extern __at(0x0EA0) __sfr RC0PPS;

typedef union
  {
  struct
    {
    unsigned RC0PPS0            : 1;
    unsigned RC0PPS1            : 1;
    unsigned RC0PPS2            : 1;
    unsigned RC0PPS3            : 1;
    unsigned RC0PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC0PPS             : 5;
    unsigned                    : 3;
    };
  } __RC0PPSbits_t;

extern __at(0x0EA0) volatile __RC0PPSbits_t RC0PPSbits;

#define _RC0PPS0                0x01
#define _RC0PPS1                0x02
#define _RC0PPS2                0x04
#define _RC0PPS3                0x08
#define _RC0PPS4                0x10

//==============================================================================


//==============================================================================
//        RC1PPS Bits

extern __at(0x0EA1) __sfr RC1PPS;

typedef union
  {
  struct
    {
    unsigned RC1PPS0            : 1;
    unsigned RC1PPS1            : 1;
    unsigned RC1PPS2            : 1;
    unsigned RC1PPS3            : 1;
    unsigned RC1PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC1PPS             : 5;
    unsigned                    : 3;
    };
  } __RC1PPSbits_t;

extern __at(0x0EA1) volatile __RC1PPSbits_t RC1PPSbits;

#define _RC1PPS0                0x01
#define _RC1PPS1                0x02
#define _RC1PPS2                0x04
#define _RC1PPS3                0x08
#define _RC1PPS4                0x10

//==============================================================================


//==============================================================================
//        RC2PPS Bits

extern __at(0x0EA2) __sfr RC2PPS;

typedef union
  {
  struct
    {
    unsigned RC2PPS0            : 1;
    unsigned RC2PPS1            : 1;
    unsigned RC2PPS2            : 1;
    unsigned RC2PPS3            : 1;
    unsigned RC2PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC2PPS             : 5;
    unsigned                    : 3;
    };
  } __RC2PPSbits_t;

extern __at(0x0EA2) volatile __RC2PPSbits_t RC2PPSbits;

#define _RC2PPS0                0x01
#define _RC2PPS1                0x02
#define _RC2PPS2                0x04
#define _RC2PPS3                0x08
#define _RC2PPS4                0x10

//==============================================================================


//==============================================================================
//        RC3PPS Bits

extern __at(0x0EA3) __sfr RC3PPS;

typedef union
  {
  struct
    {
    unsigned RC3PPS0            : 1;
    unsigned RC3PPS1            : 1;
    unsigned RC3PPS2            : 1;
    unsigned RC3PPS3            : 1;
    unsigned RC3PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC3PPS             : 5;
    unsigned                    : 3;
    };
  } __RC3PPSbits_t;

extern __at(0x0EA3) volatile __RC3PPSbits_t RC3PPSbits;

#define _RC3PPS0                0x01
#define _RC3PPS1                0x02
#define _RC3PPS2                0x04
#define _RC3PPS3                0x08
#define _RC3PPS4                0x10

//==============================================================================


//==============================================================================
//        RC4PPS Bits

extern __at(0x0EA4) __sfr RC4PPS;

typedef union
  {
  struct
    {
    unsigned RC4PPS0            : 1;
    unsigned RC4PPS1            : 1;
    unsigned RC4PPS2            : 1;
    unsigned RC4PPS3            : 1;
    unsigned RC4PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC4PPS             : 5;
    unsigned                    : 3;
    };
  } __RC4PPSbits_t;

extern __at(0x0EA4) volatile __RC4PPSbits_t RC4PPSbits;

#define _RC4PPS0                0x01
#define _RC4PPS1                0x02
#define _RC4PPS2                0x04
#define _RC4PPS3                0x08
#define _RC4PPS4                0x10

//==============================================================================


//==============================================================================
//        RC5PPS Bits

extern __at(0x0EA5) __sfr RC5PPS;

typedef union
  {
  struct
    {
    unsigned RC5PPS0            : 1;
    unsigned RC5PPS1            : 1;
    unsigned RC5PPS2            : 1;
    unsigned RC5PPS3            : 1;
    unsigned RC5PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC5PPS             : 5;
    unsigned                    : 3;
    };
  } __RC5PPSbits_t;

extern __at(0x0EA5) volatile __RC5PPSbits_t RC5PPSbits;

#define _RC5PPS0                0x01
#define _RC5PPS1                0x02
#define _RC5PPS2                0x04
#define _RC5PPS3                0x08
#define _RC5PPS4                0x10

//==============================================================================


//==============================================================================
//        RC6PPS Bits

extern __at(0x0EA6) __sfr RC6PPS;

typedef union
  {
  struct
    {
    unsigned RC6PPS0            : 1;
    unsigned RC6PPS1            : 1;
    unsigned RC6PPS2            : 1;
    unsigned RC6PPS3            : 1;
    unsigned RC6PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC6PPS             : 5;
    unsigned                    : 3;
    };
  } __RC6PPSbits_t;

extern __at(0x0EA6) volatile __RC6PPSbits_t RC6PPSbits;

#define _RC6PPS0                0x01
#define _RC6PPS1                0x02
#define _RC6PPS2                0x04
#define _RC6PPS3                0x08
#define _RC6PPS4                0x10

//==============================================================================


//==============================================================================
//        RC7PPS Bits

extern __at(0x0EA7) __sfr RC7PPS;

typedef union
  {
  struct
    {
    unsigned RC7PPS0            : 1;
    unsigned RC7PPS1            : 1;
    unsigned RC7PPS2            : 1;
    unsigned RC7PPS3            : 1;
    unsigned RC7PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC7PPS             : 5;
    unsigned                    : 3;
    };
  } __RC7PPSbits_t;

extern __at(0x0EA7) volatile __RC7PPSbits_t RC7PPSbits;

#define _RC7PPS0                0x01
#define _RC7PPS1                0x02
#define _RC7PPS2                0x04
#define _RC7PPS3                0x08
#define _RC7PPS4                0x10

//==============================================================================


//==============================================================================
//        CLCDATA Bits

extern __at(0x0F0F) __sfr CLCDATA;

typedef struct
  {
  unsigned MLC1OUT              : 1;
  unsigned MLC2OUT              : 1;
  unsigned MLC3OUT              : 1;
  unsigned MLC4OUT              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CLCDATAbits_t;

extern __at(0x0F0F) volatile __CLCDATAbits_t CLCDATAbits;

#define _MLC1OUT                0x01
#define _MLC2OUT                0x02
#define _MLC3OUT                0x04
#define _MLC4OUT                0x08

//==============================================================================


//==============================================================================
//        CLC1CON Bits

extern __at(0x0F10) __sfr CLC1CON;

typedef union
  {
  struct
    {
    unsigned LC1MODE0           : 1;
    unsigned LC1MODE1           : 1;
    unsigned LC1MODE2           : 1;
    unsigned LC1INTN            : 1;
    unsigned LC1INTP            : 1;
    unsigned LC1OUT             : 1;
    unsigned                    : 1;
    unsigned LC1EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC1MODE            : 3;
    unsigned                    : 5;
    };
  } __CLC1CONbits_t;

extern __at(0x0F10) volatile __CLC1CONbits_t CLC1CONbits;

#define _CLC1CON_LC1MODE0       0x01
#define _CLC1CON_MODE0          0x01
#define _CLC1CON_LC1MODE1       0x02
#define _CLC1CON_MODE1          0x02
#define _CLC1CON_LC1MODE2       0x04
#define _CLC1CON_MODE2          0x04
#define _CLC1CON_LC1INTN        0x08
#define _CLC1CON_INTN           0x08
#define _CLC1CON_LC1INTP        0x10
#define _CLC1CON_INTP           0x10
#define _CLC1CON_LC1OUT         0x20
#define _CLC1CON_OUT            0x20
#define _CLC1CON_LC1EN          0x80
#define _CLC1CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC1POL Bits

extern __at(0x0F11) __sfr CLC1POL;

typedef union
  {
  struct
    {
    unsigned LC1G1POL           : 1;
    unsigned LC1G2POL           : 1;
    unsigned LC1G3POL           : 1;
    unsigned LC1G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC1POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC1POLbits_t;

extern __at(0x0F11) volatile __CLC1POLbits_t CLC1POLbits;

#define _CLC1POL_LC1G1POL       0x01
#define _CLC1POL_G1POL          0x01
#define _CLC1POL_LC1G2POL       0x02
#define _CLC1POL_G2POL          0x02
#define _CLC1POL_LC1G3POL       0x04
#define _CLC1POL_G3POL          0x04
#define _CLC1POL_LC1G4POL       0x08
#define _CLC1POL_G4POL          0x08
#define _CLC1POL_LC1POL         0x80
#define _CLC1POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC1SEL0 Bits

extern __at(0x0F12) __sfr CLC1SEL0;

typedef union
  {
  struct
    {
    unsigned LC1D1S0            : 1;
    unsigned LC1D1S1            : 1;
    unsigned LC1D1S2            : 1;
    unsigned LC1D1S3            : 1;
    unsigned LC1D1S4            : 1;
    unsigned LC1D1S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D1S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D1S                : 6;
    unsigned                    : 2;
    };
  } __CLC1SEL0bits_t;

extern __at(0x0F12) volatile __CLC1SEL0bits_t CLC1SEL0bits;

#define _LC1D1S0                0x01
#define _D1S0                   0x01
#define _LC1D1S1                0x02
#define _D1S1                   0x02
#define _LC1D1S2                0x04
#define _D1S2                   0x04
#define _LC1D1S3                0x08
#define _D1S3                   0x08
#define _LC1D1S4                0x10
#define _D1S4                   0x10
#define _LC1D1S5                0x20
#define _D1S5                   0x20

//==============================================================================


//==============================================================================
//        CLC1SEL1 Bits

extern __at(0x0F13) __sfr CLC1SEL1;

typedef union
  {
  struct
    {
    unsigned LC1D2S0            : 1;
    unsigned LC1D2S1            : 1;
    unsigned LC1D2S2            : 1;
    unsigned LC1D2S3            : 1;
    unsigned LC1D2S4            : 1;
    unsigned LC1D2S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC1D2S             : 6;
    unsigned                    : 2;
    };
  } __CLC1SEL1bits_t;

extern __at(0x0F13) volatile __CLC1SEL1bits_t CLC1SEL1bits;

#define _LC1D2S0                0x01
#define _D2S0                   0x01
#define _LC1D2S1                0x02
#define _D2S1                   0x02
#define _LC1D2S2                0x04
#define _D2S2                   0x04
#define _LC1D2S3                0x08
#define _D2S3                   0x08
#define _LC1D2S4                0x10
#define _D2S4                   0x10
#define _LC1D2S5                0x20
#define _D2S5                   0x20

//==============================================================================


//==============================================================================
//        CLC1SEL2 Bits

extern __at(0x0F14) __sfr CLC1SEL2;

typedef union
  {
  struct
    {
    unsigned LC1D3S0            : 1;
    unsigned LC1D3S1            : 1;
    unsigned LC1D3S2            : 1;
    unsigned LC1D3S3            : 1;
    unsigned LC1D3S4            : 1;
    unsigned LC1D3S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D3S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D3S                : 6;
    unsigned                    : 2;
    };
  } __CLC1SEL2bits_t;

extern __at(0x0F14) volatile __CLC1SEL2bits_t CLC1SEL2bits;

#define _LC1D3S0                0x01
#define _D3S0                   0x01
#define _LC1D3S1                0x02
#define _D3S1                   0x02
#define _LC1D3S2                0x04
#define _D3S2                   0x04
#define _LC1D3S3                0x08
#define _D3S3                   0x08
#define _LC1D3S4                0x10
#define _D3S4                   0x10
#define _LC1D3S5                0x20
#define _D3S5                   0x20

//==============================================================================


//==============================================================================
//        CLC1SEL3 Bits

extern __at(0x0F15) __sfr CLC1SEL3;

typedef union
  {
  struct
    {
    unsigned LC1D4S0            : 1;
    unsigned LC1D4S1            : 1;
    unsigned LC1D4S2            : 1;
    unsigned LC1D4S3            : 1;
    unsigned LC1D4S4            : 1;
    unsigned LC1D4S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D4S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D4S                : 6;
    unsigned                    : 2;
    };
  } __CLC1SEL3bits_t;

extern __at(0x0F15) volatile __CLC1SEL3bits_t CLC1SEL3bits;

#define _LC1D4S0                0x01
#define _D4S0                   0x01
#define _LC1D4S1                0x02
#define _D4S1                   0x02
#define _LC1D4S2                0x04
#define _D4S2                   0x04
#define _LC1D4S3                0x08
#define _D4S3                   0x08
#define _LC1D4S4                0x10
#define _D4S4                   0x10
#define _LC1D4S5                0x20
#define _D4S5                   0x20

//==============================================================================


//==============================================================================
//        CLC1GLS0 Bits

extern __at(0x0F16) __sfr CLC1GLS0;

typedef union
  {
  struct
    {
    unsigned LC1G1D1N           : 1;
    unsigned LC1G1D1T           : 1;
    unsigned LC1G1D2N           : 1;
    unsigned LC1G1D2T           : 1;
    unsigned LC1G1D3N           : 1;
    unsigned LC1G1D3T           : 1;
    unsigned LC1G1D4N           : 1;
    unsigned LC1G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS0bits_t;

extern __at(0x0F16) volatile __CLC1GLS0bits_t CLC1GLS0bits;

#define _LC1G1D1N               0x01
#define _D1N                    0x01
#define _LC1G1D1T               0x02
#define _D1T                    0x02
#define _LC1G1D2N               0x04
#define _D2N                    0x04
#define _LC1G1D2T               0x08
#define _D2T                    0x08
#define _LC1G1D3N               0x10
#define _D3N                    0x10
#define _LC1G1D3T               0x20
#define _D3T                    0x20
#define _LC1G1D4N               0x40
#define _D4N                    0x40
#define _LC1G1D4T               0x80
#define _D4T                    0x80

//==============================================================================


//==============================================================================
//        CLC1GLS1 Bits

extern __at(0x0F17) __sfr CLC1GLS1;

typedef union
  {
  struct
    {
    unsigned LC1G2D1N           : 1;
    unsigned LC1G2D1T           : 1;
    unsigned LC1G2D2N           : 1;
    unsigned LC1G2D2T           : 1;
    unsigned LC1G2D3N           : 1;
    unsigned LC1G2D3T           : 1;
    unsigned LC1G2D4N           : 1;
    unsigned LC1G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS1bits_t;

extern __at(0x0F17) volatile __CLC1GLS1bits_t CLC1GLS1bits;

#define _CLC1GLS1_LC1G2D1N      0x01
#define _CLC1GLS1_D1N           0x01
#define _CLC1GLS1_LC1G2D1T      0x02
#define _CLC1GLS1_D1T           0x02
#define _CLC1GLS1_LC1G2D2N      0x04
#define _CLC1GLS1_D2N           0x04
#define _CLC1GLS1_LC1G2D2T      0x08
#define _CLC1GLS1_D2T           0x08
#define _CLC1GLS1_LC1G2D3N      0x10
#define _CLC1GLS1_D3N           0x10
#define _CLC1GLS1_LC1G2D3T      0x20
#define _CLC1GLS1_D3T           0x20
#define _CLC1GLS1_LC1G2D4N      0x40
#define _CLC1GLS1_D4N           0x40
#define _CLC1GLS1_LC1G2D4T      0x80
#define _CLC1GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS2 Bits

extern __at(0x0F18) __sfr CLC1GLS2;

typedef union
  {
  struct
    {
    unsigned LC1G3D1N           : 1;
    unsigned LC1G3D1T           : 1;
    unsigned LC1G3D2N           : 1;
    unsigned LC1G3D2T           : 1;
    unsigned LC1G3D3N           : 1;
    unsigned LC1G3D3T           : 1;
    unsigned LC1G3D4N           : 1;
    unsigned LC1G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS2bits_t;

extern __at(0x0F18) volatile __CLC1GLS2bits_t CLC1GLS2bits;

#define _CLC1GLS2_LC1G3D1N      0x01
#define _CLC1GLS2_D1N           0x01
#define _CLC1GLS2_LC1G3D1T      0x02
#define _CLC1GLS2_D1T           0x02
#define _CLC1GLS2_LC1G3D2N      0x04
#define _CLC1GLS2_D2N           0x04
#define _CLC1GLS2_LC1G3D2T      0x08
#define _CLC1GLS2_D2T           0x08
#define _CLC1GLS2_LC1G3D3N      0x10
#define _CLC1GLS2_D3N           0x10
#define _CLC1GLS2_LC1G3D3T      0x20
#define _CLC1GLS2_D3T           0x20
#define _CLC1GLS2_LC1G3D4N      0x40
#define _CLC1GLS2_D4N           0x40
#define _CLC1GLS2_LC1G3D4T      0x80
#define _CLC1GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS3 Bits

extern __at(0x0F19) __sfr CLC1GLS3;

typedef union
  {
  struct
    {
    unsigned LC1G4D1N           : 1;
    unsigned LC1G4D1T           : 1;
    unsigned LC1G4D2N           : 1;
    unsigned LC1G4D2T           : 1;
    unsigned LC1G4D3N           : 1;
    unsigned LC1G4D3T           : 1;
    unsigned LC1G4D4N           : 1;
    unsigned LC1G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC1GLS3bits_t;

extern __at(0x0F19) volatile __CLC1GLS3bits_t CLC1GLS3bits;

#define _LC1G4D1N               0x01
#define _G4D1N                  0x01
#define _LC1G4D1T               0x02
#define _G4D1T                  0x02
#define _LC1G4D2N               0x04
#define _G4D2N                  0x04
#define _LC1G4D2T               0x08
#define _G4D2T                  0x08
#define _LC1G4D3N               0x10
#define _G4D3N                  0x10
#define _LC1G4D3T               0x20
#define _G4D3T                  0x20
#define _LC1G4D4N               0x40
#define _G4D4N                  0x40
#define _LC1G4D4T               0x80
#define _G4D4T                  0x80

//==============================================================================


//==============================================================================
//        CLC2CON Bits

extern __at(0x0F1A) __sfr CLC2CON;

typedef union
  {
  struct
    {
    unsigned LC2MODE0           : 1;
    unsigned LC2MODE1           : 1;
    unsigned LC2MODE2           : 1;
    unsigned LC2INTN            : 1;
    unsigned LC2INTP            : 1;
    unsigned LC2OUT             : 1;
    unsigned                    : 1;
    unsigned LC2EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC2MODE            : 3;
    unsigned                    : 5;
    };
  } __CLC2CONbits_t;

extern __at(0x0F1A) volatile __CLC2CONbits_t CLC2CONbits;

#define _CLC2CON_LC2MODE0       0x01
#define _CLC2CON_MODE0          0x01
#define _CLC2CON_LC2MODE1       0x02
#define _CLC2CON_MODE1          0x02
#define _CLC2CON_LC2MODE2       0x04
#define _CLC2CON_MODE2          0x04
#define _CLC2CON_LC2INTN        0x08
#define _CLC2CON_INTN           0x08
#define _CLC2CON_LC2INTP        0x10
#define _CLC2CON_INTP           0x10
#define _CLC2CON_LC2OUT         0x20
#define _CLC2CON_OUT            0x20
#define _CLC2CON_LC2EN          0x80
#define _CLC2CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC2POL Bits

extern __at(0x0F1B) __sfr CLC2POL;

typedef union
  {
  struct
    {
    unsigned LC2G1POL           : 1;
    unsigned LC2G2POL           : 1;
    unsigned LC2G3POL           : 1;
    unsigned LC2G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC2POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC2POLbits_t;

extern __at(0x0F1B) volatile __CLC2POLbits_t CLC2POLbits;

#define _CLC2POL_LC2G1POL       0x01
#define _CLC2POL_G1POL          0x01
#define _CLC2POL_LC2G2POL       0x02
#define _CLC2POL_G2POL          0x02
#define _CLC2POL_LC2G3POL       0x04
#define _CLC2POL_G3POL          0x04
#define _CLC2POL_LC2G4POL       0x08
#define _CLC2POL_G4POL          0x08
#define _CLC2POL_LC2POL         0x80
#define _CLC2POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC2SEL0 Bits

extern __at(0x0F1C) __sfr CLC2SEL0;

typedef union
  {
  struct
    {
    unsigned LC2D1S0            : 1;
    unsigned LC2D1S1            : 1;
    unsigned LC2D1S2            : 1;
    unsigned LC2D1S3            : 1;
    unsigned LC2D1S4            : 1;
    unsigned LC2D1S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC2D1S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D1S                : 6;
    unsigned                    : 2;
    };
  } __CLC2SEL0bits_t;

extern __at(0x0F1C) volatile __CLC2SEL0bits_t CLC2SEL0bits;

#define _CLC2SEL0_LC2D1S0       0x01
#define _CLC2SEL0_D1S0          0x01
#define _CLC2SEL0_LC2D1S1       0x02
#define _CLC2SEL0_D1S1          0x02
#define _CLC2SEL0_LC2D1S2       0x04
#define _CLC2SEL0_D1S2          0x04
#define _CLC2SEL0_LC2D1S3       0x08
#define _CLC2SEL0_D1S3          0x08
#define _CLC2SEL0_LC2D1S4       0x10
#define _CLC2SEL0_D1S4          0x10
#define _CLC2SEL0_LC2D1S5       0x20
#define _CLC2SEL0_D1S5          0x20

//==============================================================================


//==============================================================================
//        CLC2SEL1 Bits

extern __at(0x0F1D) __sfr CLC2SEL1;

typedef union
  {
  struct
    {
    unsigned LC2D2S0            : 1;
    unsigned LC2D2S1            : 1;
    unsigned LC2D2S2            : 1;
    unsigned LC2D2S3            : 1;
    unsigned LC2D2S4            : 1;
    unsigned LC2D2S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC2D2S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D2S                : 6;
    unsigned                    : 2;
    };
  } __CLC2SEL1bits_t;

extern __at(0x0F1D) volatile __CLC2SEL1bits_t CLC2SEL1bits;

#define _CLC2SEL1_LC2D2S0       0x01
#define _CLC2SEL1_D2S0          0x01
#define _CLC2SEL1_LC2D2S1       0x02
#define _CLC2SEL1_D2S1          0x02
#define _CLC2SEL1_LC2D2S2       0x04
#define _CLC2SEL1_D2S2          0x04
#define _CLC2SEL1_LC2D2S3       0x08
#define _CLC2SEL1_D2S3          0x08
#define _CLC2SEL1_LC2D2S4       0x10
#define _CLC2SEL1_D2S4          0x10
#define _CLC2SEL1_LC2D2S5       0x20
#define _CLC2SEL1_D2S5          0x20

//==============================================================================


//==============================================================================
//        CLC2SEL2 Bits

extern __at(0x0F1E) __sfr CLC2SEL2;

typedef union
  {
  struct
    {
    unsigned LC2D3S0            : 1;
    unsigned LC2D3S1            : 1;
    unsigned LC2D3S2            : 1;
    unsigned LC2D3S3            : 1;
    unsigned LC2D3S4            : 1;
    unsigned LC2D3S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC2D3S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D3S                : 6;
    unsigned                    : 2;
    };
  } __CLC2SEL2bits_t;

extern __at(0x0F1E) volatile __CLC2SEL2bits_t CLC2SEL2bits;

#define _CLC2SEL2_LC2D3S0       0x01
#define _CLC2SEL2_D3S0          0x01
#define _CLC2SEL2_LC2D3S1       0x02
#define _CLC2SEL2_D3S1          0x02
#define _CLC2SEL2_LC2D3S2       0x04
#define _CLC2SEL2_D3S2          0x04
#define _CLC2SEL2_LC2D3S3       0x08
#define _CLC2SEL2_D3S3          0x08
#define _CLC2SEL2_LC2D3S4       0x10
#define _CLC2SEL2_D3S4          0x10
#define _CLC2SEL2_LC2D3S5       0x20
#define _CLC2SEL2_D3S5          0x20

//==============================================================================


//==============================================================================
//        CLC2SEL3 Bits

extern __at(0x0F1F) __sfr CLC2SEL3;

typedef union
  {
  struct
    {
    unsigned LC2D4S0            : 1;
    unsigned LC2D4S1            : 1;
    unsigned LC2D4S2            : 1;
    unsigned LC2D4S3            : 1;
    unsigned LC2D4S4            : 1;
    unsigned LC2D4S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC2D4S             : 6;
    unsigned                    : 2;
    };
  } __CLC2SEL3bits_t;

extern __at(0x0F1F) volatile __CLC2SEL3bits_t CLC2SEL3bits;

#define _CLC2SEL3_LC2D4S0       0x01
#define _CLC2SEL3_D4S0          0x01
#define _CLC2SEL3_LC2D4S1       0x02
#define _CLC2SEL3_D4S1          0x02
#define _CLC2SEL3_LC2D4S2       0x04
#define _CLC2SEL3_D4S2          0x04
#define _CLC2SEL3_LC2D4S3       0x08
#define _CLC2SEL3_D4S3          0x08
#define _CLC2SEL3_LC2D4S4       0x10
#define _CLC2SEL3_D4S4          0x10
#define _CLC2SEL3_LC2D4S5       0x20
#define _CLC2SEL3_D4S5          0x20

//==============================================================================


//==============================================================================
//        CLC2GLS0 Bits

extern __at(0x0F20) __sfr CLC2GLS0;

typedef union
  {
  struct
    {
    unsigned LC2G1D1N           : 1;
    unsigned LC2G1D1T           : 1;
    unsigned LC2G1D2N           : 1;
    unsigned LC2G1D2T           : 1;
    unsigned LC2G1D3N           : 1;
    unsigned LC2G1D3T           : 1;
    unsigned LC2G1D4N           : 1;
    unsigned LC2G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS0bits_t;

extern __at(0x0F20) volatile __CLC2GLS0bits_t CLC2GLS0bits;

#define _CLC2GLS0_LC2G1D1N      0x01
#define _CLC2GLS0_D1N           0x01
#define _CLC2GLS0_LC2G1D1T      0x02
#define _CLC2GLS0_D1T           0x02
#define _CLC2GLS0_LC2G1D2N      0x04
#define _CLC2GLS0_D2N           0x04
#define _CLC2GLS0_LC2G1D2T      0x08
#define _CLC2GLS0_D2T           0x08
#define _CLC2GLS0_LC2G1D3N      0x10
#define _CLC2GLS0_D3N           0x10
#define _CLC2GLS0_LC2G1D3T      0x20
#define _CLC2GLS0_D3T           0x20
#define _CLC2GLS0_LC2G1D4N      0x40
#define _CLC2GLS0_D4N           0x40
#define _CLC2GLS0_LC2G1D4T      0x80
#define _CLC2GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS1 Bits

extern __at(0x0F21) __sfr CLC2GLS1;

typedef union
  {
  struct
    {
    unsigned LC2G2D1N           : 1;
    unsigned LC2G2D1T           : 1;
    unsigned LC2G2D2N           : 1;
    unsigned LC2G2D2T           : 1;
    unsigned LC2G2D3N           : 1;
    unsigned LC2G2D3T           : 1;
    unsigned LC2G2D4N           : 1;
    unsigned LC2G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS1bits_t;

extern __at(0x0F21) volatile __CLC2GLS1bits_t CLC2GLS1bits;

#define _CLC2GLS1_LC2G2D1N      0x01
#define _CLC2GLS1_D1N           0x01
#define _CLC2GLS1_LC2G2D1T      0x02
#define _CLC2GLS1_D1T           0x02
#define _CLC2GLS1_LC2G2D2N      0x04
#define _CLC2GLS1_D2N           0x04
#define _CLC2GLS1_LC2G2D2T      0x08
#define _CLC2GLS1_D2T           0x08
#define _CLC2GLS1_LC2G2D3N      0x10
#define _CLC2GLS1_D3N           0x10
#define _CLC2GLS1_LC2G2D3T      0x20
#define _CLC2GLS1_D3T           0x20
#define _CLC2GLS1_LC2G2D4N      0x40
#define _CLC2GLS1_D4N           0x40
#define _CLC2GLS1_LC2G2D4T      0x80
#define _CLC2GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS2 Bits

extern __at(0x0F22) __sfr CLC2GLS2;

typedef union
  {
  struct
    {
    unsigned LC2G3D1N           : 1;
    unsigned LC2G3D1T           : 1;
    unsigned LC2G3D2N           : 1;
    unsigned LC2G3D2T           : 1;
    unsigned LC2G3D3N           : 1;
    unsigned LC2G3D3T           : 1;
    unsigned LC2G3D4N           : 1;
    unsigned LC2G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS2bits_t;

extern __at(0x0F22) volatile __CLC2GLS2bits_t CLC2GLS2bits;

#define _CLC2GLS2_LC2G3D1N      0x01
#define _CLC2GLS2_D1N           0x01
#define _CLC2GLS2_LC2G3D1T      0x02
#define _CLC2GLS2_D1T           0x02
#define _CLC2GLS2_LC2G3D2N      0x04
#define _CLC2GLS2_D2N           0x04
#define _CLC2GLS2_LC2G3D2T      0x08
#define _CLC2GLS2_D2T           0x08
#define _CLC2GLS2_LC2G3D3N      0x10
#define _CLC2GLS2_D3N           0x10
#define _CLC2GLS2_LC2G3D3T      0x20
#define _CLC2GLS2_D3T           0x20
#define _CLC2GLS2_LC2G3D4N      0x40
#define _CLC2GLS2_D4N           0x40
#define _CLC2GLS2_LC2G3D4T      0x80
#define _CLC2GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS3 Bits

extern __at(0x0F23) __sfr CLC2GLS3;

typedef union
  {
  struct
    {
    unsigned LC2G4D1N           : 1;
    unsigned LC2G4D1T           : 1;
    unsigned LC2G4D2N           : 1;
    unsigned LC2G4D2T           : 1;
    unsigned LC2G4D3N           : 1;
    unsigned LC2G4D3T           : 1;
    unsigned LC2G4D4N           : 1;
    unsigned LC2G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC2GLS3bits_t;

extern __at(0x0F23) volatile __CLC2GLS3bits_t CLC2GLS3bits;

#define _CLC2GLS3_LC2G4D1N      0x01
#define _CLC2GLS3_G4D1N         0x01
#define _CLC2GLS3_LC2G4D1T      0x02
#define _CLC2GLS3_G4D1T         0x02
#define _CLC2GLS3_LC2G4D2N      0x04
#define _CLC2GLS3_G4D2N         0x04
#define _CLC2GLS3_LC2G4D2T      0x08
#define _CLC2GLS3_G4D2T         0x08
#define _CLC2GLS3_LC2G4D3N      0x10
#define _CLC2GLS3_G4D3N         0x10
#define _CLC2GLS3_LC2G4D3T      0x20
#define _CLC2GLS3_G4D3T         0x20
#define _CLC2GLS3_LC2G4D4N      0x40
#define _CLC2GLS3_G4D4N         0x40
#define _CLC2GLS3_LC2G4D4T      0x80
#define _CLC2GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        CLC3CON Bits

extern __at(0x0F24) __sfr CLC3CON;

typedef union
  {
  struct
    {
    unsigned LC3MODE0           : 1;
    unsigned LC3MODE1           : 1;
    unsigned LC3MODE2           : 1;
    unsigned LC3INTN            : 1;
    unsigned LC3INTP            : 1;
    unsigned LC3OUT             : 1;
    unsigned                    : 1;
    unsigned LC3EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned LC3MODE            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CLC3CONbits_t;

extern __at(0x0F24) volatile __CLC3CONbits_t CLC3CONbits;

#define _CLC3CON_LC3MODE0       0x01
#define _CLC3CON_MODE0          0x01
#define _CLC3CON_LC3MODE1       0x02
#define _CLC3CON_MODE1          0x02
#define _CLC3CON_LC3MODE2       0x04
#define _CLC3CON_MODE2          0x04
#define _CLC3CON_LC3INTN        0x08
#define _CLC3CON_INTN           0x08
#define _CLC3CON_LC3INTP        0x10
#define _CLC3CON_INTP           0x10
#define _CLC3CON_LC3OUT         0x20
#define _CLC3CON_OUT            0x20
#define _CLC3CON_LC3EN          0x80
#define _CLC3CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC3POL Bits

extern __at(0x0F25) __sfr CLC3POL;

typedef union
  {
  struct
    {
    unsigned LC3G1POL           : 1;
    unsigned LC3G2POL           : 1;
    unsigned LC3G3POL           : 1;
    unsigned LC3G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC3POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC3POLbits_t;

extern __at(0x0F25) volatile __CLC3POLbits_t CLC3POLbits;

#define _CLC3POL_LC3G1POL       0x01
#define _CLC3POL_G1POL          0x01
#define _CLC3POL_LC3G2POL       0x02
#define _CLC3POL_G2POL          0x02
#define _CLC3POL_LC3G3POL       0x04
#define _CLC3POL_G3POL          0x04
#define _CLC3POL_LC3G4POL       0x08
#define _CLC3POL_G4POL          0x08
#define _CLC3POL_LC3POL         0x80
#define _CLC3POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC3SEL0 Bits

extern __at(0x0F26) __sfr CLC3SEL0;

typedef union
  {
  struct
    {
    unsigned LC3D1S0            : 1;
    unsigned LC3D1S1            : 1;
    unsigned LC3D1S2            : 1;
    unsigned LC3D1S3            : 1;
    unsigned LC3D1S4            : 1;
    unsigned LC3D1S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC3D1S             : 6;
    unsigned                    : 2;
    };
  } __CLC3SEL0bits_t;

extern __at(0x0F26) volatile __CLC3SEL0bits_t CLC3SEL0bits;

#define _CLC3SEL0_LC3D1S0       0x01
#define _CLC3SEL0_D1S0          0x01
#define _CLC3SEL0_LC3D1S1       0x02
#define _CLC3SEL0_D1S1          0x02
#define _CLC3SEL0_LC3D1S2       0x04
#define _CLC3SEL0_D1S2          0x04
#define _CLC3SEL0_LC3D1S3       0x08
#define _CLC3SEL0_D1S3          0x08
#define _CLC3SEL0_LC3D1S4       0x10
#define _CLC3SEL0_D1S4          0x10
#define _CLC3SEL0_LC3D1S5       0x20
#define _CLC3SEL0_D1S5          0x20

//==============================================================================


//==============================================================================
//        CLC3SEL1 Bits

extern __at(0x0F27) __sfr CLC3SEL1;

typedef union
  {
  struct
    {
    unsigned LC3D2S0            : 1;
    unsigned LC3D2S1            : 1;
    unsigned LC3D2S2            : 1;
    unsigned LC3D2S3            : 1;
    unsigned LC3D2S4            : 1;
    unsigned LC3D2S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC3D2S             : 6;
    unsigned                    : 2;
    };
  } __CLC3SEL1bits_t;

extern __at(0x0F27) volatile __CLC3SEL1bits_t CLC3SEL1bits;

#define _CLC3SEL1_LC3D2S0       0x01
#define _CLC3SEL1_D2S0          0x01
#define _CLC3SEL1_LC3D2S1       0x02
#define _CLC3SEL1_D2S1          0x02
#define _CLC3SEL1_LC3D2S2       0x04
#define _CLC3SEL1_D2S2          0x04
#define _CLC3SEL1_LC3D2S3       0x08
#define _CLC3SEL1_D2S3          0x08
#define _CLC3SEL1_LC3D2S4       0x10
#define _CLC3SEL1_D2S4          0x10
#define _CLC3SEL1_LC3D2S5       0x20
#define _CLC3SEL1_D2S5          0x20

//==============================================================================


//==============================================================================
//        CLC3SEL2 Bits

extern __at(0x0F28) __sfr CLC3SEL2;

typedef union
  {
  struct
    {
    unsigned LC3D3S0            : 1;
    unsigned LC3D3S1            : 1;
    unsigned LC3D3S2            : 1;
    unsigned LC3D3S3            : 1;
    unsigned LC3D3S4            : 1;
    unsigned LC3D3S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC3D3S             : 6;
    unsigned                    : 2;
    };
  } __CLC3SEL2bits_t;

extern __at(0x0F28) volatile __CLC3SEL2bits_t CLC3SEL2bits;

#define _CLC3SEL2_LC3D3S0       0x01
#define _CLC3SEL2_D3S0          0x01
#define _CLC3SEL2_LC3D3S1       0x02
#define _CLC3SEL2_D3S1          0x02
#define _CLC3SEL2_LC3D3S2       0x04
#define _CLC3SEL2_D3S2          0x04
#define _CLC3SEL2_LC3D3S3       0x08
#define _CLC3SEL2_D3S3          0x08
#define _CLC3SEL2_LC3D3S4       0x10
#define _CLC3SEL2_D3S4          0x10
#define _CLC3SEL2_LC3D3S5       0x20
#define _CLC3SEL2_D3S5          0x20

//==============================================================================


//==============================================================================
//        CLC3SEL3 Bits

extern __at(0x0F29) __sfr CLC3SEL3;

typedef union
  {
  struct
    {
    unsigned LC3D4S0            : 1;
    unsigned LC3D4S1            : 1;
    unsigned LC3D4S2            : 1;
    unsigned LC3D4S3            : 1;
    unsigned LC3D4S4            : 1;
    unsigned LC3D4S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC3D4S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D4S                : 6;
    unsigned                    : 2;
    };
  } __CLC3SEL3bits_t;

extern __at(0x0F29) volatile __CLC3SEL3bits_t CLC3SEL3bits;

#define _CLC3SEL3_LC3D4S0       0x01
#define _CLC3SEL3_D4S0          0x01
#define _CLC3SEL3_LC3D4S1       0x02
#define _CLC3SEL3_D4S1          0x02
#define _CLC3SEL3_LC3D4S2       0x04
#define _CLC3SEL3_D4S2          0x04
#define _CLC3SEL3_LC3D4S3       0x08
#define _CLC3SEL3_D4S3          0x08
#define _CLC3SEL3_LC3D4S4       0x10
#define _CLC3SEL3_D4S4          0x10
#define _CLC3SEL3_LC3D4S5       0x20
#define _CLC3SEL3_D4S5          0x20

//==============================================================================


//==============================================================================
//        CLC3GLS0 Bits

extern __at(0x0F2A) __sfr CLC3GLS0;

typedef union
  {
  struct
    {
    unsigned LC3G1D1N           : 1;
    unsigned LC3G1D1T           : 1;
    unsigned LC3G1D2N           : 1;
    unsigned LC3G1D2T           : 1;
    unsigned LC3G1D3N           : 1;
    unsigned LC3G1D3T           : 1;
    unsigned LC3G1D4N           : 1;
    unsigned LC3G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS0bits_t;

extern __at(0x0F2A) volatile __CLC3GLS0bits_t CLC3GLS0bits;

#define _CLC3GLS0_LC3G1D1N      0x01
#define _CLC3GLS0_D1N           0x01
#define _CLC3GLS0_LC3G1D1T      0x02
#define _CLC3GLS0_D1T           0x02
#define _CLC3GLS0_LC3G1D2N      0x04
#define _CLC3GLS0_D2N           0x04
#define _CLC3GLS0_LC3G1D2T      0x08
#define _CLC3GLS0_D2T           0x08
#define _CLC3GLS0_LC3G1D3N      0x10
#define _CLC3GLS0_D3N           0x10
#define _CLC3GLS0_LC3G1D3T      0x20
#define _CLC3GLS0_D3T           0x20
#define _CLC3GLS0_LC3G1D4N      0x40
#define _CLC3GLS0_D4N           0x40
#define _CLC3GLS0_LC3G1D4T      0x80
#define _CLC3GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS1 Bits

extern __at(0x0F2B) __sfr CLC3GLS1;

typedef union
  {
  struct
    {
    unsigned LC3G2D1N           : 1;
    unsigned LC3G2D1T           : 1;
    unsigned LC3G2D2N           : 1;
    unsigned LC3G2D2T           : 1;
    unsigned LC3G2D3N           : 1;
    unsigned LC3G2D3T           : 1;
    unsigned LC3G2D4N           : 1;
    unsigned LC3G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS1bits_t;

extern __at(0x0F2B) volatile __CLC3GLS1bits_t CLC3GLS1bits;

#define _CLC3GLS1_LC3G2D1N      0x01
#define _CLC3GLS1_D1N           0x01
#define _CLC3GLS1_LC3G2D1T      0x02
#define _CLC3GLS1_D1T           0x02
#define _CLC3GLS1_LC3G2D2N      0x04
#define _CLC3GLS1_D2N           0x04
#define _CLC3GLS1_LC3G2D2T      0x08
#define _CLC3GLS1_D2T           0x08
#define _CLC3GLS1_LC3G2D3N      0x10
#define _CLC3GLS1_D3N           0x10
#define _CLC3GLS1_LC3G2D3T      0x20
#define _CLC3GLS1_D3T           0x20
#define _CLC3GLS1_LC3G2D4N      0x40
#define _CLC3GLS1_D4N           0x40
#define _CLC3GLS1_LC3G2D4T      0x80
#define _CLC3GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS2 Bits

extern __at(0x0F2C) __sfr CLC3GLS2;

typedef union
  {
  struct
    {
    unsigned LC3G3D1N           : 1;
    unsigned LC3G3D1T           : 1;
    unsigned LC3G3D2N           : 1;
    unsigned LC3G3D2T           : 1;
    unsigned LC3G3D3N           : 1;
    unsigned LC3G3D3T           : 1;
    unsigned LC3G3D4N           : 1;
    unsigned LC3G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS2bits_t;

extern __at(0x0F2C) volatile __CLC3GLS2bits_t CLC3GLS2bits;

#define _CLC3GLS2_LC3G3D1N      0x01
#define _CLC3GLS2_D1N           0x01
#define _CLC3GLS2_LC3G3D1T      0x02
#define _CLC3GLS2_D1T           0x02
#define _CLC3GLS2_LC3G3D2N      0x04
#define _CLC3GLS2_D2N           0x04
#define _CLC3GLS2_LC3G3D2T      0x08
#define _CLC3GLS2_D2T           0x08
#define _CLC3GLS2_LC3G3D3N      0x10
#define _CLC3GLS2_D3N           0x10
#define _CLC3GLS2_LC3G3D3T      0x20
#define _CLC3GLS2_D3T           0x20
#define _CLC3GLS2_LC3G3D4N      0x40
#define _CLC3GLS2_D4N           0x40
#define _CLC3GLS2_LC3G3D4T      0x80
#define _CLC3GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS3 Bits

extern __at(0x0F2D) __sfr CLC3GLS3;

typedef union
  {
  struct
    {
    unsigned LC3G4D1N           : 1;
    unsigned LC3G4D1T           : 1;
    unsigned LC3G4D2N           : 1;
    unsigned LC3G4D2T           : 1;
    unsigned LC3G4D3N           : 1;
    unsigned LC3G4D3T           : 1;
    unsigned LC3G4D4N           : 1;
    unsigned LC3G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC3GLS3bits_t;

extern __at(0x0F2D) volatile __CLC3GLS3bits_t CLC3GLS3bits;

#define _CLC3GLS3_LC3G4D1N      0x01
#define _CLC3GLS3_G4D1N         0x01
#define _CLC3GLS3_LC3G4D1T      0x02
#define _CLC3GLS3_G4D1T         0x02
#define _CLC3GLS3_LC3G4D2N      0x04
#define _CLC3GLS3_G4D2N         0x04
#define _CLC3GLS3_LC3G4D2T      0x08
#define _CLC3GLS3_G4D2T         0x08
#define _CLC3GLS3_LC3G4D3N      0x10
#define _CLC3GLS3_G4D3N         0x10
#define _CLC3GLS3_LC3G4D3T      0x20
#define _CLC3GLS3_G4D3T         0x20
#define _CLC3GLS3_LC3G4D4N      0x40
#define _CLC3GLS3_G4D4N         0x40
#define _CLC3GLS3_LC3G4D4T      0x80
#define _CLC3GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        CLC4CON Bits

extern __at(0x0F2E) __sfr CLC4CON;

typedef union
  {
  struct
    {
    unsigned LC4MODE0           : 1;
    unsigned LC4MODE1           : 1;
    unsigned LC4MODE2           : 1;
    unsigned LC4INTN            : 1;
    unsigned LC4INTP            : 1;
    unsigned LC4OUT             : 1;
    unsigned                    : 1;
    unsigned LC4EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC4MODE            : 3;
    unsigned                    : 5;
    };
  } __CLC4CONbits_t;

extern __at(0x0F2E) volatile __CLC4CONbits_t CLC4CONbits;

#define _CLC4CON_LC4MODE0       0x01
#define _CLC4CON_MODE0          0x01
#define _CLC4CON_LC4MODE1       0x02
#define _CLC4CON_MODE1          0x02
#define _CLC4CON_LC4MODE2       0x04
#define _CLC4CON_MODE2          0x04
#define _CLC4CON_LC4INTN        0x08
#define _CLC4CON_INTN           0x08
#define _CLC4CON_LC4INTP        0x10
#define _CLC4CON_INTP           0x10
#define _CLC4CON_LC4OUT         0x20
#define _CLC4CON_OUT            0x20
#define _CLC4CON_LC4EN          0x80
#define _CLC4CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC4POL Bits

extern __at(0x0F2F) __sfr CLC4POL;

typedef union
  {
  struct
    {
    unsigned LC4G1POL           : 1;
    unsigned LC4G2POL           : 1;
    unsigned LC4G3POL           : 1;
    unsigned LC4G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC4POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC4POLbits_t;

extern __at(0x0F2F) volatile __CLC4POLbits_t CLC4POLbits;

#define _CLC4POL_LC4G1POL       0x01
#define _CLC4POL_G1POL          0x01
#define _CLC4POL_LC4G2POL       0x02
#define _CLC4POL_G2POL          0x02
#define _CLC4POL_LC4G3POL       0x04
#define _CLC4POL_G3POL          0x04
#define _CLC4POL_LC4G4POL       0x08
#define _CLC4POL_G4POL          0x08
#define _CLC4POL_LC4POL         0x80
#define _CLC4POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC4SEL0 Bits

extern __at(0x0F30) __sfr CLC4SEL0;

typedef union
  {
  struct
    {
    unsigned LC4D1S0            : 1;
    unsigned LC4D1S1            : 1;
    unsigned LC4D1S2            : 1;
    unsigned LC4D1S3            : 1;
    unsigned LC4D1S4            : 1;
    unsigned LC4D1S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC4D1S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D1S                : 6;
    unsigned                    : 2;
    };
  } __CLC4SEL0bits_t;

extern __at(0x0F30) volatile __CLC4SEL0bits_t CLC4SEL0bits;

#define _CLC4SEL0_LC4D1S0       0x01
#define _CLC4SEL0_D1S0          0x01
#define _CLC4SEL0_LC4D1S1       0x02
#define _CLC4SEL0_D1S1          0x02
#define _CLC4SEL0_LC4D1S2       0x04
#define _CLC4SEL0_D1S2          0x04
#define _CLC4SEL0_LC4D1S3       0x08
#define _CLC4SEL0_D1S3          0x08
#define _CLC4SEL0_LC4D1S4       0x10
#define _CLC4SEL0_D1S4          0x10
#define _CLC4SEL0_LC4D1S5       0x20
#define _CLC4SEL0_D1S5          0x20

//==============================================================================


//==============================================================================
//        CLC4SEL1 Bits

extern __at(0x0F31) __sfr CLC4SEL1;

typedef union
  {
  struct
    {
    unsigned LC4D2S0            : 1;
    unsigned LC4D2S1            : 1;
    unsigned LC4D2S2            : 1;
    unsigned LC4D2S3            : 1;
    unsigned LC4D2S4            : 1;
    unsigned LC4D2S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC4D2S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D2S                : 6;
    unsigned                    : 2;
    };
  } __CLC4SEL1bits_t;

extern __at(0x0F31) volatile __CLC4SEL1bits_t CLC4SEL1bits;

#define _CLC4SEL1_LC4D2S0       0x01
#define _CLC4SEL1_D2S0          0x01
#define _CLC4SEL1_LC4D2S1       0x02
#define _CLC4SEL1_D2S1          0x02
#define _CLC4SEL1_LC4D2S2       0x04
#define _CLC4SEL1_D2S2          0x04
#define _CLC4SEL1_LC4D2S3       0x08
#define _CLC4SEL1_D2S3          0x08
#define _CLC4SEL1_LC4D2S4       0x10
#define _CLC4SEL1_D2S4          0x10
#define _CLC4SEL1_LC4D2S5       0x20
#define _CLC4SEL1_D2S5          0x20

//==============================================================================


//==============================================================================
//        CLC4SEL2 Bits

extern __at(0x0F32) __sfr CLC4SEL2;

typedef union
  {
  struct
    {
    unsigned LC4D3S0            : 1;
    unsigned LC4D3S1            : 1;
    unsigned LC4D3S2            : 1;
    unsigned LC4D3S3            : 1;
    unsigned LC4D3S4            : 1;
    unsigned LC4D3S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC4D3S             : 6;
    unsigned                    : 2;
    };
  } __CLC4SEL2bits_t;

extern __at(0x0F32) volatile __CLC4SEL2bits_t CLC4SEL2bits;

#define _CLC4SEL2_LC4D3S0       0x01
#define _CLC4SEL2_D3S0          0x01
#define _CLC4SEL2_LC4D3S1       0x02
#define _CLC4SEL2_D3S1          0x02
#define _CLC4SEL2_LC4D3S2       0x04
#define _CLC4SEL2_D3S2          0x04
#define _CLC4SEL2_LC4D3S3       0x08
#define _CLC4SEL2_D3S3          0x08
#define _CLC4SEL2_LC4D3S4       0x10
#define _CLC4SEL2_D3S4          0x10
#define _CLC4SEL2_LC4D3S5       0x20
#define _CLC4SEL2_D3S5          0x20

//==============================================================================


//==============================================================================
//        CLC4SEL3 Bits

extern __at(0x0F33) __sfr CLC4SEL3;

typedef union
  {
  struct
    {
    unsigned LC4D4S0            : 1;
    unsigned LC4D4S1            : 1;
    unsigned LC4D4S2            : 1;
    unsigned LC4D4S3            : 1;
    unsigned LC4D4S4            : 1;
    unsigned LC4D4S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC4D4S             : 6;
    unsigned                    : 2;
    };
  } __CLC4SEL3bits_t;

extern __at(0x0F33) volatile __CLC4SEL3bits_t CLC4SEL3bits;

#define _CLC4SEL3_LC4D4S0       0x01
#define _CLC4SEL3_D4S0          0x01
#define _CLC4SEL3_LC4D4S1       0x02
#define _CLC4SEL3_D4S1          0x02
#define _CLC4SEL3_LC4D4S2       0x04
#define _CLC4SEL3_D4S2          0x04
#define _CLC4SEL3_LC4D4S3       0x08
#define _CLC4SEL3_D4S3          0x08
#define _CLC4SEL3_LC4D4S4       0x10
#define _CLC4SEL3_D4S4          0x10
#define _CLC4SEL3_LC4D4S5       0x20
#define _CLC4SEL3_D4S5          0x20

//==============================================================================


//==============================================================================
//        CLC4GLS0 Bits

extern __at(0x0F34) __sfr CLC4GLS0;

typedef union
  {
  struct
    {
    unsigned LC4G1D1N           : 1;
    unsigned LC4G1D1T           : 1;
    unsigned LC4G1D2N           : 1;
    unsigned LC4G1D2T           : 1;
    unsigned LC4G1D3N           : 1;
    unsigned LC4G1D3T           : 1;
    unsigned LC4G1D4N           : 1;
    unsigned LC4G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS0bits_t;

extern __at(0x0F34) volatile __CLC4GLS0bits_t CLC4GLS0bits;

#define _CLC4GLS0_LC4G1D1N      0x01
#define _CLC4GLS0_D1N           0x01
#define _CLC4GLS0_LC4G1D1T      0x02
#define _CLC4GLS0_D1T           0x02
#define _CLC4GLS0_LC4G1D2N      0x04
#define _CLC4GLS0_D2N           0x04
#define _CLC4GLS0_LC4G1D2T      0x08
#define _CLC4GLS0_D2T           0x08
#define _CLC4GLS0_LC4G1D3N      0x10
#define _CLC4GLS0_D3N           0x10
#define _CLC4GLS0_LC4G1D3T      0x20
#define _CLC4GLS0_D3T           0x20
#define _CLC4GLS0_LC4G1D4N      0x40
#define _CLC4GLS0_D4N           0x40
#define _CLC4GLS0_LC4G1D4T      0x80
#define _CLC4GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS1 Bits

extern __at(0x0F35) __sfr CLC4GLS1;

typedef union
  {
  struct
    {
    unsigned LC4G2D1N           : 1;
    unsigned LC4G2D1T           : 1;
    unsigned LC4G2D2N           : 1;
    unsigned LC4G2D2T           : 1;
    unsigned LC4G2D3N           : 1;
    unsigned LC4G2D3T           : 1;
    unsigned LC4G2D4N           : 1;
    unsigned LC4G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS1bits_t;

extern __at(0x0F35) volatile __CLC4GLS1bits_t CLC4GLS1bits;

#define _CLC4GLS1_LC4G2D1N      0x01
#define _CLC4GLS1_D1N           0x01
#define _CLC4GLS1_LC4G2D1T      0x02
#define _CLC4GLS1_D1T           0x02
#define _CLC4GLS1_LC4G2D2N      0x04
#define _CLC4GLS1_D2N           0x04
#define _CLC4GLS1_LC4G2D2T      0x08
#define _CLC4GLS1_D2T           0x08
#define _CLC4GLS1_LC4G2D3N      0x10
#define _CLC4GLS1_D3N           0x10
#define _CLC4GLS1_LC4G2D3T      0x20
#define _CLC4GLS1_D3T           0x20
#define _CLC4GLS1_LC4G2D4N      0x40
#define _CLC4GLS1_D4N           0x40
#define _CLC4GLS1_LC4G2D4T      0x80
#define _CLC4GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS2 Bits

extern __at(0x0F36) __sfr CLC4GLS2;

typedef union
  {
  struct
    {
    unsigned LC4G3D1N           : 1;
    unsigned LC4G3D1T           : 1;
    unsigned LC4G3D2N           : 1;
    unsigned LC4G3D2T           : 1;
    unsigned LC4G3D3N           : 1;
    unsigned LC4G3D3T           : 1;
    unsigned LC4G3D4N           : 1;
    unsigned LC4G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS2bits_t;

extern __at(0x0F36) volatile __CLC4GLS2bits_t CLC4GLS2bits;

#define _CLC4GLS2_LC4G3D1N      0x01
#define _CLC4GLS2_D1N           0x01
#define _CLC4GLS2_LC4G3D1T      0x02
#define _CLC4GLS2_D1T           0x02
#define _CLC4GLS2_LC4G3D2N      0x04
#define _CLC4GLS2_D2N           0x04
#define _CLC4GLS2_LC4G3D2T      0x08
#define _CLC4GLS2_D2T           0x08
#define _CLC4GLS2_LC4G3D3N      0x10
#define _CLC4GLS2_D3N           0x10
#define _CLC4GLS2_LC4G3D3T      0x20
#define _CLC4GLS2_D3T           0x20
#define _CLC4GLS2_LC4G3D4N      0x40
#define _CLC4GLS2_D4N           0x40
#define _CLC4GLS2_LC4G3D4T      0x80
#define _CLC4GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS3 Bits

extern __at(0x0F37) __sfr CLC4GLS3;

typedef union
  {
  struct
    {
    unsigned LC4G4D1N           : 1;
    unsigned LC4G4D1T           : 1;
    unsigned LC4G4D2N           : 1;
    unsigned LC4G4D2T           : 1;
    unsigned LC4G4D3N           : 1;
    unsigned LC4G4D3T           : 1;
    unsigned LC4G4D4N           : 1;
    unsigned LC4G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC4GLS3bits_t;

extern __at(0x0F37) volatile __CLC4GLS3bits_t CLC4GLS3bits;

#define _CLC4GLS3_LC4G4D1N      0x01
#define _CLC4GLS3_G4D1N         0x01
#define _CLC4GLS3_LC4G4D1T      0x02
#define _CLC4GLS3_G4D1T         0x02
#define _CLC4GLS3_LC4G4D2N      0x04
#define _CLC4GLS3_G4D2N         0x04
#define _CLC4GLS3_LC4G4D2T      0x08
#define _CLC4GLS3_G4D2T         0x08
#define _CLC4GLS3_LC4G4D3N      0x10
#define _CLC4GLS3_G4D3N         0x10
#define _CLC4GLS3_LC4G4D3T      0x20
#define _CLC4GLS3_G4D3T         0x20
#define _CLC4GLS3_LC4G4D4N      0x40
#define _CLC4GLS3_G4D4N         0x40
#define _CLC4GLS3_LC4G4D4T      0x80
#define _CLC4GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008
#define _CONFIG3                0x8009

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_HS                0x3FFA  // HS Oscillator, High-speed crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_INTOSC            0x3FFC  // INTOSC oscillator: I/O function on CLKIN pin.
#define _FOSC_ECL               0x3FFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECM               0x3FFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECH               0x3FFF  // ECH, External Clock, High Power Mode (4-20 MHz): device clock supplied to CLKIN pins.
#define _PWRTE_ON               0x3FDF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0x3FFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0x3F7F  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0x39FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0x3BFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0x3DFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0x37FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.
#define _IESO_OFF               0x2FFF  // Internal External Switch Over mode is disabled.
#define _IESO_ON                0x3FFF  // Internal External Switch Over mode is enabled.
#define _FCMEN_OFF              0x1FFF  // Fail-Safe Clock Monitor is disabled.
#define _FCMEN_ON               0x3FFF  // Fail-Safe Clock Monitor is enabled.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0x3FFC  // 000h to 1FFFh write protected, no addresses may be modified by PMCON control.
#define _WRT_HALF               0x3FFD  // 000h to FFFh write protected, 1000h to 1FFFh may be modified by PMCON control.
#define _WRT_BOOT               0x3FFE  // 000h to 1FFh write protected, 200h to 1FFFh may be modified by PMCON control.
#define _WRT_OFF                0x3FFF  // Write protection off.
#define _PPS1WAY_OFF            0x3FFB  // The PPSLOCK bit can be set and cleared repeatedly by software.
#define _PPS1WAY_ON             0x3FFF  // The PPSLOCK bit cannot be cleared once it is set by software.
#define _ZCD_ON                 0x3F7F  // ZCD always enabled.
#define _ZCD_OFF                0x3FFF  // ZCD disable.  ZCD can be enabled by setting the ZCDSEN bit of ZCDCON.
#define _PLLEN_OFF              0x3EFF  // 4x PLL is enabled when software sets the SPLLEN bit.
#define _PLLEN_ON               0x3FFF  // 4x PLL is always enabled.
#define _STVREN_OFF             0x3DFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0x3FFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0x3BFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0x3FFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LPBOR_ON               0x37FF  // Low-Power BOR is enabled.
#define _LPBOR_OFF              0x3FFF  // Low-Power BOR is disabled.
#define _DEBUG_ON               0x2FFF  // In-Circuit Debugger enabled, ICSPCLK and ICSPDAT are dedicated to the debugger.
#define _DEBUG_OFF              0x3FFF  // In-Circuit Debugger disabled, ICSPCLK and ICSPDAT are general purpose I/O pins.
#define _LVP_OFF                0x1FFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0x3FFF  // Low-voltage programming enabled.

//----------------------------- CONFIG3 Options -------------------------------

#define _WDTCPS_WDTCPS0         0x3FE0  // 1:32 (1 ms period).
#define _WDTCPS_WDTCPS1         0x3FE1  // 1:64 (2 ms period).
#define _WDTCPS_WDTCPS2         0x3FE2  // 1:128 (4 ms period).
#define _WDTCPS_WDTCPS3         0x3FE3  // 1:256 (8 ms period).
#define _WDTCPS_WDTCPS4         0x3FE4  // 1:512 (16 ms period).
#define _WDTCPS_WDTCPS5         0x3FE5  // 1:1024 (32 ms period).
#define _WDTCPS_WDTCPS6         0x3FE6  // 1:2048 (64 ms period).
#define _WDTCPS_WDTCPS7         0x3FE7  // 1:4096 (128 ms period).
#define _WDTCPS_WDTCPS8         0x3FE8  // 1:8192 (256 ms period).
#define _WDTCPS_WDTCPS9         0x3FE9  // 1:16384 (512 ms period).
#define _WDTCPS_WDTCPSA         0x3FEA  // 1:32768 (1 s period).
#define _WDTCPS_WDTCPSB         0x3FEB  // 1:65536 (2 s period).
#define _WDTCPS_WDTCPSC         0x3FEC  // 1:131072 (4 s period).
#define _WDTCPS_WDTCPSD         0x3FED  // 1:262144 (8 s period).
#define _WDTCPS_WDTCPSE         0x3FEE  // 1:524299 (16 s period).
#define _WDTCPS_WDTCPSF         0x3FEF  // 1:1048576 (32 s period).
#define _WDTCPS_WDTCPS10        0x3FF0  // 1:2097152 (64 s period).
#define _WDTCPS_WDTCPS11        0x3FF1  // 1:4194304 (128 s period).
#define _WDTCPS_WDTCPS12        0x3FF2  // 1:8388608 (256 s period).
#define _WDTCPS_WDTCPS1F        0x3FFF  // Software Control (WDTPS).
#define _WDTE_OFF               0x3F9F  // WDT disabled.
#define _WDTE_SWDTEN            0x3FBF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0x3FDF  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _WDTCWS_WDTCWS125       0x38FF  // 12.5 percent window open time.
#define _WDTCWS_WDTCWS25        0x39FF  // 25 percent window open time.
#define _WDTCWS_WDTCWS375       0x3AFF  // 37.5 percent window open time.
#define _WDTCWS_WDTCWS50        0x3BFF  // 50 percent window open time.
#define _WDTCWS_WDTCWS625       0x3CFF  // 62.5 percent window open time.
#define _WDTCWS_WDTCWS75        0x3DFF  // 75 percent window open time.
#define _WDTCWS_WDTCWS100       0x3EFF  // 100 percent window open time (Legacy WDT).
#define _WDTCWS_WDTCWSSW        0x3FFF  // Software WDT window size control (WDTWS bits).
#define _WDTCCS_LFINTOSC        0x07FF  // 31.0kHz LFINTOSC.
#define _WDTCCS_MFINTOSC        0x0FFF  // 31.25 kHz HFINTOSC (MFINTOSC).
#define _WDTCCS_SWC             0x3FFF  // Software control, controlled by WDTCS bits.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define ADGO                    ADCON0bits.ADGO                 // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define CHS4                    ADCON0bits.CHS4                 // bit 6

#define ADPREF0                 ADCON1bits.ADPREF0              // bit 0
#define ADPREF1                 ADCON1bits.ADPREF1              // bit 1
#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define TRIGSEL0                ADCON2bits.TRIGSEL0             // bit 4
#define TRIGSEL1                ADCON2bits.TRIGSEL1             // bit 5
#define TRIGSEL2                ADCON2bits.TRIGSEL2             // bit 6
#define TRIGSEL3                ADCON2bits.TRIGSEL3             // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA4                   ANSELAbits.ANSA4                // bit 4

#define ANSB4                   ANSELBbits.ANSB4                // bit 4
#define ANSB5                   ANSELBbits.ANSB5                // bit 5
#define ANSB6                   ANSELBbits.ANSB6                // bit 6
#define ANSB7                   ANSELBbits.ANSB7                // bit 7

#define ANSC0                   ANSELCbits.ANSC0                // bit 0
#define ANSC1                   ANSELCbits.ANSC1                // bit 1
#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC3                   ANSELCbits.ANSC3                // bit 3
#define ANSC6                   ANSELCbits.ANSC6                // bit 6
#define ANSC7                   ANSELCbits.ANSC7                // bit 7

#define AT1CC18                 AT1CC1Hbits.AT1CC18             // bit 0, shadows bit in AT1CC1Hbits
#define CC18                    AT1CC1Hbits.CC18                // bit 0, shadows bit in AT1CC1Hbits
#define AT1CC19                 AT1CC1Hbits.AT1CC19             // bit 1, shadows bit in AT1CC1Hbits
#define CC19                    AT1CC1Hbits.CC19                // bit 1, shadows bit in AT1CC1Hbits

#define AT1CC10                 AT1CC1Lbits.AT1CC10             // bit 0, shadows bit in AT1CC1Lbits
#define CC10                    AT1CC1Lbits.CC10                // bit 0, shadows bit in AT1CC1Lbits
#define AT1CC11                 AT1CC1Lbits.AT1CC11             // bit 1, shadows bit in AT1CC1Lbits
#define CC11                    AT1CC1Lbits.CC11                // bit 1, shadows bit in AT1CC1Lbits
#define AT1CC12                 AT1CC1Lbits.AT1CC12             // bit 2, shadows bit in AT1CC1Lbits
#define CC12                    AT1CC1Lbits.CC12                // bit 2, shadows bit in AT1CC1Lbits
#define AT1CC13                 AT1CC1Lbits.AT1CC13             // bit 3, shadows bit in AT1CC1Lbits
#define CC13                    AT1CC1Lbits.CC13                // bit 3, shadows bit in AT1CC1Lbits
#define AT1CC14                 AT1CC1Lbits.AT1CC14             // bit 4, shadows bit in AT1CC1Lbits
#define CC14                    AT1CC1Lbits.CC14                // bit 4, shadows bit in AT1CC1Lbits
#define AT1CC15                 AT1CC1Lbits.AT1CC15             // bit 5, shadows bit in AT1CC1Lbits
#define CC15                    AT1CC1Lbits.CC15                // bit 5, shadows bit in AT1CC1Lbits
#define AT1CC16                 AT1CC1Lbits.AT1CC16             // bit 6, shadows bit in AT1CC1Lbits
#define CC16                    AT1CC1Lbits.CC16                // bit 6, shadows bit in AT1CC1Lbits
#define AT1CC17                 AT1CC1Lbits.AT1CC17             // bit 7, shadows bit in AT1CC1Lbits
#define CC17                    AT1CC1Lbits.CC17                // bit 7, shadows bit in AT1CC1Lbits

#define AT1CC28                 AT1CC2Hbits.AT1CC28             // bit 0, shadows bit in AT1CC2Hbits
#define CC28                    AT1CC2Hbits.CC28                // bit 0, shadows bit in AT1CC2Hbits
#define AT1CC29                 AT1CC2Hbits.AT1CC29             // bit 1, shadows bit in AT1CC2Hbits
#define CC29                    AT1CC2Hbits.CC29                // bit 1, shadows bit in AT1CC2Hbits

#define AT1CC38                 AT1CC3Hbits.AT1CC38             // bit 0, shadows bit in AT1CC3Hbits
#define CC38                    AT1CC3Hbits.CC38                // bit 0, shadows bit in AT1CC3Hbits
#define AT1CC39                 AT1CC3Hbits.AT1CC39             // bit 1, shadows bit in AT1CC3Hbits
#define CC39                    AT1CC3Hbits.CC39                // bit 1, shadows bit in AT1CC3Hbits

#define AT1CC30                 AT1CC3Lbits.AT1CC30             // bit 0, shadows bit in AT1CC3Lbits
#define CC30                    AT1CC3Lbits.CC30                // bit 0, shadows bit in AT1CC3Lbits
#define AT1CC31                 AT1CC3Lbits.AT1CC31             // bit 1, shadows bit in AT1CC3Lbits
#define CC31                    AT1CC3Lbits.CC31                // bit 1, shadows bit in AT1CC3Lbits
#define AT1CC32                 AT1CC3Lbits.AT1CC32             // bit 2, shadows bit in AT1CC3Lbits
#define CC32                    AT1CC3Lbits.CC32                // bit 2, shadows bit in AT1CC3Lbits
#define AT1CC33                 AT1CC3Lbits.AT1CC33             // bit 3, shadows bit in AT1CC3Lbits
#define CC33                    AT1CC3Lbits.CC33                // bit 3, shadows bit in AT1CC3Lbits
#define AT1CC34                 AT1CC3Lbits.AT1CC34             // bit 4, shadows bit in AT1CC3Lbits
#define CC34                    AT1CC3Lbits.CC34                // bit 4, shadows bit in AT1CC3Lbits
#define AT1CC35                 AT1CC3Lbits.AT1CC35             // bit 5, shadows bit in AT1CC3Lbits
#define CC35                    AT1CC3Lbits.CC35                // bit 5, shadows bit in AT1CC3Lbits
#define AT1CC36                 AT1CC3Lbits.AT1CC36             // bit 6, shadows bit in AT1CC3Lbits
#define CC36                    AT1CC3Lbits.CC36                // bit 6, shadows bit in AT1CC3Lbits
#define AT1CC37                 AT1CC3Lbits.AT1CC37             // bit 7, shadows bit in AT1CC3Lbits
#define CC37                    AT1CC3Lbits.CC37                // bit 7, shadows bit in AT1CC3Lbits

#define AT1CC1MODE              AT1CCON1bits.AT1CC1MODE         // bit 0, shadows bit in AT1CCON1bits
#define CC1MODE                 AT1CCON1bits.CC1MODE            // bit 0, shadows bit in AT1CCON1bits
#define AT1CAP1P                AT1CCON1bits.AT1CAP1P           // bit 3, shadows bit in AT1CCON1bits
#define CAP1P                   AT1CCON1bits.CAP1P              // bit 3, shadows bit in AT1CCON1bits
#define AT1CC1POL               AT1CCON1bits.AT1CC1POL          // bit 4, shadows bit in AT1CCON1bits
#define CC1POL                  AT1CCON1bits.CC1POL             // bit 4, shadows bit in AT1CCON1bits
#define AT1CC1EN                AT1CCON1bits.AT1CC1EN           // bit 7, shadows bit in AT1CCON1bits
#define CC1EN                   AT1CCON1bits.CC1EN              // bit 7, shadows bit in AT1CCON1bits

#define AT1CC2MODE              AT1CCON2bits.AT1CC2MODE         // bit 0, shadows bit in AT1CCON2bits
#define CC2MODE                 AT1CCON2bits.CC2MODE            // bit 0, shadows bit in AT1CCON2bits
#define AT1CAP2P                AT1CCON2bits.AT1CAP2P           // bit 3, shadows bit in AT1CCON2bits
#define CAP2P                   AT1CCON2bits.CAP2P              // bit 3, shadows bit in AT1CCON2bits
#define AT1CC2POL               AT1CCON2bits.AT1CC2POL          // bit 4, shadows bit in AT1CCON2bits
#define CC2POL                  AT1CCON2bits.CC2POL             // bit 4, shadows bit in AT1CCON2bits
#define AT1CC2EN                AT1CCON2bits.AT1CC2EN           // bit 7, shadows bit in AT1CCON2bits
#define CC2EN                   AT1CCON2bits.CC2EN              // bit 7, shadows bit in AT1CCON2bits

#define AT1CC3MODE              AT1CCON3bits.AT1CC3MODE         // bit 0, shadows bit in AT1CCON3bits
#define CC3MODE                 AT1CCON3bits.CC3MODE            // bit 0, shadows bit in AT1CCON3bits
#define AT1CAP3P                AT1CCON3bits.AT1CAP3P           // bit 3, shadows bit in AT1CCON3bits
#define CAP3P                   AT1CCON3bits.CAP3P              // bit 3, shadows bit in AT1CCON3bits
#define AT1CC3POL               AT1CCON3bits.AT1CC3POL          // bit 4, shadows bit in AT1CCON3bits
#define CC3POL                  AT1CCON3bits.CC3POL             // bit 4, shadows bit in AT1CCON3bits
#define AT1CC3EN                AT1CCON3bits.AT1CC3EN           // bit 7, shadows bit in AT1CCON3bits
#define CC3EN                   AT1CCON3bits.CC3EN              // bit 7, shadows bit in AT1CCON3bits

#define CS                      AT1CLKbits.CS                   // bit 0, shadows bit in AT1CLKbits
#define AT1CS                   AT1CLKbits.AT1CS                // bit 0, shadows bit in AT1CLKbits
#define CS0                     AT1CLKbits.CS0                  // bit 0, shadows bit in AT1CLKbits
#define AT1CS0                  AT1CLKbits.AT1CS0               // bit 0, shadows bit in AT1CLKbits

#define MODE                    AT1CON0bits.MODE                // bit 0, shadows bit in AT1CON0bits
#define AT1MODE                 AT1CON0bits.AT1MODE             // bit 0, shadows bit in AT1CON0bits
#define APMOD                   AT1CON0bits.APMOD               // bit 1, shadows bit in AT1CON0bits
#define AT1APMOD                AT1CON0bits.AT1APMOD            // bit 1, shadows bit in AT1CON0bits
#define POL                     AT1CON0bits.POL                 // bit 3, shadows bit in AT1CON0bits
#define AT1POL                  AT1CON0bits.AT1POL              // bit 3, shadows bit in AT1CON0bits
#define PS0                     AT1CON0bits.PS0                 // bit 4, shadows bit in AT1CON0bits
#define AT1PS0                  AT1CON0bits.AT1PS0              // bit 4, shadows bit in AT1CON0bits
#define PS1                     AT1CON0bits.PS1                 // bit 5, shadows bit in AT1CON0bits
#define AT1PS1                  AT1CON0bits.AT1PS1              // bit 5, shadows bit in AT1CON0bits
#define PREC                    AT1CON0bits.PREC                // bit 6, shadows bit in AT1CON0bits
#define AT1PREC                 AT1CON0bits.AT1PREC             // bit 6, shadows bit in AT1CON0bits
#define EN                      AT1CON0bits.EN                  // bit 7, shadows bit in AT1CON0bits
#define AT1EN                   AT1CON0bits.AT1EN               // bit 7, shadows bit in AT1CON0bits

#define VALID                   AT1CON1bits.VALID               // bit 0, shadows bit in AT1CON1bits
#define AT1VALID                AT1CON1bits.AT1VALID            // bit 0, shadows bit in AT1CON1bits
#define ACCS                    AT1CON1bits.ACCS                // bit 1, shadows bit in AT1CON1bits
#define AT1ACCS                 AT1CON1bits.AT1ACCS             // bit 1, shadows bit in AT1CON1bits
#define MPP                     AT1CON1bits.MPP                 // bit 2, shadows bit in AT1CON1bits
#define AT1MPP                  AT1CON1bits.AT1MPP              // bit 2, shadows bit in AT1CON1bits
#define PRP                     AT1CON1bits.PRP                 // bit 4, shadows bit in AT1CON1bits
#define AT1PRP                  AT1CON1bits.AT1PRP              // bit 4, shadows bit in AT1CON1bits
#define PHP                     AT1CON1bits.PHP                 // bit 6, shadows bit in AT1CON1bits
#define AT1PHP                  AT1CON1bits.AT1PHP              // bit 6, shadows bit in AT1CON1bits

#define AT1CP1S0                AT1CSEL1bits.AT1CP1S0           // bit 0, shadows bit in AT1CSEL1bits
#define CP1S0                   AT1CSEL1bits.CP1S0              // bit 0, shadows bit in AT1CSEL1bits
#define AT1CP1S1                AT1CSEL1bits.AT1CP1S1           // bit 1, shadows bit in AT1CSEL1bits
#define CP1S1                   AT1CSEL1bits.CP1S1              // bit 1, shadows bit in AT1CSEL1bits
#define AT1CP1S2                AT1CSEL1bits.AT1CP1S2           // bit 2, shadows bit in AT1CSEL1bits
#define CP1S2                   AT1CSEL1bits.CP1S2              // bit 2, shadows bit in AT1CSEL1bits

#define AT1CP2S0                AT1CSEL2bits.AT1CP2S0           // bit 0, shadows bit in AT1CSEL2bits
#define CP2S0                   AT1CSEL2bits.CP2S0              // bit 0, shadows bit in AT1CSEL2bits
#define AT1CP2S1                AT1CSEL2bits.AT1CP2S1           // bit 1, shadows bit in AT1CSEL2bits
#define CP2S1                   AT1CSEL2bits.CP2S1              // bit 1, shadows bit in AT1CSEL2bits
#define AT1CP2S2                AT1CSEL2bits.AT1CP2S2           // bit 2, shadows bit in AT1CSEL2bits
#define CP2S2                   AT1CSEL2bits.CP2S2              // bit 2, shadows bit in AT1CSEL2bits

#define AT1CP3S0                AT1CSEL3bits.AT1CP3S0           // bit 0, shadows bit in AT1CSEL3bits
#define CP3S0                   AT1CSEL3bits.CP3S0              // bit 0, shadows bit in AT1CSEL3bits
#define AT1CP3S1                AT1CSEL3bits.AT1CP3S1           // bit 1, shadows bit in AT1CSEL3bits
#define CP3S1                   AT1CSEL3bits.CP3S1              // bit 1, shadows bit in AT1CSEL3bits
#define AT1CP3S2                AT1CSEL3bits.AT1CP3S2           // bit 2, shadows bit in AT1CSEL3bits
#define CP3S2                   AT1CSEL3bits.CP3S2              // bit 2, shadows bit in AT1CSEL3bits

#define AT1ERR8                 AT1ERRHbits.AT1ERR8             // bit 0, shadows bit in AT1ERRHbits
#define ERR8                    AT1ERRHbits.ERR8                // bit 0, shadows bit in AT1ERRHbits
#define ERRH0                   AT1ERRHbits.ERRH0               // bit 0, shadows bit in AT1ERRHbits
#define AT1ERR9                 AT1ERRHbits.AT1ERR9             // bit 1, shadows bit in AT1ERRHbits
#define ERR9                    AT1ERRHbits.ERR9                // bit 1, shadows bit in AT1ERRHbits
#define ERRH1                   AT1ERRHbits.ERRH1               // bit 1, shadows bit in AT1ERRHbits
#define AT1ERR10                AT1ERRHbits.AT1ERR10            // bit 2, shadows bit in AT1ERRHbits
#define ERR10                   AT1ERRHbits.ERR10               // bit 2, shadows bit in AT1ERRHbits
#define ERRH2                   AT1ERRHbits.ERRH2               // bit 2, shadows bit in AT1ERRHbits
#define AT1ERR11                AT1ERRHbits.AT1ERR11            // bit 3, shadows bit in AT1ERRHbits
#define ERR11                   AT1ERRHbits.ERR11               // bit 3, shadows bit in AT1ERRHbits
#define ERRH3                   AT1ERRHbits.ERRH3               // bit 3, shadows bit in AT1ERRHbits
#define AT1ERR12                AT1ERRHbits.AT1ERR12            // bit 4, shadows bit in AT1ERRHbits
#define ERR12                   AT1ERRHbits.ERR12               // bit 4, shadows bit in AT1ERRHbits
#define ERRH4                   AT1ERRHbits.ERRH4               // bit 4, shadows bit in AT1ERRHbits
#define AT1ERR13                AT1ERRHbits.AT1ERR13            // bit 5, shadows bit in AT1ERRHbits
#define ERR13                   AT1ERRHbits.ERR13               // bit 5, shadows bit in AT1ERRHbits
#define ERRH5                   AT1ERRHbits.ERRH5               // bit 5, shadows bit in AT1ERRHbits
#define AT1ERR14                AT1ERRHbits.AT1ERR14            // bit 6, shadows bit in AT1ERRHbits
#define ERR14                   AT1ERRHbits.ERR14               // bit 6, shadows bit in AT1ERRHbits
#define ERRH6                   AT1ERRHbits.ERRH6               // bit 6, shadows bit in AT1ERRHbits
#define AT1ERR15                AT1ERRHbits.AT1ERR15            // bit 7, shadows bit in AT1ERRHbits
#define ERR15                   AT1ERRHbits.ERR15               // bit 7, shadows bit in AT1ERRHbits
#define ERRH7                   AT1ERRHbits.ERRH7               // bit 7, shadows bit in AT1ERRHbits

#define AT1ERR0                 AT1ERRLbits.AT1ERR0             // bit 0, shadows bit in AT1ERRLbits
#define ERR0                    AT1ERRLbits.ERR0                // bit 0, shadows bit in AT1ERRLbits
#define ERRL0                   AT1ERRLbits.ERRL0               // bit 0, shadows bit in AT1ERRLbits
#define AT1ERR1                 AT1ERRLbits.AT1ERR1             // bit 1, shadows bit in AT1ERRLbits
#define ERR1                    AT1ERRLbits.ERR1                // bit 1, shadows bit in AT1ERRLbits
#define ERRL1                   AT1ERRLbits.ERRL1               // bit 1, shadows bit in AT1ERRLbits
#define AT1ERR2                 AT1ERRLbits.AT1ERR2             // bit 2, shadows bit in AT1ERRLbits
#define ERR2                    AT1ERRLbits.ERR2                // bit 2, shadows bit in AT1ERRLbits
#define ERRL2                   AT1ERRLbits.ERRL2               // bit 2, shadows bit in AT1ERRLbits
#define AT1ERR3                 AT1ERRLbits.AT1ERR3             // bit 3, shadows bit in AT1ERRLbits
#define ERR3                    AT1ERRLbits.ERR3                // bit 3, shadows bit in AT1ERRLbits
#define ERRL3                   AT1ERRLbits.ERRL3               // bit 3, shadows bit in AT1ERRLbits
#define AT1ERR4                 AT1ERRLbits.AT1ERR4             // bit 4, shadows bit in AT1ERRLbits
#define ERR4                    AT1ERRLbits.ERR4                // bit 4, shadows bit in AT1ERRLbits
#define ERRL4                   AT1ERRLbits.ERRL4               // bit 4, shadows bit in AT1ERRLbits
#define AT1ERR5                 AT1ERRLbits.AT1ERR5             // bit 5, shadows bit in AT1ERRLbits
#define ERR5                    AT1ERRLbits.ERR5                // bit 5, shadows bit in AT1ERRLbits
#define ERRL5                   AT1ERRLbits.ERRL5               // bit 5, shadows bit in AT1ERRLbits
#define AT1ERR6                 AT1ERRLbits.AT1ERR6             // bit 6, shadows bit in AT1ERRLbits
#define ERR6                    AT1ERRLbits.ERR6                // bit 6, shadows bit in AT1ERRLbits
#define ERRL6                   AT1ERRLbits.ERRL6               // bit 6, shadows bit in AT1ERRLbits
#define AT1ERR7                 AT1ERRLbits.AT1ERR7             // bit 7, shadows bit in AT1ERRLbits
#define ERR7                    AT1ERRLbits.ERR7                // bit 7, shadows bit in AT1ERRLbits
#define ERRL7                   AT1ERRLbits.ERRL7               // bit 7, shadows bit in AT1ERRLbits

#define AT1PERIE                AT1IE0bits.AT1PERIE             // bit 0
#define AT1MISSIE               AT1IE0bits.AT1MISSIE            // bit 1
#define AT1PHSIE                AT1IE0bits.AT1PHSIE             // bit 2

#define AT1CC1IE                AT1IE1bits.AT1CC1IE             // bit 0
#define AT1CC2IE                AT1IE1bits.AT1CC2IE             // bit 1
#define AT1CC3IE                AT1IE1bits.AT1CC3IE             // bit 2

#define AT1PERIF                AT1IR0bits.AT1PERIF             // bit 0
#define AT1MISSIF               AT1IR0bits.AT1MISSIF            // bit 1
#define AT1PHSIF                AT1IR0bits.AT1PHSIF             // bit 2

#define AT1CC1IF                AT1IR1bits.AT1CC1IF             // bit 0
#define AT1CC2IF                AT1IR1bits.AT1CC2IF             // bit 1
#define AT1CC3IF                AT1IR1bits.AT1CC3IF             // bit 2

#define AT1MISS8                AT1MISSHbits.AT1MISS8           // bit 0, shadows bit in AT1MISSHbits
#define MISS8                   AT1MISSHbits.MISS8              // bit 0, shadows bit in AT1MISSHbits
#define AT1MISS9                AT1MISSHbits.AT1MISS9           // bit 1, shadows bit in AT1MISSHbits
#define MISS9                   AT1MISSHbits.MISS9              // bit 1, shadows bit in AT1MISSHbits
#define AT1MISS10               AT1MISSHbits.AT1MISS10          // bit 2, shadows bit in AT1MISSHbits
#define MISS10                  AT1MISSHbits.MISS10             // bit 2, shadows bit in AT1MISSHbits
#define AT1MISS11               AT1MISSHbits.AT1MISS11          // bit 3, shadows bit in AT1MISSHbits
#define MISS11                  AT1MISSHbits.MISS11             // bit 3, shadows bit in AT1MISSHbits
#define AT1MISS12               AT1MISSHbits.AT1MISS12          // bit 4, shadows bit in AT1MISSHbits
#define MISS12                  AT1MISSHbits.MISS12             // bit 4, shadows bit in AT1MISSHbits
#define AT1MISS13               AT1MISSHbits.AT1MISS13          // bit 5, shadows bit in AT1MISSHbits
#define MISS13                  AT1MISSHbits.MISS13             // bit 5, shadows bit in AT1MISSHbits
#define AT1MISS14               AT1MISSHbits.AT1MISS14          // bit 6, shadows bit in AT1MISSHbits
#define MISS14                  AT1MISSHbits.MISS14             // bit 6, shadows bit in AT1MISSHbits
#define AT1MISS15               AT1MISSHbits.AT1MISS15          // bit 7, shadows bit in AT1MISSHbits
#define MISS15                  AT1MISSHbits.MISS15             // bit 7, shadows bit in AT1MISSHbits

#define AT1MISS0                AT1MISSLbits.AT1MISS0           // bit 0, shadows bit in AT1MISSLbits
#define MISS0                   AT1MISSLbits.MISS0              // bit 0, shadows bit in AT1MISSLbits
#define AT1MISS1                AT1MISSLbits.AT1MISS1           // bit 1, shadows bit in AT1MISSLbits
#define MISS1                   AT1MISSLbits.MISS1              // bit 1, shadows bit in AT1MISSLbits
#define AT1MISS2                AT1MISSLbits.AT1MISS2           // bit 2, shadows bit in AT1MISSLbits
#define MISS2                   AT1MISSLbits.MISS2              // bit 2, shadows bit in AT1MISSLbits
#define AT1MISS3                AT1MISSLbits.AT1MISS3           // bit 3, shadows bit in AT1MISSLbits
#define MISS3                   AT1MISSLbits.MISS3              // bit 3, shadows bit in AT1MISSLbits
#define AT1MISS4                AT1MISSLbits.AT1MISS4           // bit 4, shadows bit in AT1MISSLbits
#define MISS4                   AT1MISSLbits.MISS4              // bit 4, shadows bit in AT1MISSLbits
#define AT1MISS5                AT1MISSLbits.AT1MISS5           // bit 5, shadows bit in AT1MISSLbits
#define MISS5                   AT1MISSLbits.MISS5              // bit 5, shadows bit in AT1MISSLbits
#define AT1MISS6                AT1MISSLbits.AT1MISS6           // bit 6, shadows bit in AT1MISSLbits
#define MISS6                   AT1MISSLbits.MISS6              // bit 6, shadows bit in AT1MISSLbits
#define AT1MISS7                AT1MISSLbits.AT1MISS7           // bit 7, shadows bit in AT1MISSLbits
#define MISS7                   AT1MISSLbits.MISS7              // bit 7, shadows bit in AT1MISSLbits

#define AT1PER8                 AT1PERHbits.AT1PER8             // bit 0, shadows bit in AT1PERHbits
#define PER8                    AT1PERHbits.PER8                // bit 0, shadows bit in AT1PERHbits
#define PERH0                   AT1PERHbits.PERH0               // bit 0, shadows bit in AT1PERHbits
#define AT1PER9                 AT1PERHbits.AT1PER9             // bit 1, shadows bit in AT1PERHbits
#define PER9                    AT1PERHbits.PER9                // bit 1, shadows bit in AT1PERHbits
#define PERH1                   AT1PERHbits.PERH1               // bit 1, shadows bit in AT1PERHbits
#define AT1PER10                AT1PERHbits.AT1PER10            // bit 2, shadows bit in AT1PERHbits
#define PER10                   AT1PERHbits.PER10               // bit 2, shadows bit in AT1PERHbits
#define PERH2                   AT1PERHbits.PERH2               // bit 2, shadows bit in AT1PERHbits
#define AT1PER11                AT1PERHbits.AT1PER11            // bit 3, shadows bit in AT1PERHbits
#define PER11                   AT1PERHbits.PER11               // bit 3, shadows bit in AT1PERHbits
#define PERH3                   AT1PERHbits.PERH3               // bit 3, shadows bit in AT1PERHbits
#define AT1PER12                AT1PERHbits.AT1PER12            // bit 4, shadows bit in AT1PERHbits
#define PER12                   AT1PERHbits.PER12               // bit 4, shadows bit in AT1PERHbits
#define PERH4                   AT1PERHbits.PERH4               // bit 4, shadows bit in AT1PERHbits
#define AT1PER13                AT1PERHbits.AT1PER13            // bit 5, shadows bit in AT1PERHbits
#define PER13                   AT1PERHbits.PER13               // bit 5, shadows bit in AT1PERHbits
#define PERH5                   AT1PERHbits.PERH5               // bit 5, shadows bit in AT1PERHbits
#define AT1PER14                AT1PERHbits.AT1PER14            // bit 6, shadows bit in AT1PERHbits
#define PER14                   AT1PERHbits.PER14               // bit 6, shadows bit in AT1PERHbits
#define PERH6                   AT1PERHbits.PERH6               // bit 6, shadows bit in AT1PERHbits
#define AT1POV                  AT1PERHbits.AT1POV              // bit 7, shadows bit in AT1PERHbits
#define PER15                   AT1PERHbits.PER15               // bit 7, shadows bit in AT1PERHbits
#define PERH7                   AT1PERHbits.PERH7               // bit 7, shadows bit in AT1PERHbits

#define AT1PER0                 AT1PERLbits.AT1PER0             // bit 0, shadows bit in AT1PERLbits
#define PER0                    AT1PERLbits.PER0                // bit 0, shadows bit in AT1PERLbits
#define PERL0                   AT1PERLbits.PERL0               // bit 0, shadows bit in AT1PERLbits
#define AT1PER1                 AT1PERLbits.AT1PER1             // bit 1, shadows bit in AT1PERLbits
#define PER1                    AT1PERLbits.PER1                // bit 1, shadows bit in AT1PERLbits
#define PERL1                   AT1PERLbits.PERL1               // bit 1, shadows bit in AT1PERLbits
#define AT1PER2                 AT1PERLbits.AT1PER2             // bit 2, shadows bit in AT1PERLbits
#define PER2                    AT1PERLbits.PER2                // bit 2, shadows bit in AT1PERLbits
#define PERL2                   AT1PERLbits.PERL2               // bit 2, shadows bit in AT1PERLbits
#define AT1PER3                 AT1PERLbits.AT1PER3             // bit 3, shadows bit in AT1PERLbits
#define PER3                    AT1PERLbits.PER3                // bit 3, shadows bit in AT1PERLbits
#define PERL3                   AT1PERLbits.PERL3               // bit 3, shadows bit in AT1PERLbits
#define AT1PER4                 AT1PERLbits.AT1PER4             // bit 4, shadows bit in AT1PERLbits
#define PER4                    AT1PERLbits.PER4                // bit 4, shadows bit in AT1PERLbits
#define PERL4                   AT1PERLbits.PERL4               // bit 4, shadows bit in AT1PERLbits
#define AT1PER5                 AT1PERLbits.AT1PER5             // bit 5, shadows bit in AT1PERLbits
#define PER5                    AT1PERLbits.PER5                // bit 5, shadows bit in AT1PERLbits
#define PERL5                   AT1PERLbits.PERL5               // bit 5, shadows bit in AT1PERLbits
#define AT1PER6                 AT1PERLbits.AT1PER6             // bit 6, shadows bit in AT1PERLbits
#define PER6                    AT1PERLbits.PER6                // bit 6, shadows bit in AT1PERLbits
#define PERL6                   AT1PERLbits.PERL6               // bit 6, shadows bit in AT1PERLbits
#define AT1PER7                 AT1PERLbits.AT1PER7             // bit 7, shadows bit in AT1PERLbits
#define PER7                    AT1PERLbits.PER7                // bit 7, shadows bit in AT1PERLbits
#define PERL7                   AT1PERLbits.PERL7               // bit 7, shadows bit in AT1PERLbits

#define AT1PHS8                 AT1PHSHbits.AT1PHS8             // bit 0, shadows bit in AT1PHSHbits
#define PHS8                    AT1PHSHbits.PHS8                // bit 0, shadows bit in AT1PHSHbits
#define PHSL8                   AT1PHSHbits.PHSL8               // bit 0, shadows bit in AT1PHSHbits
#define AT1PHS9                 AT1PHSHbits.AT1PHS9             // bit 1, shadows bit in AT1PHSHbits
#define PHS9                    AT1PHSHbits.PHS9                // bit 1, shadows bit in AT1PHSHbits
#define PHSL9                   AT1PHSHbits.PHSL9               // bit 1, shadows bit in AT1PHSHbits

#define AT1PHS0                 AT1PHSLbits.AT1PHS0             // bit 0, shadows bit in AT1PHSLbits
#define PHS0                    AT1PHSLbits.PHS0                // bit 0, shadows bit in AT1PHSLbits
#define AT1PHS1                 AT1PHSLbits.AT1PHS1             // bit 1, shadows bit in AT1PHSLbits
#define PHS1                    AT1PHSLbits.PHS1                // bit 1, shadows bit in AT1PHSLbits
#define AT1PHS2                 AT1PHSLbits.AT1PHS2             // bit 2, shadows bit in AT1PHSLbits
#define PHS2                    AT1PHSLbits.PHS2                // bit 2, shadows bit in AT1PHSLbits
#define AT1PHS3                 AT1PHSLbits.AT1PHS3             // bit 3, shadows bit in AT1PHSLbits
#define PHS3                    AT1PHSLbits.PHS3                // bit 3, shadows bit in AT1PHSLbits
#define AT1PHS4                 AT1PHSLbits.AT1PHS4             // bit 4, shadows bit in AT1PHSLbits
#define PHS4                    AT1PHSLbits.PHS4                // bit 4, shadows bit in AT1PHSLbits
#define AT1PHS5                 AT1PHSLbits.AT1PHS5             // bit 5, shadows bit in AT1PHSLbits
#define PHS5                    AT1PHSLbits.PHS5                // bit 5, shadows bit in AT1PHSLbits
#define AT1PHS6                 AT1PHSLbits.AT1PHS6             // bit 6, shadows bit in AT1PHSLbits
#define PHS6                    AT1PHSLbits.PHS6                // bit 6, shadows bit in AT1PHSLbits
#define AT1PHS7                 AT1PHSLbits.AT1PHS7             // bit 7, shadows bit in AT1PHSLbits
#define PHS7                    AT1PHSLbits.PHS7                // bit 7, shadows bit in AT1PHSLbits

#define AT1RES8                 AT1RESHbits.AT1RES8             // bit 0, shadows bit in AT1RESHbits
#define RES8                    AT1RESHbits.RES8                // bit 0, shadows bit in AT1RESHbits
#define AT1RES9                 AT1RESHbits.AT1RES9             // bit 1, shadows bit in AT1RESHbits
#define RES9                    AT1RESHbits.RES9                // bit 1, shadows bit in AT1RESHbits

#define AT1RES0                 AT1RESLbits.AT1RES0             // bit 0, shadows bit in AT1RESLbits
#define RES0                    AT1RESLbits.RES0                // bit 0, shadows bit in AT1RESLbits
#define AT1RES1                 AT1RESLbits.AT1RES1             // bit 1, shadows bit in AT1RESLbits
#define RES1                    AT1RESLbits.RES1                // bit 1, shadows bit in AT1RESLbits
#define AT1RES2                 AT1RESLbits.AT1RES2             // bit 2, shadows bit in AT1RESLbits
#define RES2                    AT1RESLbits.RES2                // bit 2, shadows bit in AT1RESLbits
#define AT1RES3                 AT1RESLbits.AT1RES3             // bit 3, shadows bit in AT1RESLbits
#define RES3                    AT1RESLbits.RES3                // bit 3, shadows bit in AT1RESLbits
#define AT1RES4                 AT1RESLbits.AT1RES4             // bit 4, shadows bit in AT1RESLbits
#define RES4                    AT1RESLbits.RES4                // bit 4, shadows bit in AT1RESLbits
#define AT1RES5                 AT1RESLbits.AT1RES5             // bit 5, shadows bit in AT1RESLbits
#define RES5                    AT1RESLbits.RES5                // bit 5, shadows bit in AT1RESLbits
#define AT1RES6                 AT1RESLbits.AT1RES6             // bit 6, shadows bit in AT1RESLbits
#define RES6                    AT1RESLbits.RES6                // bit 6, shadows bit in AT1RESLbits
#define AT1RES7                 AT1RESLbits.AT1RES7             // bit 7, shadows bit in AT1RESLbits
#define RES7                    AT1RESLbits.RES7                // bit 7, shadows bit in AT1RESLbits

#define AT1SSEL0                AT1SIGbits.AT1SSEL0             // bit 0, shadows bit in AT1SIGbits
#define SSEL0                   AT1SIGbits.SSEL0                // bit 0, shadows bit in AT1SIGbits
#define AT1SSEL1                AT1SIGbits.AT1SSEL1             // bit 1, shadows bit in AT1SIGbits
#define SSEL1                   AT1SIGbits.SSEL1                // bit 1, shadows bit in AT1SIGbits
#define AT1SSEL2                AT1SIGbits.AT1SSEL2             // bit 2, shadows bit in AT1SIGbits
#define SSEL2                   AT1SIGbits.SSEL2                // bit 2, shadows bit in AT1SIGbits

#define AT1STPT8                AT1STPTHbits.AT1STPT8           // bit 0, shadows bit in AT1STPTHbits
#define STPT8                   AT1STPTHbits.STPT8              // bit 0, shadows bit in AT1STPTHbits
#define AT1STPT9                AT1STPTHbits.AT1STPT9           // bit 1, shadows bit in AT1STPTHbits
#define STPT9                   AT1STPTHbits.STPT9              // bit 1, shadows bit in AT1STPTHbits
#define AT1STPT10               AT1STPTHbits.AT1STPT10          // bit 2, shadows bit in AT1STPTHbits
#define STPT10                  AT1STPTHbits.STPT10             // bit 2, shadows bit in AT1STPTHbits
#define AT1STPT11               AT1STPTHbits.AT1STPT11          // bit 3, shadows bit in AT1STPTHbits
#define STPT11                  AT1STPTHbits.STPT11             // bit 3, shadows bit in AT1STPTHbits
#define AT1STPT12               AT1STPTHbits.AT1STPT12          // bit 4, shadows bit in AT1STPTHbits
#define STPT12                  AT1STPTHbits.STPT12             // bit 4, shadows bit in AT1STPTHbits
#define AT1STPT13               AT1STPTHbits.AT1STPT13          // bit 5, shadows bit in AT1STPTHbits
#define STPT13                  AT1STPTHbits.STPT13             // bit 5, shadows bit in AT1STPTHbits
#define AT1STPT14               AT1STPTHbits.AT1STPT14          // bit 6, shadows bit in AT1STPTHbits
#define STPT14                  AT1STPTHbits.STPT14             // bit 6, shadows bit in AT1STPTHbits

#define AT1STPT0                AT1STPTLbits.AT1STPT0           // bit 0, shadows bit in AT1STPTLbits
#define STPT0                   AT1STPTLbits.STPT0              // bit 0, shadows bit in AT1STPTLbits
#define AT1STPT1                AT1STPTLbits.AT1STPT1           // bit 1, shadows bit in AT1STPTLbits
#define STPT1                   AT1STPTLbits.STPT1              // bit 1, shadows bit in AT1STPTLbits
#define AT1STPT2                AT1STPTLbits.AT1STPT2           // bit 2, shadows bit in AT1STPTLbits
#define STPT2                   AT1STPTLbits.STPT2              // bit 2, shadows bit in AT1STPTLbits
#define AT1STPT3                AT1STPTLbits.AT1STPT3           // bit 3, shadows bit in AT1STPTLbits
#define STPT3                   AT1STPTLbits.STPT3              // bit 3, shadows bit in AT1STPTLbits
#define AT1STPT4                AT1STPTLbits.AT1STPT4           // bit 4, shadows bit in AT1STPTLbits
#define STPT4                   AT1STPTLbits.STPT4              // bit 4, shadows bit in AT1STPTLbits
#define AT1STPT5                AT1STPTLbits.AT1STPT5           // bit 5, shadows bit in AT1STPTLbits
#define STPT5                   AT1STPTLbits.STPT5              // bit 5, shadows bit in AT1STPTLbits
#define AT1STPT6                AT1STPTLbits.AT1STPT6           // bit 6, shadows bit in AT1STPTLbits
#define STPT6                   AT1STPTLbits.STPT6              // bit 6, shadows bit in AT1STPTLbits
#define AT1STPT7                AT1STPTLbits.AT1STPT7           // bit 7, shadows bit in AT1STPTLbits
#define STPT7                   AT1STPTLbits.STPT7              // bit 7, shadows bit in AT1STPTLbits

#define ATCC1PPS0               ATCC1PPSbits.ATCC1PPS0          // bit 0
#define ATCC1PPS1               ATCC1PPSbits.ATCC1PPS1          // bit 1
#define ATCC1PPS2               ATCC1PPSbits.ATCC1PPS2          // bit 2
#define ATCC1PPS3               ATCC1PPSbits.ATCC1PPS3          // bit 3
#define ATCC1PPS4               ATCC1PPSbits.ATCC1PPS4          // bit 4

#define ATCC2PPS0               ATCC2PPSbits.ATCC2PPS0          // bit 0
#define ATCC2PPS1               ATCC2PPSbits.ATCC2PPS1          // bit 1
#define ATCC2PPS2               ATCC2PPSbits.ATCC2PPS2          // bit 2
#define ATCC2PPS3               ATCC2PPSbits.ATCC2PPS3          // bit 3
#define ATCC2PPS4               ATCC2PPSbits.ATCC2PPS4          // bit 4

#define ATCC3PPS0               ATCC3PPSbits.ATCC3PPS0          // bit 0
#define ATCC3PPS1               ATCC3PPSbits.ATCC3PPS1          // bit 1
#define ATCC3PPS2               ATCC3PPSbits.ATCC3PPS2          // bit 2
#define ATCC3PPS3               ATCC3PPSbits.ATCC3PPS3          // bit 3
#define ATCC3PPS4               ATCC3PPSbits.ATCC3PPS4          // bit 4

#define ATINPPS0                ATINPPSbits.ATINPPS0            // bit 0
#define ATINPPS1                ATINPPSbits.ATINPPS1            // bit 1
#define ATINPPS2                ATINPPSbits.ATINPPS2            // bit 2
#define ATINPPS3                ATINPPSbits.ATINPPS3            // bit 3
#define ATINPPS4                ATINPPSbits.ATINPPS4            // bit 4

#define ABDEN                   BAUD1CONbits.ABDEN              // bit 0
#define WUE                     BAUD1CONbits.WUE                // bit 1
#define BRG16                   BAUD1CONbits.BRG16              // bit 3
#define SCKP                    BAUD1CONbits.SCKP               // bit 4
#define RCIDL                   BAUD1CONbits.RCIDL              // bit 6
#define ABDOVF                  BAUD1CONbits.ABDOVF             // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define CTS0                    CCP1CAPbits.CTS0                // bit 0, shadows bit in CCP1CAPbits
#define CCP1CTS0                CCP1CAPbits.CCP1CTS0            // bit 0, shadows bit in CCP1CAPbits
#define CTS1                    CCP1CAPbits.CTS1                // bit 1, shadows bit in CCP1CAPbits
#define CCP1CTS1                CCP1CAPbits.CCP1CTS1            // bit 1, shadows bit in CCP1CAPbits
#define CTS2                    CCP1CAPbits.CTS2                // bit 2, shadows bit in CCP1CAPbits
#define CCP1CTS2                CCP1CAPbits.CCP1CTS2            // bit 2, shadows bit in CCP1CAPbits

#define CCP1PPS0                CCP1PPSbits.CCP1PPS0            // bit 0
#define CCP1PPS1                CCP1PPSbits.CCP1PPS1            // bit 1
#define CCP1PPS2                CCP1PPSbits.CCP1PPS2            // bit 2
#define CCP1PPS3                CCP1PPSbits.CCP1PPS3            // bit 3
#define CCP1PPS4                CCP1PPSbits.CCP1PPS4            // bit 4

#define CCP2PPS0                CCP2PPSbits.CCP2PPS0            // bit 0
#define CCP2PPS1                CCP2PPSbits.CCP2PPS1            // bit 1
#define CCP2PPS2                CCP2PPSbits.CCP2PPS2            // bit 2
#define CCP2PPS3                CCP2PPSbits.CCP2PPS3            // bit 3
#define CCP2PPS4                CCP2PPSbits.CCP2PPS4            // bit 4

#define CCP1TSEL0               CCPTMRSbits.CCP1TSEL0           // bit 0
#define CCP1TSEL1               CCPTMRSbits.CCP1TSEL1           // bit 1
#define CCP2TSEL0               CCPTMRSbits.CCP2TSEL0           // bit 2
#define CCP2TSEL1               CCPTMRSbits.CCP2TSEL1           // bit 3
#define P3TSEL0                 CCPTMRSbits.P3TSEL0             // bit 4
#define P3TSEL1                 CCPTMRSbits.P3TSEL1             // bit 5
#define P4TSEL0                 CCPTMRSbits.P4TSEL0             // bit 6
#define P4TSEL1                 CCPTMRSbits.P4TSEL1             // bit 7

#define CKPPS0                  CKPPSbits.CKPPS0                // bit 0
#define CKPPS1                  CKPPSbits.CKPPS1                // bit 1
#define CKPPS2                  CKPPSbits.CKPPS2                // bit 2
#define CKPPS3                  CKPPSbits.CKPPS3                // bit 3
#define CKPPS4                  CKPPSbits.CKPPS4                // bit 4

#define LC1G1D1N                CLC1GLS0bits.LC1G1D1N           // bit 0, shadows bit in CLC1GLS0bits
#define D1N                     CLC1GLS0bits.D1N                // bit 0, shadows bit in CLC1GLS0bits
#define LC1G1D1T                CLC1GLS0bits.LC1G1D1T           // bit 1, shadows bit in CLC1GLS0bits
#define D1T                     CLC1GLS0bits.D1T                // bit 1, shadows bit in CLC1GLS0bits
#define LC1G1D2N                CLC1GLS0bits.LC1G1D2N           // bit 2, shadows bit in CLC1GLS0bits
#define D2N                     CLC1GLS0bits.D2N                // bit 2, shadows bit in CLC1GLS0bits
#define LC1G1D2T                CLC1GLS0bits.LC1G1D2T           // bit 3, shadows bit in CLC1GLS0bits
#define D2T                     CLC1GLS0bits.D2T                // bit 3, shadows bit in CLC1GLS0bits
#define LC1G1D3N                CLC1GLS0bits.LC1G1D3N           // bit 4, shadows bit in CLC1GLS0bits
#define D3N                     CLC1GLS0bits.D3N                // bit 4, shadows bit in CLC1GLS0bits
#define LC1G1D3T                CLC1GLS0bits.LC1G1D3T           // bit 5, shadows bit in CLC1GLS0bits
#define D3T                     CLC1GLS0bits.D3T                // bit 5, shadows bit in CLC1GLS0bits
#define LC1G1D4N                CLC1GLS0bits.LC1G1D4N           // bit 6, shadows bit in CLC1GLS0bits
#define D4N                     CLC1GLS0bits.D4N                // bit 6, shadows bit in CLC1GLS0bits
#define LC1G1D4T                CLC1GLS0bits.LC1G1D4T           // bit 7, shadows bit in CLC1GLS0bits
#define D4T                     CLC1GLS0bits.D4T                // bit 7, shadows bit in CLC1GLS0bits

#define LC1G4D1N                CLC1GLS3bits.LC1G4D1N           // bit 0, shadows bit in CLC1GLS3bits
#define G4D1N                   CLC1GLS3bits.G4D1N              // bit 0, shadows bit in CLC1GLS3bits
#define LC1G4D1T                CLC1GLS3bits.LC1G4D1T           // bit 1, shadows bit in CLC1GLS3bits
#define G4D1T                   CLC1GLS3bits.G4D1T              // bit 1, shadows bit in CLC1GLS3bits
#define LC1G4D2N                CLC1GLS3bits.LC1G4D2N           // bit 2, shadows bit in CLC1GLS3bits
#define G4D2N                   CLC1GLS3bits.G4D2N              // bit 2, shadows bit in CLC1GLS3bits
#define LC1G4D2T                CLC1GLS3bits.LC1G4D2T           // bit 3, shadows bit in CLC1GLS3bits
#define G4D2T                   CLC1GLS3bits.G4D2T              // bit 3, shadows bit in CLC1GLS3bits
#define LC1G4D3N                CLC1GLS3bits.LC1G4D3N           // bit 4, shadows bit in CLC1GLS3bits
#define G4D3N                   CLC1GLS3bits.G4D3N              // bit 4, shadows bit in CLC1GLS3bits
#define LC1G4D3T                CLC1GLS3bits.LC1G4D3T           // bit 5, shadows bit in CLC1GLS3bits
#define G4D3T                   CLC1GLS3bits.G4D3T              // bit 5, shadows bit in CLC1GLS3bits
#define LC1G4D4N                CLC1GLS3bits.LC1G4D4N           // bit 6, shadows bit in CLC1GLS3bits
#define G4D4N                   CLC1GLS3bits.G4D4N              // bit 6, shadows bit in CLC1GLS3bits
#define LC1G4D4T                CLC1GLS3bits.LC1G4D4T           // bit 7, shadows bit in CLC1GLS3bits
#define G4D4T                   CLC1GLS3bits.G4D4T              // bit 7, shadows bit in CLC1GLS3bits

#define LC1D1S0                 CLC1SEL0bits.LC1D1S0            // bit 0, shadows bit in CLC1SEL0bits
#define D1S0                    CLC1SEL0bits.D1S0               // bit 0, shadows bit in CLC1SEL0bits
#define LC1D1S1                 CLC1SEL0bits.LC1D1S1            // bit 1, shadows bit in CLC1SEL0bits
#define D1S1                    CLC1SEL0bits.D1S1               // bit 1, shadows bit in CLC1SEL0bits
#define LC1D1S2                 CLC1SEL0bits.LC1D1S2            // bit 2, shadows bit in CLC1SEL0bits
#define D1S2                    CLC1SEL0bits.D1S2               // bit 2, shadows bit in CLC1SEL0bits
#define LC1D1S3                 CLC1SEL0bits.LC1D1S3            // bit 3, shadows bit in CLC1SEL0bits
#define D1S3                    CLC1SEL0bits.D1S3               // bit 3, shadows bit in CLC1SEL0bits
#define LC1D1S4                 CLC1SEL0bits.LC1D1S4            // bit 4, shadows bit in CLC1SEL0bits
#define D1S4                    CLC1SEL0bits.D1S4               // bit 4, shadows bit in CLC1SEL0bits
#define LC1D1S5                 CLC1SEL0bits.LC1D1S5            // bit 5, shadows bit in CLC1SEL0bits
#define D1S5                    CLC1SEL0bits.D1S5               // bit 5, shadows bit in CLC1SEL0bits

#define LC1D2S0                 CLC1SEL1bits.LC1D2S0            // bit 0, shadows bit in CLC1SEL1bits
#define D2S0                    CLC1SEL1bits.D2S0               // bit 0, shadows bit in CLC1SEL1bits
#define LC1D2S1                 CLC1SEL1bits.LC1D2S1            // bit 1, shadows bit in CLC1SEL1bits
#define D2S1                    CLC1SEL1bits.D2S1               // bit 1, shadows bit in CLC1SEL1bits
#define LC1D2S2                 CLC1SEL1bits.LC1D2S2            // bit 2, shadows bit in CLC1SEL1bits
#define D2S2                    CLC1SEL1bits.D2S2               // bit 2, shadows bit in CLC1SEL1bits
#define LC1D2S3                 CLC1SEL1bits.LC1D2S3            // bit 3, shadows bit in CLC1SEL1bits
#define D2S3                    CLC1SEL1bits.D2S3               // bit 3, shadows bit in CLC1SEL1bits
#define LC1D2S4                 CLC1SEL1bits.LC1D2S4            // bit 4, shadows bit in CLC1SEL1bits
#define D2S4                    CLC1SEL1bits.D2S4               // bit 4, shadows bit in CLC1SEL1bits
#define LC1D2S5                 CLC1SEL1bits.LC1D2S5            // bit 5, shadows bit in CLC1SEL1bits
#define D2S5                    CLC1SEL1bits.D2S5               // bit 5, shadows bit in CLC1SEL1bits

#define LC1D3S0                 CLC1SEL2bits.LC1D3S0            // bit 0, shadows bit in CLC1SEL2bits
#define D3S0                    CLC1SEL2bits.D3S0               // bit 0, shadows bit in CLC1SEL2bits
#define LC1D3S1                 CLC1SEL2bits.LC1D3S1            // bit 1, shadows bit in CLC1SEL2bits
#define D3S1                    CLC1SEL2bits.D3S1               // bit 1, shadows bit in CLC1SEL2bits
#define LC1D3S2                 CLC1SEL2bits.LC1D3S2            // bit 2, shadows bit in CLC1SEL2bits
#define D3S2                    CLC1SEL2bits.D3S2               // bit 2, shadows bit in CLC1SEL2bits
#define LC1D3S3                 CLC1SEL2bits.LC1D3S3            // bit 3, shadows bit in CLC1SEL2bits
#define D3S3                    CLC1SEL2bits.D3S3               // bit 3, shadows bit in CLC1SEL2bits
#define LC1D3S4                 CLC1SEL2bits.LC1D3S4            // bit 4, shadows bit in CLC1SEL2bits
#define D3S4                    CLC1SEL2bits.D3S4               // bit 4, shadows bit in CLC1SEL2bits
#define LC1D3S5                 CLC1SEL2bits.LC1D3S5            // bit 5, shadows bit in CLC1SEL2bits
#define D3S5                    CLC1SEL2bits.D3S5               // bit 5, shadows bit in CLC1SEL2bits

#define LC1D4S0                 CLC1SEL3bits.LC1D4S0            // bit 0, shadows bit in CLC1SEL3bits
#define D4S0                    CLC1SEL3bits.D4S0               // bit 0, shadows bit in CLC1SEL3bits
#define LC1D4S1                 CLC1SEL3bits.LC1D4S1            // bit 1, shadows bit in CLC1SEL3bits
#define D4S1                    CLC1SEL3bits.D4S1               // bit 1, shadows bit in CLC1SEL3bits
#define LC1D4S2                 CLC1SEL3bits.LC1D4S2            // bit 2, shadows bit in CLC1SEL3bits
#define D4S2                    CLC1SEL3bits.D4S2               // bit 2, shadows bit in CLC1SEL3bits
#define LC1D4S3                 CLC1SEL3bits.LC1D4S3            // bit 3, shadows bit in CLC1SEL3bits
#define D4S3                    CLC1SEL3bits.D4S3               // bit 3, shadows bit in CLC1SEL3bits
#define LC1D4S4                 CLC1SEL3bits.LC1D4S4            // bit 4, shadows bit in CLC1SEL3bits
#define D4S4                    CLC1SEL3bits.D4S4               // bit 4, shadows bit in CLC1SEL3bits
#define LC1D4S5                 CLC1SEL3bits.LC1D4S5            // bit 5, shadows bit in CLC1SEL3bits
#define D4S5                    CLC1SEL3bits.D4S5               // bit 5, shadows bit in CLC1SEL3bits

#define MLC1OUT                 CLCDATAbits.MLC1OUT             // bit 0
#define MLC2OUT                 CLCDATAbits.MLC2OUT             // bit 1
#define MLC3OUT                 CLCDATAbits.MLC3OUT             // bit 2
#define MLC4OUT                 CLCDATAbits.MLC4OUT             // bit 3

#define CLCIN0PPS0              CLCIN0PPSbits.CLCIN0PPS0        // bit 0
#define CLCIN0PPS1              CLCIN0PPSbits.CLCIN0PPS1        // bit 1
#define CLCIN0PPS2              CLCIN0PPSbits.CLCIN0PPS2        // bit 2
#define CLCIN0PPS3              CLCIN0PPSbits.CLCIN0PPS3        // bit 3
#define CLCIN0PPS4              CLCIN0PPSbits.CLCIN0PPS4        // bit 4

#define CLCIN1PPS0              CLCIN1PPSbits.CLCIN1PPS0        // bit 0
#define CLCIN1PPS1              CLCIN1PPSbits.CLCIN1PPS1        // bit 1
#define CLCIN1PPS2              CLCIN1PPSbits.CLCIN1PPS2        // bit 2
#define CLCIN1PPS3              CLCIN1PPSbits.CLCIN1PPS3        // bit 3
#define CLCIN1PPS4              CLCIN1PPSbits.CLCIN1PPS4        // bit 4

#define CLCIN2PPS0              CLCIN2PPSbits.CLCIN2PPS0        // bit 0
#define CLCIN2PPS1              CLCIN2PPSbits.CLCIN2PPS1        // bit 1
#define CLCIN2PPS2              CLCIN2PPSbits.CLCIN2PPS2        // bit 2
#define CLCIN2PPS3              CLCIN2PPSbits.CLCIN2PPS3        // bit 3
#define CLCIN2PPS4              CLCIN2PPSbits.CLCIN2PPS4        // bit 4

#define CLCIN3PPS0              CLCIN3PPSbits.CLCIN3PPS0        // bit 0
#define CLCIN3PPS1              CLCIN3PPSbits.CLCIN3PPS1        // bit 1
#define CLCIN3PPS2              CLCIN3PPSbits.CLCIN3PPS2        // bit 2
#define CLCIN3PPS3              CLCIN3PPSbits.CLCIN3PPS3        // bit 3
#define CLCIN3PPS4              CLCIN3PPSbits.CLCIN3PPS4        // bit 4

#define C1SYNC                  CM1CON0bits.C1SYNC              // bit 0
#define C1HYS                   CM1CON0bits.C1HYS               // bit 1
#define C1SP                    CM1CON0bits.C1SP                // bit 2
#define C1POL                   CM1CON0bits.C1POL               // bit 4
#define C1OUT                   CM1CON0bits.C1OUT               // bit 6
#define C1ON                    CM1CON0bits.C1ON                // bit 7

#define C1NCH0                  CM1CON1bits.C1NCH0              // bit 0
#define C1NCH1                  CM1CON1bits.C1NCH1              // bit 1
#define C1NCH2                  CM1CON1bits.C1NCH2              // bit 2
#define C1PCH0                  CM1CON1bits.C1PCH0              // bit 4
#define C1PCH1                  CM1CON1bits.C1PCH1              // bit 5
#define C1INTN                  CM1CON1bits.C1INTN              // bit 6
#define C1INTP                  CM1CON1bits.C1INTP              // bit 7

#define C2SYNC                  CM2CON0bits.C2SYNC              // bit 0
#define C2HYS                   CM2CON0bits.C2HYS               // bit 1
#define C2SP                    CM2CON0bits.C2SP                // bit 2
#define C2POL                   CM2CON0bits.C2POL               // bit 4
#define C2OUT                   CM2CON0bits.C2OUT               // bit 6
#define C2ON                    CM2CON0bits.C2ON                // bit 7

#define C2NCH0                  CM2CON1bits.C2NCH0              // bit 0
#define C2NCH1                  CM2CON1bits.C2NCH1              // bit 1
#define C2NCH2                  CM2CON1bits.C2NCH2              // bit 2
#define C2PCH0                  CM2CON1bits.C2PCH0              // bit 4
#define C2PCH1                  CM2CON1bits.C2PCH1              // bit 5
#define C2INTN                  CM2CON1bits.C2INTN              // bit 6
#define C2INTP                  CM2CON1bits.C2INTP              // bit 7

#define MC1OUT                  CMOUTbits.MC1OUT                // bit 0
#define MC2OUT                  CMOUTbits.MC2OUT                // bit 1

#define ACC8                    CRCACCHbits.ACC8                // bit 0, shadows bit in CRCACCHbits
#define CRCACC8                 CRCACCHbits.CRCACC8             // bit 0, shadows bit in CRCACCHbits
#define ACC9                    CRCACCHbits.ACC9                // bit 1, shadows bit in CRCACCHbits
#define CRCACC9                 CRCACCHbits.CRCACC9             // bit 1, shadows bit in CRCACCHbits
#define ACC10                   CRCACCHbits.ACC10               // bit 2, shadows bit in CRCACCHbits
#define CRCACC10                CRCACCHbits.CRCACC10            // bit 2, shadows bit in CRCACCHbits
#define ACC11                   CRCACCHbits.ACC11               // bit 3, shadows bit in CRCACCHbits
#define CRCACC11                CRCACCHbits.CRCACC11            // bit 3, shadows bit in CRCACCHbits
#define ACC12                   CRCACCHbits.ACC12               // bit 4, shadows bit in CRCACCHbits
#define CRCACC12                CRCACCHbits.CRCACC12            // bit 4, shadows bit in CRCACCHbits
#define ACC13                   CRCACCHbits.ACC13               // bit 5, shadows bit in CRCACCHbits
#define CRCACC13                CRCACCHbits.CRCACC13            // bit 5, shadows bit in CRCACCHbits
#define ACC14                   CRCACCHbits.ACC14               // bit 6, shadows bit in CRCACCHbits
#define CRCACC14                CRCACCHbits.CRCACC14            // bit 6, shadows bit in CRCACCHbits
#define ACC15                   CRCACCHbits.ACC15               // bit 7, shadows bit in CRCACCHbits
#define CRCACC15                CRCACCHbits.CRCACC15            // bit 7, shadows bit in CRCACCHbits

#define ACC0                    CRCACCLbits.ACC0                // bit 0, shadows bit in CRCACCLbits
#define CRCACC0                 CRCACCLbits.CRCACC0             // bit 0, shadows bit in CRCACCLbits
#define ACC1                    CRCACCLbits.ACC1                // bit 1, shadows bit in CRCACCLbits
#define CRCACC1                 CRCACCLbits.CRCACC1             // bit 1, shadows bit in CRCACCLbits
#define ACC2                    CRCACCLbits.ACC2                // bit 2, shadows bit in CRCACCLbits
#define CRCACC2                 CRCACCLbits.CRCACC2             // bit 2, shadows bit in CRCACCLbits
#define ACC3                    CRCACCLbits.ACC3                // bit 3, shadows bit in CRCACCLbits
#define CRCACC3                 CRCACCLbits.CRCACC3             // bit 3, shadows bit in CRCACCLbits
#define ACC4                    CRCACCLbits.ACC4                // bit 4, shadows bit in CRCACCLbits
#define CRCACC4                 CRCACCLbits.CRCACC4             // bit 4, shadows bit in CRCACCLbits
#define ACC5                    CRCACCLbits.ACC5                // bit 5, shadows bit in CRCACCLbits
#define CRCACC5                 CRCACCLbits.CRCACC5             // bit 5, shadows bit in CRCACCLbits
#define ACC6                    CRCACCLbits.ACC6                // bit 6, shadows bit in CRCACCLbits
#define CRCACC6                 CRCACCLbits.CRCACC6             // bit 6, shadows bit in CRCACCLbits
#define ACC7                    CRCACCLbits.ACC7                // bit 7, shadows bit in CRCACCLbits
#define CRCACC7                 CRCACCLbits.CRCACC7             // bit 7, shadows bit in CRCACCLbits

#define PLEN0                   CRCCON1bits.PLEN0               // bit 0, shadows bit in CRCCON1bits
#define CRCPLEN0                CRCCON1bits.CRCPLEN0            // bit 0, shadows bit in CRCCON1bits
#define PLEN1                   CRCCON1bits.PLEN1               // bit 1, shadows bit in CRCCON1bits
#define CRCPLEN1                CRCCON1bits.CRCPLEN1            // bit 1, shadows bit in CRCCON1bits
#define PLEN2                   CRCCON1bits.PLEN2               // bit 2, shadows bit in CRCCON1bits
#define CRCPLEN2                CRCCON1bits.CRCPLEN2            // bit 2, shadows bit in CRCCON1bits
#define PLEN3                   CRCCON1bits.PLEN3               // bit 3, shadows bit in CRCCON1bits
#define CRCPLEN3                CRCCON1bits.CRCPLEN3            // bit 3, shadows bit in CRCCON1bits
#define DLEN0                   CRCCON1bits.DLEN0               // bit 4, shadows bit in CRCCON1bits
#define CRCDLEN0                CRCCON1bits.CRCDLEN0            // bit 4, shadows bit in CRCCON1bits
#define DLEN1                   CRCCON1bits.DLEN1               // bit 5, shadows bit in CRCCON1bits
#define CRCDLEN1                CRCCON1bits.CRCDLEN1            // bit 5, shadows bit in CRCCON1bits
#define DLEN2                   CRCCON1bits.DLEN2               // bit 6, shadows bit in CRCCON1bits
#define CRCDLEN2                CRCCON1bits.CRCDLEN2            // bit 6, shadows bit in CRCCON1bits
#define DLEN3                   CRCCON1bits.DLEN3               // bit 7, shadows bit in CRCCON1bits
#define CRCDLEN3                CRCCON1bits.CRCDLEN3            // bit 7, shadows bit in CRCCON1bits

#define DAT8                    CRCDATHbits.DAT8                // bit 0, shadows bit in CRCDATHbits
#define CRCDAT8                 CRCDATHbits.CRCDAT8             // bit 0, shadows bit in CRCDATHbits
#define DAT9                    CRCDATHbits.DAT9                // bit 1, shadows bit in CRCDATHbits
#define CRCDAT9                 CRCDATHbits.CRCDAT9             // bit 1, shadows bit in CRCDATHbits
#define DAT10                   CRCDATHbits.DAT10               // bit 2, shadows bit in CRCDATHbits
#define CRCDAT10                CRCDATHbits.CRCDAT10            // bit 2, shadows bit in CRCDATHbits
#define DAT11                   CRCDATHbits.DAT11               // bit 3, shadows bit in CRCDATHbits
#define CRCDAT11                CRCDATHbits.CRCDAT11            // bit 3, shadows bit in CRCDATHbits
#define DAT12                   CRCDATHbits.DAT12               // bit 4, shadows bit in CRCDATHbits
#define CRCDAT12                CRCDATHbits.CRCDAT12            // bit 4, shadows bit in CRCDATHbits
#define DAT13                   CRCDATHbits.DAT13               // bit 5, shadows bit in CRCDATHbits
#define CRCDAT13                CRCDATHbits.CRCDAT13            // bit 5, shadows bit in CRCDATHbits
#define DAT14                   CRCDATHbits.DAT14               // bit 6, shadows bit in CRCDATHbits
#define CRCDAT14                CRCDATHbits.CRCDAT14            // bit 6, shadows bit in CRCDATHbits
#define DAT15                   CRCDATHbits.DAT15               // bit 7, shadows bit in CRCDATHbits
#define CRCDAT15                CRCDATHbits.CRCDAT15            // bit 7, shadows bit in CRCDATHbits

#define DAT0                    CRCDATLbits.DAT0                // bit 0, shadows bit in CRCDATLbits
#define CRCDAT0                 CRCDATLbits.CRCDAT0             // bit 0, shadows bit in CRCDATLbits
#define DAT1                    CRCDATLbits.DAT1                // bit 1, shadows bit in CRCDATLbits
#define CRCDAT1                 CRCDATLbits.CRCDAT1             // bit 1, shadows bit in CRCDATLbits
#define DAT2                    CRCDATLbits.DAT2                // bit 2, shadows bit in CRCDATLbits
#define CRCDAT2                 CRCDATLbits.CRCDAT2             // bit 2, shadows bit in CRCDATLbits
#define DAT3                    CRCDATLbits.DAT3                // bit 3, shadows bit in CRCDATLbits
#define CRCDAT3                 CRCDATLbits.CRCDAT3             // bit 3, shadows bit in CRCDATLbits
#define DAT4                    CRCDATLbits.DAT4                // bit 4, shadows bit in CRCDATLbits
#define CRCDAT4                 CRCDATLbits.CRCDAT4             // bit 4, shadows bit in CRCDATLbits
#define DAT5                    CRCDATLbits.DAT5                // bit 5, shadows bit in CRCDATLbits
#define CRCDAT5                 CRCDATLbits.CRCDAT5             // bit 5, shadows bit in CRCDATLbits
#define DAT6                    CRCDATLbits.DAT6                // bit 6, shadows bit in CRCDATLbits
#define CRCDAT6                 CRCDATLbits.CRCDAT6             // bit 6, shadows bit in CRCDATLbits
#define DAT7                    CRCDATLbits.DAT7                // bit 7, shadows bit in CRCDATLbits
#define CRDCDAT7                CRCDATLbits.CRDCDAT7            // bit 7, shadows bit in CRCDATLbits

#define SHIFT8                  CRCSHIFTHbits.SHIFT8            // bit 0, shadows bit in CRCSHIFTHbits
#define CRCSHIFT8               CRCSHIFTHbits.CRCSHIFT8         // bit 0, shadows bit in CRCSHIFTHbits
#define SHIFT9                  CRCSHIFTHbits.SHIFT9            // bit 1, shadows bit in CRCSHIFTHbits
#define CRCSHIFT9               CRCSHIFTHbits.CRCSHIFT9         // bit 1, shadows bit in CRCSHIFTHbits
#define SHIFT10                 CRCSHIFTHbits.SHIFT10           // bit 2, shadows bit in CRCSHIFTHbits
#define CRCSHIFT10              CRCSHIFTHbits.CRCSHIFT10        // bit 2, shadows bit in CRCSHIFTHbits
#define SHIFT11                 CRCSHIFTHbits.SHIFT11           // bit 3, shadows bit in CRCSHIFTHbits
#define CRCSHIFT11              CRCSHIFTHbits.CRCSHIFT11        // bit 3, shadows bit in CRCSHIFTHbits
#define SHIFT12                 CRCSHIFTHbits.SHIFT12           // bit 4, shadows bit in CRCSHIFTHbits
#define CRCSHIFT12              CRCSHIFTHbits.CRCSHIFT12        // bit 4, shadows bit in CRCSHIFTHbits
#define SHIFT13                 CRCSHIFTHbits.SHIFT13           // bit 5, shadows bit in CRCSHIFTHbits
#define CRCSHIFT13              CRCSHIFTHbits.CRCSHIFT13        // bit 5, shadows bit in CRCSHIFTHbits
#define SHIFT14                 CRCSHIFTHbits.SHIFT14           // bit 6, shadows bit in CRCSHIFTHbits
#define CRCSHIFT14              CRCSHIFTHbits.CRCSHIFT14        // bit 6, shadows bit in CRCSHIFTHbits
#define SHIFT15                 CRCSHIFTHbits.SHIFT15           // bit 7, shadows bit in CRCSHIFTHbits
#define CRCSHIFT15              CRCSHIFTHbits.CRCSHIFT15        // bit 7, shadows bit in CRCSHIFTHbits

#define SHIFT0                  CRCSHIFTLbits.SHIFT0            // bit 0, shadows bit in CRCSHIFTLbits
#define CRCSHIFT0               CRCSHIFTLbits.CRCSHIFT0         // bit 0, shadows bit in CRCSHIFTLbits
#define SHIFT1                  CRCSHIFTLbits.SHIFT1            // bit 1, shadows bit in CRCSHIFTLbits
#define CRCSHIFT1               CRCSHIFTLbits.CRCSHIFT1         // bit 1, shadows bit in CRCSHIFTLbits
#define SHIFT2                  CRCSHIFTLbits.SHIFT2            // bit 2, shadows bit in CRCSHIFTLbits
#define CRCSHIFT2               CRCSHIFTLbits.CRCSHIFT2         // bit 2, shadows bit in CRCSHIFTLbits
#define SHIFT3                  CRCSHIFTLbits.SHIFT3            // bit 3, shadows bit in CRCSHIFTLbits
#define CRCSHIFT3               CRCSHIFTLbits.CRCSHIFT3         // bit 3, shadows bit in CRCSHIFTLbits
#define SHIFT4                  CRCSHIFTLbits.SHIFT4            // bit 4, shadows bit in CRCSHIFTLbits
#define CRCSHIFT4               CRCSHIFTLbits.CRCSHIFT4         // bit 4, shadows bit in CRCSHIFTLbits
#define SHIFT5                  CRCSHIFTLbits.SHIFT5            // bit 5, shadows bit in CRCSHIFTLbits
#define CRCSHIFT5               CRCSHIFTLbits.CRCSHIFT5         // bit 5, shadows bit in CRCSHIFTLbits
#define SHIFT6                  CRCSHIFTLbits.SHIFT6            // bit 6, shadows bit in CRCSHIFTLbits
#define CRCSHIFT6               CRCSHIFTLbits.CRCSHIFT6         // bit 6, shadows bit in CRCSHIFTLbits
#define SHIFT7                  CRCSHIFTLbits.SHIFT7            // bit 7, shadows bit in CRCSHIFTLbits
#define CRCSHIFT7               CRCSHIFTLbits.CRCSHIFT7         // bit 7, shadows bit in CRCSHIFTLbits

#define XOR8                    CRCXORHbits.XOR8                // bit 0, shadows bit in CRCXORHbits
#define CRCXOR8                 CRCXORHbits.CRCXOR8             // bit 0, shadows bit in CRCXORHbits
#define XOR9                    CRCXORHbits.XOR9                // bit 1, shadows bit in CRCXORHbits
#define CRCXOR9                 CRCXORHbits.CRCXOR9             // bit 1, shadows bit in CRCXORHbits
#define XOR10                   CRCXORHbits.XOR10               // bit 2, shadows bit in CRCXORHbits
#define CRCXOR10                CRCXORHbits.CRCXOR10            // bit 2, shadows bit in CRCXORHbits
#define XOR11                   CRCXORHbits.XOR11               // bit 3, shadows bit in CRCXORHbits
#define CRCXOR11                CRCXORHbits.CRCXOR11            // bit 3, shadows bit in CRCXORHbits
#define XOR12                   CRCXORHbits.XOR12               // bit 4, shadows bit in CRCXORHbits
#define CRCXOR12                CRCXORHbits.CRCXOR12            // bit 4, shadows bit in CRCXORHbits
#define XOR13                   CRCXORHbits.XOR13               // bit 5, shadows bit in CRCXORHbits
#define CRCXOR13                CRCXORHbits.CRCXOR13            // bit 5, shadows bit in CRCXORHbits
#define XOR14                   CRCXORHbits.XOR14               // bit 6, shadows bit in CRCXORHbits
#define CRCXOR14                CRCXORHbits.CRCXOR14            // bit 6, shadows bit in CRCXORHbits
#define XOR15                   CRCXORHbits.XOR15               // bit 7, shadows bit in CRCXORHbits
#define CRCXOR15                CRCXORHbits.CRCXOR15            // bit 7, shadows bit in CRCXORHbits

#define XOR1                    CRCXORLbits.XOR1                // bit 1, shadows bit in CRCXORLbits
#define CRCXOR1                 CRCXORLbits.CRCXOR1             // bit 1, shadows bit in CRCXORLbits
#define XOR2                    CRCXORLbits.XOR2                // bit 2, shadows bit in CRCXORLbits
#define CRCXOR2                 CRCXORLbits.CRCXOR2             // bit 2, shadows bit in CRCXORLbits
#define XOR3                    CRCXORLbits.XOR3                // bit 3, shadows bit in CRCXORLbits
#define CRCXOR3                 CRCXORLbits.CRCXOR3             // bit 3, shadows bit in CRCXORLbits
#define XOR4                    CRCXORLbits.XOR4                // bit 4, shadows bit in CRCXORLbits
#define CRCXOR4                 CRCXORLbits.CRCXOR4             // bit 4, shadows bit in CRCXORLbits
#define XOR5                    CRCXORLbits.XOR5                // bit 5, shadows bit in CRCXORLbits
#define CRCXOR5                 CRCXORLbits.CRCXOR5             // bit 5, shadows bit in CRCXORLbits
#define XOR6                    CRCXORLbits.XOR6                // bit 6, shadows bit in CRCXORLbits
#define CRCXOR6                 CRCXORLbits.CRCXOR6             // bit 6, shadows bit in CRCXORLbits
#define XOR7                    CRCXORLbits.XOR7                // bit 7, shadows bit in CRCXORLbits
#define CRCXOR7                 CRCXORLbits.CRCXOR7             // bit 7, shadows bit in CRCXORLbits

#define LSAC0                   CWG1AS0bits.LSAC0               // bit 2, shadows bit in CWG1AS0bits
#define CWG1LSAC0               CWG1AS0bits.CWG1LSAC0           // bit 2, shadows bit in CWG1AS0bits
#define LSAC1                   CWG1AS0bits.LSAC1               // bit 3, shadows bit in CWG1AS0bits
#define CWG1LSAC1               CWG1AS0bits.CWG1LSAC1           // bit 3, shadows bit in CWG1AS0bits
#define LSBD0                   CWG1AS0bits.LSBD0               // bit 4, shadows bit in CWG1AS0bits
#define CWG1LSBD0               CWG1AS0bits.CWG1LSBD0           // bit 4, shadows bit in CWG1AS0bits
#define LSBD1                   CWG1AS0bits.LSBD1               // bit 5, shadows bit in CWG1AS0bits
#define CWG1LSBD1               CWG1AS0bits.CWG1LSBD1           // bit 5, shadows bit in CWG1AS0bits
#define REN                     CWG1AS0bits.REN                 // bit 6, shadows bit in CWG1AS0bits
#define CWG1REN                 CWG1AS0bits.CWG1REN             // bit 6, shadows bit in CWG1AS0bits
#define SHUTDOWN                CWG1AS0bits.SHUTDOWN            // bit 7, shadows bit in CWG1AS0bits
#define CWG1SHUTDOWN            CWG1AS0bits.CWG1SHUTDOWN        // bit 7, shadows bit in CWG1AS0bits

#define INAS                    CWG1AS1bits.INAS                // bit 0, shadows bit in CWG1AS1bits
#define CWG1INAS                CWG1AS1bits.CWG1INAS            // bit 0, shadows bit in CWG1AS1bits
#define C1AS                    CWG1AS1bits.C1AS                // bit 1, shadows bit in CWG1AS1bits
#define CWG1C1AS                CWG1AS1bits.CWG1C1AS            // bit 1, shadows bit in CWG1AS1bits
#define C2AS                    CWG1AS1bits.C2AS                // bit 2, shadows bit in CWG1AS1bits
#define CWG1C2AS                CWG1AS1bits.CWG1C2AS            // bit 2, shadows bit in CWG1AS1bits
#define TMR2AS                  CWG1AS1bits.TMR2AS              // bit 4, shadows bit in CWG1AS1bits
#define CWG1TMR2AS              CWG1AS1bits.CWG1TMR2AS          // bit 4, shadows bit in CWG1AS1bits
#define TMR4AS                  CWG1AS1bits.TMR4AS              // bit 5, shadows bit in CWG1AS1bits
#define CWG1TMR4AS              CWG1AS1bits.CWG1TMR4AS          // bit 5, shadows bit in CWG1AS1bits
#define TMR6AS                  CWG1AS1bits.TMR6AS              // bit 6, shadows bit in CWG1AS1bits
#define CWG1TMR6AS              CWG1AS1bits.CWG1TMR6AS          // bit 6, shadows bit in CWG1AS1bits

#define POLA                    CWG1CON1bits.POLA               // bit 0, shadows bit in CWG1CON1bits
#define CWG1POLA                CWG1CON1bits.CWG1POLA           // bit 0, shadows bit in CWG1CON1bits
#define POLB                    CWG1CON1bits.POLB               // bit 1, shadows bit in CWG1CON1bits
#define CWG1POLB                CWG1CON1bits.CWG1POLB           // bit 1, shadows bit in CWG1CON1bits
#define POLC                    CWG1CON1bits.POLC               // bit 2, shadows bit in CWG1CON1bits
#define CWG1POLC                CWG1CON1bits.CWG1POLC           // bit 2, shadows bit in CWG1CON1bits
#define POLD                    CWG1CON1bits.POLD               // bit 3, shadows bit in CWG1CON1bits
#define CWG1POLD                CWG1CON1bits.CWG1POLD           // bit 3, shadows bit in CWG1CON1bits
#define IN                      CWG1CON1bits.IN                 // bit 5, shadows bit in CWG1CON1bits
#define CWG1IN                  CWG1CON1bits.CWG1IN             // bit 5, shadows bit in CWG1CON1bits

#define DBF0                    CWG1DBFbits.DBF0                // bit 0, shadows bit in CWG1DBFbits
#define CWG1DBF0                CWG1DBFbits.CWG1DBF0            // bit 0, shadows bit in CWG1DBFbits
#define DBF1                    CWG1DBFbits.DBF1                // bit 1, shadows bit in CWG1DBFbits
#define CWG1DBF1                CWG1DBFbits.CWG1DBF1            // bit 1, shadows bit in CWG1DBFbits
#define DBF2                    CWG1DBFbits.DBF2                // bit 2, shadows bit in CWG1DBFbits
#define CWG1DBF2                CWG1DBFbits.CWG1DBF2            // bit 2, shadows bit in CWG1DBFbits
#define DBF3                    CWG1DBFbits.DBF3                // bit 3, shadows bit in CWG1DBFbits
#define CWG1DBF3                CWG1DBFbits.CWG1DBF3            // bit 3, shadows bit in CWG1DBFbits
#define DBF4                    CWG1DBFbits.DBF4                // bit 4, shadows bit in CWG1DBFbits
#define CWG1DBF4                CWG1DBFbits.CWG1DBF4            // bit 4, shadows bit in CWG1DBFbits
#define DBF5                    CWG1DBFbits.DBF5                // bit 5, shadows bit in CWG1DBFbits
#define CWG1DBF5                CWG1DBFbits.CWG1DBF5            // bit 5, shadows bit in CWG1DBFbits

#define DBR0                    CWG1DBRbits.DBR0                // bit 0, shadows bit in CWG1DBRbits
#define CWG1DBR0                CWG1DBRbits.CWG1DBR0            // bit 0, shadows bit in CWG1DBRbits
#define DBR1                    CWG1DBRbits.DBR1                // bit 1, shadows bit in CWG1DBRbits
#define CWG1DBR1                CWG1DBRbits.CWG1DBR1            // bit 1, shadows bit in CWG1DBRbits
#define DBR2                    CWG1DBRbits.DBR2                // bit 2, shadows bit in CWG1DBRbits
#define CWG1DBR2                CWG1DBRbits.CWG1DBR2            // bit 2, shadows bit in CWG1DBRbits
#define DBR3                    CWG1DBRbits.DBR3                // bit 3, shadows bit in CWG1DBRbits
#define CWG1DBR3                CWG1DBRbits.CWG1DBR3            // bit 3, shadows bit in CWG1DBRbits
#define DBR4                    CWG1DBRbits.DBR4                // bit 4, shadows bit in CWG1DBRbits
#define CWG1DBR4                CWG1DBRbits.CWG1DBR4            // bit 4, shadows bit in CWG1DBRbits
#define DBR5                    CWG1DBRbits.DBR5                // bit 5, shadows bit in CWG1DBRbits
#define CWG1DBR5                CWG1DBRbits.CWG1DBR5            // bit 5, shadows bit in CWG1DBRbits

#define IS0                     CWG1ISMbits.IS0                 // bit 0, shadows bit in CWG1ISMbits
#define CWG1IS0                 CWG1ISMbits.CWG1IS0             // bit 0, shadows bit in CWG1ISMbits
#define IS1                     CWG1ISMbits.IS1                 // bit 1, shadows bit in CWG1ISMbits
#define CWG1IS1                 CWG1ISMbits.CWG1IS1             // bit 1, shadows bit in CWG1ISMbits
#define IS2                     CWG1ISMbits.IS2                 // bit 2, shadows bit in CWG1ISMbits
#define CWG1IS2                 CWG1ISMbits.CWG1IS2             // bit 2, shadows bit in CWG1ISMbits
#define IS3                     CWG1ISMbits.IS3                 // bit 3, shadows bit in CWG1ISMbits
#define CWG1IS3                 CWG1ISMbits.CWG1IS3             // bit 3, shadows bit in CWG1ISMbits

#define STRA                    CWG1OCON0bits.STRA              // bit 0, shadows bit in CWG1OCON0bits
#define CWG1STRA                CWG1OCON0bits.CWG1STRA          // bit 0, shadows bit in CWG1OCON0bits
#define STRB                    CWG1OCON0bits.STRB              // bit 1, shadows bit in CWG1OCON0bits
#define CWG1STRB                CWG1OCON0bits.CWG1STRB          // bit 1, shadows bit in CWG1OCON0bits
#define STRC                    CWG1OCON0bits.STRC              // bit 2, shadows bit in CWG1OCON0bits
#define CWG1STRC                CWG1OCON0bits.CWG1STRC          // bit 2, shadows bit in CWG1OCON0bits
#define STRD                    CWG1OCON0bits.STRD              // bit 3, shadows bit in CWG1OCON0bits
#define CWG1STRD                CWG1OCON0bits.CWG1STRD          // bit 3, shadows bit in CWG1OCON0bits
#define OVRA                    CWG1OCON0bits.OVRA              // bit 4, shadows bit in CWG1OCON0bits
#define CWG1OVRA                CWG1OCON0bits.CWG1OVRA          // bit 4, shadows bit in CWG1OCON0bits
#define OVRB                    CWG1OCON0bits.OVRB              // bit 5, shadows bit in CWG1OCON0bits
#define CWG1OVRB                CWG1OCON0bits.CWG1OVRB          // bit 5, shadows bit in CWG1OCON0bits
#define OVRC                    CWG1OCON0bits.OVRC              // bit 6, shadows bit in CWG1OCON0bits
#define CWG1OVRC                CWG1OCON0bits.CWG1OVRC          // bit 6, shadows bit in CWG1OCON0bits
#define OVRD                    CWG1OCON0bits.OVRD              // bit 7, shadows bit in CWG1OCON0bits
#define CWG1OVRD                CWG1OCON0bits.CWG1OVRD          // bit 7, shadows bit in CWG1OCON0bits

#define CWGINPPS0               CWGINPPSbits.CWGINPPS0          // bit 0
#define CWGINPPS1               CWGINPPSbits.CWGINPPS1          // bit 1
#define CWGINPPS2               CWGINPPSbits.CWGINPPS2          // bit 2
#define CWGINPPS3               CWGINPPSbits.CWGINPPS3          // bit 3
#define CWGINPPS4               CWGINPPSbits.CWGINPPS4          // bit 4

#define D1PSS0                  DAC1CON0bits.D1PSS0             // bit 2
#define D1PSS1                  DAC1CON0bits.D1PSS1             // bit 3
#define DAC1OE                  DAC1CON0bits.DAC1OE             // bit 5
#define DAC1EN                  DAC1CON0bits.DAC1EN             // bit 7

#define DAC1R0                  DAC1CON1bits.DAC1R0             // bit 0
#define DAC1R1                  DAC1CON1bits.DAC1R1             // bit 1
#define DAC1R2                  DAC1CON1bits.DAC1R2             // bit 2
#define DAC1R3                  DAC1CON1bits.DAC1R3             // bit 3
#define DAC1R4                  DAC1CON1bits.DAC1R4             // bit 4
#define DAC1R5                  DAC1CON1bits.DAC1R5             // bit 5
#define DAC1R6                  DAC1CON1bits.DAC1R6             // bit 6
#define DAC1R7                  DAC1CON1bits.DAC1R7             // bit 7

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define CDAFVR0                 FVRCONbits.CDAFVR0              // bit 2
#define CDAFVR1                 FVRCONbits.CDAFVR1              // bit 3
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define HIDC4                   HDRVCbits.HIDC4                 // bit 4
#define HIDC5                   HDRVCbits.HIDC5                 // bit 5

#define INLVLA0                 INLVLAbits.INLVLA0              // bit 0
#define INLVLA1                 INLVLAbits.INLVLA1              // bit 1
#define INLVLA2                 INLVLAbits.INLVLA2              // bit 2
#define INLVLA3                 INLVLAbits.INLVLA3              // bit 3
#define INLVLA4                 INLVLAbits.INLVLA4              // bit 4
#define INLVLA5                 INLVLAbits.INLVLA5              // bit 5

#define INLVLB4                 INLVLBbits.INLVLB4              // bit 4
#define INLVLB5                 INLVLBbits.INLVLB5              // bit 5
#define INLVLB6                 INLVLBbits.INLVLB6              // bit 6
#define INLVLB7                 INLVLBbits.INLVLB7              // bit 7

#define INLVLC0                 INLVLCbits.INLVLC0              // bit 0
#define INLVLC1                 INLVLCbits.INLVLC1              // bit 1
#define INLVLC2                 INLVLCbits.INLVLC2              // bit 2
#define INLVLC3                 INLVLCbits.INLVLC3              // bit 3
#define INLVLC4                 INLVLCbits.INLVLC4              // bit 4
#define INLVLC5                 INLVLCbits.INLVLC5              // bit 5
#define INLVLC6                 INLVLCbits.INLVLC6              // bit 6
#define INLVLC7                 INLVLCbits.INLVLC7              // bit 7

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define INTPPS0                 INTPPSbits.INTPPS0              // bit 0
#define INTPPS1                 INTPPSbits.INTPPS1              // bit 1
#define INTPPS2                 INTPPSbits.INTPPS2              // bit 2
#define INTPPS3                 INTPPSbits.INTPPS3              // bit 3
#define INTPPS4                 INTPPSbits.INTPPS4              // bit 4

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5

#define IOCBF4                  IOCBFbits.IOCBF4                // bit 4
#define IOCBF5                  IOCBFbits.IOCBF5                // bit 5
#define IOCBF6                  IOCBFbits.IOCBF6                // bit 6
#define IOCBF7                  IOCBFbits.IOCBF7                // bit 7

#define IOCBN4                  IOCBNbits.IOCBN4                // bit 4
#define IOCBN5                  IOCBNbits.IOCBN5                // bit 5
#define IOCBN6                  IOCBNbits.IOCBN6                // bit 6
#define IOCBN7                  IOCBNbits.IOCBN7                // bit 7

#define IOCBP4                  IOCBPbits.IOCBP4                // bit 4
#define IOCBP5                  IOCBPbits.IOCBP5                // bit 5
#define IOCBP6                  IOCBPbits.IOCBP6                // bit 6
#define IOCBP7                  IOCBPbits.IOCBP7                // bit 7

#define IOCCF0                  IOCCFbits.IOCCF0                // bit 0
#define IOCCF1                  IOCCFbits.IOCCF1                // bit 1
#define IOCCF2                  IOCCFbits.IOCCF2                // bit 2
#define IOCCF3                  IOCCFbits.IOCCF3                // bit 3
#define IOCCF4                  IOCCFbits.IOCCF4                // bit 4
#define IOCCF5                  IOCCFbits.IOCCF5                // bit 5
#define IOCCF6                  IOCCFbits.IOCCF6                // bit 6
#define IOCCF7                  IOCCFbits.IOCCF7                // bit 7

#define IOCCN0                  IOCCNbits.IOCCN0                // bit 0
#define IOCCN1                  IOCCNbits.IOCCN1                // bit 1
#define IOCCN2                  IOCCNbits.IOCCN2                // bit 2
#define IOCCN3                  IOCCNbits.IOCCN3                // bit 3
#define IOCCN4                  IOCCNbits.IOCCN4                // bit 4
#define IOCCN5                  IOCCNbits.IOCCN5                // bit 5
#define IOCCN6                  IOCCNbits.IOCCN6                // bit 6
#define IOCCN7                  IOCCNbits.IOCCN7                // bit 7

#define IOCCP0                  IOCCPbits.IOCCP0                // bit 0
#define IOCCP1                  IOCCPbits.IOCCP1                // bit 1
#define IOCCP2                  IOCCPbits.IOCCP2                // bit 2
#define IOCCP3                  IOCCPbits.IOCCP3                // bit 3
#define IOCCP4                  IOCCPbits.IOCCP4                // bit 4
#define IOCCP5                  IOCCPbits.IOCCP5                // bit 5
#define IOCCP6                  IOCCPbits.IOCCP6                // bit 6
#define IOCCP7                  IOCCPbits.IOCCP7                // bit 7

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA3                   LATAbits.LATA3                  // bit 3
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5

#define LATB4                   LATBbits.LATB4                  // bit 4
#define LATB5                   LATBbits.LATB5                  // bit 5
#define LATB6                   LATBbits.LATB6                  // bit 6
#define LATB7                   LATBbits.LATB7                  // bit 7

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5
#define LATC6                   LATCbits.LATC6                  // bit 6
#define LATC7                   LATCbits.LATC7                  // bit 7

#define ODA0                    ODCONAbits.ODA0                 // bit 0
#define ODA1                    ODCONAbits.ODA1                 // bit 1
#define ODA2                    ODCONAbits.ODA2                 // bit 2
#define ODA4                    ODCONAbits.ODA4                 // bit 4
#define ODA5                    ODCONAbits.ODA5                 // bit 5

#define ODB4                    ODCONBbits.ODB4                 // bit 4
#define ODB5                    ODCONBbits.ODB5                 // bit 5
#define ODB6                    ODCONBbits.ODB6                 // bit 6
#define ODB7                    ODCONBbits.ODB7                 // bit 7

#define ODC0                    ODCONCbits.ODC0                 // bit 0
#define ODC1                    ODCONCbits.ODC1                 // bit 1
#define ODC2                    ODCONCbits.ODC2                 // bit 2
#define ODC3                    ODCONCbits.ODC3                 // bit 3
#define ODC4                    ODCONCbits.ODC4                 // bit 4
#define ODC5                    ODCONCbits.ODC5                 // bit 5
#define ODC6                    ODCONCbits.ODC6                 // bit 6
#define ODC7                    ODCONCbits.ODC7                 // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6
#define SPLLEN                  OSCCONbits.SPLLEN               // bit 7

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define MFIOFR                  OSCSTATbits.MFIOFR              // bit 2
#define HFIOFL                  OSCSTATbits.HFIOFL              // bit 3
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define OSTS                    OSCSTATbits.OSTS                // bit 5
#define PLLR                    OSCSTATbits.PLLR                // bit 6

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4
#define TUN5                    OSCTUNEbits.TUN5                // bit 5

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define NOT_WDTWV               PCONbits.NOT_WDTWV              // bit 5
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define PID1ACC24               PID1ACCHHbits.PID1ACC24         // bit 0, shadows bit in PID1ACCHHbits
#define ACC24                   PID1ACCHHbits.ACC24             // bit 0, shadows bit in PID1ACCHHbits
#define PID1ACC25               PID1ACCHHbits.PID1ACC25         // bit 1, shadows bit in PID1ACCHHbits
#define ACC25                   PID1ACCHHbits.ACC25             // bit 1, shadows bit in PID1ACCHHbits
#define PID1ACC26               PID1ACCHHbits.PID1ACC26         // bit 2, shadows bit in PID1ACCHHbits
#define ACC26                   PID1ACCHHbits.ACC26             // bit 2, shadows bit in PID1ACCHHbits
#define PID1ACC27               PID1ACCHHbits.PID1ACC27         // bit 3, shadows bit in PID1ACCHHbits
#define ACC27                   PID1ACCHHbits.ACC27             // bit 3, shadows bit in PID1ACCHHbits
#define PID1ACC28               PID1ACCHHbits.PID1ACC28         // bit 4, shadows bit in PID1ACCHHbits
#define ACC28                   PID1ACCHHbits.ACC28             // bit 4, shadows bit in PID1ACCHHbits
#define PID1ACC29               PID1ACCHHbits.PID1ACC29         // bit 5, shadows bit in PID1ACCHHbits
#define ACC29                   PID1ACCHHbits.ACC29             // bit 5, shadows bit in PID1ACCHHbits
#define PID1ACC30               PID1ACCHHbits.PID1ACC30         // bit 6, shadows bit in PID1ACCHHbits
#define ACC30                   PID1ACCHHbits.ACC30             // bit 6, shadows bit in PID1ACCHHbits
#define PID1ACC31               PID1ACCHHbits.PID1ACC31         // bit 7, shadows bit in PID1ACCHHbits
#define ACC31                   PID1ACCHHbits.ACC31             // bit 7, shadows bit in PID1ACCHHbits

#define PID1ACC16               PID1ACCHLbits.PID1ACC16         // bit 0, shadows bit in PID1ACCHLbits
#define ACC16                   PID1ACCHLbits.ACC16             // bit 0, shadows bit in PID1ACCHLbits
#define PID1ACC17               PID1ACCHLbits.PID1ACC17         // bit 1, shadows bit in PID1ACCHLbits
#define ACC17                   PID1ACCHLbits.ACC17             // bit 1, shadows bit in PID1ACCHLbits
#define PID1ACC18               PID1ACCHLbits.PID1ACC18         // bit 2, shadows bit in PID1ACCHLbits
#define ACC18                   PID1ACCHLbits.ACC18             // bit 2, shadows bit in PID1ACCHLbits
#define PID1ACC19               PID1ACCHLbits.PID1ACC19         // bit 3, shadows bit in PID1ACCHLbits
#define ACC19                   PID1ACCHLbits.ACC19             // bit 3, shadows bit in PID1ACCHLbits
#define PID1ACC20               PID1ACCHLbits.PID1ACC20         // bit 4, shadows bit in PID1ACCHLbits
#define ACC20                   PID1ACCHLbits.ACC20             // bit 4, shadows bit in PID1ACCHLbits
#define PID1ACC21               PID1ACCHLbits.PID1ACC21         // bit 5, shadows bit in PID1ACCHLbits
#define ACC21                   PID1ACCHLbits.ACC21             // bit 5, shadows bit in PID1ACCHLbits
#define PID1ACC22               PID1ACCHLbits.PID1ACC22         // bit 6, shadows bit in PID1ACCHLbits
#define ACC22                   PID1ACCHLbits.ACC22             // bit 6, shadows bit in PID1ACCHLbits
#define PID1ACC23               PID1ACCHLbits.PID1ACC23         // bit 7, shadows bit in PID1ACCHLbits
#define ACC23                   PID1ACCHLbits.ACC23             // bit 7, shadows bit in PID1ACCHLbits

#define PID1ACC32               PID1ACCUbits.PID1ACC32          // bit 0, shadows bit in PID1ACCUbits
#define ACC32                   PID1ACCUbits.ACC32              // bit 0, shadows bit in PID1ACCUbits
#define PID1ACC33               PID1ACCUbits.PID1ACC33          // bit 1, shadows bit in PID1ACCUbits
#define ACC33                   PID1ACCUbits.ACC33              // bit 1, shadows bit in PID1ACCUbits
#define PID1ACC34               PID1ACCUbits.PID1ACC34          // bit 2, shadows bit in PID1ACCUbits
#define ACC34                   PID1ACCUbits.ACC34              // bit 2, shadows bit in PID1ACCUbits

#define PID1IN8                 PID1INHbits.PID1IN8             // bit 0, shadows bit in PID1INHbits
#define IN8                     PID1INHbits.IN8                 // bit 0, shadows bit in PID1INHbits
#define PID1IN9                 PID1INHbits.PID1IN9             // bit 1, shadows bit in PID1INHbits
#define IN9                     PID1INHbits.IN9                 // bit 1, shadows bit in PID1INHbits
#define PID1IN10                PID1INHbits.PID1IN10            // bit 2, shadows bit in PID1INHbits
#define IN10                    PID1INHbits.IN10                // bit 2, shadows bit in PID1INHbits
#define PID1IN11                PID1INHbits.PID1IN11            // bit 3, shadows bit in PID1INHbits
#define IN11                    PID1INHbits.IN11                // bit 3, shadows bit in PID1INHbits
#define PID1IN12                PID1INHbits.PID1IN12            // bit 4, shadows bit in PID1INHbits
#define IN12                    PID1INHbits.IN12                // bit 4, shadows bit in PID1INHbits
#define PID1IN13                PID1INHbits.PID1IN13            // bit 5, shadows bit in PID1INHbits
#define IN13                    PID1INHbits.IN13                // bit 5, shadows bit in PID1INHbits
#define PID1IN14                PID1INHbits.PID1IN14            // bit 6, shadows bit in PID1INHbits
#define IN14                    PID1INHbits.IN14                // bit 6, shadows bit in PID1INHbits
#define PID1IN15                PID1INHbits.PID1IN15            // bit 7, shadows bit in PID1INHbits
#define IN15                    PID1INHbits.IN15                // bit 7, shadows bit in PID1INHbits

#define PID1IN0                 PID1INLbits.PID1IN0             // bit 0, shadows bit in PID1INLbits
#define IN0                     PID1INLbits.IN0                 // bit 0, shadows bit in PID1INLbits
#define PID1IN1                 PID1INLbits.PID1IN1             // bit 1, shadows bit in PID1INLbits
#define IN1                     PID1INLbits.IN1                 // bit 1, shadows bit in PID1INLbits
#define PID1IN2                 PID1INLbits.PID1IN2             // bit 2, shadows bit in PID1INLbits
#define IN2                     PID1INLbits.IN2                 // bit 2, shadows bit in PID1INLbits
#define PID1IN3                 PID1INLbits.PID1IN3             // bit 3, shadows bit in PID1INLbits
#define IN3                     PID1INLbits.IN3                 // bit 3, shadows bit in PID1INLbits
#define PID1IN4                 PID1INLbits.PID1IN4             // bit 4, shadows bit in PID1INLbits
#define IN4                     PID1INLbits.IN4                 // bit 4, shadows bit in PID1INLbits
#define PID1IN5                 PID1INLbits.PID1IN5             // bit 5, shadows bit in PID1INLbits
#define IN5                     PID1INLbits.IN5                 // bit 5, shadows bit in PID1INLbits
#define PID1IN6                 PID1INLbits.PID1IN6             // bit 6, shadows bit in PID1INLbits
#define IN6                     PID1INLbits.IN6                 // bit 6, shadows bit in PID1INLbits
#define PID1IN7                 PID1INLbits.PID1IN7             // bit 7, shadows bit in PID1INLbits
#define IN7                     PID1INLbits.IN7                 // bit 7, shadows bit in PID1INLbits

#define PID1K18                 PID1K1Hbits.PID1K18             // bit 0, shadows bit in PID1K1Hbits
#define K18                     PID1K1Hbits.K18                 // bit 0, shadows bit in PID1K1Hbits
#define PID1K19                 PID1K1Hbits.PID1K19             // bit 1, shadows bit in PID1K1Hbits
#define K19                     PID1K1Hbits.K19                 // bit 1, shadows bit in PID1K1Hbits
#define PID1K110                PID1K1Hbits.PID1K110            // bit 2, shadows bit in PID1K1Hbits
#define K110                    PID1K1Hbits.K110                // bit 2, shadows bit in PID1K1Hbits
#define PID1K111                PID1K1Hbits.PID1K111            // bit 3, shadows bit in PID1K1Hbits
#define K111                    PID1K1Hbits.K111                // bit 3, shadows bit in PID1K1Hbits
#define PID1K112                PID1K1Hbits.PID1K112            // bit 4, shadows bit in PID1K1Hbits
#define K112                    PID1K1Hbits.K112                // bit 4, shadows bit in PID1K1Hbits
#define PID1K113                PID1K1Hbits.PID1K113            // bit 5, shadows bit in PID1K1Hbits
#define K113                    PID1K1Hbits.K113                // bit 5, shadows bit in PID1K1Hbits
#define PID1K114                PID1K1Hbits.PID1K114            // bit 6, shadows bit in PID1K1Hbits
#define K114                    PID1K1Hbits.K114                // bit 6, shadows bit in PID1K1Hbits
#define PID1K115                PID1K1Hbits.PID1K115            // bit 7, shadows bit in PID1K1Hbits
#define K115                    PID1K1Hbits.K115                // bit 7, shadows bit in PID1K1Hbits

#define PID1K10                 PID1K1Lbits.PID1K10             // bit 0, shadows bit in PID1K1Lbits
#define K10                     PID1K1Lbits.K10                 // bit 0, shadows bit in PID1K1Lbits
#define PID1K11                 PID1K1Lbits.PID1K11             // bit 1, shadows bit in PID1K1Lbits
#define K11                     PID1K1Lbits.K11                 // bit 1, shadows bit in PID1K1Lbits
#define PID1K12                 PID1K1Lbits.PID1K12             // bit 2, shadows bit in PID1K1Lbits
#define K12                     PID1K1Lbits.K12                 // bit 2, shadows bit in PID1K1Lbits
#define PID1K13                 PID1K1Lbits.PID1K13             // bit 3, shadows bit in PID1K1Lbits
#define K13                     PID1K1Lbits.K13                 // bit 3, shadows bit in PID1K1Lbits
#define PID1K14                 PID1K1Lbits.PID1K14             // bit 4, shadows bit in PID1K1Lbits
#define K14                     PID1K1Lbits.K14                 // bit 4, shadows bit in PID1K1Lbits
#define PID1K15                 PID1K1Lbits.PID1K15             // bit 5, shadows bit in PID1K1Lbits
#define K15                     PID1K1Lbits.K15                 // bit 5, shadows bit in PID1K1Lbits
#define PID1K16                 PID1K1Lbits.PID1K16             // bit 6, shadows bit in PID1K1Lbits
#define K16                     PID1K1Lbits.K16                 // bit 6, shadows bit in PID1K1Lbits
#define PID1K17                 PID1K1Lbits.PID1K17             // bit 7, shadows bit in PID1K1Lbits
#define K17                     PID1K1Lbits.K17                 // bit 7, shadows bit in PID1K1Lbits

#define PID1K28                 PID1K2Hbits.PID1K28             // bit 0, shadows bit in PID1K2Hbits
#define K28                     PID1K2Hbits.K28                 // bit 0, shadows bit in PID1K2Hbits
#define PID1K29                 PID1K2Hbits.PID1K29             // bit 1, shadows bit in PID1K2Hbits
#define K29                     PID1K2Hbits.K29                 // bit 1, shadows bit in PID1K2Hbits
#define PID1K210                PID1K2Hbits.PID1K210            // bit 2, shadows bit in PID1K2Hbits
#define K210                    PID1K2Hbits.K210                // bit 2, shadows bit in PID1K2Hbits
#define PID1K211                PID1K2Hbits.PID1K211            // bit 3, shadows bit in PID1K2Hbits
#define K211                    PID1K2Hbits.K211                // bit 3, shadows bit in PID1K2Hbits
#define PID1K212                PID1K2Hbits.PID1K212            // bit 4, shadows bit in PID1K2Hbits
#define K212                    PID1K2Hbits.K212                // bit 4, shadows bit in PID1K2Hbits
#define PID1K213                PID1K2Hbits.PID1K213            // bit 5, shadows bit in PID1K2Hbits
#define K213                    PID1K2Hbits.K213                // bit 5, shadows bit in PID1K2Hbits
#define PID1K214                PID1K2Hbits.PID1K214            // bit 6, shadows bit in PID1K2Hbits
#define K214                    PID1K2Hbits.K214                // bit 6, shadows bit in PID1K2Hbits
#define PID1K215                PID1K2Hbits.PID1K215            // bit 7, shadows bit in PID1K2Hbits
#define K215                    PID1K2Hbits.K215                // bit 7, shadows bit in PID1K2Hbits

#define PID1K20                 PID1K2Lbits.PID1K20             // bit 0, shadows bit in PID1K2Lbits
#define K20                     PID1K2Lbits.K20                 // bit 0, shadows bit in PID1K2Lbits
#define PID1K21                 PID1K2Lbits.PID1K21             // bit 1, shadows bit in PID1K2Lbits
#define K21                     PID1K2Lbits.K21                 // bit 1, shadows bit in PID1K2Lbits
#define PID1K22                 PID1K2Lbits.PID1K22             // bit 2, shadows bit in PID1K2Lbits
#define K22                     PID1K2Lbits.K22                 // bit 2, shadows bit in PID1K2Lbits
#define PID1K23                 PID1K2Lbits.PID1K23             // bit 3, shadows bit in PID1K2Lbits
#define K23                     PID1K2Lbits.K23                 // bit 3, shadows bit in PID1K2Lbits
#define PID1K24                 PID1K2Lbits.PID1K24             // bit 4, shadows bit in PID1K2Lbits
#define K24                     PID1K2Lbits.K24                 // bit 4, shadows bit in PID1K2Lbits
#define PID1K25                 PID1K2Lbits.PID1K25             // bit 5, shadows bit in PID1K2Lbits
#define K25                     PID1K2Lbits.K25                 // bit 5, shadows bit in PID1K2Lbits
#define PID1K26                 PID1K2Lbits.PID1K26             // bit 6, shadows bit in PID1K2Lbits
#define K26                     PID1K2Lbits.K26                 // bit 6, shadows bit in PID1K2Lbits
#define PID1K27                 PID1K2Lbits.PID1K27             // bit 7, shadows bit in PID1K2Lbits
#define K27                     PID1K2Lbits.K27                 // bit 7, shadows bit in PID1K2Lbits

#define PID1K38                 PID1K3Hbits.PID1K38             // bit 0, shadows bit in PID1K3Hbits
#define K38                     PID1K3Hbits.K38                 // bit 0, shadows bit in PID1K3Hbits
#define PID1K39                 PID1K3Hbits.PID1K39             // bit 1, shadows bit in PID1K3Hbits
#define K39                     PID1K3Hbits.K39                 // bit 1, shadows bit in PID1K3Hbits
#define PID1K310                PID1K3Hbits.PID1K310            // bit 2, shadows bit in PID1K3Hbits
#define K310                    PID1K3Hbits.K310                // bit 2, shadows bit in PID1K3Hbits
#define PID1K311                PID1K3Hbits.PID1K311            // bit 3, shadows bit in PID1K3Hbits
#define K311                    PID1K3Hbits.K311                // bit 3, shadows bit in PID1K3Hbits
#define PID1K312                PID1K3Hbits.PID1K312            // bit 4, shadows bit in PID1K3Hbits
#define K312                    PID1K3Hbits.K312                // bit 4, shadows bit in PID1K3Hbits
#define PID1K313                PID1K3Hbits.PID1K313            // bit 5, shadows bit in PID1K3Hbits
#define K313                    PID1K3Hbits.K313                // bit 5, shadows bit in PID1K3Hbits
#define PID1K314                PID1K3Hbits.PID1K314            // bit 6, shadows bit in PID1K3Hbits
#define K314                    PID1K3Hbits.K314                // bit 6, shadows bit in PID1K3Hbits
#define PID1K315                PID1K3Hbits.PID1K315            // bit 7, shadows bit in PID1K3Hbits
#define K315                    PID1K3Hbits.K315                // bit 7, shadows bit in PID1K3Hbits

#define PID1K30                 PID1K3Lbits.PID1K30             // bit 0, shadows bit in PID1K3Lbits
#define K30                     PID1K3Lbits.K30                 // bit 0, shadows bit in PID1K3Lbits
#define PID1K31                 PID1K3Lbits.PID1K31             // bit 1, shadows bit in PID1K3Lbits
#define K31                     PID1K3Lbits.K31                 // bit 1, shadows bit in PID1K3Lbits
#define PID1K32                 PID1K3Lbits.PID1K32             // bit 2, shadows bit in PID1K3Lbits
#define K32                     PID1K3Lbits.K32                 // bit 2, shadows bit in PID1K3Lbits
#define PID1K33                 PID1K3Lbits.PID1K33             // bit 3, shadows bit in PID1K3Lbits
#define K33                     PID1K3Lbits.K33                 // bit 3, shadows bit in PID1K3Lbits
#define PID1K34                 PID1K3Lbits.PID1K34             // bit 4, shadows bit in PID1K3Lbits
#define K34                     PID1K3Lbits.K34                 // bit 4, shadows bit in PID1K3Lbits
#define PID1K35                 PID1K3Lbits.PID1K35             // bit 5, shadows bit in PID1K3Lbits
#define K35                     PID1K3Lbits.K35                 // bit 5, shadows bit in PID1K3Lbits
#define PID1K36                 PID1K3Lbits.PID1K36             // bit 6, shadows bit in PID1K3Lbits
#define K36                     PID1K3Lbits.K36                 // bit 6, shadows bit in PID1K3Lbits
#define PID1K37                 PID1K3Lbits.PID1K37             // bit 7, shadows bit in PID1K3Lbits
#define K37                     PID1K3Lbits.K37                 // bit 7, shadows bit in PID1K3Lbits

#define PID1OUT24               PID1OUTHHbits.PID1OUT24         // bit 0, shadows bit in PID1OUTHHbits
#define OUT24                   PID1OUTHHbits.OUT24             // bit 0, shadows bit in PID1OUTHHbits
#define PID1OUT25               PID1OUTHHbits.PID1OUT25         // bit 1, shadows bit in PID1OUTHHbits
#define OUT25                   PID1OUTHHbits.OUT25             // bit 1, shadows bit in PID1OUTHHbits
#define PID1OUT26               PID1OUTHHbits.PID1OUT26         // bit 2, shadows bit in PID1OUTHHbits
#define OUT26                   PID1OUTHHbits.OUT26             // bit 2, shadows bit in PID1OUTHHbits
#define PID1OUT27               PID1OUTHHbits.PID1OUT27         // bit 3, shadows bit in PID1OUTHHbits
#define OUT27                   PID1OUTHHbits.OUT27             // bit 3, shadows bit in PID1OUTHHbits
#define PID1OUT28               PID1OUTHHbits.PID1OUT28         // bit 4, shadows bit in PID1OUTHHbits
#define OUT28                   PID1OUTHHbits.OUT28             // bit 4, shadows bit in PID1OUTHHbits
#define PID1OUT29               PID1OUTHHbits.PID1OUT29         // bit 5, shadows bit in PID1OUTHHbits
#define OUT29                   PID1OUTHHbits.OUT29             // bit 5, shadows bit in PID1OUTHHbits
#define PID1OUT30               PID1OUTHHbits.PID1OUT30         // bit 6, shadows bit in PID1OUTHHbits
#define OUT30                   PID1OUTHHbits.OUT30             // bit 6, shadows bit in PID1OUTHHbits
#define PID1OUT31               PID1OUTHHbits.PID1OUT31         // bit 7, shadows bit in PID1OUTHHbits
#define OUT31                   PID1OUTHHbits.OUT31             // bit 7, shadows bit in PID1OUTHHbits

#define PID1OUT16               PID1OUTHLbits.PID1OUT16         // bit 0, shadows bit in PID1OUTHLbits
#define OUT16                   PID1OUTHLbits.OUT16             // bit 0, shadows bit in PID1OUTHLbits
#define PID1OUT17               PID1OUTHLbits.PID1OUT17         // bit 1, shadows bit in PID1OUTHLbits
#define OUT17                   PID1OUTHLbits.OUT17             // bit 1, shadows bit in PID1OUTHLbits
#define PID1OUT18               PID1OUTHLbits.PID1OUT18         // bit 2, shadows bit in PID1OUTHLbits
#define OUT18                   PID1OUTHLbits.OUT18             // bit 2, shadows bit in PID1OUTHLbits
#define PID1OUT19               PID1OUTHLbits.PID1OUT19         // bit 3, shadows bit in PID1OUTHLbits
#define OUT19                   PID1OUTHLbits.OUT19             // bit 3, shadows bit in PID1OUTHLbits
#define PID1OUT20               PID1OUTHLbits.PID1OUT20         // bit 4, shadows bit in PID1OUTHLbits
#define OUT20                   PID1OUTHLbits.OUT20             // bit 4, shadows bit in PID1OUTHLbits
#define PID1OUT21               PID1OUTHLbits.PID1OUT21         // bit 5, shadows bit in PID1OUTHLbits
#define OUT21                   PID1OUTHLbits.OUT21             // bit 5, shadows bit in PID1OUTHLbits
#define PID1OUT22               PID1OUTHLbits.PID1OUT22         // bit 6, shadows bit in PID1OUTHLbits
#define OUT22                   PID1OUTHLbits.OUT22             // bit 6, shadows bit in PID1OUTHLbits
#define PID1OUT23               PID1OUTHLbits.PID1OUT23         // bit 7, shadows bit in PID1OUTHLbits
#define OUT23                   PID1OUTHLbits.OUT23             // bit 7, shadows bit in PID1OUTHLbits

#define PID1OUT8                PID1OUTLHbits.PID1OUT8          // bit 0, shadows bit in PID1OUTLHbits
#define OUT8                    PID1OUTLHbits.OUT8              // bit 0, shadows bit in PID1OUTLHbits
#define PID1OUT9                PID1OUTLHbits.PID1OUT9          // bit 1, shadows bit in PID1OUTLHbits
#define OUT9                    PID1OUTLHbits.OUT9              // bit 1, shadows bit in PID1OUTLHbits
#define PID1OUT10               PID1OUTLHbits.PID1OUT10         // bit 2, shadows bit in PID1OUTLHbits
#define OUT10                   PID1OUTLHbits.OUT10             // bit 2, shadows bit in PID1OUTLHbits
#define PID1OUT11               PID1OUTLHbits.PID1OUT11         // bit 3, shadows bit in PID1OUTLHbits
#define OUT11                   PID1OUTLHbits.OUT11             // bit 3, shadows bit in PID1OUTLHbits
#define PID1OUT12               PID1OUTLHbits.PID1OUT12         // bit 4, shadows bit in PID1OUTLHbits
#define OUT12                   PID1OUTLHbits.OUT12             // bit 4, shadows bit in PID1OUTLHbits
#define PID1OUT13               PID1OUTLHbits.PID1OUT13         // bit 5, shadows bit in PID1OUTLHbits
#define OUT13                   PID1OUTLHbits.OUT13             // bit 5, shadows bit in PID1OUTLHbits
#define PID1OUT14               PID1OUTLHbits.PID1OUT14         // bit 6, shadows bit in PID1OUTLHbits
#define OUT14                   PID1OUTLHbits.OUT14             // bit 6, shadows bit in PID1OUTLHbits
#define PID1OUT15               PID1OUTLHbits.PID1OUT15         // bit 7, shadows bit in PID1OUTLHbits
#define OUT15                   PID1OUTLHbits.OUT15             // bit 7, shadows bit in PID1OUTLHbits

#define PID1OUT0                PID1OUTLLbits.PID1OUT0          // bit 0, shadows bit in PID1OUTLLbits
#define OUT0                    PID1OUTLLbits.OUT0              // bit 0, shadows bit in PID1OUTLLbits
#define PID1OUT1                PID1OUTLLbits.PID1OUT1          // bit 1, shadows bit in PID1OUTLLbits
#define OUT1                    PID1OUTLLbits.OUT1              // bit 1, shadows bit in PID1OUTLLbits
#define PID1OUT2                PID1OUTLLbits.PID1OUT2          // bit 2, shadows bit in PID1OUTLLbits
#define OUT2                    PID1OUTLLbits.OUT2              // bit 2, shadows bit in PID1OUTLLbits
#define PID1OUT3                PID1OUTLLbits.PID1OUT3          // bit 3, shadows bit in PID1OUTLLbits
#define OUT3                    PID1OUTLLbits.OUT3              // bit 3, shadows bit in PID1OUTLLbits
#define PID1OUT4                PID1OUTLLbits.PID1OUT4          // bit 4, shadows bit in PID1OUTLLbits
#define OUT4                    PID1OUTLLbits.OUT4              // bit 4, shadows bit in PID1OUTLLbits
#define PID1OUT5                PID1OUTLLbits.PID1OUT5          // bit 5, shadows bit in PID1OUTLLbits
#define OUT5                    PID1OUTLLbits.OUT5              // bit 5, shadows bit in PID1OUTLLbits
#define PID1OUT6                PID1OUTLLbits.PID1OUT6          // bit 6, shadows bit in PID1OUTLLbits
#define OUT6                    PID1OUTLLbits.OUT6              // bit 6, shadows bit in PID1OUTLLbits
#define PID1OUT7                PID1OUTLLbits.PID1OUT7          // bit 7, shadows bit in PID1OUTLLbits
#define OUT7                    PID1OUTLLbits.OUT7              // bit 7, shadows bit in PID1OUTLLbits

#define PID1OUT32               PID1OUTUbits.PID1OUT32          // bit 0, shadows bit in PID1OUTUbits
#define OUT32                   PID1OUTUbits.OUT32              // bit 0, shadows bit in PID1OUTUbits
#define PID1OUT33               PID1OUTUbits.PID1OUT33          // bit 1, shadows bit in PID1OUTUbits
#define OUT33                   PID1OUTUbits.OUT33              // bit 1, shadows bit in PID1OUTUbits
#define PID1OUT34               PID1OUTUbits.PID1OUT34          // bit 2, shadows bit in PID1OUTUbits
#define OUT34                   PID1OUTUbits.OUT34              // bit 2, shadows bit in PID1OUTUbits
#define PID1OUT35               PID1OUTUbits.PID1OUT35          // bit 3, shadows bit in PID1OUTUbits
#define OUT35                   PID1OUTUbits.OUT35              // bit 3, shadows bit in PID1OUTUbits

#define PID1SET8                PID1SETHbits.PID1SET8           // bit 0, shadows bit in PID1SETHbits
#define SET8                    PID1SETHbits.SET8               // bit 0, shadows bit in PID1SETHbits
#define PID1SET9                PID1SETHbits.PID1SET9           // bit 1, shadows bit in PID1SETHbits
#define SET9                    PID1SETHbits.SET9               // bit 1, shadows bit in PID1SETHbits
#define PID1SET10               PID1SETHbits.PID1SET10          // bit 2, shadows bit in PID1SETHbits
#define SET10                   PID1SETHbits.SET10              // bit 2, shadows bit in PID1SETHbits
#define PID1SET11               PID1SETHbits.PID1SET11          // bit 3, shadows bit in PID1SETHbits
#define SET11                   PID1SETHbits.SET11              // bit 3, shadows bit in PID1SETHbits
#define PID1SET12               PID1SETHbits.PID1SET12          // bit 4, shadows bit in PID1SETHbits
#define SET12                   PID1SETHbits.SET12              // bit 4, shadows bit in PID1SETHbits
#define PID1SET13               PID1SETHbits.PID1SET13          // bit 5, shadows bit in PID1SETHbits
#define SET13                   PID1SETHbits.SET13              // bit 5, shadows bit in PID1SETHbits
#define PID1SET14               PID1SETHbits.PID1SET14          // bit 6, shadows bit in PID1SETHbits
#define SET14                   PID1SETHbits.SET14              // bit 6, shadows bit in PID1SETHbits
#define PID1SET15               PID1SETHbits.PID1SET15          // bit 7, shadows bit in PID1SETHbits
#define SET15                   PID1SETHbits.SET15              // bit 7, shadows bit in PID1SETHbits

#define PID1SET0                PID1SETLbits.PID1SET0           // bit 0, shadows bit in PID1SETLbits
#define SET0                    PID1SETLbits.SET0               // bit 0, shadows bit in PID1SETLbits
#define PID1SET1                PID1SETLbits.PID1SET1           // bit 1, shadows bit in PID1SETLbits
#define SET1                    PID1SETLbits.SET1               // bit 1, shadows bit in PID1SETLbits
#define PID1SET2                PID1SETLbits.PID1SET2           // bit 2, shadows bit in PID1SETLbits
#define SET2                    PID1SETLbits.SET2               // bit 2, shadows bit in PID1SETLbits
#define PID1SET3                PID1SETLbits.PID1SET3           // bit 3, shadows bit in PID1SETLbits
#define SET3                    PID1SETLbits.SET3               // bit 3, shadows bit in PID1SETLbits
#define PID1SET4                PID1SETLbits.PID1SET4           // bit 4, shadows bit in PID1SETLbits
#define SET4                    PID1SETLbits.SET4               // bit 4, shadows bit in PID1SETLbits
#define PID1SET5                PID1SETLbits.PID1SET5           // bit 5, shadows bit in PID1SETLbits
#define SET5                    PID1SETLbits.SET5               // bit 5, shadows bit in PID1SETLbits
#define PID1SET6                PID1SETLbits.PID1SET6           // bit 6, shadows bit in PID1SETLbits
#define SET6                    PID1SETLbits.SET6               // bit 6, shadows bit in PID1SETLbits
#define PID1SET7                PID1SETLbits.PID1SET7           // bit 7, shadows bit in PID1SETLbits
#define SET7                    PID1SETLbits.SET7               // bit 7, shadows bit in PID1SETLbits

#define PID1Z18                 PID1Z1Hbits.PID1Z18             // bit 0, shadows bit in PID1Z1Hbits
#define Z18                     PID1Z1Hbits.Z18                 // bit 0, shadows bit in PID1Z1Hbits
#define PID1Z19                 PID1Z1Hbits.PID1Z19             // bit 1, shadows bit in PID1Z1Hbits
#define Z19                     PID1Z1Hbits.Z19                 // bit 1, shadows bit in PID1Z1Hbits
#define PID1Z110                PID1Z1Hbits.PID1Z110            // bit 2, shadows bit in PID1Z1Hbits
#define Z110                    PID1Z1Hbits.Z110                // bit 2, shadows bit in PID1Z1Hbits
#define PID1Z111                PID1Z1Hbits.PID1Z111            // bit 3, shadows bit in PID1Z1Hbits
#define Z111                    PID1Z1Hbits.Z111                // bit 3, shadows bit in PID1Z1Hbits
#define PID1Z112                PID1Z1Hbits.PID1Z112            // bit 4, shadows bit in PID1Z1Hbits
#define Z112                    PID1Z1Hbits.Z112                // bit 4, shadows bit in PID1Z1Hbits
#define PID1Z113                PID1Z1Hbits.PID1Z113            // bit 5, shadows bit in PID1Z1Hbits
#define Z113                    PID1Z1Hbits.Z113                // bit 5, shadows bit in PID1Z1Hbits
#define PID1Z114                PID1Z1Hbits.PID1Z114            // bit 6, shadows bit in PID1Z1Hbits
#define Z114                    PID1Z1Hbits.Z114                // bit 6, shadows bit in PID1Z1Hbits
#define PID1Z115                PID1Z1Hbits.PID1Z115            // bit 7, shadows bit in PID1Z1Hbits
#define Z115                    PID1Z1Hbits.Z115                // bit 7, shadows bit in PID1Z1Hbits

#define PID1Z10                 PID1Z1Lbits.PID1Z10             // bit 0, shadows bit in PID1Z1Lbits
#define Z10                     PID1Z1Lbits.Z10                 // bit 0, shadows bit in PID1Z1Lbits
#define PID1Z11                 PID1Z1Lbits.PID1Z11             // bit 1, shadows bit in PID1Z1Lbits
#define Z11                     PID1Z1Lbits.Z11                 // bit 1, shadows bit in PID1Z1Lbits
#define PID1Z12                 PID1Z1Lbits.PID1Z12             // bit 2, shadows bit in PID1Z1Lbits
#define Z12                     PID1Z1Lbits.Z12                 // bit 2, shadows bit in PID1Z1Lbits
#define PID1Z13                 PID1Z1Lbits.PID1Z13             // bit 3, shadows bit in PID1Z1Lbits
#define Z13                     PID1Z1Lbits.Z13                 // bit 3, shadows bit in PID1Z1Lbits
#define PID1Z14                 PID1Z1Lbits.PID1Z14             // bit 4, shadows bit in PID1Z1Lbits
#define Z14                     PID1Z1Lbits.Z14                 // bit 4, shadows bit in PID1Z1Lbits
#define PID1Z15                 PID1Z1Lbits.PID1Z15             // bit 5, shadows bit in PID1Z1Lbits
#define Z15                     PID1Z1Lbits.Z15                 // bit 5, shadows bit in PID1Z1Lbits
#define PID1Z16                 PID1Z1Lbits.PID1Z16             // bit 6, shadows bit in PID1Z1Lbits
#define Z16                     PID1Z1Lbits.Z16                 // bit 6, shadows bit in PID1Z1Lbits
#define PID1Z17                 PID1Z1Lbits.PID1Z17             // bit 7, shadows bit in PID1Z1Lbits
#define Z17                     PID1Z1Lbits.Z17                 // bit 7, shadows bit in PID1Z1Lbits

#define PID1Z116                PID1Z1Ubits.PID1Z116            // bit 0, shadows bit in PID1Z1Ubits
#define Z116                    PID1Z1Ubits.Z116                // bit 0, shadows bit in PID1Z1Ubits

#define PID1Z28                 PID1Z2Hbits.PID1Z28             // bit 0, shadows bit in PID1Z2Hbits
#define Z28                     PID1Z2Hbits.Z28                 // bit 0, shadows bit in PID1Z2Hbits
#define PID1Z29                 PID1Z2Hbits.PID1Z29             // bit 1, shadows bit in PID1Z2Hbits
#define Z29                     PID1Z2Hbits.Z29                 // bit 1, shadows bit in PID1Z2Hbits
#define PID1Z210                PID1Z2Hbits.PID1Z210            // bit 2, shadows bit in PID1Z2Hbits
#define Z210                    PID1Z2Hbits.Z210                // bit 2, shadows bit in PID1Z2Hbits
#define PID1Z211                PID1Z2Hbits.PID1Z211            // bit 3, shadows bit in PID1Z2Hbits
#define Z211                    PID1Z2Hbits.Z211                // bit 3, shadows bit in PID1Z2Hbits
#define PID1Z212                PID1Z2Hbits.PID1Z212            // bit 4, shadows bit in PID1Z2Hbits
#define Z212                    PID1Z2Hbits.Z212                // bit 4, shadows bit in PID1Z2Hbits
#define PID1Z213                PID1Z2Hbits.PID1Z213            // bit 5, shadows bit in PID1Z2Hbits
#define Z213                    PID1Z2Hbits.Z213                // bit 5, shadows bit in PID1Z2Hbits
#define PID1Z214                PID1Z2Hbits.PID1Z214            // bit 6, shadows bit in PID1Z2Hbits
#define Z214                    PID1Z2Hbits.Z214                // bit 6, shadows bit in PID1Z2Hbits
#define PID1Z215                PID1Z2Hbits.PID1Z215            // bit 7, shadows bit in PID1Z2Hbits
#define Z215                    PID1Z2Hbits.Z215                // bit 7, shadows bit in PID1Z2Hbits

#define PID1Z20                 PID1Z2Lbits.PID1Z20             // bit 0, shadows bit in PID1Z2Lbits
#define Z20                     PID1Z2Lbits.Z20                 // bit 0, shadows bit in PID1Z2Lbits
#define PID1Z21                 PID1Z2Lbits.PID1Z21             // bit 1, shadows bit in PID1Z2Lbits
#define Z21                     PID1Z2Lbits.Z21                 // bit 1, shadows bit in PID1Z2Lbits
#define PID1Z22                 PID1Z2Lbits.PID1Z22             // bit 2, shadows bit in PID1Z2Lbits
#define Z22                     PID1Z2Lbits.Z22                 // bit 2, shadows bit in PID1Z2Lbits
#define PID1Z23                 PID1Z2Lbits.PID1Z23             // bit 3, shadows bit in PID1Z2Lbits
#define Z23                     PID1Z2Lbits.Z23                 // bit 3, shadows bit in PID1Z2Lbits
#define PID1Z24                 PID1Z2Lbits.PID1Z24             // bit 4, shadows bit in PID1Z2Lbits
#define Z24                     PID1Z2Lbits.Z24                 // bit 4, shadows bit in PID1Z2Lbits
#define PID1Z25                 PID1Z2Lbits.PID1Z25             // bit 5, shadows bit in PID1Z2Lbits
#define Z25                     PID1Z2Lbits.Z25                 // bit 5, shadows bit in PID1Z2Lbits
#define PID1Z26                 PID1Z2Lbits.PID1Z26             // bit 6, shadows bit in PID1Z2Lbits
#define Z26                     PID1Z2Lbits.Z26                 // bit 6, shadows bit in PID1Z2Lbits
#define PID1Z27                 PID1Z2Lbits.PID1Z27             // bit 7, shadows bit in PID1Z2Lbits
#define Z27                     PID1Z2Lbits.Z27                 // bit 7, shadows bit in PID1Z2Lbits

#define PID1Z216                PID1Z2Ubits.PID1Z216            // bit 0, shadows bit in PID1Z2Ubits
#define Z216                    PID1Z2Ubits.Z216                // bit 0, shadows bit in PID1Z2Ubits

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define SSP1IE                  PIE1bits.SSP1IE                 // bit 3
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define CCP2IE                  PIE2bits.CCP2IE                 // bit 0
#define TMR4IE                  PIE2bits.TMR4IE                 // bit 1
#define TMR6IE                  PIE2bits.TMR6IE                 // bit 2
#define BCL1IE                  PIE2bits.BCL1IE                 // bit 3
#define C1IE                    PIE2bits.C1IE                   // bit 5
#define C2IE                    PIE2bits.C2IE                   // bit 6
#define OSCFIE                  PIE2bits.OSCFIE                 // bit 7

#define CLC1IE                  PIE3bits.CLC1IE                 // bit 0
#define CLC2IE                  PIE3bits.CLC2IE                 // bit 1
#define CLC3IE                  PIE3bits.CLC3IE                 // bit 2
#define CLC4IE                  PIE3bits.CLC4IE                 // bit 3
#define ZCDIE                   PIE3bits.ZCDIE                  // bit 4
#define CWGIE                   PIE3bits.CWGIE                  // bit 5

#define SMT1IE                  PIE4bits.SMT1IE                 // bit 0
#define SMT1PRAIE               PIE4bits.SMT1PRAIE              // bit 1
#define SMT1PWAIE               PIE4bits.SMT1PWAIE              // bit 2
#define SMT2IE                  PIE4bits.SMT2IE                 // bit 3
#define SMT2PRAIE               PIE4bits.SMT2PRAIE              // bit 4
#define SMT2PWAIE               PIE4bits.SMT2PWAIE              // bit 5
#define CRCIE                   PIE4bits.CRCIE                  // bit 6
#define SCANIE                  PIE4bits.SCANIE                 // bit 7

#define PID1DIE                 PIE5bits.PID1DIE                // bit 0
#define PID1EIE                 PIE5bits.PID1EIE                // bit 1
#define AT1IE                   PIE5bits.AT1IE                  // bit 2
#define TMR5IE                  PIE5bits.TMR5IE                 // bit 4
#define TMR5GIE                 PIE5bits.TMR5GIE                // bit 5
#define TMR3IE                  PIE5bits.TMR3IE                 // bit 6
#define TMR3GIE                 PIE5bits.TMR3GIE                // bit 7

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define SSP1IF                  PIR1bits.SSP1IF                 // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define CCP2IF                  PIR2bits.CCP2IF                 // bit 0
#define TMR4IF                  PIR2bits.TMR4IF                 // bit 1
#define TMR6IF                  PIR2bits.TMR6IF                 // bit 2
#define BCL1IF                  PIR2bits.BCL1IF                 // bit 3
#define C1IF                    PIR2bits.C1IF                   // bit 5
#define C2IF                    PIR2bits.C2IF                   // bit 6
#define OSFIF                   PIR2bits.OSFIF                  // bit 7

#define CLC1IF                  PIR3bits.CLC1IF                 // bit 0
#define CLC2IF                  PIR3bits.CLC2IF                 // bit 1
#define CLC3IF                  PIR3bits.CLC3IF                 // bit 2
#define CLC4IF                  PIR3bits.CLC4IF                 // bit 3
#define ZCDIF                   PIR3bits.ZCDIF                  // bit 4
#define CWGIF                   PIR3bits.CWGIF                  // bit 5

#define SMT1IF                  PIR4bits.SMT1IF                 // bit 0
#define SMT1PRAIF               PIR4bits.SMT1PRAIF              // bit 1
#define SMT1PWAIF               PIR4bits.SMT1PWAIF              // bit 2
#define SMT2IF                  PIR4bits.SMT2IF                 // bit 3
#define SMT2PRAIF               PIR4bits.SMT2PRAIF              // bit 4
#define SMT2PWAIF               PIR4bits.SMT2PWAIF              // bit 5
#define CRCIF                   PIR4bits.CRCIF                  // bit 6
#define SCANIF                  PIR4bits.SCANIF                 // bit 7

#define PID1DIF                 PIR5bits.PID1DIF                // bit 0
#define PID1EIF                 PIR5bits.PID1EIF                // bit 1
#define AT1IF                   PIR5bits.AT1IF                  // bit 2
#define TMR5IF                  PIR5bits.TMR5IF                 // bit 4
#define TMR5GIF                 PIR5bits.TMR5GIF                // bit 5
#define TMR3IF                  PIR5bits.TMR3IF                 // bit 6
#define TMR3GIF                 PIR5bits.TMR3GIF                // bit 7

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define PPSLOCKED               PPSLOCKbits.PPSLOCKED           // bit 0

#define DC2                     PWM3DCHbits.DC2                 // bit 0, shadows bit in PWM3DCHbits
#define PWM3DC2                 PWM3DCHbits.PWM3DC2             // bit 0, shadows bit in PWM3DCHbits
#define PWMPW2                  PWM3DCHbits.PWMPW2              // bit 0, shadows bit in PWM3DCHbits
#define DC3                     PWM3DCHbits.DC3                 // bit 1, shadows bit in PWM3DCHbits
#define PWM3DC3                 PWM3DCHbits.PWM3DC3             // bit 1, shadows bit in PWM3DCHbits
#define PWMPW3                  PWM3DCHbits.PWMPW3              // bit 1, shadows bit in PWM3DCHbits
#define DC4                     PWM3DCHbits.DC4                 // bit 2, shadows bit in PWM3DCHbits
#define PWM3DC4                 PWM3DCHbits.PWM3DC4             // bit 2, shadows bit in PWM3DCHbits
#define PWMPW4                  PWM3DCHbits.PWMPW4              // bit 2, shadows bit in PWM3DCHbits
#define DC5                     PWM3DCHbits.DC5                 // bit 3, shadows bit in PWM3DCHbits
#define PWM3DC5                 PWM3DCHbits.PWM3DC5             // bit 3, shadows bit in PWM3DCHbits
#define PWMPW5                  PWM3DCHbits.PWMPW5              // bit 3, shadows bit in PWM3DCHbits
#define DC6                     PWM3DCHbits.DC6                 // bit 4, shadows bit in PWM3DCHbits
#define PWM3DC6                 PWM3DCHbits.PWM3DC6             // bit 4, shadows bit in PWM3DCHbits
#define PWMPW6                  PWM3DCHbits.PWMPW6              // bit 4, shadows bit in PWM3DCHbits
#define DC7                     PWM3DCHbits.DC7                 // bit 5, shadows bit in PWM3DCHbits
#define PWM3DC7                 PWM3DCHbits.PWM3DC7             // bit 5, shadows bit in PWM3DCHbits
#define PWMPW7                  PWM3DCHbits.PWMPW7              // bit 5, shadows bit in PWM3DCHbits
#define DC8                     PWM3DCHbits.DC8                 // bit 6, shadows bit in PWM3DCHbits
#define PWM3DC8                 PWM3DCHbits.PWM3DC8             // bit 6, shadows bit in PWM3DCHbits
#define PWMPW8                  PWM3DCHbits.PWMPW8              // bit 6, shadows bit in PWM3DCHbits
#define DC9                     PWM3DCHbits.DC9                 // bit 7, shadows bit in PWM3DCHbits
#define PWM3DC9                 PWM3DCHbits.PWM3DC9             // bit 7, shadows bit in PWM3DCHbits
#define PWMPW9                  PWM3DCHbits.PWMPW9              // bit 7, shadows bit in PWM3DCHbits

#define DC0                     PWM3DCLbits.DC0                 // bit 6, shadows bit in PWM3DCLbits
#define PWM3DC0                 PWM3DCLbits.PWM3DC0             // bit 6, shadows bit in PWM3DCLbits
#define PWMPW0                  PWM3DCLbits.PWMPW0              // bit 6, shadows bit in PWM3DCLbits
#define DC1                     PWM3DCLbits.DC1                 // bit 7, shadows bit in PWM3DCLbits
#define PWM3DC1                 PWM3DCLbits.PWM3DC1             // bit 7, shadows bit in PWM3DCLbits
#define PWMPW1                  PWM3DCLbits.PWMPW1              // bit 7, shadows bit in PWM3DCLbits

#define RA0PPS0                 RA0PPSbits.RA0PPS0              // bit 0
#define RA0PPS1                 RA0PPSbits.RA0PPS1              // bit 1
#define RA0PPS2                 RA0PPSbits.RA0PPS2              // bit 2
#define RA0PPS3                 RA0PPSbits.RA0PPS3              // bit 3
#define RA0PPS4                 RA0PPSbits.RA0PPS4              // bit 4

#define RA1PPS0                 RA1PPSbits.RA1PPS0              // bit 0
#define RA1PPS1                 RA1PPSbits.RA1PPS1              // bit 1
#define RA1PPS2                 RA1PPSbits.RA1PPS2              // bit 2
#define RA1PPS3                 RA1PPSbits.RA1PPS3              // bit 3
#define RA1PPS4                 RA1PPSbits.RA1PPS4              // bit 4

#define RA2PPS0                 RA2PPSbits.RA2PPS0              // bit 0
#define RA2PPS1                 RA2PPSbits.RA2PPS1              // bit 1
#define RA2PPS2                 RA2PPSbits.RA2PPS2              // bit 2
#define RA2PPS3                 RA2PPSbits.RA2PPS3              // bit 3
#define RA2PPS4                 RA2PPSbits.RA2PPS4              // bit 4

#define RA4PPS0                 RA4PPSbits.RA4PPS0              // bit 0
#define RA4PPS1                 RA4PPSbits.RA4PPS1              // bit 1
#define RA4PPS2                 RA4PPSbits.RA4PPS2              // bit 2
#define RA4PPS3                 RA4PPSbits.RA4PPS3              // bit 3
#define RA4PPS4                 RA4PPSbits.RA4PPS4              // bit 4

#define RA5PPS0                 RA5PPSbits.RA5PPS0              // bit 0
#define RA5PPS1                 RA5PPSbits.RA5PPS1              // bit 1
#define RA5PPS2                 RA5PPSbits.RA5PPS2              // bit 2
#define RA5PPS3                 RA5PPSbits.RA5PPS3              // bit 3
#define RA5PPS4                 RA5PPSbits.RA5PPS4              // bit 4

#define RB4PPS0                 RB4PPSbits.RB4PPS0              // bit 0
#define RB4PPS1                 RB4PPSbits.RB4PPS1              // bit 1
#define RB4PPS2                 RB4PPSbits.RB4PPS2              // bit 2
#define RB4PPS3                 RB4PPSbits.RB4PPS3              // bit 3
#define RB4PPS4                 RB4PPSbits.RB4PPS4              // bit 4

#define RB5PPS0                 RB5PPSbits.RB5PPS0              // bit 0
#define RB5PPS1                 RB5PPSbits.RB5PPS1              // bit 1
#define RB5PPS2                 RB5PPSbits.RB5PPS2              // bit 2
#define RB5PPS3                 RB5PPSbits.RB5PPS3              // bit 3
#define RB5PPS4                 RB5PPSbits.RB5PPS4              // bit 4

#define RB6PPS0                 RB6PPSbits.RB6PPS0              // bit 0
#define RB6PPS1                 RB6PPSbits.RB6PPS1              // bit 1
#define RB6PPS2                 RB6PPSbits.RB6PPS2              // bit 2
#define RB6PPS3                 RB6PPSbits.RB6PPS3              // bit 3
#define RB6PPS4                 RB6PPSbits.RB6PPS4              // bit 4

#define RB7PPS0                 RB7PPSbits.RB7PPS0              // bit 0
#define RB7PPS1                 RB7PPSbits.RB7PPS1              // bit 1
#define RB7PPS2                 RB7PPSbits.RB7PPS2              // bit 2
#define RB7PPS3                 RB7PPSbits.RB7PPS3              // bit 3
#define RB7PPS4                 RB7PPSbits.RB7PPS4              // bit 4

#define RC0PPS0                 RC0PPSbits.RC0PPS0              // bit 0
#define RC0PPS1                 RC0PPSbits.RC0PPS1              // bit 1
#define RC0PPS2                 RC0PPSbits.RC0PPS2              // bit 2
#define RC0PPS3                 RC0PPSbits.RC0PPS3              // bit 3
#define RC0PPS4                 RC0PPSbits.RC0PPS4              // bit 4

#define RC1PPS0                 RC1PPSbits.RC1PPS0              // bit 0
#define RC1PPS1                 RC1PPSbits.RC1PPS1              // bit 1
#define RC1PPS2                 RC1PPSbits.RC1PPS2              // bit 2
#define RC1PPS3                 RC1PPSbits.RC1PPS3              // bit 3
#define RC1PPS4                 RC1PPSbits.RC1PPS4              // bit 4

#define RX9D                    RC1STAbits.RX9D                 // bit 0
#define OERR                    RC1STAbits.OERR                 // bit 1
#define FERR                    RC1STAbits.FERR                 // bit 2
#define ADDEN                   RC1STAbits.ADDEN                // bit 3
#define CREN                    RC1STAbits.CREN                 // bit 4
#define SREN                    RC1STAbits.SREN                 // bit 5
#define RX9                     RC1STAbits.RX9                  // bit 6
#define SPEN                    RC1STAbits.SPEN                 // bit 7

#define RC2PPS0                 RC2PPSbits.RC2PPS0              // bit 0
#define RC2PPS1                 RC2PPSbits.RC2PPS1              // bit 1
#define RC2PPS2                 RC2PPSbits.RC2PPS2              // bit 2
#define RC2PPS3                 RC2PPSbits.RC2PPS3              // bit 3
#define RC2PPS4                 RC2PPSbits.RC2PPS4              // bit 4

#define RC3PPS0                 RC3PPSbits.RC3PPS0              // bit 0
#define RC3PPS1                 RC3PPSbits.RC3PPS1              // bit 1
#define RC3PPS2                 RC3PPSbits.RC3PPS2              // bit 2
#define RC3PPS3                 RC3PPSbits.RC3PPS3              // bit 3
#define RC3PPS4                 RC3PPSbits.RC3PPS4              // bit 4

#define RC4PPS0                 RC4PPSbits.RC4PPS0              // bit 0
#define RC4PPS1                 RC4PPSbits.RC4PPS1              // bit 1
#define RC4PPS2                 RC4PPSbits.RC4PPS2              // bit 2
#define RC4PPS3                 RC4PPSbits.RC4PPS3              // bit 3
#define RC4PPS4                 RC4PPSbits.RC4PPS4              // bit 4

#define RC5PPS0                 RC5PPSbits.RC5PPS0              // bit 0
#define RC5PPS1                 RC5PPSbits.RC5PPS1              // bit 1
#define RC5PPS2                 RC5PPSbits.RC5PPS2              // bit 2
#define RC5PPS3                 RC5PPSbits.RC5PPS3              // bit 3
#define RC5PPS4                 RC5PPSbits.RC5PPS4              // bit 4

#define RC6PPS0                 RC6PPSbits.RC6PPS0              // bit 0
#define RC6PPS1                 RC6PPSbits.RC6PPS1              // bit 1
#define RC6PPS2                 RC6PPSbits.RC6PPS2              // bit 2
#define RC6PPS3                 RC6PPSbits.RC6PPS3              // bit 3
#define RC6PPS4                 RC6PPSbits.RC6PPS4              // bit 4

#define RC7PPS0                 RC7PPSbits.RC7PPS0              // bit 0
#define RC7PPS1                 RC7PPSbits.RC7PPS1              // bit 1
#define RC7PPS2                 RC7PPSbits.RC7PPS2              // bit 2
#define RC7PPS3                 RC7PPSbits.RC7PPS3              // bit 3
#define RC7PPS4                 RC7PPSbits.RC7PPS4              // bit 4

#define RXPPS0                  RXPPSbits.RXPPS0                // bit 0
#define RXPPS1                  RXPPSbits.RXPPS1                // bit 1
#define RXPPS2                  RXPPSbits.RXPPS2                // bit 2
#define RXPPS3                  RXPPSbits.RXPPS3                // bit 3
#define RXPPS4                  RXPPSbits.RXPPS4                // bit 4

#define HADR8                   SCANHADRHbits.HADR8             // bit 0, shadows bit in SCANHADRHbits
#define SCANHADR8               SCANHADRHbits.SCANHADR8         // bit 0, shadows bit in SCANHADRHbits
#define HADR9                   SCANHADRHbits.HADR9             // bit 1, shadows bit in SCANHADRHbits
#define SCANHADR9               SCANHADRHbits.SCANHADR9         // bit 1, shadows bit in SCANHADRHbits
#define HADR10                  SCANHADRHbits.HADR10            // bit 2, shadows bit in SCANHADRHbits
#define SCANHADR10              SCANHADRHbits.SCANHADR10        // bit 2, shadows bit in SCANHADRHbits
#define HADR11                  SCANHADRHbits.HADR11            // bit 3, shadows bit in SCANHADRHbits
#define SCANHADR11              SCANHADRHbits.SCANHADR11        // bit 3, shadows bit in SCANHADRHbits
#define HADR12                  SCANHADRHbits.HADR12            // bit 4, shadows bit in SCANHADRHbits
#define SCANHADR12              SCANHADRHbits.SCANHADR12        // bit 4, shadows bit in SCANHADRHbits
#define HADR13                  SCANHADRHbits.HADR13            // bit 5, shadows bit in SCANHADRHbits
#define SCANHADR13              SCANHADRHbits.SCANHADR13        // bit 5, shadows bit in SCANHADRHbits
#define HADR14                  SCANHADRHbits.HADR14            // bit 6, shadows bit in SCANHADRHbits
#define SCANHADR14              SCANHADRHbits.SCANHADR14        // bit 6, shadows bit in SCANHADRHbits
#define HADR15                  SCANHADRHbits.HADR15            // bit 7, shadows bit in SCANHADRHbits
#define SCANHADR15              SCANHADRHbits.SCANHADR15        // bit 7, shadows bit in SCANHADRHbits

#define HADR0                   SCANHADRLbits.HADR0             // bit 0, shadows bit in SCANHADRLbits
#define SCANHADR0               SCANHADRLbits.SCANHADR0         // bit 0, shadows bit in SCANHADRLbits
#define HADR1                   SCANHADRLbits.HADR1             // bit 1, shadows bit in SCANHADRLbits
#define SCANHADR1               SCANHADRLbits.SCANHADR1         // bit 1, shadows bit in SCANHADRLbits
#define HARD2                   SCANHADRLbits.HARD2             // bit 2, shadows bit in SCANHADRLbits
#define SCANHADR2               SCANHADRLbits.SCANHADR2         // bit 2, shadows bit in SCANHADRLbits
#define HADR3                   SCANHADRLbits.HADR3             // bit 3, shadows bit in SCANHADRLbits
#define SCANHADR3               SCANHADRLbits.SCANHADR3         // bit 3, shadows bit in SCANHADRLbits
#define HADR4                   SCANHADRLbits.HADR4             // bit 4, shadows bit in SCANHADRLbits
#define SCANHADR4               SCANHADRLbits.SCANHADR4         // bit 4, shadows bit in SCANHADRLbits
#define HADR5                   SCANHADRLbits.HADR5             // bit 5, shadows bit in SCANHADRLbits
#define SCANHADR5               SCANHADRLbits.SCANHADR5         // bit 5, shadows bit in SCANHADRLbits
#define HADR6                   SCANHADRLbits.HADR6             // bit 6, shadows bit in SCANHADRLbits
#define SCANHADR6               SCANHADRLbits.SCANHADR6         // bit 6, shadows bit in SCANHADRLbits
#define HADR7                   SCANHADRLbits.HADR7             // bit 7, shadows bit in SCANHADRLbits
#define SCANHADR7               SCANHADRLbits.SCANHADR7         // bit 7, shadows bit in SCANHADRLbits

#define LADR8                   SCANLADRHbits.LADR8             // bit 0, shadows bit in SCANLADRHbits
#define SCANLADR8               SCANLADRHbits.SCANLADR8         // bit 0, shadows bit in SCANLADRHbits
#define LADR9                   SCANLADRHbits.LADR9             // bit 1, shadows bit in SCANLADRHbits
#define SCANLADR9               SCANLADRHbits.SCANLADR9         // bit 1, shadows bit in SCANLADRHbits
#define LADR10                  SCANLADRHbits.LADR10            // bit 2, shadows bit in SCANLADRHbits
#define SCANLADR10              SCANLADRHbits.SCANLADR10        // bit 2, shadows bit in SCANLADRHbits
#define LADR11                  SCANLADRHbits.LADR11            // bit 3, shadows bit in SCANLADRHbits
#define SCANLADR11              SCANLADRHbits.SCANLADR11        // bit 3, shadows bit in SCANLADRHbits
#define LADR12                  SCANLADRHbits.LADR12            // bit 4, shadows bit in SCANLADRHbits
#define SCANLADR12              SCANLADRHbits.SCANLADR12        // bit 4, shadows bit in SCANLADRHbits
#define LADR13                  SCANLADRHbits.LADR13            // bit 5, shadows bit in SCANLADRHbits
#define SCANLADR13              SCANLADRHbits.SCANLADR13        // bit 5, shadows bit in SCANLADRHbits
#define LADR14                  SCANLADRHbits.LADR14            // bit 6, shadows bit in SCANLADRHbits
#define SCANLADR14              SCANLADRHbits.SCANLADR14        // bit 6, shadows bit in SCANLADRHbits
#define LADR15                  SCANLADRHbits.LADR15            // bit 7, shadows bit in SCANLADRHbits
#define SCANLADR15              SCANLADRHbits.SCANLADR15        // bit 7, shadows bit in SCANLADRHbits

#define LDAR0                   SCANLADRLbits.LDAR0             // bit 0, shadows bit in SCANLADRLbits
#define SCANLADR0               SCANLADRLbits.SCANLADR0         // bit 0, shadows bit in SCANLADRLbits
#define LDAR1                   SCANLADRLbits.LDAR1             // bit 1, shadows bit in SCANLADRLbits
#define SCANLADR1               SCANLADRLbits.SCANLADR1         // bit 1, shadows bit in SCANLADRLbits
#define LADR2                   SCANLADRLbits.LADR2             // bit 2, shadows bit in SCANLADRLbits
#define SCANLADR2               SCANLADRLbits.SCANLADR2         // bit 2, shadows bit in SCANLADRLbits
#define LADR3                   SCANLADRLbits.LADR3             // bit 3, shadows bit in SCANLADRLbits
#define SCANLADR3               SCANLADRLbits.SCANLADR3         // bit 3, shadows bit in SCANLADRLbits
#define LADR4                   SCANLADRLbits.LADR4             // bit 4, shadows bit in SCANLADRLbits
#define SCANLADR4               SCANLADRLbits.SCANLADR4         // bit 4, shadows bit in SCANLADRLbits
#define LADR5                   SCANLADRLbits.LADR5             // bit 5, shadows bit in SCANLADRLbits
#define SCANLADR5               SCANLADRLbits.SCANLADR5         // bit 5, shadows bit in SCANLADRLbits
#define LADR6                   SCANLADRLbits.LADR6             // bit 6, shadows bit in SCANLADRLbits
#define SCANLADR6               SCANLADRLbits.SCANLADR6         // bit 6, shadows bit in SCANLADRLbits
#define LADR7                   SCANLADRLbits.LADR7             // bit 7, shadows bit in SCANLADRLbits
#define SCANLADR7               SCANLADRLbits.SCANLADR7         // bit 7, shadows bit in SCANLADRLbits

#define TSEL0                   SCANTRIGbits.TSEL0              // bit 0, shadows bit in SCANTRIGbits
#define SCANTSEL0               SCANTRIGbits.SCANTSEL0          // bit 0, shadows bit in SCANTRIGbits
#define TSEL1                   SCANTRIGbits.TSEL1              // bit 1, shadows bit in SCANTRIGbits
#define SCANTSEL1               SCANTRIGbits.SCANTSEL1          // bit 1, shadows bit in SCANTRIGbits
#define TSEL2                   SCANTRIGbits.TSEL2              // bit 2, shadows bit in SCANTRIGbits
#define SCANTSEL2               SCANTRIGbits.SCANTSEL2          // bit 2, shadows bit in SCANTRIGbits
#define TSEL3                   SCANTRIGbits.TSEL3              // bit 3, shadows bit in SCANTRIGbits
#define SCANTSEL3               SCANTRIGbits.SCANTSEL3          // bit 3, shadows bit in SCANTRIGbits

#define SLRA0                   SLRCONAbits.SLRA0               // bit 0
#define SLRA1                   SLRCONAbits.SLRA1               // bit 1
#define SLRA2                   SLRCONAbits.SLRA2               // bit 2
#define SLRA4                   SLRCONAbits.SLRA4               // bit 4
#define SLRA5                   SLRCONAbits.SLRA5               // bit 5

#define SLRB4                   SLRCONBbits.SLRB4               // bit 4
#define SLRB5                   SLRCONBbits.SLRB5               // bit 5
#define SLRB6                   SLRCONBbits.SLRB6               // bit 6
#define SLRB7                   SLRCONBbits.SLRB7               // bit 7

#define SLRC0                   SLRCONCbits.SLRC0               // bit 0
#define SLRC1                   SLRCONCbits.SLRC1               // bit 1
#define SLRC2                   SLRCONCbits.SLRC2               // bit 2
#define SLRC3                   SLRCONCbits.SLRC3               // bit 3
#define SLRC4                   SLRCONCbits.SLRC4               // bit 4
#define SLRC5                   SLRCONCbits.SLRC5               // bit 5
#define SLRC6                   SLRCONCbits.SLRC6               // bit 6
#define SLRC7                   SLRCONCbits.SLRC7               // bit 7

#define CSEL0                   SMT1CLKbits.CSEL0               // bit 0, shadows bit in SMT1CLKbits
#define SMT1CSEL0               SMT1CLKbits.SMT1CSEL0           // bit 0, shadows bit in SMT1CLKbits
#define CSEL1                   SMT1CLKbits.CSEL1               // bit 1, shadows bit in SMT1CLKbits
#define SMT1CSEL1               SMT1CLKbits.SMT1CSEL1           // bit 1, shadows bit in SMT1CLKbits
#define CSEL2                   SMT1CLKbits.CSEL2               // bit 2, shadows bit in SMT1CLKbits
#define SMT1CSEL2               SMT1CLKbits.SMT1CSEL2           // bit 2, shadows bit in SMT1CLKbits

#define SMT1CPR8                SMT1CPRHbits.SMT1CPR8           // bit 0
#define SMT1CPR9                SMT1CPRHbits.SMT1CPR9           // bit 1
#define SMT1CPR10               SMT1CPRHbits.SMT1CPR10          // bit 2
#define SMT1CPR11               SMT1CPRHbits.SMT1CPR11          // bit 3
#define SMT1CPR12               SMT1CPRHbits.SMT1CPR12          // bit 4
#define SMT1CPR13               SMT1CPRHbits.SMT1CPR13          // bit 5
#define SMT1CPR14               SMT1CPRHbits.SMT1CPR14          // bit 6
#define SMT1CPR15               SMT1CPRHbits.SMT1CPR15          // bit 7

#define SMT1CPR0                SMT1CPRLbits.SMT1CPR0           // bit 0
#define SMT1CPR1                SMT1CPRLbits.SMT1CPR1           // bit 1
#define SMT1CPR2                SMT1CPRLbits.SMT1CPR2           // bit 2
#define SMT1CPR3                SMT1CPRLbits.SMT1CPR3           // bit 3
#define SMT1CPR4                SMT1CPRLbits.SMT1CPR4           // bit 4
#define SMT1CPR5                SMT1CPRLbits.SMT1CPR5           // bit 5
#define SMT1CPR6                SMT1CPRLbits.SMT1CPR6           // bit 6
#define SMT1CPR7                SMT1CPRLbits.SMT1CPR7           // bit 7

#define SMT1CPR16               SMT1CPRUbits.SMT1CPR16          // bit 0
#define SMT1CPR17               SMT1CPRUbits.SMT1CPR17          // bit 1
#define SMT1CPR18               SMT1CPRUbits.SMT1CPR18          // bit 2
#define SMT1CPR19               SMT1CPRUbits.SMT1CPR19          // bit 3
#define SMT1CPR20               SMT1CPRUbits.SMT1CPR20          // bit 4
#define SMT1CPR21               SMT1CPRUbits.SMT1CPR21          // bit 5
#define SMT1CPR22               SMT1CPRUbits.SMT1CPR22          // bit 6
#define SMT1CPR23               SMT1CPRUbits.SMT1CPR23          // bit 7

#define SMT1CPW8                SMT1CPWHbits.SMT1CPW8           // bit 0
#define SMT1CPW9                SMT1CPWHbits.SMT1CPW9           // bit 1
#define SMT1CPW10               SMT1CPWHbits.SMT1CPW10          // bit 2
#define SMT1CPW11               SMT1CPWHbits.SMT1CPW11          // bit 3
#define SMT1CPW12               SMT1CPWHbits.SMT1CPW12          // bit 4
#define SMT1CPW13               SMT1CPWHbits.SMT1CPW13          // bit 5
#define SMT1CPW14               SMT1CPWHbits.SMT1CPW14          // bit 6
#define SMT1CPW15               SMT1CPWHbits.SMT1CPW15          // bit 7

#define SMT1CPW0                SMT1CPWLbits.SMT1CPW0           // bit 0
#define SMT1CPW1                SMT1CPWLbits.SMT1CPW1           // bit 1
#define SMT1CPW2                SMT1CPWLbits.SMT1CPW2           // bit 2
#define SMT1CPW3                SMT1CPWLbits.SMT1CPW3           // bit 3
#define SMT1CPW4                SMT1CPWLbits.SMT1CPW4           // bit 4
#define SMT1CPW5                SMT1CPWLbits.SMT1CPW5           // bit 5
#define SMT1CPW6                SMT1CPWLbits.SMT1CPW6           // bit 6
#define SMT1CPW7                SMT1CPWLbits.SMT1CPW7           // bit 7

#define SMT1CPW16               SMT1CPWUbits.SMT1CPW16          // bit 0
#define SMT1CPW17               SMT1CPWUbits.SMT1CPW17          // bit 1
#define SMT1CPW18               SMT1CPWUbits.SMT1CPW18          // bit 2
#define SMT1CPW19               SMT1CPWUbits.SMT1CPW19          // bit 3
#define SMT1CPW20               SMT1CPWUbits.SMT1CPW20          // bit 4
#define SMT1CPW21               SMT1CPWUbits.SMT1CPW21          // bit 5
#define SMT1CPW22               SMT1CPWUbits.SMT1CPW22          // bit 6
#define SMT1CPW23               SMT1CPWUbits.SMT1CPW23          // bit 7

#define SMT1PR8                 SMT1PRHbits.SMT1PR8             // bit 0
#define SMT1PR9                 SMT1PRHbits.SMT1PR9             // bit 1
#define SMT1PR10                SMT1PRHbits.SMT1PR10            // bit 2
#define SMT1PR11                SMT1PRHbits.SMT1PR11            // bit 3
#define SMT1PR12                SMT1PRHbits.SMT1PR12            // bit 4
#define SMT1PR13                SMT1PRHbits.SMT1PR13            // bit 5
#define SMT1PR14                SMT1PRHbits.SMT1PR14            // bit 6
#define SMT1PR15                SMT1PRHbits.SMT1PR15            // bit 7

#define SMT1PR0                 SMT1PRLbits.SMT1PR0             // bit 0
#define SMT1PR1                 SMT1PRLbits.SMT1PR1             // bit 1
#define SMT1PR2                 SMT1PRLbits.SMT1PR2             // bit 2
#define SMT1PR3                 SMT1PRLbits.SMT1PR3             // bit 3
#define SMT1PR4                 SMT1PRLbits.SMT1PR4             // bit 4
#define SMT1PR5                 SMT1PRLbits.SMT1PR5             // bit 5
#define SMT1PR6                 SMT1PRLbits.SMT1PR6             // bit 6
#define SMT1PR7                 SMT1PRLbits.SMT1PR7             // bit 7

#define SMT1PR16                SMT1PRUbits.SMT1PR16            // bit 0
#define SMT1PR17                SMT1PRUbits.SMT1PR17            // bit 1
#define SMT1PR18                SMT1PRUbits.SMT1PR18            // bit 2
#define SMT1PR19                SMT1PRUbits.SMT1PR19            // bit 3
#define SMT1PR20                SMT1PRUbits.SMT1PR20            // bit 4
#define SMT1PR21                SMT1PRUbits.SMT1PR21            // bit 5
#define SMT1PR22                SMT1PRUbits.SMT1PR22            // bit 6
#define SMT1PR23                SMT1PRUbits.SMT1PR23            // bit 7

#define SMT1SIGPPS0             SMT1SIGPPSbits.SMT1SIGPPS0      // bit 0
#define SMT1SIGPPS1             SMT1SIGPPSbits.SMT1SIGPPS1      // bit 1
#define SMT1SIGPPS2             SMT1SIGPPSbits.SMT1SIGPPS2      // bit 2
#define SMT1SIGPPS3             SMT1SIGPPSbits.SMT1SIGPPS3      // bit 3
#define SMT1SIGPPS4             SMT1SIGPPSbits.SMT1SIGPPS4      // bit 4

#define AS                      SMT1STATbits.AS                 // bit 0, shadows bit in SMT1STATbits
#define SMT1AS                  SMT1STATbits.SMT1AS             // bit 0, shadows bit in SMT1STATbits
#define WS                      SMT1STATbits.WS                 // bit 1, shadows bit in SMT1STATbits
#define SMT1WS                  SMT1STATbits.SMT1WS             // bit 1, shadows bit in SMT1STATbits
#define TS                      SMT1STATbits.TS                 // bit 2, shadows bit in SMT1STATbits
#define SMT1TS                  SMT1STATbits.SMT1TS             // bit 2, shadows bit in SMT1STATbits
#define RST                     SMT1STATbits.RST                // bit 5, shadows bit in SMT1STATbits
#define SMT1RESET               SMT1STATbits.SMT1RESET          // bit 5, shadows bit in SMT1STATbits
#define CPWUP                   SMT1STATbits.CPWUP              // bit 6, shadows bit in SMT1STATbits
#define SMT1CPWUP               SMT1STATbits.SMT1CPWUP          // bit 6, shadows bit in SMT1STATbits
#define CPRUP                   SMT1STATbits.CPRUP              // bit 7, shadows bit in SMT1STATbits
#define SMT1CPRUP               SMT1STATbits.SMT1CPRUP          // bit 7, shadows bit in SMT1STATbits

#define SMT1TMR8                SMT1TMRHbits.SMT1TMR8           // bit 0
#define SMT1TMR9                SMT1TMRHbits.SMT1TMR9           // bit 1
#define SMT1TMR10               SMT1TMRHbits.SMT1TMR10          // bit 2
#define SMT1TMR11               SMT1TMRHbits.SMT1TMR11          // bit 3
#define SMT1TMR12               SMT1TMRHbits.SMT1TMR12          // bit 4
#define SMT1TMR13               SMT1TMRHbits.SMT1TMR13          // bit 5
#define SMT1TMR14               SMT1TMRHbits.SMT1TMR14          // bit 6
#define SMT1TMR15               SMT1TMRHbits.SMT1TMR15          // bit 7

#define SMT1TMR0                SMT1TMRLbits.SMT1TMR0           // bit 0
#define SMT1TMR1                SMT1TMRLbits.SMT1TMR1           // bit 1
#define SMT1TMR2                SMT1TMRLbits.SMT1TMR2           // bit 2
#define SMT1TMR3                SMT1TMRLbits.SMT1TMR3           // bit 3
#define SMT1TMR4                SMT1TMRLbits.SMT1TMR4           // bit 4
#define SMT1TMR5                SMT1TMRLbits.SMT1TMR5           // bit 5
#define SMT1TMR6                SMT1TMRLbits.SMT1TMR6           // bit 6
#define SMT1TMR7                SMT1TMRLbits.SMT1TMR7           // bit 7

#define SMT1TMR16               SMT1TMRUbits.SMT1TMR16          // bit 0
#define SMT1TMR17               SMT1TMRUbits.SMT1TMR17          // bit 1
#define SMT1TMR18               SMT1TMRUbits.SMT1TMR18          // bit 2
#define SMT1TMR19               SMT1TMRUbits.SMT1TMR19          // bit 3
#define SMT1TMR20               SMT1TMRUbits.SMT1TMR20          // bit 4
#define SMT1TMR21               SMT1TMRUbits.SMT1TMR21          // bit 5
#define SMT1TMR22               SMT1TMRUbits.SMT1TMR22          // bit 6
#define SMT1TMR23               SMT1TMRUbits.SMT1TMR23          // bit 7

#define WSEL0                   SMT1WINbits.WSEL0               // bit 0, shadows bit in SMT1WINbits
#define SMT1WSEL0               SMT1WINbits.SMT1WSEL0           // bit 0, shadows bit in SMT1WINbits
#define WSEL1                   SMT1WINbits.WSEL1               // bit 1, shadows bit in SMT1WINbits
#define SMT1WSEL1               SMT1WINbits.SMT1WSEL1           // bit 1, shadows bit in SMT1WINbits
#define WSEL2                   SMT1WINbits.WSEL2               // bit 2, shadows bit in SMT1WINbits
#define SMT1WSEL2               SMT1WINbits.SMT1WSEL2           // bit 2, shadows bit in SMT1WINbits
#define WSEL3                   SMT1WINbits.WSEL3               // bit 3, shadows bit in SMT1WINbits
#define SMT1WSEL3               SMT1WINbits.SMT1WSEL3           // bit 3, shadows bit in SMT1WINbits
#define WSEL4                   SMT1WINbits.WSEL4               // bit 4, shadows bit in SMT1WINbits
#define SMT1WSEL4               SMT1WINbits.SMT1WSEL4           // bit 4, shadows bit in SMT1WINbits

#define SMTWINPPS0              SMT1WINPPSbits.SMTWINPPS0       // bit 0
#define SMTWINPPS1              SMT1WINPPSbits.SMTWINPPS1       // bit 1
#define SMTWINPPS2              SMT1WINPPSbits.SMTWINPPS2       // bit 2
#define SMTWINPPS3              SMT1WINPPSbits.SMTWINPPS3       // bit 3
#define SMTWINPPS4              SMT1WINPPSbits.SMTWINPPS4       // bit 4

#define SMT2CPR8                SMT2CPRHbits.SMT2CPR8           // bit 0
#define SMT2CPR9                SMT2CPRHbits.SMT2CPR9           // bit 1
#define SMT2CPR10               SMT2CPRHbits.SMT2CPR10          // bit 2
#define SMT2CPR11               SMT2CPRHbits.SMT2CPR11          // bit 3
#define SMT2CPR12               SMT2CPRHbits.SMT2CPR12          // bit 4
#define SMT2CPR13               SMT2CPRHbits.SMT2CPR13          // bit 5
#define SMT2CPR14               SMT2CPRHbits.SMT2CPR14          // bit 6
#define SMT2CPR15               SMT2CPRHbits.SMT2CPR15          // bit 7

#define SMT2CPR0                SMT2CPRLbits.SMT2CPR0           // bit 0
#define SMT2CPR1                SMT2CPRLbits.SMT2CPR1           // bit 1
#define SMT2CPR2                SMT2CPRLbits.SMT2CPR2           // bit 2
#define SMT2CPR3                SMT2CPRLbits.SMT2CPR3           // bit 3
#define SMT2CPR4                SMT2CPRLbits.SMT2CPR4           // bit 4
#define SMT2CPR5                SMT2CPRLbits.SMT2CPR5           // bit 5
#define SMT2CPR6                SMT2CPRLbits.SMT2CPR6           // bit 6
#define SMT2CPR7                SMT2CPRLbits.SMT2CPR7           // bit 7

#define SMT2CPR16               SMT2CPRUbits.SMT2CPR16          // bit 0
#define SMT2CPR17               SMT2CPRUbits.SMT2CPR17          // bit 1
#define SMT2CPR18               SMT2CPRUbits.SMT2CPR18          // bit 2
#define SMT2CPR19               SMT2CPRUbits.SMT2CPR19          // bit 3
#define SMT2CPR20               SMT2CPRUbits.SMT2CPR20          // bit 4
#define SMT2CPR21               SMT2CPRUbits.SMT2CPR21          // bit 5
#define SMT2CPR22               SMT2CPRUbits.SMT2CPR22          // bit 6
#define SMT2CPR23               SMT2CPRUbits.SMT2CPR23          // bit 7

#define SMT2CPW8                SMT2CPWHbits.SMT2CPW8           // bit 0
#define SMT2CPW9                SMT2CPWHbits.SMT2CPW9           // bit 1
#define SMT2CPW10               SMT2CPWHbits.SMT2CPW10          // bit 2
#define SMT2CPW11               SMT2CPWHbits.SMT2CPW11          // bit 3
#define SMT2CPW12               SMT2CPWHbits.SMT2CPW12          // bit 4
#define SMT2CPW13               SMT2CPWHbits.SMT2CPW13          // bit 5
#define SMT2CPW14               SMT2CPWHbits.SMT2CPW14          // bit 6
#define SMT2CPW15               SMT2CPWHbits.SMT2CPW15          // bit 7

#define SMT2CPW0                SMT2CPWLbits.SMT2CPW0           // bit 0
#define SMT2CPW1                SMT2CPWLbits.SMT2CPW1           // bit 1
#define SMT2CPW2                SMT2CPWLbits.SMT2CPW2           // bit 2
#define SMT2CPW3                SMT2CPWLbits.SMT2CPW3           // bit 3
#define SMT2CPW4                SMT2CPWLbits.SMT2CPW4           // bit 4
#define SMT2CPW5                SMT2CPWLbits.SMT2CPW5           // bit 5
#define SMT2CPW6                SMT2CPWLbits.SMT2CPW6           // bit 6
#define SMT2CPW7                SMT2CPWLbits.SMT2CPW7           // bit 7

#define SMT2CPW16               SMT2CPWUbits.SMT2CPW16          // bit 0
#define SMT2CPW17               SMT2CPWUbits.SMT2CPW17          // bit 1
#define SMT2CPW18               SMT2CPWUbits.SMT2CPW18          // bit 2
#define SMT2CPW19               SMT2CPWUbits.SMT2CPW19          // bit 3
#define SMT2CPW20               SMT2CPWUbits.SMT2CPW20          // bit 4
#define SMT2CPW21               SMT2CPWUbits.SMT2CPW21          // bit 5
#define SMT2CPW22               SMT2CPWUbits.SMT2CPW22          // bit 6
#define SMT2CPW23               SMT2CPWUbits.SMT2CPW23          // bit 7

#define SMT2PR8                 SMT2PRHbits.SMT2PR8             // bit 0
#define SMT2PR9                 SMT2PRHbits.SMT2PR9             // bit 1
#define SMT2PR10                SMT2PRHbits.SMT2PR10            // bit 2
#define SMT2PR11                SMT2PRHbits.SMT2PR11            // bit 3
#define SMT2PR12                SMT2PRHbits.SMT2PR12            // bit 4
#define SMT2PR13                SMT2PRHbits.SMT2PR13            // bit 5
#define SMT2PR14                SMT2PRHbits.SMT2PR14            // bit 6
#define SMT2PR15                SMT2PRHbits.SMT2PR15            // bit 7

#define SMT2PR0                 SMT2PRLbits.SMT2PR0             // bit 0
#define SMT2PR1                 SMT2PRLbits.SMT2PR1             // bit 1
#define SMT2PR2                 SMT2PRLbits.SMT2PR2             // bit 2
#define SMT2PR3                 SMT2PRLbits.SMT2PR3             // bit 3
#define SMT2PR4                 SMT2PRLbits.SMT2PR4             // bit 4
#define SMT2PR5                 SMT2PRLbits.SMT2PR5             // bit 5
#define SMT2PR6                 SMT2PRLbits.SMT2PR6             // bit 6
#define SMT2PR7                 SMT2PRLbits.SMT2PR7             // bit 7

#define SMT2PR16                SMT2PRUbits.SMT2PR16            // bit 0
#define SMT2PR17                SMT2PRUbits.SMT2PR17            // bit 1
#define SMT2PR18                SMT2PRUbits.SMT2PR18            // bit 2
#define SMT2PR19                SMT2PRUbits.SMT2PR19            // bit 3
#define SMT2PR20                SMT2PRUbits.SMT2PR20            // bit 4
#define SMT2PR21                SMT2PRUbits.SMT2PR21            // bit 5
#define SMT2PR22                SMT2PRUbits.SMT2PR22            // bit 6
#define SMT2PR23                SMT2PRUbits.SMT2PR23            // bit 7

#define SMT2SIGPPS0             SMT2SIGPPSbits.SMT2SIGPPS0      // bit 0
#define SMT2SIGPPS1             SMT2SIGPPSbits.SMT2SIGPPS1      // bit 1
#define SMT2SIGPPS2             SMT2SIGPPSbits.SMT2SIGPPS2      // bit 2
#define SMT2SIGPPS3             SMT2SIGPPSbits.SMT2SIGPPS3      // bit 3
#define SMT2SIGPPS4             SMT2SIGPPSbits.SMT2SIGPPS4      // bit 4

#define SMT2TMR8                SMT2TMRHbits.SMT2TMR8           // bit 0
#define SMT2TMR9                SMT2TMRHbits.SMT2TMR9           // bit 1
#define SMT2TMR10               SMT2TMRHbits.SMT2TMR10          // bit 2
#define SMT2TMR11               SMT2TMRHbits.SMT2TMR11          // bit 3
#define SMT2TMR12               SMT2TMRHbits.SMT2TMR12          // bit 4
#define SMT2TMR13               SMT2TMRHbits.SMT2TMR13          // bit 5
#define SMT2TMR14               SMT2TMRHbits.SMT2TMR14          // bit 6
#define SMT2TMR15               SMT2TMRHbits.SMT2TMR15          // bit 7

#define SMT2TMR0                SMT2TMRLbits.SMT2TMR0           // bit 0
#define SMT2TMR1                SMT2TMRLbits.SMT2TMR1           // bit 1
#define SMT2TMR2                SMT2TMRLbits.SMT2TMR2           // bit 2
#define SMT2TMR3                SMT2TMRLbits.SMT2TMR3           // bit 3
#define SMT2TMR4                SMT2TMRLbits.SMT2TMR4           // bit 4
#define SMT2TMR5                SMT2TMRLbits.SMT2TMR5           // bit 5
#define SMT2TMR6                SMT2TMRLbits.SMT2TMR6           // bit 6
#define SMT2TMR7                SMT2TMRLbits.SMT2TMR7           // bit 7

#define SMT2TMR16               SMT2TMRUbits.SMT2TMR16          // bit 0
#define SMT2TMR17               SMT2TMRUbits.SMT2TMR17          // bit 1
#define SMT2TMR18               SMT2TMRUbits.SMT2TMR18          // bit 2
#define SMT2TMR19               SMT2TMRUbits.SMT2TMR19          // bit 3
#define SMT2TMR20               SMT2TMRUbits.SMT2TMR20          // bit 4
#define SMT2TMR21               SMT2TMRUbits.SMT2TMR21          // bit 5
#define SMT2TMR22               SMT2TMRUbits.SMT2TMR22          // bit 6
#define SMT2TMR23               SMT2TMRUbits.SMT2TMR23          // bit 7

#define SMT2WINPPS0             SMT2WINPPSbits.SMT2WINPPS0      // bit 0
#define SMT2WINPPS1             SMT2WINPPSbits.SMT2WINPPS1      // bit 1
#define SMT2WINPPS2             SMT2WINPPSbits.SMT2WINPPS2      // bit 2
#define SMT2WINPPS3             SMT2WINPPSbits.SMT2WINPPS3      // bit 3
#define SMT2WINPPS4             SMT2WINPPSbits.SMT2WINPPS4      // bit 4

#define SSP1ADD0                SSP1ADDbits.SSP1ADD0            // bit 0, shadows bit in SSP1ADDbits
#define ADD0                    SSP1ADDbits.ADD0                // bit 0, shadows bit in SSP1ADDbits
#define SSP1ADD1                SSP1ADDbits.SSP1ADD1            // bit 1, shadows bit in SSP1ADDbits
#define ADD1                    SSP1ADDbits.ADD1                // bit 1, shadows bit in SSP1ADDbits
#define SSP1ADD2                SSP1ADDbits.SSP1ADD2            // bit 2, shadows bit in SSP1ADDbits
#define ADD2                    SSP1ADDbits.ADD2                // bit 2, shadows bit in SSP1ADDbits
#define SSP1ADD3                SSP1ADDbits.SSP1ADD3            // bit 3, shadows bit in SSP1ADDbits
#define ADD3                    SSP1ADDbits.ADD3                // bit 3, shadows bit in SSP1ADDbits
#define SSP1ADD4                SSP1ADDbits.SSP1ADD4            // bit 4, shadows bit in SSP1ADDbits
#define ADD4                    SSP1ADDbits.ADD4                // bit 4, shadows bit in SSP1ADDbits
#define SSP1ADD5                SSP1ADDbits.SSP1ADD5            // bit 5, shadows bit in SSP1ADDbits
#define ADD5                    SSP1ADDbits.ADD5                // bit 5, shadows bit in SSP1ADDbits
#define SSP1ADD6                SSP1ADDbits.SSP1ADD6            // bit 6, shadows bit in SSP1ADDbits
#define ADD6                    SSP1ADDbits.ADD6                // bit 6, shadows bit in SSP1ADDbits
#define SSP1ADD7                SSP1ADDbits.SSP1ADD7            // bit 7, shadows bit in SSP1ADDbits
#define ADD7                    SSP1ADDbits.ADD7                // bit 7, shadows bit in SSP1ADDbits

#define SSP1BUF0                SSP1BUFbits.SSP1BUF0            // bit 0, shadows bit in SSP1BUFbits
#define BUF0                    SSP1BUFbits.BUF0                // bit 0, shadows bit in SSP1BUFbits
#define SSP1BUF1                SSP1BUFbits.SSP1BUF1            // bit 1, shadows bit in SSP1BUFbits
#define BUF1                    SSP1BUFbits.BUF1                // bit 1, shadows bit in SSP1BUFbits
#define SSP1BUF2                SSP1BUFbits.SSP1BUF2            // bit 2, shadows bit in SSP1BUFbits
#define BUF2                    SSP1BUFbits.BUF2                // bit 2, shadows bit in SSP1BUFbits
#define SSP1BUF3                SSP1BUFbits.SSP1BUF3            // bit 3, shadows bit in SSP1BUFbits
#define BUF3                    SSP1BUFbits.BUF3                // bit 3, shadows bit in SSP1BUFbits
#define SSP1BUF4                SSP1BUFbits.SSP1BUF4            // bit 4, shadows bit in SSP1BUFbits
#define BUF4                    SSP1BUFbits.BUF4                // bit 4, shadows bit in SSP1BUFbits
#define SSP1BUF5                SSP1BUFbits.SSP1BUF5            // bit 5, shadows bit in SSP1BUFbits
#define BUF5                    SSP1BUFbits.BUF5                // bit 5, shadows bit in SSP1BUFbits
#define SSP1BUF6                SSP1BUFbits.SSP1BUF6            // bit 6, shadows bit in SSP1BUFbits
#define BUF6                    SSP1BUFbits.BUF6                // bit 6, shadows bit in SSP1BUFbits
#define SSP1BUF7                SSP1BUFbits.SSP1BUF7            // bit 7, shadows bit in SSP1BUFbits
#define BUF7                    SSP1BUFbits.BUF7                // bit 7, shadows bit in SSP1BUFbits

#define SSPM0                   SSP1CONbits.SSPM0               // bit 0
#define SSPM1                   SSP1CONbits.SSPM1               // bit 1
#define SSPM2                   SSP1CONbits.SSPM2               // bit 2
#define SSPM3                   SSP1CONbits.SSPM3               // bit 3
#define CKP                     SSP1CONbits.CKP                 // bit 4
#define SSPEN                   SSP1CONbits.SSPEN               // bit 5
#define SSPOV                   SSP1CONbits.SSPOV               // bit 6
#define WCOL                    SSP1CONbits.WCOL                // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1
#define PEN                     SSP1CON2bits.PEN                // bit 2
#define RCEN                    SSP1CON2bits.RCEN               // bit 3
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define SSP1MSK0                SSP1MSKbits.SSP1MSK0            // bit 0, shadows bit in SSP1MSKbits
#define MSK0                    SSP1MSKbits.MSK0                // bit 0, shadows bit in SSP1MSKbits
#define SSP1MSK1                SSP1MSKbits.SSP1MSK1            // bit 1, shadows bit in SSP1MSKbits
#define MSK1                    SSP1MSKbits.MSK1                // bit 1, shadows bit in SSP1MSKbits
#define SSP1MSK2                SSP1MSKbits.SSP1MSK2            // bit 2, shadows bit in SSP1MSKbits
#define MSK2                    SSP1MSKbits.MSK2                // bit 2, shadows bit in SSP1MSKbits
#define SSP1MSK3                SSP1MSKbits.SSP1MSK3            // bit 3, shadows bit in SSP1MSKbits
#define MSK3                    SSP1MSKbits.MSK3                // bit 3, shadows bit in SSP1MSKbits
#define SSP1MSK4                SSP1MSKbits.SSP1MSK4            // bit 4, shadows bit in SSP1MSKbits
#define MSK4                    SSP1MSKbits.MSK4                // bit 4, shadows bit in SSP1MSKbits
#define SSP1MSK5                SSP1MSKbits.SSP1MSK5            // bit 5, shadows bit in SSP1MSKbits
#define MSK5                    SSP1MSKbits.MSK5                // bit 5, shadows bit in SSP1MSKbits
#define SSP1MSK6                SSP1MSKbits.SSP1MSK6            // bit 6, shadows bit in SSP1MSKbits
#define MSK6                    SSP1MSKbits.MSK6                // bit 6, shadows bit in SSP1MSKbits
#define SSP1MSK7                SSP1MSKbits.SSP1MSK7            // bit 7, shadows bit in SSP1MSKbits
#define MSK7                    SSP1MSKbits.MSK7                // bit 7, shadows bit in SSP1MSKbits

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2
#define S                       SSP1STATbits.S                  // bit 3
#define P                       SSP1STATbits.P                  // bit 4
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define SSPCLKPPS0              SSPCLKPPSbits.SSPCLKPPS0        // bit 0
#define SSPCLKPPS1              SSPCLKPPSbits.SSPCLKPPS1        // bit 1
#define SSPCLKPPS2              SSPCLKPPSbits.SSPCLKPPS2        // bit 2
#define SSPCLKPPS3              SSPCLKPPSbits.SSPCLKPPS3        // bit 3
#define SSPCLKPPS4              SSPCLKPPSbits.SSPCLKPPS4        // bit 4

#define SSPDATPPS0              SSPDATPPSbits.SSPDATPPS0        // bit 0
#define SSPDATPPS1              SSPDATPPSbits.SSPDATPPS1        // bit 1
#define SSPDATPPS2              SSPDATPPSbits.SSPDATPPS2        // bit 2
#define SSPDATPPS3              SSPDATPPSbits.SSPDATPPS3        // bit 3
#define SSPDATPPS4              SSPDATPPSbits.SSPDATPPS4        // bit 4

#define SSPSSPPS0               SSPSSPPSbits.SSPSSPPS0          // bit 0
#define SSPSSPPS1               SSPSSPPSbits.SSPSSPPS1          // bit 1
#define SSPSSPPS2               SSPSSPPSbits.SSPSSPPS2          // bit 2
#define SSPSSPPS3               SSPSSPPSbits.SSPSSPPS3          // bit 3
#define SSPSSPPS4               SSPSSPPSbits.SSPSSPPS4          // bit 4

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define T0CKIPPS0               T0CKIPPSbits.T0CKIPPS0          // bit 0
#define T0CKIPPS1               T0CKIPPSbits.T0CKIPPS1          // bit 1
#define T0CKIPPS2               T0CKIPPSbits.T0CKIPPS2          // bit 2
#define T0CKIPPS3               T0CKIPPSbits.T0CKIPPS3          // bit 3
#define T0CKIPPS4               T0CKIPPSbits.T0CKIPPS4          // bit 4

#define T1CKIPPS0               T1CKIPPSbits.T1CKIPPS0          // bit 0
#define T1CKIPPS1               T1CKIPPSbits.T1CKIPPS1          // bit 1
#define T1CKIPPS2               T1CKIPPSbits.T1CKIPPS2          // bit 2
#define T1CKIPPS3               T1CKIPPSbits.T1CKIPPS3          // bit 3
#define T1CKIPPS4               T1CKIPPSbits.T1CKIPPS4          // bit 4

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T1GPPS0                 T1GPPSbits.T1GPPS0              // bit 0
#define T1GPPS1                 T1GPPSbits.T1GPPS1              // bit 1
#define T1GPPS2                 T1GPPSbits.T1GPPS2              // bit 2
#define T1GPPS3                 T1GPPSbits.T1GPPS3              // bit 3
#define T1GPPS4                 T1GPPSbits.T1GPPS4              // bit 4

#define OUTPS0                  T2CONbits.OUTPS0                // bit 0, shadows bit in T2CONbits
#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 0, shadows bit in T2CONbits
#define OUTPS1                  T2CONbits.OUTPS1                // bit 1, shadows bit in T2CONbits
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 1, shadows bit in T2CONbits
#define OUTPS2                  T2CONbits.OUTPS2                // bit 2, shadows bit in T2CONbits
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 2, shadows bit in T2CONbits
#define OUTPS3                  T2CONbits.OUTPS3                // bit 3, shadows bit in T2CONbits
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 3, shadows bit in T2CONbits
#define CKPS0                   T2CONbits.CKPS0                 // bit 4, shadows bit in T2CONbits
#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 4, shadows bit in T2CONbits
#define CKPS1                   T2CONbits.CKPS1                 // bit 5, shadows bit in T2CONbits
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 5, shadows bit in T2CONbits
#define CKPS2                   T2CONbits.CKPS2                 // bit 6, shadows bit in T2CONbits
#define T2CKPS2                 T2CONbits.T2CKPS2               // bit 6, shadows bit in T2CONbits
#define ON                      T2CONbits.ON                    // bit 7, shadows bit in T2CONbits
#define T2ON                    T2CONbits.T2ON                  // bit 7, shadows bit in T2CONbits
#define TMR2ON                  T2CONbits.TMR2ON                // bit 7, shadows bit in T2CONbits

#define T2PPS0                  T2PPSbits.T2PPS0                // bit 0
#define T2PPS1                  T2PPSbits.T2PPS1                // bit 1
#define T2PPS2                  T2PPSbits.T2PPS2                // bit 2
#define T2PPS3                  T2PPSbits.T2PPS3                // bit 3
#define T2PPS4                  T2PPSbits.T2PPS4                // bit 4

#define RSEL0                   T2RSTbits.RSEL0                 // bit 0, shadows bit in T2RSTbits
#define T2RSEL0                 T2RSTbits.T2RSEL0               // bit 0, shadows bit in T2RSTbits
#define RSEL1                   T2RSTbits.RSEL1                 // bit 1, shadows bit in T2RSTbits
#define T2RSEL1                 T2RSTbits.T2RSEL1               // bit 1, shadows bit in T2RSTbits
#define RSEL2                   T2RSTbits.RSEL2                 // bit 2, shadows bit in T2RSTbits
#define T2RSEL2                 T2RSTbits.T2RSEL2               // bit 2, shadows bit in T2RSTbits
#define RSEL3                   T2RSTbits.RSEL3                 // bit 3, shadows bit in T2RSTbits
#define T2RSEL3                 T2RSTbits.T2RSEL3               // bit 3, shadows bit in T2RSTbits

#define T3CKIPPS0               T3CKIPPSbits.T3CKIPPS0          // bit 0
#define T3CKIPPS1               T3CKIPPSbits.T3CKIPPS1          // bit 1
#define T3CKIPPS2               T3CKIPPSbits.T3CKIPPS2          // bit 2
#define T3CKIPPS3               T3CKIPPSbits.T3CKIPPS3          // bit 3
#define T3CKIPPS4               T3CKIPPSbits.T3CKIPPS4          // bit 4

#define TMR3ON                  T3CONbits.TMR3ON                // bit 0
#define T3SYNC                  T3CONbits.T3SYNC                // bit 2
#define T3CKPS0                 T3CONbits.T3CKPS0               // bit 4
#define T3CKPS1                 T3CONbits.T3CKPS1               // bit 5
#define TMR3CS0                 T3CONbits.TMR3CS0               // bit 6
#define TMR3CS1                 T3CONbits.TMR3CS1               // bit 7

#define T3GSS0                  T3GCONbits.T3GSS0               // bit 0
#define T3GSS1                  T3GCONbits.T3GSS1               // bit 1
#define T3GVAL                  T3GCONbits.T3GVAL               // bit 2
#define T3GGO_NOT_DONE          T3GCONbits.T3GGO_NOT_DONE       // bit 3
#define T3GSPM                  T3GCONbits.T3GSPM               // bit 4
#define T3GTM                   T3GCONbits.T3GTM                // bit 5
#define T3GPOL                  T3GCONbits.T3GPOL               // bit 6
#define TMR3GE                  T3GCONbits.TMR3GE               // bit 7

#define T3GPPS0                 T3GPPSbits.T3GPPS0              // bit 0
#define T3GPPS1                 T3GPPSbits.T3GPPS1              // bit 1
#define T3GPPS2                 T3GPPSbits.T3GPPS2              // bit 2
#define T3GPPS3                 T3GPPSbits.T3GPPS3              // bit 3
#define T3GPPS4                 T3GPPSbits.T3GPPS4              // bit 4

#define T4PPS0                  T4PPSbits.T4PPS0                // bit 0
#define T4PPS1                  T4PPSbits.T4PPS1                // bit 1
#define T4PPS2                  T4PPSbits.T4PPS2                // bit 2
#define T4PPS3                  T4PPSbits.T4PPS3                // bit 3
#define T4PPS4                  T4PPSbits.T4PPS4                // bit 4

#define T5CKIPPS0               T5CKIPPSbits.T5CKIPPS0          // bit 0
#define T5CKIPPS1               T5CKIPPSbits.T5CKIPPS1          // bit 1
#define T5CKIPPS2               T5CKIPPSbits.T5CKIPPS2          // bit 2
#define T5CKIPPS3               T5CKIPPSbits.T5CKIPPS3          // bit 3
#define T5CKIPPS4               T5CKIPPSbits.T5CKIPPS4          // bit 4

#define TMR5ON                  T5CONbits.TMR5ON                // bit 0
#define T5SYNC                  T5CONbits.T5SYNC                // bit 2
#define T5CKPS0                 T5CONbits.T5CKPS0               // bit 4
#define T5CKPS1                 T5CONbits.T5CKPS1               // bit 5
#define TMR5CS0                 T5CONbits.TMR5CS0               // bit 6
#define TMR5CS1                 T5CONbits.TMR5CS1               // bit 7

#define T5GSS0                  T5GCONbits.T5GSS0               // bit 0
#define T5GSS1                  T5GCONbits.T5GSS1               // bit 1
#define T5GVAL                  T5GCONbits.T5GVAL               // bit 2
#define T5GGO_NOT_DONE          T5GCONbits.T5GGO_NOT_DONE       // bit 3
#define T5GSPM                  T5GCONbits.T5GSPM               // bit 4
#define T5GTM                   T5GCONbits.T5GTM                // bit 5
#define T5GPOL                  T5GCONbits.T5GPOL               // bit 6
#define TMR5GE                  T5GCONbits.TMR5GE               // bit 7

#define T5GPPS0                 T5GPPSbits.T5GPPS0              // bit 0
#define T5GPPS1                 T5GPPSbits.T5GPPS1              // bit 1
#define T5GPPS2                 T5GPPSbits.T5GPPS2              // bit 2
#define T5GPPS3                 T5GPPSbits.T5GPPS3              // bit 3
#define T5GPPS4                 T5GPPSbits.T5GPPS4              // bit 4

#define T6PPS0                  T6PPSbits.T6PPS0                // bit 0
#define T6PPS1                  T6PPSbits.T6PPS1                // bit 1
#define T6PPS2                  T6PPSbits.T6PPS2                // bit 2
#define T6PPS3                  T6PPSbits.T6PPS3                // bit 3
#define T6PPS4                  T6PPSbits.T6PPS4                // bit 4

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TX9D                    TX1STAbits.TX9D                 // bit 0
#define TRMT                    TX1STAbits.TRMT                 // bit 1
#define BRGH                    TX1STAbits.BRGH                 // bit 2
#define SENDB                   TX1STAbits.SENDB                // bit 3
#define SYNC                    TX1STAbits.SYNC                 // bit 4
#define TXEN                    TX1STAbits.TXEN                 // bit 5
#define TX9                     TX1STAbits.TX9                  // bit 6
#define CSRC                    TX1STAbits.CSRC                 // bit 7

#define WINDOW0                 WDTCON1bits.WINDOW0             // bit 0, shadows bit in WDTCON1bits
#define WDTWINDOW0              WDTCON1bits.WDTWINDOW0          // bit 0, shadows bit in WDTCON1bits
#define WINDOW1                 WDTCON1bits.WINDOW1             // bit 1, shadows bit in WDTCON1bits
#define WDTWINDOW1              WDTCON1bits.WDTWINDOW1          // bit 1, shadows bit in WDTCON1bits
#define WINDOW2                 WDTCON1bits.WINDOW2             // bit 2, shadows bit in WDTCON1bits
#define WDTWINDOW2              WDTCON1bits.WDTWINDOW2          // bit 2, shadows bit in WDTCON1bits
#define WDTCS0                  WDTCON1bits.WDTCS0              // bit 4
#define WDTCS1                  WDTCON1bits.WDTCS1              // bit 5
#define WDTCS2                  WDTCON1bits.WDTCS2              // bit 6

#define PSCNT8                  WDTPSHbits.PSCNT8               // bit 0, shadows bit in WDTPSHbits
#define WDTPSCNT8               WDTPSHbits.WDTPSCNT8            // bit 0, shadows bit in WDTPSHbits
#define PSCNT9                  WDTPSHbits.PSCNT9               // bit 1, shadows bit in WDTPSHbits
#define WDTPSCNT9               WDTPSHbits.WDTPSCNT9            // bit 1, shadows bit in WDTPSHbits
#define PSCNT10                 WDTPSHbits.PSCNT10              // bit 2, shadows bit in WDTPSHbits
#define WDTPSCNT10              WDTPSHbits.WDTPSCNT10           // bit 2, shadows bit in WDTPSHbits
#define PSCNT11                 WDTPSHbits.PSCNT11              // bit 3, shadows bit in WDTPSHbits
#define WDTPSCNT11              WDTPSHbits.WDTPSCNT11           // bit 3, shadows bit in WDTPSHbits
#define PSCNT12                 WDTPSHbits.PSCNT12              // bit 4, shadows bit in WDTPSHbits
#define WDTPSCNT12              WDTPSHbits.WDTPSCNT12           // bit 4, shadows bit in WDTPSHbits
#define PSCNT13                 WDTPSHbits.PSCNT13              // bit 5, shadows bit in WDTPSHbits
#define WDTPSCNT13              WDTPSHbits.WDTPSCNT13           // bit 5, shadows bit in WDTPSHbits
#define PSCNT14                 WDTPSHbits.PSCNT14              // bit 6, shadows bit in WDTPSHbits
#define WDTPSCNT14              WDTPSHbits.WDTPSCNT14           // bit 6, shadows bit in WDTPSHbits
#define PSCNT15                 WDTPSHbits.PSCNT15              // bit 7, shadows bit in WDTPSHbits
#define WDTPSCNT15              WDTPSHbits.WDTPSCNT15           // bit 7, shadows bit in WDTPSHbits

#define PSCNT0                  WDTPSLbits.PSCNT0               // bit 0, shadows bit in WDTPSLbits
#define WDTPSCNT0               WDTPSLbits.WDTPSCNT0            // bit 0, shadows bit in WDTPSLbits
#define PSCNT1                  WDTPSLbits.PSCNT1               // bit 1, shadows bit in WDTPSLbits
#define WDTPSCNT1               WDTPSLbits.WDTPSCNT1            // bit 1, shadows bit in WDTPSLbits
#define PSCNT2                  WDTPSLbits.PSCNT2               // bit 2, shadows bit in WDTPSLbits
#define WDTPSCNT2               WDTPSLbits.WDTPSCNT2            // bit 2, shadows bit in WDTPSLbits
#define PSCNT3                  WDTPSLbits.PSCNT3               // bit 3, shadows bit in WDTPSLbits
#define WDTPSCNT3               WDTPSLbits.WDTPSCNT3            // bit 3, shadows bit in WDTPSLbits
#define PSCNT4                  WDTPSLbits.PSCNT4               // bit 4, shadows bit in WDTPSLbits
#define WDTPSCNT4               WDTPSLbits.WDTPSCNT4            // bit 4, shadows bit in WDTPSLbits
#define PSCNT5                  WDTPSLbits.PSCNT5               // bit 5, shadows bit in WDTPSLbits
#define WDTPSCNT5               WDTPSLbits.WDTPSCNT5            // bit 5, shadows bit in WDTPSLbits
#define PSCNT6                  WDTPSLbits.PSCNT6               // bit 6, shadows bit in WDTPSLbits
#define WDTPSCNT6               WDTPSLbits.WDTPSCNT6            // bit 6, shadows bit in WDTPSLbits
#define PSCNT7                  WDTPSLbits.PSCNT7               // bit 7, shadows bit in WDTPSLbits
#define WDTPSCNT7               WDTPSLbits.WDTPSCNT7            // bit 7, shadows bit in WDTPSLbits

#define PSCNT16                 WDTTMRbits.PSCNT16              // bit 0, shadows bit in WDTTMRbits
#define WDTPSCNT16              WDTTMRbits.WDTPSCNT16           // bit 0, shadows bit in WDTTMRbits
#define PSCNT17                 WDTTMRbits.PSCNT17              // bit 1, shadows bit in WDTTMRbits
#define WDTPSCNT17              WDTTMRbits.WDTPSCNT17           // bit 1, shadows bit in WDTTMRbits
#define STATE                   WDTTMRbits.STATE                // bit 2, shadows bit in WDTTMRbits
#define WDTSTATE                WDTTMRbits.WDTSTATE             // bit 2, shadows bit in WDTTMRbits
#define WDTTMR0                 WDTTMRbits.WDTTMR0              // bit 3
#define WDTTMR1                 WDTTMRbits.WDTTMR1              // bit 4
#define WDTTMR2                 WDTTMRbits.WDTTMR2              // bit 5
#define WDTTMR3                 WDTTMRbits.WDTTMR3              // bit 6
#define WDTTMR4                 WDTTMRbits.WDTTMR4              // bit 7

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5

#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#define WPUC0                   WPUCbits.WPUC0                  // bit 0
#define WPUC1                   WPUCbits.WPUC1                  // bit 1
#define WPUC2                   WPUCbits.WPUC2                  // bit 2
#define WPUC3                   WPUCbits.WPUC3                  // bit 3
#define WPUC4                   WPUCbits.WPUC4                  // bit 4
#define WPUC5                   WPUCbits.WPUC5                  // bit 5
#define WPUC6                   WPUCbits.WPUC6                  // bit 6
#define WPUC7                   WPUCbits.WPUC7                  // bit 7

#define ZCD1INTN                ZCD1CONbits.ZCD1INTN            // bit 0
#define ZCD1INTP                ZCD1CONbits.ZCD1INTP            // bit 1
#define ZCD1POL                 ZCD1CONbits.ZCD1POL             // bit 4
#define ZCD1OUT                 ZCD1CONbits.ZCD1OUT             // bit 5
#define ZCD1EN                  ZCD1CONbits.ZCD1EN              // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16LF1619_H__
