/*
 * This declarations of the PIC16LF18855 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:25 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16LF18855_H__
#define __PIC16LF18855_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTB_ADDR              0x000D
#define PORTC_ADDR              0x000E
#define PORTE_ADDR              0x0010
#define TRISA_ADDR              0x0011
#define TRISB_ADDR              0x0012
#define TRISC_ADDR              0x0013
#define LATA_ADDR               0x0016
#define LATB_ADDR               0x0017
#define LATC_ADDR               0x0018
#define TMR0_ADDR               0x001C
#define TMR0L_ADDR              0x001C
#define PR0_ADDR                0x001D
#define TMR0H_ADDR              0x001D
#define T0CON0_ADDR             0x001E
#define T0CON1_ADDR             0x001F
#define ADRES_ADDR              0x008C
#define ADRESL_ADDR             0x008C
#define ADRESH_ADDR             0x008D
#define ADPREV_ADDR             0x008E
#define ADPREVL_ADDR            0x008E
#define ADPREVH_ADDR            0x008F
#define ADACC_ADDR              0x0090
#define ADACCL_ADDR             0x0090
#define ADACCH_ADDR             0x0091
#define ADCON0_ADDR             0x0093
#define ADCON1_ADDR             0x0094
#define ADCON2_ADDR             0x0095
#define ADCON3_ADDR             0x0096
#define ADSTAT_ADDR             0x0097
#define ADCLK_ADDR              0x0098
#define ADACT_ADDR              0x0099
#define ADREF_ADDR              0x009A
#define ADCAP_ADDR              0x009B
#define ADPRE_ADDR              0x009C
#define ADACQ_ADDR              0x009D
#define ADPCH_ADDR              0x009E
#define ADCNT_ADDR              0x010C
#define ADRPT_ADDR              0x010D
#define ADLTH_ADDR              0x010E
#define ADLTHL_ADDR             0x010E
#define ADLTHH_ADDR             0x010F
#define ADUTH_ADDR              0x0110
#define ADUTHL_ADDR             0x0110
#define ADUTHH_ADDR             0x0111
#define ADSTPT_ADDR             0x0112
#define ADSTPTL_ADDR            0x0112
#define ADSTPTH_ADDR            0x0113
#define ADFLTR_ADDR             0x0114
#define ADFLTRL_ADDR            0x0114
#define ADFLTRH_ADDR            0x0115
#define ADERR_ADDR              0x0116
#define ADERRL_ADDR             0x0116
#define ADERRH_ADDR             0x0117
#define RC1REG_ADDR             0x0119
#define RCREG_ADDR              0x0119
#define RCREG1_ADDR             0x0119
#define TX1REG_ADDR             0x011A
#define TXREG_ADDR              0x011A
#define TXREG1_ADDR             0x011A
#define SP1BRG_ADDR             0x011B
#define SP1BRGL_ADDR            0x011B
#define SPBRG_ADDR              0x011B
#define SPBRG1_ADDR             0x011B
#define SPBRGL_ADDR             0x011B
#define SP1BRGH_ADDR            0x011C
#define SPBRGH_ADDR             0x011C
#define SPBRGH1_ADDR            0x011C
#define RC1STA_ADDR             0x011D
#define RCSTA_ADDR              0x011D
#define RCSTA1_ADDR             0x011D
#define TX1STA_ADDR             0x011E
#define TXSTA_ADDR              0x011E
#define TXSTA1_ADDR             0x011E
#define BAUD1CON_ADDR           0x011F
#define BAUDCON_ADDR            0x011F
#define BAUDCON1_ADDR           0x011F
#define BAUDCTL_ADDR            0x011F
#define BAUDCTL1_ADDR           0x011F
#define SSP1BUF_ADDR            0x018C
#define SSP1ADD_ADDR            0x018D
#define SSP1MSK_ADDR            0x018E
#define SSP1STAT_ADDR           0x018F
#define SSP1CON1_ADDR           0x0190
#define SSP1CON2_ADDR           0x0191
#define SSP1CON3_ADDR           0x0192
#define SSP2BUF_ADDR            0x0196
#define SSP2ADD_ADDR            0x0197
#define SSP2MSK_ADDR            0x0198
#define SSP2STAT_ADDR           0x0199
#define SSP2CON1_ADDR           0x019A
#define SSP2CON2_ADDR           0x019B
#define SSP2CON3_ADDR           0x019C
#define TMR1L_ADDR              0x020C
#define TMR1H_ADDR              0x020D
#define T1CON_ADDR              0x020E
#define PR1_ADDR                0x020F
#define T1GCON_ADDR             0x020F
#define T1GATE_ADDR             0x0210
#define TMR1GATE_ADDR           0x0210
#define T1CLK_ADDR              0x0211
#define TMR1CLK_ADDR            0x0211
#define TMR3L_ADDR              0x0212
#define TMR3H_ADDR              0x0213
#define T3CON_ADDR              0x0214
#define PR3_ADDR                0x0215
#define T3GCON_ADDR             0x0215
#define T3GATE_ADDR             0x0216
#define TMR3GATE_ADDR           0x0216
#define T3CLK_ADDR              0x0217
#define TMR3CLK_ADDR            0x0217
#define TMR5L_ADDR              0x0218
#define TMR5H_ADDR              0x0219
#define T5CON_ADDR              0x021A
#define PR5_ADDR                0x021B
#define T5GCON_ADDR             0x021B
#define T5GATE_ADDR             0x021C
#define TMR5GATE_ADDR           0x021C
#define T5CLK_ADDR              0x021D
#define TMR5CLK_ADDR            0x021D
#define CCPTMRS0_ADDR           0x021E
#define CCPTMRS1_ADDR           0x021F
#define T2TMR_ADDR              0x028C
#define TMR2_ADDR               0x028C
#define PR2_ADDR                0x028D
#define T2PR_ADDR               0x028D
#define T2CON_ADDR              0x028E
#define T2HLT_ADDR              0x028F
#define T2CLKCON_ADDR           0x0290
#define T2RST_ADDR              0x0291
#define T4TMR_ADDR              0x0292
#define TMR4_ADDR               0x0292
#define PR4_ADDR                0x0293
#define T4PR_ADDR               0x0293
#define T4CON_ADDR              0x0294
#define T4HLT_ADDR              0x0295
#define T4CLKCON_ADDR           0x0296
#define T4RST_ADDR              0x0297
#define T6TMR_ADDR              0x0298
#define TMR6_ADDR               0x0298
#define PR6_ADDR                0x0299
#define T6PR_ADDR               0x0299
#define T6CON_ADDR              0x029A
#define T6HLT_ADDR              0x029B
#define T6CLKCON_ADDR           0x029C
#define T6RST_ADDR              0x029D
#define CCPR1_ADDR              0x030C
#define CCPR1L_ADDR             0x030C
#define CCPR1H_ADDR             0x030D
#define CCP1CON_ADDR            0x030E
#define CCP1CAP_ADDR            0x030F
#define CCPR2_ADDR              0x0310
#define CCPR2L_ADDR             0x0310
#define CCPR2H_ADDR             0x0311
#define CCP2CON_ADDR            0x0312
#define CCP2CAP_ADDR            0x0313
#define CCPR3_ADDR              0x0314
#define CCPR3L_ADDR             0x0314
#define CCPR3H_ADDR             0x0315
#define CCP3CON_ADDR            0x0316
#define CCP3CAP_ADDR            0x0317
#define CCPR4_ADDR              0x0318
#define CCPR4L_ADDR             0x0318
#define CCPR4H_ADDR             0x0319
#define CCP4CON_ADDR            0x031A
#define CCP4CAP_ADDR            0x031B
#define CCPR5_ADDR              0x031C
#define CCPR5L_ADDR             0x031C
#define CCPR5H_ADDR             0x031D
#define CCP5CON_ADDR            0x031E
#define CCP5CAP_ADDR            0x031F
#define PWM6DCL_ADDR            0x038C
#define PWM6DCH_ADDR            0x038D
#define PWM6CON_ADDR            0x038E
#define PWM7DCL_ADDR            0x0390
#define PWM7DCH_ADDR            0x0391
#define PWM7CON_ADDR            0x0392
#define SCANLADRL_ADDR          0x040C
#define SCANLADRH_ADDR          0x040D
#define SCANHADRL_ADDR          0x040E
#define SCANHADRH_ADDR          0x040F
#define SCANCON0_ADDR           0x0410
#define SCANTRIG_ADDR           0x0411
#define CRCDATA_ADDR            0x0416
#define CRCDATL_ADDR            0x0416
#define CRCDATH_ADDR            0x0417
#define CRCACC_ADDR             0x0418
#define CRCACCL_ADDR            0x0418
#define CRCACCH_ADDR            0x0419
#define CRCSHFT_ADDR            0x041A
#define CRCSHIFTL_ADDR          0x041A
#define CRCSHIFTH_ADDR          0x041B
#define CRCXOR_ADDR             0x041C
#define CRCXORL_ADDR            0x041C
#define CRCXORH_ADDR            0x041D
#define CRCCON0_ADDR            0x041E
#define CRCCON1_ADDR            0x041F
#define SMT1TMR_ADDR            0x048C
#define SMT1TMRL_ADDR           0x048C
#define SMT1TMRH_ADDR           0x048D
#define SMT1TMRU_ADDR           0x048E
#define SMT1CPR_ADDR            0x048F
#define SMT1CPRL_ADDR           0x048F
#define SMT1CPRH_ADDR           0x0490
#define SMT1CPRU_ADDR           0x0491
#define SMT1CPW_ADDR            0x0492
#define SMT1CPWL_ADDR           0x0492
#define SMT1CPWH_ADDR           0x0493
#define SMT1CPWU_ADDR           0x0494
#define SMT1PR_ADDR             0x0495
#define SMT1PRL_ADDR            0x0495
#define SMT1PRH_ADDR            0x0496
#define SMT1PRU_ADDR            0x0497
#define SMT1CON0_ADDR           0x0498
#define SMT1CON1_ADDR           0x0499
#define SMT1STAT_ADDR           0x049A
#define SMT1CLK_ADDR            0x049B
#define SMT1SIG_ADDR            0x049C
#define SMT1WIN_ADDR            0x049D
#define SMT2TMR_ADDR            0x050C
#define SMT2TMRL_ADDR           0x050C
#define SMT2TMRH_ADDR           0x050D
#define SMT2TMRU_ADDR           0x050E
#define SMT2CPR_ADDR            0x050F
#define SMT2CPRL_ADDR           0x050F
#define SMT2CPRH_ADDR           0x0510
#define SMT2CPRU_ADDR           0x0511
#define SMT2CPW_ADDR            0x0512
#define SMT2CPWL_ADDR           0x0512
#define SMT2CPWH_ADDR           0x0513
#define SMT2CPWU_ADDR           0x0514
#define SMT2PR_ADDR             0x0515
#define SMT2PRL_ADDR            0x0515
#define SMT2PRH_ADDR            0x0516
#define SMT2PRU_ADDR            0x0517
#define SMT2CON0_ADDR           0x0518
#define SMT2CON1_ADDR           0x0519
#define SMT2STAT_ADDR           0x051A
#define SMT2CLK_ADDR            0x051B
#define SMT2SIG_ADDR            0x051C
#define SMT2WIN_ADDR            0x051D
#define NCO1ACC_ADDR            0x058C
#define NCO1ACCL_ADDR           0x058C
#define NCO1ACCH_ADDR           0x058D
#define NCO1ACCU_ADDR           0x058E
#define NCO1INC_ADDR            0x058F
#define NCO1INCL_ADDR           0x058F
#define NCO1INCH_ADDR           0x0590
#define NCO1INCU_ADDR           0x0591
#define NCO1CON_ADDR            0x0592
#define NCO1CLK_ADDR            0x0593
#define CWG1CLKCON_ADDR         0x060C
#define CWG1ISM_ADDR            0x060D
#define CWG1DBR_ADDR            0x060E
#define CWG1DBF_ADDR            0x060F
#define CWG1CON0_ADDR           0x0610
#define CWG1CON1_ADDR           0x0611
#define CWG1AS0_ADDR            0x0612
#define CWG1AS1_ADDR            0x0613
#define CWG1STR_ADDR            0x0614
#define CWG2CLKCON_ADDR         0x0616
#define CWG2ISM_ADDR            0x0617
#define CWG2DBR_ADDR            0x0618
#define CWG2DBF_ADDR            0x0619
#define CWG2CON0_ADDR           0x061A
#define CWG2CON1_ADDR           0x061B
#define CWG2AS0_ADDR            0x061C
#define CWG2AS1_ADDR            0x061D
#define CWG2STR_ADDR            0x061E
#define CWG3CLKCON_ADDR         0x068C
#define CWG3ISM_ADDR            0x068D
#define CWG3DBR_ADDR            0x068E
#define CWG3DBF_ADDR            0x068F
#define CWG3CON0_ADDR           0x0690
#define CWG3CON1_ADDR           0x0691
#define CWG3AS0_ADDR            0x0692
#define CWG3AS1_ADDR            0x0693
#define CWG3STR_ADDR            0x0694
#define PIR0_ADDR               0x070C
#define PIR1_ADDR               0x070D
#define PIR2_ADDR               0x070E
#define PIR3_ADDR               0x070F
#define PIR4_ADDR               0x0710
#define PIR5_ADDR               0x0711
#define PIR6_ADDR               0x0712
#define PIR7_ADDR               0x0713
#define PIR8_ADDR               0x0714
#define PIE0_ADDR               0x0716
#define PIE1_ADDR               0x0717
#define PIE2_ADDR               0x0718
#define PIE3_ADDR               0x0719
#define PIE4_ADDR               0x071A
#define PIE5_ADDR               0x071B
#define PIE6_ADDR               0x071C
#define PIE7_ADDR               0x071D
#define PIE8_ADDR               0x071E
#define PMD0_ADDR               0x0796
#define PMD1_ADDR               0x0797
#define PMD2_ADDR               0x0798
#define PMD3_ADDR               0x0799
#define PMD4_ADDR               0x079A
#define PMD5_ADDR               0x079B
#define WDTCON0_ADDR            0x080C
#define WDTCON1_ADDR            0x080D
#define WDTPSL_ADDR             0x080E
#define WDTPSH_ADDR             0x080F
#define WDTTMR_ADDR             0x0810
#define BORCON_ADDR             0x0811
#define PCON0_ADDR              0x0813
#define CCDCON_ADDR             0x0814
#define NVMADRL_ADDR            0x081A
#define NVMADRH_ADDR            0x081B
#define NVMDATL_ADDR            0x081C
#define NVMDATH_ADDR            0x081D
#define NVMCON1_ADDR            0x081E
#define NVMCON2_ADDR            0x081F
#define CPUDOZE_ADDR            0x088C
#define OSCCON1_ADDR            0x088D
#define OSCCON2_ADDR            0x088E
#define OSCCON3_ADDR            0x088F
#define OSCSTAT_ADDR            0x0890
#define OSCEN_ADDR              0x0891
#define OSCTUNE_ADDR            0x0892
#define OSCFRQ_ADDR             0x0893
#define CLKRCON_ADDR            0x0895
#define CLKRCLK_ADDR            0x0896
#define MDCON0_ADDR             0x0897
#define MDCON1_ADDR             0x0898
#define MDSRC_ADDR              0x0899
#define MDCARL_ADDR             0x089A
#define MDCARH_ADDR             0x089B
#define FVRCON_ADDR             0x090C
#define DAC1CON0_ADDR           0x090E
#define DAC1CON1_ADDR           0x090F
#define ZCD1CON_ADDR            0x091F
#define ZCDCON_ADDR             0x091F
#define CMOUT_ADDR              0x098F
#define CMSTAT_ADDR             0x098F
#define CM1CON0_ADDR            0x0990
#define CM1CON1_ADDR            0x0991
#define CM1NSEL_ADDR            0x0992
#define CM1PSEL_ADDR            0x0993
#define CM2CON0_ADDR            0x0994
#define CM2CON1_ADDR            0x0995
#define CM2NSEL_ADDR            0x0996
#define CM2PSEL_ADDR            0x0997
#define CLCDATA_ADDR            0x0E0F
#define CLC1CON_ADDR            0x0E10
#define CLC1POL_ADDR            0x0E11
#define CLC1SEL0_ADDR           0x0E12
#define CLC1SEL1_ADDR           0x0E13
#define CLC1SEL2_ADDR           0x0E14
#define CLC1SEL3_ADDR           0x0E15
#define CLC1GLS0_ADDR           0x0E16
#define CLC1GLS1_ADDR           0x0E17
#define CLC1GLS2_ADDR           0x0E18
#define CLC1GLS3_ADDR           0x0E19
#define CLC2CON_ADDR            0x0E1A
#define CLC2POL_ADDR            0x0E1B
#define CLC2SEL0_ADDR           0x0E1C
#define CLC2SEL1_ADDR           0x0E1D
#define CLC2SEL2_ADDR           0x0E1E
#define CLC2SEL3_ADDR           0x0E1F
#define CLC2GLS0_ADDR           0x0E20
#define CLC2GLS1_ADDR           0x0E21
#define CLC2GLS2_ADDR           0x0E22
#define CLC2GLS3_ADDR           0x0E23
#define CLC3CON_ADDR            0x0E24
#define CLC3POL_ADDR            0x0E25
#define CLC3SEL0_ADDR           0x0E26
#define CLC3SEL1_ADDR           0x0E27
#define CLC3SEL2_ADDR           0x0E28
#define CLC3SEL3_ADDR           0x0E29
#define CLC3GLS0_ADDR           0x0E2A
#define CLC3GLS1_ADDR           0x0E2B
#define CLC3GLS2_ADDR           0x0E2C
#define CLC3GLS3_ADDR           0x0E2D
#define CLC4CON_ADDR            0x0E2E
#define CLC4POL_ADDR            0x0E2F
#define CLC4SEL0_ADDR           0x0E30
#define CLC4SEL1_ADDR           0x0E31
#define CLC4SEL2_ADDR           0x0E32
#define CLC4SEL3_ADDR           0x0E33
#define CLC4GLS0_ADDR           0x0E34
#define CLC4GLS1_ADDR           0x0E35
#define CLC4GLS2_ADDR           0x0E36
#define CLC4GLS3_ADDR           0x0E37
#define PPSLOCK_ADDR            0x0E8F
#define INTPPS_ADDR             0x0E90
#define T0CKIPPS_ADDR           0x0E91
#define T1CKIPPS_ADDR           0x0E92
#define T1GPPS_ADDR             0x0E93
#define T3CKIPPS_ADDR           0x0E94
#define T3GPPS_ADDR             0x0E95
#define T5CKIPPS_ADDR           0x0E96
#define T5GPPS_ADDR             0x0E97
#define T2AINPPS_ADDR           0x0E9C
#define T4AINPPS_ADDR           0x0E9D
#define T6AINPPS_ADDR           0x0E9E
#define CCP1PPS_ADDR            0x0EA1
#define CCP2PPS_ADDR            0x0EA2
#define CCP3PPS_ADDR            0x0EA3
#define CCP4PPS_ADDR            0x0EA4
#define CCP5PPS_ADDR            0x0EA5
#define SMT1WINPPS_ADDR         0x0EA9
#define SMT1SIGPPS_ADDR         0x0EAA
#define SMT2WINPPS_ADDR         0x0EAB
#define SMT2SIGPPS_ADDR         0x0EAC
#define CWG1PPS_ADDR            0x0EB1
#define CWG2PPS_ADDR            0x0EB2
#define CWG3PPS_ADDR            0x0EB3
#define MDCARLPPS_ADDR          0x0EB8
#define MDCARHPPS_ADDR          0x0EB9
#define MDSRCPPS_ADDR           0x0EBA
#define CLCIN0PPS_ADDR          0x0EBB
#define CLCIN1PPS_ADDR          0x0EBC
#define CLCIN2PPS_ADDR          0x0EBD
#define CLCIN3PPS_ADDR          0x0EBE
#define ADCACTPPS_ADDR          0x0EC3
#define SSP1CLKPPS_ADDR         0x0EC5
#define SSP1DATPPS_ADDR         0x0EC6
#define SSP1SSPPS_ADDR          0x0EC7
#define SSP2CLKPPS_ADDR         0x0EC8
#define SSP2DATPPS_ADDR         0x0EC9
#define SSP2SSPPS_ADDR          0x0ECA
#define RXPPS_ADDR              0x0ECB
#define TXPPS_ADDR              0x0ECC
#define RA0PPS_ADDR             0x0F10
#define RA1PPS_ADDR             0x0F11
#define RA2PPS_ADDR             0x0F12
#define RA3PPS_ADDR             0x0F13
#define RA4PPS_ADDR             0x0F14
#define RA5PPS_ADDR             0x0F15
#define RA6PPS_ADDR             0x0F16
#define RA7PPS_ADDR             0x0F17
#define RB0PPS_ADDR             0x0F18
#define RB1PPS_ADDR             0x0F19
#define RB2PPS_ADDR             0x0F1A
#define RB3PPS_ADDR             0x0F1B
#define RB4PPS_ADDR             0x0F1C
#define RB5PPS_ADDR             0x0F1D
#define RB6PPS_ADDR             0x0F1E
#define RB7PPS_ADDR             0x0F1F
#define RC0PPS_ADDR             0x0F20
#define RC1PPS_ADDR             0x0F21
#define RC2PPS_ADDR             0x0F22
#define RC3PPS_ADDR             0x0F23
#define RC4PPS_ADDR             0x0F24
#define RC5PPS_ADDR             0x0F25
#define RC6PPS_ADDR             0x0F26
#define RC7PPS_ADDR             0x0F27
#define ANSELA_ADDR             0x0F38
#define WPUA_ADDR               0x0F39
#define ODCONA_ADDR             0x0F3A
#define SLRCONA_ADDR            0x0F3B
#define INLVLA_ADDR             0x0F3C
#define IOCAP_ADDR              0x0F3D
#define IOCAN_ADDR              0x0F3E
#define IOCAF_ADDR              0x0F3F
#define CCDNA_ADDR              0x0F40
#define CCDPA_ADDR              0x0F41
#define ANSELB_ADDR             0x0F43
#define WPUB_ADDR               0x0F44
#define ODCONB_ADDR             0x0F45
#define SLRCONB_ADDR            0x0F46
#define INLVLB_ADDR             0x0F47
#define IOCBP_ADDR              0x0F48
#define IOCBN_ADDR              0x0F49
#define IOCBF_ADDR              0x0F4A
#define CCDNB_ADDR              0x0F4B
#define CCDPB_ADDR              0x0F4C
#define ANSELC_ADDR             0x0F4E
#define WPUC_ADDR               0x0F4F
#define ODCONC_ADDR             0x0F50
#define SLRCONC_ADDR            0x0F51
#define INLVLC_ADDR             0x0F52
#define IOCCP_ADDR              0x0F53
#define IOCCN_ADDR              0x0F54
#define IOCCF_ADDR              0x0F55
#define CCDNC_ADDR              0x0F56
#define CCDPC_ADDR              0x0F57
#define WPUE_ADDR               0x0F65
#define INLVLE_ADDR             0x0F68
#define IOCEP_ADDR              0x0F69
#define IOCEN_ADDR              0x0F6A
#define IOCEF_ADDR              0x0F6B
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef struct
  {
  unsigned INTEDG               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PEIE                 : 1;
  unsigned GIE                  : 1;
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _INTEDG                 0x01
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef struct
  {
  unsigned RA0                  : 1;
  unsigned RA1                  : 1;
  unsigned RA2                  : 1;
  unsigned RA3                  : 1;
  unsigned RA4                  : 1;
  unsigned RA5                  : 1;
  unsigned RA6                  : 1;
  unsigned RA7                  : 1;
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20
#define _RA6                    0x40
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x000D) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x000D) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _RB1                    0x02
#define _RB2                    0x04
#define _RB3                    0x08
#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0010) __sfr PORTE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RE3                  : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PORTEbits_t;

extern __at(0x0010) volatile __PORTEbits_t PORTEbits;

#define _RE3                    0x08

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0011) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x0011) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0012) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x0012) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0013) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x0013) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0016) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x0016) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x0017) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x0017) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0018) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x0018) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        TMR0 Bits

extern __at(0x001C) __sfr TMR0;

typedef struct
  {
  unsigned TMR0L0               : 1;
  unsigned TMR0L1               : 1;
  unsigned TMR0L2               : 1;
  unsigned TMR0L3               : 1;
  unsigned TMR0L4               : 1;
  unsigned TMR0L5               : 1;
  unsigned TMR0L6               : 1;
  unsigned TMR0L7               : 1;
  } __TMR0bits_t;

extern __at(0x001C) volatile __TMR0bits_t TMR0bits;

#define _TMR0L0                 0x01
#define _TMR0L1                 0x02
#define _TMR0L2                 0x04
#define _TMR0L3                 0x08
#define _TMR0L4                 0x10
#define _TMR0L5                 0x20
#define _TMR0L6                 0x40
#define _TMR0L7                 0x80

//==============================================================================


//==============================================================================
//        TMR0L Bits

extern __at(0x001C) __sfr TMR0L;

typedef struct
  {
  unsigned TMR0L0               : 1;
  unsigned TMR0L1               : 1;
  unsigned TMR0L2               : 1;
  unsigned TMR0L3               : 1;
  unsigned TMR0L4               : 1;
  unsigned TMR0L5               : 1;
  unsigned TMR0L6               : 1;
  unsigned TMR0L7               : 1;
  } __TMR0Lbits_t;

extern __at(0x001C) volatile __TMR0Lbits_t TMR0Lbits;

#define _TMR0L_TMR0L0           0x01
#define _TMR0L_TMR0L1           0x02
#define _TMR0L_TMR0L2           0x04
#define _TMR0L_TMR0L3           0x08
#define _TMR0L_TMR0L4           0x10
#define _TMR0L_TMR0L5           0x20
#define _TMR0L_TMR0L6           0x40
#define _TMR0L_TMR0L7           0x80

//==============================================================================


//==============================================================================
//        PR0 Bits

extern __at(0x001D) __sfr PR0;

typedef union
  {
  struct
    {
    unsigned TMR0H0             : 1;
    unsigned TMR0H1             : 1;
    unsigned TMR0H2             : 1;
    unsigned TMR0H3             : 1;
    unsigned TMR0H4             : 1;
    unsigned TMR0H5             : 1;
    unsigned TMR0H6             : 1;
    unsigned TMR0H7             : 1;
    };

  struct
    {
    unsigned T0PR0              : 1;
    unsigned T0PR1              : 1;
    unsigned T0PR2              : 1;
    unsigned T0PR3              : 1;
    unsigned T0PR4              : 1;
    unsigned T0PR5              : 1;
    unsigned T0PR6              : 1;
    unsigned T0PR7              : 1;
    };
  } __PR0bits_t;

extern __at(0x001D) volatile __PR0bits_t PR0bits;

#define _TMR0H0                 0x01
#define _T0PR0                  0x01
#define _TMR0H1                 0x02
#define _T0PR1                  0x02
#define _TMR0H2                 0x04
#define _T0PR2                  0x04
#define _TMR0H3                 0x08
#define _T0PR3                  0x08
#define _TMR0H4                 0x10
#define _T0PR4                  0x10
#define _TMR0H5                 0x20
#define _T0PR5                  0x20
#define _TMR0H6                 0x40
#define _T0PR6                  0x40
#define _TMR0H7                 0x80
#define _T0PR7                  0x80

//==============================================================================


//==============================================================================
//        TMR0H Bits

extern __at(0x001D) __sfr TMR0H;

typedef union
  {
  struct
    {
    unsigned TMR0H0             : 1;
    unsigned TMR0H1             : 1;
    unsigned TMR0H2             : 1;
    unsigned TMR0H3             : 1;
    unsigned TMR0H4             : 1;
    unsigned TMR0H5             : 1;
    unsigned TMR0H6             : 1;
    unsigned TMR0H7             : 1;
    };

  struct
    {
    unsigned T0PR0              : 1;
    unsigned T0PR1              : 1;
    unsigned T0PR2              : 1;
    unsigned T0PR3              : 1;
    unsigned T0PR4              : 1;
    unsigned T0PR5              : 1;
    unsigned T0PR6              : 1;
    unsigned T0PR7              : 1;
    };
  } __TMR0Hbits_t;

extern __at(0x001D) volatile __TMR0Hbits_t TMR0Hbits;

#define _TMR0H_TMR0H0           0x01
#define _TMR0H_T0PR0            0x01
#define _TMR0H_TMR0H1           0x02
#define _TMR0H_T0PR1            0x02
#define _TMR0H_TMR0H2           0x04
#define _TMR0H_T0PR2            0x04
#define _TMR0H_TMR0H3           0x08
#define _TMR0H_T0PR3            0x08
#define _TMR0H_TMR0H4           0x10
#define _TMR0H_T0PR4            0x10
#define _TMR0H_TMR0H5           0x20
#define _TMR0H_T0PR5            0x20
#define _TMR0H_TMR0H6           0x40
#define _TMR0H_T0PR6            0x40
#define _TMR0H_TMR0H7           0x80
#define _TMR0H_T0PR7            0x80

//==============================================================================


//==============================================================================
//        T0CON0 Bits

extern __at(0x001E) __sfr T0CON0;

typedef union
  {
  struct
    {
    unsigned T0OUTPS0           : 1;
    unsigned T0OUTPS1           : 1;
    unsigned T0OUTPS2           : 1;
    unsigned T0OUTPS3           : 1;
    unsigned T016BIT            : 1;
    unsigned T0OUT              : 1;
    unsigned                    : 1;
    unsigned T0EN               : 1;
    };

  struct
    {
    unsigned T0OUTPS            : 4;
    unsigned                    : 4;
    };
  } __T0CON0bits_t;

extern __at(0x001E) volatile __T0CON0bits_t T0CON0bits;

#define _T0OUTPS0               0x01
#define _T0OUTPS1               0x02
#define _T0OUTPS2               0x04
#define _T0OUTPS3               0x08
#define _T016BIT                0x10
#define _T0OUT                  0x20
#define _T0EN                   0x80

//==============================================================================


//==============================================================================
//        T0CON1 Bits

extern __at(0x001F) __sfr T0CON1;

typedef union
  {
  struct
    {
    unsigned T0CKPS0            : 1;
    unsigned T0CKPS1            : 1;
    unsigned T0CKPS2            : 1;
    unsigned T0CKPS3            : 1;
    unsigned T0ASYNC            : 1;
    unsigned T0CS0              : 1;
    unsigned T0CS1              : 1;
    unsigned T0CS2              : 1;
    };

  struct
    {
    unsigned T0PS0              : 1;
    unsigned T0PS1              : 1;
    unsigned T0PS2              : 1;
    unsigned T0PS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T0PS               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T0CKPS             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned T0CS               : 3;
    };
  } __T0CON1bits_t;

extern __at(0x001F) volatile __T0CON1bits_t T0CON1bits;

#define _T0CKPS0                0x01
#define _T0PS0                  0x01
#define _T0CKPS1                0x02
#define _T0PS1                  0x02
#define _T0CKPS2                0x04
#define _T0PS2                  0x04
#define _T0CKPS3                0x08
#define _T0PS3                  0x08
#define _T0ASYNC                0x10
#define _T0CS0                  0x20
#define _T0CS1                  0x40
#define _T0CS2                  0x80

//==============================================================================

extern __at(0x008C) __sfr ADRES;
extern __at(0x008C) __sfr ADRESL;
extern __at(0x008D) __sfr ADRESH;
extern __at(0x008E) __sfr ADPREV;

//==============================================================================
//        ADPREVL Bits

extern __at(0x008E) __sfr ADPREVL;

typedef struct
  {
  unsigned ADPREV0              : 1;
  unsigned ADPREV1              : 1;
  unsigned ADPREV2              : 1;
  unsigned ADPREV3              : 1;
  unsigned ADPREV4              : 1;
  unsigned ADPREV5              : 1;
  unsigned ADPREV6              : 1;
  unsigned ADPREV7              : 1;
  } __ADPREVLbits_t;

extern __at(0x008E) volatile __ADPREVLbits_t ADPREVLbits;

#define _ADPREV0                0x01
#define _ADPREV1                0x02
#define _ADPREV2                0x04
#define _ADPREV3                0x08
#define _ADPREV4                0x10
#define _ADPREV5                0x20
#define _ADPREV6                0x40
#define _ADPREV7                0x80

//==============================================================================


//==============================================================================
//        ADPREVH Bits

extern __at(0x008F) __sfr ADPREVH;

typedef struct
  {
  unsigned ADPREV8              : 1;
  unsigned ADPREV9              : 1;
  unsigned ADPREV10             : 1;
  unsigned ADPREV11             : 1;
  unsigned ADPREV12             : 1;
  unsigned ADPREV13             : 1;
  unsigned ADPREV14             : 1;
  unsigned ADPREV15             : 1;
  } __ADPREVHbits_t;

extern __at(0x008F) volatile __ADPREVHbits_t ADPREVHbits;

#define _ADPREV8                0x01
#define _ADPREV9                0x02
#define _ADPREV10               0x04
#define _ADPREV11               0x08
#define _ADPREV12               0x10
#define _ADPREV13               0x20
#define _ADPREV14               0x40
#define _ADPREV15               0x80

//==============================================================================

extern __at(0x0090) __sfr ADACC;

//==============================================================================
//        ADACCL Bits

extern __at(0x0090) __sfr ADACCL;

typedef struct
  {
  unsigned ADACC0               : 1;
  unsigned ADACC1               : 1;
  unsigned ADACC2               : 1;
  unsigned ADACC3               : 1;
  unsigned ADACC4               : 1;
  unsigned ADACC5               : 1;
  unsigned ADACC6               : 1;
  unsigned ADACC7               : 1;
  } __ADACCLbits_t;

extern __at(0x0090) volatile __ADACCLbits_t ADACCLbits;

#define _ADACC0                 0x01
#define _ADACC1                 0x02
#define _ADACC2                 0x04
#define _ADACC3                 0x08
#define _ADACC4                 0x10
#define _ADACC5                 0x20
#define _ADACC6                 0x40
#define _ADACC7                 0x80

//==============================================================================


//==============================================================================
//        ADACCH Bits

extern __at(0x0091) __sfr ADACCH;

typedef struct
  {
  unsigned ADACC8               : 1;
  unsigned ADACC9               : 1;
  unsigned ADACC10              : 1;
  unsigned ADACC11              : 1;
  unsigned ADACC12              : 1;
  unsigned ADACC13              : 1;
  unsigned ADACC14              : 1;
  unsigned ADACC15              : 1;
  } __ADACCHbits_t;

extern __at(0x0091) volatile __ADACCHbits_t ADACCHbits;

#define _ADACC8                 0x01
#define _ADACC9                 0x02
#define _ADACC10                0x04
#define _ADACC11                0x08
#define _ADACC12                0x10
#define _ADACC13                0x20
#define _ADACC14                0x40
#define _ADACC15                0x80

//==============================================================================


//==============================================================================
//        ADCON0 Bits

extern __at(0x0093) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned ADFM0              : 1;
    unsigned ADFM1              : 1;
    unsigned ADCS               : 1;
    unsigned                    : 1;
    unsigned ADCONT             : 1;
    unsigned ADON               : 1;
    };

  struct
    {
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned GO_NOT_DONE        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned ADFM               : 2;
    unsigned                    : 4;
    };
  } __ADCON0bits_t;

extern __at(0x0093) volatile __ADCON0bits_t ADCON0bits;

#define _ADGO                   0x01
#define _DONE                   0x01
#define _NOT_DONE               0x01
#define _GO                     0x01
#define _GO_NOT_DONE            0x01
#define _ADFM0                  0x04
#define _ADFM1                  0x08
#define _ADCS                   0x10
#define _ADCONT                 0x40
#define _ADON                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x0094) __sfr ADCON1;

typedef struct
  {
  unsigned ADDSEN               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADGPOL               : 1;
  unsigned ADIPEN               : 1;
  unsigned ADPPOL               : 1;
  } __ADCON1bits_t;

extern __at(0x0094) volatile __ADCON1bits_t ADCON1bits;

#define _ADDSEN                 0x01
#define _ADGPOL                 0x20
#define _ADIPEN                 0x40
#define _ADPPOL                 0x80

//==============================================================================


//==============================================================================
//        ADCON2 Bits

extern __at(0x0095) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned ADMD0              : 1;
    unsigned ADMD1              : 1;
    unsigned ADMD2              : 1;
    unsigned ADACLR             : 1;
    unsigned ADCRS0             : 1;
    unsigned ADCRS1             : 1;
    unsigned ADCRS2             : 1;
    unsigned ADPSIS             : 1;
    };

  struct
    {
    unsigned ADMD               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCRS              : 3;
    unsigned                    : 1;
    };
  } __ADCON2bits_t;

extern __at(0x0095) volatile __ADCON2bits_t ADCON2bits;

#define _ADMD0                  0x01
#define _ADMD1                  0x02
#define _ADMD2                  0x04
#define _ADACLR                 0x08
#define _ADCRS0                 0x10
#define _ADCRS1                 0x20
#define _ADCRS2                 0x40
#define _ADPSIS                 0x80

//==============================================================================


//==============================================================================
//        ADCON3 Bits

extern __at(0x0096) __sfr ADCON3;

typedef union
  {
  struct
    {
    unsigned ADTMD0             : 1;
    unsigned ADTMD1             : 1;
    unsigned ADTMD2             : 1;
    unsigned ADSOI              : 1;
    unsigned ADCALC0            : 1;
    unsigned ADCALC1            : 1;
    unsigned ADCALC2            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADTMD              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCALC             : 3;
    unsigned                    : 1;
    };
  } __ADCON3bits_t;

extern __at(0x0096) volatile __ADCON3bits_t ADCON3bits;

#define _ADTMD0                 0x01
#define _ADTMD1                 0x02
#define _ADTMD2                 0x04
#define _ADSOI                  0x08
#define _ADCALC0                0x10
#define _ADCALC1                0x20
#define _ADCALC2                0x40

//==============================================================================


//==============================================================================
//        ADSTAT Bits

extern __at(0x0097) __sfr ADSTAT;

typedef union
  {
  struct
    {
    unsigned ADSTAT0            : 1;
    unsigned ADSTAT1            : 1;
    unsigned ADSTAT2            : 1;
    unsigned ADMACT             : 1;
    unsigned ADMATH             : 1;
    unsigned ADLTHR             : 1;
    unsigned ADUTHR             : 1;
    unsigned ADAOV              : 1;
    };

  struct
    {
    unsigned ADSTAT             : 3;
    unsigned                    : 5;
    };
  } __ADSTATbits_t;

extern __at(0x0097) volatile __ADSTATbits_t ADSTATbits;

#define _ADSTAT0                0x01
#define _ADSTAT1                0x02
#define _ADSTAT2                0x04
#define _ADMACT                 0x08
#define _ADMATH                 0x10
#define _ADLTHR                 0x20
#define _ADUTHR                 0x40
#define _ADAOV                  0x80

//==============================================================================


//==============================================================================
//        ADCLK Bits

extern __at(0x0098) __sfr ADCLK;

typedef union
  {
  struct
    {
    unsigned ADCCS0             : 1;
    unsigned ADCCS1             : 1;
    unsigned ADCCS2             : 1;
    unsigned ADCCS3             : 1;
    unsigned ADCCS4             : 1;
    unsigned ADCCS5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADCCS              : 6;
    unsigned                    : 2;
    };
  } __ADCLKbits_t;

extern __at(0x0098) volatile __ADCLKbits_t ADCLKbits;

#define _ADCCS0                 0x01
#define _ADCCS1                 0x02
#define _ADCCS2                 0x04
#define _ADCCS3                 0x08
#define _ADCCS4                 0x10
#define _ADCCS5                 0x20

//==============================================================================


//==============================================================================
//        ADACT Bits

extern __at(0x0099) __sfr ADACT;

typedef union
  {
  struct
    {
    unsigned ADACT0             : 1;
    unsigned ADACT1             : 1;
    unsigned ADACT2             : 1;
    unsigned ADACT3             : 1;
    unsigned ADACT4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACT              : 5;
    unsigned                    : 3;
    };
  } __ADACTbits_t;

extern __at(0x0099) volatile __ADACTbits_t ADACTbits;

#define _ADACT0                 0x01
#define _ADACT1                 0x02
#define _ADACT2                 0x04
#define _ADACT3                 0x08
#define _ADACT4                 0x10

//==============================================================================


//==============================================================================
//        ADREF Bits

extern __at(0x009A) __sfr ADREF;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADNREF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };
  } __ADREFbits_t;

extern __at(0x009A) volatile __ADREFbits_t ADREFbits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADNREF                 0x10

//==============================================================================


//==============================================================================
//        ADCAP Bits

extern __at(0x009B) __sfr ADCAP;

typedef union
  {
  struct
    {
    unsigned ADCAP0             : 1;
    unsigned ADCAP1             : 1;
    unsigned ADCAP2             : 1;
    unsigned ADCAP3             : 1;
    unsigned ADCAP4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADCAP              : 5;
    unsigned                    : 3;
    };
  } __ADCAPbits_t;

extern __at(0x009B) volatile __ADCAPbits_t ADCAPbits;

#define _ADCAP0                 0x01
#define _ADCAP1                 0x02
#define _ADCAP2                 0x04
#define _ADCAP3                 0x08
#define _ADCAP4                 0x10

//==============================================================================


//==============================================================================
//        ADPRE Bits

extern __at(0x009C) __sfr ADPRE;

typedef struct
  {
  unsigned ADPRE0               : 1;
  unsigned ADPRE1               : 1;
  unsigned ADPRE2               : 1;
  unsigned ADPRE3               : 1;
  unsigned ADPRE4               : 1;
  unsigned ADPRE5               : 1;
  unsigned ADPRE6               : 1;
  unsigned ADPRE7               : 1;
  } __ADPREbits_t;

extern __at(0x009C) volatile __ADPREbits_t ADPREbits;

#define _ADPRE0                 0x01
#define _ADPRE1                 0x02
#define _ADPRE2                 0x04
#define _ADPRE3                 0x08
#define _ADPRE4                 0x10
#define _ADPRE5                 0x20
#define _ADPRE6                 0x40
#define _ADPRE7                 0x80

//==============================================================================


//==============================================================================
//        ADACQ Bits

extern __at(0x009D) __sfr ADACQ;

typedef struct
  {
  unsigned ADACQ0               : 1;
  unsigned ADACQ1               : 1;
  unsigned ADACQ2               : 1;
  unsigned ADACQ3               : 1;
  unsigned ADACQ4               : 1;
  unsigned ADACQ5               : 1;
  unsigned ADACQ6               : 1;
  unsigned ADACQ7               : 1;
  } __ADACQbits_t;

extern __at(0x009D) volatile __ADACQbits_t ADACQbits;

#define _ADACQ0                 0x01
#define _ADACQ1                 0x02
#define _ADACQ2                 0x04
#define _ADACQ3                 0x08
#define _ADACQ4                 0x10
#define _ADACQ5                 0x20
#define _ADACQ6                 0x40
#define _ADACQ7                 0x80

//==============================================================================


//==============================================================================
//        ADPCH Bits

extern __at(0x009E) __sfr ADPCH;

typedef union
  {
  struct
    {
    unsigned ADPCH0             : 1;
    unsigned ADPCH1             : 1;
    unsigned ADPCH2             : 1;
    unsigned ADPCH3             : 1;
    unsigned ADPCH4             : 1;
    unsigned ADPCH5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPCH              : 6;
    unsigned                    : 2;
    };
  } __ADPCHbits_t;

extern __at(0x009E) volatile __ADPCHbits_t ADPCHbits;

#define _ADPCH0                 0x01
#define _ADPCH1                 0x02
#define _ADPCH2                 0x04
#define _ADPCH3                 0x08
#define _ADPCH4                 0x10
#define _ADPCH5                 0x20

//==============================================================================


//==============================================================================
//        ADCNT Bits

extern __at(0x010C) __sfr ADCNT;

typedef struct
  {
  unsigned ADCNT0               : 1;
  unsigned ADCNT1               : 1;
  unsigned ADCNT2               : 1;
  unsigned ADCNT3               : 1;
  unsigned ADCNT4               : 1;
  unsigned ADCNT5               : 1;
  unsigned ADCNT6               : 1;
  unsigned ADCNT7               : 1;
  } __ADCNTbits_t;

extern __at(0x010C) volatile __ADCNTbits_t ADCNTbits;

#define _ADCNT0                 0x01
#define _ADCNT1                 0x02
#define _ADCNT2                 0x04
#define _ADCNT3                 0x08
#define _ADCNT4                 0x10
#define _ADCNT5                 0x20
#define _ADCNT6                 0x40
#define _ADCNT7                 0x80

//==============================================================================


//==============================================================================
//        ADRPT Bits

extern __at(0x010D) __sfr ADRPT;

typedef struct
  {
  unsigned ADRPT0               : 1;
  unsigned ADRPT1               : 1;
  unsigned ADRPT2               : 1;
  unsigned ADRPT3               : 1;
  unsigned ADRPT4               : 1;
  unsigned ADRPT5               : 1;
  unsigned ADRPT6               : 1;
  unsigned ADRPT7               : 1;
  } __ADRPTbits_t;

extern __at(0x010D) volatile __ADRPTbits_t ADRPTbits;

#define _ADRPT0                 0x01
#define _ADRPT1                 0x02
#define _ADRPT2                 0x04
#define _ADRPT3                 0x08
#define _ADRPT4                 0x10
#define _ADRPT5                 0x20
#define _ADRPT6                 0x40
#define _ADRPT7                 0x80

//==============================================================================

extern __at(0x010E) __sfr ADLTH;

//==============================================================================
//        ADLTHL Bits

extern __at(0x010E) __sfr ADLTHL;

typedef struct
  {
  unsigned ADLTH0               : 1;
  unsigned ADLTH1               : 1;
  unsigned ADLTH2               : 1;
  unsigned ADLTH3               : 1;
  unsigned ADLTH4               : 1;
  unsigned ADLTH5               : 1;
  unsigned ADLTH6               : 1;
  unsigned ADLTH7               : 1;
  } __ADLTHLbits_t;

extern __at(0x010E) volatile __ADLTHLbits_t ADLTHLbits;

#define _ADLTH0                 0x01
#define _ADLTH1                 0x02
#define _ADLTH2                 0x04
#define _ADLTH3                 0x08
#define _ADLTH4                 0x10
#define _ADLTH5                 0x20
#define _ADLTH6                 0x40
#define _ADLTH7                 0x80

//==============================================================================


//==============================================================================
//        ADLTHH Bits

extern __at(0x010F) __sfr ADLTHH;

typedef struct
  {
  unsigned ADLTH8               : 1;
  unsigned ADLTH9               : 1;
  unsigned ADLTH10              : 1;
  unsigned ADLTH11              : 1;
  unsigned ADLTH12              : 1;
  unsigned ADLTH13              : 1;
  unsigned ADLTH14              : 1;
  unsigned ADLTH15              : 1;
  } __ADLTHHbits_t;

extern __at(0x010F) volatile __ADLTHHbits_t ADLTHHbits;

#define _ADLTH8                 0x01
#define _ADLTH9                 0x02
#define _ADLTH10                0x04
#define _ADLTH11                0x08
#define _ADLTH12                0x10
#define _ADLTH13                0x20
#define _ADLTH14                0x40
#define _ADLTH15                0x80

//==============================================================================

extern __at(0x0110) __sfr ADUTH;

//==============================================================================
//        ADUTHL Bits

extern __at(0x0110) __sfr ADUTHL;

typedef struct
  {
  unsigned ADUTH0               : 1;
  unsigned ADUTH1               : 1;
  unsigned ADUTH2               : 1;
  unsigned ADUTH3               : 1;
  unsigned ADUTH4               : 1;
  unsigned ADUTH5               : 1;
  unsigned ADUTH6               : 1;
  unsigned ADUTH7               : 1;
  } __ADUTHLbits_t;

extern __at(0x0110) volatile __ADUTHLbits_t ADUTHLbits;

#define _ADUTH0                 0x01
#define _ADUTH1                 0x02
#define _ADUTH2                 0x04
#define _ADUTH3                 0x08
#define _ADUTH4                 0x10
#define _ADUTH5                 0x20
#define _ADUTH6                 0x40
#define _ADUTH7                 0x80

//==============================================================================


//==============================================================================
//        ADUTHH Bits

extern __at(0x0111) __sfr ADUTHH;

typedef struct
  {
  unsigned ADUTH8               : 1;
  unsigned ADUTH9               : 1;
  unsigned ADUTH10              : 1;
  unsigned ADUTH11              : 1;
  unsigned ADUTH12              : 1;
  unsigned ADUTH13              : 1;
  unsigned ADUTH14              : 1;
  unsigned ADUTH15              : 1;
  } __ADUTHHbits_t;

extern __at(0x0111) volatile __ADUTHHbits_t ADUTHHbits;

#define _ADUTH8                 0x01
#define _ADUTH9                 0x02
#define _ADUTH10                0x04
#define _ADUTH11                0x08
#define _ADUTH12                0x10
#define _ADUTH13                0x20
#define _ADUTH14                0x40
#define _ADUTH15                0x80

//==============================================================================

extern __at(0x0112) __sfr ADSTPT;

//==============================================================================
//        ADSTPTL Bits

extern __at(0x0112) __sfr ADSTPTL;

typedef struct
  {
  unsigned ADSTPT0              : 1;
  unsigned ADSTPT1              : 1;
  unsigned ADSTPT2              : 1;
  unsigned ADSTPT3              : 1;
  unsigned ADSTPT4              : 1;
  unsigned ADSTPT5              : 1;
  unsigned ADSTPT6              : 1;
  unsigned ADSTPT7              : 1;
  } __ADSTPTLbits_t;

extern __at(0x0112) volatile __ADSTPTLbits_t ADSTPTLbits;

#define _ADSTPT0                0x01
#define _ADSTPT1                0x02
#define _ADSTPT2                0x04
#define _ADSTPT3                0x08
#define _ADSTPT4                0x10
#define _ADSTPT5                0x20
#define _ADSTPT6                0x40
#define _ADSTPT7                0x80

//==============================================================================


//==============================================================================
//        ADSTPTH Bits

extern __at(0x0113) __sfr ADSTPTH;

typedef struct
  {
  unsigned ADSTPT8              : 1;
  unsigned ADSTPT9              : 1;
  unsigned ADSTPT10             : 1;
  unsigned ADSTPT11             : 1;
  unsigned ADSTPT12             : 1;
  unsigned ADSTPT13             : 1;
  unsigned ADSTPT14             : 1;
  unsigned ADSTPT15             : 1;
  } __ADSTPTHbits_t;

extern __at(0x0113) volatile __ADSTPTHbits_t ADSTPTHbits;

#define _ADSTPT8                0x01
#define _ADSTPT9                0x02
#define _ADSTPT10               0x04
#define _ADSTPT11               0x08
#define _ADSTPT12               0x10
#define _ADSTPT13               0x20
#define _ADSTPT14               0x40
#define _ADSTPT15               0x80

//==============================================================================

extern __at(0x0114) __sfr ADFLTR;

//==============================================================================
//        ADFLTRL Bits

extern __at(0x0114) __sfr ADFLTRL;

typedef struct
  {
  unsigned ADFLTR0              : 1;
  unsigned ADFLTR1              : 1;
  unsigned ADFLTR2              : 1;
  unsigned ADFLTR3              : 1;
  unsigned ADFLTR4              : 1;
  unsigned ADFLTR5              : 1;
  unsigned ADFLTR6              : 1;
  unsigned ADFLTR7              : 1;
  } __ADFLTRLbits_t;

extern __at(0x0114) volatile __ADFLTRLbits_t ADFLTRLbits;

#define _ADFLTR0                0x01
#define _ADFLTR1                0x02
#define _ADFLTR2                0x04
#define _ADFLTR3                0x08
#define _ADFLTR4                0x10
#define _ADFLTR5                0x20
#define _ADFLTR6                0x40
#define _ADFLTR7                0x80

//==============================================================================


//==============================================================================
//        ADFLTRH Bits

extern __at(0x0115) __sfr ADFLTRH;

typedef struct
  {
  unsigned ADFLTR8              : 1;
  unsigned ADFLTR9              : 1;
  unsigned ADFLTR10             : 1;
  unsigned ADFLTR11             : 1;
  unsigned ADFLTR12             : 1;
  unsigned ADFLTR13             : 1;
  unsigned ADFLTR14             : 1;
  unsigned ADFLTR15             : 1;
  } __ADFLTRHbits_t;

extern __at(0x0115) volatile __ADFLTRHbits_t ADFLTRHbits;

#define _ADFLTR8                0x01
#define _ADFLTR9                0x02
#define _ADFLTR10               0x04
#define _ADFLTR11               0x08
#define _ADFLTR12               0x10
#define _ADFLTR13               0x20
#define _ADFLTR14               0x40
#define _ADFLTR15               0x80

//==============================================================================

extern __at(0x0116) __sfr ADERR;

//==============================================================================
//        ADERRL Bits

extern __at(0x0116) __sfr ADERRL;

typedef struct
  {
  unsigned ADERR0               : 1;
  unsigned ADERR1               : 1;
  unsigned ADERR2               : 1;
  unsigned ADERR3               : 1;
  unsigned ADERR4               : 1;
  unsigned ADERR5               : 1;
  unsigned ADERR6               : 1;
  unsigned ADERR7               : 1;
  } __ADERRLbits_t;

extern __at(0x0116) volatile __ADERRLbits_t ADERRLbits;

#define _ADERR0                 0x01
#define _ADERR1                 0x02
#define _ADERR2                 0x04
#define _ADERR3                 0x08
#define _ADERR4                 0x10
#define _ADERR5                 0x20
#define _ADERR6                 0x40
#define _ADERR7                 0x80

//==============================================================================


//==============================================================================
//        ADERRH Bits

extern __at(0x0117) __sfr ADERRH;

typedef struct
  {
  unsigned ADERR8               : 1;
  unsigned ADERR9               : 1;
  unsigned ADERR10              : 1;
  unsigned ADERR11              : 1;
  unsigned ADERR12              : 1;
  unsigned ADERR13              : 1;
  unsigned ADERR14              : 1;
  unsigned ADERR15              : 1;
  } __ADERRHbits_t;

extern __at(0x0117) volatile __ADERRHbits_t ADERRHbits;

#define _ADERR8                 0x01
#define _ADERR9                 0x02
#define _ADERR10                0x04
#define _ADERR11                0x08
#define _ADERR12                0x10
#define _ADERR13                0x20
#define _ADERR14                0x40
#define _ADERR15                0x80

//==============================================================================

extern __at(0x0119) __sfr RC1REG;
extern __at(0x0119) __sfr RCREG;
extern __at(0x0119) __sfr RCREG1;
extern __at(0x011A) __sfr TX1REG;
extern __at(0x011A) __sfr TXREG;
extern __at(0x011A) __sfr TXREG1;
extern __at(0x011B) __sfr SP1BRG;
extern __at(0x011B) __sfr SP1BRGL;
extern __at(0x011B) __sfr SPBRG;
extern __at(0x011B) __sfr SPBRG1;
extern __at(0x011B) __sfr SPBRGL;
extern __at(0x011C) __sfr SP1BRGH;
extern __at(0x011C) __sfr SPBRGH;
extern __at(0x011C) __sfr SPBRGH1;

//==============================================================================
//        RC1STA Bits

extern __at(0x011D) __sfr RC1STA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RC1STAbits_t;

extern __at(0x011D) volatile __RC1STAbits_t RC1STAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x011D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x011D) volatile __RCSTAbits_t RCSTAbits;

#define _RCSTA_RX9D             0x01
#define _RCSTA_OERR             0x02
#define _RCSTA_FERR             0x04
#define _RCSTA_ADDEN            0x08
#define _RCSTA_CREN             0x10
#define _RCSTA_SREN             0x20
#define _RCSTA_RX9              0x40
#define _RCSTA_SPEN             0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x011D) __sfr RCSTA1;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTA1bits_t;

extern __at(0x011D) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_SPEN            0x80

//==============================================================================


//==============================================================================
//        TX1STA Bits

extern __at(0x011E) __sfr TX1STA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TX1STAbits_t;

extern __at(0x011E) volatile __TX1STAbits_t TX1STAbits;

#define _TX1STA_TX9D            0x01
#define _TX1STA_TRMT            0x02
#define _TX1STA_BRGH            0x04
#define _TX1STA_SENDB           0x08
#define _TX1STA_SYNC            0x10
#define _TX1STA_TXEN            0x20
#define _TX1STA_TX9             0x40
#define _TX1STA_CSRC            0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x011E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x011E) volatile __TXSTAbits_t TXSTAbits;

#define _TXSTA_TX9D             0x01
#define _TXSTA_TRMT             0x02
#define _TXSTA_BRGH             0x04
#define _TXSTA_SENDB            0x08
#define _TXSTA_SYNC             0x10
#define _TXSTA_TXEN             0x20
#define _TXSTA_TX9              0x40
#define _TXSTA_CSRC             0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x011E) __sfr TXSTA1;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTA1bits_t;

extern __at(0x011E) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_CSRC            0x80

//==============================================================================


//==============================================================================
//        BAUD1CON Bits

extern __at(0x011F) __sfr BAUD1CON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUD1CONbits_t;

extern __at(0x011F) volatile __BAUD1CONbits_t BAUD1CONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x011F) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x011F) volatile __BAUDCONbits_t BAUDCONbits;

#define _BAUDCON_ABDEN          0x01
#define _BAUDCON_WUE            0x02
#define _BAUDCON_BRG16          0x08
#define _BAUDCON_SCKP           0x10
#define _BAUDCON_RCIDL          0x40
#define _BAUDCON_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x011F) __sfr BAUDCON1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON1bits_t;

extern __at(0x011F) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_SCKP          0x10
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x011F) __sfr BAUDCTL;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTLbits_t;

extern __at(0x011F) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_SCKP           0x10
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCTL1 Bits

extern __at(0x011F) __sfr BAUDCTL1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTL1bits_t;

extern __at(0x011F) volatile __BAUDCTL1bits_t BAUDCTL1bits;

#define _BAUDCTL1_ABDEN         0x01
#define _BAUDCTL1_WUE           0x02
#define _BAUDCTL1_BRG16         0x08
#define _BAUDCTL1_SCKP          0x10
#define _BAUDCTL1_RCIDL         0x40
#define _BAUDCTL1_ABDOVF        0x80

//==============================================================================

extern __at(0x018C) __sfr SSP1BUF;
extern __at(0x018D) __sfr SSP1ADD;

//==============================================================================
//        SSP1MSK Bits

extern __at(0x018E) __sfr SSP1MSK;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSP1MSKbits_t;

extern __at(0x018E) volatile __SSP1MSKbits_t SSP1MSKbits;

#define _MSK0                   0x01
#define _MSK1                   0x02
#define _MSK2                   0x04
#define _MSK3                   0x08
#define _MSK4                   0x10
#define _MSK5                   0x20
#define _MSK6                   0x40
#define _MSK7                   0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x018F) __sfr SSP1STAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DAT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP1STATbits_t;

extern __at(0x018F) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _R_W                    0x04
#define _NOT_W                  0x04
#define _NOT_WRITE              0x04
#define _READ_WRITE             0x04
#define _I2C_READ               0x04
#define _S                      0x08
#define _I2C_START              0x08
#define _P                      0x10
#define _I2C_STOP               0x10
#define _D_NOT_A                0x20
#define _D_A                    0x20
#define _NOT_A                  0x20
#define _NOT_ADDRESS            0x20
#define _DATA_ADDRESS           0x20
#define _I2C_DAT                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0190) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0190) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0191) __sfr SSP1CON2;

typedef union
  {
  struct
    {
    unsigned SEN                : 1;
    unsigned RSEN               : 1;
    unsigned PEN                : 1;
    unsigned RCEN               : 1;
    unsigned ACKEN              : 1;
    unsigned ACKDT              : 1;
    unsigned ACKSTAT            : 1;
    unsigned GCEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADMSK1             : 1;
    unsigned ADMSK2             : 1;
    unsigned ADMSK3             : 1;
    unsigned ADMSK4             : 1;
    unsigned ADMSK5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP1CON2bits_t;

extern __at(0x0191) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _ADMSK1                 0x02
#define _PEN                    0x04
#define _ADMSK2                 0x04
#define _RCEN                   0x08
#define _ADMSK3                 0x08
#define _ACKEN                  0x10
#define _ADMSK4                 0x10
#define _ACKDT                  0x20
#define _ADMSK5                 0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0192) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0192) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================

extern __at(0x0196) __sfr SSP2BUF;
extern __at(0x0197) __sfr SSP2ADD;

//==============================================================================
//        SSP2MSK Bits

extern __at(0x0198) __sfr SSP2MSK;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSP2MSKbits_t;

extern __at(0x0198) volatile __SSP2MSKbits_t SSP2MSKbits;

#define _SSP2MSK_MSK0           0x01
#define _SSP2MSK_MSK1           0x02
#define _SSP2MSK_MSK2           0x04
#define _SSP2MSK_MSK3           0x08
#define _SSP2MSK_MSK4           0x10
#define _SSP2MSK_MSK5           0x20
#define _SSP2MSK_MSK6           0x40
#define _SSP2MSK_MSK7           0x80

//==============================================================================


//==============================================================================
//        SSP2STAT Bits

extern __at(0x0199) __sfr SSP2STAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DAT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP2STATbits_t;

extern __at(0x0199) volatile __SSP2STATbits_t SSP2STATbits;

#define _SSP2STAT_BF            0x01
#define _SSP2STAT_UA            0x02
#define _SSP2STAT_R_NOT_W       0x04
#define _SSP2STAT_R_W           0x04
#define _SSP2STAT_NOT_W         0x04
#define _SSP2STAT_NOT_WRITE     0x04
#define _SSP2STAT_READ_WRITE    0x04
#define _SSP2STAT_I2C_READ      0x04
#define _SSP2STAT_S             0x08
#define _SSP2STAT_I2C_START     0x08
#define _SSP2STAT_P             0x10
#define _SSP2STAT_I2C_STOP      0x10
#define _SSP2STAT_D_NOT_A       0x20
#define _SSP2STAT_D_A           0x20
#define _SSP2STAT_NOT_A         0x20
#define _SSP2STAT_NOT_ADDRESS   0x20
#define _SSP2STAT_DATA_ADDRESS  0x20
#define _SSP2STAT_I2C_DAT       0x20
#define _SSP2STAT_CKE           0x40
#define _SSP2STAT_SMP           0x80

//==============================================================================


//==============================================================================
//        SSP2CON1 Bits

extern __at(0x019A) __sfr SSP2CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP2CON1bits_t;

extern __at(0x019A) volatile __SSP2CON1bits_t SSP2CON1bits;

#define _SSP2CON1_SSPM0         0x01
#define _SSP2CON1_SSPM1         0x02
#define _SSP2CON1_SSPM2         0x04
#define _SSP2CON1_SSPM3         0x08
#define _SSP2CON1_CKP           0x10
#define _SSP2CON1_SSPEN         0x20
#define _SSP2CON1_SSPOV         0x40
#define _SSP2CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSP2CON2 Bits

extern __at(0x019B) __sfr SSP2CON2;

typedef union
  {
  struct
    {
    unsigned SEN                : 1;
    unsigned RSEN               : 1;
    unsigned PEN                : 1;
    unsigned RCEN               : 1;
    unsigned ACKEN              : 1;
    unsigned ACKDT              : 1;
    unsigned ACKSTAT            : 1;
    unsigned GCEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADMSK1             : 1;
    unsigned ADMSK2             : 1;
    unsigned ADMSK3             : 1;
    unsigned ADMSK4             : 1;
    unsigned ADMSK5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP2CON2bits_t;

extern __at(0x019B) volatile __SSP2CON2bits_t SSP2CON2bits;

#define _SSP2CON2_SEN           0x01
#define _SSP2CON2_RSEN          0x02
#define _SSP2CON2_ADMSK1        0x02
#define _SSP2CON2_PEN           0x04
#define _SSP2CON2_ADMSK2        0x04
#define _SSP2CON2_RCEN          0x08
#define _SSP2CON2_ADMSK3        0x08
#define _SSP2CON2_ACKEN         0x10
#define _SSP2CON2_ADMSK4        0x10
#define _SSP2CON2_ACKDT         0x20
#define _SSP2CON2_ADMSK5        0x20
#define _SSP2CON2_ACKSTAT       0x40
#define _SSP2CON2_GCEN          0x80

//==============================================================================


//==============================================================================
//        SSP2CON3 Bits

extern __at(0x019C) __sfr SSP2CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP2CON3bits_t;

extern __at(0x019C) volatile __SSP2CON3bits_t SSP2CON3bits;

#define _SSP2CON3_DHEN          0x01
#define _SSP2CON3_AHEN          0x02
#define _SSP2CON3_SBCDE         0x04
#define _SSP2CON3_SDAHT         0x08
#define _SSP2CON3_BOEN          0x10
#define _SSP2CON3_SCIE          0x20
#define _SSP2CON3_PCIE          0x40
#define _SSP2CON3_ACKTIM        0x80

//==============================================================================


//==============================================================================
//        TMR1L Bits

extern __at(0x020C) __sfr TMR1L;

typedef struct
  {
  unsigned TMR1L0               : 1;
  unsigned TMR1L1               : 1;
  unsigned TMR1L2               : 1;
  unsigned TMR1L3               : 1;
  unsigned TMR1L4               : 1;
  unsigned TMR1L5               : 1;
  unsigned TMR1L6               : 1;
  unsigned TMR1L7               : 1;
  } __TMR1Lbits_t;

extern __at(0x020C) volatile __TMR1Lbits_t TMR1Lbits;

#define _TMR1L0                 0x01
#define _TMR1L1                 0x02
#define _TMR1L2                 0x04
#define _TMR1L3                 0x08
#define _TMR1L4                 0x10
#define _TMR1L5                 0x20
#define _TMR1L6                 0x40
#define _TMR1L7                 0x80

//==============================================================================


//==============================================================================
//        TMR1H Bits

extern __at(0x020D) __sfr TMR1H;

typedef struct
  {
  unsigned TMR1H0               : 1;
  unsigned TMR1H1               : 1;
  unsigned TMR1H2               : 1;
  unsigned TMR1H3               : 1;
  unsigned TMR1H4               : 1;
  unsigned TMR1H5               : 1;
  unsigned TMR1H6               : 1;
  unsigned TMR1H7               : 1;
  } __TMR1Hbits_t;

extern __at(0x020D) volatile __TMR1Hbits_t TMR1Hbits;

#define _TMR1H0                 0x01
#define _TMR1H1                 0x02
#define _TMR1H2                 0x04
#define _TMR1H3                 0x08
#define _TMR1H4                 0x10
#define _TMR1H5                 0x20
#define _TMR1H6                 0x40
#define _TMR1H7                 0x80

//==============================================================================


//==============================================================================
//        T1CON Bits

extern __at(0x020E) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned ON                 : 1;
    unsigned RD16               : 1;
    unsigned NOT_SYNC           : 1;
    unsigned                    : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TMR1ON             : 1;
    unsigned T1RD16             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned                    : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x020E) volatile __T1CONbits_t T1CONbits;

#define _T1CON_ON               0x01
#define _T1CON_TMR1ON           0x01
#define _T1CON_RD16             0x02
#define _T1CON_T1RD16           0x02
#define _T1CON_NOT_SYNC         0x04
#define _T1CON_NOT_T1SYNC       0x04
#define _T1CON_T1CKPS0          0x10
#define _T1CON_CKPS0            0x10
#define _T1CON_T1CKPS1          0x20
#define _T1CON_CKPS1            0x20

//==============================================================================


//==============================================================================
//        PR1 Bits

extern __at(0x020F) __sfr PR1;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GVAL               : 1;
    unsigned GGO_NOT_DONE       : 1;
    unsigned GSPM               : 1;
    unsigned GTM                : 1;
    unsigned GPOL               : 1;
    unsigned GE                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned T1GE               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PR1bits_t;

extern __at(0x020F) volatile __PR1bits_t PR1bits;

#define _GVAL                   0x04
#define _T1GVAL                 0x04
#define _GGO_NOT_DONE           0x08
#define _T1GGO_NOT_DONE         0x08
#define _T1GGO                  0x08
#define _GSPM                   0x10
#define _T1GSPM                 0x10
#define _GTM                    0x20
#define _T1GTM                  0x20
#define _GPOL                   0x40
#define _T1GPOL                 0x40
#define _GE                     0x80
#define _T1GE                   0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x020F) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GVAL               : 1;
    unsigned GGO_NOT_DONE       : 1;
    unsigned GSPM               : 1;
    unsigned GTM                : 1;
    unsigned GPOL               : 1;
    unsigned GE                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned T1GE               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __T1GCONbits_t;

extern __at(0x020F) volatile __T1GCONbits_t T1GCONbits;

#define _T1GCON_GVAL            0x04
#define _T1GCON_T1GVAL          0x04
#define _T1GCON_GGO_NOT_DONE    0x08
#define _T1GCON_T1GGO_NOT_DONE  0x08
#define _T1GCON_T1GGO           0x08
#define _T1GCON_GSPM            0x10
#define _T1GCON_T1GSPM          0x10
#define _T1GCON_GTM             0x20
#define _T1GCON_T1GTM           0x20
#define _T1GCON_GPOL            0x40
#define _T1GCON_T1GPOL          0x40
#define _T1GCON_GE              0x80
#define _T1GCON_T1GE            0x80

//==============================================================================


//==============================================================================
//        T1GATE Bits

extern __at(0x0210) __sfr T1GATE;

typedef union
  {
  struct
    {
    unsigned GSS0               : 1;
    unsigned GSS1               : 1;
    unsigned GSS2               : 1;
    unsigned GSS3               : 1;
    unsigned GSS4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GSS2             : 1;
    unsigned T1GSS3             : 1;
    unsigned T1GSS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GSS              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned GSS                : 5;
    unsigned                    : 3;
    };
  } __T1GATEbits_t;

extern __at(0x0210) volatile __T1GATEbits_t T1GATEbits;

#define _GSS0                   0x01
#define _T1GSS0                 0x01
#define _GSS1                   0x02
#define _T1GSS1                 0x02
#define _GSS2                   0x04
#define _T1GSS2                 0x04
#define _GSS3                   0x08
#define _T1GSS3                 0x08
#define _GSS4                   0x10
#define _T1GSS4                 0x10

//==============================================================================


//==============================================================================
//        TMR1GATE Bits

extern __at(0x0210) __sfr TMR1GATE;

typedef union
  {
  struct
    {
    unsigned GSS0               : 1;
    unsigned GSS1               : 1;
    unsigned GSS2               : 1;
    unsigned GSS3               : 1;
    unsigned GSS4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GSS2             : 1;
    unsigned T1GSS3             : 1;
    unsigned T1GSS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned GSS                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned T1GSS              : 5;
    unsigned                    : 3;
    };
  } __TMR1GATEbits_t;

extern __at(0x0210) volatile __TMR1GATEbits_t TMR1GATEbits;

#define _TMR1GATE_GSS0          0x01
#define _TMR1GATE_T1GSS0        0x01
#define _TMR1GATE_GSS1          0x02
#define _TMR1GATE_T1GSS1        0x02
#define _TMR1GATE_GSS2          0x04
#define _TMR1GATE_T1GSS2        0x04
#define _TMR1GATE_GSS3          0x08
#define _TMR1GATE_T1GSS3        0x08
#define _TMR1GATE_GSS4          0x10
#define _TMR1GATE_T1GSS4        0x10

//==============================================================================


//==============================================================================
//        T1CLK Bits

extern __at(0x0211) __sfr T1CLK;

typedef union
  {
  struct
    {
    unsigned T1CS0              : 1;
    unsigned T1CS1              : 1;
    unsigned T1CS2              : 1;
    unsigned T1CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1CS               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };
  } __T1CLKbits_t;

extern __at(0x0211) volatile __T1CLKbits_t T1CLKbits;

#define _T1CS0                  0x01
#define _CS0                    0x01
#define _T1CS1                  0x02
#define _CS1                    0x02
#define _T1CS2                  0x04
#define _CS2                    0x04
#define _T1CS3                  0x08
#define _CS3                    0x08

//==============================================================================


//==============================================================================
//        TMR1CLK Bits

extern __at(0x0211) __sfr TMR1CLK;

typedef union
  {
  struct
    {
    unsigned T1CS0              : 1;
    unsigned T1CS1              : 1;
    unsigned T1CS2              : 1;
    unsigned T1CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T1CS               : 4;
    unsigned                    : 4;
    };
  } __TMR1CLKbits_t;

extern __at(0x0211) volatile __TMR1CLKbits_t TMR1CLKbits;

#define _TMR1CLK_T1CS0          0x01
#define _TMR1CLK_CS0            0x01
#define _TMR1CLK_T1CS1          0x02
#define _TMR1CLK_CS1            0x02
#define _TMR1CLK_T1CS2          0x04
#define _TMR1CLK_CS2            0x04
#define _TMR1CLK_T1CS3          0x08
#define _TMR1CLK_CS3            0x08

//==============================================================================


//==============================================================================
//        TMR3L Bits

extern __at(0x0212) __sfr TMR3L;

typedef struct
  {
  unsigned TMR3L0               : 1;
  unsigned TMR3L1               : 1;
  unsigned TMR3L2               : 1;
  unsigned TMR3L3               : 1;
  unsigned TMR3L4               : 1;
  unsigned TMR3L5               : 1;
  unsigned TMR3L6               : 1;
  unsigned TMR3L7               : 1;
  } __TMR3Lbits_t;

extern __at(0x0212) volatile __TMR3Lbits_t TMR3Lbits;

#define _TMR3L0                 0x01
#define _TMR3L1                 0x02
#define _TMR3L2                 0x04
#define _TMR3L3                 0x08
#define _TMR3L4                 0x10
#define _TMR3L5                 0x20
#define _TMR3L6                 0x40
#define _TMR3L7                 0x80

//==============================================================================


//==============================================================================
//        TMR3H Bits

extern __at(0x0213) __sfr TMR3H;

typedef struct
  {
  unsigned TMR3H0               : 1;
  unsigned TMR3H1               : 1;
  unsigned TMR3H2               : 1;
  unsigned TMR3H3               : 1;
  unsigned TMR3H4               : 1;
  unsigned TMR3H5               : 1;
  unsigned TMR3H6               : 1;
  unsigned TMR3H7               : 1;
  } __TMR3Hbits_t;

extern __at(0x0213) volatile __TMR3Hbits_t TMR3Hbits;

#define _TMR3H0                 0x01
#define _TMR3H1                 0x02
#define _TMR3H2                 0x04
#define _TMR3H3                 0x08
#define _TMR3H4                 0x10
#define _TMR3H5                 0x20
#define _TMR3H6                 0x40
#define _TMR3H7                 0x80

//==============================================================================


//==============================================================================
//        T3CON Bits

extern __at(0x0214) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned ON                 : 1;
    unsigned RD16               : 1;
    unsigned NOT_SYNC           : 1;
    unsigned                    : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TMR3ON             : 1;
    unsigned T3RD16             : 1;
    unsigned NOT_T3SYNC         : 1;
    unsigned                    : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };
  } __T3CONbits_t;

extern __at(0x0214) volatile __T3CONbits_t T3CONbits;

#define _T3CON_ON               0x01
#define _T3CON_TMR3ON           0x01
#define _T3CON_RD16             0x02
#define _T3CON_T3RD16           0x02
#define _T3CON_NOT_SYNC         0x04
#define _T3CON_NOT_T3SYNC       0x04
#define _T3CON_T3CKPS0          0x10
#define _T3CON_CKPS0            0x10
#define _T3CON_T3CKPS1          0x20
#define _T3CON_CKPS1            0x20

//==============================================================================


//==============================================================================
//        PR3 Bits

extern __at(0x0215) __sfr PR3;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GVAL               : 1;
    unsigned GGO_NOT_DONE       : 1;
    unsigned GSPM               : 1;
    unsigned GTM                : 1;
    unsigned GPOL               : 1;
    unsigned GE                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3GVAL             : 1;
    unsigned T3GGO_NOT_DONE     : 1;
    unsigned T3GSPM             : 1;
    unsigned T3GTM              : 1;
    unsigned T3GPOL             : 1;
    unsigned T3GE               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PR3bits_t;

extern __at(0x0215) volatile __PR3bits_t PR3bits;

#define _PR3_GVAL               0x04
#define _PR3_T3GVAL             0x04
#define _PR3_GGO_NOT_DONE       0x08
#define _PR3_T3GGO_NOT_DONE     0x08
#define _PR3_T3GGO              0x08
#define _PR3_GSPM               0x10
#define _PR3_T3GSPM             0x10
#define _PR3_GTM                0x20
#define _PR3_T3GTM              0x20
#define _PR3_GPOL               0x40
#define _PR3_T3GPOL             0x40
#define _PR3_GE                 0x80
#define _PR3_T3GE               0x80

//==============================================================================


//==============================================================================
//        T3GCON Bits

extern __at(0x0215) __sfr T3GCON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GVAL               : 1;
    unsigned GGO_NOT_DONE       : 1;
    unsigned GSPM               : 1;
    unsigned GTM                : 1;
    unsigned GPOL               : 1;
    unsigned GE                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3GVAL             : 1;
    unsigned T3GGO_NOT_DONE     : 1;
    unsigned T3GSPM             : 1;
    unsigned T3GTM              : 1;
    unsigned T3GPOL             : 1;
    unsigned T3GE               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __T3GCONbits_t;

extern __at(0x0215) volatile __T3GCONbits_t T3GCONbits;

#define _T3GCON_GVAL            0x04
#define _T3GCON_T3GVAL          0x04
#define _T3GCON_GGO_NOT_DONE    0x08
#define _T3GCON_T3GGO_NOT_DONE  0x08
#define _T3GCON_T3GGO           0x08
#define _T3GCON_GSPM            0x10
#define _T3GCON_T3GSPM          0x10
#define _T3GCON_GTM             0x20
#define _T3GCON_T3GTM           0x20
#define _T3GCON_GPOL            0x40
#define _T3GCON_T3GPOL          0x40
#define _T3GCON_GE              0x80
#define _T3GCON_T3GE            0x80

//==============================================================================


//==============================================================================
//        T3GATE Bits

extern __at(0x0216) __sfr T3GATE;

typedef union
  {
  struct
    {
    unsigned GSS0               : 1;
    unsigned GSS1               : 1;
    unsigned GSS2               : 1;
    unsigned GSS3               : 1;
    unsigned GSS4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3GSS0             : 1;
    unsigned T3GSS1             : 1;
    unsigned T3GSS2             : 1;
    unsigned T3GSS3             : 1;
    unsigned T3GSS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned GSS                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned T3GSS              : 5;
    unsigned                    : 3;
    };
  } __T3GATEbits_t;

extern __at(0x0216) volatile __T3GATEbits_t T3GATEbits;

#define _T3GATE_GSS0            0x01
#define _T3GATE_T3GSS0          0x01
#define _T3GATE_GSS1            0x02
#define _T3GATE_T3GSS1          0x02
#define _T3GATE_GSS2            0x04
#define _T3GATE_T3GSS2          0x04
#define _T3GATE_GSS3            0x08
#define _T3GATE_T3GSS3          0x08
#define _T3GATE_GSS4            0x10
#define _T3GATE_T3GSS4          0x10

//==============================================================================


//==============================================================================
//        TMR3GATE Bits

extern __at(0x0216) __sfr TMR3GATE;

typedef union
  {
  struct
    {
    unsigned GSS0               : 1;
    unsigned GSS1               : 1;
    unsigned GSS2               : 1;
    unsigned GSS3               : 1;
    unsigned GSS4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3GSS0             : 1;
    unsigned T3GSS1             : 1;
    unsigned T3GSS2             : 1;
    unsigned T3GSS3             : 1;
    unsigned T3GSS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3GSS              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned GSS                : 5;
    unsigned                    : 3;
    };
  } __TMR3GATEbits_t;

extern __at(0x0216) volatile __TMR3GATEbits_t TMR3GATEbits;

#define _TMR3GATE_GSS0          0x01
#define _TMR3GATE_T3GSS0        0x01
#define _TMR3GATE_GSS1          0x02
#define _TMR3GATE_T3GSS1        0x02
#define _TMR3GATE_GSS2          0x04
#define _TMR3GATE_T3GSS2        0x04
#define _TMR3GATE_GSS3          0x08
#define _TMR3GATE_T3GSS3        0x08
#define _TMR3GATE_GSS4          0x10
#define _TMR3GATE_T3GSS4        0x10

//==============================================================================


//==============================================================================
//        T3CLK Bits

extern __at(0x0217) __sfr T3CLK;

typedef union
  {
  struct
    {
    unsigned T3CS0              : 1;
    unsigned T3CS1              : 1;
    unsigned T3CS2              : 1;
    unsigned T3CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T3CS               : 4;
    unsigned                    : 4;
    };
  } __T3CLKbits_t;

extern __at(0x0217) volatile __T3CLKbits_t T3CLKbits;

#define _T3CLK_T3CS0            0x01
#define _T3CLK_CS0              0x01
#define _T3CLK_T3CS1            0x02
#define _T3CLK_CS1              0x02
#define _T3CLK_T3CS2            0x04
#define _T3CLK_CS2              0x04
#define _T3CLK_T3CS3            0x08
#define _T3CLK_CS3              0x08

//==============================================================================


//==============================================================================
//        TMR3CLK Bits

extern __at(0x0217) __sfr TMR3CLK;

typedef union
  {
  struct
    {
    unsigned T3CS0              : 1;
    unsigned T3CS1              : 1;
    unsigned T3CS2              : 1;
    unsigned T3CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3CS               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };
  } __TMR3CLKbits_t;

extern __at(0x0217) volatile __TMR3CLKbits_t TMR3CLKbits;

#define _TMR3CLK_T3CS0          0x01
#define _TMR3CLK_CS0            0x01
#define _TMR3CLK_T3CS1          0x02
#define _TMR3CLK_CS1            0x02
#define _TMR3CLK_T3CS2          0x04
#define _TMR3CLK_CS2            0x04
#define _TMR3CLK_T3CS3          0x08
#define _TMR3CLK_CS3            0x08

//==============================================================================


//==============================================================================
//        TMR5L Bits

extern __at(0x0218) __sfr TMR5L;

typedef struct
  {
  unsigned TMR5L0               : 1;
  unsigned TMR5L1               : 1;
  unsigned TMR5L2               : 1;
  unsigned TMR5L3               : 1;
  unsigned TMR5L4               : 1;
  unsigned TMR5L5               : 1;
  unsigned TMR5L6               : 1;
  unsigned TMR5L7               : 1;
  } __TMR5Lbits_t;

extern __at(0x0218) volatile __TMR5Lbits_t TMR5Lbits;

#define _TMR5L0                 0x01
#define _TMR5L1                 0x02
#define _TMR5L2                 0x04
#define _TMR5L3                 0x08
#define _TMR5L4                 0x10
#define _TMR5L5                 0x20
#define _TMR5L6                 0x40
#define _TMR5L7                 0x80

//==============================================================================


//==============================================================================
//        TMR5H Bits

extern __at(0x0219) __sfr TMR5H;

typedef struct
  {
  unsigned TMR5H0               : 1;
  unsigned TMR5H1               : 1;
  unsigned TMR5H2               : 1;
  unsigned TMR5H3               : 1;
  unsigned TMR5H4               : 1;
  unsigned TMR5H5               : 1;
  unsigned TMR5H6               : 1;
  unsigned TMR5H7               : 1;
  } __TMR5Hbits_t;

extern __at(0x0219) volatile __TMR5Hbits_t TMR5Hbits;

#define _TMR5H0                 0x01
#define _TMR5H1                 0x02
#define _TMR5H2                 0x04
#define _TMR5H3                 0x08
#define _TMR5H4                 0x10
#define _TMR5H5                 0x20
#define _TMR5H6                 0x40
#define _TMR5H7                 0x80

//==============================================================================


//==============================================================================
//        T5CON Bits

extern __at(0x021A) __sfr T5CON;

typedef union
  {
  struct
    {
    unsigned ON                 : 1;
    unsigned RD16               : 1;
    unsigned NOT_SYNC           : 1;
    unsigned                    : 1;
    unsigned T5CKPS0            : 1;
    unsigned T5CKPS1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TMR5ON             : 1;
    unsigned T5RD16             : 1;
    unsigned NOT_T5SYNC         : 1;
    unsigned                    : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T5CKPS             : 2;
    unsigned                    : 2;
    };
  } __T5CONbits_t;

extern __at(0x021A) volatile __T5CONbits_t T5CONbits;

#define _T5CON_ON               0x01
#define _T5CON_TMR5ON           0x01
#define _T5CON_RD16             0x02
#define _T5CON_T5RD16           0x02
#define _T5CON_NOT_SYNC         0x04
#define _T5CON_NOT_T5SYNC       0x04
#define _T5CON_T5CKPS0          0x10
#define _T5CON_CKPS0            0x10
#define _T5CON_T5CKPS1          0x20
#define _T5CON_CKPS1            0x20

//==============================================================================


//==============================================================================
//        PR5 Bits

extern __at(0x021B) __sfr PR5;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GVAL               : 1;
    unsigned GGO_NOT_DONE       : 1;
    unsigned GSPM               : 1;
    unsigned GTM                : 1;
    unsigned GPOL               : 1;
    unsigned GE                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T5GVAL             : 1;
    unsigned T5GGO_NOT_DONE     : 1;
    unsigned T5GSPM             : 1;
    unsigned T5GTM              : 1;
    unsigned T5GPOL             : 1;
    unsigned T5GE               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T5GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PR5bits_t;

extern __at(0x021B) volatile __PR5bits_t PR5bits;

#define _PR5_GVAL               0x04
#define _PR5_T5GVAL             0x04
#define _PR5_GGO_NOT_DONE       0x08
#define _PR5_T5GGO_NOT_DONE     0x08
#define _PR5_T5GGO              0x08
#define _PR5_GSPM               0x10
#define _PR5_T5GSPM             0x10
#define _PR5_GTM                0x20
#define _PR5_T5GTM              0x20
#define _PR5_GPOL               0x40
#define _PR5_T5GPOL             0x40
#define _PR5_GE                 0x80
#define _PR5_T5GE               0x80

//==============================================================================


//==============================================================================
//        T5GCON Bits

extern __at(0x021B) __sfr T5GCON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GVAL               : 1;
    unsigned GGO_NOT_DONE       : 1;
    unsigned GSPM               : 1;
    unsigned GTM                : 1;
    unsigned GPOL               : 1;
    unsigned GE                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T5GVAL             : 1;
    unsigned T5GGO_NOT_DONE     : 1;
    unsigned T5GSPM             : 1;
    unsigned T5GTM              : 1;
    unsigned T5GPOL             : 1;
    unsigned T5GE               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T5GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __T5GCONbits_t;

extern __at(0x021B) volatile __T5GCONbits_t T5GCONbits;

#define _T5GCON_GVAL            0x04
#define _T5GCON_T5GVAL          0x04
#define _T5GCON_GGO_NOT_DONE    0x08
#define _T5GCON_T5GGO_NOT_DONE  0x08
#define _T5GCON_T5GGO           0x08
#define _T5GCON_GSPM            0x10
#define _T5GCON_T5GSPM          0x10
#define _T5GCON_GTM             0x20
#define _T5GCON_T5GTM           0x20
#define _T5GCON_GPOL            0x40
#define _T5GCON_T5GPOL          0x40
#define _T5GCON_GE              0x80
#define _T5GCON_T5GE            0x80

//==============================================================================


//==============================================================================
//        T5GATE Bits

extern __at(0x021C) __sfr T5GATE;

typedef union
  {
  struct
    {
    unsigned GSS0               : 1;
    unsigned GSS1               : 1;
    unsigned GSS2               : 1;
    unsigned GSS3               : 1;
    unsigned GSS4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T5GSS0             : 1;
    unsigned T5GSS1             : 1;
    unsigned T5GSS2             : 1;
    unsigned T5GSS3             : 1;
    unsigned T5GSS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned GSS                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned T5GSS              : 5;
    unsigned                    : 3;
    };
  } __T5GATEbits_t;

extern __at(0x021C) volatile __T5GATEbits_t T5GATEbits;

#define _T5GATE_GSS0            0x01
#define _T5GATE_T5GSS0          0x01
#define _T5GATE_GSS1            0x02
#define _T5GATE_T5GSS1          0x02
#define _T5GATE_GSS2            0x04
#define _T5GATE_T5GSS2          0x04
#define _T5GATE_GSS3            0x08
#define _T5GATE_T5GSS3          0x08
#define _T5GATE_GSS4            0x10
#define _T5GATE_T5GSS4          0x10

//==============================================================================


//==============================================================================
//        TMR5GATE Bits

extern __at(0x021C) __sfr TMR5GATE;

typedef union
  {
  struct
    {
    unsigned GSS0               : 1;
    unsigned GSS1               : 1;
    unsigned GSS2               : 1;
    unsigned GSS3               : 1;
    unsigned GSS4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T5GSS0             : 1;
    unsigned T5GSS1             : 1;
    unsigned T5GSS2             : 1;
    unsigned T5GSS3             : 1;
    unsigned T5GSS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned GSS                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned T5GSS              : 5;
    unsigned                    : 3;
    };
  } __TMR5GATEbits_t;

extern __at(0x021C) volatile __TMR5GATEbits_t TMR5GATEbits;

#define _TMR5GATE_GSS0          0x01
#define _TMR5GATE_T5GSS0        0x01
#define _TMR5GATE_GSS1          0x02
#define _TMR5GATE_T5GSS1        0x02
#define _TMR5GATE_GSS2          0x04
#define _TMR5GATE_T5GSS2        0x04
#define _TMR5GATE_GSS3          0x08
#define _TMR5GATE_T5GSS3        0x08
#define _TMR5GATE_GSS4          0x10
#define _TMR5GATE_T5GSS4        0x10

//==============================================================================


//==============================================================================
//        T5CLK Bits

extern __at(0x021D) __sfr T5CLK;

typedef union
  {
  struct
    {
    unsigned T5CS0              : 1;
    unsigned T5CS1              : 1;
    unsigned T5CS2              : 1;
    unsigned T5CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T5CS               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };
  } __T5CLKbits_t;

extern __at(0x021D) volatile __T5CLKbits_t T5CLKbits;

#define _T5CLK_T5CS0            0x01
#define _T5CLK_CS0              0x01
#define _T5CLK_T5CS1            0x02
#define _T5CLK_CS1              0x02
#define _T5CLK_T5CS2            0x04
#define _T5CLK_CS2              0x04
#define _T5CLK_T5CS3            0x08
#define _T5CLK_CS3              0x08

//==============================================================================


//==============================================================================
//        TMR5CLK Bits

extern __at(0x021D) __sfr TMR5CLK;

typedef union
  {
  struct
    {
    unsigned T5CS0              : 1;
    unsigned T5CS1              : 1;
    unsigned T5CS2              : 1;
    unsigned T5CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T5CS               : 4;
    unsigned                    : 4;
    };
  } __TMR5CLKbits_t;

extern __at(0x021D) volatile __TMR5CLKbits_t TMR5CLKbits;

#define _TMR5CLK_T5CS0          0x01
#define _TMR5CLK_CS0            0x01
#define _TMR5CLK_T5CS1          0x02
#define _TMR5CLK_CS1            0x02
#define _TMR5CLK_T5CS2          0x04
#define _TMR5CLK_CS2            0x04
#define _TMR5CLK_T5CS3          0x08
#define _TMR5CLK_CS3            0x08

//==============================================================================


//==============================================================================
//        CCPTMRS0 Bits

extern __at(0x021E) __sfr CCPTMRS0;

typedef union
  {
  struct
    {
    unsigned C1TSEL0            : 1;
    unsigned C1TSEL1            : 1;
    unsigned C2TSEL0            : 1;
    unsigned C2TSEL1            : 1;
    unsigned C3TSEL0            : 1;
    unsigned C3TSEL1            : 1;
    unsigned C4TSEL0            : 1;
    unsigned C4TSEL1            : 1;
    };

  struct
    {
    unsigned C1TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned C2TSEL             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C3TSEL             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned C4TSEL             : 2;
    };
  } __CCPTMRS0bits_t;

extern __at(0x021E) volatile __CCPTMRS0bits_t CCPTMRS0bits;

#define _C1TSEL0                0x01
#define _C1TSEL1                0x02
#define _C2TSEL0                0x04
#define _C2TSEL1                0x08
#define _C3TSEL0                0x10
#define _C3TSEL1                0x20
#define _C4TSEL0                0x40
#define _C4TSEL1                0x80

//==============================================================================


//==============================================================================
//        CCPTMRS1 Bits

extern __at(0x021F) __sfr CCPTMRS1;

typedef union
  {
  struct
    {
    unsigned C5TSEL0            : 1;
    unsigned C5TSEL1            : 1;
    unsigned P6TSEL0            : 1;
    unsigned P6TSEL1            : 1;
    unsigned P7TSEL0            : 1;
    unsigned P7TSEL1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C5TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned P6TSEL             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned P7TSEL             : 2;
    unsigned                    : 2;
    };
  } __CCPTMRS1bits_t;

extern __at(0x021F) volatile __CCPTMRS1bits_t CCPTMRS1bits;

#define _C5TSEL0                0x01
#define _C5TSEL1                0x02
#define _P6TSEL0                0x04
#define _P6TSEL1                0x08
#define _P7TSEL0                0x10
#define _P7TSEL1                0x20

//==============================================================================

extern __at(0x028C) __sfr T2TMR;
extern __at(0x028C) __sfr TMR2;
extern __at(0x028D) __sfr PR2;
extern __at(0x028D) __sfr T2PR;

//==============================================================================
//        T2CON Bits

extern __at(0x028E) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned T2CKPS2            : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned T2ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR2ON             : 1;
    };

  struct
    {
    unsigned T2OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T2CKPS             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x028E) volatile __T2CONbits_t T2CONbits;

#define _T2CON_T2OUTPS0         0x01
#define _T2CON_OUTPS0           0x01
#define _T2CON_T2OUTPS1         0x02
#define _T2CON_OUTPS1           0x02
#define _T2CON_T2OUTPS2         0x04
#define _T2CON_OUTPS2           0x04
#define _T2CON_T2OUTPS3         0x08
#define _T2CON_OUTPS3           0x08
#define _T2CON_T2CKPS0          0x10
#define _T2CON_CKPS0            0x10
#define _T2CON_T2CKPS1          0x20
#define _T2CON_CKPS1            0x20
#define _T2CON_T2CKPS2          0x40
#define _T2CON_CKPS2            0x40
#define _T2CON_ON               0x80
#define _T2CON_T2ON             0x80
#define _T2CON_TMR2ON           0x80

//==============================================================================


//==============================================================================
//        T2HLT Bits

extern __at(0x028F) __sfr T2HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned MODE4              : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T2MODE0            : 1;
    unsigned T2MODE1            : 1;
    unsigned T2MODE2            : 1;
    unsigned T2MODE3            : 1;
    unsigned T2MODE4            : 1;
    unsigned T2CKSYNC           : 1;
    unsigned T2CKPOL            : 1;
    unsigned T2PSYNC            : 1;
    };

  struct
    {
    unsigned T2MODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MODE               : 5;
    unsigned                    : 3;
    };
  } __T2HLTbits_t;

extern __at(0x028F) volatile __T2HLTbits_t T2HLTbits;

#define _T2HLT_MODE0            0x01
#define _T2HLT_T2MODE0          0x01
#define _T2HLT_MODE1            0x02
#define _T2HLT_T2MODE1          0x02
#define _T2HLT_MODE2            0x04
#define _T2HLT_T2MODE2          0x04
#define _T2HLT_MODE3            0x08
#define _T2HLT_T2MODE3          0x08
#define _T2HLT_MODE4            0x10
#define _T2HLT_T2MODE4          0x10
#define _T2HLT_CKSYNC           0x20
#define _T2HLT_T2CKSYNC         0x20
#define _T2HLT_CKPOL            0x40
#define _T2HLT_T2CKPOL          0x40
#define _T2HLT_PSYNC            0x80
#define _T2HLT_T2PSYNC          0x80

//==============================================================================


//==============================================================================
//        T2CLKCON Bits

extern __at(0x0290) __sfr T2CLKCON;

typedef union
  {
  struct
    {
    unsigned T2CS0              : 1;
    unsigned T2CS1              : 1;
    unsigned T2CS2              : 1;
    unsigned T2CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CS               : 4;
    unsigned                    : 4;
    };
  } __T2CLKCONbits_t;

extern __at(0x0290) volatile __T2CLKCONbits_t T2CLKCONbits;

#define _T2CS0                  0x01
#define _T2CS1                  0x02
#define _T2CS2                  0x04
#define _T2CS3                  0x08

//==============================================================================


//==============================================================================
//        T2RST Bits

extern __at(0x0291) __sfr T2RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned RSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2RSEL0            : 1;
    unsigned T2RSEL1            : 1;
    unsigned T2RSEL2            : 1;
    unsigned T2RSEL3            : 1;
    unsigned T2RSEL4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RSEL               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned T2RSEL             : 5;
    unsigned                    : 3;
    };
  } __T2RSTbits_t;

extern __at(0x0291) volatile __T2RSTbits_t T2RSTbits;

#define _RSEL0                  0x01
#define _T2RSEL0                0x01
#define _RSEL1                  0x02
#define _T2RSEL1                0x02
#define _RSEL2                  0x04
#define _T2RSEL2                0x04
#define _RSEL3                  0x08
#define _T2RSEL3                0x08
#define _RSEL4                  0x10
#define _T2RSEL4                0x10

//==============================================================================

extern __at(0x0292) __sfr T4TMR;
extern __at(0x0292) __sfr TMR4;
extern __at(0x0293) __sfr PR4;
extern __at(0x0293) __sfr T4PR;

//==============================================================================
//        T4CON Bits

extern __at(0x0294) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned T4CKPS2            : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned T4ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR4ON             : 1;
    };

  struct
    {
    unsigned T4OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T4CKPS             : 3;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0294) volatile __T4CONbits_t T4CONbits;

#define _T4CON_T4OUTPS0         0x01
#define _T4CON_OUTPS0           0x01
#define _T4CON_T4OUTPS1         0x02
#define _T4CON_OUTPS1           0x02
#define _T4CON_T4OUTPS2         0x04
#define _T4CON_OUTPS2           0x04
#define _T4CON_T4OUTPS3         0x08
#define _T4CON_OUTPS3           0x08
#define _T4CON_T4CKPS0          0x10
#define _T4CON_CKPS0            0x10
#define _T4CON_T4CKPS1          0x20
#define _T4CON_CKPS1            0x20
#define _T4CON_T4CKPS2          0x40
#define _T4CON_CKPS2            0x40
#define _T4CON_ON               0x80
#define _T4CON_T4ON             0x80
#define _T4CON_TMR4ON           0x80

//==============================================================================


//==============================================================================
//        T4HLT Bits

extern __at(0x0295) __sfr T4HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned MODE4              : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T4MODE0            : 1;
    unsigned T4MODE1            : 1;
    unsigned T4MODE2            : 1;
    unsigned T4MODE3            : 1;
    unsigned T4MODE4            : 1;
    unsigned T4CKSYNC           : 1;
    unsigned T4CKPOL            : 1;
    unsigned T4PSYNC            : 1;
    };

  struct
    {
    unsigned MODE               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned T4MODE             : 5;
    unsigned                    : 3;
    };
  } __T4HLTbits_t;

extern __at(0x0295) volatile __T4HLTbits_t T4HLTbits;

#define _T4HLT_MODE0            0x01
#define _T4HLT_T4MODE0          0x01
#define _T4HLT_MODE1            0x02
#define _T4HLT_T4MODE1          0x02
#define _T4HLT_MODE2            0x04
#define _T4HLT_T4MODE2          0x04
#define _T4HLT_MODE3            0x08
#define _T4HLT_T4MODE3          0x08
#define _T4HLT_MODE4            0x10
#define _T4HLT_T4MODE4          0x10
#define _T4HLT_CKSYNC           0x20
#define _T4HLT_T4CKSYNC         0x20
#define _T4HLT_CKPOL            0x40
#define _T4HLT_T4CKPOL          0x40
#define _T4HLT_PSYNC            0x80
#define _T4HLT_T4PSYNC          0x80

//==============================================================================


//==============================================================================
//        T4CLKCON Bits

extern __at(0x0296) __sfr T4CLKCON;

typedef union
  {
  struct
    {
    unsigned T4CS0              : 1;
    unsigned T4CS1              : 1;
    unsigned T4CS2              : 1;
    unsigned T4CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CS               : 4;
    unsigned                    : 4;
    };
  } __T4CLKCONbits_t;

extern __at(0x0296) volatile __T4CLKCONbits_t T4CLKCONbits;

#define _T4CS0                  0x01
#define _T4CS1                  0x02
#define _T4CS2                  0x04
#define _T4CS3                  0x08

//==============================================================================


//==============================================================================
//        T4RST Bits

extern __at(0x0297) __sfr T4RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned RSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4RSEL0            : 1;
    unsigned T4RSEL1            : 1;
    unsigned T4RSEL2            : 1;
    unsigned T4RSEL3            : 1;
    unsigned T4RSEL4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4RSEL             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned RSEL               : 5;
    unsigned                    : 3;
    };
  } __T4RSTbits_t;

extern __at(0x0297) volatile __T4RSTbits_t T4RSTbits;

#define _T4RST_RSEL0            0x01
#define _T4RST_T4RSEL0          0x01
#define _T4RST_RSEL1            0x02
#define _T4RST_T4RSEL1          0x02
#define _T4RST_RSEL2            0x04
#define _T4RST_T4RSEL2          0x04
#define _T4RST_RSEL3            0x08
#define _T4RST_T4RSEL3          0x08
#define _T4RST_RSEL4            0x10
#define _T4RST_T4RSEL4          0x10

//==============================================================================

extern __at(0x0298) __sfr T6TMR;
extern __at(0x0298) __sfr TMR6;
extern __at(0x0299) __sfr PR6;
extern __at(0x0299) __sfr T6PR;

//==============================================================================
//        T6CON Bits

extern __at(0x029A) __sfr T6CON;

typedef union
  {
  struct
    {
    unsigned T6OUTPS0           : 1;
    unsigned T6OUTPS1           : 1;
    unsigned T6OUTPS2           : 1;
    unsigned T6OUTPS3           : 1;
    unsigned T6CKPS0            : 1;
    unsigned T6CKPS1            : 1;
    unsigned T6CKPS2            : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned T6ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR6ON             : 1;
    };

  struct
    {
    unsigned T6OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T6CKPS             : 3;
    unsigned                    : 1;
    };
  } __T6CONbits_t;

extern __at(0x029A) volatile __T6CONbits_t T6CONbits;

#define _T6CON_T6OUTPS0         0x01
#define _T6CON_OUTPS0           0x01
#define _T6CON_T6OUTPS1         0x02
#define _T6CON_OUTPS1           0x02
#define _T6CON_T6OUTPS2         0x04
#define _T6CON_OUTPS2           0x04
#define _T6CON_T6OUTPS3         0x08
#define _T6CON_OUTPS3           0x08
#define _T6CON_T6CKPS0          0x10
#define _T6CON_CKPS0            0x10
#define _T6CON_T6CKPS1          0x20
#define _T6CON_CKPS1            0x20
#define _T6CON_T6CKPS2          0x40
#define _T6CON_CKPS2            0x40
#define _T6CON_ON               0x80
#define _T6CON_T6ON             0x80
#define _T6CON_TMR6ON           0x80

//==============================================================================


//==============================================================================
//        T6HLT Bits

extern __at(0x029B) __sfr T6HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned MODE4              : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T6MODE0            : 1;
    unsigned T6MODE1            : 1;
    unsigned T6MODE2            : 1;
    unsigned T6MODE3            : 1;
    unsigned T6MODE4            : 1;
    unsigned T6CKSYNC           : 1;
    unsigned T6CKPOL            : 1;
    unsigned T6PSYNC            : 1;
    };

  struct
    {
    unsigned T6MODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MODE               : 5;
    unsigned                    : 3;
    };
  } __T6HLTbits_t;

extern __at(0x029B) volatile __T6HLTbits_t T6HLTbits;

#define _T6HLT_MODE0            0x01
#define _T6HLT_T6MODE0          0x01
#define _T6HLT_MODE1            0x02
#define _T6HLT_T6MODE1          0x02
#define _T6HLT_MODE2            0x04
#define _T6HLT_T6MODE2          0x04
#define _T6HLT_MODE3            0x08
#define _T6HLT_T6MODE3          0x08
#define _T6HLT_MODE4            0x10
#define _T6HLT_T6MODE4          0x10
#define _T6HLT_CKSYNC           0x20
#define _T6HLT_T6CKSYNC         0x20
#define _T6HLT_CKPOL            0x40
#define _T6HLT_T6CKPOL          0x40
#define _T6HLT_PSYNC            0x80
#define _T6HLT_T6PSYNC          0x80

//==============================================================================


//==============================================================================
//        T6CLKCON Bits

extern __at(0x029C) __sfr T6CLKCON;

typedef union
  {
  struct
    {
    unsigned T6CS0              : 1;
    unsigned T6CS1              : 1;
    unsigned T6CS2              : 1;
    unsigned T6CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6CS               : 4;
    unsigned                    : 4;
    };
  } __T6CLKCONbits_t;

extern __at(0x029C) volatile __T6CLKCONbits_t T6CLKCONbits;

#define _T6CS0                  0x01
#define _T6CS1                  0x02
#define _T6CS2                  0x04
#define _T6CS3                  0x08

//==============================================================================


//==============================================================================
//        T6RST Bits

extern __at(0x029D) __sfr T6RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned RSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6RSEL0            : 1;
    unsigned T6RSEL1            : 1;
    unsigned T6RSEL2            : 1;
    unsigned T6RSEL3            : 1;
    unsigned T6RSEL4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6RSEL             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned RSEL               : 5;
    unsigned                    : 3;
    };
  } __T6RSTbits_t;

extern __at(0x029D) volatile __T6RSTbits_t T6RSTbits;

#define _T6RST_RSEL0            0x01
#define _T6RST_T6RSEL0          0x01
#define _T6RST_RSEL1            0x02
#define _T6RST_T6RSEL1          0x02
#define _T6RST_RSEL2            0x04
#define _T6RST_T6RSEL2          0x04
#define _T6RST_RSEL3            0x08
#define _T6RST_T6RSEL3          0x08
#define _T6RST_RSEL4            0x10
#define _T6RST_T6RSEL4          0x10

//==============================================================================

extern __at(0x030C) __sfr CCPR1;
extern __at(0x030C) __sfr CCPR1L;
extern __at(0x030D) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x030E) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned FMT                : 1;
    unsigned OUT                : 1;
    unsigned OE                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CCP1MODE0          : 1;
    unsigned CCP1MODE1          : 1;
    unsigned CCP1MODE2          : 1;
    unsigned CCP1MODE3          : 1;
    unsigned CCP1FMT            : 1;
    unsigned CCP1OUT            : 1;
    unsigned CCP1OE             : 1;
    unsigned CCP1EN             : 1;
    };

  struct
    {
    unsigned CCP1MODE           : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };
  } __CCP1CONbits_t;

extern __at(0x030E) volatile __CCP1CONbits_t CCP1CONbits;

#define _MODE0                  0x01
#define _CCP1MODE0              0x01
#define _MODE1                  0x02
#define _CCP1MODE1              0x02
#define _MODE2                  0x04
#define _CCP1MODE2              0x04
#define _MODE3                  0x08
#define _CCP1MODE3              0x08
#define _FMT                    0x10
#define _CCP1FMT                0x10
#define _OUT                    0x20
#define _CCP1OUT                0x20
#define _OE                     0x40
#define _CCP1OE                 0x40
#define _EN                     0x80
#define _CCP1EN                 0x80

//==============================================================================


//==============================================================================
//        CCP1CAP Bits

extern __at(0x030F) __sfr CCP1CAP;

typedef union
  {
  struct
    {
    unsigned CTS0               : 1;
    unsigned CTS1               : 1;
    unsigned CTS2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1CTS0           : 1;
    unsigned CCP1CTS1           : 1;
    unsigned CCP1CTS2           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CTS                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CCP1CTS            : 3;
    unsigned                    : 5;
    };
  } __CCP1CAPbits_t;

extern __at(0x030F) volatile __CCP1CAPbits_t CCP1CAPbits;

#define _CTS0                   0x01
#define _CCP1CTS0               0x01
#define _CTS1                   0x02
#define _CCP1CTS1               0x02
#define _CTS2                   0x04
#define _CCP1CTS2               0x04

//==============================================================================

extern __at(0x0310) __sfr CCPR2;
extern __at(0x0310) __sfr CCPR2L;
extern __at(0x0311) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x0312) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned FMT                : 1;
    unsigned OUT                : 1;
    unsigned OE                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CCP2MODE0          : 1;
    unsigned CCP2MODE1          : 1;
    unsigned CCP2MODE2          : 1;
    unsigned CCP2MODE3          : 1;
    unsigned CCP2FMT            : 1;
    unsigned CCP2OUT            : 1;
    unsigned CCP2OE             : 1;
    unsigned CCP2EN             : 1;
    };

  struct
    {
    unsigned CCP2MODE           : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };
  } __CCP2CONbits_t;

extern __at(0x0312) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2CON_MODE0          0x01
#define _CCP2CON_CCP2MODE0      0x01
#define _CCP2CON_MODE1          0x02
#define _CCP2CON_CCP2MODE1      0x02
#define _CCP2CON_MODE2          0x04
#define _CCP2CON_CCP2MODE2      0x04
#define _CCP2CON_MODE3          0x08
#define _CCP2CON_CCP2MODE3      0x08
#define _CCP2CON_FMT            0x10
#define _CCP2CON_CCP2FMT        0x10
#define _CCP2CON_OUT            0x20
#define _CCP2CON_CCP2OUT        0x20
#define _CCP2CON_OE             0x40
#define _CCP2CON_CCP2OE         0x40
#define _CCP2CON_EN             0x80
#define _CCP2CON_CCP2EN         0x80

//==============================================================================


//==============================================================================
//        CCP2CAP Bits

extern __at(0x0313) __sfr CCP2CAP;

typedef union
  {
  struct
    {
    unsigned CTS0               : 1;
    unsigned CTS1               : 1;
    unsigned CTS2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2CTS0           : 1;
    unsigned CCP2CTS1           : 1;
    unsigned CCP2CTS2           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2CTS            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CTS                : 3;
    unsigned                    : 5;
    };
  } __CCP2CAPbits_t;

extern __at(0x0313) volatile __CCP2CAPbits_t CCP2CAPbits;

#define _CCP2CAP_CTS0           0x01
#define _CCP2CAP_CCP2CTS0       0x01
#define _CCP2CAP_CTS1           0x02
#define _CCP2CAP_CCP2CTS1       0x02
#define _CCP2CAP_CTS2           0x04
#define _CCP2CAP_CCP2CTS2       0x04

//==============================================================================

extern __at(0x0314) __sfr CCPR3;
extern __at(0x0314) __sfr CCPR3L;
extern __at(0x0315) __sfr CCPR3H;

//==============================================================================
//        CCP3CON Bits

extern __at(0x0316) __sfr CCP3CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned FMT                : 1;
    unsigned OUT                : 1;
    unsigned OE                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CCP3MODE0          : 1;
    unsigned CCP3MODE1          : 1;
    unsigned CCP3MODE2          : 1;
    unsigned CCP3MODE3          : 1;
    unsigned CCP3FMT            : 1;
    unsigned CCP3OUT            : 1;
    unsigned CCP3OE             : 1;
    unsigned CCP3EN             : 1;
    };

  struct
    {
    unsigned CCP3MODE           : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };
  } __CCP3CONbits_t;

extern __at(0x0316) volatile __CCP3CONbits_t CCP3CONbits;

#define _CCP3CON_MODE0          0x01
#define _CCP3CON_CCP3MODE0      0x01
#define _CCP3CON_MODE1          0x02
#define _CCP3CON_CCP3MODE1      0x02
#define _CCP3CON_MODE2          0x04
#define _CCP3CON_CCP3MODE2      0x04
#define _CCP3CON_MODE3          0x08
#define _CCP3CON_CCP3MODE3      0x08
#define _CCP3CON_FMT            0x10
#define _CCP3CON_CCP3FMT        0x10
#define _CCP3CON_OUT            0x20
#define _CCP3CON_CCP3OUT        0x20
#define _CCP3CON_OE             0x40
#define _CCP3CON_CCP3OE         0x40
#define _CCP3CON_EN             0x80
#define _CCP3CON_CCP3EN         0x80

//==============================================================================


//==============================================================================
//        CCP3CAP Bits

extern __at(0x0317) __sfr CCP3CAP;

typedef union
  {
  struct
    {
    unsigned CTS0               : 1;
    unsigned CTS1               : 1;
    unsigned CTS2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP3CTS0           : 1;
    unsigned CCP3CTS1           : 1;
    unsigned CCP3CTS2           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CTS                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CCP3CTS            : 3;
    unsigned                    : 5;
    };
  } __CCP3CAPbits_t;

extern __at(0x0317) volatile __CCP3CAPbits_t CCP3CAPbits;

#define _CCP3CAP_CTS0           0x01
#define _CCP3CAP_CCP3CTS0       0x01
#define _CCP3CAP_CTS1           0x02
#define _CCP3CAP_CCP3CTS1       0x02
#define _CCP3CAP_CTS2           0x04
#define _CCP3CAP_CCP3CTS2       0x04

//==============================================================================

extern __at(0x0318) __sfr CCPR4;
extern __at(0x0318) __sfr CCPR4L;
extern __at(0x0319) __sfr CCPR4H;

//==============================================================================
//        CCP4CON Bits

extern __at(0x031A) __sfr CCP4CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned FMT                : 1;
    unsigned OUT                : 1;
    unsigned OE                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CCP4MODE0          : 1;
    unsigned CCP4MODE1          : 1;
    unsigned CCP4MODE2          : 1;
    unsigned CCP4MODE3          : 1;
    unsigned CCP4FMT            : 1;
    unsigned CCP4OUT            : 1;
    unsigned CCP4OE             : 1;
    unsigned CCP4EN             : 1;
    };

  struct
    {
    unsigned CCP4MODE           : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };
  } __CCP4CONbits_t;

extern __at(0x031A) volatile __CCP4CONbits_t CCP4CONbits;

#define _CCP4CON_MODE0          0x01
#define _CCP4CON_CCP4MODE0      0x01
#define _CCP4CON_MODE1          0x02
#define _CCP4CON_CCP4MODE1      0x02
#define _CCP4CON_MODE2          0x04
#define _CCP4CON_CCP4MODE2      0x04
#define _CCP4CON_MODE3          0x08
#define _CCP4CON_CCP4MODE3      0x08
#define _CCP4CON_FMT            0x10
#define _CCP4CON_CCP4FMT        0x10
#define _CCP4CON_OUT            0x20
#define _CCP4CON_CCP4OUT        0x20
#define _CCP4CON_OE             0x40
#define _CCP4CON_CCP4OE         0x40
#define _CCP4CON_EN             0x80
#define _CCP4CON_CCP4EN         0x80

//==============================================================================


//==============================================================================
//        CCP4CAP Bits

extern __at(0x031B) __sfr CCP4CAP;

typedef union
  {
  struct
    {
    unsigned CTS0               : 1;
    unsigned CTS1               : 1;
    unsigned CTS2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP4CTS0           : 1;
    unsigned CCP4CTS1           : 1;
    unsigned CCP4CTS2           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CTS                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CCP4CTS            : 3;
    unsigned                    : 5;
    };
  } __CCP4CAPbits_t;

extern __at(0x031B) volatile __CCP4CAPbits_t CCP4CAPbits;

#define _CCP4CAP_CTS0           0x01
#define _CCP4CAP_CCP4CTS0       0x01
#define _CCP4CAP_CTS1           0x02
#define _CCP4CAP_CCP4CTS1       0x02
#define _CCP4CAP_CTS2           0x04
#define _CCP4CAP_CCP4CTS2       0x04

//==============================================================================

extern __at(0x031C) __sfr CCPR5;
extern __at(0x031C) __sfr CCPR5L;
extern __at(0x031D) __sfr CCPR5H;

//==============================================================================
//        CCP5CON Bits

extern __at(0x031E) __sfr CCP5CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned FMT                : 1;
    unsigned OUT                : 1;
    unsigned OE                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CCP5MODE0          : 1;
    unsigned CCP5MODE1          : 1;
    unsigned CCP5MODE2          : 1;
    unsigned CCP5MODE3          : 1;
    unsigned CCP5FMT            : 1;
    unsigned CCP5OUT            : 1;
    unsigned CCP5OE             : 1;
    unsigned CCP5EN             : 1;
    };

  struct
    {
    unsigned CCP5MODE           : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };
  } __CCP5CONbits_t;

extern __at(0x031E) volatile __CCP5CONbits_t CCP5CONbits;

#define _CCP5CON_MODE0          0x01
#define _CCP5CON_CCP5MODE0      0x01
#define _CCP5CON_MODE1          0x02
#define _CCP5CON_CCP5MODE1      0x02
#define _CCP5CON_MODE2          0x04
#define _CCP5CON_CCP5MODE2      0x04
#define _CCP5CON_MODE3          0x08
#define _CCP5CON_CCP5MODE3      0x08
#define _CCP5CON_FMT            0x10
#define _CCP5CON_CCP5FMT        0x10
#define _CCP5CON_OUT            0x20
#define _CCP5CON_CCP5OUT        0x20
#define _CCP5CON_OE             0x40
#define _CCP5CON_CCP5OE         0x40
#define _CCP5CON_EN             0x80
#define _CCP5CON_CCP5EN         0x80

//==============================================================================


//==============================================================================
//        CCP5CAP Bits

extern __at(0x031F) __sfr CCP5CAP;

typedef union
  {
  struct
    {
    unsigned CTS0               : 1;
    unsigned CTS1               : 1;
    unsigned CTS2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP5CTS0           : 1;
    unsigned CCP5CTS1           : 1;
    unsigned CCP5CTS2           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP5CTS            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CTS                : 3;
    unsigned                    : 5;
    };
  } __CCP5CAPbits_t;

extern __at(0x031F) volatile __CCP5CAPbits_t CCP5CAPbits;

#define _CCP5CAP_CTS0           0x01
#define _CCP5CAP_CCP5CTS0       0x01
#define _CCP5CAP_CTS1           0x02
#define _CCP5CAP_CCP5CTS1       0x02
#define _CCP5CAP_CTS2           0x04
#define _CCP5CAP_CCP5CTS2       0x04

//==============================================================================


//==============================================================================
//        PWM6DCL Bits

extern __at(0x038C) __sfr PWM6DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC0                : 1;
    unsigned DC1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM6DC0            : 1;
    unsigned PWM6DC1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWMPW0             : 1;
    unsigned PWMPW1             : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM6DC             : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned DC                 : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWMPW              : 2;
    };
  } __PWM6DCLbits_t;

extern __at(0x038C) volatile __PWM6DCLbits_t PWM6DCLbits;

#define _DC0                    0x40
#define _PWM6DC0                0x40
#define _PWMPW0                 0x40
#define _DC1                    0x80
#define _PWM6DC1                0x80
#define _PWMPW1                 0x80

//==============================================================================


//==============================================================================
//        PWM6DCH Bits

extern __at(0x038D) __sfr PWM6DCH;

typedef union
  {
  struct
    {
    unsigned DC2                : 1;
    unsigned DC3                : 1;
    unsigned DC4                : 1;
    unsigned DC5                : 1;
    unsigned DC6                : 1;
    unsigned DC7                : 1;
    unsigned DC8                : 1;
    unsigned DC9                : 1;
    };

  struct
    {
    unsigned PWM6DC2            : 1;
    unsigned PWM6DC3            : 1;
    unsigned PWM6DC4            : 1;
    unsigned PWM6DC5            : 1;
    unsigned PWM6DC6            : 1;
    unsigned PWM6DC7            : 1;
    unsigned PWM6DC8            : 1;
    unsigned PWM6DC9            : 1;
    };

  struct
    {
    unsigned PWMPW2             : 1;
    unsigned PWMPW3             : 1;
    unsigned PWMPW4             : 1;
    unsigned PWMPW5             : 1;
    unsigned PWMPW6             : 1;
    unsigned PWMPW7             : 1;
    unsigned PWMPW8             : 1;
    unsigned PWMPW9             : 1;
    };
  } __PWM6DCHbits_t;

extern __at(0x038D) volatile __PWM6DCHbits_t PWM6DCHbits;

#define _DC2                    0x01
#define _PWM6DC2                0x01
#define _PWMPW2                 0x01
#define _DC3                    0x02
#define _PWM6DC3                0x02
#define _PWMPW3                 0x02
#define _DC4                    0x04
#define _PWM6DC4                0x04
#define _PWMPW4                 0x04
#define _DC5                    0x08
#define _PWM6DC5                0x08
#define _PWMPW5                 0x08
#define _DC6                    0x10
#define _PWM6DC6                0x10
#define _PWMPW6                 0x10
#define _DC7                    0x20
#define _PWM6DC7                0x20
#define _PWMPW7                 0x20
#define _DC8                    0x40
#define _PWM6DC8                0x40
#define _PWMPW8                 0x40
#define _DC9                    0x80
#define _PWM6DC9                0x80
#define _PWMPW9                 0x80

//==============================================================================


//==============================================================================
//        PWM6CON Bits

extern __at(0x038E) __sfr PWM6CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned OE                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM6POL            : 1;
    unsigned PWM6OUT            : 1;
    unsigned PWM6OE             : 1;
    unsigned PWM6EN             : 1;
    };
  } __PWM6CONbits_t;

extern __at(0x038E) volatile __PWM6CONbits_t PWM6CONbits;

#define _PWM6CON_POL            0x10
#define _PWM6CON_PWM6POL        0x10
#define _PWM6CON_OUT            0x20
#define _PWM6CON_PWM6OUT        0x20
#define _PWM6CON_OE             0x40
#define _PWM6CON_PWM6OE         0x40
#define _PWM6CON_EN             0x80
#define _PWM6CON_PWM6EN         0x80

//==============================================================================


//==============================================================================
//        PWM7DCL Bits

extern __at(0x0390) __sfr PWM7DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC0                : 1;
    unsigned DC1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM7DC0            : 1;
    unsigned PWM7DC1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWMPW0             : 1;
    unsigned PWMPW1             : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWMPW              : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned DC                 : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM7DC             : 2;
    };
  } __PWM7DCLbits_t;

extern __at(0x0390) volatile __PWM7DCLbits_t PWM7DCLbits;

#define _PWM7DCL_DC0            0x40
#define _PWM7DCL_PWM7DC0        0x40
#define _PWM7DCL_PWMPW0         0x40
#define _PWM7DCL_DC1            0x80
#define _PWM7DCL_PWM7DC1        0x80
#define _PWM7DCL_PWMPW1         0x80

//==============================================================================


//==============================================================================
//        PWM7DCH Bits

extern __at(0x0391) __sfr PWM7DCH;

typedef union
  {
  struct
    {
    unsigned DC2                : 1;
    unsigned DC3                : 1;
    unsigned DC4                : 1;
    unsigned DC5                : 1;
    unsigned DC6                : 1;
    unsigned DC7                : 1;
    unsigned DC8                : 1;
    unsigned DC9                : 1;
    };

  struct
    {
    unsigned PWM7DC2            : 1;
    unsigned PWM7DC3            : 1;
    unsigned PWM7DC4            : 1;
    unsigned PWM7DC5            : 1;
    unsigned PWM7DC6            : 1;
    unsigned PWM7DC7            : 1;
    unsigned PWM7DC8            : 1;
    unsigned PWM7DC9            : 1;
    };

  struct
    {
    unsigned PWMPW2             : 1;
    unsigned PWMPW3             : 1;
    unsigned PWMPW4             : 1;
    unsigned PWMPW5             : 1;
    unsigned PWMPW6             : 1;
    unsigned PWMPW7             : 1;
    unsigned PWMPW8             : 1;
    unsigned PWMPW9             : 1;
    };
  } __PWM7DCHbits_t;

extern __at(0x0391) volatile __PWM7DCHbits_t PWM7DCHbits;

#define _PWM7DCH_DC2            0x01
#define _PWM7DCH_PWM7DC2        0x01
#define _PWM7DCH_PWMPW2         0x01
#define _PWM7DCH_DC3            0x02
#define _PWM7DCH_PWM7DC3        0x02
#define _PWM7DCH_PWMPW3         0x02
#define _PWM7DCH_DC4            0x04
#define _PWM7DCH_PWM7DC4        0x04
#define _PWM7DCH_PWMPW4         0x04
#define _PWM7DCH_DC5            0x08
#define _PWM7DCH_PWM7DC5        0x08
#define _PWM7DCH_PWMPW5         0x08
#define _PWM7DCH_DC6            0x10
#define _PWM7DCH_PWM7DC6        0x10
#define _PWM7DCH_PWMPW6         0x10
#define _PWM7DCH_DC7            0x20
#define _PWM7DCH_PWM7DC7        0x20
#define _PWM7DCH_PWMPW7         0x20
#define _PWM7DCH_DC8            0x40
#define _PWM7DCH_PWM7DC8        0x40
#define _PWM7DCH_PWMPW8         0x40
#define _PWM7DCH_DC9            0x80
#define _PWM7DCH_PWM7DC9        0x80
#define _PWM7DCH_PWMPW9         0x80

//==============================================================================


//==============================================================================
//        PWM7CON Bits

extern __at(0x0392) __sfr PWM7CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned OE                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM7POL            : 1;
    unsigned PWM7OUT            : 1;
    unsigned PWM7OE             : 1;
    unsigned PWM7EN             : 1;
    };
  } __PWM7CONbits_t;

extern __at(0x0392) volatile __PWM7CONbits_t PWM7CONbits;

#define _PWM7CON_POL            0x10
#define _PWM7CON_PWM7POL        0x10
#define _PWM7CON_OUT            0x20
#define _PWM7CON_PWM7OUT        0x20
#define _PWM7CON_OE             0x40
#define _PWM7CON_PWM7OE         0x40
#define _PWM7CON_EN             0x80
#define _PWM7CON_PWM7EN         0x80

//==============================================================================


//==============================================================================
//        SCANLADRL Bits

extern __at(0x040C) __sfr SCANLADRL;

typedef union
  {
  struct
    {
    unsigned LADR0              : 1;
    unsigned LADR1              : 1;
    unsigned LADR2              : 1;
    unsigned LADR3              : 1;
    unsigned LADR4              : 1;
    unsigned LADR5              : 1;
    unsigned LADR6              : 1;
    unsigned LADR7              : 1;
    };

  struct
    {
    unsigned SCANLADR0          : 1;
    unsigned SCANLADR1          : 1;
    unsigned SCANLADR2          : 1;
    unsigned SCANLADR3          : 1;
    unsigned SCANLADR4          : 1;
    unsigned SCANLADR5          : 1;
    unsigned SCANLADR6          : 1;
    unsigned SCANLADR7          : 1;
    };
  } __SCANLADRLbits_t;

extern __at(0x040C) volatile __SCANLADRLbits_t SCANLADRLbits;

#define _LADR0                  0x01
#define _SCANLADR0              0x01
#define _LADR1                  0x02
#define _SCANLADR1              0x02
#define _LADR2                  0x04
#define _SCANLADR2              0x04
#define _LADR3                  0x08
#define _SCANLADR3              0x08
#define _LADR4                  0x10
#define _SCANLADR4              0x10
#define _LADR5                  0x20
#define _SCANLADR5              0x20
#define _LADR6                  0x40
#define _SCANLADR6              0x40
#define _LADR7                  0x80
#define _SCANLADR7              0x80

//==============================================================================


//==============================================================================
//        SCANLADRH Bits

extern __at(0x040D) __sfr SCANLADRH;

typedef union
  {
  struct
    {
    unsigned LADR8              : 1;
    unsigned LADR9              : 1;
    unsigned LADR10             : 1;
    unsigned LADR11             : 1;
    unsigned LADR12             : 1;
    unsigned LADR13             : 1;
    unsigned LADR14             : 1;
    unsigned LADR15             : 1;
    };

  struct
    {
    unsigned SCANLADR8          : 1;
    unsigned SCANLADR9          : 1;
    unsigned SCANLADR10         : 1;
    unsigned SCANLADR11         : 1;
    unsigned SCANLADR12         : 1;
    unsigned SCANLADR13         : 1;
    unsigned SCANLADR14         : 1;
    unsigned SCANLADR15         : 1;
    };
  } __SCANLADRHbits_t;

extern __at(0x040D) volatile __SCANLADRHbits_t SCANLADRHbits;

#define _LADR8                  0x01
#define _SCANLADR8              0x01
#define _LADR9                  0x02
#define _SCANLADR9              0x02
#define _LADR10                 0x04
#define _SCANLADR10             0x04
#define _LADR11                 0x08
#define _SCANLADR11             0x08
#define _LADR12                 0x10
#define _SCANLADR12             0x10
#define _LADR13                 0x20
#define _SCANLADR13             0x20
#define _LADR14                 0x40
#define _SCANLADR14             0x40
#define _LADR15                 0x80
#define _SCANLADR15             0x80

//==============================================================================


//==============================================================================
//        SCANHADRL Bits

extern __at(0x040E) __sfr SCANHADRL;

typedef union
  {
  struct
    {
    unsigned HADR0              : 1;
    unsigned HADR1              : 1;
    unsigned HADR2              : 1;
    unsigned HADR3              : 1;
    unsigned HADR4              : 1;
    unsigned HADR5              : 1;
    unsigned HADR6              : 1;
    unsigned HADR7              : 1;
    };

  struct
    {
    unsigned SCANHADR0          : 1;
    unsigned SCANHADR1          : 1;
    unsigned SCANHADR2          : 1;
    unsigned SCANHADR3          : 1;
    unsigned SCANHADR4          : 1;
    unsigned SCANHADR5          : 1;
    unsigned SCANHADR6          : 1;
    unsigned SCANHADR7          : 1;
    };
  } __SCANHADRLbits_t;

extern __at(0x040E) volatile __SCANHADRLbits_t SCANHADRLbits;

#define _HADR0                  0x01
#define _SCANHADR0              0x01
#define _HADR1                  0x02
#define _SCANHADR1              0x02
#define _HADR2                  0x04
#define _SCANHADR2              0x04
#define _HADR3                  0x08
#define _SCANHADR3              0x08
#define _HADR4                  0x10
#define _SCANHADR4              0x10
#define _HADR5                  0x20
#define _SCANHADR5              0x20
#define _HADR6                  0x40
#define _SCANHADR6              0x40
#define _HADR7                  0x80
#define _SCANHADR7              0x80

//==============================================================================


//==============================================================================
//        SCANHADRH Bits

extern __at(0x040F) __sfr SCANHADRH;

typedef union
  {
  struct
    {
    unsigned HADR8              : 1;
    unsigned HADR9              : 1;
    unsigned HADR10             : 1;
    unsigned HADR11             : 1;
    unsigned HADR12             : 1;
    unsigned HADR13             : 1;
    unsigned HADR14             : 1;
    unsigned HADR15             : 1;
    };

  struct
    {
    unsigned SCANHADR8          : 1;
    unsigned SCANHADR9          : 1;
    unsigned SCANHADR10         : 1;
    unsigned SCANHADR11         : 1;
    unsigned SCANHADR12         : 1;
    unsigned SCANHADR13         : 1;
    unsigned SCANHADR14         : 1;
    unsigned SCANHADR15         : 1;
    };
  } __SCANHADRHbits_t;

extern __at(0x040F) volatile __SCANHADRHbits_t SCANHADRHbits;

#define _HADR8                  0x01
#define _SCANHADR8              0x01
#define _HADR9                  0x02
#define _SCANHADR9              0x02
#define _HADR10                 0x04
#define _SCANHADR10             0x04
#define _HADR11                 0x08
#define _SCANHADR11             0x08
#define _HADR12                 0x10
#define _SCANHADR12             0x10
#define _HADR13                 0x20
#define _SCANHADR13             0x20
#define _HADR14                 0x40
#define _SCANHADR14             0x40
#define _HADR15                 0x80
#define _SCANHADR15             0x80

//==============================================================================


//==============================================================================
//        SCANCON0 Bits

extern __at(0x0410) __sfr SCANCON0;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned                    : 1;
    unsigned INTM               : 1;
    unsigned INVALID            : 1;
    unsigned BUSY               : 1;
    unsigned SCANGO             : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned SCANMODE0          : 1;
    unsigned SCANMODE1          : 1;
    unsigned                    : 1;
    unsigned SCANINTM           : 1;
    unsigned SCANINVALID        : 1;
    unsigned SCANBUSY           : 1;
    unsigned                    : 1;
    unsigned SCANEN             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DABORT             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SCANMODE           : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned MODE               : 2;
    unsigned                    : 6;
    };
  } __SCANCON0bits_t;

extern __at(0x0410) volatile __SCANCON0bits_t SCANCON0bits;

#define _SCANCON0_MODE0         0x01
#define _SCANCON0_SCANMODE0     0x01
#define _SCANCON0_MODE1         0x02
#define _SCANCON0_SCANMODE1     0x02
#define _SCANCON0_INTM          0x08
#define _SCANCON0_SCANINTM      0x08
#define _SCANCON0_INVALID       0x10
#define _SCANCON0_SCANINVALID   0x10
#define _SCANCON0_DABORT        0x10
#define _SCANCON0_BUSY          0x20
#define _SCANCON0_SCANBUSY      0x20
#define _SCANCON0_SCANGO        0x40
#define _SCANCON0_EN            0x80
#define _SCANCON0_SCANEN        0x80

//==============================================================================


//==============================================================================
//        SCANTRIG Bits

extern __at(0x0411) __sfr SCANTRIG;

typedef union
  {
  struct
    {
    unsigned TSEL0              : 1;
    unsigned TSEL1              : 1;
    unsigned TSEL2              : 1;
    unsigned TSEL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SCANTSEL0          : 1;
    unsigned SCANTSEL1          : 1;
    unsigned SCANTSEL2          : 1;
    unsigned SCANTSEL3          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TSEL               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned SCANTSEL           : 4;
    unsigned                    : 4;
    };
  } __SCANTRIGbits_t;

extern __at(0x0411) volatile __SCANTRIGbits_t SCANTRIGbits;

#define _TSEL0                  0x01
#define _SCANTSEL0              0x01
#define _TSEL1                  0x02
#define _SCANTSEL1              0x02
#define _TSEL2                  0x04
#define _SCANTSEL2              0x04
#define _TSEL3                  0x08
#define _SCANTSEL3              0x08

//==============================================================================

extern __at(0x0416) __sfr CRCDATA;

//==============================================================================
//        CRCDATL Bits

extern __at(0x0416) __sfr CRCDATL;

typedef struct
  {
  unsigned DATA0                : 1;
  unsigned DATA1                : 1;
  unsigned DATA2                : 1;
  unsigned DATA3                : 1;
  unsigned DATA4                : 1;
  unsigned DATA5                : 1;
  unsigned DATA6                : 1;
  unsigned DATA7                : 1;
  } __CRCDATLbits_t;

extern __at(0x0416) volatile __CRCDATLbits_t CRCDATLbits;

#define _DATA0                  0x01
#define _DATA1                  0x02
#define _DATA2                  0x04
#define _DATA3                  0x08
#define _DATA4                  0x10
#define _DATA5                  0x20
#define _DATA6                  0x40
#define _DATA7                  0x80

//==============================================================================


//==============================================================================
//        CRCDATH Bits

extern __at(0x0417) __sfr CRCDATH;

typedef struct
  {
  unsigned DATA8                : 1;
  unsigned DATA9                : 1;
  unsigned DATA10               : 1;
  unsigned DATA11               : 1;
  unsigned DATA12               : 1;
  unsigned DATA13               : 1;
  unsigned DATA14               : 1;
  unsigned DATA15               : 1;
  } __CRCDATHbits_t;

extern __at(0x0417) volatile __CRCDATHbits_t CRCDATHbits;

#define _DATA8                  0x01
#define _DATA9                  0x02
#define _DATA10                 0x04
#define _DATA11                 0x08
#define _DATA12                 0x10
#define _DATA13                 0x20
#define _DATA14                 0x40
#define _DATA15                 0x80

//==============================================================================

extern __at(0x0418) __sfr CRCACC;

//==============================================================================
//        CRCACCL Bits

extern __at(0x0418) __sfr CRCACCL;

typedef struct
  {
  unsigned ACC0                 : 1;
  unsigned ACC1                 : 1;
  unsigned ACC2                 : 1;
  unsigned ACC3                 : 1;
  unsigned ACC4                 : 1;
  unsigned ACC5                 : 1;
  unsigned ACC6                 : 1;
  unsigned ACC7                 : 1;
  } __CRCACCLbits_t;

extern __at(0x0418) volatile __CRCACCLbits_t CRCACCLbits;

#define _ACC0                   0x01
#define _ACC1                   0x02
#define _ACC2                   0x04
#define _ACC3                   0x08
#define _ACC4                   0x10
#define _ACC5                   0x20
#define _ACC6                   0x40
#define _ACC7                   0x80

//==============================================================================


//==============================================================================
//        CRCACCH Bits

extern __at(0x0419) __sfr CRCACCH;

typedef struct
  {
  unsigned ACC8                 : 1;
  unsigned ACC9                 : 1;
  unsigned ACC10                : 1;
  unsigned ACC11                : 1;
  unsigned ACC12                : 1;
  unsigned ACC13                : 1;
  unsigned ACC14                : 1;
  unsigned ACC15                : 1;
  } __CRCACCHbits_t;

extern __at(0x0419) volatile __CRCACCHbits_t CRCACCHbits;

#define _ACC8                   0x01
#define _ACC9                   0x02
#define _ACC10                  0x04
#define _ACC11                  0x08
#define _ACC12                  0x10
#define _ACC13                  0x20
#define _ACC14                  0x40
#define _ACC15                  0x80

//==============================================================================

extern __at(0x041A) __sfr CRCSHFT;

//==============================================================================
//        CRCSHIFTL Bits

extern __at(0x041A) __sfr CRCSHIFTL;

typedef struct
  {
  unsigned SHFT0                : 1;
  unsigned SHFT1                : 1;
  unsigned SHFT2                : 1;
  unsigned SHFT3                : 1;
  unsigned SHFT4                : 1;
  unsigned SHFT5                : 1;
  unsigned SHFT6                : 1;
  unsigned SHFT7                : 1;
  } __CRCSHIFTLbits_t;

extern __at(0x041A) volatile __CRCSHIFTLbits_t CRCSHIFTLbits;

#define _SHFT0                  0x01
#define _SHFT1                  0x02
#define _SHFT2                  0x04
#define _SHFT3                  0x08
#define _SHFT4                  0x10
#define _SHFT5                  0x20
#define _SHFT6                  0x40
#define _SHFT7                  0x80

//==============================================================================


//==============================================================================
//        CRCSHIFTH Bits

extern __at(0x041B) __sfr CRCSHIFTH;

typedef struct
  {
  unsigned SHFT8                : 1;
  unsigned SHFT9                : 1;
  unsigned SHFT10               : 1;
  unsigned SHFT11               : 1;
  unsigned SHFT12               : 1;
  unsigned SHFT13               : 1;
  unsigned SHFT14               : 1;
  unsigned SHFT15               : 1;
  } __CRCSHIFTHbits_t;

extern __at(0x041B) volatile __CRCSHIFTHbits_t CRCSHIFTHbits;

#define _SHFT8                  0x01
#define _SHFT9                  0x02
#define _SHFT10                 0x04
#define _SHFT11                 0x08
#define _SHFT12                 0x10
#define _SHFT13                 0x20
#define _SHFT14                 0x40
#define _SHFT15                 0x80

//==============================================================================

extern __at(0x041C) __sfr CRCXOR;

//==============================================================================
//        CRCXORL Bits

extern __at(0x041C) __sfr CRCXORL;

typedef struct
  {
  unsigned                      : 1;
  unsigned X1                   : 1;
  unsigned X2                   : 1;
  unsigned X3                   : 1;
  unsigned X4                   : 1;
  unsigned X5                   : 1;
  unsigned X6                   : 1;
  unsigned X7                   : 1;
  } __CRCXORLbits_t;

extern __at(0x041C) volatile __CRCXORLbits_t CRCXORLbits;

#define _X1                     0x02
#define _X2                     0x04
#define _X3                     0x08
#define _X4                     0x10
#define _X5                     0x20
#define _X6                     0x40
#define _X7                     0x80

//==============================================================================


//==============================================================================
//        CRCXORH Bits

extern __at(0x041D) __sfr CRCXORH;

typedef struct
  {
  unsigned X8                   : 1;
  unsigned X9                   : 1;
  unsigned X10                  : 1;
  unsigned X11                  : 1;
  unsigned X12                  : 1;
  unsigned X13                  : 1;
  unsigned X14                  : 1;
  unsigned X15                  : 1;
  } __CRCXORHbits_t;

extern __at(0x041D) volatile __CRCXORHbits_t CRCXORHbits;

#define _X8                     0x01
#define _X9                     0x02
#define _X10                    0x04
#define _X11                    0x08
#define _X12                    0x10
#define _X13                    0x20
#define _X14                    0x40
#define _X15                    0x80

//==============================================================================


//==============================================================================
//        CRCCON0 Bits

extern __at(0x041E) __sfr CRCCON0;

typedef union
  {
  struct
    {
    unsigned FULL               : 1;
    unsigned SHIFTM             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ACCM               : 1;
    unsigned BUSY               : 1;
    unsigned CRCGO              : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CRCEN              : 1;
    };
  } __CRCCON0bits_t;

extern __at(0x041E) volatile __CRCCON0bits_t CRCCON0bits;

#define _CRCCON0_FULL           0x01
#define _CRCCON0_SHIFTM         0x02
#define _CRCCON0_ACCM           0x10
#define _CRCCON0_BUSY           0x20
#define _CRCCON0_CRCGO          0x40
#define _CRCCON0_EN             0x80
#define _CRCCON0_CRCEN          0x80

//==============================================================================


//==============================================================================
//        CRCCON1 Bits

extern __at(0x041F) __sfr CRCCON1;

typedef union
  {
  struct
    {
    unsigned PLEN0              : 1;
    unsigned PLEN1              : 1;
    unsigned PLEN2              : 1;
    unsigned PLEN3              : 1;
    unsigned DLEN0              : 1;
    unsigned DLEN1              : 1;
    unsigned DLEN2              : 1;
    unsigned DLEN3              : 1;
    };

  struct
    {
    unsigned PLEN               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DLEN               : 4;
    };
  } __CRCCON1bits_t;

extern __at(0x041F) volatile __CRCCON1bits_t CRCCON1bits;

#define _PLEN0                  0x01
#define _PLEN1                  0x02
#define _PLEN2                  0x04
#define _PLEN3                  0x08
#define _DLEN0                  0x10
#define _DLEN1                  0x20
#define _DLEN2                  0x40
#define _DLEN3                  0x80

//==============================================================================

extern __at(0x048C) __sfr SMT1TMR;

//==============================================================================
//        SMT1TMRL Bits

extern __at(0x048C) __sfr SMT1TMRL;

typedef struct
  {
  unsigned SMT1TMR0             : 1;
  unsigned SMT1TMR1             : 1;
  unsigned SMT1TMR2             : 1;
  unsigned SMT1TMR3             : 1;
  unsigned SMT1TMR4             : 1;
  unsigned SMT1TMR5             : 1;
  unsigned SMT1TMR6             : 1;
  unsigned SMT1TMR7             : 1;
  } __SMT1TMRLbits_t;

extern __at(0x048C) volatile __SMT1TMRLbits_t SMT1TMRLbits;

#define _SMT1TMR0               0x01
#define _SMT1TMR1               0x02
#define _SMT1TMR2               0x04
#define _SMT1TMR3               0x08
#define _SMT1TMR4               0x10
#define _SMT1TMR5               0x20
#define _SMT1TMR6               0x40
#define _SMT1TMR7               0x80

//==============================================================================


//==============================================================================
//        SMT1TMRH Bits

extern __at(0x048D) __sfr SMT1TMRH;

typedef struct
  {
  unsigned SMT1TMR8             : 1;
  unsigned SMT1TMR9             : 1;
  unsigned SMT1TMR10            : 1;
  unsigned SMT1TMR11            : 1;
  unsigned SMT1TMR12            : 1;
  unsigned SMT1TMR13            : 1;
  unsigned SMT1TMR14            : 1;
  unsigned SMT1TMR15            : 1;
  } __SMT1TMRHbits_t;

extern __at(0x048D) volatile __SMT1TMRHbits_t SMT1TMRHbits;

#define _SMT1TMR8               0x01
#define _SMT1TMR9               0x02
#define _SMT1TMR10              0x04
#define _SMT1TMR11              0x08
#define _SMT1TMR12              0x10
#define _SMT1TMR13              0x20
#define _SMT1TMR14              0x40
#define _SMT1TMR15              0x80

//==============================================================================


//==============================================================================
//        SMT1TMRU Bits

extern __at(0x048E) __sfr SMT1TMRU;

typedef struct
  {
  unsigned SMT1TMR16            : 1;
  unsigned SMT1TMR17            : 1;
  unsigned SMT1TMR18            : 1;
  unsigned SMT1TMR19            : 1;
  unsigned SMT1TMR20            : 1;
  unsigned SMT1TMR21            : 1;
  unsigned SMT1TMR22            : 1;
  unsigned SMT1TMR23            : 1;
  } __SMT1TMRUbits_t;

extern __at(0x048E) volatile __SMT1TMRUbits_t SMT1TMRUbits;

#define _SMT1TMR16              0x01
#define _SMT1TMR17              0x02
#define _SMT1TMR18              0x04
#define _SMT1TMR19              0x08
#define _SMT1TMR20              0x10
#define _SMT1TMR21              0x20
#define _SMT1TMR22              0x40
#define _SMT1TMR23              0x80

//==============================================================================

extern __at(0x048F) __sfr SMT1CPR;

//==============================================================================
//        SMT1CPRL Bits

extern __at(0x048F) __sfr SMT1CPRL;

typedef struct
  {
  unsigned CPR0                 : 1;
  unsigned CPR1                 : 1;
  unsigned CPR2                 : 1;
  unsigned CPR3                 : 1;
  unsigned CPR4                 : 1;
  unsigned CPR5                 : 1;
  unsigned CPR6                 : 1;
  unsigned CPR7                 : 1;
  } __SMT1CPRLbits_t;

extern __at(0x048F) volatile __SMT1CPRLbits_t SMT1CPRLbits;

#define _CPR0                   0x01
#define _CPR1                   0x02
#define _CPR2                   0x04
#define _CPR3                   0x08
#define _CPR4                   0x10
#define _CPR5                   0x20
#define _CPR6                   0x40
#define _CPR7                   0x80

//==============================================================================


//==============================================================================
//        SMT1CPRH Bits

extern __at(0x0490) __sfr SMT1CPRH;

typedef union
  {
  struct
    {
    unsigned CPR8               : 1;
    unsigned CPR9               : 1;
    unsigned CPR10              : 1;
    unsigned CPR11              : 1;
    unsigned CPR12              : 1;
    unsigned CPR13              : 1;
    unsigned CPR14              : 1;
    unsigned CPR15              : 1;
    };

  struct
    {
    unsigned SMT1CPR8           : 1;
    unsigned SMT1CPR9           : 1;
    unsigned SMT1CPR10          : 1;
    unsigned SMT1CPR11          : 1;
    unsigned SMT1CPR12          : 1;
    unsigned SMT1CPR13          : 1;
    unsigned SMT1CPR14          : 1;
    unsigned SMT1CPR15          : 1;
    };
  } __SMT1CPRHbits_t;

extern __at(0x0490) volatile __SMT1CPRHbits_t SMT1CPRHbits;

#define _CPR8                   0x01
#define _SMT1CPR8               0x01
#define _CPR9                   0x02
#define _SMT1CPR9               0x02
#define _CPR10                  0x04
#define _SMT1CPR10              0x04
#define _CPR11                  0x08
#define _SMT1CPR11              0x08
#define _CPR12                  0x10
#define _SMT1CPR12              0x10
#define _CPR13                  0x20
#define _SMT1CPR13              0x20
#define _CPR14                  0x40
#define _SMT1CPR14              0x40
#define _CPR15                  0x80
#define _SMT1CPR15              0x80

//==============================================================================


//==============================================================================
//        SMT1CPRU Bits

extern __at(0x0491) __sfr SMT1CPRU;

typedef union
  {
  struct
    {
    unsigned CPR16              : 1;
    unsigned CPR17              : 1;
    unsigned CPR18              : 1;
    unsigned CPR19              : 1;
    unsigned CPR20              : 1;
    unsigned CPR21              : 1;
    unsigned CPR22              : 1;
    unsigned CPR23              : 1;
    };

  struct
    {
    unsigned SMT1CPR16          : 1;
    unsigned SMT1CPR17          : 1;
    unsigned SMT1CPR18          : 1;
    unsigned SMT1CPR19          : 1;
    unsigned SMT1CPR20          : 1;
    unsigned SMT1CPR21          : 1;
    unsigned SMT1CPR22          : 1;
    unsigned SMT1CPR23          : 1;
    };
  } __SMT1CPRUbits_t;

extern __at(0x0491) volatile __SMT1CPRUbits_t SMT1CPRUbits;

#define _CPR16                  0x01
#define _SMT1CPR16              0x01
#define _CPR17                  0x02
#define _SMT1CPR17              0x02
#define _CPR18                  0x04
#define _SMT1CPR18              0x04
#define _CPR19                  0x08
#define _SMT1CPR19              0x08
#define _CPR20                  0x10
#define _SMT1CPR20              0x10
#define _CPR21                  0x20
#define _SMT1CPR21              0x20
#define _CPR22                  0x40
#define _SMT1CPR22              0x40
#define _CPR23                  0x80
#define _SMT1CPR23              0x80

//==============================================================================

extern __at(0x0492) __sfr SMT1CPW;

//==============================================================================
//        SMT1CPWL Bits

extern __at(0x0492) __sfr SMT1CPWL;

typedef union
  {
  struct
    {
    unsigned CPW0               : 1;
    unsigned CPW1               : 1;
    unsigned CPW2               : 1;
    unsigned CPW3               : 1;
    unsigned CPW4               : 1;
    unsigned CPW5               : 1;
    unsigned CPW6               : 1;
    unsigned CPW7               : 1;
    };

  struct
    {
    unsigned SMT1CPW0           : 1;
    unsigned SMT1CPW1           : 1;
    unsigned SMT1CPW2           : 1;
    unsigned SMT1CPW3           : 1;
    unsigned SMT1CPW4           : 1;
    unsigned SMT1CPW5           : 1;
    unsigned SMT1CPW6           : 1;
    unsigned SMT1CPW7           : 1;
    };
  } __SMT1CPWLbits_t;

extern __at(0x0492) volatile __SMT1CPWLbits_t SMT1CPWLbits;

#define _CPW0                   0x01
#define _SMT1CPW0               0x01
#define _CPW1                   0x02
#define _SMT1CPW1               0x02
#define _CPW2                   0x04
#define _SMT1CPW2               0x04
#define _CPW3                   0x08
#define _SMT1CPW3               0x08
#define _CPW4                   0x10
#define _SMT1CPW4               0x10
#define _CPW5                   0x20
#define _SMT1CPW5               0x20
#define _CPW6                   0x40
#define _SMT1CPW6               0x40
#define _CPW7                   0x80
#define _SMT1CPW7               0x80

//==============================================================================


//==============================================================================
//        SMT1CPWH Bits

extern __at(0x0493) __sfr SMT1CPWH;

typedef union
  {
  struct
    {
    unsigned CPW8               : 1;
    unsigned CPW9               : 1;
    unsigned CPW10              : 1;
    unsigned CPW11              : 1;
    unsigned CPW12              : 1;
    unsigned CPW13              : 1;
    unsigned CPW14              : 1;
    unsigned CPW15              : 1;
    };

  struct
    {
    unsigned SMT1CPW8           : 1;
    unsigned SMT1CPW9           : 1;
    unsigned SMT1CPW10          : 1;
    unsigned SMT1CPW11          : 1;
    unsigned SMT1CPW12          : 1;
    unsigned SMT1CPW13          : 1;
    unsigned SMT1CPW14          : 1;
    unsigned SMT1CPW15          : 1;
    };
  } __SMT1CPWHbits_t;

extern __at(0x0493) volatile __SMT1CPWHbits_t SMT1CPWHbits;

#define _CPW8                   0x01
#define _SMT1CPW8               0x01
#define _CPW9                   0x02
#define _SMT1CPW9               0x02
#define _CPW10                  0x04
#define _SMT1CPW10              0x04
#define _CPW11                  0x08
#define _SMT1CPW11              0x08
#define _CPW12                  0x10
#define _SMT1CPW12              0x10
#define _CPW13                  0x20
#define _SMT1CPW13              0x20
#define _CPW14                  0x40
#define _SMT1CPW14              0x40
#define _CPW15                  0x80
#define _SMT1CPW15              0x80

//==============================================================================


//==============================================================================
//        SMT1CPWU Bits

extern __at(0x0494) __sfr SMT1CPWU;

typedef union
  {
  struct
    {
    unsigned CPW16              : 1;
    unsigned CPW17              : 1;
    unsigned CPW18              : 1;
    unsigned CPW19              : 1;
    unsigned CPW20              : 1;
    unsigned CPW21              : 1;
    unsigned CPW22              : 1;
    unsigned CPW23              : 1;
    };

  struct
    {
    unsigned SMT1CPW16          : 1;
    unsigned SMT1CPW17          : 1;
    unsigned SMT1CPW18          : 1;
    unsigned SMT1CPW19          : 1;
    unsigned SMT1CPW20          : 1;
    unsigned SMT1CPW21          : 1;
    unsigned SMT1CPW22          : 1;
    unsigned SMT1CPW23          : 1;
    };
  } __SMT1CPWUbits_t;

extern __at(0x0494) volatile __SMT1CPWUbits_t SMT1CPWUbits;

#define _CPW16                  0x01
#define _SMT1CPW16              0x01
#define _CPW17                  0x02
#define _SMT1CPW17              0x02
#define _CPW18                  0x04
#define _SMT1CPW18              0x04
#define _CPW19                  0x08
#define _SMT1CPW19              0x08
#define _CPW20                  0x10
#define _SMT1CPW20              0x10
#define _CPW21                  0x20
#define _SMT1CPW21              0x20
#define _CPW22                  0x40
#define _SMT1CPW22              0x40
#define _CPW23                  0x80
#define _SMT1CPW23              0x80

//==============================================================================

extern __at(0x0495) __sfr SMT1PR;

//==============================================================================
//        SMT1PRL Bits

extern __at(0x0495) __sfr SMT1PRL;

typedef struct
  {
  unsigned SMT1PR0              : 1;
  unsigned SMT1PR1              : 1;
  unsigned SMT1PR2              : 1;
  unsigned SMT1PR3              : 1;
  unsigned SMT1PR4              : 1;
  unsigned SMT1PR5              : 1;
  unsigned SMT1PR6              : 1;
  unsigned SMT1PR7              : 1;
  } __SMT1PRLbits_t;

extern __at(0x0495) volatile __SMT1PRLbits_t SMT1PRLbits;

#define _SMT1PR0                0x01
#define _SMT1PR1                0x02
#define _SMT1PR2                0x04
#define _SMT1PR3                0x08
#define _SMT1PR4                0x10
#define _SMT1PR5                0x20
#define _SMT1PR6                0x40
#define _SMT1PR7                0x80

//==============================================================================


//==============================================================================
//        SMT1PRH Bits

extern __at(0x0496) __sfr SMT1PRH;

typedef struct
  {
  unsigned SMT1PR8              : 1;
  unsigned SMT1PR9              : 1;
  unsigned SMT1PR10             : 1;
  unsigned SMT1PR11             : 1;
  unsigned SMT1PR12             : 1;
  unsigned SMT1PR13             : 1;
  unsigned SMT1PR14             : 1;
  unsigned SMT1PR15             : 1;
  } __SMT1PRHbits_t;

extern __at(0x0496) volatile __SMT1PRHbits_t SMT1PRHbits;

#define _SMT1PR8                0x01
#define _SMT1PR9                0x02
#define _SMT1PR10               0x04
#define _SMT1PR11               0x08
#define _SMT1PR12               0x10
#define _SMT1PR13               0x20
#define _SMT1PR14               0x40
#define _SMT1PR15               0x80

//==============================================================================


//==============================================================================
//        SMT1PRU Bits

extern __at(0x0497) __sfr SMT1PRU;

typedef struct
  {
  unsigned SMT1PR16             : 1;
  unsigned SMT1PR17             : 1;
  unsigned SMT1PR18             : 1;
  unsigned SMT1PR19             : 1;
  unsigned SMT1PR20             : 1;
  unsigned SMT1PR21             : 1;
  unsigned SMT1PR22             : 1;
  unsigned SMT1PR23             : 1;
  } __SMT1PRUbits_t;

extern __at(0x0497) volatile __SMT1PRUbits_t SMT1PRUbits;

#define _SMT1PR16               0x01
#define _SMT1PR17               0x02
#define _SMT1PR18               0x04
#define _SMT1PR19               0x08
#define _SMT1PR20               0x10
#define _SMT1PR21               0x20
#define _SMT1PR22               0x40
#define _SMT1PR23               0x80

//==============================================================================


//==============================================================================
//        SMT1CON0 Bits

extern __at(0x0498) __sfr SMT1CON0;

typedef union
  {
  struct
    {
    unsigned SMT1PS0            : 1;
    unsigned SMT1PS1            : 1;
    unsigned CPOL               : 1;
    unsigned SPOL               : 1;
    unsigned WPOL               : 1;
    unsigned STP                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SMT1EN             : 1;
    };

  struct
    {
    unsigned SMT1PS             : 2;
    unsigned                    : 6;
    };
  } __SMT1CON0bits_t;

extern __at(0x0498) volatile __SMT1CON0bits_t SMT1CON0bits;

#define _SMT1CON0_SMT1PS0       0x01
#define _SMT1CON0_SMT1PS1       0x02
#define _SMT1CON0_CPOL          0x04
#define _SMT1CON0_SPOL          0x08
#define _SMT1CON0_WPOL          0x10
#define _SMT1CON0_STP           0x20
#define _SMT1CON0_EN            0x80
#define _SMT1CON0_SMT1EN        0x80

//==============================================================================


//==============================================================================
//        SMT1CON1 Bits

extern __at(0x0499) __sfr SMT1CON1;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned REPEAT             : 1;
    unsigned SMT1GO             : 1;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };
  } __SMT1CON1bits_t;

extern __at(0x0499) volatile __SMT1CON1bits_t SMT1CON1bits;

#define _SMT1CON1_MODE0         0x01
#define _SMT1CON1_MODE1         0x02
#define _SMT1CON1_MODE2         0x04
#define _SMT1CON1_MODE3         0x08
#define _SMT1CON1_REPEAT        0x40
#define _SMT1CON1_SMT1GO        0x80

//==============================================================================


//==============================================================================
//        SMT1STAT Bits

extern __at(0x049A) __sfr SMT1STAT;

typedef union
  {
  struct
    {
    unsigned AS                 : 1;
    unsigned WS                 : 1;
    unsigned TS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RST                : 1;
    unsigned CPWUP              : 1;
    unsigned CPRUP              : 1;
    };

  struct
    {
    unsigned SMT1AS             : 1;
    unsigned SMT1WS             : 1;
    unsigned SMT1TS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SMT1RESET          : 1;
    unsigned SMT1CPWUP          : 1;
    unsigned SMT1CPRUP          : 1;
    };
  } __SMT1STATbits_t;

extern __at(0x049A) volatile __SMT1STATbits_t SMT1STATbits;

#define _AS                     0x01
#define _SMT1AS                 0x01
#define _WS                     0x02
#define _SMT1WS                 0x02
#define _TS                     0x04
#define _SMT1TS                 0x04
#define _RST                    0x20
#define _SMT1RESET              0x20
#define _CPWUP                  0x40
#define _SMT1CPWUP              0x40
#define _CPRUP                  0x80
#define _SMT1CPRUP              0x80

//==============================================================================


//==============================================================================
//        SMT1CLK Bits

extern __at(0x049B) __sfr SMT1CLK;

typedef union
  {
  struct
    {
    unsigned CSEL0              : 1;
    unsigned CSEL1              : 1;
    unsigned CSEL2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1CSEL0          : 1;
    unsigned SMT1CSEL1          : 1;
    unsigned SMT1CSEL2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1CSEL           : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CSEL               : 3;
    unsigned                    : 5;
    };
  } __SMT1CLKbits_t;

extern __at(0x049B) volatile __SMT1CLKbits_t SMT1CLKbits;

#define _CSEL0                  0x01
#define _SMT1CSEL0              0x01
#define _CSEL1                  0x02
#define _SMT1CSEL1              0x02
#define _CSEL2                  0x04
#define _SMT1CSEL2              0x04

//==============================================================================


//==============================================================================
//        SMT1SIG Bits

extern __at(0x049C) __sfr SMT1SIG;

typedef union
  {
  struct
    {
    unsigned SSEL0              : 1;
    unsigned SSEL1              : 1;
    unsigned SSEL2              : 1;
    unsigned SSEL3              : 1;
    unsigned SSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1SSEL0          : 1;
    unsigned SMT1SSEL1          : 1;
    unsigned SMT1SSEL2          : 1;
    unsigned SMT1SSEL3          : 1;
    unsigned SMT1SSEL4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1SSEL           : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned SSEL               : 5;
    unsigned                    : 3;
    };
  } __SMT1SIGbits_t;

extern __at(0x049C) volatile __SMT1SIGbits_t SMT1SIGbits;

#define _SSEL0                  0x01
#define _SMT1SSEL0              0x01
#define _SSEL1                  0x02
#define _SMT1SSEL1              0x02
#define _SSEL2                  0x04
#define _SMT1SSEL2              0x04
#define _SSEL3                  0x08
#define _SMT1SSEL3              0x08
#define _SSEL4                  0x10
#define _SMT1SSEL4              0x10

//==============================================================================


//==============================================================================
//        SMT1WIN Bits

extern __at(0x049D) __sfr SMT1WIN;

typedef union
  {
  struct
    {
    unsigned WSEL0              : 1;
    unsigned WSEL1              : 1;
    unsigned WSEL2              : 1;
    unsigned WSEL3              : 1;
    unsigned WSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1WSEL0          : 1;
    unsigned SMT1WSEL1          : 1;
    unsigned SMT1WSEL2          : 1;
    unsigned SMT1WSEL3          : 1;
    unsigned SMT1WSEL4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT1WSEL           : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned WSEL               : 5;
    unsigned                    : 3;
    };
  } __SMT1WINbits_t;

extern __at(0x049D) volatile __SMT1WINbits_t SMT1WINbits;

#define _WSEL0                  0x01
#define _SMT1WSEL0              0x01
#define _WSEL1                  0x02
#define _SMT1WSEL1              0x02
#define _WSEL2                  0x04
#define _SMT1WSEL2              0x04
#define _WSEL3                  0x08
#define _SMT1WSEL3              0x08
#define _WSEL4                  0x10
#define _SMT1WSEL4              0x10

//==============================================================================

extern __at(0x050C) __sfr SMT2TMR;

//==============================================================================
//        SMT2TMRL Bits

extern __at(0x050C) __sfr SMT2TMRL;

typedef struct
  {
  unsigned SMT2TMR0             : 1;
  unsigned SMT2TMR1             : 1;
  unsigned SMT2TMR2             : 1;
  unsigned SMT2TMR3             : 1;
  unsigned SMT2TMR4             : 1;
  unsigned SMT2TMR5             : 1;
  unsigned SMT2TMR6             : 1;
  unsigned SMT2TMR7             : 1;
  } __SMT2TMRLbits_t;

extern __at(0x050C) volatile __SMT2TMRLbits_t SMT2TMRLbits;

#define _SMT2TMR0               0x01
#define _SMT2TMR1               0x02
#define _SMT2TMR2               0x04
#define _SMT2TMR3               0x08
#define _SMT2TMR4               0x10
#define _SMT2TMR5               0x20
#define _SMT2TMR6               0x40
#define _SMT2TMR7               0x80

//==============================================================================


//==============================================================================
//        SMT2TMRH Bits

extern __at(0x050D) __sfr SMT2TMRH;

typedef struct
  {
  unsigned SMT2TMR8             : 1;
  unsigned SMT2TMR9             : 1;
  unsigned SMT2TMR10            : 1;
  unsigned SMT2TMR11            : 1;
  unsigned SMT2TMR12            : 1;
  unsigned SMT2TMR13            : 1;
  unsigned SMT2TMR14            : 1;
  unsigned SMT2TMR15            : 1;
  } __SMT2TMRHbits_t;

extern __at(0x050D) volatile __SMT2TMRHbits_t SMT2TMRHbits;

#define _SMT2TMR8               0x01
#define _SMT2TMR9               0x02
#define _SMT2TMR10              0x04
#define _SMT2TMR11              0x08
#define _SMT2TMR12              0x10
#define _SMT2TMR13              0x20
#define _SMT2TMR14              0x40
#define _SMT2TMR15              0x80

//==============================================================================


//==============================================================================
//        SMT2TMRU Bits

extern __at(0x050E) __sfr SMT2TMRU;

typedef struct
  {
  unsigned SMT2TMR16            : 1;
  unsigned SMT2TMR17            : 1;
  unsigned SMT2TMR18            : 1;
  unsigned SMT2TMR19            : 1;
  unsigned SMT2TMR20            : 1;
  unsigned SMT2TMR21            : 1;
  unsigned SMT2TMR22            : 1;
  unsigned SMT2TMR23            : 1;
  } __SMT2TMRUbits_t;

extern __at(0x050E) volatile __SMT2TMRUbits_t SMT2TMRUbits;

#define _SMT2TMR16              0x01
#define _SMT2TMR17              0x02
#define _SMT2TMR18              0x04
#define _SMT2TMR19              0x08
#define _SMT2TMR20              0x10
#define _SMT2TMR21              0x20
#define _SMT2TMR22              0x40
#define _SMT2TMR23              0x80

//==============================================================================

extern __at(0x050F) __sfr SMT2CPR;

//==============================================================================
//        SMT2CPRL Bits

extern __at(0x050F) __sfr SMT2CPRL;

typedef struct
  {
  unsigned CPR0                 : 1;
  unsigned CPR1                 : 1;
  unsigned CPR2                 : 1;
  unsigned CPR3                 : 1;
  unsigned CPR4                 : 1;
  unsigned CPR5                 : 1;
  unsigned CPR6                 : 1;
  unsigned CPR7                 : 1;
  } __SMT2CPRLbits_t;

extern __at(0x050F) volatile __SMT2CPRLbits_t SMT2CPRLbits;

#define _SMT2CPRL_CPR0          0x01
#define _SMT2CPRL_CPR1          0x02
#define _SMT2CPRL_CPR2          0x04
#define _SMT2CPRL_CPR3          0x08
#define _SMT2CPRL_CPR4          0x10
#define _SMT2CPRL_CPR5          0x20
#define _SMT2CPRL_CPR6          0x40
#define _SMT2CPRL_CPR7          0x80

//==============================================================================


//==============================================================================
//        SMT2CPRH Bits

extern __at(0x0510) __sfr SMT2CPRH;

typedef union
  {
  struct
    {
    unsigned CPR8               : 1;
    unsigned CPR9               : 1;
    unsigned CPR10              : 1;
    unsigned CPR11              : 1;
    unsigned CPR12              : 1;
    unsigned CPR13              : 1;
    unsigned CPR14              : 1;
    unsigned CPR15              : 1;
    };

  struct
    {
    unsigned SMT2CPR8           : 1;
    unsigned SMT2CPR9           : 1;
    unsigned SMT2CPR10          : 1;
    unsigned SMT2CPR11          : 1;
    unsigned SMT2CPR12          : 1;
    unsigned SMT2CPR13          : 1;
    unsigned SMT2CPR14          : 1;
    unsigned SMT2CPR15          : 1;
    };
  } __SMT2CPRHbits_t;

extern __at(0x0510) volatile __SMT2CPRHbits_t SMT2CPRHbits;

#define _SMT2CPRH_CPR8          0x01
#define _SMT2CPRH_SMT2CPR8      0x01
#define _SMT2CPRH_CPR9          0x02
#define _SMT2CPRH_SMT2CPR9      0x02
#define _SMT2CPRH_CPR10         0x04
#define _SMT2CPRH_SMT2CPR10     0x04
#define _SMT2CPRH_CPR11         0x08
#define _SMT2CPRH_SMT2CPR11     0x08
#define _SMT2CPRH_CPR12         0x10
#define _SMT2CPRH_SMT2CPR12     0x10
#define _SMT2CPRH_CPR13         0x20
#define _SMT2CPRH_SMT2CPR13     0x20
#define _SMT2CPRH_CPR14         0x40
#define _SMT2CPRH_SMT2CPR14     0x40
#define _SMT2CPRH_CPR15         0x80
#define _SMT2CPRH_SMT2CPR15     0x80

//==============================================================================


//==============================================================================
//        SMT2CPRU Bits

extern __at(0x0511) __sfr SMT2CPRU;

typedef union
  {
  struct
    {
    unsigned CPR16              : 1;
    unsigned CPR17              : 1;
    unsigned CPR18              : 1;
    unsigned CPR19              : 1;
    unsigned CPR20              : 1;
    unsigned CPR21              : 1;
    unsigned CPR22              : 1;
    unsigned CPR23              : 1;
    };

  struct
    {
    unsigned SMT2CPR16          : 1;
    unsigned SMT2CPR17          : 1;
    unsigned SMT2CPR18          : 1;
    unsigned SMT2CPR19          : 1;
    unsigned SMT2CPR20          : 1;
    unsigned SMT2CPR21          : 1;
    unsigned SMT2CPR22          : 1;
    unsigned SMT2CPR23          : 1;
    };
  } __SMT2CPRUbits_t;

extern __at(0x0511) volatile __SMT2CPRUbits_t SMT2CPRUbits;

#define _SMT2CPRU_CPR16         0x01
#define _SMT2CPRU_SMT2CPR16     0x01
#define _SMT2CPRU_CPR17         0x02
#define _SMT2CPRU_SMT2CPR17     0x02
#define _SMT2CPRU_CPR18         0x04
#define _SMT2CPRU_SMT2CPR18     0x04
#define _SMT2CPRU_CPR19         0x08
#define _SMT2CPRU_SMT2CPR19     0x08
#define _SMT2CPRU_CPR20         0x10
#define _SMT2CPRU_SMT2CPR20     0x10
#define _SMT2CPRU_CPR21         0x20
#define _SMT2CPRU_SMT2CPR21     0x20
#define _SMT2CPRU_CPR22         0x40
#define _SMT2CPRU_SMT2CPR22     0x40
#define _SMT2CPRU_CPR23         0x80
#define _SMT2CPRU_SMT2CPR23     0x80

//==============================================================================

extern __at(0x0512) __sfr SMT2CPW;

//==============================================================================
//        SMT2CPWL Bits

extern __at(0x0512) __sfr SMT2CPWL;

typedef union
  {
  struct
    {
    unsigned CPW0               : 1;
    unsigned CPW1               : 1;
    unsigned CPW2               : 1;
    unsigned CPW3               : 1;
    unsigned CPW4               : 1;
    unsigned CPW5               : 1;
    unsigned CPW6               : 1;
    unsigned CPW7               : 1;
    };

  struct
    {
    unsigned SMT2CPW0           : 1;
    unsigned SMT2CPW1           : 1;
    unsigned SMT2CPW2           : 1;
    unsigned SMT2CPW3           : 1;
    unsigned SMT2CPW4           : 1;
    unsigned SMT2CPW5           : 1;
    unsigned SMT2CPW6           : 1;
    unsigned SMT2CPW7           : 1;
    };
  } __SMT2CPWLbits_t;

extern __at(0x0512) volatile __SMT2CPWLbits_t SMT2CPWLbits;

#define _SMT2CPWL_CPW0          0x01
#define _SMT2CPWL_SMT2CPW0      0x01
#define _SMT2CPWL_CPW1          0x02
#define _SMT2CPWL_SMT2CPW1      0x02
#define _SMT2CPWL_CPW2          0x04
#define _SMT2CPWL_SMT2CPW2      0x04
#define _SMT2CPWL_CPW3          0x08
#define _SMT2CPWL_SMT2CPW3      0x08
#define _SMT2CPWL_CPW4          0x10
#define _SMT2CPWL_SMT2CPW4      0x10
#define _SMT2CPWL_CPW5          0x20
#define _SMT2CPWL_SMT2CPW5      0x20
#define _SMT2CPWL_CPW6          0x40
#define _SMT2CPWL_SMT2CPW6      0x40
#define _SMT2CPWL_CPW7          0x80
#define _SMT2CPWL_SMT2CPW7      0x80

//==============================================================================


//==============================================================================
//        SMT2CPWH Bits

extern __at(0x0513) __sfr SMT2CPWH;

typedef union
  {
  struct
    {
    unsigned CPW8               : 1;
    unsigned CPW9               : 1;
    unsigned CPW10              : 1;
    unsigned CPW11              : 1;
    unsigned CPW12              : 1;
    unsigned CPW13              : 1;
    unsigned CPW14              : 1;
    unsigned CPW15              : 1;
    };

  struct
    {
    unsigned SMT2CPW8           : 1;
    unsigned SMT2CPW9           : 1;
    unsigned SMT2CPW10          : 1;
    unsigned SMT2CPW11          : 1;
    unsigned SMT2CPW12          : 1;
    unsigned SMT2CPW13          : 1;
    unsigned SMT2CPW14          : 1;
    unsigned SMT2CPW15          : 1;
    };
  } __SMT2CPWHbits_t;

extern __at(0x0513) volatile __SMT2CPWHbits_t SMT2CPWHbits;

#define _SMT2CPWH_CPW8          0x01
#define _SMT2CPWH_SMT2CPW8      0x01
#define _SMT2CPWH_CPW9          0x02
#define _SMT2CPWH_SMT2CPW9      0x02
#define _SMT2CPWH_CPW10         0x04
#define _SMT2CPWH_SMT2CPW10     0x04
#define _SMT2CPWH_CPW11         0x08
#define _SMT2CPWH_SMT2CPW11     0x08
#define _SMT2CPWH_CPW12         0x10
#define _SMT2CPWH_SMT2CPW12     0x10
#define _SMT2CPWH_CPW13         0x20
#define _SMT2CPWH_SMT2CPW13     0x20
#define _SMT2CPWH_CPW14         0x40
#define _SMT2CPWH_SMT2CPW14     0x40
#define _SMT2CPWH_CPW15         0x80
#define _SMT2CPWH_SMT2CPW15     0x80

//==============================================================================


//==============================================================================
//        SMT2CPWU Bits

extern __at(0x0514) __sfr SMT2CPWU;

typedef union
  {
  struct
    {
    unsigned CPW16              : 1;
    unsigned CPW17              : 1;
    unsigned CPW18              : 1;
    unsigned CPW19              : 1;
    unsigned CPW20              : 1;
    unsigned CPW21              : 1;
    unsigned CPW22              : 1;
    unsigned CPW23              : 1;
    };

  struct
    {
    unsigned SMT2CPW16          : 1;
    unsigned SMT2CPW17          : 1;
    unsigned SMT2CPW18          : 1;
    unsigned SMT2CPW19          : 1;
    unsigned SMT2CPW20          : 1;
    unsigned SMT2CPW21          : 1;
    unsigned SMT2CPW22          : 1;
    unsigned SMT2CPW23          : 1;
    };
  } __SMT2CPWUbits_t;

extern __at(0x0514) volatile __SMT2CPWUbits_t SMT2CPWUbits;

#define _SMT2CPWU_CPW16         0x01
#define _SMT2CPWU_SMT2CPW16     0x01
#define _SMT2CPWU_CPW17         0x02
#define _SMT2CPWU_SMT2CPW17     0x02
#define _SMT2CPWU_CPW18         0x04
#define _SMT2CPWU_SMT2CPW18     0x04
#define _SMT2CPWU_CPW19         0x08
#define _SMT2CPWU_SMT2CPW19     0x08
#define _SMT2CPWU_CPW20         0x10
#define _SMT2CPWU_SMT2CPW20     0x10
#define _SMT2CPWU_CPW21         0x20
#define _SMT2CPWU_SMT2CPW21     0x20
#define _SMT2CPWU_CPW22         0x40
#define _SMT2CPWU_SMT2CPW22     0x40
#define _SMT2CPWU_CPW23         0x80
#define _SMT2CPWU_SMT2CPW23     0x80

//==============================================================================

extern __at(0x0515) __sfr SMT2PR;

//==============================================================================
//        SMT2PRL Bits

extern __at(0x0515) __sfr SMT2PRL;

typedef struct
  {
  unsigned SMT2PR0              : 1;
  unsigned SMT2PR1              : 1;
  unsigned SMT2PR2              : 1;
  unsigned SMT2PR3              : 1;
  unsigned SMT2PR4              : 1;
  unsigned SMT2PR5              : 1;
  unsigned SMT2PR6              : 1;
  unsigned SMT2PR7              : 1;
  } __SMT2PRLbits_t;

extern __at(0x0515) volatile __SMT2PRLbits_t SMT2PRLbits;

#define _SMT2PR0                0x01
#define _SMT2PR1                0x02
#define _SMT2PR2                0x04
#define _SMT2PR3                0x08
#define _SMT2PR4                0x10
#define _SMT2PR5                0x20
#define _SMT2PR6                0x40
#define _SMT2PR7                0x80

//==============================================================================


//==============================================================================
//        SMT2PRH Bits

extern __at(0x0516) __sfr SMT2PRH;

typedef struct
  {
  unsigned SMT2PR8              : 1;
  unsigned SMT2PR9              : 1;
  unsigned SMT2PR10             : 1;
  unsigned SMT2PR11             : 1;
  unsigned SMT2PR12             : 1;
  unsigned SMT2PR13             : 1;
  unsigned SMT2PR14             : 1;
  unsigned SMT2PR15             : 1;
  } __SMT2PRHbits_t;

extern __at(0x0516) volatile __SMT2PRHbits_t SMT2PRHbits;

#define _SMT2PR8                0x01
#define _SMT2PR9                0x02
#define _SMT2PR10               0x04
#define _SMT2PR11               0x08
#define _SMT2PR12               0x10
#define _SMT2PR13               0x20
#define _SMT2PR14               0x40
#define _SMT2PR15               0x80

//==============================================================================


//==============================================================================
//        SMT2PRU Bits

extern __at(0x0517) __sfr SMT2PRU;

typedef struct
  {
  unsigned SMT2PR16             : 1;
  unsigned SMT2PR17             : 1;
  unsigned SMT2PR18             : 1;
  unsigned SMT2PR19             : 1;
  unsigned SMT2PR20             : 1;
  unsigned SMT2PR21             : 1;
  unsigned SMT2PR22             : 1;
  unsigned SMT2PR23             : 1;
  } __SMT2PRUbits_t;

extern __at(0x0517) volatile __SMT2PRUbits_t SMT2PRUbits;

#define _SMT2PR16               0x01
#define _SMT2PR17               0x02
#define _SMT2PR18               0x04
#define _SMT2PR19               0x08
#define _SMT2PR20               0x10
#define _SMT2PR21               0x20
#define _SMT2PR22               0x40
#define _SMT2PR23               0x80

//==============================================================================


//==============================================================================
//        SMT2CON0 Bits

extern __at(0x0518) __sfr SMT2CON0;

typedef union
  {
  struct
    {
    unsigned SMT2PS0            : 1;
    unsigned SMT2PS1            : 1;
    unsigned CPOL               : 1;
    unsigned SPOL               : 1;
    unsigned WPOL               : 1;
    unsigned STP                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SMT2EN             : 1;
    };

  struct
    {
    unsigned SMT2PS             : 2;
    unsigned                    : 6;
    };
  } __SMT2CON0bits_t;

extern __at(0x0518) volatile __SMT2CON0bits_t SMT2CON0bits;

#define _SMT2CON0_SMT2PS0       0x01
#define _SMT2CON0_SMT2PS1       0x02
#define _SMT2CON0_CPOL          0x04
#define _SMT2CON0_SPOL          0x08
#define _SMT2CON0_WPOL          0x10
#define _SMT2CON0_STP           0x20
#define _SMT2CON0_EN            0x80
#define _SMT2CON0_SMT2EN        0x80

//==============================================================================


//==============================================================================
//        SMT2CON1 Bits

extern __at(0x0519) __sfr SMT2CON1;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned REPEAT             : 1;
    unsigned SMT2GO             : 1;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };
  } __SMT2CON1bits_t;

extern __at(0x0519) volatile __SMT2CON1bits_t SMT2CON1bits;

#define _SMT2CON1_MODE0         0x01
#define _SMT2CON1_MODE1         0x02
#define _SMT2CON1_MODE2         0x04
#define _SMT2CON1_MODE3         0x08
#define _SMT2CON1_REPEAT        0x40
#define _SMT2CON1_SMT2GO        0x80

//==============================================================================


//==============================================================================
//        SMT2STAT Bits

extern __at(0x051A) __sfr SMT2STAT;

typedef union
  {
  struct
    {
    unsigned AS                 : 1;
    unsigned WS                 : 1;
    unsigned TS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RST                : 1;
    unsigned CPWUP              : 1;
    unsigned CPRUP              : 1;
    };

  struct
    {
    unsigned SMT2AS             : 1;
    unsigned SMT2WS             : 1;
    unsigned SMT2TS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SMT2RESET          : 1;
    unsigned SMT2CPWUP          : 1;
    unsigned SMT2CPRUP          : 1;
    };
  } __SMT2STATbits_t;

extern __at(0x051A) volatile __SMT2STATbits_t SMT2STATbits;

#define _SMT2STAT_AS            0x01
#define _SMT2STAT_SMT2AS        0x01
#define _SMT2STAT_WS            0x02
#define _SMT2STAT_SMT2WS        0x02
#define _SMT2STAT_TS            0x04
#define _SMT2STAT_SMT2TS        0x04
#define _SMT2STAT_RST           0x20
#define _SMT2STAT_SMT2RESET     0x20
#define _SMT2STAT_CPWUP         0x40
#define _SMT2STAT_SMT2CPWUP     0x40
#define _SMT2STAT_CPRUP         0x80
#define _SMT2STAT_SMT2CPRUP     0x80

//==============================================================================


//==============================================================================
//        SMT2CLK Bits

extern __at(0x051B) __sfr SMT2CLK;

typedef union
  {
  struct
    {
    unsigned CSEL0              : 1;
    unsigned CSEL1              : 1;
    unsigned CSEL2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT2CSEL0          : 1;
    unsigned SMT2CSEL1          : 1;
    unsigned SMT2CSEL2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CSEL               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned SMT2CSEL           : 3;
    unsigned                    : 5;
    };
  } __SMT2CLKbits_t;

extern __at(0x051B) volatile __SMT2CLKbits_t SMT2CLKbits;

#define _SMT2CLK_CSEL0          0x01
#define _SMT2CLK_SMT2CSEL0      0x01
#define _SMT2CLK_CSEL1          0x02
#define _SMT2CLK_SMT2CSEL1      0x02
#define _SMT2CLK_CSEL2          0x04
#define _SMT2CLK_SMT2CSEL2      0x04

//==============================================================================


//==============================================================================
//        SMT2SIG Bits

extern __at(0x051C) __sfr SMT2SIG;

typedef union
  {
  struct
    {
    unsigned SSEL0              : 1;
    unsigned SSEL1              : 1;
    unsigned SSEL2              : 1;
    unsigned SSEL3              : 1;
    unsigned SSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT2SSEL0          : 1;
    unsigned SMT2SSEL1          : 1;
    unsigned SMT2SSEL2          : 1;
    unsigned SMT2SSEL3          : 1;
    unsigned SMT2SSEL4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSEL               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned SMT2SSEL           : 5;
    unsigned                    : 3;
    };
  } __SMT2SIGbits_t;

extern __at(0x051C) volatile __SMT2SIGbits_t SMT2SIGbits;

#define _SMT2SIG_SSEL0          0x01
#define _SMT2SIG_SMT2SSEL0      0x01
#define _SMT2SIG_SSEL1          0x02
#define _SMT2SIG_SMT2SSEL1      0x02
#define _SMT2SIG_SSEL2          0x04
#define _SMT2SIG_SMT2SSEL2      0x04
#define _SMT2SIG_SSEL3          0x08
#define _SMT2SIG_SMT2SSEL3      0x08
#define _SMT2SIG_SSEL4          0x10
#define _SMT2SIG_SMT2SSEL4      0x10

//==============================================================================


//==============================================================================
//        SMT2WIN Bits

extern __at(0x051D) __sfr SMT2WIN;

typedef union
  {
  struct
    {
    unsigned WSEL0              : 1;
    unsigned WSEL1              : 1;
    unsigned WSEL2              : 1;
    unsigned WSEL3              : 1;
    unsigned WSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMT2WSEL0          : 1;
    unsigned SMT2WSEL1          : 1;
    unsigned SMT2WSEL2          : 1;
    unsigned SMT2WSEL3          : 1;
    unsigned SMT2WSEL4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WSEL               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned SMT2WSEL           : 5;
    unsigned                    : 3;
    };
  } __SMT2WINbits_t;

extern __at(0x051D) volatile __SMT2WINbits_t SMT2WINbits;

#define _SMT2WIN_WSEL0          0x01
#define _SMT2WIN_SMT2WSEL0      0x01
#define _SMT2WIN_WSEL1          0x02
#define _SMT2WIN_SMT2WSEL1      0x02
#define _SMT2WIN_WSEL2          0x04
#define _SMT2WIN_SMT2WSEL2      0x04
#define _SMT2WIN_WSEL3          0x08
#define _SMT2WIN_SMT2WSEL3      0x08
#define _SMT2WIN_WSEL4          0x10
#define _SMT2WIN_SMT2WSEL4      0x10

//==============================================================================

extern __at(0x058C) __sfr NCO1ACC;

//==============================================================================
//        NCO1ACCL Bits

extern __at(0x058C) __sfr NCO1ACCL;

typedef struct
  {
  unsigned NCO1ACC0             : 1;
  unsigned NCO1ACC1             : 1;
  unsigned NCO1ACC2             : 1;
  unsigned NCO1ACC3             : 1;
  unsigned NCO1ACC4             : 1;
  unsigned NCO1ACC5             : 1;
  unsigned NCO1ACC6             : 1;
  unsigned NCO1ACC7             : 1;
  } __NCO1ACCLbits_t;

extern __at(0x058C) volatile __NCO1ACCLbits_t NCO1ACCLbits;

#define _NCO1ACC0               0x01
#define _NCO1ACC1               0x02
#define _NCO1ACC2               0x04
#define _NCO1ACC3               0x08
#define _NCO1ACC4               0x10
#define _NCO1ACC5               0x20
#define _NCO1ACC6               0x40
#define _NCO1ACC7               0x80

//==============================================================================


//==============================================================================
//        NCO1ACCH Bits

extern __at(0x058D) __sfr NCO1ACCH;

typedef struct
  {
  unsigned NCO1ACC8             : 1;
  unsigned NCO1ACC9             : 1;
  unsigned NCO1ACC10            : 1;
  unsigned NCO1ACC11            : 1;
  unsigned NCO1ACC12            : 1;
  unsigned NCO1ACC13            : 1;
  unsigned NCO1ACC14            : 1;
  unsigned NCO1ACC15            : 1;
  } __NCO1ACCHbits_t;

extern __at(0x058D) volatile __NCO1ACCHbits_t NCO1ACCHbits;

#define _NCO1ACC8               0x01
#define _NCO1ACC9               0x02
#define _NCO1ACC10              0x04
#define _NCO1ACC11              0x08
#define _NCO1ACC12              0x10
#define _NCO1ACC13              0x20
#define _NCO1ACC14              0x40
#define _NCO1ACC15              0x80

//==============================================================================


//==============================================================================
//        NCO1ACCU Bits

extern __at(0x058E) __sfr NCO1ACCU;

typedef struct
  {
  unsigned NCO1ACC16            : 1;
  unsigned NCO1ACC17            : 1;
  unsigned NCO1ACC18            : 1;
  unsigned NCO1ACC19            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __NCO1ACCUbits_t;

extern __at(0x058E) volatile __NCO1ACCUbits_t NCO1ACCUbits;

#define _NCO1ACC16              0x01
#define _NCO1ACC17              0x02
#define _NCO1ACC18              0x04
#define _NCO1ACC19              0x08

//==============================================================================

extern __at(0x058F) __sfr NCO1INC;

//==============================================================================
//        NCO1INCL Bits

extern __at(0x058F) __sfr NCO1INCL;

typedef struct
  {
  unsigned NCO1INC0             : 1;
  unsigned NCO1INC1             : 1;
  unsigned NCO1INC2             : 1;
  unsigned NCO1INC3             : 1;
  unsigned NCO1INC4             : 1;
  unsigned NCO1INC5             : 1;
  unsigned NCO1INC6             : 1;
  unsigned NCO1INC7             : 1;
  } __NCO1INCLbits_t;

extern __at(0x058F) volatile __NCO1INCLbits_t NCO1INCLbits;

#define _NCO1INC0               0x01
#define _NCO1INC1               0x02
#define _NCO1INC2               0x04
#define _NCO1INC3               0x08
#define _NCO1INC4               0x10
#define _NCO1INC5               0x20
#define _NCO1INC6               0x40
#define _NCO1INC7               0x80

//==============================================================================


//==============================================================================
//        NCO1INCH Bits

extern __at(0x0590) __sfr NCO1INCH;

typedef struct
  {
  unsigned NCO1INC8             : 1;
  unsigned NCO1INC9             : 1;
  unsigned NCO1INC10            : 1;
  unsigned NCO1INC11            : 1;
  unsigned NCO1INC12            : 1;
  unsigned NCO1INC13            : 1;
  unsigned NCO1INC14            : 1;
  unsigned NCO1INC15            : 1;
  } __NCO1INCHbits_t;

extern __at(0x0590) volatile __NCO1INCHbits_t NCO1INCHbits;

#define _NCO1INC8               0x01
#define _NCO1INC9               0x02
#define _NCO1INC10              0x04
#define _NCO1INC11              0x08
#define _NCO1INC12              0x10
#define _NCO1INC13              0x20
#define _NCO1INC14              0x40
#define _NCO1INC15              0x80

//==============================================================================


//==============================================================================
//        NCO1INCU Bits

extern __at(0x0591) __sfr NCO1INCU;

typedef struct
  {
  unsigned NCO1INC16            : 1;
  unsigned NCO1INC17            : 1;
  unsigned NCO1INC18            : 1;
  unsigned NCO1INC19            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __NCO1INCUbits_t;

extern __at(0x0591) volatile __NCO1INCUbits_t NCO1INCUbits;

#define _NCO1INC16              0x01
#define _NCO1INC17              0x02
#define _NCO1INC18              0x04
#define _NCO1INC19              0x08

//==============================================================================


//==============================================================================
//        NCO1CON Bits

extern __at(0x0592) __sfr NCO1CON;

typedef struct
  {
  unsigned N1PFM                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned N1POL                : 1;
  unsigned N1OUT                : 1;
  unsigned                      : 1;
  unsigned N1EN                 : 1;
  } __NCO1CONbits_t;

extern __at(0x0592) volatile __NCO1CONbits_t NCO1CONbits;

#define _N1PFM                  0x01
#define _N1POL                  0x10
#define _N1OUT                  0x20
#define _N1EN                   0x80

//==============================================================================


//==============================================================================
//        NCO1CLK Bits

extern __at(0x0593) __sfr NCO1CLK;

typedef union
  {
  struct
    {
    unsigned N1CKS0             : 1;
    unsigned N1CKS1             : 1;
    unsigned N1CKS2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned N1PWS0             : 1;
    unsigned N1PWS1             : 1;
    unsigned N1PWS2             : 1;
    };

  struct
    {
    unsigned N1CKS              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 5;
    unsigned N1PWS              : 3;
    };
  } __NCO1CLKbits_t;

extern __at(0x0593) volatile __NCO1CLKbits_t NCO1CLKbits;

#define _N1CKS0                 0x01
#define _N1CKS1                 0x02
#define _N1CKS2                 0x04
#define _N1PWS0                 0x20
#define _N1PWS1                 0x40
#define _N1PWS2                 0x80

//==============================================================================


//==============================================================================
//        CWG1CLKCON Bits

extern __at(0x060C) __sfr CWG1CLKCON;

typedef union
  {
  struct
    {
    unsigned CS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1CS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG1CLKCONbits_t;

extern __at(0x060C) volatile __CWG1CLKCONbits_t CWG1CLKCONbits;

#define _CS                     0x01
#define _CWG1CS                 0x01

//==============================================================================


//==============================================================================
//        CWG1ISM Bits

extern __at(0x060D) __sfr CWG1ISM;

typedef union
  {
  struct
    {
    unsigned CWG1ISM0           : 1;
    unsigned CWG1ISM1           : 1;
    unsigned CWG1ISM2           : 1;
    unsigned CWG1ISM3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1ISM            : 4;
    unsigned                    : 4;
    };
  } __CWG1ISMbits_t;

extern __at(0x060D) volatile __CWG1ISMbits_t CWG1ISMbits;

#define _CWG1ISM0               0x01
#define _CWG1ISM1               0x02
#define _CWG1ISM2               0x04
#define _CWG1ISM3               0x08

//==============================================================================


//==============================================================================
//        CWG1DBR Bits

extern __at(0x060E) __sfr CWG1DBR;

typedef union
  {
  struct
    {
    unsigned DBR0               : 1;
    unsigned DBR1               : 1;
    unsigned DBR2               : 1;
    unsigned DBR3               : 1;
    unsigned DBR4               : 1;
    unsigned DBR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBR0           : 1;
    unsigned CWG1DBR1           : 1;
    unsigned CWG1DBR2           : 1;
    unsigned CWG1DBR3           : 1;
    unsigned CWG1DBR4           : 1;
    unsigned CWG1DBR5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DBR                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned CWG1DBR            : 6;
    unsigned                    : 2;
    };
  } __CWG1DBRbits_t;

extern __at(0x060E) volatile __CWG1DBRbits_t CWG1DBRbits;

#define _DBR0                   0x01
#define _CWG1DBR0               0x01
#define _DBR1                   0x02
#define _CWG1DBR1               0x02
#define _DBR2                   0x04
#define _CWG1DBR2               0x04
#define _DBR3                   0x08
#define _CWG1DBR3               0x08
#define _DBR4                   0x10
#define _CWG1DBR4               0x10
#define _DBR5                   0x20
#define _CWG1DBR5               0x20

//==============================================================================


//==============================================================================
//        CWG1DBF Bits

extern __at(0x060F) __sfr CWG1DBF;

typedef union
  {
  struct
    {
    unsigned DBF0               : 1;
    unsigned DBF1               : 1;
    unsigned DBF2               : 1;
    unsigned DBF3               : 1;
    unsigned DBF4               : 1;
    unsigned DBF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBF0           : 1;
    unsigned CWG1DBF1           : 1;
    unsigned CWG1DBF2           : 1;
    unsigned CWG1DBF3           : 1;
    unsigned CWG1DBF4           : 1;
    unsigned CWG1DBF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DBF                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned CWG1DBF            : 6;
    unsigned                    : 2;
    };
  } __CWG1DBFbits_t;

extern __at(0x060F) volatile __CWG1DBFbits_t CWG1DBFbits;

#define _DBF0                   0x01
#define _CWG1DBF0               0x01
#define _DBF1                   0x02
#define _CWG1DBF1               0x02
#define _DBF2                   0x04
#define _CWG1DBF2               0x04
#define _DBF3                   0x08
#define _CWG1DBF3               0x08
#define _DBF4                   0x10
#define _CWG1DBF4               0x10
#define _DBF5                   0x20
#define _CWG1DBF5               0x20

//==============================================================================


//==============================================================================
//        CWG1CON0 Bits

extern __at(0x0610) __sfr CWG1CON0;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LD                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CWG1MODE0          : 1;
    unsigned CWG1MODE1          : 1;
    unsigned CWG1MODE2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG1LD             : 1;
    unsigned G1EN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG1EN             : 1;
    };

  struct
    {
    unsigned CWG1MODE           : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CWG1CON0bits_t;

extern __at(0x0610) volatile __CWG1CON0bits_t CWG1CON0bits;

#define _CWG1CON0_MODE0         0x01
#define _CWG1CON0_CWG1MODE0     0x01
#define _CWG1CON0_MODE1         0x02
#define _CWG1CON0_CWG1MODE1     0x02
#define _CWG1CON0_MODE2         0x04
#define _CWG1CON0_CWG1MODE2     0x04
#define _CWG1CON0_LD            0x40
#define _CWG1CON0_CWG1LD        0x40
#define _CWG1CON0_EN            0x80
#define _CWG1CON0_G1EN          0x80
#define _CWG1CON0_CWG1EN        0x80

//==============================================================================


//==============================================================================
//        CWG1CON1 Bits

extern __at(0x0611) __sfr CWG1CON1;

typedef union
  {
  struct
    {
    unsigned POLA               : 1;
    unsigned POLB               : 1;
    unsigned POLC               : 1;
    unsigned POLD               : 1;
    unsigned                    : 1;
    unsigned IN                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1POLA           : 1;
    unsigned CWG1POLB           : 1;
    unsigned CWG1POLC           : 1;
    unsigned CWG1POLD           : 1;
    unsigned                    : 1;
    unsigned CWG1IN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG1CON1bits_t;

extern __at(0x0611) volatile __CWG1CON1bits_t CWG1CON1bits;

#define _POLA                   0x01
#define _CWG1POLA               0x01
#define _POLB                   0x02
#define _CWG1POLB               0x02
#define _POLC                   0x04
#define _CWG1POLC               0x04
#define _POLD                   0x08
#define _CWG1POLD               0x08
#define _IN                     0x20
#define _CWG1IN                 0x20

//==============================================================================


//==============================================================================
//        CWG1AS0 Bits

extern __at(0x0612) __sfr CWG1AS0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LSAC0              : 1;
    unsigned LSAC1              : 1;
    unsigned LSBD0              : 1;
    unsigned LSBD1              : 1;
    unsigned REN                : 1;
    unsigned SHUTDOWN           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG1LSAC0          : 1;
    unsigned CWG1LSAC1          : 1;
    unsigned CWG1LSBD0          : 1;
    unsigned CWG1LSBD1          : 1;
    unsigned CWG1REN            : 1;
    unsigned CWG1SHUTDOWN       : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CWG1LSAC           : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned LSAC               : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CWG1LSBD           : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LSBD               : 2;
    unsigned                    : 2;
    };
  } __CWG1AS0bits_t;

extern __at(0x0612) volatile __CWG1AS0bits_t CWG1AS0bits;

#define _LSAC0                  0x04
#define _CWG1LSAC0              0x04
#define _LSAC1                  0x08
#define _CWG1LSAC1              0x08
#define _LSBD0                  0x10
#define _CWG1LSBD0              0x10
#define _LSBD1                  0x20
#define _CWG1LSBD1              0x20
#define _REN                    0x40
#define _CWG1REN                0x40
#define _SHUTDOWN               0x80
#define _CWG1SHUTDOWN           0x80

//==============================================================================


//==============================================================================
//        CWG1AS1 Bits

extern __at(0x0613) __sfr CWG1AS1;

typedef struct
  {
  unsigned AS0E                 : 1;
  unsigned AS1E                 : 1;
  unsigned AS2E                 : 1;
  unsigned AS3E                 : 1;
  unsigned AS4E                 : 1;
  unsigned AS5E                 : 1;
  unsigned AS6E                 : 1;
  unsigned                      : 1;
  } __CWG1AS1bits_t;

extern __at(0x0613) volatile __CWG1AS1bits_t CWG1AS1bits;

#define _AS0E                   0x01
#define _AS1E                   0x02
#define _AS2E                   0x04
#define _AS3E                   0x08
#define _AS4E                   0x10
#define _AS5E                   0x20
#define _AS6E                   0x40

//==============================================================================


//==============================================================================
//        CWG1STR Bits

extern __at(0x0614) __sfr CWG1STR;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned OVRA               : 1;
    unsigned OVRB               : 1;
    unsigned OVRC               : 1;
    unsigned OVRD               : 1;
    };

  struct
    {
    unsigned CWG1STRA           : 1;
    unsigned CWG1STRB           : 1;
    unsigned CWG1STRC           : 1;
    unsigned CWG1STRD           : 1;
    unsigned CWG1OVRA           : 1;
    unsigned CWG1OVRB           : 1;
    unsigned CWG1OVRC           : 1;
    unsigned CWG1OVRD           : 1;
    };
  } __CWG1STRbits_t;

extern __at(0x0614) volatile __CWG1STRbits_t CWG1STRbits;

#define _STRA                   0x01
#define _CWG1STRA               0x01
#define _STRB                   0x02
#define _CWG1STRB               0x02
#define _STRC                   0x04
#define _CWG1STRC               0x04
#define _STRD                   0x08
#define _CWG1STRD               0x08
#define _OVRA                   0x10
#define _CWG1OVRA               0x10
#define _OVRB                   0x20
#define _CWG1OVRB               0x20
#define _OVRC                   0x40
#define _CWG1OVRC               0x40
#define _OVRD                   0x80
#define _CWG1OVRD               0x80

//==============================================================================


//==============================================================================
//        CWG2CLKCON Bits

extern __at(0x0616) __sfr CWG2CLKCON;

typedef union
  {
  struct
    {
    unsigned CS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2CS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG2CLKCONbits_t;

extern __at(0x0616) volatile __CWG2CLKCONbits_t CWG2CLKCONbits;

#define _CWG2CLKCON_CS          0x01
#define _CWG2CLKCON_CWG2CS      0x01

//==============================================================================


//==============================================================================
//        CWG2ISM Bits

extern __at(0x0617) __sfr CWG2ISM;

typedef union
  {
  struct
    {
    unsigned CWG2ISM0           : 1;
    unsigned CWG2ISM1           : 1;
    unsigned CWG2ISM2           : 1;
    unsigned CWG2ISM3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2ISM            : 4;
    unsigned                    : 4;
    };
  } __CWG2ISMbits_t;

extern __at(0x0617) volatile __CWG2ISMbits_t CWG2ISMbits;

#define _CWG2ISM0               0x01
#define _CWG2ISM1               0x02
#define _CWG2ISM2               0x04
#define _CWG2ISM3               0x08

//==============================================================================


//==============================================================================
//        CWG2DBR Bits

extern __at(0x0618) __sfr CWG2DBR;

typedef union
  {
  struct
    {
    unsigned DBR0               : 1;
    unsigned DBR1               : 1;
    unsigned DBR2               : 1;
    unsigned DBR3               : 1;
    unsigned DBR4               : 1;
    unsigned DBR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2DBR0           : 1;
    unsigned CWG2DBR1           : 1;
    unsigned CWG2DBR2           : 1;
    unsigned CWG2DBR3           : 1;
    unsigned CWG2DBR4           : 1;
    unsigned CWG2DBR5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2DBR            : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DBR                : 6;
    unsigned                    : 2;
    };
  } __CWG2DBRbits_t;

extern __at(0x0618) volatile __CWG2DBRbits_t CWG2DBRbits;

#define _CWG2DBR_DBR0           0x01
#define _CWG2DBR_CWG2DBR0       0x01
#define _CWG2DBR_DBR1           0x02
#define _CWG2DBR_CWG2DBR1       0x02
#define _CWG2DBR_DBR2           0x04
#define _CWG2DBR_CWG2DBR2       0x04
#define _CWG2DBR_DBR3           0x08
#define _CWG2DBR_CWG2DBR3       0x08
#define _CWG2DBR_DBR4           0x10
#define _CWG2DBR_CWG2DBR4       0x10
#define _CWG2DBR_DBR5           0x20
#define _CWG2DBR_CWG2DBR5       0x20

//==============================================================================


//==============================================================================
//        CWG2DBF Bits

extern __at(0x0619) __sfr CWG2DBF;

typedef union
  {
  struct
    {
    unsigned DBF0               : 1;
    unsigned DBF1               : 1;
    unsigned DBF2               : 1;
    unsigned DBF3               : 1;
    unsigned DBF4               : 1;
    unsigned DBF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2DBF0           : 1;
    unsigned CWG2DBF1           : 1;
    unsigned CWG2DBF2           : 1;
    unsigned CWG2DBF3           : 1;
    unsigned CWG2DBF4           : 1;
    unsigned CWG2DBF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2DBF            : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DBF                : 6;
    unsigned                    : 2;
    };
  } __CWG2DBFbits_t;

extern __at(0x0619) volatile __CWG2DBFbits_t CWG2DBFbits;

#define _CWG2DBF_DBF0           0x01
#define _CWG2DBF_CWG2DBF0       0x01
#define _CWG2DBF_DBF1           0x02
#define _CWG2DBF_CWG2DBF1       0x02
#define _CWG2DBF_DBF2           0x04
#define _CWG2DBF_CWG2DBF2       0x04
#define _CWG2DBF_DBF3           0x08
#define _CWG2DBF_CWG2DBF3       0x08
#define _CWG2DBF_DBF4           0x10
#define _CWG2DBF_CWG2DBF4       0x10
#define _CWG2DBF_DBF5           0x20
#define _CWG2DBF_CWG2DBF5       0x20

//==============================================================================


//==============================================================================
//        CWG2CON0 Bits

extern __at(0x061A) __sfr CWG2CON0;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LD                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CWG2MODE0          : 1;
    unsigned CWG2MODE1          : 1;
    unsigned CWG2MODE2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG2LD             : 1;
    unsigned G2EN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG2EN             : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CWG2MODE           : 3;
    unsigned                    : 5;
    };
  } __CWG2CON0bits_t;

extern __at(0x061A) volatile __CWG2CON0bits_t CWG2CON0bits;

#define _CWG2CON0_MODE0         0x01
#define _CWG2CON0_CWG2MODE0     0x01
#define _CWG2CON0_MODE1         0x02
#define _CWG2CON0_CWG2MODE1     0x02
#define _CWG2CON0_MODE2         0x04
#define _CWG2CON0_CWG2MODE2     0x04
#define _CWG2CON0_LD            0x40
#define _CWG2CON0_CWG2LD        0x40
#define _CWG2CON0_EN            0x80
#define _CWG2CON0_G2EN          0x80
#define _CWG2CON0_CWG2EN        0x80

//==============================================================================


//==============================================================================
//        CWG2CON1 Bits

extern __at(0x061B) __sfr CWG2CON1;

typedef union
  {
  struct
    {
    unsigned POLA               : 1;
    unsigned POLB               : 1;
    unsigned POLC               : 1;
    unsigned POLD               : 1;
    unsigned                    : 1;
    unsigned IN                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2POLA           : 1;
    unsigned CWG2POLB           : 1;
    unsigned CWG2POLC           : 1;
    unsigned CWG2POLD           : 1;
    unsigned                    : 1;
    unsigned CWG2IN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG2CON1bits_t;

extern __at(0x061B) volatile __CWG2CON1bits_t CWG2CON1bits;

#define _CWG2CON1_POLA          0x01
#define _CWG2CON1_CWG2POLA      0x01
#define _CWG2CON1_POLB          0x02
#define _CWG2CON1_CWG2POLB      0x02
#define _CWG2CON1_POLC          0x04
#define _CWG2CON1_CWG2POLC      0x04
#define _CWG2CON1_POLD          0x08
#define _CWG2CON1_CWG2POLD      0x08
#define _CWG2CON1_IN            0x20
#define _CWG2CON1_CWG2IN        0x20

//==============================================================================


//==============================================================================
//        CWG2AS0 Bits

extern __at(0x061C) __sfr CWG2AS0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LSAC0              : 1;
    unsigned LSAC1              : 1;
    unsigned LSBD0              : 1;
    unsigned LSBD1              : 1;
    unsigned REN                : 1;
    unsigned SHUTDOWN           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG2LSAC0          : 1;
    unsigned CWG2LSAC1          : 1;
    unsigned CWG2LSBD0          : 1;
    unsigned CWG2LSBD1          : 1;
    unsigned CWG2REN            : 1;
    unsigned CWG2SHUTDOWN       : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned LSAC               : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CWG2LSAC           : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CWG2LSBD           : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LSBD               : 2;
    unsigned                    : 2;
    };
  } __CWG2AS0bits_t;

extern __at(0x061C) volatile __CWG2AS0bits_t CWG2AS0bits;

#define _CWG2AS0_LSAC0          0x04
#define _CWG2AS0_CWG2LSAC0      0x04
#define _CWG2AS0_LSAC1          0x08
#define _CWG2AS0_CWG2LSAC1      0x08
#define _CWG2AS0_LSBD0          0x10
#define _CWG2AS0_CWG2LSBD0      0x10
#define _CWG2AS0_LSBD1          0x20
#define _CWG2AS0_CWG2LSBD1      0x20
#define _CWG2AS0_REN            0x40
#define _CWG2AS0_CWG2REN        0x40
#define _CWG2AS0_SHUTDOWN       0x80
#define _CWG2AS0_CWG2SHUTDOWN   0x80

//==============================================================================


//==============================================================================
//        CWG2AS1 Bits

extern __at(0x061D) __sfr CWG2AS1;

typedef struct
  {
  unsigned AS0E                 : 1;
  unsigned AS1E                 : 1;
  unsigned AS2E                 : 1;
  unsigned AS3E                 : 1;
  unsigned AS4E                 : 1;
  unsigned AS5E                 : 1;
  unsigned AS6E                 : 1;
  unsigned                      : 1;
  } __CWG2AS1bits_t;

extern __at(0x061D) volatile __CWG2AS1bits_t CWG2AS1bits;

#define _CWG2AS1_AS0E           0x01
#define _CWG2AS1_AS1E           0x02
#define _CWG2AS1_AS2E           0x04
#define _CWG2AS1_AS3E           0x08
#define _CWG2AS1_AS4E           0x10
#define _CWG2AS1_AS5E           0x20
#define _CWG2AS1_AS6E           0x40

//==============================================================================


//==============================================================================
//        CWG2STR Bits

extern __at(0x061E) __sfr CWG2STR;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned OVRA               : 1;
    unsigned OVRB               : 1;
    unsigned OVRC               : 1;
    unsigned OVRD               : 1;
    };

  struct
    {
    unsigned CWG2STRA           : 1;
    unsigned CWG2STRB           : 1;
    unsigned CWG2STRC           : 1;
    unsigned CWG2STRD           : 1;
    unsigned CWG2OVRA           : 1;
    unsigned CWG2OVRB           : 1;
    unsigned CWG2OVRC           : 1;
    unsigned CWG2OVRD           : 1;
    };
  } __CWG2STRbits_t;

extern __at(0x061E) volatile __CWG2STRbits_t CWG2STRbits;

#define _CWG2STR_STRA           0x01
#define _CWG2STR_CWG2STRA       0x01
#define _CWG2STR_STRB           0x02
#define _CWG2STR_CWG2STRB       0x02
#define _CWG2STR_STRC           0x04
#define _CWG2STR_CWG2STRC       0x04
#define _CWG2STR_STRD           0x08
#define _CWG2STR_CWG2STRD       0x08
#define _CWG2STR_OVRA           0x10
#define _CWG2STR_CWG2OVRA       0x10
#define _CWG2STR_OVRB           0x20
#define _CWG2STR_CWG2OVRB       0x20
#define _CWG2STR_OVRC           0x40
#define _CWG2STR_CWG2OVRC       0x40
#define _CWG2STR_OVRD           0x80
#define _CWG2STR_CWG2OVRD       0x80

//==============================================================================


//==============================================================================
//        CWG3CLKCON Bits

extern __at(0x068C) __sfr CWG3CLKCON;

typedef union
  {
  struct
    {
    unsigned CS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG3CS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG3CLKCONbits_t;

extern __at(0x068C) volatile __CWG3CLKCONbits_t CWG3CLKCONbits;

#define _CWG3CLKCON_CS          0x01
#define _CWG3CLKCON_CWG3CS      0x01

//==============================================================================


//==============================================================================
//        CWG3ISM Bits

extern __at(0x068D) __sfr CWG3ISM;

typedef union
  {
  struct
    {
    unsigned CWG3ISM0           : 1;
    unsigned CWG3ISM1           : 1;
    unsigned CWG3ISM2           : 1;
    unsigned CWG3ISM3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG3ISM            : 4;
    unsigned                    : 4;
    };
  } __CWG3ISMbits_t;

extern __at(0x068D) volatile __CWG3ISMbits_t CWG3ISMbits;

#define _CWG3ISM0               0x01
#define _CWG3ISM1               0x02
#define _CWG3ISM2               0x04
#define _CWG3ISM3               0x08

//==============================================================================


//==============================================================================
//        CWG3DBR Bits

extern __at(0x068E) __sfr CWG3DBR;

typedef union
  {
  struct
    {
    unsigned DBR0               : 1;
    unsigned DBR1               : 1;
    unsigned DBR2               : 1;
    unsigned DBR3               : 1;
    unsigned DBR4               : 1;
    unsigned DBR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG3DBR0           : 1;
    unsigned CWG3DBR1           : 1;
    unsigned CWG3DBR2           : 1;
    unsigned CWG3DBR3           : 1;
    unsigned CWG3DBR4           : 1;
    unsigned CWG3DBR5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DBR                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned CWG3DBR            : 6;
    unsigned                    : 2;
    };
  } __CWG3DBRbits_t;

extern __at(0x068E) volatile __CWG3DBRbits_t CWG3DBRbits;

#define _CWG3DBR_DBR0           0x01
#define _CWG3DBR_CWG3DBR0       0x01
#define _CWG3DBR_DBR1           0x02
#define _CWG3DBR_CWG3DBR1       0x02
#define _CWG3DBR_DBR2           0x04
#define _CWG3DBR_CWG3DBR2       0x04
#define _CWG3DBR_DBR3           0x08
#define _CWG3DBR_CWG3DBR3       0x08
#define _CWG3DBR_DBR4           0x10
#define _CWG3DBR_CWG3DBR4       0x10
#define _CWG3DBR_DBR5           0x20
#define _CWG3DBR_CWG3DBR5       0x20

//==============================================================================


//==============================================================================
//        CWG3DBF Bits

extern __at(0x068F) __sfr CWG3DBF;

typedef union
  {
  struct
    {
    unsigned DBF0               : 1;
    unsigned DBF1               : 1;
    unsigned DBF2               : 1;
    unsigned DBF3               : 1;
    unsigned DBF4               : 1;
    unsigned DBF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG3DBF0           : 1;
    unsigned CWG3DBF1           : 1;
    unsigned CWG3DBF2           : 1;
    unsigned CWG3DBF3           : 1;
    unsigned CWG3DBF4           : 1;
    unsigned CWG3DBF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG3DBF            : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DBF                : 6;
    unsigned                    : 2;
    };
  } __CWG3DBFbits_t;

extern __at(0x068F) volatile __CWG3DBFbits_t CWG3DBFbits;

#define _CWG3DBF_DBF0           0x01
#define _CWG3DBF_CWG3DBF0       0x01
#define _CWG3DBF_DBF1           0x02
#define _CWG3DBF_CWG3DBF1       0x02
#define _CWG3DBF_DBF2           0x04
#define _CWG3DBF_CWG3DBF2       0x04
#define _CWG3DBF_DBF3           0x08
#define _CWG3DBF_CWG3DBF3       0x08
#define _CWG3DBF_DBF4           0x10
#define _CWG3DBF_CWG3DBF4       0x10
#define _CWG3DBF_DBF5           0x20
#define _CWG3DBF_CWG3DBF5       0x20

//==============================================================================


//==============================================================================
//        CWG3CON0 Bits

extern __at(0x0690) __sfr CWG3CON0;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LD                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CWG3MODE0          : 1;
    unsigned CWG3MODE1          : 1;
    unsigned CWG3MODE2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG3LD             : 1;
    unsigned G3EN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG3EN             : 1;
    };

  struct
    {
    unsigned CWG3MODE           : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CWG3CON0bits_t;

extern __at(0x0690) volatile __CWG3CON0bits_t CWG3CON0bits;

#define _CWG3CON0_MODE0         0x01
#define _CWG3CON0_CWG3MODE0     0x01
#define _CWG3CON0_MODE1         0x02
#define _CWG3CON0_CWG3MODE1     0x02
#define _CWG3CON0_MODE2         0x04
#define _CWG3CON0_CWG3MODE2     0x04
#define _CWG3CON0_LD            0x40
#define _CWG3CON0_CWG3LD        0x40
#define _CWG3CON0_EN            0x80
#define _CWG3CON0_G3EN          0x80
#define _CWG3CON0_CWG3EN        0x80

//==============================================================================


//==============================================================================
//        CWG3CON1 Bits

extern __at(0x0691) __sfr CWG3CON1;

typedef union
  {
  struct
    {
    unsigned POLA               : 1;
    unsigned POLB               : 1;
    unsigned POLC               : 1;
    unsigned POLD               : 1;
    unsigned                    : 1;
    unsigned IN                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG3POLA           : 1;
    unsigned CWG3POLB           : 1;
    unsigned CWG3POLC           : 1;
    unsigned CWG3POLD           : 1;
    unsigned                    : 1;
    unsigned CWG3IN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG3CON1bits_t;

extern __at(0x0691) volatile __CWG3CON1bits_t CWG3CON1bits;

#define _CWG3CON1_POLA          0x01
#define _CWG3CON1_CWG3POLA      0x01
#define _CWG3CON1_POLB          0x02
#define _CWG3CON1_CWG3POLB      0x02
#define _CWG3CON1_POLC          0x04
#define _CWG3CON1_CWG3POLC      0x04
#define _CWG3CON1_POLD          0x08
#define _CWG3CON1_CWG3POLD      0x08
#define _CWG3CON1_IN            0x20
#define _CWG3CON1_CWG3IN        0x20

//==============================================================================


//==============================================================================
//        CWG3AS0 Bits

extern __at(0x0692) __sfr CWG3AS0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LSAC0              : 1;
    unsigned LSAC1              : 1;
    unsigned LSBD0              : 1;
    unsigned LSBD1              : 1;
    unsigned REN                : 1;
    unsigned SHUTDOWN           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG3LSAC0          : 1;
    unsigned CWG3LSAC1          : 1;
    unsigned CWG3LSBD0          : 1;
    unsigned CWG3LSBD1          : 1;
    unsigned CWG3REN            : 1;
    unsigned CWG3SHUTDOWN       : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CWG3LSAC           : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned LSAC               : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LSBD               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CWG3LSBD           : 2;
    unsigned                    : 2;
    };
  } __CWG3AS0bits_t;

extern __at(0x0692) volatile __CWG3AS0bits_t CWG3AS0bits;

#define _CWG3AS0_LSAC0          0x04
#define _CWG3AS0_CWG3LSAC0      0x04
#define _CWG3AS0_LSAC1          0x08
#define _CWG3AS0_CWG3LSAC1      0x08
#define _CWG3AS0_LSBD0          0x10
#define _CWG3AS0_CWG3LSBD0      0x10
#define _CWG3AS0_LSBD1          0x20
#define _CWG3AS0_CWG3LSBD1      0x20
#define _CWG3AS0_REN            0x40
#define _CWG3AS0_CWG3REN        0x40
#define _CWG3AS0_SHUTDOWN       0x80
#define _CWG3AS0_CWG3SHUTDOWN   0x80

//==============================================================================


//==============================================================================
//        CWG3AS1 Bits

extern __at(0x0693) __sfr CWG3AS1;

typedef struct
  {
  unsigned AS0E                 : 1;
  unsigned AS1E                 : 1;
  unsigned AS2E                 : 1;
  unsigned AS3E                 : 1;
  unsigned AS4E                 : 1;
  unsigned AS5E                 : 1;
  unsigned AS6E                 : 1;
  unsigned                      : 1;
  } __CWG3AS1bits_t;

extern __at(0x0693) volatile __CWG3AS1bits_t CWG3AS1bits;

#define _CWG3AS1_AS0E           0x01
#define _CWG3AS1_AS1E           0x02
#define _CWG3AS1_AS2E           0x04
#define _CWG3AS1_AS3E           0x08
#define _CWG3AS1_AS4E           0x10
#define _CWG3AS1_AS5E           0x20
#define _CWG3AS1_AS6E           0x40

//==============================================================================


//==============================================================================
//        CWG3STR Bits

extern __at(0x0694) __sfr CWG3STR;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned OVRA               : 1;
    unsigned OVRB               : 1;
    unsigned OVRC               : 1;
    unsigned OVRD               : 1;
    };

  struct
    {
    unsigned CWG3STRA           : 1;
    unsigned CWG3STRB           : 1;
    unsigned CWG3STRC           : 1;
    unsigned CWG3STRD           : 1;
    unsigned CWG3OVRA           : 1;
    unsigned CWG3OVRB           : 1;
    unsigned CWG3OVRC           : 1;
    unsigned CWG3OVRD           : 1;
    };
  } __CWG3STRbits_t;

extern __at(0x0694) volatile __CWG3STRbits_t CWG3STRbits;

#define _CWG3STR_STRA           0x01
#define _CWG3STR_CWG3STRA       0x01
#define _CWG3STR_STRB           0x02
#define _CWG3STR_CWG3STRB       0x02
#define _CWG3STR_STRC           0x04
#define _CWG3STR_CWG3STRC       0x04
#define _CWG3STR_STRD           0x08
#define _CWG3STR_CWG3STRD       0x08
#define _CWG3STR_OVRA           0x10
#define _CWG3STR_CWG3OVRA       0x10
#define _CWG3STR_OVRB           0x20
#define _CWG3STR_CWG3OVRB       0x20
#define _CWG3STR_OVRC           0x40
#define _CWG3STR_CWG3OVRC       0x40
#define _CWG3STR_OVRD           0x80
#define _CWG3STR_CWG3OVRD       0x80

//==============================================================================


//==============================================================================
//        PIR0 Bits

extern __at(0x070C) __sfr PIR0;

typedef struct
  {
  unsigned INTF                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCIF                : 1;
  unsigned TMR0IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR0bits_t;

extern __at(0x070C) volatile __PIR0bits_t PIR0bits;

#define _INTF                   0x01
#define _IOCIF                  0x10
#define _TMR0IF                 0x20

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x070D) __sfr PIR1;

typedef struct
  {
  unsigned ADIF                 : 1;
  unsigned ADTIF                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CSWIF                : 1;
  unsigned OSFIF                : 1;
  } __PIR1bits_t;

extern __at(0x070D) volatile __PIR1bits_t PIR1bits;

#define _ADIF                   0x01
#define _ADTIF                  0x02
#define _CSWIF                  0x40
#define _OSFIF                  0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x070E) __sfr PIR2;

typedef struct
  {
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ZCDIF                : 1;
  unsigned                      : 1;
  } __PIR2bits_t;

extern __at(0x070E) volatile __PIR2bits_t PIR2bits;

#define _C1IF                   0x01
#define _C2IF                   0x02
#define _ZCDIF                  0x40

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x070F) __sfr PIR3;

typedef struct
  {
  unsigned SSP1IF               : 1;
  unsigned BCL1IF               : 1;
  unsigned SSP2IF               : 1;
  unsigned BCL2IF               : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x070F) volatile __PIR3bits_t PIR3bits;

#define _SSP1IF                 0x01
#define _BCL1IF                 0x02
#define _SSP2IF                 0x04
#define _BCL2IF                 0x08
#define _TXIF                   0x10
#define _RCIF                   0x20

//==============================================================================


//==============================================================================
//        PIR4 Bits

extern __at(0x0710) __sfr PIR4;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned TMR3IF               : 1;
  unsigned TMR4IF               : 1;
  unsigned TMR5IF               : 1;
  unsigned TMR6IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR4bits_t;

extern __at(0x0710) volatile __PIR4bits_t PIR4bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _TMR3IF                 0x04
#define _TMR4IF                 0x08
#define _TMR5IF                 0x10
#define _TMR6IF                 0x20

//==============================================================================


//==============================================================================
//        PIR5 Bits

extern __at(0x0711) __sfr PIR5;

typedef struct
  {
  unsigned TMR1GIF              : 1;
  unsigned TMR3GIF              : 1;
  unsigned TMR5GIF              : 1;
  unsigned                      : 1;
  unsigned CLC1IF               : 1;
  unsigned CLC2IF               : 1;
  unsigned CLC3IF               : 1;
  unsigned CLC4IF               : 1;
  } __PIR5bits_t;

extern __at(0x0711) volatile __PIR5bits_t PIR5bits;

#define _TMR1GIF                0x01
#define _TMR3GIF                0x02
#define _TMR5GIF                0x04
#define _CLC1IF                 0x10
#define _CLC2IF                 0x20
#define _CLC3IF                 0x40
#define _CLC4IF                 0x80

//==============================================================================


//==============================================================================
//        PIR6 Bits

extern __at(0x0712) __sfr PIR6;

typedef struct
  {
  unsigned CCP1IF               : 1;
  unsigned CCP2IF               : 1;
  unsigned CCP3IF               : 1;
  unsigned CCP4IF               : 1;
  unsigned CCP5IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR6bits_t;

extern __at(0x0712) volatile __PIR6bits_t PIR6bits;

#define _CCP1IF                 0x01
#define _CCP2IF                 0x02
#define _CCP3IF                 0x04
#define _CCP4IF                 0x08
#define _CCP5IF                 0x10

//==============================================================================


//==============================================================================
//        PIR7 Bits

extern __at(0x0713) __sfr PIR7;

typedef union
  {
  struct
    {
    unsigned CWG1IF             : 1;
    unsigned CWG2IF             : 1;
    unsigned CWG3IF             : 1;
    unsigned                    : 1;
    unsigned NCO1IF             : 1;
    unsigned NVMIF              : 1;
    unsigned CRCIF              : 1;
    unsigned SCANIF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NCOIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR7bits_t;

extern __at(0x0713) volatile __PIR7bits_t PIR7bits;

#define _CWG1IF                 0x01
#define _CWG2IF                 0x02
#define _CWG3IF                 0x04
#define _NCO1IF                 0x10
#define _NCOIF                  0x10
#define _NVMIF                  0x20
#define _CRCIF                  0x40
#define _SCANIF                 0x80

//==============================================================================


//==============================================================================
//        PIR8 Bits

extern __at(0x0714) __sfr PIR8;

typedef struct
  {
  unsigned SMT1IF               : 1;
  unsigned SMT1PRAIF            : 1;
  unsigned SMT1PWAIF            : 1;
  unsigned SMT2IF               : 1;
  unsigned SMT2PRAIF            : 1;
  unsigned SMT2PWAIF            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR8bits_t;

extern __at(0x0714) volatile __PIR8bits_t PIR8bits;

#define _SMT1IF                 0x01
#define _SMT1PRAIF              0x02
#define _SMT1PWAIF              0x04
#define _SMT2IF                 0x08
#define _SMT2PRAIF              0x10
#define _SMT2PWAIF              0x20

//==============================================================================


//==============================================================================
//        PIE0 Bits

extern __at(0x0716) __sfr PIE0;

typedef struct
  {
  unsigned INTE                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCIE                : 1;
  unsigned TMR0IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE0bits_t;

extern __at(0x0716) volatile __PIE0bits_t PIE0bits;

#define _INTE                   0x01
#define _IOCIE                  0x10
#define _TMR0IE                 0x20

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0717) __sfr PIE1;

typedef struct
  {
  unsigned ADIE                 : 1;
  unsigned ADTIE                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CSWIE                : 1;
  unsigned OSFIE                : 1;
  } __PIE1bits_t;

extern __at(0x0717) volatile __PIE1bits_t PIE1bits;

#define _ADIE                   0x01
#define _ADTIE                  0x02
#define _CSWIE                  0x40
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0718) __sfr PIE2;

typedef struct
  {
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ZCDIE                : 1;
  unsigned                      : 1;
  } __PIE2bits_t;

extern __at(0x0718) volatile __PIE2bits_t PIE2bits;

#define _C1IE                   0x01
#define _C2IE                   0x02
#define _ZCDIE                  0x40

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0719) __sfr PIE3;

typedef struct
  {
  unsigned SSP1IE               : 1;
  unsigned BCL1IE               : 1;
  unsigned SSP2IE               : 1;
  unsigned BCL2IE               : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0719) volatile __PIE3bits_t PIE3bits;

#define _SSP1IE                 0x01
#define _BCL1IE                 0x02
#define _SSP2IE                 0x04
#define _BCL2IE                 0x08
#define _TXIE                   0x10
#define _RCIE                   0x20

//==============================================================================


//==============================================================================
//        PIE4 Bits

extern __at(0x071A) __sfr PIE4;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned TMR3IE               : 1;
  unsigned TMR4IE               : 1;
  unsigned TMR5IE               : 1;
  unsigned TMR6IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE4bits_t;

extern __at(0x071A) volatile __PIE4bits_t PIE4bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _TMR3IE                 0x04
#define _TMR4IE                 0x08
#define _TMR5IE                 0x10
#define _TMR6IE                 0x20

//==============================================================================


//==============================================================================
//        PIE5 Bits

extern __at(0x071B) __sfr PIE5;

typedef struct
  {
  unsigned TMR1GIE              : 1;
  unsigned TMR3GIE              : 1;
  unsigned TMR5GIE              : 1;
  unsigned                      : 1;
  unsigned CLC1IE               : 1;
  unsigned CLC2IE               : 1;
  unsigned CLC3IE               : 1;
  unsigned CLC4IE               : 1;
  } __PIE5bits_t;

extern __at(0x071B) volatile __PIE5bits_t PIE5bits;

#define _TMR1GIE                0x01
#define _TMR3GIE                0x02
#define _TMR5GIE                0x04
#define _CLC1IE                 0x10
#define _CLC2IE                 0x20
#define _CLC3IE                 0x40
#define _CLC4IE                 0x80

//==============================================================================


//==============================================================================
//        PIE6 Bits

extern __at(0x071C) __sfr PIE6;

typedef struct
  {
  unsigned CCP1IE               : 1;
  unsigned CCP2IE               : 1;
  unsigned CCP3IE               : 1;
  unsigned CCP4IE               : 1;
  unsigned CCP5IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE6bits_t;

extern __at(0x071C) volatile __PIE6bits_t PIE6bits;

#define _CCP1IE                 0x01
#define _CCP2IE                 0x02
#define _CCP3IE                 0x04
#define _CCP4IE                 0x08
#define _CCP5IE                 0x10

//==============================================================================


//==============================================================================
//        PIE7 Bits

extern __at(0x071D) __sfr PIE7;

typedef union
  {
  struct
    {
    unsigned CWG1IE             : 1;
    unsigned CWG2IE             : 1;
    unsigned CWG3IE             : 1;
    unsigned                    : 1;
    unsigned NCO1IE             : 1;
    unsigned NVMIE              : 1;
    unsigned CRCIE              : 1;
    unsigned SCANIE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NCOIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE7bits_t;

extern __at(0x071D) volatile __PIE7bits_t PIE7bits;

#define _CWG1IE                 0x01
#define _CWG2IE                 0x02
#define _CWG3IE                 0x04
#define _NCO1IE                 0x10
#define _NCOIE                  0x10
#define _NVMIE                  0x20
#define _CRCIE                  0x40
#define _SCANIE                 0x80

//==============================================================================


//==============================================================================
//        PIE8 Bits

extern __at(0x071E) __sfr PIE8;

typedef struct
  {
  unsigned SMT1IE               : 1;
  unsigned SMT1PRAIE            : 1;
  unsigned SMT1PWAIE            : 1;
  unsigned SMT2IE               : 1;
  unsigned SMT2PRAIE            : 1;
  unsigned SMT2PWAIE            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE8bits_t;

extern __at(0x071E) volatile __PIE8bits_t PIE8bits;

#define _SMT1IE                 0x01
#define _SMT1PRAIE              0x02
#define _SMT1PWAIE              0x04
#define _SMT2IE                 0x08
#define _SMT2PRAIE              0x10
#define _SMT2PWAIE              0x20

//==============================================================================


//==============================================================================
//        PMD0 Bits

extern __at(0x0796) __sfr PMD0;

typedef struct
  {
  unsigned IOCMD                : 1;
  unsigned CLKRMD               : 1;
  unsigned NVMMD                : 1;
  unsigned SCANMD               : 1;
  unsigned CRCMD                : 1;
  unsigned                      : 1;
  unsigned FVRMD                : 1;
  unsigned SYSCMD               : 1;
  } __PMD0bits_t;

extern __at(0x0796) volatile __PMD0bits_t PMD0bits;

#define _IOCMD                  0x01
#define _CLKRMD                 0x02
#define _NVMMD                  0x04
#define _SCANMD                 0x08
#define _CRCMD                  0x10
#define _FVRMD                  0x40
#define _SYSCMD                 0x80

//==============================================================================


//==============================================================================
//        PMD1 Bits

extern __at(0x0797) __sfr PMD1;

typedef union
  {
  struct
    {
    unsigned TMR0MD             : 1;
    unsigned TMR1MD             : 1;
    unsigned TMR2MD             : 1;
    unsigned TMR3MD             : 1;
    unsigned TMR4MD             : 1;
    unsigned TMR5MD             : 1;
    unsigned TMR6MD             : 1;
    unsigned NCOMD              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NCO1MD             : 1;
    };
  } __PMD1bits_t;

extern __at(0x0797) volatile __PMD1bits_t PMD1bits;

#define _TMR0MD                 0x01
#define _TMR1MD                 0x02
#define _TMR2MD                 0x04
#define _TMR3MD                 0x08
#define _TMR4MD                 0x10
#define _TMR5MD                 0x20
#define _TMR6MD                 0x40
#define _NCOMD                  0x80
#define _NCO1MD                 0x80

//==============================================================================


//==============================================================================
//        PMD2 Bits

extern __at(0x0798) __sfr PMD2;

typedef struct
  {
  unsigned ZCDMD                : 1;
  unsigned CMP1MD               : 1;
  unsigned CMP2MD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADCMD                : 1;
  unsigned DACMD                : 1;
  unsigned                      : 1;
  } __PMD2bits_t;

extern __at(0x0798) volatile __PMD2bits_t PMD2bits;

#define _ZCDMD                  0x01
#define _CMP1MD                 0x02
#define _CMP2MD                 0x04
#define _ADCMD                  0x20
#define _DACMD                  0x40

//==============================================================================


//==============================================================================
//        PMD3 Bits

extern __at(0x0799) __sfr PMD3;

typedef struct
  {
  unsigned CCP1MD               : 1;
  unsigned CCP2MD               : 1;
  unsigned CCP3MD               : 1;
  unsigned CCP4MD               : 1;
  unsigned CCP5MD               : 1;
  unsigned PWM6MD               : 1;
  unsigned PWM7MD               : 1;
  unsigned                      : 1;
  } __PMD3bits_t;

extern __at(0x0799) volatile __PMD3bits_t PMD3bits;

#define _CCP1MD                 0x01
#define _CCP2MD                 0x02
#define _CCP3MD                 0x04
#define _CCP4MD                 0x08
#define _CCP5MD                 0x10
#define _PWM6MD                 0x20
#define _PWM7MD                 0x40

//==============================================================================


//==============================================================================
//        PMD4 Bits

extern __at(0x079A) __sfr PMD4;

typedef struct
  {
  unsigned CWG1MD               : 1;
  unsigned CWG2MD               : 1;
  unsigned CWG3MD               : 1;
  unsigned                      : 1;
  unsigned MSSP1MD              : 1;
  unsigned MSSP2MD              : 1;
  unsigned UART1MD              : 1;
  unsigned                      : 1;
  } __PMD4bits_t;

extern __at(0x079A) volatile __PMD4bits_t PMD4bits;

#define _CWG1MD                 0x01
#define _CWG2MD                 0x02
#define _CWG3MD                 0x04
#define _MSSP1MD                0x10
#define _MSSP2MD                0x20
#define _UART1MD                0x40

//==============================================================================


//==============================================================================
//        PMD5 Bits

extern __at(0x079B) __sfr PMD5;

typedef struct
  {
  unsigned DSMMD                : 1;
  unsigned CLC1MD               : 1;
  unsigned CLC2MD               : 1;
  unsigned CLC3MD               : 1;
  unsigned CLC4MD               : 1;
  unsigned                      : 1;
  unsigned SMT1MD               : 1;
  unsigned SMT2MD               : 1;
  } __PMD5bits_t;

extern __at(0x079B) volatile __PMD5bits_t PMD5bits;

#define _DSMMD                  0x01
#define _CLC1MD                 0x02
#define _CLC2MD                 0x04
#define _CLC3MD                 0x08
#define _CLC4MD                 0x10
#define _SMT1MD                 0x40
#define _SMT2MD                 0x80

//==============================================================================


//==============================================================================
//        WDTCON0 Bits

extern __at(0x080C) __sfr WDTCON0;

typedef union
  {
  struct
    {
    unsigned SEN                : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SWDTEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WDTSEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCON0bits_t;

extern __at(0x080C) volatile __WDTCON0bits_t WDTCON0bits;

#define _WDTCON0_SEN            0x01
#define _WDTCON0_SWDTEN         0x01
#define _WDTCON0_WDTSEN         0x01
#define _WDTCON0_WDTPS0         0x02
#define _WDTCON0_WDTPS1         0x04
#define _WDTCON0_WDTPS2         0x08
#define _WDTCON0_WDTPS3         0x10
#define _WDTCON0_WDTPS4         0x20

//==============================================================================


//==============================================================================
//        WDTCON1 Bits

extern __at(0x080D) __sfr WDTCON1;

typedef union
  {
  struct
    {
    unsigned WINDOW0            : 1;
    unsigned WINDOW1            : 1;
    unsigned WINDOW2            : 1;
    unsigned                    : 1;
    unsigned WDTCS0             : 1;
    unsigned WDTCS1             : 1;
    unsigned WDTCS2             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WDTWINDOW0         : 1;
    unsigned WDTWINDOW1         : 1;
    unsigned WDTWINDOW2         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WINDOW             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned WDTWINDOW          : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned WDTCS              : 3;
    unsigned                    : 1;
    };
  } __WDTCON1bits_t;

extern __at(0x080D) volatile __WDTCON1bits_t WDTCON1bits;

#define _WINDOW0                0x01
#define _WDTWINDOW0             0x01
#define _WINDOW1                0x02
#define _WDTWINDOW1             0x02
#define _WINDOW2                0x04
#define _WDTWINDOW2             0x04
#define _WDTCS0                 0x10
#define _WDTCS1                 0x20
#define _WDTCS2                 0x40

//==============================================================================


//==============================================================================
//        WDTPSL Bits

extern __at(0x080E) __sfr WDTPSL;

typedef union
  {
  struct
    {
    unsigned PSCNT0             : 1;
    unsigned PSCNT1             : 1;
    unsigned PSCNT2             : 1;
    unsigned PSCNT3             : 1;
    unsigned PSCNT4             : 1;
    unsigned PSCNT5             : 1;
    unsigned PSCNT6             : 1;
    unsigned PSCNT7             : 1;
    };

  struct
    {
    unsigned WDTPSCNT0          : 1;
    unsigned WDTPSCNT1          : 1;
    unsigned WDTPSCNT2          : 1;
    unsigned WDTPSCNT3          : 1;
    unsigned WDTPSCNT4          : 1;
    unsigned WDTPSCNT5          : 1;
    unsigned WDTPSCNT6          : 1;
    unsigned WDTPSCNT7          : 1;
    };
  } __WDTPSLbits_t;

extern __at(0x080E) volatile __WDTPSLbits_t WDTPSLbits;

#define _PSCNT0                 0x01
#define _WDTPSCNT0              0x01
#define _PSCNT1                 0x02
#define _WDTPSCNT1              0x02
#define _PSCNT2                 0x04
#define _WDTPSCNT2              0x04
#define _PSCNT3                 0x08
#define _WDTPSCNT3              0x08
#define _PSCNT4                 0x10
#define _WDTPSCNT4              0x10
#define _PSCNT5                 0x20
#define _WDTPSCNT5              0x20
#define _PSCNT6                 0x40
#define _WDTPSCNT6              0x40
#define _PSCNT7                 0x80
#define _WDTPSCNT7              0x80

//==============================================================================


//==============================================================================
//        WDTPSH Bits

extern __at(0x080F) __sfr WDTPSH;

typedef union
  {
  struct
    {
    unsigned PSCNT8             : 1;
    unsigned PSCNT9             : 1;
    unsigned PSCNT10            : 1;
    unsigned PSCNT11            : 1;
    unsigned PSCNT12            : 1;
    unsigned PSCNT13            : 1;
    unsigned PSCNT14            : 1;
    unsigned PSCNT15            : 1;
    };

  struct
    {
    unsigned WDTPSCNT8          : 1;
    unsigned WDTPSCNT9          : 1;
    unsigned WDTPSCNT10         : 1;
    unsigned WDTPSCNT11         : 1;
    unsigned WDTPSCNT12         : 1;
    unsigned WDTPSCNT13         : 1;
    unsigned WDTPSCNT14         : 1;
    unsigned WDTPSCNT15         : 1;
    };
  } __WDTPSHbits_t;

extern __at(0x080F) volatile __WDTPSHbits_t WDTPSHbits;

#define _PSCNT8                 0x01
#define _WDTPSCNT8              0x01
#define _PSCNT9                 0x02
#define _WDTPSCNT9              0x02
#define _PSCNT10                0x04
#define _WDTPSCNT10             0x04
#define _PSCNT11                0x08
#define _WDTPSCNT11             0x08
#define _PSCNT12                0x10
#define _WDTPSCNT12             0x10
#define _PSCNT13                0x20
#define _WDTPSCNT13             0x20
#define _PSCNT14                0x40
#define _WDTPSCNT14             0x40
#define _PSCNT15                0x80
#define _WDTPSCNT15             0x80

//==============================================================================


//==============================================================================
//        WDTTMR Bits

extern __at(0x0810) __sfr WDTTMR;

typedef union
  {
  struct
    {
    unsigned PSCNT16            : 1;
    unsigned PSCNT17            : 1;
    unsigned STATE              : 1;
    unsigned WDTTMR0            : 1;
    unsigned WDTTMR1            : 1;
    unsigned WDTTMR2            : 1;
    unsigned WDTTMR3            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WDTPSCNT16         : 1;
    unsigned WDTPSCNT17         : 1;
    unsigned WDTSTATE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned WDTTMR             : 4;
    unsigned                    : 1;
    };
  } __WDTTMRbits_t;

extern __at(0x0810) volatile __WDTTMRbits_t WDTTMRbits;

#define _PSCNT16                0x01
#define _WDTPSCNT16             0x01
#define _PSCNT17                0x02
#define _WDTPSCNT17             0x02
#define _STATE                  0x04
#define _WDTSTATE               0x04
#define _WDTTMR0                0x08
#define _WDTTMR1                0x10
#define _WDTTMR2                0x20
#define _WDTTMR3                0x40

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0811) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0811) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        PCON0 Bits

extern __at(0x0813) __sfr PCON0;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned NOT_WDTWV            : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCON0bits_t;

extern __at(0x0813) volatile __PCON0bits_t PCON0bits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _NOT_WDTWV              0x20
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        CCDCON Bits

extern __at(0x0814) __sfr CCDCON;

typedef union
  {
  struct
    {
    unsigned CCDS0              : 1;
    unsigned CCDS1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCDEN              : 1;
    };

  struct
    {
    unsigned CCDS               : 2;
    unsigned                    : 6;
    };
  } __CCDCONbits_t;

extern __at(0x0814) volatile __CCDCONbits_t CCDCONbits;

#define _CCDS0                  0x01
#define _CCDS1                  0x02
#define _CCDEN                  0x80

//==============================================================================


//==============================================================================
//        NVMADRL Bits

extern __at(0x081A) __sfr NVMADRL;

typedef struct
  {
  unsigned NVMADR0              : 1;
  unsigned NVMADR1              : 1;
  unsigned NVMADR2              : 1;
  unsigned NVMADR3              : 1;
  unsigned NVMADR4              : 1;
  unsigned NVMADR5              : 1;
  unsigned NVMADR6              : 1;
  unsigned NVMADR7              : 1;
  } __NVMADRLbits_t;

extern __at(0x081A) volatile __NVMADRLbits_t NVMADRLbits;

#define _NVMADR0                0x01
#define _NVMADR1                0x02
#define _NVMADR2                0x04
#define _NVMADR3                0x08
#define _NVMADR4                0x10
#define _NVMADR5                0x20
#define _NVMADR6                0x40
#define _NVMADR7                0x80

//==============================================================================


//==============================================================================
//        NVMADRH Bits

extern __at(0x081B) __sfr NVMADRH;

typedef struct
  {
  unsigned NVMADR8              : 1;
  unsigned NVMADR9              : 1;
  unsigned NVMADR10             : 1;
  unsigned NVMADR11             : 1;
  unsigned NVMADR12             : 1;
  unsigned NVMADR13             : 1;
  unsigned NVMADR14             : 1;
  unsigned                      : 1;
  } __NVMADRHbits_t;

extern __at(0x081B) volatile __NVMADRHbits_t NVMADRHbits;

#define _NVMADR8                0x01
#define _NVMADR9                0x02
#define _NVMADR10               0x04
#define _NVMADR11               0x08
#define _NVMADR12               0x10
#define _NVMADR13               0x20
#define _NVMADR14               0x40

//==============================================================================


//==============================================================================
//        NVMDATL Bits

extern __at(0x081C) __sfr NVMDATL;

typedef struct
  {
  unsigned NVMDAT0              : 1;
  unsigned NVMDAT1              : 1;
  unsigned NVMDAT2              : 1;
  unsigned NVMDAT3              : 1;
  unsigned NVMDAT4              : 1;
  unsigned NVMDAT5              : 1;
  unsigned NVMDAT6              : 1;
  unsigned NVMDAT7              : 1;
  } __NVMDATLbits_t;

extern __at(0x081C) volatile __NVMDATLbits_t NVMDATLbits;

#define _NVMDAT0                0x01
#define _NVMDAT1                0x02
#define _NVMDAT2                0x04
#define _NVMDAT3                0x08
#define _NVMDAT4                0x10
#define _NVMDAT5                0x20
#define _NVMDAT6                0x40
#define _NVMDAT7                0x80

//==============================================================================


//==============================================================================
//        NVMDATH Bits

extern __at(0x081D) __sfr NVMDATH;

typedef struct
  {
  unsigned NVMDAT8              : 1;
  unsigned NVMDAT9              : 1;
  unsigned NVMDAT10             : 1;
  unsigned NVMDAT11             : 1;
  unsigned NVMDAT12             : 1;
  unsigned NVMDAT13             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __NVMDATHbits_t;

extern __at(0x081D) volatile __NVMDATHbits_t NVMDATHbits;

#define _NVMDAT8                0x01
#define _NVMDAT9                0x02
#define _NVMDAT10               0x04
#define _NVMDAT11               0x08
#define _NVMDAT12               0x10
#define _NVMDAT13               0x20

//==============================================================================


//==============================================================================
//        NVMCON1 Bits

extern __at(0x081E) __sfr NVMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned NVMREGS              : 1;
  unsigned                      : 1;
  } __NVMCON1bits_t;

extern __at(0x081E) volatile __NVMCON1bits_t NVMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _NVMREGS                0x40

//==============================================================================

extern __at(0x081F) __sfr NVMCON2;

//==============================================================================
//        CPUDOZE Bits

extern __at(0x088C) __sfr CPUDOZE;

typedef union
  {
  struct
    {
    unsigned DOZE0              : 1;
    unsigned DOZE1              : 1;
    unsigned DOZE2              : 1;
    unsigned                    : 1;
    unsigned DOE                : 1;
    unsigned ROI                : 1;
    unsigned DOZEN              : 1;
    unsigned IDLEN              : 1;
    };

  struct
    {
    unsigned DOZE               : 3;
    unsigned                    : 5;
    };
  } __CPUDOZEbits_t;

extern __at(0x088C) volatile __CPUDOZEbits_t CPUDOZEbits;

#define _DOZE0                  0x01
#define _DOZE1                  0x02
#define _DOZE2                  0x04
#define _DOE                    0x10
#define _ROI                    0x20
#define _DOZEN                  0x40
#define _IDLEN                  0x80

//==============================================================================


//==============================================================================
//        OSCCON1 Bits

extern __at(0x088D) __sfr OSCCON1;

typedef union
  {
  struct
    {
    unsigned NDIV0              : 1;
    unsigned NDIV1              : 1;
    unsigned NDIV2              : 1;
    unsigned NDIV3              : 1;
    unsigned NOSC0              : 1;
    unsigned NOSC1              : 1;
    unsigned NOSC2              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NDIV               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned NOSC               : 3;
    unsigned                    : 1;
    };
  } __OSCCON1bits_t;

extern __at(0x088D) volatile __OSCCON1bits_t OSCCON1bits;

#define _NDIV0                  0x01
#define _NDIV1                  0x02
#define _NDIV2                  0x04
#define _NDIV3                  0x08
#define _NOSC0                  0x10
#define _NOSC1                  0x20
#define _NOSC2                  0x40

//==============================================================================


//==============================================================================
//        OSCCON2 Bits

extern __at(0x088E) __sfr OSCCON2;

typedef union
  {
  struct
    {
    unsigned CDIV0              : 1;
    unsigned CDIV1              : 1;
    unsigned CDIV2              : 1;
    unsigned CDIV3              : 1;
    unsigned COSC0              : 1;
    unsigned COSC1              : 1;
    unsigned COSC2              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CDIV               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned COSC               : 3;
    unsigned                    : 1;
    };
  } __OSCCON2bits_t;

extern __at(0x088E) volatile __OSCCON2bits_t OSCCON2bits;

#define _CDIV0                  0x01
#define _CDIV1                  0x02
#define _CDIV2                  0x04
#define _CDIV3                  0x08
#define _COSC0                  0x10
#define _COSC1                  0x20
#define _COSC2                  0x40

//==============================================================================


//==============================================================================
//        OSCCON3 Bits

extern __at(0x088F) __sfr OSCCON3;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned NOSCR                : 1;
  unsigned ORDY                 : 1;
  unsigned                      : 1;
  unsigned SOSCPWR              : 1;
  unsigned CSWHOLD              : 1;
  } __OSCCON3bits_t;

extern __at(0x088F) volatile __OSCCON3bits_t OSCCON3bits;

#define _NOSCR                  0x08
#define _ORDY                   0x10
#define _SOSCPWR                0x40
#define _CSWHOLD                0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x0890) __sfr OSCSTAT;

typedef struct
  {
  unsigned PLLR                 : 1;
  unsigned                      : 1;
  unsigned ADOR                 : 1;
  unsigned SOR                  : 1;
  unsigned LFOR                 : 1;
  unsigned MFOR                 : 1;
  unsigned HFOR                 : 1;
  unsigned EXTOR                : 1;
  } __OSCSTATbits_t;

extern __at(0x0890) volatile __OSCSTATbits_t OSCSTATbits;

#define _PLLR                   0x01
#define _ADOR                   0x04
#define _SOR                    0x08
#define _LFOR                   0x10
#define _MFOR                   0x20
#define _HFOR                   0x40
#define _EXTOR                  0x80

//==============================================================================


//==============================================================================
//        OSCEN Bits

extern __at(0x0891) __sfr OSCEN;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADOEN                : 1;
  unsigned SOSCEN               : 1;
  unsigned LFOEN                : 1;
  unsigned MFOEN                : 1;
  unsigned HFOEN                : 1;
  unsigned EXTOEN               : 1;
  } __OSCENbits_t;

extern __at(0x0891) volatile __OSCENbits_t OSCENbits;

#define _ADOEN                  0x04
#define _SOSCEN                 0x08
#define _LFOEN                  0x10
#define _MFOEN                  0x20
#define _HFOEN                  0x40
#define _EXTOEN                 0x80

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0892) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned HFTUN0             : 1;
    unsigned HFTUN1             : 1;
    unsigned HFTUN2             : 1;
    unsigned HFTUN3             : 1;
    unsigned HFTUN4             : 1;
    unsigned HFTUN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned HFTUN              : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0892) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _HFTUN0                 0x01
#define _HFTUN1                 0x02
#define _HFTUN2                 0x04
#define _HFTUN3                 0x08
#define _HFTUN4                 0x10
#define _HFTUN5                 0x20

//==============================================================================


//==============================================================================
//        OSCFRQ Bits

extern __at(0x0893) __sfr OSCFRQ;

typedef union
  {
  struct
    {
    unsigned HFFRQ0             : 1;
    unsigned HFFRQ1             : 1;
    unsigned HFFRQ2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned HFFRQ              : 3;
    unsigned                    : 5;
    };
  } __OSCFRQbits_t;

extern __at(0x0893) volatile __OSCFRQbits_t OSCFRQbits;

#define _HFFRQ0                 0x01
#define _HFFRQ1                 0x02
#define _HFFRQ2                 0x04

//==============================================================================


//==============================================================================
//        CLKRCON Bits

extern __at(0x0895) __sfr CLKRCON;

typedef union
  {
  struct
    {
    unsigned CLKRDIV0           : 1;
    unsigned CLKRDIV1           : 1;
    unsigned CLKRDIV2           : 1;
    unsigned CLKRDC0            : 1;
    unsigned CLKRDC1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CLKREN             : 1;
    };

  struct
    {
    unsigned CLKRDIV            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned CLKRDC             : 2;
    unsigned                    : 3;
    };
  } __CLKRCONbits_t;

extern __at(0x0895) volatile __CLKRCONbits_t CLKRCONbits;

#define _CLKRDIV0               0x01
#define _CLKRDIV1               0x02
#define _CLKRDIV2               0x04
#define _CLKRDC0                0x08
#define _CLKRDC1                0x10
#define _CLKREN                 0x80

//==============================================================================


//==============================================================================
//        CLKRCLK Bits

extern __at(0x0896) __sfr CLKRCLK;

typedef union
  {
  struct
    {
    unsigned CLKRCLK0           : 1;
    unsigned CLKRCLK1           : 1;
    unsigned CLKRCLK2           : 1;
    unsigned CLKRCLK3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CLKRCLK            : 4;
    unsigned                    : 4;
    };
  } __CLKRCLKbits_t;

extern __at(0x0896) volatile __CLKRCLKbits_t CLKRCLKbits;

#define _CLKRCLK0               0x01
#define _CLKRCLK1               0x02
#define _CLKRCLK2               0x04
#define _CLKRCLK3               0x08

//==============================================================================


//==============================================================================
//        MDCON0 Bits

extern __at(0x0897) __sfr MDCON0;

typedef struct
  {
  unsigned MDBIT                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned MDOPOL               : 1;
  unsigned MDOUT                : 1;
  unsigned                      : 1;
  unsigned MDEN                 : 1;
  } __MDCON0bits_t;

extern __at(0x0897) volatile __MDCON0bits_t MDCON0bits;

#define _MDBIT                  0x01
#define _MDOPOL                 0x10
#define _MDOUT                  0x20
#define _MDEN                   0x80

//==============================================================================


//==============================================================================
//        MDCON1 Bits

extern __at(0x0898) __sfr MDCON1;

typedef struct
  {
  unsigned MDCLSYNC             : 1;
  unsigned MDCLPOL              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned MDCHSYNC             : 1;
  unsigned MDCHPOL              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __MDCON1bits_t;

extern __at(0x0898) volatile __MDCON1bits_t MDCON1bits;

#define _MDCLSYNC               0x01
#define _MDCLPOL                0x02
#define _MDCHSYNC               0x10
#define _MDCHPOL                0x20

//==============================================================================


//==============================================================================
//        MDSRC Bits

extern __at(0x0899) __sfr MDSRC;

typedef union
  {
  struct
    {
    unsigned MDMS0              : 1;
    unsigned MDMS1              : 1;
    unsigned MDMS2              : 1;
    unsigned MDMS3              : 1;
    unsigned MDMS4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MDMS               : 5;
    unsigned                    : 3;
    };
  } __MDSRCbits_t;

extern __at(0x0899) volatile __MDSRCbits_t MDSRCbits;

#define _MDMS0                  0x01
#define _MDMS1                  0x02
#define _MDMS2                  0x04
#define _MDMS3                  0x08
#define _MDMS4                  0x10

//==============================================================================


//==============================================================================
//        MDCARL Bits

extern __at(0x089A) __sfr MDCARL;

typedef union
  {
  struct
    {
    unsigned MDCL0              : 1;
    unsigned MDCL1              : 1;
    unsigned MDCL2              : 1;
    unsigned MDCL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MDCL               : 4;
    unsigned                    : 4;
    };
  } __MDCARLbits_t;

extern __at(0x089A) volatile __MDCARLbits_t MDCARLbits;

#define _MDCL0                  0x01
#define _MDCL1                  0x02
#define _MDCL2                  0x04
#define _MDCL3                  0x08

//==============================================================================


//==============================================================================
//        MDCARH Bits

extern __at(0x089B) __sfr MDCARH;

typedef union
  {
  struct
    {
    unsigned MDCH0              : 1;
    unsigned MDCH1              : 1;
    unsigned MDCH2              : 1;
    unsigned MDCH3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MDCH               : 4;
    unsigned                    : 4;
    };
  } __MDCARHbits_t;

extern __at(0x089B) volatile __MDCARHbits_t MDCARHbits;

#define _MDCH0                  0x01
#define _MDCH1                  0x02
#define _MDCH2                  0x04
#define _MDCH3                  0x08

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x090C) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned CDAFVR0            : 1;
    unsigned CDAFVR1            : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CDAFVR             : 2;
    unsigned                    : 4;
    };
  } __FVRCONbits_t;

extern __at(0x090C) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _CDAFVR0                0x04
#define _CDAFVR1                0x08
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        DAC1CON0 Bits

extern __at(0x090E) __sfr DAC1CON0;

typedef union
  {
  struct
    {
    unsigned NSS                : 1;
    unsigned                    : 1;
    unsigned DAC1PSS0           : 1;
    unsigned DAC1PSS1           : 1;
    unsigned OE2                : 1;
    unsigned OE1                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned DAC1NSS            : 1;
    unsigned                    : 1;
    unsigned PSS0               : 1;
    unsigned PSS1               : 1;
    unsigned DAC1OE2            : 1;
    unsigned DAC1OE1            : 1;
    unsigned                    : 1;
    unsigned DAC1EN             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS                : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DAC1PSS            : 2;
    unsigned                    : 4;
    };
  } __DAC1CON0bits_t;

extern __at(0x090E) volatile __DAC1CON0bits_t DAC1CON0bits;

#define _DAC1CON0_NSS           0x01
#define _DAC1CON0_DAC1NSS       0x01
#define _DAC1CON0_DAC1PSS0      0x04
#define _DAC1CON0_PSS0          0x04
#define _DAC1CON0_DAC1PSS1      0x08
#define _DAC1CON0_PSS1          0x08
#define _DAC1CON0_OE2           0x10
#define _DAC1CON0_DAC1OE2       0x10
#define _DAC1CON0_OE1           0x20
#define _DAC1CON0_DAC1OE1       0x20
#define _DAC1CON0_EN            0x80
#define _DAC1CON0_DAC1EN        0x80

//==============================================================================


//==============================================================================
//        DAC1CON1 Bits

extern __at(0x090F) __sfr DAC1CON1;

typedef union
  {
  struct
    {
    unsigned DAC1R0             : 1;
    unsigned DAC1R1             : 1;
    unsigned DAC1R2             : 1;
    unsigned DAC1R3             : 1;
    unsigned DAC1R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC1R              : 5;
    unsigned                    : 3;
    };
  } __DAC1CON1bits_t;

extern __at(0x090F) volatile __DAC1CON1bits_t DAC1CON1bits;

#define _DAC1R0                 0x01
#define _DAC1R1                 0x02
#define _DAC1R2                 0x04
#define _DAC1R3                 0x08
#define _DAC1R4                 0x10

//==============================================================================


//==============================================================================
//        ZCD1CON Bits

extern __at(0x091F) __sfr ZCD1CON;

typedef union
  {
  struct
    {
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned ZCD1INTN           : 1;
    unsigned ZCD1INTP           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ZCD1POL            : 1;
    unsigned ZCD1OUT            : 1;
    unsigned                    : 1;
    unsigned ZCD1EN             : 1;
    };

  struct
    {
    unsigned ZCDINTN            : 1;
    unsigned ZCDINTP            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ZCDPOL             : 1;
    unsigned ZCDOUT             : 1;
    unsigned                    : 1;
    unsigned ZCDEN              : 1;
    };
  } __ZCD1CONbits_t;

extern __at(0x091F) volatile __ZCD1CONbits_t ZCD1CONbits;

#define _ZCD1CON_INTN           0x01
#define _ZCD1CON_ZCD1INTN       0x01
#define _ZCD1CON_ZCDINTN        0x01
#define _ZCD1CON_INTP           0x02
#define _ZCD1CON_ZCD1INTP       0x02
#define _ZCD1CON_ZCDINTP        0x02
#define _ZCD1CON_POL            0x10
#define _ZCD1CON_ZCD1POL        0x10
#define _ZCD1CON_ZCDPOL         0x10
#define _ZCD1CON_OUT            0x20
#define _ZCD1CON_ZCD1OUT        0x20
#define _ZCD1CON_ZCDOUT         0x20
#define _ZCD1CON_EN             0x80
#define _ZCD1CON_ZCD1EN         0x80
#define _ZCD1CON_ZCDEN          0x80

//==============================================================================


//==============================================================================
//        ZCDCON Bits

extern __at(0x091F) __sfr ZCDCON;

typedef union
  {
  struct
    {
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned ZCD1INTN           : 1;
    unsigned ZCD1INTP           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ZCD1POL            : 1;
    unsigned ZCD1OUT            : 1;
    unsigned                    : 1;
    unsigned ZCD1EN             : 1;
    };

  struct
    {
    unsigned ZCDINTN            : 1;
    unsigned ZCDINTP            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ZCDPOL             : 1;
    unsigned ZCDOUT             : 1;
    unsigned                    : 1;
    unsigned ZCDEN              : 1;
    };
  } __ZCDCONbits_t;

extern __at(0x091F) volatile __ZCDCONbits_t ZCDCONbits;

#define _ZCDCON_INTN            0x01
#define _ZCDCON_ZCD1INTN        0x01
#define _ZCDCON_ZCDINTN         0x01
#define _ZCDCON_INTP            0x02
#define _ZCDCON_ZCD1INTP        0x02
#define _ZCDCON_ZCDINTP         0x02
#define _ZCDCON_POL             0x10
#define _ZCDCON_ZCD1POL         0x10
#define _ZCDCON_ZCDPOL          0x10
#define _ZCDCON_OUT             0x20
#define _ZCDCON_ZCD1OUT         0x20
#define _ZCDCON_ZCDOUT          0x20
#define _ZCDCON_EN              0x80
#define _ZCDCON_ZCD1EN          0x80
#define _ZCDCON_ZCDEN           0x80

//==============================================================================


//==============================================================================
//        CMOUT Bits

extern __at(0x098F) __sfr CMOUT;

typedef union
  {
  struct
    {
    unsigned MC1OUT             : 1;
    unsigned MC2OUT             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1OUT              : 1;
    unsigned C2OUT              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CMOUTbits_t;

extern __at(0x098F) volatile __CMOUTbits_t CMOUTbits;

#define _CMOUT_MC1OUT           0x01
#define _CMOUT_C1OUT            0x01
#define _CMOUT_MC2OUT           0x02
#define _CMOUT_C2OUT            0x02

//==============================================================================


//==============================================================================
//        CMSTAT Bits

extern __at(0x098F) __sfr CMSTAT;

typedef union
  {
  struct
    {
    unsigned MC1OUT             : 1;
    unsigned MC2OUT             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1OUT              : 1;
    unsigned C2OUT              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CMSTATbits_t;

extern __at(0x098F) volatile __CMSTATbits_t CMSTATbits;

#define _CMSTAT_MC1OUT          0x01
#define _CMSTAT_C1OUT           0x01
#define _CMSTAT_MC2OUT          0x02
#define _CMSTAT_C2OUT           0x02

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0990) __sfr CM1CON0;

typedef union
  {
  struct
    {
    unsigned SYNC               : 1;
    unsigned HYS                : 1;
    unsigned Reserved           : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    unsigned                    : 1;
    unsigned OUT                : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned C1SYNC             : 1;
    unsigned C1HYS              : 1;
    unsigned C1SP               : 1;
    unsigned                    : 1;
    unsigned C1POL              : 1;
    unsigned                    : 1;
    unsigned C1OUT              : 1;
    unsigned C1ON               : 1;
    };
  } __CM1CON0bits_t;

extern __at(0x0990) volatile __CM1CON0bits_t CM1CON0bits;

#define _CM1CON0_SYNC           0x01
#define _CM1CON0_C1SYNC         0x01
#define _CM1CON0_HYS            0x02
#define _CM1CON0_C1HYS          0x02
#define _CM1CON0_Reserved       0x04
#define _CM1CON0_C1SP           0x04
#define _CM1CON0_POL            0x10
#define _CM1CON0_C1POL          0x10
#define _CM1CON0_OUT            0x40
#define _CM1CON0_C1OUT          0x40
#define _CM1CON0_ON             0x80
#define _CM1CON0_C1ON           0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0991) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1INTN             : 1;
    unsigned C1INTP             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CM1CON1bits_t;

extern __at(0x0991) volatile __CM1CON1bits_t CM1CON1bits;

#define _CM1CON1_INTN           0x01
#define _CM1CON1_C1INTN         0x01
#define _CM1CON1_INTP           0x02
#define _CM1CON1_C1INTP         0x02

//==============================================================================


//==============================================================================
//        CM1NSEL Bits

extern __at(0x0992) __sfr CM1NSEL;

typedef union
  {
  struct
    {
    unsigned NCH0               : 1;
    unsigned NCH1               : 1;
    unsigned NCH2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1NCH0             : 1;
    unsigned C1NCH1             : 1;
    unsigned C1NCH2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NCH                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned C1NCH              : 3;
    unsigned                    : 5;
    };
  } __CM1NSELbits_t;

extern __at(0x0992) volatile __CM1NSELbits_t CM1NSELbits;

#define _NCH0                   0x01
#define _C1NCH0                 0x01
#define _NCH1                   0x02
#define _C1NCH1                 0x02
#define _NCH2                   0x04
#define _C1NCH2                 0x04

//==============================================================================


//==============================================================================
//        CM1PSEL Bits

extern __at(0x0993) __sfr CM1PSEL;

typedef union
  {
  struct
    {
    unsigned PCH0               : 1;
    unsigned PCH1               : 1;
    unsigned PCH2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1PCH0             : 1;
    unsigned C1PCH1             : 1;
    unsigned C1PCH2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PCH                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned C1PCH              : 3;
    unsigned                    : 5;
    };
  } __CM1PSELbits_t;

extern __at(0x0993) volatile __CM1PSELbits_t CM1PSELbits;

#define _PCH0                   0x01
#define _C1PCH0                 0x01
#define _PCH1                   0x02
#define _C1PCH1                 0x02
#define _PCH2                   0x04
#define _C1PCH2                 0x04

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0994) __sfr CM2CON0;

typedef union
  {
  struct
    {
    unsigned SYNC               : 1;
    unsigned HYS                : 1;
    unsigned Reserved           : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    unsigned                    : 1;
    unsigned OUT                : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned C2SYNC             : 1;
    unsigned C2HYS              : 1;
    unsigned C2SP               : 1;
    unsigned                    : 1;
    unsigned C2POL              : 1;
    unsigned                    : 1;
    unsigned C2OUT              : 1;
    unsigned C2ON               : 1;
    };
  } __CM2CON0bits_t;

extern __at(0x0994) volatile __CM2CON0bits_t CM2CON0bits;

#define _CM2CON0_SYNC           0x01
#define _CM2CON0_C2SYNC         0x01
#define _CM2CON0_HYS            0x02
#define _CM2CON0_C2HYS          0x02
#define _CM2CON0_Reserved       0x04
#define _CM2CON0_C2SP           0x04
#define _CM2CON0_POL            0x10
#define _CM2CON0_C2POL          0x10
#define _CM2CON0_OUT            0x40
#define _CM2CON0_C2OUT          0x40
#define _CM2CON0_ON             0x80
#define _CM2CON0_C2ON           0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0995) __sfr CM2CON1;

typedef union
  {
  struct
    {
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C2INTN             : 1;
    unsigned C2INTP             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CM2CON1bits_t;

extern __at(0x0995) volatile __CM2CON1bits_t CM2CON1bits;

#define _CM2CON1_INTN           0x01
#define _CM2CON1_C2INTN         0x01
#define _CM2CON1_INTP           0x02
#define _CM2CON1_C2INTP         0x02

//==============================================================================


//==============================================================================
//        CM2NSEL Bits

extern __at(0x0996) __sfr CM2NSEL;

typedef union
  {
  struct
    {
    unsigned NCH0               : 1;
    unsigned NCH1               : 1;
    unsigned NCH2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C2NCH0             : 1;
    unsigned C2NCH1             : 1;
    unsigned C2NCH2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NCH                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned C2NCH              : 3;
    unsigned                    : 5;
    };
  } __CM2NSELbits_t;

extern __at(0x0996) volatile __CM2NSELbits_t CM2NSELbits;

#define _CM2NSEL_NCH0           0x01
#define _CM2NSEL_C2NCH0         0x01
#define _CM2NSEL_NCH1           0x02
#define _CM2NSEL_C2NCH1         0x02
#define _CM2NSEL_NCH2           0x04
#define _CM2NSEL_C2NCH2         0x04

//==============================================================================


//==============================================================================
//        CM2PSEL Bits

extern __at(0x0997) __sfr CM2PSEL;

typedef union
  {
  struct
    {
    unsigned PCH0               : 1;
    unsigned PCH1               : 1;
    unsigned PCH2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C2PCH0             : 1;
    unsigned C2PCH1             : 1;
    unsigned C2PCH2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PCH                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned C2PCH              : 3;
    unsigned                    : 5;
    };
  } __CM2PSELbits_t;

extern __at(0x0997) volatile __CM2PSELbits_t CM2PSELbits;

#define _CM2PSEL_PCH0           0x01
#define _CM2PSEL_C2PCH0         0x01
#define _CM2PSEL_PCH1           0x02
#define _CM2PSEL_C2PCH1         0x02
#define _CM2PSEL_PCH2           0x04
#define _CM2PSEL_C2PCH2         0x04

//==============================================================================


//==============================================================================
//        CLCDATA Bits

extern __at(0x0E0F) __sfr CLCDATA;

typedef struct
  {
  unsigned MLC1OUT              : 1;
  unsigned MLC2OUT              : 1;
  unsigned MLC3OUT              : 1;
  unsigned MLC4OUT              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CLCDATAbits_t;

extern __at(0x0E0F) volatile __CLCDATAbits_t CLCDATAbits;

#define _MLC1OUT                0x01
#define _MLC2OUT                0x02
#define _MLC3OUT                0x04
#define _MLC4OUT                0x08

//==============================================================================


//==============================================================================
//        CLC1CON Bits

extern __at(0x0E10) __sfr CLC1CON;

typedef union
  {
  struct
    {
    unsigned LC1MODE0           : 1;
    unsigned LC1MODE1           : 1;
    unsigned LC1MODE2           : 1;
    unsigned LC1INTN            : 1;
    unsigned LC1INTP            : 1;
    unsigned LC1OUT             : 1;
    unsigned                    : 1;
    unsigned LC1EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned LC1MODE            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CLC1CONbits_t;

extern __at(0x0E10) volatile __CLC1CONbits_t CLC1CONbits;

#define _CLC1CON_LC1MODE0       0x01
#define _CLC1CON_MODE0          0x01
#define _CLC1CON_LC1MODE1       0x02
#define _CLC1CON_MODE1          0x02
#define _CLC1CON_LC1MODE2       0x04
#define _CLC1CON_MODE2          0x04
#define _CLC1CON_LC1INTN        0x08
#define _CLC1CON_INTN           0x08
#define _CLC1CON_LC1INTP        0x10
#define _CLC1CON_INTP           0x10
#define _CLC1CON_LC1OUT         0x20
#define _CLC1CON_OUT            0x20
#define _CLC1CON_LC1EN          0x80
#define _CLC1CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC1POL Bits

extern __at(0x0E11) __sfr CLC1POL;

typedef union
  {
  struct
    {
    unsigned LC1G1POL           : 1;
    unsigned LC1G2POL           : 1;
    unsigned LC1G3POL           : 1;
    unsigned LC1G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC1POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC1POLbits_t;

extern __at(0x0E11) volatile __CLC1POLbits_t CLC1POLbits;

#define _LC1G1POL               0x01
#define _G1POL                  0x01
#define _LC1G2POL               0x02
#define _G2POL                  0x02
#define _LC1G3POL               0x04
#define _G3POL                  0x04
#define _LC1G4POL               0x08
#define _G4POL                  0x08
#define _LC1POL                 0x80
#define _POL                    0x80

//==============================================================================


//==============================================================================
//        CLC1SEL0 Bits

extern __at(0x0E12) __sfr CLC1SEL0;

typedef union
  {
  struct
    {
    unsigned LC1D1S0            : 1;
    unsigned LC1D1S1            : 1;
    unsigned LC1D1S2            : 1;
    unsigned LC1D1S3            : 1;
    unsigned LC1D1S4            : 1;
    unsigned LC1D1S5            : 1;
    unsigned LC1D1S6            : 1;
    unsigned LC1D1S7            : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned D1S6               : 1;
    unsigned D1S7               : 1;
    };
  } __CLC1SEL0bits_t;

extern __at(0x0E12) volatile __CLC1SEL0bits_t CLC1SEL0bits;

#define _LC1D1S0                0x01
#define _D1S0                   0x01
#define _LC1D1S1                0x02
#define _D1S1                   0x02
#define _LC1D1S2                0x04
#define _D1S2                   0x04
#define _LC1D1S3                0x08
#define _D1S3                   0x08
#define _LC1D1S4                0x10
#define _D1S4                   0x10
#define _LC1D1S5                0x20
#define _D1S5                   0x20
#define _LC1D1S6                0x40
#define _D1S6                   0x40
#define _LC1D1S7                0x80
#define _D1S7                   0x80

//==============================================================================


//==============================================================================
//        CLC1SEL1 Bits

extern __at(0x0E13) __sfr CLC1SEL1;

typedef union
  {
  struct
    {
    unsigned LC1D2S0            : 1;
    unsigned LC1D2S1            : 1;
    unsigned LC1D2S2            : 1;
    unsigned LC1D2S3            : 1;
    unsigned LC1D2S4            : 1;
    unsigned LC1D2S5            : 1;
    unsigned LC1D2S6            : 1;
    unsigned LC1D2S7            : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned D2S6               : 1;
    unsigned D2S7               : 1;
    };
  } __CLC1SEL1bits_t;

extern __at(0x0E13) volatile __CLC1SEL1bits_t CLC1SEL1bits;

#define _LC1D2S0                0x01
#define _D2S0                   0x01
#define _LC1D2S1                0x02
#define _D2S1                   0x02
#define _LC1D2S2                0x04
#define _D2S2                   0x04
#define _LC1D2S3                0x08
#define _D2S3                   0x08
#define _LC1D2S4                0x10
#define _D2S4                   0x10
#define _LC1D2S5                0x20
#define _D2S5                   0x20
#define _LC1D2S6                0x40
#define _D2S6                   0x40
#define _LC1D2S7                0x80
#define _D2S7                   0x80

//==============================================================================


//==============================================================================
//        CLC1SEL2 Bits

extern __at(0x0E14) __sfr CLC1SEL2;

typedef union
  {
  struct
    {
    unsigned LC1D3S0            : 1;
    unsigned LC1D3S1            : 1;
    unsigned LC1D3S2            : 1;
    unsigned LC1D3S3            : 1;
    unsigned LC1D3S4            : 1;
    unsigned LC1D3S5            : 1;
    unsigned LC1D3S6            : 1;
    unsigned LC1D3S7            : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned D3S6               : 1;
    unsigned D3S7               : 1;
    };
  } __CLC1SEL2bits_t;

extern __at(0x0E14) volatile __CLC1SEL2bits_t CLC1SEL2bits;

#define _LC1D3S0                0x01
#define _D3S0                   0x01
#define _LC1D3S1                0x02
#define _D3S1                   0x02
#define _LC1D3S2                0x04
#define _D3S2                   0x04
#define _LC1D3S3                0x08
#define _D3S3                   0x08
#define _LC1D3S4                0x10
#define _D3S4                   0x10
#define _LC1D3S5                0x20
#define _D3S5                   0x20
#define _LC1D3S6                0x40
#define _D3S6                   0x40
#define _LC1D3S7                0x80
#define _D3S7                   0x80

//==============================================================================


//==============================================================================
//        CLC1SEL3 Bits

extern __at(0x0E15) __sfr CLC1SEL3;

typedef union
  {
  struct
    {
    unsigned LC1D4S0            : 1;
    unsigned LC1D4S1            : 1;
    unsigned LC1D4S2            : 1;
    unsigned LC1D4S3            : 1;
    unsigned LC1D4S4            : 1;
    unsigned LC1D4S5            : 1;
    unsigned LC1D4S6            : 1;
    unsigned LC1D4S7            : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned D4S6               : 1;
    unsigned D4S7               : 1;
    };
  } __CLC1SEL3bits_t;

extern __at(0x0E15) volatile __CLC1SEL3bits_t CLC1SEL3bits;

#define _LC1D4S0                0x01
#define _D4S0                   0x01
#define _LC1D4S1                0x02
#define _D4S1                   0x02
#define _LC1D4S2                0x04
#define _D4S2                   0x04
#define _LC1D4S3                0x08
#define _D4S3                   0x08
#define _LC1D4S4                0x10
#define _D4S4                   0x10
#define _LC1D4S5                0x20
#define _D4S5                   0x20
#define _LC1D4S6                0x40
#define _D4S6                   0x40
#define _LC1D4S7                0x80
#define _D4S7                   0x80

//==============================================================================


//==============================================================================
//        CLC1GLS0 Bits

extern __at(0x0E16) __sfr CLC1GLS0;

typedef union
  {
  struct
    {
    unsigned LC1G1D1N           : 1;
    unsigned LC1G1D1T           : 1;
    unsigned LC1G1D2N           : 1;
    unsigned LC1G1D2T           : 1;
    unsigned LC1G1D3N           : 1;
    unsigned LC1G1D3T           : 1;
    unsigned LC1G1D4N           : 1;
    unsigned LC1G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS0bits_t;

extern __at(0x0E16) volatile __CLC1GLS0bits_t CLC1GLS0bits;

#define _LC1G1D1N               0x01
#define _D1N                    0x01
#define _LC1G1D1T               0x02
#define _D1T                    0x02
#define _LC1G1D2N               0x04
#define _D2N                    0x04
#define _LC1G1D2T               0x08
#define _D2T                    0x08
#define _LC1G1D3N               0x10
#define _D3N                    0x10
#define _LC1G1D3T               0x20
#define _D3T                    0x20
#define _LC1G1D4N               0x40
#define _D4N                    0x40
#define _LC1G1D4T               0x80
#define _D4T                    0x80

//==============================================================================


//==============================================================================
//        CLC1GLS1 Bits

extern __at(0x0E17) __sfr CLC1GLS1;

typedef union
  {
  struct
    {
    unsigned LC1G2D1N           : 1;
    unsigned LC1G2D1T           : 1;
    unsigned LC1G2D2N           : 1;
    unsigned LC1G2D2T           : 1;
    unsigned LC1G2D3N           : 1;
    unsigned LC1G2D3T           : 1;
    unsigned LC1G2D4N           : 1;
    unsigned LC1G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS1bits_t;

extern __at(0x0E17) volatile __CLC1GLS1bits_t CLC1GLS1bits;

#define _CLC1GLS1_LC1G2D1N      0x01
#define _CLC1GLS1_D1N           0x01
#define _CLC1GLS1_LC1G2D1T      0x02
#define _CLC1GLS1_D1T           0x02
#define _CLC1GLS1_LC1G2D2N      0x04
#define _CLC1GLS1_D2N           0x04
#define _CLC1GLS1_LC1G2D2T      0x08
#define _CLC1GLS1_D2T           0x08
#define _CLC1GLS1_LC1G2D3N      0x10
#define _CLC1GLS1_D3N           0x10
#define _CLC1GLS1_LC1G2D3T      0x20
#define _CLC1GLS1_D3T           0x20
#define _CLC1GLS1_LC1G2D4N      0x40
#define _CLC1GLS1_D4N           0x40
#define _CLC1GLS1_LC1G2D4T      0x80
#define _CLC1GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS2 Bits

extern __at(0x0E18) __sfr CLC1GLS2;

typedef union
  {
  struct
    {
    unsigned LC1G3D1N           : 1;
    unsigned LC1G3D1T           : 1;
    unsigned LC1G3D2N           : 1;
    unsigned LC1G3D2T           : 1;
    unsigned LC1G3D3N           : 1;
    unsigned LC1G3D3T           : 1;
    unsigned LC1G3D4N           : 1;
    unsigned LC1G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS2bits_t;

extern __at(0x0E18) volatile __CLC1GLS2bits_t CLC1GLS2bits;

#define _CLC1GLS2_LC1G3D1N      0x01
#define _CLC1GLS2_D1N           0x01
#define _CLC1GLS2_LC1G3D1T      0x02
#define _CLC1GLS2_D1T           0x02
#define _CLC1GLS2_LC1G3D2N      0x04
#define _CLC1GLS2_D2N           0x04
#define _CLC1GLS2_LC1G3D2T      0x08
#define _CLC1GLS2_D2T           0x08
#define _CLC1GLS2_LC1G3D3N      0x10
#define _CLC1GLS2_D3N           0x10
#define _CLC1GLS2_LC1G3D3T      0x20
#define _CLC1GLS2_D3T           0x20
#define _CLC1GLS2_LC1G3D4N      0x40
#define _CLC1GLS2_D4N           0x40
#define _CLC1GLS2_LC1G3D4T      0x80
#define _CLC1GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS3 Bits

extern __at(0x0E19) __sfr CLC1GLS3;

typedef union
  {
  struct
    {
    unsigned LC1G4D1N           : 1;
    unsigned LC1G4D1T           : 1;
    unsigned LC1G4D2N           : 1;
    unsigned LC1G4D2T           : 1;
    unsigned LC1G4D3N           : 1;
    unsigned LC1G4D3T           : 1;
    unsigned LC1G4D4N           : 1;
    unsigned LC1G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC1GLS3bits_t;

extern __at(0x0E19) volatile __CLC1GLS3bits_t CLC1GLS3bits;

#define _LC1G4D1N               0x01
#define _G4D1N                  0x01
#define _LC1G4D1T               0x02
#define _G4D1T                  0x02
#define _LC1G4D2N               0x04
#define _G4D2N                  0x04
#define _LC1G4D2T               0x08
#define _G4D2T                  0x08
#define _LC1G4D3N               0x10
#define _G4D3N                  0x10
#define _LC1G4D3T               0x20
#define _G4D3T                  0x20
#define _LC1G4D4N               0x40
#define _G4D4N                  0x40
#define _LC1G4D4T               0x80
#define _G4D4T                  0x80

//==============================================================================


//==============================================================================
//        CLC2CON Bits

extern __at(0x0E1A) __sfr CLC2CON;

typedef union
  {
  struct
    {
    unsigned LC2MODE0           : 1;
    unsigned LC2MODE1           : 1;
    unsigned LC2MODE2           : 1;
    unsigned LC2INTN            : 1;
    unsigned LC2INTP            : 1;
    unsigned LC2OUT             : 1;
    unsigned                    : 1;
    unsigned LC2EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC2MODE            : 3;
    unsigned                    : 5;
    };
  } __CLC2CONbits_t;

extern __at(0x0E1A) volatile __CLC2CONbits_t CLC2CONbits;

#define _CLC2CON_LC2MODE0       0x01
#define _CLC2CON_MODE0          0x01
#define _CLC2CON_LC2MODE1       0x02
#define _CLC2CON_MODE1          0x02
#define _CLC2CON_LC2MODE2       0x04
#define _CLC2CON_MODE2          0x04
#define _CLC2CON_LC2INTN        0x08
#define _CLC2CON_INTN           0x08
#define _CLC2CON_LC2INTP        0x10
#define _CLC2CON_INTP           0x10
#define _CLC2CON_LC2OUT         0x20
#define _CLC2CON_OUT            0x20
#define _CLC2CON_LC2EN          0x80
#define _CLC2CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC2POL Bits

extern __at(0x0E1B) __sfr CLC2POL;

typedef union
  {
  struct
    {
    unsigned LC2G1POL           : 1;
    unsigned LC2G2POL           : 1;
    unsigned LC2G3POL           : 1;
    unsigned LC2G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC2POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC2POLbits_t;

extern __at(0x0E1B) volatile __CLC2POLbits_t CLC2POLbits;

#define _CLC2POL_LC2G1POL       0x01
#define _CLC2POL_G1POL          0x01
#define _CLC2POL_LC2G2POL       0x02
#define _CLC2POL_G2POL          0x02
#define _CLC2POL_LC2G3POL       0x04
#define _CLC2POL_G3POL          0x04
#define _CLC2POL_LC2G4POL       0x08
#define _CLC2POL_G4POL          0x08
#define _CLC2POL_LC2POL         0x80
#define _CLC2POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC2SEL0 Bits

extern __at(0x0E1C) __sfr CLC2SEL0;

typedef union
  {
  struct
    {
    unsigned LC2D1S0            : 1;
    unsigned LC2D1S1            : 1;
    unsigned LC2D1S2            : 1;
    unsigned LC2D1S3            : 1;
    unsigned LC2D1S4            : 1;
    unsigned LC2D1S5            : 1;
    unsigned LC2D1S6            : 1;
    unsigned LC2D1S7            : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned D1S6               : 1;
    unsigned D1S7               : 1;
    };
  } __CLC2SEL0bits_t;

extern __at(0x0E1C) volatile __CLC2SEL0bits_t CLC2SEL0bits;

#define _CLC2SEL0_LC2D1S0       0x01
#define _CLC2SEL0_D1S0          0x01
#define _CLC2SEL0_LC2D1S1       0x02
#define _CLC2SEL0_D1S1          0x02
#define _CLC2SEL0_LC2D1S2       0x04
#define _CLC2SEL0_D1S2          0x04
#define _CLC2SEL0_LC2D1S3       0x08
#define _CLC2SEL0_D1S3          0x08
#define _CLC2SEL0_LC2D1S4       0x10
#define _CLC2SEL0_D1S4          0x10
#define _CLC2SEL0_LC2D1S5       0x20
#define _CLC2SEL0_D1S5          0x20
#define _CLC2SEL0_LC2D1S6       0x40
#define _CLC2SEL0_D1S6          0x40
#define _CLC2SEL0_LC2D1S7       0x80
#define _CLC2SEL0_D1S7          0x80

//==============================================================================


//==============================================================================
//        CLC2SEL1 Bits

extern __at(0x0E1D) __sfr CLC2SEL1;

typedef union
  {
  struct
    {
    unsigned LC2D2S0            : 1;
    unsigned LC2D2S1            : 1;
    unsigned LC2D2S2            : 1;
    unsigned LC2D2S3            : 1;
    unsigned LC2D2S4            : 1;
    unsigned LC2D2S5            : 1;
    unsigned LC2D2S6            : 1;
    unsigned LC2D2S7            : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned D2S6               : 1;
    unsigned D2S7               : 1;
    };
  } __CLC2SEL1bits_t;

extern __at(0x0E1D) volatile __CLC2SEL1bits_t CLC2SEL1bits;

#define _CLC2SEL1_LC2D2S0       0x01
#define _CLC2SEL1_D2S0          0x01
#define _CLC2SEL1_LC2D2S1       0x02
#define _CLC2SEL1_D2S1          0x02
#define _CLC2SEL1_LC2D2S2       0x04
#define _CLC2SEL1_D2S2          0x04
#define _CLC2SEL1_LC2D2S3       0x08
#define _CLC2SEL1_D2S3          0x08
#define _CLC2SEL1_LC2D2S4       0x10
#define _CLC2SEL1_D2S4          0x10
#define _CLC2SEL1_LC2D2S5       0x20
#define _CLC2SEL1_D2S5          0x20
#define _CLC2SEL1_LC2D2S6       0x40
#define _CLC2SEL1_D2S6          0x40
#define _CLC2SEL1_LC2D2S7       0x80
#define _CLC2SEL1_D2S7          0x80

//==============================================================================


//==============================================================================
//        CLC2SEL2 Bits

extern __at(0x0E1E) __sfr CLC2SEL2;

typedef union
  {
  struct
    {
    unsigned LC2D3S0            : 1;
    unsigned LC2D3S1            : 1;
    unsigned LC2D3S2            : 1;
    unsigned LC2D3S3            : 1;
    unsigned LC2D3S4            : 1;
    unsigned LC2D3S5            : 1;
    unsigned LC2D3S6            : 1;
    unsigned LC2D3S7            : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned D3S6               : 1;
    unsigned D3S7               : 1;
    };
  } __CLC2SEL2bits_t;

extern __at(0x0E1E) volatile __CLC2SEL2bits_t CLC2SEL2bits;

#define _CLC2SEL2_LC2D3S0       0x01
#define _CLC2SEL2_D3S0          0x01
#define _CLC2SEL2_LC2D3S1       0x02
#define _CLC2SEL2_D3S1          0x02
#define _CLC2SEL2_LC2D3S2       0x04
#define _CLC2SEL2_D3S2          0x04
#define _CLC2SEL2_LC2D3S3       0x08
#define _CLC2SEL2_D3S3          0x08
#define _CLC2SEL2_LC2D3S4       0x10
#define _CLC2SEL2_D3S4          0x10
#define _CLC2SEL2_LC2D3S5       0x20
#define _CLC2SEL2_D3S5          0x20
#define _CLC2SEL2_LC2D3S6       0x40
#define _CLC2SEL2_D3S6          0x40
#define _CLC2SEL2_LC2D3S7       0x80
#define _CLC2SEL2_D3S7          0x80

//==============================================================================


//==============================================================================
//        CLC2SEL3 Bits

extern __at(0x0E1F) __sfr CLC2SEL3;

typedef union
  {
  struct
    {
    unsigned LC2D4S0            : 1;
    unsigned LC2D4S1            : 1;
    unsigned LC2D4S2            : 1;
    unsigned LC2D4S3            : 1;
    unsigned LC2D4S4            : 1;
    unsigned LC2D4S5            : 1;
    unsigned LC2D4S6            : 1;
    unsigned LC2D4S7            : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned D4S6               : 1;
    unsigned D4S7               : 1;
    };
  } __CLC2SEL3bits_t;

extern __at(0x0E1F) volatile __CLC2SEL3bits_t CLC2SEL3bits;

#define _CLC2SEL3_LC2D4S0       0x01
#define _CLC2SEL3_D4S0          0x01
#define _CLC2SEL3_LC2D4S1       0x02
#define _CLC2SEL3_D4S1          0x02
#define _CLC2SEL3_LC2D4S2       0x04
#define _CLC2SEL3_D4S2          0x04
#define _CLC2SEL3_LC2D4S3       0x08
#define _CLC2SEL3_D4S3          0x08
#define _CLC2SEL3_LC2D4S4       0x10
#define _CLC2SEL3_D4S4          0x10
#define _CLC2SEL3_LC2D4S5       0x20
#define _CLC2SEL3_D4S5          0x20
#define _CLC2SEL3_LC2D4S6       0x40
#define _CLC2SEL3_D4S6          0x40
#define _CLC2SEL3_LC2D4S7       0x80
#define _CLC2SEL3_D4S7          0x80

//==============================================================================


//==============================================================================
//        CLC2GLS0 Bits

extern __at(0x0E20) __sfr CLC2GLS0;

typedef union
  {
  struct
    {
    unsigned LC2G1D1N           : 1;
    unsigned LC2G1D1T           : 1;
    unsigned LC2G1D2N           : 1;
    unsigned LC2G1D2T           : 1;
    unsigned LC2G1D3N           : 1;
    unsigned LC2G1D3T           : 1;
    unsigned LC2G1D4N           : 1;
    unsigned LC2G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS0bits_t;

extern __at(0x0E20) volatile __CLC2GLS0bits_t CLC2GLS0bits;

#define _CLC2GLS0_LC2G1D1N      0x01
#define _CLC2GLS0_D1N           0x01
#define _CLC2GLS0_LC2G1D1T      0x02
#define _CLC2GLS0_D1T           0x02
#define _CLC2GLS0_LC2G1D2N      0x04
#define _CLC2GLS0_D2N           0x04
#define _CLC2GLS0_LC2G1D2T      0x08
#define _CLC2GLS0_D2T           0x08
#define _CLC2GLS0_LC2G1D3N      0x10
#define _CLC2GLS0_D3N           0x10
#define _CLC2GLS0_LC2G1D3T      0x20
#define _CLC2GLS0_D3T           0x20
#define _CLC2GLS0_LC2G1D4N      0x40
#define _CLC2GLS0_D4N           0x40
#define _CLC2GLS0_LC2G1D4T      0x80
#define _CLC2GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS1 Bits

extern __at(0x0E21) __sfr CLC2GLS1;

typedef union
  {
  struct
    {
    unsigned LC2G2D1N           : 1;
    unsigned LC2G2D1T           : 1;
    unsigned LC2G2D2N           : 1;
    unsigned LC2G2D2T           : 1;
    unsigned LC2G2D3N           : 1;
    unsigned LC2G2D3T           : 1;
    unsigned LC2G2D4N           : 1;
    unsigned LC2G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS1bits_t;

extern __at(0x0E21) volatile __CLC2GLS1bits_t CLC2GLS1bits;

#define _CLC2GLS1_LC2G2D1N      0x01
#define _CLC2GLS1_D1N           0x01
#define _CLC2GLS1_LC2G2D1T      0x02
#define _CLC2GLS1_D1T           0x02
#define _CLC2GLS1_LC2G2D2N      0x04
#define _CLC2GLS1_D2N           0x04
#define _CLC2GLS1_LC2G2D2T      0x08
#define _CLC2GLS1_D2T           0x08
#define _CLC2GLS1_LC2G2D3N      0x10
#define _CLC2GLS1_D3N           0x10
#define _CLC2GLS1_LC2G2D3T      0x20
#define _CLC2GLS1_D3T           0x20
#define _CLC2GLS1_LC2G2D4N      0x40
#define _CLC2GLS1_D4N           0x40
#define _CLC2GLS1_LC2G2D4T      0x80
#define _CLC2GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS2 Bits

extern __at(0x0E22) __sfr CLC2GLS2;

typedef union
  {
  struct
    {
    unsigned LC2G3D1N           : 1;
    unsigned LC2G3D1T           : 1;
    unsigned LC2G3D2N           : 1;
    unsigned LC2G3D2T           : 1;
    unsigned LC2G3D3N           : 1;
    unsigned LC2G3D3T           : 1;
    unsigned LC2G3D4N           : 1;
    unsigned LC2G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS2bits_t;

extern __at(0x0E22) volatile __CLC2GLS2bits_t CLC2GLS2bits;

#define _CLC2GLS2_LC2G3D1N      0x01
#define _CLC2GLS2_D1N           0x01
#define _CLC2GLS2_LC2G3D1T      0x02
#define _CLC2GLS2_D1T           0x02
#define _CLC2GLS2_LC2G3D2N      0x04
#define _CLC2GLS2_D2N           0x04
#define _CLC2GLS2_LC2G3D2T      0x08
#define _CLC2GLS2_D2T           0x08
#define _CLC2GLS2_LC2G3D3N      0x10
#define _CLC2GLS2_D3N           0x10
#define _CLC2GLS2_LC2G3D3T      0x20
#define _CLC2GLS2_D3T           0x20
#define _CLC2GLS2_LC2G3D4N      0x40
#define _CLC2GLS2_D4N           0x40
#define _CLC2GLS2_LC2G3D4T      0x80
#define _CLC2GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS3 Bits

extern __at(0x0E23) __sfr CLC2GLS3;

typedef union
  {
  struct
    {
    unsigned LC2G4D1N           : 1;
    unsigned LC2G4D1T           : 1;
    unsigned LC2G4D2N           : 1;
    unsigned LC2G4D2T           : 1;
    unsigned LC2G4D3N           : 1;
    unsigned LC2G4D3T           : 1;
    unsigned LC2G4D4N           : 1;
    unsigned LC2G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC2GLS3bits_t;

extern __at(0x0E23) volatile __CLC2GLS3bits_t CLC2GLS3bits;

#define _CLC2GLS3_LC2G4D1N      0x01
#define _CLC2GLS3_G4D1N         0x01
#define _CLC2GLS3_LC2G4D1T      0x02
#define _CLC2GLS3_G4D1T         0x02
#define _CLC2GLS3_LC2G4D2N      0x04
#define _CLC2GLS3_G4D2N         0x04
#define _CLC2GLS3_LC2G4D2T      0x08
#define _CLC2GLS3_G4D2T         0x08
#define _CLC2GLS3_LC2G4D3N      0x10
#define _CLC2GLS3_G4D3N         0x10
#define _CLC2GLS3_LC2G4D3T      0x20
#define _CLC2GLS3_G4D3T         0x20
#define _CLC2GLS3_LC2G4D4N      0x40
#define _CLC2GLS3_G4D4N         0x40
#define _CLC2GLS3_LC2G4D4T      0x80
#define _CLC2GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        CLC3CON Bits

extern __at(0x0E24) __sfr CLC3CON;

typedef union
  {
  struct
    {
    unsigned LC3MODE0           : 1;
    unsigned LC3MODE1           : 1;
    unsigned LC3MODE2           : 1;
    unsigned LC3INTN            : 1;
    unsigned LC3INTP            : 1;
    unsigned LC3OUT             : 1;
    unsigned                    : 1;
    unsigned LC3EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC3MODE            : 3;
    unsigned                    : 5;
    };
  } __CLC3CONbits_t;

extern __at(0x0E24) volatile __CLC3CONbits_t CLC3CONbits;

#define _CLC3CON_LC3MODE0       0x01
#define _CLC3CON_MODE0          0x01
#define _CLC3CON_LC3MODE1       0x02
#define _CLC3CON_MODE1          0x02
#define _CLC3CON_LC3MODE2       0x04
#define _CLC3CON_MODE2          0x04
#define _CLC3CON_LC3INTN        0x08
#define _CLC3CON_INTN           0x08
#define _CLC3CON_LC3INTP        0x10
#define _CLC3CON_INTP           0x10
#define _CLC3CON_LC3OUT         0x20
#define _CLC3CON_OUT            0x20
#define _CLC3CON_LC3EN          0x80
#define _CLC3CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC3POL Bits

extern __at(0x0E25) __sfr CLC3POL;

typedef union
  {
  struct
    {
    unsigned LC3G1POL           : 1;
    unsigned LC3G2POL           : 1;
    unsigned LC3G3POL           : 1;
    unsigned LC3G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC3POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC3POLbits_t;

extern __at(0x0E25) volatile __CLC3POLbits_t CLC3POLbits;

#define _CLC3POL_LC3G1POL       0x01
#define _CLC3POL_G1POL          0x01
#define _CLC3POL_LC3G2POL       0x02
#define _CLC3POL_G2POL          0x02
#define _CLC3POL_LC3G3POL       0x04
#define _CLC3POL_G3POL          0x04
#define _CLC3POL_LC3G4POL       0x08
#define _CLC3POL_G4POL          0x08
#define _CLC3POL_LC3POL         0x80
#define _CLC3POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC3SEL0 Bits

extern __at(0x0E26) __sfr CLC3SEL0;

typedef union
  {
  struct
    {
    unsigned LC3D1S0            : 1;
    unsigned LC3D1S1            : 1;
    unsigned LC3D1S2            : 1;
    unsigned LC3D1S3            : 1;
    unsigned LC3D1S4            : 1;
    unsigned LC3D1S5            : 1;
    unsigned LC3D1S6            : 1;
    unsigned LC3D1S7            : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned D1S6               : 1;
    unsigned D1S7               : 1;
    };
  } __CLC3SEL0bits_t;

extern __at(0x0E26) volatile __CLC3SEL0bits_t CLC3SEL0bits;

#define _CLC3SEL0_LC3D1S0       0x01
#define _CLC3SEL0_D1S0          0x01
#define _CLC3SEL0_LC3D1S1       0x02
#define _CLC3SEL0_D1S1          0x02
#define _CLC3SEL0_LC3D1S2       0x04
#define _CLC3SEL0_D1S2          0x04
#define _CLC3SEL0_LC3D1S3       0x08
#define _CLC3SEL0_D1S3          0x08
#define _CLC3SEL0_LC3D1S4       0x10
#define _CLC3SEL0_D1S4          0x10
#define _CLC3SEL0_LC3D1S5       0x20
#define _CLC3SEL0_D1S5          0x20
#define _CLC3SEL0_LC3D1S6       0x40
#define _CLC3SEL0_D1S6          0x40
#define _CLC3SEL0_LC3D1S7       0x80
#define _CLC3SEL0_D1S7          0x80

//==============================================================================


//==============================================================================
//        CLC3SEL1 Bits

extern __at(0x0E27) __sfr CLC3SEL1;

typedef union
  {
  struct
    {
    unsigned LC3D2S0            : 1;
    unsigned LC3D2S1            : 1;
    unsigned LC3D2S2            : 1;
    unsigned LC3D2S3            : 1;
    unsigned LC3D2S4            : 1;
    unsigned LC3D2S5            : 1;
    unsigned LC3D2S6            : 1;
    unsigned LC3D2S7            : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned D2S6               : 1;
    unsigned D2S7               : 1;
    };
  } __CLC3SEL1bits_t;

extern __at(0x0E27) volatile __CLC3SEL1bits_t CLC3SEL1bits;

#define _CLC3SEL1_LC3D2S0       0x01
#define _CLC3SEL1_D2S0          0x01
#define _CLC3SEL1_LC3D2S1       0x02
#define _CLC3SEL1_D2S1          0x02
#define _CLC3SEL1_LC3D2S2       0x04
#define _CLC3SEL1_D2S2          0x04
#define _CLC3SEL1_LC3D2S3       0x08
#define _CLC3SEL1_D2S3          0x08
#define _CLC3SEL1_LC3D2S4       0x10
#define _CLC3SEL1_D2S4          0x10
#define _CLC3SEL1_LC3D2S5       0x20
#define _CLC3SEL1_D2S5          0x20
#define _CLC3SEL1_LC3D2S6       0x40
#define _CLC3SEL1_D2S6          0x40
#define _CLC3SEL1_LC3D2S7       0x80
#define _CLC3SEL1_D2S7          0x80

//==============================================================================


//==============================================================================
//        CLC3SEL2 Bits

extern __at(0x0E28) __sfr CLC3SEL2;

typedef union
  {
  struct
    {
    unsigned LC3D3S0            : 1;
    unsigned LC3D3S1            : 1;
    unsigned LC3D3S2            : 1;
    unsigned LC3D3S3            : 1;
    unsigned LC3D3S4            : 1;
    unsigned LC3D3S5            : 1;
    unsigned LC3D3S6            : 1;
    unsigned LC3D3S7            : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned D3S6               : 1;
    unsigned D3S7               : 1;
    };
  } __CLC3SEL2bits_t;

extern __at(0x0E28) volatile __CLC3SEL2bits_t CLC3SEL2bits;

#define _CLC3SEL2_LC3D3S0       0x01
#define _CLC3SEL2_D3S0          0x01
#define _CLC3SEL2_LC3D3S1       0x02
#define _CLC3SEL2_D3S1          0x02
#define _CLC3SEL2_LC3D3S2       0x04
#define _CLC3SEL2_D3S2          0x04
#define _CLC3SEL2_LC3D3S3       0x08
#define _CLC3SEL2_D3S3          0x08
#define _CLC3SEL2_LC3D3S4       0x10
#define _CLC3SEL2_D3S4          0x10
#define _CLC3SEL2_LC3D3S5       0x20
#define _CLC3SEL2_D3S5          0x20
#define _CLC3SEL2_LC3D3S6       0x40
#define _CLC3SEL2_D3S6          0x40
#define _CLC3SEL2_LC3D3S7       0x80
#define _CLC3SEL2_D3S7          0x80

//==============================================================================


//==============================================================================
//        CLC3SEL3 Bits

extern __at(0x0E29) __sfr CLC3SEL3;

typedef union
  {
  struct
    {
    unsigned LC3D4S0            : 1;
    unsigned LC3D4S1            : 1;
    unsigned LC3D4S2            : 1;
    unsigned LC3D4S3            : 1;
    unsigned LC3D4S4            : 1;
    unsigned LC3D4S5            : 1;
    unsigned LC3D4S6            : 1;
    unsigned LC3D4S7            : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned D4S6               : 1;
    unsigned D4S7               : 1;
    };
  } __CLC3SEL3bits_t;

extern __at(0x0E29) volatile __CLC3SEL3bits_t CLC3SEL3bits;

#define _CLC3SEL3_LC3D4S0       0x01
#define _CLC3SEL3_D4S0          0x01
#define _CLC3SEL3_LC3D4S1       0x02
#define _CLC3SEL3_D4S1          0x02
#define _CLC3SEL3_LC3D4S2       0x04
#define _CLC3SEL3_D4S2          0x04
#define _CLC3SEL3_LC3D4S3       0x08
#define _CLC3SEL3_D4S3          0x08
#define _CLC3SEL3_LC3D4S4       0x10
#define _CLC3SEL3_D4S4          0x10
#define _CLC3SEL3_LC3D4S5       0x20
#define _CLC3SEL3_D4S5          0x20
#define _CLC3SEL3_LC3D4S6       0x40
#define _CLC3SEL3_D4S6          0x40
#define _CLC3SEL3_LC3D4S7       0x80
#define _CLC3SEL3_D4S7          0x80

//==============================================================================


//==============================================================================
//        CLC3GLS0 Bits

extern __at(0x0E2A) __sfr CLC3GLS0;

typedef union
  {
  struct
    {
    unsigned LC3G1D1N           : 1;
    unsigned LC3G1D1T           : 1;
    unsigned LC3G1D2N           : 1;
    unsigned LC3G1D2T           : 1;
    unsigned LC3G1D3N           : 1;
    unsigned LC3G1D3T           : 1;
    unsigned LC3G1D4N           : 1;
    unsigned LC3G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS0bits_t;

extern __at(0x0E2A) volatile __CLC3GLS0bits_t CLC3GLS0bits;

#define _CLC3GLS0_LC3G1D1N      0x01
#define _CLC3GLS0_D1N           0x01
#define _CLC3GLS0_LC3G1D1T      0x02
#define _CLC3GLS0_D1T           0x02
#define _CLC3GLS0_LC3G1D2N      0x04
#define _CLC3GLS0_D2N           0x04
#define _CLC3GLS0_LC3G1D2T      0x08
#define _CLC3GLS0_D2T           0x08
#define _CLC3GLS0_LC3G1D3N      0x10
#define _CLC3GLS0_D3N           0x10
#define _CLC3GLS0_LC3G1D3T      0x20
#define _CLC3GLS0_D3T           0x20
#define _CLC3GLS0_LC3G1D4N      0x40
#define _CLC3GLS0_D4N           0x40
#define _CLC3GLS0_LC3G1D4T      0x80
#define _CLC3GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS1 Bits

extern __at(0x0E2B) __sfr CLC3GLS1;

typedef union
  {
  struct
    {
    unsigned LC3G2D1N           : 1;
    unsigned LC3G2D1T           : 1;
    unsigned LC3G2D2N           : 1;
    unsigned LC3G2D2T           : 1;
    unsigned LC3G2D3N           : 1;
    unsigned LC3G2D3T           : 1;
    unsigned LC3G2D4N           : 1;
    unsigned LC3G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS1bits_t;

extern __at(0x0E2B) volatile __CLC3GLS1bits_t CLC3GLS1bits;

#define _CLC3GLS1_LC3G2D1N      0x01
#define _CLC3GLS1_D1N           0x01
#define _CLC3GLS1_LC3G2D1T      0x02
#define _CLC3GLS1_D1T           0x02
#define _CLC3GLS1_LC3G2D2N      0x04
#define _CLC3GLS1_D2N           0x04
#define _CLC3GLS1_LC3G2D2T      0x08
#define _CLC3GLS1_D2T           0x08
#define _CLC3GLS1_LC3G2D3N      0x10
#define _CLC3GLS1_D3N           0x10
#define _CLC3GLS1_LC3G2D3T      0x20
#define _CLC3GLS1_D3T           0x20
#define _CLC3GLS1_LC3G2D4N      0x40
#define _CLC3GLS1_D4N           0x40
#define _CLC3GLS1_LC3G2D4T      0x80
#define _CLC3GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS2 Bits

extern __at(0x0E2C) __sfr CLC3GLS2;

typedef union
  {
  struct
    {
    unsigned LC3G3D1N           : 1;
    unsigned LC3G3D1T           : 1;
    unsigned LC3G3D2N           : 1;
    unsigned LC3G3D2T           : 1;
    unsigned LC3G3D3N           : 1;
    unsigned LC3G3D3T           : 1;
    unsigned LC3G3D4N           : 1;
    unsigned LC3G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS2bits_t;

extern __at(0x0E2C) volatile __CLC3GLS2bits_t CLC3GLS2bits;

#define _CLC3GLS2_LC3G3D1N      0x01
#define _CLC3GLS2_D1N           0x01
#define _CLC3GLS2_LC3G3D1T      0x02
#define _CLC3GLS2_D1T           0x02
#define _CLC3GLS2_LC3G3D2N      0x04
#define _CLC3GLS2_D2N           0x04
#define _CLC3GLS2_LC3G3D2T      0x08
#define _CLC3GLS2_D2T           0x08
#define _CLC3GLS2_LC3G3D3N      0x10
#define _CLC3GLS2_D3N           0x10
#define _CLC3GLS2_LC3G3D3T      0x20
#define _CLC3GLS2_D3T           0x20
#define _CLC3GLS2_LC3G3D4N      0x40
#define _CLC3GLS2_D4N           0x40
#define _CLC3GLS2_LC3G3D4T      0x80
#define _CLC3GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS3 Bits

extern __at(0x0E2D) __sfr CLC3GLS3;

typedef union
  {
  struct
    {
    unsigned LC3G4D1N           : 1;
    unsigned LC3G4D1T           : 1;
    unsigned LC3G4D2N           : 1;
    unsigned LC3G4D2T           : 1;
    unsigned LC3G4D3N           : 1;
    unsigned LC3G4D3T           : 1;
    unsigned LC3G4D4N           : 1;
    unsigned LC3G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC3GLS3bits_t;

extern __at(0x0E2D) volatile __CLC3GLS3bits_t CLC3GLS3bits;

#define _CLC3GLS3_LC3G4D1N      0x01
#define _CLC3GLS3_G4D1N         0x01
#define _CLC3GLS3_LC3G4D1T      0x02
#define _CLC3GLS3_G4D1T         0x02
#define _CLC3GLS3_LC3G4D2N      0x04
#define _CLC3GLS3_G4D2N         0x04
#define _CLC3GLS3_LC3G4D2T      0x08
#define _CLC3GLS3_G4D2T         0x08
#define _CLC3GLS3_LC3G4D3N      0x10
#define _CLC3GLS3_G4D3N         0x10
#define _CLC3GLS3_LC3G4D3T      0x20
#define _CLC3GLS3_G4D3T         0x20
#define _CLC3GLS3_LC3G4D4N      0x40
#define _CLC3GLS3_G4D4N         0x40
#define _CLC3GLS3_LC3G4D4T      0x80
#define _CLC3GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        CLC4CON Bits

extern __at(0x0E2E) __sfr CLC4CON;

typedef union
  {
  struct
    {
    unsigned LC4MODE0           : 1;
    unsigned LC4MODE1           : 1;
    unsigned LC4MODE2           : 1;
    unsigned LC4INTN            : 1;
    unsigned LC4INTP            : 1;
    unsigned LC4OUT             : 1;
    unsigned                    : 1;
    unsigned LC4EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC4MODE            : 3;
    unsigned                    : 5;
    };
  } __CLC4CONbits_t;

extern __at(0x0E2E) volatile __CLC4CONbits_t CLC4CONbits;

#define _CLC4CON_LC4MODE0       0x01
#define _CLC4CON_MODE0          0x01
#define _CLC4CON_LC4MODE1       0x02
#define _CLC4CON_MODE1          0x02
#define _CLC4CON_LC4MODE2       0x04
#define _CLC4CON_MODE2          0x04
#define _CLC4CON_LC4INTN        0x08
#define _CLC4CON_INTN           0x08
#define _CLC4CON_LC4INTP        0x10
#define _CLC4CON_INTP           0x10
#define _CLC4CON_LC4OUT         0x20
#define _CLC4CON_OUT            0x20
#define _CLC4CON_LC4EN          0x80
#define _CLC4CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC4POL Bits

extern __at(0x0E2F) __sfr CLC4POL;

typedef union
  {
  struct
    {
    unsigned LC4G1POL           : 1;
    unsigned LC4G2POL           : 1;
    unsigned LC4G3POL           : 1;
    unsigned LC4G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC4POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC4POLbits_t;

extern __at(0x0E2F) volatile __CLC4POLbits_t CLC4POLbits;

#define _CLC4POL_LC4G1POL       0x01
#define _CLC4POL_G1POL          0x01
#define _CLC4POL_LC4G2POL       0x02
#define _CLC4POL_G2POL          0x02
#define _CLC4POL_LC4G3POL       0x04
#define _CLC4POL_G3POL          0x04
#define _CLC4POL_LC4G4POL       0x08
#define _CLC4POL_G4POL          0x08
#define _CLC4POL_LC4POL         0x80
#define _CLC4POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC4SEL0 Bits

extern __at(0x0E30) __sfr CLC4SEL0;

typedef union
  {
  struct
    {
    unsigned LC4D1S0            : 1;
    unsigned LC4D1S1            : 1;
    unsigned LC4D1S2            : 1;
    unsigned LC4D1S3            : 1;
    unsigned LC4D1S4            : 1;
    unsigned LC4D1S5            : 1;
    unsigned LC4D1S6            : 1;
    unsigned LC4D1S7            : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned D1S6               : 1;
    unsigned D1S7               : 1;
    };
  } __CLC4SEL0bits_t;

extern __at(0x0E30) volatile __CLC4SEL0bits_t CLC4SEL0bits;

#define _CLC4SEL0_LC4D1S0       0x01
#define _CLC4SEL0_D1S0          0x01
#define _CLC4SEL0_LC4D1S1       0x02
#define _CLC4SEL0_D1S1          0x02
#define _CLC4SEL0_LC4D1S2       0x04
#define _CLC4SEL0_D1S2          0x04
#define _CLC4SEL0_LC4D1S3       0x08
#define _CLC4SEL0_D1S3          0x08
#define _CLC4SEL0_LC4D1S4       0x10
#define _CLC4SEL0_D1S4          0x10
#define _CLC4SEL0_LC4D1S5       0x20
#define _CLC4SEL0_D1S5          0x20
#define _CLC4SEL0_LC4D1S6       0x40
#define _CLC4SEL0_D1S6          0x40
#define _CLC4SEL0_LC4D1S7       0x80
#define _CLC4SEL0_D1S7          0x80

//==============================================================================


//==============================================================================
//        CLC4SEL1 Bits

extern __at(0x0E31) __sfr CLC4SEL1;

typedef union
  {
  struct
    {
    unsigned LC4D2S0            : 1;
    unsigned LC4D2S1            : 1;
    unsigned LC4D2S2            : 1;
    unsigned LC4D2S3            : 1;
    unsigned LC4D2S4            : 1;
    unsigned LC4D2S5            : 1;
    unsigned LC4D2S6            : 1;
    unsigned LC4D2S7            : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned D2S6               : 1;
    unsigned D2S7               : 1;
    };
  } __CLC4SEL1bits_t;

extern __at(0x0E31) volatile __CLC4SEL1bits_t CLC4SEL1bits;

#define _CLC4SEL1_LC4D2S0       0x01
#define _CLC4SEL1_D2S0          0x01
#define _CLC4SEL1_LC4D2S1       0x02
#define _CLC4SEL1_D2S1          0x02
#define _CLC4SEL1_LC4D2S2       0x04
#define _CLC4SEL1_D2S2          0x04
#define _CLC4SEL1_LC4D2S3       0x08
#define _CLC4SEL1_D2S3          0x08
#define _CLC4SEL1_LC4D2S4       0x10
#define _CLC4SEL1_D2S4          0x10
#define _CLC4SEL1_LC4D2S5       0x20
#define _CLC4SEL1_D2S5          0x20
#define _CLC4SEL1_LC4D2S6       0x40
#define _CLC4SEL1_D2S6          0x40
#define _CLC4SEL1_LC4D2S7       0x80
#define _CLC4SEL1_D2S7          0x80

//==============================================================================


//==============================================================================
//        CLC4SEL2 Bits

extern __at(0x0E32) __sfr CLC4SEL2;

typedef union
  {
  struct
    {
    unsigned LC4D3S0            : 1;
    unsigned LC4D3S1            : 1;
    unsigned LC4D3S2            : 1;
    unsigned LC4D3S3            : 1;
    unsigned LC4D3S4            : 1;
    unsigned LC4D3S5            : 1;
    unsigned LC4D3S6            : 1;
    unsigned LC4D3S7            : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned D3S6               : 1;
    unsigned D3S7               : 1;
    };
  } __CLC4SEL2bits_t;

extern __at(0x0E32) volatile __CLC4SEL2bits_t CLC4SEL2bits;

#define _CLC4SEL2_LC4D3S0       0x01
#define _CLC4SEL2_D3S0          0x01
#define _CLC4SEL2_LC4D3S1       0x02
#define _CLC4SEL2_D3S1          0x02
#define _CLC4SEL2_LC4D3S2       0x04
#define _CLC4SEL2_D3S2          0x04
#define _CLC4SEL2_LC4D3S3       0x08
#define _CLC4SEL2_D3S3          0x08
#define _CLC4SEL2_LC4D3S4       0x10
#define _CLC4SEL2_D3S4          0x10
#define _CLC4SEL2_LC4D3S5       0x20
#define _CLC4SEL2_D3S5          0x20
#define _CLC4SEL2_LC4D3S6       0x40
#define _CLC4SEL2_D3S6          0x40
#define _CLC4SEL2_LC4D3S7       0x80
#define _CLC4SEL2_D3S7          0x80

//==============================================================================


//==============================================================================
//        CLC4SEL3 Bits

extern __at(0x0E33) __sfr CLC4SEL3;

typedef union
  {
  struct
    {
    unsigned LC4D4S0            : 1;
    unsigned LC4D4S1            : 1;
    unsigned LC4D4S2            : 1;
    unsigned LC4D4S3            : 1;
    unsigned LC4D4S4            : 1;
    unsigned LC4D4S5            : 1;
    unsigned LC4D4S6            : 1;
    unsigned LC4D4S7            : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned D4S6               : 1;
    unsigned D4S7               : 1;
    };
  } __CLC4SEL3bits_t;

extern __at(0x0E33) volatile __CLC4SEL3bits_t CLC4SEL3bits;

#define _CLC4SEL3_LC4D4S0       0x01
#define _CLC4SEL3_D4S0          0x01
#define _CLC4SEL3_LC4D4S1       0x02
#define _CLC4SEL3_D4S1          0x02
#define _CLC4SEL3_LC4D4S2       0x04
#define _CLC4SEL3_D4S2          0x04
#define _CLC4SEL3_LC4D4S3       0x08
#define _CLC4SEL3_D4S3          0x08
#define _CLC4SEL3_LC4D4S4       0x10
#define _CLC4SEL3_D4S4          0x10
#define _CLC4SEL3_LC4D4S5       0x20
#define _CLC4SEL3_D4S5          0x20
#define _CLC4SEL3_LC4D4S6       0x40
#define _CLC4SEL3_D4S6          0x40
#define _CLC4SEL3_LC4D4S7       0x80
#define _CLC4SEL3_D4S7          0x80

//==============================================================================


//==============================================================================
//        CLC4GLS0 Bits

extern __at(0x0E34) __sfr CLC4GLS0;

typedef union
  {
  struct
    {
    unsigned LC4G1D1N           : 1;
    unsigned LC4G1D1T           : 1;
    unsigned LC4G1D2N           : 1;
    unsigned LC4G1D2T           : 1;
    unsigned LC4G1D3N           : 1;
    unsigned LC4G1D3T           : 1;
    unsigned LC4G1D4N           : 1;
    unsigned LC4G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS0bits_t;

extern __at(0x0E34) volatile __CLC4GLS0bits_t CLC4GLS0bits;

#define _CLC4GLS0_LC4G1D1N      0x01
#define _CLC4GLS0_D1N           0x01
#define _CLC4GLS0_LC4G1D1T      0x02
#define _CLC4GLS0_D1T           0x02
#define _CLC4GLS0_LC4G1D2N      0x04
#define _CLC4GLS0_D2N           0x04
#define _CLC4GLS0_LC4G1D2T      0x08
#define _CLC4GLS0_D2T           0x08
#define _CLC4GLS0_LC4G1D3N      0x10
#define _CLC4GLS0_D3N           0x10
#define _CLC4GLS0_LC4G1D3T      0x20
#define _CLC4GLS0_D3T           0x20
#define _CLC4GLS0_LC4G1D4N      0x40
#define _CLC4GLS0_D4N           0x40
#define _CLC4GLS0_LC4G1D4T      0x80
#define _CLC4GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS1 Bits

extern __at(0x0E35) __sfr CLC4GLS1;

typedef union
  {
  struct
    {
    unsigned LC4G2D1N           : 1;
    unsigned LC4G2D1T           : 1;
    unsigned LC4G2D2N           : 1;
    unsigned LC4G2D2T           : 1;
    unsigned LC4G2D3N           : 1;
    unsigned LC4G2D3T           : 1;
    unsigned LC4G2D4N           : 1;
    unsigned LC4G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS1bits_t;

extern __at(0x0E35) volatile __CLC4GLS1bits_t CLC4GLS1bits;

#define _CLC4GLS1_LC4G2D1N      0x01
#define _CLC4GLS1_D1N           0x01
#define _CLC4GLS1_LC4G2D1T      0x02
#define _CLC4GLS1_D1T           0x02
#define _CLC4GLS1_LC4G2D2N      0x04
#define _CLC4GLS1_D2N           0x04
#define _CLC4GLS1_LC4G2D2T      0x08
#define _CLC4GLS1_D2T           0x08
#define _CLC4GLS1_LC4G2D3N      0x10
#define _CLC4GLS1_D3N           0x10
#define _CLC4GLS1_LC4G2D3T      0x20
#define _CLC4GLS1_D3T           0x20
#define _CLC4GLS1_LC4G2D4N      0x40
#define _CLC4GLS1_D4N           0x40
#define _CLC4GLS1_LC4G2D4T      0x80
#define _CLC4GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS2 Bits

extern __at(0x0E36) __sfr CLC4GLS2;

typedef union
  {
  struct
    {
    unsigned LC4G3D1N           : 1;
    unsigned LC4G3D1T           : 1;
    unsigned LC4G3D2N           : 1;
    unsigned LC4G3D2T           : 1;
    unsigned LC4G3D3N           : 1;
    unsigned LC4G3D3T           : 1;
    unsigned LC4G3D4N           : 1;
    unsigned LC4G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS2bits_t;

extern __at(0x0E36) volatile __CLC4GLS2bits_t CLC4GLS2bits;

#define _CLC4GLS2_LC4G3D1N      0x01
#define _CLC4GLS2_D1N           0x01
#define _CLC4GLS2_LC4G3D1T      0x02
#define _CLC4GLS2_D1T           0x02
#define _CLC4GLS2_LC4G3D2N      0x04
#define _CLC4GLS2_D2N           0x04
#define _CLC4GLS2_LC4G3D2T      0x08
#define _CLC4GLS2_D2T           0x08
#define _CLC4GLS2_LC4G3D3N      0x10
#define _CLC4GLS2_D3N           0x10
#define _CLC4GLS2_LC4G3D3T      0x20
#define _CLC4GLS2_D3T           0x20
#define _CLC4GLS2_LC4G3D4N      0x40
#define _CLC4GLS2_D4N           0x40
#define _CLC4GLS2_LC4G3D4T      0x80
#define _CLC4GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS3 Bits

extern __at(0x0E37) __sfr CLC4GLS3;

typedef union
  {
  struct
    {
    unsigned LC4G4D1N           : 1;
    unsigned LC4G4D1T           : 1;
    unsigned LC4G4D2N           : 1;
    unsigned LC4G4D2T           : 1;
    unsigned LC4G4D3N           : 1;
    unsigned LC4G4D3T           : 1;
    unsigned LC4G4D4N           : 1;
    unsigned LC4G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC4GLS3bits_t;

extern __at(0x0E37) volatile __CLC4GLS3bits_t CLC4GLS3bits;

#define _CLC4GLS3_LC4G4D1N      0x01
#define _CLC4GLS3_G4D1N         0x01
#define _CLC4GLS3_LC4G4D1T      0x02
#define _CLC4GLS3_G4D1T         0x02
#define _CLC4GLS3_LC4G4D2N      0x04
#define _CLC4GLS3_G4D2N         0x04
#define _CLC4GLS3_LC4G4D2T      0x08
#define _CLC4GLS3_G4D2T         0x08
#define _CLC4GLS3_LC4G4D3N      0x10
#define _CLC4GLS3_G4D3N         0x10
#define _CLC4GLS3_LC4G4D3T      0x20
#define _CLC4GLS3_G4D3T         0x20
#define _CLC4GLS3_LC4G4D4N      0x40
#define _CLC4GLS3_G4D4N         0x40
#define _CLC4GLS3_LC4G4D4T      0x80
#define _CLC4GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        PPSLOCK Bits

extern __at(0x0E8F) __sfr PPSLOCK;

typedef struct
  {
  unsigned PPSLOCKED            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PPSLOCKbits_t;

extern __at(0x0E8F) volatile __PPSLOCKbits_t PPSLOCKbits;

#define _PPSLOCKED              0x01

//==============================================================================


//==============================================================================
//        INTPPS Bits

extern __at(0x0E90) __sfr INTPPS;

typedef union
  {
  struct
    {
    unsigned INTPPS0            : 1;
    unsigned INTPPS1            : 1;
    unsigned INTPPS2            : 1;
    unsigned INTPPS3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INTPPS             : 4;
    unsigned                    : 4;
    };
  } __INTPPSbits_t;

extern __at(0x0E90) volatile __INTPPSbits_t INTPPSbits;

#define _INTPPS0                0x01
#define _INTPPS1                0x02
#define _INTPPS2                0x04
#define _INTPPS3                0x08

//==============================================================================


//==============================================================================
//        T0CKIPPS Bits

extern __at(0x0E91) __sfr T0CKIPPS;

typedef union
  {
  struct
    {
    unsigned T0CKIPPS0          : 1;
    unsigned T0CKIPPS1          : 1;
    unsigned T0CKIPPS2          : 1;
    unsigned T0CKIPPS3          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T0CKIPPS           : 4;
    unsigned                    : 4;
    };
  } __T0CKIPPSbits_t;

extern __at(0x0E91) volatile __T0CKIPPSbits_t T0CKIPPSbits;

#define _T0CKIPPS0              0x01
#define _T0CKIPPS1              0x02
#define _T0CKIPPS2              0x04
#define _T0CKIPPS3              0x08

//==============================================================================


//==============================================================================
//        T1CKIPPS Bits

extern __at(0x0E92) __sfr T1CKIPPS;

typedef union
  {
  struct
    {
    unsigned T1CKIPPS0          : 1;
    unsigned T1CKIPPS1          : 1;
    unsigned T1CKIPPS2          : 1;
    unsigned T1CKIPPS3          : 1;
    unsigned T1CKIPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1CKIPPS           : 5;
    unsigned                    : 3;
    };
  } __T1CKIPPSbits_t;

extern __at(0x0E92) volatile __T1CKIPPSbits_t T1CKIPPSbits;

#define _T1CKIPPS0              0x01
#define _T1CKIPPS1              0x02
#define _T1CKIPPS2              0x04
#define _T1CKIPPS3              0x08
#define _T1CKIPPS4              0x10

//==============================================================================


//==============================================================================
//        T1GPPS Bits

extern __at(0x0E93) __sfr T1GPPS;

typedef union
  {
  struct
    {
    unsigned T1GPPS0            : 1;
    unsigned T1GPPS1            : 1;
    unsigned T1GPPS2            : 1;
    unsigned T1GPPS3            : 1;
    unsigned T1GPPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GPPS             : 5;
    unsigned                    : 3;
    };
  } __T1GPPSbits_t;

extern __at(0x0E93) volatile __T1GPPSbits_t T1GPPSbits;

#define _T1GPPS0                0x01
#define _T1GPPS1                0x02
#define _T1GPPS2                0x04
#define _T1GPPS3                0x08
#define _T1GPPS4                0x10

//==============================================================================


//==============================================================================
//        T3CKIPPS Bits

extern __at(0x0E94) __sfr T3CKIPPS;

typedef union
  {
  struct
    {
    unsigned T3CKIPPS0          : 1;
    unsigned T3CKIPPS1          : 1;
    unsigned T3CKIPPS2          : 1;
    unsigned T3CKIPPS3          : 1;
    unsigned T3CKIPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3CKIPPS           : 5;
    unsigned                    : 3;
    };
  } __T3CKIPPSbits_t;

extern __at(0x0E94) volatile __T3CKIPPSbits_t T3CKIPPSbits;

#define _T3CKIPPS0              0x01
#define _T3CKIPPS1              0x02
#define _T3CKIPPS2              0x04
#define _T3CKIPPS3              0x08
#define _T3CKIPPS4              0x10

//==============================================================================


//==============================================================================
//        T3GPPS Bits

extern __at(0x0E95) __sfr T3GPPS;

typedef union
  {
  struct
    {
    unsigned T3GPPS0            : 1;
    unsigned T3GPPS1            : 1;
    unsigned T3GPPS2            : 1;
    unsigned T3GPPS3            : 1;
    unsigned T3GPPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3GPPS             : 5;
    unsigned                    : 3;
    };
  } __T3GPPSbits_t;

extern __at(0x0E95) volatile __T3GPPSbits_t T3GPPSbits;

#define _T3GPPS0                0x01
#define _T3GPPS1                0x02
#define _T3GPPS2                0x04
#define _T3GPPS3                0x08
#define _T3GPPS4                0x10

//==============================================================================


//==============================================================================
//        T5CKIPPS Bits

extern __at(0x0E96) __sfr T5CKIPPS;

typedef union
  {
  struct
    {
    unsigned T5CKIPPS0          : 1;
    unsigned T5CKIPPS1          : 1;
    unsigned T5CKIPPS2          : 1;
    unsigned T5CKIPPS3          : 1;
    unsigned T5CKIPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T5CKIPPS           : 5;
    unsigned                    : 3;
    };
  } __T5CKIPPSbits_t;

extern __at(0x0E96) volatile __T5CKIPPSbits_t T5CKIPPSbits;

#define _T5CKIPPS0              0x01
#define _T5CKIPPS1              0x02
#define _T5CKIPPS2              0x04
#define _T5CKIPPS3              0x08
#define _T5CKIPPS4              0x10

//==============================================================================


//==============================================================================
//        T5GPPS Bits

extern __at(0x0E97) __sfr T5GPPS;

typedef union
  {
  struct
    {
    unsigned T5GPPS0            : 1;
    unsigned T5GPPS1            : 1;
    unsigned T5GPPS2            : 1;
    unsigned T5GPPS3            : 1;
    unsigned T5GPPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T5GPPS             : 5;
    unsigned                    : 3;
    };
  } __T5GPPSbits_t;

extern __at(0x0E97) volatile __T5GPPSbits_t T5GPPSbits;

#define _T5GPPS0                0x01
#define _T5GPPS1                0x02
#define _T5GPPS2                0x04
#define _T5GPPS3                0x08
#define _T5GPPS4                0x10

//==============================================================================


//==============================================================================
//        T2AINPPS Bits

extern __at(0x0E9C) __sfr T2AINPPS;

typedef union
  {
  struct
    {
    unsigned T2AINPPS0          : 1;
    unsigned T2AINPPS1          : 1;
    unsigned T2AINPPS2          : 1;
    unsigned T2AINPPS3          : 1;
    unsigned T2AINPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2AINPPS           : 5;
    unsigned                    : 3;
    };
  } __T2AINPPSbits_t;

extern __at(0x0E9C) volatile __T2AINPPSbits_t T2AINPPSbits;

#define _T2AINPPS0              0x01
#define _T2AINPPS1              0x02
#define _T2AINPPS2              0x04
#define _T2AINPPS3              0x08
#define _T2AINPPS4              0x10

//==============================================================================


//==============================================================================
//        T4AINPPS Bits

extern __at(0x0E9D) __sfr T4AINPPS;

typedef union
  {
  struct
    {
    unsigned T4AINPPS0          : 1;
    unsigned T4AINPPS1          : 1;
    unsigned T4AINPPS2          : 1;
    unsigned T4AINPPS3          : 1;
    unsigned T4AINPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4AINPPS           : 5;
    unsigned                    : 3;
    };
  } __T4AINPPSbits_t;

extern __at(0x0E9D) volatile __T4AINPPSbits_t T4AINPPSbits;

#define _T4AINPPS0              0x01
#define _T4AINPPS1              0x02
#define _T4AINPPS2              0x04
#define _T4AINPPS3              0x08
#define _T4AINPPS4              0x10

//==============================================================================


//==============================================================================
//        T6AINPPS Bits

extern __at(0x0E9E) __sfr T6AINPPS;

typedef union
  {
  struct
    {
    unsigned T6AINPPS0          : 1;
    unsigned T6AINPPS1          : 1;
    unsigned T6AINPPS2          : 1;
    unsigned T6AINPPS3          : 1;
    unsigned T6AINPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6AINPPS           : 5;
    unsigned                    : 3;
    };
  } __T6AINPPSbits_t;

extern __at(0x0E9E) volatile __T6AINPPSbits_t T6AINPPSbits;

#define _T6AINPPS0              0x01
#define _T6AINPPS1              0x02
#define _T6AINPPS2              0x04
#define _T6AINPPS3              0x08
#define _T6AINPPS4              0x10

//==============================================================================


//==============================================================================
//        CCP1PPS Bits

extern __at(0x0EA1) __sfr CCP1PPS;

typedef union
  {
  struct
    {
    unsigned CCP1PPS0           : 1;
    unsigned CCP1PPS1           : 1;
    unsigned CCP1PPS2           : 1;
    unsigned CCP1PPS3           : 1;
    unsigned CCP1PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1PPS            : 5;
    unsigned                    : 3;
    };
  } __CCP1PPSbits_t;

extern __at(0x0EA1) volatile __CCP1PPSbits_t CCP1PPSbits;

#define _CCP1PPS0               0x01
#define _CCP1PPS1               0x02
#define _CCP1PPS2               0x04
#define _CCP1PPS3               0x08
#define _CCP1PPS4               0x10

//==============================================================================


//==============================================================================
//        CCP2PPS Bits

extern __at(0x0EA2) __sfr CCP2PPS;

typedef union
  {
  struct
    {
    unsigned CCP2PPS0           : 1;
    unsigned CCP2PPS1           : 1;
    unsigned CCP2PPS2           : 1;
    unsigned CCP2PPS3           : 1;
    unsigned CCP2PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2PPS            : 5;
    unsigned                    : 3;
    };
  } __CCP2PPSbits_t;

extern __at(0x0EA2) volatile __CCP2PPSbits_t CCP2PPSbits;

#define _CCP2PPS0               0x01
#define _CCP2PPS1               0x02
#define _CCP2PPS2               0x04
#define _CCP2PPS3               0x08
#define _CCP2PPS4               0x10

//==============================================================================


//==============================================================================
//        CCP3PPS Bits

extern __at(0x0EA3) __sfr CCP3PPS;

typedef union
  {
  struct
    {
    unsigned CCP3PPS0           : 1;
    unsigned CCP3PPS1           : 1;
    unsigned CCP3PPS2           : 1;
    unsigned CCP3PPS3           : 1;
    unsigned CCP3PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP3PPS            : 5;
    unsigned                    : 3;
    };
  } __CCP3PPSbits_t;

extern __at(0x0EA3) volatile __CCP3PPSbits_t CCP3PPSbits;

#define _CCP3PPS0               0x01
#define _CCP3PPS1               0x02
#define _CCP3PPS2               0x04
#define _CCP3PPS3               0x08
#define _CCP3PPS4               0x10

//==============================================================================


//==============================================================================
//        CCP4PPS Bits

extern __at(0x0EA4) __sfr CCP4PPS;

typedef union
  {
  struct
    {
    unsigned CCP4PPS0           : 1;
    unsigned CCP4PPS1           : 1;
    unsigned CCP4PPS2           : 1;
    unsigned CCP4PPS3           : 1;
    unsigned CCP4PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP4PPS            : 5;
    unsigned                    : 3;
    };
  } __CCP4PPSbits_t;

extern __at(0x0EA4) volatile __CCP4PPSbits_t CCP4PPSbits;

#define _CCP4PPS0               0x01
#define _CCP4PPS1               0x02
#define _CCP4PPS2               0x04
#define _CCP4PPS3               0x08
#define _CCP4PPS4               0x10

//==============================================================================


//==============================================================================
//        CCP5PPS Bits

extern __at(0x0EA5) __sfr CCP5PPS;

typedef union
  {
  struct
    {
    unsigned CCP5PPS0           : 1;
    unsigned CCP5PPS1           : 1;
    unsigned CCP5PPS2           : 1;
    unsigned CCP5PPS3           : 1;
    unsigned CCP5PPS4           : 1;
    unsigned CCP6PPS            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP5PPS            : 5;
    unsigned                    : 3;
    };
  } __CCP5PPSbits_t;

extern __at(0x0EA5) volatile __CCP5PPSbits_t CCP5PPSbits;

#define _CCP5PPS0               0x01
#define _CCP5PPS1               0x02
#define _CCP5PPS2               0x04
#define _CCP5PPS3               0x08
#define _CCP5PPS4               0x10
#define _CCP6PPS                0x20

//==============================================================================


//==============================================================================
//        SMT1WINPPS Bits

extern __at(0x0EA9) __sfr SMT1WINPPS;

typedef union
  {
  struct
    {
    unsigned SMU1WINPPS0        : 1;
    unsigned SMU1WINPPS1        : 1;
    unsigned SMU1WINPPS2        : 1;
    unsigned SMU1WINPPS3        : 1;
    unsigned SMU1WINPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMU1WINPPS         : 5;
    unsigned                    : 3;
    };
  } __SMT1WINPPSbits_t;

extern __at(0x0EA9) volatile __SMT1WINPPSbits_t SMT1WINPPSbits;

#define _SMU1WINPPS0            0x01
#define _SMU1WINPPS1            0x02
#define _SMU1WINPPS2            0x04
#define _SMU1WINPPS3            0x08
#define _SMU1WINPPS4            0x10

//==============================================================================


//==============================================================================
//        SMT1SIGPPS Bits

extern __at(0x0EAA) __sfr SMT1SIGPPS;

typedef union
  {
  struct
    {
    unsigned SMU1SIGPPS0        : 1;
    unsigned SMU1SIGPPS1        : 1;
    unsigned SMU1SIGPPS2        : 1;
    unsigned SMU1SIGPPS3        : 1;
    unsigned SMU1SIGPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMU1SIGPPS         : 5;
    unsigned                    : 3;
    };
  } __SMT1SIGPPSbits_t;

extern __at(0x0EAA) volatile __SMT1SIGPPSbits_t SMT1SIGPPSbits;

#define _SMU1SIGPPS0            0x01
#define _SMU1SIGPPS1            0x02
#define _SMU1SIGPPS2            0x04
#define _SMU1SIGPPS3            0x08
#define _SMU1SIGPPS4            0x10

//==============================================================================


//==============================================================================
//        SMT2WINPPS Bits

extern __at(0x0EAB) __sfr SMT2WINPPS;

typedef union
  {
  struct
    {
    unsigned SMU2WINPPS0        : 1;
    unsigned SMU2WINPPS1        : 1;
    unsigned SMU2WINPPS2        : 1;
    unsigned SMU2WINPPS3        : 1;
    unsigned SMU2WINPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMU2WINPPS         : 5;
    unsigned                    : 3;
    };
  } __SMT2WINPPSbits_t;

extern __at(0x0EAB) volatile __SMT2WINPPSbits_t SMT2WINPPSbits;

#define _SMU2WINPPS0            0x01
#define _SMU2WINPPS1            0x02
#define _SMU2WINPPS2            0x04
#define _SMU2WINPPS3            0x08
#define _SMU2WINPPS4            0x10

//==============================================================================


//==============================================================================
//        SMT2SIGPPS Bits

extern __at(0x0EAC) __sfr SMT2SIGPPS;

typedef union
  {
  struct
    {
    unsigned SMU2SIGPPS0        : 1;
    unsigned SMU2SIGPPS1        : 1;
    unsigned SMU2SIGPPS2        : 1;
    unsigned SMU2SIGPPS3        : 1;
    unsigned SMU2SIGPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SMU2SIGPPS         : 5;
    unsigned                    : 3;
    };
  } __SMT2SIGPPSbits_t;

extern __at(0x0EAC) volatile __SMT2SIGPPSbits_t SMT2SIGPPSbits;

#define _SMU2SIGPPS0            0x01
#define _SMU2SIGPPS1            0x02
#define _SMU2SIGPPS2            0x04
#define _SMU2SIGPPS3            0x08
#define _SMU2SIGPPS4            0x10

//==============================================================================


//==============================================================================
//        CWG1PPS Bits

extern __at(0x0EB1) __sfr CWG1PPS;

typedef union
  {
  struct
    {
    unsigned CWG1PPS0           : 1;
    unsigned CWG1PPS1           : 1;
    unsigned CWG1PPS2           : 1;
    unsigned CWG1PPS3           : 1;
    unsigned CWG1PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1PPS            : 5;
    unsigned                    : 3;
    };
  } __CWG1PPSbits_t;

extern __at(0x0EB1) volatile __CWG1PPSbits_t CWG1PPSbits;

#define _CWG1PPS0               0x01
#define _CWG1PPS1               0x02
#define _CWG1PPS2               0x04
#define _CWG1PPS3               0x08
#define _CWG1PPS4               0x10

//==============================================================================


//==============================================================================
//        CWG2PPS Bits

extern __at(0x0EB2) __sfr CWG2PPS;

typedef union
  {
  struct
    {
    unsigned CWG2PPS0           : 1;
    unsigned CWG2PPS1           : 1;
    unsigned CWG2PPS2           : 1;
    unsigned CWG2PPS3           : 1;
    unsigned CWG2PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2PPS            : 5;
    unsigned                    : 3;
    };
  } __CWG2PPSbits_t;

extern __at(0x0EB2) volatile __CWG2PPSbits_t CWG2PPSbits;

#define _CWG2PPS0               0x01
#define _CWG2PPS1               0x02
#define _CWG2PPS2               0x04
#define _CWG2PPS3               0x08
#define _CWG2PPS4               0x10

//==============================================================================


//==============================================================================
//        CWG3PPS Bits

extern __at(0x0EB3) __sfr CWG3PPS;

typedef union
  {
  struct
    {
    unsigned CWG3PPS0           : 1;
    unsigned CWG3PPS1           : 1;
    unsigned CWG3PPS2           : 1;
    unsigned CWG3PPS3           : 1;
    unsigned CWG3PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG3PPS            : 5;
    unsigned                    : 3;
    };
  } __CWG3PPSbits_t;

extern __at(0x0EB3) volatile __CWG3PPSbits_t CWG3PPSbits;

#define _CWG3PPS0               0x01
#define _CWG3PPS1               0x02
#define _CWG3PPS2               0x04
#define _CWG3PPS3               0x08
#define _CWG3PPS4               0x10

//==============================================================================


//==============================================================================
//        MDCARLPPS Bits

extern __at(0x0EB8) __sfr MDCARLPPS;

typedef union
  {
  struct
    {
    unsigned MDCARLPPS0         : 1;
    unsigned MDCARLPPS1         : 1;
    unsigned MDCARLPPS2         : 1;
    unsigned MDCARLPPS3         : 1;
    unsigned MDCARLPPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MDCARLPPS          : 5;
    unsigned                    : 3;
    };
  } __MDCARLPPSbits_t;

extern __at(0x0EB8) volatile __MDCARLPPSbits_t MDCARLPPSbits;

#define _MDCARLPPS0             0x01
#define _MDCARLPPS1             0x02
#define _MDCARLPPS2             0x04
#define _MDCARLPPS3             0x08
#define _MDCARLPPS4             0x10

//==============================================================================


//==============================================================================
//        MDCARHPPS Bits

extern __at(0x0EB9) __sfr MDCARHPPS;

typedef union
  {
  struct
    {
    unsigned MDCARHPPS0         : 1;
    unsigned MDCARHPPS1         : 1;
    unsigned MDCARHPPS2         : 1;
    unsigned MDCARHPPS3         : 1;
    unsigned MDCARHPPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MDCARHPPS          : 5;
    unsigned                    : 3;
    };
  } __MDCARHPPSbits_t;

extern __at(0x0EB9) volatile __MDCARHPPSbits_t MDCARHPPSbits;

#define _MDCARHPPS0             0x01
#define _MDCARHPPS1             0x02
#define _MDCARHPPS2             0x04
#define _MDCARHPPS3             0x08
#define _MDCARHPPS4             0x10

//==============================================================================


//==============================================================================
//        MDSRCPPS Bits

extern __at(0x0EBA) __sfr MDSRCPPS;

typedef union
  {
  struct
    {
    unsigned MDSRCPPS0          : 1;
    unsigned MDSRCPPS1          : 1;
    unsigned MDSRCPPS2          : 1;
    unsigned MDSRCPPS3          : 1;
    unsigned MDSRCPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MDSRCPPS           : 5;
    unsigned                    : 3;
    };
  } __MDSRCPPSbits_t;

extern __at(0x0EBA) volatile __MDSRCPPSbits_t MDSRCPPSbits;

#define _MDSRCPPS0              0x01
#define _MDSRCPPS1              0x02
#define _MDSRCPPS2              0x04
#define _MDSRCPPS3              0x08
#define _MDSRCPPS4              0x10

//==============================================================================


//==============================================================================
//        CLCIN0PPS Bits

extern __at(0x0EBB) __sfr CLCIN0PPS;

typedef union
  {
  struct
    {
    unsigned CLCIN0PPS0         : 1;
    unsigned CLCIN0PPS1         : 1;
    unsigned CLCIN0PPS2         : 1;
    unsigned CLCIN0PPS3         : 1;
    unsigned CLCIN0PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CLCIN0PPS          : 5;
    unsigned                    : 3;
    };
  } __CLCIN0PPSbits_t;

extern __at(0x0EBB) volatile __CLCIN0PPSbits_t CLCIN0PPSbits;

#define _CLCIN0PPS0             0x01
#define _CLCIN0PPS1             0x02
#define _CLCIN0PPS2             0x04
#define _CLCIN0PPS3             0x08
#define _CLCIN0PPS4             0x10

//==============================================================================


//==============================================================================
//        CLCIN1PPS Bits

extern __at(0x0EBC) __sfr CLCIN1PPS;

typedef union
  {
  struct
    {
    unsigned CLCIN1PPS0         : 1;
    unsigned CLCIN1PPS1         : 1;
    unsigned CLCIN1PPS2         : 1;
    unsigned CLCIN1PPS3         : 1;
    unsigned CLCIN1PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CLCIN1PPS          : 5;
    unsigned                    : 3;
    };
  } __CLCIN1PPSbits_t;

extern __at(0x0EBC) volatile __CLCIN1PPSbits_t CLCIN1PPSbits;

#define _CLCIN1PPS0             0x01
#define _CLCIN1PPS1             0x02
#define _CLCIN1PPS2             0x04
#define _CLCIN1PPS3             0x08
#define _CLCIN1PPS4             0x10

//==============================================================================


//==============================================================================
//        CLCIN2PPS Bits

extern __at(0x0EBD) __sfr CLCIN2PPS;

typedef union
  {
  struct
    {
    unsigned CLCIN2PPS0         : 1;
    unsigned CLCIN2PPS1         : 1;
    unsigned CLCIN2PPS2         : 1;
    unsigned CLCIN2PPS3         : 1;
    unsigned CLCIN2PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CLCIN2PPS          : 5;
    unsigned                    : 3;
    };
  } __CLCIN2PPSbits_t;

extern __at(0x0EBD) volatile __CLCIN2PPSbits_t CLCIN2PPSbits;

#define _CLCIN2PPS0             0x01
#define _CLCIN2PPS1             0x02
#define _CLCIN2PPS2             0x04
#define _CLCIN2PPS3             0x08
#define _CLCIN2PPS4             0x10

//==============================================================================


//==============================================================================
//        CLCIN3PPS Bits

extern __at(0x0EBE) __sfr CLCIN3PPS;

typedef union
  {
  struct
    {
    unsigned CLCIN3PPS0         : 1;
    unsigned CLCIN3PPS1         : 1;
    unsigned CLCIN3PPS2         : 1;
    unsigned CLCIN3PPS3         : 1;
    unsigned CLCIN3PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CLCIN3PPS          : 5;
    unsigned                    : 3;
    };
  } __CLCIN3PPSbits_t;

extern __at(0x0EBE) volatile __CLCIN3PPSbits_t CLCIN3PPSbits;

#define _CLCIN3PPS0             0x01
#define _CLCIN3PPS1             0x02
#define _CLCIN3PPS2             0x04
#define _CLCIN3PPS3             0x08
#define _CLCIN3PPS4             0x10

//==============================================================================


//==============================================================================
//        ADCACTPPS Bits

extern __at(0x0EC3) __sfr ADCACTPPS;

typedef union
  {
  struct
    {
    unsigned ADCACTPPS0         : 1;
    unsigned ADCACTPPS1         : 1;
    unsigned ADCACTPPS2         : 1;
    unsigned ADCACTPPS3         : 1;
    unsigned ADCACTPPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADCACTPPS          : 5;
    unsigned                    : 3;
    };
  } __ADCACTPPSbits_t;

extern __at(0x0EC3) volatile __ADCACTPPSbits_t ADCACTPPSbits;

#define _ADCACTPPS0             0x01
#define _ADCACTPPS1             0x02
#define _ADCACTPPS2             0x04
#define _ADCACTPPS3             0x08
#define _ADCACTPPS4             0x10

//==============================================================================


//==============================================================================
//        SSP1CLKPPS Bits

extern __at(0x0EC5) __sfr SSP1CLKPPS;

typedef union
  {
  struct
    {
    unsigned SSP1CLKPPS0        : 1;
    unsigned SSP1CLKPPS1        : 1;
    unsigned SSP1CLKPPS2        : 1;
    unsigned SSP1CLKPPS3        : 1;
    unsigned SSP1CLKPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP1CLKPPS         : 5;
    unsigned                    : 3;
    };
  } __SSP1CLKPPSbits_t;

extern __at(0x0EC5) volatile __SSP1CLKPPSbits_t SSP1CLKPPSbits;

#define _SSP1CLKPPS0            0x01
#define _SSP1CLKPPS1            0x02
#define _SSP1CLKPPS2            0x04
#define _SSP1CLKPPS3            0x08
#define _SSP1CLKPPS4            0x10

//==============================================================================


//==============================================================================
//        SSP1DATPPS Bits

extern __at(0x0EC6) __sfr SSP1DATPPS;

typedef union
  {
  struct
    {
    unsigned SSP1DATPPS0        : 1;
    unsigned SSP1DATPPS1        : 1;
    unsigned SSP1DATPPS2        : 1;
    unsigned SSP1DATPPS3        : 1;
    unsigned SSP1DATPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP1DATPPS         : 5;
    unsigned                    : 3;
    };
  } __SSP1DATPPSbits_t;

extern __at(0x0EC6) volatile __SSP1DATPPSbits_t SSP1DATPPSbits;

#define _SSP1DATPPS0            0x01
#define _SSP1DATPPS1            0x02
#define _SSP1DATPPS2            0x04
#define _SSP1DATPPS3            0x08
#define _SSP1DATPPS4            0x10

//==============================================================================


//==============================================================================
//        SSP1SSPPS Bits

extern __at(0x0EC7) __sfr SSP1SSPPS;

typedef union
  {
  struct
    {
    unsigned SSP1SSPPS0         : 1;
    unsigned SSP1SSPPS1         : 1;
    unsigned SSP1SSPPS2         : 1;
    unsigned SSP1SSPPS3         : 1;
    unsigned SSP1SSPPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP1SSPPS          : 5;
    unsigned                    : 3;
    };
  } __SSP1SSPPSbits_t;

extern __at(0x0EC7) volatile __SSP1SSPPSbits_t SSP1SSPPSbits;

#define _SSP1SSPPS0             0x01
#define _SSP1SSPPS1             0x02
#define _SSP1SSPPS2             0x04
#define _SSP1SSPPS3             0x08
#define _SSP1SSPPS4             0x10

//==============================================================================


//==============================================================================
//        SSP2CLKPPS Bits

extern __at(0x0EC8) __sfr SSP2CLKPPS;

typedef union
  {
  struct
    {
    unsigned SSP2CLKPPS0        : 1;
    unsigned SSP2CLKPPS1        : 1;
    unsigned SSP2CLKPPS2        : 1;
    unsigned SSP2CLKPPS3        : 1;
    unsigned SSP2CLKPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP2CLKPPS         : 5;
    unsigned                    : 3;
    };
  } __SSP2CLKPPSbits_t;

extern __at(0x0EC8) volatile __SSP2CLKPPSbits_t SSP2CLKPPSbits;

#define _SSP2CLKPPS0            0x01
#define _SSP2CLKPPS1            0x02
#define _SSP2CLKPPS2            0x04
#define _SSP2CLKPPS3            0x08
#define _SSP2CLKPPS4            0x10

//==============================================================================


//==============================================================================
//        SSP2DATPPS Bits

extern __at(0x0EC9) __sfr SSP2DATPPS;

typedef union
  {
  struct
    {
    unsigned SSP2DATPPS0        : 1;
    unsigned SSP2DATPPS1        : 1;
    unsigned SSP2DATPPS2        : 1;
    unsigned SSP2DATPPS3        : 1;
    unsigned SSP2DATPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP2DATPPS         : 5;
    unsigned                    : 3;
    };
  } __SSP2DATPPSbits_t;

extern __at(0x0EC9) volatile __SSP2DATPPSbits_t SSP2DATPPSbits;

#define _SSP2DATPPS0            0x01
#define _SSP2DATPPS1            0x02
#define _SSP2DATPPS2            0x04
#define _SSP2DATPPS3            0x08
#define _SSP2DATPPS4            0x10

//==============================================================================


//==============================================================================
//        SSP2SSPPS Bits

extern __at(0x0ECA) __sfr SSP2SSPPS;

typedef union
  {
  struct
    {
    unsigned SSP2SSPPS0         : 1;
    unsigned SSP2SSPPS1         : 1;
    unsigned SSP2SSPPS2         : 1;
    unsigned SSP2SSPPS3         : 1;
    unsigned SSP2SSPPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP2SSPPS          : 5;
    unsigned                    : 3;
    };
  } __SSP2SSPPSbits_t;

extern __at(0x0ECA) volatile __SSP2SSPPSbits_t SSP2SSPPSbits;

#define _SSP2SSPPS0             0x01
#define _SSP2SSPPS1             0x02
#define _SSP2SSPPS2             0x04
#define _SSP2SSPPS3             0x08
#define _SSP2SSPPS4             0x10

//==============================================================================


//==============================================================================
//        RXPPS Bits

extern __at(0x0ECB) __sfr RXPPS;

typedef union
  {
  struct
    {
    unsigned RXPPS0             : 1;
    unsigned RXPPS1             : 1;
    unsigned RXPPS2             : 1;
    unsigned RXPPS3             : 1;
    unsigned RXPPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RXPPS              : 5;
    unsigned                    : 3;
    };
  } __RXPPSbits_t;

extern __at(0x0ECB) volatile __RXPPSbits_t RXPPSbits;

#define _RXPPS0                 0x01
#define _RXPPS1                 0x02
#define _RXPPS2                 0x04
#define _RXPPS3                 0x08
#define _RXPPS4                 0x10

//==============================================================================


//==============================================================================
//        TXPPS Bits

extern __at(0x0ECC) __sfr TXPPS;

typedef union
  {
  struct
    {
    unsigned TXPPS0             : 1;
    unsigned TXPPS1             : 1;
    unsigned TXPPS2             : 1;
    unsigned TXPPS3             : 1;
    unsigned TXPPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TXPPS              : 5;
    unsigned                    : 3;
    };
  } __TXPPSbits_t;

extern __at(0x0ECC) volatile __TXPPSbits_t TXPPSbits;

#define _TXPPS0                 0x01
#define _TXPPS1                 0x02
#define _TXPPS2                 0x04
#define _TXPPS3                 0x08
#define _TXPPS4                 0x10

//==============================================================================


//==============================================================================
//        RA0PPS Bits

extern __at(0x0F10) __sfr RA0PPS;

typedef union
  {
  struct
    {
    unsigned RA0PPS0            : 1;
    unsigned RA0PPS1            : 1;
    unsigned RA0PPS2            : 1;
    unsigned RA0PPS3            : 1;
    unsigned RA0PPS4            : 1;
    unsigned RA0PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA0PPS             : 6;
    unsigned                    : 2;
    };
  } __RA0PPSbits_t;

extern __at(0x0F10) volatile __RA0PPSbits_t RA0PPSbits;

#define _RA0PPS0                0x01
#define _RA0PPS1                0x02
#define _RA0PPS2                0x04
#define _RA0PPS3                0x08
#define _RA0PPS4                0x10
#define _RA0PPS5                0x20

//==============================================================================


//==============================================================================
//        RA1PPS Bits

extern __at(0x0F11) __sfr RA1PPS;

typedef union
  {
  struct
    {
    unsigned RA1PPS0            : 1;
    unsigned RA1PPS1            : 1;
    unsigned RA1PPS2            : 1;
    unsigned RA1PPS3            : 1;
    unsigned RA1PPS4            : 1;
    unsigned RA1PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA1PPS             : 6;
    unsigned                    : 2;
    };
  } __RA1PPSbits_t;

extern __at(0x0F11) volatile __RA1PPSbits_t RA1PPSbits;

#define _RA1PPS0                0x01
#define _RA1PPS1                0x02
#define _RA1PPS2                0x04
#define _RA1PPS3                0x08
#define _RA1PPS4                0x10
#define _RA1PPS5                0x20

//==============================================================================


//==============================================================================
//        RA2PPS Bits

extern __at(0x0F12) __sfr RA2PPS;

typedef union
  {
  struct
    {
    unsigned RA2PPS0            : 1;
    unsigned RA2PPS1            : 1;
    unsigned RA2PPS2            : 1;
    unsigned RA2PPS3            : 1;
    unsigned RA2PPS4            : 1;
    unsigned RA2PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA2PPS             : 6;
    unsigned                    : 2;
    };
  } __RA2PPSbits_t;

extern __at(0x0F12) volatile __RA2PPSbits_t RA2PPSbits;

#define _RA2PPS0                0x01
#define _RA2PPS1                0x02
#define _RA2PPS2                0x04
#define _RA2PPS3                0x08
#define _RA2PPS4                0x10
#define _RA2PPS5                0x20

//==============================================================================


//==============================================================================
//        RA3PPS Bits

extern __at(0x0F13) __sfr RA3PPS;

typedef union
  {
  struct
    {
    unsigned RA3PPS0            : 1;
    unsigned RA3PPS1            : 1;
    unsigned RA3PPS2            : 1;
    unsigned RA3PPS3            : 1;
    unsigned RA3PPS4            : 1;
    unsigned RA3PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA3PPS             : 6;
    unsigned                    : 2;
    };
  } __RA3PPSbits_t;

extern __at(0x0F13) volatile __RA3PPSbits_t RA3PPSbits;

#define _RA3PPS0                0x01
#define _RA3PPS1                0x02
#define _RA3PPS2                0x04
#define _RA3PPS3                0x08
#define _RA3PPS4                0x10
#define _RA3PPS5                0x20

//==============================================================================


//==============================================================================
//        RA4PPS Bits

extern __at(0x0F14) __sfr RA4PPS;

typedef union
  {
  struct
    {
    unsigned RA4PPS0            : 1;
    unsigned RA4PPS1            : 1;
    unsigned RA4PPS2            : 1;
    unsigned RA4PPS3            : 1;
    unsigned RA4PPS4            : 1;
    unsigned RA4PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA4PPS             : 6;
    unsigned                    : 2;
    };
  } __RA4PPSbits_t;

extern __at(0x0F14) volatile __RA4PPSbits_t RA4PPSbits;

#define _RA4PPS0                0x01
#define _RA4PPS1                0x02
#define _RA4PPS2                0x04
#define _RA4PPS3                0x08
#define _RA4PPS4                0x10
#define _RA4PPS5                0x20

//==============================================================================


//==============================================================================
//        RA5PPS Bits

extern __at(0x0F15) __sfr RA5PPS;

typedef union
  {
  struct
    {
    unsigned RA5PPS0            : 1;
    unsigned RA5PPS1            : 1;
    unsigned RA5PPS2            : 1;
    unsigned RA5PPS3            : 1;
    unsigned RA5PPS4            : 1;
    unsigned RA5PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA5PPS             : 6;
    unsigned                    : 2;
    };
  } __RA5PPSbits_t;

extern __at(0x0F15) volatile __RA5PPSbits_t RA5PPSbits;

#define _RA5PPS0                0x01
#define _RA5PPS1                0x02
#define _RA5PPS2                0x04
#define _RA5PPS3                0x08
#define _RA5PPS4                0x10
#define _RA5PPS5                0x20

//==============================================================================


//==============================================================================
//        RA6PPS Bits

extern __at(0x0F16) __sfr RA6PPS;

typedef union
  {
  struct
    {
    unsigned RA6PPS0            : 1;
    unsigned RA6PPS1            : 1;
    unsigned RA6PPS2            : 1;
    unsigned RA6PPS3            : 1;
    unsigned RA6PPS4            : 1;
    unsigned RA6PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA6PPS             : 6;
    unsigned                    : 2;
    };
  } __RA6PPSbits_t;

extern __at(0x0F16) volatile __RA6PPSbits_t RA6PPSbits;

#define _RA6PPS0                0x01
#define _RA6PPS1                0x02
#define _RA6PPS2                0x04
#define _RA6PPS3                0x08
#define _RA6PPS4                0x10
#define _RA6PPS5                0x20

//==============================================================================


//==============================================================================
//        RA7PPS Bits

extern __at(0x0F17) __sfr RA7PPS;

typedef union
  {
  struct
    {
    unsigned RA7PPS0            : 1;
    unsigned RA7PPS1            : 1;
    unsigned RA7PPS2            : 1;
    unsigned RA7PPS3            : 1;
    unsigned RA7PPS4            : 1;
    unsigned RA7PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA7PPS             : 6;
    unsigned                    : 2;
    };
  } __RA7PPSbits_t;

extern __at(0x0F17) volatile __RA7PPSbits_t RA7PPSbits;

#define _RA7PPS0                0x01
#define _RA7PPS1                0x02
#define _RA7PPS2                0x04
#define _RA7PPS3                0x08
#define _RA7PPS4                0x10
#define _RA7PPS5                0x20

//==============================================================================


//==============================================================================
//        RB0PPS Bits

extern __at(0x0F18) __sfr RB0PPS;

typedef union
  {
  struct
    {
    unsigned RB0PPS0            : 1;
    unsigned RB0PPS1            : 1;
    unsigned RB0PPS2            : 1;
    unsigned RB0PPS3            : 1;
    unsigned RB0PPS4            : 1;
    unsigned RB0PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB0PPS             : 6;
    unsigned                    : 2;
    };
  } __RB0PPSbits_t;

extern __at(0x0F18) volatile __RB0PPSbits_t RB0PPSbits;

#define _RB0PPS0                0x01
#define _RB0PPS1                0x02
#define _RB0PPS2                0x04
#define _RB0PPS3                0x08
#define _RB0PPS4                0x10
#define _RB0PPS5                0x20

//==============================================================================


//==============================================================================
//        RB1PPS Bits

extern __at(0x0F19) __sfr RB1PPS;

typedef union
  {
  struct
    {
    unsigned RB1PPS0            : 1;
    unsigned RB1PPS1            : 1;
    unsigned RB1PPS2            : 1;
    unsigned RB1PPS3            : 1;
    unsigned RB1PPS4            : 1;
    unsigned RB1PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB1PPS             : 6;
    unsigned                    : 2;
    };
  } __RB1PPSbits_t;

extern __at(0x0F19) volatile __RB1PPSbits_t RB1PPSbits;

#define _RB1PPS0                0x01
#define _RB1PPS1                0x02
#define _RB1PPS2                0x04
#define _RB1PPS3                0x08
#define _RB1PPS4                0x10
#define _RB1PPS5                0x20

//==============================================================================


//==============================================================================
//        RB2PPS Bits

extern __at(0x0F1A) __sfr RB2PPS;

typedef union
  {
  struct
    {
    unsigned RB2PPS0            : 1;
    unsigned RB2PPS1            : 1;
    unsigned RB2PPS2            : 1;
    unsigned RB2PPS3            : 1;
    unsigned RB2PPS4            : 1;
    unsigned RB2PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB2PPS             : 6;
    unsigned                    : 2;
    };
  } __RB2PPSbits_t;

extern __at(0x0F1A) volatile __RB2PPSbits_t RB2PPSbits;

#define _RB2PPS0                0x01
#define _RB2PPS1                0x02
#define _RB2PPS2                0x04
#define _RB2PPS3                0x08
#define _RB2PPS4                0x10
#define _RB2PPS5                0x20

//==============================================================================


//==============================================================================
//        RB3PPS Bits

extern __at(0x0F1B) __sfr RB3PPS;

typedef union
  {
  struct
    {
    unsigned RB3PPS0            : 1;
    unsigned RB3PPS1            : 1;
    unsigned RB3PPS2            : 1;
    unsigned RB3PPS3            : 1;
    unsigned RB3PPS4            : 1;
    unsigned RB3PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB3PPS             : 6;
    unsigned                    : 2;
    };
  } __RB3PPSbits_t;

extern __at(0x0F1B) volatile __RB3PPSbits_t RB3PPSbits;

#define _RB3PPS0                0x01
#define _RB3PPS1                0x02
#define _RB3PPS2                0x04
#define _RB3PPS3                0x08
#define _RB3PPS4                0x10
#define _RB3PPS5                0x20

//==============================================================================


//==============================================================================
//        RB4PPS Bits

extern __at(0x0F1C) __sfr RB4PPS;

typedef union
  {
  struct
    {
    unsigned RB4PPS0            : 1;
    unsigned RB4PPS1            : 1;
    unsigned RB4PPS2            : 1;
    unsigned RB4PPS3            : 1;
    unsigned RB4PPS4            : 1;
    unsigned RB4PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB4PPS             : 6;
    unsigned                    : 2;
    };
  } __RB4PPSbits_t;

extern __at(0x0F1C) volatile __RB4PPSbits_t RB4PPSbits;

#define _RB4PPS0                0x01
#define _RB4PPS1                0x02
#define _RB4PPS2                0x04
#define _RB4PPS3                0x08
#define _RB4PPS4                0x10
#define _RB4PPS5                0x20

//==============================================================================


//==============================================================================
//        RB5PPS Bits

extern __at(0x0F1D) __sfr RB5PPS;

typedef union
  {
  struct
    {
    unsigned RB5PPS0            : 1;
    unsigned RB5PPS1            : 1;
    unsigned RB5PPS2            : 1;
    unsigned RB5PPS3            : 1;
    unsigned RB5PPS4            : 1;
    unsigned RB5PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB5PPS             : 6;
    unsigned                    : 2;
    };
  } __RB5PPSbits_t;

extern __at(0x0F1D) volatile __RB5PPSbits_t RB5PPSbits;

#define _RB5PPS0                0x01
#define _RB5PPS1                0x02
#define _RB5PPS2                0x04
#define _RB5PPS3                0x08
#define _RB5PPS4                0x10
#define _RB5PPS5                0x20

//==============================================================================


//==============================================================================
//        RB6PPS Bits

extern __at(0x0F1E) __sfr RB6PPS;

typedef union
  {
  struct
    {
    unsigned RB6PPS0            : 1;
    unsigned RB6PPS1            : 1;
    unsigned RB6PPS2            : 1;
    unsigned RB6PPS3            : 1;
    unsigned RB6PPS4            : 1;
    unsigned RB6PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB6PPS             : 6;
    unsigned                    : 2;
    };
  } __RB6PPSbits_t;

extern __at(0x0F1E) volatile __RB6PPSbits_t RB6PPSbits;

#define _RB6PPS0                0x01
#define _RB6PPS1                0x02
#define _RB6PPS2                0x04
#define _RB6PPS3                0x08
#define _RB6PPS4                0x10
#define _RB6PPS5                0x20

//==============================================================================


//==============================================================================
//        RB7PPS Bits

extern __at(0x0F1F) __sfr RB7PPS;

typedef union
  {
  struct
    {
    unsigned RB7PPS0            : 1;
    unsigned RB7PPS1            : 1;
    unsigned RB7PPS2            : 1;
    unsigned RB7PPS3            : 1;
    unsigned RB7PPS4            : 1;
    unsigned RB7PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB7PPS             : 6;
    unsigned                    : 2;
    };
  } __RB7PPSbits_t;

extern __at(0x0F1F) volatile __RB7PPSbits_t RB7PPSbits;

#define _RB7PPS0                0x01
#define _RB7PPS1                0x02
#define _RB7PPS2                0x04
#define _RB7PPS3                0x08
#define _RB7PPS4                0x10
#define _RB7PPS5                0x20

//==============================================================================


//==============================================================================
//        RC0PPS Bits

extern __at(0x0F20) __sfr RC0PPS;

typedef union
  {
  struct
    {
    unsigned RC0PPS0            : 1;
    unsigned RC0PPS1            : 1;
    unsigned RC0PPS2            : 1;
    unsigned RC0PPS3            : 1;
    unsigned RC0PPS4            : 1;
    unsigned RC0PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC0PPS             : 6;
    unsigned                    : 2;
    };
  } __RC0PPSbits_t;

extern __at(0x0F20) volatile __RC0PPSbits_t RC0PPSbits;

#define _RC0PPS0                0x01
#define _RC0PPS1                0x02
#define _RC0PPS2                0x04
#define _RC0PPS3                0x08
#define _RC0PPS4                0x10
#define _RC0PPS5                0x20

//==============================================================================


//==============================================================================
//        RC1PPS Bits

extern __at(0x0F21) __sfr RC1PPS;

typedef union
  {
  struct
    {
    unsigned RC1PPS0            : 1;
    unsigned RC1PPS1            : 1;
    unsigned RC1PPS2            : 1;
    unsigned RC1PPS3            : 1;
    unsigned RC1PPS4            : 1;
    unsigned RC1PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC1PPS             : 6;
    unsigned                    : 2;
    };
  } __RC1PPSbits_t;

extern __at(0x0F21) volatile __RC1PPSbits_t RC1PPSbits;

#define _RC1PPS0                0x01
#define _RC1PPS1                0x02
#define _RC1PPS2                0x04
#define _RC1PPS3                0x08
#define _RC1PPS4                0x10
#define _RC1PPS5                0x20

//==============================================================================


//==============================================================================
//        RC2PPS Bits

extern __at(0x0F22) __sfr RC2PPS;

typedef union
  {
  struct
    {
    unsigned RC2PPS0            : 1;
    unsigned RC2PPS1            : 1;
    unsigned RC2PPS2            : 1;
    unsigned RC2PPS3            : 1;
    unsigned RC2PPS4            : 1;
    unsigned RC2PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC2PPS             : 6;
    unsigned                    : 2;
    };
  } __RC2PPSbits_t;

extern __at(0x0F22) volatile __RC2PPSbits_t RC2PPSbits;

#define _RC2PPS0                0x01
#define _RC2PPS1                0x02
#define _RC2PPS2                0x04
#define _RC2PPS3                0x08
#define _RC2PPS4                0x10
#define _RC2PPS5                0x20

//==============================================================================


//==============================================================================
//        RC3PPS Bits

extern __at(0x0F23) __sfr RC3PPS;

typedef union
  {
  struct
    {
    unsigned RC3PPS0            : 1;
    unsigned RC3PPS1            : 1;
    unsigned RC3PPS2            : 1;
    unsigned RC3PPS3            : 1;
    unsigned RC3PPS4            : 1;
    unsigned RC3PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC3PPS             : 6;
    unsigned                    : 2;
    };
  } __RC3PPSbits_t;

extern __at(0x0F23) volatile __RC3PPSbits_t RC3PPSbits;

#define _RC3PPS0                0x01
#define _RC3PPS1                0x02
#define _RC3PPS2                0x04
#define _RC3PPS3                0x08
#define _RC3PPS4                0x10
#define _RC3PPS5                0x20

//==============================================================================


//==============================================================================
//        RC4PPS Bits

extern __at(0x0F24) __sfr RC4PPS;

typedef union
  {
  struct
    {
    unsigned RC4PPS0            : 1;
    unsigned RC4PPS1            : 1;
    unsigned RC4PPS2            : 1;
    unsigned RC4PPS3            : 1;
    unsigned RC4PPS4            : 1;
    unsigned RC4PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC4PPS             : 6;
    unsigned                    : 2;
    };
  } __RC4PPSbits_t;

extern __at(0x0F24) volatile __RC4PPSbits_t RC4PPSbits;

#define _RC4PPS0                0x01
#define _RC4PPS1                0x02
#define _RC4PPS2                0x04
#define _RC4PPS3                0x08
#define _RC4PPS4                0x10
#define _RC4PPS5                0x20

//==============================================================================


//==============================================================================
//        RC5PPS Bits

extern __at(0x0F25) __sfr RC5PPS;

typedef union
  {
  struct
    {
    unsigned RC5PPS0            : 1;
    unsigned RC5PPS1            : 1;
    unsigned RC5PPS2            : 1;
    unsigned RC5PPS3            : 1;
    unsigned RC5PPS4            : 1;
    unsigned RC5PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC5PPS             : 6;
    unsigned                    : 2;
    };
  } __RC5PPSbits_t;

extern __at(0x0F25) volatile __RC5PPSbits_t RC5PPSbits;

#define _RC5PPS0                0x01
#define _RC5PPS1                0x02
#define _RC5PPS2                0x04
#define _RC5PPS3                0x08
#define _RC5PPS4                0x10
#define _RC5PPS5                0x20

//==============================================================================


//==============================================================================
//        RC6PPS Bits

extern __at(0x0F26) __sfr RC6PPS;

typedef union
  {
  struct
    {
    unsigned RC6PPS0            : 1;
    unsigned RC6PPS1            : 1;
    unsigned RC6PPS2            : 1;
    unsigned RC6PPS3            : 1;
    unsigned RC6PPS4            : 1;
    unsigned RC6PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC6PPS             : 6;
    unsigned                    : 2;
    };
  } __RC6PPSbits_t;

extern __at(0x0F26) volatile __RC6PPSbits_t RC6PPSbits;

#define _RC6PPS0                0x01
#define _RC6PPS1                0x02
#define _RC6PPS2                0x04
#define _RC6PPS3                0x08
#define _RC6PPS4                0x10
#define _RC6PPS5                0x20

//==============================================================================


//==============================================================================
//        RC7PPS Bits

extern __at(0x0F27) __sfr RC7PPS;

typedef union
  {
  struct
    {
    unsigned RC7PPS0            : 1;
    unsigned RC7PPS1            : 1;
    unsigned RC7PPS2            : 1;
    unsigned RC7PPS3            : 1;
    unsigned RC7PPS4            : 1;
    unsigned RC7PPS5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC7PPS             : 6;
    unsigned                    : 2;
    };
  } __RC7PPSbits_t;

extern __at(0x0F27) volatile __RC7PPSbits_t RC7PPSbits;

#define _RC7PPS0                0x01
#define _RC7PPS1                0x02
#define _RC7PPS2                0x04
#define _RC7PPS3                0x08
#define _RC7PPS4                0x10
#define _RC7PPS5                0x20

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x0F38) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned ANSA3                : 1;
  unsigned ANSA4                : 1;
  unsigned ANSA5                : 1;
  unsigned ANSA6                : 1;
  unsigned ANSA7                : 1;
  } __ANSELAbits_t;

extern __at(0x0F38) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA3                  0x08
#define _ANSA4                  0x10
#define _ANSA5                  0x20
#define _ANSA6                  0x40
#define _ANSA7                  0x80

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x0F39) __sfr WPUA;

typedef struct
  {
  unsigned WPUA0                : 1;
  unsigned WPUA1                : 1;
  unsigned WPUA2                : 1;
  unsigned WPUA3                : 1;
  unsigned WPUA4                : 1;
  unsigned WPUA5                : 1;
  unsigned WPUA6                : 1;
  unsigned WPUA7                : 1;
  } __WPUAbits_t;

extern __at(0x0F39) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20
#define _WPUA6                  0x40
#define _WPUA7                  0x80

//==============================================================================


//==============================================================================
//        ODCONA Bits

extern __at(0x0F3A) __sfr ODCONA;

typedef struct
  {
  unsigned ODCA0                : 1;
  unsigned ODCA1                : 1;
  unsigned ODCA2                : 1;
  unsigned ODCA3                : 1;
  unsigned ODCA4                : 1;
  unsigned ODCA5                : 1;
  unsigned ODCA6                : 1;
  unsigned ODCA7                : 1;
  } __ODCONAbits_t;

extern __at(0x0F3A) volatile __ODCONAbits_t ODCONAbits;

#define _ODCA0                  0x01
#define _ODCA1                  0x02
#define _ODCA2                  0x04
#define _ODCA3                  0x08
#define _ODCA4                  0x10
#define _ODCA5                  0x20
#define _ODCA6                  0x40
#define _ODCA7                  0x80

//==============================================================================


//==============================================================================
//        SLRCONA Bits

extern __at(0x0F3B) __sfr SLRCONA;

typedef struct
  {
  unsigned SLRA0                : 1;
  unsigned SLRA1                : 1;
  unsigned SLRA2                : 1;
  unsigned SLRA3                : 1;
  unsigned SLRA4                : 1;
  unsigned SLRA5                : 1;
  unsigned SLRA6                : 1;
  unsigned SLRA7                : 1;
  } __SLRCONAbits_t;

extern __at(0x0F3B) volatile __SLRCONAbits_t SLRCONAbits;

#define _SLRA0                  0x01
#define _SLRA1                  0x02
#define _SLRA2                  0x04
#define _SLRA3                  0x08
#define _SLRA4                  0x10
#define _SLRA5                  0x20
#define _SLRA6                  0x40
#define _SLRA7                  0x80

//==============================================================================


//==============================================================================
//        INLVLA Bits

extern __at(0x0F3C) __sfr INLVLA;

typedef struct
  {
  unsigned INLVLA0              : 1;
  unsigned INLVLA1              : 1;
  unsigned INLVLA2              : 1;
  unsigned INLVLA3              : 1;
  unsigned INLVLA4              : 1;
  unsigned INLVLA5              : 1;
  unsigned INLVLA6              : 1;
  unsigned INLVLA7              : 1;
  } __INLVLAbits_t;

extern __at(0x0F3C) volatile __INLVLAbits_t INLVLAbits;

#define _INLVLA0                0x01
#define _INLVLA1                0x02
#define _INLVLA2                0x04
#define _INLVLA3                0x08
#define _INLVLA4                0x10
#define _INLVLA5                0x20
#define _INLVLA6                0x40
#define _INLVLA7                0x80

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0F3D) __sfr IOCAP;

typedef struct
  {
  unsigned IOCAP0               : 1;
  unsigned IOCAP1               : 1;
  unsigned IOCAP2               : 1;
  unsigned IOCAP3               : 1;
  unsigned IOCAP4               : 1;
  unsigned IOCAP5               : 1;
  unsigned IOCAP6               : 1;
  unsigned IOCAP7               : 1;
  } __IOCAPbits_t;

extern __at(0x0F3D) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20
#define _IOCAP6                 0x40
#define _IOCAP7                 0x80

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0F3E) __sfr IOCAN;

typedef struct
  {
  unsigned IOCAN0               : 1;
  unsigned IOCAN1               : 1;
  unsigned IOCAN2               : 1;
  unsigned IOCAN3               : 1;
  unsigned IOCAN4               : 1;
  unsigned IOCAN5               : 1;
  unsigned IOCAN6               : 1;
  unsigned IOCAN7               : 1;
  } __IOCANbits_t;

extern __at(0x0F3E) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20
#define _IOCAN6                 0x40
#define _IOCAN7                 0x80

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0F3F) __sfr IOCAF;

typedef struct
  {
  unsigned IOCAF0               : 1;
  unsigned IOCAF1               : 1;
  unsigned IOCAF2               : 1;
  unsigned IOCAF3               : 1;
  unsigned IOCAF4               : 1;
  unsigned IOCAF5               : 1;
  unsigned IOCAF6               : 1;
  unsigned IOCAF7               : 1;
  } __IOCAFbits_t;

extern __at(0x0F3F) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20
#define _IOCAF6                 0x40
#define _IOCAF7                 0x80

//==============================================================================


//==============================================================================
//        CCDNA Bits

extern __at(0x0F40) __sfr CCDNA;

typedef struct
  {
  unsigned CCDNA0               : 1;
  unsigned CCDNA1               : 1;
  unsigned CCDNA2               : 1;
  unsigned CCDNA3               : 1;
  unsigned CCDNA4               : 1;
  unsigned CCDNA5               : 1;
  unsigned CCDNA6               : 1;
  unsigned CCDNA7               : 1;
  } __CCDNAbits_t;

extern __at(0x0F40) volatile __CCDNAbits_t CCDNAbits;

#define _CCDNA0                 0x01
#define _CCDNA1                 0x02
#define _CCDNA2                 0x04
#define _CCDNA3                 0x08
#define _CCDNA4                 0x10
#define _CCDNA5                 0x20
#define _CCDNA6                 0x40
#define _CCDNA7                 0x80

//==============================================================================


//==============================================================================
//        CCDPA Bits

extern __at(0x0F41) __sfr CCDPA;

typedef struct
  {
  unsigned CCDPA0               : 1;
  unsigned CCDPA1               : 1;
  unsigned CCDPA2               : 1;
  unsigned CCDPA3               : 1;
  unsigned CCDPA4               : 1;
  unsigned CCDPA5               : 1;
  unsigned CCDPA6               : 1;
  unsigned CCDPA7               : 1;
  } __CCDPAbits_t;

extern __at(0x0F41) volatile __CCDPAbits_t CCDPAbits;

#define _CCDPA0                 0x01
#define _CCDPA1                 0x02
#define _CCDPA2                 0x04
#define _CCDPA3                 0x08
#define _CCDPA4                 0x10
#define _CCDPA5                 0x20
#define _CCDPA6                 0x40
#define _CCDPA7                 0x80

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x0F43) __sfr ANSELB;

typedef struct
  {
  unsigned ANSB0                : 1;
  unsigned ANSB1                : 1;
  unsigned ANSB2                : 1;
  unsigned ANSB3                : 1;
  unsigned ANSB4                : 1;
  unsigned ANSB5                : 1;
  unsigned ANSB6                : 1;
  unsigned ANSB7                : 1;
  } __ANSELBbits_t;

extern __at(0x0F43) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB0                  0x01
#define _ANSB1                  0x02
#define _ANSB2                  0x04
#define _ANSB3                  0x08
#define _ANSB4                  0x10
#define _ANSB5                  0x20
#define _ANSB6                  0x40
#define _ANSB7                  0x80

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x0F44) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x0F44) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        ODCONB Bits

extern __at(0x0F45) __sfr ODCONB;

typedef struct
  {
  unsigned ODCB0                : 1;
  unsigned ODCB1                : 1;
  unsigned ODCB2                : 1;
  unsigned ODCB3                : 1;
  unsigned ODCB4                : 1;
  unsigned ODCB5                : 1;
  unsigned ODCB6                : 1;
  unsigned ODCB7                : 1;
  } __ODCONBbits_t;

extern __at(0x0F45) volatile __ODCONBbits_t ODCONBbits;

#define _ODCB0                  0x01
#define _ODCB1                  0x02
#define _ODCB2                  0x04
#define _ODCB3                  0x08
#define _ODCB4                  0x10
#define _ODCB5                  0x20
#define _ODCB6                  0x40
#define _ODCB7                  0x80

//==============================================================================


//==============================================================================
//        SLRCONB Bits

extern __at(0x0F46) __sfr SLRCONB;

typedef struct
  {
  unsigned SLRB0                : 1;
  unsigned SLRB1                : 1;
  unsigned SLRB2                : 1;
  unsigned SLRB3                : 1;
  unsigned SLRB4                : 1;
  unsigned SLRB5                : 1;
  unsigned SLRB6                : 1;
  unsigned SLRB7                : 1;
  } __SLRCONBbits_t;

extern __at(0x0F46) volatile __SLRCONBbits_t SLRCONBbits;

#define _SLRB0                  0x01
#define _SLRB1                  0x02
#define _SLRB2                  0x04
#define _SLRB3                  0x08
#define _SLRB4                  0x10
#define _SLRB5                  0x20
#define _SLRB6                  0x40
#define _SLRB7                  0x80

//==============================================================================


//==============================================================================
//        INLVLB Bits

extern __at(0x0F47) __sfr INLVLB;

typedef struct
  {
  unsigned INLVLB0              : 1;
  unsigned INLVLB1              : 1;
  unsigned INLVLB2              : 1;
  unsigned INLVLB3              : 1;
  unsigned INLVLB4              : 1;
  unsigned INLVLB5              : 1;
  unsigned INLVLB6              : 1;
  unsigned INLVLB7              : 1;
  } __INLVLBbits_t;

extern __at(0x0F47) volatile __INLVLBbits_t INLVLBbits;

#define _INLVLB0                0x01
#define _INLVLB1                0x02
#define _INLVLB2                0x04
#define _INLVLB3                0x08
#define _INLVLB4                0x10
#define _INLVLB5                0x20
#define _INLVLB6                0x40
#define _INLVLB7                0x80

//==============================================================================


//==============================================================================
//        IOCBP Bits

extern __at(0x0F48) __sfr IOCBP;

typedef struct
  {
  unsigned IOCBP0               : 1;
  unsigned IOCBP1               : 1;
  unsigned IOCBP2               : 1;
  unsigned IOCBP3               : 1;
  unsigned IOCBP4               : 1;
  unsigned IOCBP5               : 1;
  unsigned IOCBP6               : 1;
  unsigned IOCBP7               : 1;
  } __IOCBPbits_t;

extern __at(0x0F48) volatile __IOCBPbits_t IOCBPbits;

#define _IOCBP0                 0x01
#define _IOCBP1                 0x02
#define _IOCBP2                 0x04
#define _IOCBP3                 0x08
#define _IOCBP4                 0x10
#define _IOCBP5                 0x20
#define _IOCBP6                 0x40
#define _IOCBP7                 0x80

//==============================================================================


//==============================================================================
//        IOCBN Bits

extern __at(0x0F49) __sfr IOCBN;

typedef struct
  {
  unsigned IOCBN0               : 1;
  unsigned IOCBN1               : 1;
  unsigned IOCBN2               : 1;
  unsigned IOCBN3               : 1;
  unsigned IOCBN4               : 1;
  unsigned IOCBN5               : 1;
  unsigned IOCBN6               : 1;
  unsigned IOCBN7               : 1;
  } __IOCBNbits_t;

extern __at(0x0F49) volatile __IOCBNbits_t IOCBNbits;

#define _IOCBN0                 0x01
#define _IOCBN1                 0x02
#define _IOCBN2                 0x04
#define _IOCBN3                 0x08
#define _IOCBN4                 0x10
#define _IOCBN5                 0x20
#define _IOCBN6                 0x40
#define _IOCBN7                 0x80

//==============================================================================


//==============================================================================
//        IOCBF Bits

extern __at(0x0F4A) __sfr IOCBF;

typedef struct
  {
  unsigned IOCBF0               : 1;
  unsigned IOCBF1               : 1;
  unsigned IOCBF2               : 1;
  unsigned IOCBF3               : 1;
  unsigned IOCBF4               : 1;
  unsigned IOCBF5               : 1;
  unsigned IOCBF6               : 1;
  unsigned IOCBF7               : 1;
  } __IOCBFbits_t;

extern __at(0x0F4A) volatile __IOCBFbits_t IOCBFbits;

#define _IOCBF0                 0x01
#define _IOCBF1                 0x02
#define _IOCBF2                 0x04
#define _IOCBF3                 0x08
#define _IOCBF4                 0x10
#define _IOCBF5                 0x20
#define _IOCBF6                 0x40
#define _IOCBF7                 0x80

//==============================================================================


//==============================================================================
//        CCDNB Bits

extern __at(0x0F4B) __sfr CCDNB;

typedef struct
  {
  unsigned CCDNB0               : 1;
  unsigned CCDNB1               : 1;
  unsigned CCDNB2               : 1;
  unsigned CCDNB3               : 1;
  unsigned CCDNB4               : 1;
  unsigned CCDNB5               : 1;
  unsigned CCDNB6               : 1;
  unsigned CCDNB7               : 1;
  } __CCDNBbits_t;

extern __at(0x0F4B) volatile __CCDNBbits_t CCDNBbits;

#define _CCDNB0                 0x01
#define _CCDNB1                 0x02
#define _CCDNB2                 0x04
#define _CCDNB3                 0x08
#define _CCDNB4                 0x10
#define _CCDNB5                 0x20
#define _CCDNB6                 0x40
#define _CCDNB7                 0x80

//==============================================================================


//==============================================================================
//        CCDPB Bits

extern __at(0x0F4C) __sfr CCDPB;

typedef struct
  {
  unsigned CCDPB0               : 1;
  unsigned CCDPB1               : 1;
  unsigned CCDPB2               : 1;
  unsigned CCDPB3               : 1;
  unsigned CCDPB4               : 1;
  unsigned CCDPB5               : 1;
  unsigned CCDPB6               : 1;
  unsigned CCDPB7               : 1;
  } __CCDPBbits_t;

extern __at(0x0F4C) volatile __CCDPBbits_t CCDPBbits;

#define _CCDPB0                 0x01
#define _CCDPB1                 0x02
#define _CCDPB2                 0x04
#define _CCDPB3                 0x08
#define _CCDPB4                 0x10
#define _CCDPB5                 0x20
#define _CCDPB6                 0x40
#define _CCDPB7                 0x80

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x0F4E) __sfr ANSELC;

typedef struct
  {
  unsigned ANSC0                : 1;
  unsigned ANSC1                : 1;
  unsigned ANSC2                : 1;
  unsigned ANSC3                : 1;
  unsigned ANSC4                : 1;
  unsigned ANSC5                : 1;
  unsigned ANSC6                : 1;
  unsigned ANSC7                : 1;
  } __ANSELCbits_t;

extern __at(0x0F4E) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC0                  0x01
#define _ANSC1                  0x02
#define _ANSC2                  0x04
#define _ANSC3                  0x08
#define _ANSC4                  0x10
#define _ANSC5                  0x20
#define _ANSC6                  0x40
#define _ANSC7                  0x80

//==============================================================================


//==============================================================================
//        WPUC Bits

extern __at(0x0F4F) __sfr WPUC;

typedef struct
  {
  unsigned WPUC0                : 1;
  unsigned WPUC1                : 1;
  unsigned WPUC2                : 1;
  unsigned WPUC3                : 1;
  unsigned WPUC4                : 1;
  unsigned WPUC5                : 1;
  unsigned WPUC6                : 1;
  unsigned WPUC7                : 1;
  } __WPUCbits_t;

extern __at(0x0F4F) volatile __WPUCbits_t WPUCbits;

#define _WPUC0                  0x01
#define _WPUC1                  0x02
#define _WPUC2                  0x04
#define _WPUC3                  0x08
#define _WPUC4                  0x10
#define _WPUC5                  0x20
#define _WPUC6                  0x40
#define _WPUC7                  0x80

//==============================================================================


//==============================================================================
//        ODCONC Bits

extern __at(0x0F50) __sfr ODCONC;

typedef struct
  {
  unsigned ODCC0                : 1;
  unsigned ODCC1                : 1;
  unsigned ODCC2                : 1;
  unsigned ODCC3                : 1;
  unsigned ODCC4                : 1;
  unsigned ODCC5                : 1;
  unsigned ODCC6                : 1;
  unsigned ODCC7                : 1;
  } __ODCONCbits_t;

extern __at(0x0F50) volatile __ODCONCbits_t ODCONCbits;

#define _ODCC0                  0x01
#define _ODCC1                  0x02
#define _ODCC2                  0x04
#define _ODCC3                  0x08
#define _ODCC4                  0x10
#define _ODCC5                  0x20
#define _ODCC6                  0x40
#define _ODCC7                  0x80

//==============================================================================


//==============================================================================
//        SLRCONC Bits

extern __at(0x0F51) __sfr SLRCONC;

typedef struct
  {
  unsigned SLRC0                : 1;
  unsigned SLRC1                : 1;
  unsigned SLRC2                : 1;
  unsigned SLRC3                : 1;
  unsigned SLRC4                : 1;
  unsigned SLRC5                : 1;
  unsigned SLRC6                : 1;
  unsigned SLRC7                : 1;
  } __SLRCONCbits_t;

extern __at(0x0F51) volatile __SLRCONCbits_t SLRCONCbits;

#define _SLRC0                  0x01
#define _SLRC1                  0x02
#define _SLRC2                  0x04
#define _SLRC3                  0x08
#define _SLRC4                  0x10
#define _SLRC5                  0x20
#define _SLRC6                  0x40
#define _SLRC7                  0x80

//==============================================================================


//==============================================================================
//        INLVLC Bits

extern __at(0x0F52) __sfr INLVLC;

typedef struct
  {
  unsigned INLVLC0              : 1;
  unsigned INLVLC1              : 1;
  unsigned INLVLC2              : 1;
  unsigned INLVLC3              : 1;
  unsigned INLVLC4              : 1;
  unsigned INLVLC5              : 1;
  unsigned INLVLC6              : 1;
  unsigned INLVLC7              : 1;
  } __INLVLCbits_t;

extern __at(0x0F52) volatile __INLVLCbits_t INLVLCbits;

#define _INLVLC0                0x01
#define _INLVLC1                0x02
#define _INLVLC2                0x04
#define _INLVLC3                0x08
#define _INLVLC4                0x10
#define _INLVLC5                0x20
#define _INLVLC6                0x40
#define _INLVLC7                0x80

//==============================================================================


//==============================================================================
//        IOCCP Bits

extern __at(0x0F53) __sfr IOCCP;

typedef struct
  {
  unsigned IOCCP0               : 1;
  unsigned IOCCP1               : 1;
  unsigned IOCCP2               : 1;
  unsigned IOCCP3               : 1;
  unsigned IOCCP4               : 1;
  unsigned IOCCP5               : 1;
  unsigned IOCCP6               : 1;
  unsigned IOCCP7               : 1;
  } __IOCCPbits_t;

extern __at(0x0F53) volatile __IOCCPbits_t IOCCPbits;

#define _IOCCP0                 0x01
#define _IOCCP1                 0x02
#define _IOCCP2                 0x04
#define _IOCCP3                 0x08
#define _IOCCP4                 0x10
#define _IOCCP5                 0x20
#define _IOCCP6                 0x40
#define _IOCCP7                 0x80

//==============================================================================


//==============================================================================
//        IOCCN Bits

extern __at(0x0F54) __sfr IOCCN;

typedef struct
  {
  unsigned IOCCN0               : 1;
  unsigned IOCCN1               : 1;
  unsigned IOCCN2               : 1;
  unsigned IOCCN3               : 1;
  unsigned IOCCN4               : 1;
  unsigned IOCCN5               : 1;
  unsigned IOCCN6               : 1;
  unsigned IOCCN7               : 1;
  } __IOCCNbits_t;

extern __at(0x0F54) volatile __IOCCNbits_t IOCCNbits;

#define _IOCCN0                 0x01
#define _IOCCN1                 0x02
#define _IOCCN2                 0x04
#define _IOCCN3                 0x08
#define _IOCCN4                 0x10
#define _IOCCN5                 0x20
#define _IOCCN6                 0x40
#define _IOCCN7                 0x80

//==============================================================================


//==============================================================================
//        IOCCF Bits

extern __at(0x0F55) __sfr IOCCF;

typedef struct
  {
  unsigned IOCCF0               : 1;
  unsigned IOCCF1               : 1;
  unsigned IOCCF2               : 1;
  unsigned IOCCF3               : 1;
  unsigned IOCCF4               : 1;
  unsigned IOCCF5               : 1;
  unsigned IOCCF6               : 1;
  unsigned IOCCF7               : 1;
  } __IOCCFbits_t;

extern __at(0x0F55) volatile __IOCCFbits_t IOCCFbits;

#define _IOCCF0                 0x01
#define _IOCCF1                 0x02
#define _IOCCF2                 0x04
#define _IOCCF3                 0x08
#define _IOCCF4                 0x10
#define _IOCCF5                 0x20
#define _IOCCF6                 0x40
#define _IOCCF7                 0x80

//==============================================================================


//==============================================================================
//        CCDNC Bits

extern __at(0x0F56) __sfr CCDNC;

typedef struct
  {
  unsigned CCDNC0               : 1;
  unsigned CCDNC1               : 1;
  unsigned CCDNC2               : 1;
  unsigned CCDNC3               : 1;
  unsigned CCDNC4               : 1;
  unsigned CCDNC5               : 1;
  unsigned CCDNC6               : 1;
  unsigned CCDNC7               : 1;
  } __CCDNCbits_t;

extern __at(0x0F56) volatile __CCDNCbits_t CCDNCbits;

#define _CCDNC0                 0x01
#define _CCDNC1                 0x02
#define _CCDNC2                 0x04
#define _CCDNC3                 0x08
#define _CCDNC4                 0x10
#define _CCDNC5                 0x20
#define _CCDNC6                 0x40
#define _CCDNC7                 0x80

//==============================================================================


//==============================================================================
//        CCDPC Bits

extern __at(0x0F57) __sfr CCDPC;

typedef struct
  {
  unsigned CCDPC0               : 1;
  unsigned CCDPC1               : 1;
  unsigned CCDPC2               : 1;
  unsigned CCDPC3               : 1;
  unsigned CCDPC4               : 1;
  unsigned CCDPC5               : 1;
  unsigned CCDPC6               : 1;
  unsigned CCDPC7               : 1;
  } __CCDPCbits_t;

extern __at(0x0F57) volatile __CCDPCbits_t CCDPCbits;

#define _CCDPC0                 0x01
#define _CCDPC1                 0x02
#define _CCDPC2                 0x04
#define _CCDPC3                 0x08
#define _CCDPC4                 0x10
#define _CCDPC5                 0x20
#define _CCDPC6                 0x40
#define _CCDPC7                 0x80

//==============================================================================


//==============================================================================
//        WPUE Bits

extern __at(0x0F65) __sfr WPUE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUE3                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __WPUEbits_t;

extern __at(0x0F65) volatile __WPUEbits_t WPUEbits;

#define _WPUE3                  0x08

//==============================================================================


//==============================================================================
//        INLVLE Bits

extern __at(0x0F68) __sfr INLVLE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned INLVLE3              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __INLVLEbits_t;

extern __at(0x0F68) volatile __INLVLEbits_t INLVLEbits;

#define _INLVLE3                0x08

//==============================================================================


//==============================================================================
//        IOCEP Bits

extern __at(0x0F69) __sfr IOCEP;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCEP3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCEPbits_t;

extern __at(0x0F69) volatile __IOCEPbits_t IOCEPbits;

#define _IOCEP3                 0x08

//==============================================================================


//==============================================================================
//        IOCEN Bits

extern __at(0x0F6A) __sfr IOCEN;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCEN3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCENbits_t;

extern __at(0x0F6A) volatile __IOCENbits_t IOCENbits;

#define _IOCEN3                 0x08

//==============================================================================


//==============================================================================
//        IOCEF Bits

extern __at(0x0F6B) __sfr IOCEF;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCEF3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCEFbits_t;

extern __at(0x0F6B) volatile __IOCEFbits_t IOCEFbits;

#define _IOCEF3                 0x08

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008
#define _CONFIG3                0x8009
#define _CONFIG4                0x800A
#define _CONFIG5                0x800B

//----------------------------- CONFIG1 Options -------------------------------

#define _FEXTOSC_LP             0x3FF8  // LP (crystal oscillator) optimized for 32.768kHz; PFM set to low power.
#define _FEXTOSC_XT             0x3FF9  // XT (crystal oscillator) above 500kHz, below 4MHz; PFM set to medium power.
#define _FEXTOSC_HS             0x3FFA  // HS (crystal oscillator) above 4MHz; PFM set to high power.
#define _FEXTOSC_Reserved       0x3FFB  // Reserved.
#define _FEXTOSC_OFF            0x3FFC  // Oscillator not enabled.
#define _FEXTOSC_ECL            0x3FFD  // EC below 500kHz; PFM set to low power.
#define _FEXTOSC_ECM            0x3FFE  // EC for 500kHz to 8MHz; PFM set to medium power.
#define _FEXTOSC_ECH            0x3FFF  // EC above 8MHz; PFM set to high power.
#define _RSTOSC_HFINT32         0x3F8F  // HFINTOSC with OSCFRQ= 32 MHz and CDIV = 1:1.
#define _RSTOSC_HFINTPLL        0x3F9F  // HFINTOSC with 2x PLL, with OSCFRQ = 16 MHz and CDIV = 1:1 (FOSC = 32 MHz).
#define _RSTOSC_EXT4X           0x3FAF  // EXTOSC with 4x PLL, with EXTOSC operating per FEXTOSC bits.
#define _RSTOSC_Reserved        0x3FBF  // Reserved.
#define _RSTOSC_SOSC            0x3FCF  // SOSC.
#define _RSTOSC_LFINT           0x3FDF  // LFINTOSC.
#define _RSTOSC_HFINT1          0x3FEF  // HFINTOSC (1MHz).
#define _RSTOSC_EXT1X           0x3FFF  // EXTOSC operating per FEXTOSC bits.
#define _CLKOUTEN_ON            0x3EFF  // CLKOUT function is enabled; FOSC/4 clock appears at OSC2.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function is disabled; i/o or oscillator function on OSC2.
#define _CSWEN_OFF              0x37FF  // The NOSC and NDIV bits cannot be changed by user software.
#define _CSWEN_ON               0x3FFF  // Writing to NOSC and NDIV is allowed.
#define _FCMEN_OFF              0x1FFF  // FSCM timer disabled.
#define _FCMEN_ON               0x3FFF  // FSCM timer enabled.

//----------------------------- CONFIG2 Options -------------------------------

#define _MCLRE_OFF              0x3FFE  // MCLR pin function is port defined function.
#define _MCLRE_ON               0x3FFF  // MCLR pin is Master Clear function.
#define _PWRTE_ON               0x3FFD  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _LPBOREN_ON             0x3FDF  // ULPBOR enabled.
#define _LPBOREN_OFF            0x3FFF  // ULPBOR disabled.
#define _BOREN_OFF              0x3F3F  // Brown-out reset disabled.
#define _BOREN_SBOREN           0x3F7F  // Brown-out reset enabled according to SBOREN bit.
#define _BOREN_NSLEEP           0x3FBF  // Brown-out Reset enabled while running, disabled in sleep; SBOREN is ignored.
#define _BOREN_ON               0x3FFF  // Brown-out Reset Enabled, SBOREN bit is ignored.
#define _BORV_HI                0x3DFF  // Brown-out Reset Voltage (VBOR) is set to 2.7V.
#define _BORV_LO                0x3FFF  // Brown-out Reset Voltage (VBOR) set to 1.9V on LF, and 2.45V on F Devices.
#define _ZCD_OFF                0x3BFF  // Zero-cross detect circuit is always enabled.
#define _ZCD_ON                 0x3FFF  // Zero-cross detect circuit is disabled at POR.
#define _ZCDDIS_OFF             0x3BFF  // Zero-cross detect circuit is always enabled.
#define _ZCDDIS_ON              0x3FFF  // Zero-cross detect circuit is disabled at POR.
#define _PPS1WAY_OFF            0x37FF  // The PPSLOCK bit can be set and cleared repeatedly by software.
#define _PPS1WAY_ON             0x3FFF  // The PPSLOCK bit can be cleared and set only once in software.
#define _STVREN_OFF             0x2FFF  // Stack Overflow or Underflow will not cause a reset.
#define _STVREN_ON              0x3FFF  // Stack Overflow or Underflow will cause a reset.
#define _DEBUG_ON               0x1FFF  // Background debugger enabled; ICSPCLK and ICSPDAT are dedicated to the debugger.
#define _DEBUG_OFF              0x3FFF  // Background debugger disabled; ICSPCLK and ICSPDAT are general purpose I/O pins.

//----------------------------- CONFIG3 Options -------------------------------

#define _WDTCPS_WDTCPS_0        0x3FE0  // Divider ratio 1:32.
#define _WDTCPS_WDTCPS_1        0x3FE1  // Divider ratio 1:64.
#define _WDTCPS_WDTCPS_2        0x3FE2  // Divider ratio 1:128.
#define _WDTCPS_WDTCPS_3        0x3FE3  // Divider ratio 1:256.
#define _WDTCPS_WDTCPS_4        0x3FE4  // Divider ratio 1:512.
#define _WDTCPS_WDTCPS_5        0x3FE5  // Divider ratio 1:1024.
#define _WDTCPS_WDTCPS_6        0x3FE6  // Divider ratio 1:2048.
#define _WDTCPS_WDTCPS_7        0x3FE7  // Divider ratio 1:4096.
#define _WDTCPS_WDTCPS_8        0x3FE8  // Divider ratio 1:8192.
#define _WDTCPS_WDTCPS_9        0x3FE9  // Divider ratio 1:16384.
#define _WDTCPS_WDTCPS_10       0x3FEA  // Divider ratio 1:32768.
#define _WDTCPS_WDTCPS_11       0x3FEB  // Divider ratio 1:65536.
#define _WDTCPS_WDTCPS_12       0x3FEC  // Divider ratio 1:131072.
#define _WDTCPS_WDTCPS_13       0x3FED  // Divider ratio 1:262144.
#define _WDTCPS_WDTCPS_14       0x3FEE  // Divider ratio 1:524299.
#define _WDTCPS_WDTCPS_15       0x3FEF  // Divider ratio 1:1048576.
#define _WDTCPS_WDTCPS_16       0x3FF0  // Divider ratio 1:2097152.
#define _WDTCPS_WDTCPS_17       0x3FF1  // Divider ratio 1:4194304.
#define _WDTCPS_WDTCPS_18       0x3FF2  // Divider ratio 1:8388608.
#define _WDTCPS_WDTCPS_19       0x3FF3  // Divider ratio 1:32.
#define _WDTCPS_WDTCPS_20       0x3FF4  // Divider ratio 1:32.
#define _WDTCPS_WDTCPS_21       0x3FF5  // Divider ratio 1:32.
#define _WDTCPS_WDTCPS_22       0x3FF6  // Divider ratio 1:32.
#define _WDTCPS_WDTCPS_23       0x3FF7  // Divider ratio 1:32.
#define _WDTCPS_WDTCPS_24       0x3FF8  // Divider ratio 1:32.
#define _WDTCPS_WDTCPS_25       0x3FF9  // Divider ratio 1:32.
#define _WDTCPS_WDTCPS_26       0x3FFA  // Divider ratio 1:32.
#define _WDTCPS_WDTCPS_27       0x3FFB  // Divider ratio 1:32.
#define _WDTCPS_WDTCPS_28       0x3FFC  // Divider ratio 1:32.
#define _WDTCPS_WDTCPS_29       0x3FFD  // Divider ratio 1:32.
#define _WDTCPS_WDTCPS_30       0x3FFE  // Divider ratio 1:32.
#define _WDTCPS_WDTCPS_31       0x3FFF  // Divider ratio 1:65536; software control of WDTPS.
#define _WDTE_OFF               0x3F9F  // WDT Disabled, SWDTEN is ignored.
#define _WDTE_SWDTEN            0x3FBF  // WDT enabled/disabled by SWDTEN bit in WDTCON0.
#define _WDTE_NSLEEP            0x3FDF  // WDT enabled while sleep=0, suspended when sleep=1; SWDTEN ignored.
#define _WDTE_ON                0x3FFF  // WDT enabled regardless of sleep; SWDTEN ignored.
#define _WDTCWS_WDTCWS_0        0x38FF  // window delay = 87.5 percent of time; no software control; keyed access required.
#define _WDTCWS_WDTCWS_1        0x39FF  // window delay = 75 percent of time; no software control; keyed access required.
#define _WDTCWS_WDTCWS_2        0x3AFF  // window delay = 62.5 percent of time; no software control; keyed access required.
#define _WDTCWS_WDTCWS_3        0x3BFF  // window delay = 50 percent of time; no software control; keyed access required.
#define _WDTCWS_WDTCWS_4        0x3CFF  // window delay = 37.5 percent of time; no software control; keyed access required.
#define _WDTCWS_WDTCWS_5        0x3DFF  // window delay = 25 percent of time; no software control; keyed access required.
#define _WDTCWS_WDTCWS_6        0x3EFF  // window always open (100%); no software control; keyed access required.
#define _WDTCWS_WDTCWS_7        0x3FFF  // window always open (100%); software control; keyed access not required.
#define _WDTCCS_LFINTOSC        0x07FF  // WDT reference clock is the 31.0kHz LFINTOSC output.
#define _WDTCCS_HFINTOSC        0x0FFF  // WDT reference clock is the 31.25 kHz HFINTOSC.
#define _WDTCCS_SC              0x3FFF  // Software Control.

//----------------------------- CONFIG4 Options -------------------------------

#define _WRT_ON                 0x3FFC  // 0x0000 to 0x1FFF write protected.
#define _WRT_WRT_lower          0x3FFD  // 0x0000 to x0FFF write protected.
#define _WRT_WRT_upper          0x3FFE  // 0x0000 to 0x01FF write protected.
#define _WRT_OFF                0x3FFF  // Write protection off.
#define _SCANE_not_available    0x2FFF  // Scanner module is not available for use.
#define _SCANE_available        0x3FFF  // Scanner module is available for use.
#define _LVP_OFF                0x1FFF  // High Voltage on MCLR/Vpp must be used for programming.
#define _LVP_ON                 0x3FFF  // Low Voltage programming enabled. MCLR/Vpp pin function is MCLR.

//----------------------------- CONFIG5 Options -------------------------------

#define _CP_ON                  0x3FFE  // UserNVM code protection enabled.
#define _CP_OFF                 0x3FFF  // UserNVM code protection disabled.
#define _CPD_ON                 0x3FFD  // DataNVM code protection enabled.
#define _CPD_OFF                0x3FFF  // DataNVM code protection disabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADACC8                  ADACCHbits.ADACC8               // bit 0
#define ADACC9                  ADACCHbits.ADACC9               // bit 1
#define ADACC10                 ADACCHbits.ADACC10              // bit 2
#define ADACC11                 ADACCHbits.ADACC11              // bit 3
#define ADACC12                 ADACCHbits.ADACC12              // bit 4
#define ADACC13                 ADACCHbits.ADACC13              // bit 5
#define ADACC14                 ADACCHbits.ADACC14              // bit 6
#define ADACC15                 ADACCHbits.ADACC15              // bit 7

#define ADACC0                  ADACCLbits.ADACC0               // bit 0
#define ADACC1                  ADACCLbits.ADACC1               // bit 1
#define ADACC2                  ADACCLbits.ADACC2               // bit 2
#define ADACC3                  ADACCLbits.ADACC3               // bit 3
#define ADACC4                  ADACCLbits.ADACC4               // bit 4
#define ADACC5                  ADACCLbits.ADACC5               // bit 5
#define ADACC6                  ADACCLbits.ADACC6               // bit 6
#define ADACC7                  ADACCLbits.ADACC7               // bit 7

#define ADACQ0                  ADACQbits.ADACQ0                // bit 0
#define ADACQ1                  ADACQbits.ADACQ1                // bit 1
#define ADACQ2                  ADACQbits.ADACQ2                // bit 2
#define ADACQ3                  ADACQbits.ADACQ3                // bit 3
#define ADACQ4                  ADACQbits.ADACQ4                // bit 4
#define ADACQ5                  ADACQbits.ADACQ5                // bit 5
#define ADACQ6                  ADACQbits.ADACQ6                // bit 6
#define ADACQ7                  ADACQbits.ADACQ7                // bit 7

#define ADACT0                  ADACTbits.ADACT0                // bit 0
#define ADACT1                  ADACTbits.ADACT1                // bit 1
#define ADACT2                  ADACTbits.ADACT2                // bit 2
#define ADACT3                  ADACTbits.ADACT3                // bit 3
#define ADACT4                  ADACTbits.ADACT4                // bit 4

#define ADCACTPPS0              ADCACTPPSbits.ADCACTPPS0        // bit 0
#define ADCACTPPS1              ADCACTPPSbits.ADCACTPPS1        // bit 1
#define ADCACTPPS2              ADCACTPPSbits.ADCACTPPS2        // bit 2
#define ADCACTPPS3              ADCACTPPSbits.ADCACTPPS3        // bit 3
#define ADCACTPPS4              ADCACTPPSbits.ADCACTPPS4        // bit 4

#define ADCAP0                  ADCAPbits.ADCAP0                // bit 0
#define ADCAP1                  ADCAPbits.ADCAP1                // bit 1
#define ADCAP2                  ADCAPbits.ADCAP2                // bit 2
#define ADCAP3                  ADCAPbits.ADCAP3                // bit 3
#define ADCAP4                  ADCAPbits.ADCAP4                // bit 4

#define ADCCS0                  ADCLKbits.ADCCS0                // bit 0
#define ADCCS1                  ADCLKbits.ADCCS1                // bit 1
#define ADCCS2                  ADCLKbits.ADCCS2                // bit 2
#define ADCCS3                  ADCLKbits.ADCCS3                // bit 3
#define ADCCS4                  ADCLKbits.ADCCS4                // bit 4
#define ADCCS5                  ADCLKbits.ADCCS5                // bit 5

#define ADCNT0                  ADCNTbits.ADCNT0                // bit 0
#define ADCNT1                  ADCNTbits.ADCNT1                // bit 1
#define ADCNT2                  ADCNTbits.ADCNT2                // bit 2
#define ADCNT3                  ADCNTbits.ADCNT3                // bit 3
#define ADCNT4                  ADCNTbits.ADCNT4                // bit 4
#define ADCNT5                  ADCNTbits.ADCNT5                // bit 5
#define ADCNT6                  ADCNTbits.ADCNT6                // bit 6
#define ADCNT7                  ADCNTbits.ADCNT7                // bit 7

#define ADGO                    ADCON0bits.ADGO                 // bit 0, shadows bit in ADCON0bits
#define DONE                    ADCON0bits.DONE                 // bit 0, shadows bit in ADCON0bits
#define NOT_DONE                ADCON0bits.NOT_DONE             // bit 0, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 0, shadows bit in ADCON0bits
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 0, shadows bit in ADCON0bits
#define ADFM0                   ADCON0bits.ADFM0                // bit 2
#define ADFM1                   ADCON0bits.ADFM1                // bit 3
#define ADCS                    ADCON0bits.ADCS                 // bit 4
#define ADCONT                  ADCON0bits.ADCONT               // bit 6
#define ADON                    ADCON0bits.ADON                 // bit 7

#define ADDSEN                  ADCON1bits.ADDSEN               // bit 0
#define ADGPOL                  ADCON1bits.ADGPOL               // bit 5
#define ADIPEN                  ADCON1bits.ADIPEN               // bit 6
#define ADPPOL                  ADCON1bits.ADPPOL               // bit 7

#define ADMD0                   ADCON2bits.ADMD0                // bit 0
#define ADMD1                   ADCON2bits.ADMD1                // bit 1
#define ADMD2                   ADCON2bits.ADMD2                // bit 2
#define ADACLR                  ADCON2bits.ADACLR               // bit 3
#define ADCRS0                  ADCON2bits.ADCRS0               // bit 4
#define ADCRS1                  ADCON2bits.ADCRS1               // bit 5
#define ADCRS2                  ADCON2bits.ADCRS2               // bit 6
#define ADPSIS                  ADCON2bits.ADPSIS               // bit 7

#define ADTMD0                  ADCON3bits.ADTMD0               // bit 0
#define ADTMD1                  ADCON3bits.ADTMD1               // bit 1
#define ADTMD2                  ADCON3bits.ADTMD2               // bit 2
#define ADSOI                   ADCON3bits.ADSOI                // bit 3
#define ADCALC0                 ADCON3bits.ADCALC0              // bit 4
#define ADCALC1                 ADCON3bits.ADCALC1              // bit 5
#define ADCALC2                 ADCON3bits.ADCALC2              // bit 6

#define ADERR8                  ADERRHbits.ADERR8               // bit 0
#define ADERR9                  ADERRHbits.ADERR9               // bit 1
#define ADERR10                 ADERRHbits.ADERR10              // bit 2
#define ADERR11                 ADERRHbits.ADERR11              // bit 3
#define ADERR12                 ADERRHbits.ADERR12              // bit 4
#define ADERR13                 ADERRHbits.ADERR13              // bit 5
#define ADERR14                 ADERRHbits.ADERR14              // bit 6
#define ADERR15                 ADERRHbits.ADERR15              // bit 7

#define ADERR0                  ADERRLbits.ADERR0               // bit 0
#define ADERR1                  ADERRLbits.ADERR1               // bit 1
#define ADERR2                  ADERRLbits.ADERR2               // bit 2
#define ADERR3                  ADERRLbits.ADERR3               // bit 3
#define ADERR4                  ADERRLbits.ADERR4               // bit 4
#define ADERR5                  ADERRLbits.ADERR5               // bit 5
#define ADERR6                  ADERRLbits.ADERR6               // bit 6
#define ADERR7                  ADERRLbits.ADERR7               // bit 7

#define ADFLTR8                 ADFLTRHbits.ADFLTR8             // bit 0
#define ADFLTR9                 ADFLTRHbits.ADFLTR9             // bit 1
#define ADFLTR10                ADFLTRHbits.ADFLTR10            // bit 2
#define ADFLTR11                ADFLTRHbits.ADFLTR11            // bit 3
#define ADFLTR12                ADFLTRHbits.ADFLTR12            // bit 4
#define ADFLTR13                ADFLTRHbits.ADFLTR13            // bit 5
#define ADFLTR14                ADFLTRHbits.ADFLTR14            // bit 6
#define ADFLTR15                ADFLTRHbits.ADFLTR15            // bit 7

#define ADFLTR0                 ADFLTRLbits.ADFLTR0             // bit 0
#define ADFLTR1                 ADFLTRLbits.ADFLTR1             // bit 1
#define ADFLTR2                 ADFLTRLbits.ADFLTR2             // bit 2
#define ADFLTR3                 ADFLTRLbits.ADFLTR3             // bit 3
#define ADFLTR4                 ADFLTRLbits.ADFLTR4             // bit 4
#define ADFLTR5                 ADFLTRLbits.ADFLTR5             // bit 5
#define ADFLTR6                 ADFLTRLbits.ADFLTR6             // bit 6
#define ADFLTR7                 ADFLTRLbits.ADFLTR7             // bit 7

#define ADLTH8                  ADLTHHbits.ADLTH8               // bit 0
#define ADLTH9                  ADLTHHbits.ADLTH9               // bit 1
#define ADLTH10                 ADLTHHbits.ADLTH10              // bit 2
#define ADLTH11                 ADLTHHbits.ADLTH11              // bit 3
#define ADLTH12                 ADLTHHbits.ADLTH12              // bit 4
#define ADLTH13                 ADLTHHbits.ADLTH13              // bit 5
#define ADLTH14                 ADLTHHbits.ADLTH14              // bit 6
#define ADLTH15                 ADLTHHbits.ADLTH15              // bit 7

#define ADLTH0                  ADLTHLbits.ADLTH0               // bit 0
#define ADLTH1                  ADLTHLbits.ADLTH1               // bit 1
#define ADLTH2                  ADLTHLbits.ADLTH2               // bit 2
#define ADLTH3                  ADLTHLbits.ADLTH3               // bit 3
#define ADLTH4                  ADLTHLbits.ADLTH4               // bit 4
#define ADLTH5                  ADLTHLbits.ADLTH5               // bit 5
#define ADLTH6                  ADLTHLbits.ADLTH6               // bit 6
#define ADLTH7                  ADLTHLbits.ADLTH7               // bit 7

#define ADPCH0                  ADPCHbits.ADPCH0                // bit 0
#define ADPCH1                  ADPCHbits.ADPCH1                // bit 1
#define ADPCH2                  ADPCHbits.ADPCH2                // bit 2
#define ADPCH3                  ADPCHbits.ADPCH3                // bit 3
#define ADPCH4                  ADPCHbits.ADPCH4                // bit 4
#define ADPCH5                  ADPCHbits.ADPCH5                // bit 5

#define ADPRE0                  ADPREbits.ADPRE0                // bit 0
#define ADPRE1                  ADPREbits.ADPRE1                // bit 1
#define ADPRE2                  ADPREbits.ADPRE2                // bit 2
#define ADPRE3                  ADPREbits.ADPRE3                // bit 3
#define ADPRE4                  ADPREbits.ADPRE4                // bit 4
#define ADPRE5                  ADPREbits.ADPRE5                // bit 5
#define ADPRE6                  ADPREbits.ADPRE6                // bit 6
#define ADPRE7                  ADPREbits.ADPRE7                // bit 7

#define ADPREV8                 ADPREVHbits.ADPREV8             // bit 0
#define ADPREV9                 ADPREVHbits.ADPREV9             // bit 1
#define ADPREV10                ADPREVHbits.ADPREV10            // bit 2
#define ADPREV11                ADPREVHbits.ADPREV11            // bit 3
#define ADPREV12                ADPREVHbits.ADPREV12            // bit 4
#define ADPREV13                ADPREVHbits.ADPREV13            // bit 5
#define ADPREV14                ADPREVHbits.ADPREV14            // bit 6
#define ADPREV15                ADPREVHbits.ADPREV15            // bit 7

#define ADPREV0                 ADPREVLbits.ADPREV0             // bit 0
#define ADPREV1                 ADPREVLbits.ADPREV1             // bit 1
#define ADPREV2                 ADPREVLbits.ADPREV2             // bit 2
#define ADPREV3                 ADPREVLbits.ADPREV3             // bit 3
#define ADPREV4                 ADPREVLbits.ADPREV4             // bit 4
#define ADPREV5                 ADPREVLbits.ADPREV5             // bit 5
#define ADPREV6                 ADPREVLbits.ADPREV6             // bit 6
#define ADPREV7                 ADPREVLbits.ADPREV7             // bit 7

#define ADPREF0                 ADREFbits.ADPREF0               // bit 0
#define ADPREF1                 ADREFbits.ADPREF1               // bit 1
#define ADNREF                  ADREFbits.ADNREF                // bit 4

#define ADRPT0                  ADRPTbits.ADRPT0                // bit 0
#define ADRPT1                  ADRPTbits.ADRPT1                // bit 1
#define ADRPT2                  ADRPTbits.ADRPT2                // bit 2
#define ADRPT3                  ADRPTbits.ADRPT3                // bit 3
#define ADRPT4                  ADRPTbits.ADRPT4                // bit 4
#define ADRPT5                  ADRPTbits.ADRPT5                // bit 5
#define ADRPT6                  ADRPTbits.ADRPT6                // bit 6
#define ADRPT7                  ADRPTbits.ADRPT7                // bit 7

#define ADSTAT0                 ADSTATbits.ADSTAT0              // bit 0
#define ADSTAT1                 ADSTATbits.ADSTAT1              // bit 1
#define ADSTAT2                 ADSTATbits.ADSTAT2              // bit 2
#define ADMACT                  ADSTATbits.ADMACT               // bit 3
#define ADMATH                  ADSTATbits.ADMATH               // bit 4
#define ADLTHR                  ADSTATbits.ADLTHR               // bit 5
#define ADUTHR                  ADSTATbits.ADUTHR               // bit 6
#define ADAOV                   ADSTATbits.ADAOV                // bit 7

#define ADSTPT8                 ADSTPTHbits.ADSTPT8             // bit 0
#define ADSTPT9                 ADSTPTHbits.ADSTPT9             // bit 1
#define ADSTPT10                ADSTPTHbits.ADSTPT10            // bit 2
#define ADSTPT11                ADSTPTHbits.ADSTPT11            // bit 3
#define ADSTPT12                ADSTPTHbits.ADSTPT12            // bit 4
#define ADSTPT13                ADSTPTHbits.ADSTPT13            // bit 5
#define ADSTPT14                ADSTPTHbits.ADSTPT14            // bit 6
#define ADSTPT15                ADSTPTHbits.ADSTPT15            // bit 7

#define ADSTPT0                 ADSTPTLbits.ADSTPT0             // bit 0
#define ADSTPT1                 ADSTPTLbits.ADSTPT1             // bit 1
#define ADSTPT2                 ADSTPTLbits.ADSTPT2             // bit 2
#define ADSTPT3                 ADSTPTLbits.ADSTPT3             // bit 3
#define ADSTPT4                 ADSTPTLbits.ADSTPT4             // bit 4
#define ADSTPT5                 ADSTPTLbits.ADSTPT5             // bit 5
#define ADSTPT6                 ADSTPTLbits.ADSTPT6             // bit 6
#define ADSTPT7                 ADSTPTLbits.ADSTPT7             // bit 7

#define ADUTH8                  ADUTHHbits.ADUTH8               // bit 0
#define ADUTH9                  ADUTHHbits.ADUTH9               // bit 1
#define ADUTH10                 ADUTHHbits.ADUTH10              // bit 2
#define ADUTH11                 ADUTHHbits.ADUTH11              // bit 3
#define ADUTH12                 ADUTHHbits.ADUTH12              // bit 4
#define ADUTH13                 ADUTHHbits.ADUTH13              // bit 5
#define ADUTH14                 ADUTHHbits.ADUTH14              // bit 6
#define ADUTH15                 ADUTHHbits.ADUTH15              // bit 7

#define ADUTH0                  ADUTHLbits.ADUTH0               // bit 0
#define ADUTH1                  ADUTHLbits.ADUTH1               // bit 1
#define ADUTH2                  ADUTHLbits.ADUTH2               // bit 2
#define ADUTH3                  ADUTHLbits.ADUTH3               // bit 3
#define ADUTH4                  ADUTHLbits.ADUTH4               // bit 4
#define ADUTH5                  ADUTHLbits.ADUTH5               // bit 5
#define ADUTH6                  ADUTHLbits.ADUTH6               // bit 6
#define ADUTH7                  ADUTHLbits.ADUTH7               // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA3                   ANSELAbits.ANSA3                // bit 3
#define ANSA4                   ANSELAbits.ANSA4                // bit 4
#define ANSA5                   ANSELAbits.ANSA5                // bit 5
#define ANSA6                   ANSELAbits.ANSA6                // bit 6
#define ANSA7                   ANSELAbits.ANSA7                // bit 7

#define ANSB0                   ANSELBbits.ANSB0                // bit 0
#define ANSB1                   ANSELBbits.ANSB1                // bit 1
#define ANSB2                   ANSELBbits.ANSB2                // bit 2
#define ANSB3                   ANSELBbits.ANSB3                // bit 3
#define ANSB4                   ANSELBbits.ANSB4                // bit 4
#define ANSB5                   ANSELBbits.ANSB5                // bit 5
#define ANSB6                   ANSELBbits.ANSB6                // bit 6
#define ANSB7                   ANSELBbits.ANSB7                // bit 7

#define ANSC0                   ANSELCbits.ANSC0                // bit 0
#define ANSC1                   ANSELCbits.ANSC1                // bit 1
#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC3                   ANSELCbits.ANSC3                // bit 3
#define ANSC4                   ANSELCbits.ANSC4                // bit 4
#define ANSC5                   ANSELCbits.ANSC5                // bit 5
#define ANSC6                   ANSELCbits.ANSC6                // bit 6
#define ANSC7                   ANSELCbits.ANSC7                // bit 7

#define ABDEN                   BAUD1CONbits.ABDEN              // bit 0
#define WUE                     BAUD1CONbits.WUE                // bit 1
#define BRG16                   BAUD1CONbits.BRG16              // bit 3
#define SCKP                    BAUD1CONbits.SCKP               // bit 4
#define RCIDL                   BAUD1CONbits.RCIDL              // bit 6
#define ABDOVF                  BAUD1CONbits.ABDOVF             // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define CCDS0                   CCDCONbits.CCDS0                // bit 0
#define CCDS1                   CCDCONbits.CCDS1                // bit 1
#define CCDEN                   CCDCONbits.CCDEN                // bit 7

#define CCDNA0                  CCDNAbits.CCDNA0                // bit 0
#define CCDNA1                  CCDNAbits.CCDNA1                // bit 1
#define CCDNA2                  CCDNAbits.CCDNA2                // bit 2
#define CCDNA3                  CCDNAbits.CCDNA3                // bit 3
#define CCDNA4                  CCDNAbits.CCDNA4                // bit 4
#define CCDNA5                  CCDNAbits.CCDNA5                // bit 5
#define CCDNA6                  CCDNAbits.CCDNA6                // bit 6
#define CCDNA7                  CCDNAbits.CCDNA7                // bit 7

#define CCDNB0                  CCDNBbits.CCDNB0                // bit 0
#define CCDNB1                  CCDNBbits.CCDNB1                // bit 1
#define CCDNB2                  CCDNBbits.CCDNB2                // bit 2
#define CCDNB3                  CCDNBbits.CCDNB3                // bit 3
#define CCDNB4                  CCDNBbits.CCDNB4                // bit 4
#define CCDNB5                  CCDNBbits.CCDNB5                // bit 5
#define CCDNB6                  CCDNBbits.CCDNB6                // bit 6
#define CCDNB7                  CCDNBbits.CCDNB7                // bit 7

#define CCDNC0                  CCDNCbits.CCDNC0                // bit 0
#define CCDNC1                  CCDNCbits.CCDNC1                // bit 1
#define CCDNC2                  CCDNCbits.CCDNC2                // bit 2
#define CCDNC3                  CCDNCbits.CCDNC3                // bit 3
#define CCDNC4                  CCDNCbits.CCDNC4                // bit 4
#define CCDNC5                  CCDNCbits.CCDNC5                // bit 5
#define CCDNC6                  CCDNCbits.CCDNC6                // bit 6
#define CCDNC7                  CCDNCbits.CCDNC7                // bit 7

#define CCDPA0                  CCDPAbits.CCDPA0                // bit 0
#define CCDPA1                  CCDPAbits.CCDPA1                // bit 1
#define CCDPA2                  CCDPAbits.CCDPA2                // bit 2
#define CCDPA3                  CCDPAbits.CCDPA3                // bit 3
#define CCDPA4                  CCDPAbits.CCDPA4                // bit 4
#define CCDPA5                  CCDPAbits.CCDPA5                // bit 5
#define CCDPA6                  CCDPAbits.CCDPA6                // bit 6
#define CCDPA7                  CCDPAbits.CCDPA7                // bit 7

#define CCDPB0                  CCDPBbits.CCDPB0                // bit 0
#define CCDPB1                  CCDPBbits.CCDPB1                // bit 1
#define CCDPB2                  CCDPBbits.CCDPB2                // bit 2
#define CCDPB3                  CCDPBbits.CCDPB3                // bit 3
#define CCDPB4                  CCDPBbits.CCDPB4                // bit 4
#define CCDPB5                  CCDPBbits.CCDPB5                // bit 5
#define CCDPB6                  CCDPBbits.CCDPB6                // bit 6
#define CCDPB7                  CCDPBbits.CCDPB7                // bit 7

#define CCDPC0                  CCDPCbits.CCDPC0                // bit 0
#define CCDPC1                  CCDPCbits.CCDPC1                // bit 1
#define CCDPC2                  CCDPCbits.CCDPC2                // bit 2
#define CCDPC3                  CCDPCbits.CCDPC3                // bit 3
#define CCDPC4                  CCDPCbits.CCDPC4                // bit 4
#define CCDPC5                  CCDPCbits.CCDPC5                // bit 5
#define CCDPC6                  CCDPCbits.CCDPC6                // bit 6
#define CCDPC7                  CCDPCbits.CCDPC7                // bit 7

#define CTS0                    CCP1CAPbits.CTS0                // bit 0, shadows bit in CCP1CAPbits
#define CCP1CTS0                CCP1CAPbits.CCP1CTS0            // bit 0, shadows bit in CCP1CAPbits
#define CTS1                    CCP1CAPbits.CTS1                // bit 1, shadows bit in CCP1CAPbits
#define CCP1CTS1                CCP1CAPbits.CCP1CTS1            // bit 1, shadows bit in CCP1CAPbits
#define CTS2                    CCP1CAPbits.CTS2                // bit 2, shadows bit in CCP1CAPbits
#define CCP1CTS2                CCP1CAPbits.CCP1CTS2            // bit 2, shadows bit in CCP1CAPbits

#define MODE0                   CCP1CONbits.MODE0               // bit 0, shadows bit in CCP1CONbits
#define CCP1MODE0               CCP1CONbits.CCP1MODE0           // bit 0, shadows bit in CCP1CONbits
#define MODE1                   CCP1CONbits.MODE1               // bit 1, shadows bit in CCP1CONbits
#define CCP1MODE1               CCP1CONbits.CCP1MODE1           // bit 1, shadows bit in CCP1CONbits
#define MODE2                   CCP1CONbits.MODE2               // bit 2, shadows bit in CCP1CONbits
#define CCP1MODE2               CCP1CONbits.CCP1MODE2           // bit 2, shadows bit in CCP1CONbits
#define MODE3                   CCP1CONbits.MODE3               // bit 3, shadows bit in CCP1CONbits
#define CCP1MODE3               CCP1CONbits.CCP1MODE3           // bit 3, shadows bit in CCP1CONbits
#define FMT                     CCP1CONbits.FMT                 // bit 4, shadows bit in CCP1CONbits
#define CCP1FMT                 CCP1CONbits.CCP1FMT             // bit 4, shadows bit in CCP1CONbits
#define OUT                     CCP1CONbits.OUT                 // bit 5, shadows bit in CCP1CONbits
#define CCP1OUT                 CCP1CONbits.CCP1OUT             // bit 5, shadows bit in CCP1CONbits
#define OE                      CCP1CONbits.OE                  // bit 6, shadows bit in CCP1CONbits
#define CCP1OE                  CCP1CONbits.CCP1OE              // bit 6, shadows bit in CCP1CONbits
#define EN                      CCP1CONbits.EN                  // bit 7, shadows bit in CCP1CONbits
#define CCP1EN                  CCP1CONbits.CCP1EN              // bit 7, shadows bit in CCP1CONbits

#define CCP1PPS0                CCP1PPSbits.CCP1PPS0            // bit 0
#define CCP1PPS1                CCP1PPSbits.CCP1PPS1            // bit 1
#define CCP1PPS2                CCP1PPSbits.CCP1PPS2            // bit 2
#define CCP1PPS3                CCP1PPSbits.CCP1PPS3            // bit 3
#define CCP1PPS4                CCP1PPSbits.CCP1PPS4            // bit 4

#define CCP2PPS0                CCP2PPSbits.CCP2PPS0            // bit 0
#define CCP2PPS1                CCP2PPSbits.CCP2PPS1            // bit 1
#define CCP2PPS2                CCP2PPSbits.CCP2PPS2            // bit 2
#define CCP2PPS3                CCP2PPSbits.CCP2PPS3            // bit 3
#define CCP2PPS4                CCP2PPSbits.CCP2PPS4            // bit 4

#define CCP3PPS0                CCP3PPSbits.CCP3PPS0            // bit 0
#define CCP3PPS1                CCP3PPSbits.CCP3PPS1            // bit 1
#define CCP3PPS2                CCP3PPSbits.CCP3PPS2            // bit 2
#define CCP3PPS3                CCP3PPSbits.CCP3PPS3            // bit 3
#define CCP3PPS4                CCP3PPSbits.CCP3PPS4            // bit 4

#define CCP4PPS0                CCP4PPSbits.CCP4PPS0            // bit 0
#define CCP4PPS1                CCP4PPSbits.CCP4PPS1            // bit 1
#define CCP4PPS2                CCP4PPSbits.CCP4PPS2            // bit 2
#define CCP4PPS3                CCP4PPSbits.CCP4PPS3            // bit 3
#define CCP4PPS4                CCP4PPSbits.CCP4PPS4            // bit 4

#define CCP5PPS0                CCP5PPSbits.CCP5PPS0            // bit 0
#define CCP5PPS1                CCP5PPSbits.CCP5PPS1            // bit 1
#define CCP5PPS2                CCP5PPSbits.CCP5PPS2            // bit 2
#define CCP5PPS3                CCP5PPSbits.CCP5PPS3            // bit 3
#define CCP5PPS4                CCP5PPSbits.CCP5PPS4            // bit 4
#define CCP6PPS                 CCP5PPSbits.CCP6PPS             // bit 5

#define C1TSEL0                 CCPTMRS0bits.C1TSEL0            // bit 0
#define C1TSEL1                 CCPTMRS0bits.C1TSEL1            // bit 1
#define C2TSEL0                 CCPTMRS0bits.C2TSEL0            // bit 2
#define C2TSEL1                 CCPTMRS0bits.C2TSEL1            // bit 3
#define C3TSEL0                 CCPTMRS0bits.C3TSEL0            // bit 4
#define C3TSEL1                 CCPTMRS0bits.C3TSEL1            // bit 5
#define C4TSEL0                 CCPTMRS0bits.C4TSEL0            // bit 6
#define C4TSEL1                 CCPTMRS0bits.C4TSEL1            // bit 7

#define C5TSEL0                 CCPTMRS1bits.C5TSEL0            // bit 0
#define C5TSEL1                 CCPTMRS1bits.C5TSEL1            // bit 1
#define P6TSEL0                 CCPTMRS1bits.P6TSEL0            // bit 2
#define P6TSEL1                 CCPTMRS1bits.P6TSEL1            // bit 3
#define P7TSEL0                 CCPTMRS1bits.P7TSEL0            // bit 4
#define P7TSEL1                 CCPTMRS1bits.P7TSEL1            // bit 5

#define LC1G1D1N                CLC1GLS0bits.LC1G1D1N           // bit 0, shadows bit in CLC1GLS0bits
#define D1N                     CLC1GLS0bits.D1N                // bit 0, shadows bit in CLC1GLS0bits
#define LC1G1D1T                CLC1GLS0bits.LC1G1D1T           // bit 1, shadows bit in CLC1GLS0bits
#define D1T                     CLC1GLS0bits.D1T                // bit 1, shadows bit in CLC1GLS0bits
#define LC1G1D2N                CLC1GLS0bits.LC1G1D2N           // bit 2, shadows bit in CLC1GLS0bits
#define D2N                     CLC1GLS0bits.D2N                // bit 2, shadows bit in CLC1GLS0bits
#define LC1G1D2T                CLC1GLS0bits.LC1G1D2T           // bit 3, shadows bit in CLC1GLS0bits
#define D2T                     CLC1GLS0bits.D2T                // bit 3, shadows bit in CLC1GLS0bits
#define LC1G1D3N                CLC1GLS0bits.LC1G1D3N           // bit 4, shadows bit in CLC1GLS0bits
#define D3N                     CLC1GLS0bits.D3N                // bit 4, shadows bit in CLC1GLS0bits
#define LC1G1D3T                CLC1GLS0bits.LC1G1D3T           // bit 5, shadows bit in CLC1GLS0bits
#define D3T                     CLC1GLS0bits.D3T                // bit 5, shadows bit in CLC1GLS0bits
#define LC1G1D4N                CLC1GLS0bits.LC1G1D4N           // bit 6, shadows bit in CLC1GLS0bits
#define D4N                     CLC1GLS0bits.D4N                // bit 6, shadows bit in CLC1GLS0bits
#define LC1G1D4T                CLC1GLS0bits.LC1G1D4T           // bit 7, shadows bit in CLC1GLS0bits
#define D4T                     CLC1GLS0bits.D4T                // bit 7, shadows bit in CLC1GLS0bits

#define LC1G4D1N                CLC1GLS3bits.LC1G4D1N           // bit 0, shadows bit in CLC1GLS3bits
#define G4D1N                   CLC1GLS3bits.G4D1N              // bit 0, shadows bit in CLC1GLS3bits
#define LC1G4D1T                CLC1GLS3bits.LC1G4D1T           // bit 1, shadows bit in CLC1GLS3bits
#define G4D1T                   CLC1GLS3bits.G4D1T              // bit 1, shadows bit in CLC1GLS3bits
#define LC1G4D2N                CLC1GLS3bits.LC1G4D2N           // bit 2, shadows bit in CLC1GLS3bits
#define G4D2N                   CLC1GLS3bits.G4D2N              // bit 2, shadows bit in CLC1GLS3bits
#define LC1G4D2T                CLC1GLS3bits.LC1G4D2T           // bit 3, shadows bit in CLC1GLS3bits
#define G4D2T                   CLC1GLS3bits.G4D2T              // bit 3, shadows bit in CLC1GLS3bits
#define LC1G4D3N                CLC1GLS3bits.LC1G4D3N           // bit 4, shadows bit in CLC1GLS3bits
#define G4D3N                   CLC1GLS3bits.G4D3N              // bit 4, shadows bit in CLC1GLS3bits
#define LC1G4D3T                CLC1GLS3bits.LC1G4D3T           // bit 5, shadows bit in CLC1GLS3bits
#define G4D3T                   CLC1GLS3bits.G4D3T              // bit 5, shadows bit in CLC1GLS3bits
#define LC1G4D4N                CLC1GLS3bits.LC1G4D4N           // bit 6, shadows bit in CLC1GLS3bits
#define G4D4N                   CLC1GLS3bits.G4D4N              // bit 6, shadows bit in CLC1GLS3bits
#define LC1G4D4T                CLC1GLS3bits.LC1G4D4T           // bit 7, shadows bit in CLC1GLS3bits
#define G4D4T                   CLC1GLS3bits.G4D4T              // bit 7, shadows bit in CLC1GLS3bits

#define LC1G1POL                CLC1POLbits.LC1G1POL            // bit 0, shadows bit in CLC1POLbits
#define G1POL                   CLC1POLbits.G1POL               // bit 0, shadows bit in CLC1POLbits
#define LC1G2POL                CLC1POLbits.LC1G2POL            // bit 1, shadows bit in CLC1POLbits
#define G2POL                   CLC1POLbits.G2POL               // bit 1, shadows bit in CLC1POLbits
#define LC1G3POL                CLC1POLbits.LC1G3POL            // bit 2, shadows bit in CLC1POLbits
#define G3POL                   CLC1POLbits.G3POL               // bit 2, shadows bit in CLC1POLbits
#define LC1G4POL                CLC1POLbits.LC1G4POL            // bit 3, shadows bit in CLC1POLbits
#define G4POL                   CLC1POLbits.G4POL               // bit 3, shadows bit in CLC1POLbits
#define LC1POL                  CLC1POLbits.LC1POL              // bit 7, shadows bit in CLC1POLbits
#define POL                     CLC1POLbits.POL                 // bit 7, shadows bit in CLC1POLbits

#define LC1D1S0                 CLC1SEL0bits.LC1D1S0            // bit 0, shadows bit in CLC1SEL0bits
#define D1S0                    CLC1SEL0bits.D1S0               // bit 0, shadows bit in CLC1SEL0bits
#define LC1D1S1                 CLC1SEL0bits.LC1D1S1            // bit 1, shadows bit in CLC1SEL0bits
#define D1S1                    CLC1SEL0bits.D1S1               // bit 1, shadows bit in CLC1SEL0bits
#define LC1D1S2                 CLC1SEL0bits.LC1D1S2            // bit 2, shadows bit in CLC1SEL0bits
#define D1S2                    CLC1SEL0bits.D1S2               // bit 2, shadows bit in CLC1SEL0bits
#define LC1D1S3                 CLC1SEL0bits.LC1D1S3            // bit 3, shadows bit in CLC1SEL0bits
#define D1S3                    CLC1SEL0bits.D1S3               // bit 3, shadows bit in CLC1SEL0bits
#define LC1D1S4                 CLC1SEL0bits.LC1D1S4            // bit 4, shadows bit in CLC1SEL0bits
#define D1S4                    CLC1SEL0bits.D1S4               // bit 4, shadows bit in CLC1SEL0bits
#define LC1D1S5                 CLC1SEL0bits.LC1D1S5            // bit 5, shadows bit in CLC1SEL0bits
#define D1S5                    CLC1SEL0bits.D1S5               // bit 5, shadows bit in CLC1SEL0bits
#define LC1D1S6                 CLC1SEL0bits.LC1D1S6            // bit 6, shadows bit in CLC1SEL0bits
#define D1S6                    CLC1SEL0bits.D1S6               // bit 6, shadows bit in CLC1SEL0bits
#define LC1D1S7                 CLC1SEL0bits.LC1D1S7            // bit 7, shadows bit in CLC1SEL0bits
#define D1S7                    CLC1SEL0bits.D1S7               // bit 7, shadows bit in CLC1SEL0bits

#define LC1D2S0                 CLC1SEL1bits.LC1D2S0            // bit 0, shadows bit in CLC1SEL1bits
#define D2S0                    CLC1SEL1bits.D2S0               // bit 0, shadows bit in CLC1SEL1bits
#define LC1D2S1                 CLC1SEL1bits.LC1D2S1            // bit 1, shadows bit in CLC1SEL1bits
#define D2S1                    CLC1SEL1bits.D2S1               // bit 1, shadows bit in CLC1SEL1bits
#define LC1D2S2                 CLC1SEL1bits.LC1D2S2            // bit 2, shadows bit in CLC1SEL1bits
#define D2S2                    CLC1SEL1bits.D2S2               // bit 2, shadows bit in CLC1SEL1bits
#define LC1D2S3                 CLC1SEL1bits.LC1D2S3            // bit 3, shadows bit in CLC1SEL1bits
#define D2S3                    CLC1SEL1bits.D2S3               // bit 3, shadows bit in CLC1SEL1bits
#define LC1D2S4                 CLC1SEL1bits.LC1D2S4            // bit 4, shadows bit in CLC1SEL1bits
#define D2S4                    CLC1SEL1bits.D2S4               // bit 4, shadows bit in CLC1SEL1bits
#define LC1D2S5                 CLC1SEL1bits.LC1D2S5            // bit 5, shadows bit in CLC1SEL1bits
#define D2S5                    CLC1SEL1bits.D2S5               // bit 5, shadows bit in CLC1SEL1bits
#define LC1D2S6                 CLC1SEL1bits.LC1D2S6            // bit 6, shadows bit in CLC1SEL1bits
#define D2S6                    CLC1SEL1bits.D2S6               // bit 6, shadows bit in CLC1SEL1bits
#define LC1D2S7                 CLC1SEL1bits.LC1D2S7            // bit 7, shadows bit in CLC1SEL1bits
#define D2S7                    CLC1SEL1bits.D2S7               // bit 7, shadows bit in CLC1SEL1bits

#define LC1D3S0                 CLC1SEL2bits.LC1D3S0            // bit 0, shadows bit in CLC1SEL2bits
#define D3S0                    CLC1SEL2bits.D3S0               // bit 0, shadows bit in CLC1SEL2bits
#define LC1D3S1                 CLC1SEL2bits.LC1D3S1            // bit 1, shadows bit in CLC1SEL2bits
#define D3S1                    CLC1SEL2bits.D3S1               // bit 1, shadows bit in CLC1SEL2bits
#define LC1D3S2                 CLC1SEL2bits.LC1D3S2            // bit 2, shadows bit in CLC1SEL2bits
#define D3S2                    CLC1SEL2bits.D3S2               // bit 2, shadows bit in CLC1SEL2bits
#define LC1D3S3                 CLC1SEL2bits.LC1D3S3            // bit 3, shadows bit in CLC1SEL2bits
#define D3S3                    CLC1SEL2bits.D3S3               // bit 3, shadows bit in CLC1SEL2bits
#define LC1D3S4                 CLC1SEL2bits.LC1D3S4            // bit 4, shadows bit in CLC1SEL2bits
#define D3S4                    CLC1SEL2bits.D3S4               // bit 4, shadows bit in CLC1SEL2bits
#define LC1D3S5                 CLC1SEL2bits.LC1D3S5            // bit 5, shadows bit in CLC1SEL2bits
#define D3S5                    CLC1SEL2bits.D3S5               // bit 5, shadows bit in CLC1SEL2bits
#define LC1D3S6                 CLC1SEL2bits.LC1D3S6            // bit 6, shadows bit in CLC1SEL2bits
#define D3S6                    CLC1SEL2bits.D3S6               // bit 6, shadows bit in CLC1SEL2bits
#define LC1D3S7                 CLC1SEL2bits.LC1D3S7            // bit 7, shadows bit in CLC1SEL2bits
#define D3S7                    CLC1SEL2bits.D3S7               // bit 7, shadows bit in CLC1SEL2bits

#define LC1D4S0                 CLC1SEL3bits.LC1D4S0            // bit 0, shadows bit in CLC1SEL3bits
#define D4S0                    CLC1SEL3bits.D4S0               // bit 0, shadows bit in CLC1SEL3bits
#define LC1D4S1                 CLC1SEL3bits.LC1D4S1            // bit 1, shadows bit in CLC1SEL3bits
#define D4S1                    CLC1SEL3bits.D4S1               // bit 1, shadows bit in CLC1SEL3bits
#define LC1D4S2                 CLC1SEL3bits.LC1D4S2            // bit 2, shadows bit in CLC1SEL3bits
#define D4S2                    CLC1SEL3bits.D4S2               // bit 2, shadows bit in CLC1SEL3bits
#define LC1D4S3                 CLC1SEL3bits.LC1D4S3            // bit 3, shadows bit in CLC1SEL3bits
#define D4S3                    CLC1SEL3bits.D4S3               // bit 3, shadows bit in CLC1SEL3bits
#define LC1D4S4                 CLC1SEL3bits.LC1D4S4            // bit 4, shadows bit in CLC1SEL3bits
#define D4S4                    CLC1SEL3bits.D4S4               // bit 4, shadows bit in CLC1SEL3bits
#define LC1D4S5                 CLC1SEL3bits.LC1D4S5            // bit 5, shadows bit in CLC1SEL3bits
#define D4S5                    CLC1SEL3bits.D4S5               // bit 5, shadows bit in CLC1SEL3bits
#define LC1D4S6                 CLC1SEL3bits.LC1D4S6            // bit 6, shadows bit in CLC1SEL3bits
#define D4S6                    CLC1SEL3bits.D4S6               // bit 6, shadows bit in CLC1SEL3bits
#define LC1D4S7                 CLC1SEL3bits.LC1D4S7            // bit 7, shadows bit in CLC1SEL3bits
#define D4S7                    CLC1SEL3bits.D4S7               // bit 7, shadows bit in CLC1SEL3bits

#define MLC1OUT                 CLCDATAbits.MLC1OUT             // bit 0
#define MLC2OUT                 CLCDATAbits.MLC2OUT             // bit 1
#define MLC3OUT                 CLCDATAbits.MLC3OUT             // bit 2
#define MLC4OUT                 CLCDATAbits.MLC4OUT             // bit 3

#define CLCIN0PPS0              CLCIN0PPSbits.CLCIN0PPS0        // bit 0
#define CLCIN0PPS1              CLCIN0PPSbits.CLCIN0PPS1        // bit 1
#define CLCIN0PPS2              CLCIN0PPSbits.CLCIN0PPS2        // bit 2
#define CLCIN0PPS3              CLCIN0PPSbits.CLCIN0PPS3        // bit 3
#define CLCIN0PPS4              CLCIN0PPSbits.CLCIN0PPS4        // bit 4

#define CLCIN1PPS0              CLCIN1PPSbits.CLCIN1PPS0        // bit 0
#define CLCIN1PPS1              CLCIN1PPSbits.CLCIN1PPS1        // bit 1
#define CLCIN1PPS2              CLCIN1PPSbits.CLCIN1PPS2        // bit 2
#define CLCIN1PPS3              CLCIN1PPSbits.CLCIN1PPS3        // bit 3
#define CLCIN1PPS4              CLCIN1PPSbits.CLCIN1PPS4        // bit 4

#define CLCIN2PPS0              CLCIN2PPSbits.CLCIN2PPS0        // bit 0
#define CLCIN2PPS1              CLCIN2PPSbits.CLCIN2PPS1        // bit 1
#define CLCIN2PPS2              CLCIN2PPSbits.CLCIN2PPS2        // bit 2
#define CLCIN2PPS3              CLCIN2PPSbits.CLCIN2PPS3        // bit 3
#define CLCIN2PPS4              CLCIN2PPSbits.CLCIN2PPS4        // bit 4

#define CLCIN3PPS0              CLCIN3PPSbits.CLCIN3PPS0        // bit 0
#define CLCIN3PPS1              CLCIN3PPSbits.CLCIN3PPS1        // bit 1
#define CLCIN3PPS2              CLCIN3PPSbits.CLCIN3PPS2        // bit 2
#define CLCIN3PPS3              CLCIN3PPSbits.CLCIN3PPS3        // bit 3
#define CLCIN3PPS4              CLCIN3PPSbits.CLCIN3PPS4        // bit 4

#define CLKRCLK0                CLKRCLKbits.CLKRCLK0            // bit 0
#define CLKRCLK1                CLKRCLKbits.CLKRCLK1            // bit 1
#define CLKRCLK2                CLKRCLKbits.CLKRCLK2            // bit 2
#define CLKRCLK3                CLKRCLKbits.CLKRCLK3            // bit 3

#define CLKRDIV0                CLKRCONbits.CLKRDIV0            // bit 0
#define CLKRDIV1                CLKRCONbits.CLKRDIV1            // bit 1
#define CLKRDIV2                CLKRCONbits.CLKRDIV2            // bit 2
#define CLKRDC0                 CLKRCONbits.CLKRDC0             // bit 3
#define CLKRDC1                 CLKRCONbits.CLKRDC1             // bit 4
#define CLKREN                  CLKRCONbits.CLKREN              // bit 7

#define NCH0                    CM1NSELbits.NCH0                // bit 0, shadows bit in CM1NSELbits
#define C1NCH0                  CM1NSELbits.C1NCH0              // bit 0, shadows bit in CM1NSELbits
#define NCH1                    CM1NSELbits.NCH1                // bit 1, shadows bit in CM1NSELbits
#define C1NCH1                  CM1NSELbits.C1NCH1              // bit 1, shadows bit in CM1NSELbits
#define NCH2                    CM1NSELbits.NCH2                // bit 2, shadows bit in CM1NSELbits
#define C1NCH2                  CM1NSELbits.C1NCH2              // bit 2, shadows bit in CM1NSELbits

#define PCH0                    CM1PSELbits.PCH0                // bit 0, shadows bit in CM1PSELbits
#define C1PCH0                  CM1PSELbits.C1PCH0              // bit 0, shadows bit in CM1PSELbits
#define PCH1                    CM1PSELbits.PCH1                // bit 1, shadows bit in CM1PSELbits
#define C1PCH1                  CM1PSELbits.C1PCH1              // bit 1, shadows bit in CM1PSELbits
#define PCH2                    CM1PSELbits.PCH2                // bit 2, shadows bit in CM1PSELbits
#define C1PCH2                  CM1PSELbits.C1PCH2              // bit 2, shadows bit in CM1PSELbits

#define DOZE0                   CPUDOZEbits.DOZE0               // bit 0
#define DOZE1                   CPUDOZEbits.DOZE1               // bit 1
#define DOZE2                   CPUDOZEbits.DOZE2               // bit 2
#define DOE                     CPUDOZEbits.DOE                 // bit 4
#define ROI                     CPUDOZEbits.ROI                 // bit 5
#define DOZEN                   CPUDOZEbits.DOZEN               // bit 6
#define IDLEN                   CPUDOZEbits.IDLEN               // bit 7

#define ACC8                    CRCACCHbits.ACC8                // bit 0
#define ACC9                    CRCACCHbits.ACC9                // bit 1
#define ACC10                   CRCACCHbits.ACC10               // bit 2
#define ACC11                   CRCACCHbits.ACC11               // bit 3
#define ACC12                   CRCACCHbits.ACC12               // bit 4
#define ACC13                   CRCACCHbits.ACC13               // bit 5
#define ACC14                   CRCACCHbits.ACC14               // bit 6
#define ACC15                   CRCACCHbits.ACC15               // bit 7

#define ACC0                    CRCACCLbits.ACC0                // bit 0
#define ACC1                    CRCACCLbits.ACC1                // bit 1
#define ACC2                    CRCACCLbits.ACC2                // bit 2
#define ACC3                    CRCACCLbits.ACC3                // bit 3
#define ACC4                    CRCACCLbits.ACC4                // bit 4
#define ACC5                    CRCACCLbits.ACC5                // bit 5
#define ACC6                    CRCACCLbits.ACC6                // bit 6
#define ACC7                    CRCACCLbits.ACC7                // bit 7

#define PLEN0                   CRCCON1bits.PLEN0               // bit 0
#define PLEN1                   CRCCON1bits.PLEN1               // bit 1
#define PLEN2                   CRCCON1bits.PLEN2               // bit 2
#define PLEN3                   CRCCON1bits.PLEN3               // bit 3
#define DLEN0                   CRCCON1bits.DLEN0               // bit 4
#define DLEN1                   CRCCON1bits.DLEN1               // bit 5
#define DLEN2                   CRCCON1bits.DLEN2               // bit 6
#define DLEN3                   CRCCON1bits.DLEN3               // bit 7

#define DATA8                   CRCDATHbits.DATA8               // bit 0
#define DATA9                   CRCDATHbits.DATA9               // bit 1
#define DATA10                  CRCDATHbits.DATA10              // bit 2
#define DATA11                  CRCDATHbits.DATA11              // bit 3
#define DATA12                  CRCDATHbits.DATA12              // bit 4
#define DATA13                  CRCDATHbits.DATA13              // bit 5
#define DATA14                  CRCDATHbits.DATA14              // bit 6
#define DATA15                  CRCDATHbits.DATA15              // bit 7

#define DATA0                   CRCDATLbits.DATA0               // bit 0
#define DATA1                   CRCDATLbits.DATA1               // bit 1
#define DATA2                   CRCDATLbits.DATA2               // bit 2
#define DATA3                   CRCDATLbits.DATA3               // bit 3
#define DATA4                   CRCDATLbits.DATA4               // bit 4
#define DATA5                   CRCDATLbits.DATA5               // bit 5
#define DATA6                   CRCDATLbits.DATA6               // bit 6
#define DATA7                   CRCDATLbits.DATA7               // bit 7

#define SHFT8                   CRCSHIFTHbits.SHFT8             // bit 0
#define SHFT9                   CRCSHIFTHbits.SHFT9             // bit 1
#define SHFT10                  CRCSHIFTHbits.SHFT10            // bit 2
#define SHFT11                  CRCSHIFTHbits.SHFT11            // bit 3
#define SHFT12                  CRCSHIFTHbits.SHFT12            // bit 4
#define SHFT13                  CRCSHIFTHbits.SHFT13            // bit 5
#define SHFT14                  CRCSHIFTHbits.SHFT14            // bit 6
#define SHFT15                  CRCSHIFTHbits.SHFT15            // bit 7

#define SHFT0                   CRCSHIFTLbits.SHFT0             // bit 0
#define SHFT1                   CRCSHIFTLbits.SHFT1             // bit 1
#define SHFT2                   CRCSHIFTLbits.SHFT2             // bit 2
#define SHFT3                   CRCSHIFTLbits.SHFT3             // bit 3
#define SHFT4                   CRCSHIFTLbits.SHFT4             // bit 4
#define SHFT5                   CRCSHIFTLbits.SHFT5             // bit 5
#define SHFT6                   CRCSHIFTLbits.SHFT6             // bit 6
#define SHFT7                   CRCSHIFTLbits.SHFT7             // bit 7

#define X8                      CRCXORHbits.X8                  // bit 0
#define X9                      CRCXORHbits.X9                  // bit 1
#define X10                     CRCXORHbits.X10                 // bit 2
#define X11                     CRCXORHbits.X11                 // bit 3
#define X12                     CRCXORHbits.X12                 // bit 4
#define X13                     CRCXORHbits.X13                 // bit 5
#define X14                     CRCXORHbits.X14                 // bit 6
#define X15                     CRCXORHbits.X15                 // bit 7

#define X1                      CRCXORLbits.X1                  // bit 1
#define X2                      CRCXORLbits.X2                  // bit 2
#define X3                      CRCXORLbits.X3                  // bit 3
#define X4                      CRCXORLbits.X4                  // bit 4
#define X5                      CRCXORLbits.X5                  // bit 5
#define X6                      CRCXORLbits.X6                  // bit 6
#define X7                      CRCXORLbits.X7                  // bit 7

#define LSAC0                   CWG1AS0bits.LSAC0               // bit 2, shadows bit in CWG1AS0bits
#define CWG1LSAC0               CWG1AS0bits.CWG1LSAC0           // bit 2, shadows bit in CWG1AS0bits
#define LSAC1                   CWG1AS0bits.LSAC1               // bit 3, shadows bit in CWG1AS0bits
#define CWG1LSAC1               CWG1AS0bits.CWG1LSAC1           // bit 3, shadows bit in CWG1AS0bits
#define LSBD0                   CWG1AS0bits.LSBD0               // bit 4, shadows bit in CWG1AS0bits
#define CWG1LSBD0               CWG1AS0bits.CWG1LSBD0           // bit 4, shadows bit in CWG1AS0bits
#define LSBD1                   CWG1AS0bits.LSBD1               // bit 5, shadows bit in CWG1AS0bits
#define CWG1LSBD1               CWG1AS0bits.CWG1LSBD1           // bit 5, shadows bit in CWG1AS0bits
#define REN                     CWG1AS0bits.REN                 // bit 6, shadows bit in CWG1AS0bits
#define CWG1REN                 CWG1AS0bits.CWG1REN             // bit 6, shadows bit in CWG1AS0bits
#define SHUTDOWN                CWG1AS0bits.SHUTDOWN            // bit 7, shadows bit in CWG1AS0bits
#define CWG1SHUTDOWN            CWG1AS0bits.CWG1SHUTDOWN        // bit 7, shadows bit in CWG1AS0bits

#define AS0E                    CWG1AS1bits.AS0E                // bit 0
#define AS1E                    CWG1AS1bits.AS1E                // bit 1
#define AS2E                    CWG1AS1bits.AS2E                // bit 2
#define AS3E                    CWG1AS1bits.AS3E                // bit 3
#define AS4E                    CWG1AS1bits.AS4E                // bit 4
#define AS5E                    CWG1AS1bits.AS5E                // bit 5
#define AS6E                    CWG1AS1bits.AS6E                // bit 6

#define CS                      CWG1CLKCONbits.CS               // bit 0, shadows bit in CWG1CLKCONbits
#define CWG1CS                  CWG1CLKCONbits.CWG1CS           // bit 0, shadows bit in CWG1CLKCONbits

#define POLA                    CWG1CON1bits.POLA               // bit 0, shadows bit in CWG1CON1bits
#define CWG1POLA                CWG1CON1bits.CWG1POLA           // bit 0, shadows bit in CWG1CON1bits
#define POLB                    CWG1CON1bits.POLB               // bit 1, shadows bit in CWG1CON1bits
#define CWG1POLB                CWG1CON1bits.CWG1POLB           // bit 1, shadows bit in CWG1CON1bits
#define POLC                    CWG1CON1bits.POLC               // bit 2, shadows bit in CWG1CON1bits
#define CWG1POLC                CWG1CON1bits.CWG1POLC           // bit 2, shadows bit in CWG1CON1bits
#define POLD                    CWG1CON1bits.POLD               // bit 3, shadows bit in CWG1CON1bits
#define CWG1POLD                CWG1CON1bits.CWG1POLD           // bit 3, shadows bit in CWG1CON1bits
#define IN                      CWG1CON1bits.IN                 // bit 5, shadows bit in CWG1CON1bits
#define CWG1IN                  CWG1CON1bits.CWG1IN             // bit 5, shadows bit in CWG1CON1bits

#define DBF0                    CWG1DBFbits.DBF0                // bit 0, shadows bit in CWG1DBFbits
#define CWG1DBF0                CWG1DBFbits.CWG1DBF0            // bit 0, shadows bit in CWG1DBFbits
#define DBF1                    CWG1DBFbits.DBF1                // bit 1, shadows bit in CWG1DBFbits
#define CWG1DBF1                CWG1DBFbits.CWG1DBF1            // bit 1, shadows bit in CWG1DBFbits
#define DBF2                    CWG1DBFbits.DBF2                // bit 2, shadows bit in CWG1DBFbits
#define CWG1DBF2                CWG1DBFbits.CWG1DBF2            // bit 2, shadows bit in CWG1DBFbits
#define DBF3                    CWG1DBFbits.DBF3                // bit 3, shadows bit in CWG1DBFbits
#define CWG1DBF3                CWG1DBFbits.CWG1DBF3            // bit 3, shadows bit in CWG1DBFbits
#define DBF4                    CWG1DBFbits.DBF4                // bit 4, shadows bit in CWG1DBFbits
#define CWG1DBF4                CWG1DBFbits.CWG1DBF4            // bit 4, shadows bit in CWG1DBFbits
#define DBF5                    CWG1DBFbits.DBF5                // bit 5, shadows bit in CWG1DBFbits
#define CWG1DBF5                CWG1DBFbits.CWG1DBF5            // bit 5, shadows bit in CWG1DBFbits

#define DBR0                    CWG1DBRbits.DBR0                // bit 0, shadows bit in CWG1DBRbits
#define CWG1DBR0                CWG1DBRbits.CWG1DBR0            // bit 0, shadows bit in CWG1DBRbits
#define DBR1                    CWG1DBRbits.DBR1                // bit 1, shadows bit in CWG1DBRbits
#define CWG1DBR1                CWG1DBRbits.CWG1DBR1            // bit 1, shadows bit in CWG1DBRbits
#define DBR2                    CWG1DBRbits.DBR2                // bit 2, shadows bit in CWG1DBRbits
#define CWG1DBR2                CWG1DBRbits.CWG1DBR2            // bit 2, shadows bit in CWG1DBRbits
#define DBR3                    CWG1DBRbits.DBR3                // bit 3, shadows bit in CWG1DBRbits
#define CWG1DBR3                CWG1DBRbits.CWG1DBR3            // bit 3, shadows bit in CWG1DBRbits
#define DBR4                    CWG1DBRbits.DBR4                // bit 4, shadows bit in CWG1DBRbits
#define CWG1DBR4                CWG1DBRbits.CWG1DBR4            // bit 4, shadows bit in CWG1DBRbits
#define DBR5                    CWG1DBRbits.DBR5                // bit 5, shadows bit in CWG1DBRbits
#define CWG1DBR5                CWG1DBRbits.CWG1DBR5            // bit 5, shadows bit in CWG1DBRbits

#define CWG1ISM0                CWG1ISMbits.CWG1ISM0            // bit 0
#define CWG1ISM1                CWG1ISMbits.CWG1ISM1            // bit 1
#define CWG1ISM2                CWG1ISMbits.CWG1ISM2            // bit 2
#define CWG1ISM3                CWG1ISMbits.CWG1ISM3            // bit 3

#define CWG1PPS0                CWG1PPSbits.CWG1PPS0            // bit 0
#define CWG1PPS1                CWG1PPSbits.CWG1PPS1            // bit 1
#define CWG1PPS2                CWG1PPSbits.CWG1PPS2            // bit 2
#define CWG1PPS3                CWG1PPSbits.CWG1PPS3            // bit 3
#define CWG1PPS4                CWG1PPSbits.CWG1PPS4            // bit 4

#define STRA                    CWG1STRbits.STRA                // bit 0, shadows bit in CWG1STRbits
#define CWG1STRA                CWG1STRbits.CWG1STRA            // bit 0, shadows bit in CWG1STRbits
#define STRB                    CWG1STRbits.STRB                // bit 1, shadows bit in CWG1STRbits
#define CWG1STRB                CWG1STRbits.CWG1STRB            // bit 1, shadows bit in CWG1STRbits
#define STRC                    CWG1STRbits.STRC                // bit 2, shadows bit in CWG1STRbits
#define CWG1STRC                CWG1STRbits.CWG1STRC            // bit 2, shadows bit in CWG1STRbits
#define STRD                    CWG1STRbits.STRD                // bit 3, shadows bit in CWG1STRbits
#define CWG1STRD                CWG1STRbits.CWG1STRD            // bit 3, shadows bit in CWG1STRbits
#define OVRA                    CWG1STRbits.OVRA                // bit 4, shadows bit in CWG1STRbits
#define CWG1OVRA                CWG1STRbits.CWG1OVRA            // bit 4, shadows bit in CWG1STRbits
#define OVRB                    CWG1STRbits.OVRB                // bit 5, shadows bit in CWG1STRbits
#define CWG1OVRB                CWG1STRbits.CWG1OVRB            // bit 5, shadows bit in CWG1STRbits
#define OVRC                    CWG1STRbits.OVRC                // bit 6, shadows bit in CWG1STRbits
#define CWG1OVRC                CWG1STRbits.CWG1OVRC            // bit 6, shadows bit in CWG1STRbits
#define OVRD                    CWG1STRbits.OVRD                // bit 7, shadows bit in CWG1STRbits
#define CWG1OVRD                CWG1STRbits.CWG1OVRD            // bit 7, shadows bit in CWG1STRbits

#define CWG2ISM0                CWG2ISMbits.CWG2ISM0            // bit 0
#define CWG2ISM1                CWG2ISMbits.CWG2ISM1            // bit 1
#define CWG2ISM2                CWG2ISMbits.CWG2ISM2            // bit 2
#define CWG2ISM3                CWG2ISMbits.CWG2ISM3            // bit 3

#define CWG2PPS0                CWG2PPSbits.CWG2PPS0            // bit 0
#define CWG2PPS1                CWG2PPSbits.CWG2PPS1            // bit 1
#define CWG2PPS2                CWG2PPSbits.CWG2PPS2            // bit 2
#define CWG2PPS3                CWG2PPSbits.CWG2PPS3            // bit 3
#define CWG2PPS4                CWG2PPSbits.CWG2PPS4            // bit 4

#define CWG3ISM0                CWG3ISMbits.CWG3ISM0            // bit 0
#define CWG3ISM1                CWG3ISMbits.CWG3ISM1            // bit 1
#define CWG3ISM2                CWG3ISMbits.CWG3ISM2            // bit 2
#define CWG3ISM3                CWG3ISMbits.CWG3ISM3            // bit 3

#define CWG3PPS0                CWG3PPSbits.CWG3PPS0            // bit 0
#define CWG3PPS1                CWG3PPSbits.CWG3PPS1            // bit 1
#define CWG3PPS2                CWG3PPSbits.CWG3PPS2            // bit 2
#define CWG3PPS3                CWG3PPSbits.CWG3PPS3            // bit 3
#define CWG3PPS4                CWG3PPSbits.CWG3PPS4            // bit 4

#define DAC1R0                  DAC1CON1bits.DAC1R0             // bit 0
#define DAC1R1                  DAC1CON1bits.DAC1R1             // bit 1
#define DAC1R2                  DAC1CON1bits.DAC1R2             // bit 2
#define DAC1R3                  DAC1CON1bits.DAC1R3             // bit 3
#define DAC1R4                  DAC1CON1bits.DAC1R4             // bit 4

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define CDAFVR0                 FVRCONbits.CDAFVR0              // bit 2
#define CDAFVR1                 FVRCONbits.CDAFVR1              // bit 3
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define INLVLA0                 INLVLAbits.INLVLA0              // bit 0
#define INLVLA1                 INLVLAbits.INLVLA1              // bit 1
#define INLVLA2                 INLVLAbits.INLVLA2              // bit 2
#define INLVLA3                 INLVLAbits.INLVLA3              // bit 3
#define INLVLA4                 INLVLAbits.INLVLA4              // bit 4
#define INLVLA5                 INLVLAbits.INLVLA5              // bit 5
#define INLVLA6                 INLVLAbits.INLVLA6              // bit 6
#define INLVLA7                 INLVLAbits.INLVLA7              // bit 7

#define INLVLB0                 INLVLBbits.INLVLB0              // bit 0
#define INLVLB1                 INLVLBbits.INLVLB1              // bit 1
#define INLVLB2                 INLVLBbits.INLVLB2              // bit 2
#define INLVLB3                 INLVLBbits.INLVLB3              // bit 3
#define INLVLB4                 INLVLBbits.INLVLB4              // bit 4
#define INLVLB5                 INLVLBbits.INLVLB5              // bit 5
#define INLVLB6                 INLVLBbits.INLVLB6              // bit 6
#define INLVLB7                 INLVLBbits.INLVLB7              // bit 7

#define INLVLC0                 INLVLCbits.INLVLC0              // bit 0
#define INLVLC1                 INLVLCbits.INLVLC1              // bit 1
#define INLVLC2                 INLVLCbits.INLVLC2              // bit 2
#define INLVLC3                 INLVLCbits.INLVLC3              // bit 3
#define INLVLC4                 INLVLCbits.INLVLC4              // bit 4
#define INLVLC5                 INLVLCbits.INLVLC5              // bit 5
#define INLVLC6                 INLVLCbits.INLVLC6              // bit 6
#define INLVLC7                 INLVLCbits.INLVLC7              // bit 7

#define INLVLE3                 INLVLEbits.INLVLE3              // bit 3

#define INTEDG                  INTCONbits.INTEDG               // bit 0
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define INTPPS0                 INTPPSbits.INTPPS0              // bit 0
#define INTPPS1                 INTPPSbits.INTPPS1              // bit 1
#define INTPPS2                 INTPPSbits.INTPPS2              // bit 2
#define INTPPS3                 INTPPSbits.INTPPS3              // bit 3

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5
#define IOCAF6                  IOCAFbits.IOCAF6                // bit 6
#define IOCAF7                  IOCAFbits.IOCAF7                // bit 7

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5
#define IOCAN6                  IOCANbits.IOCAN6                // bit 6
#define IOCAN7                  IOCANbits.IOCAN7                // bit 7

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5
#define IOCAP6                  IOCAPbits.IOCAP6                // bit 6
#define IOCAP7                  IOCAPbits.IOCAP7                // bit 7

#define IOCBF0                  IOCBFbits.IOCBF0                // bit 0
#define IOCBF1                  IOCBFbits.IOCBF1                // bit 1
#define IOCBF2                  IOCBFbits.IOCBF2                // bit 2
#define IOCBF3                  IOCBFbits.IOCBF3                // bit 3
#define IOCBF4                  IOCBFbits.IOCBF4                // bit 4
#define IOCBF5                  IOCBFbits.IOCBF5                // bit 5
#define IOCBF6                  IOCBFbits.IOCBF6                // bit 6
#define IOCBF7                  IOCBFbits.IOCBF7                // bit 7

#define IOCBN0                  IOCBNbits.IOCBN0                // bit 0
#define IOCBN1                  IOCBNbits.IOCBN1                // bit 1
#define IOCBN2                  IOCBNbits.IOCBN2                // bit 2
#define IOCBN3                  IOCBNbits.IOCBN3                // bit 3
#define IOCBN4                  IOCBNbits.IOCBN4                // bit 4
#define IOCBN5                  IOCBNbits.IOCBN5                // bit 5
#define IOCBN6                  IOCBNbits.IOCBN6                // bit 6
#define IOCBN7                  IOCBNbits.IOCBN7                // bit 7

#define IOCBP0                  IOCBPbits.IOCBP0                // bit 0
#define IOCBP1                  IOCBPbits.IOCBP1                // bit 1
#define IOCBP2                  IOCBPbits.IOCBP2                // bit 2
#define IOCBP3                  IOCBPbits.IOCBP3                // bit 3
#define IOCBP4                  IOCBPbits.IOCBP4                // bit 4
#define IOCBP5                  IOCBPbits.IOCBP5                // bit 5
#define IOCBP6                  IOCBPbits.IOCBP6                // bit 6
#define IOCBP7                  IOCBPbits.IOCBP7                // bit 7

#define IOCCF0                  IOCCFbits.IOCCF0                // bit 0
#define IOCCF1                  IOCCFbits.IOCCF1                // bit 1
#define IOCCF2                  IOCCFbits.IOCCF2                // bit 2
#define IOCCF3                  IOCCFbits.IOCCF3                // bit 3
#define IOCCF4                  IOCCFbits.IOCCF4                // bit 4
#define IOCCF5                  IOCCFbits.IOCCF5                // bit 5
#define IOCCF6                  IOCCFbits.IOCCF6                // bit 6
#define IOCCF7                  IOCCFbits.IOCCF7                // bit 7

#define IOCCN0                  IOCCNbits.IOCCN0                // bit 0
#define IOCCN1                  IOCCNbits.IOCCN1                // bit 1
#define IOCCN2                  IOCCNbits.IOCCN2                // bit 2
#define IOCCN3                  IOCCNbits.IOCCN3                // bit 3
#define IOCCN4                  IOCCNbits.IOCCN4                // bit 4
#define IOCCN5                  IOCCNbits.IOCCN5                // bit 5
#define IOCCN6                  IOCCNbits.IOCCN6                // bit 6
#define IOCCN7                  IOCCNbits.IOCCN7                // bit 7

#define IOCCP0                  IOCCPbits.IOCCP0                // bit 0
#define IOCCP1                  IOCCPbits.IOCCP1                // bit 1
#define IOCCP2                  IOCCPbits.IOCCP2                // bit 2
#define IOCCP3                  IOCCPbits.IOCCP3                // bit 3
#define IOCCP4                  IOCCPbits.IOCCP4                // bit 4
#define IOCCP5                  IOCCPbits.IOCCP5                // bit 5
#define IOCCP6                  IOCCPbits.IOCCP6                // bit 6
#define IOCCP7                  IOCCPbits.IOCCP7                // bit 7

#define IOCEF3                  IOCEFbits.IOCEF3                // bit 3

#define IOCEN3                  IOCENbits.IOCEN3                // bit 3

#define IOCEP3                  IOCEPbits.IOCEP3                // bit 3

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA3                   LATAbits.LATA3                  // bit 3
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5
#define LATA6                   LATAbits.LATA6                  // bit 6
#define LATA7                   LATAbits.LATA7                  // bit 7

#define LATB0                   LATBbits.LATB0                  // bit 0
#define LATB1                   LATBbits.LATB1                  // bit 1
#define LATB2                   LATBbits.LATB2                  // bit 2
#define LATB3                   LATBbits.LATB3                  // bit 3
#define LATB4                   LATBbits.LATB4                  // bit 4
#define LATB5                   LATBbits.LATB5                  // bit 5
#define LATB6                   LATBbits.LATB6                  // bit 6
#define LATB7                   LATBbits.LATB7                  // bit 7

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5
#define LATC6                   LATCbits.LATC6                  // bit 6
#define LATC7                   LATCbits.LATC7                  // bit 7

#define MDCH0                   MDCARHbits.MDCH0                // bit 0
#define MDCH1                   MDCARHbits.MDCH1                // bit 1
#define MDCH2                   MDCARHbits.MDCH2                // bit 2
#define MDCH3                   MDCARHbits.MDCH3                // bit 3

#define MDCARHPPS0              MDCARHPPSbits.MDCARHPPS0        // bit 0
#define MDCARHPPS1              MDCARHPPSbits.MDCARHPPS1        // bit 1
#define MDCARHPPS2              MDCARHPPSbits.MDCARHPPS2        // bit 2
#define MDCARHPPS3              MDCARHPPSbits.MDCARHPPS3        // bit 3
#define MDCARHPPS4              MDCARHPPSbits.MDCARHPPS4        // bit 4

#define MDCL0                   MDCARLbits.MDCL0                // bit 0
#define MDCL1                   MDCARLbits.MDCL1                // bit 1
#define MDCL2                   MDCARLbits.MDCL2                // bit 2
#define MDCL3                   MDCARLbits.MDCL3                // bit 3

#define MDCARLPPS0              MDCARLPPSbits.MDCARLPPS0        // bit 0
#define MDCARLPPS1              MDCARLPPSbits.MDCARLPPS1        // bit 1
#define MDCARLPPS2              MDCARLPPSbits.MDCARLPPS2        // bit 2
#define MDCARLPPS3              MDCARLPPSbits.MDCARLPPS3        // bit 3
#define MDCARLPPS4              MDCARLPPSbits.MDCARLPPS4        // bit 4

#define MDBIT                   MDCON0bits.MDBIT                // bit 0
#define MDOPOL                  MDCON0bits.MDOPOL               // bit 4
#define MDOUT                   MDCON0bits.MDOUT                // bit 5
#define MDEN                    MDCON0bits.MDEN                 // bit 7

#define MDCLSYNC                MDCON1bits.MDCLSYNC             // bit 0
#define MDCLPOL                 MDCON1bits.MDCLPOL              // bit 1
#define MDCHSYNC                MDCON1bits.MDCHSYNC             // bit 4
#define MDCHPOL                 MDCON1bits.MDCHPOL              // bit 5

#define MDMS0                   MDSRCbits.MDMS0                 // bit 0
#define MDMS1                   MDSRCbits.MDMS1                 // bit 1
#define MDMS2                   MDSRCbits.MDMS2                 // bit 2
#define MDMS3                   MDSRCbits.MDMS3                 // bit 3
#define MDMS4                   MDSRCbits.MDMS4                 // bit 4

#define MDSRCPPS0               MDSRCPPSbits.MDSRCPPS0          // bit 0
#define MDSRCPPS1               MDSRCPPSbits.MDSRCPPS1          // bit 1
#define MDSRCPPS2               MDSRCPPSbits.MDSRCPPS2          // bit 2
#define MDSRCPPS3               MDSRCPPSbits.MDSRCPPS3          // bit 3
#define MDSRCPPS4               MDSRCPPSbits.MDSRCPPS4          // bit 4

#define NCO1ACC8                NCO1ACCHbits.NCO1ACC8           // bit 0
#define NCO1ACC9                NCO1ACCHbits.NCO1ACC9           // bit 1
#define NCO1ACC10               NCO1ACCHbits.NCO1ACC10          // bit 2
#define NCO1ACC11               NCO1ACCHbits.NCO1ACC11          // bit 3
#define NCO1ACC12               NCO1ACCHbits.NCO1ACC12          // bit 4
#define NCO1ACC13               NCO1ACCHbits.NCO1ACC13          // bit 5
#define NCO1ACC14               NCO1ACCHbits.NCO1ACC14          // bit 6
#define NCO1ACC15               NCO1ACCHbits.NCO1ACC15          // bit 7

#define NCO1ACC0                NCO1ACCLbits.NCO1ACC0           // bit 0
#define NCO1ACC1                NCO1ACCLbits.NCO1ACC1           // bit 1
#define NCO1ACC2                NCO1ACCLbits.NCO1ACC2           // bit 2
#define NCO1ACC3                NCO1ACCLbits.NCO1ACC3           // bit 3
#define NCO1ACC4                NCO1ACCLbits.NCO1ACC4           // bit 4
#define NCO1ACC5                NCO1ACCLbits.NCO1ACC5           // bit 5
#define NCO1ACC6                NCO1ACCLbits.NCO1ACC6           // bit 6
#define NCO1ACC7                NCO1ACCLbits.NCO1ACC7           // bit 7

#define NCO1ACC16               NCO1ACCUbits.NCO1ACC16          // bit 0
#define NCO1ACC17               NCO1ACCUbits.NCO1ACC17          // bit 1
#define NCO1ACC18               NCO1ACCUbits.NCO1ACC18          // bit 2
#define NCO1ACC19               NCO1ACCUbits.NCO1ACC19          // bit 3

#define N1CKS0                  NCO1CLKbits.N1CKS0              // bit 0
#define N1CKS1                  NCO1CLKbits.N1CKS1              // bit 1
#define N1CKS2                  NCO1CLKbits.N1CKS2              // bit 2
#define N1PWS0                  NCO1CLKbits.N1PWS0              // bit 5
#define N1PWS1                  NCO1CLKbits.N1PWS1              // bit 6
#define N1PWS2                  NCO1CLKbits.N1PWS2              // bit 7

#define N1PFM                   NCO1CONbits.N1PFM               // bit 0
#define N1POL                   NCO1CONbits.N1POL               // bit 4
#define N1OUT                   NCO1CONbits.N1OUT               // bit 5
#define N1EN                    NCO1CONbits.N1EN                // bit 7

#define NCO1INC8                NCO1INCHbits.NCO1INC8           // bit 0
#define NCO1INC9                NCO1INCHbits.NCO1INC9           // bit 1
#define NCO1INC10               NCO1INCHbits.NCO1INC10          // bit 2
#define NCO1INC11               NCO1INCHbits.NCO1INC11          // bit 3
#define NCO1INC12               NCO1INCHbits.NCO1INC12          // bit 4
#define NCO1INC13               NCO1INCHbits.NCO1INC13          // bit 5
#define NCO1INC14               NCO1INCHbits.NCO1INC14          // bit 6
#define NCO1INC15               NCO1INCHbits.NCO1INC15          // bit 7

#define NCO1INC0                NCO1INCLbits.NCO1INC0           // bit 0
#define NCO1INC1                NCO1INCLbits.NCO1INC1           // bit 1
#define NCO1INC2                NCO1INCLbits.NCO1INC2           // bit 2
#define NCO1INC3                NCO1INCLbits.NCO1INC3           // bit 3
#define NCO1INC4                NCO1INCLbits.NCO1INC4           // bit 4
#define NCO1INC5                NCO1INCLbits.NCO1INC5           // bit 5
#define NCO1INC6                NCO1INCLbits.NCO1INC6           // bit 6
#define NCO1INC7                NCO1INCLbits.NCO1INC7           // bit 7

#define NCO1INC16               NCO1INCUbits.NCO1INC16          // bit 0
#define NCO1INC17               NCO1INCUbits.NCO1INC17          // bit 1
#define NCO1INC18               NCO1INCUbits.NCO1INC18          // bit 2
#define NCO1INC19               NCO1INCUbits.NCO1INC19          // bit 3

#define NVMADR8                 NVMADRHbits.NVMADR8             // bit 0
#define NVMADR9                 NVMADRHbits.NVMADR9             // bit 1
#define NVMADR10                NVMADRHbits.NVMADR10            // bit 2
#define NVMADR11                NVMADRHbits.NVMADR11            // bit 3
#define NVMADR12                NVMADRHbits.NVMADR12            // bit 4
#define NVMADR13                NVMADRHbits.NVMADR13            // bit 5
#define NVMADR14                NVMADRHbits.NVMADR14            // bit 6

#define NVMADR0                 NVMADRLbits.NVMADR0             // bit 0
#define NVMADR1                 NVMADRLbits.NVMADR1             // bit 1
#define NVMADR2                 NVMADRLbits.NVMADR2             // bit 2
#define NVMADR3                 NVMADRLbits.NVMADR3             // bit 3
#define NVMADR4                 NVMADRLbits.NVMADR4             // bit 4
#define NVMADR5                 NVMADRLbits.NVMADR5             // bit 5
#define NVMADR6                 NVMADRLbits.NVMADR6             // bit 6
#define NVMADR7                 NVMADRLbits.NVMADR7             // bit 7

#define RD                      NVMCON1bits.RD                  // bit 0
#define WR                      NVMCON1bits.WR                  // bit 1
#define WREN                    NVMCON1bits.WREN                // bit 2
#define WRERR                   NVMCON1bits.WRERR               // bit 3
#define FREE                    NVMCON1bits.FREE                // bit 4
#define LWLO                    NVMCON1bits.LWLO                // bit 5
#define NVMREGS                 NVMCON1bits.NVMREGS             // bit 6

#define NVMDAT8                 NVMDATHbits.NVMDAT8             // bit 0
#define NVMDAT9                 NVMDATHbits.NVMDAT9             // bit 1
#define NVMDAT10                NVMDATHbits.NVMDAT10            // bit 2
#define NVMDAT11                NVMDATHbits.NVMDAT11            // bit 3
#define NVMDAT12                NVMDATHbits.NVMDAT12            // bit 4
#define NVMDAT13                NVMDATHbits.NVMDAT13            // bit 5

#define NVMDAT0                 NVMDATLbits.NVMDAT0             // bit 0
#define NVMDAT1                 NVMDATLbits.NVMDAT1             // bit 1
#define NVMDAT2                 NVMDATLbits.NVMDAT2             // bit 2
#define NVMDAT3                 NVMDATLbits.NVMDAT3             // bit 3
#define NVMDAT4                 NVMDATLbits.NVMDAT4             // bit 4
#define NVMDAT5                 NVMDATLbits.NVMDAT5             // bit 5
#define NVMDAT6                 NVMDATLbits.NVMDAT6             // bit 6
#define NVMDAT7                 NVMDATLbits.NVMDAT7             // bit 7

#define ODCA0                   ODCONAbits.ODCA0                // bit 0
#define ODCA1                   ODCONAbits.ODCA1                // bit 1
#define ODCA2                   ODCONAbits.ODCA2                // bit 2
#define ODCA3                   ODCONAbits.ODCA3                // bit 3
#define ODCA4                   ODCONAbits.ODCA4                // bit 4
#define ODCA5                   ODCONAbits.ODCA5                // bit 5
#define ODCA6                   ODCONAbits.ODCA6                // bit 6
#define ODCA7                   ODCONAbits.ODCA7                // bit 7

#define ODCB0                   ODCONBbits.ODCB0                // bit 0
#define ODCB1                   ODCONBbits.ODCB1                // bit 1
#define ODCB2                   ODCONBbits.ODCB2                // bit 2
#define ODCB3                   ODCONBbits.ODCB3                // bit 3
#define ODCB4                   ODCONBbits.ODCB4                // bit 4
#define ODCB5                   ODCONBbits.ODCB5                // bit 5
#define ODCB6                   ODCONBbits.ODCB6                // bit 6
#define ODCB7                   ODCONBbits.ODCB7                // bit 7

#define ODCC0                   ODCONCbits.ODCC0                // bit 0
#define ODCC1                   ODCONCbits.ODCC1                // bit 1
#define ODCC2                   ODCONCbits.ODCC2                // bit 2
#define ODCC3                   ODCONCbits.ODCC3                // bit 3
#define ODCC4                   ODCONCbits.ODCC4                // bit 4
#define ODCC5                   ODCONCbits.ODCC5                // bit 5
#define ODCC6                   ODCONCbits.ODCC6                // bit 6
#define ODCC7                   ODCONCbits.ODCC7                // bit 7

#define NDIV0                   OSCCON1bits.NDIV0               // bit 0
#define NDIV1                   OSCCON1bits.NDIV1               // bit 1
#define NDIV2                   OSCCON1bits.NDIV2               // bit 2
#define NDIV3                   OSCCON1bits.NDIV3               // bit 3
#define NOSC0                   OSCCON1bits.NOSC0               // bit 4
#define NOSC1                   OSCCON1bits.NOSC1               // bit 5
#define NOSC2                   OSCCON1bits.NOSC2               // bit 6

#define CDIV0                   OSCCON2bits.CDIV0               // bit 0
#define CDIV1                   OSCCON2bits.CDIV1               // bit 1
#define CDIV2                   OSCCON2bits.CDIV2               // bit 2
#define CDIV3                   OSCCON2bits.CDIV3               // bit 3
#define COSC0                   OSCCON2bits.COSC0               // bit 4
#define COSC1                   OSCCON2bits.COSC1               // bit 5
#define COSC2                   OSCCON2bits.COSC2               // bit 6

#define NOSCR                   OSCCON3bits.NOSCR               // bit 3
#define ORDY                    OSCCON3bits.ORDY                // bit 4
#define SOSCPWR                 OSCCON3bits.SOSCPWR             // bit 6
#define CSWHOLD                 OSCCON3bits.CSWHOLD             // bit 7

#define ADOEN                   OSCENbits.ADOEN                 // bit 2
#define SOSCEN                  OSCENbits.SOSCEN                // bit 3
#define LFOEN                   OSCENbits.LFOEN                 // bit 4
#define MFOEN                   OSCENbits.MFOEN                 // bit 5
#define HFOEN                   OSCENbits.HFOEN                 // bit 6
#define EXTOEN                  OSCENbits.EXTOEN                // bit 7

#define HFFRQ0                  OSCFRQbits.HFFRQ0               // bit 0
#define HFFRQ1                  OSCFRQbits.HFFRQ1               // bit 1
#define HFFRQ2                  OSCFRQbits.HFFRQ2               // bit 2

#define PLLR                    OSCSTATbits.PLLR                // bit 0
#define ADOR                    OSCSTATbits.ADOR                // bit 2
#define SOR                     OSCSTATbits.SOR                 // bit 3
#define LFOR                    OSCSTATbits.LFOR                // bit 4
#define MFOR                    OSCSTATbits.MFOR                // bit 5
#define HFOR                    OSCSTATbits.HFOR                // bit 6
#define EXTOR                   OSCSTATbits.EXTOR               // bit 7

#define HFTUN0                  OSCTUNEbits.HFTUN0              // bit 0
#define HFTUN1                  OSCTUNEbits.HFTUN1              // bit 1
#define HFTUN2                  OSCTUNEbits.HFTUN2              // bit 2
#define HFTUN3                  OSCTUNEbits.HFTUN3              // bit 3
#define HFTUN4                  OSCTUNEbits.HFTUN4              // bit 4
#define HFTUN5                  OSCTUNEbits.HFTUN5              // bit 5

#define NOT_BOR                 PCON0bits.NOT_BOR               // bit 0
#define NOT_POR                 PCON0bits.NOT_POR               // bit 1
#define NOT_RI                  PCON0bits.NOT_RI                // bit 2
#define NOT_RMCLR               PCON0bits.NOT_RMCLR             // bit 3
#define NOT_RWDT                PCON0bits.NOT_RWDT              // bit 4
#define NOT_WDTWV               PCON0bits.NOT_WDTWV             // bit 5
#define STKUNF                  PCON0bits.STKUNF                // bit 6
#define STKOVF                  PCON0bits.STKOVF                // bit 7

#define INTE                    PIE0bits.INTE                   // bit 0
#define IOCIE                   PIE0bits.IOCIE                  // bit 4
#define TMR0IE                  PIE0bits.TMR0IE                 // bit 5

#define ADIE                    PIE1bits.ADIE                   // bit 0
#define ADTIE                   PIE1bits.ADTIE                  // bit 1
#define CSWIE                   PIE1bits.CSWIE                  // bit 6
#define OSFIE                   PIE1bits.OSFIE                  // bit 7

#define C1IE                    PIE2bits.C1IE                   // bit 0
#define C2IE                    PIE2bits.C2IE                   // bit 1
#define ZCDIE                   PIE2bits.ZCDIE                  // bit 6

#define SSP1IE                  PIE3bits.SSP1IE                 // bit 0
#define BCL1IE                  PIE3bits.BCL1IE                 // bit 1
#define SSP2IE                  PIE3bits.SSP2IE                 // bit 2
#define BCL2IE                  PIE3bits.BCL2IE                 // bit 3
#define TXIE                    PIE3bits.TXIE                   // bit 4
#define RCIE                    PIE3bits.RCIE                   // bit 5

#define TMR1IE                  PIE4bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE4bits.TMR2IE                 // bit 1
#define TMR3IE                  PIE4bits.TMR3IE                 // bit 2
#define TMR4IE                  PIE4bits.TMR4IE                 // bit 3
#define TMR5IE                  PIE4bits.TMR5IE                 // bit 4
#define TMR6IE                  PIE4bits.TMR6IE                 // bit 5

#define TMR1GIE                 PIE5bits.TMR1GIE                // bit 0
#define TMR3GIE                 PIE5bits.TMR3GIE                // bit 1
#define TMR5GIE                 PIE5bits.TMR5GIE                // bit 2
#define CLC1IE                  PIE5bits.CLC1IE                 // bit 4
#define CLC2IE                  PIE5bits.CLC2IE                 // bit 5
#define CLC3IE                  PIE5bits.CLC3IE                 // bit 6
#define CLC4IE                  PIE5bits.CLC4IE                 // bit 7

#define CCP1IE                  PIE6bits.CCP1IE                 // bit 0
#define CCP2IE                  PIE6bits.CCP2IE                 // bit 1
#define CCP3IE                  PIE6bits.CCP3IE                 // bit 2
#define CCP4IE                  PIE6bits.CCP4IE                 // bit 3
#define CCP5IE                  PIE6bits.CCP5IE                 // bit 4

#define CWG1IE                  PIE7bits.CWG1IE                 // bit 0
#define CWG2IE                  PIE7bits.CWG2IE                 // bit 1
#define CWG3IE                  PIE7bits.CWG3IE                 // bit 2
#define NCO1IE                  PIE7bits.NCO1IE                 // bit 4, shadows bit in PIE7bits
#define NCOIE                   PIE7bits.NCOIE                  // bit 4, shadows bit in PIE7bits
#define NVMIE                   PIE7bits.NVMIE                  // bit 5
#define CRCIE                   PIE7bits.CRCIE                  // bit 6
#define SCANIE                  PIE7bits.SCANIE                 // bit 7

#define SMT1IE                  PIE8bits.SMT1IE                 // bit 0
#define SMT1PRAIE               PIE8bits.SMT1PRAIE              // bit 1
#define SMT1PWAIE               PIE8bits.SMT1PWAIE              // bit 2
#define SMT2IE                  PIE8bits.SMT2IE                 // bit 3
#define SMT2PRAIE               PIE8bits.SMT2PRAIE              // bit 4
#define SMT2PWAIE               PIE8bits.SMT2PWAIE              // bit 5

#define INTF                    PIR0bits.INTF                   // bit 0
#define IOCIF                   PIR0bits.IOCIF                  // bit 4
#define TMR0IF                  PIR0bits.TMR0IF                 // bit 5

#define ADIF                    PIR1bits.ADIF                   // bit 0
#define ADTIF                   PIR1bits.ADTIF                  // bit 1
#define CSWIF                   PIR1bits.CSWIF                  // bit 6
#define OSFIF                   PIR1bits.OSFIF                  // bit 7

#define C1IF                    PIR2bits.C1IF                   // bit 0
#define C2IF                    PIR2bits.C2IF                   // bit 1
#define ZCDIF                   PIR2bits.ZCDIF                  // bit 6

#define SSP1IF                  PIR3bits.SSP1IF                 // bit 0
#define BCL1IF                  PIR3bits.BCL1IF                 // bit 1
#define SSP2IF                  PIR3bits.SSP2IF                 // bit 2
#define BCL2IF                  PIR3bits.BCL2IF                 // bit 3
#define TXIF                    PIR3bits.TXIF                   // bit 4
#define RCIF                    PIR3bits.RCIF                   // bit 5

#define TMR1IF                  PIR4bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR4bits.TMR2IF                 // bit 1
#define TMR3IF                  PIR4bits.TMR3IF                 // bit 2
#define TMR4IF                  PIR4bits.TMR4IF                 // bit 3
#define TMR5IF                  PIR4bits.TMR5IF                 // bit 4
#define TMR6IF                  PIR4bits.TMR6IF                 // bit 5

#define TMR1GIF                 PIR5bits.TMR1GIF                // bit 0
#define TMR3GIF                 PIR5bits.TMR3GIF                // bit 1
#define TMR5GIF                 PIR5bits.TMR5GIF                // bit 2
#define CLC1IF                  PIR5bits.CLC1IF                 // bit 4
#define CLC2IF                  PIR5bits.CLC2IF                 // bit 5
#define CLC3IF                  PIR5bits.CLC3IF                 // bit 6
#define CLC4IF                  PIR5bits.CLC4IF                 // bit 7

#define CCP1IF                  PIR6bits.CCP1IF                 // bit 0
#define CCP2IF                  PIR6bits.CCP2IF                 // bit 1
#define CCP3IF                  PIR6bits.CCP3IF                 // bit 2
#define CCP4IF                  PIR6bits.CCP4IF                 // bit 3
#define CCP5IF                  PIR6bits.CCP5IF                 // bit 4

#define CWG1IF                  PIR7bits.CWG1IF                 // bit 0
#define CWG2IF                  PIR7bits.CWG2IF                 // bit 1
#define CWG3IF                  PIR7bits.CWG3IF                 // bit 2
#define NCO1IF                  PIR7bits.NCO1IF                 // bit 4, shadows bit in PIR7bits
#define NCOIF                   PIR7bits.NCOIF                  // bit 4, shadows bit in PIR7bits
#define NVMIF                   PIR7bits.NVMIF                  // bit 5
#define CRCIF                   PIR7bits.CRCIF                  // bit 6
#define SCANIF                  PIR7bits.SCANIF                 // bit 7

#define SMT1IF                  PIR8bits.SMT1IF                 // bit 0
#define SMT1PRAIF               PIR8bits.SMT1PRAIF              // bit 1
#define SMT1PWAIF               PIR8bits.SMT1PWAIF              // bit 2
#define SMT2IF                  PIR8bits.SMT2IF                 // bit 3
#define SMT2PRAIF               PIR8bits.SMT2PRAIF              // bit 4
#define SMT2PWAIF               PIR8bits.SMT2PWAIF              // bit 5

#define IOCMD                   PMD0bits.IOCMD                  // bit 0
#define CLKRMD                  PMD0bits.CLKRMD                 // bit 1
#define NVMMD                   PMD0bits.NVMMD                  // bit 2
#define SCANMD                  PMD0bits.SCANMD                 // bit 3
#define CRCMD                   PMD0bits.CRCMD                  // bit 4
#define FVRMD                   PMD0bits.FVRMD                  // bit 6
#define SYSCMD                  PMD0bits.SYSCMD                 // bit 7

#define TMR0MD                  PMD1bits.TMR0MD                 // bit 0
#define TMR1MD                  PMD1bits.TMR1MD                 // bit 1
#define TMR2MD                  PMD1bits.TMR2MD                 // bit 2
#define TMR3MD                  PMD1bits.TMR3MD                 // bit 3
#define TMR4MD                  PMD1bits.TMR4MD                 // bit 4
#define TMR5MD                  PMD1bits.TMR5MD                 // bit 5
#define TMR6MD                  PMD1bits.TMR6MD                 // bit 6
#define NCOMD                   PMD1bits.NCOMD                  // bit 7, shadows bit in PMD1bits
#define NCO1MD                  PMD1bits.NCO1MD                 // bit 7, shadows bit in PMD1bits

#define ZCDMD                   PMD2bits.ZCDMD                  // bit 0
#define CMP1MD                  PMD2bits.CMP1MD                 // bit 1
#define CMP2MD                  PMD2bits.CMP2MD                 // bit 2
#define ADCMD                   PMD2bits.ADCMD                  // bit 5
#define DACMD                   PMD2bits.DACMD                  // bit 6

#define CCP1MD                  PMD3bits.CCP1MD                 // bit 0
#define CCP2MD                  PMD3bits.CCP2MD                 // bit 1
#define CCP3MD                  PMD3bits.CCP3MD                 // bit 2
#define CCP4MD                  PMD3bits.CCP4MD                 // bit 3
#define CCP5MD                  PMD3bits.CCP5MD                 // bit 4
#define PWM6MD                  PMD3bits.PWM6MD                 // bit 5
#define PWM7MD                  PMD3bits.PWM7MD                 // bit 6

#define CWG1MD                  PMD4bits.CWG1MD                 // bit 0
#define CWG2MD                  PMD4bits.CWG2MD                 // bit 1
#define CWG3MD                  PMD4bits.CWG3MD                 // bit 2
#define MSSP1MD                 PMD4bits.MSSP1MD                // bit 4
#define MSSP2MD                 PMD4bits.MSSP2MD                // bit 5
#define UART1MD                 PMD4bits.UART1MD                // bit 6

#define DSMMD                   PMD5bits.DSMMD                  // bit 0
#define CLC1MD                  PMD5bits.CLC1MD                 // bit 1
#define CLC2MD                  PMD5bits.CLC2MD                 // bit 2
#define CLC3MD                  PMD5bits.CLC3MD                 // bit 3
#define CLC4MD                  PMD5bits.CLC4MD                 // bit 4
#define SMT1MD                  PMD5bits.SMT1MD                 // bit 6
#define SMT2MD                  PMD5bits.SMT2MD                 // bit 7

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5
#define RA6                     PORTAbits.RA6                   // bit 6
#define RA7                     PORTAbits.RA7                   // bit 7

#define RB0                     PORTBbits.RB0                   // bit 0
#define RB1                     PORTBbits.RB1                   // bit 1
#define RB2                     PORTBbits.RB2                   // bit 2
#define RB3                     PORTBbits.RB3                   // bit 3
#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define RE3                     PORTEbits.RE3                   // bit 3

#define PPSLOCKED               PPSLOCKbits.PPSLOCKED           // bit 0

#define TMR0H0                  PR0bits.TMR0H0                  // bit 0, shadows bit in PR0bits
#define T0PR0                   PR0bits.T0PR0                   // bit 0, shadows bit in PR0bits
#define TMR0H1                  PR0bits.TMR0H1                  // bit 1, shadows bit in PR0bits
#define T0PR1                   PR0bits.T0PR1                   // bit 1, shadows bit in PR0bits
#define TMR0H2                  PR0bits.TMR0H2                  // bit 2, shadows bit in PR0bits
#define T0PR2                   PR0bits.T0PR2                   // bit 2, shadows bit in PR0bits
#define TMR0H3                  PR0bits.TMR0H3                  // bit 3, shadows bit in PR0bits
#define T0PR3                   PR0bits.T0PR3                   // bit 3, shadows bit in PR0bits
#define TMR0H4                  PR0bits.TMR0H4                  // bit 4, shadows bit in PR0bits
#define T0PR4                   PR0bits.T0PR4                   // bit 4, shadows bit in PR0bits
#define TMR0H5                  PR0bits.TMR0H5                  // bit 5, shadows bit in PR0bits
#define T0PR5                   PR0bits.T0PR5                   // bit 5, shadows bit in PR0bits
#define TMR0H6                  PR0bits.TMR0H6                  // bit 6, shadows bit in PR0bits
#define T0PR6                   PR0bits.T0PR6                   // bit 6, shadows bit in PR0bits
#define TMR0H7                  PR0bits.TMR0H7                  // bit 7, shadows bit in PR0bits
#define T0PR7                   PR0bits.T0PR7                   // bit 7, shadows bit in PR0bits

#define GVAL                    PR1bits.GVAL                    // bit 2, shadows bit in PR1bits
#define T1GVAL                  PR1bits.T1GVAL                  // bit 2, shadows bit in PR1bits
#define GGO_NOT_DONE            PR1bits.GGO_NOT_DONE            // bit 3, shadows bit in PR1bits
#define T1GGO_NOT_DONE          PR1bits.T1GGO_NOT_DONE          // bit 3, shadows bit in PR1bits
#define T1GGO                   PR1bits.T1GGO                   // bit 3, shadows bit in PR1bits
#define GSPM                    PR1bits.GSPM                    // bit 4, shadows bit in PR1bits
#define T1GSPM                  PR1bits.T1GSPM                  // bit 4, shadows bit in PR1bits
#define GTM                     PR1bits.GTM                     // bit 5, shadows bit in PR1bits
#define T1GTM                   PR1bits.T1GTM                   // bit 5, shadows bit in PR1bits
#define GPOL                    PR1bits.GPOL                    // bit 6, shadows bit in PR1bits
#define T1GPOL                  PR1bits.T1GPOL                  // bit 6, shadows bit in PR1bits
#define GE                      PR1bits.GE                      // bit 7, shadows bit in PR1bits
#define T1GE                    PR1bits.T1GE                    // bit 7, shadows bit in PR1bits

#define DC2                     PWM6DCHbits.DC2                 // bit 0, shadows bit in PWM6DCHbits
#define PWM6DC2                 PWM6DCHbits.PWM6DC2             // bit 0, shadows bit in PWM6DCHbits
#define PWMPW2                  PWM6DCHbits.PWMPW2              // bit 0, shadows bit in PWM6DCHbits
#define DC3                     PWM6DCHbits.DC3                 // bit 1, shadows bit in PWM6DCHbits
#define PWM6DC3                 PWM6DCHbits.PWM6DC3             // bit 1, shadows bit in PWM6DCHbits
#define PWMPW3                  PWM6DCHbits.PWMPW3              // bit 1, shadows bit in PWM6DCHbits
#define DC4                     PWM6DCHbits.DC4                 // bit 2, shadows bit in PWM6DCHbits
#define PWM6DC4                 PWM6DCHbits.PWM6DC4             // bit 2, shadows bit in PWM6DCHbits
#define PWMPW4                  PWM6DCHbits.PWMPW4              // bit 2, shadows bit in PWM6DCHbits
#define DC5                     PWM6DCHbits.DC5                 // bit 3, shadows bit in PWM6DCHbits
#define PWM6DC5                 PWM6DCHbits.PWM6DC5             // bit 3, shadows bit in PWM6DCHbits
#define PWMPW5                  PWM6DCHbits.PWMPW5              // bit 3, shadows bit in PWM6DCHbits
#define DC6                     PWM6DCHbits.DC6                 // bit 4, shadows bit in PWM6DCHbits
#define PWM6DC6                 PWM6DCHbits.PWM6DC6             // bit 4, shadows bit in PWM6DCHbits
#define PWMPW6                  PWM6DCHbits.PWMPW6              // bit 4, shadows bit in PWM6DCHbits
#define DC7                     PWM6DCHbits.DC7                 // bit 5, shadows bit in PWM6DCHbits
#define PWM6DC7                 PWM6DCHbits.PWM6DC7             // bit 5, shadows bit in PWM6DCHbits
#define PWMPW7                  PWM6DCHbits.PWMPW7              // bit 5, shadows bit in PWM6DCHbits
#define DC8                     PWM6DCHbits.DC8                 // bit 6, shadows bit in PWM6DCHbits
#define PWM6DC8                 PWM6DCHbits.PWM6DC8             // bit 6, shadows bit in PWM6DCHbits
#define PWMPW8                  PWM6DCHbits.PWMPW8              // bit 6, shadows bit in PWM6DCHbits
#define DC9                     PWM6DCHbits.DC9                 // bit 7, shadows bit in PWM6DCHbits
#define PWM6DC9                 PWM6DCHbits.PWM6DC9             // bit 7, shadows bit in PWM6DCHbits
#define PWMPW9                  PWM6DCHbits.PWMPW9              // bit 7, shadows bit in PWM6DCHbits

#define DC0                     PWM6DCLbits.DC0                 // bit 6, shadows bit in PWM6DCLbits
#define PWM6DC0                 PWM6DCLbits.PWM6DC0             // bit 6, shadows bit in PWM6DCLbits
#define PWMPW0                  PWM6DCLbits.PWMPW0              // bit 6, shadows bit in PWM6DCLbits
#define DC1                     PWM6DCLbits.DC1                 // bit 7, shadows bit in PWM6DCLbits
#define PWM6DC1                 PWM6DCLbits.PWM6DC1             // bit 7, shadows bit in PWM6DCLbits
#define PWMPW1                  PWM6DCLbits.PWMPW1              // bit 7, shadows bit in PWM6DCLbits

#define RA0PPS0                 RA0PPSbits.RA0PPS0              // bit 0
#define RA0PPS1                 RA0PPSbits.RA0PPS1              // bit 1
#define RA0PPS2                 RA0PPSbits.RA0PPS2              // bit 2
#define RA0PPS3                 RA0PPSbits.RA0PPS3              // bit 3
#define RA0PPS4                 RA0PPSbits.RA0PPS4              // bit 4
#define RA0PPS5                 RA0PPSbits.RA0PPS5              // bit 5

#define RA1PPS0                 RA1PPSbits.RA1PPS0              // bit 0
#define RA1PPS1                 RA1PPSbits.RA1PPS1              // bit 1
#define RA1PPS2                 RA1PPSbits.RA1PPS2              // bit 2
#define RA1PPS3                 RA1PPSbits.RA1PPS3              // bit 3
#define RA1PPS4                 RA1PPSbits.RA1PPS4              // bit 4
#define RA1PPS5                 RA1PPSbits.RA1PPS5              // bit 5

#define RA2PPS0                 RA2PPSbits.RA2PPS0              // bit 0
#define RA2PPS1                 RA2PPSbits.RA2PPS1              // bit 1
#define RA2PPS2                 RA2PPSbits.RA2PPS2              // bit 2
#define RA2PPS3                 RA2PPSbits.RA2PPS3              // bit 3
#define RA2PPS4                 RA2PPSbits.RA2PPS4              // bit 4
#define RA2PPS5                 RA2PPSbits.RA2PPS5              // bit 5

#define RA3PPS0                 RA3PPSbits.RA3PPS0              // bit 0
#define RA3PPS1                 RA3PPSbits.RA3PPS1              // bit 1
#define RA3PPS2                 RA3PPSbits.RA3PPS2              // bit 2
#define RA3PPS3                 RA3PPSbits.RA3PPS3              // bit 3
#define RA3PPS4                 RA3PPSbits.RA3PPS4              // bit 4
#define RA3PPS5                 RA3PPSbits.RA3PPS5              // bit 5

#define RA4PPS0                 RA4PPSbits.RA4PPS0              // bit 0
#define RA4PPS1                 RA4PPSbits.RA4PPS1              // bit 1
#define RA4PPS2                 RA4PPSbits.RA4PPS2              // bit 2
#define RA4PPS3                 RA4PPSbits.RA4PPS3              // bit 3
#define RA4PPS4                 RA4PPSbits.RA4PPS4              // bit 4
#define RA4PPS5                 RA4PPSbits.RA4PPS5              // bit 5

#define RA5PPS0                 RA5PPSbits.RA5PPS0              // bit 0
#define RA5PPS1                 RA5PPSbits.RA5PPS1              // bit 1
#define RA5PPS2                 RA5PPSbits.RA5PPS2              // bit 2
#define RA5PPS3                 RA5PPSbits.RA5PPS3              // bit 3
#define RA5PPS4                 RA5PPSbits.RA5PPS4              // bit 4
#define RA5PPS5                 RA5PPSbits.RA5PPS5              // bit 5

#define RA6PPS0                 RA6PPSbits.RA6PPS0              // bit 0
#define RA6PPS1                 RA6PPSbits.RA6PPS1              // bit 1
#define RA6PPS2                 RA6PPSbits.RA6PPS2              // bit 2
#define RA6PPS3                 RA6PPSbits.RA6PPS3              // bit 3
#define RA6PPS4                 RA6PPSbits.RA6PPS4              // bit 4
#define RA6PPS5                 RA6PPSbits.RA6PPS5              // bit 5

#define RA7PPS0                 RA7PPSbits.RA7PPS0              // bit 0
#define RA7PPS1                 RA7PPSbits.RA7PPS1              // bit 1
#define RA7PPS2                 RA7PPSbits.RA7PPS2              // bit 2
#define RA7PPS3                 RA7PPSbits.RA7PPS3              // bit 3
#define RA7PPS4                 RA7PPSbits.RA7PPS4              // bit 4
#define RA7PPS5                 RA7PPSbits.RA7PPS5              // bit 5

#define RB0PPS0                 RB0PPSbits.RB0PPS0              // bit 0
#define RB0PPS1                 RB0PPSbits.RB0PPS1              // bit 1
#define RB0PPS2                 RB0PPSbits.RB0PPS2              // bit 2
#define RB0PPS3                 RB0PPSbits.RB0PPS3              // bit 3
#define RB0PPS4                 RB0PPSbits.RB0PPS4              // bit 4
#define RB0PPS5                 RB0PPSbits.RB0PPS5              // bit 5

#define RB1PPS0                 RB1PPSbits.RB1PPS0              // bit 0
#define RB1PPS1                 RB1PPSbits.RB1PPS1              // bit 1
#define RB1PPS2                 RB1PPSbits.RB1PPS2              // bit 2
#define RB1PPS3                 RB1PPSbits.RB1PPS3              // bit 3
#define RB1PPS4                 RB1PPSbits.RB1PPS4              // bit 4
#define RB1PPS5                 RB1PPSbits.RB1PPS5              // bit 5

#define RB2PPS0                 RB2PPSbits.RB2PPS0              // bit 0
#define RB2PPS1                 RB2PPSbits.RB2PPS1              // bit 1
#define RB2PPS2                 RB2PPSbits.RB2PPS2              // bit 2
#define RB2PPS3                 RB2PPSbits.RB2PPS3              // bit 3
#define RB2PPS4                 RB2PPSbits.RB2PPS4              // bit 4
#define RB2PPS5                 RB2PPSbits.RB2PPS5              // bit 5

#define RB3PPS0                 RB3PPSbits.RB3PPS0              // bit 0
#define RB3PPS1                 RB3PPSbits.RB3PPS1              // bit 1
#define RB3PPS2                 RB3PPSbits.RB3PPS2              // bit 2
#define RB3PPS3                 RB3PPSbits.RB3PPS3              // bit 3
#define RB3PPS4                 RB3PPSbits.RB3PPS4              // bit 4
#define RB3PPS5                 RB3PPSbits.RB3PPS5              // bit 5

#define RB4PPS0                 RB4PPSbits.RB4PPS0              // bit 0
#define RB4PPS1                 RB4PPSbits.RB4PPS1              // bit 1
#define RB4PPS2                 RB4PPSbits.RB4PPS2              // bit 2
#define RB4PPS3                 RB4PPSbits.RB4PPS3              // bit 3
#define RB4PPS4                 RB4PPSbits.RB4PPS4              // bit 4
#define RB4PPS5                 RB4PPSbits.RB4PPS5              // bit 5

#define RB5PPS0                 RB5PPSbits.RB5PPS0              // bit 0
#define RB5PPS1                 RB5PPSbits.RB5PPS1              // bit 1
#define RB5PPS2                 RB5PPSbits.RB5PPS2              // bit 2
#define RB5PPS3                 RB5PPSbits.RB5PPS3              // bit 3
#define RB5PPS4                 RB5PPSbits.RB5PPS4              // bit 4
#define RB5PPS5                 RB5PPSbits.RB5PPS5              // bit 5

#define RB6PPS0                 RB6PPSbits.RB6PPS0              // bit 0
#define RB6PPS1                 RB6PPSbits.RB6PPS1              // bit 1
#define RB6PPS2                 RB6PPSbits.RB6PPS2              // bit 2
#define RB6PPS3                 RB6PPSbits.RB6PPS3              // bit 3
#define RB6PPS4                 RB6PPSbits.RB6PPS4              // bit 4
#define RB6PPS5                 RB6PPSbits.RB6PPS5              // bit 5

#define RB7PPS0                 RB7PPSbits.RB7PPS0              // bit 0
#define RB7PPS1                 RB7PPSbits.RB7PPS1              // bit 1
#define RB7PPS2                 RB7PPSbits.RB7PPS2              // bit 2
#define RB7PPS3                 RB7PPSbits.RB7PPS3              // bit 3
#define RB7PPS4                 RB7PPSbits.RB7PPS4              // bit 4
#define RB7PPS5                 RB7PPSbits.RB7PPS5              // bit 5

#define RC0PPS0                 RC0PPSbits.RC0PPS0              // bit 0
#define RC0PPS1                 RC0PPSbits.RC0PPS1              // bit 1
#define RC0PPS2                 RC0PPSbits.RC0PPS2              // bit 2
#define RC0PPS3                 RC0PPSbits.RC0PPS3              // bit 3
#define RC0PPS4                 RC0PPSbits.RC0PPS4              // bit 4
#define RC0PPS5                 RC0PPSbits.RC0PPS5              // bit 5

#define RC1PPS0                 RC1PPSbits.RC1PPS0              // bit 0
#define RC1PPS1                 RC1PPSbits.RC1PPS1              // bit 1
#define RC1PPS2                 RC1PPSbits.RC1PPS2              // bit 2
#define RC1PPS3                 RC1PPSbits.RC1PPS3              // bit 3
#define RC1PPS4                 RC1PPSbits.RC1PPS4              // bit 4
#define RC1PPS5                 RC1PPSbits.RC1PPS5              // bit 5

#define RX9D                    RC1STAbits.RX9D                 // bit 0
#define OERR                    RC1STAbits.OERR                 // bit 1
#define FERR                    RC1STAbits.FERR                 // bit 2
#define ADDEN                   RC1STAbits.ADDEN                // bit 3
#define CREN                    RC1STAbits.CREN                 // bit 4
#define SREN                    RC1STAbits.SREN                 // bit 5
#define RX9                     RC1STAbits.RX9                  // bit 6
#define SPEN                    RC1STAbits.SPEN                 // bit 7

#define RC2PPS0                 RC2PPSbits.RC2PPS0              // bit 0
#define RC2PPS1                 RC2PPSbits.RC2PPS1              // bit 1
#define RC2PPS2                 RC2PPSbits.RC2PPS2              // bit 2
#define RC2PPS3                 RC2PPSbits.RC2PPS3              // bit 3
#define RC2PPS4                 RC2PPSbits.RC2PPS4              // bit 4
#define RC2PPS5                 RC2PPSbits.RC2PPS5              // bit 5

#define RC3PPS0                 RC3PPSbits.RC3PPS0              // bit 0
#define RC3PPS1                 RC3PPSbits.RC3PPS1              // bit 1
#define RC3PPS2                 RC3PPSbits.RC3PPS2              // bit 2
#define RC3PPS3                 RC3PPSbits.RC3PPS3              // bit 3
#define RC3PPS4                 RC3PPSbits.RC3PPS4              // bit 4
#define RC3PPS5                 RC3PPSbits.RC3PPS5              // bit 5

#define RC4PPS0                 RC4PPSbits.RC4PPS0              // bit 0
#define RC4PPS1                 RC4PPSbits.RC4PPS1              // bit 1
#define RC4PPS2                 RC4PPSbits.RC4PPS2              // bit 2
#define RC4PPS3                 RC4PPSbits.RC4PPS3              // bit 3
#define RC4PPS4                 RC4PPSbits.RC4PPS4              // bit 4
#define RC4PPS5                 RC4PPSbits.RC4PPS5              // bit 5

#define RC5PPS0                 RC5PPSbits.RC5PPS0              // bit 0
#define RC5PPS1                 RC5PPSbits.RC5PPS1              // bit 1
#define RC5PPS2                 RC5PPSbits.RC5PPS2              // bit 2
#define RC5PPS3                 RC5PPSbits.RC5PPS3              // bit 3
#define RC5PPS4                 RC5PPSbits.RC5PPS4              // bit 4
#define RC5PPS5                 RC5PPSbits.RC5PPS5              // bit 5

#define RC6PPS0                 RC6PPSbits.RC6PPS0              // bit 0
#define RC6PPS1                 RC6PPSbits.RC6PPS1              // bit 1
#define RC6PPS2                 RC6PPSbits.RC6PPS2              // bit 2
#define RC6PPS3                 RC6PPSbits.RC6PPS3              // bit 3
#define RC6PPS4                 RC6PPSbits.RC6PPS4              // bit 4
#define RC6PPS5                 RC6PPSbits.RC6PPS5              // bit 5

#define RC7PPS0                 RC7PPSbits.RC7PPS0              // bit 0
#define RC7PPS1                 RC7PPSbits.RC7PPS1              // bit 1
#define RC7PPS2                 RC7PPSbits.RC7PPS2              // bit 2
#define RC7PPS3                 RC7PPSbits.RC7PPS3              // bit 3
#define RC7PPS4                 RC7PPSbits.RC7PPS4              // bit 4
#define RC7PPS5                 RC7PPSbits.RC7PPS5              // bit 5

#define RXPPS0                  RXPPSbits.RXPPS0                // bit 0
#define RXPPS1                  RXPPSbits.RXPPS1                // bit 1
#define RXPPS2                  RXPPSbits.RXPPS2                // bit 2
#define RXPPS3                  RXPPSbits.RXPPS3                // bit 3
#define RXPPS4                  RXPPSbits.RXPPS4                // bit 4

#define HADR8                   SCANHADRHbits.HADR8             // bit 0, shadows bit in SCANHADRHbits
#define SCANHADR8               SCANHADRHbits.SCANHADR8         // bit 0, shadows bit in SCANHADRHbits
#define HADR9                   SCANHADRHbits.HADR9             // bit 1, shadows bit in SCANHADRHbits
#define SCANHADR9               SCANHADRHbits.SCANHADR9         // bit 1, shadows bit in SCANHADRHbits
#define HADR10                  SCANHADRHbits.HADR10            // bit 2, shadows bit in SCANHADRHbits
#define SCANHADR10              SCANHADRHbits.SCANHADR10        // bit 2, shadows bit in SCANHADRHbits
#define HADR11                  SCANHADRHbits.HADR11            // bit 3, shadows bit in SCANHADRHbits
#define SCANHADR11              SCANHADRHbits.SCANHADR11        // bit 3, shadows bit in SCANHADRHbits
#define HADR12                  SCANHADRHbits.HADR12            // bit 4, shadows bit in SCANHADRHbits
#define SCANHADR12              SCANHADRHbits.SCANHADR12        // bit 4, shadows bit in SCANHADRHbits
#define HADR13                  SCANHADRHbits.HADR13            // bit 5, shadows bit in SCANHADRHbits
#define SCANHADR13              SCANHADRHbits.SCANHADR13        // bit 5, shadows bit in SCANHADRHbits
#define HADR14                  SCANHADRHbits.HADR14            // bit 6, shadows bit in SCANHADRHbits
#define SCANHADR14              SCANHADRHbits.SCANHADR14        // bit 6, shadows bit in SCANHADRHbits
#define HADR15                  SCANHADRHbits.HADR15            // bit 7, shadows bit in SCANHADRHbits
#define SCANHADR15              SCANHADRHbits.SCANHADR15        // bit 7, shadows bit in SCANHADRHbits

#define HADR0                   SCANHADRLbits.HADR0             // bit 0, shadows bit in SCANHADRLbits
#define SCANHADR0               SCANHADRLbits.SCANHADR0         // bit 0, shadows bit in SCANHADRLbits
#define HADR1                   SCANHADRLbits.HADR1             // bit 1, shadows bit in SCANHADRLbits
#define SCANHADR1               SCANHADRLbits.SCANHADR1         // bit 1, shadows bit in SCANHADRLbits
#define HADR2                   SCANHADRLbits.HADR2             // bit 2, shadows bit in SCANHADRLbits
#define SCANHADR2               SCANHADRLbits.SCANHADR2         // bit 2, shadows bit in SCANHADRLbits
#define HADR3                   SCANHADRLbits.HADR3             // bit 3, shadows bit in SCANHADRLbits
#define SCANHADR3               SCANHADRLbits.SCANHADR3         // bit 3, shadows bit in SCANHADRLbits
#define HADR4                   SCANHADRLbits.HADR4             // bit 4, shadows bit in SCANHADRLbits
#define SCANHADR4               SCANHADRLbits.SCANHADR4         // bit 4, shadows bit in SCANHADRLbits
#define HADR5                   SCANHADRLbits.HADR5             // bit 5, shadows bit in SCANHADRLbits
#define SCANHADR5               SCANHADRLbits.SCANHADR5         // bit 5, shadows bit in SCANHADRLbits
#define HADR6                   SCANHADRLbits.HADR6             // bit 6, shadows bit in SCANHADRLbits
#define SCANHADR6               SCANHADRLbits.SCANHADR6         // bit 6, shadows bit in SCANHADRLbits
#define HADR7                   SCANHADRLbits.HADR7             // bit 7, shadows bit in SCANHADRLbits
#define SCANHADR7               SCANHADRLbits.SCANHADR7         // bit 7, shadows bit in SCANHADRLbits

#define LADR8                   SCANLADRHbits.LADR8             // bit 0, shadows bit in SCANLADRHbits
#define SCANLADR8               SCANLADRHbits.SCANLADR8         // bit 0, shadows bit in SCANLADRHbits
#define LADR9                   SCANLADRHbits.LADR9             // bit 1, shadows bit in SCANLADRHbits
#define SCANLADR9               SCANLADRHbits.SCANLADR9         // bit 1, shadows bit in SCANLADRHbits
#define LADR10                  SCANLADRHbits.LADR10            // bit 2, shadows bit in SCANLADRHbits
#define SCANLADR10              SCANLADRHbits.SCANLADR10        // bit 2, shadows bit in SCANLADRHbits
#define LADR11                  SCANLADRHbits.LADR11            // bit 3, shadows bit in SCANLADRHbits
#define SCANLADR11              SCANLADRHbits.SCANLADR11        // bit 3, shadows bit in SCANLADRHbits
#define LADR12                  SCANLADRHbits.LADR12            // bit 4, shadows bit in SCANLADRHbits
#define SCANLADR12              SCANLADRHbits.SCANLADR12        // bit 4, shadows bit in SCANLADRHbits
#define LADR13                  SCANLADRHbits.LADR13            // bit 5, shadows bit in SCANLADRHbits
#define SCANLADR13              SCANLADRHbits.SCANLADR13        // bit 5, shadows bit in SCANLADRHbits
#define LADR14                  SCANLADRHbits.LADR14            // bit 6, shadows bit in SCANLADRHbits
#define SCANLADR14              SCANLADRHbits.SCANLADR14        // bit 6, shadows bit in SCANLADRHbits
#define LADR15                  SCANLADRHbits.LADR15            // bit 7, shadows bit in SCANLADRHbits
#define SCANLADR15              SCANLADRHbits.SCANLADR15        // bit 7, shadows bit in SCANLADRHbits

#define LADR0                   SCANLADRLbits.LADR0             // bit 0, shadows bit in SCANLADRLbits
#define SCANLADR0               SCANLADRLbits.SCANLADR0         // bit 0, shadows bit in SCANLADRLbits
#define LADR1                   SCANLADRLbits.LADR1             // bit 1, shadows bit in SCANLADRLbits
#define SCANLADR1               SCANLADRLbits.SCANLADR1         // bit 1, shadows bit in SCANLADRLbits
#define LADR2                   SCANLADRLbits.LADR2             // bit 2, shadows bit in SCANLADRLbits
#define SCANLADR2               SCANLADRLbits.SCANLADR2         // bit 2, shadows bit in SCANLADRLbits
#define LADR3                   SCANLADRLbits.LADR3             // bit 3, shadows bit in SCANLADRLbits
#define SCANLADR3               SCANLADRLbits.SCANLADR3         // bit 3, shadows bit in SCANLADRLbits
#define LADR4                   SCANLADRLbits.LADR4             // bit 4, shadows bit in SCANLADRLbits
#define SCANLADR4               SCANLADRLbits.SCANLADR4         // bit 4, shadows bit in SCANLADRLbits
#define LADR5                   SCANLADRLbits.LADR5             // bit 5, shadows bit in SCANLADRLbits
#define SCANLADR5               SCANLADRLbits.SCANLADR5         // bit 5, shadows bit in SCANLADRLbits
#define LADR6                   SCANLADRLbits.LADR6             // bit 6, shadows bit in SCANLADRLbits
#define SCANLADR6               SCANLADRLbits.SCANLADR6         // bit 6, shadows bit in SCANLADRLbits
#define LADR7                   SCANLADRLbits.LADR7             // bit 7, shadows bit in SCANLADRLbits
#define SCANLADR7               SCANLADRLbits.SCANLADR7         // bit 7, shadows bit in SCANLADRLbits

#define TSEL0                   SCANTRIGbits.TSEL0              // bit 0, shadows bit in SCANTRIGbits
#define SCANTSEL0               SCANTRIGbits.SCANTSEL0          // bit 0, shadows bit in SCANTRIGbits
#define TSEL1                   SCANTRIGbits.TSEL1              // bit 1, shadows bit in SCANTRIGbits
#define SCANTSEL1               SCANTRIGbits.SCANTSEL1          // bit 1, shadows bit in SCANTRIGbits
#define TSEL2                   SCANTRIGbits.TSEL2              // bit 2, shadows bit in SCANTRIGbits
#define SCANTSEL2               SCANTRIGbits.SCANTSEL2          // bit 2, shadows bit in SCANTRIGbits
#define TSEL3                   SCANTRIGbits.TSEL3              // bit 3, shadows bit in SCANTRIGbits
#define SCANTSEL3               SCANTRIGbits.SCANTSEL3          // bit 3, shadows bit in SCANTRIGbits

#define SLRA0                   SLRCONAbits.SLRA0               // bit 0
#define SLRA1                   SLRCONAbits.SLRA1               // bit 1
#define SLRA2                   SLRCONAbits.SLRA2               // bit 2
#define SLRA3                   SLRCONAbits.SLRA3               // bit 3
#define SLRA4                   SLRCONAbits.SLRA4               // bit 4
#define SLRA5                   SLRCONAbits.SLRA5               // bit 5
#define SLRA6                   SLRCONAbits.SLRA6               // bit 6
#define SLRA7                   SLRCONAbits.SLRA7               // bit 7

#define SLRB0                   SLRCONBbits.SLRB0               // bit 0
#define SLRB1                   SLRCONBbits.SLRB1               // bit 1
#define SLRB2                   SLRCONBbits.SLRB2               // bit 2
#define SLRB3                   SLRCONBbits.SLRB3               // bit 3
#define SLRB4                   SLRCONBbits.SLRB4               // bit 4
#define SLRB5                   SLRCONBbits.SLRB5               // bit 5
#define SLRB6                   SLRCONBbits.SLRB6               // bit 6
#define SLRB7                   SLRCONBbits.SLRB7               // bit 7

#define SLRC0                   SLRCONCbits.SLRC0               // bit 0
#define SLRC1                   SLRCONCbits.SLRC1               // bit 1
#define SLRC2                   SLRCONCbits.SLRC2               // bit 2
#define SLRC3                   SLRCONCbits.SLRC3               // bit 3
#define SLRC4                   SLRCONCbits.SLRC4               // bit 4
#define SLRC5                   SLRCONCbits.SLRC5               // bit 5
#define SLRC6                   SLRCONCbits.SLRC6               // bit 6
#define SLRC7                   SLRCONCbits.SLRC7               // bit 7

#define CSEL0                   SMT1CLKbits.CSEL0               // bit 0, shadows bit in SMT1CLKbits
#define SMT1CSEL0               SMT1CLKbits.SMT1CSEL0           // bit 0, shadows bit in SMT1CLKbits
#define CSEL1                   SMT1CLKbits.CSEL1               // bit 1, shadows bit in SMT1CLKbits
#define SMT1CSEL1               SMT1CLKbits.SMT1CSEL1           // bit 1, shadows bit in SMT1CLKbits
#define CSEL2                   SMT1CLKbits.CSEL2               // bit 2, shadows bit in SMT1CLKbits
#define SMT1CSEL2               SMT1CLKbits.SMT1CSEL2           // bit 2, shadows bit in SMT1CLKbits

#define CPR8                    SMT1CPRHbits.CPR8               // bit 0, shadows bit in SMT1CPRHbits
#define SMT1CPR8                SMT1CPRHbits.SMT1CPR8           // bit 0, shadows bit in SMT1CPRHbits
#define CPR9                    SMT1CPRHbits.CPR9               // bit 1, shadows bit in SMT1CPRHbits
#define SMT1CPR9                SMT1CPRHbits.SMT1CPR9           // bit 1, shadows bit in SMT1CPRHbits
#define CPR10                   SMT1CPRHbits.CPR10              // bit 2, shadows bit in SMT1CPRHbits
#define SMT1CPR10               SMT1CPRHbits.SMT1CPR10          // bit 2, shadows bit in SMT1CPRHbits
#define CPR11                   SMT1CPRHbits.CPR11              // bit 3, shadows bit in SMT1CPRHbits
#define SMT1CPR11               SMT1CPRHbits.SMT1CPR11          // bit 3, shadows bit in SMT1CPRHbits
#define CPR12                   SMT1CPRHbits.CPR12              // bit 4, shadows bit in SMT1CPRHbits
#define SMT1CPR12               SMT1CPRHbits.SMT1CPR12          // bit 4, shadows bit in SMT1CPRHbits
#define CPR13                   SMT1CPRHbits.CPR13              // bit 5, shadows bit in SMT1CPRHbits
#define SMT1CPR13               SMT1CPRHbits.SMT1CPR13          // bit 5, shadows bit in SMT1CPRHbits
#define CPR14                   SMT1CPRHbits.CPR14              // bit 6, shadows bit in SMT1CPRHbits
#define SMT1CPR14               SMT1CPRHbits.SMT1CPR14          // bit 6, shadows bit in SMT1CPRHbits
#define CPR15                   SMT1CPRHbits.CPR15              // bit 7, shadows bit in SMT1CPRHbits
#define SMT1CPR15               SMT1CPRHbits.SMT1CPR15          // bit 7, shadows bit in SMT1CPRHbits

#define CPR0                    SMT1CPRLbits.CPR0               // bit 0
#define CPR1                    SMT1CPRLbits.CPR1               // bit 1
#define CPR2                    SMT1CPRLbits.CPR2               // bit 2
#define CPR3                    SMT1CPRLbits.CPR3               // bit 3
#define CPR4                    SMT1CPRLbits.CPR4               // bit 4
#define CPR5                    SMT1CPRLbits.CPR5               // bit 5
#define CPR6                    SMT1CPRLbits.CPR6               // bit 6
#define CPR7                    SMT1CPRLbits.CPR7               // bit 7

#define CPR16                   SMT1CPRUbits.CPR16              // bit 0, shadows bit in SMT1CPRUbits
#define SMT1CPR16               SMT1CPRUbits.SMT1CPR16          // bit 0, shadows bit in SMT1CPRUbits
#define CPR17                   SMT1CPRUbits.CPR17              // bit 1, shadows bit in SMT1CPRUbits
#define SMT1CPR17               SMT1CPRUbits.SMT1CPR17          // bit 1, shadows bit in SMT1CPRUbits
#define CPR18                   SMT1CPRUbits.CPR18              // bit 2, shadows bit in SMT1CPRUbits
#define SMT1CPR18               SMT1CPRUbits.SMT1CPR18          // bit 2, shadows bit in SMT1CPRUbits
#define CPR19                   SMT1CPRUbits.CPR19              // bit 3, shadows bit in SMT1CPRUbits
#define SMT1CPR19               SMT1CPRUbits.SMT1CPR19          // bit 3, shadows bit in SMT1CPRUbits
#define CPR20                   SMT1CPRUbits.CPR20              // bit 4, shadows bit in SMT1CPRUbits
#define SMT1CPR20               SMT1CPRUbits.SMT1CPR20          // bit 4, shadows bit in SMT1CPRUbits
#define CPR21                   SMT1CPRUbits.CPR21              // bit 5, shadows bit in SMT1CPRUbits
#define SMT1CPR21               SMT1CPRUbits.SMT1CPR21          // bit 5, shadows bit in SMT1CPRUbits
#define CPR22                   SMT1CPRUbits.CPR22              // bit 6, shadows bit in SMT1CPRUbits
#define SMT1CPR22               SMT1CPRUbits.SMT1CPR22          // bit 6, shadows bit in SMT1CPRUbits
#define CPR23                   SMT1CPRUbits.CPR23              // bit 7, shadows bit in SMT1CPRUbits
#define SMT1CPR23               SMT1CPRUbits.SMT1CPR23          // bit 7, shadows bit in SMT1CPRUbits

#define CPW8                    SMT1CPWHbits.CPW8               // bit 0, shadows bit in SMT1CPWHbits
#define SMT1CPW8                SMT1CPWHbits.SMT1CPW8           // bit 0, shadows bit in SMT1CPWHbits
#define CPW9                    SMT1CPWHbits.CPW9               // bit 1, shadows bit in SMT1CPWHbits
#define SMT1CPW9                SMT1CPWHbits.SMT1CPW9           // bit 1, shadows bit in SMT1CPWHbits
#define CPW10                   SMT1CPWHbits.CPW10              // bit 2, shadows bit in SMT1CPWHbits
#define SMT1CPW10               SMT1CPWHbits.SMT1CPW10          // bit 2, shadows bit in SMT1CPWHbits
#define CPW11                   SMT1CPWHbits.CPW11              // bit 3, shadows bit in SMT1CPWHbits
#define SMT1CPW11               SMT1CPWHbits.SMT1CPW11          // bit 3, shadows bit in SMT1CPWHbits
#define CPW12                   SMT1CPWHbits.CPW12              // bit 4, shadows bit in SMT1CPWHbits
#define SMT1CPW12               SMT1CPWHbits.SMT1CPW12          // bit 4, shadows bit in SMT1CPWHbits
#define CPW13                   SMT1CPWHbits.CPW13              // bit 5, shadows bit in SMT1CPWHbits
#define SMT1CPW13               SMT1CPWHbits.SMT1CPW13          // bit 5, shadows bit in SMT1CPWHbits
#define CPW14                   SMT1CPWHbits.CPW14              // bit 6, shadows bit in SMT1CPWHbits
#define SMT1CPW14               SMT1CPWHbits.SMT1CPW14          // bit 6, shadows bit in SMT1CPWHbits
#define CPW15                   SMT1CPWHbits.CPW15              // bit 7, shadows bit in SMT1CPWHbits
#define SMT1CPW15               SMT1CPWHbits.SMT1CPW15          // bit 7, shadows bit in SMT1CPWHbits

#define CPW0                    SMT1CPWLbits.CPW0               // bit 0, shadows bit in SMT1CPWLbits
#define SMT1CPW0                SMT1CPWLbits.SMT1CPW0           // bit 0, shadows bit in SMT1CPWLbits
#define CPW1                    SMT1CPWLbits.CPW1               // bit 1, shadows bit in SMT1CPWLbits
#define SMT1CPW1                SMT1CPWLbits.SMT1CPW1           // bit 1, shadows bit in SMT1CPWLbits
#define CPW2                    SMT1CPWLbits.CPW2               // bit 2, shadows bit in SMT1CPWLbits
#define SMT1CPW2                SMT1CPWLbits.SMT1CPW2           // bit 2, shadows bit in SMT1CPWLbits
#define CPW3                    SMT1CPWLbits.CPW3               // bit 3, shadows bit in SMT1CPWLbits
#define SMT1CPW3                SMT1CPWLbits.SMT1CPW3           // bit 3, shadows bit in SMT1CPWLbits
#define CPW4                    SMT1CPWLbits.CPW4               // bit 4, shadows bit in SMT1CPWLbits
#define SMT1CPW4                SMT1CPWLbits.SMT1CPW4           // bit 4, shadows bit in SMT1CPWLbits
#define CPW5                    SMT1CPWLbits.CPW5               // bit 5, shadows bit in SMT1CPWLbits
#define SMT1CPW5                SMT1CPWLbits.SMT1CPW5           // bit 5, shadows bit in SMT1CPWLbits
#define CPW6                    SMT1CPWLbits.CPW6               // bit 6, shadows bit in SMT1CPWLbits
#define SMT1CPW6                SMT1CPWLbits.SMT1CPW6           // bit 6, shadows bit in SMT1CPWLbits
#define CPW7                    SMT1CPWLbits.CPW7               // bit 7, shadows bit in SMT1CPWLbits
#define SMT1CPW7                SMT1CPWLbits.SMT1CPW7           // bit 7, shadows bit in SMT1CPWLbits

#define CPW16                   SMT1CPWUbits.CPW16              // bit 0, shadows bit in SMT1CPWUbits
#define SMT1CPW16               SMT1CPWUbits.SMT1CPW16          // bit 0, shadows bit in SMT1CPWUbits
#define CPW17                   SMT1CPWUbits.CPW17              // bit 1, shadows bit in SMT1CPWUbits
#define SMT1CPW17               SMT1CPWUbits.SMT1CPW17          // bit 1, shadows bit in SMT1CPWUbits
#define CPW18                   SMT1CPWUbits.CPW18              // bit 2, shadows bit in SMT1CPWUbits
#define SMT1CPW18               SMT1CPWUbits.SMT1CPW18          // bit 2, shadows bit in SMT1CPWUbits
#define CPW19                   SMT1CPWUbits.CPW19              // bit 3, shadows bit in SMT1CPWUbits
#define SMT1CPW19               SMT1CPWUbits.SMT1CPW19          // bit 3, shadows bit in SMT1CPWUbits
#define CPW20                   SMT1CPWUbits.CPW20              // bit 4, shadows bit in SMT1CPWUbits
#define SMT1CPW20               SMT1CPWUbits.SMT1CPW20          // bit 4, shadows bit in SMT1CPWUbits
#define CPW21                   SMT1CPWUbits.CPW21              // bit 5, shadows bit in SMT1CPWUbits
#define SMT1CPW21               SMT1CPWUbits.SMT1CPW21          // bit 5, shadows bit in SMT1CPWUbits
#define CPW22                   SMT1CPWUbits.CPW22              // bit 6, shadows bit in SMT1CPWUbits
#define SMT1CPW22               SMT1CPWUbits.SMT1CPW22          // bit 6, shadows bit in SMT1CPWUbits
#define CPW23                   SMT1CPWUbits.CPW23              // bit 7, shadows bit in SMT1CPWUbits
#define SMT1CPW23               SMT1CPWUbits.SMT1CPW23          // bit 7, shadows bit in SMT1CPWUbits

#define SMT1PR8                 SMT1PRHbits.SMT1PR8             // bit 0
#define SMT1PR9                 SMT1PRHbits.SMT1PR9             // bit 1
#define SMT1PR10                SMT1PRHbits.SMT1PR10            // bit 2
#define SMT1PR11                SMT1PRHbits.SMT1PR11            // bit 3
#define SMT1PR12                SMT1PRHbits.SMT1PR12            // bit 4
#define SMT1PR13                SMT1PRHbits.SMT1PR13            // bit 5
#define SMT1PR14                SMT1PRHbits.SMT1PR14            // bit 6
#define SMT1PR15                SMT1PRHbits.SMT1PR15            // bit 7

#define SMT1PR0                 SMT1PRLbits.SMT1PR0             // bit 0
#define SMT1PR1                 SMT1PRLbits.SMT1PR1             // bit 1
#define SMT1PR2                 SMT1PRLbits.SMT1PR2             // bit 2
#define SMT1PR3                 SMT1PRLbits.SMT1PR3             // bit 3
#define SMT1PR4                 SMT1PRLbits.SMT1PR4             // bit 4
#define SMT1PR5                 SMT1PRLbits.SMT1PR5             // bit 5
#define SMT1PR6                 SMT1PRLbits.SMT1PR6             // bit 6
#define SMT1PR7                 SMT1PRLbits.SMT1PR7             // bit 7

#define SMT1PR16                SMT1PRUbits.SMT1PR16            // bit 0
#define SMT1PR17                SMT1PRUbits.SMT1PR17            // bit 1
#define SMT1PR18                SMT1PRUbits.SMT1PR18            // bit 2
#define SMT1PR19                SMT1PRUbits.SMT1PR19            // bit 3
#define SMT1PR20                SMT1PRUbits.SMT1PR20            // bit 4
#define SMT1PR21                SMT1PRUbits.SMT1PR21            // bit 5
#define SMT1PR22                SMT1PRUbits.SMT1PR22            // bit 6
#define SMT1PR23                SMT1PRUbits.SMT1PR23            // bit 7

#define SSEL0                   SMT1SIGbits.SSEL0               // bit 0, shadows bit in SMT1SIGbits
#define SMT1SSEL0               SMT1SIGbits.SMT1SSEL0           // bit 0, shadows bit in SMT1SIGbits
#define SSEL1                   SMT1SIGbits.SSEL1               // bit 1, shadows bit in SMT1SIGbits
#define SMT1SSEL1               SMT1SIGbits.SMT1SSEL1           // bit 1, shadows bit in SMT1SIGbits
#define SSEL2                   SMT1SIGbits.SSEL2               // bit 2, shadows bit in SMT1SIGbits
#define SMT1SSEL2               SMT1SIGbits.SMT1SSEL2           // bit 2, shadows bit in SMT1SIGbits
#define SSEL3                   SMT1SIGbits.SSEL3               // bit 3, shadows bit in SMT1SIGbits
#define SMT1SSEL3               SMT1SIGbits.SMT1SSEL3           // bit 3, shadows bit in SMT1SIGbits
#define SSEL4                   SMT1SIGbits.SSEL4               // bit 4, shadows bit in SMT1SIGbits
#define SMT1SSEL4               SMT1SIGbits.SMT1SSEL4           // bit 4, shadows bit in SMT1SIGbits

#define SMU1SIGPPS0             SMT1SIGPPSbits.SMU1SIGPPS0      // bit 0
#define SMU1SIGPPS1             SMT1SIGPPSbits.SMU1SIGPPS1      // bit 1
#define SMU1SIGPPS2             SMT1SIGPPSbits.SMU1SIGPPS2      // bit 2
#define SMU1SIGPPS3             SMT1SIGPPSbits.SMU1SIGPPS3      // bit 3
#define SMU1SIGPPS4             SMT1SIGPPSbits.SMU1SIGPPS4      // bit 4

#define AS                      SMT1STATbits.AS                 // bit 0, shadows bit in SMT1STATbits
#define SMT1AS                  SMT1STATbits.SMT1AS             // bit 0, shadows bit in SMT1STATbits
#define WS                      SMT1STATbits.WS                 // bit 1, shadows bit in SMT1STATbits
#define SMT1WS                  SMT1STATbits.SMT1WS             // bit 1, shadows bit in SMT1STATbits
#define TS                      SMT1STATbits.TS                 // bit 2, shadows bit in SMT1STATbits
#define SMT1TS                  SMT1STATbits.SMT1TS             // bit 2, shadows bit in SMT1STATbits
#define RST                     SMT1STATbits.RST                // bit 5, shadows bit in SMT1STATbits
#define SMT1RESET               SMT1STATbits.SMT1RESET          // bit 5, shadows bit in SMT1STATbits
#define CPWUP                   SMT1STATbits.CPWUP              // bit 6, shadows bit in SMT1STATbits
#define SMT1CPWUP               SMT1STATbits.SMT1CPWUP          // bit 6, shadows bit in SMT1STATbits
#define CPRUP                   SMT1STATbits.CPRUP              // bit 7, shadows bit in SMT1STATbits
#define SMT1CPRUP               SMT1STATbits.SMT1CPRUP          // bit 7, shadows bit in SMT1STATbits

#define SMT1TMR8                SMT1TMRHbits.SMT1TMR8           // bit 0
#define SMT1TMR9                SMT1TMRHbits.SMT1TMR9           // bit 1
#define SMT1TMR10               SMT1TMRHbits.SMT1TMR10          // bit 2
#define SMT1TMR11               SMT1TMRHbits.SMT1TMR11          // bit 3
#define SMT1TMR12               SMT1TMRHbits.SMT1TMR12          // bit 4
#define SMT1TMR13               SMT1TMRHbits.SMT1TMR13          // bit 5
#define SMT1TMR14               SMT1TMRHbits.SMT1TMR14          // bit 6
#define SMT1TMR15               SMT1TMRHbits.SMT1TMR15          // bit 7

#define SMT1TMR0                SMT1TMRLbits.SMT1TMR0           // bit 0
#define SMT1TMR1                SMT1TMRLbits.SMT1TMR1           // bit 1
#define SMT1TMR2                SMT1TMRLbits.SMT1TMR2           // bit 2
#define SMT1TMR3                SMT1TMRLbits.SMT1TMR3           // bit 3
#define SMT1TMR4                SMT1TMRLbits.SMT1TMR4           // bit 4
#define SMT1TMR5                SMT1TMRLbits.SMT1TMR5           // bit 5
#define SMT1TMR6                SMT1TMRLbits.SMT1TMR6           // bit 6
#define SMT1TMR7                SMT1TMRLbits.SMT1TMR7           // bit 7

#define SMT1TMR16               SMT1TMRUbits.SMT1TMR16          // bit 0
#define SMT1TMR17               SMT1TMRUbits.SMT1TMR17          // bit 1
#define SMT1TMR18               SMT1TMRUbits.SMT1TMR18          // bit 2
#define SMT1TMR19               SMT1TMRUbits.SMT1TMR19          // bit 3
#define SMT1TMR20               SMT1TMRUbits.SMT1TMR20          // bit 4
#define SMT1TMR21               SMT1TMRUbits.SMT1TMR21          // bit 5
#define SMT1TMR22               SMT1TMRUbits.SMT1TMR22          // bit 6
#define SMT1TMR23               SMT1TMRUbits.SMT1TMR23          // bit 7

#define WSEL0                   SMT1WINbits.WSEL0               // bit 0, shadows bit in SMT1WINbits
#define SMT1WSEL0               SMT1WINbits.SMT1WSEL0           // bit 0, shadows bit in SMT1WINbits
#define WSEL1                   SMT1WINbits.WSEL1               // bit 1, shadows bit in SMT1WINbits
#define SMT1WSEL1               SMT1WINbits.SMT1WSEL1           // bit 1, shadows bit in SMT1WINbits
#define WSEL2                   SMT1WINbits.WSEL2               // bit 2, shadows bit in SMT1WINbits
#define SMT1WSEL2               SMT1WINbits.SMT1WSEL2           // bit 2, shadows bit in SMT1WINbits
#define WSEL3                   SMT1WINbits.WSEL3               // bit 3, shadows bit in SMT1WINbits
#define SMT1WSEL3               SMT1WINbits.SMT1WSEL3           // bit 3, shadows bit in SMT1WINbits
#define WSEL4                   SMT1WINbits.WSEL4               // bit 4, shadows bit in SMT1WINbits
#define SMT1WSEL4               SMT1WINbits.SMT1WSEL4           // bit 4, shadows bit in SMT1WINbits

#define SMU1WINPPS0             SMT1WINPPSbits.SMU1WINPPS0      // bit 0
#define SMU1WINPPS1             SMT1WINPPSbits.SMU1WINPPS1      // bit 1
#define SMU1WINPPS2             SMT1WINPPSbits.SMU1WINPPS2      // bit 2
#define SMU1WINPPS3             SMT1WINPPSbits.SMU1WINPPS3      // bit 3
#define SMU1WINPPS4             SMT1WINPPSbits.SMU1WINPPS4      // bit 4

#define SMT2PR8                 SMT2PRHbits.SMT2PR8             // bit 0
#define SMT2PR9                 SMT2PRHbits.SMT2PR9             // bit 1
#define SMT2PR10                SMT2PRHbits.SMT2PR10            // bit 2
#define SMT2PR11                SMT2PRHbits.SMT2PR11            // bit 3
#define SMT2PR12                SMT2PRHbits.SMT2PR12            // bit 4
#define SMT2PR13                SMT2PRHbits.SMT2PR13            // bit 5
#define SMT2PR14                SMT2PRHbits.SMT2PR14            // bit 6
#define SMT2PR15                SMT2PRHbits.SMT2PR15            // bit 7

#define SMT2PR0                 SMT2PRLbits.SMT2PR0             // bit 0
#define SMT2PR1                 SMT2PRLbits.SMT2PR1             // bit 1
#define SMT2PR2                 SMT2PRLbits.SMT2PR2             // bit 2
#define SMT2PR3                 SMT2PRLbits.SMT2PR3             // bit 3
#define SMT2PR4                 SMT2PRLbits.SMT2PR4             // bit 4
#define SMT2PR5                 SMT2PRLbits.SMT2PR5             // bit 5
#define SMT2PR6                 SMT2PRLbits.SMT2PR6             // bit 6
#define SMT2PR7                 SMT2PRLbits.SMT2PR7             // bit 7

#define SMT2PR16                SMT2PRUbits.SMT2PR16            // bit 0
#define SMT2PR17                SMT2PRUbits.SMT2PR17            // bit 1
#define SMT2PR18                SMT2PRUbits.SMT2PR18            // bit 2
#define SMT2PR19                SMT2PRUbits.SMT2PR19            // bit 3
#define SMT2PR20                SMT2PRUbits.SMT2PR20            // bit 4
#define SMT2PR21                SMT2PRUbits.SMT2PR21            // bit 5
#define SMT2PR22                SMT2PRUbits.SMT2PR22            // bit 6
#define SMT2PR23                SMT2PRUbits.SMT2PR23            // bit 7

#define SMU2SIGPPS0             SMT2SIGPPSbits.SMU2SIGPPS0      // bit 0
#define SMU2SIGPPS1             SMT2SIGPPSbits.SMU2SIGPPS1      // bit 1
#define SMU2SIGPPS2             SMT2SIGPPSbits.SMU2SIGPPS2      // bit 2
#define SMU2SIGPPS3             SMT2SIGPPSbits.SMU2SIGPPS3      // bit 3
#define SMU2SIGPPS4             SMT2SIGPPSbits.SMU2SIGPPS4      // bit 4

#define SMT2TMR8                SMT2TMRHbits.SMT2TMR8           // bit 0
#define SMT2TMR9                SMT2TMRHbits.SMT2TMR9           // bit 1
#define SMT2TMR10               SMT2TMRHbits.SMT2TMR10          // bit 2
#define SMT2TMR11               SMT2TMRHbits.SMT2TMR11          // bit 3
#define SMT2TMR12               SMT2TMRHbits.SMT2TMR12          // bit 4
#define SMT2TMR13               SMT2TMRHbits.SMT2TMR13          // bit 5
#define SMT2TMR14               SMT2TMRHbits.SMT2TMR14          // bit 6
#define SMT2TMR15               SMT2TMRHbits.SMT2TMR15          // bit 7

#define SMT2TMR0                SMT2TMRLbits.SMT2TMR0           // bit 0
#define SMT2TMR1                SMT2TMRLbits.SMT2TMR1           // bit 1
#define SMT2TMR2                SMT2TMRLbits.SMT2TMR2           // bit 2
#define SMT2TMR3                SMT2TMRLbits.SMT2TMR3           // bit 3
#define SMT2TMR4                SMT2TMRLbits.SMT2TMR4           // bit 4
#define SMT2TMR5                SMT2TMRLbits.SMT2TMR5           // bit 5
#define SMT2TMR6                SMT2TMRLbits.SMT2TMR6           // bit 6
#define SMT2TMR7                SMT2TMRLbits.SMT2TMR7           // bit 7

#define SMT2TMR16               SMT2TMRUbits.SMT2TMR16          // bit 0
#define SMT2TMR17               SMT2TMRUbits.SMT2TMR17          // bit 1
#define SMT2TMR18               SMT2TMRUbits.SMT2TMR18          // bit 2
#define SMT2TMR19               SMT2TMRUbits.SMT2TMR19          // bit 3
#define SMT2TMR20               SMT2TMRUbits.SMT2TMR20          // bit 4
#define SMT2TMR21               SMT2TMRUbits.SMT2TMR21          // bit 5
#define SMT2TMR22               SMT2TMRUbits.SMT2TMR22          // bit 6
#define SMT2TMR23               SMT2TMRUbits.SMT2TMR23          // bit 7

#define SMU2WINPPS0             SMT2WINPPSbits.SMU2WINPPS0      // bit 0
#define SMU2WINPPS1             SMT2WINPPSbits.SMU2WINPPS1      // bit 1
#define SMU2WINPPS2             SMT2WINPPSbits.SMU2WINPPS2      // bit 2
#define SMU2WINPPS3             SMT2WINPPSbits.SMU2WINPPS3      // bit 3
#define SMU2WINPPS4             SMT2WINPPSbits.SMU2WINPPS4      // bit 4

#define SSP1CLKPPS0             SSP1CLKPPSbits.SSP1CLKPPS0      // bit 0
#define SSP1CLKPPS1             SSP1CLKPPSbits.SSP1CLKPPS1      // bit 1
#define SSP1CLKPPS2             SSP1CLKPPSbits.SSP1CLKPPS2      // bit 2
#define SSP1CLKPPS3             SSP1CLKPPSbits.SSP1CLKPPS3      // bit 3
#define SSP1CLKPPS4             SSP1CLKPPSbits.SSP1CLKPPS4      // bit 4

#define SSPM0                   SSP1CON1bits.SSPM0              // bit 0
#define SSPM1                   SSP1CON1bits.SSPM1              // bit 1
#define SSPM2                   SSP1CON1bits.SSPM2              // bit 2
#define SSPM3                   SSP1CON1bits.SSPM3              // bit 3
#define CKP                     SSP1CON1bits.CKP                // bit 4
#define SSPEN                   SSP1CON1bits.SSPEN              // bit 5
#define SSPOV                   SSP1CON1bits.SSPOV              // bit 6
#define WCOL                    SSP1CON1bits.WCOL               // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1, shadows bit in SSP1CON2bits
#define ADMSK1                  SSP1CON2bits.ADMSK1             // bit 1, shadows bit in SSP1CON2bits
#define PEN                     SSP1CON2bits.PEN                // bit 2, shadows bit in SSP1CON2bits
#define ADMSK2                  SSP1CON2bits.ADMSK2             // bit 2, shadows bit in SSP1CON2bits
#define RCEN                    SSP1CON2bits.RCEN               // bit 3, shadows bit in SSP1CON2bits
#define ADMSK3                  SSP1CON2bits.ADMSK3             // bit 3, shadows bit in SSP1CON2bits
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4, shadows bit in SSP1CON2bits
#define ADMSK4                  SSP1CON2bits.ADMSK4             // bit 4, shadows bit in SSP1CON2bits
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5, shadows bit in SSP1CON2bits
#define ADMSK5                  SSP1CON2bits.ADMSK5             // bit 5, shadows bit in SSP1CON2bits
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define SSP1DATPPS0             SSP1DATPPSbits.SSP1DATPPS0      // bit 0
#define SSP1DATPPS1             SSP1DATPPSbits.SSP1DATPPS1      // bit 1
#define SSP1DATPPS2             SSP1DATPPSbits.SSP1DATPPS2      // bit 2
#define SSP1DATPPS3             SSP1DATPPSbits.SSP1DATPPS3      // bit 3
#define SSP1DATPPS4             SSP1DATPPSbits.SSP1DATPPS4      // bit 4

#define MSK0                    SSP1MSKbits.MSK0                // bit 0
#define MSK1                    SSP1MSKbits.MSK1                // bit 1
#define MSK2                    SSP1MSKbits.MSK2                // bit 2
#define MSK3                    SSP1MSKbits.MSK3                // bit 3
#define MSK4                    SSP1MSKbits.MSK4                // bit 4
#define MSK5                    SSP1MSKbits.MSK5                // bit 5
#define MSK6                    SSP1MSKbits.MSK6                // bit 6
#define MSK7                    SSP1MSKbits.MSK7                // bit 7

#define SSP1SSPPS0              SSP1SSPPSbits.SSP1SSPPS0        // bit 0
#define SSP1SSPPS1              SSP1SSPPSbits.SSP1SSPPS1        // bit 1
#define SSP1SSPPS2              SSP1SSPPSbits.SSP1SSPPS2        // bit 2
#define SSP1SSPPS3              SSP1SSPPSbits.SSP1SSPPS3        // bit 3
#define SSP1SSPPS4              SSP1SSPPSbits.SSP1SSPPS4        // bit 4

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2, shadows bit in SSP1STATbits
#define R_W                     SSP1STATbits.R_W                // bit 2, shadows bit in SSP1STATbits
#define NOT_W                   SSP1STATbits.NOT_W              // bit 2, shadows bit in SSP1STATbits
#define NOT_WRITE               SSP1STATbits.NOT_WRITE          // bit 2, shadows bit in SSP1STATbits
#define READ_WRITE              SSP1STATbits.READ_WRITE         // bit 2, shadows bit in SSP1STATbits
#define I2C_READ                SSP1STATbits.I2C_READ           // bit 2, shadows bit in SSP1STATbits
#define S                       SSP1STATbits.S                  // bit 3, shadows bit in SSP1STATbits
#define I2C_START               SSP1STATbits.I2C_START          // bit 3, shadows bit in SSP1STATbits
#define P                       SSP1STATbits.P                  // bit 4, shadows bit in SSP1STATbits
#define I2C_STOP                SSP1STATbits.I2C_STOP           // bit 4, shadows bit in SSP1STATbits
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5, shadows bit in SSP1STATbits
#define D_A                     SSP1STATbits.D_A                // bit 5, shadows bit in SSP1STATbits
#define NOT_A                   SSP1STATbits.NOT_A              // bit 5, shadows bit in SSP1STATbits
#define NOT_ADDRESS             SSP1STATbits.NOT_ADDRESS        // bit 5, shadows bit in SSP1STATbits
#define DATA_ADDRESS            SSP1STATbits.DATA_ADDRESS       // bit 5, shadows bit in SSP1STATbits
#define I2C_DAT                 SSP1STATbits.I2C_DAT            // bit 5, shadows bit in SSP1STATbits
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define SSP2CLKPPS0             SSP2CLKPPSbits.SSP2CLKPPS0      // bit 0
#define SSP2CLKPPS1             SSP2CLKPPSbits.SSP2CLKPPS1      // bit 1
#define SSP2CLKPPS2             SSP2CLKPPSbits.SSP2CLKPPS2      // bit 2
#define SSP2CLKPPS3             SSP2CLKPPSbits.SSP2CLKPPS3      // bit 3
#define SSP2CLKPPS4             SSP2CLKPPSbits.SSP2CLKPPS4      // bit 4

#define SSP2DATPPS0             SSP2DATPPSbits.SSP2DATPPS0      // bit 0
#define SSP2DATPPS1             SSP2DATPPSbits.SSP2DATPPS1      // bit 1
#define SSP2DATPPS2             SSP2DATPPSbits.SSP2DATPPS2      // bit 2
#define SSP2DATPPS3             SSP2DATPPSbits.SSP2DATPPS3      // bit 3
#define SSP2DATPPS4             SSP2DATPPSbits.SSP2DATPPS4      // bit 4

#define SSP2SSPPS0              SSP2SSPPSbits.SSP2SSPPS0        // bit 0
#define SSP2SSPPS1              SSP2SSPPSbits.SSP2SSPPS1        // bit 1
#define SSP2SSPPS2              SSP2SSPPSbits.SSP2SSPPS2        // bit 2
#define SSP2SSPPS3              SSP2SSPPSbits.SSP2SSPPS3        // bit 3
#define SSP2SSPPS4              SSP2SSPPSbits.SSP2SSPPS4        // bit 4

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define T0CKIPPS0               T0CKIPPSbits.T0CKIPPS0          // bit 0
#define T0CKIPPS1               T0CKIPPSbits.T0CKIPPS1          // bit 1
#define T0CKIPPS2               T0CKIPPSbits.T0CKIPPS2          // bit 2
#define T0CKIPPS3               T0CKIPPSbits.T0CKIPPS3          // bit 3

#define T0OUTPS0                T0CON0bits.T0OUTPS0             // bit 0
#define T0OUTPS1                T0CON0bits.T0OUTPS1             // bit 1
#define T0OUTPS2                T0CON0bits.T0OUTPS2             // bit 2
#define T0OUTPS3                T0CON0bits.T0OUTPS3             // bit 3
#define T016BIT                 T0CON0bits.T016BIT              // bit 4
#define T0OUT                   T0CON0bits.T0OUT                // bit 5
#define T0EN                    T0CON0bits.T0EN                 // bit 7

#define T0CKPS0                 T0CON1bits.T0CKPS0              // bit 0, shadows bit in T0CON1bits
#define T0PS0                   T0CON1bits.T0PS0                // bit 0, shadows bit in T0CON1bits
#define T0CKPS1                 T0CON1bits.T0CKPS1              // bit 1, shadows bit in T0CON1bits
#define T0PS1                   T0CON1bits.T0PS1                // bit 1, shadows bit in T0CON1bits
#define T0CKPS2                 T0CON1bits.T0CKPS2              // bit 2, shadows bit in T0CON1bits
#define T0PS2                   T0CON1bits.T0PS2                // bit 2, shadows bit in T0CON1bits
#define T0CKPS3                 T0CON1bits.T0CKPS3              // bit 3, shadows bit in T0CON1bits
#define T0PS3                   T0CON1bits.T0PS3                // bit 3, shadows bit in T0CON1bits
#define T0ASYNC                 T0CON1bits.T0ASYNC              // bit 4
#define T0CS0                   T0CON1bits.T0CS0                // bit 5
#define T0CS1                   T0CON1bits.T0CS1                // bit 6
#define T0CS2                   T0CON1bits.T0CS2                // bit 7

#define T1CKIPPS0               T1CKIPPSbits.T1CKIPPS0          // bit 0
#define T1CKIPPS1               T1CKIPPSbits.T1CKIPPS1          // bit 1
#define T1CKIPPS2               T1CKIPPSbits.T1CKIPPS2          // bit 2
#define T1CKIPPS3               T1CKIPPSbits.T1CKIPPS3          // bit 3
#define T1CKIPPS4               T1CKIPPSbits.T1CKIPPS4          // bit 4

#define T1CS0                   T1CLKbits.T1CS0                 // bit 0, shadows bit in T1CLKbits
#define CS0                     T1CLKbits.CS0                   // bit 0, shadows bit in T1CLKbits
#define T1CS1                   T1CLKbits.T1CS1                 // bit 1, shadows bit in T1CLKbits
#define CS1                     T1CLKbits.CS1                   // bit 1, shadows bit in T1CLKbits
#define T1CS2                   T1CLKbits.T1CS2                 // bit 2, shadows bit in T1CLKbits
#define CS2                     T1CLKbits.CS2                   // bit 2, shadows bit in T1CLKbits
#define T1CS3                   T1CLKbits.T1CS3                 // bit 3, shadows bit in T1CLKbits
#define CS3                     T1CLKbits.CS3                   // bit 3, shadows bit in T1CLKbits

#define GSS0                    T1GATEbits.GSS0                 // bit 0, shadows bit in T1GATEbits
#define T1GSS0                  T1GATEbits.T1GSS0               // bit 0, shadows bit in T1GATEbits
#define GSS1                    T1GATEbits.GSS1                 // bit 1, shadows bit in T1GATEbits
#define T1GSS1                  T1GATEbits.T1GSS1               // bit 1, shadows bit in T1GATEbits
#define GSS2                    T1GATEbits.GSS2                 // bit 2, shadows bit in T1GATEbits
#define T1GSS2                  T1GATEbits.T1GSS2               // bit 2, shadows bit in T1GATEbits
#define GSS3                    T1GATEbits.GSS3                 // bit 3, shadows bit in T1GATEbits
#define T1GSS3                  T1GATEbits.T1GSS3               // bit 3, shadows bit in T1GATEbits
#define GSS4                    T1GATEbits.GSS4                 // bit 4, shadows bit in T1GATEbits
#define T1GSS4                  T1GATEbits.T1GSS4               // bit 4, shadows bit in T1GATEbits

#define T1GPPS0                 T1GPPSbits.T1GPPS0              // bit 0
#define T1GPPS1                 T1GPPSbits.T1GPPS1              // bit 1
#define T1GPPS2                 T1GPPSbits.T1GPPS2              // bit 2
#define T1GPPS3                 T1GPPSbits.T1GPPS3              // bit 3
#define T1GPPS4                 T1GPPSbits.T1GPPS4              // bit 4

#define T2AINPPS0               T2AINPPSbits.T2AINPPS0          // bit 0
#define T2AINPPS1               T2AINPPSbits.T2AINPPS1          // bit 1
#define T2AINPPS2               T2AINPPSbits.T2AINPPS2          // bit 2
#define T2AINPPS3               T2AINPPSbits.T2AINPPS3          // bit 3
#define T2AINPPS4               T2AINPPSbits.T2AINPPS4          // bit 4

#define T2CS0                   T2CLKCONbits.T2CS0              // bit 0
#define T2CS1                   T2CLKCONbits.T2CS1              // bit 1
#define T2CS2                   T2CLKCONbits.T2CS2              // bit 2
#define T2CS3                   T2CLKCONbits.T2CS3              // bit 3

#define RSEL0                   T2RSTbits.RSEL0                 // bit 0, shadows bit in T2RSTbits
#define T2RSEL0                 T2RSTbits.T2RSEL0               // bit 0, shadows bit in T2RSTbits
#define RSEL1                   T2RSTbits.RSEL1                 // bit 1, shadows bit in T2RSTbits
#define T2RSEL1                 T2RSTbits.T2RSEL1               // bit 1, shadows bit in T2RSTbits
#define RSEL2                   T2RSTbits.RSEL2                 // bit 2, shadows bit in T2RSTbits
#define T2RSEL2                 T2RSTbits.T2RSEL2               // bit 2, shadows bit in T2RSTbits
#define RSEL3                   T2RSTbits.RSEL3                 // bit 3, shadows bit in T2RSTbits
#define T2RSEL3                 T2RSTbits.T2RSEL3               // bit 3, shadows bit in T2RSTbits
#define RSEL4                   T2RSTbits.RSEL4                 // bit 4, shadows bit in T2RSTbits
#define T2RSEL4                 T2RSTbits.T2RSEL4               // bit 4, shadows bit in T2RSTbits

#define T3CKIPPS0               T3CKIPPSbits.T3CKIPPS0          // bit 0
#define T3CKIPPS1               T3CKIPPSbits.T3CKIPPS1          // bit 1
#define T3CKIPPS2               T3CKIPPSbits.T3CKIPPS2          // bit 2
#define T3CKIPPS3               T3CKIPPSbits.T3CKIPPS3          // bit 3
#define T3CKIPPS4               T3CKIPPSbits.T3CKIPPS4          // bit 4

#define T3GPPS0                 T3GPPSbits.T3GPPS0              // bit 0
#define T3GPPS1                 T3GPPSbits.T3GPPS1              // bit 1
#define T3GPPS2                 T3GPPSbits.T3GPPS2              // bit 2
#define T3GPPS3                 T3GPPSbits.T3GPPS3              // bit 3
#define T3GPPS4                 T3GPPSbits.T3GPPS4              // bit 4

#define T4AINPPS0               T4AINPPSbits.T4AINPPS0          // bit 0
#define T4AINPPS1               T4AINPPSbits.T4AINPPS1          // bit 1
#define T4AINPPS2               T4AINPPSbits.T4AINPPS2          // bit 2
#define T4AINPPS3               T4AINPPSbits.T4AINPPS3          // bit 3
#define T4AINPPS4               T4AINPPSbits.T4AINPPS4          // bit 4

#define T4CS0                   T4CLKCONbits.T4CS0              // bit 0
#define T4CS1                   T4CLKCONbits.T4CS1              // bit 1
#define T4CS2                   T4CLKCONbits.T4CS2              // bit 2
#define T4CS3                   T4CLKCONbits.T4CS3              // bit 3

#define T5CKIPPS0               T5CKIPPSbits.T5CKIPPS0          // bit 0
#define T5CKIPPS1               T5CKIPPSbits.T5CKIPPS1          // bit 1
#define T5CKIPPS2               T5CKIPPSbits.T5CKIPPS2          // bit 2
#define T5CKIPPS3               T5CKIPPSbits.T5CKIPPS3          // bit 3
#define T5CKIPPS4               T5CKIPPSbits.T5CKIPPS4          // bit 4

#define T5GPPS0                 T5GPPSbits.T5GPPS0              // bit 0
#define T5GPPS1                 T5GPPSbits.T5GPPS1              // bit 1
#define T5GPPS2                 T5GPPSbits.T5GPPS2              // bit 2
#define T5GPPS3                 T5GPPSbits.T5GPPS3              // bit 3
#define T5GPPS4                 T5GPPSbits.T5GPPS4              // bit 4

#define T6AINPPS0               T6AINPPSbits.T6AINPPS0          // bit 0
#define T6AINPPS1               T6AINPPSbits.T6AINPPS1          // bit 1
#define T6AINPPS2               T6AINPPSbits.T6AINPPS2          // bit 2
#define T6AINPPS3               T6AINPPSbits.T6AINPPS3          // bit 3
#define T6AINPPS4               T6AINPPSbits.T6AINPPS4          // bit 4

#define T6CS0                   T6CLKCONbits.T6CS0              // bit 0
#define T6CS1                   T6CLKCONbits.T6CS1              // bit 1
#define T6CS2                   T6CLKCONbits.T6CS2              // bit 2
#define T6CS3                   T6CLKCONbits.T6CS3              // bit 3

#define TMR0L0                  TMR0bits.TMR0L0                 // bit 0
#define TMR0L1                  TMR0bits.TMR0L1                 // bit 1
#define TMR0L2                  TMR0bits.TMR0L2                 // bit 2
#define TMR0L3                  TMR0bits.TMR0L3                 // bit 3
#define TMR0L4                  TMR0bits.TMR0L4                 // bit 4
#define TMR0L5                  TMR0bits.TMR0L5                 // bit 5
#define TMR0L6                  TMR0bits.TMR0L6                 // bit 6
#define TMR0L7                  TMR0bits.TMR0L7                 // bit 7

#define TMR1H0                  TMR1Hbits.TMR1H0                // bit 0
#define TMR1H1                  TMR1Hbits.TMR1H1                // bit 1
#define TMR1H2                  TMR1Hbits.TMR1H2                // bit 2
#define TMR1H3                  TMR1Hbits.TMR1H3                // bit 3
#define TMR1H4                  TMR1Hbits.TMR1H4                // bit 4
#define TMR1H5                  TMR1Hbits.TMR1H5                // bit 5
#define TMR1H6                  TMR1Hbits.TMR1H6                // bit 6
#define TMR1H7                  TMR1Hbits.TMR1H7                // bit 7

#define TMR1L0                  TMR1Lbits.TMR1L0                // bit 0
#define TMR1L1                  TMR1Lbits.TMR1L1                // bit 1
#define TMR1L2                  TMR1Lbits.TMR1L2                // bit 2
#define TMR1L3                  TMR1Lbits.TMR1L3                // bit 3
#define TMR1L4                  TMR1Lbits.TMR1L4                // bit 4
#define TMR1L5                  TMR1Lbits.TMR1L5                // bit 5
#define TMR1L6                  TMR1Lbits.TMR1L6                // bit 6
#define TMR1L7                  TMR1Lbits.TMR1L7                // bit 7

#define TMR3H0                  TMR3Hbits.TMR3H0                // bit 0
#define TMR3H1                  TMR3Hbits.TMR3H1                // bit 1
#define TMR3H2                  TMR3Hbits.TMR3H2                // bit 2
#define TMR3H3                  TMR3Hbits.TMR3H3                // bit 3
#define TMR3H4                  TMR3Hbits.TMR3H4                // bit 4
#define TMR3H5                  TMR3Hbits.TMR3H5                // bit 5
#define TMR3H6                  TMR3Hbits.TMR3H6                // bit 6
#define TMR3H7                  TMR3Hbits.TMR3H7                // bit 7

#define TMR3L0                  TMR3Lbits.TMR3L0                // bit 0
#define TMR3L1                  TMR3Lbits.TMR3L1                // bit 1
#define TMR3L2                  TMR3Lbits.TMR3L2                // bit 2
#define TMR3L3                  TMR3Lbits.TMR3L3                // bit 3
#define TMR3L4                  TMR3Lbits.TMR3L4                // bit 4
#define TMR3L5                  TMR3Lbits.TMR3L5                // bit 5
#define TMR3L6                  TMR3Lbits.TMR3L6                // bit 6
#define TMR3L7                  TMR3Lbits.TMR3L7                // bit 7

#define TMR5H0                  TMR5Hbits.TMR5H0                // bit 0
#define TMR5H1                  TMR5Hbits.TMR5H1                // bit 1
#define TMR5H2                  TMR5Hbits.TMR5H2                // bit 2
#define TMR5H3                  TMR5Hbits.TMR5H3                // bit 3
#define TMR5H4                  TMR5Hbits.TMR5H4                // bit 4
#define TMR5H5                  TMR5Hbits.TMR5H5                // bit 5
#define TMR5H6                  TMR5Hbits.TMR5H6                // bit 6
#define TMR5H7                  TMR5Hbits.TMR5H7                // bit 7

#define TMR5L0                  TMR5Lbits.TMR5L0                // bit 0
#define TMR5L1                  TMR5Lbits.TMR5L1                // bit 1
#define TMR5L2                  TMR5Lbits.TMR5L2                // bit 2
#define TMR5L3                  TMR5Lbits.TMR5L3                // bit 3
#define TMR5L4                  TMR5Lbits.TMR5L4                // bit 4
#define TMR5L5                  TMR5Lbits.TMR5L5                // bit 5
#define TMR5L6                  TMR5Lbits.TMR5L6                // bit 6
#define TMR5L7                  TMR5Lbits.TMR5L7                // bit 7

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5
#define TRISA6                  TRISAbits.TRISA6                // bit 6
#define TRISA7                  TRISAbits.TRISA7                // bit 7

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TXPPS0                  TXPPSbits.TXPPS0                // bit 0
#define TXPPS1                  TXPPSbits.TXPPS1                // bit 1
#define TXPPS2                  TXPPSbits.TXPPS2                // bit 2
#define TXPPS3                  TXPPSbits.TXPPS3                // bit 3
#define TXPPS4                  TXPPSbits.TXPPS4                // bit 4

#define WINDOW0                 WDTCON1bits.WINDOW0             // bit 0, shadows bit in WDTCON1bits
#define WDTWINDOW0              WDTCON1bits.WDTWINDOW0          // bit 0, shadows bit in WDTCON1bits
#define WINDOW1                 WDTCON1bits.WINDOW1             // bit 1, shadows bit in WDTCON1bits
#define WDTWINDOW1              WDTCON1bits.WDTWINDOW1          // bit 1, shadows bit in WDTCON1bits
#define WINDOW2                 WDTCON1bits.WINDOW2             // bit 2, shadows bit in WDTCON1bits
#define WDTWINDOW2              WDTCON1bits.WDTWINDOW2          // bit 2, shadows bit in WDTCON1bits
#define WDTCS0                  WDTCON1bits.WDTCS0              // bit 4
#define WDTCS1                  WDTCON1bits.WDTCS1              // bit 5
#define WDTCS2                  WDTCON1bits.WDTCS2              // bit 6

#define PSCNT8                  WDTPSHbits.PSCNT8               // bit 0, shadows bit in WDTPSHbits
#define WDTPSCNT8               WDTPSHbits.WDTPSCNT8            // bit 0, shadows bit in WDTPSHbits
#define PSCNT9                  WDTPSHbits.PSCNT9               // bit 1, shadows bit in WDTPSHbits
#define WDTPSCNT9               WDTPSHbits.WDTPSCNT9            // bit 1, shadows bit in WDTPSHbits
#define PSCNT10                 WDTPSHbits.PSCNT10              // bit 2, shadows bit in WDTPSHbits
#define WDTPSCNT10              WDTPSHbits.WDTPSCNT10           // bit 2, shadows bit in WDTPSHbits
#define PSCNT11                 WDTPSHbits.PSCNT11              // bit 3, shadows bit in WDTPSHbits
#define WDTPSCNT11              WDTPSHbits.WDTPSCNT11           // bit 3, shadows bit in WDTPSHbits
#define PSCNT12                 WDTPSHbits.PSCNT12              // bit 4, shadows bit in WDTPSHbits
#define WDTPSCNT12              WDTPSHbits.WDTPSCNT12           // bit 4, shadows bit in WDTPSHbits
#define PSCNT13                 WDTPSHbits.PSCNT13              // bit 5, shadows bit in WDTPSHbits
#define WDTPSCNT13              WDTPSHbits.WDTPSCNT13           // bit 5, shadows bit in WDTPSHbits
#define PSCNT14                 WDTPSHbits.PSCNT14              // bit 6, shadows bit in WDTPSHbits
#define WDTPSCNT14              WDTPSHbits.WDTPSCNT14           // bit 6, shadows bit in WDTPSHbits
#define PSCNT15                 WDTPSHbits.PSCNT15              // bit 7, shadows bit in WDTPSHbits
#define WDTPSCNT15              WDTPSHbits.WDTPSCNT15           // bit 7, shadows bit in WDTPSHbits

#define PSCNT0                  WDTPSLbits.PSCNT0               // bit 0, shadows bit in WDTPSLbits
#define WDTPSCNT0               WDTPSLbits.WDTPSCNT0            // bit 0, shadows bit in WDTPSLbits
#define PSCNT1                  WDTPSLbits.PSCNT1               // bit 1, shadows bit in WDTPSLbits
#define WDTPSCNT1               WDTPSLbits.WDTPSCNT1            // bit 1, shadows bit in WDTPSLbits
#define PSCNT2                  WDTPSLbits.PSCNT2               // bit 2, shadows bit in WDTPSLbits
#define WDTPSCNT2               WDTPSLbits.WDTPSCNT2            // bit 2, shadows bit in WDTPSLbits
#define PSCNT3                  WDTPSLbits.PSCNT3               // bit 3, shadows bit in WDTPSLbits
#define WDTPSCNT3               WDTPSLbits.WDTPSCNT3            // bit 3, shadows bit in WDTPSLbits
#define PSCNT4                  WDTPSLbits.PSCNT4               // bit 4, shadows bit in WDTPSLbits
#define WDTPSCNT4               WDTPSLbits.WDTPSCNT4            // bit 4, shadows bit in WDTPSLbits
#define PSCNT5                  WDTPSLbits.PSCNT5               // bit 5, shadows bit in WDTPSLbits
#define WDTPSCNT5               WDTPSLbits.WDTPSCNT5            // bit 5, shadows bit in WDTPSLbits
#define PSCNT6                  WDTPSLbits.PSCNT6               // bit 6, shadows bit in WDTPSLbits
#define WDTPSCNT6               WDTPSLbits.WDTPSCNT6            // bit 6, shadows bit in WDTPSLbits
#define PSCNT7                  WDTPSLbits.PSCNT7               // bit 7, shadows bit in WDTPSLbits
#define WDTPSCNT7               WDTPSLbits.WDTPSCNT7            // bit 7, shadows bit in WDTPSLbits

#define PSCNT16                 WDTTMRbits.PSCNT16              // bit 0, shadows bit in WDTTMRbits
#define WDTPSCNT16              WDTTMRbits.WDTPSCNT16           // bit 0, shadows bit in WDTTMRbits
#define PSCNT17                 WDTTMRbits.PSCNT17              // bit 1, shadows bit in WDTTMRbits
#define WDTPSCNT17              WDTTMRbits.WDTPSCNT17           // bit 1, shadows bit in WDTTMRbits
#define STATE                   WDTTMRbits.STATE                // bit 2, shadows bit in WDTTMRbits
#define WDTSTATE                WDTTMRbits.WDTSTATE             // bit 2, shadows bit in WDTTMRbits
#define WDTTMR0                 WDTTMRbits.WDTTMR0              // bit 3
#define WDTTMR1                 WDTTMRbits.WDTTMR1              // bit 4
#define WDTTMR2                 WDTTMRbits.WDTTMR2              // bit 5
#define WDTTMR3                 WDTTMRbits.WDTTMR3              // bit 6

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5
#define WPUA6                   WPUAbits.WPUA6                  // bit 6
#define WPUA7                   WPUAbits.WPUA7                  // bit 7

#define WPUB0                   WPUBbits.WPUB0                  // bit 0
#define WPUB1                   WPUBbits.WPUB1                  // bit 1
#define WPUB2                   WPUBbits.WPUB2                  // bit 2
#define WPUB3                   WPUBbits.WPUB3                  // bit 3
#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#define WPUC0                   WPUCbits.WPUC0                  // bit 0
#define WPUC1                   WPUCbits.WPUC1                  // bit 1
#define WPUC2                   WPUCbits.WPUC2                  // bit 2
#define WPUC3                   WPUCbits.WPUC3                  // bit 3
#define WPUC4                   WPUCbits.WPUC4                  // bit 4
#define WPUC5                   WPUCbits.WPUC5                  // bit 5
#define WPUC6                   WPUCbits.WPUC6                  // bit 6
#define WPUC7                   WPUCbits.WPUC7                  // bit 7

#define WPUE3                   WPUEbits.WPUE3                  // bit 3

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16LF18855_H__
