/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard;

import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.StandardRoom;

public class StatuesRoom
extends StandardRoom {
    @Override
    public int minWidth() {
        return Math.max(7, super.minWidth());
    }

    @Override
    public int minHeight() {
        return Math.max(7, super.minHeight());
    }

    @Override
    public float[] sizeCatProbs() {
        return new float[]{9.0f, 3.0f, 1.0f};
    }

    @Override
    public void paint(Level level) {
        Painter.fill(level, this, 4);
        Painter.fill(level, this, 1, 1);
        for (Room.Door door : this.connected.values()) {
            door.set(Room.Door.Type.REGULAR);
        }
        int rows = (this.width() + 1) / 6;
        int cols = (this.height() + 1) / 6;
        int w = (this.width() - 4 - (rows - 1)) / rows;
        int h = (this.height() - 4 - (cols - 1)) / cols;
        int Wspacing = rows % 2 == this.width() % 2 ? 2 : 1;
        int Hspacing = cols % 2 == this.height() % 2 ? 2 : 1;
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < cols; ++y) {
                int left = this.left + 2 + x * (w + Wspacing);
                int top = this.top + 2 + y * (h + Hspacing);
                Painter.fill(level, left, top, w, h, 14);
                Painter.set(level, left, top, 26);
                Painter.set(level, left + w - 1, top, 26);
                Painter.set(level, left, top + h - 1, 26);
                Painter.set(level, left + w - 1, top + h - 1, 26);
                if (w < 5 || h < 5) continue;
                Painter.fill(level, left + 2, top + 2, w - 4, h - 4, 26);
            }
        }
    }
}

