/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityFile;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Util;
import java.util.Vector;

class LocalIdentityRepository
implements IdentityRepository {
    private static final String name = "Local Identity Repository";
    private Vector identities = new Vector();
    private JSch jsch;

    LocalIdentityRepository(JSch jSch) {
        this.jsch = jSch;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getStatus() {
        return 2;
    }

    @Override
    public synchronized Vector getIdentities() {
        this.removeDupulicates();
        Vector vector = new Vector();
        for (int i = 0; i < this.identities.size(); ++i) {
            vector.addElement(this.identities.elementAt(i));
        }
        return vector;
    }

    public synchronized void add(Identity identity) {
        if (!this.identities.contains(identity)) {
            byte[] byArray = identity.getPublicKeyBlob();
            if (byArray == null) {
                this.identities.addElement(identity);
                return;
            }
            for (int i = 0; i < this.identities.size(); ++i) {
                byte[] byArray2 = ((Identity)this.identities.elementAt(i)).getPublicKeyBlob();
                if (byArray2 == null || !Util.array_equals(byArray, byArray2)) continue;
                if (!identity.isEncrypted() && ((Identity)this.identities.elementAt(i)).isEncrypted()) {
                    this.remove(byArray2);
                    continue;
                }
                return;
            }
            this.identities.addElement(identity);
        }
    }

    @Override
    public synchronized boolean add(byte[] byArray) {
        try {
            IdentityFile identityFile = IdentityFile.newInstance("from remote:", byArray, null, this.jsch);
            this.add(identityFile);
            return true;
        }
        catch (JSchException jSchException) {
            return false;
        }
    }

    synchronized void remove(Identity identity) {
        if (this.identities.contains(identity)) {
            this.identities.removeElement(identity);
            identity.clear();
        } else {
            this.remove(identity.getPublicKeyBlob());
        }
    }

    @Override
    public synchronized boolean remove(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        for (int i = 0; i < this.identities.size(); ++i) {
            Identity identity = (Identity)this.identities.elementAt(i);
            byte[] byArray2 = identity.getPublicKeyBlob();
            if (byArray2 == null || !Util.array_equals(byArray, byArray2)) continue;
            this.identities.removeElement(identity);
            identity.clear();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void removeAll() {
        for (int i = 0; i < this.identities.size(); ++i) {
            Identity identity = (Identity)this.identities.elementAt(i);
            identity.clear();
        }
        this.identities.removeAllElements();
    }

    private void removeDupulicates() {
        int n;
        Vector<byte[]> vector = new Vector<byte[]>();
        int n2 = this.identities.size();
        if (n2 == 0) {
            return;
        }
        block0: for (n = 0; n < n2; ++n) {
            Identity identity = (Identity)this.identities.elementAt(n);
            byte[] byArray = identity.getPublicKeyBlob();
            if (byArray == null) continue;
            for (int i = n + 1; i < n2; ++i) {
                Identity identity2 = (Identity)this.identities.elementAt(i);
                byte[] byArray2 = identity2.getPublicKeyBlob();
                if (byArray2 == null || !Util.array_equals(byArray, byArray2) || identity.isEncrypted() != identity2.isEncrypted()) continue;
                vector.addElement(byArray);
                continue block0;
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            this.remove((byte[])vector.elementAt(n));
        }
    }
}

