/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.management.ObjectName;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipProvider;
import org.apache.catalina.tribes.jmx.JmxRegistry;
import org.apache.catalina.tribes.membership.MembershipServiceBase;
import org.apache.catalina.tribes.membership.StaticMember;
import org.apache.catalina.tribes.membership.StaticMembershipProvider;
import org.apache.catalina.tribes.membership.StaticMembershipServiceMBean;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class StaticMembershipService
extends MembershipServiceBase
implements StaticMembershipServiceMBean {
    private static final Log log = LogFactory.getLog(StaticMembershipService.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.tribes.membership");
    protected final ArrayList<StaticMember> staticMembers = new ArrayList();
    private StaticMember localMember;
    private StaticMembershipProvider provider;
    private ObjectName oname = null;

    public StaticMembershipService() {
        this.setDefaults(this.properties);
    }

    @Override
    public void start(int n) throws Exception {
        if (this.provider != null) {
            this.provider.start(n);
            return;
        }
        this.localMember.setServiceStartTime(System.currentTimeMillis());
        this.localMember.setMemberAliveTime(100L);
        if (this.provider == null) {
            this.provider = this.buildMembershipProvider();
        }
        this.provider.start(n);
        JmxRegistry jmxRegistry = JmxRegistry.getRegistry(this.channel);
        if (jmxRegistry != null) {
            this.oname = jmxRegistry.registerJmx(",component=Membership", this);
        }
    }

    protected StaticMembershipProvider buildMembershipProvider() throws Exception {
        StaticMembershipProvider staticMembershipProvider = new StaticMembershipProvider();
        staticMembershipProvider.setChannel(this.channel);
        staticMembershipProvider.setMembershipListener(this);
        staticMembershipProvider.setMembershipService(this);
        staticMembershipProvider.setStaticMembers(this.staticMembers);
        this.properties.setProperty("membershipName", this.getMembershipName());
        staticMembershipProvider.init(this.properties);
        return staticMembershipProvider;
    }

    @Override
    public void stop(int n) {
        try {
            if (this.provider != null && this.provider.stop(n)) {
                if (this.oname != null) {
                    JmxRegistry.getRegistry(this.channel).unregisterJmx(this.oname);
                    this.oname = null;
                }
                this.provider = null;
                this.channel = null;
            }
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("staticMembershipService.stopFail", n), (Throwable)exception);
        }
    }

    @Override
    public Member getLocalMember(boolean bl) {
        if (bl && this.localMember != null) {
            this.localMember.setMemberAliveTime(System.currentTimeMillis() - this.localMember.getServiceStartTime());
        }
        return this.localMember;
    }

    @Override
    public void setLocalMemberProperties(String string, int n, int n2, int n3) {
        this.properties.setProperty("tcpListenHost", string);
        this.properties.setProperty("tcpListenPort", String.valueOf(n));
        try {
            this.findLocalMember();
            this.localMember.setHostname(string);
            this.localMember.setPort(n);
            this.localMember.setSecurePort(n2);
            this.localMember.setUdpPort(n3);
            this.localMember.getData(true, true);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    @Override
    public void setPayload(byte[] byArray) {
    }

    @Override
    public void setDomain(byte[] byArray) {
    }

    @Override
    public MembershipProvider getMembershipProvider() {
        return this.provider;
    }

    public ArrayList<StaticMember> getStaticMembers() {
        return this.staticMembers;
    }

    public void addStaticMember(StaticMember staticMember) {
        this.staticMembers.add(staticMember);
    }

    public void removeStaticMember(StaticMember staticMember) {
        this.staticMembers.remove(staticMember);
    }

    public void setLocalMember(StaticMember staticMember) {
        this.localMember = staticMember;
        this.localMember.setLocal(true);
    }

    @Override
    public long getExpirationTime() {
        String string = this.properties.getProperty("expirationTime");
        return Long.parseLong(string);
    }

    public void setExpirationTime(long l) {
        this.properties.setProperty("expirationTime", String.valueOf(l));
    }

    @Override
    public int getConnectTimeout() {
        String string = this.properties.getProperty("connectTimeout");
        return Integer.parseInt(string);
    }

    public void setConnectTimeout(int n) {
        this.properties.setProperty("connectTimeout", String.valueOf(n));
    }

    @Override
    public long getRpcTimeout() {
        String string = this.properties.getProperty("rpcTimeout");
        return Long.parseLong(string);
    }

    public void setRpcTimeout(long l) {
        this.properties.setProperty("rpcTimeout", String.valueOf(l));
    }

    @Override
    public boolean getUseThread() {
        String string = this.properties.getProperty("useThread");
        return Boolean.parseBoolean(string);
    }

    public void setUseThread(boolean bl) {
        this.properties.setProperty("useThread", String.valueOf(bl));
    }

    @Override
    public long getPingInterval() {
        String string = this.properties.getProperty("pingInterval");
        return Long.parseLong(string);
    }

    public void setPingInterval(long l) {
        this.properties.setProperty("pingInterval", String.valueOf(l));
    }

    @Override
    public void setProperties(Properties properties) {
        this.setDefaults(properties);
        this.properties = properties;
    }

    protected void setDefaults(Properties properties) {
        if (properties.getProperty("expirationTime") == null) {
            properties.setProperty("expirationTime", "5000");
        }
        if (properties.getProperty("connectTimeout") == null) {
            properties.setProperty("connectTimeout", "500");
        }
        if (properties.getProperty("rpcTimeout") == null) {
            properties.setProperty("rpcTimeout", "3000");
        }
        if (properties.getProperty("useThread") == null) {
            properties.setProperty("useThread", "false");
        }
        if (properties.getProperty("pingInterval") == null) {
            properties.setProperty("pingInterval", "1000");
        }
    }

    private String getMembershipName() {
        return this.channel.getName() + "-StaticMembership";
    }

    private void findLocalMember() throws IOException {
        if (this.localMember != null) {
            return;
        }
        String string = this.properties.getProperty("tcpListenHost");
        String string2 = this.properties.getProperty("tcpListenPort");
        for (StaticMember staticMember : this.staticMembers) {
            if (!Arrays.equals(InetAddress.getByName(string).getAddress(), staticMember.getHost()) || Integer.parseInt(string2) != staticMember.getPort()) continue;
            this.localMember = staticMember;
            break;
        }
        if (this.localMember == null) {
            throw new IllegalStateException(sm.getString("staticMembershipService.noLocalMember"));
        }
        this.staticMembers.remove(this.localMember);
    }
}

