/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import org.apache.tomcat.util.bcel.classfile.ConstantDouble;
import org.apache.tomcat.util.bcel.classfile.ConstantFloat;
import org.apache.tomcat.util.bcel.classfile.ConstantInteger;
import org.apache.tomcat.util.bcel.classfile.ConstantLong;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ElementValue;

public class SimpleElementValue
extends ElementValue {
    private final int index;

    SimpleElementValue(int n, int n2, ConstantPool constantPool) {
        super(n, constantPool);
        this.index = n2;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String stringifyValue() {
        ConstantPool constantPool = super.getConstantPool();
        int n = super.getType();
        switch (n) {
            case 73: {
                return Integer.toString(constantPool.getConstantInteger(this.getIndex()).getBytes());
            }
            case 74: {
                ConstantLong constantLong = (ConstantLong)constantPool.getConstant(this.getIndex(), (byte)5);
                return Long.toString(constantLong.getBytes());
            }
            case 68: {
                ConstantDouble constantDouble = (ConstantDouble)constantPool.getConstant(this.getIndex(), (byte)6);
                return Double.toString(constantDouble.getBytes());
            }
            case 70: {
                ConstantFloat constantFloat = (ConstantFloat)constantPool.getConstant(this.getIndex(), (byte)4);
                return Float.toString(constantFloat.getBytes());
            }
            case 83: {
                ConstantInteger constantInteger = constantPool.getConstantInteger(this.getIndex());
                return Integer.toString(constantInteger.getBytes());
            }
            case 66: {
                ConstantInteger constantInteger = constantPool.getConstantInteger(this.getIndex());
                return Integer.toString(constantInteger.getBytes());
            }
            case 67: {
                ConstantInteger constantInteger = constantPool.getConstantInteger(this.getIndex());
                return String.valueOf((char)constantInteger.getBytes());
            }
            case 90: {
                ConstantInteger constantInteger = constantPool.getConstantInteger(this.getIndex());
                if (constantInteger.getBytes() == 0) {
                    return "false";
                }
                return "true";
            }
            case 115: {
                return constantPool.getConstantUtf8(this.getIndex()).getBytes();
            }
        }
        throw new IllegalStateException("SimpleElementValue class does not know how to stringify type " + n);
    }
}

