/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.lang.reflect.Method;
import org.apache.catalina.Executor;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.Rule;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.Attributes;

public class ConnectorCreateRule
extends Rule {
    private static final Log log = LogFactory.getLog(ConnectorCreateRule.class);
    protected static final StringManager sm = StringManager.getManager(ConnectorCreateRule.class);

    public void begin(String string, String string2, Attributes attributes) throws Exception {
        String string3;
        Service service = (Service)this.digester.peek();
        Executor executor = null;
        String string4 = attributes.getValue("executor");
        if (string4 != null) {
            executor = service.getExecutor(string4);
        }
        String string5 = attributes.getValue("protocol");
        Connector connector = new Connector(string5);
        if (executor != null) {
            ConnectorCreateRule.setExecutor(connector, executor);
        }
        if ((string3 = attributes.getValue("sslImplementationName")) != null) {
            ConnectorCreateRule.setSSLImplementationName(connector, string3);
        }
        this.digester.push((Object)connector);
        StringBuilder stringBuilder = this.digester.getGeneratedCode();
        if (stringBuilder != null) {
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append(Connector.class.getName()).append(' ').append(this.digester.toVariableName((Object)connector));
            stringBuilder.append(" = new ").append(Connector.class.getName());
            stringBuilder.append("(new ").append(connector.getProtocolHandlerClassName()).append("());");
            stringBuilder.append(System.lineSeparator());
            if (executor != null) {
                stringBuilder.append(this.digester.toVariableName((Object)connector)).append(".getProtocolHandler().setExecutor(");
                stringBuilder.append(this.digester.toVariableName((Object)service)).append(".getExecutor(\"").append(string4);
                stringBuilder.append("\"));");
                stringBuilder.append(System.lineSeparator());
            }
            if (string3 != null) {
                stringBuilder.append("((").append(AbstractHttp11JsseProtocol.class.getName()).append("<?>) ");
                stringBuilder.append(this.digester.toVariableName((Object)connector)).append(".getProtocolHandler()).setSslImplementationName(\"");
                stringBuilder.append(string3).append("\");");
                stringBuilder.append(System.lineSeparator());
            }
        }
    }

    private static void setExecutor(Connector connector, Executor executor) throws Exception {
        Method method = IntrospectionUtils.findMethod(connector.getProtocolHandler().getClass(), (String)"setExecutor", (Class[])new Class[]{java.util.concurrent.Executor.class});
        if (method != null) {
            method.invoke((Object)connector.getProtocolHandler(), executor);
        } else {
            log.warn((Object)sm.getString("connector.noSetExecutor", new Object[]{connector}));
        }
    }

    private static void setSSLImplementationName(Connector connector, String string) throws Exception {
        Method method = IntrospectionUtils.findMethod(connector.getProtocolHandler().getClass(), (String)"setSslImplementationName", (Class[])new Class[]{String.class});
        if (method != null) {
            method.invoke((Object)connector.getProtocolHandler(), string);
        } else {
            log.warn((Object)sm.getString("connector.noSetSSLImplementationName", new Object[]{connector}));
        }
    }

    public void end(String string, String string2) throws Exception {
        this.digester.pop();
    }
}

