/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.coyote.ActionCode;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.json.JSONFilter;
import org.apache.tomcat.util.res.StringManager;

public class JsonErrorReportValve
extends ErrorReportValve {
    @Override
    protected void report(Request request, Response response, Throwable throwable) {
        String string;
        int n = response.getStatus();
        if (n < 400 || response.getContentWritten() > 0L || !response.setErrorReported()) {
            return;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        response.getCoyoteResponse().action(ActionCode.IS_IO_ALLOWED, (Object)atomicBoolean);
        if (!atomicBoolean.get()) {
            return;
        }
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.valves", request.getLocales());
        response.setLocale(stringManager.getLocale());
        String string2 = throwable != null ? stringManager.getString("errorReportValve.exceptionReport") : stringManager.getString("errorReportValve.statusReport");
        String string3 = response.getMessage();
        if (string3 == null && throwable != null) {
            string3 = throwable.getMessage();
        }
        if (string3 == null) {
            string3 = "";
        }
        if ((string = stringManager.getString("http." + n + ".desc")) == null) {
            if (string3.isEmpty()) {
                return;
            }
            string = stringManager.getString("errorReportValve.noDescription");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n  \"type\": \"").append(JSONFilter.escape((String)string2)).append("\",\n");
        stringBuilder.append("  \"status\": ").append(n).append(",\n");
        stringBuilder.append("  \"message\": \"").append(JSONFilter.escape((String)string3)).append("\",\n");
        stringBuilder.append("  \"description\": \"").append(JSONFilter.escape((String)string));
        if (throwable != null) {
            stringBuilder.append("\",\n");
            stringBuilder.append("  \"throwable\": [");
            boolean bl = true;
            do {
                int n2;
                if (!bl) {
                    stringBuilder.append(',');
                } else {
                    bl = false;
                }
                stringBuilder.append('\"').append(JSONFilter.escape((String)throwable.toString())).append('\"');
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                int n3 = stackTraceElementArray.length;
                for (n2 = stackTraceElementArray.length - 1; n2 >= 0; --n2) {
                    if (!stackTraceElementArray[n2].getClassName().startsWith("org.apache.catalina.core.ApplicationFilterChain") || !stackTraceElementArray[n2].getMethodName().equals("internalDoFilter")) continue;
                    n3 = n2;
                    break;
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    if (stackTraceElementArray[n2].getClassName().startsWith("org.apache.catalina.core.")) continue;
                    stringBuilder.append(',').append('\"').append(' ').append(JSONFilter.escape((String)stackTraceElementArray[n2].toString())).append('\"');
                }
            } while ((throwable = throwable.getCause()) != null);
            stringBuilder.append("]\n}");
        } else {
            stringBuilder.append("\"\n}");
        }
        try {
            block18: {
                try {
                    response.setContentType("application/json");
                    response.setCharacterEncoding("utf-8");
                }
                catch (Throwable throwable2) {
                    ExceptionUtils.handleThrowable((Throwable)throwable2);
                    if (!this.container.getLogger().isDebugEnabled()) break block18;
                    this.container.getLogger().debug((Object)sm.getString("errorReportValve.contentTypeFail"), throwable2);
                }
            }
            PrintWriter printWriter = response.getReporter();
            if (printWriter != null) {
                ((Writer)printWriter).write(stringBuilder.toString());
                response.finishResponse();
            }
        }
        catch (IOException | IllegalStateException exception) {
            // empty catch block
        }
    }
}

