/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.StoreManager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class PersistentValve
extends ValveBase {
    private static final ClassLoader MY_CLASSLOADER = PersistentValve.class.getClassLoader();
    private volatile boolean clBindRequired;
    protected Pattern filter = null;
    private final ConcurrentMap<String, UsageCountingSemaphore> sessionToSemaphoreMap = new ConcurrentHashMap<String, UsageCountingSemaphore>();
    private boolean semaphoreFairness = true;
    private boolean semaphoreBlockOnAcquire = true;
    private boolean semaphoreAcquireUninterruptibly = true;

    public PersistentValve() {
        super(true);
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        this.clBindRequired = container instanceof Engine || container instanceof Host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        block43: {
            Context context;
            if (this.isRequestWithoutSession(request.getDecodedRequestURI())) {
                if (this.containerLog.isTraceEnabled()) {
                    this.containerLog.trace((Object)sm.getString("persistentValve.requestIgnore", new Object[]{request.getDecodedRequestURI()}));
                }
                this.getNext().invoke(request, response);
                return;
            }
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("persistentValve.requestProcess", new Object[]{request.getDecodedRequestURI()}));
            }
            if ((context = request.getContext()) == null) {
                response.sendError(500, sm.getString("standardHost.noContext"));
                return;
            }
            String string2 = request.getRequestedSessionId();
            UsageCountingSemaphore usageCountingSemaphore2 = null;
            boolean bl = true;
            try {
                Object object;
                Object object2;
                if (string2 != null) {
                    usageCountingSemaphore2 = this.sessionToSemaphoreMap.compute(string2, (string, usageCountingSemaphore) -> usageCountingSemaphore == null ? new UsageCountingSemaphore(this.semaphoreFairness) : usageCountingSemaphore.incrementUsageCount());
                    if (this.semaphoreBlockOnAcquire) {
                        if (this.semaphoreAcquireUninterruptibly) {
                            usageCountingSemaphore2.acquireUninterruptibly();
                        } else {
                            try {
                                usageCountingSemaphore2.acquire();
                            }
                            catch (InterruptedException interruptedException) {
                                bl = false;
                                this.onSemaphoreNotAcquired(request, response);
                                if (this.containerLog.isDebugEnabled()) {
                                    this.containerLog.debug((Object)sm.getString("persistentValve.acquireInterrupted", new Object[]{request.getDecodedRequestURI()}));
                                }
                                if (usageCountingSemaphore2 != null) {
                                    if (bl) {
                                        usageCountingSemaphore2.release();
                                    }
                                    this.sessionToSemaphoreMap.computeIfPresent(string2, (string, usageCountingSemaphore) -> usageCountingSemaphore.decrementAndGetUsageCount() == 0L ? null : usageCountingSemaphore);
                                }
                                return;
                            }
                        }
                    } else if (!usageCountingSemaphore2.tryAcquire()) {
                        this.onSemaphoreNotAcquired(request, response);
                        if (this.containerLog.isDebugEnabled()) {
                            this.containerLog.debug((Object)sm.getString("persistentValve.acquireFailed", new Object[]{request.getDecodedRequestURI()}));
                        }
                        return;
                    }
                }
                Manager manager = context.getManager();
                if (string2 != null && manager instanceof StoreManager && (object2 = ((StoreManager)((Object)manager)).getStore()) != null) {
                    object = null;
                    try {
                        object = object2.load(string2);
                    }
                    catch (Exception exception) {
                        this.containerLog.error((Object)sm.getString("persistentValve.sessionLoadFail", new Object[]{string2}));
                    }
                    if (object != null) {
                        if (!object.isValid() || this.isSessionStale((Session)object, System.currentTimeMillis())) {
                            if (this.containerLog.isTraceEnabled()) {
                                this.containerLog.trace((Object)"session swapped in is invalid or expired");
                            }
                            object.expire();
                            object2.remove(string2);
                        } else {
                            object.setManager(manager);
                            manager.add((Session)object);
                            object.access();
                            object.endAccess();
                        }
                    }
                }
                if (this.containerLog.isTraceEnabled()) {
                    this.containerLog.trace((Object)("sessionId: " + string2));
                }
                this.getNext().invoke(request, response);
                if (request.isAsync()) break block43;
                try {
                    object2 = request.getSessionInternal(false);
                }
                catch (Exception exception) {
                    object2 = null;
                }
                object = null;
                if (object2 != null) {
                    object = object2.getIdInternal();
                }
                if (this.containerLog.isTraceEnabled()) {
                    this.containerLog.trace((Object)("newsessionId: " + (String)object));
                }
                if (object == null) break block43;
                try {
                    this.bind(context);
                    if (manager instanceof StoreManager) {
                        Session session = manager.findSession((String)object);
                        Store store = ((StoreManager)((Object)manager)).getStore();
                        boolean bl2 = false;
                        if (session != null && store != null && session.isValid() && !this.isSessionStale(session, System.currentTimeMillis())) {
                            store.save(session);
                            ((StoreManager)((Object)manager)).removeSuper(session);
                            session.recycle();
                            bl2 = true;
                        }
                        if (!bl2 && this.containerLog.isTraceEnabled()) {
                            this.containerLog.trace((Object)("newsessionId store: " + String.valueOf(store) + " session: " + String.valueOf(session) + " valid: " + (session == null ? "N/A" : Boolean.toString(session.isValid())) + " stale: " + this.isSessionStale(session, System.currentTimeMillis())));
                        }
                    } else if (this.containerLog.isTraceEnabled()) {
                        this.containerLog.trace((Object)("newsessionId Manager: " + String.valueOf(manager)));
                    }
                }
                finally {
                    this.unbind(context);
                }
            }
            finally {
                if (usageCountingSemaphore2 != null) {
                    if (bl) {
                        usageCountingSemaphore2.release();
                    }
                    this.sessionToSemaphoreMap.computeIfPresent(string2, (string, usageCountingSemaphore) -> usageCountingSemaphore.decrementAndGetUsageCount() == 0L ? null : usageCountingSemaphore);
                }
            }
        }
    }

    protected void onSemaphoreNotAcquired(Request request, Response response) throws IOException {
        response.sendError(429);
    }

    protected boolean isSessionStale(Session session, long l) {
        int n;
        if (session != null && (n = session.getMaxInactiveInterval()) > 0) {
            int n2 = (int)(session.getIdleTimeInternal() / 1000L);
            return n2 >= n;
        }
        return false;
    }

    private void bind(Context context) {
        if (this.clBindRequired) {
            context.bind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
        }
    }

    private void unbind(Context context) {
        if (this.clBindRequired) {
            context.unbind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
        }
    }

    protected boolean isRequestWithoutSession(String string) {
        Pattern pattern = this.filter;
        return pattern != null && pattern.matcher(string).matches();
    }

    public String getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.toString();
    }

    public void setFilter(String string) {
        if (string == null || string.isEmpty()) {
            this.filter = null;
        } else {
            try {
                this.filter = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.container.getLogger().error((Object)sm.getString("persistentValve.filter.failure", new Object[]{string}), (Throwable)patternSyntaxException);
            }
        }
    }

    public boolean isSemaphoreFairness() {
        return this.semaphoreFairness;
    }

    public void setSemaphoreFairness(boolean bl) {
        this.semaphoreFairness = bl;
    }

    public boolean isSemaphoreBlockOnAcquire() {
        return this.semaphoreBlockOnAcquire;
    }

    public void setSemaphoreBlockOnAcquire(boolean bl) {
        this.semaphoreBlockOnAcquire = bl;
    }

    public boolean isSemaphoreAcquireUninterruptibly() {
        return this.semaphoreAcquireUninterruptibly;
    }

    public void setSemaphoreAcquireUninterruptibly(boolean bl) {
        this.semaphoreAcquireUninterruptibly = bl;
    }

    private static class UsageCountingSemaphore {
        private final AtomicLong usageCount = new AtomicLong(1L);
        private final Semaphore semaphore;

        private UsageCountingSemaphore(boolean bl) {
            this.semaphore = new Semaphore(1, bl);
        }

        private UsageCountingSemaphore incrementUsageCount() {
            this.usageCount.incrementAndGet();
            return this;
        }

        private long decrementAndGetUsageCount() {
            return this.usageCount.decrementAndGet();
        }

        private void acquire() throws InterruptedException {
            this.semaphore.acquire();
        }

        private void acquireUninterruptibly() {
            this.semaphore.acquireUninterruptibly();
        }

        private boolean tryAcquire() {
            return this.semaphore.tryAcquire();
        }

        private void release() {
            this.semaphore.release();
        }
    }
}

