/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.tribes.util.StringManager;

public class ExecutorFactory {
    protected static final StringManager sm = StringManager.getManager(ExecutorFactory.class);

    public static ExecutorService newThreadPool(int n, int n2, long l, TimeUnit timeUnit) {
        TaskQueue taskQueue = new TaskQueue();
        TribesThreadPoolExecutor tribesThreadPoolExecutor = new TribesThreadPoolExecutor(n, n2, l, timeUnit, taskQueue);
        taskQueue.setParent(tribesThreadPoolExecutor);
        return tribesThreadPoolExecutor;
    }

    public static ExecutorService newThreadPool(int n, int n2, long l, TimeUnit timeUnit, ThreadFactory threadFactory) {
        TaskQueue taskQueue = new TaskQueue();
        TribesThreadPoolExecutor tribesThreadPoolExecutor = new TribesThreadPoolExecutor(n, n2, l, timeUnit, (BlockingQueue<Runnable>)taskQueue, threadFactory);
        taskQueue.setParent(tribesThreadPoolExecutor);
        return tribesThreadPoolExecutor;
    }

    private static class TaskQueue
    extends LinkedBlockingQueue<Runnable> {
        private static final long serialVersionUID = 1L;
        transient ThreadPoolExecutor parent = null;

        TaskQueue() {
        }

        public void setParent(ThreadPoolExecutor threadPoolExecutor) {
            this.parent = threadPoolExecutor;
        }

        public boolean force(Runnable runnable) {
            if (this.parent != null && this.parent.isShutdown()) {
                throw new RejectedExecutionException(sm.getString("executorFactory.not.running"));
            }
            return super.offer(runnable);
        }

        @Override
        public boolean offer(Runnable runnable) {
            if (this.parent == null) {
                return super.offer(runnable);
            }
            if (this.parent.getPoolSize() == this.parent.getMaximumPoolSize()) {
                return super.offer(runnable);
            }
            if (this.parent.getActiveCount() < this.parent.getPoolSize()) {
                return super.offer(runnable);
            }
            if (this.parent.getPoolSize() < this.parent.getMaximumPoolSize()) {
                return false;
            }
            return super.offer(runnable);
        }
    }

    private static class TribesThreadPoolExecutor
    extends ThreadPoolExecutor {
        TribesThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
            super(n, n2, l, timeUnit, blockingQueue, rejectedExecutionHandler);
            this.prestartAllCoreThreads();
        }

        TribesThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
            super(n, n2, l, timeUnit, blockingQueue, threadFactory, rejectedExecutionHandler);
            this.prestartAllCoreThreads();
        }

        TribesThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
            super(n, n2, l, timeUnit, blockingQueue, threadFactory);
            this.prestartAllCoreThreads();
        }

        TribesThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
            super(n, n2, l, timeUnit, blockingQueue);
            this.prestartAllCoreThreads();
        }

        @Override
        public void execute(Runnable runnable) {
            block2: {
                try {
                    super.execute(runnable);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    TaskQueue taskQueue;
                    if (!(super.getQueue() instanceof TaskQueue) || (taskQueue = (TaskQueue)super.getQueue()).force(runnable)) break block2;
                    throw new RejectedExecutionException(sm.getString("executorFactory.queue.full"));
                }
            }
        }
    }
}

