/* Generated by wayland-scanner 1.23.1 */

#ifndef COLOR_MANAGEMENT_V1_ENUM_PROTOCOL_H
#define COLOR_MANAGEMENT_V1_ENUM_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef WP_COLOR_MANAGER_V1_ERROR_ENUM
#define WP_COLOR_MANAGER_V1_ERROR_ENUM
enum wp_color_manager_v1_error {
	/**
	 * request not supported
	 */
	WP_COLOR_MANAGER_V1_ERROR_UNSUPPORTED_FEATURE = 0,
	/**
	 * color management surface exists already
	 */
	WP_COLOR_MANAGER_V1_ERROR_SURFACE_EXISTS = 1,
};
#endif /* WP_COLOR_MANAGER_V1_ERROR_ENUM */

#ifndef WP_COLOR_MANAGER_V1_RENDER_INTENT_ENUM
#define WP_COLOR_MANAGER_V1_RENDER_INTENT_ENUM
/**
 * @ingroup iface_wp_color_manager_v1
 * rendering intents
 *
 * See the ICC.1:2022 specification from the International Color Consortium
 * for more details about rendering intents.
 *
 * The principles of ICC defined rendering intents apply with all types of
 * image descriptions, not only those with ICC file profiles.
 *
 * Compositors must support the perceptual rendering intent. Other
 * rendering intents are optional.
 */
enum wp_color_manager_v1_render_intent {
	/**
	 * perceptual
	 */
	WP_COLOR_MANAGER_V1_RENDER_INTENT_PERCEPTUAL = 0,
	/**
	 * media-relative colorimetric
	 */
	WP_COLOR_MANAGER_V1_RENDER_INTENT_RELATIVE = 1,
	/**
	 * saturation
	 */
	WP_COLOR_MANAGER_V1_RENDER_INTENT_SATURATION = 2,
	/**
	 * ICC-absolute colorimetric
	 */
	WP_COLOR_MANAGER_V1_RENDER_INTENT_ABSOLUTE = 3,
	/**
	 * media-relative colorimetric + black point compensation
	 */
	WP_COLOR_MANAGER_V1_RENDER_INTENT_RELATIVE_BPC = 4,
};
#endif /* WP_COLOR_MANAGER_V1_RENDER_INTENT_ENUM */

#ifndef WP_COLOR_MANAGER_V1_FEATURE_ENUM
#define WP_COLOR_MANAGER_V1_FEATURE_ENUM
/**
 * @ingroup iface_wp_color_manager_v1
 * compositor supported features
 */
enum wp_color_manager_v1_feature {
	/**
	 * create_icc_creator request
	 */
	WP_COLOR_MANAGER_V1_FEATURE_ICC_V2_V4 = 0,
	/**
	 * create_parametric_creator request
	 */
	WP_COLOR_MANAGER_V1_FEATURE_PARAMETRIC = 1,
	/**
	 * parametric set_primaries request
	 */
	WP_COLOR_MANAGER_V1_FEATURE_SET_PRIMARIES = 2,
	/**
	 * parametric set_tf_power request
	 */
	WP_COLOR_MANAGER_V1_FEATURE_SET_TF_POWER = 3,
	/**
	 * parametric set_luminances request
	 */
	WP_COLOR_MANAGER_V1_FEATURE_SET_LUMINANCES = 4,
	/**
	 * parametric set_mastering_display_primaries request
	 *
	 * The compositor supports set_mastering_display_primaries
	 * request with a target color volume fully contained inside the
	 * primary color volume.
	 */
	WP_COLOR_MANAGER_V1_FEATURE_SET_MASTERING_DISPLAY_PRIMARIES = 5,
	/**
	 * parametric target exceeds primary color volume
	 *
	 * The compositor additionally supports target color volumes that
	 * extend outside of the primary color volume.
	 *
	 * This can only be advertised if feature
	 * set_mastering_display_primaries is supported as well.
	 */
	WP_COLOR_MANAGER_V1_FEATURE_EXTENDED_TARGET_VOLUME = 6,
	/**
	 * create_windows_scrgb request
	 */
	WP_COLOR_MANAGER_V1_FEATURE_WINDOWS_SCRGB = 7,
};
#endif /* WP_COLOR_MANAGER_V1_FEATURE_ENUM */

#ifndef WP_COLOR_MANAGER_V1_PRIMARIES_ENUM
#define WP_COLOR_MANAGER_V1_PRIMARIES_ENUM
/**
 * @ingroup iface_wp_color_manager_v1
 * named color primaries
 *
 * Named color primaries used to encode well-known sets of primaries. H.273
 * is the authority, when it comes to the exact values of primaries and
 * authoritative specifications, where an equivalent code point exists.
 *
 * A value of 0 is invalid and will never be present in the list of enums.
 *
 * Descriptions do list the specifications for convenience.
 */
enum wp_color_manager_v1_primaries {
	/**
	 * Color primaries for the sRGB color space as defined by the BT.709 standard
	 *
	 * Color primaries as defined by - Rec. ITU-R BT.709-6 - Rec.
	 * ITU-R BT.1361-0 conventional colour gamut system and extended
	 * colour gamut system (historical) - IEC 61966-2-1 sRGB or sYCC -
	 * IEC 61966-2-4 - Society of Motion Picture and Television
	 * Engineers (SMPTE) RP 177 (1993) Annex B Equivalent to H.273
	 * ColourPrimaries code point 1.
	 */
	WP_COLOR_MANAGER_V1_PRIMARIES_SRGB = 1,
	/**
	 * Color primaries for PAL-M as defined by the BT.470 standard
	 *
	 * Color primaries as defined by - Rec. ITU-R BT.470-6 System M
	 * (historical) - United States National Television System
	 * Committee 1953 Recommendation for transmission standards for
	 * color television - United States Federal Communications
	 * Commission (2003) Title 47 Code of Federal Regulations 73.682
	 * (a)(20) Equivalent to H.273 ColourPrimaries code point 4.
	 */
	WP_COLOR_MANAGER_V1_PRIMARIES_PAL_M = 2,
	/**
	 * Color primaries for PAL as defined by the BT.601 standard
	 *
	 * Color primaries as defined by - Rec. ITU-R BT.470-6 System B,
	 * G (historical) - Rec. ITU-R BT.601-7 625 - Rec. ITU-R BT.1358-0
	 * 625 (historical) - Rec. ITU-R BT.1700-0 625 PAL and 625 SECAM
	 * Equivalent to H.273 ColourPrimaries code point 5.
	 */
	WP_COLOR_MANAGER_V1_PRIMARIES_PAL = 3,
	/**
	 * Color primaries for NTSC as defined by the BT.601 standard
	 *
	 * Color primaries as defined by - Rec. ITU-R BT.601-7 525 - Rec.
	 * ITU-R BT.1358-1 525 or 625 (historical) - Rec. ITU-R BT.1700-0
	 * NTSC - SMPTE 170M (2004) - SMPTE 240M (1999) (historical)
	 * Equivalent to H.273 ColourPrimaries code point 6 and 7.
	 */
	WP_COLOR_MANAGER_V1_PRIMARIES_NTSC = 4,
	/**
	 * Generic film with colour filters using Illuminant C
	 *
	 * Color primaries as defined by H.273 for generic film.
	 * Equivalent to H.273 ColourPrimaries code point 8.
	 */
	WP_COLOR_MANAGER_V1_PRIMARIES_GENERIC_FILM = 5,
	/**
	 * Color primaries as defined by the BT.2020 and BT.2100 standard
	 *
	 * Color primaries as defined by - Rec. ITU-R BT.2020-2 - Rec.
	 * ITU-R BT.2100-0 Equivalent to H.273 ColourPrimaries code point
	 * 9.
	 */
	WP_COLOR_MANAGER_V1_PRIMARIES_BT2020 = 6,
	/**
	 * Color primaries of the full CIE 1931 XYZ color space
	 *
	 * Color primaries as defined as the maximum of the CIE 1931 XYZ
	 * color space by - SMPTE ST 428-1 - (CIE 1931 XYZ as in ISO
	 * 11664-1) Equivalent to H.273 ColourPrimaries code point 10.
	 */
	WP_COLOR_MANAGER_V1_PRIMARIES_CIE1931_XYZ = 7,
	/**
	 * Color primaries of the DCI P3 color space as defined by the SMPTE RP 431 standard
	 *
	 * Color primaries as defined by Digital Cinema System and
	 * published in SMPTE RP 431-2 (2011). Equivalent to H.273
	 * ColourPrimaries code point 11.
	 */
	WP_COLOR_MANAGER_V1_PRIMARIES_DCI_P3 = 8,
	/**
	 * Color primaries of Display P3 variant of the DCI-P3 color space as defined by the SMPTE EG 432 standard
	 *
	 * Color primaries as defined by Digital Cinema System and
	 * published in SMPTE EG 432-1 (2010). Equivalent to H.273
	 * ColourPrimaries code point 12.
	 */
	WP_COLOR_MANAGER_V1_PRIMARIES_DISPLAY_P3 = 9,
	/**
	 * Color primaries of the Adobe RGB color space as defined by the ISO 12640 standard
	 *
	 * Color primaries as defined by Adobe as "Adobe RGB" and later
	 * published by ISO 12640-4 (2011).
	 */
	WP_COLOR_MANAGER_V1_PRIMARIES_ADOBE_RGB = 10,
};
#endif /* WP_COLOR_MANAGER_V1_PRIMARIES_ENUM */

#ifndef WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_ENUM
#define WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_ENUM
/**
 * @ingroup iface_wp_color_manager_v1
 * named transfer functions
 *
 * Named transfer functions used to represent well-known transfer
 * characteristics. H.273 is the authority, when it comes to the exact
 * formulas and authoritative specifications, where an equivalent code
 * point exists.
 *
 * A value of 0 is invalid and will never be present in the list of enums.
 *
 * Descriptions do list the specifications for convenience.
 */
enum wp_color_manager_v1_transfer_function {
	/**
	 * BT.1886 display transfer characteristic
	 *
	 * Rec. ITU-R BT.1886 is the display transfer characteristic
	 * assumed by - Rec. ITU-R BT.601-7 525 and 625 - Rec. ITU-R
	 * BT.709-6 - Rec. ITU-R BT.2020-2 These recommendations are
	 * referred to by H.273 TransferCharacteristics code points 1, 6,
	 * 14, and 15, which are all equivalent.
	 *
	 * This TF implies these default luminances from Rec. ITU-R
	 * BT.2035: - primary color volume minimum: 0.01 cd/m² - primary
	 * color volume maximum: 100 cd/m² - reference white: 100 cd/m²
	 */
	WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_BT1886 = 1,
	/**
	 * Assumed display gamma 2.2 transfer function
	 *
	 * Transfer characteristics as defined by - Rec. ITU-R BT.470-6
	 * System M (historical) - United States National Television System
	 * Committee 1953 Recommendation for transmission standards for
	 * color television - United States Federal Communications
	 * Commission (2003) Title 47 Code of Federal Regulations 73.682
	 * (a) (20) - Rec. ITU-R BT.1700-0 625 PAL and 625 SECAM Equivalent
	 * to H.273 TransferCharacteristics code point 4.
	 *
	 * Note: an sRGB display (IEC 61966-2-1) uses this transfer
	 * function.
	 */
	WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_GAMMA22 = 2,
	/**
	 * Assumed display gamma 2.8 transfer function
	 *
	 * Transfer characteristics as defined by - Rec. ITU-R BT.470-6
	 * System B, G (historical) Equivalent to H.273
	 * TransferCharacteristics code point 5.
	 */
	WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_GAMMA28 = 3,
	/**
	 * SMPTE ST 240 transfer function
	 *
	 * Transfer characteristics as defined by - SMPTE ST 240 (1999)
	 * Equivalent to H.273 TransferCharacteristics code point 7.
	 */
	WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_ST240 = 4,
	/**
	 * extended linear transfer function
	 *
	 * Linear transfer function defined over all real numbers.
	 * Normalised electrical values are equal the normalised optical
	 * values.
	 *
	 * The differences to H.273 TransferCharacteristics code point 8
	 * are the definition over all real numbers.
	 */
	WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_EXT_LINEAR = 5,
	/**
	 * logarithmic 100:1 transfer function
	 *
	 * Logarithmic transfer characteristic (100:1 range). Equivalent
	 * to H.273 TransferCharacteristics code point 9.
	 */
	WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_LOG_100 = 6,
	/**
	 * logarithmic (100*Sqrt(10) : 1) transfer function
	 *
	 * Logarithmic transfer characteristic (100 * Sqrt(10) : 1
	 * range). Equivalent to H.273 TransferCharacteristics code point
	 * 10.
	 */
	WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_LOG_316 = 7,
	/**
	 * IEC 61966-2-4 transfer function
	 *
	 * Transfer characteristics as defined by - IEC 61966-2-4
	 * Equivalent to H.273 TransferCharacteristics code point 11.
	 */
	WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_XVYCC = 8,
	/**
	 * sRGB piece-wise transfer function
	 *
	 * Transfer characteristics as defined by - IEC 61966-2-1 sRGB
	 * Equivalent to H.273 TransferCharacteristics code point 13 with
	 * MatrixCoefficients set to 0.
	 *
	 * Note: This is not appropriate for describing sRGB material. sRGB
	 * material is intended to be viewed on an sRGB display, and that
	 * is described by gamma22.
	 */
	WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_SRGB = 9,
	/**
	 * Extended sRGB piece-wise transfer function
	 *
	 * Transfer characteristics as defined by - IEC 61966-2-1 sYCC
	 * Equivalent to H.273 TransferCharacteristics code point 13 with
	 * MatrixCoefficients set to anything but 0.
	 */
	WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_EXT_SRGB = 10,
	/**
	 * perceptual quantizer transfer function
	 *
	 * Transfer characteristics as defined by - SMPTE ST 2084 (2014)
	 * for 10-, 12-, 14- and 16-bit systems - Rec. ITU-R BT.2100-2
	 * perceptual quantization (PQ) system Equivalent to H.273
	 * TransferCharacteristics code point 16.
	 *
	 * This TF implies these default luminances - primary color volume
	 * minimum: 0.005 cd/m² - primary color volume maximum: 10000
	 * cd/m² - reference white: 203 cd/m²
	 *
	 * The difference between the primary color volume minimum and
	 * maximum must be approximately 10000 cd/m² as that is the swing
	 * of the EOTF defined by ST 2084 and BT.2100. The default value
	 * for the reference white is a protocol addition: it is suggested
	 * by Report ITU-R BT.2408-7 and is not part of ST 2084 or BT.2100.
	 */
	WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_ST2084_PQ = 11,
	/**
	 * SMPTE ST 428 transfer function
	 *
	 * Transfer characteristics as defined by - SMPTE ST 428-1 (2019)
	 * Equivalent to H.273 TransferCharacteristics code point 17.
	 */
	WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_ST428 = 12,
	/**
	 * hybrid log-gamma transfer function
	 *
	 * Transfer characteristics as defined by - ARIB STD-B67 (2015) -
	 * Rec. ITU-R BT.2100-2 hybrid log-gamma (HLG) system Equivalent to
	 * H.273 TransferCharacteristics code point 18.
	 *
	 * This TF implies these default luminances - primary color volume
	 * minimum: 0.005 cd/m² - primary color volume maximum: 1000
	 * cd/m² - reference white: 203 cd/m²
	 *
	 * HLG is a relative display-referred signal with a specified
	 * non-linear mapping to the display peak luminance (the HLG OOTF).
	 * All absolute luminance values used here for HLG assume a 1000
	 * cd/m² peak display.
	 *
	 * The default value for the reference white is a protocol
	 * addition: it is suggested by Report ITU-R BT.2408-7 and is not
	 * part of ARIB STD-B67 or BT.2100.
	 */
	WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_HLG = 13,
};
#endif /* WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_ENUM */

#ifndef WP_COLOR_MANAGEMENT_SURFACE_V1_ERROR_ENUM
#define WP_COLOR_MANAGEMENT_SURFACE_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_color_management_surface_v1
 * protocol errors
 */
enum wp_color_management_surface_v1_error {
	/**
	 * unsupported rendering intent
	 */
	WP_COLOR_MANAGEMENT_SURFACE_V1_ERROR_RENDER_INTENT = 0,
	/**
	 * invalid image description
	 */
	WP_COLOR_MANAGEMENT_SURFACE_V1_ERROR_IMAGE_DESCRIPTION = 1,
	/**
	 * forbidden request on inert object
	 */
	WP_COLOR_MANAGEMENT_SURFACE_V1_ERROR_INERT = 2,
};
#endif /* WP_COLOR_MANAGEMENT_SURFACE_V1_ERROR_ENUM */

#ifndef WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_ERROR_ENUM
#define WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_color_management_surface_feedback_v1
 * protocol errors
 */
enum wp_color_management_surface_feedback_v1_error {
	/**
	 * forbidden request on inert object
	 */
	WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_ERROR_INERT = 0,
	/**
	 * attempted to use an unsupported feature
	 */
	WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_ERROR_UNSUPPORTED_FEATURE = 1,
};
#endif /* WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_ERROR_ENUM */

#ifndef WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_ENUM
#define WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_image_description_creator_icc_v1
 * protocol errors
 */
enum wp_image_description_creator_icc_v1_error {
	/**
	 * incomplete parameter set
	 */
	WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_INCOMPLETE_SET = 0,
	/**
	 * property already set
	 */
	WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_ALREADY_SET = 1,
	/**
	 * fd not seekable and readable
	 */
	WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_BAD_FD = 2,
	/**
	 * no or too much data
	 */
	WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_BAD_SIZE = 3,
	/**
	 * offset + length exceeds file size
	 */
	WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_OUT_OF_FILE = 4,
};
#endif /* WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_ENUM */

#ifndef WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_ENUM
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_image_description_creator_params_v1
 * protocol errors
 */
enum wp_image_description_creator_params_v1_error {
	/**
	 * incomplete parameter set
	 */
	WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_INCOMPLETE_SET = 0,
	/**
	 * property already set
	 */
	WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_ALREADY_SET = 1,
	/**
	 * request not supported
	 */
	WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_UNSUPPORTED_FEATURE = 2,
	/**
	 * invalid transfer characteristic
	 */
	WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_INVALID_TF = 3,
	/**
	 * invalid primaries named
	 */
	WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_INVALID_PRIMARIES_NAMED = 4,
	/**
	 * invalid luminance value or range
	 */
	WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_INVALID_LUMINANCE = 5,
};
#endif /* WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_ENUM */

#ifndef WP_IMAGE_DESCRIPTION_V1_ERROR_ENUM
#define WP_IMAGE_DESCRIPTION_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_image_description_v1
 * protocol errors
 */
enum wp_image_description_v1_error {
	/**
	 * attempted to use an object which is not ready
	 */
	WP_IMAGE_DESCRIPTION_V1_ERROR_NOT_READY = 0,
	/**
	 * get_information not allowed
	 */
	WP_IMAGE_DESCRIPTION_V1_ERROR_NO_INFORMATION = 1,
};
#endif /* WP_IMAGE_DESCRIPTION_V1_ERROR_ENUM */

#ifndef WP_IMAGE_DESCRIPTION_V1_CAUSE_ENUM
#define WP_IMAGE_DESCRIPTION_V1_CAUSE_ENUM
/**
 * @ingroup iface_wp_image_description_v1
 * generic reason for failure
 */
enum wp_image_description_v1_cause {
	/**
	 * interface version too low
	 */
	WP_IMAGE_DESCRIPTION_V1_CAUSE_LOW_VERSION = 0,
	/**
	 * unsupported image description data
	 */
	WP_IMAGE_DESCRIPTION_V1_CAUSE_UNSUPPORTED = 1,
	/**
	 * error independent of the client
	 */
	WP_IMAGE_DESCRIPTION_V1_CAUSE_OPERATING_SYSTEM = 2,
	/**
	 * the relevant output no longer exists
	 */
	WP_IMAGE_DESCRIPTION_V1_CAUSE_NO_OUTPUT = 3,
};
#endif /* WP_IMAGE_DESCRIPTION_V1_CAUSE_ENUM */

#ifdef  __cplusplus
}
#endif

#endif
