START TRANSACTION;
INSERT INTO `role` (`roleid`,`name`,`type`,`readonly`) VALUES ('1','User role','1','0'),
('2','Admin role','2','0'),
('3','Super admin role','3','1'),
('4','Guest role','1','0');
INSERT INTO `ugset` (`ugsetid`,`hash`) VALUES ('1','b21d61561974b06cbeb97a71ca880e92f0fc06d49ac3246280afb88dfa6050a6');
INSERT INTO `users` (`userid`,`username`,`name`,`surname`,`passwd`,`url`,`autologin`,`autologout`,`refresh`,`rows_per_page`,`roleid`) VALUES ('1','Admin','Zabbix','Administrator','$2y$10$92nDno4n0Zm7Ej7Jfsz8WukBfgSS/U0QkIuu8WkJPihXBb2A1UrEK','','1','0','30s','50','3'),
('2','guest','','','$2y$10$89otZrRNmde97rIyzclecuk6LwKAsHN0BcvoOKGjbT.BwMBfm7G06','','0','15m','30s','50','4');
INSERT INTO `hstgrp` (`groupid`,`name`,`flags`,`uuid`,`type`) VALUES ('1','Templates','0','7df96b18c230490a9a0a9e2307226338','1'),
('2','Linux servers','0','dc579cd7a1a34222933f24f52a68bcd8','0'),
('4','Zabbix servers','0','6f6799aa69e844b4b3918f779f2abf08','0'),
('5','Discovered hosts','0','f2481361f99448eea617b7b1d4765566','0'),
('6','Virtual machines','0','137f19e6e2dc4219b33553b812627bc2','0'),
('7','Hypervisors','0','1b837a3c078647049a0c00c61b4d57b5','0'),
('9','Templates/Network devices','0','36bff6c29af64692839d077febfc7079','1'),
('10','Templates/Operating systems','0','846977d1dfed4968bc5f8bdb363285bc','1'),
('11','Templates/Server hardware','0','e960332b3f6c46a1956486d4f3f99fce','1'),
('12','Templates/Applications','0','a571c0d144b14fd4a87a9d9b2aa9fcd6','1'),
('13','Templates/Databases','0','748ad4d098d447d492bb935c907f652f','1'),
('14','Templates/Virtualization','0','02e4df4f20b848e79267641790f241da','1'),
('15','Templates/Telephony','0','1d12408342854fd5a4436dd6d5d1bd4a','1'),
('16','Templates/SAN','0','7c2cb727f85b492d88cd56e17127c64d','1'),
('17','Templates/Video surveillance','0','d37f71c7e3f7469bab645852a69a2018','1'),
('18','Templates/Power','0','3dcd5bbe90534f9e8eb5c2d53756af63','1'),
('19','Applications','0','a571c0d144b14fd4a87a9d9b2aa9fcd6','0'),
('20','Databases','0','748ad4d098d447d492bb935c907f652f','0'),
('21','Templates/Cloud','0','c2c162144c2d4c5491c8801193af4945','1');
INSERT INTO `drules` (`druleid`,`proxyid`,`name`,`iprange`,`delay`,`status`,`concurrency_max`) VALUES ('2',NULL,'Local network','192.168.0.1-254','1h','1','0');
INSERT INTO `dchecks` (`dcheckid`,`druleid`,`type`,`key_`,`snmp_community`,`ports`,`snmpv3_securityname`,`snmpv3_securitylevel`,`snmpv3_authpassphrase`,`snmpv3_privpassphrase`,`uniq`,`snmpv3_authprotocol`,`snmpv3_privprotocol`,`snmpv3_contextname`,`host_source`,`name_source`,`allow_redirect`) VALUES ('2','2','9','system.uname','','10050','','0','','','0','0','0','','1','0','0');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`maxsessions`,`maxattempts`,`attempt_interval`,`message_format`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`,`provider`) VALUES ('1','0','Email','mail.example.com','example.com','zabbix@example.com','','','','','25','0','0','0','0','1','3','10s','0','','30s','0','0','','','','0'),
('3','2','SMS','','','','','/dev/ttyS0','','','25','0','0','0','0','1','3','10s','1','','30s','0','0','','','','0'),
('4','0','Email (HTML)','mail.example.com','example.com','zabbix@example.com','','','','','25','0','0','0','0','1','3','10s','1','','30s','0','0','','','','0'),
('34','0','Gmail','smtp.gmail.com','example.com','zabbix@example.com','','','','','587','1','0','0','1','1','3','10s','1','','30s','0','0','','','','1'),
('35','0','Gmail relay','smtp-relay.gmail.com','example.com','zabbix@example.com','','','','','587','1','0','0','0','1','3','10s','1','','30s','0','0','','','','2'),
('36','0','Office365','smtp.office365.com','example.com','zabbix@example.com','','','','','587','1','0','0','1','1','3','10s','1','','30s','0','0','','','','3'),
('37','0','Office365 relay','example-com.mail.protection.outlook.com','example.com','zabbix@example.com','','','','','25','1','0','0','0','1','3','10s','1','','30s','0','0','','','','4'),
('70','4','Brevis.one','','','','','','','','25','0','0','0','0','1','3','10s','1','var BrevisOne = {\r\n    params: [],\r\n\r\n    addParam: function (name, value) {\r\n        BrevisOne.params.push(name + \'=\' + encodeURIComponent(value));\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        BrevisOne.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setPayload: function (params) {\r\n        var parts = params.send_to.split(\':\'),\r\n            defaultValues = {\r\n                ring: \'true\',\r\n                flash: \'true\',\r\n                telauto: \'false\'\r\n            };\r\n\r\n        BrevisOne.addParam(\'username\', params.username);\r\n        BrevisOne.addParam(\'password\', params.password);\r\n        BrevisOne.addParam(\'text\', params.text);\r\n\r\n        if (parts.length > 1) {\r\n            BrevisOne.addParam(\'mode\', parts[0]);\r\n            BrevisOne.addParam(\'to\', parts[1]);\r\n        }\r\n        else {\r\n            BrevisOne.addParam(\'to\', parts[0]);\r\n        }\r\n\r\n        Object.keys(defaultValues)\r\n            .forEach(function (key) {\r\n                if (params[key] && params[key].trim() && params[key].toLowerCase() === defaultValues[key]) {\r\n                    BrevisOne.addParam(key, defaultValues[key]);\r\n                }\r\n            });\r\n    },\r\n\r\n    request: function () {\r\n        var response,\r\n            request = new HttpRequest(),\r\n            data = \'?\' + BrevisOne.params.join(\'&\');\r\n\r\n        request.addHeader(\'Content-Type: multipart/form-data\');\r\n\r\n        if (typeof BrevisOne.HTTPProxy !== \'undefined\' && BrevisOne.HTTPProxy !== \'\') {\r\n            request.setProxy(BrevisOne.HTTPProxy);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ BrevisOne Webhook ] Sending request.\');\r\n\r\n        response = request.post(params.endpoint + data);\r\n\r\n        Zabbix.log(4, \'[ BrevisOne Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response) {\r\n                message += \': \' + response;\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    [\'endpoint\', \'password\', \'username\', \'text\', \'send_to\'].forEach(function (field) {\r\n        if (typeof params !== \'object\' || typeof params[field] === \'undefined\'\r\n                || !params[field].trim()) {\r\n            throw \'Required parameter is not set: "\' + field + \'".\';\r\n        }\r\n    });\r\n\r\n    if (params.send_to === \'{ALERT.SENDTO}\') {\r\n        throw \'Required parameter is not set: "send_to".\';\r\n    }\r\n\r\n    BrevisOne.setProxy(params.HTTPProxy);\r\n    BrevisOne.setPayload(params);\r\n    BrevisOne.request();\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ BrevisOne Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','','0'),
('71','4','Discord','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nvar SEVERITY_COLORS = [\r\n	\'#97AAB3\',\r\n	\'#7499FF\',\r\n	\'#FFC859\',\r\n	\'#FFA059\',\r\n	\'#E97659\',\r\n	\'#E45959\',\r\n	\'#009900\'\r\n],\r\n	serviceLogName = \'Discord Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	Discord = CWebhook;\r\n\r\nfunction stringTruncate(str, len) {\r\n	return str.length > len ? str.substring(0, len - 3) + \'...\' : str;\r\n}\r\n\r\nDiscord.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({discord_endpoint: {type: \'string\', url: true}, zabbix_url: {type: \'string\', url: true}, alert_message: {type: \'string\'},\r\n		alert_subject: {type: \'string\'}, event_nseverity: {type: \'integer\', default: 1}, user_agent: {type: \'string\'}}, this.params);\r\n\r\n	this.params.discord_endpoint = this.params.discord_endpoint.replace(\'/api/\', \'/api/v10/\') + \'?wait=True\';\r\n\r\n	if (this.params.event_source === \'3\' && this.params.event_value === \'1\') {\r\n		this.params.event_nseverity = 4;\r\n	}\r\n\r\n	if (this.params.event_value === \'0\') {\r\n		this.params.event_nseverity = 6;\r\n	}\r\n\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({event_id: {type: \'integer\'}, trigger_id: {type: \'integer\'}}, this.params);\r\n	}\r\n\r\n	this.data = {\r\n		embeds: [\r\n			{\r\n				color: parseInt(SEVERITY_COLORS[this.params.event_nseverity].replace(\'#\', \'\'), 16),\r\n				url: CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id),\r\n				title: stringTruncate(this.params.alert_subject, 256),\r\n				description: stringTruncate(this.params.alert_message, 4096)\r\n			}\r\n		]\r\n	};\r\n};\r\n\r\nDiscord.prototype.onEvent = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n\r\n	this.request.addHeaders({"User-Agent": this.params.user_agent});\r\n	const response = this.request.jsonRequest(\'POST\', this.params.discord_endpoint, this.data);\r\n\r\n	if (!response.id) {\r\n		const error_message = CParamValidator.isType(response.message, \'string\') ? response.message : \'Unknown error\';\r\n\r\n		throw error_message + \'. For more details check the Zabbix server log.\';\r\n	}\r\n\r\n	return \'OK\';\r\n};\r\n\r\n\r\ntry {\r\n	var hook = new Discord(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','This media type integrates your Zabbix installation with your Discord server using the Zabbix webhook feature.\r\n\r\nDiscord configuration:\r\n\r\n1. Go to `https://discord.com/app` or open the Discord desktop application. Open your *Server Settings* and head to the *Integrations* tab.  \r\n2. Press the *Create Webhook* button to create a new webhook.\r\n3. Click on the webhook that has been created and edit the details if needed.\r\n4. After setting up your Discord webhook press "Save Changes". Now you can copy Discord webhook URL now by pressing "Copy Webhook URL" or you can view it later.\r\n\r\nZabbix configuration:\r\n\r\n1. Before you can start using Discord webhook, set up the global macro "{$ZABBIX.URL}":\r\n- In the Zabbix web interface, go to "Administration" → "Macros" section in the dropdown menu in the top left corner.\r\n- Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.\r\n- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration you might also need to append "/zabbix" to the end of URL. Good examples: \r\n  - http://zabbix.com\r\n  - https://zabbix.lan/zabbix\r\n  - http://server.zabbix.lan/\r\n  - http://localhost\r\n  - http://127.0.0.1:8080\r\n- Bad examples:\r\n  - zabbix.com\r\n  - http://zabbix/\r\n\r\n2. Create a Zabbix user and add media:\r\n- If you want to create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks). \r\n- In the "Media" tab, add a new media and select "Discord" type from the drop-down list. The "Send to" field must contain the URL of the Discord webhook created before.\r\n- Make sure this user has access to all hosts for which you would like problem notifications to be sent to Discord.\r\n\r\n3. Great! You can now start using this media type in actions and receive alerts!\r\n\r\nYou can find the latest version of this media and additional information in the official Zabbix repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/discord','0'),
('72','4','Event-Driven Ansible','','','','','','','','25','0','0','0','0','1','3','10s','1','var Eda = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        var required_params = [\r\n                \'send_to\',\r\n                \'event_source\',\r\n                \'event_value\',\r\n                \'event_date\',\r\n                \'event_time\'],\r\n            integer_fields = [\r\n                \'event_id\',\r\n                \'event_nseverity\',\r\n                \'event_object\',\r\n                \'event_source\',\r\n                \'event_value\',\r\n                \'host_id\',\r\n                \'trigger_id\'];\r\n\r\n        required_params.forEach(function (field) {\r\n            if (typeof params !== \'object\' || typeof params[field] === \'undefined\' || params[field] === \'\') {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        Eda.params = params;\r\n\r\n        integer_fields.forEach(function (key) {\r\n                if (typeof Eda.params[key] !== \'undefined\') {\r\n                    if (isNaN(Eda.params[key])) {\r\n                        throw \'Parameter "\' + key + \'" must be integer. Given value: \' + Eda.params[key];\r\n                    }\r\n                    Eda.params[key] = parseInt(Eda.params[key]);\r\n                }\r\n            });\r\n\r\n        // Check type of event. Possible values: 0 - Trigger\r\n        if (params.event_source != 0) {\r\n            throw (\'Incorrect "event_source" parameter given: \' + params.event_source \r\n                + \'\\nOnly trigger-based events are supported\');\r\n        }\r\n\r\n        // Check trigger update and trigger resolve events\r\n        if (params.event_source == 0 && params.event_value != 1) {\r\n            throw (\'Incorrect "event_value" parameter given: "\' + params.event_value \r\n                + \'".\\nOnly trigger-based events of problem are supported\');\r\n        }\r\n        \r\n        // Check endpoint\r\n        Eda.params.endpoint = (Eda.params.endpoint.startsWith(\'/\'))\r\n                ? Eda.params.endpoint : \'/\' + Eda.params.endpoint;\r\n        // Prepare groups\r\n        Eda.params.host_groups = (typeof Eda.params[\'host_groups\'] !== \'undefined\')\r\n                ? this.prepareHostgroups(Eda.params.host_groups): []\r\n        // Prepare tags\r\n        Eda.params.event_tags = (typeof Eda.params[\'event_tags\'] !== \'undefined\')\r\n                ? this.transformTags(Eda.params.event_tags): {}\r\n        // Prepare timestamp\r\n        Eda.params.event_datetime_timestamp = this.getTimestamp(\r\n            Eda.params.event_date, Eda.params.event_time)\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Eda.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    prepareHostgroups: function (hostgroups) {\r\n        var host_groups = []; \r\n        hostgroups.split(\',\').forEach(function (group) {\r\n            group = group.trim();\r\n            if (group.length > 0) {\r\n                host_groups.push(group);\r\n            }\r\n        });\r\n        return host_groups;\r\n    },\r\n\r\n    getTimestamp: function (date, time) {\r\n        try {\r\n            return Date.parse(date.split(\'.\').join(\'-\') + \'T\' + time + \'.000Z\') / 1000 + new Date().getTimezoneOffset() * 60;\r\n        } catch (_) {}\r\n    \r\n        throw (\'Failed to parse event time.\');\r\n    },\r\n\r\n    transformTags: function (event_tags) {\r\n        var tags = {};\r\n        if (event_tags) {\r\n            try {\r\n                JSON.parse(event_tags).forEach(function (object) {\r\n                    var tag = object[\'tag\'];\r\n                    tags[tag] = tags[tag] || [];\r\n                    tags[tag].push(object[\'value\']);\r\n                });\r\n            } catch (error) {\r\n                throw \'Event tags format is invalid.\';\r\n            }\r\n        }\r\n    \r\n        return tags;\r\n    },\r\n\r\n    sendMessage: function () {\r\n        var response, request = new HttpRequest();\r\n        var url = Eda.params[\'send_to\'] + Eda.params[\'endpoint\'];\r\n        var data = JSON.stringify(Eda.params);\r\n        Zabbix.log(4, \'[ Event-Driven Ansible webhook ] URL: \' + url + \' data: \' + data);\r\n        \r\n        if (typeof Eda.HTTPProxy !== \'undefined\' && Eda.HTTPProxy !== \'\') {\r\n            request.setProxy(Eda.HTTPProxy);\r\n        }\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        response = request.post(url, data);\r\n        \r\n        Zabbix.log(4, \'[ Event-Driven Ansible webhook ] HTTP code: \' + request.getStatus()\r\n            + \' response: \' + response);\r\n\r\n        if (request.getStatus() !== 200) {\r\n            throw \'Request failed with status code \' + request.getStatus() + \': \' + response;\r\n        }\r\n    }\r\n};\r\n\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n    \r\n    Eda.setParams(params);\r\n    Eda.setProxy(params.HTTPProxy);\r\n    Eda.sendMessage();\r\n    return true;\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ Event-Driven Ansible webhook ] notification failed: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','','0'),
('73','4','Express.ms','','','','','','','','25','0','0','0','0','1','3','10s','1','var Express = {\r\n    params: [],\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Express.params = params;\r\n\r\n        if (typeof Express.params.url === \'string\' && !Express.params.url.endsWith(\'/\')) {\r\n            Express.params.url += \'/\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Express.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    request: function (query, data) {\r\n        var response,\r\n            url = Express.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: Bearer \' + Express.params.token);\r\n\r\n        if (typeof Express.HTTPProxy !== \'undefined\' && Express.HTTPProxy !== \'\') {\r\n            request.setProxy(Express.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Express Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        response = request.post(url, data);\r\n\r\n        Zabbix.log(4, \'[ Express Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ Express Webhook ] Failed to parse response received from Express\');\r\n                response = {};\r\n            }\r\n        }\r\n\r\n        if (response.status !== \'ok\') {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (typeof response.reason !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.reason);\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return response.result;\r\n    },\r\n\r\n    postMessage: function (is_problem) {\r\n        var data,\r\n            url,\r\n            result = {tags: {}},\r\n            response;\r\n\r\n        if (is_problem) {\r\n            data = {\r\n                group_chat_id: Express.params.send_to,\r\n                notification: {\r\n                    status: \'ok\',\r\n                    body: Express.params.message\r\n                }\r\n            };\r\n            url = \'api/v4/botx/notifications/direct\';\r\n        }\r\n        else {\r\n            data = {\r\n                reply: {\r\n                    status: \'ok\',\r\n                    body: Express.params.message\r\n                }\r\n            };\r\n            url = \'api/v3/botx/events/reply_event\';\r\n\r\n            try {\r\n                var tags = JSON.parse(Express.params.tags);\r\n            }\r\n            catch (error) {\r\n                throw \'Value of "express_tags" is not JSON. Value: \' + Express.params.tags + \'.\';\r\n            }\r\n\r\n            tags.forEach(function(tag) {\r\n                if (tag.tag === \'__zbx_ex_sync_id_\' + Express.params.send_to) {\r\n                    data.source_sync_id = tag.value;\r\n                }\r\n            });\r\n\r\n            if (!data.source_sync_id) {\r\n                throw \'Cannot update data. sync_id for the provided sender is unknown.\';\r\n            }\r\n        }\r\n\r\n        response = Express.request(url, data);\r\n\r\n        if (is_problem && response.sync_id) {\r\n            result.tags[\'__zbx_ex_sync_id_\' + Express.params.send_to] = response.sync_id;\r\n\r\n            return JSON.stringify(result);\r\n        }\r\n        else {\r\n            return \'OK\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        express = {},\r\n        required_params = [\r\n            \'express_url\', \'express_send_to\', \'express_message\', \'express_tags\', \'express_token\',\r\n            \'event_source\', \'event_value\', \'event_update_status\'\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'express_\')) {\r\n                express[key.substring(8)] = params[key];\r\n            }\r\n\r\n            if (required_params.indexOf(key) !== -1\r\n                    && (params[key].trim() === \'\' || params[key] === \'{ALERT.SENDTO}\')) {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Forcing event_value and event_update_status for non trigger-based events.\r\n    if (params.event_source !== \'0\' ) {\r\n        params.event_value = \'1\';\r\n        params.event_update_status = \'0\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    Express.setParams(express);\r\n    Express.setProxy(params.HTTPProxy);\r\n\r\n    return Express.postMessage(params.event_value === \'1\' && params.event_update_status === \'0\');\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ Express Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','0','','','','0'),
('74','4','GitHub','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nvar serviceLogName = \'GitHub Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	GitHub = CWebhook;\r\n\r\nGitHub.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		alert_message: {type: \'string\'},\r\n		alert_subject: {type: \'string\'},\r\n		github_api_version: {type: \'string\'},\r\n		github_repo: {type: \'string\'},\r\n		github_token: {type: \'string\'},\r\n		github_url: {type: \'string\', url: true},\r\n		github_user_agent: {type: \'string\'},\r\n		github_zabbix_event_priority_label_prefix: {type: \'string\', default: \'Zabbix Event Priority: \'},\r\n		github_zabbix_event_source_label_prefix: {type: \'string\', default: \'Zabbix Event Source: \'},\r\n		github_zabbix_event_status_label_prefix: {type: \'string\', default: \'Zabbix Event Status: \'},\r\n		github_zabbix_generic_label: {type: \'string\', default: \'Zabbix GitHub Webhook\'},\r\n		zabbix_url: {type: \'string\', url: true}\r\n	}, this.params);\r\n\r\n	this.request_headers = {\r\n		\'User-Agent\': this.params.github_user_agent,\r\n		\'Accept\': \'application/vnd.github+json\',\r\n		\'X-GitHub-Api-Version\': this.params.github_api_version,\r\n		\'Authorization\': \'Bearer \' + this.params.github_token\r\n	};\r\n\r\n	this.payload_data = {\r\n		title: this.params.alert_subject,\r\n		labels: [\r\n			{\r\n				name: this.params.github_zabbix_generic_label\r\n			}\r\n		]\r\n	};\r\n\r\n	this.result = {tags: {}};\r\n};\r\n\r\nfunction checkResponse(response, received_code, required_code, response_field, error_message) {\r\n	if (received_code != required_code || !CParamValidator.isDefined(response[response_field])) {\r\n		var message = error_message + \' Request failed with status code \' + received_code;\r\n\r\n		if (CParamValidator.isDefined(response.message) && Object.keys(response.message).length > 0) {\r\n			message += \': \' + response.message;\r\n		}\r\n\r\n		throw message + \' Check debug log for more information.\';\r\n	}\r\n}\r\n\r\nGitHub.prototype.createIssue = function () {\r\n	this.payload_data.body = this.params.alert_message + \'\\n\' + CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n\r\n	this.request.addHeaders(this.request_headers);\r\n\r\n	const response = this.request.jsonRequest(\'POST\', this.params.github_url + \'/repos/\' + this.params.github_repo + \'/issues\', this.payload_data);\r\n\r\n	checkResponse(response, this.request.getStatus(), 201, \'number\', \'Cannot create GitHub issue.\');\r\n\r\n	return response;\r\n}\r\n\r\nGitHub.prototype.updateIssue = function () {\r\n	this.request.addHeaders(this.request_headers);\r\n\r\n	const response = this.request.jsonRequest(\'PATCH\', this.params.github_url + \'/repos/\' + this.params.github_repo + \'/issues/\' + this.params.github_issue_number, this.payload_data);\r\n\r\n	checkResponse(response, this.request.getStatus(), 200, \'number\', \'Cannot update GitHub issue.\');\r\n\r\n	return response;\r\n}\r\n\r\nGitHub.prototype.addIssueComment = function () {\r\n	this.payload_data = {\r\n		body: this.params.alert_message\r\n	};\r\n\r\n	this.request.addHeaders(this.request_headers);\r\n\r\n	const response = this.request.jsonRequest(\'POST\', this.params.github_url + \'/repos/\' + this.params.github_repo + \'/issues/\' + this.params.github_issue_number + \'/comments\', this.payload_data);\r\n\r\n	checkResponse(response, this.request.getStatus(), 201, \'id\', \'Cannot add comment for GitHub issue.\');\r\n\r\n	return response;\r\n}\r\n\r\nGitHub.prototype.onProblem = function (alert) {\r\n	if (CParamValidator.isMacroSet(this.params.github_issue_number)) {\r\n		return this.onUpdate(alert);\r\n	}\r\n\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({event_id: {type: \'integer\'}, trigger_id: {type: \'integer\'}}, this.params);\r\n	}\r\n\r\n	this.payload_data.labels.push({name: this.params.github_zabbix_event_source_label_prefix + alert.source});\r\n\r\n	this.payload_data.labels.push({name: this.params.github_zabbix_event_status_label_prefix + \'Problem\'});\r\n\r\n	if (!CParamValidator.isEmpty(this.params.event_severity) && CParamValidator.isMacroSet(this.params.event_severity, \'EVENT.SEVERITY\')) {\r\n		this.payload_data.labels.push({name: this.params.github_zabbix_event_priority_label_prefix + this.params.event_severity});\r\n	}\r\n\r\n	const response = this.createIssue();\r\n\r\n	this.result.tags = {\r\n		__zbx_github_issue_number: response.number,\r\n		__zbx_github_repo: this.params.github_repo,\r\n		__zbx_github_link: response.html_url\r\n	};\r\n\r\n	return this.result;\r\n}\r\n\r\nGitHub.prototype.onUpdate = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n\r\n	if (!CParamValidator.isMacroSet(this.params.github_issue_number)) {\r\n		throw "Failed to update the existing issue: no issue number was received."\r\n	}\r\n\r\n	this.payload_data.labels.push({name: this.params.github_zabbix_event_source_label_prefix + alert.source});\r\n\r\n	if (this.params.event_value === \'0\') {\r\n		this.payload_data.labels.push({name: this.params.github_zabbix_event_status_label_prefix + \'Resolved\'});\r\n	} else {\r\n		this.payload_data.labels.push({name: this.params.github_zabbix_event_status_label_prefix + \'Problem\'});\r\n	}\r\n\r\n	if (!CParamValidator.isEmpty(this.params.event_severity) && CParamValidator.isMacroSet(this.params.event_severity, \'EVENT.SEVERITY\')) {\r\n		this.payload_data.labels.push({name: this.params.github_zabbix_event_priority_label_prefix + this.params.event_severity});\r\n	}\r\n\r\n	this.updateIssue();\r\n\r\n	this.request.clearHeader();\r\n	this.addIssueComment();\r\n\r\n	return this.result;\r\n}\r\n\r\nGitHub.prototype.onResolve = function (alert) {\r\n	return this.onUpdate(alert);\r\n}\r\n\r\nGitHub.prototype.onDiscovery = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n\r\n	this.payload_data.labels.push({name: this.params.github_zabbix_event_source_label_prefix + alert.source});\r\n\r\n	this.createIssue();\r\n\r\n	return this.result;\r\n}\r\n\r\nGitHub.prototype.onAutoreg = function (alert) {\r\n	return this.onDiscovery(alert);\r\n}\r\n\r\ntry {\r\n	var hook = new GitHub(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_github_link}','Github: Issue {EVENT.TAGS.__zbx_github_issue_number}','This media type integrates your Zabbix installation with GitHub using the Zabbix webhook feature.\r\n\r\nGitHub configuration:\r\n\r\n1. Create an access token.\r\n\r\nOne of the simplest ways to send authenticated requests is to use a personal access token - either a classic or a fine-grained one:\r\nhttps://docs.github.com/en/rest/authentication/authenticating-to-the-rest-api?apiVersion=2022-11-28#authenticating-with-a-personal-access-token\r\n\r\nClassic personal access token\r\n\r\nYou can create a new classic personal access token by following the instructions in the official documentation:\r\nhttps://docs.github.com/en/authentication/keeping-your-account-and-data-secure/managing-your-personal-access-tokens#creating-a-personal-access-token-classic\r\n\r\nThe token user must have a permission to create issues and issue comments in the desired repositories. For webhook to work on private repositories, the "repo" scope must be set in token settings to have full control of private repositories.\r\n\r\nAdditional information about OAuth scopes is available in the official documentation:\r\nhttps://docs.github.com/en/apps/oauth-apps/building-oauth-apps/scopes-for-oauth-apps#available-scopes\r\n\r\nFine-grained personal access token\r\n\r\nAlternatively, you can use a fine-grained personal access token:\r\nhttps://docs.github.com/en/authentication/keeping-your-account-and-data-secure/managing-your-personal-access-tokens#creating-a-fine-grained-personal-access-token\r\n\r\nIn order to use fine-grained tokens to monitor organization-owned repositories, organizations must opt in to fine-grained personal access tokens and set up a personal access token policy:\r\nhttps://docs.github.com/en/organizations/managing-programmatic-access-to-your-organization/setting-a-personal-access-token-policy-for-your-organization\r\n\r\nThe fine-grained token needs to have the following permission set to provide access to the repository issues:\r\n- "Issues" repository permissions (write)\r\n\r\n2. Copy and save the created token somewhere, as it will be shown only once for security reasons.\r\n\r\nZabbix configuration:\r\n\r\n1. Before you can start using Zammad webhook, set up the global macro "{$ZABBIX.URL}":\r\n- In the Zabbix web interface, go to "Administration" → "Macros" section in the dropdown menu in the top left corner.\r\n- Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.\r\n- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration you might also need to append "/zabbix" to the end of URL. Good examples:\r\n  - http://zabbix.com\r\n  - https://zabbix.lan/zabbix\r\n  - http://server.zabbix.lan/\r\n  - http://localhost\r\n  - http://127.0.0.1:8080\r\n- Bad examples:\r\n  - zabbix.com\r\n  - http://zabbix/\r\n\r\n2. Set the "github_token" webhook parameter value to the access token that you created previously.\r\n\r\nYou can also adjust the issue labels created by the webhook in the following parameters:\r\n- github_zabbix_event_priority_label_prefix - the prefix for the issue label that displays the Zabbix event priority in the supported event sources. It is set to "Zabbix Event Priority: " by default.\r\n- github_zabbix_event_source_label_prefix - the prefix for the issue label that displays the Zabbix event source. It is set to "Zabbix Event Source: " by default.\r\n- github_zabbix_event_status_label_prefix - the prefix for the issue label that displays the Zabbix event status. It is set to "Zabbix Event Status: " by default.\r\n- github_zabbix_generic_label - the label that is added to all issues created by the webhook. It is set to "Zabbix GitHub Webhook" by default.\r\n\r\nNote that the webhook will reuse the labels with the same name that already exist in the repository (including the color, so it can changed from the default value for new labels in GitHub, if needed). Also, the labels are replaced when the issue is updated, so any user-added labels will be removed.\r\n\r\n4. Create a Zabbix user and add media:\r\n- If you want to create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).\r\n- In the "Media" tab, add a new media and select "Zammad" type from the drop-down list. In field "Send to" specify the full repo name (owner/project name) e.g. johndoe/example-project.\r\n- Make sure this user has access to all hosts for which you would like problem notifications to be sent to GitHub.\r\n\r\n5. Great! You can now start using this media type in actions and create GitHub issues!\r\n\r\nYou can find the latest version of this media and additional information in the official Zabbix repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/github','0'),
('75','4','GLPi','','','','','','','','25','0','0','0','0','1','1','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nconst serviceLogName = \'GLPi Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	GLPi = CWebhook;\r\n\r\nGLPi.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		alert_message: { type: \'string\' },\r\n		alert_subject: { type: \'string\' },\r\n		zabbix_url: { type: \'string\', url: true },\r\n		glpi_url: { type: \'string\', url: true },\r\n		glpi_token: { type: \'string\' }\r\n	}, this.params);\r\n\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({ trigger_id: { type: \'integer\' }, event_id: { type: \'integer\' } }, this.params);\r\n		this.params.zabbix_url = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n	}\r\n\r\n	if (params.event_value != \'0\' && CParamValidator.isMacroSet(this.params.glpi_problem_id)) {\r\n		this.params.event_update_status = \'1\';\r\n	}\r\n\r\n	this.data = {\r\n		input: {\r\n			name: this.params.alert_subject,\r\n			urgency: (this.params.event_nseverity = isNaN(Number(this.params.event_nseverity)) ? 2 : this.params.event_nseverity)\r\n		}\r\n	};\r\n\r\n	this.dataFollowup = {\r\n		input: {\r\n			items_id: this.params.glpi_problem_id,\r\n			itemtype: \'Problem\',\r\n			content: this.params.alert_message + \'<br> <a href=\' + this.params.zabbix_url + \'>Link to problem in Zabbix</a>\',\r\n		}\r\n	};\r\n\r\n	this.result = { tags: {} };\r\n}\r\n\r\nGLPi.prototype.getAuthToken = function () {\r\n\r\n	this.request.addHeaders(\'Authorization: user_token \' + this.params.glpi_token);\r\n	var response = this.request.jsonRequest(\'post\', this.params.glpi_url + \'/apirest.php/initSession\');\r\n\r\n	if ((this.request.getStatus() !== 200 && this.request.getStatus() !== 201)) {\r\n		Logger.log(Logger.INFO, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.description, \'string\')) {\r\n			throw response.description;\r\n		}\r\n		else {\r\n			Logger.log(Logger.INFO, \'Request not successful. Received response: \' + JSON.stringify(response));\r\n			throw \'Unknown INFO. Check debug log for more information.\';\r\n		}\r\n	}\r\n	if (!CParamValidator.isType(response.session_token, \'string\') || CParamValidator.isEmpty(response.session_token)) {\r\n		Logger.log(Logger.INFO, \'Check getting GLPi sessionToken: \' + response.session_token);\r\n		throw \'Required GLPi sessionToken is not received.\';\r\n	}\r\n\r\n	return response.session_token;\r\n}\r\n\r\nGLPi.prototype.sendRequest = function (method, path, data) {\r\n\r\n	this.request.clearHeader();\r\n	this.request.addHeaders(\'Session-Token:\' + this.params.authToken);\r\n	var response = this.request.jsonRequest(method, this.params.glpi_url + path, data);\r\n\r\n	if ((this.request.getStatus() !== 200 && this.request.getStatus() !== 201)) {\r\n		Logger.log(Logger.INFO, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.description, \'string\')) {\r\n			throw response.description;\r\n		}\r\n		else {\r\n			Logger.log(Logger.INFO, \'Request not successful. Received response: \' + JSON.stringify(response));\r\n			throw \'Unknown INFO. Check debug log for more information.\';\r\n		}\r\n	}\r\n\r\n	return response;\r\n}\r\n\r\nGLPi.prototype.createProblem = function (status) {\r\n	this.data.input.content = this.params.alert_message + \'<br> <a href=\' + this.params.zabbix_url + \'>Link to problem in Zabbix</a>\';\r\n\r\n	if (CParamValidator.isDefined(status)) {\r\n		this.data.input.status = status;\r\n	}\r\n\r\n	var response = this.sendRequest(\'post\', \'/apirest.php/Problem/\', this.data);\r\n\r\n	if (!CParamValidator.isDefined(response.id)) {\r\n		throw \'Cannot create GPLi problem. Check debug log for more information.\';\r\n	}\r\n\r\n	return response.id\r\n}\r\n\r\nGLPi.prototype.updateProblem = function (status) {\r\n	CParamValidator.validate({ glpi_problem_id: { type: \'string\' } }, this.params);\r\n	this.data.id = this.params.glpi_problem_id;\r\n\r\n	if (CParamValidator.isDefined(status)) {\r\n		this.data.input.status = status;\r\n	}\r\n\r\n	this.sendRequest(\'put\', \'/apirest.php/Problem/\' + this.params.glpi_problem_id, this.data);\r\n	this.sendRequest(\'post\', \'/apirest.php/Problem/\' + this.params.glpi_problem_id + \'/ITILFollowup\', this.dataFollowup);\r\n}\r\n\r\nGLPi.prototype.onProblem = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	const problem_id = this.createProblem(1)\r\n\r\n	this.result.tags.__zbx_glpi_problem_id = problem_id;\r\n	this.result.tags.__zbx_glpi_link = this.params.glpi_url + \'/front/problem.form.php?id=\' + problem_id;\r\n\r\n	return this.result;\r\n}\r\n\r\nGLPi.prototype.onUpdate = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	this.updateProblem();\r\n\r\n	return this.result;\r\n}\r\n\r\nGLPi.prototype.onResolve = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	this.updateProblem(5);\r\n\r\n	return this.result;\r\n}\r\n\r\nGLPi.prototype.onDiscovery = function () {\r\n	return this.createProblem();\r\n}\r\n\r\nGLPi.prototype.onAutoreg = function () {\r\n	return this.createProblem();\r\n}\r\n\r\ntry {\r\n	var hook = new GLPi(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	hook.params.authToken = hook.getAuthToken();\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_glpi_link}','GLPi: Problem {EVENT.TAGS.__zbx_glpi_problem_id}','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/glpi\r\n\r\n1. To make this integration work, you will need the following from GLPi:\r\n  * GLPi instance URL;\r\n  * GLPi user token. API token obtained by going to Administration → Users → create or use existing user → Remote access keys → Regenerate API token.\r\n2. In the Zabbix web interface, go to Administration → Macros section. Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend.\r\n3. On this page replace the placeholder \'<...>\' values with the ones from the step #1.\r\n4. In Zabbix, you need to have a Zabbix user and add Media with the GLPi media type. Make sure this user has access to all hosts for which you would like problem issues to be created in GLPi.','0'),
('76','4','iLert','','','','','','','','25','0','0','0','0','1','3','10s','1','try {\r\n    var result = { tags: {} },\r\n        params = JSON.parse(value),\r\n        req = new HttpRequest(),\r\n        resp = \'\';\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.setProxy(params.HTTPProxy);\r\n    }\r\n    var alertSourceKey = params[\'.ILERT.ALERT.SOURCE.KEY\'];\r\n    if (!alertSourceKey || (typeof alertSourceKey === \'string\' && alertSourceKey.trim() === \'\')) {\r\n        throw \'incorrect value for variable "ILERT.ALERT.SOURCE.KEY". The value must be a non-empty string.\';\r\n    }\r\n    delete params[\'.ILERT.ALERT.SOURCE.KEY\'];\r\n    \r\n    var ilertApiBaseURL = "https://api.ilert.com";\r\n    var reqURL = encodeURI(ilertApiBaseURL + "/api/v1/events/zabbix-mt/" + alertSourceKey)\r\n\r\n    var incidentKey = "zabbix-" + params[\'EVENT.ID\'];\r\n    var incidentViewURL = ilertApiBaseURL + "/api/v1/incidents/resolve-ik/" + alertSourceKey + "/" + incidentKey;\r\n\r\n    req.addHeader(\'Accept: application/json\');\r\n    req.addHeader(\'Content-Type: application/json\');\r\n\r\n    Zabbix.log(4, \'[iLert Webhook] Sending request:\' + JSON.stringify(params));\r\n    resp = req.post(reqURL, JSON.stringify(params));\r\n    Zabbix.log(4, \'[iLert Webhook] Receiving response:\' + resp);\r\n\r\n    try {\r\n        resp = JSON.parse(resp);\r\n    }\r\n    catch (error) {\r\n        throw \'incorrect response. iLert returned a non-JSON object.\';\r\n    }\r\n\r\n    if (req.getStatus() == 200) {\r\n        result.tags.__ilert_incident_url = incidentViewURL;\r\n        return JSON.stringify(result);\r\n    }\r\n\r\n    if (req.getStatus() == 400 && typeof resp === \'object\' && typeof resp.code === \'string\') {\r\n        if (resp.code === \'NO_OPEN_INCIDENT_WITH_KEY\') {\r\n          return JSON.stringify(result);\r\n        }\r\n        if (resp.code === \'INCIDENT_ALREADY_ACCEPTED\') {\r\n          result.tags.__ilert_incident_url = incidentViewURL;\r\n          return JSON.stringify(result);\r\n        }\r\n    }\r\n\r\n    if (typeof resp === \'object\' && typeof resp.message === \'string\') {\r\n        throw resp.message;\r\n    }\r\n    else {\r\n        throw \'Unknown error.\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[iLert Webhook] Notification failed : \' + error);\r\n    throw \'iLert notification failed : \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__ilert_incident_url}','iLert incident','Please refer to https://docs.ilert.com/integrations/zabbix/native \r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "iLert". You can also rewrite the incident summary via ".ILERT.INCIDENT.SUMMARY" parameter or leave it empty to use the standard pattern.','0'),
('77','4','iTop','','','','','','','','25','0','0','0','0','1','3','10s','1','var Itop = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        if (params.log !== \'private_log\' && params.log !== \'public_log\') {\r\n            throw \'Incorrect "itop_log" parameter given: \' + params.log + \'\\nMust be "private_log" or "public_log".\';\r\n        }\r\n\r\n        Itop.params = params;\r\n        if (typeof Itop.params.url === \'string\') {\r\n            if (!Itop.params.url.endsWith(\'/\')) {\r\n                Itop.params.url += \'/\';\r\n            }\r\n\r\n            Itop.params.url += \'webservices/rest.php?version=\' + encodeURIComponent(Itop.params.api_version);\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Itop.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setCreatePayload: function () {\r\n        json_data.operation = \'core/create\';\r\n        json_data.fields.org_id = Itop.params.organization_id;\r\n        json_data.fields.title = params.alert_subject;\r\n        json_data.fields.description = params.alert_message.replace(\'<\', \'&lt;\')\r\n            .replace(\'>\', \'&gt;\')\r\n            .replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n    },\r\n\r\n    setUpdatePayload: function () {\r\n        json_data.operation = \'core/update\';\r\n        json_data.key = Itop.params.id;\r\n        json_data.fields.title = params.alert_subject;\r\n        json_data.fields[Itop.params.log] = {\r\n            add_item: {\r\n                message: params.alert_subject + \'\\n\' + params.alert_message,\r\n                format: \'text\'\r\n            }\r\n        };\r\n    },\r\n\r\n    request: function (data) {\r\n        [\'url\', \'user\', \'password\', \'organization_id\', \'class\', \'api_version\', \'id\'].forEach(function (field) {\r\n            if (typeof Itop.params !== \'object\' || typeof Itop.params[field] === \'undefined\'\r\n                    || Itop.params[field] === \'\' ) {\r\n                throw \'Required Itop param is not set: "itop_\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Itop.params.url,\r\n            request = new HttpRequest(),\r\n            object;\r\n\r\n        request.addHeader(\'Content-Type: multipart/form-data\');\r\n        request.addHeader(\'Authorization: Basic \' + btoa(Itop.params.user + \':\' + Itop.params.password));\r\n\r\n        if (Itop.HTTPProxy) {\r\n            request.setProxy(Itop.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ iTop Webhook ] Sending request: \' + url + \'&json_data=\' + data);\r\n\r\n        response = request.post(url + \'&json_data=\' + encodeURIComponent(data));\r\n\r\n        Zabbix.log(4, \'[ iTop Webhook ] Received response with status code \' + request.getStatus() + \'\\n\' + response);\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.log(4, \'[ iTop Webhook ] Failed to parse response received from iTop\');\r\n            throw \'Failed to parse response received from iTop.\\nRequest status code \' +\r\n                    request.getStatus() + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            throw \'Request failed with status code \' + request.getStatus() + \'. Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.code !== \'undefined\' && response.code !== 0) {\r\n            throw \'Request failed with iTop code \' + response.code + \': \' +\r\n                    JSON.stringify(response.message) + \'. Check debug log for more information.\';\r\n        }\r\n        else {\r\n            Object.keys(response.objects)\r\n                .forEach(function (key) {\r\n                    object = response.objects[key];\r\n                });\r\n    \r\n            return {\r\n                status: request.getStatus(),\r\n                response: object.fields\r\n            };\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        json_data = {},\r\n        itop_params = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'summary\', \'event_recovery_value\',\r\n            \'event_source\', \'event_value\', \'action_name\'\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'itop_\')) {\r\n                itop_params[key.substring(5)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Itop.setParams(itop_params);\r\n    Itop.setProxy(params.HTTPProxy);\r\n\r\n    json_data.operation = \'\';\r\n    json_data.class = Itop.params.class;\r\n    json_data.comment = Itop.params.comment;\r\n    json_data.output_fields = \'id, friendlyname\';\r\n    json_data.fields = {};\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Itop.setCreatePayload();\r\n        Itop.request(json_data);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\'\r\n            && (Itop.params.id === \'{EVENT.TAGS.__zbx_itop_id}\' || Itop.params.id === \'*UNKNOWN*\')) {\r\n        Itop.setCreatePayload();\r\n\r\n        var response = Itop.request(json_data);\r\n\r\n        result.tags.__zbx_itop_id = response.response.id;\r\n        result.tags.__zbx_itop_key = response.response.friendlyname;\r\n        result.tags.__zbx_itop_link = params.itop_url + (params.itop_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n                \'pages/UI.php?operation=details&class=\' + encodeURIComponent(Itop.params.class) + \'&id=\' +\r\n                encodeURIComponent(response.response.id);\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (Itop.params.id === \'{EVENT.TAGS.__zbx_itop_id}\' || Itop.params.id === \'*UNKNOWN*\') {\r\n            throw \'Incorrect iTop ticket ID given: \' + Itop.params.id;\r\n        }\r\n        Itop.setUpdatePayload();\r\n        Itop.request(json_data);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ iTop Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_itop_link}','iTop: {EVENT.TAGS.__zbx_itop_key}','','0'),
('78','4','Jira','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nvar ZABBIX_SEVERITY_MAP = ["not_classified", "information", "warning", "average", "high", "disaster"];\r\n\r\nvar serviceLogName = \'Jira Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	Jira = CWebhook;\r\n\r\nJira.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		jira_url: { type: \'string\', url: true},\r\n		jira_user: { type: \'string\' },\r\n		jira_password: { type: \'string\' },\r\n		jira_issue_type: { type: \'string\' },\r\n		jira_project_key: { type: \'string\' },\r\n		event_source: { type: \'string\' },\r\n		alert_subject: { type: \'string\' },\r\n		alert_message: { type: \'string\' },\r\n		event_nseverity: { type: \'integer\', default: 0 }\r\n	}, this.params);\r\n\r\n	this.priority = this.params.event_source == 3 ? this.params.jira_priority_internal : this.params[\'severity_\' + ZABBIX_SEVERITY_MAP[this.params.event_nseverity]];\r\n	this.params.event_tags_json = parseTags(this.params.event_tags_json, false);\r\n\r\n	if (this.params.event_tags_json.length > 0) {\r\n		this.labels = setLabels(this.params.event_tags_json);\r\n	}\r\n\r\n	parseOptionalFields();\r\n\r\n	this.result = { tags: {} };\r\n}\r\n\r\nfunction escapeMarkup(str) {\r\n	var length = str.length,\r\n		result = \'\',\r\n		markup = [\'{\', \'|\', \'}\', \'~\', \'_\', \'\\\\\', \'[\', \']\', \'^\', \'<\', \'>\', \'?\', \'!\', \'#\', \'+\', \'*\', \'&\'];\r\n\r\n	for (var i = 0; i < length; i++) {\r\n		var char = str[i];\r\n		result += (markup.indexOf(char) !== -1) ? (\'&#\' + str[i].charCodeAt() + \';\') : char;\r\n	}\r\n\r\n	return result;\r\n}\r\n\r\nfunction parseOptionalFields() {\r\n	this.params.customfields = {};\r\n	this.params.components = [];\r\n\r\n	Object.keys(this.params).forEach(function (key) {\r\n		if (key.startsWith(\'customfield_\')) {\r\n			this.params.customfields[key] = this.params[key];\r\n		}\r\n\r\n		if (key.startsWith(\'component_\')) {\r\n			this.params.components.push({"name": this.params[key]})\r\n		}\r\n	});\r\n}\r\n\r\nJira.prototype.addCustomFields = function (data) {\r\n	if (typeof this.params.customfields === \'object\' && Object.keys(this.params.customfields).length) {\r\n		var schemaData = this.sendRequest(\'GET\', \'/rest/api/latest/field\'),\r\n			schema = {};\r\n\r\n		schemaData.forEach(function (item) {\r\n			schema[item.id] = item.schema;\r\n		});\r\n\r\n		Object.keys(this.params.customfields).forEach(function (field) {\r\n			if (typeof schema[field] === \'object\' && schema[field].type) {				\r\n				const type = schema[field].type;\r\n\r\n				if (type === \'number\') {\r\n					data.fields[field] = parseInt(this.params.customfields[field]);\r\n				}\r\n				else if (type === \'string\' && schema[field][\'custom\'].split(\':\')[1] === \'url\') {\r\n					if (this.params.customfields[field] === \'zabbix_url\') {\r\n						data.fields[field] = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n					} else {\r\n						data.fields[field] = this.params.customfields[field];\r\n					}\r\n				}\r\n				else if (type === \'date\') {\r\n					if (this.params.customfields[field].match(/\\d+[.-]\\d+[.-]\\d+/) !== null) {\r\n						data.fields[field] = this.params.customfields[field].replace(/\\./g, \'-\');\r\n					}\r\n				}\r\n				else if (type === \'datetime\') {\r\n					if (this.params.customfields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {\r\n						data.fields[field] = this.params.customfields[field].replace(/\\./g, \'-\');\r\n					}\r\n				}\r\n				else if (type === \'option\') {\r\n					data.fields[field] = { \'value\': this.params.customfields[field] };\r\n				}\r\n				else if (type === \'array\') {\r\n					if (schema[field].items === \'option\') {\r\n						const valuesList = this.params.customfields[field].split(\',\');\r\n						data.fields[field] = [];\r\n						valuesList.forEach(function (val) {\r\n							data.fields[field].push({\'value\': val})\r\n						});\r\n					}\r\n					else {\r\n						data.fields[field] = [this.params.customfields[field]];\r\n					}\r\n				}\r\n				else {\r\n					data.fields[field] = this.params.customfields[field];\r\n				}\r\n			}\r\n		});\r\n	}\r\n	else {\r\n		Logger.log(Logger.WARN, \'No customfields found.\');\r\n	}\r\n\r\n	return data;\r\n}\r\n\r\nfunction parseTags(event_tags) {\r\n	try {\r\n		return JSON.parse(event_tags);\r\n	}\r\n	catch (error) {\r\n		if (this.params.event_source == 0 || this.params.event_source > 2) {\r\n			Logger.log(Logger.WARN, \'No event tags were found. Should be an object. Received event tags: "\' + event_tags + \'".\');\r\n		}\r\n		return [];\r\n	}\r\n}\r\n\r\nfunction getTagValue(tags, key, throw_on_fail) {\r\n	for (i in tags) {\r\n		if (tags[i].tag === key) {\r\n			return tags[i].value\r\n		}\r\n	}\r\n\r\n	if (!throw_on_fail) {\r\n		return false;\r\n	} else {\r\n		throw \'Tag "\' + key + \'" is not in the event tag list.\'\r\n	}\r\n};\r\n\r\nfunction setLabels(event_tags_json) {\r\n	var buffer = [];\r\n\r\n	event_tags_json.forEach(function (tag) {\r\n		if (typeof tag.tag !== \'undefined\' && typeof tag.value !== \'undefined\' && !tag.tag.startsWith(\'__zbx\')) {\r\n			label = (tag.tag + (tag.value ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n			if (label.length < 256) {\r\n				buffer.push(label);\r\n			}\r\n		}\r\n	});\r\n\r\n	if (buffer.length === 0) {\r\n		Logger.log(Logger.WARN, \'No labels were set.\');\r\n	}\r\n\r\n	return buffer;\r\n}\r\n\r\nJira.prototype.commentIssue = function (issue_key) {\r\n	var data = {\r\n		body: this.params.alert_message,\r\n	};\r\n	this.sendRequest(\'POST\', \'/rest/api/latest/issue/\' + encodeURIComponent(issue_key) + \'/comment\', data);\r\n}\r\n\r\nJira.prototype.sendRequest = function (method, path, data) {\r\n	this.request.clearHeader();\r\n	this.request.addHeaders(\'Authorization: Basic \' + btoa(this.params.jira_user + \':\' + this.params.jira_password));\r\n\r\n	var response = this.request.jsonRequest(method, this.params.jira_url + path, data);\r\n\r\n	if ((this.request.getStatus() !== 200 && this.request.getStatus() !== 201)) {\r\n		Logger.log(Logger.WARN, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.description, \'string\')) {\r\n			throw response.description;\r\n		}\r\n		else {\r\n			Logger.log(Logger.WARN, \'Request not successful. Received response: \' + JSON.stringify(response));\r\n			throw \'Unknown error. Check debug log for more information.\';\r\n		}\r\n	}\r\n\r\n	return response;\r\n}\r\n\r\nJira.prototype.onProblem = function (alert) {\r\n	if (this.params.event_tags_json.length > 0 && getTagValue(this.params.event_tags_json, \'__zbx_jira_issuekey\', false) !== false) {\r\n		return this.onUpdate(alert, true);\r\n	}\r\n\r\n	var data = {\r\n		fields: {\r\n			project: {\r\n				key: this.params.jira_project_key\r\n			},\r\n			issuetype: {\r\n				name: this.params.jira_issue_type\r\n			},\r\n			summary: this.params.alert_subject,\r\n			description: this.params.alert_message,\r\n			priority: {\r\n				"name": this.priority\r\n			}\r\n		}\r\n	};\r\n\r\n	if (this.labels && this.labels.length > 0) {\r\n		data.fields.labels = this.labels;\r\n	}\r\n\r\n	if (this.params.components && this.params.components.length > 0) {\r\n		data.fields.components = this.params.components;\r\n	}\r\n\r\n	var response = this.sendRequest(\'POST\', \'/rest/api/latest/issue\', this.addCustomFields(data));\r\n	this.result.tags = {\r\n		__zbx_jira_issuekey: response.key,\r\n		__zbx_jira_issuelink: this.params.jira_url + \'/browse/\' + response.key\r\n	}\r\n	return this.result;\r\n}\r\n\r\nJira.prototype.onUpdate = function (alert, dontUpdatePriority) {\r\n	var data = {\r\n		fields: {\r\n			summary: this.params.alert_subject,\r\n			priority: {\r\n				"name": this.priority\r\n			}\r\n		}\r\n	};\r\n\r\n	if (dontUpdatePriority && this.params.event_source != 0) {\r\n		delete data[\'fields\'][\'priority\'];\r\n	}\r\n\r\n	var jira_issue_key = getTagValue(this.params.event_tags_json, \'__zbx_jira_issuekey\', true);\r\n	this.sendRequest(\'PUT\', \'/rest/api/latest/issue/\' + encodeURIComponent(jira_issue_key) + \'?returnIssue=true\', this.addCustomFields(data));\r\n	this.commentIssue(jira_issue_key);\r\n\r\n	return this.result;\r\n}\r\n\r\nJira.prototype.onResolve = function (alert) {\r\n	return this.onUpdate(alert, true);\r\n}\r\n\r\nJira.prototype.onDiscovery = function (alert) {\r\n	this.priority = this.params.jira_priority_discovery;\r\n	return this.onProblem(alert);\r\n}\r\n\r\nJira.prototype.onAutoreg = function (alert) {\r\n	this.priority = this.params.jira_priority_autoregistration;\r\n	return this.onProblem(alert);\r\n}\r\n\r\ntry {\r\n	var hook = new Jira(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/jira\r\n\r\n1. To make this integration work, you will need the following from Jira:\r\n  * Jira instance URL;\r\n  * Jira project key and issue type that the issues created by Zabbix will use;\r\n  * Jira username and password or API token. API token is strongly recommended and can be obtained at https://id.atlassian.com/manage/api-tokens.\r\n2. In the Zabbix web interface, go to Administration → Macros section. Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend.\r\n3. On this page replace the placeholder \'<...>\' values with the ones from the step #1.\r\n4. In Zabbix, you need to have a Zabbix user and add Media with the Jira media type. Make sure this user has access to all hosts for which you would like problem issues to be created in Jira.','0'),
('79','4','Jira Service Management','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nvar ZABBIX_SEVERITY_MAP = ["not_classified", "information", "warning", "average", "high", "disaster"];\r\n\r\nvar serviceLogName = \'Jira Service Management Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	Jira = CWebhook;\r\n\r\nJira.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		jira_url: { type: \'string\', url: true},\r\n		jira_user: { type: \'string\' },\r\n		jira_password: { type: \'string\' },\r\n		jira_request_type_id: { type: \'string\' },\r\n		jira_servicedesk_id: { type: \'string\' },\r\n		issue_comments_public: {type: \'boolean\', default: false},\r\n		event_source: { type: \'string\' },\r\n		alert_subject: { type: \'string\' },\r\n		alert_message: { type: \'string\' },\r\n		event_nseverity: { type: \'integer\', default: 0 }\r\n	}, this.params);\r\n\r\n	this.priority = this.params.event_source == 3 ? this.params.jira_priority_internal : this.params[\'severity_\' + ZABBIX_SEVERITY_MAP[this.params.event_nseverity]];\r\n	this.params.event_tags_json = parseTags(this.params.event_tags_json, false);\r\n\r\n	if (this.params.event_tags_json.length > 0) {\r\n		this.labels = setLabels(this.params.event_tags_json);\r\n	}\r\n\r\n	parseOptionalFields();\r\n\r\n	this.result = { tags: {} };\r\n}\r\n\r\nfunction escapeMarkup(str) {\r\n	var length = str.length,\r\n		result = \'\',\r\n		markup = [\'{\', \'|\', \'}\', \'~\', \'_\', \'\\\\\', \'[\', \']\', \'^\', \'<\', \'>\', \'?\', \'!\', \'#\', \'+\', \'*\', \'&\'];\r\n\r\n	for (var i = 0; i < length; i++) {\r\n		var char = str[i];\r\n		result += (markup.indexOf(char) !== -1) ? (\'&#\' + str[i].charCodeAt() + \';\') : char;\r\n	}\r\n\r\n	return result;\r\n}\r\n\r\nfunction parseOptionalFields() {\r\n	this.params.customfields = {};\r\n	this.params.components = [];\r\n\r\n	Object.keys(this.params).forEach(function (key) {\r\n		if (key.startsWith(\'customfield_\')) {\r\n			this.params.customfields[key] = this.params[key];\r\n		}\r\n\r\n		if (key.startsWith(\'component_\')) {\r\n			this.params.components.push({"name": this.params[key]})\r\n		}\r\n	});\r\n}\r\n\r\nJira.prototype.addCustomFields = function (data, requestFieldValues) {\r\n	if (typeof this.params.customfields === \'object\' && Object.keys(this.params.customfields).length) {\r\n		var schemaData = this.sendRequest(\'GET\', \'/rest/api/latest/field\'),\r\n			schema = {};\r\n\r\n		schemaData.forEach(function (item) {\r\n			schema[item.id] = item.schema;\r\n		});\r\n\r\n		var placeholder = (requestFieldValues ? \'requestFieldValues\' : \'fields\');\r\n\r\n		Object.keys(this.params.customfields).forEach(function (field) {\r\n			if (typeof schema[field] === \'object\' && schema[field].type) {\r\n				const type = schema[field].type;\r\n\r\n				if (type === \'number\') {\r\n					data[placeholder][field] = parseInt(this.params.customfields[field]);\r\n				}\r\n				else if (type === \'string\' && schema[field][\'custom\'].split(\':\')[1] === \'url\') {\r\n					if (this.params.customfields[field] === \'zabbix_url\') {\r\n						data[placeholder][field] = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n					} else {\r\n						data[placeholder][field] = this.params.customfields[field];\r\n					}\r\n				}\r\n				else if (type === \'date\') {\r\n					if (this.params.customfields[field].match(/\\d+[.-]\\d+[.-]\\d+/) !== null) {\r\n						data[placeholder][field] = this.params.customfields[field].replace(/\\./g, \'-\');\r\n					}\r\n				}\r\n				else if (type === \'datetime\') {\r\n					if (this.params.customfields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {\r\n						data[placeholder][field] = this.params.customfields[field].replace(/\\./g, \'-\');\r\n					}\r\n				}\r\n				else if (type === \'option\') {\r\n					data[placeholder][field] = { \'value\': this.params.customfields[field] };\r\n				}\r\n				else if (type === \'array\') {\r\n					if (schema[field].items === \'option\') {\r\n						const valuesList = this.params.customfields[field].split(\',\');\r\n						data[placeholder][field] = [];\r\n						valuesList.forEach(function (val) {\r\n							data[placeholder][field].push({\'value\': val})\r\n						});\r\n					}\r\n					else {\r\n						data[placeholder][field] = [this.params.customfields[field]];\r\n					}\r\n				}\r\n				else {\r\n					data[placeholder][field] = this.params.customfields[field];\r\n				}\r\n			}\r\n		});\r\n	}\r\n	else {\r\n		Logger.log(Logger.WARN, \'No customfields found.\');\r\n	}\r\n\r\n	return data;\r\n}\r\n\r\nfunction parseTags(event_tags) {\r\n	try {\r\n		return JSON.parse(event_tags);\r\n	}\r\n	catch (error) {\r\n		if (this.params.event_source == 0 || this.params.event_source > 2) {\r\n			Logger.log(Logger.WARN, \'No event tags were found. Should be an object. Received event tags: "\' + event_tags + \'".\');\r\n		}\r\n		return [];\r\n	}\r\n}\r\n\r\nfunction getTagValue(tags, key, throw_on_fail) {\r\n	for (i in tags) {\r\n		if (tags[i].tag === key) {\r\n			return tags[i].value\r\n		}\r\n	}\r\n\r\n	if (!throw_on_fail) {\r\n		return false;\r\n	} else {\r\n		throw \'Tag "\' + key + \'" is not in the event tag list.\'\r\n	}\r\n};\r\n\r\nfunction setLabels(event_tags_json) {\r\n	var buffer = [];\r\n\r\n	event_tags_json.forEach(function (tag) {\r\n		if (typeof tag.tag !== \'undefined\' && typeof tag.value !== \'undefined\' && !tag.tag.startsWith(\'__zbx\')) {\r\n			label = (tag.tag + (tag.value ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n			if (label.length < 256) {\r\n				buffer.push(label);\r\n			}\r\n		}\r\n	});\r\n\r\n	if (buffer.length === 0) {\r\n		Logger.log(Logger.WARN, \'No labels were set.\');\r\n	}\r\n\r\n	return buffer;\r\n}\r\n\r\nJira.prototype.commentIssue = function (issue_key) {\r\n	var data = {\r\n		body: this.params.alert_message,\r\n		public: this.params.issue_comments_public\r\n	};\r\n	this.sendRequest(\'POST\', \'/rest/servicedeskapi/request/\' + encodeURIComponent(issue_key) + \'/comment\', data);\r\n}\r\n\r\nJira.prototype.sendRequest = function (method, path, data) {\r\n	this.request.clearHeader();\r\n	this.request.addHeaders(\'Authorization: Basic \' + btoa(this.params.jira_user + \':\' + this.params.jira_password));\r\n\r\n	var response = this.request.jsonRequest(method, this.params.jira_url + path, data);\r\n\r\n	if ((this.request.getStatus() !== 200 && this.request.getStatus() !== 201)) {\r\n		Logger.log(Logger.WARN, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.description, \'string\')) {\r\n			throw response.description;\r\n		}\r\n		else {\r\n			Logger.log(Logger.WARN, \'Request not successful. Received response: \' + JSON.stringify(response));\r\n			throw \'Unknown error. Check debug log for more information.\';\r\n		}\r\n	}\r\n\r\n	return response;\r\n}\r\n\r\nJira.prototype.onProblem = function (alert) {\r\n	if (this.params.event_tags_json.length > 0 && getTagValue(this.params.event_tags_json, \'__zbx_jira_requestkey\', false) !== false) {\r\n		return this.onUpdate(alert, true);\r\n	}\r\n\r\n	var data = {\r\n		serviceDeskId: this.params.jira_servicedesk_id,\r\n		requestTypeId: this.params.jira_request_type_id,\r\n		requestFieldValues: {\r\n			summary: this.params.alert_subject,\r\n			description: this.params.alert_message,\r\n			priority: {\r\n				"name": this.priority\r\n			}\r\n		}\r\n	};\r\n\r\n	if (this.labels && this.labels.length > 0) {\r\n		data.requestFieldValues.labels = this.labels;\r\n	}\r\n\r\n	if (this.params.components && this.params.components.length > 0) {\r\n		data.requestFieldValues.components = this.params.components;\r\n	}\r\n\r\n	var response = this.sendRequest(\'POST\', \'/rest/servicedeskapi/request\', this.addCustomFields(data, true));\r\n	this.result.tags = {\r\n		__zbx_jira_requestkey: response.issueKey,\r\n		__zbx_jira_requestlink: this.params.jira_url + \'/browse/\' + response.issueKey\r\n	}\r\n	return this.result;\r\n}\r\n\r\nJira.prototype.onUpdate = function (alert, dontUpdatePriority) {\r\n	var data = {\r\n		fields: {\r\n			summary: this.params.alert_subject,\r\n			priority: {\r\n				"name": this.priority\r\n			}\r\n		}\r\n	};\r\n\r\n	if (dontUpdatePriority && this.params.event_source != 0) {\r\n		delete data[\'fields\'][\'priority\'];\r\n	}\r\n\r\n	var jira_issue_key = getTagValue(this.params.event_tags_json, \'__zbx_jira_requestkey\', true);\r\n	this.sendRequest(\'PUT\', \'/rest/api/latest/issue/\' + encodeURIComponent(jira_issue_key) + \'?returnIssue=true\', this.addCustomFields(data));\r\n	this.commentIssue(jira_issue_key);\r\n\r\n	return this.result;\r\n}\r\n\r\nJira.prototype.onResolve = function (alert) {\r\n	return this.onUpdate(alert, true);\r\n}\r\n\r\nJira.prototype.onDiscovery = function (alert) {\r\n	this.priority = this.params.jira_priority_discovery;\r\n	return this.onProblem(alert);\r\n}\r\n\r\nJira.prototype.onAutoreg = function (alert) {\r\n	this.priority = this.params.jira_priority_autoregistration;\r\n	return this.onProblem(alert);\r\n}\r\n\r\ntry {\r\n	var hook = new Jira(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_jira_requestlink}','Jira Service Management: {EVENT.TAGS.__zbx_jira_requestkey}','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/jira_service_management\r\n\r\n1. To make this integration work, you will need the following from Jira:\r\n  * Jira instance URL;\r\n  * Jira service desk id and request type id that the issues created by Zabbix will use;\r\n  * Jira username and password or API token. API token is strongly recommended and can be obtained at https://id.atlassian.com/manage/api-tokens.\r\n2. In the Zabbix web interface, go to Administration → Macros section. Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend.\r\n3. On this page replace the placeholder \'<...>\' values with the ones from the step #1.\r\n4. In Zabbix, you need to have a Zabbix user and add Media with the Jira Service Management media type. Make sure this user has access to all hosts for which you would like problem issues to be created in Jira.','0'),
('80','4','Line','','','','','','','','25','0','0','0','0','1','3','10s','1','function sendMessage(to, messages, params) {\r\n    var response,\r\n        request = new HttpRequest();\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        request.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    request.addHeader(\'Content-Type: application/json\');\r\n    request.addHeader(\'Authorization: Bearer \' + params.bot_token);\r\n\r\n    response = request.post(\'https://api.line.me/v2/bot/message/push\', JSON.stringify({\r\n        "to": to,\r\n        "messages": messages\r\n    }));\r\n\r\n    if (request.getStatus() !== 200) {\r\n        throw response;\r\n    }\r\n}\r\n\r\nfunction validateParams(params) {\r\n    if (typeof params.bot_token !== \'string\' || params.bot_token.trim() === \'\') {\r\n        throw \'Field "bot_token" cannot be empty\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\') {\r\n        params.event_nseverity = \'0\';\r\n        params.event_severity = \'Not classified\';\r\n        params.event_update_status = \'0\';\r\n    }\r\n\r\n    if (params.event_source === \'1\' || params.event_source === \'2\') {\r\n        params.event_value = \'1\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        throw \'Incorrect "event_nseverity" parameter given: \' + params.event_nseverity + \'\\nMust be 0-5.\';\r\n    }\r\n\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (isNaN(params.trigger_id) && params.event_source === \'0\') {\r\n        throw \'field "trigger_id" is not a number\';\r\n    }\r\n\r\n    if (typeof params.zabbix_url !== \'string\' || params.zabbix_url.trim() === \'\') {\r\n        throw \'Field "zabbix_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.zabbix_url)) {\r\n        throw \'Field "zabbix_url" must contain a schema\';\r\n    }\r\n}\r\n\r\nfunction getZabbixProblemLink(params) {\r\n    return params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') + \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id;    \r\n}\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    validateParams(params);\r\n\r\n    severity_emoji = [\r\n        "\\u26AA",\r\n        "\\uD83D\\uDD35",\r\n        "\\uD83D\\uDFE4",\r\n        "\\uD83D\\uDFE1",\r\n        "\\uD83D\\uDFE0",\r\n        "\\uD83D\\uDD34",\r\n    ];\r\n\r\n    // If its a trigger and a recovery operation and not an update operation.\r\n    if (params.event_source === \'0\' && params.event_value === \'0\' && params.event_update_status === \'0\') {\r\n        var line_message = [\r\n            {\r\n                "type": "text",\r\n                "text": \'\\u2705 \' + params.alert_subject + \'\\n\\n\' + params.alert_message + \'\\n\' + params.trigger_description + \'\\n\\n\' + getZabbixProblemLink(params)\r\n            }\r\n        ];\r\n    }\r\n    // If its a trigger and its a problem.\r\n    else if (params.event_source === \'0\' && params.event_value === \'1\') {\r\n        var line_message = [\r\n            {\r\n                "type": "text",\r\n                "text": severity_emoji[params.event_nseverity] + \' \' + params.alert_subject + \'\\n\\n\' + params.alert_message + \'\\n\' + params.trigger_description + \'\\n\\n\' + getZabbixProblemLink(params)\r\n            }\r\n        ];\r\n    }\r\n    // If its a trigger and its an update operation.\r\n    else if (params.event_source === \'0\' && params.event_update_status === \'1\') {\r\n        var line_message = [\r\n            {\r\n                "type": "text",\r\n                "text": \'\\u2733 \' + severity_emoji[params.event_nseverity] + \' \' + params.alert_subject + \'\\n\\n\' + params.alert_message + \'\\n\' + params.trigger_description + \'\\n\\n\' + getZabbixProblemLink(params)\r\n            }\r\n        ];\r\n    }\r\n    else {\r\n        var line_message = [\r\n            {\r\n                "type": "text",\r\n                "text": params.alert_subject + \'\\n\\n\' + params.alert_message + \'\\n\'\r\n            }\r\n        ];\r\n    }\r\n\r\n    sendMessage(params.send_to, line_message, params);\r\n\r\n    return \'OK\';\r\n}\r\ncatch (err) {\r\n    Zabbix.log(4, \'[ Line Webhook ] Line notification failed : \' + err);\r\n    throw \'Line notification failed : \' + err;\r\n}','30s','0','0','','','Please refer to setup guide here: https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/line\r\n\r\nSet bot_token parameter to your Line bot token.\r\nWhen assigning Line media to the Zabbix user - add the ID of the target recipient. Use a userId, groupId, or roomId value.','0'),
('81','4','ManageEngine ServiceDesk','','','','','','','','25','0','0','0','0','1','3','10s','1','var MEngine = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        MEngine.params = params;\r\n        if (typeof MEngine.params.url === \'string\') {\r\n            if (!MEngine.params.url.endsWith(\'/\')) {\r\n                MEngine.params.url += \'/\';\r\n            }\r\n\r\n            MEngine.params.url += \'api/v3/\';\r\n        }\r\n\r\n        if (MEngine.params.on_premise.toLowerCase() !== \'true\'\r\n                && typeof MEngine.params.on_demand_url_auth === \'string\') {\r\n            if (!MEngine.params.on_demand_url_auth.endsWith(\'/\')) {\r\n                MEngine.params.on_demand_url_auth += \'/\';\r\n            }\r\n\r\n            MEngine.params.on_demand_url_auth += \'oauth/v2/token?\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        MEngine.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    createLink: function (id, url) {\r\n        return url + (url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            ((MEngine.params.on_premise.toLowerCase() === \'true\')\r\n                ? (\'WorkOrder.do?woMode=viewWO&woID=\' + id)\r\n                : (\'app/itdesk/ui/requests/\' + id + \'/details\')\r\n            );\r\n    },\r\n\r\n    refreshAccessToken: function () {\r\n        [\r\n            \'on_demand_url_auth\',\r\n            \'on_demand_refresh_token\',\r\n            \'on_demand_client_id\',\r\n            \'on_demand_client_secret\'\r\n        ].forEach(function (field) {\r\n            if (typeof MEngine.params !== \'object\' || typeof MEngine.params[field] === \'undefined\'\r\n                    || MEngine.params[field].trim() === \'\' ) {\r\n                throw \'Required MEngine param is not set: "sd_\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            request = new HttpRequest(),\r\n            url = MEngine.params.on_demand_url_auth +\r\n                \'refresh_token=\' + encodeURIComponent(MEngine.params.on_demand_refresh_token) +\r\n                \'&grant_type=refresh_token&client_id=\' + encodeURIComponent(MEngine.params.on_demand_client_id) +\r\n                \'&client_secret=\' + encodeURIComponent(MEngine.params.on_demand_client_secret) +\r\n                \'&redirect_uri=https://www.zoho.com&scope=SDPOnDemand.requests.ALL\';\r\n\r\n        if (MEngine.HTTPProxy) {\r\n            request.setProxy(MEngine.HTTPProxy);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ ManageEngine Webhook ] Refreshing access token. Request: \' + url);\r\n\r\n        response = request.post(url);\r\n\r\n        Zabbix.log(4, \'[ ManageEngine Webhook ] Received response with status code \' +\r\n        request.getStatus() + \'\\n\' + response);\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.log(4, \'[ ManageEngine Webhook ] Failed to parse response received from Zoho Accounts\');\r\n        }\r\n\r\n        if ((request.getStatus() < 200 || request.getStatus() >= 300) && !response.access_token) {\r\n            throw \'Access token refresh failed with HTTP status code \' + request.getStatus() +\r\n                \'. Check debug log for more information.\';\r\n        }\r\n        else {\r\n            MEngine.params.on_demand_auth_token = response.access_token;\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        var response,\r\n            url = MEngine.params.url + query,\r\n            input,\r\n            request = new HttpRequest(),\r\n            message;\r\n\r\n        if (MEngine.params.on_premise.toLowerCase() === \'true\') {\r\n            request.addHeader(\'TECHNICIAN_KEY: \' + MEngine.params.on_premise_auth_token);\r\n        }\r\n        else {\r\n            request.addHeader(\'Authorization: Zoho-oauthtoken \' + MEngine.params.on_demand_auth_token);\r\n            request.addHeader(\'Accept: application/v3+json\');\r\n        }\r\n\r\n        if (MEngine.HTTPProxy) {\r\n            request.setProxy(MEngine.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        input = \'input_data=\' + encodeURIComponent(data);\r\n        Zabbix.log(4, \'[ ManageEngine Webhook ] Sending request: \' + url + \'?\' + input);\r\n\r\n        switch (method) {\r\n            case \'post\':\r\n                response = request.post(url, input);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, input);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ ManageEngine Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.log(4, \'[ ManageEngine Webhook ] Failed to parse response received from ManageEngine\');\r\n        }\r\n\r\n        if ((request.getStatus() < 200 || request.getStatus() >= 300)\r\n                && typeof response.response_status !== \'object\') {\r\n            throw \'Request failed with HTTP status code \' + request.getStatus() +\r\n                \'. Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.response_status === \'object\' && response.response_status.status === \'failed\') {\r\n            message = \'Request failed with status_code \';\r\n\r\n            if (typeof response.response_status.messages === \'object\'\r\n                    && response.response_status.messages[0]\r\n                    && response.response_status.messages[0].message) {\r\n                message += response.response_status.messages[0].status_code +\r\n                    \'. Message: \' + response.response_status.messages[0].message;\r\n            }\r\n            else {\r\n                message += response.response_status.status_code;\r\n            }\r\n\r\n            message += \'. Check debug log for more information.\';\r\n            throw message;\r\n        }\r\n        else if (response.request) {\r\n            return response.request.id;\r\n        }\r\n    },\r\n\r\n    createPaylaod: function (fields, isNote) {\r\n        var data = {},\r\n            result;\r\n\r\n        if (isNote) {\r\n            data.description = fields[\'field_string:description\'].replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n            result = {request_note: data};\r\n        }\r\n        else {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (fields[field].trim() === \'\') {\r\n                        Zabbix.log(4, \'[ ManageEngine Webhook ] Field "\' + field +\r\n                            \'" can\\\'t be empty. The field ignored.\');\r\n                    }\r\n                    else {\r\n                        try {\r\n                            var prefix = field.split(\':\')[0],\r\n                                root;\r\n\r\n                            if  (prefix.startsWith(\'udf_\') && !data.udf_fields) {\r\n                                data.udf_fields = {};\r\n                                root = data.udf_fields;\r\n                            }\r\n                            else if (prefix.startsWith(\'udf_\')) {\r\n                                root = data.udf_fields;\r\n                            }\r\n                            else {\r\n                                root = data;\r\n                            }\r\n\r\n                            if (prefix.endsWith(\'string\')) {\r\n                                root[field.substring(field.indexOf(\':\') + 1)\r\n                                    .toLowerCase()] = fields[field];\r\n                            }\r\n                            else {\r\n                                root[field.substring(field.indexOf(\':\') + 1)\r\n                                    .toLowerCase()] = {\r\n                                    name: fields[field]\r\n                                };\r\n                            }\r\n                        }\r\n                        catch (error) {\r\n                            Zabbix.log(4, \'[ ManageEngine Webhook ] Can\\\'t parse field "\' + field +\r\n                                \'". The field ignored.\');\r\n                        }\r\n                    }\r\n                });\r\n            if (data.description) {\r\n                data.description = data.description.replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n            }\r\n\r\n            result = {request: data};\r\n        }\r\n\r\n        return result;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        sd = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'sd_on_premise\', \'field_string:subject\', \'field_string:description\',\r\n            \'event_recovery_value\', \'event_source\', \'event_value\', \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'sd_\')) {\r\n                sd[key.substring(3)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'field_\') || key.startsWith(\'udf_field_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (params.event_update_status === \'1\' && (typeof params.sd_request_id === \'undefined\'\r\n            || params.sd_request_id.trim() === \'\'\r\n            || params.sd_request_id === \'{EVENT.TAGS.__zbx_sd_request_id}\'\r\n            || params.sd_request_id === \'*UNKNOWN*\')) {\r\n        throw \'Parameter "sd_request_id" can\\\'t be empty for update operation.\';\r\n    }\r\n\r\n    MEngine.setParams(sd);\r\n    MEngine.setProxy(params.HTTPProxy);\r\n\r\n    if (MEngine.params.on_premise.toLowerCase() !== \'true\') {\r\n        MEngine.refreshAccessToken();\r\n    }\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        fields[\'field_object:priority\'] = params[\'priority_\' + severities[params.event_nseverity].name]\r\n        || \'Normal\';\r\n\r\n        MEngine.request(\'post\', \'requests\', MEngine.createPaylaod(fields));\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\') {\r\n        fields[\'field_object:priority\'] = params[\'priority_\' + severities[params.event_nseverity].name]\r\n        || \'Normal\';\r\n\r\n        var id = MEngine.request(\'post\', \'requests\', MEngine.createPaylaod(fields));\r\n\r\n        result.tags.__zbx_sd_request_id = id;\r\n        result.tags.__zbx_sd_request_link = MEngine.createLink(id, params.sd_url);\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (params.event_update_status === \'1\') {\r\n            MEngine.request(\'post\', \'requests/\' + params.sd_request_id + \'/notes\',\r\n                MEngine.createPaylaod(fields, true)\r\n            );\r\n        }\r\n        delete fields[\'field_string:description\'];\r\n        MEngine.request(\'put\', \'requests/\' + params.sd_request_id, MEngine.createPaylaod(fields));\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ ManageEngine Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_sd_request_link}','ManageEngine: {EVENT.TAGS.__zbx_sd_request_id}','','0'),
('82','4','MantisBT','','','','','','','','25','0','0','0','0','1','1','10s','1','var Mantisbt = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n        Mantisbt.params = params;\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Mantisbt.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    checkUrlFormat: function (url) {\r\n        if (typeof url === \'string\' && !url.endsWith(\'/\')) {\r\n            url += \'/\';\r\n        }\r\n\r\n        if (url.indexOf(\'http://\') === -1 && url.indexOf(\'https://\') === -1) {\r\n            url = \'https://\' + url;\r\n        }\r\n\r\n        return url;\r\n    },\r\n\r\n    getProblemURL: function (zabbix_url, triggerid, eventid, event_source) {\r\n        var problem_url = zabbix_url;\r\n\r\n        if (event_source === \'0\') {\r\n            problem_url += \'tr_events.php?triggerid=\' + triggerid + \'&eventid=\' + eventid;\r\n        }\r\n\r\n        return problem_url;\r\n    },\r\n\r\n    request: function (method, url, data) {\r\n        [\'token\', \'url\', \'category\'].forEach(function (field) {\r\n            if (typeof Mantisbt.params !== \'object\' || typeof Mantisbt.params[field] === \'undefined\' || Mantisbt.params[field] === \'\') {\r\n                throw \'Required MantisBT param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: \' + Mantisbt.params.token);\r\n\r\n        if (typeof Mantisbt.HTTPProxy !== \'undefined\' && Mantisbt.HTTPProxy !== \'\') {\r\n            request.setProxy(Mantisbt.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ MantisBT Webhook ] Sending request: \' + url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'patch\':\r\n                response = request.patch(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ MantisBT Webhook ] Received response with status code \' + request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ MantisBT Webhook ] Failed to parse the response received from MantisBT\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (typeof response !== \'object\') {\r\n            throw \'Failed to process the response received from MantisBT. Check debug log for more information.\';\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (typeof response.message !== \'undefined\') {\r\n                message += \': \' + response.message;\r\n            }\r\n\r\n            throw message;\r\n        }\r\n\r\n        return response;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        mantisbt = {},\r\n        url = \'\',\r\n        data = {},\r\n        result = { tags: {} },\r\n        required_params = [\r\n            \'alert_subject\', \'alert_message\', \'event_source\', \'event_value\', \'event_update_action\',\r\n            \'event_update_status\', \'event_recovery_value\', \'event_nseverity\', \'event_tagsjson\',\r\n            \'event_id\', \'trigger_id\', \'zabbix_url\', \'alert_sendto\',\r\n            \'mantisbt_token\', \'mantisbt_url\', \'mantisbt_category\', \'mantisbt_issue_number\', \'mantisbt_use_zabbix_tags\'\r\n        ],\r\n        method,\r\n        severities = [\'none\', \'low\', \'normal\', \'high\', \'urgent\', \'immediate\'];\r\n\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'mantisbt_\')) {\r\n                mantisbt[key.substring(9)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\' && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported for trigger-based actions only.\';\r\n    }\r\n\r\n    if (typeof params.zabbix_url !== \'string\' || params.zabbix_url.trim() === \'\' || params.zabbix_url === \'{$ZABBIX.URL}\') {\r\n        throw \'Field "zabbix_url" cannot be empty.\';\r\n    }\r\n\r\n    // Check for backslash in the end of url and schema.\r\n    mantisbt.url = Mantisbt.checkUrlFormat(mantisbt.url);\r\n    params.zabbix_url = Mantisbt.checkUrlFormat(params.zabbix_url);\r\n\r\n    // In case of resolve event.\r\n    if (params.event_source === \'0\' && params.event_value === \'0\') {\r\n        method = "patch";\r\n        url = mantisbt.url + \'api/rest/issues/\' + mantisbt.issue_number;\r\n        data = {\r\n            summary: params.alert_subject,\r\n            status: {\r\n                name: "resolved"\r\n            }\r\n        };\r\n        if (/commented/.test(params.event_update_action)) {\r\n            data.additional_information = params.event_update_message;\r\n        }\r\n        process_tags = false;\r\n    }\r\n    // In case of update event.\r\n    else if (params.event_source === \'0\' && params.event_update_status === \'1\') {\r\n        method = "patch";\r\n        url = mantisbt.url + \'api/rest/issues/\' + mantisbt.issue_number;\r\n        data = {\r\n            status: {},\r\n            priority: {\r\n                name: severities[parseInt(params.event_nseverity, 10)]\r\n            }\r\n        };\r\n        if (/commented/.test(params.event_update_action)) {\r\n            data.additional_information = params.event_update_message;\r\n        }\r\n        if (/acknowledged/.test(params.event_update_action)) {\r\n            data.status.name = "acknowledged";\r\n        }\r\n        if (/unacknowledged/.test(params.event_update_action)) {\r\n            data.status.name = "new";\r\n        }\r\n        process_tags = false;\r\n    }\r\n    else {\r\n        method = \'post\';\r\n        url = mantisbt.url + \'api/rest/issues\';\r\n\r\n        data = {\r\n            summary: params.alert_subject,\r\n            description: params.alert_message,\r\n            project: { name: params.alert_sendto },\r\n            category: { name: mantisbt.category },\r\n            priority: {\r\n                name: parseInt(params.event_nseverity, 10) ? severities[parseInt(params.event_nseverity, 10)] : "none"\r\n            }\r\n        };\r\n        if (params.event_source === \'0\') {\r\n            problem_url = Mantisbt.getProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source);\r\n            data.description += \'\\n\' + problem_url;\r\n\r\n            if (mantisbt.use_zabbix_tags === "true") {\r\n                var alert_tags = JSON.parse(params.event_tagsjson);\r\n                data.tags = alert_tags.map(function (t) { return { name: t.value ? (t.tag + \': \' + t.value) : t.tag }; });\r\n            }\r\n        }\r\n        process_tags = true;\r\n    }\r\n\r\n    Mantisbt.setParams(mantisbt);\r\n    Mantisbt.setProxy(params.HTTPProxy);\r\n\r\n    var response = Mantisbt.request(method, url, data);\r\n\r\n    if (process_tags) {\r\n        result.tags.__zbx_mantisbt_issue_number = response.issue.id;\r\n        result.tags.__zbx_mantisbt_link = mantisbt.url + \'view.php?id=\' + response.issue.id;\r\n    }\r\n\r\n    Zabbix.log(4, \'[ MantisBT Webhook ] Result: \' + JSON.stringify(result));\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(4, \'[ MantisBT Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_mantisbt_link}','MantisBT: Issue ID {EVENT.TAGS.__zbx_mantisbt_issue_number}','','0'),
('83','4','Mattermost','','','','','','','','25','0','0','0','0','1','1','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', \'#7499FF\', \'#FFC859\',\r\n    \'#FFA059\', \'#E97659\', \'#E45959\'\r\n];\r\n\r\nvar RESOLVE_COLOR = \'#009900\';\r\n\r\nvar SEND_MODE_HANDLERS = {\r\n    alarm: handlerAlarm,\r\n    event: handlerEvent\r\n};\r\n\r\nif (!String.prototype.format) {\r\n    String.prototype.format = function() {\r\n        var args = arguments;\r\n\r\n        return this.replace(/{(\\d+)}/g, function(match, number) {\r\n            return number in args\r\n                ? args[number]\r\n                : match\r\n            ;\r\n        });\r\n    };\r\n}\r\n\r\nfunction isEventProblem(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 0\r\n    ;\r\n}\r\n\r\nfunction isEventUpdate(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 1\r\n    ;\r\n}\r\n\r\nfunction isEventResolve(params) {\r\n    return params.event_value == 0;\r\n}\r\n\r\nfunction getPermalink(mattermost_url, team_name, postid) {\r\n    return \'{0}/{1}/pl/{2}\'.format(\r\n        mattermost_url.replace(/\\/+$/, \'\'),\r\n        team_name,\r\n        postid\r\n    );\r\n}\r\n\r\nfunction getChannel(send_to) {\r\n    switch (true) {\r\n        case /.+\\/#.+/.test(send_to):\r\n            return getChannelByName(send_to);\r\n\r\n        case /@.+/.test(send_to):\r\n            return getDirectChannel(send_to);\r\n\r\n        default:\r\n            return getChannelByID(send_to);\r\n    }\r\n}\r\n\r\nfunction getChannelByName(send_to) {\r\n    var team_chan = send_to\r\n        .trim()\r\n        .split(\'/#\');\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.channel_byname.format(team_chan[0], team_chan[1]),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getDirectChannel(send_to) {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var teamUser = send_to\r\n            .trim()\r\n            .split(\'/@\'),\r\n        bot = getBotUser(),\r\n        user = getUserByName(teamUser[1]);\r\n\r\n    var resp = JSON.parse(req.post(\r\n        Mattermost.direct_channel,\r\n        JSON.stringify([bot.id, user.id])\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 201) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    resp.team_name = teamUser[0];\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getChannelByID(channelID) {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.get_channel.format(channelID),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getBotUser() {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.bot_user,\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getUserByName(userName) {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.user_byname.format(userName),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getTeamByID(teamID) {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.get_team.format(teamID),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction createProblemURL(zabbix_url, triggerid, eventid, event_source) {\r\n    var problem_url = \'\';\r\n    if (event_source === \'0\') {\r\n        problem_url = \'{0}/tr_events.php?triggerid={1}&eventid={2}\'\r\n            .format(\r\n                zabbix_url,\r\n                triggerid,\r\n                eventid\r\n            );\r\n    }\r\n    else {\r\n        problem_url = zabbix_url;\r\n    }\r\n\r\n    return problem_url;\r\n}\r\n\r\nfunction getTagValue(event_tags, key) {\r\n    var pattern = new RegExp(\'(\' + key + \':.+)\');\r\n    var tagValue = event_tags\r\n        .split(\',\')\r\n        .filter(function (v) {\r\n            return v.match(pattern);\r\n        })\r\n        .map(function (v) {\r\n            return v.split(\':\')[1];\r\n        })[0]\r\n        || 0;\r\n\r\n    return tagValue;\r\n}\r\n\r\nfunction handlerAlarm(req, params) {\r\n    var channel = getChannel(params.send_to);\r\n    var fields = {\r\n        channel_id: channel.id,\r\n        props: {}\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        var team_name = channel.team_name\r\n            ? channel.team_name\r\n            : getTeamByID(channel.team_id).name;\r\n\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.post(\r\n            Mattermost.post_message,\r\n            JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n        result.tags.__mattermost_post_id = resp.id;\r\n        result.tags.__mattermost_channel_id = channel.id;\r\n        result.tags.__mattermost_channel_name = channel.name;\r\n        result.tags.__mattermost_message_link = getPermalink(\r\n            params.mattermost_url,\r\n            team_name,\r\n            resp.id\r\n        );\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.root_id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n\r\n        if (params.event_source === \'0\') {}\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                true\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.post(\r\n            Mattermost.post_message, JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.channel_id = getTagValue(params.event_tags, \'mattermost_channel_id\');\r\n        fields.id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var post_id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n\r\n        resp = JSON.parse(req.put(\r\n            Mattermost.chat_update.format(post_id),\r\n            JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.getStatus() != 200) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n    }\r\n}\r\n\r\nfunction handlerEvent(req, params) {\r\n    var channel = getChannel(params.send_to);\r\n    var fields = {\r\n        channel_id: channel.id,\r\n        props: {}\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        var team_name = channel.team_name\r\n            ? channel.team_name\r\n            : getTeamByID(channel.team_id).name;\r\n\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n        result.tags.__mattermost_channel_name = channel.name;\r\n        result.tags.__mattermost_message_link = getPermalink(\r\n            params.mattermost_url,\r\n            team_name,\r\n            resp.id\r\n        );\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                false\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_recovery_date,\r\n                params.event_recovery_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n    }\r\n}\r\n\r\nfunction createMessage(\r\n    event_severity_color,\r\n    event_date,\r\n    event_time,\r\n    problem_url,\r\n    isShort\r\n) {\r\n    var message = {\r\n        fallbac: params.alert_subject,\r\n        title: params.alert_subject,\r\n        color: event_severity_color,\r\n        title_link: problem_url,\r\n        footer: problem_url,\r\n\r\n        fields: [\r\n            {\r\n                title: \'Host\',\r\n                value: \'{0} [{1}]\'.format(params.host_name, params.host_ip),\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Event time\',\r\n                value: \'{0} {1}\'.format(event_date, event_time),\r\n                short: true\r\n            }\r\n        ],\r\n    };\r\n\r\n    \r\n    if (params.event_source === \'0\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Severity\',\r\n                value: params.event_severity,\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Opdata\',\r\n                value: params.event_opdata,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (!isShort && params.event_source === \'0\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Event tags\',\r\n                value: \'`{0}`\'.format(params.event_tags.replace(/__.+?:(.+?,|.+)/g, \'\') || \'None\'),\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Trigger description\',\r\n                value: params.trigger_description,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (params.event_source !== \'0\' || params.event_update_status === \'1\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Details\',\r\n                value: params.alert_message,\r\n                short: false\r\n            }\r\n        );\r\n    }\r\n\r\n    return message;\r\n}\r\n\r\nfunction validateParams(params) {\r\n    if (typeof params.bot_token !== \'string\' || params.bot_token.trim() === \'\') {\r\n        throw \'Field "bot_token" cannot be empty\';\r\n    }\r\n\r\n    if (isNaN(params.event_id)) {\r\n        throw \'Field "event_id" is not a number\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\') {\r\n        params.event_nseverity = \'0\';\r\n        params.event_severity = \'Not classified\';\r\n        params.event_update_status = \'0\';\r\n        params.send_mode = \'event\';\r\n    }\r\n\r\n    if (params.event_source === \'1\' || params.event_source === \'2\') {\r\n        params.event_value = \'1\';\r\n    }\r\n\r\n    if (params.event_source === \'1\') {\r\n        params.host_name = params.discovery_host_dns;\r\n        params.host_ip = params.discovery_host_ip;\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        throw \'Incorrect "event_nseverity" parameter given: \' + params.event_nseverity + \'\\nMust be 0-5.\';\r\n    }\r\n\r\n    if (typeof params.event_severity !== \'string\' || params.event_severity.trim() === \'\') {\r\n        throw \'Field "event_severity" cannot be empty\';\r\n    }\r\n\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (typeof params.host_ip !== \'string\' || params.host_ip.trim() === \'\') {\r\n        throw \'Field "host_ip" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.host_name !== \'string\' || params.host_name.trim() === \'\') {\r\n        throw \'Field "host_name" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.mattermost_url !== \'string\' || params.mattermost_url.trim() === \'\') {\r\n        throw \'Field "mattermost_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.mattermost_url)) {\r\n        throw \'Field "mattermost_url" must contain a schema\';\r\n    }\r\n\r\n    if ([\'alarm\', \'event\'].indexOf(params.send_mode) === -1) {\r\n        throw \'Incorrect "send_mode" parameter given: \' + params.send_mode + \'\\nMust be "alarm" or "event".\';\r\n    }\r\n\r\n    if (typeof params.send_to !== \'string\' || params.send_to.trim() === \'\') {\r\n        throw \'Field "send_to" cannot be empty\';\r\n    }\r\n\r\n    if (isNaN(params.trigger_id) && params.event_source === \'0\') {\r\n        throw \'field "trigger_id" is not a number\';\r\n    }\r\n\r\n    if (typeof params.zabbix_url !== \'string\' || params.zabbix_url.trim() === \'\') {\r\n        throw \'Field "zabbix_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.zabbix_url)) {\r\n        throw \'Field "zabbix_url" must contain a schema\';\r\n    }\r\n\r\n}\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    validateParams(params);\r\n\r\n    var req = new HttpRequest(),\r\n        fields = {},\r\n        result = {tags: {}};\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    req.addHeader(\'Content-Type: application/json; charset=utf-8\');\r\n    req.addHeader(\'Authorization: Bearer \' + params.bot_token);\r\n\r\n    params.mattermost_url = params.mattermost_url.replace(/\\/+$/, \'\');\r\n    params.zabbix_url = params.zabbix_url.replace(/\\/+$/, \'\');\r\n\r\n    var APIEndpoint = params.mattermost_url + \'/api/v4/\';\r\n\r\n    var Mattermost = {\r\n        post_message: APIEndpoint + \'posts\',\r\n        get_channel: APIEndpoint + \'channels/{0}\',\r\n        get_team: APIEndpoint + \'teams/{0}\',\r\n        chat_update: APIEndpoint + \'posts/{0}\',\r\n        direct_channel: APIEndpoint + \'channels/direct\',\r\n        channel_byname: APIEndpoint + \'teams/name/{0}/channels/name/{1}\',\r\n        user_byname: APIEndpoint + \'users/username/{0}\',\r\n        bot_user: APIEndpoint + \'users/me\'\r\n\r\n    };\r\n\r\n    params.send_mode = params.send_mode.toLowerCase();\r\n    params.send_mode = params.send_mode in SEND_MODE_HANDLERS\r\n        ? params.send_mode\r\n        : \'alarm\';\r\n\r\n    SEND_MODE_HANDLERS[params.send_mode](req, params);\r\n\r\n    if (params.event_source === \'0\') {\r\n        return JSON.stringify(result);\r\n    }\r\n    else {\r\n        return \'OK\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.log(4, \'[ Mattermost Webhook ] Mattermost notification failed: \' + error);\r\n    throw \'Mattermost notification failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__mattermost_message_link}','Open in Mattermost: {EVENT.TAGS.__mattermost_channel_name}','','0'),
('84','4','MS Teams','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nvar SEVERITY_COLORS = [\r\n	\'#97AAB3\',\r\n	\'#7499FF\',\r\n	\'#FFC859\',\r\n	\'#FFA059\',\r\n	\'#E97659\',\r\n	\'#E45959\',\r\n	\'#009900\',\r\n	\'#1F1F1F\'\r\n],\r\n	serviceLogName = \'MS Teams Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	MSTeams = CWebhook;\r\n\r\nMSTeams.prototype.addBodyFact = function (name, value) {\r\n	if (!CParamValidator.isDefined(this.data.sections[0].facts)) {\r\n		this.data.sections[0].facts = [];\r\n	}\r\n	this.data.sections[0].facts.push({name: name, value: value});\r\n}\r\n\r\nMSTeams.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({teams_endpoint: {type: \'string\'}, event_source: {type: \'string\'}, alert_subject: {type: \'string\'},\r\n		alert_message: {type: \'string\'}, host_ip: {type: \'string\', default: \'\'}, zabbix_url: {type: \'string\', url: true},\r\n		use_default_message: {type: \'boolean\', default: false}, event_nseverity: {type: \'integer\', default: 7}}, this.params);\r\n	var actionName = \'Zabbix Home\';\r\n	if (!CParamValidator.inArray(this.params.event_source, [\'0\',\'3\',\'4\'])\r\n		|| this.params.alert_message.startsWith("NOTE: Escalation canceled:")) {\r\n		this.params[\'use_default_message\'] = true;\r\n	}\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({event_id: {type: \'integer\'}, trigger_id: {type: \'integer\'}}, this.params);\r\n		actionName = \'Event Info\';\r\n	}\r\n	var actionURL = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n	if (this.params.event_value === \'0\') {\r\n		this.params.event_nseverity = 6;\r\n	}\r\n	this.data = {\r\n		themeColor: SEVERITY_COLORS[this.params.event_nseverity].replace(\'#\', \'\'),\r\n		summary: this.params.alert_subject,\r\n		sections: [{\r\n			markdown: \'false\',\r\n			activityTitle: this.params.alert_subject,\r\n			text: (this.params.event_source === \'0\' && !this.params.use_default_message) ? this.params.trigger_description : this.params.alert_message\r\n		}],\r\n		potentialAction: [{\r\n			\'@type\': \'OpenUri\',\r\n			name: actionName,\r\n			targets: [{\r\n				os: \'default\',\r\n				uri: actionURL\r\n			}]\r\n		}]\r\n	};\r\n};\r\n\r\nMSTeams.prototype.makeUpDefaultMessage = function () {\r\n	if (!this.params.use_default_message) {\r\n		if (!CParamValidator.isEmpty(this.params.host_name) && CParamValidator.isMacroSet(this.params.host_name, \'HOST.NAME\')) {\r\n			this.addBodyFact(\'Host\', this.params.host_name + ((!CParamValidator.isEmpty(this.params.host_ip)) ? \' [\' + this.params.host_ip + \']\' : \'\'));\r\n		}\r\n		if (!CParamValidator.isEmpty(this.params.event_severity) && CParamValidator.isMacroSet(this.params.event_severity, \'EVENT.SEVERITY\')) {\r\n			this.addBodyFact(\'Severity\', this.params.event_severity);\r\n		}\r\n		if (!CParamValidator.isEmpty(this.params.event_opdata) && CParamValidator.isMacroSet(this.params.event_opdata, \'EVENT.OPDATA\')) {\r\n			this.addBodyFact(\'Operational data\', this.params.event_opdata);\r\n		}\r\n		if (!CParamValidator.isEmpty(this.params.event_tags) && CParamValidator.isMacroSet(this.params.event_tags, \'EVENT.TAGS\')) {\r\n			this.addBodyFact(\'Event tags\', this.params.event_tags);\r\n		}\r\n\r\n		Object.keys(this.params).forEach(function (key) {\r\n			if (key.startsWith(\'fact_\') && this.params[key] !== \'\') {\r\n				this.addBodyFact(key.substring(5), this.params[key]);\r\n			}\r\n			else if (key.startsWith(\'openUri_\') && this.params[key] !== \'\' && !this.params[key].startsWith(\'{\')) {\r\n				this.data.potentialAction.push({\r\n					\'@type\': \'OpenUri\',\r\n					name: key.substring(8),\r\n					targets: [{\r\n						os: \'default\',\r\n						uri: this.params[key]\r\n					}]\r\n				});\r\n			}\r\n		});\r\n	}\r\n}\r\n\r\nconst htmlMultiline = function (text) {\r\n	return text.replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n}\r\n\r\nMSTeams.prototype.sendRequest = function () {\r\n	this.request.addHeaders({"Content-Type": "application/json"});\r\n	var response = this.request.plainRequest(\'POST\', this.params.teams_endpoint, JSON.stringify(this.data));\r\n\r\n	if (response !== \'1\') {\r\n		Logger.log(Logger.WARN, \'FAILED with response: \' + response);\r\n		throw response;\r\n	}\r\n	return \'OK\';\r\n};\r\n\r\nMSTeams.prototype.onProblem = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	if (!this.params.use_default_message) {\r\n		this.addBodyFact(\'Event time\', this.params.event_time + \' \' + this.params.event_date);\r\n		this.makeUpDefaultMessage();\r\n	}\r\n	this.data.sections[0].text = htmlMultiline(this.data.sections[0].text);\r\n\r\n	return this.sendRequest();\r\n}\r\n\r\nMSTeams.prototype.onUpdate = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	if (!this.params.use_default_message) {\r\n		this.data.sections[0].text = this.params.event_update_user + \' \' + this.params.event_update_action + \'.\';\r\n		if (this.params.event_update_message) {\r\n			this.data.sections[0].text += \'<br>Message:<br>\' + this.params.event_update_message;\r\n		}\r\n		this.addBodyFact(\'Event update time\', this.params.event_update_time + \' \' + this.params.event_update_date);\r\n		this.makeUpDefaultMessage();\r\n	}\r\n	this.data.sections[0].text = htmlMultiline(this.data.sections[0].text);\r\n\r\n	return this.sendRequest();\r\n}\r\n\r\nMSTeams.prototype.onResolve = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	if (!this.params.use_default_message) {\r\n		this.addBodyFact(\'Recovery time\', this.params.event_recovery_time + \' \' + this.params.event_recovery_date);\r\n		this.makeUpDefaultMessage();\r\n	}\r\n	this.data.sections[0].text = htmlMultiline(this.data.sections[0].text);\r\n\r\n	return this.sendRequest();\r\n}\r\n\r\nMSTeams.prototype.onDiscovery = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\nMSTeams.prototype.onAutoreg = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\ntry {\r\n	var hook = new MSTeams(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/msteams\r\n\r\n1. Add official Zabbix webhook connector from MS Teams apps for the channel, where you want to receive notifications.\r\n2. Create Incoming webhook for your channel.\r\n3. In the Zabbix web interface go to Administration → Macros section. Setup the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend. \r\n4. On this page replace placeholder <PLACE WEBHOOK URL HERE> with the incoming webhook URL, created during the webhook setup in MS Teams.\r\n5. To receive Zabbix notifications in MS Teams, you need to create a Zabbix user and add Media with the MS Teams media type. Make sure this user has access to all hosts for which you would like problem notifications to be sent to MS Teams.','0'),
('85','4','MS Teams Workflow','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\n\r\nvar serviceLogName = \'MS Teams Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	MSTeams = CWebhook;\r\n\r\nMSTeams.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		alert_subject: { type: \'string\' }, alert_message: { type: \'string\' },\r\n		zabbix_url: { type: \'string\', url: true }, teams_endpoint: { type: \'string\', url: true }\r\n	}, this.params);\r\n\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({ event_id: { type: \'integer\' }, trigger_id: { type: \'integer\' } }, this.params);\r\n	}\r\n\r\n	this.body = {\r\n		type: "message",\r\n		attachments: [\r\n			{\r\n				contentType: "application/vnd.microsoft.card.adaptive",\r\n				contentUrl: null,\r\n				content: {\r\n					$schema: "http://adaptivecards.io/schemas/adaptive-card.json",\r\n					type: "AdaptiveCard",\r\n					version: "1.4",\r\n					body: [\r\n						{\r\n							type: "Container",\r\n							items: [\r\n								{\r\n									type: "TextBlock",\r\n									size: "Medium",\r\n									wrap: "true",\r\n									weight: "Bolder",\r\n									text: this.params.alert_subject\r\n								}\r\n							],\r\n							style: "",\r\n							bleed: true\r\n						}\r\n					],\r\n					actions: [\r\n						{\r\n							type: "Action.OpenUrl",\r\n							title: "Event info",\r\n							url: CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id)\r\n						}\r\n					]\r\n				}\r\n			}\r\n		]\r\n	};\r\n\r\n	this.params.alert_message = this.params.alert_message.split(\'\\n\');\r\n\r\n	for (line in this.params.alert_message) {\r\n		this.body.attachments[0].content.body.push({\r\n			type: "TextBlock",\r\n			wrap: "true",\r\n			text: this.params.alert_message[line]\r\n		});\r\n	}\r\n\r\n};\r\n\r\nMSTeams.prototype.sendRequest = function (color) {\r\n	this.body.attachments[0].content.body[0].style = color;\r\n\r\n	this.request.addHeaders({ "Content-Type": "application/json" });\r\n	var response = this.request.plainRequest(\'POST\', this.params.teams_endpoint, JSON.stringify(this.body));\r\n\r\n	if (this.request.getStatus() !== 202) {\r\n		Logger.log(Logger.INFO, \'HTTP code: \' + this.request.getStatus() + \'. Endpoint response:\' + response);\r\n		throw \'HTTP code: \' + this.request.getStatus() + \'. Endpoint response:\' + response;\r\n	}\r\n\r\n	return \'OK\';\r\n};\r\n\r\nMSTeams.prototype.onProblem = function () {\r\n	return this.sendRequest("attention");\r\n};\r\n\r\nMSTeams.prototype.onResolve = function () {\r\n	return this.sendRequest("good");\r\n};\r\n\r\nMSTeams.prototype.onUpdate = function () {\r\n	return this.sendRequest("emphasis");\r\n};\r\n\r\nMSTeams.prototype.onDiscovery = function () {\r\n	return this.sendRequest("emphasis");\r\n};\r\n\r\nMSTeams.prototype.onAutoreg = function () {\r\n	return this.sendRequest("emphasis");\r\n};\r\n\r\ntry {\r\n	var hook = new MSTeams(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n};','30s','0','0','','','To set up a webhook, please follow these steps:\r\n\r\n- Create a workflow in MS Teams. You can use the "Post a message in a channel when a webhook request is received" template for it.\r\n- Copy the endpoint URL and place it in the teams_endpoint parameter.\r\n- Set up the global macro {$ZABBIX.URL}, which will contain the URL to the Zabbix frontend.\r\n- Create a Zabbix user and add the MS Teams Workflow media to it.\r\n\r\nFor more detailed instructions, please visit https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/.','0'),
('86','4','Opsgenie','','','','','','','','25','0','0','0','0','1','3','10s','1','var method,\r\n    Media = {\r\n    params: {},\r\n    name: \'\',\r\n    labels: [],\r\n    HTTPProxy: \'\',\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Media.params = params;\r\n        Media.params.api += Media.params.api.endsWith(\'/\') ? \'\' : \'/\';\r\n        Media.params.web += Media.params.web.endsWith(\'/\') ? \'\' : \'/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        if (typeof HTTPProxy !== \'undefined\' && HTTPProxy.trim() !== \'\') {\r\n            Media.HTTPProxy = HTTPProxy;\r\n        }\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n                && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag === \'string\') {\r\n                        label = (tag.tag + (typeof tag.value !== \'undefined\'\r\n                                && tag.value !== \'\' ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        Media.labels.push(label);\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse "event_tags_json" param\');\r\n            }\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data, allow_404) {\r\n        if (typeof(allow_404) === \'undefined\') {\r\n            allow_404 = false;\r\n        }\r\n\r\n        [\'api\', \'token\'].forEach(function (field) {\r\n            if (typeof Media.params !== \'object\' || typeof Media.params[field] === \'undefined\'\r\n                    || Media.params[field] === \'\') {\r\n                throw \'Required \' + Media.name + \' param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Media.params.api + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: \' + Media.params.token);\r\n        request.setProxy(Media.HTTPProxy);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse response.\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if ((request.getStatus() < 200 || request.getStatus() >= 300)\r\n                && (!allow_404 || request.getStatus() !== 404)) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null) {\r\n                if (typeof response.errors === \'object\' && Object.keys(response.errors).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errors);\r\n                }\r\n                else if (typeof response.errorMessages === \'object\' && Object.keys(response.errorMessages).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errorMessages);\r\n                }\r\n                else if (typeof response.message === \'string\') {\r\n                    message += \': \' + response.message;\r\n                }\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getAlertId: function (requestId) {\r\n        status_counter = params.status_counter || 25; \r\n        do {\r\n            resp = Media.request(\'get\', \'requests/\' + requestId, undefined, true);\r\n        status_counter -= 1;            \r\n        }\r\n        while ( status_counter > 0 && \r\n            ( \r\n            typeof resp.response !== \'object\' || \r\n            typeof resp.response.data === \'undefined\' ||\r\n            resp.response.data.success === false &&\r\n                !resp.response.data.status.includes("There is no open alert") &&\r\n                !resp.response.data.status.includes("Alert is already")\r\n            ) \r\n        );\r\n\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.data === \'undefined\') {\r\n            throw \'Cannot get \' + Media.name + \' issue ID. Check debug log for more information.\';\r\n        }\r\n        else if (resp.response.data.success === false ) {\r\n            throw Media.name + \': Operation status (\' + resp.response.data.status + \')\';\r\n        }\r\n\r\n        return resp;\r\n    }\r\n};\r\n\r\ntry {\r\n    var result = {tags: {}},\r\n        params = JSON.parse(value),\r\n        media = {},\r\n        fields = {},\r\n        resp = {},\r\n        responders = [],\r\n        tags = [],\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\',\r\n            \'opsgenie_api\',\r\n            \'opsgenie_web\',\r\n            \'opsgenie_token\'\r\n        ],\r\n        severities = [\r\n            \'not_classified\',\r\n            \'information\',\r\n            \'warning\',\r\n            \'average\',\r\n            \'high\',\r\n            \'disaster\',\r\n            \'resolved\',\r\n            \'default\'\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n            if (key.startsWith(\'opsgenie_\')) {\r\n                media[key.substring(9)] = params[key];\r\n            }\r\n        });\r\n\r\n    // Possible values of event_source:\r\n    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check event_value for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_update_status only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_id for a numeric value.\r\n    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {\r\n        throw \'Incorrect "event_id" parameter given: \' + params.event_id + \'\\nMust be a positive number.\';\r\n    }\r\n\r\n    if ((params.event_source === \'1\' || params.event_source === \'2\')  && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for Trigger and Internal actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity]];\r\n    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n    Media.name = \'Opsgenie\';\r\n    Media.setParams(media);\r\n    Media.params.token = \'GenieKey \' + Media.params.token;\r\n    Media.setProxy(params.HTTPProxy);\r\n    Media.setTags(params.event_tags_json); // Set Media.labels\r\n\r\n    // Create an issue.\r\n    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).\r\n    // Numeric value of the problem update status. Possible values:\r\n    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)\r\n            || (params.event_source == 3 && params.event_value == 1)\r\n            || params.event_source == 1 || params.event_source == 2) {\r\n        fields.message = params.alert_subject;\r\n        fields.alias = params.event_id;\r\n        fields.description = params.alert_message;\r\n        fields.priority = priority;\r\n        fields.source = \'Zabbix\';\r\n\r\n        if (params.event_source === \'0\') {\r\n            fields.details = {\r\n                \'Zabbix server\': params.zbxurl,\r\n                Problem: params.zbxurl + \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id\r\n            };\r\n        }\r\n        else {\r\n            fields.details = {\'Zabbix server\': params.zbxurl};\r\n        }\r\n\r\n        if (typeof params.opsgenie_teams === \'string\') {\r\n            responders = params.opsgenie_teams.split(\',\');\r\n            fields.responders = responders.map(function(team) {\r\n                return {type: \'team\', name: team.trim()};\r\n            });\r\n        }\r\n\r\n        fields.tags = Media.labels;\r\n        if (typeof params.opsgenie_tags === \'string\') {\r\n            tags = params.opsgenie_tags.split(\',\');\r\n            tags.forEach(function(item) {\r\n                fields.tags.push(item.trim());\r\n            });\r\n        }\r\n\r\n        resp = Media.request(\'post\', \'\', fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.result === \'undefined\') {\r\n            throw \'Cannot create \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (resp.status === 202) {\r\n            resp = Media.getAlertId(resp.response.requestId);\r\n            if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {\r\n                result.tags.__zbx_ops_issuekey = resp.response.data.alertId;\r\n                result.tags.__zbx_ops_issuelink = Media.params.web + \'alert/detail/\' + resp.response.data.alertId;\r\n            }\r\n        }\r\n        else {\r\n            throw Media.name + \' response code is unexpected. Check debug log for more information.\';\r\n        }\r\n    }\r\n    // Update or close the created issue.\r\n    else {\r\n        fields.user = (params.event_value != 0) ? params.zbxuser : \'\';\r\n        fields.note = params.alert_message;\r\n        if ( [0, 3].indexOf(parseInt(params.event_source)) > -1  && params.event_value == 0 ) {\r\n            // skip sending of close request from update operation(mandatory when both update & recovery operations are defined in action)  \r\n            method = params.event_update_status == 0 ? "close" : "skip";\r\n        }\r\n        else if ( params.event_source == 0 && params.event_value == 1 && params.event_update_status == 1 && params.event_update_action.includes(\'acknowledged\')) {\r\n            method = params.event_update_action.includes(\'unacknowledged\') ? "unacknowledge" : "acknowledge";\r\n        }\r\n        else {\r\n            method = "notes";\r\n        }\r\n\r\n        if (method !== "skip") {\r\n        resp = Media.request(\'post\', params.event_id + \'/\' + method +\'?identifierType=alias\', fields);\r\n\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.result === \'undefined\') {\r\n            throw \'Cannot update \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (resp.status === 202) {\r\n            resp = Media.getAlertId(resp.response.requestId);\r\n        }\r\n        else {\r\n            throw Media.name + \' response code is unexpected. Check debug log for more information.\';\r\n        }\r\n    }\r\n    }\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ \' + Media.name + \' Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_ops_issuelink}','Opsgenie: {EVENT.TAGS.__zbx_ops_issuekey}','Please refer to https://docs.opsgenie.com/docs/alert-api and https://www.zabbix.com/documentation/7.4/manual/config/notifications/media/webhook#example_scripts.\r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd dedicated user with media type "Opsgenie".\r\nChange the values of the variables opsgenie_api (https://api.opsgenie.com/v2/alerts or https://api.eu.opsgenie.com/v2/alerts),\r\nopsgenie_web (for example, https://myzabbix.app.opsgenie.com), opsgenie_token.','0'),
('87','4','OTRS CE','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst SEVERITIES = ["not_classified", "information", "warning", "average", "high", "disaster"],\r\n	serviceLogName = \' ((OTRS)) CE Webhook \',\r\n	Logger = new CLogger(serviceLogName),\r\n	OTRS = CWebhook;\r\n\r\nOTRS.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({alert_subject: {type: \'string\'}, alert_message: {type: \'string\'},\r\n		event_nseverity: {type: \'integer\', default: -1}, otrs_url: {type: \'string\', url: true}, otrs_auth_user: {type: \'string\'},\r\n		otrs_auth_password: {type: \'string\'}, otrs_customer: {type: \'string\'}, otrs_default_priority_id: {type: \'integer\', min: 1, max: 5},\r\n		otrs_queue: {type: \'string\'}, otrs_ticket_type: {type: \'string\'}, otrs_ticket_state: {type: \'string\'}, otrs_time_unit: {type: \'integer\'},\r\n		otrs_closed_state_id: {type: \'integer\', default: 0}, zabbix_url: {type: \'string\', url: true}}, this.params);\r\n	this.params.entrypoint = \'/nph-genericinterface.pl/Webservice/ZabbixTicketConnector/Ticket\';\r\n\r\n	var priority;\r\n	if (this.params.event_nseverity >= 0 && this.params.event_nseverity < SEVERITIES.length) {\r\n		priority = this.params[\'severity_\' + SEVERITIES[this.params.event_nseverity]];\r\n	}\r\n	this.priority = (CParamValidator.isDefined(priority)) ? priority.trim() : this.params.otrs_default_priority_id;\r\n\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({trigger_id: {type: \'integer\'}, event_id: {type: \'integer\'}}, this.params);\r\n		this.params.zabbix_url = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n		this.params.alert_message = this.params.alert_subject + \'\\n\' + this.params.alert_message + \'\\n\' +\r\n			this.params.zabbix_url + \'\\n\';\r\n	}\r\n	if (this.params.event_value != \'0\' && CParamValidator.isMacroSet(this.params.otrs_ticket_id)) {\r\n		this.params.event_update_status = \'1\';\r\n	}\r\n	this.dynamicFields = {}\r\n	Object.keys(this.params).forEach(function (key) {\r\n		if (key.startsWith(\'dynamicfield_\')) {\r\n			this.dynamicFields[key.substring(13)] = this.params[key];\r\n		}\r\n	});\r\n\r\n	this.data = {\r\n		Article: {\r\n			Subject: this.params.alert_subject,\r\n			Body: (CParamValidator.isDefined(this.params.alert_message)) ? this.params.alert_message : \'\',\r\n			TimeUnit: this.params.otrs_time_unit.toString(),\r\n			ContentType: \'text/plain; charset=utf8\'\r\n		}\r\n	};\r\n\r\n	this.result = {tags: {}};\r\n};\r\n\r\nOTRS.prototype.sendRequest = function (method) {\r\n	var url = this.params.otrs_url + this.params.entrypoint +\r\n		\'?UserLogin=\' + encodeURIComponent(this.params.otrs_auth_user) +\r\n		\'&Password=\' + encodeURIComponent(this.params.otrs_auth_password);\r\n\r\n	var response = this.request.jsonRequest(method, url, this.data);\r\n\r\n	if (!CParamValidator.isType(response, \'object\')) {\r\n		Logger.log(Logger.INFO, \'API response ERROR: \' + response);\r\n		throw \'Unknown error. Check debug log for more information.\';\r\n	}\r\n	if (this.request.getStatus() < 200 || this.request.getStatus() >= 300) {\r\n		var message = \'status code \' + this.request.getStatus();\r\n		Logger.log(Logger.INFO, \'API response ERROR with \' + message + \': \' + response);\r\n		throw \'Request failed with \' + message + \'. Check debug log for more information.\';\r\n	}\r\n	if (CParamValidator.isDefined(response.Error) && Object.keys(response.Error).length > 0) {\r\n		Logger.log(Logger.INFO, \'API response ERROR: \' + JSON.stringify(response.Error));\r\n		throw \'Request failed: \' + JSON.stringify(response.Error);\r\n	}\r\n\r\n	return {\r\n		status: this.request.getStatus(),\r\n		response: response\r\n	};\r\n};\r\n\r\nOTRS.prototype.createTicket = function () {\r\n	this.data[\'Ticket\'] = {\r\n		Title: this.params.alert_subject,\r\n		Queue: this.params.otrs_queue,\r\n		Type: this.params.otrs_ticket_type,\r\n		State: this.params.otrs_ticket_state,\r\n		PriorityID: this.priority.toString(),\r\n		CustomerUser: this.params.otrs_customer\r\n	}\r\n\r\n	var result = this.sendRequest(\'post\');\r\n\r\n	if (!CParamValidator.isDefined(result.response.TicketID) || result.status != 200) {\r\n		throw \'Cannot create ((OTRS)) CE ticket. Check debug log for more information.\';\r\n	}\r\n\r\n	return result.response.TicketID;\r\n}\r\n\r\nOTRS.prototype.updateTicket = function () {\r\n	CParamValidator.validate({otrs_ticket_id: {type: \'string\'}, entrypoint: {type: \'string\'}}, this.params);\r\n	this.params.entrypoint += \'/\' + encodeURIComponent(this.params.otrs_ticket_id);\r\n\r\n	var result = this.sendRequest(\'put\');\r\n\r\n	if (!CParamValidator.isDefined(result.response.TicketID) || result.status != 200) {\r\n		throw \'Cannot update ((OTRS)) CE ticket. Check debug log for more information.\';\r\n	}\r\n\r\n	return result.response.TicketID;\r\n}\r\n\r\nOTRS.prototype.onProblem = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	if (CParamValidator.isDefined(alert.source) && CParamValidator.inArray(alert.source, [\'trigger\', \'service\', \'internal\'])) {\r\n		if (Object.keys(this.dynamicFields).length > 0) {\r\n			this.data.DynamicField = [];\r\n			Object.keys(this.dynamicFields).forEach(function(field) {\r\n				if (field !== undefined) {\r\n					if (this.dynamicFields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/)) {\r\n						this.dynamicFields[field] = this.dynamicFields[field].replace(/\\./g, \'-\');\r\n					}\r\n	\r\n					this.data.DynamicField.push({Name: field, Value: this.dynamicFields[field]});\r\n				}\r\n			});\r\n		}\r\n		const ticket_id = this.createTicket(alert);\r\n		this.result.tags.__zbx_otrs_ticket_id = ticket_id;\r\n		this.result.tags.__zbx_otrs_ticketlink = this.params.otrs_url + \'index.pl?Action=AgentTicketZoom;TicketID=\' + ticket_id;\r\n\r\n		return this.result;\r\n	}\r\n	return this.createTicket();\r\n}\r\n\r\nOTRS.prototype.onUpdate = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	this.updateTicket();\r\n\r\n	return this.result;\r\n}\r\n\r\nOTRS.prototype.onResolve = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	if (this.params.otrs_closed_state_id > 0) {\r\n		this.data[\'Ticket\'] = {\r\n			StateID: this.params.otrs_closed_state_id\r\n		}\r\n	}\r\n	this.updateTicket();\r\n\r\n	return this.result;\r\n}\r\n\r\nOTRS.prototype.onDiscovery = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\nOTRS.prototype.onAutoreg = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\ntry {\r\n	var hook = new OTRS(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_otrs_ticketlink}','((OTRS)) CE: ticket #{EVENT.TAGS.__zbx_otrs_ticket_id}','This media type integrates your Zabbix installation with your Zammad installation using the Zabbix webhook feature.\r\n\r\n((OTRS)) CE configuration:\r\n\r\n1. Create a new web service. To do so, navigate to "Admin" → "Web services" and import the "ZabbixTicketConnector.yml" file (it can be found in the official Zabbix repository next to the media type file).\r\n\r\n2. Create a new customer.\r\n\r\n3. Create a new customer user. Select the ID of the customer that you created in the previous step.\r\n\r\n4. Create a new agent. Depending on the ticket queue you want to use for tickets created by the webhook, set the "RW" permission for the group that this ticket queue belongs to. In the example below, if you want to use the "Misc" queue, you must set the "RW" permission for the group "users".\r\n\r\nZabbix configuration:\r\n\r\n1. Before you can start using the ((OTRS)) CE webhook, set the global macro "{$ZABBIX.URL}":\r\n- In the Zabbix web interface, go to "Administration" → "Macros" in the top-left dropdown menu.\r\n- Set the global macro "{$ZABBIX.URL}" to the URL of the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.\r\n- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration, you might also need to append "/zabbix" to the end of URL. Good examples:\r\n  - http://zabbix.com\r\n  - https://zabbix.lan/zabbix\r\n  - http://server.zabbix.lan/\r\n  - http://localhost\r\n  - http://127.0.0.1:8080\r\n- Bad examples:\r\n  - zabbix.com\r\n  - http://zabbix/\r\n\r\n2. Set the following webhook parameters:\r\n- otrs_auth_user - the username of the agent\r\n- otrs_auth_password - the password of the agent\r\n- otrs_customer - the email of the customer user\r\n- otrs_queue - the queue that will be used for tickets created by the webhook\r\n- otrs_url - the frontend URL of your ((OTRS)) CE installation (for example, "https://otrs.example.com/otrs")\r\n\r\n3. If you want to prioritize issues according to the severity values in Zabbix, you can define mapping parameters (create them as additional webhook parameters):\r\n- severity_<name> - the ((OTRS)) CE priority ID (<name> in the parameter name can be one of the following values: "not_classified", "information", "warning", "average", "high", "disaster")\r\n\r\n4. If you have dynamic fields in ((OTRS)) CE and want them to be filled with values from Zabbix, add webhook parameters in the format "dynamicfield_<((OTRS)) CE dynamic field name>", similarly to the previous step. Dynamic fields can only be of the types "text", "textarea", "checkbox", or "date".\r\n\r\n5. If you want the webhook to close tickets related to **resolved** problems in Zabbix, you can change the following parameter value:\r\n- otrs_closed_state_id - ((OTRS)) CE state ID for closed tasks (possible values: 0 - Disable tickets closing, >0 - State ID from the State Management page).\r\n\r\n6. If you use the ticket type feature, you can change the type of the created tickets:\r\n- otrs_ticket_type - ((OTRS)) CE ticket type (set to "Unclassified" by default; present on fresh installations).\r\n\r\n7. Click the "Enabled" checkbox to enable the mediatype and click the "Update" button to save the webhook settings.\r\n\r\n8. Create a Zabbix user and add media:\r\n- To create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).\r\n- In the "Media" tab, click "Add" and select the type "Zammad" from the drop-down list. Add any value in the "Send to" field: it is not used in the webhook, but is required.\r\n- Make sure this user has access to all hosts for which you would like problem notifications to be sent to Zammad.\r\n\r\n9. Done! You can now start using this media type in actions and create tickets.\r\n\r\nYou can find the latest version of this media and additional information in the official Zabbix repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/otrs_ce','0'),
('88','4','PagerDuty','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nvar severityMapping = [\r\n	\'info\',\r\n	\'info\',\r\n	\'warning\',\r\n	\'warning\',\r\n	\'error\',\r\n	\'critical\'\r\n],\r\n	serviceLogName = \'PagerDuty Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	PagerDuty = CWebhook;\r\n\r\nfunction getDefaultEventData(data, params) {\r\n	data.event_action = \'trigger\';\r\n	data.payload.custom_details = {\r\n		\'Alert message\': params.alert_message\r\n	};\r\n	Object.keys(params).forEach(function (key) {\r\n		if (key.startsWith(\'customdetails_\') && !CParamValidator.isEmpty(params[key])) {\r\n			data.payload.custom_details[key.substring(14)] = params[key];\r\n		}\r\n	});\r\n	data.client = \'Zabbix\';\r\n	data.client_url = params.zabbix_url;\r\n\r\n	return data;\r\n};\r\n\r\nPagerDuty.prototype.onCheckParams = function () {\r\n	this.params.url = \'https://events.pagerduty.com/v2/enqueue\';\r\n	CParamValidator.validate({api_token: {type: \'string\'}, event_id: {type: \'integer\'},\r\n		alert_subject: {type: \'string\'}, host_ip: {type: \'string\', default: \'\'}, zabbix_url: {type: \'string\', url: true},\r\n		event_nseverity: {type: \'integer\', min: 0, max: 5, default: 0}}, this.params);\r\n	if (CParamValidator.inArray(this.params.event_source, [\'0\',\'3\',\'4\'])) {\r\n		CParamValidator.validate({host_name: {type: \'string\', default: \'\'}}, this.params);\r\n		if (this.params.event_source === \'0\') {\r\n			CParamValidator.validate({trigger_id: {type: \'integer\'}, event_update_status: {type: \'string\', array: [\'0\', \'1\']},\r\n				event_ack: {type: \'boolean\'}}, this.params);\r\n		}\r\n		else {\r\n			CParamValidator.validate({alert_message: {type: \'string\'}, event_ack: {type: \'boolean\', default: false}}, this.params);\r\n		}\r\n	}\r\n	this.data = {\r\n		routing_key: this.params.api_token,\r\n		dedup_key: String(this.params.event_id),\r\n		payload: {\r\n			summary: this.params.alert_subject,\r\n			source: (!CParamValidator.isEmpty(this.params.host_name)) ? (this.params.host_name +\r\n				((!CParamValidator.isEmpty(this.params.host_ip)) ? \' : \' + this.params.host_ip : \'\')) : \'Zabbix\',\r\n			severity: severityMapping[this.params.event_nseverity],\r\n		}\r\n	}\r\n}\r\n\r\nPagerDuty.prototype.onProblem = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	this.data = getDefaultEventData(this.data, this.params);\r\n	if (CParamValidator.isDefined(alert.source) && alert.source === \'Trigger\') {\r\n		this.data.links = [{\r\n			href: CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id),\r\n			text: \'Event link\'\r\n		}];\r\n	}\r\n\r\n	return this.sendRequest();\r\n}\r\n\r\nPagerDuty.prototype.onUpdate = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	if (this.params.event_ack === true) {\r\n		this.data.event_action = \'acknowledge\';\r\n		return this.sendRequest();\r\n	}\r\n	this.data = getDefaultEventData(this.data, this.params);\r\n\r\n	return this.sendRequest();\r\n}\r\n\r\nPagerDuty.prototype.onResolve = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	this.data = getDefaultEventData(this.data, this.params);\r\n	this.data.event_action = \'resolve\';\r\n	\r\n	return this.sendRequest();\r\n}\r\n\r\nPagerDuty.prototype.onDiscovery = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	this.data = getDefaultEventData(this.data, this.params);\r\n	this.data.payload.source = \'Discovery\';\r\n\r\n	return this.sendRequest();\r\n}\r\n\r\nPagerDuty.prototype.onAutoreg = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\nPagerDuty.prototype.sendRequest = function () {\r\n	var response = this.request.jsonRequest(\'POST\', this.params.url, this.data);\r\n	if (!CParamValidator.isType(response, \'object\')) {\r\n		Logger.log(Logger.INFO, \'API response ERROR: \' + response);\r\n		throw \'Unknown error. Check debug log for more information.\';\r\n	}\r\n	if (this.request.getStatus() != 202) {\r\n		if (CParamValidator.isType(response.errors, \'array\') && CParamValidator.isType(response.errors[0], \'string\')) {\r\n			throw response.errors[0];\r\n		}\r\n		else {\r\n			throw \'Unknown error. HTTP status: \' + this.request.getStatus();\r\n		}\r\n	}\r\n	if (response.status != \'success\') {\r\n		Logger.log(Logger.INFO, \'API response ERROR: \' + response);\r\n		throw \'Unknown error. Check debug log for more information.\';\r\n	}\r\n\r\n	return \'OK\';\r\n};\r\n\r\ntry {\r\n	var hook = new PagerDuty(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','Please refer to https://v2.developer.pagerduty.com/docs/send-an-event-events-api-v2 and https://www.zabbix.com/documentation/7.4/manual/config/notifications/media/webhook#example_scripts.\r\n\r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "PagerDuty" and place the integration key in the user\'s "Send to" parameter to integrate into the service.','0'),
('89','4','Pushover','','','','','','','','25','0','0','0','0','0','3','10s','1','try {\r\n    var params = JSON.parse(value),\r\n        request = new HttpRequest(),\r\n        data,\r\n        response,\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        request.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'priority_\' + severities[params.event_nseverity].name] || params.priority_default;\r\n\r\n    if (isNaN(priority) || priority < -2 || priority > 2) {\r\n        throw \'"priority" should be -2..2\';\r\n    }\r\n\r\n    if (params.event_source === \'0\' && isNaN(params.triggerid)) {\r\n        throw \'field "triggerid" is not a number\';\r\n    }\r\n\r\n    if (isNaN(params.eventid)) {\r\n        throw \'field "eventid" is not a number\';\r\n    }\r\n\r\n    if (typeof params.message !== \'string\' || params.message.trim() === \'\') {\r\n        throw \'field "message" cannot be empty\';\r\n    }\r\n\r\n    data = {\r\n        token: params.token,\r\n        user: params.user,\r\n        title: params.title,\r\n        message: params.message,\r\n        url: (params.event_source === \'0\') \r\n            ? params.url + \'/tr_events.php?triggerid=\' + params.triggerid + \'&eventid=\' + params.eventid\r\n            : params.url,\r\n        url_title: params.url_title,\r\n        priority: priority\r\n    };\r\n\r\n    if (priority == 2) {\r\n        if (isNaN(params.retry) || params.retry < 30) {\r\n            throw \'field "retry" should be a number with value of at least 30 if "priority" is set to 2\';\r\n        }\r\n\r\n        if (isNaN(params.expire) || params.expire > 10800) {\r\n            throw \'field "expire" should be a number with value of at most 10800 if "priority" is set to 2\';\r\n        }\r\n\r\n        data.retry = params.retry;\r\n        data.expire = params.expire;\r\n    }\r\n\r\n    data = JSON.stringify(data);\r\n    Zabbix.log(4, \'[ Pushover Webhook ] Sending request: \' + params.endpoint + \'\\n\' + data);\r\n\r\n    request.addHeader(\'Content-Type: application/json\');\r\n    response = request.post(params.endpoint, data);\r\n\r\n    Zabbix.log(4, \'[ Pushover Webhook ] Received response with status code \' + request.getStatus() + \'\\n\' + response);\r\n\r\n    if (response !== null) {\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.log(4, \'[ Pushover Webhook ] Failed to parse response received from Pushover\');\r\n            response = null;\r\n        }\r\n    }\r\n\r\n    if (request.getStatus() != 200 || response === null || typeof response !== \'object\' || response.status !== 1) {\r\n        if (response !== null && typeof response === \'object\' && typeof response.errors === \'object\'\r\n                && typeof response.errors[0] === \'string\') {\r\n            throw response.errors[0];\r\n        }\r\n        else {\r\n            throw \'Unknown error. Check debug log for more information.\';\r\n        }\r\n    }\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(4, \'[ Pushover Webhook ] Pushover notification failed: \' + error);\r\n    throw \'Pushover notification failed: \' + error;\r\n}','30s','0','0','','','Please refer to setup guide here: https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/pushover\r\n\r\nSet token parameter with to your Pushover application key.\r\nWhen assigning Pushover media to the Zabbix user - add user key into send to field.','0'),
('90','4','Redmine','','','','','','','','25','0','0','0','0','1','3','10s','1','var Redmine = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Redmine.params = params;\r\n        if (typeof Redmine.params.url === \'string\') {\r\n            if (!Redmine.params.url.endsWith(\'/\')) {\r\n                Redmine.params.url += \'/\';\r\n            }\r\n        }\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n\r\n            data.issue.custom_fields = [];\r\n            Object.keys(fields)\r\n                .forEach(function (field) {\r\n                    var field_value = fields[field];\r\n\r\n                    if (field_value !== undefined) {\r\n                        data.issue.custom_fields.push({ id: field, value: field_value });\r\n                    }\r\n                });\r\n\r\n        }\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'access_key\'].forEach(function (field) {\r\n            if (typeof Redmine.params !== \'object\' || typeof Redmine.params[field] === \'undefined\'\r\n                || Redmine.params[field] === \'\' ) {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Redmine.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        if (typeof Redmine.HTTPProxy === \'string\' && Redmine.HTTPProxy.trim() !== \'\') {\r\n            request.setProxy(Redmine.HTTPProxy);\r\n        }\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'X-Redmine-API-Key: \' + Redmine.params.access_key);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Redmine Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Redmine Webhook ] Received response with status code \' + request.getStatus() + \': \' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ Redmine Webhook ] Failed to parse response received from Redmine\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getProjectID: function(name) {\r\n        var result = Redmine.request(\'get\', \'projects.json\'),\r\n            project_id;\r\n\r\n        if (result.response) {\r\n            var projects = result.response.projects || [];\r\n\r\n            for (var i in projects) {\r\n                if (projects[i].name === name) {\r\n                    project_id = projects[i].id;\r\n                    break;\r\n                }\r\n            }\r\n        }\r\n        else {\r\n            Zabbix.log(4, \'[ Redmine Webhook ] Failed to retrieve project data.\');\r\n        }\r\n\r\n        if (typeof project_id === \'undefined\') {\r\n            throw \'Cannot find project with name: \' + name;\r\n        }\r\n\r\n        return project_id;\r\n    },\r\n\r\n    createIssue: function(subject, description, priority, fields) {\r\n        var project_id = /^\\d+$/.test(Redmine.params.project)\r\n                ? Redmine.params.project\r\n                : Redmine.getProjectID(Redmine.params.project),\r\n            data = {\r\n                issue: {\r\n                    project_id: project_id,\r\n                    tracker_id: Redmine.params.tracker_id,\r\n                    subject: subject,\r\n                    description: description\r\n                }\r\n            },\r\n            result;\r\n\r\n        if (priority) {\r\n            data.issue.priority_id = priority;\r\n        }\r\n\r\n        result = Redmine.request(\'post\', \'issues.json\', Redmine.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.issue.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot create Redmine issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.issue.id;\r\n    },\r\n\r\n    updateIssue: function (note, fields, status) {\r\n        var data = {\r\n            issue: {\r\n                notes: note || \'\'\r\n            }\r\n        };\r\n\r\n        if (status) {\r\n            data.issue.status_id = status;\r\n        }\r\n\r\n        Redmine.request(\'put\', \'issues/\' + Redmine.params.issue_key + \'.json\', Redmine.addCustomFields(data, fields));\r\n    }\r\n\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_redmine = {},\r\n        params_fields = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'tracker_id\', \'project\',\r\n            \'event_source\', \'event_value\',  \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'redmine_\')) {\r\n                params_redmine[key.substring(8)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                params_fields[key.substring(12)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n\r\n    if (typeof params_redmine.close_status_id === \'string\' && params_redmine.close_status_id.trim() !== \'\' && !parseInt(params_redmine.close_status_id, 10)) {\r\n        throw \'Incorrect "redmine_close_status_id" parameter given! Must be an integer.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\'\r\n        && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\'\r\n                && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.redmine_issue_key)) || parseInt(params.redmine_issue_key) < 1 )) {\r\n        throw \'Incorrect "redmine_issue_key" parameter given: \' + params.redmine_issue_key +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    Redmine.setParams(params_redmine);\r\n    Redmine.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\'\r\n        && params.event_value !== \'0\') {\r\n        Redmine.createIssue(params.alert_subject, params.alert_message, priority);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        var issue_id = Redmine.createIssue(params.alert_subject,\r\n            params.alert_subject + \'\\n\' + params.alert_message + \'\\n\' +\r\n            params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\',\r\n            priority,\r\n            params_fields);\r\n\r\n        result.tags.__zbx_redmine_issue_id = issue_id;\r\n        result.tags.__zbx_redmine_issuelink = params.redmine_url +\r\n            (params.redmine_url.endsWith(\'/\') ? \'\' : \'/\') + \'issues/\' + issue_id;\r\n    }\r\n    // Close issue if parameter close_status_id is set and it is a recovery operation\r\n    else if (params.event_value === \'0\' && typeof params_redmine.close_status_id === \'string\' && params_redmine.close_status_id.trim() !== \'\') {\r\n        Redmine.updateIssue(params.alert_subject + \'\\n\' + params.alert_message, params_fields, params_redmine.close_status_id);\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        Redmine.updateIssue(params.alert_subject + \'\\n\' + params.alert_message, params_fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ Redmine Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_redmine_issuelink}','Redmine: issue #{EVENT.TAGS.__zbx_redmine_issue_id}','','0'),
('91','4','Rocket.Chat','','','','','','','','25','0','0','0','0','1','3','10s','1','var RocketChat = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        RocketChat.params = params;\r\n        if (RocketChat.params.url && RocketChat.params.api_url) {\r\n            if (!RocketChat.params.url.endsWith(\'/\')) {\r\n                RocketChat.params.url += \'/\';\r\n            }\r\n            if (!RocketChat.params.api_url.endsWith(\'/\')) {\r\n                RocketChat.params.api_url += \'/\';\r\n            }\r\n            if (RocketChat.params.api_url.startsWith(\'/\')) {\r\n                RocketChat.params.api_url = RocketChat.params.api_url.substring(1);\r\n            }\r\n\r\n            RocketChat.params.url += RocketChat.params.api_url;\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        RocketChat.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addFields: function (fields) {\r\n        var data = [];\r\n\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (fields[field] === \'\') {\r\n                        Zabbix.log(4, \'[ RocketChat Webhook ] Field "\' + field +\r\n                            \'" can\\\'t be empty. The field ignored.\');\r\n                    }\r\n                    else {\r\n                        try {\r\n                            var parts = field.split(\':\'),\r\n                                prefix = parts[0].split(\'_\');\r\n\r\n                            if (typeof prefix[2] === \'undefined\'\r\n                                    || (prefix[2] === \'p\' && params.event_value === \'1\')\r\n                                    || (prefix[2] === \'r\' && params.event_value === \'0\')) {\r\n                                data.push({\r\n                                    title: field.substring(field.indexOf(\':\') + 1),\r\n                                    value: fields[field],\r\n                                    short: prefix[1] === \'short\'\r\n                                });\r\n                            }\r\n                        }\r\n                        catch (error) {\r\n                            Zabbix.log(4, \'[ RocketChat Webhook ] Can\\\'t parse field "\' + field +\r\n                                \'". The field ignored.\');\r\n                        }\r\n                    }\r\n                });\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'api_url\', \'user_id\', \'user_token\', \'send_to\'].forEach(function (field) {\r\n            if (typeof RocketChat.params !== \'object\' || typeof RocketChat.params[field] === \'undefined\'\r\n                    || RocketChat.params[field] === \'\' ) {\r\n                throw \'Required parameter is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = RocketChat.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'X-Auth-Token:\' + RocketChat.params.user_token);\r\n        request.addHeader(\'X-User-Id:\' + RocketChat.params.user_id);\r\n\r\n        if (typeof RocketChat.HTTPProxy !== \'undefined\' && RocketChat.HTTPProxy !== \'\') {\r\n            request.setProxy(RocketChat.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ RocketChat Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ RocketChat Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ RocketChat Webhook ] Failed to parse response received from RocketChat\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.message !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.message);\r\n            }\r\n            else if (response !== null && typeof response.error !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    postMessage: function(use_default_message, message, fields) {\r\n        var data = {\r\n            channel: RocketChat.params.send_to,\r\n            attachments: [{\r\n                collapsed: false,\r\n                color: RocketChat.params.color,\r\n                title: params.alert_subject\r\n            }]\r\n        };\r\n\r\n        if (RocketChat.params.title_link) {\r\n            data.attachments[0].title_link = RocketChat.params.title_link;\r\n        }\r\n\r\n        if (use_default_message) {\r\n            data.attachments[0].text = message;\r\n        }\r\n        else {\r\n            data.attachments[0].fields = RocketChat.addFields(fields);\r\n        }\r\n\r\n        var result = RocketChat.request(\'post\', \'chat.postMessage\', data);\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.message._id === \'undefined\') {\r\n            throw \'Cannot send RocketChat message. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            id: result.response.message._id,\r\n            rid: result.response.message.rid,\r\n            channel: result.response.channel\r\n        };\r\n    },\r\n\r\n    sendMessage: function(update, fields) {\r\n\r\n        var data = {\r\n            message: {\r\n                rid: RocketChat.params.room_id,\r\n                tmid: RocketChat.params.msg_id,\r\n                tshow: true\r\n            }\r\n        };\r\n\r\n        if (update.status === \'0\') {\r\n            data.message.attachments = [{\r\n                collapsed: false,\r\n                color: RocketChat.params.color,\r\n                title: params.alert_subject,\r\n                title_link: RocketChat.params.title_link,\r\n                fields: RocketChat.addFields(fields)\r\n            }];\r\n        }\r\n        else {\r\n            data.message.alias = update.user;\r\n            data.message.msg = update.action;\r\n            if (update.message) {\r\n                data.message.attachments = [{\r\n                    color: RocketChat.params.color,\r\n                    text: update.message\r\n                }];\r\n            }\r\n        }\r\n\r\n        RocketChat.request(\'post\', \'chat.sendMessage\', data);\r\n    },\r\n\r\n    getMessageLink: function(rid, id) {\r\n        var room = RocketChat.request(\'get\', \'rooms.info?roomId=\' + encodeURIComponent(rid)),\r\n            link = params.rc_url +\r\n                (params.rc_url.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n        switch (room.response.room.t) {\r\n            case \'c\':\r\n                link += \'channel/\' + room.response.room.name + \'?msg=\' + id;\r\n                break;\r\n\r\n            case \'p\':\r\n                link += \'group/\' + room.response.room.name + \'?msg=\' + id;\r\n                break;\r\n\r\n            case \'d\':\r\n                link += \'direct/\' + rid + \'?msg=\' + id;\r\n                break;\r\n\r\n            default:\r\n                Zabbix.log(4, \'[ RocketChat Webhook ] Can\\\'t get room type. Link to message will not be added.\');\r\n        }\r\n\r\n        return link;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        response,\r\n        fields = {},\r\n        rc = {},\r\n        update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'alert_message\', \'event_source\', \'event_value\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'rc_\')) {\r\n                rc[key.substring(3)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'field_\')) {\r\n                fields[key.substring(6)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Forcing parameters for non trigger-based events.\r\n    if (params.event_source !== \'0\') {\r\n        params.use_default_message = \'true\';\r\n        params.event_nseverity = \'0\';\r\n        params.rc_title_link = false;\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    RocketChat.setParams(rc);\r\n    RocketChat.setProxy(params.HTTPProxy);\r\n    RocketChat.params.color = severities[params.event_nseverity].color;\r\n\r\n    // Send default message if use_default_message === true.\r\n    if (params.use_default_message.toLowerCase() === \'true\') {\r\n        response = RocketChat.postMessage(true, params.alert_message);\r\n        result.tags.__zbx_rc_id = response.id;\r\n        result.tags.__zbx_rc_rid = response.rid;\r\n        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);\r\n    }\r\n    // Send message for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\') {\r\n        response = RocketChat.postMessage(false, params.alert_message, fields);\r\n        result.tags.__zbx_rc_id = response.id;\r\n        result.tags.__zbx_rc_rid = response.rid;\r\n        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);\r\n    }\r\n    // Send thread message for trigger-based event.\r\n    else {\r\n        RocketChat.sendMessage(update, fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ RocketChat Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_rc_msg_url}','Rocket.Chat','','0'),
('92','4','ServiceNow','','','','','','','','25','0','0','0','0','1','3','10s','1','var ServiceNow = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        ServiceNow.params = params;\r\n        if (typeof ServiceNow.params.url === \'string\') {\r\n            if (!ServiceNow.params.url.endsWith(\'/\')) {\r\n                ServiceNow.params.url += \'/\';\r\n            }\r\n\r\n            ServiceNow.params.url += \'api/now/table/incident\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        ServiceNow.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    data[field] = (fields[field].match(/^\\d{4}\\.\\d{2}\\.\\d{2}$/) !== null)\r\n                        ? fields[field].replace(/\\./g, \'-\')\r\n                        : fields[field];\r\n                });\r\n        }\r\n    },\r\n\r\n    request: function (method, data) {\r\n        [\'url\', \'user\', \'password\'].forEach(function (field) {\r\n            if (typeof ServiceNow.params !== \'object\' || typeof ServiceNow.params[field] === \'undefined\'\r\n                || ServiceNow.params[field] === \'\' ) {\r\n                throw \'Required ServiceNow param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = ServiceNow.params.url,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: Basic \' + btoa(ServiceNow.params.user + \':\' + ServiceNow.params.password));\r\n\r\n        if (typeof ServiceNow.HTTPProxy !== \'undefined\' && ServiceNow.HTTPProxy !== \'\') {\r\n            request.setProxy(ServiceNow.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ ServiceNow Webhook ] Sending request: \' + url + ((typeof data === \'string\')\r\n            ? (\'\\n\' + data)\r\n            : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ ServiceNow Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ ServiceNow Webhook ] Failed to parse response received from ServiceNow\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.error.message !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error.message);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.result !== \'object\' || typeof response.result.sys_id === \'undefined\') {\r\n            throw \'Cannot create ServiceNow incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return response.result;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        servicenow = {},\r\n        data = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'alert_message\', \'event_source\', \'event_value\',\r\n            \'event_update_status\', \'event_recovery_value\', \'event_nseverity\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        method = \'post\',\r\n        process_tags = true;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'servicenow_\')) {\r\n                servicenow[key.substring(11)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'u_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    data.short_description = params.alert_subject;\r\n    data.description = params.alert_message;\r\n    data.comments = params.alert_message;\r\n\r\n    if (typeof params[\'urgency_for_\' + severities[params.event_nseverity].name] !== \'undefined\') {\r\n        data.urgency = params[\'urgency_for_\' + severities[params.event_nseverity].name];\r\n    }\r\n\r\n    ServiceNow.setParams(servicenow);\r\n    ServiceNow.setProxy(params.HTTPProxy);\r\n    ServiceNow.setFields(data, fields);\r\n\r\n    if (params.event_source === \'0\' && (params.event_value === \'0\' || params.event_update_status === \'1\')) {\r\n        process_tags = false;\r\n        method = \'put\';\r\n        delete data.description;\r\n        delete data.urgency;\r\n        ServiceNow.params.url += \'/\' + params.servicenow_sys_id;\r\n    }\r\n\r\n    var response = ServiceNow.request(method, data);\r\n\r\n    if (process_tags) {\r\n        result.tags.__zbx_servicenow_sys_id = response.sys_id;\r\n        result.tags.__zbx_servicenow_link = params.servicenow_url +\r\n            (params.servicenow_url.endsWith(\'/\') ? \'\' : \'/\') + \'incident.do?sys_id=\' + response.sys_id;\r\n        result.tags.__zbx_servicenow_number = response.number;\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ ServiceNow Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_servicenow_link}','ServiceNow: {EVENT.TAGS.__zbx_servicenow_number}','','0'),
('93','4','SIGNL4','','','','','','','','25','0','0','0','0','1','3','10s','1','// SIGNL4 Webhook\r\ntry {\r\n    var response,\r\n        payload,\r\n        params = JSON.parse(value),\r\n        endpoint = \'https://connect.signl4.com/webhook/\',\r\n        request = new HttpRequest();\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        request.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    if (typeof params.teamsecret === \'string\' && params.teamsecret.trim() !== \'\') {\r\n        endpoint += params.teamsecret;\r\n        delete params.teamsecret;\r\n    }\r\n    else {\r\n        throw \'The team secret of your SIGNL4 team cannot be empty.\';\r\n    }\r\n\r\n    if (typeof params.Severity === \'string\' && params.Severity === \'{EVENT.SEVERITY}\') {\r\n        params.Severity = \'Not classified\';\r\n    }\r\n\r\n	if (typeof params.User === \'string\' && params.User === \'{USER.FULLNAME}\') {\r\n        params.User = \'\';\r\n    }\r\n\r\n	if (typeof params.Event_Update_Action === \'string\' && params.Event_Update_Action === \'{EVENT.UPDATE.ACTION}\') {\r\n        params.Event_Update_Action = \'\';\r\n    }\r\n\r\n	// Assemble X-S4-ExternalID for two-way integration\r\n	// Format: "ZabbixEventID: 222 ZabbixURL: https://your-zabbix-server/zabbix/"\r\n	params[\'X-S4-ExternalID\'] = \'ZabbixEventID: \' + params.Event_ID;\r\n	if (typeof params.Zabbix_URL === \'string\' && params.Zabbix_URL.indexOf(\'http\') == 0) {\r\n		// Make sure the URL ends with \'/\'\r\n		if (params.Zabbix_URL.charAt(params.Zabbix_URL.length - 1) != \'/\') {\r\n			params.Zabbix_URL = params.Zabbix_URL + \'/\';\r\n		}\r\n\r\n		params[\'X-S4-ExternalID\'] = params[\'X-S4-ExternalID\'] + \' ZabbixURL: \' +  params.Zabbix_URL;\r\n\r\n		// Add Link parameter\r\n		params[\'Link\'] = params.Zabbix_URL + "tr_events.php?triggerid="+params.Trigger_ID + "&eventid=" + params.Event_ID;\r\n	}\r\n\r\n	// Check if this is a new problem or a recovery\r\n	if (params.Trigger_Status == \'OK\') {\r\n		params[\'X-S4-Status\'] = \'resolved\';\r\n	}\r\n	else {\r\n		params[\'X-S4-Status\'] = \'new\';\r\n		params[\'X-S4-SourceSystem\'] = \'Zabbix\';\r\n	}\r\n\r\n    payload = JSON.stringify(params);\r\n    Zabbix.log(4, \'[ SIGNL4 Webhook ] Sending request: \' + payload);\r\n\r\n    request.addHeader(\'Content-Type: application/json\');\r\n    response = request.post(endpoint, \'payload=\' + payload);\r\n\r\n    Zabbix.log(4, \'[ SIGNL4 Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response\r\n    );\r\n\r\n    if (request.getStatus() !== 201) {\r\n        throw \'Request failed with status code \' + request.getStatus() +\r\n                \'. Check debug log for more information.\';\r\n    }\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(4, \'[ SIGNL4 Webhook ] ERROR: \' + error);\r\n\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','SIGNL4 is a mobile alert notification app for powerful alerting, alert management and mobile assignment of work items. It offers alerting via app push, SMS and voice calls including escalations, tracking, and duty scheduling.\r\n\r\nGet the app at https://www.signl4.com.\r\n\r\nFind out more including an integration video here: https://www.signl4.com/blog/portfolio_item/zabbix-mobile-alert-notification-duty-schedule-escalation/','0'),
('94','4','Slack','','','','','','','','25','0','0','0','0','1','1','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nvar serviceLogName = \'Slack Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	Slack = CWebhook;\r\n\r\nSlack.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		alert_subject: { type: \'string\' },\r\n		alert_message: { type: \'string\' },\r\n		bot_token: { type: \'string\' },\r\n		zabbix_url: { type: \'string\', url: true },\r\n		channel: { type: \'string\', macro: \'ALERT.SENDTO\' },\r\n		slack_mode: { type: \'string\', array: [\'alarm\', \'event\'], }\r\n	}, this.params);\r\n\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({\r\n			event_id: { type: \'integer\' },\r\n			trigger_id: { type: \'integer\' }\r\n		}, this.params);\r\n	}\r\n\r\n	if (CParamValidator.inArray(this.params.event_source, [\'0\', \'3\', \'4\'])) {\r\n		CParamValidator.validate({\r\n			event_tags: { type: \'array\', macro: \'EVENT.TAGSJSON\', tags: true, default: {} }\r\n		}, this.params);\r\n	}\r\n\r\n	if (this.params.event_value != \'0\' && CParamValidator.isDefined(this.params.event_tags[\'__channel_id_\' + this.params.channel])) {\r\n		this.params.event_update_status = \'1\';\r\n	}\r\n\r\n	this.severity_colors = [\r\n		\'#97AAB3\',\r\n		\'#7499FF\',\r\n		\'#FFC859\',\r\n		\'#FFA059\',\r\n		\'#E97659\',\r\n		\'#E45959\'\r\n	];\r\n\r\n	this.resolve_color = \'#009900\';\r\n	this.slack_endpoint = \'https://slack.com/api/\';\r\n\r\n	this.problem_url = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n\r\n	this.data = {\r\n		channel: this.params.channel,\r\n		attachments: [\r\n			{\r\n				fallback: this.params.alert_subject,\r\n				title: this.params.alert_subject,\r\n				color: this.severity_colors[this.params.event_nseverity],\r\n				title_link: this.problem_url,\r\n				text: this.params.alert_message,\r\n				actions: [\r\n					{\r\n						type: \'button\',\r\n						text: \'Open in Zabbix\',\r\n						url: this.problem_url\r\n					}\r\n				]\r\n			}\r\n		]\r\n	};\r\n\r\n	this.reply = {\r\n		channel: this.params.channel,\r\n		thread_ts: \'\',\r\n		blocks: [\r\n			{\r\n				type: \'context\',\r\n				elements: [\r\n					{\r\n						type: \'plain_text\',\r\n						text: \'Event update message\'\r\n					}\r\n				]\r\n			},\r\n			{\r\n				type: \'rich_text\',\r\n				elements: [\r\n					{\r\n						type: \'rich_text_section\',\r\n						elements: [\r\n							{\r\n								type: \'text\',\r\n								text: \'\',\r\n								style: {\r\n									italic: true\r\n								}\r\n							}\r\n						]\r\n					}\r\n				]\r\n			}\r\n		]\r\n	};\r\n};\r\n\r\nSlack.prototype.sendRequest = function (route, data, tags) {\r\n	this.request.clearHeader();\r\n	this.request.addHeaders({\r\n		\'Content-Type\': \'application/json; charset=utf-8;\',\r\n		\'Authorization\': \'Bearer \' + this.params.bot_token\r\n	});\r\n\r\n	var response = this.request.jsonRequest(\'POST\', this.slack_endpoint + route, data);\r\n\r\n	if (this.request.getStatus() !== 200 || !CParamValidator.isType(response.ok, \'boolean\') || response.ok !== true) {\r\n		Logger.log(Logger.INFO, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.error, \'string\')) {\r\n			throw \'Endpoint response:\' + response.error;\r\n		}\r\n		else {\r\n			throw \'Unknown error. Check debug log for more information.\';\r\n		}\r\n	}\r\n\r\n	if (tags) {\r\n		return {\r\n			tags: {\r\n				[\'__message_ts_\' + this.params.channel]: response.ts,\r\n				[\'__channel_id_\' + this.params.channel]: response.channel,\r\n				[\'__message_link_\' + this.params.channel]: this.getPermalink(response.channel, response.ts),\r\n			}\r\n		};\r\n\r\n	}\r\n	else {\r\n		return { tags: {} };\r\n	}\r\n};\r\n\r\nSlack.prototype.getPermalink = function (channel, message_ts) {\r\n	var response = this.request.jsonRequest(\'GET\', this.slack_endpoint + \'chat.getPermalink\' + \'?channel=\' + channel + \'&message_ts=\' + message_ts);\r\n\r\n	if (this.request.getStatus() !== 200 || !CParamValidator.isType(response.ok, \'boolean\') || response.ok !== true) {\r\n		Logger.log(Logger.INFO, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.error, \'string\')) {\r\n			throw \'Endpoint response:\' + response.error;\r\n		}\r\n		else {\r\n			throw \'Unknown error. Check debug log for more information.\';\r\n		}\r\n	}\r\n\r\n	if (!CParamValidator.isDefined(response.permalink)) {\r\n		throw \'Permalink is missed from the JSON response\';\r\n	}\r\n\r\n	return response.permalink;\r\n};\r\n\r\nSlack.prototype.onProblem = function (properties) {\r\n	Logger.log(Logger.INFO, \'Source: \' + properties.source + \'; Event: \' + properties.event);\r\n\r\n	if (this.params.slack_mode === "alarm") {\r\n		return this.sendRequest(\'chat.postMessage\', this.data, true);\r\n	} else {\r\n		return this.sendRequest(\'chat.postMessage\', this.data, false);\r\n	}\r\n};\r\n\r\nSlack.prototype.onUpdate = function (properties) {\r\n	Logger.log(Logger.INFO, \'Source: \' + properties.source + \'; Event: \' + properties.event);\r\n\r\n	if (this.params.slack_mode === "alarm") {\r\n		this.data.channel = this.params.event_tags[\'__channel_id_\' + this.params.channel];\r\n		this.data.ts = this.params.event_tags[\'__message_ts_\' + this.params.channel];\r\n\r\n		if (CParamValidator.isMacroSet(this.params.event_update_message, \'EVENT.UPDATE.MESSAGE\') && !CParamValidator.isEmpty(this.params.event_update_message)) {\r\n			this.reply.thread_ts = this.data.ts;\r\n			this.reply.blocks[1].elements[0].elements[0].text = this.params.event_update_message;\r\n			this.sendRequest(\'chat.postMessage\', this.reply, false);\r\n		}\r\n\r\n		if (/\\backnowledged/.test(this.params.event_update_action)) {\r\n			this.sendRequest(\'reactions.add\', { channel: this.data.channel, timestamp: this.data.ts, name: \'white_check_mark\' }, false);\r\n		}\r\n\r\n		if (/\\bunacknowledged/.test(this.params.event_update_action)) {\r\n			this.sendRequest(\'reactions.remove\', { channel: this.data.channel, timestamp: this.data.ts, name: \'white_check_mark\' }, false);\r\n		}\r\n\r\n		if (/\\bclosed/.test(this.params.event_update_action)) {\r\n			return { tags: {} };\r\n		}\r\n		else {\r\n			return this.sendRequest(\'chat.update\', this.data, false);\r\n		}\r\n	} else {\r\n		return this.sendRequest(\'chat.postMessage\', this.data, false);\r\n	}\r\n};\r\n\r\nSlack.prototype.onResolve = function (properties) {\r\n	Logger.log(Logger.INFO, \'Source: \' + properties.source + \'; Event: \' + properties.event);\r\n	this.data.attachments[0].color = this.resolve_color;\r\n\r\n	if (this.params.slack_mode === "alarm") {\r\n		this.data.channel = this.params.event_tags[\'__channel_id_\' + this.params.channel];\r\n		this.data.ts = this.params.event_tags[\'__message_ts_\' + this.params.channel];\r\n\r\n		return this.sendRequest(\'chat.update\', this.data, false);\r\n	} else {\r\n		return this.sendRequest(\'chat.postMessage\', this.data, false);\r\n	}\r\n};\r\n\r\nSlack.prototype.onDiscovery = function (properties) {\r\n	return this.onProblem(properties);\r\n};\r\n\r\nSlack.prototype.onAutoreg = function (properties) {\r\n	return this.onProblem(properties);\r\n};\r\n\r\ntry {\r\n	var hook = new Slack(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'Notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','0','','','Preparing slack for a Zabbix media type:\r\n1. On the page Your Apps (https://api.slack.com/apps) press \'Create an App\', select \'From scratch\' and specify its name and workspace.\r\n2. In the \'Add features and functionality\' section, select \'Bots\' and press \'Review Scopes to Add\'.\r\n3. In the \'Scopes\' section, find \'Bot Token Scopes\', press \'Add an OAuth Scope\' and add \'chat:write\', \'im:write\', \'groups:write\' and \'reactions:write\' scopes.\r\n4. In the \'Settings\' section on the left side of the page press \'Install App\' and then \'Install to Workspace\'.\r\n5. Press \'Allow\' and copy \'Bot User OAuth Access Token\', which will be used to set up webhook.\r\n\r\nIn Zabbix:\r\n1. Set global macro {$ZABBIX.URL}\r\n2. Set user media for slack using channel name or member ID\r\n3. Set media param \'bot_token\' to the previously created token\r\n\r\nFor a detailed instructions please read full README file https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/slack/README.md','0'),
('95','4','SolarWinds Service Desk','','','','','','','','25','0','0','0','0','1','3','10s','1','var SolarWinds = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        SolarWinds.params = params;\r\n        SolarWinds.params.endpoint = \'https://api.samanage.com/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        SolarWinds.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof data.incident === \'object\' && typeof fields === \'object\' && Object.keys(fields).length) {\r\n            if (typeof fields.sw_fields === \'object\' && Object.keys(fields.sw_fields).length) {\r\n                Object.keys(fields.sw_fields)\r\n                    .forEach(function(field) {\r\n                        try {\r\n                            data.incident[field] = JSON.parse(fields.sw_fields[field]);\r\n                        }\r\n                        catch (error) {\r\n                            data.incident[field] = fields.sw_fields[field];\r\n                        }\r\n                    });\r\n            }\r\n\r\n            if (typeof fields.sw_customfields === \'object\' && Object.keys(fields.sw_customfields).length) {\r\n                data.incident.custom_fields_values = {custom_fields_value: []};\r\n                Object.keys(fields.sw_customfields)\r\n                    .forEach(function(field) {\r\n                        data.incident.custom_fields_values.custom_fields_value.push({\r\n                            name: field,\r\n                            value: fields.sw_customfields[field]\r\n                        });\r\n                    });\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'token\'].forEach(function (field) {\r\n            if (typeof SolarWinds.params !== \'object\' || typeof SolarWinds.params[field] === \'undefined\'\r\n                || SolarWinds.params[field] === \'\' ) {\r\n                throw \'Required SolarWinds param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = SolarWinds.params.endpoint + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'X-Samanage-Authorization: Bearer \' + SolarWinds.params.token);\r\n        request.addHeader(\'Accept: application/vnd.samanage.v2.1+json\');\r\n\r\n        if (typeof SolarWinds.HTTPProxy !== \'undefined\' && SolarWinds.HTTPProxy !== \'\') {\r\n            request.setProxy(SolarWinds.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ SolarWinds SD Webhook ] Sending request: \' + url + ((typeof data === \'string\')\r\n            ? (\'\\n\' + data)\r\n            : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ SolarWinds SD Webhook ] Received response with status code \' + request.getStatus() +\r\n            \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ SolarWinds SD Webhook ] Failed to parse response received from SolarWinds\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.error !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n            else if (response !== null && typeof response === \'object\'\r\n                && Object.keys(response).length > 0) {\r\n                Object.keys(response)\r\n                    .forEach(function(field) {\r\n                        message += \'\\n\' + field + \': \' + response[field][0];\r\n                    });\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    createIncident: function(name, description, fields) {\r\n        var data = {\r\n            incident: {\r\n                name: name,\r\n                description: description,\r\n                priority: SolarWinds.params.priority\r\n            }\r\n        };\r\n\r\n        var result = SolarWinds.request(\'post\', \'incidents.json\', SolarWinds.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.id === \'undefined\') {\r\n            throw \'Cannot create SolarWinds incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.id;\r\n    },\r\n\r\n    updateIncident: function(name, fields, message) {\r\n        var data = {\r\n            incident: {\r\n                name: name,\r\n                priority: SolarWinds.params.priority\r\n            }\r\n        };\r\n\r\n        SolarWinds.request(\r\n            \'put\',\r\n            \'incidents/\' + SolarWinds.params.incident_id + \'.json\',\r\n            SolarWinds.addCustomFields(data, fields));\r\n\r\n        SolarWinds.commenIncident(message);\r\n    },\r\n\r\n    commenIncident: function(message) {\r\n        var data = {\r\n            comment: {\r\n                body: message\r\n            }\r\n        };\r\n\r\n        SolarWinds.request(\'post\', \'incidents/\' + SolarWinds.params.incident_id + \'/comments.json\', data);\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        samanage = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'event_recovery_value\', \'event_source\', \'event_value\', \'priority_default\'],\r\n        severities = [\r\n            {name: \'not_classified\'},\r\n            {name: \'information\'},\r\n            {name: \'warning\'},\r\n            {name: \'average\'},\r\n            {name: \'high\'},\r\n            {name: \'disaster\'},\r\n            {name: \'resolved\'},\r\n            {name: \'default\'}\r\n        ];\r\n\r\n    fields.sw_fields = {};\r\n    fields.sw_customfields = {};\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'samanage_\')) {\r\n                samanage[key.substring(9)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'sw_field_\')) {\r\n                fields.sw_fields[key.substring(9)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'sw_customfield_\')) {\r\n                fields.sw_customfields[key.substring(15)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    samanage.priority = params[\'priority_\' + severities[params.event_nseverity].name] || params.priority_default;\r\n\r\n    SolarWinds.setParams(samanage);\r\n    SolarWinds.setProxy(params.HTTPProxy);\r\n\r\n    // Create incident for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        SolarWinds.createIncident(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create incident for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\'\r\n            && (samanage.incident_id === \'{EVENT.TAGS.__zbx_solarwinds_inc_id}\' || samanage.incident_id === \'*UNKNOWN*\')) {\r\n        var key = SolarWinds.createIncident(params.alert_subject, params.alert_message, fields);\r\n\r\n\r\n        result.tags.__zbx_solarwinds_inc_id = key;\r\n        result.tags.__zbx_solarwinds_inc_link = params.samanage_url +\r\n            (params.samanage_url.endsWith(\'/\') ? \'\' : \'/\') + \'incidents/\' + key;\r\n    }\r\n    // Update created incident for trigger-based event.\r\n    else {\r\n        if (samanage.incident_id === \'{EVENT.TAGS.__zbx_solarwinds_inc_id}\' || samanage.incident_id === \'\' || samanage.incident_id === \'*UNKNOWN*\') {\r\n            throw \'Incorrect incident key given: \' + samanage.incident_id;\r\n        }\r\n        if (!params.alert_message) {\r\n            throw \'Parameter "alert_message" can\\\'t be empty.\';\r\n        }\r\n        SolarWinds.updateIncident(params.alert_subject, fields, params.alert_message);\r\n    }\r\n\r\n    if (params.event_source === \'0\') {\r\n        return JSON.stringify(result);\r\n    }\r\n    else {\r\n        return \'OK\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ SolarWinds SD Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_solarwinds_inc_link}','SolarWinds incident ID: {EVENT.TAGS.__zbx_solarwinds_inc_id}','','0'),
('96','4','SysAid','','','','','','','','25','0','0','0','0','1','3','10s','1','var SysAid = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        var required = [\'url\', \'auth_user\', \'auth_password\', \'category_level_1\', \'category_level_2\',\r\n            \'category_level_3\', \'incident_id\', \'template_id\', \'urgency_id\', \'incident_state\',\r\n            \'default_priority_id\'\r\n        ];\r\n\r\n        required.forEach(function (field) {\r\n            if (typeof params !== \'object\' || typeof params[field] === \'undefined\' || params[field] === \'\') {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        SysAid.params = params;\r\n        if (typeof SysAid.params.url === \'string\' && !SysAid.params.url.endsWith(\'/\')) {\r\n            SysAid.params.url += \'/\';\r\n        }\r\n    },\r\n\r\n    login: function () {\r\n        var result = SysAid.request(\'post\', \'api/v1/login\', {\r\n            user_name: SysAid.params.auth_user,\r\n            password: SysAid.params.auth_password\r\n        });\r\n\r\n        return result.response.user.id;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        var response,\r\n            request = SysAid.req || (SysAid.req = new HttpRequest()),\r\n            url = SysAid.params.url + query;\r\n\r\n        if (typeof SysAid.HTTPProxy !== \'undefined\' && SysAid.HTTPProxy.trim() !== \'\') {\r\n            request.setProxy(SysAid.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ SysAid Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ SysAid Webhook ] Received response with status code \' + request.getStatus() + \': \' + response);\r\n\r\n        if (request.getStatus() !== 200) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            message += \': \' + response;\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ SysAid Webhook ] Failed to parse response received from SysAid\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (response === null || (typeof response.Error !== \'undefined\' && Object.keys(response.Error).length > 0)) {\r\n            throw \'Request failed: \' + JSON.stringify(response.Error);\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    createIncident: function(subject, message, priority) {\r\n        var result = SysAid.request(\'post\', \'api/v1/sr/?template=\' + encodeURIComponent(SysAid.params.template_id), {\r\n            info: [\r\n                {\r\n                    key: \'problem_type\',\r\n                    value: [\r\n                        SysAid.params.category_level_1,\r\n                        SysAid.params.category_level_2,\r\n                        SysAid.params.category_level_3\r\n                    ].join(\'_\')\r\n                },\r\n                {\r\n                    key: \'title\',\r\n                    value: subject\r\n                },\r\n                {\r\n                    key: \'description\',\r\n                    value: message\r\n                },\r\n                {\r\n                    key: \'status\',\r\n                    value: \'1\'\r\n                },\r\n                {\r\n                    key: \'urgency\',\r\n                    value: SysAid.params.urgency_id\r\n                },\r\n                {\r\n                    key: \'priority\',\r\n                    value: priority || SysAid.params.default_priority_id,\r\n                }\r\n            ]\r\n        });\r\n\r\n        if (result.response.id === \'undefined\') {\r\n            throw \'Cannot create SysAid incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.id;\r\n    },\r\n\r\n    updateTicket: function(note) {\r\n        var date = new Date().getTime();\r\n\r\n        SysAid.request(\'put\', \'api/v1/sr/\' + encodeURIComponent(SysAid.params.incident_id), {\r\n            id: SysAid.params.incident_id,\r\n            info: [\r\n                {\r\n                    key: \'update_time\',\r\n                    value: date\r\n                },\r\n                {\r\n                    key: \'notes\',\r\n                    value: [\r\n                        {\r\n                            userName: \'Zabbix\',\r\n                            createDate: date,\r\n                            text: note\r\n                        }\r\n                    ]\r\n                }\r\n            ]\r\n        });\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_sysaid = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'event_source\', \'event_value\',  \'event_update_status\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'sysaid_\')) {\r\n                params_sysaid[key.substring(7)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\' && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\' && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n            && (isNaN(parseInt(params.sysaid_incident_id)) || parseInt(params.sysaid_incident_id) < 1 )) {\r\n        throw \'Incorrect "sysaid_incident_id" parameter given: \' + params.sysaid_incident_id + \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    SysAid.setParams(params_sysaid);\r\n    SysAid.HTTPProxy = params.HTTPProxy;\r\n    SysAid.login();\r\n\r\n    if (params.event_source !== \'0\' && params.event_value !== \'0\') {\r\n        // Create ticket for non trigger-based events.\r\n        SysAid.createIncident(params.alert_subject, params.alert_message, priority);\r\n    }\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        // Create ticket for trigger-based events.\r\n        var incident_id = SysAid.createIncident(params.alert_subject, params.alert_subject + \'\\n\' + params.alert_message +\r\n                \'\\n\' + params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') + \'tr_events.php?triggerid=\' +\r\n                params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\', priority\r\n        );\r\n\r\n        result.tags.__zbx_sysaid_incident_id = incident_id;\r\n        result.tags.__zbx_sysaid_incidentlink = params.sysaid_url +\r\n            (params.sysaid_url.endsWith(\'/\') ? \'\' : \'/\') + \'SREdit.jsp?id=\' + incident_id + \'&fromId=IncidentsList\';\r\n    }\r\n    else {\r\n        // Update created ticket for trigger-based event.\r\n        SysAid.updateTicket(params.alert_subject + \'\\n\' + params.alert_message);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ SysAid Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_sysaid_incidentlink}','SysAid: incident #{EVENT.TAGS.__zbx_sysaid_incident_id}','','0'),
('97','4','Telegram','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nvar serviceLogName = \'Telegram Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	Telegram = CWebhook;\r\n\r\nfunction escapeMarkup(str, mode) {\r\n	switch (mode) {\r\n		case \'markdown\':\r\n			return str.replace(/([_*\\[`])/g, \'\\\\$&\');\r\n		case \'markdownv2\':\r\n			return str.replace(/([_*\\[\\]()~`>#+\\-=|{}.!])/g, \'\\\\$&\');\r\n		case \'html\':\r\n			return str.replace(/<(\\s|[^a-z\\/])/g, \'&lt;$1\');\r\n		default:\r\n			return str;\r\n	}\r\n}\r\n\r\nTelegram.prototype.getMessageID = function (chat_id, message_thread_id) {\r\n	const tag_key = \'__telegram_msg_id_\' + chat_id + (message_thread_id ? \'_\' + message_thread_id : \'\');\r\n	if (CParamValidator.isDefined(this.params.event_tags[tag_key])) {\r\n		return this.params.event_tags[tag_key];\r\n	}\r\n	return null;\r\n}\r\n\r\nTelegram.prototype.onCheckParams = function () {\r\n	CParamValidator.validate(\r\n		{\r\n			api_token: {type: \'string\'},\r\n			api_chat_id: {type: \'string\'},\r\n			alert_message: {type: \'string\'},\r\n			event_tags: {type: \'array\', tags: true, default: {}}\r\n		},\r\n		this.params\r\n	);\r\n	this.params.url = \'https://api.telegram.org/bot\';\r\n	this.data = {\r\n		disable_web_page_preview: true,\r\n		disable_notification: false\r\n	};\r\n	const match = this.params.api_chat_id.match(/^(-?\\d+|@[a-zA-Z0-9_]+)(?::(\\d+))?$/);\r\n	if (!match) {\r\n		throw \'Invalid format for api_chat_id: "\' + this.params.api_chat_id + \'". Must be a numeric group ID or @GroupName, optionally followed by :message_thread_id.\';\r\n	}\r\n	this.data[\'chat_id\'] = match[1];\r\n	if (CParamValidator.isDefined(match[2])) {\r\n		this.data[\'message_thread_id\'] = match[2];\r\n	}\r\n	this.data[\'text\'] = ((this.params.alert_subject !== \'\') ? this.params.alert_subject + \'\\n\' : \'\') + this.params.alert_message;\r\n	if ([\'markdown\', \'html\', \'markdownv2\'].indexOf(this.params.api_parse_mode.toLowerCase()) !== -1) {\r\n		this.data[\'parse_mode\'] = this.params.api_parse_mode.toLowerCase();\r\n		this.data[\'text\'] = escapeMarkup(this.data[\'text\'], this.data[\'parse_mode\']);\r\n	}\r\n	const reply_to_message_id = this.getMessageID(this.data[\'chat_id\'], this.data[\'message_thread_id\']);\r\n	if (reply_to_message_id !== null) {\r\n		this.data[\'reply_to_message_id\'] = reply_to_message_id;\r\n	}\r\n	this.result = {tags: {}};\r\n};\r\n\r\nTelegram.prototype.onEvent = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	Logger.log(Logger.INFO, \'URL: \' + this.params.url.replace(this.params.api_token, \'<TOKEN>\'));\r\n	var response = this.request.jsonRequest(\'POST\', this.params.url + this.params.api_token + \'/sendMessage\', this.data);\r\n\r\n	if (this.request.getStatus() !== 200 || !CParamValidator.isType(response.ok, \'boolean\') || response.ok !== true) {\r\n		Logger.log(Logger.INFO, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.description, \'string\')) {\r\n			throw response.description;\r\n		}\r\n		else {\r\n			throw \'Unknown error. Check debug log for more information.\';\r\n		}\r\n	}\r\n\r\n	if (CParamValidator.isDefined(response.result.message_id) && this.getMessageID(this.data[\'chat_id\'], this.data[\'message_thread_id\']) === null) {\r\n		this.result.tags[\'__telegram_msg_id_\' + this.data[\'chat_id\'] + (this.data[\'message_thread_id\'] ? \'_\' + this.data[\'message_thread_id\'] : \'\')] = response.result.message_id;\r\n	}\r\n\r\n	return this.result;\r\n};\r\n\r\ntry {\r\n	var hook = new Telegram(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','0','','','This media type integrates your Zabbix installation with Telegram using the Zabbix webhook feature.\r\n\r\nTelegram configuration:\r\n\r\n1. Register a new Telegram bot: send "/newbot" to "@BotFather" and follow the instructions. The token provided by "@BotFather" in the final step will be needed for configuring the Zabbix webhook.\r\n\r\n2. Set up personal or group notifications:\r\n\r\n2.1 Personal notifications:\r\n\r\n2.1.1 Retrieve the chat ID of the user the bot should send messages to. The user should send "/getid" to "@myidbot" in the Telegram messenger.\r\n\r\n2.1.2 The user should also send "/start" to the bot created in step 1. If you skip this step, the Telegram bot won\'t be able to send messages to the user (bots cannot initiate conversations with users).\r\n\r\n2.2 Group notifications:\r\n\r\n2.2.1 Retrieve the group ID of the group that the bot should send messages to. Add "@myidbot" and the bot created in step 1 to your group.\r\n\r\n2.2.2 In the group chat, send: "/getgroupid@myidbot".\r\n\r\n2.2.3 If the bot is added to a supergroup and you want the bot to send messages to a specific topic instead of the default "General" channel, right-click any message in that topic and click "Copy Message Link". The copied link will have the following format: "https://t.me/c/<short_group_id>/<topic_id>/<message_id>", for example: "https://t.me/c/1234567890/2/1". In this example, the topic ID is "2".\r\n\r\nNote:\r\n- The group ID is a negative number, for example: "-1234567890".\r\n- The supergroup ID is a negative number prefixed with "-100", for example: "-1001234567890"\r\n- The public group or supergroup ID can also be specified in media type properties as a name prefixed by "@", for example: "@MyGroupName".\r\n\r\n3. Depending on where you want to send notifications, copy and save the bot token, personal chat ID or group ID, and topic ID (if you want to send messages to a specific supergroup topic), as you will need these later to set up the media type in Zabbix.\r\n\r\nZabbix configuration:\r\n\r\n1. Set the following webhook parameters:\r\n- "api_parse_mode" - the formatting mode applied for messages (possible values: "markdown", "html", "markdownv2")\r\n- "api_token" - the token of the bot used to send messages\r\n\r\nLearn more about message formatting options in Telegram Bot API documentation:\r\n- Markdown: https://core.telegram.org/bots/api#markdown-style\r\n- HTML: https://core.telegram.org/bots/api#html-style\r\n- MarkdownV2: https://core.telegram.org/bots/api#markdownv2-style\r\n\r\nNote: Your Telegram-related actions should be separated from other notification types (e.g., SMS); otherwise, if you use Markdown or HTML in the alert subject or body, you may receive plain-text alerts with raw tags.\r\n\r\n2. Click the "Enabled" checkbox to enable the media type and click the "Update" button to save the webhook settings.\r\n\r\n3. Create a Zabbix user and add media:\r\n- To create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).\r\n- Make sure this user has access to all hosts for which you would like problem notifications to be sent to Zammad.\r\n- In the "Media" tab, click "Add" and select the type "Telegram" from the drop-down list.\r\n- In the "Send to" field, specify the Telegram user chat ID or group ID that you retrieved during Telegram setup. To send notifications to a specific topic within a supergroup, specify the topic ID after the semicolon delimiter in the format "<group_id>:<topic_id>", for example: "-1001234567890:2", "@MyGroupName:2".\r\n\r\n4. Done! You can now start using this media type in actions and create tickets.\r\n\r\nYou can find the latest version of this media and additional information in the official Zabbix repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/telegram','0'),
('98','4','TOPdesk','','','','','','','','25','0','0','0','0','1','3','10s','1','var Media = {\r\n    params: {},\r\n    name: \'\',\r\n    labels: [],\r\n    HTTPProxy: \'\',\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Media.params = params;\r\n        Media.params.api += Media.params.api.endsWith(\'/\') ? \'\' : \'/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        if (typeof HTTPProxy !== \'undefined\' && HTTPProxy.trim() !== \'\') {\r\n            Media.HTTPProxy = HTTPProxy;\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'api\', \'token\'].forEach(function (field) {\r\n            if (typeof Media.params !== \'object\' || typeof Media.params[field] === \'undefined\'\r\n                    || Media.params[field] === \'\') {\r\n                throw \'Required \' + Media.name + \' param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Media.params.api + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Accept: application/json\');\r\n        request.addHeader(\'Authorization: \' + Media.params.token);\r\n        request.setProxy(Media.HTTPProxy);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse response.\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null) {\r\n                if (typeof response.errors === \'object\' && Object.keys(response.errors).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errors);\r\n                }\r\n                else if (typeof response.errorMessages === \'object\' && Object.keys(response.errorMessages).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errorMessages);\r\n                }\r\n                else if (typeof response.message === \'string\') {\r\n                    message += \': \' + response.message;\r\n                }\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    }\r\n};\r\n\r\ntry {\r\n    var result = {tags: {}},\r\n        params = JSON.parse(value),\r\n        media = {},\r\n        fields = {},\r\n        resp = {},\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\',\r\n            \'topdesk_api\',\r\n            \'topdesk_user\',\r\n            \'topdesk_password\'\r\n        ],\r\n        severities = [\r\n            \'not_classified\',\r\n            \'information\',\r\n            \'warning\',\r\n            \'average\',\r\n            \'high\',\r\n            \'disaster\',\r\n            \'resolved\',\r\n            \'default\'\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n            if (key.startsWith(\'topdesk_\')) {\r\n                media[key.substring(8)] = params[key];\r\n            }\r\n        });\r\n\r\n    // Possible values of event_source:\r\n    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check event_value for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_update_status only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_id for a numeric value.\r\n    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {\r\n        throw \'Incorrect "event_id" parameter given: \' + params.event_id + \'\\nMust be a positive number.\';\r\n    }\r\n\r\n    if ((params.event_source === \'1\' || params.event_source === \'2\')  && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for Trigger and Internal actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity]];\r\n    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n    Media.name = \'TOPdesk\';\r\n    Media.setParams(media);\r\n    Media.params.token = \'Basic \' + btoa(Media.params.user + \':\' + Media.params.password);\r\n    Media.setProxy(params.HTTPProxy);\r\n\r\n    // Create an issue.\r\n    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).\r\n    // Numeric value of the problem update status. Possible values:\r\n    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)\r\n            || (params.event_source == 3 && params.event_value == 1)\r\n            || params.event_source == 1 || params.event_source == 2) {\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Request of the ticket creating.\');\r\n        fields.caller = {dynamicName: \'Zabbix\'};\r\n        fields.briefDescription = params.alert_subject;\r\n        fields.request = params.alert_message.replace(/\\n/g, \'<br>\');\r\n        fields.priority = {name: priority};\r\n        fields.processingStatus = {name: Media.params.status};\r\n        fields.externalNumber = params.event_id;\r\n        fields.request += \'<br>\' + params.zbxurl;\r\n\r\n        if (params.event_source === \'0\') {\r\n            fields.request += \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id;\r\n        }\r\n\r\n        resp = Media.request(\'post\', \'tas/api/incidents\', fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.id === \'undefined\') {\r\n            throw \'Cannot create \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {\r\n            result.tags.__zbx_tpd_issuekey = resp.response.number;\r\n            result.tags.__zbx_tpd_issuelink = Media.params.api +\r\n                \'tas/secure/incident?action=show&unid=\' + resp.response.id;\r\n        }\r\n    }\r\n    // Update a created issue.\r\n    else {\r\n        if (params.event_source == 3 && params.event_value == 0) {\r\n            throw \'Internal event recovery actions are not supported.\';\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Request of the ticket updating.\');\r\n        fields.action = params.alert_message.replace(/\\n/g, \'<br>\');\r\n\r\n        resp = Media.request(\'put\', \'tas/api/incidents/number/\' + Media.params.issue_key, fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.id === \'undefined\'\r\n                || resp.response.number !== Media.params.issue_key) {\r\n            throw \'Cannot update \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ \' + Media.name + \' Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_tpd_issuelink}','TOPdesk: {EVENT.TAGS.__zbx_tpd_issuekey}','Please refer to https://developers.topdesk.com/documentation/index.html and https://www.zabbix.com/documentation/7.4/manual/config/notifications/media/webhook#example_scripts.\r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "TOPdesk".\r\nChange the values of the variables topdesk_api (URL), topdesk_password, topdesk_user. The topdesk_status is the default status for creating a new TOPdesk ticket.','0'),
('99','4','VictorOps','','','','','','','','25','0','0','0','0','1','3','10s','1','var VictorOps = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        VictorOps.params = params;\r\n        if (VictorOps.params.endpoint) {\r\n            if (!VictorOps.params.endpoint.endsWith(\'/\')) {\r\n                VictorOps.params.endpoint += \'/\';\r\n            }\r\n\r\n            if (typeof VictorOps.params.routing_key !== \'undefined\'\r\n                    && VictorOps.params.routing_key !== \'{ALERT.SENDTO}\'\r\n                    && VictorOps.params.routing_key !== \'Default\') {\r\n                VictorOps.params.endpoint += VictorOps.params.routing_key;\r\n            }\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        VictorOps.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addFields: function (fields) {\r\n        var data = {};\r\n\r\n        if (typeof fields === \'object\') {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (fields[field] === \'\') {\r\n                        Zabbix.log(4, \'[ VictorOps Webhook ] Field "\' + field +\r\n                            \'" can\\\'t be empty. The field ignored.\');\r\n                    }\r\n                    else {\r\n                        try {\r\n                            var parts = field.split(\':\'),\r\n                                prefix = parts[0].split(\'_\');\r\n\r\n                            if (typeof prefix[1] === \'undefined\'\r\n                                    || (prefix[1] === \'p\' && params.event_value === \'1\'\r\n                                        && (params.event_update_status === \'0\'\r\n                                            || params.event_update_status === \'{EVENT.UPDATE.STATUS}\'))\r\n                                    || (prefix[1] === \'r\' && params.event_value === \'0\'\r\n                                        && (params.event_update_status === \'0\'\r\n                                            || params.event_update_status === \'{EVENT.UPDATE.STATUS}\'))\r\n                                    || (prefix[1] === \'u\' && params.event_update_status === \'1\')) {\r\n                                data[field.substring(field.indexOf(\':\') + 1)] = fields[field];\r\n                            }\r\n                        }\r\n                        catch (error) {\r\n                            Zabbix.log(4, \'[ VictorOps Webhook ] Can\\\'t parse field "\' + field +\r\n                                \'". The field ignored.\');\r\n                        }\r\n                    }\r\n                });\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (data) {\r\n        if (typeof VictorOps.params !== \'object\' || typeof VictorOps.params.endpoint === \'undefined\'\r\n                || VictorOps.params.endpoint === \'\' ) {\r\n            throw \'Required parameter is not set: "vops_endpoint".\';\r\n        }\r\n\r\n        var response,\r\n            url = VictorOps.params.endpoint,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n\r\n        if (typeof VictorOps.HTTPProxy !== \'undefined\' && VictorOps.HTTPProxy !== \'\') {\r\n            request.setProxy(VictorOps.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ VictorOps Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        response = request.post(url, data);\r\n\r\n        Zabbix.log(4, \'[ VictorOps Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ VictorOps Webhook ] Failed to parse response received from VictorOps\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.messages !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.messages);\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return response;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        vops = {},\r\n        required_params = [\'event_source\', \'event_value\', \'priority_update\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'vops_\')) {\r\n                vops[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'field\')) {\r\n                fields[key.substring(5)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (params.event_update_status === \'1\') {\r\n        fields[\':message_type\'] = params.priority_update;\r\n    }\r\n    else {\r\n        fields[\':message_type\'] = params[\'priority_\' + severities[params.event_nseverity].name]\r\n            || \'INFO\';\r\n    }\r\n\r\n    if (params.event_info && params.event_source === \'0\') {\r\n        fields[\':event_info\'] = params.event_info;\r\n    }\r\n\r\n    VictorOps.setParams(vops);\r\n    VictorOps.setProxy(params.HTTPProxy);\r\n    VictorOps.request(VictorOps.addFields(fields));\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ VictorOps Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','','0'),
('100','4','Zammad','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nvar ZABBIX_SEVERITY_MAP = ["not_classified", "information", "warning", "average", "high", "disaster"],\r\n	serviceLogName = \'Zammad Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	Zammad = CWebhook;\r\n\r\nZammad.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		alert_message: {type: \'string\'},\r\n		alert_subject: {type: \'string\'},\r\n		zammad_url: {type: \'string\', url: true},\r\n		zammad_customer: {type: \'string\'},\r\n		zammad_access_token: {type: \'string\'},\r\n		zammad_group: {type: \'string\'},\r\n		zammad_enable_tags: {type: \'boolean\', default: false},\r\n		event_nseverity: {type: \'integer\', default: -1},\r\n		zabbix_url: {type: \'string\', url: true}\r\n	}, this.params);\r\n\r\n	if (CParamValidator.inArray(this.params.event_source, [\'0\', \'3\', \'4\'])) {\r\n		CParamValidator.validate({\r\n			event_tags: {type: \'array\', macro: \'EVENT.TAGSJSON\', tags: true, default: {}}\r\n		}, this.params);\r\n	}\r\n\r\n	var priority;\r\n\r\n	if (this.params.event_nseverity >= 0 && this.params.event_nseverity < ZABBIX_SEVERITY_MAP.length) {\r\n		priority = this.params[\'severity_\' + ZABBIX_SEVERITY_MAP[this.params.event_nseverity]];\r\n	}\r\n	this.priority = (CParamValidator.isDefined(priority)) ? priority.trim() : null;\r\n\r\n	this.result = {tags: {}};\r\n};\r\n\r\nZammad.prototype.onProblem = function (alert) {\r\n	if (CParamValidator.isDefined(this.params.event_tags[\'__zbx_zammad_ticket_id\'])) {\r\n		return this.onUpdate(alert);\r\n	}\r\n\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n\r\n	this.request.addHeaders(\'Authorization: Token token=\' + this.params.zammad_access_token);\r\n\r\n	var payload_data = {\r\n		title: this.params.alert_subject,\r\n		group: this.params.zammad_group,\r\n		article: {\r\n			subject: this.params.alert_subject,\r\n			body: this.params.alert_message + \'\\n\' + CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id),\r\n			type: \'note\',\r\n			internal: false\r\n		},\r\n		customer: this.params.zammad_customer\r\n	};\r\n\r\n	if (this.priority) {\r\n		payload_data.priority_id = this.priority;\r\n	}\r\n\r\n	const response = this.request.jsonRequest(\'POST\', this.params.zammad_url + \'/api/v1/tickets\', payload_data);\r\n\r\n	if (this.request.getStatus() != 201 || !CParamValidator.isDefined(response.id)) {\r\n		var message = \'Cannot create Zammad ticket. Request failed with status code \' + this.request.getStatus();\r\n\r\n		if (CParamValidator.isDefined(response.error) && Object.keys(response.error).length > 0) {\r\n			message += \': \' + response.error;\r\n		}\r\n\r\n		throw message + \' Check debug log for more information.\';\r\n	}\r\n\r\n	this.result.tags = {\r\n		__zbx_zammad_ticket_id: response.id,\r\n		__zbx_zammad_ticketlink: this.params.zammad_url + \'/#ticket/zoom/\' + response.id\r\n	};\r\n\r\n	if (this.params.zammad_enable_tags && Object.keys(this.params.event_tags).length > 0 && CParamValidator.inArray(this.params.event_source, [\'0\', \'3\', \'4\'])) {\r\n		this.request.clearHeader();\r\n		this.request.addHeaders({\r\n			"Content-Type": "application/json",\r\n			"Authorization": "Token token=" + this.params.zammad_access_token\r\n		});\r\n\r\n		payload_data = {\r\n			item: \'\',\r\n			object: \'Ticket\',\r\n			o_id: response.id\r\n		};\r\n\r\n		try {\r\n			for (var tag in this.params.event_tags) {\r\n				payload_data.item = tag;\r\n\r\n				if (this.params.event_tags[tag]) {\r\n					payload_data.item += ": " + this.params.event_tags[tag];\r\n				}\r\n\r\n				this.request.plainRequest(\'POST\', this.params.zammad_url + \'/api/v1/tags/add\', JSON.stringify(payload_data));\r\n\r\n				if (this.request.getStatus() != 201) {\r\n					Logger.log(Logger.INFO, \'Failed to set tag: \' + tag);\r\n				}\r\n			}\r\n		}\r\n		catch (error) {\r\n			Logger.log(Logger.INFO, \'Failed to add ticket tags: \' + error);\r\n		}\r\n	}\r\n\r\n	return this.result;\r\n}\r\n\r\nZammad.prototype.onUpdate = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n\r\n	if (!CParamValidator.isDefined(this.params.event_tags[\'__zbx_zammad_ticket_id\'])) {\r\n		throw "Failed to update the existing ticket: no ticket ID was received."\r\n	}\r\n\r\n\r\n	this.request.addHeaders(\'Authorization: Token token=\' + this.params.zammad_access_token);\r\n\r\n	const payload_data = {\r\n		ticket_id: this.params.event_tags[\'__zbx_zammad_ticket_id\'],\r\n		subject: this.params.alert_subject,\r\n		body: this.params.alert_message,\r\n		type: \'note\',\r\n		internal: false\r\n	};\r\n\r\n	const response = this.request.jsonRequest(\'POST\', this.params.zammad_url + \'/api/v1/ticket_articles\', payload_data);\r\n\r\n	if (this.request.getStatus() != 201 || !CParamValidator.isDefined(response.id)) {\r\n		var message = \'Cannot update Zammad ticket. Request failed with status code \' + this.request.getStatus();\r\n\r\n		if (CParamValidator.isDefined(response.error) && Object.keys(response.error).length > 0) {\r\n			message += \': \' + response.error;\r\n		}\r\n\r\n		throw message + \' Check debug log for more information.\';\r\n	}\r\n\r\n	return this.result;\r\n}\r\n\r\nZammad.prototype.onResolve = function (alert) {\r\n	return this.onUpdate(alert);\r\n}\r\n\r\nZammad.prototype.onDiscovery = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\nZammad.prototype.onAutoreg = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\ntry {\r\n	var hook = new Zammad(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_zammad_ticketlink}','Zammad: Ticket #{EVENT.TAGS.__zbx_zammad_ticket_id}','This media type integrates your Zabbix installation with your Zammad installation using the Zabbix webhook feature.\r\n\r\nZammad configuration:\r\n\r\n1. Check that API Token Access is enabled in "Settings" → "System" → "API".\r\n2. Open the profile settings of the customer user and create a new Personal User Token.\r\n3. Set the "ticket.agent" permission for the token and press Create.\r\n4. Copy and save the created token somewhere, as it will be shown only once for security reasons.\r\n\r\nZabbix configuration:\r\n\r\n1. Before you can start using Zammad webhook, set up the global macro "{$ZABBIX.URL}":\r\n- In the Zabbix web interface, go to "Administration" → "Macros" section in the dropdown menu in the top left corner.\r\n- Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.\r\n- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration you might also need to append "/zabbix" to the end of URL. Good examples:\r\n  - http://zabbix.com\r\n  - https://zabbix.lan/zabbix\r\n  - http://server.zabbix.lan/\r\n  - http://localhost\r\n  - http://127.0.0.1:8080\r\n- Bad examples:\r\n  - zabbix.com\r\n  - http://zabbix/\r\n\r\n2. Set the following webhook parameters:\r\n- zammad_access_token - the access token that you created during Zammad configuration\r\n- zammad_url - the frontend URL of your Zammad installation\r\n- zammad_customer - the Zammad user email\r\n- zammad_enable_tags - if you want to add the Zabbix event tags to the Zammad tickets that are created, you can set it to one of the following values: "1", "true", "yes", "on" (note, that if the tag support is enabled, each tag is sent via separate HTTP request and created tags will also remain in the Zammad when tickets are closed/deleted)\r\n- zammad_group - if needed, you can change the Zammad user group\r\n\r\n3. If you want to prioritize issues according to the severity values in Zabbix, you can define mapping parameters (create them as additional webhook parameters):\r\n- severity_<name> - the Zammad priority ID (<name> in the parameter name can be one of the following values: "not_classified", "information", "warning", "average", "high", "disaster")\r\n\r\n4. Create a Zabbix user and add media:\r\n- If you want to create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).\r\n- In the "Media" tab, add a new media and select "Zammad" type from the drop-down list. Add any value to the "Send to" field: it is required to be filled, but it is not used.\r\n- Make sure this user has access to all hosts for which you would like problem notifications to be sent to Zammad.\r\n\r\n5. Great! You can now start using this media type in actions and create tickets!\r\n\r\nYou can find the latest version of this media and additional information in the official Zabbix repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/zammad','0'),
('101','4','Zendesk','','','','','','','','25','0','0','0','0','1','3','10s','1','var Zendesk = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Zendesk.params = params;\r\n        if (typeof Zendesk.params.url === \'string\') {\r\n            if (!Zendesk.params.url.endsWith(\'/\')) {\r\n                Zendesk.params.url += \'/\';\r\n            }\r\n            Zendesk.params.url += \'api/v2/\';\r\n        }\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Zendesk.getSchema(),\r\n                arr = [],\r\n                i,\r\n                n;\r\n\r\n            if (schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        for (i = 0, n = schema.ticket_fields.length; i < n; i++) {\r\n                            if (schema.ticket_fields[i].id == field\r\n                                && [\'text\', \'integer\', \'date\'].indexOf(schema.ticket_fields[i].type) !== -1){\r\n\r\n                                switch (schema.ticket_fields[i].type) {\r\n                                    case \'integer\':\r\n                                        fields[field] = parseInt(fields[field]);\r\n                                        break;\r\n                                    case \'date\':\r\n                                        if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/) !== null) {\r\n                                            fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                                        }\r\n                                        else {\r\n                                            fields[field] = \'\';\r\n                                        }\r\n                                        break;\r\n                                }\r\n\r\n                                arr.push({id: field, value: fields[field]});\r\n                                break;\r\n                            }\r\n                        }\r\n                    });\r\n\r\n                if (arr.length) {\r\n                    data.ticket[\'custom_fields\'] = arr;\r\n                }\r\n            }\r\n            else {\r\n                Zabbix.log(4, \'[Zendesk Webhook] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'token\', \'type\'].forEach(function (field) {\r\n            if (typeof Zendesk.params !== \'object\' || typeof Zendesk.params[field] === \'undefined\') {\r\n                throw \'Required Zendesk param is not set: \' + field + \'\\n\' + Zendesk.params[field];\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Zendesk.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        if (typeof Zendesk.HTTPProxy === \'string\' && Zendesk.HTTPProxy.trim() !== \'\') {\r\n            request.setProxy(Zendesk.HTTPProxy);\r\n        }\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: Basic \' + btoa(Zendesk.params.token));\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[Zendesk Webhook] Sending request: \' + url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[Zendesk Webhook] Received response with status code \' + request.getStatus() + \'. \' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[Zendesk Webhook] Failed to parse response received from Zendesk.\');\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.error !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n            else if (response !== null && typeof response.description !== \'undefined\'\r\n                && Object.keys(response.description).length > 0) {\r\n                message += \': \' + JSON.stringify(response.description);\r\n            }\r\n            else {\r\n                message += \'. \' + response;\r\n            }\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Zendesk.request(\'get\', \'ticket_fields.json\');\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(data, fields) {\r\n        var result = Zendesk.request(\'post\', \'tickets.json\', Zendesk.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.ticket.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot create Zendesk issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.ticket.id;\r\n    },\r\n\r\n    updateIssue: function(data, fields) {\r\n        Zendesk.request(\'put\', \'tickets/\' + Zendesk.params.issue_key + \'.json\', Zendesk.addCustomFields(data, fields));\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        zendesk = {},\r\n        update = {},\r\n        data = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'zendesk_\')) {\r\n                zendesk[key.substring(8)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key.substring(12)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter \' + key + \' cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    // Possible values: question, incident, problems, task\r\n    if ([\'question\', \'incident\', \'problem\', \'task\'].indexOf(params.zendesk_type) === -1) {\r\n        throw \'Incorrect "zendesk_type" parameter given: \' + params.zendesk_type +\r\n            \'\\nMust be one of question, incident, problem, task.\';\r\n    }\r\n\r\n    // Possible values: 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    // Zendesk_issue_key must be a positive integer if an update action is being performed.\r\n    if (params.event_source === \'0\' && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n        || (params.event_value === \'0\' && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.zendesk_issue_key)) || parseInt(params.zendesk_issue_key) < 1 )) {\r\n        throw \'Incorrect "zendesk_issue_key" parameter given: \' + params.zendesk_issue_key +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name] || severities[7].name;\r\n\r\n    Zendesk.setParams(zendesk);\r\n    Zendesk.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_value !== \'0\') {\r\n        data = {\r\n            ticket: {\r\n                external_id: params.event_id,\r\n                type: Zendesk.params.type,\r\n                status: \'new\',\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.alert_message,\r\n                    public: \'false\'\r\n                },\r\n                priority: priority,\r\n                tags: params.event_tags\r\n            }\r\n        };\r\n\r\n        Zendesk.createIssue(data, fields);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\') {\r\n        data = {\r\n            ticket: {\r\n                external_id: params.event_id,\r\n                type: Zendesk.params.type,\r\n                status: \'new\',\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\') + \'tr_events.php?triggerid=\' +\r\n                        params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\' + params.alert_message,\r\n                    public: \'false\'\r\n                },\r\n                priority: priority,\r\n                tags: params.event_tags\r\n            }\r\n        };\r\n        var key = Zendesk.createIssue(data, fields);\r\n\r\n        result.tags.__zbx_zdk_issuekey = key;\r\n        result.tags.__zbx_zdk_issuelink = params.zendesk_url +\r\n            (params.zendesk_url.endsWith(\'/\') ? \'\' : \'/\') + \'agent/tickets/\' + key;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        data = {\r\n            ticket: {\r\n                type: Zendesk.params.type,\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.alert_message,\r\n                    public: \'false\'\r\n                }\r\n            }\r\n        };\r\n\r\n        Zendesk.updateIssue(data, fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[Zendesk Webhook] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_zdk_issuelink}','Zendesk: {EVENT.TAGS.__zbx_zdk_issuekey}','','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`,`sortorder`) VALUES ('646','70','endpoint','<PLACE HTTP API URL>','0'),
('647','70','flash','false','0'),
('648','70','password','<PLACE PASSWORD>','0'),
('649','70','ring','false','0'),
('650','70','send_to','{ALERT.SENDTO}','0'),
('651','70','telauto','true','0'),
('652','70','text','{ALERT.MESSAGE}','0'),
('653','70','username','<PLACE USERNAME>','0'),
('654','71','alert_message','{ALERT.MESSAGE}','0'),
('655','71','alert_subject','{ALERT.SUBJECT}','0'),
('656','71','discord_endpoint','{ALERT.SENDTO}','0'),
('657','71','event_id','{EVENT.ID}','0'),
('658','71','event_nseverity','{EVENT.NSEVERITY}','0'),
('659','71','event_severity','{EVENT.SEVERITY}','0'),
('660','71','event_source','{EVENT.SOURCE}','0'),
('661','71','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('662','71','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('663','71','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('664','71','event_value','{EVENT.VALUE}','0'),
('665','71','trigger_id','{TRIGGER.ID}','0'),
('666','71','user_agent','ZabbixServer (zabbix.com, 7.4)','0'),
('667','71','zabbix_url','{$ZABBIX.URL}','0'),
('668','72','acknowledged','{EVENT.ACK.STATUS}','0'),
('669','72','endpoint','/endpoint','0'),
('670','72','event_date','{EVENT.DATE}','0'),
('671','72','event_id','{EVENT.ID}','0'),
('672','72','event_name','{EVENT.NAME}','0'),
('673','72','event_nseverity','{EVENT.NSEVERITY}','0'),
('674','72','event_object','{EVENT.OBJECT}','0'),
('675','72','event_severity','{EVENT.SEVERITY}','0'),
('676','72','event_source','{EVENT.SOURCE}','0'),
('677','72','event_tags','{EVENT.TAGSJSON}','0'),
('678','72','event_time','{EVENT.TIME}','0'),
('679','72','event_value','{EVENT.VALUE}','0'),
('680','72','host_groups','{TRIGGER.HOSTGROUP.NAME}','0'),
('681','72','host_host','{HOST.HOST}','0'),
('682','72','host_id','{HOST.ID}','0'),
('683','72','host_ip','{HOST.IP}','0'),
('684','72','host_port','{HOST.PORT}','0'),
('685','72','HTTPProxy','','0'),
('686','72','monitoring_source','Zabbix sever','0'),
('687','72','operation_data','{EVENT.OPDATA}','0'),
('688','72','send_to','{ALERT.SENDTO}','0'),
('689','72','subject','{ALERT.SUBJECT}','0'),
('690','72','trigger_description','{TRIGGER.DESCRIPTION}','0'),
('691','72','trigger_id','{TRIGGER.ID}','0'),
('692','72','trigger_name','{TRIGGER.NAME}','0'),
('693','73','event_source','{EVENT.SOURCE}','0'),
('694','73','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('695','73','event_value','{EVENT.VALUE}','0'),
('696','73','express_message','{ALERT.MESSAGE}','0'),
('697','73','express_send_to','{ALERT.SENDTO}','0'),
('698','73','express_tags','{EVENT.TAGSJSON}','0'),
('699','73','express_token','<PLACE BOT TOKEN>','0'),
('700','73','express_url','<PLACE INSTANCE URL>','0'),
('701','74','alert_message','{ALERT.MESSAGE}','0'),
('702','74','alert_subject','{ALERT.SUBJECT}','0'),
('703','74','event_id','{EVENT.ID}','0'),
('704','74','event_nseverity','{EVENT.NSEVERITY}','0'),
('705','74','event_severity','{EVENT.SEVERITY}','0'),
('706','74','event_source','{EVENT.SOURCE}','0'),
('707','74','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('708','74','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('709','74','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('710','74','event_value','{EVENT.VALUE}','0'),
('711','74','github_api_version','2022-11-28','0'),
('712','74','github_issue_number','{EVENT.TAGS.__zbx_github_issue_number}','0'),
('713','74','github_repo','{ALERT.SENDTO}','0'),
('714','74','github_token','<PLACE GITHUB TOKEN>','0'),
('715','74','github_url','https://api.github.com','0'),
('716','74','github_user_agent','Zabbix/7.4','0'),
('717','74','github_zabbix_event_priority_label_prefix','Zabbix Event Priority:','0'),
('718','74','github_zabbix_event_source_label_prefix','Zabbix Event Source:','0'),
('719','74','github_zabbix_event_status_label_prefix','Zabbix Event Status:','0'),
('720','74','github_zabbix_generic_label','Zabbix GitHub Webhook','0'),
('721','74','trigger_id','{TRIGGER.ID}','0'),
('722','74','zabbix_url','{$ZABBIX.URL}','0'),
('723','75','alert_message','{ALERT.MESSAGE}','0'),
('724','75','alert_subject','{ALERT.SUBJECT}','0'),
('725','75','event_id','{EVENT.ID}','0'),
('726','75','event_nseverity','{EVENT.NSEVERITY}','0'),
('727','75','event_severity','{EVENT.SEVERITY}','0'),
('728','75','event_source','{EVENT.SOURCE}','0'),
('729','75','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('730','75','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('731','75','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('732','75','event_value','{EVENT.VALUE}','0'),
('733','75','glpi_problem_id','{EVENT.TAGS.__zbx_glpi_problem_id}','0'),
('734','75','glpi_token','<PLACE GLPI TOKEN>','0'),
('735','75','glpi_url','<PLACE GLPI URL>','0'),
('736','75','trigger_id','{TRIGGER.ID}','0'),
('737','75','zabbix_url','{$ZABBIX.URL}','0'),
('738','76','.ILERT.ALERT.SOURCE.KEY','{ALERT.SENDTO}','0'),
('739','76','.ILERT.INCIDENT.SUMMARY','','0'),
('740','76','ALERT.MESSAGE','{ALERT.MESSAGE}','0'),
('741','76','ALERT.SUBJECT','{ALERT.SUBJECT}','0'),
('742','76','EVENT.ACK.STATUS','{EVENT.ACK.STATUS}','0'),
('743','76','EVENT.DATE','{EVENT.DATE}','0'),
('744','76','EVENT.ID','{EVENT.ID}','0'),
('745','76','EVENT.NAME','{EVENT.NAME}','0'),
('746','76','EVENT.NSEVERITY','{EVENT.NSEVERITY}','0'),
('747','76','EVENT.OPDATA','{EVENT.OPDATA}','0'),
('748','76','EVENT.RECOVERY.DATE','{EVENT.RECOVERY.DATE}','0'),
('749','76','EVENT.RECOVERY.TIME','{EVENT.RECOVERY.TIME}','0'),
('750','76','EVENT.RECOVERY.VALUE','{EVENT.RECOVERY.VALUE}','0'),
('751','76','EVENT.SEVERITY','{EVENT.SEVERITY}','0'),
('752','76','EVENT.TAGS','{EVENT.TAGS}','0'),
('753','76','EVENT.TIME','{EVENT.TIME}','0'),
('754','76','EVENT.UPDATE.ACTION','{EVENT.UPDATE.ACTION}','0'),
('755','76','EVENT.UPDATE.DATE','{EVENT.UPDATE.DATE}','0'),
('756','76','EVENT.UPDATE.MESSAGE','{EVENT.UPDATE.MESSAGE}','0'),
('757','76','EVENT.UPDATE.STATUS','{EVENT.UPDATE.STATUS}','0'),
('758','76','EVENT.UPDATE.TIME','{EVENT.UPDATE.TIME}','0'),
('759','76','EVENT.VALUE','{EVENT.VALUE}','0'),
('760','76','HOST.HOST','{HOST.HOST}','0'),
('761','76','HOST.IP','{HOST.IP}','0'),
('762','76','HOST.NAME','{HOST.NAME}','0'),
('763','76','ITEM.ID1','{ITEM.ID1}','0'),
('764','76','ITEM.ID2','{ITEM.ID2}','0'),
('765','76','ITEM.ID3','{ITEM.ID3}','0'),
('766','76','ITEM.ID4','{ITEM.ID4}','0'),
('767','76','ITEM.ID5','{ITEM.ID5}','0'),
('768','76','ITEM.NAME1','{ITEM.NAME1}','0'),
('769','76','ITEM.NAME2','{ITEM.NAME2}','0'),
('770','76','ITEM.NAME3','{ITEM.NAME3}','0'),
('771','76','ITEM.NAME4','{ITEM.NAME4}','0'),
('772','76','ITEM.NAME5','{ITEM.NAME5}','0'),
('773','76','TRIGGER.DESCRIPTION','{TRIGGER.DESCRIPTION}','0'),
('774','76','TRIGGER.ID','{TRIGGER.ID}','0'),
('775','76','TRIGGER.NAME','{TRIGGER.NAME}','0'),
('776','76','TRIGGER.SEVERITY','{TRIGGER.SEVERITY}','0'),
('777','76','TRIGGER.STATUS','{TRIGGER.STATUS}','0'),
('778','76','TRIGGER.URL','{TRIGGER.URL}','0'),
('779','76','TRIGGER.VALUE','{TRIGGER.VALUE}','0'),
('780','76','USER.FULLNAME','{USER.FULLNAME}','0'),
('781','76','ZABBIX.URL','{$ZABBIX.URL}','0'),
('782','77','alert_message','{ALERT.MESSAGE}','0'),
('783','77','alert_subject','{ALERT.SUBJECT}','0'),
('784','77','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('785','77','event_source','{EVENT.SOURCE}','0'),
('786','77','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('787','77','event_value','{EVENT.VALUE}','0'),
('788','77','itop_api_version','1.3','0'),
('789','77','itop_class','UserRequest','0'),
('790','77','itop_comment','Created by Zabbix action {ACTION.NAME}','0'),
('791','77','itop_id','{EVENT.TAGS.__zbx_itop_id}','0'),
('792','77','itop_log','private_log','0'),
('793','77','itop_organization_id','<PLACE ORGANIZATION ID>','0'),
('794','77','itop_password','<PLACE PASSWORD OR TOKEN>','0'),
('795','77','itop_url','<PLACE YOUR ITOP URL>','0'),
('796','77','itop_user','<PLACE LOGIN>','0'),
('797','78','alert_message','{ALERT.MESSAGE}','0'),
('798','78','alert_subject','{ALERT.SUBJECT}','0'),
('799','78','event_id','{EVENT.ID}','0'),
('800','78','event_nseverity','{EVENT.NSEVERITY}','0'),
('801','78','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('802','78','event_severity','{EVENT.SEVERITY}','0'),
('803','78','event_source','{EVENT.SOURCE}','0'),
('804','78','event_tags_json','{EVENT.TAGSJSON}','0'),
('805','78','event_update_action','{EVENT.UPDATE.ACTION}','0'),
('806','78','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('807','78','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('808','78','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('809','78','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('810','78','event_update_user','{USER.FULLNAME}','0'),
('811','78','event_value','{EVENT.VALUE}','0'),
('812','78','jira_issue_type','<PLACE ISSUETYPE NAME>','0'),
('813','78','jira_password','<PLACE PASSWORD OR TOKEN>','0'),
('814','78','jira_priority_autoregistration','Low','0'),
('815','78','jira_priority_discovery','Low','0'),
('816','78','jira_priority_internal','Low','0'),
('817','78','jira_project_key','<PLACE PROJECT KEY>','0'),
('818','78','jira_url','<PLACE YOUR JIRA URL>','0'),
('819','78','jira_user','<PLACE LOGIN>','0'),
('820','78','severity_average','Medium','0'),
('821','78','severity_disaster','Highest','0'),
('822','78','severity_high','High','0'),
('823','78','severity_information','Lowest','0'),
('824','78','severity_not_classified','Lowest','0'),
('825','78','severity_warning','Low','0'),
('826','78','trigger_description','{TRIGGER.DESCRIPTION}','0'),
('827','78','trigger_id','{TRIGGER.ID}','0'),
('828','78','zabbix_url','{$ZABBIX.URL}','0'),
('829','79','alert_message','{ALERT.MESSAGE}','0'),
('830','79','alert_subject','{ALERT.SUBJECT}','0'),
('831','79','event_id','{EVENT.ID}','0'),
('832','79','event_nseverity','{EVENT.NSEVERITY}','0'),
('833','79','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('834','79','event_severity','{EVENT.SEVERITY}','0'),
('835','79','event_source','{EVENT.SOURCE}','0'),
('836','79','event_tags_json','{EVENT.TAGSJSON}','0'),
('837','79','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('838','79','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('839','79','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('840','79','event_value','{EVENT.VALUE}','0'),
('841','79','issue_comments_public','false','0'),
('842','79','jira_password','<PLACE PASSWORD OR TOKEN>','0'),
('843','79','jira_priority_autoregistration','Low','0'),
('844','79','jira_priority_discovery','Low','0'),
('845','79','jira_priority_internal','Low','0'),
('846','79','jira_request_type_id','<PLACE REQUEST TYPE ID>','0'),
('847','79','jira_servicedesk_id','<PLACE SERVICEDESK ID>','0'),
('848','79','jira_url','<PLACE YOUR JIRA URL>','0'),
('849','79','jira_user','<PLACE LOGIN>','0'),
('850','79','severity_average','Medium','0'),
('851','79','severity_disaster','Highest','0'),
('852','79','severity_high','High','0'),
('853','79','severity_information','Lowest','0'),
('854','79','severity_not_classified','Lowest','0'),
('855','79','severity_warning','Low','0'),
('856','79','trigger_id','{TRIGGER.ID}','0'),
('857','79','zabbix_url','{$ZABBIX.URL}','0'),
('858','80','alert_message','{ALERT.MESSAGE}','0'),
('859','80','alert_subject','{ALERT.SUBJECT}','0'),
('860','80','bot_token','<PLACE BOT TOKEN>','0'),
('861','80','event_id','{EVENT.ID}','0'),
('862','80','event_nseverity','{EVENT.NSEVERITY}','0'),
('863','80','event_source','{EVENT.SOURCE}','0'),
('864','80','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('865','80','event_value','{EVENT.VALUE}','0'),
('866','80','send_to','{ALERT.SENDTO}','0'),
('867','80','trigger_description','{TRIGGER.DESCRIPTION}','0'),
('868','80','trigger_id','{TRIGGER.ID}','0'),
('869','80','zabbix_url','{$ZABBIX.URL}','0'),
('870','81','event_nseverity','{EVENT.NSEVERITY}','0'),
('871','81','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('872','81','event_source','{EVENT.SOURCE}','0'),
('873','81','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('874','81','event_value','{EVENT.VALUE}','0'),
('875','81','field_ref:requester','<PLACE API USER NAME>','0'),
('876','81','field_string:description','{ALERT.MESSAGE}','0'),
('877','81','field_string:subject','{ALERT.SUBJECT}','0'),
('878','81','priority_average','Normal','0'),
('879','81','priority_default','Normal','0'),
('880','81','priority_disaster','High','0'),
('881','81','priority_high','High','0'),
('882','81','priority_information','Low','0'),
('883','81','priority_not_classified','Low','0'),
('884','81','priority_warning','Medium','0'),
('885','81','sd_on_demand_client_id','<PLACE ON DEMAND CLIENT ID>','0'),
('886','81','sd_on_demand_client_secret','<PLACE ON DEMAND CLIENT SECRET>','0'),
('887','81','sd_on_demand_refresh_token','<PLACE ON DEMAND REFRESH TOKEN>','0'),
('888','81','sd_on_demand_url_auth','<PLACE AUTHENTICATION URL FOR ON DEMAND>','0'),
('889','81','sd_on_premise','true','0'),
('890','81','sd_on_premise_auth_token','<PLACE ON PREMISE TECHNICIAN_KEY>','0'),
('891','81','sd_request_id','{EVENT.TAGS.__zbx_sd_request_id}','0'),
('892','81','sd_url','<PLACE INSTANCE URL>','0'),
('893','81','trigger_description','{TRIGGER.DESCRIPTION}','0'),
('894','82','alert_message','{ALERT.MESSAGE}','0'),
('895','82','alert_sendto','{ALERT.SENDTO}','0'),
('896','82','alert_subject','{ALERT.SUBJECT}','0'),
('897','82','event_id','{EVENT.ID}','0'),
('898','82','event_nseverity','{EVENT.NSEVERITY}','0'),
('899','82','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('900','82','event_source','{EVENT.SOURCE}','0'),
('901','82','event_tagsjson','{EVENT.TAGSJSON}','0'),
('902','82','event_update_action','{EVENT.UPDATE.ACTION}','0'),
('903','82','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('904','82','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('905','82','event_value','{EVENT.VALUE}','0'),
('906','82','mantisbt_category','[All Projects] General','0'),
('907','82','mantisbt_issue_number','{EVENT.TAGS.__zbx_mantisbt_issue_number}','0'),
('908','82','mantisbt_token','<PLACE MANTISBT TOKEN>','0'),
('909','82','mantisbt_url','<PLACE MANTISBT URL>','0'),
('910','82','mantisbt_use_zabbix_tags','true','0'),
('911','82','trigger_id','{TRIGGER.ID}','0'),
('912','82','zabbix_url','{$ZABBIX.URL}','0'),
('913','83','alert_message','{ALERT.MESSAGE}','0'),
('914','83','alert_subject','{ALERT.SUBJECT}','0'),
('915','83','bot_token','<YOUR BOT TOKEN>','0'),
('916','83','discovery_host_dns','{DISCOVERY.DEVICE.DNS}','0'),
('917','83','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}','0'),
('918','83','event_date','{EVENT.DATE}','0'),
('919','83','event_id','{EVENT.ID}','0'),
('920','83','event_nseverity','{EVENT.NSEVERITY}','0'),
('921','83','event_opdata','{EVENT.OPDATA}','0'),
('922','83','event_recovery_date','{EVENT.RECOVERY.DATE}','0'),
('923','83','event_recovery_time','{EVENT.RECOVERY.TIME}','0'),
('924','83','event_severity','{EVENT.SEVERITY}','0'),
('925','83','event_source','{EVENT.SOURCE}','0'),
('926','83','event_tags','{EVENT.TAGS}','0'),
('927','83','event_time','{EVENT.TIME}','0'),
('928','83','event_update_date','{EVENT.UPDATE.DATE}','0'),
('929','83','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('930','83','event_update_time','{EVENT.UPDATE.TIME}','0'),
('931','83','event_value','{EVENT.VALUE}','0'),
('932','83','host_ip','{HOST.IP}','0'),
('933','83','host_name','{HOST.HOST}','0'),
('934','83','mattermost_url','<YOUR MATTERMOST URL>','0'),
('935','83','send_mode','alarm','0'),
('936','83','send_to','{ALERT.SENDTO}','0'),
('937','83','trigger_description','{TRIGGER.DESCRIPTION}','0'),
('938','83','trigger_id','{TRIGGER.ID}','0'),
('939','83','zabbix_url','{$ZABBIX.URL}','0'),
('940','84','alert_message','{ALERT.MESSAGE}','0'),
('941','84','alert_subject','{ALERT.SUBJECT}','0'),
('942','84','event_date','{EVENT.DATE}','0'),
('943','84','event_id','{EVENT.ID}','0'),
('944','84','event_nseverity','{EVENT.NSEVERITY}','0'),
('945','84','event_opdata','{EVENT.OPDATA}','0'),
('946','84','event_recovery_date','{EVENT.RECOVERY.DATE}','0'),
('947','84','event_recovery_time','{EVENT.RECOVERY.TIME}','0'),
('948','84','event_severity','{EVENT.SEVERITY}','0'),
('949','84','event_source','{EVENT.SOURCE}','0'),
('950','84','event_status','{EVENT.STATUS}','0'),
('951','84','event_tags','{EVENT.TAGS}','0'),
('952','84','event_time','{EVENT.TIME}','0'),
('953','84','event_update_action','{EVENT.UPDATE.ACTION}','0'),
('954','84','event_update_date','{EVENT.UPDATE.DATE}','0'),
('955','84','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('956','84','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('957','84','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('958','84','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('959','84','event_update_time','{EVENT.UPDATE.TIME}','0'),
('960','84','event_update_user','{USER.FULLNAME}','0'),
('961','84','event_value','{EVENT.VALUE}','0'),
('962','84','host_ip','{HOST.IP}','0'),
('963','84','host_name','{HOST.NAME}','0'),
('964','84','teams_endpoint','<PLACE WEBHOOK URL HERE>','0'),
('965','84','trigger_description','{TRIGGER.DESCRIPTION}','0'),
('966','84','trigger_id','{TRIGGER.ID}','0'),
('967','84','use_default_message','false','0'),
('968','84','zabbix_url','{$ZABBIX.URL}','0'),
('969','85','alert_message','{ALERT.MESSAGE}','0'),
('970','85','alert_subject','{ALERT.SUBJECT}','0'),
('971','85','event_id','{EVENT.ID}','0'),
('972','85','event_nseverity','{EVENT.NSEVERITY}','0'),
('973','85','event_severity','{EVENT.SEVERITY}','0'),
('974','85','event_source','{EVENT.SOURCE}','0'),
('975','85','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('976','85','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('977','85','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('978','85','event_value','{EVENT.VALUE}','0'),
('979','85','teams_endpoint','<PLACE WEBHOOK URL HERE>','0'),
('980','85','trigger_id','{TRIGGER.ID}','0'),
('981','85','zabbix_url','{$ZABBIX.URL}','0'),
('982','86','alert_message','{ALERT.MESSAGE}','0'),
('983','86','alert_subject','{ALERT.SUBJECT}','0'),
('984','86','event_id','{EVENT.ID}','0'),
('985','86','event_nseverity','{EVENT.NSEVERITY}','0'),
('986','86','event_source','{EVENT.SOURCE}','0'),
('987','86','event_tags_json','{EVENT.TAGSJSON}','0'),
('988','86','event_update_action','{EVENT.UPDATE.ACTION}','0'),
('989','86','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('990','86','event_value','{EVENT.VALUE}','0'),
('991','86','opsgenie_api','<put your opsgenie api>','0'),
('992','86','opsgenie_tags','','0'),
('993','86','opsgenie_teams','','0'),
('994','86','opsgenie_token','<put your token>','0'),
('995','86','opsgenie_web','<put your opsgenie web>','0'),
('996','86','severity_average','P3','0'),
('997','86','severity_default','P5','0'),
('998','86','severity_disaster','P1','0'),
('999','86','severity_high','P2','0'),
('1000','86','severity_information','P5','0'),
('1001','86','severity_not_classified','P5','0'),
('1002','86','severity_warning','P4','0'),
('1003','86','status_counter','25','0'),
('1004','86','trigger_id','{TRIGGER.ID}','0'),
('1005','86','zbxurl','{$ZABBIX.URL}','0'),
('1006','86','zbxuser','{USER.FULLNAME}','0'),
('1007','87','alert_message','{ALERT.MESSAGE}','0'),
('1008','87','alert_subject','{ALERT.SUBJECT}','0'),
('1009','87','event_id','{EVENT.ID}','0'),
('1010','87','event_nseverity','{EVENT.NSEVERITY}','0'),
('1011','87','event_severity','{EVENT.SEVERITY}','0'),
('1012','87','event_source','{EVENT.SOURCE}','0'),
('1013','87','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('1014','87','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('1015','87','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('1016','87','event_value','{EVENT.VALUE}','0'),
('1017','87','otrs_auth_password','<PUT YOUR USER PASSWORD>','0'),
('1018','87','otrs_auth_user','<PUT YOUR USER NAME>','0'),
('1019','87','otrs_closed_state_id','0','0'),
('1020','87','otrs_customer','<PUT YOUR CUSTOMER EMAIL>','0'),
('1021','87','otrs_default_priority_id','3','0'),
('1022','87','otrs_queue','<PUT YOUR QUEUE NAME>','0'),
('1023','87','otrs_ticket_id','{EVENT.TAGS.__zbx_otrs_ticket_id}','0'),
('1024','87','otrs_ticket_state','new','0'),
('1025','87','otrs_time_unit','0','0'),
('1026','87','otrs_url','<PUT YOUR ((OTRS)) CE URL>','0'),
('1027','87','trigger_id','{TRIGGER.ID}','0'),
('1028','87','zabbix_url','{$ZABBIX.URL}','0'),
('1029','88','alert_message','{ALERT.MESSAGE}','0'),
('1030','88','alert_subject','{ALERT.SUBJECT}','0'),
('1031','88','api_token','{ALERT.SENDTO}','0'),
('1032','88','event_ack','{EVENT.ACK.STATUS}','0'),
('1033','88','event_id','{EVENT.ID}','0'),
('1034','88','event_nseverity','{EVENT.NSEVERITY}','0'),
('1035','88','event_severity','{EVENT.SEVERITY}','0'),
('1036','88','event_source','{EVENT.SOURCE}','0'),
('1037','88','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('1038','88','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('1039','88','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('1040','88','event_value','{EVENT.VALUE}','0'),
('1041','88','host_ip','{HOST.IP}','0'),
('1042','88','host_name','{HOST.NAME}','0'),
('1043','88','trigger_id','{TRIGGER.ID}','0'),
('1044','88','zabbix_url','{$ZABBIX.URL}','0'),
('1045','89','endpoint','https://api.pushover.net/1/messages.json','0'),
('1046','89','eventid','{EVENT.ID}','0'),
('1047','89','event_nseverity','{EVENT.NSEVERITY}','0'),
('1048','89','event_source','{EVENT.SOURCE}','0'),
('1049','89','event_value','{EVENT.VALUE}','0'),
('1050','89','expire','1200','0'),
('1051','89','message','{ALERT.MESSAGE}','0'),
('1052','89','priority_average','0','0'),
('1053','89','priority_default','0','0'),
('1054','89','priority_disaster','0','0'),
('1055','89','priority_high','0','0'),
('1056','89','priority_information','0','0'),
('1057','89','priority_not_classified','0','0'),
('1058','89','priority_warning','0','0'),
('1059','89','retry','60','0'),
('1060','89','title','{ALERT.SUBJECT}','0'),
('1061','89','token','<PUSHOVER TOKEN HERE>','0'),
('1062','89','triggerid','{TRIGGER.ID}','0'),
('1063','89','url','{$ZABBIX.URL}','0'),
('1064','89','url_title','Zabbix','0'),
('1065','89','user','{ALERT.SENDTO}','0'),
('1066','90','alert_message','{ALERT.MESSAGE}','0'),
('1067','90','alert_subject','{ALERT.SUBJECT}','0'),
('1068','90','event_id','{EVENT.ID}','0'),
('1069','90','event_nseverity','{EVENT.NSEVERITY}','0'),
('1070','90','event_source','{EVENT.SOURCE}','0'),
('1071','90','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('1072','90','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('1073','90','event_value','{EVENT.VALUE}','0'),
('1074','90','redmine_access_key','<PUT YOUR ACCESS KEY>','0'),
('1075','90','redmine_issue_key','{EVENT.TAGS.__zbx_redmine_issue_id}','0'),
('1076','90','redmine_project','<PUT YOUR PROJECT ID OR NAME>','0'),
('1077','90','redmine_tracker_id','<PUT YOUR TRACKER ID>','0'),
('1078','90','redmine_url','<PUT YOUR REDMINE URL>','0'),
('1079','90','trigger_id','{TRIGGER.ID}','0'),
('1080','90','zabbix_url','{$ZABBIX.URL}','0'),
('1081','91','alert_message','{ALERT.MESSAGE}','0'),
('1082','91','alert_subject','{ALERT.SUBJECT}','0'),
('1083','91','event_nseverity','{EVENT.NSEVERITY}','0'),
('1084','91','event_source','{EVENT.SOURCE}','0'),
('1085','91','event_update_action','{EVENT.UPDATE.ACTION}','0'),
('1086','91','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('1087','91','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('1088','91','event_update_user','{USER.FULLNAME}','0'),
('1089','91','event_value','{EVENT.VALUE}','0'),
('1090','91','field_1_full:Host','{HOST.NAME} [{HOST.IP}]','0'),
('1091','91','field_2_short:Severity','{EVENT.SEVERITY}','0'),
('1092','91','field_3_short:Event time','{EVENT.DATE} {EVENT.TIME}','0'),
('1093','91','field_3_short_r:Recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}','0'),
('1094','91','field_4_short_r:Event duration','{EVENT.DURATION}','0'),
('1095','91','field_5_short:Operational data','{EVENT.OPDATA}','0'),
('1096','91','field_999_full_p:Trigger description','{TRIGGER.DESCRIPTION}','0'),
('1097','91','rc_api_url','api/v1/','0'),
('1098','91','rc_msg_id','{EVENT.TAGS.__zbx_rc_id}','0'),
('1099','91','rc_room_id','{EVENT.TAGS.__zbx_rc_rid}','0'),
('1100','91','rc_send_to','{ALERT.SENDTO}','0'),
('1101','91','rc_title_link','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}','0'),
('1102','91','rc_url','<PLACE YOUR INSTANCE URL HERE>','0'),
('1103','91','rc_user_id','<PLACE USER ID HERE>','0'),
('1104','91','rc_user_token','<PLACE TOKEN HERE>','0'),
('1105','91','use_default_message','false','0'),
('1106','92','alert_message','{ALERT.MESSAGE}','0'),
('1107','92','alert_subject','{ALERT.SUBJECT}','0'),
('1108','92','event_nseverity','{EVENT.NSEVERITY}','0'),
('1109','92','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('1110','92','event_source','{EVENT.SOURCE}','0'),
('1111','92','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('1112','92','event_value','{EVENT.VALUE}','0'),
('1113','92','servicenow_password','<PLACE PASSWORD HERE>','0'),
('1114','92','servicenow_sys_id','{EVENT.TAGS.__zbx_servicenow_sys_id}','0'),
('1115','92','servicenow_url','{ALERT.SENDTO}','0'),
('1116','92','servicenow_user','<PLACE USERNAME HERE>','0'),
('1117','92','urgency_for_average','2','0'),
('1118','92','urgency_for_disaster','1','0'),
('1119','92','urgency_for_high','2','0'),
('1120','92','urgency_for_information','3','0'),
('1121','92','urgency_for_not_classified','3','0'),
('1122','92','urgency_for_warning','3','0'),
('1123','93','Event_Ack_Status','{EVENT.ACK.STATUS}','0'),
('1124','93','Event_Date_Time','{EVENT.DATE} {EVENT.TIME}','0'),
('1125','93','Event_ID','{EVENT.ID}','0'),
('1126','93','Event_Update_Action','{EVENT.UPDATE.ACTION}','0'),
('1127','93','Event_Update_Status','{EVENT.UPDATE.STATUS}','0'),
('1128','93','Hostname','{HOST.NAME}','0'),
('1129','93','Host_IP','{HOST.IP}','0'),
('1130','93','Message','{ALERT.MESSAGE}','0'),
('1131','93','Severity','{EVENT.SEVERITY}','0'),
('1132','93','Subject','{ALERT.SUBJECT}','0'),
('1133','93','teamsecret','{ALERT.SENDTO}','0'),
('1134','93','Trigger_ID','{TRIGGER.ID}','0'),
('1135','93','Trigger_Status','{TRIGGER.STATUS}','0'),
('1136','93','User','{USER.FULLNAME}','0'),
('1137','93','Zabbix_URL','{$ZABBIX.URL}','0'),
('1138','94','alert_message','{ALERT.MESSAGE}','0'),
('1139','94','alert_subject','{ALERT.SUBJECT}','0'),
('1140','94','bot_token','<PLACE YOUR TOKEN>','0'),
('1141','94','channel','{ALERT.SENDTO}','0'),
('1142','94','event_id','{EVENT.ID}','0'),
('1143','94','event_nseverity','{EVENT.NSEVERITY}','0'),
('1144','94','event_severity','{EVENT.SEVERITY}','0'),
('1145','94','event_source','{EVENT.SOURCE}','0'),
('1146','94','event_tags','{EVENT.TAGSJSON}','0'),
('1147','94','event_update_action','{EVENT.UPDATE.ACTION}','0'),
('1148','94','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('1149','94','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('1150','94','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('1151','94','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('1152','94','event_value','{EVENT.VALUE}','0'),
('1153','94','slack_mode','alarm','0'),
('1154','94','trigger_id','{TRIGGER.ID}','0'),
('1155','94','zabbix_url','{$ZABBIX.URL}','0'),
('1156','95','alert_message','{ALERT.MESSAGE}','0'),
('1157','95','alert_subject','{ALERT.SUBJECT}','0'),
('1158','95','event_nseverity','{EVENT.NSEVERITY}','0'),
('1159','95','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('1160','95','event_source','{EVENT.SOURCE}','0'),
('1161','95','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('1162','95','event_value','{EVENT.VALUE}','0'),
('1163','95','priority_average','Medium','0'),
('1164','95','priority_default','Low','0'),
('1165','95','priority_disaster','Critical','0'),
('1166','95','priority_high','High','0'),
('1167','95','samanage_incident_id','{EVENT.TAGS.__zbx_solarwinds_inc_id}','0'),
('1168','95','samanage_token','<PUT YOUR TOKEN HERE>','0'),
('1169','95','samanage_url','<PUT YOUR INSTANCE URL HERE>','0'),
('1170','96','alert_message','{ALERT.MESSAGE}','0'),
('1171','96','alert_subject','{ALERT.SUBJECT}','0'),
('1172','96','event_id','{EVENT.ID}','0'),
('1173','96','event_nseverity','{EVENT.NSEVERITY}','0'),
('1174','96','event_source','{EVENT.SOURCE}','0'),
('1175','96','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('1176','96','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('1177','96','event_value','{EVENT.VALUE}','0'),
('1178','96','sysaid_auth_password','<PUT YOUR USER PASSWORD>','0'),
('1179','96','sysaid_auth_user','<PUT YOUR USER NAME>','0'),
('1180','96','sysaid_category_level_1','<PUT YOUR CATEGORY>','0'),
('1181','96','sysaid_category_level_2','<PUT YOUR SUB-CATEGORY>','0'),
('1182','96','sysaid_category_level_3','<PUT YOUR THIRD LEVEL CATEGORY>','0'),
('1183','96','sysaid_default_priority_id','1','0'),
('1184','96','sysaid_incident_id','{EVENT.TAGS.__zbx_sysaid_incident_id}','0'),
('1185','96','sysaid_incident_state','1','0'),
('1186','96','sysaid_template_id','<PUT YOUR TEMPLATE ID>','0'),
('1187','96','sysaid_urgency_id','<PUT YOUR URGENCY ID>','0'),
('1188','96','sysaid_url','<PUT YOUR SYSAID URL>','0'),
('1189','96','trigger_id','{TRIGGER.ID}','0'),
('1190','96','zabbix_url','{$ZABBIX.URL}','0'),
('1191','97','alert_message','{ALERT.MESSAGE}','0'),
('1192','97','alert_subject','{ALERT.SUBJECT}','0'),
('1193','97','api_chat_id','{ALERT.SENDTO}','0'),
('1194','97','api_parse_mode','<PLACE PARSE MODE>','0'),
('1195','97','api_token','<PLACE YOUR TOKEN>','0'),
('1196','97','event_nseverity','{EVENT.NSEVERITY}','0'),
('1197','97','event_severity','{EVENT.SEVERITY}','0'),
('1198','97','event_source','{EVENT.SOURCE}','0'),
('1199','97','event_tags','{EVENT.TAGSJSON}','0'),
('1200','97','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('1201','97','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('1202','97','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('1203','97','event_value','{EVENT.VALUE}','0'),
('1204','98','alert_message','{ALERT.MESSAGE}','0'),
('1205','98','alert_subject','{ALERT.SUBJECT}','0'),
('1206','98','event_id','{EVENT.ID}','0'),
('1207','98','event_nseverity','{EVENT.NSEVERITY}','0'),
('1208','98','event_source','{EVENT.SOURCE}','0'),
('1209','98','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('1210','98','event_value','{EVENT.VALUE}','0'),
('1211','98','severity_average','P3','0'),
('1212','98','severity_default','P5','0'),
('1213','98','severity_disaster','P1','0'),
('1214','98','severity_high','P2','0'),
('1215','98','severity_information','P5','0'),
('1216','98','severity_not_classified','P5','0'),
('1217','98','severity_warning','P4','0'),
('1218','98','topdesk_api','<put your TOPdesk API URL>','0'),
('1219','98','topdesk_issue_key','{EVENT.TAGS.__zbx_tpd_issuekey}','0'),
('1220','98','topdesk_password','<put your TOPdesk application password>','0'),
('1221','98','topdesk_status','<put default status for new tickets>','0'),
('1222','98','topdesk_user','<put your TOPdesk username>','0'),
('1223','98','trigger_id','{TRIGGER.ID}','0'),
('1224','98','zbxurl','{$ZABBIX.URL}','0'),
('1225','99','event_info','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}','0'),
('1226','99','event_nseverity','{EVENT.NSEVERITY}','0'),
('1227','99','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('1228','99','event_source','{EVENT.SOURCE}','0'),
('1229','99','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('1230','99','event_value','{EVENT.VALUE}','0'),
('1231','99','field:entity_display_name','{ALERT.SUBJECT}','0'),
('1232','99','field:entity_id','{EVENT.ID}','0'),
('1233','99','field:hostname','{HOST.NAME}','0'),
('1234','99','field:monitoring_tool','Zabbix','0'),
('1235','99','field:operational_data','{EVENT.OPDATA}','0'),
('1236','99','field:severity','{EVENT.SEVERITY}','0'),
('1237','99','field:state_message','{ALERT.MESSAGE}','0'),
('1238','99','field_p:trigger_description','{TRIGGER.DESCRIPTION}','0'),
('1239','99','field_r:event_duration','{EVENT.DURATION}','0'),
('1240','99','field_r:recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}','0'),
('1241','99','priority_average','WARNING','0'),
('1242','99','priority_default','INFO','0'),
('1243','99','priority_disaster','CRITICAL','0'),
('1244','99','priority_high','WARNING','0'),
('1245','99','priority_information','INFO','0'),
('1246','99','priority_not_classified','INFO','0'),
('1247','99','priority_resolved','OK','0'),
('1248','99','priority_update','INFO','0'),
('1249','99','priority_warning','INFO','0'),
('1250','99','vops_endpoint','<PLACE ENDPOINT URL HERE>','0'),
('1251','99','vops_routing_key','{ALERT.SENDTO}','0'),
('1252','100','alert_message','{ALERT.MESSAGE}','0'),
('1253','100','alert_subject','{ALERT.SUBJECT}','0'),
('1254','100','event_id','{EVENT.ID}','0'),
('1255','100','event_nseverity','{EVENT.NSEVERITY}','0'),
('1256','100','event_severity','{EVENT.SEVERITY}','0'),
('1257','100','event_source','{EVENT.SOURCE}','0'),
('1258','100','event_tags','{EVENT.TAGSJSON}','0'),
('1259','100','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('1260','100','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('1261','100','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('1262','100','event_value','{EVENT.VALUE}','0'),
('1263','100','trigger_id','{TRIGGER.ID}','0'),
('1264','100','zabbix_url','{$ZABBIX.URL}','0'),
('1265','100','zammad_access_token','<PUT YOUR ACCESS TOKEN>','0'),
('1266','100','zammad_customer','<PUT YOUR CUSTOMER EMAIL>','0'),
('1267','100','zammad_enable_tags','false','0'),
('1268','100','zammad_group','Users','0'),
('1269','100','zammad_url','<PUT YOUR ZAMMAD URL>','0'),
('1270','101','alert_message','{ALERT.MESSAGE}','0'),
('1271','101','alert_subject','{ALERT.SUBJECT}','0'),
('1272','101','event_id','{EVENT.ID}','0'),
('1273','101','event_nseverity','{EVENT.NSEVERITY}','0'),
('1274','101','event_source','{EVENT.SOURCE}','0'),
('1275','101','event_tags','{EVENT.TAGS}','0'),
('1276','101','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('1277','101','event_value','{EVENT.VALUE}','0'),
('1278','101','severity_average','normal','0'),
('1279','101','severity_default','-','0'),
('1280','101','severity_disaster','urgent','0'),
('1281','101','severity_high','high','0'),
('1282','101','severity_information','low','0'),
('1283','101','severity_not_classified','low','0'),
('1284','101','severity_warning','normal','0'),
('1285','101','trigger_id','{TRIGGER.ID}','0'),
('1286','101','zbxurl','{$ZABBIX.URL}','0'),
('1287','101','zendesk_issue_key','{EVENT.TAGS.__zbx_zdk_issuekey}','0'),
('1288','101','zendesk_token','<put your {enduser_email_address}/token:{api_token}>','0'),
('1289','101','zendesk_type','incident','0'),
('1290','101','zendesk_url','<put your Zendesk URL>','0'),
('1291','87','otrs_ticket_type','Unclassified','0');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) VALUES ('1','1','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('2','1','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('3','1','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('4','1','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('5','1','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('6','3','0','0','','{EVENT.SEVERITY}: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\n{EVENT.DATE} {EVENT.TIME}'),
('7','3','0','1','','Resolved in {EVENT.DURATION}: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\n{EVENT.DATE} {EVENT.TIME}'),
('8','3','0','2','','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem in {EVENT.AGE} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}'),
('9','3','1','0','','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}'),
('10','3','2','0','','Autoregistration: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('11','4','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('12','4','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('13','4','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.'),
('14','4','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}'),
('15','4','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}'),
('160','34','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('161','34','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('162','34','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.'),
('163','34','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}'),
('164','34','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}'),
('165','35','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('166','35','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('167','35','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.'),
('168','35','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}'),
('169','35','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}'),
('170','36','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('171','36','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('172','36','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.'),
('173','36','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}'),
('174','36','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}'),
('175','37','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('176','37','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('177','37','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.'),
('178','37','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}'),
('179','37','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}'),
('397','70','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nStarted at {EVENT.TIME} on {EVENT.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}'),
('398','70','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nResolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}'),
('399','70','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\n\r\n{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}'),
('400','70','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}\r\nDiscovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('401','70','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('402','71','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('403','71','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('404','71','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('405','71','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('406','71','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('407','71','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('408','71','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('409','71','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('410','71','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('411','71','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('412','72','0','0','Event ID: {EVENT.ID}, Host: {HOST.HOST}, Problem: {EVENT.NAME}',''),
('413','73','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nStarted at {EVENT.TIME} on {EVENT.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}'),
('414','73','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nResolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}'),
('415','73','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\n\r\n{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}'),
('416','73','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}\r\nDiscovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('417','73','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('418','74','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('419','74','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('420','74','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('421','74','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('422','74','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('423','74','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('424','74','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('425','74','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('426','74','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('427','74','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('428','75','0','0','Problem: {EVENT.NAME}','<dl><dd><b>Problem started at</b> {EVENT.TIME} <b>on</b> {EVENT.DATE}</b></dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Host:</b> {HOST.NAME}</dd><dd><b>Severity:</b> {EVENT.SEVERITY}</dd><dd><b>Operational data:</b> {EVENT.OPDATA}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd></dl>{TRIGGER.URL}'),
('429','75','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<dl><dd><b>Problem has been resolved in</b> {EVENT.DURATION} <b>at</b> {EVENT.RECOVERY.TIME} <b>on</b> {EVENT.RECOVERY.DATE}</dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Host:</b> {HOST.NAME}</dd><dd><b>Severity:</b> {EVENT.SEVERITY}</dd><dd><b>Operational data:</b> {EVENT.OPDATA}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd></dl>{TRIGGER.URL}'),
('430','75','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.TIME} on {EVENT.UPDATE.DATE}. <br><br>{EVENT.UPDATE.MESSAGE}<br><br>Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.<br><br>'),
('431','75','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<dl><dd><b>Discovery rule:</b> {DISCOVERY.RULE.NAME}</dd><br><dd><b>Device IP:</b> {DISCOVERY.DEVICE.IPADDRESS}</dd><dd><b>Device DNS:</b> {DISCOVERY.DEVICE.DNS}</dd><br><dd><b>Device status:</b> {DISCOVERY.DEVICE.STATUS}</dd><br><dd><b>Device uptime:</b> {DISCOVERY.DEVICE.UPTIME}</dd><br><dd><b>Device service name:</b> {DISCOVERY.SERVICE.NAME}</dd><dd><b>Device service port:</b> {DISCOVERY.SERVICE.PORT}</dd><dd><b>Device service status:</b> {DISCOVERY.SERVICE.STATUS}</dd><dd><b>Device service uptime:</b> {DISCOVERY.SERVICE.UPTIME}</dd></dl>'),
('432','75','2','0','Autoregistration: {HOST.HOST}','<dl><dd><b>Host name:</b> {HOST.HOST}</dd><dd><b>Host IP:</b> {HOST.IP}</dd><dd><b>Agent port:</b> {HOST.PORT}</dd></dl>'),
('433','75','3','0','[{EVENT.STATUS}] {EVENT.NAME}','<dl><dd><b>Problem started at</b> {EVENT.TIME} <b>on</b> {EVENT.DATE}</b></dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Host:</b> {HOST.NAME}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd></dl>'),
('434','75','3','1','[{EVENT.STATUS}] {EVENT.NAME}','<dl><dd><b>Problem has been resolved in</b> {EVENT.DURATION} <b>at</b> {EVENT.RECOVERY.TIME} <b>on</b> {EVENT.RECOVERY.DATE}</dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Host:</b> {HOST.NAME}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd></dl>'),
('435','75','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','<dl><dd><b>Service problem started at</b> {EVENT.TIME} <b>on</b> {EVENT.DATE}</dd><dd><b>Service problem name:</b> {EVENT.NAME}</dd><dd><b>Service:</b> {SERVICE.NAME}</dd><dd><b>Severity:</b> {EVENT.SEVERITY}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd><dd><b>Service description:</b> {SERVICE.DESCRIPTION}</dd><dd><b><br>{SERVICE.ROOTCAUSE}</dd></dl>'),
('436','75','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','<dl><dd><b>Service {SERVICE.NAME} <b>has been resolved at</b> {EVENT.RECOVERY.TIME} <b>on</b> {EVENT.RECOVERY.DATE}</dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Problem duration:</b> {EVENT.DURATION}</dd><dd><b>Severity:</b> {EVENT.SEVERITY}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd><dd><b>Service description:</b {SERVICE.DESCRIPTION}</dd></dl>'),
('437','75','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','<dl><dd><b>Changed {SERVICE.NAME} <b>service status to</b> {EVENT.UPDATE.SEVERITY} <b>at</b> {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.</dd><dd><b>Current problem age is</b> {EVENT.AGE}.</dd><dd><b>Service description:</b> {SERVICE.DESCRIPTION}</dd><br>{SERVICE.ROOTCAUSE}</dd></dl>'),
('438','76','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('439','76','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('440','76','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('441','77','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('442','77','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('443','77','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('444','77','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('445','77','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('446','78','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('447','78','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('448','78','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('449','78','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('450','78','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('451','78','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('452','78','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('453','78','4','0','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('454','78','4','1','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('455','78','4','2','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('456','79','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('457','79','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('458','79','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('459','79','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('460','79','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('461','79','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('462','79','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('463','79','4','0','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('464','79','4','1','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('465','79','4','2','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('466','80','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}'),
('467','80','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}'),
('468','80','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('469','80','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('470','80','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('471','81','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('472','81','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('473','81','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('474','81','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('475','81','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('476','82','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('477','82','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('478','82','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('479','82','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('480','82','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('481','82','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('482','82','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('483','83','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('484','83','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('485','83','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('486','83','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('487','83','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('488','84','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('489','84','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('490','84','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('491','84','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('492','84','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('493','84','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('494','84','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('495','84','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('496','84','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('497','84','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('498','85','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('499','85','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('500','85','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('501','85','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('502','85','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('503','85','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('504','85','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('505','85','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('506','85','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('507','85','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('508','86','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('509','86','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('510','86','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('511','86','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('512','86','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('513','87','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('514','87','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('515','87','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('516','87','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('517','87','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('518','87','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('519','87','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('520','87','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('521','87','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('522','87','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('523','88','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('524','88','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('525','88','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('526','88','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('527','88','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('528','88','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('529','88','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('530','88','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('531','88','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('532','88','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('533','89','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('534','89','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('535','89','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('536','89','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('537','89','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('538','90','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('539','90','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('540','90','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('541','90','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('542','90','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('543','91','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('544','91','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('545','91','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('546','91','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('547','91','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('548','92','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('549','92','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('550','92','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('551','92','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('552','92','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('553','93','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('554','93','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('555','93','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('556','93','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('557','93','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('558','94','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('559','94','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('560','94','0','2','Updated: {EVENT.NAME}','Problem updated at {EVENT.TIME} on {EVENT.DATE}\r\n{USER.FULLNAME} {EVENT.UPDATE.ACTION}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('561','94','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('562','94','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('563','94','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('564','94','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('565','94','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('566','94','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('567','94','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('568','95','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n\r\nTrigger description: {TRIGGER.DESCRIPTION}'),
('569','95','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('570','95','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('571','95','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('572','95','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('573','96','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('574','96','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('575','96','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('576','96','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('577','96','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('578','97','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('579','97','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('580','97','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('581','97','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('582','97','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('583','97','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('584','97','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('585','97','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('586','97','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('587','97','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('588','98','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('589','98','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('590','98','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('591','98','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('592','98','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('593','99','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('594','99','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('595','99','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('596','99','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('597','99','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('598','100','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('599','100','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('600','100','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('601','100','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('602','100','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('603','100','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('604','100','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('605','100','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('606','100','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('607','100','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('608','101','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('609','101','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('610','101','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('611','101','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('612','101','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('613','101','3','0','Internal problem: {EVENT.NAME}','Internal problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`,`userdirectoryid`,`mfa_status`,`mfaid`) VALUES ('7','Zabbix administrators','0','0','0',NULL,'0',NULL),
('8','Guests','0','0','0',NULL,'0',NULL),
('9','Disabled','0','1','0',NULL,'0',NULL),
('11','Enabled debug mode','0','0','1',NULL,'0',NULL),
('12','No access to the frontend','3','0','0',NULL,'0',NULL),
('13','Internal','1','0','0',NULL,'0',NULL);
INSERT INTO `users_groups` (`id`,`usrgrpid`,`userid`) VALUES ('2','8','2'),
('3','9','2'),
('4','7','1'),
('5','13','1'),
('6','13','2');
INSERT INTO `ugset_group` (`ugsetid`,`usrgrpid`) VALUES ('1','13'),
('1','8'),
('1','9');
INSERT INTO `user_ugset` (`userid`,`ugsetid`) VALUES ('2','1');
INSERT INTO `scripts` (`scriptid`,`name`,`command`,`host_access`,`usrgrpid`,`groupid`,`description`,`confirmation`,`type`,`execute_on`,`timeout`,`scope`,`port`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`menu_path`,`url`,`new_window`,`manualinput`,`manualinput_prompt`,`manualinput_validator`,`manualinput_validator_type`,`manualinput_default_value`) VALUES ('1','Ping','ping -c 3 {HOST.CONN}; case $? in [01]) true;; *) false;; esac','2',NULL,NULL,'','','0','2','30s','2','','0','','','','','','','1','0','','','0',''),
('2','Traceroute','/usr/bin/traceroute {HOST.CONN}','2',NULL,NULL,'','','0','2','30s','2','','0','','','','','','','1','0','','','0',''),
('3','Detect operating system','sudo /usr/bin/nmap -O {HOST.CONN}','2','7',NULL,'','','0','2','30s','2','','0','','','','','','','1','0','','','0','');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`,`notify_if_canceled`,`pause_symptoms`) VALUES ('2','Auto discovery. Linux servers.','1','0','1','0','','1','1','1'),
('3','Report problems to Zabbix administrators','0','0','1','1h','','1','1','1'),
('4','Report not supported items','3','0','1','1h','','1','1','1'),
('5','Report not supported low level discovery rules','3','0','1','1h','','1','1','1'),
('6','Report unknown triggers','3','0','1','1h','','1','1','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) VALUES ('1','2','6','0','1','1','0','0'),
('2','2','4','0','1','1','0','0'),
('3','3','0','0','1','1','0','0'),
('4','4','0','0','1','1','0','0'),
('5','5','0','0','1','1','0','0'),
('6','6','0','0','1','1','0','0'),
('7','3','11','0','1','1','0','1'),
('8','4','11','0','1','1','0','1'),
('9','5','11','0','1','1','0','1'),
('10','6','11','0','1','1','0','1');
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) VALUES ('3','1','','',NULL),
('4','1','','',NULL),
('5','1','','',NULL),
('6','1','','',NULL),
('7','1','','',NULL),
('8','1','','',NULL),
('9','1','','',NULL),
('10','1','','',NULL);
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) VALUES ('1','3','7'),
('2','4','7'),
('3','5','7'),
('4','6','7');
INSERT INTO `opgroup` (`opgroupid`,`operationid`,`groupid`) VALUES ('1','2','2');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) VALUES ('2','2','10','0','0',''),
('3','2','8','0','9',''),
('4','2','12','2','Linux',''),
('6','4','23','0','0',''),
('7','5','23','0','2',''),
('8','6','23','0','4','');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) VALUES ('1','blue-theme','FFFFFF','FFFFFF','CCD5D9','ACBBC2','ACBBC2','1F2C33','E33734','429E47','E33734','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4'),
('2','dark-theme','2B2B2B','2B2B2B','454545','4F4F4F','4F4F4F','F2F2F2','E45959','59DB8F','E45959','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4'),
('3','hc-light','FFFFFF','FFFFFF','555555','000000','333333','000000','333333','000000','000000','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4'),
('4','hc-dark','000000','000000','666666','888888','4F4F4F','FFFFFF','FFFFFF','FFFFFF','FFFFFF','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4');
INSERT INTO `globalmacro` (`globalmacroid`,`macro`,`value`,`description`,`type`) VALUES ('2','{$SNMP_COMMUNITY}','public','','0');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) VALUES ('1','File systems for discovery','ext3'),
('2','Network interfaces for discovery','eth0'),
('3','Storage devices for SNMP discovery','/boot'),
('4','Windows service names for discovery','SysmonLog'),
('5','Windows service startup states for discovery','automatic');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) VALUES ('1','1','^(btrfs|ext2|ext3|ext4|reiser|xfs|ffs|ufs|jfs|jfs2|vxfs|hfs|apfs|refs|ntfs|fat32|zfs)$','3',',','0'),
('3','3','^(Physical memory|Virtual memory|Memory buffers|Cached memory|Swap space)$','4',',','1'),
('5','4','^(MMCSS|gupdate|SysmonLog|clr_optimization_v2.0.50727_32|clr_optimization_v4.0.30319_32)$','4',',','1'),
('6','5','^(automatic|automatic delayed)$','3',',','1'),
('7','2','^Software Loopback Interface','4',',','1'),
('8','2','^(In)?[Ll]oop[Bb]ack[0-9._]*$','4',',','1'),
('9','2','^NULL[0-9.]*$','4',',','1'),
('10','2','^[Ll]o[0-9.]*$','4',',','1'),
('11','2','^[Ss]ystem$','4',',','1'),
('12','2','^Nu[0-9.]*$','4',',','1');
INSERT INTO `config_autoreg_tls` (`autoreg_tlsid`,`tls_psk_identity`,`tls_psk`) VALUES ('1','','');
INSERT INTO `module` (`moduleid`,`id`,`relative_path`,`status`,`config`) VALUES ('1','actionlog','widgets/actionlog','1','[]'),
('2','clock','widgets/clock','1','[]'),
('3','topitems','widgets/topitems','1','[]'),
('4','discovery','widgets/discovery','1','[]'),
('5','favgraphs','widgets/favgraphs','1','[]'),
('6','favmaps','widgets/favmaps','1','[]'),
('7','geomap','widgets/geomap','1','[]'),
('8','graph','widgets/graph','1','[]'),
('9','graphprototype','widgets/graphprototype','1','[]'),
('10','hostavail','widgets/hostavail','1','[]'),
('11','item','widgets/item','1','[]'),
('12','map','widgets/map','1','[]'),
('13','navtree','widgets/navtree','1','[]'),
('14','itemhistory','widgets/itemhistory','1','[]'),
('15','problemhosts','widgets/problemhosts','1','[]'),
('16','problems','widgets/problems','1','[]'),
('17','problemsbysv','widgets/problemsbysv','1','[]'),
('18','slareport','widgets/slareport','1','[]'),
('19','svggraph','widgets/svggraph','1','[]'),
('20','systeminfo','widgets/systeminfo','1','[]'),
('21','tophosts','widgets/tophosts','1','[]'),
('22','trigover','widgets/trigover','1','[]'),
('23','url','widgets/url','1','[]'),
('24','web','widgets/web','1','[]'),
('25','gauge','widgets/gauge','1','[]'),
('26','toptriggers','widgets/toptriggers','1','[]'),
('27','piechart','widgets/piechart','1','[]'),
('28','honeycomb','widgets/honeycomb','1','[]'),
('29','hostnavigator','widgets/hostnavigator','1','[]'),
('30','itemnavigator','widgets/itemnavigator','1','[]'),
('31','hostcard','widgets/hostcard','1','[]'),
('32','itemcard','widgets/itemcard','1','[]');
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`,`value_serviceid`) VALUES ('1','1','0','ui.default_access','1','',NULL,NULL),
('2','1','0','services.read','1','',NULL,NULL),
('3','1','0','services.write','0','',NULL,NULL),
('4','1','0','modules.default_access','1','',NULL,NULL),
('5','1','0','api.access','1','',NULL,NULL),
('6','1','0','api.mode','0','',NULL,NULL),
('7','1','0','actions.default_access','1','',NULL,NULL),
('8','2','0','ui.default_access','1','',NULL,NULL),
('9','2','0','services.read','1','',NULL,NULL),
('10','2','0','services.write','1','',NULL,NULL),
('11','2','0','modules.default_access','1','',NULL,NULL),
('12','2','0','api.access','1','',NULL,NULL),
('13','2','0','api.mode','0','',NULL,NULL),
('14','2','0','actions.default_access','1','',NULL,NULL),
('15','3','0','ui.default_access','1','',NULL,NULL),
('16','3','0','services.read','1','',NULL,NULL),
('17','3','0','services.write','1','',NULL,NULL),
('18','3','0','modules.default_access','1','',NULL,NULL),
('19','3','0','api.access','1','',NULL,NULL),
('20','3','0','api.mode','0','',NULL,NULL),
('21','3','0','actions.default_access','1','',NULL,NULL),
('22','4','0','ui.default_access','1','',NULL,NULL),
('23','4','0','services.read','1','',NULL,NULL),
('24','4','0','services.write','0','',NULL,NULL),
('25','4','0','modules.default_access','1','',NULL,NULL),
('26','4','0','api.access','0','',NULL,NULL),
('27','4','0','actions.default_access','0','',NULL,NULL);
INSERT INTO `settings` (`name`,`type`,`value_str`,`value_int`,`value_usrgrpid`,`value_hostgroupid`,`value_userdirectoryid`,`value_mfaid`) VALUES ('alert_usrgrpid','3','','0','7',NULL,NULL,NULL),
('auditlog_enabled','2','','1',NULL,NULL,NULL,NULL),
('auditlog_mode','2','','1',NULL,NULL,NULL,NULL),
('authentication_type','2','','0',NULL,NULL,NULL,NULL),
('autoreg_tls_accept','2','','1',NULL,NULL,NULL,NULL),
('blink_period','1','2m','0',NULL,NULL,NULL,NULL),
('compress_older','1','7d','0',NULL,NULL,NULL,NULL),
('compression_status','2','','0',NULL,NULL,NULL,NULL),
('connect_timeout','1','3s','0',NULL,NULL,NULL,NULL),
('custom_color','2','','0',NULL,NULL,NULL,NULL),
('db_extension','1','','0',NULL,NULL,NULL,NULL),
('dbversion_status','1','','0',NULL,NULL,NULL,NULL),
('default_inventory_mode','2','','-1',NULL,NULL,NULL,NULL),
('default_lang','1','en_US','0',NULL,NULL,NULL,NULL),
('default_theme','1','blue-theme','0',NULL,NULL,NULL,NULL),
('default_timezone','1','system','0',NULL,NULL,NULL,NULL),
('disabled_usrgrpid','3','','0',NULL,NULL,NULL,NULL),
('discovery_groupid','4','','0',NULL,'5',NULL,NULL),
('geomaps_attribution','1','','0',NULL,NULL,NULL,NULL),
('geomaps_max_zoom','2','','0',NULL,NULL,NULL,NULL),
('geomaps_tile_provider','1','OpenStreetMap.Mapnik','0',NULL,NULL,NULL,NULL),
('geomaps_tile_url','1','','0',NULL,NULL,NULL,NULL),
('ha_failover_delay','1','1m','0',NULL,NULL,NULL,NULL),
('history_period','1','24h','0',NULL,NULL,NULL,NULL),
('hk_audit','1','31d','0',NULL,NULL,NULL,NULL),
('hk_audit_mode','2','','1',NULL,NULL,NULL,NULL),
('hk_events_autoreg','1','1d','0',NULL,NULL,NULL,NULL),
('hk_events_discovery','1','1d','0',NULL,NULL,NULL,NULL),
('hk_events_internal','1','1d','0',NULL,NULL,NULL,NULL),
('hk_events_mode','2','','1',NULL,NULL,NULL,NULL),
('hk_events_service','1','1d','0',NULL,NULL,NULL,NULL),
('hk_events_trigger','1','365d','0',NULL,NULL,NULL,NULL),
('hk_history','1','31d','0',NULL,NULL,NULL,NULL),
('hk_history_global','2','','0',NULL,NULL,NULL,NULL),
('hk_history_mode','2','','1',NULL,NULL,NULL,NULL),
('hk_services','1','365d','0',NULL,NULL,NULL,NULL),
('hk_services_mode','2','','1',NULL,NULL,NULL,NULL),
('hk_sessions','1','31d','0',NULL,NULL,NULL,NULL),
('hk_sessions_mode','2','','1',NULL,NULL,NULL,NULL),
('hk_trends','1','365d','0',NULL,NULL,NULL,NULL),
('hk_trends_global','2','','0',NULL,NULL,NULL,NULL),
('hk_trends_mode','2','','1',NULL,NULL,NULL,NULL),
('http_auth_enabled','2','','0',NULL,NULL,NULL,NULL),
('http_case_sensitive','2','','1',NULL,NULL,NULL,NULL),
('http_login_form','2','','0',NULL,NULL,NULL,NULL),
('http_strip_domains','1','','0',NULL,NULL,NULL,NULL),
('iframe_sandboxing_enabled','2','','1',NULL,NULL,NULL,NULL),
('iframe_sandboxing_exceptions','1','','0',NULL,NULL,NULL,NULL),
('instanceid','1','','0',NULL,NULL,NULL,NULL),
('item_test_timeout','1','60s','0',NULL,NULL,NULL,NULL),
('jit_provision_interval','1','1h','0',NULL,NULL,NULL,NULL),
('ldap_auth_enabled','2','','0',NULL,NULL,NULL,NULL),
('ldap_case_sensitive','2','','1',NULL,NULL,NULL,NULL),
('ldap_jit_status','2','','0',NULL,NULL,NULL,NULL),
('ldap_userdirectoryid','5','','0',NULL,NULL,NULL,NULL),
('login_attempts','2','','5',NULL,NULL,NULL,NULL),
('login_block','1','30s','0',NULL,NULL,NULL,NULL),
('max_in_table','2','','50',NULL,NULL,NULL,NULL),
('max_overview_table_size','2','','50',NULL,NULL,NULL,NULL),
('max_period','1','2y','0',NULL,NULL,NULL,NULL),
('media_type_test_timeout','1','65s','0',NULL,NULL,NULL,NULL),
('mfa_status','2','','0',NULL,NULL,NULL,NULL),
('mfaid','6','','0',NULL,NULL,NULL,NULL),
('ok_ack_color','1','009900','0',NULL,NULL,NULL,NULL),
('ok_ack_style','2','','1',NULL,NULL,NULL,NULL),
('ok_period','1','5m','0',NULL,NULL,NULL,NULL),
('ok_unack_color','1','009900','0',NULL,NULL,NULL,NULL),
('ok_unack_style','2','','1',NULL,NULL,NULL,NULL),
('passwd_check_rules','2','','8',NULL,NULL,NULL,NULL),
('passwd_min_length','2','','8',NULL,NULL,NULL,NULL),
('period_default','1','1h','0',NULL,NULL,NULL,NULL),
('problem_ack_color','1','CC0000','0',NULL,NULL,NULL,NULL),
('problem_ack_style','2','','1',NULL,NULL,NULL,NULL),
('problem_unack_color','1','CC0000','0',NULL,NULL,NULL,NULL),
('problem_unack_style','2','','1',NULL,NULL,NULL,NULL),
('proxy_secrets_provider','2','','0',NULL,NULL,NULL,NULL),
('report_test_timeout','1','60s','0',NULL,NULL,NULL,NULL),
('saml_auth_enabled','2','','0',NULL,NULL,NULL,NULL),
('saml_case_sensitive','2','','0',NULL,NULL,NULL,NULL),
('saml_jit_status','2','','0',NULL,NULL,NULL,NULL),
('script_timeout','1','60s','0',NULL,NULL,NULL,NULL),
('search_limit','2','','1000',NULL,NULL,NULL,NULL),
('server_check_interval','2','','10',NULL,NULL,NULL,NULL),
('server_status','1','','0',NULL,NULL,NULL,NULL),
('session_key','1','0e1e3fb9846cbe4e079a22d38b2db33e','0',NULL,NULL,NULL,NULL),
('severity_color_0','1','97AAB3','0',NULL,NULL,NULL,NULL),
('severity_color_1','1','7499FF','0',NULL,NULL,NULL,NULL),
('severity_color_2','1','FFC859','0',NULL,NULL,NULL,NULL),
('severity_color_3','1','FFA059','0',NULL,NULL,NULL,NULL),
('severity_color_4','1','E97659','0',NULL,NULL,NULL,NULL),
('severity_color_5','1','E45959','0',NULL,NULL,NULL,NULL),
('severity_name_0','1','Not classified','0',NULL,NULL,NULL,NULL),
('severity_name_1','1','Information','0',NULL,NULL,NULL,NULL),
('severity_name_2','1','Warning','0',NULL,NULL,NULL,NULL),
('severity_name_3','1','Average','0',NULL,NULL,NULL,NULL),
('severity_name_4','1','High','0',NULL,NULL,NULL,NULL),
('severity_name_5','1','Disaster','0',NULL,NULL,NULL,NULL),
('show_technical_errors','2','','0',NULL,NULL,NULL,NULL),
('snmptrap_logging','2','','1',NULL,NULL,NULL,NULL),
('socket_timeout','1','3s','0',NULL,NULL,NULL,NULL),
('software_update_check_data','1','','0',NULL,NULL,NULL,NULL),
('software_update_checkid','1','','0',NULL,NULL,NULL,NULL),
('timeout_browser','1','60s','0',NULL,NULL,NULL,NULL),
('timeout_db_monitor','1','3s','0',NULL,NULL,NULL,NULL),
('timeout_external_check','1','3s','0',NULL,NULL,NULL,NULL),
('timeout_http_agent','1','3s','0',NULL,NULL,NULL,NULL),
('timeout_script','1','3s','0',NULL,NULL,NULL,NULL),
('timeout_simple_check','1','3s','0',NULL,NULL,NULL,NULL),
('timeout_snmp_agent','1','3s','0',NULL,NULL,NULL,NULL),
('timeout_ssh_agent','1','3s','0',NULL,NULL,NULL,NULL),
('timeout_telnet_agent','1','3s','0',NULL,NULL,NULL,NULL),
('timeout_zabbix_agent','1','3s','0',NULL,NULL,NULL,NULL),
('uri_valid_schemes','1','http,https,ftp,file,mailto,tel,ssh','0',NULL,NULL,NULL,NULL),
('url','1','','0',NULL,NULL,NULL,NULL),
('validate_uri_schemes','2','','1',NULL,NULL,NULL,NULL),
('vault_provider','2','','0',NULL,NULL,NULL,NULL),
('work_period','1','1-5,09:00-18:00','0',NULL,NULL,NULL,NULL),
('x_frame_options','1','SAMEORIGIN','0',NULL,NULL,NULL,NULL);
INSERT INTO `hgset` (`hgsetid`,`hash`) VALUES ('1','e629fa6598d732768f7c726b4b621285f9c3b85303900aa912017db7617d8bdb'),
('2','4ec9599fc203d176a301536c2e091a19bc852759b255bd6818810a42c5fed14a'),
('3','4523540f1504cd17100c4835e85b7eefd49911580f8efff0599a8f283be6b9e3'),
('4','ef8704ac79657fbf2818c74a70a571c131283abd8914eca173cd032929702789'),
('5','6f4b6612125fb3a0daecd2799dfd6c9c299424fd920f9b308110a2c1fbd8f443'),
('6','4b227777d4dd1fc61c6f884f48641d02b4d121d3fd328cb08b5531fcacdabf8a'),
('7','19581e27de7ced00ff1ce50b2047e7a567c76b1cbaebabe5ef03f7c3017bb5b7'),
('8','6b51d431df5d7f141cbececcf79edf3dd861c3b4069f0b11661a3eefacbba918'),
('9','b17ef6d19c7a5b1ee83b907c595526dcb1eb06db8227d650d5dda0a9f4ce8cd9'),
('10','4fc82b26aecb47d2868c4efbe3581732a3e7cbcc6c2efb32062c08170a05eeb8'),
('11','4a44dc15364204a80fe80e9039455cc1608281820fe2b24f1e5233ade6af1dd5'),
('12','3fdba35f04dc8c462986c992bcf875546257113072a909c162f7e470e581e278');
INSERT INTO `hosts` (`hostid`,`proxyid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`discover`,`custom_interfaces`,`uuid`,`name_upper`,`vendor_name`,`vendor_version`,`proxy_groupid`,`monitored_by`,`wizard_ready`,`readme`) VALUES ('10001',NULL,'Linux by Zabbix agent','3','-1','2','','','Linux by Zabbix agent','0',NULL,'This is an official Linux template. It requires Zabbix agent 7.4 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n- The ext4/3/2 filesystem reserves space for privileged usage, typically set at 5% by default.\r\n- BTRFS allocates a default of 10% of the volume for its own needs.\r\n- To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n  - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n- The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f8f7908280354f2abeed07dc788c3747','LINUX BY ZABBIX AGENT','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis is an official Linux template. It requires Zabbix agent 7.4 or newer.\r\n\r\n#### Notes on filesystem (FS) discovery:\r\n- The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n- BTRFS allocates a default of 10% of the volume for its own needs.\r\n- To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n  - Utilization formula: `pused = 100 - 100 * (available / total - free + available)`\r\n- The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.'),
('10047',NULL,'Zabbix server health','3','-1','2','','','Zabbix server health','0',NULL,'This template is designed to monitor internal Zabbix metrics on the local Zabbix server.\r\n\r\nLink this template to the local Zabbix server host.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e2d2b4e4ac28483996cc11fe42823d57','ZABBIX SERVER HEALTH','Zabbix','7.4-5',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor internal Zabbix metrics on the local Zabbix server.\r\n\r\n## Setup\r\n\r\nLink this template to the local Zabbix server host.'),
('10048',NULL,'Zabbix proxy health','3','-1','2','','','Zabbix proxy health','0',NULL,'This template is designed to monitor internal Zabbix metrics on the local Zabbix proxy.\r\n\r\nLink this template to the local Zabbix proxy host.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','dd114bf0fb2f46bc84840f1bb24e2b23','ZABBIX PROXY HEALTH','Zabbix','7.4-3',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor internal Zabbix metrics on the local Zabbix proxy.\r\n\r\n## Setup\r\n\r\nLink this template to the local Zabbix proxy host.'),
('10074',NULL,'OpenBSD by Zabbix agent','3','-1','2','','','OpenBSD by Zabbix agent','0',NULL,'This is an Official OpenBSD template. It requires Zabbix agent 7.4 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','760be6e1c2194a5bb7c0df47cc5f71ca','OPENBSD BY ZABBIX AGENT','Zabbix','7.4-1',NULL,'0','0',''),
('10075',NULL,'FreeBSD by Zabbix agent','3','-1','2','','','FreeBSD by Zabbix agent','0',NULL,'This is an official FreeBSD template. It requires Zabbix agent 7.4 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a3dc630729e443139f4e608954fa6e19','FREEBSD BY ZABBIX AGENT','Zabbix','7.4-1',NULL,'0','0',''),
('10076',NULL,'AIX by Zabbix agent','3','-1','2','','','AIX by Zabbix agent','0',NULL,'This is an official AIX template. It requires Zabbix agent 7.4 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7e6bb0931a72459db9514aa924b420bc','AIX BY ZABBIX AGENT','Zabbix','7.4-1',NULL,'0','0',''),
('10077',NULL,'HP-UX by Zabbix agent','3','-1','2','','','HP-UX by Zabbix agent','0',NULL,'This is an official HP-UX template. It requires Zabbix agent 7.4 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b1fd823d262042e08291313f72be9452','HP-UX BY ZABBIX AGENT','Zabbix','7.4-1',NULL,'0','0',''),
('10078',NULL,'Solaris by Zabbix agent','3','-1','2','','','Solaris by Zabbix agent','0',NULL,'This is an official Solaris OS template. It requires Zabbix agent 7.4 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','eaf36c98b91843b7b79bd5184a23d377','SOLARIS BY ZABBIX AGENT','Zabbix','7.4-1',NULL,'0','0',''),
('10079',NULL,'macOS by Zabbix agent','3','-1','2','','','macOS by Zabbix agent','0',NULL,'This is an official macOS template. It requires Zabbix agent 7.4 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f895df5b37494f668cde1a2388d7af8b','MACOS BY ZABBIX AGENT','Zabbix','7.4-1',NULL,'0','0',''),
('10081',NULL,'Windows by Zabbix agent','3','-1','2','','','Windows by Zabbix agent','0',NULL,'This is an official Windows template. It requires Zabbix agent 7.4 or newer.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','13b06904a6bf41cbb795e3193d896340','WINDOWS BY ZABBIX AGENT','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis is an official Windows template. It requires Zabbix agent 7.4 or newer.'),
('10084',NULL,'Zabbix server','0','-1','2','','','Zabbix server','0',NULL,'','1','1','','','','','0','0','','ZABBIX SERVER','','',NULL,'0','0',''),
('10169',NULL,'Generic Java JMX','3','-1','2','','','Generic Java JMX','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','72aab08f7f27406a8f2c291648e5ba95','GENERIC JAVA JMX','Zabbix','7.4-0',NULL,'0','0',''),
('10171',NULL,'Intel SR1530 IPMI','3','-1','2','','','Intel SR1530 IPMI','0',NULL,'Template for monitoring Intel SR1530 server system.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f01bd64eef4049fabe087cccae590226','INTEL SR1530 IPMI','Zabbix','7.4-0',NULL,'0','0',''),
('10172',NULL,'Intel SR1630 IPMI','3','-1','2','','','Intel SR1630 IPMI','0',NULL,'Template for monitoring Intel SR1630 server system.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2327c665b46e4aa781d41240168c3867','INTEL SR1630 IPMI','Zabbix','7.4-0',NULL,'0','0',''),
('10173',NULL,'VMware','3','-1','2','','','VMware','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nNote: To enable discovery of hardware sensors of VMware Hypervisors, set the macro \'{$VMWARE.HV.SENSOR.DISCOVERY}\' to the value \'true\' on the discovered host level.\r\n\r\nNote: To create custom performance counter see documentation: https://www.zabbix.com/documentation/7.4/manual/vm_monitoring/vmware_keys#footnotes\r\n\r\nNote: To get all supported counters and generate path for custom performance counter see documentation: https://www.zabbix.com/documentation/7.4/manual/appendix/items/perf_counters\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','56079badd056419383cc26e6a4fcc7e0','VMWARE','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis template set is designed for the effortless deployment of VMware vCenter and ESX hypervisor monitoring and doesn\'t require any external scripts.\r\n\r\n- The template "VMware Guest" is used in discovery and normally should not be manually linked to a host.\r\n- The template "VMware Hypervisor" can be used in discovery as well as manually linked to a host.\r\n\r\nFor additional information, please see [Zabbix documentation on VM monitoring](https://www.zabbix.com/documentation/7.4/manual/vm_monitoring).\r\n\r\n## Setup\r\n\r\n1. Compile Zabbix server with the required options (`--with-libxml2` and `--with-libcurl`)\r\n2. Set the `StartVMwareCollectors` option in the Zabbix server configuration file to "1" or more\r\n3. Create a new host\r\n4. If you want to use a separate user for monitoring, make sure that the user is a member of the `SystemConfiguration.ReadOnly` and `vStatsGroup` groups\r\nSet the host wizard configuration fields required for VMware authentication: `VMware URL`, `VMware username` and `VMware password`\r\n5. Link the template to the host created earlier\r\n\r\nNote: To enable discovery of hardware sensors of VMware hypervisors, set the host wizard configuration field `Monitoring of hardware sensors` to the selected state.\r\n\r\nAdditional resources:\r\n- How to [create a custom performance counter](https://www.zabbix.com/documentation/7.4/manual/vm_monitoring/vmware_keys#footnotes)\r\n- How to get all supported counters and [generate a path for the custom performance counter](https://www.zabbix.com/documentation/7.4/manual/appendix/items/perf_counters)'),
('10174',NULL,'VMware Guest','3','-1','2','','','VMware Guest','0',NULL,'Note: To enable trigger for free space for guest VM, set macro \'{$VMWARE.VM.FS.TRIGGER.USED}\' to the value \'1\' on the discovered host level.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7942fb93ae3b47cf9ca0ea4beb0675ce','VMWARE GUEST','Zabbix','7.4-3',NULL,'0','0',''),
('10175',NULL,'VMware Hypervisor','3','-1','2','','','VMware Hypervisor','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nThis template can be used in discovery as well as manually linked to a host. To use this template as manually linked to a host, attach it to the host and set manually the value of \'{$VMWARE.HV.UUID}\' macro.\r\n\r\nNote: To create custom performance counter see documentation: https://www.zabbix.com/documentation/7.4/manual/vm_monitoring/vmware_keys#footnotes\r\n\r\nNote: To get all supported counters and generate path for custom performance counter see documentation: https://www.zabbix.com/documentation/7.4/manual/appendix/items/perf_counters\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5899b2f0aced4085b5ac25d0461b3425','VMWARE HYPERVISOR','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis template is designed for the effortless deployment of VMware ESX hypervisor monitoring and doesn\'t require any external scripts.\r\n\r\nThis template can be used in discovery as well as manually linked to a host.\r\n\r\nFor additional information, please see [Zabbix documentation on VM monitoring](https://www.zabbix.com/documentation/7.4/manual/vm_monitoring).\r\n\r\nTo use this template as manually linked to a host, attach it to the host and manually set the `Hypervisor UUID` host wizard configuration field.\r\n\r\n## Setup\r\n\r\nTo use this template as manually linked to a host:\r\n  1. Compile Zabbix server with the required options (`--with-libxml2` and `--with-libcurl`)\r\n  2. Set the `StartVMwareCollectors` option in the Zabbix server configuration file to "1" or more\r\n  3. Set the host wizard configuration fields required for VMware authentication: `VMware URL`, `VMware username` and `VMware password`\r\n  4. To get the hypervisor UUID, enable access to the hypervisor via SSH and log in via SSH using a valid login and password.\r\n  5. Run the following command and specify the UUID in the `Hypervisor UUID` host wizard configuration field:\r\n  ```text\r\n  vim-cmd hostsvc/hostsummary | grep uuid\r\n  ```\r\n\r\nNote: To enable discovery of hardware sensors of VMware hypervisors, set the host wizard configuration field `Monitoring of hardware sensors` to the selected state.'),
('10207',NULL,'Alcatel Timetra TiMOS by SNMP','3','-1','2','','','Alcatel Timetra TiMOS by SNMP','0',NULL,'Template Net Alcatel Timetra TiMOS\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\nTIMETRA-SYSTEM-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nTIMETRA-CHASSIS-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','53044571fb864d87af32473e08c76d0b','ALCATEL TIMETRA TIMOS BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10208',NULL,'Brocade FC by SNMP','3','-1','2','','','Brocade FC by SNMP','0',NULL,'Template Net Brocade FC\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nSW-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: no IF-MIB::ifAlias is available\r\n  Version: v6.3.1c, v7.0.0c,  v7.4.1c\r\n  Device: all\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','de96d02bd5f242bfa31308ae2131d03f','BROCADE FC BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10210',NULL,'Brocade_Foundry Nonstackable by SNMP','3','-1','2','','','Brocade_Foundry Nonstackable by SNMP','0',NULL,'Template Net Brocade Foundry Nonstackable\r\n\r\nMIBs used:\r\nFOUNDRY-SN-AGENT-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6ecfb7083ddf45f183ab4be50cfba37a','BROCADE_FOUNDRY NONSTACKABLE BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10211',NULL,'Brocade_Foundry Stackable by SNMP','3','-1','2','','','Brocade_Foundry Stackable by SNMP','0',NULL,'Template Brocade Foundry Stackable\r\n\r\nMIBs used:\r\nFOUNDRY-SN-AGENT-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nFOUNDRY-SN-STACKING-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Correct fan(returns fan status as \'other(1)\' and temperature (returns 0) for the non-master Switches are not available in SNMP\r\n  Version: Version 08.0.40b and above\r\n  Device: ICX 7750 in stack\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f64ad01567914165a493815e492fb315','BROCADE_FOUNDRY STACKABLE BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10218',NULL,'Cisco IOS by SNMP','3','-1','2','','','Cisco IOS by SNMP','0',NULL,'Template Cisco IOS Software releases 12.2(3.5) or later\r\n\r\nMIBs used:\r\nCISCO-MEMORY-POOL-MIB\r\nIF-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nCISCO-ENVMON-MIB\r\nCISCO-PROCESS-MIB\r\nENTITY-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: no if(in|out)(Errors|Discards) are available for vlan ifType\r\n  Version: IOS for example: 12.1(22)EA11, 15.4(3)M2\r\n  Device: C2911, C7600\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','aa3ce9bd8c1d40a2b0f83f9e642e88ee','CISCO IOS BY SNMP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\n### Known Issues\r\n\r\nDescription: no if(in|out)(Errors|Discards) are available for vlan ifType\r\nVersion: IOS for example: 12.1(22)EA11, 15.4(3)M2\r\nDevice: C2911, C7600'),
('10220',NULL,'Cisco IOS prior to 12.0_3_T by SNMP','3','-1','2','','','Cisco IOS prior to 12.0_3_T by SNMP','0',NULL,'Cisco IOS Software releases prior to 12.0(3)T\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nOLD-CISCO-CPU-MIB\r\nCISCO-ENVMON-MIB\r\nCISCO-MEMORY-POOL-MIB\r\nENTITY-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1bb42fbdb9054645a62ff81f14ba3b99','CISCO IOS PRIOR TO 12.0_3_T BY SNMP','Zabbix','7.4-1',NULL,'0','1',''),
('10221',NULL,'Dell Force S-Series by SNMP','3','-1','2','','','Dell Force S-Series by SNMP','0',NULL,'Template Dell Force S-Series\r\n\r\nMIBs used:\r\nF10-S-SERIES-CHASSIS-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e5ec7acc7efc4ac491b6fa552ab077ae','DELL FORCE S-SERIES BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10222',NULL,'D-Link DES 7200 by SNMP','3','-1','2','','','D-Link DES 7200 by SNMP','0',NULL,'Template D-Link DES 7200\r\n\r\nMIBs used:\r\nENTITY-MIBdescription has changed\r\nIF-MIB\r\nMY-PROCESS-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMY-MEMORY-MIB\r\nENTITY-MIB\r\nMY-SYSTEM-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','395184b5d5b048a68e06c91154c56847','D-LINK DES 7200 BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10223',NULL,'D-Link DES_DGS Switch by SNMP','3','-1','2','','','D-Link DES_DGS Switch by SNMP','0',NULL,'Template D-Link DES_DGS Switch\r\n\r\nMIBs used:\r\nEQUIPMENT-MIB\r\nIF-MIB\r\nDLINK-AGENT-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: D-Link reports missing PSU as fail(4)\r\n  Version: Firmware: 1.73R008,hardware revision: B1\r\n  Device: DGS-3420-26SC Gigabit Ethernet Switch\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d3176749a5274264938f487cd89d17eb','D-LINK DES_DGS SWITCH BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10224',NULL,'Extreme EXOS by SNMP','3','-1','2','','','Extreme EXOS by SNMP','0',NULL,'Template Extreme EXOS\r\n\r\nMIBs used:\r\nEXTREME-SYSTEM-MIB\r\nIF-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nEXTREME-SOFTWARE-MONITOR-MIB\r\nENTITY-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','861dbdece18f4b8f85214a319995eb3e','EXTREME EXOS BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10226',NULL,'Network Generic Device by SNMP','3','-1','2','','','Network Generic Device by SNMP','0',NULL,'Template Net Network Generic Device\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','67332e679035423f85090aa985947c36','NETWORK GENERIC DEVICE BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10227',NULL,'HP Comware HH3C by SNMP','3','-1','2','','','HP Comware HH3C by SNMP','0',NULL,'Template Net HP Comware (HH3C)\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\nHH3C-ENTITY-EXT-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: No temperature sensors. All entities of them return 0 for HH3C-ENTITY-EXT-MIB::hh3cEntityExtTemperature\r\n  Version: 1910-48 Switch Software Version 5.20.99, Release 1116 Copyright(c)2010-2016 Hewlett Packard Enterprise Development LP\r\n  Device: HP 1910-48\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','57aeccd43b744942b9555269b79a96ad','HP COMWARE HH3C BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10229',NULL,'Huawei VRP by SNMP','3','-1','2','','','Huawei VRP by SNMP','0',NULL,'Template Net Huawei VRP\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\nHUAWEI-ENTITY-EXTENT-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ad4c3dad4b7b492685d1fd3bd3a664f9','HUAWEI VRP BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10230',NULL,'Intel_Qlogic Infiniband by SNMP','3','-1','2','','','Intel_Qlogic Infiniband by SNMP','0',NULL,'Template Net Intel_Qlogic Infiniband\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nICS-CHASSIS-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6f7f2c44e13a46a4b219fbb5db92f3f7','INTEL_QLOGIC INFINIBAND BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10231',NULL,'Juniper by SNMP','3','-1','2','','','Juniper by SNMP','0',NULL,'Template Net Juniper\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\nJUNIPER-ALARM-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nJUNIPER-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a326034825984bbd8a3a5885f3939bb3','JUNIPER BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10233',NULL,'Mikrotik by SNMP','3','-1','2','','','Mikrotik by SNMP','0',NULL,'Template Net Mikrotik\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Doesn\'t have ifHighSpeed filled. fixed in more recent versions\r\n  Version: RouterOS 6.28 or lower\r\n\r\n  Description: Doesn\'t have any temperature sensors\r\n  Version: RouterOS 6.38.5\r\n  Device: Mikrotik 941-2nD, Mikrotik 951G-2HnD\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','815b5a81b29a477695fddbd533ad9c84','MIKROTIK BY SNMP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nAt the core of all MikroTik hardware is RouterOS, a powerful and versatile operating system. It offers a vast array of networking features.\r\n\r\n### Known Issues\r\n\r\n  Description: Doesn\'t have ifHighSpeed filled. fixed in more recent versions\r\n  Version: RouterOS 6.28 or lower\r\n\r\n  Description: Doesn\'t have any temperature sensors\r\n  Version: RouterOS 6.38.5\r\n  Device: Mikrotik 941-2nD, Mikrotik 951G-2HnD'),
('10234',NULL,'Netgear Fastpath by SNMP','3','-1','2','','','Netgear Fastpath by SNMP','0',NULL,'Template Net Netgear Fastpath\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nFASTPATH-SWITCHING-MIB\r\nFASTPATH-BOXSERVICES-PRIVATE-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5920713da492452889adabc25e259caa','NETGEAR FASTPATH BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10235',NULL,'QTech QSW by SNMP','3','-1','2','','','QTech QSW by SNMP','0',NULL,'Template Net QTech QSW\r\n\r\nMIBs used:\r\nQTECH-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','21f3e79e1d2e4f5e868d1ef81c94bbfd','QTECH QSW BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10236',NULL,'TP-LINK by SNMP','3','-1','2','','','TP-LINK by SNMP','0',NULL,'Template Net TP-LINK\r\n\r\nMIBs used:\r\nTPLINK-SYSINFO-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nTPLINK-SYSMONITOR-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Default sysLocation, sysName and sysContact is not filled with proper data. Real hostname and location can be found only in private branch (TPLINK-SYSINFO-MIB). Please check whether this problem exists in the latest firmware: https://www.tp-link.com/en/support/download/t2600g-28ts/#Firmware\r\n  Version: 2.0.0 Build 20170628 Rel.55184 (Beta)\r\n  Device: T2600G-28TS 2.0\r\n\r\n  Description: The Serial number of the product (tpSysInfoSerialNum) is missing in HW versions prior to V2_170323\r\n  Version: Prior to version V2_170323\r\n  Device: T2600G-28TS 2.0\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2b9039885edf45b8bdd39f16dd069133','TP-LINK BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10237',NULL,'Ubiquiti AirOS by SNMP','3','-1','2','','','Ubiquiti AirOS by SNMP','0',NULL,'Template Net Ubiquiti AirOS\r\n\r\nMIBs used:\r\nFROGFOOT-RESOURCES-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nIEEE802dot11-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: UBNT unifi reports speed: like IF-MIB::ifSpeed.1 = Gauge32: 4294967295 for all interfaces\r\n  Version: Firmware: BZ.ar7240.v3.7.51.6230.170322.1513\r\n  Device: UBNT UAP-LR\r\n\r\n  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports ifSpeed: as 0 for VLAN and wireless(ath0) interfaces\r\n  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836\r\n  Device: NanoStation M5\r\n\r\n  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports always return ifType: as ethernet(6) even for wifi,vlans and other types\r\n  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836\r\n  Device: NanoStation M5\r\n\r\n  Description: ifXTable is not provided in IF-MIB. So Interfaces Simple Template is used instead\r\n  Version: all above\r\n  Device: NanoStation, UAP-LR\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6c235d126c1f4895acfe2156b140a886','UBIQUITI AIROS BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10248',NULL,'Linux by SNMP','3','-1','2','','','Linux by SNMP','0',NULL,'This is an official Linux template. It requires an SNMP client.\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nUCD-DISKIO-MIB\r\nUCD-SNMP-MIB\r\nIF-MIB\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 * (used / used + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4d3a7adbb6964bd08f2b9d28e0da6496','LINUX BY SNMP','Zabbix','7.4-3',NULL,'0','1','## Overview\r\n\r\nThis is an official Linux template. It requires an SNMP client.\r\n\r\n#### Notes on filesystem (FS) discovery:\r\n- The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n- BTRFS allocates a default of 10% of the volume for its own needs.\r\n- To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n  - Utilization formula: `pused = 100 * (used / used + available)`\r\n- The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\n## Setup\r\n\r\nInstall snmpd agent on Linux OS, enable SNMPv2.\r\n\r\nMake sure access to UCD-SNMP-MIB is allowed from Zabbix server/proxy host, since,\r\nby default, snmpd (for example, in Ubuntu) limits access to basic system information only:\r\n\r\n```text\r\nrocommunity public  default    -V systemonly\r\n```\r\n\r\nEnsure snmpd is monitoring disks, using `includeALLDisks` or `disk` options. Example:\r\n```\r\nincludeALLDisks 0% # monitors all disks starting with 0% fill rate\r\n# disk / 0% # monitor only / root volume starting with 0% fill rate\r\n```\r\nMake sure you change that in order to read metrics of UCD-SNMP-MIB and UCD-DISKIO-MIB. Please refer to the documentation:\r\nhttp://www.net-snmp.org/wiki/index.php/Vacm\r\n\r\nYou can also try to use `snmpconf`:\r\n\r\nhttp://www.net-snmp.org/wiki/index.php/TUT:snmpd_configuration'),
('10249',NULL,'Windows by SNMP','3','-1','2','','','Windows by SNMP','0',NULL,'This is an official Windows template. It requires an SNMP client.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description:\r\n    64-bit I/O is not supported even though `IfxTable` is present.\r\n    Currently, Windows gets its interface status from MIB-2. Since these 64-bit SNMP counters (`ifHCInOctets`, `ifHCOutOctets`, etc.) are defined as an extension to IF-MIB, Microsoft has not implemented it.\r\n    https://social.technet.microsoft.com/Forums/windowsserver/en-US/07b62ff0-94f6-40ca-a99d-d129c1b33d70/windows-2008-r2-snmp-64bit-counters-support?forum=winservergen\r\n  Version: Win2008, Win2012R2.\r\n\r\n  Description: MIB is not supported\r\n  Version: WindowsXP\r\n\r\n  Description: EtherLike MIB is not supported\r\n  Version: any\r\n\r\n  Description:\r\n    HOST-RESOURCES-MIB::hrStorageSize is limited to number 2147483647.\r\n    Storage size is calculated using: `hrStorageSize` and `hrStorageAllocationUnits`.\r\n    Allocation size of 512 bytes, sets the limit of monitored device to 1TB.\r\n  Version: any\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f9a59315c8944853bb91c0a9ec3056d7','WINDOWS BY SNMP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis is an official Windows template. It requires an SNMP client.\r\n\r\nMIBs used:\r\n- HOST-RESOURCES-MIB\r\n- SNMPv2-MIB\r\n- IF-MIB\r\n\r\n### Known Issues\r\n\r\n- 64-bit I/O is not supported even though `IfxTable` is present.\r\n  Currently, Windows gets its interface status from MIB-2. Since these 64-bit SNMP counters (`ifHCInOctets`, `ifHCOutOctets`, etc.) are defined as an extension to IF-MIB, Microsoft has not implemented it.\r\n  https://social.technet.microsoft.com/Forums/windowsserver/en-US/07b62ff0-94f6-40ca-a99d-d129c1b33d70/windows-2008-r2-snmp-64bit-counters-support?forum=winservergen\r\n  - version: Win2008, Win2012R2.\r\n- `ifXTable` is not supported.\r\n  - version: WindowsXP\r\n- EtherLike MIB is not supported\r\n  - version: any\r\n- HOST-RESOURCES-MIB::hrStorageSize is limited to number 2147483647.\r\n  Storage size is calculated using: `hrStorageSize` and `hrStorageAllocationUnits`.\r\n  An allocation size of 512 bytes, sets the limit of monitored device to 1TB.\r\n  |hrStorageAllocationUnits|Max size (TB)|\r\n  |---|---|\r\n  |512 bytes|1|\r\n  |1024 bytes|2|\r\n  |2048 bytes|4|\r\n  |64 KB|128|\r\n  - version: any'),
('10250',NULL,'HP Enterprise Switch by SNMP','3','-1','2','','','HP Enterprise Switch by SNMP','0',NULL,'Template Net HP Enterprise Switch\r\n\r\nMIBs used:\r\nNETSWITCH-MIB\r\nHP-ICF-CHASSIS\r\nENTITY-SENSORS-MIB\r\nIF-MIB\r\nEtherLike-MIB\r\nSEMI-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\nSTATISTICS-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cce20a5d149a48b7ac7f5383c3510883','HP ENTERPRISE SWITCH BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10251',NULL,'Mellanox by SNMP','3','-1','2','','','Mellanox by SNMP','0',NULL,'The updated template for monitoring the Mellanox network switches over SNMP agent. All items collected in one template without any linked templates.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-SENSORS-MIB\r\nENTITY-STATE-MIB\r\nENTITY-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a60798c651604d93a062bec0f8a89751','MELLANOX BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10253',NULL,'Cisco IOS versions 12.0_3_T-12.2_3.5 by SNMP','3','-1','2','','','Cisco IOS versions 12.0_3_T-12.2_3.5 by SNMP','0',NULL,'Cisco IOS Software releases later to 12.0(3)T and prior to 12.2(3.5)\r\n\r\nMIBs used:\r\nCISCO-MEMORY-POOL-MIB\r\nIF-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nCISCO-ENVMON-MIB\r\nCISCO-PROCESS-MIB\r\nENTITY-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','40c233aaa3424fd29dc378022ff3461d','CISCO IOS VERSIONS 12.0_3_T-12.2_3.5 BY SNMP','Zabbix','7.4-1',NULL,'0','1',''),
('10254',NULL,'Arista by SNMP','3','-1','2','','','Arista by SNMP','0',NULL,'Template Net Arista\r\n\r\nMIBs used:\r\nENTITY-SENSORS-MIB\r\nENTITY-STATE-MIB\r\nIF-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','26674f62500e4e79b9f470bbf962130d','ARISTA BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10255',NULL,'Dell iDRAC by SNMP','3','-1','2','','','Dell iDRAC by SNMP','0',NULL,'Template for Dell servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','43dc5c8a9a0e4786b64e44422c7f32b4','DELL IDRAC BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10256',NULL,'HP iLO by SNMP','3','-1','2','','','HP iLO by SNMP','0',NULL,'Template Server HP iLO\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c2a7ddca051d4b4a9553f339c57e47a9','HP ILO BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10258',NULL,'IBM IMM by SNMP','3','-1','2','','','IBM IMM by SNMP','0',NULL,'Template Server IBM IMM\r\n\r\nMIBs used:\r\nIMM-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Some IMMs (IMM1) do not return disks\r\n  Version: IMM1\r\n  Device: IBM x3250M3\r\n\r\n  Description: Some IMMs (IMM1) do not return fan status: fanHealthStatus\r\n  Version: IMM1\r\n  Device: IBM x3250M3\r\n\r\n  Description: IMM1 servers (M2, M3 generations) sysObjectID is NET-SNMP-MIB::netSnmpAgentOIDs.10\r\n  Version: IMM1\r\n  Device: IMM1 servers (M2,M3 generations)\r\n\r\n  Description: IMM1 servers (M2, M3 generations) only Ambient temperature sensor available\r\n  Version: IMM1\r\n  Device: IMM1 servers (M2,M3 generations)\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c9e1acd3ae4a427ab39724b6bcaf839e','IBM IMM BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10259',NULL,'Supermicro Aten by SNMP','3','-1','2','','','Supermicro Aten by SNMP','0',NULL,'Template Server Supermicro Aten\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nATEN-IPMI-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cf0947cc05d3450b9a6d66b2eb180482','SUPERMICRO ATEN BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10260',NULL,'Apache Tomcat by JMX','3','-1','2','','','Apache Tomcat by JMX','0',NULL,'The template to monitor Apache Tomcat by Zabbix that work without any external scripts.\r\nThe metrics are collected by JMX.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411862-discussion-thread-for-official-zabbix-template-tomcat\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3cc8c9ae7055458c9a803597007f70bd','APACHE TOMCAT BY JMX','Zabbix','7.4-0',NULL,'0','0',''),
('10261',NULL,'Remote Zabbix server health','3','-1','2','','','Remote Zabbix server health','0',NULL,'This template is designed to monitor internal Zabbix metrics on the remote Zabbix server.\r\n\r\nSpecify the address of the remote Zabbix server by changing the {$ZABBIX.SERVER.ADDRESS} and {$ZABBIX.SERVER.PORT} macros. Don\'t forget to adjust the "StatsAllowedIP" parameter in the remote server\'s configuration file to allow the collection of statistics.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','79b16cbbe593444eae3de66de0cb566b','REMOTE ZABBIX SERVER HEALTH','Zabbix','7.4-5',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor internal Zabbix metrics on the remote Zabbix server.\r\n\r\n## Setup\r\n\r\nSpecify the address of the remote Zabbix server as the values for the `Zabbix server Address` and `Zabbix server Port` configuration fields. Don\'t forget to adjust the `StatsAllowedIP` parameter in the remote server\'s configuration file to allow the collection of statistics.'),
('10262',NULL,'Remote Zabbix proxy health','3','-1','2','','','Remote Zabbix proxy health','0',NULL,'This template is designed to monitor internal Zabbix metrics on the remote Zabbix proxy.\r\n\r\nSpecify the address of the remote Zabbix proxy by updating the {$ZABBIX.PROXY.ADDRESS} and {$ZABBIX.PROXY.PORT} macros. Don\'t forget to adjust the "StatsAllowedIP" parameter in the remote proxy\'s configuration file to allow the collection of statistics.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','970c2342146549768e6b91a26089bcdf','REMOTE ZABBIX PROXY HEALTH','Zabbix','7.4-3',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor internal Zabbix metrics on the remote Zabbix proxy.\r\n\r\n## Setup\r\n\r\nSpecify the address of the remote Zabbix proxy as the values for the `Zabbix proxy Address` and `Zabbix proxy Port` configuration fields. Don\'t forget to adjust the `StatsAllowedIP` parameter in the remote proxy\'s configuration file to allow the collection of statistics.'),
('10264',NULL,'Apache by Zabbix agent','3','-1','2','','','Apache by Zabbix agent','0',NULL,'Get metrics from mod_status module using HTTP agent.\r\nhttps://httpd.apache.org/docs/current/mod/mod_status.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a8d91e4f36794e32b73090d5edf3d7ae','APACHE BY ZABBIX AGENT','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is designed for the effortless deployment of Apache monitoring by Zabbix via Zabbix agent and doesn\'t require any external scripts.\r\nThe template `Apache by Zabbix agent` - collects metrics by polling [mod_status](https://httpd.apache.org/docs/current/mod/mod_status.html) locally with Zabbix agent:\r\n  \r\n```text\r\n127.0.0.1\r\nServerVersion: Apache/2.4.41 (Unix)\r\nServerMPM: event\r\nServer Built: Aug 14 2019 00:35:10\r\nCurrentTime: Friday, 16-Aug-2019 12:38:40 UTC\r\nRestartTime: Wednesday, 14-Aug-2019 07:58:26 UTC\r\nParentServerConfigGeneration: 1\r\nParentServerMPMGeneration: 0\r\nServerUptimeSeconds: 189613\r\nServerUptime: 2 days 4 hours 40 minutes 13 seconds\r\nLoad1: 4.60\r\nLoad5: 1.20\r\nLoad15: 0.47\r\nTotal Accesses: 27860\r\nTotal kBytes: 33011\r\nTotal Duration: 54118\r\nCPUUser: 18.02\r\nCPUSystem: 31.76\r\nCPUChildrenUser: 0\r\nCPUChildrenSystem: 0\r\nCPULoad: .0262535\r\nUptime: 189613\r\nReqPerSec: .146931\r\nBytesPerSec: 178.275\r\nBytesPerReq: 1213.33\r\nDurationPerReq: 1.9425\r\nBusyWorkers: 7\r\nIdleWorkers: 93\r\nProcesses: 4\r\nStopping: 0\r\nBusyWorkers: 7\r\nIdleWorkers: 93\r\nConnsTotal: 13\r\nConnsAsyncWriting: 0\r\nConnsAsyncKeepAlive: 5\r\nConnsAsyncClosing: 0\r\nScoreboard: ...\r\n\r\n```\r\n  \r\nIt also uses Zabbix agent to collect `Apache` Linux process statistics such as CPU usage, memory usage, and whether the process is running or not.\r\n\r\n## Setup\r\n\r\nSee the setup instructions for [mod_status](https://httpd.apache.org/docs/current/mod/mod_status.html).\r\n\r\nCheck the availability of the module with this command line: `httpd -M 2>/dev/null | grep status_module`\r\n\r\nThis is an example configuration of the Apache web server:\r\n\r\n```text\r\n<Location "/server-status">\r\n  SetHandler server-status\r\n  Require host example.com\r\n</Location>\r\n```\r\n\r\nIf you use another path, then do not forget to change the `Apache status page path` host wizard configuration field.'),
('10265',NULL,'Apache by HTTP','3','-1','2','','','Apache by HTTP','0',NULL,'This template is designed for the effortless deployment of Apache monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n\r\nThe template collects metrics by polling \'mod_status\' with HTTP agent remotely.\r\n\r\nSetup:\r\n\r\n1. See the setup instructions for mod_status:\r\nhttps://httpd.apache.org/docs/current/mod/mod_status.html\r\n\r\nCheck the availability of the module with this command line:\r\nhttpd -M 2>/dev/null | grep status_module\r\n\r\nThis is an example configuration of the Apache web server:\r\n\r\n<Location "/server-status">\r\n  SetHandler server-status\r\n  Require host example.com\r\n</Location>\r\n\r\n2. Set the hostname or IP address of the Apache status page host in the \'{$APACHE.STATUS.HOST}\' macro. You can also change the status page port in the \'{$APACHE.STATUS.PORT}\' macro and status page path in the \'{$APACHE.STATUS.PATH}\' macro if necessary.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','86702e8bc514434e8c914d50c206cb94','APACHE BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is designed for the effortless deployment of Apache monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n\r\nThe template collects metrics by polling [`mod_status`](https://httpd.apache.org/docs/current/mod/mod_status.html) with HTTP agent remotely:\r\n\r\n```text\r\n127.0.0.1\r\nServerVersion: Apache/2.4.41 (Unix)\r\nServerMPM: event\r\nServer Built: Aug 14 2019 00:35:10\r\nCurrentTime: Friday, 16-Aug-2019 12:38:40 UTC\r\nRestartTime: Wednesday, 14-Aug-2019 07:58:26 UTC\r\nParentServerConfigGeneration: 1\r\nParentServerMPMGeneration: 0\r\nServerUptimeSeconds: 189613\r\nServerUptime: 2 days 4 hours 40 minutes 13 seconds\r\nLoad1: 4.60\r\nLoad5: 1.20\r\nLoad15: 0.47\r\nTotal Accesses: 27860\r\nTotal kBytes: 33011\r\nTotal Duration: 54118\r\nCPUUser: 18.02\r\nCPUSystem: 31.76\r\nCPUChildrenUser: 0\r\nCPUChildrenSystem: 0\r\nCPULoad: .0262535\r\nUptime: 189613\r\nReqPerSec: .146931\r\nBytesPerSec: 178.275\r\nBytesPerReq: 1213.33\r\nDurationPerReq: 1.9425\r\nBusyWorkers: 7\r\nIdleWorkers: 93\r\nProcesses: 4\r\nStopping: 0\r\nBusyWorkers: 7\r\nIdleWorkers: 93\r\nConnsTotal: 13\r\nConnsAsyncWriting: 0\r\nConnsAsyncKeepAlive: 5\r\nConnsAsyncClosing: 0\r\nScoreboard: ...\r\n```\r\n\r\n## Setup\r\n\r\n1. See the setup instructions for [`mod_status`](https://httpd.apache.org/docs/current/mod/mod_status.html).\r\n\r\nCheck the availability of the module with this command line:\r\n`httpd -M 2>/dev/null | grep status_module`\r\n\r\nThis is an example configuration of the Apache web server:\r\n\r\n```text\r\n<Location "/server-status">\r\n  SetHandler server-status\r\n  Require host example.com\r\n</Location>\r\n```\r\n\r\n2. Set the hostname or IP address of the Apache status page host in the `Apache status host` host wizard configuration field. You can also change the status page port in the `Apache status page port` field and status page path in the `Apache status page path` field if necessary.'),
('10266',NULL,'Nginx by Zabbix agent','3','-1','2','','','Nginx by Zabbix agent','0',NULL,'Get metrics from stub status module using Zabbix agent running on Linux\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','27f6424905884dbb96ab9210d987a56c','NGINX BY ZABBIX AGENT','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is developed to monitor Nginx by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template `Nginx by Zabbix agent` - collects metrics by polling the [Module ngx_http_stub_status_module](https://nginx.ru/en/docs/http/ngx_http_stub_status_module.html) locally with Zabbix agent:\r\n\r\n```text\r\nActive connections: 291\r\nserver accepts handled requests\r\n16630948 16630948 31070465\r\nReading: 6 Writing: 179 Waiting: 106\r\n```\r\n\r\nNote that this template doesn\'t support HTTPS and redirects (limitations of `web.page.get`).\r\n\r\nIt also uses Zabbix agent to collect `Nginx` Linux process statistics, such as CPU usage, memory usage and whether the process is running or not.\r\n\r\n\r\n## Setup\r\n\r\nSee the setup instructions for [ngx_http_stub_status_module](https://nginx.ru/en/docs/http/ngx_http_stub_status_module.html).\r\nTest the availability of the `http_stub_status_module` `nginx -V 2>&1 | grep -o with-http_stub_status_module`.\r\n\r\nExample configuration of Nginx:\r\n```text\r\nlocation = /basic_status {\r\n    stub_status;\r\n    allow 127.0.0.1;\r\n    allow ::1;\r\n    deny all;\r\n}\r\n```\r\n\r\nIf you use another location, then don\'t forget to change the `Nginx status page path` host wizard configuration field.\r\n\r\nExample answer from Nginx:\r\n```text\r\nActive connections: 291\r\nserver accepts handled requests\r\n16630948 16630948 31070465\r\nReading: 6 Writing: 179 Waiting: 106\r\n```\r\n\r\nNote that this template doesn\'t support https and redirects (limitations of web.page.get).'),
('10267',NULL,'Nginx by HTTP','3','-1','2','','','Nginx by HTTP','0',NULL,'This template is developed to monitor Nginx by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template collects metrics by polling the module \'ngx_http_stub_status_module\' with HTTP agent remotely:\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html\r\n\r\nActive connections: 291\r\nserver accepts handled requests\r\n16630948 16630948 31070465\r\nReading: 6 Writing: 179 Waiting: 106\r\n\r\nSetup:\r\n\r\n1. See the setup instructions for \'ngx_http_stub_status_module\':\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html\r\n\r\nTest the availability of the \'http_stub_status_module\' with \'nginx -V 2>&1 | grep -o with-http_stub_status_module\'.\r\n\r\nExample configuration of Nginx:\r\n\r\nlocation = /basic_status {\r\n    stub_status;\r\n    allow <IP of your Zabbix server/proxy>;\r\n    deny all;\r\n}\r\n\r\n2. Set the hostname or IP address of the Nginx host or Nginx container in the \'{$NGINX.STUB_STATUS.HOST}\' macro. You can also change the status page port in the \'{$NGINX.STUB_STATUS.PORT}\' macro, the status page scheme in the \'{$NGINX.STUB_STATUS.SCHEME}\' macro and the status page path in the \'{$NGINX.STUB_STATUS.PATH}\' macro if necessary.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','13d5bb0a4ae84228bff408aab5be338e','NGINX BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is developed to monitor Nginx by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template collects metrics by polling the module [`ngx_http_stub_status_module`](https://nginx.ru/en/docs/http/ngx_http_stub_status_module.html) with HTTP agent remotely:\r\n\r\n```text\r\nActive connections: 291\r\nserver accepts handled requests\r\n16630948 16630948 31070465\r\nReading: 6 Writing: 179 Waiting: 106\r\n```\r\n\r\n## Setup\r\n\r\n1. See the setup instructions for [`ngx_http_stub_status_module`](https://nginx.ru/en/docs/http/ngx_http_stub_status_module.html).\r\n\r\nTest the availability of the `http_stub_status_module` with `nginx -V 2>&1 | grep -o with-http_stub_status_module`.\r\n\r\nExample configuration of Nginx:\r\n\r\n```text\r\nlocation = /basic_status {\r\n    stub_status;\r\n    allow <IP of your Zabbix server/proxy>;\r\n    deny all;\r\n}\r\n```\r\n\r\n2. Set the hostname or IP address of the Nginx host or Nginx container in the `Nginx status host` host wizard configuration field. You can also change the status page port in the `Nginx status page path` field, select the status page scheme in the `Request scheme` field and change the status page path in the `Nginx status page path` field if necessary.\r\n\r\nExample answer from Nginx:\r\n\r\n```text\r\nActive connections: 291\r\nserver accepts handled requests\r\n16630948 16630948 31070465\r\nReading: 6 Writing: 179 Waiting: 106\r\n```'),
('10285',NULL,'Linux by Prom','3','-1','2','','','Linux by Prom','0',NULL,'This template collects Linux metrics from node_exporter 0.18 and above. Support for older node_exporter versions is provided as \'best effort\'.\r\n\r\nSetup:\r\n\r\n1. Set up the node_exporter according to the official documentation:\r\nhttps://prometheus.io/docs/guides/node-exporter/\r\n\r\nUse node_exporter v0.18.0 or above.\r\n\r\n2. Set the hostname or IP address of the node_exporter host in the \'{$NODE_EXPORTER_HOST}\' macro. You can also change the Prometheus endpoint port in the \'{$NODE_EXPORTER_PORT}\' macro if necessary.\r\n\r\nKnown Issues:\r\n\r\n  - Node Exporter 0.16.0 renamed many metrics. CPU utilization for "guest" and "guest_nice" metrics are not supported in this template with Node Exporter < 0.16. Disk IO metrics are not supported. Other metrics provided as best effort. See https://github.com/prometheus/node_exporter/releases/tag/v0.16.0 for details.\r\n    - version: below 0.16.0\r\n  - metric node_network_info with label \'device\' cannot be found, so network discovery is not possible.\r\n    - version: below 0.18\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2506b0ca01884903b547b1e19b76ce6d','LINUX BY PROM','Zabbix','7.4-3',NULL,'0','1','## Overview\r\n\r\nThis template collects Linux metrics from Node Exporter 0.18 and above. Support for older Node Exporter versions is provided as best effort.\r\n\r\n### Known Issues\r\n\r\n  - Node Exporter 0.16.0 renamed many metrics. CPU utilization for "guest" and "guest_nice" metrics are not supported in this template with Node Exporter < 0.16. Disk IO metrics are not supported. Other metrics provided as best effort. See https://github.com/prometheus/node_exporter/releases/tag/v0.16.0 for details\r\nSee https://github.com/prometheus/node_exporter/releases/tag/v0.16.0 for details.\r\n    - version: below 0.16.0\r\n  - metric node_network_info with label \'device\' cannot be found, so network discovery is not possible.\r\n    - version: below 0.18\r\n\r\n#### Notes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: `pused = 100 - 100 * (available / total - free + available)`\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\n## Setup\r\n\r\n1. Set up the node_exporter according to the [`official documentation`](https://prometheus.io/docs/guides/node-exporter/). Use node_exporter v0.18.0 or above.\r\n\r\n2. Set the hostname or IP address of the node_exporter host in the `The node_exporter host` parameter. You can also change the Prometheus endpoint port in the `TCP Port node_exporter` parameter if necessary.'),
('10300',NULL,'RabbitMQ cluster by Zabbix agent','3','-1','2','','','RabbitMQ cluster by Zabbix agent','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5fa761bc51e4432a90c6c9eece930c4a','RABBITMQ CLUSTER BY ZABBIX AGENT','Zabbix','7.4-0',NULL,'0','0',''),
('10301',NULL,'RabbitMQ node by Zabbix agent','3','-1','2','','','RabbitMQ node by Zabbix agent','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d5dc11ae9ab143a89c4be534bbb35188','RABBITMQ NODE BY ZABBIX AGENT','Zabbix','7.4-0',NULL,'0','0',''),
('10302',NULL,'RabbitMQ cluster by HTTP','3','-1','2','','','RabbitMQ cluster by HTTP','0',NULL,'This template is developed to monitor the messaging broker RabbitMQ cluster by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template collects metrics by polling RabbitMQ management plugin with HTTP agent remotely.\r\n\r\nSetup:\r\n\r\n1. Enable the RabbitMQ management plugin. See the RabbitMQ documentation for the instructions:\r\nhttps://www.rabbitmq.com/management.html\r\n\r\n2. Create a user to monitor the service:\r\n\r\nrabbitmqctl add_user zbx_monitor <PASSWORD>\r\nrabbitmqctl set_permissions  -p / zbx_monitor "" "" ".*"\r\nrabbitmqctl set_user_tags zbx_monitor monitoring\r\n\r\n3. Set the hostname or IP address of the RabbitMQ cluster host in the \'{$RABBITMQ.API.CLUSTER_HOST}\' macro. You can also change the port in the \'{$RABBITMQ.API.PORT}\' macro and the scheme in the \'{$RABBITMQ.API.SCHEME}\' macro if necessary.\r\n\r\n4. Set the user name and password in the macros \'{$RABBITMQ.API.USER}\' and \'{$RABBITMQ.API.PASSWORD}\'.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8c8474148c2a4eaeabe5a9331ea99d77','RABBITMQ CLUSTER BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10303',NULL,'RabbitMQ node by HTTP','3','-1','2','','','RabbitMQ node by HTTP','0',NULL,'This template is developed to monitor the messaging broker RabbitMQ node by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template collects metrics by polling RabbitMQ management plugin with HTTP agent remotely.\r\n\r\nSetup:\r\n\r\n1. Enable the RabbitMQ management plugin. See the RabbitMQ documentation for the instructions:\r\nhttps://www.rabbitmq.com/management.html\r\n\r\n2. Create a user to monitor the service:\r\n\r\nrabbitmqctl add_user zbx_monitor <PASSWORD>\r\nrabbitmqctl set_permissions  -p / zbx_monitor "" "" ".*"\r\nrabbitmqctl set_user_tags zbx_monitor monitoring\r\n\r\n3. Set the hostname or IP address of the RabbitMQ node host in the \'{$RABBITMQ.API.HOST}\' macro. You can also change the port in the \'{$RABBITMQ.API.PORT}\' macro and the scheme in the \'{$RABBITMQ.API.SCHEME}\' macro if necessary.\r\n\r\n4. Set the user name and password in the macros \'{$RABBITMQ.API.USER}\' and \'{$RABBITMQ.API.PASSWORD}\'.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b9514029d03b44de9adf24251778dbf3','RABBITMQ NODE BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10304',NULL,'Cisco UCS by SNMP','3','-1','2','','','Cisco UCS by SNMP','0',NULL,'Template Server Cisco UCS\r\n\r\nMIBs used:\r\nCISCO-UNIFIED-COMPUTING-COMPUTE-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nCISCO-UNIFIED-COMPUTING-PROCESSOR-MIB\r\nCISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB\r\nCISCO-UNIFIED-COMPUTING-STORAGE-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cb66d34564e44b3893442fc74cf6e951','CISCO UCS BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10308',NULL,'HAProxy by Zabbix agent','3','-1','2','','','HAProxy by Zabbix agent','0',NULL,'The template to monitor HAProxy by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template collects metrics by polling the HAProxy stats page with Zabbix agent.\r\n\r\nNote, that this template doesn\'t support authentication and redirects (limitations of \'web.page.get\').\r\n\r\nSetup:\r\n\r\n1. Set up the HAProxy stats page:\r\nhttps://www.haproxy.com/blog/exploring-the-haproxy-stats-page/\r\n\r\nThe example configuration of HAProxy:\r\n\r\nfrontend stats\r\n    bind *:8404\r\n    stats enable\r\n    stats uri /stats\r\n    stats refresh 10s\r\n\r\n2. Set the hostname or IP address of the HAProxy stats host or container in the \'{$HAPROXY.STATS.HOST}\' macro. You can also change the status page port in the \'{$HAPROXY.STATS.PORT}\' macro, the status page scheme in the \'{$HAPROXY.STATS.SCHEME}\' macro and the status page path in the \'{$HAPROXY.STATS.PATH}\' macro if necessary.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','812073bf8df143bcae2a84b32c3965e5','HAPROXY BY ZABBIX AGENT','Zabbix','7.4-1',NULL,'0','0',''),
('10309',NULL,'HAProxy by HTTP','3','-1','2','','','HAProxy by HTTP','0',NULL,'The template to monitor HAProxy by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template collects metrics by polling the HAProxy stats page with HTTP agent.\r\n\r\nSetup:\r\n\r\n1. Set up the HAProxy stats page:\r\nhttps://www.haproxy.com/blog/exploring-the-haproxy-stats-page/\r\n\r\nIf you want to use authentication, set the username and password in the \'stats auth\' option of the configuration file.\r\n\r\nThe example configuration of HAProxy:\r\n\r\nfrontend stats\r\n    bind *:8404\r\n    stats enable\r\n    stats uri /stats\r\n    stats refresh 10s\r\n    #stats auth Username:Password  # Authentication credentials\r\n\r\n2. Set the hostname or IP address of the HAProxy stats host or container in the \'{$HAPROXY.STATS.HOST}\' macro. You can also change the status page port in the \'{$HAPROXY.STATS.PORT}\' macro, the status page scheme in the \'{$HAPROXY.STATS.SCHEME}\' macro and the status page path in the \'{$HAPROXY.STATS.PATH}\' macro if necessary.\r\n\r\n3. If you have enabled authentication in the HAProxy configuration file in step 1, set the username and password in the `{$HAPROXY.USERNAME}` and `{$HAPROXY.PASSWORD}` macros.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','948d046cb2894e5c8d07767a518cc1a9','HAPROXY BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10310',NULL,'Redis by Zabbix agent 2','3','-1','2','','','Redis by Zabbix agent 2','0',NULL,'Get Redis metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/389050-discussion-thread-for-official-zabbix-template-redis\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e111446745a1425b862f8727ae63bce4','REDIS BY ZABBIX AGENT 2','Zabbix','7.4-1',NULL,'0','0',''),
('10316',NULL,'MySQL by Zabbix agent','3','-1','2','','','MySQL by Zabbix agent','0',NULL,'Requirements for template operation:\r\n\r\n1. Install Zabbix agent and MySQL client. If necessary, add the path to the \'mysql\' and \'mysqladmin\' utilities to the global environment variable PATH.\r\n\r\n2. Copy the \'template_db_mysql.conf\' file with user parameters into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don\'t forget to restart Zabbix agent.\r\n\r\n3. Create the MySQL user that will be used for monitoring (\'<password>\' at your discretion). For example:\r\n\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information, please see MySQL documentation (https://dev.mysql.com/doc/refman/8.0/en/grant.html).\r\n\r\nNOTE: In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the SLAVE MONITOR privilege to be set for the monitoring user:\r\n\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information, please read the MariaDB documentation (https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/).\r\n\r\n4. Create \'.my.cnf\' configuration file in the home directory of Zabbix agent for Linux distributions (/var/lib/zabbix by default) or \'my.cnf\' in c:\\ for Windows. For example:\r\n\r\n[client]\r\nprotocol=tcp\r\nuser=\'zbx_monitor\'\r\npassword=\'<password>\'\r\n\r\nFor more information, please see MySQL documentation (https://dev.mysql.com/doc/refman/8.0/en/option-files.html).\r\n\r\nNOTE: Linux distributions that use SELinux may require additional steps for access configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f255e3fc32124b55b2a17ef3c961e5f5','MYSQL BY ZABBIX AGENT','Zabbix','7.4-3',NULL,'0','1','## Setup\r\n\r\n1. Install MySQL client. If necessary, add the path to the `mysql` and `mysqladmin` utilities to the global environment variable PATH.\r\n2. Copy the `template_db_mysql.conf` file with user parameters into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don\'t forget to restart Zabbix agent.\r\n3. Create the MySQL user that will be used for monitoring (`<password>` at your discretion). For example:\r\n\r\n```text\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n```\r\n\r\nFor more information, please see [`MySQL documentation`](https://dev.mysql.com/doc/refman/8.0/en/grant.html).\r\n\r\n4. Create `.my.cnf` configuration file in the home directory of Zabbix agent for Linux distributions (/var/lib/zabbix by default) or `my.cnf` in c:\\ for Windows. For example:\r\n\r\n```text\r\n[client]\r\nprotocol=tcp\r\nuser=\'zbx_monitor\'\r\npassword=\'<password>\'\r\n```\r\n\r\nFor more information, please see [`MySQL documentation`](https://dev.mysql.com/doc/refman/8.0/en/option-files.html).\r\n\r\n**NOTE:** In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the `SLAVE MONITOR` privilege to be set for the monitoring user:\r\n\r\n```text\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n```\r\n\r\nFor more information, please read the [`MariaDB documentation`](https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/).\r\n\r\nNOTE: Linux distributions that use SELinux may require additional steps for access configuration.\r\n\r\nFor example, the following rule could be added to the SELinux policy:\r\n\r\n```text\r\n# cat <<EOF > zabbix_home.te\r\nmodule zabbix_home 1.0;\r\n\r\nrequire {\r\n        type zabbix_agent_t;\r\n        type zabbix_var_lib_t;\r\n        type mysqld_etc_t;\r\n        type mysqld_port_t;\r\n        type mysqld_var_run_t;\r\n        class file { open read };\r\n        class tcp_socket name_connect;\r\n        class sock_file write;\r\n}\r\n\r\n#============= zabbix_agent_t ==============\r\n\r\nallow zabbix_agent_t zabbix_var_lib_t:file read;\r\nallow zabbix_agent_t zabbix_var_lib_t:file open;\r\nallow zabbix_agent_t mysqld_etc_t:file read;\r\nallow zabbix_agent_t mysqld_port_t:tcp_socket name_connect;\r\nallow zabbix_agent_t mysqld_var_run_t:sock_file write;\r\nEOF\r\n# checkmodule -M -m -o zabbix_home.mod zabbix_home.te\r\n# semodule_package -o zabbix_home.pp -m zabbix_home.mod\r\n# semodule -i zabbix_home.pp\r\n# restorecon -R /var/lib/zabbix\r\n```'),
('10317',NULL,'MySQL by ODBC','3','-1','2','','','MySQL by ODBC','0',NULL,'Requirements for template operation:\r\n1. Create a MySQL user for monitoring. For example:\r\n\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html.\r\n\r\nNOTE: In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the SLAVE MONITOR privilege to be set for the monitoring user:\r\n\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information please read the MariaDB documentation https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/\r\n\r\n2. Set the user name and password in the host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e19c120027e04da69b130e0f6cea29fc','MYSQL BY ODBC','Zabbix','7.4-3',NULL,'0','1','## Setup\r\n\r\n1. Create a MySQL user for monitoring (`<password>` at your discretion):\r\n\r\n```text\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n```\r\n\r\nFor more information, please see MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html\r\n\r\n**NOTE:** In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the `SLAVE MONITOR` privilege to be set for the monitoring user:\r\n\r\n```text\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n```\r\n\r\nFor more information please read the MariaDB documentation https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/\r\n\r\n2. Set the username and password in the `MySQL user` and `MySQL password` host wizard configuration fields.'),
('10318',NULL,'Docker by Zabbix agent 2','3','-1','2','','','Docker by Zabbix agent 2','0',NULL,'Get Docker engine metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/435429-discussion-thread-for-official-zabbix-template-docker\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c5fd214cdd0d4b3b8272e73b022ba5c2','DOCKER BY ZABBIX AGENT 2','Zabbix','7.4-1',NULL,'0','0',''),
('10319',NULL,'Memcached by Zabbix agent 2','3','-1','2','','','Memcached by Zabbix agent 2','0',NULL,'Get Memcached metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398623-discussion-thread-for-official-zabbix-template-memcached\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','05894ba2c9184d33992bf1bd21c347f6','MEMCACHED BY ZABBIX AGENT 2','Zabbix','7.4-2',NULL,'0','0',''),
('10320',NULL,'MySQL by Zabbix agent 2','3','-1','2','','','MySQL by Zabbix agent 2','0',NULL,'Requirements for template operation:\r\n\r\n1. Create a MySQL user for monitoring. For example:\r\n\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html.\r\n\r\nNOTE: In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the SLAVE MONITOR privilege to be set for the monitoring user:\r\n\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information please read the MariaDB documentation https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/\r\n\r\n2. Set in the {$MYSQL.DSN} macro the data source name of the MySQL instance either session name from Zabbix agent 2 configuration file or URI.\r\nExamples: MySQL1, tcp://localhost:3306, tcp://172.16.0.10, unix:/var/run/mysql.sock\r\nFor more information about MySQL Unix socket file please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/problems-with-mysql-sock.html.\r\n\r\n3. If you had set URI in the {$MYSQL.DSN}, please define the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).\r\nLeave macros {$MYSQL.USER} and {$MYSQL.PASSWORD} empty if you use a session name. Set the user name and password in the Plugins.Mysql.<...> section of your Zabbix agent 2 configuration file.\r\nFor more information about configuring the Zabbix MySQL plugin please read the documentation https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/src/go/plugins/mysql/README.md.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4904f84303c74c5e955b7849730c3155','MYSQL BY ZABBIX AGENT 2','Zabbix','7.4-3',NULL,'0','1','## Setup\r\n\r\n1. Create a MySQL user for monitoring (`<password>` at your discretion):\r\n\r\n```text\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n```\r\n\r\nFor more information, please see MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html\r\n\r\n**NOTE:** In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the `SLAVE MONITOR` privilege to be set for the monitoring user:\r\n\r\n```text\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n```\r\n\r\nFor more information please read the MariaDB documentation https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/\r\n\r\n2. Set in the `MySQL DSN` host wizard configuration field macro the data source name of the MySQL instance either session name from Zabbix agent 2 configuration file or URI.\r\n**Examples:** MySQL1, tcp://localhost:3306, tcp://172.16.0.10, unix:/var/run/mysql.sock\r\nFor more information about MySQL Unix socket file, see the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/problems-with-mysql-sock.html.\r\n\r\n3. If you had set URI in the `MySQL DSN` field, define the user name and password in `MySQL user` and `MySQL password` host wizard configuration fields.\r\nLeave fields `MySQL user` and `MySQL password` empty if you use a session name. Set the user name and password in the Plugins.Mysql.<...> section of your Zabbix agent 2 configuration file.\r\nFor more information about configuring the Zabbix MySQL plugin, see the documentation https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/src/go/plugins/mysql/README.md.'),
('10321',NULL,'Chassis by IPMI','3','-1','2','','','Chassis by IPMI','0',NULL,'Template for monitoring servers with BMC over IPMI that work without any external scripts.\r\nAll metrics are collected at once, thanks to Zabbix\'s bulk data collection. The template is available starting from Zabbix version 5.0.\r\nIt collects metrics by polling BMC remotely using an IPMI agent.\r\n\r\n\r\nKnown Issues:\r\n\r\n  Description: If the BMC has a sensor with an empty threshold value, we get the LLD error "Cannot create trigger...".\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398023-discussion-thread-for-official-zabbix-template-ipmi\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','02f35169a5a54a5aad8b3f06e798ab1f','CHASSIS BY IPMI','Zabbix','7.4-0',NULL,'0','0',''),
('10322',NULL,'Elasticsearch Cluster by HTTP','3','-1','2','','','Elasticsearch Cluster by HTTP','0',NULL,'The template to monitor Elasticsearch by Zabbix that work without any external scripts.\r\nIt works with both standalone and cluster instances.\r\nThe metrics are collected in one pass remotely using an HTTP agent.\r\nThey are getting values from REST API \'_cluster/health\', \'_cluster/stats\', \'_nodes/stats\' requests.\r\n\r\nSetup:\r\n\r\n1. Set the hostname or IP address of the Elasticsearch host in the \'{$ELASTICSEARCH.HOST}\' macro.\r\n\r\n2. Set the login and password in the \'{$ELASTICSEARCH.USERNAME}\' and \'{$ELASTICSEARCH.PASSWORD}\' macros.\r\n\r\n3. If you use an atypical location of ES API, don\'t forget to change the macros \'{$ELASTICSEARCH.SCHEME}\',\'{$ELASTICSEARCH.PORT}\'.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/399473-discussion-thread-for-official-zabbix-template-for-elasticsearch\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','52b2664578884d9eba62e47375c99f8e','ELASTICSEARCH CLUSTER BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10323',NULL,'ClickHouse by HTTP','3','-1','2','','','ClickHouse by HTTP','0',NULL,'This template is designed for the effortless deployment of ClickHouse monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n\r\nSetup:\r\n\r\n1. Create a user to monitor the service. For example, you could create a file \'/etc/clickhouse-server/users.d/zabbix.xml\' with the following content:\r\n\r\n<yandex>\r\n  <users>\r\n    <zabbix>\r\n      <password>zabbix_pass</password>\r\n      <networks incl="networks" />\r\n      <profile>web</profile>\r\n      <quota>default</quota>\r\n      <allow_databases>\r\n        <database>test</database>\r\n      </allow_databases>\r\n    </zabbix>\r\n  </users>\r\n</yandex>\r\n\r\n2. Set the hostname or IP address of the ClickHouse HTTP endpoint in the \'{$CLICKHOUSE.HOST}\' macro. You can also change the port in the \'{$CLICKHOUSE.PORT}\' macro and scheme in the \'{$CLICKHOUSE.SCHEME}\' macro if necessary.\r\n\r\n3. Set the login and password in the macros \'{$CLICKHOUSE.USER}\' and \'{$CLICKHOUSE.PASSWORD}\'. If you don\'t need an authentication - remove headers from HTTP-Agent type items.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','95f2053c21094ad4968440b562cc7ea2','CLICKHOUSE BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10324',NULL,'Etcd by HTTP','3','-1','2','','','Etcd by HTTP','0',NULL,'This template is designed to monitor \'etcd\' by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template \'Etcd by HTTP\' — collects metrics by help of the HTTP agent from \'/metrics\' endpoint.\r\n\r\nRefer to the vendor documentation:\r\nhttps://etcd.io/docs/v3.5/op-guide/monitoring/#metrics-endpoint\r\n\r\nFor the users of \'etcd version <= 3.4\':\r\n\r\nIn \'etcd v3.5\' some metrics have been deprecated. See more details on \'Upgrade etcd from 3.4 to 3.5\':\r\nhttps://etcd.io/docs/v3.4/upgrades/upgrade_3_5/\r\nPlease upgrade your \'etcd\' instance, or use older \'Etcd by HTTP\' template version.\r\n\r\nSetup:\r\n\r\n1. Make sure that \'etcd\' allows the collection of metrics. You can test it by running:\r\ncurl -L http://localhost:2379/metrics\r\n\r\n2. Check if \'etcd\' is accessible from Zabbix proxy or Zabbix server depending on where you are planning to do the monitoring. To verify it, run:\r\ncurl -L  http://<etcd_node_address>:2379/metrics\r\n\r\n3. Add the template to the \'etcd\' node. Set the hostname or IP address of the \'etcd\' host in the \'{$ETCD.HOST}\' macro. By default, the template uses a client\'s port.\r\nYou can configure metrics endpoint location by adding \'--listen-metrics-urls\' flag.\r\n\r\nFor more details, see the etcd documentation:\r\nhttps://etcd.io/docs/v3.5/op-guide/configuration/#profiling-and-monitoring\r\n\r\nAdditional points to consider:\r\n\r\n- If you have specified a non-standard port for \'etcd\', don\'t forget to change macros: \'{$ETCD.SCHEME}\' and \'{$ETCD.PORT}\'.\r\n- You can set \'{$ETCD.USERNAME}\' and \'{$ETCD.PASSWORD}\' macros in the template to use on a host level if necessary.\r\n- To test availability, run : \'zabbix_get -s etcd-host -k etcd.health\'.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b25b8b517a4743c48037bfa10af3dc3c','ETCD BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10325',NULL,'IIS by Zabbix agent','3','-1','2','','','IIS by Zabbix agent','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c7c7e5dc319b4801982e719beb1c5191','IIS BY ZABBIX AGENT','Zabbix','7.4-3',NULL,'0','0',''),
('10326',NULL,'IIS by Zabbix agent active','3','-1','2','','','IIS by Zabbix agent active','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4677be3e07bf4f3285496f2f4230b928','IIS BY ZABBIX AGENT ACTIVE','Zabbix','7.4-3',NULL,'0','0',''),
('10327',NULL,'MSSQL by ODBC','3','-1','2','','','MSSQL by ODBC','0',NULL,'This template is designed for the effortless deployment of MSSQL monitoring by Zabbix via ODBC and doesn\'t require any external scripts.\r\n\r\nSetup:\r\n\r\n1. Create an MSSQL user for monitoring.\r\n\r\n  View Server State and View Any Definition permissions should be granted to the user.\r\n  Grant this user read permissions to the sysjobschedules, sysjobhistory, and sysjobs tables.\r\n\r\n  For more information, see MSSQL documentation:\r\n  \r\n  - Create a database user: https://docs.microsoft.com/en-us/sql/relational-databases/security/authentication-access/create-a-database-user?view=sql-server-ver16\r\n  \r\n  - GRANT Server Permissions: https://docs.microsoft.com/en-us/sql/t-sql/statements/grant-server-permissions-transact-sql?view=sql-server-ver16\r\n  \r\n  - Configure a User to Create and Manage SQL Server Agent Jobs: https://docs.microsoft.com/en-us/sql/ssms/agent/configure-a-user-to-create-and-manage-sql-server-agent-jobs?view=sql-server-ver16\r\n\r\n2. Set the user name and password in the host macros ({$MSSQL.USER} and {$MSSQL.PASSWORD}).\r\n\r\n3. Do not forget to install Microsoft ODBC driver on Zabbix server or Zabbix proxy and specify data source name in macro {$MSSQL.DSN}.\r\n  \r\n  See Microsoft documentation for instructions: https://docs.microsoft.com/en-us/sql/connect/odbc/linux-mac/installing-the-microsoft-odbc-driver-for-sql-server?view=sql-server-ver16.\r\n\r\n  Note! Credentials in the odbc.ini do not work for MSSQL.\r\n\r\nThe "Service\'s TCP port state" item uses the {$MSSQL.HOST} and {$MSSQL.PORT} macros to check the availability of the MSSQL instance, change these if necessary. Keep in mind that if dynamic ports are used on the MSSQL server side, this check will not work correctly.\r\n\r\nIf your instance uses a non-default TCP port, set the port in your section of odbc.ini in the line Server = IP or FQDN name, port.\r\n\r\nNote: You can use the context macros {$MSSQL.BACKUP_FULL.USED}, {$MSSQL.BACKUP_LOG.USED}, and {$MSSQL.BACKUP_DIFF.USED} to disable backup age triggers for a certain database. If set to a value other than "1", the trigger expression for the backup age will not fire.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','001a1677f6a949b6bddfdb2926023300','MSSQL BY ODBC','Zabbix','7.4-3',NULL,'0','1','## Setup\r\n\r\n1. Create an MSSQL user for monitoring. For example, "zbx_monitor".\r\n\r\n**View Server State** and **View Any Definition** permissions should be granted to the user.\r\nGrant this user read permissions to the `sysjobschedules`, `sysjobhistory`, and `sysjobs` tables.\r\n\r\nFor example, using T-SQL commands:\r\n\r\n```sql\r\nGRANT SELECT ON OBJECT::msdb.dbo.sysjobs TO zbx_monitor;\r\nGRANT SELECT ON OBJECT::msdb.dbo.sysjobservers TO zbx_monitor;\r\nGRANT SELECT ON OBJECT::msdb.dbo.sysjobactivity TO zbx_monitor;\r\nGRANT EXECUTE ON OBJECT::msdb.dbo.agent_datetime TO zbx_monitor;\r\n```\r\n\r\nFor more information, see MSSQL documentation:\r\n\r\n[Create a database user](https://docs.microsoft.com/en-us/sql/relational-databases/security/authentication-access/create-a-database-user?view=sql-server-ver16)\r\n\r\n[GRANT Server Permissions](https://docs.microsoft.com/en-us/sql/t-sql/statements/grant-server-permissions-transact-sql?view=sql-server-ver16)\r\n\r\n[Configure a User to Create and Manage SQL Server Agent Jobs](https://docs.microsoft.com/en-us/sql/ssms/agent/configure-a-user-to-create-and-manage-sql-server-agent-jobs?view=sql-server-ver16)\r\n\r\n2. Set the username and password in the `MSSQL user` and `MSSQL password` host wizard configuration fields.\r\n\r\n3. Do not forget to install Microsoft ODBC driver on Zabbix server or Zabbix proxy and specify data source name in the `MSSQL DSN` host wizard configuration field.\r\n\r\nSee Microsoft documentation for instructions: https://docs.microsoft.com/en-us/sql/connect/odbc/linux-mac/installing-the-microsoft-odbc-driver-for-sql-server?view=sql-server-ver16.\r\n\r\n**Note! Credentials in the `odbc.ini` do not work for MSSQL.**\r\n\r\nThe `Service\'s TCP port state` item uses the `MSSQL address` and `MSSQL TCP port` host wizard configuration fields to check the availability of the MSSQL instance, change these if necessary. Keep in mind that if dynamic ports are used on the MSSQL server side, this check will not work correctly.\r\n\r\nIf your instance uses a non-default TCP port, set the port in your section of `odbc.ini` in the line Server = IP or FQDN name, port.\r\n\r\nNote: You can use the `Monitoring of full backup`, `Monitoring of log backup`, and `Monitoring of differential backup` host wizard configuration fields to disable backup age triggers. If set to unselected state, the trigger expression for the backup age will not fire.'),
('10328',NULL,'Oracle by ODBC','3','-1','2','','','Oracle by ODBC','0',NULL,'1. Create an Oracle user for monitoring.\r\n\r\n2. Set the hostname or IP address of the Oracle DB instance, user name and password in host macros ({$ORACLE.HOST}, {$ORACLE.USER} and {$ORACLE.PASSWORD}).\r\n  Do not forget to install the Microsoft ODBC driver on the Zabbix server or the Zabbix proxy.\r\n  See Oracle documentation for instructions: https://www.oracle.com/database/technologies/releasenote-odbc-ic.html.\r\n\r\n  Note! Credentials in the odbc.ini do not work for Oracle.\r\n  Note! Be sure that ODBC connects to Oracle with session parameter NLS_NUMERIC_CHARACTERS= \'.,\' It is important for correct display float numbers in Zabbix.\r\nThe "Service\'s TCP port state" item uses {$ORACLE.HOST} and {$ORACLE.PORT} macros to check the availability of the listener.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','00ade9277d7c41e8b57d638b22d54372','ORACLE BY ODBC','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThe template is developed to monitor a single DBMS Oracle Database instance with ODBC and can monitor CDB or non-CDB installations.\r\n\r\n## Supported versions\r\n\r\nOracle Database 12c2 and newer.\r\n\r\n**Important! This integration queries the `V$ACTIVE_SESSION_HISTORY` dynamic performance view which is part of the Oracle Diagnostics Pack. Please make sure that you have the licence required for using this management pack.**\r\n\r\n## Setup\r\n\r\n1. Create an Oracle Database user for monitoring:\r\n\r\n    In CDB installations, it is possible to monitor tablespaces from the CDB (container database) and all PDBs (pluggable databases). To do so, a common user is needed with the correct rights:\r\n\r\n    ```\r\n    CREATE USER c##zabbix_mon IDENTIFIED BY <PASSWORD>;\r\n    -- Grant access to the c##zabbix_mon user.\r\n    ALTER USER c##zabbix_mon SET CONTAINER_DATA=ALL CONTAINER=CURRENT;\r\n    GRANT CONNECT, CREATE SESSION TO c##zabbix_mon;\r\n    GRANT SELECT_CATALOG_ROLE to c##zabbix_mon;\r\n    GRANT SELECT ON v_$instance TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$database TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$sysmetric TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$system_parameter TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$session TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$recovery_file_dest TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$active_session_history TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$osstat TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$process TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$datafile TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$pgastat TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$sgastat TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$log TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$archive_dest TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$asm_diskgroup TO c##zabbix_mon;\r\n    GRANT SELECT ON v_$asm_diskgroup_stat TO c##zabbix_mon;\r\n    GRANT SELECT ON DBA_USERS TO c##zabbix_mon;\r\n    ```\r\n    This is needed because the template uses `CDB_*` views to monitor tablespaces from the CDB and different PDBs - the monitoring user therefore needs access to the container data objects on all PDBs.\r\n\r\n    However, if you wish to monitor only a single PDB or a non-CDB instance, a local user is sufficient:\r\n    \r\n    ```\r\n    CREATE USER zabbix_mon IDENTIFIED BY <PASSWORD>;\r\n    -- Grant access to the zabbix_mon user.\r\n    GRANT CONNECT, CREATE SESSION TO zabbix_mon;\r\n    GRANT SELECT_CATALOG_ROLE to zabbix_mon;\r\n    GRANT SELECT ON v_$instance TO zabbix_mon;\r\n    GRANT SELECT ON v_$database TO zabbix_mon;\r\n    GRANT SELECT ON v_$sysmetric TO zabbix_mon;\r\n    GRANT SELECT ON v_$system_parameter TO zabbix_mon;\r\n    GRANT SELECT ON v_$session TO zabbix_mon;\r\n    GRANT SELECT ON v_$recovery_file_dest TO zabbix_mon;\r\n    GRANT SELECT ON v_$active_session_history TO zabbix_mon;\r\n    GRANT SELECT ON v_$osstat TO zabbix_mon;\r\n    GRANT SELECT ON v_$process TO zabbix_mon;\r\n    GRANT SELECT ON v_$datafile TO zabbix_mon;\r\n    GRANT SELECT ON v_$pgastat TO zabbix_mon;\r\n    GRANT SELECT ON v_$sgastat TO zabbix_mon;\r\n    GRANT SELECT ON v_$log TO zabbix_mon;\r\n    GRANT SELECT ON v_$archive_dest TO zabbix_mon;\r\n    GRANT SELECT ON v_$asm_diskgroup TO zabbix_mon;\r\n    GRANT SELECT ON v_$asm_diskgroup_stat TO zabbix_mon;\r\n    GRANT SELECT ON DBA_USERS TO zabbix_mon;\r\n    ```\r\n    **Important! Ensure that the ODBC connection to Oracle includes the session parameter `NLS_NUMERIC_CHARACTERS= \'.,\'`. It is important for displaying the float numbers in Zabbix correctly.**\r\n\r\n    **Important! These privileges grant the monitoring user `SELECT_CATALOG_ROLE`, which, in turn, gives access to thousands of tables in the database.**\r\n    This role is required to access the `V$RESTORE_POINT` dynamic performance view.\r\n    However, there are ways to go around this, if the `SELECT_CATALOG_ROLE` assigned to a monitoring user raises any security issues.\r\n    One way to do this is using **pipelined table functions**:\r\n\r\n      1. Log into your database as the `SYS` user or make sure that your administration user has the required privileges to execute the steps below;\r\n\r\n      2. Create types for the table function:\r\n\r\n          ```sql\r\n          CREATE OR REPLACE TYPE zbx_mon_restore_point_row AS OBJECT (\r\n            SCN                           NUMBER,\r\n            DATABASE_INCARNATION#         NUMBER,\r\n            GUARANTEE_FLASHBACK_DATABASE  VARCHAR2(3),\r\n            STORAGE_SIZE                  NUMBER,\r\n            TIME                          TIMESTAMP(9),\r\n            RESTORE_POINT_TIME            TIMESTAMP(9),\r\n            PRESERVED                     VARCHAR2(3),\r\n            NAME                          VARCHAR2(128),\r\n            PDB_RESTORE_POINT             VARCHAR2(3),\r\n            CLEAN_PDB_RESTORE_POINT       VARCHAR2(3),\r\n            PDB_INCARNATION#              NUMBER,\r\n            REPLICATED                    VARCHAR2(3),\r\n            CON_ID                        NUMBER\r\n          );\r\n          CREATE OR REPLACE TYPE zbx_mon_restore_point_tab IS TABLE OF zbx_mon_restore_point_row;\r\n          ```\r\n\r\n      3. Create the pipelined table function:\r\n\r\n          ```sql\r\n          CREATE OR REPLACE FUNCTION zbx_mon_restore_point RETURN zbx_mon_restore_point_tab PIPELINED AS\r\n          BEGIN\r\n            FOR i IN (SELECT * FROM V$RESTORE_POINT) LOOP\r\n              PIPE ROW (zbx_mon_restore_point_row(i.SCN, i.DATABASE_INCARNATION#, i.GUARANTEE_FLASHBACK_DATABASE, i.STORAGE_SIZE, i.TIME, i.RESTORE_POINT_TIME, i.PRESERVED, i.NAME, i.PDB_RESTORE_POINT, i.CLEAN_PDB_RESTORE_POINT, i.PDB_INCARNATION#, i.REPLICATED, i.CON_ID));\r\n            END LOOP;\r\n            RETURN;\r\n          END;\r\n          ```\r\n\r\n      4. Grant the Zabbix monitoring user the Execute privilege on the created pipelined table function and replace the monitoring user `V$RESTORE_POINT` view with the `SYS` user function (in this example, the `SYS` user is used to create DB types and function):\r\n\r\n          ```sql\r\n          GRANT EXECUTE ON zbx_mon_restore_point TO c##zabbix_mon;\r\n          CREATE OR REPLACE VIEW c##zabbix_mon.V$RESTORE_POINT AS SELECT * FROM TABLE(SYS.zbx_mon_restore_point);\r\n          ```\r\n\r\n      5. Finally, revoke the `SELECT_CATALOG_ROLE` and grant additional permissions that were previously covered by the `SELECT_CATALOG_ROLE`.\r\n\r\n          ```sql\r\n          REVOKE SELECT_CATALOG_ROLE FROM c##zabbix_mon;\r\n          GRANT SELECT ON v_$pdbs TO c##zabbix_mon;\r\n          GRANT SELECT ON v_$sort_segment TO c##zabbix_mon;\r\n          GRANT SELECT ON v_$parameter TO c##zabbix_mon;\r\n          GRANT SELECT ON CDB_TABLESPACES TO c##zabbix_mon;\r\n          GRANT SELECT ON CDB_DATA_FILES TO c##zabbix_mon;\r\n          GRANT SELECT ON CDB_FREE_SPACE TO c##zabbix_mon;\r\n          GRANT SELECT ON CDB_TEMP_FILES TO c##zabbix_mon;\r\n          ```\r\n\r\n      > Note that in these examples, the monitoring user is named `c##zabbix_mon` and the system user - `SYS`. Change these example usernames to ones that are appropriate for your environment.\r\n    \r\n    If this workaround does not work for you, there are more options available, such as __materialized views__, but look out for data refresh as `V$RESTORE_POINT` is a dynamic performance view.\r\n\r\n2. Install the ODBC driver on Zabbix server or Zabbix proxy.\r\n  See the [Oracle documentation](https://www.oracle.com/database/technologies/releasenote-odbc-ic.html) for instructions.\r\n\r\n3. Configure Zabbix server or Zabbix proxy for using the Oracle environment:\r\n\r\n    This step is required only when:\r\n    \r\n    * installing Oracle Instant Client with .rpm packages with a version < 19.3 (if Instant Client is the only Oracle software installed on Zabbix server or Zabbix proxy);\r\n    \r\n    * installing Oracle Instant Client manually with .zip files.\r\n  \r\n    There are multiple configuration options:\r\n    \r\n      1. Using the `LDCONFIG` utility **(recommended option)**:\r\n  \r\n          To update the runtime link path, it is recommended to use the ```LDCONFIG``` utility, for example:\r\n    \r\n          ```\r\n          # sh -c "echo /opt/oracle/instantclient_19_18 > /etc/ld.so.conf.d/oracle-instantclient.conf"\r\n          # ldconfig\r\n          ```\r\n  \r\n      2. Using the application configuration file:\r\n  \r\n          An alternative solution is to export the required variables by editing or adding a new application configuration file:\r\n    \r\n           * ```/etc/sysconfig/zabbix-server # for server```\r\n    \r\n           * ```/etc/sysconfig/zabbix-proxy # for proxy```\r\n    \r\n          And then, adding:\r\n        \r\n          ```\r\n          # Oracle Instant Client library\r\n          LD_LIBRARY_PATH=/opt/oracle/instantclient_19_18:$LD_LIBRARY_PATH\r\n          export LD_LIBRARY_PATH\r\n          ```\r\n    \r\n    Keep in mind that the library paths will vary depending on your installation.\r\n\r\n    This is a minimal configuration example. Depending on the Oracle Instant Client version, required functionality and host operating system, a different set of additional packages might need to be installed.\r\n    For more detailed configuration instructions, see the [official Oracle Instant Client installation instructions for Linux](https://www.oracle.com/database/technologies/instant-client/linux-x86-64-downloads.html).\r\n\r\n4. Restart Zabbix server or Zabbix proxy.\r\n\r\n5. Set the username and password in host wizard configuration fields `Username` and `Password`.\r\n\r\n6. Set the `Oracle URL`, `Oracle driver path` and `Oracle Service Name` in host wizard configuration fields.\r\n\r\n    * `Oracle URL` is a hostname or IP address of the Oracle DB instance.\r\n\r\n    * `Oracle driver path` is a path to the driver location in the OS. The ODBC driver file should be found in the Instant Client directory and named `libsqora.so.XX.Y`.\r\n\r\n    * `Oracle Service Name` is a service name to which the host will connect to. It is important as it determines if the connection is established to a non-CDB, CDB, or PDB. If you wish to monitor tablespaces of all PDBs, you will need to set a service name that points to the CDB.\r\n      Active service names can be seen from the instance running Oracle Database with `lsnrctl status`.\r\n      \r\n    **Important! Make sure that the user created in step #1 is present on the specified service.**\r\n\r\n    The "Service\'s TCP port state" item uses `{$ORACLE.HOST}` and `{$ORACLE.PORT}` macros to check the availability of the listener.'),
('10329',NULL,'PostgreSQL by Zabbix agent 2','3','-1','2','','','PostgreSQL by Zabbix agent 2','0',NULL,'This template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent 2 and uses a loadable plugin to run SQL queries.\r\n\r\nSetup:\r\n\r\n1. Deploy Zabbix agent 2 with the PostgreSQL plugin. Starting with Zabbix versions 6.0.10 / 6.2.4 / 6.4 PostgreSQL metrics are moved to a loadable plugin and require installation of a separate package or compilation of the plugin from sources (https://www.zabbix.com/documentation/7.4/manual/extensions/plugins/build).\r\n\r\n2. Create the PostgreSQL user for monitoring (`<password>` at your discretion) and inherit permissions from the default role `pg_monitor`:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n\r\n3. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. You can check the PostgreSQL documentation for examples (https://www.postgresql.org/docs/current/auth-pg-hba-conf.html).\r\n\r\n4. Set the connection string for the PostgreSQL instance in the `{$PG.CONNSTRING.AGENT2}` macro as URI, such as `<protocol(host:port)>`, or specify the named session - `<sessionname>`.\r\n\r\nNote: if you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, a named session must be used. In that case, the instance URI should be specified in the `Plugins.PostgreSQL.Sessions.*.Uri` parameter in the PostgreSQL plugin configuration files alongside all the encryption parameters (type, certificate/key filepaths if needed etc.).\r\n\r\nYou can check the PostgreSQL plugin documentation (https://git.zabbix.com/projects/AP/repos/postgresql/browse?at=refs%2Fheads%2Frelease%2F7.4) for details about agent plugin parameters and named sessions.\r\n\r\nAlso, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the PostgreSQL documentation (https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\nNote that plugin TLS certificate validation relies on checking the Subject Alternative Names (SAN) instead of the Common Name (CN), check the cryptography package documentation (https://pkg.go.dev/crypto/x509) for details.\r\n\r\nFor example, to enable required encryption in transport mode without identity checks you could create the file `/etc/zabbix/zabbix_agent2.d/postgresql_myconn.conf` with the following configuration for the named session `myconn` (replace `<instanceip>` with the address of the PostgreSQL instance):\r\nPlugins.PostgreSQL.Sessions.myconn.Uri=tcp://<instanceip>:5432\r\nPlugins.PostgreSQL.Sessions.myconn.TLSConnect=required\r\n\r\nThen set the `{$PG.CONNSTRING.AGENT2}` macro to `myconn` to use this named session.\r\n\r\n5. Set the password that you specified in step 2 in the macro `{$PG.PASSWORD}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d0ef7d659a8f4beaaabfc4b6134e737a','POSTGRESQL BY ZABBIX AGENT 2','Zabbix','7.4-3',NULL,'0','1','## Overview\r\n\r\nThis template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent 2 and uses a loadable plugin to run SQL queries.\r\n\r\n## Setup\r\n\r\n1. Create the PostgreSQL user for monitoring (`<password>` at your discretion) and inherit permissions from the default role `pg_monitor`:\r\n\r\n```sql\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n```\r\n\r\n3. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. For example, you could add one of the following rows to allow local TCP connections from the same host:\r\n\r\n```bash\r\n# TYPE  DATABASE        USER            ADDRESS                 METHOD\r\n  host       all        zbx_monitor     localhost               trust\r\n  host       all        zbx_monitor     127.0.0.1/32            md5\r\n  host       all        zbx_monitor     ::1/128                 scram-sha-256\r\n```\r\n\r\nFor more information please read the PostgreSQL documentation `https://www.postgresql.org/docs/current/auth-pg-hba-conf.html`.\r\n\r\n4. Set the connection string for the PostgreSQL instance in the `PostgreSQL connection string` host wizard configuration field as URI, such as `<protocol(host:port)>`, or specify the named session - `<sessionname>`.\r\n\r\n**Note:** if you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, a named session must be used. In that case, the instance URI should be specified in the `Plugins.PostgreSQL.Sessions.*.Uri` parameter in the PostgreSQL plugin configuration files alongside all the encryption parameters (type, certificate/key filepaths if needed etc.).\r\n\r\nYou can check the [`PostgreSQL plugin documentation`](https://git.zabbix.com/projects/AP/repos/postgresql/browse?at=refs%2Fheads%2Frelease%2F7.4) for details about agent plugin parameters and named sessions.\r\n\r\nAlso, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the [`PostgreSQL documentation`](https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\n**Note:** plugin TLS certificate validation relies on checking the Subject Alternative Names (SAN) instead of the Common Name (CN), check the cryptography package [`documentation`](https://pkg.go.dev/crypto/x509) for details.\r\n\r\nFor example, to enable required encryption in transport mode without identity checks you could create the file `/etc/zabbix/zabbix_agent2.d/postgresql_myconn.conf` with the following configuration for the named session `myconn` (replace `<instanceip>` with the address of the PostgreSQL instance):\r\n\r\n```bash\r\nPlugins.PostgreSQL.Sessions.myconn.Uri=tcp://<instanceip>:5432\r\nPlugins.PostgreSQL.Sessions.myconn.TLSConnect=required\r\n```\r\n\r\nThen set the `PostgreSQL connection string` field to `myconn` to use this named session.\r\n\r\n5. Set the password that you specified in step 2 in the `PostgreSQL user password` field.'),
('10330',NULL,'PHP-FPM by Zabbix agent','3','-1','2','','','PHP-FPM by Zabbix agent','0',NULL,'Get PHP-FPM metrics using Zabbix agent running on Linux.\r\n\r\nNote that depending on your OS distribution, the PHP-FPM process name may vary. Please, check the actual name in the line "Name" from /proc/<pid>/status file (https://www.zabbix.com/documentation/7.4/manual/appendix/items/proc_mem_num_notes) and change {$PHP_FPM.PROCESS.NAME.PARAMETER} macro if needed.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1cbda0970410435684135884d0cb7090','PHP-FPM BY ZABBIX AGENT','Zabbix','7.4-1',NULL,'0','0',''),
('10331',NULL,'PHP-FPM by HTTP','3','-1','2','','','PHP-FPM by HTTP','0',NULL,'Get PHP-FPM metrics using the Zabbix HTTP agent.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','49c77ce207f8478da53e761526d6eca5','PHP-FPM BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10335',NULL,'Oracle by Zabbix agent 2','3','-1','2','','','Oracle by Zabbix agent 2','0',NULL,'Get metrics from Oracle Database using Zabbix agent 2.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d670c32f007d438c9dcd32db57d2b691','ORACLE BY ZABBIX AGENT 2','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThe template is developed to monitor a single DBMS Oracle Database instance with Zabbix agent 2.\r\n\r\n## Supported versions\r\n\r\nOracle Database 12c2 and newer.\r\n\r\n**Important! This integration queries the `V$ACTIVE_SESSION_HISTORY` dynamic performance view which is part of the Oracle Diagnostics Pack. Please make sure that you have the licence required for using this management pack.**\r\n\r\n## Setup\r\n\r\n1. Set the \'URI or session name\' value using either <protocol(host:port)> or named session.\r\n2. If you want to override parameters from Zabbix agent configuration file, set the user name, password and service name in host wizard configuration fields(Username, Password, and Service Name).\r\n\r\n   User can contain sysdba, sysoper, sysasm privileges. It must be used with `as` as a separator e.g `user as sysdba`, privilege can be upper or lowercase, and must be at the end of username string.\r\n\r\nTest availability:\r\n ```zabbix_get -s oracle-host -k  oracle.ping["{$ORACLE.CONNSTRING}","{$ORACLE.USER}","{$ORACLE.PASSWORD}","{$ORACLE.SERVICE}"]```'),
('10336',NULL,'Asterisk by HTTP','3','-1','2','','','Asterisk by HTTP','0',NULL,'The template gets Asterisk metrics from AMI by HTTP agent.\r\nYou should enable the mini-HTTP Server, add the option webenabled=yes in the general section of the manager.conf file and create Asterisk Manager user with system and command write permissions within your Asterisk instance.\r\nDisable the PJSIP driver if you do not use PJSIP or do not have PJSIP endpoints.\r\nPlease, define AMI address in the {$AMI.URL} macro. Also, set the hostname or IP address of the AMI host in the {$AMI.HOST} macro for Zabbix to check Asterisk service status.\r\nThen you can define {$AMI.USERNAME} and {$AMI.SECRET} macros in the template for using on the host level.\r\nIf there are errors, increase the logging to debug level and see the Zabbix server log.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410060-discussion-thread-for-official-zabbix-template-asterisk\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','30cc187a4e994c39b07f53d86b5cc6bc','ASTERISK BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10343',NULL,'Linux by Zabbix agent active','3','-1','2','','','Linux by Zabbix agent active','0',NULL,'This is an official Linux template. It requires Zabbix agent 7.4 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e2307c94f1744af7a8f1f458a67af424','LINUX BY ZABBIX AGENT ACTIVE','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis is an official Linux template. It requires Zabbix agent 7.4 or newer.\r\n\r\n#### Notes on filesystem (FS) discovery:\r\n- The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n- BTRFS allocates a default of 10% of the volume for its own needs.\r\n- To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n  - Utilization formula: `pused = 100 - 100 * (available / total - free + available)`\r\n- The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.'),
('10351',NULL,'Windows by Zabbix agent active','3','-1','2','','','Windows by Zabbix agent active','0',NULL,'This is an official Windows template. It requires Zabbix agent 7.4 or newer.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5fdd2ca8b8f84962aaea5a218b46ea7d','WINDOWS BY ZABBIX AGENT ACTIVE','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis is an official Windows template. It requires Zabbix agent 7.4 or newer.'),
('10353',NULL,'Ceph by Zabbix agent 2','3','-1','2','','','Ceph by Zabbix agent 2','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410059-discussion-thread-for-official-zabbix-template-ceph\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','09fb25d089f7467f860895f6e71d3fa2','CEPH BY ZABBIX AGENT 2','Zabbix','7.4-2',NULL,'0','0',''),
('10355',NULL,'Squid by SNMP','3','-1','2','','','Squid by SNMP','0',NULL,'Template for monitoring Squid caching proxy via SNMP\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/409339-discussion-thread-for-official-zabbix-template-squid\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8e5236f799b347a8ae90a979198be85e','SQUID BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10357',NULL,'PostgreSQL by Zabbix agent','3','-1','2','','','PostgreSQL by Zabbix agent','0',NULL,'This template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent and uses user parameters to run SQL queries with the `psql` command-line tool.\r\n\r\nNote:\r\n- The template requires `pg_isready` and `psql` utilities to be installed on the same host with Zabbix agent.\r\n- The template requires files with SQL queries and user parameters that can be found in the Zabbix official repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/db/postgresql?at=refs%2Fheads%2Frelease%2F6.0\r\n\r\nSetup:\r\n\r\n1. Deploy Zabbix agent and create the PostgreSQL user for monitoring (`<password>` at your discretion) with proper access rights to your PostgreSQL instance.\r\n\r\nFor PostgreSQL version 10 and above:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n\r\nFor PostgreSQL version 9.6 and below:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\';\r\nGRANT SELECT ON pg_stat_database TO zbx_monitor;\r\nALTER USER zbx_monitor WITH SUPERUSER;\r\n\r\n2. Copy the `postgresql/` directory to the `zabbix` user home directory - `/var/lib/zabbix/`. The `postgresql/` directory contains the files with SQL queries needed to obtain metrics from PostgreSQL instance.\r\n\r\nIf the home directory of the `zabbix` user doesn\'t exist, create it first:\r\nmkdir -m u=rwx,g=rwx,o= -p /var/lib/zabbix\r\nchown zabbix:zabbix /var/lib/zabbix\r\n\r\n3. Copy the `template_db_postgresql.conf` file, containing user parameters, to the Zabbix agent configuration directory `/etc/zabbix/zabbix_agentd.d/` and restart Zabbix agent service.\r\n\r\nIf you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, you can modify the connection string in user parameters. For example, to enable required encryption in transport mode without identity checks you could append `?sslmode=required` to the end of the connection string for all keys that use `psql`:\r\nUserParameter=pgsql.bgwriter[*], psql -qtAX postgresql://"$3":"$4"@"$1":"$2"/"$5"?sslmode=required -f "/var/lib/zabbix/postgresql/pgsql.bgwriter.sql"\r\n\r\nConsult the PostgreSQL documentation about protection modes (https://www.postgresql.org/docs/current/libpq-ssl.html#LIBPQ-SSL-PROTECTION) and client connection parameters (https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNECT-SSLMODE).\r\n\r\nAlso, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the PostgreSQL documentation (https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\n4. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. You can check the PostgreSQL documentation for examples (https://www.postgresql.org/docs/current/auth-pg-hba-conf.html).\r\n\r\n5. Specify the host name or IP address in the `{$PG.HOST}` macro. Adjust the port number with `{$PG.PORT}` macro if needed.\r\n\r\n6. Set the password that you specified in step 1 in the macro `{$PG.PASSWORD}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','399bd1ee587245ecac6f39beaa99886f','POSTGRESQL BY ZABBIX AGENT','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent and uses user parameters to run SQL queries with the `psql` command-line tool.\r\n\r\n## Setup\r\n\r\n**Note:**\r\n- The template requires `pg_isready` and `psql` utilities to be installed on the same host with Zabbix agent.\r\n\r\n1. Create the PostgreSQL user for monitoring (`<password>` at your discretion) with proper access rights to your PostgreSQL instance.\r\n\r\nFor PostgreSQL version 10 and above:\r\n\r\n```sql\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n```\r\n\r\nFor PostgreSQL version 9.6 and below:\r\n\r\n```sql\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\';\r\nGRANT SELECT ON pg_stat_database TO zbx_monitor;\r\n\r\n-- To collect WAL metrics, the user must have a `superuser` role.\r\nALTER USER zbx_monitor WITH SUPERUSER;\r\n```\r\n\r\n2. Copy the `postgresql/` directory to the `zabbix` user home directory - `/var/lib/zabbix/`. The `postgresql/` directory contains the files with SQL queries needed to obtain metrics from PostgreSQL instance.\r\n\r\nIf the home directory of the `zabbix` user doesn\'t exist, create it first:\r\n\r\n```bash\r\nmkdir -m u=rwx,g=rwx,o= -p /var/lib/zabbix\r\nchown zabbix:zabbix /var/lib/zabbix\r\n```\r\n\r\n3. Copy the `template_db_postgresql.conf` file, containing user parameters, to the Zabbix agent configuration directory `/etc/zabbix/zabbix_agentd.d/` and restart Zabbix agent service.\r\n\r\n**Note:** if you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, you can modify the connection string in user parameters. For example, to enable required encryption in transport mode without identity checks you could append `?sslmode=required` to the end of the connection string for all keys that use `psql`:\r\n\r\n```bash\r\nUserParameter=pgsql.bgwriter[*], psql -qtAX postgresql://"$3":"$4"@"$1":"$2"/"$5"?sslmode=required -f "/var/lib/zabbix/postgresql/pgsql.bgwriter.sql"\r\n```\r\n\r\nConsult the PostgreSQL documentation about [`protection modes`](https://www.postgresql.org/docs/current/libpq-ssl.html#LIBPQ-SSL-PROTECTION) and [`client connection parameters`](https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNECT-SSLMODE).\r\n\r\nAlso, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the [`PostgreSQL documentation`](https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\n4. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. For example, you could add one of the following rows to allow local TCP connections from the same host:\r\n\r\n```bash\r\n# TYPE  DATABASE        USER            ADDRESS                 METHOD\r\n  host       all        zbx_monitor     localhost               trust\r\n  host       all        zbx_monitor     127.0.0.1/32            md5\r\n  host       all        zbx_monitor     ::1/128                 scram-sha-256\r\n```\r\n\r\nFor more information please read the PostgreSQL documentation `https://www.postgresql.org/docs/current/auth-pg-hba-conf.html`.\r\n\r\n5. Specify the host name or IP address in the `PostgreSQL host` host wizard configuration field. Adjust the port number in the `PostgreSQL port` field if needed.\r\n\r\n6. Set the password that you specified in step 1 in the `PostgreSQL user password` field.'),
('10358',NULL,'Apache ActiveMQ by JMX','3','-1','2','','','Apache ActiveMQ by JMX','0',NULL,'The template to monitor Apache ActiveMQ by Zabbix that work without any external scripts.\r\nThe metrics are collected by JMX.\r\nYou can set macro values and add macros with context for specific brokers or destinations following macro description.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411049-discussion-thread-for-official-zabbix-template-amq\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c87e0a2e0683483ab7c6f3c380e9f840','APACHE ACTIVEMQ BY JMX','Zabbix','7.4-1',NULL,'0','0',''),
('10359',NULL,'Aranet Cloud','3','-1','2','','','Aranet Cloud','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','af21edc47557400583e537904ea632aa','ARANET CLOUD','Zabbix','7.4-1',NULL,'0','0',''),
('10360',NULL,'Microsoft Exchange Server 2016 by Zabbix agent','3','-1','2','','','Microsoft Exchange Server 2016 by Zabbix agent','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.\r\nThe metrics are collected by Zabbix agent.\r\nRecommended to use it with "OS Windows by Zabbix agent" template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cbf70ed444394566bcf213dd63d4d352','MICROSOFT EXCHANGE SERVER 2016 BY ZABBIX AGENT','Zabbix','7.4-1',NULL,'0','0',''),
('10361',NULL,'Microsoft Exchange Server 2016 by Zabbix agent active','3','-1','2','','','Microsoft Exchange Server 2016 by Zabbix agent active','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.\r\nThe metrics are collected by Zabbix agent active.\r\nRecommended to use it with "OS Windows by Zabbix agent active" template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a0e05ca631034676821b7e0e1ce25488','MICROSOFT EXCHANGE SERVER 2016 BY ZABBIX AGENT ACTIVE','Zabbix','7.4-1',NULL,'0','0',''),
('10362',NULL,'GitLab by HTTP','3','-1','2','','','GitLab by HTTP','0',NULL,'Get GitLab metrics by HTTP agent from Prometheus metrics endpoint.\r\n\r\nTo access the metrics, the client IP address must be explicitly allowed. See https://docs.gitlab.com/ee/administration/monitoring/ip_whitelist.html.\r\nOr second method, using token variable from http://your.gitlab.address/admin/health_check (fill {$GITLAB.HEALTH.TOKEN} macro with variable path like "?token=your_token").\r\nDon\'t forget change macros {$GITLAB.URL}.\r\nSome metrics may not be collected depending on your Gitlab instance version and configuration. See (Gitlab\'s documentation[)https://docs.gitlab.com/ee/administration/monitoring/prometheus/gitlab_metrics.html] for further information about its metric collection.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f445dac89ff74deabaae9dcb84815998','GITLAB BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10363',NULL,'Hadoop by HTTP','3','-1','2','','','Hadoop by HTTP','0',NULL,'The template gets the Hadoop metrics from cluster\'s hosts (ResourceManager, NodeManagers, NameNode, DataNodes) by HTTP agent. You should define the IP address (or FQDN) and Web-UI port for the ResourceManager in {$HADOOP.RESOURCEMANAGER.HOST} and {$HADOOP.RESOURCEMANAGER.PORT} macros and for the NameNode in {$HADOOP.NAMENODE.HOST} and {$HADOOP.NAMENODE.PORT} macros respectively. Macros can be set in the template or overridden at the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/413459-discussion-thread-for-official-zabbix-template-hadoop\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e129aeba7c814bf189772cf5919b4bbb','HADOOP BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10364',NULL,'Apache Kafka by JMX','3','-1','2','','','Apache Kafka by JMX','0',NULL,'Official JMX Template for Apache Kafka.\r\n  The metrics are collected by JMX.\r\n  You can set {$KAFKA.USER} and {$KAFKA.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2eb43a3c9666467683b9ce09d2bd26d7','APACHE KAFKA BY JMX','Zabbix','7.4-1',NULL,'0','0',''),
('10365',NULL,'HashiCorp Vault by HTTP','3','-1','2','','','HashiCorp Vault by HTTP','0',NULL,'Get HashiCorp Vault metrics from Vault API HTTP Prometheus metrics endpoint.\r\n\r\nSome metrics may not be collected depending on your Vault instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2f82248e411340429d390e8389850401','HASHICORP VAULT BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10366',NULL,'VMware FQDN','3','-1','2','','','VMware FQDN','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nNote: To enable discovery of hardware sensors of VMware Hypervisors, set the macro \'{$VMWARE.HV.SENSOR.DISCOVERY}\' to the value \'true\' on the discovered host level.\r\n\r\nNote: To create custom performance counter see documentation: https://www.zabbix.com/documentation/7.4/manual/vm_monitoring/vmware_keys#footnotes\r\n\r\nNote: To get all supported counters and generate path for custom performance counter see documentation: https://www.zabbix.com/documentation/7.4/manual/appendix/items/perf_counters\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ca02e82e6c414d0aa7aedc8d78468a49','VMWARE FQDN','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis template set is designed for the effortless deployment of VMware vCenter and ESX hypervisor monitoring and doesn\'t require any external scripts.\r\n\r\n- The template "VMware Guest" is used in discovery and normally should not be manually linked to a host.\r\n- The template "VMware Hypervisor" can be used in discovery as well as manually linked to a host.\r\n\r\nFor additional information, please see [Zabbix documentation on VM monitoring](https://www.zabbix.com/documentation/7.4/manual/vm_monitoring).\r\n\r\n## Setup\r\n\r\n1. Compile Zabbix server with the required options (`--with-libxml2` and `--with-libcurl`)\r\n2. Set the `StartVMwareCollectors` option in the Zabbix server configuration file to "1" or more\r\n3. Create a new host\r\n4. If you want to use a separate user for monitoring, make sure that the user is a member of the `SystemConfiguration.ReadOnly` and `vStatsGroup` groups\r\nSet the host wizard configuration fields required for VMware authentication: `VMware URL`, `VMware username` and `VMware password`\r\n5. Link the template to the host created earlier\r\n\r\nNote: To enable discovery of hardware sensors of VMware hypervisors, set the host wizard configuration field `Monitoring of hardware sensors` to the selected state.\r\n\r\nAdditional resources:\r\n- How to [create a custom performance counter](https://www.zabbix.com/documentation/7.4/manual/vm_monitoring/vmware_keys#footnotes)\r\n- How to get all supported counters and [generate a path for the custom performance counter](https://www.zabbix.com/documentation/7.4/manual/appendix/items/perf_counters)'),
('10369',NULL,'Zookeeper by HTTP','3','-1','2','','','Zookeeper by HTTP','0',NULL,'This template is designed for the effortless deployment of Apache Zookeeper monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n\r\nThis template works with standalone and cluster instances. Metrics are collected from each Zookeeper node by requests to AdminServer\r\n\r\nSetup:\r\n\r\n1. Enable the AdminServer and configure the parameters according to the official documentation:\r\nhttps://zookeeper.apache.org/doc/current/zookeeperAdmin.html#sc_adminserver_config\r\n\r\n2. Set the hostname or IP address of the Apache Zookeeper host in the \'{$ZOOKEEPER.HOST}\' macro. You can also change the \'{$ZOOKEEPER.COMMAND_URL}\', \'{$ZOOKEEPER.PORT}\' and \'{$ZOOKEEPER.SCHEME}\' macros if necessary.\r\n\r\nYou can discuss this template or leave feedback on our forum:\r\nhttps://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b606eda347ea4663a33ad4d12a482750','ZOOKEEPER BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10370',NULL,'Apache Cassandra by JMX','3','-1','2','','','Apache Cassandra by JMX','0',NULL,'The template to monitor Apache Cassandra by Zabbix that work without any external scripts.\r\nIt works with both standalone and cluster instances.\r\nThe metrics are collected by JMX.\r\nYou can set {$CASSANDRA.USER} and {$CASSANDRA.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410057-discussion-thread-for-official-zabbix-template-apache-cassandra\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5c42de26643c4b43b23a11159df021ce','APACHE CASSANDRA BY JMX','Zabbix','7.4-0',NULL,'0','0',''),
('10371',NULL,'Morningstar ProStar MPPT by SNMP','3','-1','2','','','Morningstar ProStar MPPT by SNMP','0',NULL,'MIBs used:\r\nPROSTAR-MPPT\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b84324c2a40a496dbbb379bbf5dde8d5','MORNINGSTAR PROSTAR MPPT BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10372',NULL,'Morningstar ProStar PWM by SNMP','3','-1','2','','','Morningstar ProStar PWM by SNMP','0',NULL,'MIBs used:\r\nPROSTAR-PWM\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','24bed6339f0a492fab86fe757394b937','MORNINGSTAR PROSTAR PWM BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10373',NULL,'Morningstar SunSaver MPPT by SNMP','3','-1','2','','','Morningstar SunSaver MPPT by SNMP','0',NULL,'MIBs used:\r\nSUNSAVER-MPPT\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f1336fd88ab0415a9c02892a71e50032','MORNINGSTAR SUNSAVER MPPT BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10374',NULL,'Morningstar SureSine by SNMP','3','-1','2','','','Morningstar SureSine by SNMP','0',NULL,'MIBs used:\r\nSURESINE\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3bbfe42c78c74f04a2565431fbdd19e2','MORNINGSTAR SURESINE BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10375',NULL,'Morningstar TriStar MPPT 600V by SNMP','3','-1','2','','','Morningstar TriStar MPPT 600V by SNMP','0',NULL,'MIBs used:\r\nTRISTAR-MPPT\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2d20a2fbd540492089fdcafc8feb60e3','MORNINGSTAR TRISTAR MPPT 600V BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10376',NULL,'Morningstar TriStar MPPT by SNMP','3','-1','2','','','Morningstar TriStar MPPT by SNMP','0',NULL,'MIBs used:\r\nTRISTAR-MPPT\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','07b32152c3654e8ead4c1eeae24efa8f','MORNINGSTAR TRISTAR MPPT BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10377',NULL,'Morningstar TriStar PWM by SNMP','3','-1','2','','','Morningstar TriStar PWM by SNMP','0',NULL,'MIBs used:\r\nTRISTAR\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','230fa9f7c1774821bbe6cdcbbba5cbc6','MORNINGSTAR TRISTAR PWM BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10378',NULL,'NetApp FAS3220 by SNMP','3','-1','2','','','NetApp FAS3220 by SNMP','0',NULL,'The template to monitor SAN NetApp FAS3220 cluster by Zabbix SNMP agent.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nNETAPP-MIB\r\nIF-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/416694-discussion-thread-for-official-zabbix-template-netapp-fas3220\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e118ab11c1ec4f9cbe21dfce1441c0f6','NETAPP FAS3220 BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10379',NULL,'Jenkins by HTTP','3','-1','2','','','Jenkins by HTTP','0',NULL,'Get Jenkins metrics by HTTP agent.\r\nMetrics are collected by requests to Metrics API. Install  Metrics plugin and configure access to the Metrics Servlet by issuing API key.\r\nDon\'t forget to change macros {$JENKINS.URL}, {$JENKINS.USER}, {$JENKINS.API.TOKEN}, {$JENKINS.API.KEY}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2ef2f2eb75ee4a0bae839e22aa76e5fc','JENKINS BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10380',NULL,'Hikvision camera by HTTP','3','-1','2','','','Hikvision camera by HTTP','0',NULL,'This template is designed for the effortless deployment of Hikvision cameras monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n\r\nSample device overview page:\r\nhttps://www.hikvision.com/en/products/IP-Products/Network-Cameras/\r\n\r\nSetup:\r\n\r\n1. Set the hostname or IP address of the Hikvision ISAPI host in the \'{$HIKVISION_ISAPI_HOST}\' macro.\r\n\r\n2. Set the user name and password in the \'{$PASSWORD}\' and \'{$USER}\' macros.\r\n\r\n3. Change other macros according to your camera configuration if necessary.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3fb4020df2984b0ab64dfd8355ff5c65','HIKVISION CAMERA BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10381',NULL,'Ignite by JMX','3','-1','2','','','Ignite by JMX','0',NULL,'The template to monitor Apache Ignite by Zabbix that work without any external scripts.\r\n  It works with both standalone and cluster instances.\r\n  The metrics are discoverable and collected by JMX.\r\n  Current JMX tree hierarchy contains classloader by default. Add the following jvm option `-DIGNITE_MBEAN_APPEND_CLASS_LOADER_ID=false`to will exclude one level with Classloader name.\r\n  You can set {$IGNITE.USER} and {$IGNITE.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ab05dbb15ff047f192782f617f0627ac','IGNITE BY JMX','Zabbix','7.4-1',NULL,'0','0',''),
('10382',NULL,'Microsoft SharePoint by HTTP','3','-1','2','','','Microsoft SharePoint by HTTP','0',NULL,'Overview:\r\nTemplate receives data via HTTP Agent.\r\nSetup:\r\nCreate a new host.\r\nDefine macros according to your Sharepoint web portal.\r\nIt is recommended to fill in the values of the filter macros to avoid getting redundant data.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8d5fe5b4ebb64255a2429b34c7dd3681','MICROSOFT SHAREPOINT BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10385',NULL,'Huawei OceanStor 5300 V5 by SNMP','3','-1','2','','','Huawei OceanStor 5300 V5 by SNMP','0',NULL,'The template to monitor SAN Huawei OceanStor 5300 V5 by Zabbix SNMP agent.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418855-discussion-thread-for-official-zabbix-template-huawei-oceanstor\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c5564dd58c394b969d5365cc5de3e7f8','HUAWEI OCEANSTOR 5300 V5 BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10386',NULL,'MongoDB node by Zabbix agent 2','3','-1','2','','','MongoDB node by Zabbix agent 2','0',NULL,'Get MongoDB metrics from plugin for the zabbix-agent2.\r\n  1. Setup and configure zabbix-agent2 compiled with the MongoDB monitoring plugin.\r\n  2. Set the {$MONGODB.CONNSTRING} such as <protocol(host:port)> or named session.\r\n  3. Set the user name and password in host macros ({$MONGODB.USER}, {$MONGODB.PASSWORD}) if you want to override parameters from the Zabbix agent configuration file.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420659-discussion-thread-for-official-zabbix-template-db-mongodb\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','81aa8c5ab5594f77a2b26fb7f5094048','MONGODB NODE BY ZABBIX AGENT 2','Zabbix','7.4-0',NULL,'0','0',''),
('10387',NULL,'MongoDB cluster by Zabbix agent 2','3','-1','2','','','MongoDB cluster by Zabbix agent 2','0',NULL,'Get MongoDB metrics from plugin for the zabbix-agent2.\r\n  1. Setup and configure zabbix-agent2 compiled with the MongoDB monitoring plugin.\r\n  2. Set the {$MONGODB.CONNSTRING} such as <protocol(host:port)> or named session.\r\n  3. Set the user name and password in host macros ({$MONGODB.USER}, {$MONGODB.PASSWORD}) if you want to override parameters from the Zabbix agent configuration file.\r\n\r\n  All sharded Mongodb nodes (mongod) will be discovered with attached template "MongoDB node".\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420659-discussion-thread-for-official-zabbix-template-db-mongodb\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d38b271797bd41f2ad8c79d83b9d8d9c','MONGODB CLUSTER BY ZABBIX AGENT 2','Zabbix','7.4-0',NULL,'0','0',''),
('10390',NULL,'Cisco Catalyst 3750V2-24FS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24FS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24FS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6ff896f545e043cc98de6d98698d41df','CISCO CATALYST 3750V2-24FS BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10391',NULL,'Cisco Catalyst 3750V2-24PS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24PS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24PS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4583f0c3bc894251a6c5e7129cb5b9aa','CISCO CATALYST 3750V2-24PS BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10392',NULL,'Cisco Catalyst 3750V2-24TS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24TS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24TS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','30d084c6b7844b7cab6cf820b00bb7b2','CISCO CATALYST 3750V2-24TS BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10393',NULL,'Cisco Catalyst 3750V2-48PS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-48PS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-48PS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ea096c13a09b4d7a9be0aab1cec95206','CISCO CATALYST 3750V2-48PS BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10394',NULL,'Cisco Catalyst 3750V2-48TS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-48TS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-48TS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f744679600844c07b2b4eedda9bc3d0c','CISCO CATALYST 3750V2-48TS BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10395',NULL,'APC UPS by SNMP','3','-1','2','','','APC UPS by SNMP','0',NULL,'Template Power APC UPS\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3ec55c9966624ef5bc1b50502812d581','APC UPS BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10396',NULL,'NetApp AFF A700 by HTTP','3','-1','2','','','NetApp AFF A700 by HTTP','0',NULL,'The template to monitor SAN NetApp AFF A700 cluster by Zabbix HTTP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','79267c69f54a4e59b4152aba4e8c4bd5','NETAPP AFF A700 BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10397',NULL,'TiDB PD by HTTP','3','-1','2','','','TiDB PD by HTTP','0',NULL,'The template to monitor PD server of TiDB cluster by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\nDon\'t forget to change the macros {$PD.URL}, {$PD.PORT}.\r\n\r\nTemplate `TiDB PD by HTTP` — collects metrics by HTTP agent from PD /metrics endpoint and from monitoring API.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','43596328d4d74a5592906a9e08e3fd96','TIDB PD BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10398',NULL,'TiDB by HTTP','3','-1','2','','','TiDB by HTTP','0',NULL,'The template to monitor TiDB server of TiDB cluster by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\nDon\'t forget to change the macros {$TIDB.URL}, {$TIDB.PORT}.\r\n\r\nTemplate `TiDB by HTTP` — collects metrics by HTTP agent from PD /metrics endpoint and from monitoring API.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8ec72ebbe3204d7789429640abcac610','TIDB BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10399',NULL,'TiDB TiKV by HTTP','3','-1','2','','','TiDB TiKV by HTTP','0',NULL,'The template to monitor TiKV server of TiDB cluster by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\nDon\'t forget to change the macros {$TIKV.URL}, {$TIKV.PORT}.\r\n\r\nTemplate `TiDB TiKV by HTTP` — collects metrics by HTTP agent from TiKV /metrics endpoint.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3a0bbbb2ec0a4c58bba3ba3a3d6ce660','TIDB TIKV BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10400',NULL,'APC UPS Galaxy 3500 by SNMP','3','-1','2','','','APC UPS Galaxy 3500 by SNMP','0',NULL,'Template Power APC UPS Galaxy 3500\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5d3971cd973b46e7915d7ae0750bac57','APC UPS GALAXY 3500 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10401',NULL,'APC Smart-UPS 2200 RM by SNMP','3','-1','2','','','APC Smart-UPS 2200 RM by SNMP','0',NULL,'Template Power APC Smart-UPS 2200 RM\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e8c0b2c40e884f1598d86f3edf020ea7','APC SMART-UPS 2200 RM BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10402',NULL,'APC Smart-UPS 3000 XLM by SNMP','3','-1','2','','','APC Smart-UPS 3000 XLM by SNMP','0',NULL,'Template Power APC Smart-UPS 3000 XLM\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','eafd78764fde4110b9e46ae184f327ba','APC SMART-UPS 3000 XLM BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10403',NULL,'APC Smart-UPS RT 1000 RM XL by SNMP','3','-1','2','','','APC Smart-UPS RT 1000 RM XL by SNMP','0',NULL,'Template Power APC Smart-UPS RT 1000 RM XL\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','340ec6917c274ead8fab36925e57f30a','APC SMART-UPS RT 1000 RM XL BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10404',NULL,'APC Smart-UPS RT 1000 XL by SNMP','3','-1','2','','','APC Smart-UPS RT 1000 XL by SNMP','0',NULL,'Template Power APC Smart-UPS RT 1000 XL\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','32d3c78ff44c4c3c9ff5b893ad7f5fc9','APC SMART-UPS RT 1000 XL BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10406',NULL,'APC Smart-UPS SRT 8000 by SNMP','3','-1','2','','','APC Smart-UPS SRT 8000 by SNMP','0',NULL,'Template Power APC Smart-UPS SRT 8000\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b3caafda8c5345cc832ac3be3cefa615','APC SMART-UPS SRT 8000 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10407',NULL,'APC UPS Symmetra LX by SNMP','3','-1','2','','','APC UPS Symmetra LX by SNMP','0',NULL,'Template Power APC UPS Symmetra LX\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0b9a899ff8f1467c9fdf999d02b9fd77','APC UPS SYMMETRA LX BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10408',NULL,'APC UPS Symmetra RM by SNMP','3','-1','2','','','APC UPS Symmetra RM by SNMP','0',NULL,'Template Power APC UPS Symmetra RM\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1dac0a88c3774315b90622a48031e369','APC UPS SYMMETRA RM BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10409',NULL,'APC UPS Symmetra RX by SNMP','3','-1','2','','','APC UPS Symmetra RX by SNMP','0',NULL,'Template Power APC UPS Symmetra RX\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4ffb0f9103084384a98379ed533865e9','APC UPS SYMMETRA RX BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10410',NULL,'WildFly Domain by JMX','3','-1','2','','','WildFly Domain by JMX','0',NULL,'Official JMX Template for WildFly.\r\nThe metrics are collected by JMX. This template works with Domain Controller.\r\nYou can set {$WILDFLY.USER} and {$WILDFLY.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4b27e636b6ad4ce68511d344d5604999','WILDFLY DOMAIN BY JMX','Zabbix','7.4-1',NULL,'0','0',''),
('10411',NULL,'WildFly Server by JMX','3','-1','2','','','WildFly Server by JMX','0',NULL,'Official JMX Template for WildFly.\r\nThe metrics are collected by JMX. This template works with standalone and domain instances.\r\nYou can set {$WILDFLY.USER} and {$WILDFLY.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2bf5827343f0420792ad953f290baa05','WILDFLY SERVER BY JMX','Zabbix','7.4-1',NULL,'0','0',''),
('10412',NULL,'APC Smart-UPS SRT 5000 by SNMP','3','-1','2','','','APC Smart-UPS SRT 5000 by SNMP','0',NULL,'Template Power APC Smart-UPS SRT 5000\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8ec76aeb703747a5affdf435bc12f572','APC SMART-UPS SRT 5000 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10413',NULL,'Website certificate by Zabbix agent 2','3','-1','2','','','Website certificate by Zabbix agent 2','0',NULL,'The template to monitor TLS/SSL certificate on the website by Zabbix agent 2 that works without any external scripts.\r\n\r\nZabbix agent 2 with the WebCertificate plugin requests certificate using the web.certificate.get key and returns JSON with certificate attributes.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/428309-discussion-thread-for-official-zabbix-template-tls-ssl-certificates-monitoring\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5630ec1b1baf449abe1bc5521f85fe6c','WEBSITE CERTIFICATE BY ZABBIX AGENT 2','Zabbix','7.4-1',NULL,'0','0',''),
('10414',NULL,'Cloudflare by HTTP','3','-1','2','','','Cloudflare by HTTP','0',NULL,'The template to monitor Cloudflare to see your web traffic and DNS metrics.\r\nIt works without any external scripts and uses Script item.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','08ef3d687d754b0aba17e1dcbd77d4bd','CLOUDFLARE BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10415',NULL,'NGINX Plus by HTTP','3','-1','2','','','NGINX Plus by HTTP','0',NULL,'Get Nginx Plus metrics by HTTP agent.\r\nMetrics are collected by requests to Nginx Plus API.\r\nDon\'t forget to change macros {$NGINX.API.ENDPOINT}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8cad0f2564694416b60bd8a414948641','NGINX PLUS BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10416',NULL,'Systemd by Zabbix agent 2','3','-1','2','','','Systemd by Zabbix agent 2','0',NULL,'Get systemd units metrics from plugin for the zabbix-agent2.\r\n  1. Setup and configure zabbix-agent2 compiled with the Systemd monitoring plugin.\r\n  2. Set filters with macros if you want to override default filter parameters.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','90ac276995294a6aa88462c032d2ddaf','SYSTEMD BY ZABBIX AGENT 2','Zabbix','7.4-2',NULL,'0','0',''),
('10417',NULL,'GridGain by JMX','3','-1','2','','','GridGain by JMX','0',NULL,'The template to monitor GridGain In-Memory Computing Platform by Zabbix that work without any external scripts.\r\n  It works with both standalone and cluster instances.\r\n  The metrics are discoverable and collected by JMX.\r\n  Current JMX tree hierarchy contains classloader by default. Add the following jvm option `-DIGNITE_MBEAN_APPEND_CLASS_LOADER_ID=false`to will exclude one level with Classloader name.\r\n  You can set {$GRIDGAIN.USER} and {$GRIDGAIN.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','47d87c39c121429b98a18f641aa443ea','GRIDGAIN BY JMX','Zabbix','7.4-1',NULL,'0','0',''),
('10418',NULL,'Cisco ASAv by SNMP','3','-1','2','','','Cisco ASAv by SNMP','0',NULL,'Template Net Cisco ASAv\r\n\r\nMIBs used:\r\nCISCO-PORT-MIB\r\nCISCO-MEMORY-POOL-MIB\r\nCISCO-REMOTE-ACCESS-MONITOR-MIB\r\nIF-MIB\r\nRFC1213-MIB\r\nCISCO-PROCESS-MIB\r\nENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','75d009cd4dc84ee7a8fc479fa2fbaeee','CISCO ASAV BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10419',NULL,'F5 Big-IP by SNMP','3','-1','2','','','F5 Big-IP by SNMP','0',NULL,'MIBs used:\r\nRFC1213-MIB\r\nF5-BIGIP-LOCAL-MIB\r\nF5-BIGIP-SYSTEM-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','44c2c2d94a4447c6a924386640e4854a','F5 BIG-IP BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10420',NULL,'ZYXEL AAM1212-51 IES-612 by SNMP','3','-1','2','','','ZYXEL AAM1212-51 IES-612 by SNMP','0',NULL,'ZYXEL AAM1212-51 / IES-612\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IESCOMMON-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL AAM1212-51 / IES-612\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3a71dcdcfe0b4a0e8284d8939d335cce','ZYXEL AAM1212-51 IES-612 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10421',NULL,'ZYXEL ES3500-8PD by SNMP','3','-1','2','','','ZYXEL ES3500-8PD by SNMP','0',NULL,'ZYXEL ES3500-8PD\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-ES3500-8PD-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL ES3500-8PD\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b8a6f34fd5c447b1b9310746a96f4e80','ZYXEL ES3500-8PD BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10422',NULL,'ZYXEL GS-4012F by SNMP','3','-1','2','','','ZYXEL GS-4012F by SNMP','0',NULL,'ZYXEL GS-4012F\r\n\r\nMIBs used:\r\nZYXEL-GS4012F-MIB\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL GS-4012F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','73f123bb9ffe4587a0269c7e8752b2ed','ZYXEL GS-4012F BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10423',NULL,'ZYXEL IES-500x by SNMP','3','-1','2','','','ZYXEL IES-500x by SNMP','0',NULL,'ZYXEL IES-500x\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IES5000-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES-500x\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3db86b0d235e4c7b80f7d6144ca08925','ZYXEL IES-500X BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10424',NULL,'ZYXEL IES-6000 by SNMP','3','-1','2','','','ZYXEL IES-6000 by SNMP','0',NULL,'ZYXEL IES-6000\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IES5000-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES-6000\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3645654baaf04f11927b171bcb048349','ZYXEL IES-6000 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10425',NULL,'ZYXEL IES1248-51 by SNMP','3','-1','2','','','ZYXEL IES1248-51 by SNMP','0',NULL,'ZYXEL IES1248-51\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IESCOMMON-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES1248-51\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8e6d7067cd094e56a52db999b3199edc','ZYXEL IES1248-51 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10426',NULL,'ZYXEL MES-3528 by SNMP','3','-1','2','','','ZYXEL MES-3528 by SNMP','0',NULL,'ZYXEL MES-3528\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-MES3528-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES-3528\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','249de8d8d21e4dda9c3f766ab6201378','ZYXEL MES-3528 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10427',NULL,'ZYXEL MES3500-10 by SNMP','3','-1','2','','','ZYXEL MES3500-10 by SNMP','0',NULL,'ZYXEL MES3500-10\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-MES3500-10-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES3500-10\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','21a95afef0e74fb19691693090403d1d','ZYXEL MES3500-10 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10428',NULL,'ZYXEL MES3500-24 by SNMP','3','-1','2','','','ZYXEL MES3500-24 by SNMP','0',NULL,'ZYXEL MES3500-24\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-MES3500-24-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES3500-24\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','292970ad91204722b5e5cb3233fc0026','ZYXEL MES3500-24 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10429',NULL,'ZYXEL MGS-3712 by SNMP','3','-1','2','','','ZYXEL MGS-3712 by SNMP','0',NULL,'ZYXEL MGS-3712\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-MGS3712F-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS-3712\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8ea7299983f24d0a913606e334f0e526','ZYXEL MGS-3712 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10430',NULL,'ZYXEL MGS-3712F by SNMP','3','-1','2','','','ZYXEL MGS-3712F by SNMP','0',NULL,'ZYXEL MGS-3712F\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-MGS3712F-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS-3712F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','01deb47efa1f4a9092de67fd61820a7d','ZYXEL MGS-3712F BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10431',NULL,'ZYXEL MES3500-24S by SNMP','3','-1','2','','','ZYXEL MES3500-24S by SNMP','0',NULL,'ZYXEL MES3500-24S\r\n\r\nMIBs used:\r\nZYXEL-TRANSCEIVER-MIB\r\nIF-MIB\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-HW-MONITOR-MIB\r\nZYXEL-PORT-MIB\r\nZYXEL-ES-COMMON\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS3520-28\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','89eef2fe23964f44bf9aec6d00e39efd','ZYXEL MES3500-24S BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10432',NULL,'ZYXEL MGS3520-28x by SNMP','3','-1','2','','','ZYXEL MGS3520-28x by SNMP','0',NULL,'ZYXEL MGS3520-28x\r\n\r\nMIBs used:\r\nZYXEL-TRANSCEIVER-MIB\r\nIF-MIB\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-HW-MONITOR-MIB\r\nZYXEL-PORT-MIB\r\nZYXEL-ES-COMMON\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS3520-28\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','9cc843a085bb4ee5af0dc4d764a7eee9','ZYXEL MGS3520-28X BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10433',NULL,'ZYXEL XGS-4728F by SNMP','3','-1','2','','','ZYXEL XGS-4728F by SNMP','0',NULL,'ZYXEL XGS-4728F\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-XGS4728F-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL XGS-4728F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ab18a5665b7d4bed876881b5c4e8ce51','ZYXEL XGS-4728F BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10434',NULL,'Cisco UCS Manager by SNMP','3','-1','2','','','Cisco UCS Manager by SNMP','0',NULL,'This is a template for Cisco UCS Manager monitoring via Zabbix SNMP Agent that works without any external scripts.\r\n\r\n\r\nMIBs used:\r\nCISCO-UNIFIED-COMPUTING-COMPUTE-MIB\r\nCISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB\r\nIF-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nCISCO-UNIFIED-COMPUTING-PROCESSOR-MIB\r\nCISCO-UNIFIED-COMPUTING-STORAGE-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d5eb4ce08a334098a85e6e02c534be90','CISCO UCS MANAGER BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10435',NULL,'DELL PowerEdge R720 by HTTP','3','-1','2','','','DELL PowerEdge R720 by HTTP','0',NULL,'Template for DELL PowerEdge R720 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','9643f22821104f809e2486be83e1816e','DELL POWEREDGE R720 BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10436',NULL,'DELL PowerEdge R720 by SNMP','3','-1','2','','','DELL PowerEdge R720 by SNMP','0',NULL,'Template for DELL PowerEdge R720 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fe5b8448661f41b9a6d948fccd7f9045','DELL POWEREDGE R720 BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10437',NULL,'DELL PowerEdge R740 by HTTP','3','-1','2','','','DELL PowerEdge R740 by HTTP','0',NULL,'Template for DELL PowerEdge R740 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3f707f39c32a4b6e8b214c38a260f6f9','DELL POWEREDGE R740 BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10438',NULL,'DELL PowerEdge R740 by SNMP','3','-1','2','','','DELL PowerEdge R740 by SNMP','0',NULL,'Template for DELL PowerEdge R740 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','9fde0e1c36f8453da72f97535d4e74ca','DELL POWEREDGE R740 BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10439',NULL,'DELL PowerEdge R820 by HTTP','3','-1','2','','','DELL PowerEdge R820 by HTTP','0',NULL,'Template for DELL PowerEdge R820 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1e9fe6b88c7542638c0f5d94484858b2','DELL POWEREDGE R820 BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10440',NULL,'DELL PowerEdge R820 by SNMP','3','-1','2','','','DELL PowerEdge R820 by SNMP','0',NULL,'Template for DELL PowerEdge R820 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d41c5d0fa91545d68cced1b5dabe4bf1','DELL POWEREDGE R820 BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10441',NULL,'DELL PowerEdge R840 by HTTP','3','-1','2','','','DELL PowerEdge R840 by HTTP','0',NULL,'Template for DELL PowerEdge R840 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','20147f00f92d4240aab0b70cf578c022','DELL POWEREDGE R840 BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10442',NULL,'DELL PowerEdge R840 by SNMP','3','-1','2','','','DELL PowerEdge R840 by SNMP','0',NULL,'Template for DELL PowerEdge R840 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fc834b8da8864678b55557e9a237eac9','DELL POWEREDGE R840 BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10443',NULL,'HPE ProLiant BL460 by SNMP','3','-1','2','','','HPE ProLiant BL460 by SNMP','0',NULL,'Template for HPE ProLiant BL460 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','172ec7e51f1c4a6ba49baffbab3dda97','HPE PROLIANT BL460 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10444',NULL,'HPE ProLiant BL920 by SNMP','3','-1','2','','','HPE ProLiant BL920 by SNMP','0',NULL,'Template for HPE ProLiant BL920 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','586119e5e27e4062a3cce8601ecb8d71','HPE PROLIANT BL920 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10445',NULL,'HPE ProLiant DL360 by SNMP','3','-1','2','','','HPE ProLiant DL360 by SNMP','0',NULL,'Template for HPE ProLiant DL360 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','60cb9ccb922e4fd194a1d9573db10237','HPE PROLIANT DL360 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10446',NULL,'HPE ProLiant DL380 by SNMP','3','-1','2','','','HPE ProLiant DL380 by SNMP','0',NULL,'Template for HPE ProLiant DL380 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','379aaf7e87574debb4f5c3947a22ec68','HPE PROLIANT DL380 BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10447',NULL,'Travis CI by HTTP','3','-1','2','','','Travis CI by HTTP','0',NULL,'Template for monitoring Travis CI https://travis-ci.com\r\nYou must set {$TRAVIS.API.TOKEN} and {$TRAVIS.API.URL} macros.\r\n  {$TRAVIS.API.TOKEN} is a Travis API authentication token located in User -> Settings -> API authentication.\r\n  {$TRAVIS.API.URL} could be in 2 different variations:\r\n   - for a private project : api.travis-ci.com\r\n   - for an enterprise projects: api.example.com (where you replace example.com with the domain Travis CI is running on)\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8cdbe00a2a3046ee962d28d32567968a','TRAVIS CI BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10448',NULL,'InfluxDB by HTTP','3','-1','2','','','InfluxDB by HTTP','0',NULL,'Get InfluxDB metrics by HTTP agent from Prometheus metrics endpoint.\r\nFor organization discovery template need to use Authorization via API token. See docs: https://docs.influxdata.com/influxdb/v2.0/security/tokens/\r\n\r\nDon\'t forget change macros {$INFLUXDB.URL}, {$INFLUXDB.API.TOKEN}.\r\nSome metrics may not be collected depending on your InfluxDB instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a6fe3640b23544e7ae15d438b38ce1cd','INFLUXDB BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10449',NULL,'MikroTik CCR1009-7G-1C-1SPC by SNMP','3','-1','2','','','MikroTik CCR1009-7G-1C-1S+PC by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1009-7G-1C-1S+PC.\r\n\r\n7x Gigabit Ethernet, 1x Combo port (SFP or Gigabit Ethernet), 1xSFP+ cage, 9\r\ncores x 1GHz CPU, 2GB RAM, LCD panel, passive cooling desktop enclosure, SmartCard\r\nslot, RouterOS L6, PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d596d6d231bf49c08890aa3ff135ecc6','MIKROTIK CCR1009-7G-1C-1S+PC BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10450',NULL,'MikroTik CCR1009-7G-1C-1S by SNMP','3','-1','2','','','MikroTik CCR1009-7G-1C-1S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1009-7G-1C-1S+.\r\n\r\n1U rackmount, 7x Gigabit Ethernet, 1x Combo port (SFP or Gigabit Ethernet),\r\n1xSFP+ cage, 9 cores x 1.2GHz CPU, 2GB RAM, LCD panel, Dual Power supplies,\r\nSmartCard slot, RouterOS L6\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a809695fbc784b75adcd4833c86bca8d','MIKROTIK CCR1009-7G-1C-1S+ BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10451',NULL,'MikroTik CCR1009-7G-1C-PC by SNMP','3','-1','2','','','MikroTik CCR1009-7G-1C-PC by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1009-7G-1C-PC.\r\n\r\n7x Gigabit Ethernet, 1x Combo port (SFP or Gigabit Ethernet), 9 cores x 1GHz\r\nCPU, 1GB RAM, passive cooling case, RouterOS L6\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','012e7043ff9849e197c42bf41cdf4d9a','MIKROTIK CCR1009-7G-1C-PC BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10452',NULL,'MikroTik CCR1016-12G by SNMP','3','-1','2','','','MikroTik CCR1016-12G by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1016-12G.\r\n\r\n1U rackmount, 12x Gigabit Ethernet, LCD, 16 cores x 1.2GHz CPU, 2GB RAM, 17.8mpps\r\nfastpath, Up to 12Gbit/s throughput, RouterOS L6, Dual PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5ed19d1f74224588bf5f53ac47003acc','MIKROTIK CCR1016-12G BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10453',NULL,'MikroTik CCR1016-12S-1S by SNMP','3','-1','2','','','MikroTik CCR1016-12S-1S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1016-12S-1S+.\r\n\r\n1U rackmount, 12xSFP cage, 1xSFP+ cage, 16 cores x 1.2GHz CPU, 2GB RAM, LCD\r\npanel, Dual Power supplies, RouterOS L6\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','654910b270d9464f863ed085ba7302ce','MIKROTIK CCR1016-12S-1S+ BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10454',NULL,'MikroTik CCR1036-12G-4S-EM by SNMP','3','-1','2','','','MikroTik CCR1036-12G-4S-EM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-12G-4S-EM.\r\n\r\n1U rackmount, 12x Gigabit Ethernet, 4xSFP cages, LCD, 36 cores x 1.2GHz CPU,\r\n8GB RAM, 24 mpps fastpath, Up to 16Gbit/s throughput, RouterOS L6, Dual PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','930c0e0534a9424fb01f2b6218d8ce59','MIKROTIK CCR1036-12G-4S-EM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10455',NULL,'MikroTik CCR1036-12G-4S by SNMP','3','-1','2','','','MikroTik CCR1036-12G-4S by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-12G-4S.\r\n\r\n1U rackmount, 12x Gigabit Ethernet, 4xSFP cages, LCD, 36 cores x 1.2GHz CPU,\r\n4GB RAM, 24 mpps fastpath, Up to 16Gbit/s throughput, RouterOS L6, Dual PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','82b428ad78d34988b93f3d577f2b6adc','MIKROTIK CCR1036-12G-4S BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10456',NULL,'MikroTik CCR1036-8G-2SEM by SNMP','3','-1','2','','','MikroTik CCR1036-8G-2S+EM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-8G-2S+EM.\r\n\r\n1U rackmount, 8x Gigabit Ethernet, 2xSFP+ cages, LCD, 36 cores x 1.2GHz CPU,\r\n8GB RAM, 41.5mpps fastpath, Up to 28Gbit/s throughput, RouterOS L6, Dual PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7b3ecb24366f4685970df8e1143323f0','MIKROTIK CCR1036-8G-2S+EM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10457',NULL,'MikroTik CCR1036-8G-2S by SNMP','3','-1','2','','','MikroTik CCR1036-8G-2S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-8G-2S+.\r\n\r\n1U rackmount, 8x Gigabit Ethernet, 2xSFP+ cages, LCD, 36 cores x 1.2GHz CPU,\r\n4GB RAM, 41.5mpps fastpath, Up to 28Gbit/s throughput, RouterOS L6, Dual PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7f44e67e3f564ec9894c9142d7276553','MIKROTIK CCR1036-8G-2S+ BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10458',NULL,'MikroTik CCR1072-1G-8S by SNMP','3','-1','2','','','MikroTik CCR1072-1G-8S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1072-1G-8S+.\r\n\r\n1U rackmount, 1x Gigabit Ethernet, 8xSFP+ cages, LCD, 72 cores x 1GHz CPU, 16GB\r\nRAM, up to 120 million packets per second, 80Gbps throughput, RouterOS L6\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e7894db1c4c94e0f8715977e751368b3','MIKROTIK CCR1072-1G-8S+ BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10459',NULL,'MikroTik CCR2004-16G-2S by SNMP','3','-1','2','','','MikroTik CCR2004-16G-2S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR2004-16G-2S+.\r\n\r\nThis powerful and affordable router crushes all previous CCR models in single-core\r\nperformance. 16x Gigabit Ethernet ports, 2x10G SFP+ cages, active cooling and\r\nthe best single-core performance per watt & best overall performance per watt\r\namong all the CCR devices.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ab871d051e304f83950171c5243aa4db','MIKROTIK CCR2004-16G-2S+ BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10460',NULL,'MikroTik CCR2004-1G-12S2XS by SNMP','3','-1','2','','','MikroTik CCR2004-1G-12S+2XS by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR2004-1G-12S+2XS.\r\n\r\nThe Connectivity Router - your best companion when it comes to SFP, SFP+ and\r\nSFP28 management! 1, 10 and 25 Gbps ports in a single device to make your life\r\neasier.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f2efeb94f4bd4ed9ab34a973c0363eb8','MIKROTIK CCR2004-1G-12S+2XS BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10461',NULL,'MikroTik CRS106-1C-5S by SNMP','3','-1','2','','','MikroTik CRS106-1C-5S by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS106-1C-5S.\r\n\r\nSmart Switch, 5x SFP cages, 1x Combo port (SFP or Gigabit Ethernet), 400MHz\r\nCPU, 128MB RAM, desktop case, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','20ea139663264c21bca0dcecf2e95589','MIKROTIK CRS106-1C-5S BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10462',NULL,'MikroTik CRS109-8G-1S-2HnD-IN by SNMP','3','-1','2','','','MikroTik CRS109-8G-1S-2HnD-IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS109-8G-1S-2HnD-IN.\r\n\r\n8x Gigabit Smart Switch, 1x SFP cage, LCD, 802.11b/g/n Dual Chain wireless,\r\n600MHz CPU, 128MB RAM, Metal desktop case, RouterOS L5, supports 10-57V, 802.3af/at\r\ncompliant\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fac16383680c4454be48b6db870d975e','MIKROTIK CRS109-8G-1S-2HND-IN BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10463',NULL,'MikroTik CRS112-8G-4S-IN by SNMP','3','-1','2','','','MikroTik CRS112-8G-4S-IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS112-8G-4S-IN.\r\n\r\n8x Gigabit Ethernet Smart Switch, 4x SFP cages, 400MHz CPU, 128MB RAM, desktop\r\ncase, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8d7d49fd0b3f4b1f9046dc0e94457931','MIKROTIK CRS112-8G-4S-IN BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10464',NULL,'MikroTik CRS112-8P-4S-IN by SNMP','3','-1','2','','','MikroTik CRS112-8P-4S-IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS112-8P-4S-IN.\r\n\r\n8x Gigabit Ethernet Smart Switch with PoE-out, 4x SFP cages, 400MHz CPU, 128MB\r\nRAM, desktop case, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','538ec67ce01341a9b281dbd86d86d2a2','MIKROTIK CRS112-8P-4S-IN BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10465',NULL,'MikroTik CRS125-24G-1S-2HnD-IN by SNMP','3','-1','2','','','MikroTik CRS125-24G-1S-2HnD-IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS125-24G-1S-2HnD-IN.\r\n\r\n24x Gigabit Ethernet layer 3 Smart Switch, 1x SFP cage, LCD, 802.11b/g/n Dual\r\nChain wireless, 600MHz CPU, 128MB RAM, Metal desktop case, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c8db153405704d859ba5ee19f08b46f3','MIKROTIK CRS125-24G-1S-2HND-IN BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10466',NULL,'MikroTik CRS212-1G-10S-1SIN by SNMP','3','-1','2','','','MikroTik CRS212-1G-10S-1S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS212-1G-10S-1S+IN.\r\n\r\nSmart Switch, 1x Gigabit LAN, 10x SFP cages, 1x SFP+ cage, LCD, 400MHz CPU,\r\n64MB RAM, Metal desktop case, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cdb6ebceb1174bada392dd24889b14d9','MIKROTIK CRS212-1G-10S-1S+IN BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10467',NULL,'MikroTik CRS305-1G-4SIN by SNMP','3','-1','2','','','MikroTik CRS305-1G-4S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS305-1G-4S+IN.\r\n\r\nFive-port desktop switch with one Gigabit Ethernet port and four SFP+ 10Gbps\r\nports\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','223101f878704022a04c30c3ff066e3f','MIKROTIK CRS305-1G-4S+IN BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10468',NULL,'MikroTik CRS309-1G-8SIN by SNMP','3','-1','2','','','MikroTik CRS309-1G-8S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS309-1G-8S+IN.\r\n\r\nDesktop switch with one Gigabit Ethernet port and eight SFP+ 10Gbps ports\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','bcc01f2b466345c4bcbe0cea1a7884d1','MIKROTIK CRS309-1G-8S+IN BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10469',NULL,'MikroTik CRS312-4C8XG-RM by SNMP','3','-1','2','','','MikroTik CRS312-4C+8XG-RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS312-4C+8XG-RM.\r\n\r\nSwitch of the future: the first MikroTik product with 10G RJ45 Ethernet ports\r\nand SFP+\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8da94e2f01ff46e28becf0b08ff09ace','MIKROTIK CRS312-4C+8XG-RM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10470',NULL,'MikroTik CRS317-1G-16SRM by SNMP','3','-1','2','','','MikroTik CRS317-1G-16S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS317-1G-16S+RM.\r\n\r\nSmart Switch, 1 x Gigabit LAN, 16 x SFP+ cages, Dual Core 800MHz CPU, 1GB RAM,\r\n1U rackmount passive cooling case, Dual Power Supplies\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f474ff823fe84d689b9e4c6a4f0ce59e','MIKROTIK CRS317-1G-16S+RM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10471',NULL,'MikroTik CRS326-24G-2SIN by SNMP','3','-1','2','','','MikroTik CRS326-24G-2S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS326-24G-2S+IN.\r\n\r\n24 Gigabit ports, 2 SFP+ cages and a desktop case – server room power for your\r\nhome!\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c5f41fe0f54f470f9e304384838f150a','MIKROTIK CRS326-24G-2S+IN BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10472',NULL,'MikroTik CRS326-24G-2SRM by SNMP','3','-1','2','','','MikroTik CRS326-24G-2S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS326-24G-2S+RM.\r\n\r\n24 Gigabit port switch with 2 x SFP+ cages in 1U rackmount case, Dual boot (RouterOS\r\nor SwitchOS)\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','bc80883918ac4f879427ca145122b5cb','MIKROTIK CRS326-24G-2S+RM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10473',NULL,'MikroTik CRS326-24S2QRM by SNMP','3','-1','2','','','MikroTik CRS326-24S+2Q+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS326-24S+2Q+RM.\r\n\r\nOur fastest switch for the most demanding setups\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e7ed0e0cbd0b439394f6498ea90dc31d','MIKROTIK CRS326-24S+2Q+RM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10474',NULL,'MikroTik CRS328-24P-4SRM by SNMP','3','-1','2','','','MikroTik CRS328-24P-4S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS328-24P-4S+RM.\r\n\r\n24 port Gigabit Ethernet router/switch with four 10Gbps SFP+ ports in 1U rackmount\r\ncase, Dual Boot and PoE output, 500W\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','dcf88bca5aaf4123a10eb3daab28a9af','MIKROTIK CRS328-24P-4S+RM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10475',NULL,'MikroTik CRS328-4C-20S-4SRM by SNMP','3','-1','2','','','MikroTik CRS328-4C-20S-4S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS328-4C-20S-4S+RM.\r\n\r\nSmart Switch, 20 x SFP cages, 4 x SFP+ cages, 4 x Combo ports (Gigabit Ethernet\r\nor SFP), 800MHz CPU, 512MB RAM, 1U rackmount case, Dual Power Supplies, RouterOS\r\nL5 or SwitchOS (Dual Boot)\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6742f5ed33ca4c19b8e61203770e5fe5','MIKROTIK CRS328-4C-20S-4S+RM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10476',NULL,'MikroTik CRS354-48G-4S2QRM by SNMP','3','-1','2','','','MikroTik CRS354-48G-4S+2Q+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS354-48G-4S+2Q+RM.\r\n\r\nBest price and best performance on the market – this 48 port switch will rock\r\nany setup, including 40 Gbps devices!\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d1c1ab5db2c34c17ae3541407f8b7faa','MIKROTIK CRS354-48G-4S+2Q+RM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10477',NULL,'MikroTik CRS354-48P-4S2QRM by SNMP','3','-1','2','','','MikroTik CRS354-48P-4S+2Q+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS354-48P-4S+2Q+RM.\r\n\r\nThe 48 port champion you’ve been waiting for - now with PoE-out!\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fa5e5e131eb34bbea1b1f7b2352a853d','MIKROTIK CRS354-48P-4S+2Q+RM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10478',NULL,'MikroTik CSS326-24G-2SRM by SNMP','3','-1','2','','','MikroTik CSS326-24G-2S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CSS326-24G-2S+RM.\r\n\r\nSwOS powered 24 port Gigabit Ethernet switch with two SFP+ ports in 1U rackmount\r\ncase\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','75ada0d6fb22416a9e6e5f44c2c3f64a','MIKROTIK CSS326-24G-2S+RM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10479',NULL,'MikroTik CSS610-8G-2SIN by SNMP','3','-1','2','','','MikroTik CSS610-8G-2S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CSS610-8G-2S+IN.\r\n\r\nEight 1G Ethernet ports and two SFP+ ports for 10G fiber connectivity. Portable,\r\npowerful and extremely cost-effective - this switch is an instant classic!\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8d22b4d1a9c6457fbd6fd959263f91db','MIKROTIK CSS610-8G-2S+IN BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10480',NULL,'MikroTik FiberBox by SNMP','3','-1','2','','','MikroTik FiberBox by SNMP','0',NULL,'The template for monitoring Switch MikroTik FiberBox.\r\n\r\nAn outdoor switch with five SFP ports\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2bd6f566391d49dab6bee184522ab5fa','MIKROTIK FIBERBOX BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10481',NULL,'MikroTik PowerBox Pro by SNMP','3','-1','2','','','MikroTik PowerBox Pro by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik PowerBox Pro.\r\n\r\nFive Gigabit Ethernet Router with 4xPoE-out ports, SFP cage and outdoor enclosure\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c03e1ab0128a4ae1847bc04a34f5634e','MIKROTIK POWERBOX PRO BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10482',NULL,'MikroTik PowerBox by SNMP','3','-1','2','','','MikroTik PowerBox by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik PowerBox.\r\n\r\n650MHz CPU, 64MB RAM, 5xEthernet with PoE output for four ports, RouterOS L4,\r\noutdoor case, PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0c7b3c03a5854f868b56f3ab63e2d3f7','MIKROTIK POWERBOX BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10483',NULL,'MikroTik RB1100AHx4 Dude Edition by SNMP','3','-1','2','','','MikroTik RB1100AHx4 Dude Edition by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB1100AHx4 Dude Edition.\r\n\r\nPowerful 1U rackmount router with 13x Gigabit Ethernet ports, 60GB M.2 drive\r\nfor Dude database\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fac50638cb77468598c29a6a47520c24','MIKROTIK RB1100AHX4 DUDE EDITION BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10484',NULL,'MikroTik RB1100AHx4 by SNMP','3','-1','2','','','MikroTik RB1100AHx4 by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB1100AHx4.\r\n\r\nPowerful 1U rackmount router with 13x Gigabit Ethernet ports\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3dfd1a55987848e5aa6ffe92c228f63b','MIKROTIK RB1100AHX4 BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10485',NULL,'MikroTik RB2011UiAS-IN by SNMP','3','-1','2','','','MikroTik RB2011UiAS-IN by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011UiAS-IN.\r\n\r\nDesktop metal case, 5xEthernet, 5xGigabit Ethernet, USB, LCD, PoE out on port\r\n10, 600MHz CPU, 128MB RAM, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8cf537f34600403b9de31d3db4eb2a1d','MIKROTIK RB2011UIAS-IN BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10486',NULL,'MikroTik RB2011UiAS-RM by SNMP','3','-1','2','','','MikroTik RB2011UiAS-RM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011UiAS-RM.\r\n\r\n1U rackmount, 5xEthernet, 5xGigabit Ethernet, USB, LCD, PoE out on port 10,\r\n600MHz CPU, 128MB RAM, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','969cf5dca58f47f0b271ccf62ef79c13','MIKROTIK RB2011UIAS-RM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10487',NULL,'MikroTik RB2011iL-IN by SNMP','3','-1','2','','','MikroTik RB2011iL-IN by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011iL-IN.\r\n\r\nDesktop metal case, 5xEthernet, 5xGigabit Ethernet, PoE out on port 10, 600MHz\r\nCPU, 64MB RAM, RouterOS L4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','141438a05f904b518c7d3ddfbbabf91f','MIKROTIK RB2011IL-IN BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10488',NULL,'MikroTik RB2011iL-RM by SNMP','3','-1','2','','','MikroTik RB2011iL-RM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011iL-RM.\r\n\r\n1U rackmount, 5xEthernet, 5xGigabit Ethernet, PoE out on port 10, 600MHz CPU,\r\n64MB RAM, RouterOS L4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6d9737c72e5540d39e3553b773a587b1','MIKROTIK RB2011IL-RM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10489',NULL,'MikroTik RB2011iLS-IN by SNMP','3','-1','2','','','MikroTik RB2011iLS-IN by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011iLS-IN.\r\n\r\nDesktop metal case, 5xEthernet, 5xGigabit Ethernet, SFP cage, PoE out on port\r\n10, 600MHz CPU, 64MB RAM, RouterOS L4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','318fd61c22fa4f1a92a71376814d6c32','MIKROTIK RB2011ILS-IN BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10490',NULL,'MikroTik RB260GSP by SNMP','3','-1','2','','','MikroTik RB260GSP by SNMP','0',NULL,'The template for monitoring Switch MikroTik RB260GSP.\r\n\r\n5x Gigabit PoE out Ethernet Smart Switch, SFP cage, plastic case, SwOS\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5331ecc3be9f47d6a8eb0732ae141239','MIKROTIK RB260GSP BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10491',NULL,'MikroTik RB260GS by SNMP','3','-1','2','','','MikroTik RB260GS by SNMP','0',NULL,'The template for monitoring Switch MikroTik RB260GS.\r\n\r\n5x Gigabit Ethernet Smart Switch, SFP cage, plastic case, SwOS\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1a74dd95e7244493a1b13b94fe9dd9e8','MIKROTIK RB260GS BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10492',NULL,'MikroTik RB3011UiAS-RM by SNMP','3','-1','2','','','MikroTik RB3011UiAS-RM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB3011UiAS-RM.\r\n\r\n1U rackmount, 10xGigabit Ethernet, SFP, USB 3.0, LCD, PoE out on port 10, 2x1.4GHz\r\nCPU, 1GB RAM, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cc762a057f0f467ab571b6d76a9bb278','MIKROTIK RB3011UIAS-RM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10493',NULL,'MikroTik RB4011iGSRM by SNMP','3','-1','2','','','MikroTik RB4011iGS+RM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB4011iGS+RM.\r\n\r\nPowerful 10xGigabit port router with a Quad-core 1.4Ghz CPU, 1GB RAM, SFP+ 10Gbps\r\ncage and desktop case with rack ears\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','780c4a9a657e42fc83f1ab9a535f5184','MIKROTIK RB4011IGS+RM BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10494',NULL,'MikroTik RB5009UGSIN by SNMP','3','-1','2','','','MikroTik RB5009UG+S+IN by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB5009UG+S+IN.\r\n\r\nThe ultimate heavy-duty home lab router with USB 3.0, 1G and 2.5G Ethernet and\r\na 10G SFP+ cage. You can mount four of these new routers in a single 1U rackmount\r\nspace! Unprecedented processing power in such a small form factor.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7b6f7a12a6b449ca926e74c894eca354','MIKROTIK RB5009UG+S+IN BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10495',NULL,'MikroTik hEX PoE lite by SNMP','3','-1','2','','','MikroTik hEX PoE lite by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX PoE lite.\r\n\r\n5xEthernet with PoE output for four ports, USB, 650MHz CPU, 64MB RAM, RouterOS\r\nL4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a5ddacdd5ac64b82bf5183769cc03e8c','MIKROTIK HEX POE LITE BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10496',NULL,'MikroTik hEX PoE by SNMP','3','-1','2','','','MikroTik hEX PoE by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX PoE.\r\n\r\n5x Gigabit Ethernet with PoE output for four ports, SFP, USB, 800MHz CPU, 128MB\r\nRAM, RouterOS L4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ff57532daf924030b364e3b75acb74c4','MIKROTIK HEX POE BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10497',NULL,'MikroTik hEX S by SNMP','3','-1','2','','','MikroTik hEX S by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX S.\r\n\r\n5x Gigabit Ethernet, SFP, Dual Core 880MHz CPU, 256MB RAM, USB, microSD, RouterOS\r\nL4, IPsec hardware encryption support and The Dude server package\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7802db8c2f9c4a7eba7b381b8f3fa5c5','MIKROTIK HEX S BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10498',NULL,'MikroTik hEX lite by SNMP','3','-1','2','','','MikroTik hEX lite by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX lite.\r\n\r\n5x Ethernet, Small plastic case, 850MHz CPU, 64MB RAM, Most affordable MPLS\r\nrouter, RouterOS L4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2785d83763c641a7a7937b516665d93a','MIKROTIK HEX LITE BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10499',NULL,'MikroTik hEX by SNMP','3','-1','2','','','MikroTik hEX by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX.\r\n\r\n5x Gigabit Ethernet, Dual Core 880MHz CPU, 256MB RAM, USB, microSD, RouterOS\r\nL4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','68c2034014f24115ae9e910962530472','MIKROTIK HEX BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10500',NULL,'MikroTik netPower 15FR by SNMP','3','-1','2','','','MikroTik netPower 15FR by SNMP','0',NULL,'The template for monitoring Switch MikroTik netPower 15FR.\r\n\r\nAn outdoor 18 port switch with 15 reverse PoE ports and SFP. Cut costs, not\r\nspeed - choose GPEN over GPON!\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f1928e12f9554599a9adb516f38b6bf6','MIKROTIK NETPOWER 15FR BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10501',NULL,'MikroTik netPower 16P by SNMP','3','-1','2','','','MikroTik netPower 16P by SNMP','0',NULL,'The template for monitoring Switch MikroTik netPower 16P.\r\n\r\nAn outdoor 18 port switch with 16 Gigabit PoE-out ports and 2 SFP+. Power all\r\nyour access points anywhere!\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b126aaf4499d49d7b4fcee0329b7dea7','MIKROTIK NETPOWER 16P BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10502',NULL,'MikroTik netPower Lite 7R by SNMP','3','-1','2','','','MikroTik netPower Lite 7R by SNMP','0',NULL,'The template for monitoring Switch MikroTik netPower Lite 7R.\r\n\r\nAn outdoor reverse PoE switch with Gigabit Ethernet and 10G SFP+ ports.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1782caa5bf724f66a23e7dbb96ef7ba2','MIKROTIK NETPOWER LITE 7R BY SNMP','Zabbix','7.4-2',NULL,'0','0',''),
('10503',NULL,'VMWare SD-WAN VeloCloud by HTTP','3','-1','2','','','VMWare SD-WAN VeloCloud by HTTP','0',NULL,'Template for monitoring VMWare SD-WAN VeloCloud https://www.vmware.com/products/sd-wan.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e1ca624566424496bff9d90c261ab37b','VMWARE SD-WAN VELOCLOUD BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10504',NULL,'Kubernetes API server by HTTP','3','-1','2','','','Kubernetes API server by HTTP','0',NULL,'Get Kubernetes API server metrics by HTTP agent from Prometheus metrics endpoint.\r\n\r\nDon\'t forget change macros {$KUBE.API.SERVER.URL}, {$KUBE.API.TOKEN}.\r\nSome metrics may not be collected depending on your Kubernetes API server instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','85ce114c802e4e28a5f3597e07d07032','KUBERNETES API SERVER BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThe template to monitor Kubernetes API server that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nTemplate `Kubernetes API server by HTTP` - collects metrics by HTTP agent from API server /metrics endpoint.\r\n\r\n## Setup\r\n\r\nInternal service metrics are collected from /metrics endpoint.\r\nTemplate needs to use Authorization via API token.\r\n\r\nSet the following fields: `Kubernetes API server URL`, `API Authorization Token`.\r\n\r\n*NOTE.* Some metrics may not be collected depending on your Kubernetes API server instance version and configuration.'),
('10505',NULL,'Kubernetes Controller manager by HTTP','3','-1','2','','','Kubernetes Controller manager by HTTP','0',NULL,'Get Kubernetes Controller manager metrics by HTTP agent from Prometheus metrics endpoint.\r\n\r\nDon\'t forget change macros {$KUBE.API.SERVER.URL}.\r\nSome metrics may not be collected depending on your Kubernetes Controller manager instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2420a8a4fda74fbc81743aed69fafa3b','KUBERNETES CONTROLLER MANAGER BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThe template to monitor Kubernetes Controller manager by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nTemplate `Kubernetes Controller manager by HTTP` - collects metrics by HTTP agent from Controller manager /metrics endpoint.\r\n\r\n## Setup\r\n\r\nInternal service metrics are collected from /metrics endpoint.\r\nTemplate needs to use Authorization via API token.\r\n\r\nSet the following fields: `Metrics endpoint URL`, `API Authorization Token`.\r\n\r\n*NOTE.* You might need to set the `--binding-address` option for Controller Manager to the address where Zabbix proxy can reach it.\r\nFor example, for clusters created with `kubeadm` it can be set in the following manifest file (changes will be applied immediately):\r\n\r\n- /etc/kubernetes/manifests/kube-controller-manager.yaml\r\n\r\n*NOTE.* Some metrics may not be collected depending on your Kubernetes Controller manager instance version and configuration.'),
('10506',NULL,'Kubernetes Kubelet by HTTP','3','-1','2','','','Kubernetes Kubelet by HTTP','0',NULL,'Get Kubernetes kubelet metrics by HTTP agent from Prometheus metrics endpoint.\r\n\r\nDon\'t forget change macros {$KUBE.KUBELET.URL}, {$KUBE.API.TOKEN}.\r\nSome metrics may not be collected depending on your Kubernetes API server instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e785916967c14544b59c3644c3edda3a','KUBERNETES KUBELET BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThe template to monitor Kubernetes Kubelet by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nTemplate `Kubernetes Kubelet by HTTP` - collects metrics by HTTP agent from Kubelet /metrics endpoint.\r\n\r\n## Setup\r\n\r\nInternal service metrics are collected from /metrics endpoint.\r\nTemplate needs to use Authorization via API token.\r\n\r\nSet the following fields: `Kubelet URL`, `API Authorization Token`.\r\n\r\n*NOTE.* Some metrics may not be collected depending on your Kubernetes instance version and configuration.'),
('10507',NULL,'Kubernetes nodes by HTTP','3','-1','2','','','Kubernetes nodes by HTTP','0',NULL,'Get Kubernetes nodes metrics by HTTP.\r\nMetrics are collected by requests to Kubernetes API.\r\n\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f397be2340734d24bc666102fbe184a5','KUBERNETES NODES BY HTTP','Zabbix','7.4-3',NULL,'0','1','## Overview\r\n\r\nThe template to monitor Kubernetes nodes that work without any external scripts.\r\nIt works without external scripts and uses the script item to make HTTP requests to the Kubernetes API.\r\n\r\nChange the values according to the environment in the file $HOME/zabbix_values.yaml.\r\n\r\nFor example:\r\n\r\n -  ## Enables use of **Zabbix proxy**\r\n    enabled: false\r\n\r\nSet the field: `Kubernetes API URL` such as `<scheme>://<host>:<port>`.\r\n\r\nGet the generated service account token using the command\r\n\r\n`kubectl get secret zabbix-service-account -n monitoring -o jsonpath={.data.token} | base64 -d`\r\n\r\nThen set it to the field: `API Authorization Token`.\r\n\r\nSet up the fields to filter the metrics of discovered nodes\r\n\r\n\r\n## Setup\r\n\r\nInstall the [Zabbix Helm Chart](https://git.zabbix.com/projects/ZT/repos/kubernetes-helm/browse?at=refs%2Fheads%2Fmaster) in your Kubernetes cluster.\r\n\r\nSet the following fields: `Kubernetes API URL` such as `<scheme>://<host>:<port>`.\r\n\r\nGet the generated service account token using the command\r\n\r\n`kubectl get secret zabbix-service-account -n monitoring -o jsonpath={.data.token} | base64 -d`\r\n\r\nThen set it to the field: `API Authorization Token`.\r\n\r\nSet `Nodes Endpoint Name` with Zabbix agent\'s endpoint name. See `kubectl -n monitoring get ep`. Default: `zabbix-zabbix-helm-chrt-agent`.\r\n\r\nSet up the fields to filter the metrics of discovered nodes and host creation based on host prototypes:\r\n\r\n- `Node Matches Filter`\r\n- `Node Exclusion Filter`\r\n- `Node Role Matches Filter`\r\n- `Node Role Exclusion Filter`\r\n\r\nSet up fields to filter pod metrics by namespace:\r\n\r\n- `Pod Namespace Matches Filter`\r\n- `Pod Namespace Exclusion Filter`\r\n\r\n**Note**, If you have a large cluster, it is highly recommended to set a filter for discoverable pods.\r\n\r\nYou can use the `Node Labels Filter`, `Pod Labels Filter`, `Node Annotations Filter` and `Pod Annotations Filter` fields for advanced filtering of nodes and pods by labels and annotations.\r\n\r\nNotes about labels and annotations filters:\r\n\r\n- Values should be specified separated by commas and must have the key/value form with support for regular expressions in the value (`key1: value, key2: regexp`).\r\n- ECMAScript syntax is used for regular expressions.\r\n- Filters are applied if such a label key exists for the entity that is being filtered (it means that if you specify a key in a filter, entities which do not have this key will not be affected by the filter and will still be discovered, and only entities containing that key will be filtered by the value).\r\n- You can also use the exclamation point symbol (`!`) to invert the filter (`!key: value`).\r\n\r\nFor example: `kubernetes.io/hostname: kubernetes-node[5-25], !node-role.kubernetes.io/ingress: .*`. As a result, the nodes 5-25 without the "ingress" role will be discovered.\r\n\r\n\r\nSee the Kubernetes documentation for details about labels and annotations:\r\n\r\n- <https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/>\r\n- <https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/>\r\n\r\n**Note**, the discovered nodes will be created as separate hosts in Zabbix with the Linux template automatically assigned to them.'),
('10509',NULL,'Kubernetes Scheduler by HTTP','3','-1','2','','','Kubernetes Scheduler by HTTP','0',NULL,'Get Kubernetes Scheduler metrics by HTTP agent from Prometheus metrics endpoint.\r\n\r\nDon\'t forget change macros {$KUBE.API.SERVER.URL}.\r\nSome metrics may not be collected depending on your Kubernetes Scheduler instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ece96efdf0a045b99ede7978fa9366d6','KUBERNETES SCHEDULER BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThe template to monitor Kubernetes Scheduler by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nTemplate `Kubernetes Scheduler by HTTP` - collects metrics by HTTP agent from Scheduler /metrics endpoint.\r\n\r\n## Setup\r\n\r\nInternal service metrics are collected from /metrics endpoint.\r\nTemplate needs to use Authorization via API token.\r\n\r\nSet the following fields: `Scheduler metrics endpoint URL`, `API Authorization Token`.\r\n\r\n*NOTE.* You might need to set the `--binding-address` option for Scheduler to the address where Zabbix proxy can reach it.\r\nFor example, for clusters created with `kubeadm` it can be set in the following manifest file (changes will be applied immediately):\r\n\r\n- /etc/kubernetes/manifests/kube-scheduler.yaml\r\n\r\n*NOTE.* Some metrics may not be collected depending on your Kubernetes Scheduler instance version and configuration.'),
('10510',NULL,'Kubernetes cluster state by HTTP','3','-1','2','','','Kubernetes cluster state by HTTP','0',NULL,'Get Kubernetes state metrics by HTTP.\r\nMetrics are collected by requests to Kubernetes API.\r\n\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','07695028a2ba4b66a5414797bec791df','KUBERNETES CLUSTER STATE BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThe template to monitor Kubernetes state.\r\nIt works without external scripts and uses the script item to make HTTP requests to the Kubernetes API.\r\n\r\nTemplate `Kubernetes cluster state by HTTP` - collects metrics by HTTP agent from kube-state-metrics endpoint and Kubernetes API.\r\n\r\n*NOTE.* Some metrics may not be collected depending on your Kubernetes version and configuration.\r\n\r\n## Setup\r\n\r\nInstall the [Zabbix Helm Chart](https://git.zabbix.com/projects/ZT/repos/kubernetes-helm/browse?at=refs%2Fheads%2Fmaster) in your Kubernetes cluster.\r\nInternal service metrics are collected from kube-state-metrics endpoint.\r\n\r\nTemplate needs to use authorization via API token.\r\n\r\nSet the `Kubernetes API URL` such as `<scheme>://<host>:<port>`.\r\n\r\nGet the generated service account token using the command:\r\n\r\n`kubectl get secret zabbix-service-account -n monitoring -o jsonpath={.data.token} | base64 -d`\r\n\r\nThen set it to the field: `API Authorization Token`.\r\nSet `State Endpoint Name` with Kube state metrics endpoint name. See `kubectl -n monitoring get ep`. Default: `zabbix-kube-state-metrics`.\r\n\r\n*NOTE.* If you wish to monitor Controller Manager and Scheduler components, you might need to set the `--binding-address` option for them to the address where Zabbix proxy can reach them.\r\nFor example, for clusters created with `kubeadm` it can be set in the following manifest files (changes will be applied immediately):\r\n\r\n- /etc/kubernetes/manifests/kube-controller-manager.yaml\r\n- /etc/kubernetes/manifests/kube-scheduler.yaml\r\n\r\nDepending on your Kubernetes distribution, you might need to adjust `Control Plane Taint` field (for example, set it to `node-role.kubernetes.io/master` for OpenShift).\r\n\r\n*NOTE.* Some metrics may not be collected depending on your Kubernetes version and configuration.\r\n\r\nSet up the fields to filter the metrics of discovered Kubelets by node names:\r\n\r\n- `Kubelet Node Matches Filter`\r\n- `Kubelet Node Exclude Filter`\r\n\r\nSet up fields to filter metrics by namespace:\r\n\r\n- `Namespace Matches Filter`\r\n- `Namespace Exclude Filter`\r\n\r\nSet up fields to filter node metrics by nodename:\r\n\r\n- `Node Matches Filter`\r\n- `Node Exclude Filter`\r\n\r\n**Note**: If you have a large cluster, it is highly recommended to set a filter for discoverable namespaces.\r\n\r\nYou can use the `Kubelet Labels Filter` and `Kubelet Annotations Filter` fields for advanced filtering of kubelets by node labels and annotations.\r\n\r\nNotes about labels and annotations filters:\r\n\r\n- Values should be specified separated by commas and must have the key/value form with support for regular expressions in the value (`key1: value, key2: regexp`).\r\n- ECMAScript syntax is used for regular expressions.\r\n- Filters are applied if such label key exists for the entity that is being filtered (it means that if you specify a key in the filter, entities that do not have this key will not be affected by the filter and will still be discovered, and only entities containing that key will be filtered by the value).\r\n- You can also use the exclamation point symbol (`!`) to invert the filter (`!key: value`).\r\n\r\nFor example: `kubernetes.io/hostname: kubernetes-node[5-25], !node-role.kubernetes.io/ingress: .*`. As a result, the kubelets on nodes 5-25 without the "ingress" role will be discovered.\r\n\r\n\r\nSee the Kubernetes documentation for details about labels and annotations:\r\n\r\n- <https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/>\r\n- <https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/>\r\n\r\nYou can also set up evaluation periods for replica mismatch triggers (Deployments, ReplicaSets, StatefulSets) with the field `Replica Mismatch Evaluation Period`, which supports context and regular expressions.'),
('10515',NULL,'PFSense by SNMP','3','-1','2','','','PFSense by SNMP','0',NULL,'Template for monitoring pfSense by SNMP\r\nSetup:\r\n  1. Enable SNMP daemon at Services in pfSense web interface https://docs.netgate.com/pfsense/en/latest/services/snmp.html\r\n  2. Setup firewall rule to get access from Zabbix proxy or Zabbix server by SNMP https://docs.netgate.com/pfsense/en/latest/firewall/index.html#managing-firewall-rules\r\n  3. Link template to the host\r\n\r\n\r\nMIBs used:\r\nBEGEMOT-PF-MIB\r\nHOST-RESOURCES-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','16f281aeb8904d3db8b66dda94611fcc','PFSENSE BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10516',NULL,'OpenWeatherMap by HTTP','3','-1','2','','','OpenWeatherMap by HTTP','0',NULL,'Get weather metrics from OpenWeatherMap current weather API by HTTP.\r\nIt works without any external scripts and uses the Script item.\r\n\r\nSetup:\r\n  1. Create a host.\r\n\r\n  2. Link the template to the host.\r\n\r\n  3. Customize the values of {$OPENWEATHERMAP.API.TOKEN} and {$LOCATION} macros.  \r\n      OpenWeatherMap API Tokens are available in your OpenWeatherMap account https://home.openweathermap.org/api_keys.  \r\n      Locations can be set by few ways:\r\n        - by geo coordinates (for example: 56.95,24.0833)\r\n        - by location name (for example: Riga)\r\n        - by location ID. Link to the list of city ID: http://bulk.openweathermap.org/sample/city.list.json.gz\r\n        - by zip/post code with a country code (for example: 94040,us)\r\n      A few locations can be added to the macro at the same time by "|" delimiter. \r\n      For example: 43.81821,7.76115|Riga|2643743|94040,us.\r\n      Please note that API requests by city name, zip-codes and city id will be deprecated soon.\r\n      \r\n      Language and units macros can be customized too if necessary.\r\n      List of available languages: https://openweathermap.org/current#multi.\r\n      Available units of measurement are: standard, metric and imperial https://openweathermap.org/current#data.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8098b3c157ab456abd55d3840eef79c1','OPENWEATHERMAP BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10517',NULL,'Proxmox VE by HTTP','3','-1','2','','','Proxmox VE by HTTP','0',NULL,'This template is designed for the effortless deployment of Proxmox VE monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n\r\nProxmox VE uses a REST like API. The concept is described in Resource Oriented Architecture (ROA).\r\n\r\nCheck the API documentation for details:\r\nhttps://pve.proxmox.com/pve-docs/api-viewer/index.html\r\n\r\nSetup:\r\n\r\n1. Create an API token for the monitoring user. Important note: for security reasons, it is recommended to create a separate user (Datacenter - Permissions).\r\n\r\nPlease provide the necessary access levels for both the User and the Token:\r\n\r\n* Check: ["perm","/",["Sys.Audit"]]\r\n* Check: ["perm","/storage",["Datastore.Audit"]]\r\n* Check: ["perm","/vms",["VM.Audit"]]\r\n\r\n2. Copy the resulting Token ID and Secret into the host macros \'{$PVE.TOKEN.ID}\' and \'{$PVE.TOKEN.SECRET}\'.\r\n\r\n3. Set the hostname or IP address of the Proxmox VE API host in the \'{$PVE.URL.HOST}\' macro. You can also change the API port in the \'{$PVE.URL.PORT}\' macro if necessary.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4958b76448d74ff1b6d7d6280449beee','PROXMOX VE BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10518',NULL,'TrueNAS CORE by SNMP','3','-1','2','','','TrueNAS CORE by SNMP','0',NULL,'Template for monitoring TrueNAS CORE by SNMP.\r\n\r\nSetup:\r\n1. Import the template into Zabbix.\r\n2. Enable SNMP daemon at Services in TrueNAS CORE web interface: https://www.truenas.com/docs/core/uireference/services/snmpscreen/\r\n3. Link the template to the host.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nUCD-DISKIO-MIB\r\nUCD-SNMP-MIB\r\nFREENAS-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','28e31ef9402d4c1ba2fbc730a288d2d8','TRUENAS CORE BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10519',NULL,'CockroachDB by HTTP','3','-1','2','','','CockroachDB by HTTP','0',NULL,'The template to monitor CockroachDB nodes by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template collects metrics by HTTP agent from Prometheus endpoint and health endpoints.\r\n\r\nInternal node metrics are collected from Prometheus /_status/vars endpoint.\r\nNode health metrics are collected from /health and /health?ready=1 endpoints.\r\nThe template doesn\'t require usage of session token.\r\n\r\nNote, that some metrics may not be collected depending on your CockroachDB version and configuration.\r\n\r\nSetup:\r\n\r\nSet the hostname or IP address of the CockroachDB node host in the \'{$COCKROACHDB.API.HOST}\' macro. You can also change the port in the \'{$COCKROACHDB.API.PORT}\' macro and the scheme in the \'{$COCKROACHDB.API.SCHEME}\' macro if necessary.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','36116d8675da47b8a678193969d5a787','COCKROACHDB BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10520',NULL,'Envoy Proxy by HTTP','3','-1','2','','','Envoy Proxy by HTTP','0',NULL,'Get Envoy Proxy metrics by HTTP agent from metrics endpoint.\r\nhttps://www.envoyproxy.io/docs/envoy/v1.20.0/operations/stats_overview\r\n\r\nDon\'t forget to change macros {$ENVOY.URL}, {$ENVOY.METRICS.PATH}.\r\nSome metrics may not be collected depending on your Envoy Proxy instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0368ca599bbb49729587b9c43ac83084','ENVOY PROXY BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10521',NULL,'HashiCorp Consul Node by HTTP','3','-1','2','','','HashiCorp Consul Node by HTTP','0',NULL,'Get HashiCorp Consul Node metrics by HTTP agent from metrics endpoint.\r\n\r\nDon\'t forget to change macros {$CONSUL.NODE.API.URL}, {$CONSUL.TOKEN}.\r\nSome metrics may not be collected depending on your HashiCorp Consul instance version and configuration.\r\nMore information about metrics you can find in official documentation: https://www.consul.io/docs/agent/telemetry\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','884bdbeea93c4be0a11a2c92a5f8adce','HASHICORP CONSUL NODE BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10522',NULL,'HashiCorp Consul Cluster by HTTP','3','-1','2','','','HashiCorp Consul Cluster by HTTP','0',NULL,'Get HashiCorp Consul Cluster services and nodes by HTTP agent from API endpoints.\r\n\r\nDon\'t forget to change macros {$CONSUL.CLUSTER.URL}, {$CONSUL.TOKEN}.\r\nSome metrics may not be collected depending on your HashiCorp Consul instance version and configuration.\r\nMore information about metrics you can find in official documentation: https://www.consul.io/docs/agent/telemetry\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3db29bb6b2b14fa289ba7915264efcdf','HASHICORP CONSUL CLUSTER BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10524',NULL,'HPE MSA 2040 Storage by HTTP','3','-1','2','','','HPE MSA 2040 Storage by HTTP','0',NULL,'The template to monitor HPE MSA 2040 by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n1. Create a user with a monitor role on the storage, for example "zabbix".\r\n2. Link the template to a host.\r\n3. Set the hostname or IP address of the host in the {$HPE.MSA.API.HOST} macro and configure the username and password in the {$HPE.MSA.API.USERNAME} and {$HPE.MSA.API.PASSWORD} macros.\r\n4. Change the {$HPE.MSA.API.SCHEME} and {$HPE.MSA.API.PORT} macros if needed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','be10b1140fce4cc08247260b71bcd037','HPE MSA 2040 STORAGE BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10525',NULL,'HPE MSA 2060 Storage by HTTP','3','-1','2','','','HPE MSA 2060 Storage by HTTP','0',NULL,'The template to monitor HPE MSA 2060 by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n1. Create a user with a monitor role on the storage, for example "zabbix".\r\n2. Link the template to a host.\r\n3. Set the hostname or IP address of the host in the {$HPE.MSA.API.HOST} macro and configure the username and password in the {$HPE.MSA.API.USERNAME} and {$HPE.MSA.API.PASSWORD} macros.\r\n4. Change the {$HPE.MSA.API.SCHEME} and {$HPE.MSA.API.PORT} macros if needed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','10537641cfa3416ab0f1451cdb61d804','HPE MSA 2060 STORAGE BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10526',NULL,'HPE Primera by HTTP','3','-1','2','','','HPE Primera by HTTP','0',NULL,'The template to monitor HPE Primera by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create a user on the storage with a browse role and enable it for all domains, for example "zabbix".\r\n  2. The WSAPI server does not start automatically.\r\n     - Log in to the CLI as Super, Service, or any role granted the wsapi_set right.\r\n     - Start the WSAPI server by command: `startwsapi`.\r\n     - To check WSAPI state use command: `showwsapi`.\r\n  3. Link template to the host.\r\n  4. Set the hostname or IP address of the host in the {$HPE.PRIMERA.API.HOST} macro and configure the username and password in the {$HPE.PRIMERA.API.USERNAME} and {$HPE.PRIMERA.API.PASSWORD} macros.\r\n  5. Change the {$HPE.PRIMERA.API.SCHEME} and {$HPE.PRIMERA.API.PORT} macros if needed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b8750c02b5624c6889979b129735bd56','HPE PRIMERA BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10527',NULL,'AWS EC2 by HTTP','3','-1','2','','','AWS EC2 by HTTP','0',NULL,'Get AWS EC2 and attached AWS EBS volumes metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7af6d68b223a43d4bf8526cc5dc3fe2e','AWS EC2 BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThe template to monitor AWS EC2 and attached AWS EBS volumes by HTTP via Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n*NOTE*\r\nThis template uses the GetMetricData CloudWatch API calls to list and retrieve metrics.\r\nFor more information, please refer to the [CloudWatch pricing](https://aws.amazon.com/cloudwatch/pricing/) page.\r\n\r\nAdditional information about metrics and used API methods:\r\n* [Full metrics list related to EBS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html)\r\n* [Full metrics list related to EC2](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html)\r\n* [DescribeAlarms API method](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)\r\n* [DescribeVolumes API method](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumes.html)\r\n\r\n\r\n## Setup\r\n\r\nThe template get AWS EC2 and attached AWS EBS volumes metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\n\r\nBefore using the template, you need to create an IAM policy with the necessary permissions for the Zabbix role in your AWS account.\r\n\r\n### Required Permissions\r\nAdd the following required permissions to your Zabbix IAM policy in order to collect Amazon EC2 metrics.\r\n\r\n```json\r\n{\r\n    "Version":"2012-10-17",\r\n    "Statement":[\r\n        {\r\n          "Action":[\r\n              "ec2:DescribeVolumes",\r\n              "cloudwatch:"DescribeAlarms",\r\n              "cloudwatch:GetMetricData"\r\n          ],\r\n          "Effect":"Allow",\r\n          "Resource":"*"\r\n        }\r\n    ]\r\n  }\r\n```\r\n\r\n### Access Key Authorization\r\n\r\nIf you are using access key authorization, you need to generate an access key and secret key for an IAM user with the necessary permissions:\r\n\r\n1. Create an IAM user with programmatic access.\r\n2. Attach the required policy to the IAM user.\r\n3. Generate an access key and secret key.\r\n4. Use the generated credentials in the macros `Access key ID` and `Secret access key`.\r\n\r\n### Assume Role Authorization\r\nFor using assume role authorization, add the appropriate permissions to the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "sts:AssumeRole",\r\n            "Resource": "arn:aws:iam::{Account}:user/{UserName}"\r\n        },\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "ec2:DescribeVolumes",\r\n                "cloudwatch:"DescribeAlarms",\r\n                "cloudwatch:GetMetricData"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Assume Role Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n  "Version": "2012-10-17",\r\n  "Statement": [\r\n    {\r\n      "Effect": "Allow",\r\n      "Principal": {\r\n        "AWS": "arn:aws:iam::{Account}:user/{UserName}"\r\n      },\r\n      "Action": "sts:AssumeRole"\r\n    }\r\n  ]\r\n}\r\n```\r\nSet the following fields: `Access key ID`, `Secret access key`, `STS Region`, `ARN assume role`.\r\n\r\n### Role-Based Authorization\r\nIf you are using role-based authorization, set the appropriate permissions:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "iam:PassRole",\r\n            "Resource": "arn:aws:iam::<<--account-id-->>:role/<<--role_name-->>"\r\n        },\r\n        {\r\n            "Sid": "VisualEditor1",\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "ec2:DescribeVolumes",\r\n                "cloudwatch:"DescribeAlarms",\r\n                "cloudwatch:GetMetricData"\r\n                "ec2:AssociateIamInstanceProfile",\r\n                "ec2:ReplaceIamInstanceProfileAssociation"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Role-Based Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Principal": {\r\n                "Service": [\r\n                    "ec2.amazonaws.com"\r\n                ]\r\n            },\r\n            "Action": [\r\n                "sts:AssumeRole"\r\n            ]\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n**Note**: Using role-based authorization is only possible when you use a Zabbix server or proxy inside AWS.\r\n\r\nFor more information, see the [EC2 policies](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-iam.html) on the AWS website.\r\n\r\nSet the following fields: `Authorization method`, `AWS Region`, `EC2 instance ID`.\r\n\r\nFor more information about manage access keys, see [official documentation](https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys)\r\n\r\nAlso, see the Macros section for a list of macros used for LLD filters.'),
('10528',NULL,'OPNsense by SNMP','3','-1','2','','','OPNsense by SNMP','0',NULL,'Template for monitoring OPNsense by SNMP\r\nSetup:\r\n  1. Enable bsnmpd daemon by creating new config file "/etc/rc.conf.d/bsnmpd" with the following content:\r\n  bsnmpd_enable="YES"\r\n  2. Uncomment the following lines in "/etc/snmpd.config" file to enable required SNMP modules:\r\n  begemotSnmpdModulePath."hostres" = "/usr/lib/snmp_hostres.so"\r\n  begemotSnmpdModulePath."pf"     = "/usr/lib/snmp_pf.so"\r\n  3. Start bsnmpd daemon with the following command:\r\n  /etc/rc.d/bsnmpd start\r\n  4. Setup a firewall rule to get access from Zabbix proxy or Zabbix server by SNMP (https://docs.opnsense.org/manual/firewall.html).\r\n  5. Link the template to a host.\r\n\r\n\r\nMIBs used:\r\nBEGEMOT-PF-MIB\r\nHOST-RESOURCES-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0c94915edb4c41bf8c627dddb4f68f5a','OPNSENSE BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10529',NULL,'AWS RDS instance by HTTP','3','-1','2','','','AWS RDS instance by HTTP','0',NULL,'The template gets AWS RDS instance metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c6d9475847f44d9193f8253e5995b8f8','AWS RDS INSTANCE BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThe template to monitor AWS RDS instance by HTTP via Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n*NOTE*\r\nThis template uses the GetMetricData CloudWatch API calls to list and retrieve metrics.\r\nFor more information, please refer to the [CloudWatch pricing](https://aws.amazon.com/cloudwatch/pricing/) page.\r\n\r\nAdditional information about metrics and used API methods:\r\n\r\n* [Full metrics list related to RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-metrics.html)\r\n* [Full metrics list related to Amazon Aurora](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.AuroraMySQL.Monitoring.Metrics.html#Aurora.AuroraMySQL.Monitoring.Metrics.instances)\r\n* [DescribeAlarms API method](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)\r\n\r\n\r\n## Setup\r\n\r\nThe template get AWS RDS instance metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\n\r\nBefore using the template, you need to create an IAM policy with the necessary permissions for the Zabbix role in your AWS account.\r\n\r\n### Required Permissions\r\nAdd the following required permissions to your Zabbix IAM policy in order to collect Amazon RDS metrics.\r\n\r\n```json\r\n{\r\n    "Version":"2012-10-17",\r\n    "Statement":[\r\n        {\r\n          "Action":[\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "rds:DescribeEvents",\r\n                "rds:DescribeDBInstances"\r\n          ],\r\n          "Effect":"Allow",\r\n          "Resource":"*"\r\n        }\r\n    ]\r\n  }\r\n```\r\n\r\n### Access Key Authorization\r\n\r\nIf you are using access key authorization, you need to generate an access key and secret key for an IAM user with the necessary permissions:\r\n\r\n1. Create an IAM user with programmatic access.\r\n2. Attach the required policy to the IAM user.\r\n3. Generate an access key and secret key.\r\n4. Use the generated credentials in the macros `Access key ID` and `Secret access key`.\r\n\r\n### Assume Role Authorization\r\nFor using assume role authorization, add the appropriate permissions to the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "sts:AssumeRole",\r\n            "Resource": "arn:aws:iam::{Account}:user/{UserName}"\r\n        },\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "rds:DescribeEvents",\r\n                "rds:DescribeDBInstances"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Assume Role Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n  "Version": "2012-10-17",\r\n  "Statement": [\r\n    {\r\n      "Effect": "Allow",\r\n      "Principal": {\r\n        "AWS": "arn:aws:iam::{Account}:user/{UserName}"\r\n      },\r\n      "Action": "sts:AssumeRole"\r\n    }\r\n  ]\r\n}\r\n```\r\nSet the following fields: `Access key ID`, `Secret access key`, `STS Region`, `ARN assume role`.\r\n\r\n### Role-Based Authorization\r\nIf you are using role-based authorization, set the appropriate permissions:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "iam:PassRole",\r\n            "Resource": "arn:aws:iam::<<--account-id-->>:role/<<--role_name-->>"\r\n        },\r\n        {\r\n            "Sid": "VisualEditor1",\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "rds:DescribeEvents",\r\n                "rds:DescribeDBInstances",\r\n                "ec2:AssociateIamInstanceProfile",\r\n                "ec2:ReplaceIamInstanceProfileAssociation"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Role-Based Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Principal": {\r\n                "Service": [\r\n                    "ec2.amazonaws.com"\r\n                ]\r\n            },\r\n            "Action": [\r\n                "sts:AssumeRole"\r\n            ]\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n**Note**: Using role-based authorization is only possible when you use a Zabbix server or proxy inside AWS.\r\n\r\nSet the following fields: `Authorization method`, `AWS Region`, `RDS DB Instance identifier`.\r\n\r\nFor more information about manage access keys, see [official documentation](https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys)\r\n\r\nAlso, see the Macros section for a list of macros used for LLD filters.'),
('10530',NULL,'AWS S3 bucket by HTTP','3','-1','2','','','AWS S3 bucket by HTTP','0',NULL,'The template gets AWS S3 bucket metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a14ab6b4e80643fe8daa9d7288658f79','AWS S3 BUCKET BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThe template to monitor AWS S3 bucket by HTTP via Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n*NOTE*\r\nThis template uses the GetMetricData CloudWatch API calls to list and retrieve metrics.\r\nFor more information, please refer to the [CloudWatch pricing](https://aws.amazon.com/cloudwatch/pricing/) page.\r\n\r\nAdditional information about metrics and used API methods:\r\n\r\n* [Full metrics list related to S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/metrics-dimensions.html)\r\n* [DescribeAlarms API method](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)\r\n\r\n## Setup\r\n\r\nThe template gets AWS S3 metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\n\r\nBefore using the template, you need to create an IAM policy for the Zabbix role in your AWS account with the necessary permissions.\r\n\r\n### Required Permissions\r\nAdd the following required permissions to your Zabbix IAM policy in order to collect Amazon S3 metrics.\r\n\r\n```json\r\n{\r\n    "Version":"2012-10-17",\r\n    "Statement":[\r\n        {\r\n          "Action":[\r\n              "cloudwatch:DescribeAlarms",\r\n              "cloudwatch:GetMetricData",\r\n              "s3:GetMetricsConfiguration"\r\n          ],\r\n          "Effect":"Allow",\r\n          "Resource":"*"\r\n        }\r\n    ]\r\n  }\r\n```\r\n\r\n### Access Key Authorization\r\n\r\nIf you are using access key authorization, you need to generate an access key and secret key for an IAM user with the necessary permissions:\r\n\r\n1. Create an IAM user with programmatic access.\r\n2. Attach the required policy to the IAM user.\r\n3. Generate an access key and secret key.\r\n4. Use the generated credentials in the macros `Access key ID` and `Secret access key`.\r\n\r\n### Assume role authorization\r\nFor using assume role authorization, add the appropriate permissions to the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "sts:AssumeRole",\r\n            "Resource": "arn:aws:iam::{Account}:user/{UserName}"\r\n        },\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "s3:GetMetricsConfiguration"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Assume Role Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n  "Version": "2012-10-17",\r\n  "Statement": [\r\n    {\r\n      "Effect": "Allow",\r\n      "Principal": {\r\n        "AWS": "arn:aws:iam::{Account}:user/{UserName}"\r\n      },\r\n      "Action": "sts:AssumeRole"\r\n    }\r\n  ]\r\n}\r\n```\r\nSet the following fields: `Access key ID`, `Secret access key`, `STS Region`, `ARN assume role`.\r\n\r\n### Role-Based Authorization\r\nIf you are using role-based authorization, set the appropriate permissions:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "iam:PassRole",\r\n            "Resource": "arn:aws:iam::<<--account-id-->>:role/<<--role_name-->>"\r\n        },\r\n        {\r\n            "Sid": "VisualEditor1",\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "s3:GetMetricsConfiguration",\r\n                "ec2:AssociateIamInstanceProfile",\r\n                "ec2:ReplaceIamInstanceProfileAssociation"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Role-Based Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Principal": {\r\n                "Service": [\r\n                    "ec2.amazonaws.com"\r\n                ]\r\n            },\r\n            "Action": [\r\n                "sts:AssumeRole"\r\n            ]\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n**Note**: Using role-based authorization is only possible when you use a Zabbix server or proxy inside AWS.\r\n\r\nTo gather Request metrics, [enable Requests metrics](https://docs.aws.amazon.com/AmazonS3/latest/userguide/cloudwatch-monitoring.html) on your Amazon S3 buckets from the AWS console.\r\n\r\nYou can also define a filter for the Request metrics using a shared prefix, object tag, or access point.\r\n\r\nSet the following fields: `Authorization method`, `S3 bucket name`.\r\n\r\nFor more information about manage access keys, see [official documentation](https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys)\r\n\r\nAlso, see the Macros section for a list of macros used for LLD filters.'),
('10531',NULL,'Azure by HTTP','3','-1','2','','','Azure by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure by HTTP.\r\nIt works without any external scripts and uses the script item.\r\nCurrently the template supports the discovery of virtual machines (VMs), Cosmos DB for MongoDB, storage accounts, Microsoft SQL, MySQL, and PostgreSQL servers.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: `{$AZURE.APP.ID}`, `{$AZURE.PASSWORD}`, `{$AZURE.TENANT.ID}`, and `{$AZURE.SUBSCRIPTION.ID}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fa58228fee8a4e34a7c6503950d1c615','AZURE BY HTTP','Zabbix','7.4-4',NULL,'0','1','## Overview\r\n\r\n- This template is designed to monitor Microsoft Azure by HTTP.\r\n- It works without any external scripts and uses the script item.\r\n- Currently, the template supports the discovery of virtual machines (VMs), VM scale sets, Cosmos DB for MongoDB, storage accounts, Microsoft SQL, MySQL, and PostgreSQL servers.\r\n\r\n## Setup\r\n\r\n1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n\r\n      `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n\r\n> See [Azure documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli) for more details.\r\n\r\n2. Link the template to a host.\r\n3. Configure the macros: `Azure App ID`, `Azure password`, `Azure tenant ID`, `Azure subscription ID`.'),
('10532',NULL,'Azure Virtual Machine by HTTP','3','-1','2','','','Azure Virtual Machine by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure virtual machines (VMs) by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','820fa4a1565c43e4aac07a691a5bface','AZURE VIRTUAL MACHINE BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor Microsoft Azure virtual machines (VMs) by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\n## Setup\r\n\r\n1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n\r\n      `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n\r\n> See [Azure documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli) for more details.\r\n\r\n2. Link the template to a host.\r\n3. Configure the macros: `Azure App ID`, `Azure password`, `Azure tenant ID`, `Azure subscription ID`, and `Azure virtual machine ID`.'),
('10534',NULL,'HPE Synergy by HTTP','3','-1','2','','','HPE Synergy by HTTP','0',NULL,'This template is designed to monitor HPE Synergy by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Link template to the host.\r\n  2. Set the hostname or IP address of the host in the {$HPE.SYNERGY.API.HOST} macro and configure the username and password in the {$HPE.SYNERGY.API.USERNAME} and {$HPE.SYNERGY.API.PASSWORD} macros.\r\n  3. Change the {$HPE.SYNERGY.API.SCHEME} and {$HPE.SYNERGY.API.PORT} macros if needed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0ffde4421f524bcbac2f47fec87c0f95','HPE SYNERGY BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10535',NULL,'AWS by HTTP','3','-1','2','','','AWS by HTTP','0',NULL,'Get AWS EC2, RDS and S3 instances, AWS ECS clusters, AWS Elastic Load Balancing. Don\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c60e5929ab474f67bbe67dc6b04e709d','AWS BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis template is designed for the effortless deployment of AWS monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n- Currently, the template supports the discovery of EC2 and RDS instances, ECS clusters, ELB, Lambda and S3 buckets.\r\n\r\n## Setup\r\n\r\nBefore using the template, you need to create an IAM policy for the Zabbix role in your AWS account with the necessary permissions.\r\n\r\n### Required Permissions\r\nAdd the following required permissions to your Zabbix IAM policy in order to collect metrics.\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "ec2:DescribeInstances",\r\n                "ec2:DescribeVolumes",\r\n                "ec2:DescribeRegions",\r\n                "rds:DescribeEvents",\r\n                "rds:DescribeDBInstances",\r\n                "ecs:DescribeClusters",\r\n                "ecs:ListServices",\r\n                "ecs:ListTasks",\r\n                "ecs:ListClusters",\r\n                "s3:ListAllMyBuckets",\r\n                "s3:GetBucketLocation",\r\n                "s3:GetMetricsConfiguration",\r\n                "elasticloadbalancing:DescribeLoadBalancers",\r\n                "elasticloadbalancing:DescribeTargetGroups",\r\n                "ec2:DescribeSecurityGroups",\r\n                "lambda:ListFunctions"\r\n            ],\r\n            "Effect": "Allow",\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n### Access Key Authorization\r\n\r\nIf you are using access key authorization, you need to generate an access key and secret key for an IAM user with the necessary permissions:\r\n\r\n1. Create an IAM user with programmatic access.\r\n2. Attach the required policy to the IAM user.\r\n3. Generate an access key and secret key.\r\n4. Use the generated credentials in `Access key ID` and `Secret access key`.\r\n\r\n### Assume Role Authorization\r\nFor using assume role authorization, add the appropriate permissions to the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "sts:AssumeRole",\r\n            "Resource": "arn:aws:iam::{Account}:user/{UserName}"\r\n        },\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "ec2:DescribeInstances",\r\n                "ec2:DescribeVolumes",\r\n                "ec2:DescribeRegions",\r\n                "rds:DescribeEvents",\r\n                "rds:DescribeDBInstances",\r\n                "ecs:DescribeClusters",\r\n                "ecs:ListServices",\r\n                "ecs:ListTasks",\r\n                "ecs:ListClusters",\r\n                "s3:ListAllMyBuckets",\r\n                "s3:GetBucketLocation",\r\n                "s3:GetMetricsConfiguration",\r\n                "ec2:AssociateIamInstanceProfile",\r\n                "ec2:ReplaceIamInstanceProfileAssociation",\r\n                "elasticloadbalancing:DescribeLoadBalancers",\r\n                "elasticloadbalancing:DescribeTargetGroups",\r\n                "ec2:DescribeSecurityGroups",\r\n                "lambda:ListFunctions"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Assume Role Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n  "Version": "2012-10-17",\r\n  "Statement": [\r\n    {\r\n      "Effect": "Allow",\r\n      "Principal": {\r\n        "AWS": "arn:aws:iam::{Account}:user/{UserName}"\r\n      },\r\n      "Action": "sts:AssumeRole"\r\n    }\r\n  ]\r\n}\r\n```\r\nSet the following fields: `Access key ID`, `Secret access key`, `STS Region`, `ARN assume role`.\r\n\r\n### Role-Based Authorization\r\nIf you are using role-based authorization, add the appropriate permissions:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "iam:PassRole",\r\n            "Resource": "arn:aws:iam::<<--account-id-->>:role/<<--role_name-->>"\r\n        },\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "ec2:DescribeInstances",\r\n                "ec2:DescribeVolumes",\r\n                "ec2:DescribeRegions",\r\n                "rds:DescribeEvents",\r\n                "rds:DescribeDBInstances",\r\n                "ecs:DescribeClusters",\r\n                "ecs:ListServices",\r\n                "ecs:ListTasks",\r\n                "ecs:ListClusters",\r\n                "s3:ListAllMyBuckets",\r\n                "s3:GetBucketLocation",\r\n                "s3:GetMetricsConfiguration",\r\n                "ec2:AssociateIamInstanceProfile",\r\n                "ec2:ReplaceIamInstanceProfileAssociation",\r\n                "elasticloadbalancing:DescribeLoadBalancers",\r\n                "elasticloadbalancing:DescribeTargetGroups",\r\n                "ec2:DescribeSecurityGroups",\r\n                "lambda:ListFunctions"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Role-Based Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Principal": {\r\n                "Service": [\r\n                    "ec2.amazonaws.com"\r\n                ]\r\n            },\r\n            "Action": [\r\n                "sts:AssumeRole"\r\n            ]\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n**Note**: Using role-based authorization is only possible when you use a Zabbix server or proxy inside AWS.\r\n\r\nTo gather Request metrics, enable [Requests metrics](https://docs.aws.amazon.com/AmazonS3/latest/userguide/cloudwatch-monitoring.html) on your Amazon S3 buckets from the AWS console.\r\n\r\nChoose a method of authorization (field of `Authorization method`).\r\n\r\nFor more information about managing access keys, see [official documentation](https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys).\r\n\r\nRefer to the Macros section for a list of macros used for LLD filters.\r\n\r\nAdditional information about the metrics and used API methods:\r\n* [Full metrics list related to EBS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html)\r\n* [Full metrics list related to EC2](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html)\r\n* [Full metrics list related to RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-metrics.html)\r\n* [Full metrics list related to Amazon Aurora](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.AuroraMySQL.Monitoring.Metrics.html#Aurora.AuroraMySQL.Monitoring.Metrics.instances)\r\n* [Full metrics list related to S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/metrics-dimensions.html)\r\n* [Full metrics list related to ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-metrics.html)\r\n* [Full metrics list related to ELB ALB](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-cloudwatch-metrics.html)\r\n* [DescribeAlarms API method](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)\r\n* [DescribeVolumes API method](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumes.html)\r\n* [DescribeLoadBalancers API method](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)'),
('10539',NULL,'Azure MySQL Flexible Server by HTTP','3','-1','2','','','Azure MySQL Flexible Server by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure MySQL flexible servers by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ec92c7b0b1d14946b6ac61de89357199','AZURE MYSQL FLEXIBLE SERVER BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor Microsoft Azure MySQL flexible servers by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\n## Setup\r\n\r\n1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n\r\n      `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n\r\n> See [Azure documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli) for more details.\r\n\r\n2. Link the template to a host.\r\n3. Configure the macros: `Azure App ID`, `Azure password`, `Azure tenant ID`, `Azure subscription ID`, and `Azure MySQL server ID.`.'),
('10540',NULL,'Azure MySQL Single Server by HTTP','3','-1','2','','','Azure MySQL Single Server by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure MySQL single servers by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c1396bf1e8cf46f6a407e88ddceef0b8','AZURE MYSQL SINGLE SERVER BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor Microsoft Azure MySQL single servers by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\n## Setup\r\n\r\n1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n\r\n      `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n\r\n> See [Azure documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli) for more details.\r\n\r\n2. Link the template to a host.\r\n3. Configure the macros: `Azure App ID`, `Azure password`, `Azure tenant ID`, `Azure subscription ID`, and `Azure MySQL server ID`.'),
('10543',NULL,'Azure PostgreSQL Flexible Server by HTTP','3','-1','2','','','Azure PostgreSQL Flexible Server by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure PostgreSQL flexible servers by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','35ef29f24158444097272d2ea7fa6044','AZURE POSTGRESQL FLEXIBLE SERVER BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor Microsoft Azure PostgreSQL flexible servers by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\n## Setup\r\n\r\n1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n\r\n      `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n\r\n> See [Azure documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli) for more details.\r\n\r\n2. Link the template to a host.\r\n3. Configure the macros: `Azure App ID`, `Azure password`, `Azure tenant ID`, `Azure subscription ID`, and `Azure PostgreSQL server ID`.'),
('10544',NULL,'Azure PostgreSQL Single Server by HTTP','3','-1','2','','','Azure PostgreSQL Single Server by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure PostgreSQL servers by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d023e2cd326c486f908e3e361d1fe157','AZURE POSTGRESQL SINGLE SERVER BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor Microsoft Azure PostgreSQL servers by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\n## Setup\r\n\r\n1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n\r\n      `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n\r\n> See [Azure documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli) for more details.\r\n\r\n2. Link the template to a host.\r\n3. Configure the macros: `Azure App ID`, `Azure password`, `Azure tenant ID`, `Azure subscription ID`, and `Azure PostgreSQL server ID`.'),
('10546',NULL,'Cisco Meraki dashboard by HTTP','3','-1','2','','','Cisco Meraki dashboard by HTTP','0',NULL,'Template for monitoring Cisco Meraki dashboard https://meraki.cisco.com/products/meraki-dashboard/\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2fca6b60914b4fa98132b1a7885ab014','CISCO MERAKI DASHBOARD BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10547',NULL,'Cisco Meraki device by HTTP','3','-1','2','','','Cisco Meraki device by HTTP','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2cae7d2eeca04e6fa7419759ac9ad814','CISCO MERAKI DEVICE BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10548',NULL,'Cisco Meraki organization by HTTP','3','-1','2','','','Cisco Meraki organization by HTTP','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','39e2f742d0b24ea489b7f61d27a5df1c','CISCO MERAKI ORGANIZATION BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10551',NULL,'Cisco Nexus 9000 Series by SNMP','3','-1','2','','','Cisco Nexus 9000 Series by SNMP','0',NULL,'Template Cisco Nexus 9000 Series\r\n  \r\n  MIBs used:\r\n  CISCO-ENHANCED-MEMPOOL-MIB\r\n  CISCO-ENTITY-FRU-CONTROL-MIB\r\n  CISCO-ENTITY-SENSOR-MIB\r\n  CISCO-PROCESS-MIB\r\n  ENTITY-MIB\r\n  EtherLike-MIB\r\n  IF-MIB\r\n  SNMPv2-MIB\r\n  SNMP-FRAMEWORK-MIB\r\n  CISCO-IMAGE-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','80fc469750f84061924662a98c33580c','CISCO NEXUS 9000 SERIES BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10552',NULL,'Control-M enterprise manager by HTTP','3','-1','2','','','Control-M enterprise manager by HTTP','0',NULL,'This template is designed to get metrics from the Control-M Enterprise Manager using the Control-M Automation API with HTTP agent.\r\n\r\nThis template monitors active Service Level Agreement (SLA) services, discovers Control-M servers using Low Level Discovery and also creates host prototypes for them in conjunction with the `Control-M server by HTTP` template.\r\n\r\nTo use this template, macros `{$API.TOKEN}` and `{$API.URI.ENDPOINT}` need to be set.\r\n\r\n> See [Zabbix template operation](https://www.zabbix.com/documentation/7.4/manual/config/templates_out_of_the_box/http) for basic instructions.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','24b64f6d22b446dabecc86ee3f199004','CONTROL-M ENTERPRISE MANAGER BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10553',NULL,'Control-M server by HTTP','3','-1','2','','','Control-M server by HTTP','0',NULL,'This template is designed to get metrics from the Control-M server using the Control-M Automation API with HTTP agent.\r\n\r\nThis template monitors server statistics, discovers jobs and agents using Low Level Discovery.\r\n\r\nTo use this template, macros `{$API.TOKEN}`, `{$API.URI.ENDPOINT}`, and `{$SERVER.NAME}` need to be set.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c077d6c381904e94a4df88136588b551','CONTROL-M SERVER BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10555',NULL,'Veeam Backup and Replication by HTTP','3','-1','2','','','Veeam Backup and Replication by HTTP','0',NULL,'This template is designed to monitor Veeam Backup and Replication.\r\n\r\nNOTE: The RESTful API may not be available for some editions, see (https://www.veeam.com/licensing-pricing.html) for more details.\r\n\r\nSetup:\r\n  1. Create a user to monitor the service or use an existing read-only account.\r\n  See (https://helpcenter.veeam.com/docs/backup/vbr_rest/reference/vbr-rest-v1-rev2.html?ver=110#tag/Login/operation/CreateToken!path=grant_type&t=request) for more details. \r\n  2. Link the template to a host.\r\n  3. Configure the following macros: {$VEEAM.API.URL}, {$VEEAM.USER}, and {$VEEAM.PASSWORD}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','738085dde4e749d49199e5e6fd4d56ab','VEEAM BACKUP AND REPLICATION BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10556',NULL,'Veeam Backup Enterprise Manager by HTTP','3','-1','2','','','Veeam Backup Enterprise Manager by HTTP','0',NULL,'This template is designed to monitor Veeam Backup Enterprise Manager.\r\n\r\nNOTE: The REST API may not be available for some editions, see (https://www.veeam.com/licensing-pricing.html) for more details.\r\n\r\nSetup:\r\n  1. Create a user to monitor the service, or use an existing read-only account.\r\n     Similarly to the user authentication in the Veeam Backup Enterprise Manager Web UI, \r\n     the client authentication in the REST API dictates which operations a client is allowed to perform when working with the REST API.\r\n     That is, if the client is authenticated using an account that does not have enough permissions to perform some actions, it will not be able to execute them.\r\n     You can also obtain the collected jobs if you are logged in under an account having only `Portal Administrator` role.\r\n  See (https://helpcenter.veeam.com/docs/backup/em_rest/http_authentication.html?ver=110) for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the following macros: {$VEEAM.MANAGER.API.URL}, {$VEEAM.MANAGER.USER}, {$VEEAM.MANAGER.PASSWORD}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2ce384bafd524db5b910d7f55bca1fbb','VEEAM BACKUP ENTERPRISE MANAGER BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10557',NULL,'Azure Microsoft SQL Database by HTTP','3','-1','2','','','Azure Microsoft SQL Database by HTTP','0',NULL,'This template is designed to monitor Microsoft SQL databases by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2d8b9329b5d04cdf85bf17d2d0db2b29','AZURE MICROSOFT SQL DATABASE BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor Microsoft SQL databases by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\n## Setup\r\n\r\n1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n\r\n      `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n\r\n> See [Azure documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli) for more details.\r\n\r\n2. Link the template to a host.\r\n3. Configure the macros: `Azure App ID`, `Azure password`, `Azure tenant ID`, `Azure subscription ID`, and `Azure MSSQL database ID`.'),
('10558',NULL,'Azure Microsoft SQL Serverless Database by HTTP','3','-1','2','','','Azure Microsoft SQL Serverless Database by HTTP','0',NULL,'This template is designed to monitor Microsoft SQL serverless databases by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5175afdf713744d9a81ce53864ccfc1d','AZURE MICROSOFT SQL SERVERLESS DATABASE BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor Microsoft SQL serverless databases by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\n## Setup\r\n\r\n1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n\r\n      `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n\r\n> See [Azure documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli) for more details.\r\n\r\n2. Link the template to a host.\r\n3. Configure the macros: `Azure App ID`, `Azure password`, `Azure tenant ID`, `Azure subscription ID`, and `Azure MSSQL database ID`.'),
('10560',NULL,'OS processes by Zabbix agent','3','-1','2','','','OS processes by Zabbix agent','0',NULL,'Get processes metrics using item proc.get by Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0f6889282f6048e2b1370e569e578985','OS PROCESSES BY ZABBIX AGENT','Zabbix','7.4-0',NULL,'0','0',''),
('10561',NULL,'Zabbix agent','3','-1','2','','','Zabbix agent','0',NULL,'Use this template for agents reachable from Zabbix server/proxy (passive mode).\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8aa4557f6c3f4aadbc03447fca3af9f6','ZABBIX AGENT','Zabbix','7.4-1',NULL,'0','0',''),
('10562',NULL,'Zabbix agent active','3','-1','2','','','Zabbix agent active','0',NULL,'Use this template instead of \'Zabbix agent\' for agents running in active mode only.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','650bec3f2f364a478b82317396949459','ZABBIX AGENT ACTIVE','Zabbix','7.4-1',NULL,'0','0',''),
('10563',NULL,'Generic by SNMP','3','-1','2','','','Generic by SNMP','0',NULL,'Template Module Generic\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4cb1aabe2b704b5c882963c2ef87d8f6','GENERIC BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10564',NULL,'ICMP Ping','3','-1','2','','','ICMP Ping','0',NULL,'Template Net ICMP Ping\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','37e5eb5606bc4abba66c8b20381a1e8a','ICMP PING','Zabbix','7.4-1',NULL,'0','1','## Setup\r\n\r\nSet `Threshold of ICMP packet loss` and `Threshold of the average ICMP response`'),
('10565',NULL,'SMART by Zabbix agent 2','3','-1','2','','','SMART by Zabbix agent 2','0',NULL,'The template for monitoring S.M.A.R.T. attributes of physical disk that works without any external scripts. It collects metrics by Zabbix agent 2 version 5.0 and later with Smartmontools version 7.1 and later. Disk discovery LLD rule finds all HDD, SSD, NVMe disks with S.M.A.R.T. enabled. Attribute discovery LLD rule have pre-defined Vendor Specific Attributes for each disk, and will be discovered if attribute is present.\r\n\r\nSetup:\r\n\r\n1. Install Zabbix agent 2 and Smartmontools 7.1 or newer.\r\n\r\n2. Ensure the path to the "smartctl" executable is correctly specified. You can either provide the full path to the executable (e.g., "/usr/sbin/smartctl" on Linux or "C:\\Program Files\\smartctl\\smartctl.exe" on Windows) in the configuration file or ensure that the folder containing the "smartctl" executable is added to the system\'s environment variables ("PATH"). This applies to both Linux and Windows systems.\r\n\r\nExample for Linux:      \r\nPlugins.Smart.Path=/usr/sbin/smartctl\r\n\r\nExample for Windows:\r\nPlugins.Smart.Path="C:\\Program Files\\smartctl\\smartctl.exe"\r\n\r\n3. Grant Zabbix agent 2 super/admin user privileges for the "smartctl" utility (not required for Windows). Example for Linux (add the line that grants execution of the "smartctl" utility without the password):\r\n\r\n- Run the "visudo" command to edit the "sudoers" file:\r\nsudo visudo\r\n\r\n- Add the permission line and save the changes:\r\nzabbix ALL=(ALL) NOPASSWD:/usr/sbin/smartctl\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415662-discussion-thread-for-official-zabbix-smart-disk-monitoring\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7b6c6228b25f4586b42cd1bf37ff8034','SMART BY ZABBIX AGENT 2','Zabbix','7.4-1',NULL,'0','0',''),
('10566',NULL,'SMART by Zabbix agent 2 active','3','-1','2','','','SMART by Zabbix agent 2 active','0',NULL,'The template for monitoring S.M.A.R.T. attributes of physical disk that works without any external scripts. It collects metrics by Zabbix agent 2 version 5.0 and later with Smartmontools version 7.1 and later. Disk discovery LLD rule finds all HDD, SSD, NVMe disks with S.M.A.R.T. enabled. Attribute discovery LLD rule have pre-defined Vendor Specific Attributes for each disk, and will be discovered if attribute is present.\r\n\r\nSetup:\r\n\r\n1. Install Zabbix agent 2 and Smartmontools 7.1 or newer.\r\n\r\n2. Ensure the path to the "smartctl" executable is correctly specified. You can either provide the full path to the executable (e.g., "/usr/sbin/smartctl" on Linux or "C:\\Program Files\\smartctl\\smartctl.exe" on Windows) in the configuration file or ensure that the folder containing the "smartctl" executable is added to the system\'s environment variables ("PATH"). This applies to both Linux and Windows systems.\r\n\r\nExample for Linux:      \r\nPlugins.Smart.Path=/usr/sbin/smartctl\r\n\r\nExample for Windows:\r\nPlugins.Smart.Path="C:\\Program Files\\smartctl\\smartctl.exe"\r\n\r\n3. Grant Zabbix agent 2 super/admin user privileges for the "smartctl" utility (not required for Windows). Example for Linux (add the line that grants execution of the "smartctl" utility without the password):\r\n\r\n- Run the "visudo" command to edit the "sudoers" file:\r\nsudo visudo\r\n\r\n- Add the permission line and save the changes:\r\nzabbix ALL=(ALL) NOPASSWD:/usr/sbin/smartctl\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415662-discussion-thread-for-official-zabbix-smart-disk-monitoring\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e518b1340ce44d7389d2cc7c304a97b4','SMART BY ZABBIX AGENT 2 ACTIVE','Zabbix','7.4-1',NULL,'0','0',''),
('10568',NULL,'Azure Cosmos DB for MongoDB by HTTP','3','-1','2','','','Azure Cosmos DB for MongoDB by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure Cosmos DB for MongoDB by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','29325098807848aa928b4192ad5e020f','AZURE COSMOS DB FOR MONGODB BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Setup\r\n\r\n1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n\r\n      `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n\r\n> See [Azure documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli) for more details.\r\n\r\n2. Link the template to a host.\r\n3. Configure the macros: `Azure App ID`, `Azure password`, `Azure tenant ID`, `Azure subscription ID`, and `Azure Cosmos DB ID`.'),
('10570',NULL,'GCP by HTTP','3','-1','2','','','GCP by HTTP','0',NULL,'Discover GCP Compute Engine/Cloud SQL Instances and Compute Engine project quota metrics.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4e1e9372a5fe4297936210bc4fc4b1c0','GCP BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor Google Cloud Platform (hereinafter - GCP) by Zabbix.\r\nIt works without any external scripts and uses the script item.\r\nThe template currently supports the discovery of [Compute Engine](https://cloud.google.com/compute)/[Cloud SQL](https://cloud.google.com/sql) instances and Compute Engine project quota metrics.\r\n\r\n\r\n## Setup\r\n\r\n1. Enable the `Stackdriver Monitoring API` for the GCP project you wish to monitor.\r\n>Refer to the [vendor documentation](https://cloud.google.com/monitoring/api/enable-api).\r\n2. Create a service account in Google Cloud console for the project you have to monitor.\r\n>Refer to the [vendor documentation](https://cloud.google.com/iam/docs/creating-managing-service-accounts).\r\n3. Create and download the service account key in JSON format.\r\n>Refer to the [vendor documentation](https://cloud.google.com/iam/docs/creating-managing-service-account-keys).\r\n4. If you want to monitor Cloud SQL services - don\'t forget to activate the Cloud SQL Admin API.\r\n>Refer to the [vendor documentation](https://cloud.google.com/sql/docs/mysql/admin-api) for the details.\r\n5. Copy the `project_id`, `private_key_id`, `private_key`, `client_email` from the JSON key file and add them to their corresponding macros `GCP project ID`, `Private key id`, `Private key data`, `Client e-mail` in host wizard configuration fields.\r\n\r\n**Additional information**:\r\n\r\n    Make sure that you\'re creating the service account using the credentials with the `Project Owner/Project IAM Admin/service account Admin` role.\r\n\r\n    The service account JSON key file can only be downloaded once: regenerate it if the previous key has been lost.\r\n\r\n    The service account should have `Project Viewer` permissions or granular permissions for the GCP Compute Engine API/GCP Cloud SQL.\r\n\r\n    You can copy and paste private_key string data from the Service Account JSON key file as is or replace the new line metasymbol (\\n) with an actual new line.\r\n\r\n>Please, refer to the [vendor documentation](https://cloud.google.com/iam/docs/manage-access-service-accounts)  about the service accounts management.\r\n\r\n**IMPORTANT!!!**\r\n\r\n     Secret authorization token is defined as a plain text in host prototype settings by default due to Zabbix templates export/import limits: therefore, it is highly recommended to change the user macro `{$GCP.AUTH.TOKEN}` value type to `SECRET` for all host prototypes after the template `GCP by HTTP` import.\r\n\r\n     All the instances/quotas/metrics discovered are related to a particular GCP project.\r\n     To monitor several GCP projects - create their corresponding service accounts/Zabbix hosts.\r\n\r\n     GCP Access Token is available for 1 hour (3600 seconds) after the generation request.\r\n\r\n     To avoid a GCP token inconsistency between Zabbix database and Zabbix server configuration cache, don\'t set Zabbix server configuration parameter CacheUpdateFrequency to a value over 45 minutes and don\'t set the update interval for the GCP Authorization item to more than 1 hour (maximum CacheUpdateFrequency value).\r\n\r\nAdditional information about metrics and used API methods:\r\n\r\n  [Compute Engine](https://cloud.google.com/monitoring/api/metrics_gcp#gcp-compute)\r\n\r\n  [Cloud SQL](https://cloud.google.com/monitoring/api/metrics_gcp#gcp-cloudsql)'),
('10571',NULL,'GCP Cloud SQL MSSQL by HTTP','3','-1','2','','','GCP Cloud SQL MSSQL by HTTP','0',NULL,'Get GCP Cloud SQL MSSQL instances monitoring with script item usage to perform HTTP requests to Google Cloud Platform Monitoring API.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','507d70db18554a4e9ee5e09bb29bc85f','GCP CLOUD SQL MSSQL BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10572',NULL,'GCP Cloud SQL MSSQL Replica by HTTP','3','-1','2','','','GCP Cloud SQL MSSQL Replica by HTTP','0',NULL,'Get GCP Cloud SQL MSSQL monitoring for read-only replicas with script item usage to perform HTTP requests to Google Cloud Platform Monitoring API.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','54f0ffb538d94a9bb8062df3e63c4cb6','GCP CLOUD SQL MSSQL REPLICA BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10573',NULL,'GCP Cloud SQL MySQL by HTTP','3','-1','2','','','GCP Cloud SQL MySQL by HTTP','0',NULL,'Get GCP Cloud SQL MySQL instances monitoring with script item usage to perform HTTP requests to Google Cloud Platform Monitoring API.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','38456af4aedd4b168ec3fa4ad2acb256','GCP CLOUD SQL MYSQL BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10574',NULL,'GCP Cloud SQL MySQL Replica by HTTP','3','-1','2','','','GCP Cloud SQL MySQL Replica by HTTP','0',NULL,'Get GCP Cloud SQL MySQL monitoring for read-only replicas with script item usage to perform HTTP requests to Google Cloud Platform Monitoring API.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','9d7871c093f9489293421396b9fea668','GCP CLOUD SQL MYSQL REPLICA BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10575',NULL,'GCP Cloud SQL PostgreSQL by HTTP','3','-1','2','','','GCP Cloud SQL PostgreSQL by HTTP','0',NULL,'Get GCP Cloud SQL PostgreSQL instances monitoring with script item usage to perform HTTP requests to Google Cloud Platform Monitoring API.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e74c1e12f82e4d9880a368b53f5e65a4','GCP CLOUD SQL POSTGRESQL BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10576',NULL,'GCP Cloud SQL PostgreSQL Replica by HTTP','3','-1','2','','','GCP Cloud SQL PostgreSQL Replica by HTTP','0',NULL,'Get GCP Cloud SQL PostgreSQL  monitoring for read-only replicas with script item usage to perform HTTP requests to Google Cloud Platform Monitoring API.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b43a7c5f1d1d43d28e2eb8f0a9f6f16f','GCP CLOUD SQL POSTGRESQL REPLICA BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10577',NULL,'GCP Compute Engine Instance by HTTP','3','-1','2','','','GCP Compute Engine Instance by HTTP','0',NULL,'Discover GCP Compute Engine instances by HTTP with script item usage.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6d2443db49e54d59a82b9b525f2424ef','GCP COMPUTE ENGINE INSTANCE BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10582',NULL,'AWS Cost Explorer by HTTP','3','-1','2','','','AWS Cost Explorer by HTTP','0',NULL,'The template gets AWS Cost Explorer metrics and uses the script item to make HTTP requests to the Cost Explorer API.\r\nThe Cost Explorer API can access the historical data over up to 12 months and the data for current month.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','dce23cdaef364e139efa580d8a304ffe','AWS COST EXPLORER BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThe template to monitor AWS Cost Explorer by HTTP via Zabbix, which works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n*NOTE*\r\nThis template uses the Cost Explorer API calls to list and retrieve metrics.\r\nFor more information, please refer to the [Cost Explorer pricing](https://aws.amazon.com/aws-cost-management/aws-cost-explorer/pricing/) page.\r\n\r\n\r\n## Setup\r\n\r\nBefore using the template, you need to create an IAM policy for the Zabbix role in your AWS account with the necessary permissions.\r\n\r\n* [IAM policies for AWS Cost Management](https://docs.aws.amazon.com/cost-management/latest/userguide/billing-permissions-ref.html)\r\n\r\n### Required Permissions\r\nAdd the following required permissions to your Zabbix IAM policy in order to collect metrics.\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Action": [\r\n                "ce:GetDimensionValues",\r\n                "ce:GetCostAndUsage"\r\n            ],\r\n            "Effect": "Allow",\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n### Access Key Authorization\r\n\r\nIf you are using access key authorization, you need to generate an access key and secret key for an IAM user with the necessary permissions:\r\n\r\n1. Create an IAM user with programmatic access.\r\n2. Attach the required policy to the IAM user.\r\n3. Generate an access key and secret key.\r\n4. Use the generated credentials in the macros `Access key ID` and `Secret access key`.\r\n\r\n### Assume Role Authorization\r\nFor using assume role authorization, add the appropriate permissions to the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "sts:AssumeRole",\r\n            "Resource": "arn:aws:iam::{Account}:user/{UserName}"\r\n        },\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "ce:GetDimensionValues",\r\n                "ce:GetCostAndUsage"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Assume Role Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n  "Version": "2012-10-17",\r\n  "Statement": [\r\n    {\r\n      "Effect": "Allow",\r\n      "Principal": {\r\n        "AWS": "arn:aws:iam::{Account}:user/{UserName}"\r\n      },\r\n      "Action": "sts:AssumeRole"\r\n    }\r\n  ]\r\n}\r\n```\r\nSet the following fields: `Access key ID`, `Secret access key`, `STS Region`, `ARN assume role`.\r\n\r\n### Role-Based Authorization\r\nIf you are using role-based authorization, add the appropriate permissions:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "iam:PassRole",\r\n            "Resource": "arn:aws:iam::<<--account-id-->>:role/<<--role_name-->>"\r\n        },\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "ce:GetDimensionValues",\r\n                "ce:GetCostAndUsage",\r\n                "ec2:AssociateIamInstanceProfile",\r\n                "ec2:ReplaceIamInstanceProfileAssociation"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Role-Based Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Principal": {\r\n                "Service": [\r\n                    "ec2.amazonaws.com"\r\n                ]\r\n            },\r\n            "Action": [\r\n                "sts:AssumeRole"\r\n            ]\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n**Note**: Using role-based authorization is only possible when you use a Zabbix server or proxy inside AWS.\r\n\r\nChoose a method of authorization (field of `Authorization method`).\r\n\r\nFor more information about managing access keys, see the [official documentation](https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys).\r\n\r\nAlso, see the Macros section for a list of macros used in LLD filters.\r\n\r\nAdditional information about metrics and used API methods:\r\n\r\n* [Describe AWS Cost Explore API actions](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Operations.html)'),
('10583',NULL,'AWS ECS Cluster by HTTP','3','-1','2','','','AWS ECS Cluster by HTTP','0',NULL,'The template gets AWS ECS Cluster metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c94105c23220452baed03ba87f09ca12','AWS ECS CLUSTER BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThe template to monitor AWS ECS Serverless Cluster by HTTP via Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n*NOTE*\r\nThis template uses the GetMetricData CloudWatch API calls to list and retrieve metrics.\r\nFor more information, please refer to the [CloudWatch pricing](https://aws.amazon.com/cloudwatch/pricing/) page.\r\n\r\nAdditional information about the metrics and used API methods:\r\n\r\n* [Full metrics list related to ECS](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Container-Insights-metrics-ECS.html)\r\n* [DescribeAlarms API method](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)\r\n\r\n## Setup\r\n\r\nThe template gets AWS ECS metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\n\r\nBefore using the template, you need to create an IAM policy for the Zabbix role in your AWS account with the necessary permissions.\r\n\r\n### Required Permissions\r\nAdd the following required permissions to your Zabbix IAM policy in order to collect Amazon ECS metrics.\r\n\r\n```json\r\n{\r\n    "Version":"2012-10-17",\r\n    "Statement":[\r\n        {\r\n          "Action":[\r\n              "cloudwatch:DescribeAlarms",\r\n              "cloudwatch:GetMetricData",\r\n              "ecs:ListServices"\r\n          ],\r\n          "Effect":"Allow",\r\n          "Resource":"*"\r\n        }\r\n    ]\r\n  }\r\n```\r\n\r\n### Access Key Authorization\r\n\r\nIf you are using access key authorization, you need to generate an access key and secret key for an IAM user with the necessary permissions:\r\n\r\n1. Create an IAM user with programmatic access.\r\n2. Attach the required policy to the IAM user.\r\n3. Generate an access key and secret key.\r\n4. Use the generated credentials in the macros `Access key ID` and `Secret access key`.\r\n\r\n### Assume role authorization\r\nFor using assume role authorization, add the appropriate permissions to the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "sts:AssumeRole",\r\n            "Resource": "arn:aws:iam::{Account}:user/{UserName}"\r\n        },\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "ecs:ListServices"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Assume Role Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n  "Version": "2012-10-17",\r\n  "Statement": [\r\n    {\r\n      "Effect": "Allow",\r\n      "Principal": {\r\n        "AWS": "arn:aws:iam::{Account}:user/{UserName}"\r\n      },\r\n      "Action": "sts:AssumeRole"\r\n    }\r\n  ]\r\n}\r\n```\r\nSet the following fields: `Access key ID`, `Secret access key`, `STS Region`, `ARN assume role`.\r\n\r\n### Role-Based Authorization\r\nIf you are using role-based authorization, set the appropriate permissions:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "iam:PassRole",\r\n            "Resource": "arn:aws:iam::<<--account-id-->>:role/<<--role_name-->>"\r\n        },\r\n        {\r\n            "Sid": "VisualEditor1",\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "ecs:ListServices",\r\n                "ec2:AssociateIamInstanceProfile",\r\n                "ec2:ReplaceIamInstanceProfileAssociation"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n#### Trust Relationships for Role-Based Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Principal": {\r\n                "Service": [\r\n                    "ec2.amazonaws.com"\r\n                ]\r\n            },\r\n            "Action": [\r\n                "sts:AssumeRole"\r\n            ]\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n**Note**: Using role-based authorization is only possible when you use a Zabbix server or proxy inside AWS.\r\n\r\nSet the following macros `Authorization method`, `AWS Region`, `ECS cluster name`.\r\n\r\nFor more information about managing access keys, see [official documentation](https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys)\r\n\r\nRefer to the Macros section for a list of macros used for LLD filters.'),
('10584',NULL,'AWS ECS Serverless Cluster by HTTP','3','-1','2','','','AWS ECS Serverless Cluster by HTTP','0',NULL,'The template gets AWS ECS Serverless Cluster metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5e225ad1c2cc4d0bbf75586e7bf8871b','AWS ECS SERVERLESS CLUSTER BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThe template to monitor AWS ECS Serverless Cluster by HTTP via Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n*NOTE*\r\nThis template uses the GetMetricData CloudWatch API calls to list and retrieve metrics.\r\nFor more information, please refer to the [CloudWatch pricing](https://aws.amazon.com/cloudwatch/pricing/) page.\r\n\r\nAdditional information about the metrics and used API methods:\r\n\r\n* [Full metrics list related to ECS](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Container-Insights-metrics-ECS.html)\r\n* [DescribeAlarms API method](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)\r\n\r\n## Setup\r\n\r\nThe template gets AWS ECS metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\n\r\nBefore using the template, you need to create an IAM policy for the Zabbix role in your AWS account with the necessary permissions.\r\n\r\n### Required Permissions\r\nAdd the following required permissions to your Zabbix IAM policy in order to collect Amazon ECS metrics.\r\n\r\n```json\r\n{\r\n    "Version":"2012-10-17",\r\n    "Statement":[\r\n        {\r\n          "Action":[\r\n              "cloudwatch:DescribeAlarms",\r\n              "cloudwatch:GetMetricData",\r\n              "ecs:ListServices"\r\n          ],\r\n          "Effect":"Allow",\r\n          "Resource":"*"\r\n        }\r\n    ]\r\n  }\r\n```\r\n\r\n### Access Key Authorization\r\n\r\nIf you are using access key authorization, you need to generate an access key and secret key for an IAM user with the necessary permissions:\r\n\r\n1. Create an IAM user with programmatic access.\r\n2. Attach the required policy to the IAM user.\r\n3. Generate an access key and secret key.\r\n4. Use the generated credentials in the macros `Access key ID` and `Secret access key`.\r\n\r\n### Assume role authorization\r\nFor using assume role authorization, add the appropriate permissions to the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "sts:AssumeRole",\r\n            "Resource": "arn:aws:iam::{Account}:user/{UserName}"\r\n        },\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "ecs:ListServices"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Assume Role Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n  "Version": "2012-10-17",\r\n  "Statement": [\r\n    {\r\n      "Effect": "Allow",\r\n      "Principal": {\r\n        "AWS": "arn:aws:iam::{Account}:user/{UserName}"\r\n      },\r\n      "Action": "sts:AssumeRole"\r\n    }\r\n  ]\r\n}\r\n```\r\nSet the following fields: `Access key ID`, `Secret access key`, `STS Region`, `ARN assume role`.\r\n\r\n### Role-Based Authorization\r\nIf you are using role-based authorization, set the appropriate permissions:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "iam:PassRole",\r\n            "Resource": "arn:aws:iam::<<--account-id-->>:role/<<--role_name-->>"\r\n        },\r\n        {\r\n            "Sid": "VisualEditor1",\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "ecs:ListServices",\r\n                "ec2:AssociateIamInstanceProfile",\r\n                "ec2:ReplaceIamInstanceProfileAssociation"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n#### Trust Relationships for Role-Based Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Principal": {\r\n                "Service": [\r\n                    "ec2.amazonaws.com"\r\n                ]\r\n            },\r\n            "Action": [\r\n                "sts:AssumeRole"\r\n            ]\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n**Note**: Using role-based authorization is only possible when you use a Zabbix server or proxy inside AWS.\r\n\r\nSet the following macros `Authorization method`, `AWS Region`, `ECS cluster name`.\r\n\r\nFor more information about managing access keys, see [official documentation](https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys)\r\n\r\nRefer to the Macros section for a list of macros used for LLD filters.'),
('10586',NULL,'OpenStack by HTTP','3','-1','2','','','OpenStack by HTTP','0',NULL,'Requests OpenStack API access token and discovers available OpenStack services using OpenStack Identity API by HTTP using script item and creates host prototypes for them.\r\n\r\nTemplate uses OpenStack application credentials for authorization.\r\n\r\nZabbix currently supports OpenStack Nova service.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4e3fb27f028e4c35b8c9fc43b11c07d7','OPENSTACK BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10587',NULL,'OpenStack Nova by HTTP','3','-1','2','','','OpenStack Nova by HTTP','0',NULL,'Discovers and monitors project limits, servers, services, hypervisors, availability zones, hypervisors and tenants with OpenStack Compute API by HTTP using script and HTTP agent items.\r\n\r\nThis template receives token and service URL from parent host, therefore no additional configuration is necessary.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ff637e001b91472d8730eb7f10e65800','OPENSTACK NOVA BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10589',NULL,'PostgreSQL by ODBC','3','-1','2','','','PostgreSQL by ODBC','0',NULL,'This template is designed for the effortless deployment of PostgreSQL monitoring by Zabbix via ODBC and doesn\'t require any external scripts.\r\n\r\nSetup:\r\n\r\n1. Create the PostgreSQL user for monitoring (`<password>` at your discretion) and inherit permissions from the default role `pg_monitor`:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n\r\n2. Edit the `pg_hba.conf` configuration file to allow TCP connections for the user `zbx_monitor`. You can check the PostgreSQL documentation for examples (https://www.postgresql.org/docs/current/auth-pg-hba-conf.html).\r\n\r\n3. Install the PostgreSQL ODBC driver.\r\n\r\n4. Set up the connection string with the `{$PG.CONNSTRING.ODBC}` macro. The minimum required parameters are:\r\n- `Driver=` - set the name of the driver which will be used for monitoring (from the `odbcinst.ini` file) or specify the path to the driver file (for example `/usr/lib64/psqlodbcw.so`);\r\n- `Servername=` - set the host name or IP address of the PostgreSQL instance;\r\n- `Port=` - adjust the port number if needed.\r\n\r\nIf you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, you can also specify encryption parameters here.\r\n\r\nIt is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the PostgreSQL documentation (https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\nFor example, to enable required encryption in transport mode without identity checks, the connection string could look like this (replace `<instanceip>` with the address of the PostgreSQL instance):\r\nServername=<instanceip>;Port=5432;Driver=/usr/lib64/psqlodbcw.so;SSLmode=require\r\n\r\n5. Set the password that you specified in step 1 in the macro `{$PG.PASSWORD}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e0a7c3e725c445228b03116dc6114fe9','POSTGRESQL BY ODBC','Zabbix','7.4-2',NULL,'0','1','## Setup\r\n\r\n1. Create the PostgreSQL user for monitoring (`<password>` at your discretion) and inherit permissions from the default role `pg_monitor`:\r\n\r\n```sql\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n```\r\n\r\n2. Edit the `pg_hba.conf` configuration file to allow TCP connections for the user `zbx_monitor`. For example, you could add one of the following rows to allow local connections from the same host:\r\n\r\n```bash\r\n# TYPE  DATABASE        USER            ADDRESS                 METHOD\r\n  host       all        zbx_monitor     localhost               trust\r\n  host       all        zbx_monitor     127.0.0.1/32            md5\r\n  host       all        zbx_monitor     ::1/128                 scram-sha-256\r\n```\r\n\r\nFor more information please read the PostgreSQL documentation `https://www.postgresql.org/docs/current/auth-pg-hba-conf.html`.\r\n\r\n3. Install the PostgreSQL ODBC driver. Check the [`Zabbix documentation`](https://www.zabbix.com/documentation/7.4/manual/config/items/itemtypes/odbc_checks/) for details about ODBC checks and [`recommended parameters page`](https://www.zabbix.com/documentation/7.4/manual/config/items/itemtypes/odbc_checks/unixodbc_postgresql).\r\n\r\n4. Set up the connection string in the `PostgreSQL connection string` host wizard configuration field. The minimum required parameters are:\r\n\r\n- `Driver=` - set the name of the driver which will be used for monitoring (from the `odbcinst.ini` file) or specify the path to the driver file (for example `/usr/lib64/psqlodbcw.so`);\r\n- `Servername=` - set the host name or IP address of the PostgreSQL instance;\r\n- `Port=` - adjust the port number if needed.\r\n\r\n**Note:** if you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, you can also specify encryption parameters here.\r\n\r\nIt is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the [`PostgreSQL documentation`](https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\nFor example, to enable required encryption in transport mode without identity checks, the connection string could look like this (replace `<instanceip>` with the address of the PostgreSQL instance):\r\n\r\n```\r\nServername=<instanceip>;Port=5432;Driver=/usr/lib64/psqlodbcw.so;SSLmode=require\r\n```\r\n\r\n5. Set the password that you specified in step 1 in the `PostgreSQL user password` field.'),
('10590',NULL,'Cisco SD-WAN by HTTP','3','-1','2','','','Cisco SD-WAN by HTTP','0',NULL,'Discover Cisco SD-WAN devices by HTTP with script item usage.\r\n\r\nSetup:\r\n1. Put your username and password from Cisco SD-WAN vManage into {$SDWAN.API.USERNAME} and {$SDWAN.API.PASSWORD} macros.\r\n2. Set your Cisco SD-WAN vManage URL as {$SDWAN.API.URL} macro value.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e5cf4e7ac41a470b99e4262d1c5ee104','CISCO SD-WAN BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10591',NULL,'Cisco SD-WAN device by HTTP','3','-1','2','','','Cisco SD-WAN device by HTTP','0',NULL,'Get Cisco SD-WAN devices monitoring with script item usage to perform HTTP requests to Cisco SD-WAN API.\r\nThis template will be automatically connected to discovered entities with all required parameters pre-defined.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e1e25df663204b099f2597caf89a0678','CISCO SD-WAN DEVICE BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10593',NULL,'Mantis BT by HTTP','3','-1','2','','','Mantis BT by HTTP','0',NULL,'Get Mantis BT issues by HTTP.\r\nMetrics are collected by requests to Mantis BT API.\r\nPlease change macros {$MANTIS.URL} and {$MANTIS.TOKEN}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2c96393f8f2945c1a9f03f86adf5eb57','MANTIS BT BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10594',NULL,'HashiCorp Nomad by HTTP','3','-1','2','','','HashiCorp Nomad by HTTP','0',NULL,'Discover HashiCorp Nomad servers and clients automatically.\r\n\r\nDon\'t forget to change macro {$NOMAD.ENDPOINT.API.URL}, {$NOMAD.TOKEN} values.\r\n\r\nYou can discuss this template or leave feedback on our forum: https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f74adf26d9ab44ada318002d31fd2881','HASHICORP NOMAD BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10595',NULL,'HashiCorp Nomad Client by HTTP','3','-1','2','','','HashiCorp Nomad Client by HTTP','0',NULL,'Get HashiCorp Nomad client metrics by HTTP from metrics endpoint.\r\n\r\nMore information about metrics is available in the official documentation: https://developer.hashicorp.com/nomad/docs/operations/metrics-reference.\r\n\r\nYou can discuss this template or leave feedback on our forum: https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','44eac6a1abe34999b85ad6d0e40073fd','HASHICORP NOMAD CLIENT BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10596',NULL,'HashiCorp Nomad Server by HTTP','3','-1','2','','','HashiCorp Nomad Server by HTTP','0',NULL,'Get HashiCorp Nomad server metrics by HTTP from metrics endpoint.\r\n\r\nMore information about metrics is available in the official documentation: https://developer.hashicorp.com/nomad/docs/operations/metrics-reference.\r\n\r\nYou can discuss this template or leave feedback on our forum: https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8598d0e2bd6f4903832ec91b7b300062','HASHICORP NOMAD SERVER BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10599',NULL,'Acronis Cyber Protect Cloud by HTTP','3','-1','2','','','Acronis Cyber Protect Cloud by HTTP','0',NULL,'Requests Acronis Cyber Protect Cloud API access token and creates host prototype for MSP.\r\n\r\nTemplate uses HTTP item to query Acronis Cyber Protect Cloud API client for authorization.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d0571c5f2c204b7ab244843040288a35','ACRONIS CYBER PROTECT CLOUD BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10600',NULL,'Acronis Cyber Protect Cloud MSP by HTTP','3','-1','2','','','Acronis Cyber Protect Cloud MSP by HTTP','0',NULL,'Discovers and monitors alerts, clients, devices using HTTP agent items.\r\n\r\nThis template receives API token and datacenter URL from parent host, therefore no additional configuration is necessary.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','bf3107deff3a4aabab1e1c0ee71a3281','ACRONIS CYBER PROTECT CLOUD MSP BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10602',NULL,'Nextcloud by HTTP','3','-1','2','','','Nextcloud by HTTP','0',NULL,'This template is designed for monitoring Nextcloud by HTTP via Zabbix, and it works without any external scripts.\r\n  Nextcloud is a suite of client-server software for creating and using file hosting services.\r\n  For more information, see the [`official documentation`](https://docs.nextcloud.com/server/latest/developer_manual/client_apis/OCS/ocs-api-overview.html#)\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','34f386276a094e8e9a6e46653fdf05b1','NEXTCLOUD BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10603',NULL,'FortiGate by HTTP','3','-1','2','','','FortiGate by HTTP','0',NULL,'The template for monitoring FortiGate Next Generation Firewall by HTTP.\r\n\r\n1. On the FortiGate GUI, select System > Admin Profiles > Create New.\r\n2. Enter a profile name (ex. zabbix_ro) and enable all the Read permissions. Please note the profile name, it will be used a bit later.\r\n3. Go to System > Administrators > Create New > REST API Admin.\r\n4. Enter the API-user\'s name and select the profile name you created in step 2.\r\n5. The trusted host can be specified to ensure that only Zabbix server can reach the FortiGate.\r\n6. Click OK and an API token will be generated. Make a note of the API token as it\'s only shown once and cannot be retrieved.\r\n7. Put the API token into {$FGATE.API.TOKEN} macro.\r\n8. Set your FortiGate GUI IP/FQDN as {$FGATE.API.FQDN} macro value.\r\n9. If FortiGate GUI uses HTTPS, put "https" value into {$FGATE.SCHEME} macro and "443" into {$FGATE.API.PORT} macro.\r\n10. If FortiGate GUI port differs from the standard one, specify it in {$FGATE.API.PORT} macro.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e56c9577c225476eb6d8f1c2f5dc90a5','FORTIGATE BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10604',NULL,'FortiGate by SNMP','3','-1','2','','','FortiGate by SNMP','0',NULL,'The template for monitoring FortiGate firewall by SNMP.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nFORTINET-FORTIGATE-MIB\r\nFORTINET-CORE-MIB\r\nSNMPv2-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1f38deb487fc4a8d965e407ba7c5247f','FORTIGATE BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10605',NULL,'HPE iLO by HTTP','3','-1','2','','','HPE iLO by HTTP','0',NULL,'This template is designed for the effortless deployment of HPE iLO monitoring by Zabbix via iLO RESTful API and doesn\'t require any external scripts.\r\n\r\nSetup:\r\n\r\n1. Create the iLO user for monitoring (for example, `zbx_monitor`). The user will only need to have the `Login` privilege, which can be assigned manually or by assigning the `ReadOnly` role to the user.\r\n2. Set the iLO API endpoint URL in the `{$ILO.URL}` macro in the format `<scheme>://<host>[:port]/` (port is optional).\r\n3. Set the name of the user that you created in step 1 in the `{$ILO.USER}` macro.\r\n4. Set the password of the user that you created in step 1 in the `{$ILO.PASSWORD}` macro.\r\n\r\nFor more details about HPE Redfish services, refer to the official documentation:\r\nhttps://servermanagementportal.ext.hpe.com/docs/redfishservices/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d50f6dcfc3e44244a0fc9fd933607024','HPE ILO BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10606',NULL,'Azure Cost Management by HTTP','3','-1','2','','','Azure Cost Management by HTTP','0',NULL,'This template is designed to monitor Microsoft Cost Management by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c0263df8d8c14d30b24afcf45a6a354f','AZURE COST MANAGEMENT BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor Microsoft Cost Management by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\n## Setup\r\n\r\n1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n\r\n      `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n\r\n> See [Azure documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli) for more details.\r\n\r\n2. Link the template to a host.\r\n3. Configure the macros: `Azure App ID`, `Azure password`, `Azure tenant ID`, `Azure subscription ID`.'),
('10607',NULL,'AWS ELB Application Load Balancer by HTTP','3','-1','2','','','AWS ELB Application Load Balancer by HTTP','0',NULL,'The template is designed to monitor AWS ELB Application Load Balancer by HTTP via Zabbix, and it works without any external scripts.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f59c8b4156ec4386a7c724534ddd384d','AWS ELB APPLICATION LOAD BALANCER BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\n*Please scroll down for AWS ELB Network Load Balancer by HTTP.*\r\n\r\nThe template is designed to monitor AWS ELB Application Load Balancer by HTTP via Zabbix, and it works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThis template uses the GetMetricData CloudWatch API calls to list and retrieve metrics.\r\nFor more information, please refer to the [CloudWatch pricing](https://aws.amazon.com/cloudwatch/pricing/) page.\r\n\r\nAdditional information about metrics and API methods used in the template:\r\n* [Full metrics list related to AWS ELB Application Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-cloudwatch-metrics.html)\r\n* [DescribeAlarms API method](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)\r\n* [DescribeTargetGroups API method](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)\r\n\r\n\r\n## Setup\r\n\r\nThe template gets AWS ELB Application Load Balancer metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\n\r\nBefore using the template, you need to create an IAM policy with the necessary permissions for the Zabbix role in your AWS account. For more information, visit the [ELB policies page](https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/elb-api-permissions.html) on the AWS website.\r\n\r\n### Required Permissions\r\nAdd the following required permissions to your Zabbix IAM policy in order to collect AWS ELB Application Load Balancer metrics.\r\n\r\n```json\r\n{\r\n    "Version":"2012-10-17",\r\n    "Statement":[\r\n        {\r\n          "Action":[\r\n              "cloudwatch:DescribeAlarms",\r\n              "cloudwatch:GetMetricData",\r\n              "elasticloadbalancing:DescribeTargetGroups"\r\n          ],\r\n          "Effect":"Allow",\r\n          "Resource":"*"\r\n        }\r\n    ]\r\n  }\r\n```\r\n\r\n### Access Key Authorization\r\n\r\nIf you are using access key authorization, you need to generate an access key and secret key for an IAM user with the necessary permissions:\r\n\r\n1. Create an IAM user with programmatic access.\r\n2. Attach the required policy to the IAM user.\r\n3. Generate an access key and secret key.\r\n4. Use the generated credentials in the macros `Access key ID` and `Secret access key`.\r\n\r\n### Assume role authorization\r\nFor using assume role authorization, add the appropriate permissions to the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "sts:AssumeRole",\r\n            "Resource": "arn:aws:iam::{Account}:user/{UserName}"\r\n        },\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "elasticloadbalancing:DescribeTargetGroups"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Assume Role Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n  "Version": "2012-10-17",\r\n  "Statement": [\r\n    {\r\n      "Effect": "Allow",\r\n      "Principal": {\r\n        "AWS": "arn:aws:iam::{Account}:user/{UserName}"\r\n      },\r\n      "Action": "sts:AssumeRole"\r\n    }\r\n  ]\r\n}\r\n```\r\nSet the following fields: `Access key ID`, `Secret access key`, `STS Region`, `ARN assume role`.\r\n\r\n### Role-Based Authorization\r\nIf you are using role-based authorization, set the appropriate permissions:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "iam:PassRole",\r\n            "Resource": "arn:aws:iam::<<--account-id-->>:role/<<--role_name-->>"\r\n        },\r\n        {\r\n            "Sid": "VisualEditor1",\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "elasticloadbalancing:DescribeTargetGroups",\r\n                "ec2:AssociateIamInstanceProfile",\r\n                "ec2:ReplaceIamInstanceProfileAssociation"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Role-Based Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Principal": {\r\n                "Service": [\r\n                    "ec2.amazonaws.com"\r\n                ]\r\n            },\r\n            "Action": [\r\n                "sts:AssumeRole"\r\n            ]\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n**Note**: Using role-based authorization is only possible when you use a Zabbix server or proxy inside AWS.\r\n\r\nSet the following fields: `Authorization method`, `AWS Region`, and `Load Balancer ARN`.\r\n\r\nFor more information about managing access keys, see [official AWS documentation](https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys).\r\n\r\nSee the section below for a list of macros used for LLD filters.'),
('10609',NULL,'MSSQL by Zabbix agent 2','3','-1','2','','','MSSQL by Zabbix agent 2','0',NULL,'This template is designed for the effortless deployment of MSSQL monitoring by Zabbix via Zabbix agent 2 and uses a loadable plugin to run SQL queries.\r\n\r\nSetup:\r\n\r\n1. Deploy Zabbix agent 2 with the MSSQL plugin. You can use this template starting with version 7.4.0 of both Zabbix and the MSSQL plugin.\r\n\r\n  For more information, see MSSQL plugin documentation: https://git.zabbix.com/projects/AP/repos/mssql/browse\r\n\r\n  Important! Starting with version 7.4-1 of this template, the MSSQL plugin must be updated to a version equal to or above 7.4.0. (You can check the version of the template in its YAML file under the "vendor" section.)\r\n\r\n  Loadable plugin requires installation of one of the following:\r\n\r\n  - Separate package\r\n  \r\n  - Binary file\r\n  \r\n  - Compilation from sources: https://www.zabbix.com/documentation/7.4/manual/extensions/plugins/build\r\n\r\n2. Create an MSSQL user for monitoring.\r\n\r\n  View Server State and View Any Definition permissions should be granted to the user.\r\n  Grant this user read permissions to the sysjobschedules, sysjobhistory, and sysjobs tables.\r\n\r\n  For more information, see MSSQL documentation:\r\n  \r\n  - Create a database user: https://docs.microsoft.com/en-us/sql/relational-databases/security/authentication-access/create-a-database-user?view=sql-server-ver16\r\n  \r\n  - GRANT Server Permissions: https://docs.microsoft.com/en-us/sql/t-sql/statements/grant-server-permissions-transact-sql?view=sql-server-ver16\r\n  \r\n  - Configure a User to Create and Manage SQL Server Agent Jobs: https://docs.microsoft.com/en-us/sql/ssms/agent/configure-a-user-to-create-and-manage-sql-server-agent-jobs?view=sql-server-ver16\r\n\r\n3. Set the user name and password in the host macros ({$MSSQL.USER} and {$MSSQL.PASSWORD}).\r\n\r\n4. Set the connection string for the MSSQL instance in the {$MSSQL.URI} macro as a URI, such as <protocol://host:port>, or specify the named session - <sessionname>.\r\n\r\nThe "Service\'s TCP port state" item uses the {$MSSQL.HOST} and {$MSSQL.PORT} macros to check the availability of the MSSQL instance, change these if necessary. Keep in mind that if dynamic ports are used on the MSSQL server side, this check will not work correctly.\r\n\r\nNote: You can use the context macros {$MSSQL.BACKUP_FULL.USED}, {$MSSQL.BACKUP_LOG.USED}, and {$MSSQL.BACKUP_DIFF.USED} to disable backup age triggers for a certain database. If set to a value other than "1", the trigger expression for the backup age will not fire.\r\n\r\nNote: Since version 7.2.0, you can also connect to the MSSQL instance using its name. To do this, set the connection string in the {$MSSQL.URI} macro as <protocol://host/instance_name>.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','75fc96367e8d4588ba8314145fc12d35','MSSQL BY ZABBIX AGENT 2','Zabbix','7.4-2',NULL,'0','1','## Setup\r\n\r\n1. Create an MSSQL user for monitoring. For example, "zbx_monitor".\r\n\r\n**View Server State** and **View Any Definition** permissions should be granted to the user.\r\nGrant this user read permissions to the `sysjobschedules`, `sysjobhistory`, and `sysjobs` tables.\r\n\r\nFor example, using T-SQL commands:\r\n\r\n```sql\r\nGRANT SELECT ON OBJECT::msdb.dbo.sysjobs TO zbx_monitor;\r\nGRANT SELECT ON OBJECT::msdb.dbo.sysjobservers TO zbx_monitor;\r\nGRANT SELECT ON OBJECT::msdb.dbo.sysjobactivity TO zbx_monitor;\r\nGRANT EXECUTE ON OBJECT::msdb.dbo.agent_datetime TO zbx_monitor;\r\n```\r\n\r\nFor more information, see MSSQL documentation:\r\n\r\n[Create a database user](https://docs.microsoft.com/en-us/sql/relational-databases/security/authentication-access/create-a-database-user?view=sql-server-ver16)\r\n\r\n[GRANT Server Permissions](https://docs.microsoft.com/en-us/sql/t-sql/statements/grant-server-permissions-transact-sql?view=sql-server-ver16)\r\n\r\n[Configure a User to Create and Manage SQL Server Agent Jobs](https://docs.microsoft.com/en-us/sql/ssms/agent/configure-a-user-to-create-and-manage-sql-server-agent-jobs?view=sql-server-ver16)\r\n\r\n2. Set the username and password in the `MSSQL user` and `MSSQL password` host wizard configuration fields.\r\n\r\n3. Set the connection string for the MSSQL instance in the `MSSQL URI` host wizard configuration field as a URI, such as `<protocol://host:port>`, or specify the named session - `<sessionname>`.\r\n\r\nThe `Service\'s TCP port state` item uses the `MSSQL address` and `MSSQL TCP port` host wizard configuration fields to check the availability of the MSSQL instance, change these if necessary. Keep in mind that if dynamic ports are used on the MSSQL server side, this check will not work correctly.\r\n\r\nNote: You can use the `Monitoring of full backup`, `Monitoring of log backup`, and `Monitoring of differential backup` host wizard configuration fields to disable backup age triggers. If set to unselected state, the trigger expression for the backup age will not fire.\r\n\r\nNote: Since version 7.2.0, you can also connect to the MSSQL instance using its name. To do this, set the connection string in the `MSSQL URI` host wizard configuration field as `<protocol://host/instance_name>`.'),
('10610',NULL,'YugabyteDB by HTTP','3','-1','2','','','YugabyteDB by HTTP','0',NULL,'This template is designed for the deployment of YugabyteDB monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n\r\nTo set up the template:\r\n\r\n1. Set your account ID as a value of the {$YUGABYTEDB.ACCOUNT.ID} macro. The account ID is the unique identifier for your customer account in YugabyteDB Managed. You can access the account ID from your profile in the YugabyteDB Managed user interface. To get your account ID, log in to YugabyteDB Managed and click the user profile icon. \r\nSee YugabyteDB documentation for instructions:\r\nhttps://yugabyte.stoplight.io/docs/managed-apis/tvsjh28t5ivmw-getting-started#account-id\r\n\r\n2. Set your project ID as a value of the {$YUGABYTEDB.PROJECT.ID} macro. The project ID is the unique identifier for a YugabyteDB Managed project. You can access the project ID from your profile in the YugabyteDB Managed user interface (along with the account ID). \r\nSee YugabyteDB documentation for instructions:\r\nhttps://yugabyte.stoplight.io/docs/managed-apis/tvsjh28t5ivmw-getting-started#project-id\r\n\r\n3. Generate the API access token and specify it as a value of the {$YUGABYTEDB.ACCESS.TOKEN} macro. \r\nSee YugabyteDB documentation for instructions:\r\nhttps://docs.yugabyte.com/preview/yugabyte-cloud/managed-automation/managed-apikeys/#create-an-api-key\r\n\r\nNOTE: If needed, you can specify a HTTP proxy for the template to use by changing the value of the {$YUGABYTEDB.PROXY} user macro.\r\n\r\nIMPORTANT! The value of the {$YUGABYTEDB.ACCESS.TOKEN} macro is stored as plain (not secret) text by default.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','bc056b1724e748bba50928f8cc605f8e','YUGABYTEDB BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10611',NULL,'YugabyteDB Cluster by HTTP','3','-1','2','','','YugabyteDB Cluster by HTTP','0',NULL,'This template is designed for the deployment of YugabyteDB clusters monitoring by Zabbix via HTTP and doesn\'t require any external scripts. This template will be automatically connected to discovered entities with all required parameters pre-defined.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f5fff9a83f774f4688692ad58aa35d45','YUGABYTEDB CLUSTER BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10613',NULL,'Check Point Next Generation Firewall by SNMP','3','-1','2','','','Check Point Next Generation Firewall by SNMP','0',NULL,'The template for monitoring Check Point Quantum Next Generation Firewall Security Gateway by SNMP.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nCHECKPOINT-MIB\r\nUCD-SNMP-MIB\r\nSNMPv2-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3a7ff6eb19bb4a42b5b5b34a7179b30c','CHECK POINT NEXT GENERATION FIREWALL BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10614',NULL,'Oracle Cloud Autonomous Database by HTTP','3','-1','2','','','Oracle Cloud Autonomous Database by HTTP','0',NULL,'This template monitors Oracle Cloud Infrastructure (OCI) autonomous database (serverless) resources.\r\n\r\nThis template is not meant to be used independently, but together with Oracle Cloud by HTTP as a template for\r\nLLD host prototypes.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','178645e229484bcf9cb030dc1edccebb','ORACLE CLOUD AUTONOMOUS DATABASE BY HTTP','Zabbix','7.4-3',NULL,'0','0',''),
('10615',NULL,'Oracle Cloud Block Volume by HTTP','3','-1','2','','','Oracle Cloud Block Volume by HTTP','0',NULL,'This template monitors Oracle Cloud Infrastructure (OCI) block volume resources.\r\n\r\nThis template is not meant to be used independently, but together with Oracle Cloud by HTTP as a template for\r\nLLD host prototypes.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8afa1796d280425b99c7ea36900dac24','ORACLE CLOUD BLOCK VOLUME BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10616',NULL,'Oracle Cloud Boot Volume by HTTP','3','-1','2','','','Oracle Cloud Boot Volume by HTTP','0',NULL,'Monitor Oracle Cloud Infrastructure (OCI) boot volume.\r\n\r\nThis template is not meant to be used independently, but instead with Oracle Cloud by HTTP as a template for\r\nLLD host prototypes.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e5486d98ff414c1391de1bd369a7f9db','ORACLE CLOUD BOOT VOLUME BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10617',NULL,'Oracle Cloud by HTTP','3','-1','2','','','Oracle Cloud by HTTP','0',NULL,'Monitor resources of Oracle Cloud Infrastructure (OCI) services.\r\n\r\nThis template handles discovery of various OCI services.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','057558a26d934b4683d73a7058499d62','ORACLE CLOUD BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis template is designed as a master template that discovers various Oracle Cloud Infrastructure (OCI) services\r\nand resources, such as:\r\n\r\n* OCI Compute;\r\n\r\n* OCI Autonomous Database (serverless);\r\n\r\n* OCI Object Storage;\r\n\r\n* OCI Virtual Cloud Networks (VCNs);\r\n\r\n* OCI Block Volumes;\r\n\r\n* OCI Boot Volumes.\r\n\r\nFor communication with OCI, this template utilizes script items which execute HTTP `GET` and `POST` requests. \r\n`POST` requests are required for OCI Monitoring API as it utilizes Monitoring Query Language (MQL) which uses an\r\nHTTP request body for queries.\r\n\r\n\r\n## Setup\r\n\r\n## Required setup\r\n\r\nFor this template to work, it needs authentication details to use in requests. To acquire this information, see\r\nthe following steps:\r\n\r\n1. Log into your administrator account in Oracle Cloud Console.\r\n\r\n2. Create a new user that will be used by Zabbix for monitoring.\r\n\r\n3. Create a new security policy and assign a previously created user to it.\r\n\r\n4. This policy will contain a set of rules that will give monitoring user access to specific resources in your\r\nOCI. Make sure to add the following rules to the policy:\r\n  \r\n    ```\r\n    Allow group \'zabbix_api\' to read metrics in tenancy\r\n    Allow group \'zabbix_api\' to read instances in tenancy\r\n    Allow group \'zabbix_api\' to read subnets in tenancy\r\n    Allow group \'zabbix_api\' to read vcns in tenancy\r\n    Allow group \'zabbix_api\' to read vnic-attachments in tenancy\r\n    Allow group \'zabbix_api\' to read volumes in tenancy\r\n    Allow group \'zabbix_api\' to read objectstorage-namespaces in tenancy\r\n    Allow group \'zabbix_api\' to read buckets in tenancy\r\n    Allow group \'zabbix_api\' to read autonomous-databases in tenancy\r\n    ```\r\n  \r\n    In this example, `zabbix_api` is the name of the previously created monitoring user. Rename it to your\r\nmonitoring user\'s name.\r\n\r\n5. Generate an API key pair for your monitoring user - open your monitoring user profile and on the left side,\r\npress `API keys` and then, `Add API key` (if generating a new key pair, do not forget to save the private key).\r\n  \r\n6. After this, Oracle Cloud Console will provide additional information that is required for access, such as:\r\n\r\n    * Tenancy OCID;\r\n      \r\n    * User OCID;\r\n      \r\n    * Fingerprint;\r\n      \r\n    * Region.\r\n\r\n    > Save this information somewhere or keep this window open. This information will be required in later steps.\r\n\r\n7. In Zabbix, create a new host and assign this template to it (Oracle Cloud by HTTP).\r\n\r\n8. In host wizard configuration fields please set next values (from step #6):\r\n\r\n    * `OCID tenancy` - set the tenancy OCID value;\r\n      \r\n    * `OCID user` - set the user OCID value;\r\n      \r\n    * `Fingerprint` - set the fingerprint value;\r\n      \r\n    * `Private key` - copy and paste the contents of private key file here.\r\n\r\n9. After the authentication credentials are entered, you need to identify the OCI API endpoints that match your\r\nregion (as provided by Oracle Cloud Console in step #6).\r\nTo do so, you can use the OCI [API Reference and Endpoints](https://docs.public.oneportal.content.oci.oraclecloud.com/en-us/iaas/api/#/) list, where each API service has a dedicated page with the respective API endpoints.\r\n\r\n   The required API service endpoints are:\r\n  \r\n   * [Core Services API](https://docs.public.oneportal.content.oci.oraclecloud.com/en-us/iaas/api/#/en/iaas/20160918/);\r\n  \r\n   * [Database Service API](https://docs.public.oneportal.content.oci.oraclecloud.com/en-us/iaas/api/#/en/database/20160918/);\r\n  \r\n   * [Object Storage Service API](https://docs.public.oneportal.content.oci.oraclecloud.com/en-us/iaas/api/#/en/objectstorage/20160918/);\r\n  \r\n   * [Monitoring API](https://docs.public.oneportal.content.oci.oraclecloud.com/en-us/iaas/api/#/en/monitoring/20180401/).\r\n        \r\n10. When the API endpoints are identified, you need to set them in host wizard configuration fields (similarly to step #8):\r\n\r\n    * `Core Services host` - Core Services API endpoint, for example, `iaas.eu-stockholm-1.oraclecloud.com`;\r\n\r\n    * `Database Service host` - Database Service API endpoint, for example, `database.eu-stockholm-1.oraclecloud.com`;\r\n\r\n    * `Object Storage host` - Object Storage Service API endpoint, for example, `objectstorage.eu-stockholm-1.oraclecloud.com`;\r\n\r\n    * `Monitoring host` - Monitoring API endpoint, for example, `telemetry.eu-stockholm-1.oraclecloud.com`;\r\n                            \r\n    > IMPORTANT! API Endpoint URLs need to be entered without the HTTP scheme (`https://`).\r\n                            \r\n11. Once you\'ve completed adding the host to Zabbix, and it will automatically discover services and monitor them.\r\n\r\n## Optional setup\r\n\r\n#### Example\r\n\r\n1. In Oracle Cloud Console, add a free-form tag to a resource, for example, a compute instance.\r\nThe tag key will be `location_group` and the tag value will be `eu-north-1`.\r\n\r\n2. Open the Oracle Cloud by HTTP template in Zabbix and go to "Discovery rules".\r\nFind "Compute instances discovery" and open it.\r\n\r\n3. Under "LLD macros", add a new macro that will represent this location group tag, for example:\r\n`{#LOCATION_GROUP}` `$.tags.location_group`.\r\n                                                                                            \r\n4. Under the "Filters" tab, there will already be filters regarding the compute instance name and state.\r\nClick "Add" to add a new filter and define the previously created LLD macro and add a matching pattern and\r\nvalue, for example, `{#LOCATION_GROUP}` `matches` `eu-north-*`.\r\n\r\n5. The next time `Compute instances discovery` is executed, it will only discover OCI compute instances that\r\nhave the free-form tag `location_group` that matches the regex of `eu-north-*`. You can also experiment with\r\nthe LLD filter pattern matching value to receive different matching results for a specified value.'),
('10618',NULL,'Oracle Cloud Compute by HTTP','3','-1','2','','','Oracle Cloud Compute by HTTP','0',NULL,'This template monitors Oracle Cloud Infrastructure (OCI) single compute instance resources and discovers attached\r\nvirtual network interface cards (VNICs) and monitors their resources.\r\n\r\nThis template is not meant to be used independently, but together with Oracle Cloud by HTTP as a template for\r\nLLD host prototypes.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e6b0aada359944d09ee4bd46c1a55587','ORACLE CLOUD COMPUTE BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10619',NULL,'Oracle Cloud Networking by HTTP','3','-1','2','','','Oracle Cloud Networking by HTTP','0',NULL,'This template monitors Oracle Cloud Infrastructure (OCI) single virtual network card availability and discovers\r\nattached subnets and monitors their availability.\r\n\r\nThis template is not meant to be used independently, but together with Oracle Cloud by HTTP as a template for \r\nLLD host prototypes.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','62d99b55585e41dd89736f5f46074dcb','ORACLE CLOUD NETWORKING BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10620',NULL,'Oracle Cloud Object Storage by HTTP','3','-1','2','','','Oracle Cloud Object Storage by HTTP','0',NULL,'This template monitors Oracle Cloud Infrastructure (OCI) object storage resources.\r\n\r\nThis template is not meant to be used independently, but together with Oracle Cloud by HTTP as a template for\r\nLLD host prototypes.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e8f89476695848e99ba900a5664d290b','ORACLE CLOUD OBJECT STORAGE BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10627',NULL,'AWS ELB Network Load Balancer by HTTP','3','-1','2','','','AWS ELB Network Load Balancer by HTTP','0',NULL,'The template is designed to monitor AWS ELB Network Load Balancer by HTTP via Zabbix, and it works without any external scripts.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4c7d0c6e342b40458611bdb6e9dd958f','AWS ELB NETWORK LOAD BALANCER BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThe template is designed to monitor AWS ELB Network Load Balancer by HTTP via Zabbix, and it works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThis template uses the GetMetricData CloudWatch API calls to list and retrieve metrics.\r\nFor more information, please refer to the [CloudWatch pricing](https://aws.amazon.com/cloudwatch/pricing/) page.\r\n\r\nAdditional information about metrics and API methods used in the template:\r\n* [Full metrics list related to AWS ELB Network Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-cloudwatch-metrics.html)\r\n* [DescribeAlarms API method](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)\r\n* [DescribeTargetGroups API method](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)\r\n\r\n\r\n## Setup\r\n\r\nThe template gets AWS ELB Network Load Balancer metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\n\r\nBefore using the template, you need to create an IAM policy with the necessary permissions for the Zabbix role in your AWS account. For more information, visit the [ELB policies page](https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/elb-api-permissions.html) on the AWS website.\r\n\r\n### Required Permissions\r\nAdd the following required permissions to your Zabbix IAM policy in order to collect AWS ELB Network Load Balancer metrics.\r\n\r\n```json\r\n{\r\n    "Version":"2012-10-17",\r\n    "Statement":[\r\n        {\r\n          "Action":[\r\n              "cloudwatch:DescribeAlarms",\r\n              "cloudwatch:GetMetricData",\r\n              "elasticloadbalancing:DescribeTargetGroups"\r\n          ],\r\n          "Effect":"Allow",\r\n          "Resource":"*"\r\n        }\r\n    ]\r\n  }\r\n```\r\n\r\n### Access Key Authorization\r\n\r\nIf you are using access key authorization, you need to generate an access key and secret key for an IAM user with the necessary permissions:\r\n\r\n1. Create an IAM user with programmatic access.\r\n2. Attach the required policy to the IAM user.\r\n3. Generate an access key and secret key.\r\n4. Use the generated credentials in the macros `Access key ID` and `Secret access key`.\r\n\r\n### Assume role authorization\r\nFor using assume role authorization, add the appropriate permissions to the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "sts:AssumeRole",\r\n            "Resource": "arn:aws:iam::{Account}:user/{UserName}"\r\n        },\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "elasticloadbalancing:DescribeTargetGroups"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Assume Role Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n  "Version": "2012-10-17",\r\n  "Statement": [\r\n    {\r\n      "Effect": "Allow",\r\n      "Principal": {\r\n        "AWS": "arn:aws:iam::{Account}:user/{UserName}"\r\n      },\r\n      "Action": "sts:AssumeRole"\r\n    }\r\n  ]\r\n}\r\n```\r\nSet the following fields: `Access key ID`, `Secret access key`, `STS Region`, `ARN assume role`.\r\n\r\n### Role-Based Authorization\r\nIf you are using role-based authorization, set the appropriate permissions:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "iam:PassRole",\r\n            "Resource": "arn:aws:iam::<<--account-id-->>:role/<<--role_name-->>"\r\n        },\r\n        {\r\n            "Sid": "VisualEditor1",\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "elasticloadbalancing:DescribeTargetGroups",\r\n                "ec2:AssociateIamInstanceProfile",\r\n                "ec2:ReplaceIamInstanceProfileAssociation"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Role-Based Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Principal": {\r\n                "Service": [\r\n                    "ec2.amazonaws.com"\r\n                ]\r\n            },\r\n            "Action": [\r\n                "sts:AssumeRole"\r\n            ]\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n**Note**: Using role-based authorization is only possible when you use a Zabbix server or proxy inside AWS.\r\n\r\nSet the following fields: `Authorization method`, `AWS Region`, and `Load Balancer ARN`.\r\n\r\nFor more information about managing access keys, see [official AWS documentation](https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys).\r\n\r\nSee the section below for a list of macros used for LLD filters.'),
('10628',NULL,'Website by Browser','3','-1','2','','','Website by Browser','0',NULL,'The template to monitor a website\'s availability and performance on the website by Browser.\r\n\r\nZabbix server uses a web browser to perform navigation and collect performance metrics.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2526dce71d714e31bd545e96370c67b2','WEBSITE BY BROWSER','Zabbix','7.4-1',NULL,'0','0',''),
('10629',NULL,'GitHub repository by HTTP','3','-1','2','','','GitHub repository by HTTP','0',NULL,'This template is designed for the effortless deployment of GitHub repository monitoring by Zabbix via GitHub REST API and doesn\'t require any external scripts.\r\n\r\nFor more details about GitHub REST API, refer to the official documentation:\r\nhttps://docs.github.com/en/rest?apiVersion=2022-11-28\r\n\r\nSetup:\r\n\r\n1. Create an access token for monitoring\r\n\r\nOne of the simplest ways to send authenticated requests is to use a personal access token - either a classic or a fine-grained one:\r\nhttps://docs.github.com/en/rest/authentication/authenticating-to-the-rest-api?apiVersion=2022-11-28#authenticating-with-a-personal-access-token\r\n\r\nClassic personal access token\r\n\r\nYou can create a new classic personal access token by following the instructions in the official documentation:\r\nhttps://docs.github.com/en/authentication/keeping-your-account-and-data-secure/managing-your-personal-access-tokens#creating-a-personal-access-token-classic\r\n\r\nFor public repositories, no additional permission scopes are required. For monitoring to work on private repositories, the "repo" scope must be set to have full control of private repositories.\r\n\r\nAdditional information about OAuth scopes is available in the official documentation:\r\nhttps://docs.github.com/en/apps/oauth-apps/building-oauth-apps/scopes-for-oauth-apps#available-scopes\r\n\r\nNote that authenticated users must have admin access to the repository and the "repo" scope must be set to get information about self-hosted runners:\r\nhttps://docs.github.com/en/rest/actions/self-hosted-runners?apiVersion=2022-11-28#list-self-hosted-runners-for-a-repository\r\n\r\nFine-grained personal access token\r\n\r\nAlternatively, you can use a fine-grained personal access token:\r\nhttps://docs.github.com/en/authentication/keeping-your-account-and-data-secure/managing-your-personal-access-tokens#creating-a-fine-grained-personal-access-token\r\n\r\nIn order to use fine-grained tokens to monitor organization-owned repositories, organizations must opt in to fine-grained personal access tokens and set up a personal access token policy:\r\nhttps://docs.github.com/en/organizations/managing-programmatic-access-to-your-organization/setting-a-personal-access-token-policy-for-your-organization\r\n\r\nThe fine-grained token needs to have the following permissions set to provide access to the repository resources:\r\n- "Actions" repository permissions (read);\r\n- "Administration" repository permissions (read);\r\n- "Contents" repository permissions (read);\r\n- "Issues" repository permissions (read);\r\n- "Metadata" repository permissions (read);\r\n- "Pull requests" repository permissions (read).\r\n\r\n2. Set the access token that you\'ve created in step 1 in the "{$GITHUB.API.TOKEN}" macro\r\n3. Change the API URL in the "{$GITHUB.API.URL}" macro if needed (for self-hosted installations)\r\n4. Set the repository owner name in the "{$GITHUB.REPO.OWNER}" macro\r\n5. Set the repository name in the "{$GITHUB.REPO.NAME}" macro\r\n6. Set the LLD rule filters if needed (you may want to use it to also stay within rate limits as on large repositories, LLD rules may generate a lot of script items)\r\n\r\nNote: Update intervals and timeouts for script items can be changed individually via "{$GITHUB.INTERVAL}" and "{$GITHUB.TIMEOUT}" macros with context. Depending on the repository being monitored, it can be adjusted if needed (if you are exceeding rate limits, you can increase update intervals for some script items to stay within per hour request limits). But be aware that it may also affect the triggers (check whether the item is used in triggers and adjust thresholds and/or evaluation periods if needed).\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','11144543d1144a3693aa0b97a1c20dac','GITHUB REPOSITORY BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10630',NULL,'Jira Data Center by JMX','3','-1','2','','','Jira Data Center by JMX','0',NULL,'This template is used for monitoring Jira Data Center health. It is designed for standalone operation for on-premises Jira installations.\r\n\r\nThis template uses a single data source, JMX, which requires JMX RMI setup of your Jira application and Java Gateway setup on the Zabbix side.\r\nIf you need "Garbage collector" and "Web server" monitoring, add "Generic Java JMX" and "Apache Tomcat by JMX" templates on the same host.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nSetup:\r\n  Metrics are collected by JMX.\r\n  0. Deploy the Zabbix Java Gateway component ([instructions](https://www.zabbix.com/documentation/7.4/manual/concepts/java)).\r\n  1. Enable and configure JMX access to Jira Data Center. See documentation for [instructions](https://confluence.atlassian.com/adminjiraserver/live-monitoring-using-the-jmx-interface-939707304.html).\r\n  2. Assign the "Jira Data Center by JMX" template to the host with a JMX interface.\r\n  2. If your Jira installation requires authentication for JMX, set the values in the host macros `{$JMX.USERNAME}` and `{$JMX.PASSWORD}`.\r\n  3. (Optional) Set custom macro values and add macros with context for specific metrics following the macro description.\r\n  4. (Optional) Assign the "Generic Java JMX" template for garbage collector monitoring.\r\n  5. (Optional) Assign the "Apache Tomcat by JMX" template for web server monitoring.\r\n\r\ntested_on:\r\n  - Jira Data Center 9.14.1\r\n  - Jira Data Center 9.12.4\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a7f0c853c6634b1dacaaf43c2a0d9375','JIRA DATA CENTER BY JMX','Zabbix','7.4-1',NULL,'0','0',''),
('10631',NULL,'Microsoft 365 reports by HTTP','3','-1','2','','','Microsoft 365 reports by HTTP','0',NULL,'This template is designed to monitor Microsoft 365 reports by HTTP. It works without any external scripts and uses script items.\r\nThe template uses endpoints in the Microsoft Graph API to gather daily metrics from weekly reports.\r\nThe template is meant to be used as a long-term trend monitoring tool.\r\n\r\nSetup:\r\n  1. Register the app with Microsoft Entra ID.\r\n  2. Configure Microsoft Graph application permissions on the app ID:\r\n    `Reports.Read.All` - required for app usage and activity metrics\r\n    `ServiceHealth.Read.All` - required for service discovery and service status metrics\r\n  3. Request administrator consent.\r\n  4. Configure the macros: `{$MS365.APP.ID}`, `{$MS365.PASSWORD}`, `{$MS365.TENANT.ID}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','03e93dc9a8194a17958544a056d02316','MICROSOFT 365 REPORTS BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10632',NULL,'AWS Lambda by HTTP','3','-1','2','','','AWS Lambda by HTTP','0',NULL,'The template is designed to monitor AWS Lambda by HTTP via Zabbix, and it works without any external scripts.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fd36e0a231d343d38a95d1ed789584ca','AWS LAMBDA BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis template uses the GetMetricData CloudWatch API calls to list and retrieve metrics.\r\nFor more information, please refer to the [CloudWatch pricing](https://aws.amazon.com/cloudwatch/pricing/) page.\r\n\r\nAdditional information about metrics and API methods used in the template:\r\n* [Full metrics list related to AWS Lambda](https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics.html)\r\n* [DescribeAlarms API method](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)\r\n\r\n\r\n## Setup\r\n\r\nThe template gets AWS Lambda metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\n\r\nBefore using the template, you need to create an IAM policy with the necessary permissions for the Zabbix role in your AWS account. For more information, visit the [Lambda permissions page](https://docs.aws.amazon.com/lambda/latest/dg/lambda-permissions.html) on the AWS website.\r\n\r\n### Required Permissions\r\nAdd the following required permissions to your Zabbix IAM policy in order to collect AWS Lambda metrics.\r\n\r\n```json\r\n{\r\n    "Version":"2012-10-17",\r\n    "Statement":[\r\n        {\r\n          "Action":[\r\n              "cloudwatch:DescribeAlarms",\r\n              "cloudwatch:GetMetricData"\r\n          ],\r\n          "Effect":"Allow",\r\n          "Resource":"*"\r\n        }\r\n    ]\r\n  }\r\n```\r\n\r\n### Access Key Authorization\r\n\r\nIf you are using access key authorization, you need to generate an access key and secret key for an IAM user with the necessary permissions:\r\n\r\n1. Create an IAM user with programmatic access.\r\n2. Attach the required policy to the IAM user.\r\n3. Generate an access key and secret key.\r\n4. Use the generated credentials in the macros `Access key ID` and `Secret access key`.\r\n\r\n### Assume role authorization\r\nFor using assume role authorization, add the appropriate permissions to the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "sts:AssumeRole",\r\n            "Resource": "arn:aws:iam::{Account}:user/{UserName}"\r\n        },\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n#### Trust Relationships for Assume Role Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n  "Version": "2012-10-17",\r\n  "Statement": [\r\n    {\r\n      "Effect": "Allow",\r\n      "Principal": {\r\n        "AWS": "arn:aws:iam::{Account}:user/{UserName}"\r\n      },\r\n      "Action": "sts:AssumeRole"\r\n    }\r\n  ]\r\n}\r\n```\r\nSet the following fields: `Access key ID`, `Secret access key`, `STS Region`, `ARN assume role`.\r\n\r\n### Role-Based Authorization\r\nIf you are using role-based authorization, set the appropriate permissions:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Action": "iam:PassRole",\r\n            "Resource": "arn:aws:iam::<<--account-id-->>:role/<<--role_name-->>"\r\n        },\r\n        {\r\n            "Sid": "VisualEditor1",\r\n            "Effect": "Allow",\r\n            "Action": [\r\n                "cloudwatch:DescribeAlarms",\r\n                "cloudwatch:GetMetricData",\r\n                "ec2:AssociateIamInstanceProfile",\r\n                "ec2:ReplaceIamInstanceProfileAssociation"\r\n            ],\r\n            "Resource": "*"\r\n        }\r\n    ]\r\n}\r\n```\r\n#### Trust Relationships for Role-Based Authorization\r\nNext, add a principal to the trust relationships of the role you are using:\r\n\r\n```json\r\n{\r\n    "Version": "2012-10-17",\r\n    "Statement": [\r\n        {\r\n            "Effect": "Allow",\r\n            "Principal": {\r\n                "Service": [\r\n                    "ec2.amazonaws.com"\r\n                ]\r\n            },\r\n            "Action": [\r\n                "sts:AssumeRole"\r\n            ]\r\n        }\r\n    ]\r\n}\r\n```\r\n\r\n**Note**: Using role-based authorization is only possible when you use a Zabbix server or proxy inside AWS.\r\n\r\nSet the following fields: `Authorization method`, `AWS Region`, and `Lambda function ARN`.\r\n\r\nFor more information about managing access keys, see the [official AWS documentation](https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys).\r\n\r\nSee the section below for a list of macros used for LLD filters.'),
('10634',NULL,'Azure VM Scale Set by HTTP','3','-1','2','','','Azure VM Scale Set by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure virtual machine scale sets by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d0fd5d346b1740dda9d3a976371789dd','AZURE VM SCALE SET BY HTTP','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor Microsoft Azure virtual machine scale sets by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\n## Setup\r\n\r\n1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n\r\n      `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n\r\n> See [Azure documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli) for more details.\r\n\r\n2. Link the template to a host.\r\n3. Configure the macros: `Azure App ID`, `Azure password`, `Azure tenant ID`, `Azure subscription ID`, and `Azure scale set ID`.'),
('10636',NULL,'Huawei OceanStor V6 by SNMP','3','-1','2','','','Huawei OceanStor V6 by SNMP','0',NULL,'This template is developed to monitor SAN Huawei OceanStor V6 via the Zabbix SNMP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418855-discussion-thread-for-official-zabbix-template-huawei-oceanstor\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','521d864fe8574f19b350f7ddbe259042','HUAWEI OCEANSTOR V6 BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10637',NULL,'Apache by Zabbix agent active','3','-1','2','','','Apache by Zabbix agent active','0',NULL,'Get metrics from mod_status module using HTTP agent.\r\nhttps://httpd.apache.org/docs/current/mod/mod_status.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','aa3286a824464020863ead141e8f0afc','APACHE BY ZABBIX AGENT ACTIVE','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is designed for the effortless deployment of Apache monitoring by Zabbix via Zabbix agent and doesn\'t require any external scripts.\r\nThe template `Apache by Zabbix agent` - collects metrics by polling [mod_status](https://httpd.apache.org/docs/current/mod/mod_status.html) locally with Zabbix agent:\r\n  \r\n```text\r\n127.0.0.1\r\nServerVersion: Apache/2.4.41 (Unix)\r\nServerMPM: event\r\nServer Built: Aug 14 2019 00:35:10\r\nCurrentTime: Friday, 16-Aug-2019 12:38:40 UTC\r\nRestartTime: Wednesday, 14-Aug-2019 07:58:26 UTC\r\nParentServerConfigGeneration: 1\r\nParentServerMPMGeneration: 0\r\nServerUptimeSeconds: 189613\r\nServerUptime: 2 days 4 hours 40 minutes 13 seconds\r\nLoad1: 4.60\r\nLoad5: 1.20\r\nLoad15: 0.47\r\nTotal Accesses: 27860\r\nTotal kBytes: 33011\r\nTotal Duration: 54118\r\nCPUUser: 18.02\r\nCPUSystem: 31.76\r\nCPUChildrenUser: 0\r\nCPUChildrenSystem: 0\r\nCPULoad: .0262535\r\nUptime: 189613\r\nReqPerSec: .146931\r\nBytesPerSec: 178.275\r\nBytesPerReq: 1213.33\r\nDurationPerReq: 1.9425\r\nBusyWorkers: 7\r\nIdleWorkers: 93\r\nProcesses: 4\r\nStopping: 0\r\nBusyWorkers: 7\r\nIdleWorkers: 93\r\nConnsTotal: 13\r\nConnsAsyncWriting: 0\r\nConnsAsyncKeepAlive: 5\r\nConnsAsyncClosing: 0\r\nScoreboard: ...\r\n\r\n```\r\n  \r\nIt also uses Zabbix agent to collect `Apache` Linux process statistics such as CPU usage, memory usage, and whether the process is running or not.\r\n\r\n## Setup\r\n\r\nSee the setup instructions for [mod_status](https://httpd.apache.org/docs/current/mod/mod_status.html).\r\n\r\nCheck the availability of the module with this command line: `httpd -M 2>/dev/null | grep status_module`\r\n\r\nThis is an example configuration of the Apache web server:\r\n\r\n```text\r\n<Location "/server-status">\r\n  SetHandler server-status\r\n  Require host example.com\r\n</Location>\r\n```\r\n\r\nIf you use another path, then do not forget to change the `Apache status page path` host wizard configuration field.'),
('10638',NULL,'Website certificate by Zabbix agent 2 active','3','-1','2','','','Website certificate by Zabbix agent 2 active','0',NULL,'The template to monitor TLS/SSL certificate on the website by Zabbix agent 2 that works without any external scripts.\r\n\r\nZabbix agent 2 with the WebCertificate plugin requests certificate using the web.certificate.get key and returns JSON with certificate attributes.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/428309-discussion-thread-for-official-zabbix-template-tls-ssl-certificates-monitoring\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','de38542cf4f24fafab33520677f392c4','WEBSITE CERTIFICATE BY ZABBIX AGENT 2 ACTIVE','Zabbix','7.4-1',NULL,'0','0',''),
('10639',NULL,'Nginx by Zabbix agent active','3','-1','2','','','Nginx by Zabbix agent active','0',NULL,'Get metrics from stub status module using Zabbix agent running on Linux\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d2cebb67b4d94a12a072db85e7be6a33','NGINX BY ZABBIX AGENT ACTIVE','Zabbix','7.4-1',NULL,'0','1','## Overview\r\n\r\nThis template is developed to monitor Nginx by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template `Nginx by Zabbix agent` - collects metrics by polling the [Module ngx_http_stub_status_module](https://nginx.ru/en/docs/http/ngx_http_stub_status_module.html) locally with Zabbix agent:\r\n\r\n```text\r\nActive connections: 291\r\nserver accepts handled requests\r\n16630948 16630948 31070465\r\nReading: 6 Writing: 179 Waiting: 106\r\n```\r\n\r\nNote that this template doesn\'t support HTTPS and redirects (limitations of `web.page.get`).\r\n\r\nIt also uses Zabbix agent to collect `Nginx` Linux process statistics, such as CPU usage, memory usage and whether the process is running or not.\r\n\r\n\r\n## Setup\r\n\r\nSee the setup instructions for [ngx_http_stub_status_module](https://nginx.ru/en/docs/http/ngx_http_stub_status_module.html).\r\nTest the availability of the `http_stub_status_module` `nginx -V 2>&1 | grep -o with-http_stub_status_module`.\r\n\r\nExample configuration of Nginx:\r\n```text\r\nlocation = /basic_status {\r\n    stub_status;\r\n    allow 127.0.0.1;\r\n    allow ::1;\r\n    deny all;\r\n}\r\n```\r\n\r\nIf you use another location, then don\'t forget to change the `Nginx status page path` host wizard configuration field.\r\n\r\nExample answer from Nginx:\r\n```text\r\nActive connections: 291\r\nserver accepts handled requests\r\n16630948 16630948 31070465\r\nReading: 6 Writing: 179 Waiting: 106\r\n```\r\n\r\nNote that this template doesn\'t support https and redirects (limitations of web.page.get).'),
('10640',NULL,'Nutanix Cluster Prism Element by HTTP','3','-1','2','','','Nutanix Cluster Prism Element by HTTP','0',NULL,'Prism Element: It is a service already built into the platform for every Nutanix cluster deployed. It provides the ability to fully configure, manage, and monitor Nutanix clusters running any hypervisors, however, It only manages the cluster it is part of.\r\n\r\nThis template is designed for the effortless deployment of Nutanix Cluster Prism Element monitoring and doesn\'t require any external scripts.\r\n\r\nThis template can be used in discovery, as well as manually linked to a host - to do so, attach it to the host and manually set the value of the \'{$NUTANIX.CLUSTER.UUID}\' macro.\r\n\r\nMore details can be found in the official documentation:\r\n  - on retrieving UUIDs: https://www.nutanixbible.com/19b-cli.html\r\n  - on the Nutanix Prism Element REST API: https://www.nutanix.dev/api_reference/apis/prism_v2.html\r\n  - on differences between Nutanix API versions: https://www.nutanix.dev/api-versions/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b6027e374e424481951ca2256099515c','NUTANIX CLUSTER PRISM ELEMENT BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10641',NULL,'Nutanix Host Prism Element by HTTP','3','-1','2','','','Nutanix Host Prism Element by HTTP','0',NULL,'Prism Element: It is a service already built into the platform for every Nutanix cluster deployed. It provides the ability to fully configure, manage, and monitor Nutanix clusters running any hypervisors, however, It only manages the cluster it is part of.\r\n\r\nThis template is designed for the effortless deployment of Nutanix Host Prism Element monitoring and doesn\'t require any external scripts.\r\n\r\nThis template can be used in discovery, as well as manually linked to a host - to do so, attach it to the host and manually set the value of the \'{$NUTANIX.HOST.UUID}\' macro.\r\n\r\nMore details can be found in the official documentation:\r\n  - on retrieving UUIDs: https://www.nutanixbible.com/19b-cli.html\r\n  - on the Nutanix Prism Element REST API: https://www.nutanix.dev/api_reference/apis/prism_v2.html\r\n  - on differences between Nutanix API versions: https://www.nutanix.dev/api-versions/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8ab5387c8887435587cce8383b2fc6c5','NUTANIX HOST PRISM ELEMENT BY HTTP','Zabbix','7.4-2',NULL,'0','0',''),
('10642',NULL,'Nutanix Prism Element by HTTP','3','-1','2','','','Nutanix Prism Element by HTTP','0',NULL,'Prism Element: It is a service already built into the platform for every Nutanix cluster deployed. It provides the ability to fully configure, manage, and monitor Nutanix clusters running any hypervisors, however, it only manages the cluster it is part of.\r\n\r\nThis template is designed for the effortless deployment of Nutanix Prism Element monitoring and doesn\'t require any external scripts.\r\n\r\nThe templates "Nutanix Host Prism Element by HTTP" and "Nutanix Cluster Prism Element by HTTP" can be used in discovery, as well as manually linked to a host.\r\n\r\nMore details can be found in the official documentation:\r\n  - on the Nutanix Prism Element REST API: https://www.nutanix.dev/api_reference/apis/prism_v2.html\r\n  - on the differences between Nutanix API versions: https://www.nutanix.dev/api-versions/\r\n  - on the differences between Nutanix Prism Element REST API and Nutanix Prism Central REST API: https://next.nutanix.com/how-it-works-22/differences-between-prism-element-prism-central-and-prism-pro-37137\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0bb43a48a33f48ad910441384486edb4','NUTANIX PRISM ELEMENT BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10645',NULL,'PHP-FPM by Zabbix agent active','3','-1','2','','','PHP-FPM by Zabbix agent active','0',NULL,'Get PHP-FPM metrics using Zabbix agent running on Linux.\r\n\r\nNote that depending on your OS distribution, the PHP-FPM process name may vary. Please, check the actual name in the line "Name" from /proc/<pid>/status file (https://www.zabbix.com/documentation/7.4/manual/appendix/items/proc_mem_num_notes) and change {$PHP_FPM.PROCESS.NAME.PARAMETER} macro if needed.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a9e83f950e9f41a78474d523c8376338','PHP-FPM BY ZABBIX AGENT ACTIVE','Zabbix','7.4-1',NULL,'0','0',''),
('10646',NULL,'MySQL by Zabbix agent 2 active','3','-1','2','','','MySQL by Zabbix agent 2 active','0',NULL,'Requirements for template operation:\r\n\r\n1. Create a MySQL user for monitoring. For example:\r\n\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html.\r\n\r\nNOTE: In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the SLAVE MONITOR privilege to be set for the monitoring user:\r\n\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information please read the MariaDB documentation https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/\r\n\r\n2. Set in the {$MYSQL.DSN} macro the data source name of the MySQL instance either session name from Zabbix agent 2 configuration file or URI.\r\nExamples: MySQL1, tcp://localhost:3306, tcp://172.16.0.10, unix:/var/run/mysql.sock\r\nFor more information about MySQL Unix socket file please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/problems-with-mysql-sock.html.\r\n\r\n3. If you had set URI in the {$MYSQL.DSN}, please define the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).\r\nLeave macros {$MYSQL.USER} and {$MYSQL.PASSWORD} empty if you use a session name. Set the user name and password in the Plugins.Mysql.<...> section of your Zabbix agent 2 configuration file.\r\nFor more information about configuring the Zabbix MySQL plugin please read the documentation https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/src/go/plugins/mysql/README.md.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','51ffd432b9324ce2b04e1d4dc4122d16','MYSQL BY ZABBIX AGENT 2 ACTIVE','Zabbix','7.4-3',NULL,'0','1','## Setup\r\n\r\n1. Create a MySQL user for monitoring (`<password>` at your discretion):\r\n\r\n```text\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n```\r\n\r\nFor more information, please see MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html\r\n\r\n**NOTE:** In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the `SLAVE MONITOR` privilege to be set for the monitoring user:\r\n\r\n```text\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n```\r\n\r\nFor more information please read the MariaDB documentation https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/\r\n\r\n2. Set in the `MySQL DSN` host wizard configuration field macro the data source name of the MySQL instance either session name from Zabbix agent 2 configuration file or URI.\r\n**Examples:** MySQL1, tcp://localhost:3306, tcp://172.16.0.10, unix:/var/run/mysql.sock\r\nFor more information about MySQL Unix socket file, see the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/problems-with-mysql-sock.html.\r\n\r\n3. If you had set URI in the `MySQL DSN` field, define the user name and password in `MySQL user` and `MySQL password` host wizard configuration fields.\r\nLeave fields `MySQL user` and `MySQL password` empty if you use a session name. Set the user name and password in the Plugins.Mysql.<...> section of your Zabbix agent 2 configuration file.\r\nFor more information about configuring the Zabbix MySQL plugin, see the documentation https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/src/go/plugins/mysql/README.md.'),
('10647',NULL,'MySQL by Zabbix agent active','3','-1','2','','','MySQL by Zabbix agent active','0',NULL,'Requirements for template operation:\r\n\r\n1. Install Zabbix agent and MySQL client. If necessary, add the path to the \'mysql\' and \'mysqladmin\' utilities to the global environment variable PATH.\r\n\r\n2. Copy the \'template_db_mysql.conf\' file with user parameters into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don\'t forget to restart Zabbix agent.\r\n\r\n3. Create the MySQL user that will be used for monitoring (\'<password>\' at your discretion). For example:\r\n\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information, please see MySQL documentation (https://dev.mysql.com/doc/refman/8.0/en/grant.html).\r\n\r\nNOTE: In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the SLAVE MONITOR privilege to be set for the monitoring user:\r\n\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information, please read the MariaDB documentation (https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/).\r\n\r\n4. Create \'.my.cnf\' configuration file in the home directory of Zabbix agent for Linux distributions (/var/lib/zabbix by default) or \'my.cnf\' in c:\\ for Windows. For example:\r\n\r\n[client]\r\nprotocol=tcp\r\nuser=\'zbx_monitor\'\r\npassword=\'<password>\'\r\n\r\nFor more information, please see MySQL documentation (https://dev.mysql.com/doc/refman/8.0/en/option-files.html).\r\n\r\nNOTE: Linux distributions that use SELinux may require additional steps for access configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1ae69b01417849b180717f62ad7819d6','MYSQL BY ZABBIX AGENT ACTIVE','Zabbix','7.4-3',NULL,'0','1','## Setup\r\n\r\n1. Install MySQL client. If necessary, add the path to the `mysql` and `mysqladmin` utilities to the global environment variable PATH.\r\n2. Copy the `template_db_mysql.conf` file with user parameters into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don\'t forget to restart Zabbix agent.\r\n3. Create the MySQL user that will be used for monitoring (`<password>` at your discretion). For example:\r\n\r\n```text\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n```\r\n\r\nFor more information, please see [`MySQL documentation`](https://dev.mysql.com/doc/refman/8.0/en/grant.html).\r\n\r\n4. Create `.my.cnf` configuration file in the home directory of Zabbix agent for Linux distributions (/var/lib/zabbix by default) or `my.cnf` in c:\\ for Windows. For example:\r\n\r\n```text\r\n[client]\r\nprotocol=tcp\r\nuser=\'zbx_monitor\'\r\npassword=\'<password>\'\r\n```\r\n\r\nFor more information, please see [`MySQL documentation`](https://dev.mysql.com/doc/refman/8.0/en/option-files.html).\r\n\r\n**NOTE:** In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the `SLAVE MONITOR` privilege to be set for the monitoring user:\r\n\r\n```text\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n```\r\n\r\nFor more information, please read the [`MariaDB documentation`](https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/).\r\n\r\nNOTE: Linux distributions that use SELinux may require additional steps for access configuration.\r\n\r\nFor example, the following rule could be added to the SELinux policy:\r\n\r\n```text\r\n# cat <<EOF > zabbix_home.te\r\nmodule zabbix_home 1.0;\r\n\r\nrequire {\r\n        type zabbix_agent_t;\r\n        type zabbix_var_lib_t;\r\n        type mysqld_etc_t;\r\n        type mysqld_port_t;\r\n        type mysqld_var_run_t;\r\n        class file { open read };\r\n        class tcp_socket name_connect;\r\n        class sock_file write;\r\n}\r\n\r\n#============= zabbix_agent_t ==============\r\n\r\nallow zabbix_agent_t zabbix_var_lib_t:file read;\r\nallow zabbix_agent_t zabbix_var_lib_t:file open;\r\nallow zabbix_agent_t mysqld_etc_t:file read;\r\nallow zabbix_agent_t mysqld_port_t:tcp_socket name_connect;\r\nallow zabbix_agent_t mysqld_var_run_t:sock_file write;\r\nEOF\r\n# checkmodule -M -m -o zabbix_home.mod zabbix_home.te\r\n# semodule_package -o zabbix_home.pp -m zabbix_home.mod\r\n# semodule -i zabbix_home.pp\r\n# restorecon -R /var/lib/zabbix\r\n```'),
('10648',NULL,'PostgreSQL by Zabbix agent 2 active','3','-1','2','','','PostgreSQL by Zabbix agent 2 active','0',NULL,'This template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent 2 and uses a loadable plugin to run SQL queries.\r\n\r\nSetup:\r\n\r\n1. Deploy Zabbix agent 2 with the PostgreSQL plugin. Starting with Zabbix versions 6.0.10 / 6.2.4 / 6.4 PostgreSQL metrics are moved to a loadable plugin and require installation of a separate package or compilation of the plugin from sources (https://www.zabbix.com/documentation/7.4/manual/extensions/plugins/build).\r\n\r\n2. Create the PostgreSQL user for monitoring (`<password>` at your discretion) and inherit permissions from the default role `pg_monitor`:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n\r\n3. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. You can check the PostgreSQL documentation for examples (https://www.postgresql.org/docs/current/auth-pg-hba-conf.html).\r\n\r\n4. Set the connection string for the PostgreSQL instance in the `{$PG.CONNSTRING.AGENT2}` macro as URI, such as `<protocol(host:port)>`, or specify the named session - `<sessionname>`.\r\n\r\nNote: if you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, a named session must be used. In that case, the instance URI should be specified in the `Plugins.PostgreSQL.Sessions.*.Uri` parameter in the PostgreSQL plugin configuration files alongside all the encryption parameters (type, certificate/key filepaths if needed etc.).\r\n\r\nYou can check the PostgreSQL plugin documentation (https://git.zabbix.com/projects/AP/repos/postgresql/browse?at=refs%2Fheads%2Frelease%2F7.4) for details about agent plugin parameters and named sessions.\r\n\r\nAlso, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the PostgreSQL documentation (https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\nNote that plugin TLS certificate validation relies on checking the Subject Alternative Names (SAN) instead of the Common Name (CN), check the cryptography package documentation (https://pkg.go.dev/crypto/x509) for details.\r\n\r\nFor example, to enable required encryption in transport mode without identity checks you could create the file `/etc/zabbix/zabbix_agent2.d/postgresql_myconn.conf` with the following configuration for the named session `myconn` (replace `<instanceip>` with the address of the PostgreSQL instance):\r\nPlugins.PostgreSQL.Sessions.myconn.Uri=tcp://<instanceip>:5432\r\nPlugins.PostgreSQL.Sessions.myconn.TLSConnect=required\r\n\r\nThen set the `{$PG.CONNSTRING.AGENT2}` macro to `myconn` to use this named session.\r\n\r\n5. Set the password that you specified in step 2 in the macro `{$PG.PASSWORD}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','21cca24cec1d40cdb0c2999aa6ac3037','POSTGRESQL BY ZABBIX AGENT 2 ACTIVE','Zabbix','7.4-3',NULL,'0','1','## Overview\r\n\r\nThis template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent 2 and uses a loadable plugin to run SQL queries.\r\n\r\n## Setup\r\n\r\n1. Create the PostgreSQL user for monitoring (`<password>` at your discretion) and inherit permissions from the default role `pg_monitor`:\r\n\r\n```sql\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n```\r\n\r\n2. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. For example, you could add one of the following rows to allow local TCP connections from the same host:\r\n\r\n```bash\r\n# TYPE  DATABASE        USER            ADDRESS                 METHOD\r\n  host       all        zbx_monitor     localhost               trust\r\n  host       all        zbx_monitor     127.0.0.1/32            md5\r\n  host       all        zbx_monitor     ::1/128                 scram-sha-256\r\n```\r\n\r\nFor more information please read the PostgreSQL documentation `https://www.postgresql.org/docs/current/auth-pg-hba-conf.html`.\r\n\r\n3. Set the connection string for the PostgreSQL instance in the `PostgreSQL connection string` host wizard configuration field as URI, such as `<protocol(host:port)>`, or specify the named session - `<sessionname>`.\r\n\r\n**Note:** if you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, a named session must be used. In that case, the instance URI should be specified in the `Plugins.PostgreSQL.Sessions.*.Uri` parameter in the PostgreSQL plugin configuration files alongside all the encryption parameters (type, certificate/key filepaths if needed etc.).\r\n\r\nYou can check the [`PostgreSQL plugin documentation`](https://git.zabbix.com/projects/AP/repos/postgresql/browse?at=refs%2Fheads%2Frelease%2F7.4) for details about agent plugin parameters and named sessions.\r\n\r\nAlso, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the [`PostgreSQL documentation`](https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\n**Note:** plugin TLS certificate validation relies on checking the Subject Alternative Names (SAN) instead of the Common Name (CN), check the cryptography package [`documentation`](https://pkg.go.dev/crypto/x509) for details.\r\n\r\nFor example, to enable required encryption in transport mode without identity checks you could create the file `/etc/zabbix/zabbix_agent2.d/postgresql_myconn.conf` with the following configuration for the named session `myconn` (replace `<instanceip>` with the address of the PostgreSQL instance):\r\n\r\n```bash\r\nPlugins.PostgreSQL.Sessions.myconn.Uri=tcp://<instanceip>:5432\r\nPlugins.PostgreSQL.Sessions.myconn.TLSConnect=required\r\n```\r\n\r\nThen set the `PostgreSQL connection string` field to `myconn` to use this named session.\r\n\r\n4. Set the password that you specified in step 2 in the `PostgreSQL user password` field.'),
('10649',NULL,'PostgreSQL by Zabbix agent active','3','-1','2','','','PostgreSQL by Zabbix agent active','0',NULL,'This template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent and uses user parameters to run SQL queries with the `psql` command-line tool.\r\n\r\nNote:\r\n- The template requires `pg_isready` and `psql` utilities to be installed on the same host with Zabbix agent.\r\n- The template requires files with SQL queries and user parameters that can be found in the Zabbix official repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/db/postgresql?at=refs%2Fheads%2Frelease%2F6.0\r\n\r\nSetup:\r\n\r\n1. Deploy Zabbix agent and create the PostgreSQL user for monitoring (`<password>` at your discretion) with proper access rights to your PostgreSQL instance.\r\n\r\nFor PostgreSQL version 10 and above:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n\r\nFor PostgreSQL version 9.6 and below:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\';\r\nGRANT SELECT ON pg_stat_database TO zbx_monitor;\r\nALTER USER zbx_monitor WITH SUPERUSER;\r\n\r\n2. Copy the `postgresql/` directory to the `zabbix` user home directory - `/var/lib/zabbix/`. The `postgresql/` directory contains the files with SQL queries needed to obtain metrics from PostgreSQL instance.\r\n\r\nIf the home directory of the `zabbix` user doesn\'t exist, create it first:\r\nmkdir -m u=rwx,g=rwx,o= -p /var/lib/zabbix\r\nchown zabbix:zabbix /var/lib/zabbix\r\n\r\n3. Copy the `template_db_postgresql.conf` file, containing user parameters, to the Zabbix agent configuration directory `/etc/zabbix/zabbix_agentd.d/` and restart Zabbix agent service.\r\n\r\nIf you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, you can modify the connection string in user parameters. For example, to enable required encryption in transport mode without identity checks you could append `?sslmode=required` to the end of the connection string for all keys that use `psql`:\r\nUserParameter=pgsql.bgwriter[*], psql -qtAX postgresql://"$3":"$4"@"$1":"$2"/"$5"?sslmode=required -f "/var/lib/zabbix/postgresql/pgsql.bgwriter.sql"\r\n\r\nConsult the PostgreSQL documentation about protection modes (https://www.postgresql.org/docs/current/libpq-ssl.html#LIBPQ-SSL-PROTECTION) and client connection parameters (https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNECT-SSLMODE).\r\n\r\nAlso, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the PostgreSQL documentation (https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\n4. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. You can check the PostgreSQL documentation for examples (https://www.postgresql.org/docs/current/auth-pg-hba-conf.html).\r\n\r\n5. Specify the host name or IP address in the `{$PG.HOST}` macro. Adjust the port number with `{$PG.PORT}` macro if needed.\r\n\r\n6. Set the password that you specified in step 1 in the macro `{$PG.PASSWORD}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7005acc9123e4bc290805a3a16dab9cf','POSTGRESQL BY ZABBIX AGENT ACTIVE','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent and uses user parameters to run SQL queries with the `psql` command-line tool.\r\n\r\n## Setup\r\n\r\n**Note:**\r\n- The template requires `pg_isready` and `psql` utilities to be installed on the same host with Zabbix agent.\r\n\r\n1. Create the PostgreSQL user for monitoring (`<password>` at your discretion) with proper access rights to your PostgreSQL instance.\r\n\r\nFor PostgreSQL version 10 and above:\r\n\r\n```sql\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n```\r\n\r\nFor PostgreSQL version 9.6 and below:\r\n\r\n```sql\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\';\r\nGRANT SELECT ON pg_stat_database TO zbx_monitor;\r\n\r\n-- To collect WAL metrics, the user must have a `superuser` role.\r\nALTER USER zbx_monitor WITH SUPERUSER;\r\n```\r\n\r\n2. Copy the `postgresql/` directory to the `zabbix` user home directory - `/var/lib/zabbix/`. The `postgresql/` directory contains the files with SQL queries needed to obtain metrics from PostgreSQL instance.\r\n\r\nIf the home directory of the `zabbix` user doesn\'t exist, create it first:\r\n\r\n```bash\r\nmkdir -m u=rwx,g=rwx,o= -p /var/lib/zabbix\r\nchown zabbix:zabbix /var/lib/zabbix\r\n```\r\n\r\n3. Copy the `template_db_postgresql.conf` file, containing user parameters, to the Zabbix agent configuration directory `/etc/zabbix/zabbix_agentd.d/` and restart Zabbix agent service.\r\n\r\n**Note:** if you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, you can modify the connection string in user parameters. For example, to enable required encryption in transport mode without identity checks you could append `?sslmode=required` to the end of the connection string for all keys that use `psql`:\r\n\r\n```bash\r\nUserParameter=pgsql.bgwriter[*], psql -qtAX postgresql://"$3":"$4"@"$1":"$2"/"$5"?sslmode=required -f "/var/lib/zabbix/postgresql/pgsql.bgwriter.sql"\r\n```\r\n\r\nConsult the PostgreSQL documentation about [`protection modes`](https://www.postgresql.org/docs/current/libpq-ssl.html#LIBPQ-SSL-PROTECTION) and [`client connection parameters`](https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNECT-SSLMODE).\r\n\r\nAlso, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the [`PostgreSQL documentation`](https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\n4. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. For example, you could add one of the following rows to allow local TCP connections from the same host:\r\n\r\n```bash\r\n# TYPE  DATABASE        USER            ADDRESS                 METHOD\r\n  host       all        zbx_monitor     localhost               trust\r\n  host       all        zbx_monitor     127.0.0.1/32            md5\r\n  host       all        zbx_monitor     ::1/128                 scram-sha-256\r\n```\r\n\r\nFor more information please read the PostgreSQL documentation `https://www.postgresql.org/docs/current/auth-pg-hba-conf.html`.\r\n\r\n5. Specify the host name or IP address in the `PostgreSQL host` host wizard configuration field. Adjust the port number in the `PostgreSQL port` field if needed.\r\n\r\n6. Set the password that you specified in step 1 in the `PostgreSQL user password` field.'),
('10650',NULL,'Nvidia by Zabbix agent 2 active','3','-1','2','','','Nvidia by Zabbix agent 2 active','0',NULL,'This template is designed for Nvidia GPU monitoring and doesn\'t require any external scripts.\r\n1. Setup and configure Zabbix agent 2 compiled with the Nvidia monitoring plugin.\r\n2. Create a host and attach the template to it.\r\nAll Nvidia GPUs will be discovered. Set filters with macros if you want to override default filter parameters.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7297d66e419543c6b83dd8cfe5eb4fb7','NVIDIA BY ZABBIX AGENT 2 ACTIVE','Zabbix','7.4-1',NULL,'0','0',''),
('10651',NULL,'Nvidia by Zabbix agent 2','3','-1','2','','','Nvidia by Zabbix agent 2','0',NULL,'This template is designed for Nvidia GPU monitoring and doesn\'t require any external scripts.\r\n1. Setup and configure Zabbix agent 2 compiled with the Nvidia monitoring plugin.\r\n2. Create a host with Zabbix agent interface and attach the template to it.\r\nAll Nvidia GPUs will be discovered. Set filters with macros if you want to override default filter parameters.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','32a39c8aca9445df862e9f3e1369c19a','NVIDIA BY ZABBIX AGENT 2','Zabbix','7.4-1',NULL,'0','0',''),
('10652',NULL,'Azure SQL Managed Instance by HTTP','3','-1','2','','','Azure SQL Managed Instance by HTTP','0',NULL,'This template is designed to monitor Azure SQL Managed Instance by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a93f57ccc68e442da79bf4a20fe46570','AZURE SQL MANAGED INSTANCE BY HTTP','Zabbix','7.4-2',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor Microsoft Azure SQL Managed Instance by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\n## Setup\r\n\r\n1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n\r\n      `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n\r\n> See [Azure documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli) for more details.\r\n\r\n2. Link the template to a host.\r\n3. Configure the macros: `Azure App ID`, `Azure password`, `Azure tenant ID`, `Azure subscription ID`, and `Azure SQL managed instance ID`.'),
('10654',NULL,'Juniper MX by SNMP','3','-1','2','','','Juniper MX by SNMP','0',NULL,'The template for monitoring Juniper MX Series by SNMP.\r\n\r\nMIBs used:\r\nSNMPv2-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nIF-MIB\r\nOSPF-MIB\r\nJUNIPER-ALARM-MIB\r\nJUNIPER-DOM-MIB\r\nJUNIPER-MIB\r\nBGP4-V2-MIB-JUNIPER\r\nOSPFV3-MIB-JUNIPER\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fe7eb8b22ce84017b07bcab36e9032dc','JUNIPER MX BY SNMP','Zabbix','7.4-0',NULL,'0','0',''),
('10655',NULL,'Palo Alto PA-440 by HTTP','3','-1','2','','','Palo Alto PA-440 by HTTP','0',NULL,'This template is designed for the effortless deployment of Palo Alto PA-440 monitoring by Zabbix via XML API and doesn\'t require any external scripts.\r\n\r\nSetup:\r\n\r\nConfigure a user for monitoring. Note that in order to retrieve the device certificate information, superuser privileges are required. If you opt for a user with limited access (for security reasons), the device certificate expiration metrics will not be discovered.\r\n\r\nSuperuser privileges user (full access to all data):\r\n1. Add a new administrator user. Go to "Device" > "Administrators" and click "Add".\r\n2. Enter the necessary details. Set the "Administrator Type" to "Dynamic" and select the built-in "Superuser" role. Commit the changes.\r\n\r\nLimited privileges user (no access to device certificate data):\r\n1. Create a new Admin Role. Go to "Device" > "Admin Role" and click "Add".\r\n2. Enter the necessary details. Adjust the list of permissions:\r\n- Restrict access to all sections in the "Web UI" tab\r\n- Allow access to the "Configuration" and "Operational Requests" sections in the "XML API" tab\r\n- Check that the access to CLI is set to "None" in the "Command Line" tab\r\n- Restrict access to all sections in the "REST API" tab\r\n3. Add a new administrator user. Go to "Device" > "Administrators" and click "Add".\r\n4. Enter the necessary details. Set the "Administrator Type" to "Role Based" and select the profile that was created in the previous steps. Commit the changes.\r\n\r\nSet the host macros:\r\n1. Set the firewall XML API endpoint URL in the "{$PAN.PA440.API.URL}" macro in the format "<scheme>://<host>[:port]/api" (port is optional).\r\n2. Set the name of the user that you created in the "{$PAN.PA440.USER}" macro.\r\n3. Set the password of the user that you created in the "{$PAN.PA440.PASSWORD}" macro.\r\n\r\nFor more details about PAN-OS API, refer to the official documentation:\r\nhttps://docs.paloaltonetworks.com/pan-os/11-1/pan-os-panorama-api\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','edc752f178f94b9dbaee459ec7bacc66','PALO ALTO PA-440 BY HTTP','Zabbix','7.4-0',NULL,'0','0',''),
('10656',NULL,'DELL PowerEdge R660 by HTTP','3','-1','2','','','DELL PowerEdge R660 by HTTP','0',NULL,'Template for DELL PowerEdge R660 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','185867ae9b4a46b59d53931d3330c770','DELL POWEREDGE R660 BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10657',NULL,'DELL PowerEdge R660 by SNMP','3','-1','2','','','DELL PowerEdge R660 by SNMP','0',NULL,'Template for DELL PowerEdge R660 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3ba7dec7c0034d86ad1c73b4f8ee8994','DELL POWEREDGE R660 BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10658',NULL,'DELL PowerEdge R750 by HTTP','3','-1','2','','','DELL PowerEdge R750 by HTTP','0',NULL,'Template for DELL PowerEdge R750 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','42b18986c8b34c2d9c36f9cd00565bd5','DELL POWEREDGE R750 BY HTTP','Zabbix','7.4-1',NULL,'0','0',''),
('10659',NULL,'DELL PowerEdge R750 by SNMP','3','-1','2','','','DELL PowerEdge R750 by SNMP','0',NULL,'Template for DELL PowerEdge R750 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','419145c8af7e4b8eb30af8460bbed566','DELL POWEREDGE R750 BY SNMP','Zabbix','7.4-1',NULL,'0','0',''),
('10660',NULL,'Zabbix proxy health by Zabbix agent','3','-1','2','','','Zabbix proxy health by Zabbix agent','0',NULL,'This template is designed to monitor internal Zabbix metrics on the remote Zabbix proxy via the passive Zabbix agent.\r\n\r\nSpecify the address of the remote Zabbix proxy by changing the {$ZABBIX.PROXY.ADDRESS} and {$ZABBIX.PROXY.PORT} macros. Don\'t forget to adjust the "StatsAllowedIP" parameter in the remote proxy\'s configuration file to allow the collection of statistics.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8cd15d3b39654eb7b7423e6b109037b2','ZABBIX PROXY HEALTH BY ZABBIX AGENT','Zabbix','7.4-3',NULL,'0','1','## Overview\r\n\r\nThis template is designed to monitor internal Zabbix metrics on the remote Zabbix proxy via the passive Zabbix agent.\r\n\r\n## Setup\r\n\r\nSpecify the address of the remote Zabbix proxy as the values for the `Zabbix proxy Address` and `Zabbix proxy Port` configuration fields. Don\'t forget to adjust the `StatsAllowedIP` parameter in the remote proxy\'s configuration file to allow the collection of statistics.'),
('10661',NULL,'Zabbix proxy health by Zabbix agent active','3','-1','2','','','Zabbix proxy health by Zabbix agent active','0',NULL,'This template is designed to monitor internal Zabbix metrics on the remote Zabbix proxy via the active Zabbix agent.\r\n\r\nSpecify the address of the remote Zabbix proxy by changing the {$ZABBIX.PROXY.ADDRESS} and {$ZABBIX.PROXY.PORT} macros. Don\'t forget to adjust the "StatsAllowedIP" parameter in the remote proxy\'s configuration file to allow the collection of statistics.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','02aac022a62c48bba810d07bbaa