{
  lib,
  stdenv,
  fetchgit,
  jdk_headless,
  gradle_8,
  makeWrapper,
  bashNonInteractive,
}:
let
  # "Deprecated Gradle features were used in this build, making it incompatible with Gradle 9.0."
  gradle = gradle_8;
in
stdenv.mkDerivation rec {
  pname = "apksigner";
  # Major version is derived from the API version of the corresponding Android release.
  # Patch version is derived from the release number.
  # For example, Android 15 had releases starting at r24 -> r30 is patch 6.
  version = "35.0.6";

  src = fetchgit {
    # use pname here because the final jar uses this as the filename
    name = pname;
    url = "https://android.googlesource.com/platform/tools/apksig";
    rev = "refs/tags/android-15.0.0_r30";
    hash = "sha256-f/PggxvBv8nYUyL9Ukd4YVpunpRWbLL5UYsYhsiDWRE=";
  };

  mitmCache = gradle.fetchDeps {
    inherit pname;
    data = ./deps.json;
  };

  __darwinAllowLocalNetworking = true;

  doCheck = true;

  nativeBuildInputs = [
    gradle
    makeWrapper
  ];

  buildInputs = [
    # required for startup script generated by Gradle
    bashNonInteractive
  ];

  installPhase = ''
    runHook preInstall

    mkdir -p $out/opt
    tar xf build/distributions/apksigner.tar
    mv apksigner $out/opt
    mkdir -p $out/bin
    makeWrapper $out/opt/apksigner/bin/apksigner $out/bin/apksigner \
      --set JAVA_HOME ${jdk_headless.home}

    runHook postInstall
  '';

  meta = {
    description = "Command line tool to sign and verify Android APKs";
    mainProgram = "apksigner";
    homepage = "https://developer.android.com/tools/apksigner";
    downloadPage = "https://android.googlesource.com/platform/tools/apksig/";
    license = lib.licenses.asl20;
    maintainers = with lib.maintainers; [
      linsui
      fliegendewurst
    ];
    teams = [ lib.teams.android ];
    platforms = lib.platforms.unix;
  };
}
