{
  lib,
  buildGo125Module,
  fetchFromGitHub,
  versionCheckHook,
}:

buildGo125Module rec {
  pname = "oauth2-proxy";
  version = "7.13.0";

  src = fetchFromGitHub {
    repo = pname;
    owner = "oauth2-proxy";
    sha256 = "sha256-o5wJVi8TJ7Qfzn2JzoMSLNhDWSRC7HcrfrQOlMlQr/0=";
    rev = "v${version}";
  };

  vendorHash = "sha256-35eJ+vw8V5/nSYsBjlkWvQg2xyvmT5PTDtzZA7b/KkU=";

  # Taken from https://github.com/oauth2-proxy/oauth2-proxy/blob/master/Makefile
  ldflags = [ "-X github.com/oauth2-proxy/oauth2-proxy/v7/pkg/version.VERSION=v${version}" ];

  nativeInstallCheckInputs = [ versionCheckHook ];
  versionCheckProgramArg = "--version";
  doInstallCheck = true;

  meta = with lib; {
    description = "Reverse proxy that provides authentication with Google, Github, or other providers";
    homepage = "https://github.com/oauth2-proxy/oauth2-proxy/";
    license = licenses.mit;
    teams = [ teams.serokell ];
    mainProgram = "oauth2-proxy";
  };
}
