#line 1 "include/boost/json/detail/gdb_printers.hpp"
// 
//  Copyright (c) 2024 Dmitry Arkhipov (grisumbras@yandex.ru)
// 
//  Distributed under the Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
// 
//  Official repository: https://github.com/boostorg/json
// 

// Autogenerated from boost_json_gdb_printers.py by boost-pretty-printers

#ifndef BOOST_JSON_DETAIL_GDB_PRINTERS_HPP
#define BOOST_JSON_DETAIL_GDB_PRINTERS_HPP

#if defined(__ELF__)

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Woverlength-strings"
#elif defined(__GNUC__)
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Woverlength-strings"
#endif

__asm__(
  ".pushsection \".debug_gdb_scripts\", \"MS\",%progbits,1\n"
  ".ascii \"\\4gdb.inlined-script.BOOST_JSON_DETAIL_GDB_PRINTERS_HPP\\n\"\n"
  ".ascii \"import gdb\\n\"\n"
  ".ascii \"import gdb.printing\\n\"\n"


  ".ascii \"class PrettyPrinterBuilder():\\n\"\n"
  ".ascii \"    '''decorator that accumulates pretty printers for types'''\\n\"\n"

  ".ascii \"    def __init__(self, name=None):\\n\"\n"
  ".ascii \"        self.result = gdb.printing.RegexpCollectionPrettyPrinter(\\n\"\n"
  ".ascii \"            name or 'Boost.JSON')\\n\"\n"

  ".ascii \"    def __call__(self, pp=None, ns=None, template=False):\\n\"\n"
  ".ascii \"        if pp is None:\\n\"\n"
  ".ascii \"            def decorator(pp):\\n\"\n"
  ".ascii \"                return self(pp, ns=ns, template=template)\\n\"\n"
  ".ascii \"            return decorator\\n\"\n"

  ".ascii \"        typename = getattr(pp, '__name__')\\n\"\n"
  ".ascii \"        ns = ns or 'boost::json'\\n\"\n"
  ".ascii \"        self.result.add_printer(\\n\"\n"
  ".ascii \"            typename,\\n\"\n"
  ".ascii \"            '^{ns}::{typename}{marker}'.format(\\n\"\n"
  ".ascii \"                ns=ns,\\n\"\n"
  ".ascii \"                typename=typename,\\n\"\n"
  ".ascii \"                marker='<'if template else '$'),\\n\"\n"
  ".ascii \"            pp)\\n\"\n"
  ".ascii \"        return pp\\n\"\n"

  ".ascii \"pretty_printer = PrettyPrinterBuilder()\\n\"\n"


  ".ascii \"class static_property:\\n\"\n"
  ".ascii \"    '''decorator for lazy evaluation of static members'''\\n\"\n"

  ".ascii \"    def __init__(self, wrapped):\\n\"\n"
  ".ascii \"        self.wrapped = wrapped\\n\"\n"
  ".ascii \"        self.__name__ = wrapped.__name__\\n\"\n"
  ".ascii \"        self.__doc__ = wrapped.__doc__\\n\"\n"

  ".ascii \"    def __get__(self, inst, objtype=None):\\n\"\n"
  ".ascii \"        val = self.wrapped()\\n\"\n"
  ".ascii \"        if objtype is not None:\\n\"\n"
  ".ascii \"            setattr(objtype, self.wrapped.__name__, val)\\n\"\n"
  ".ascii \"        return val\\n\"\n"


  ".ascii \"@pretty_printer\\n\"\n"
  ".ascii \"class storage_ptr:\\n\"\n"
  ".ascii \"    '''boost::json::storage_ptr pretty printer'''\\n\"\n"

  ".ascii \"    @static_property\\n\"\n"
  ".ascii \"    def _size_t():\\n\"\n"
  ".ascii \"        return gdb.lookup_type('std::size_t')\\n\"\n"

  ".ascii \"    @static_property\\n\"\n"
  ".ascii \"    def _shared_resource_ptr():\\n\"\n"
  ".ascii \"        return gdb.lookup_type(\\n\"\n"
  ".ascii \"            'boost::json::detail::shared_resource').pointer()\\n\"\n"

  ".ascii \"    @static_property\\n\"\n"
  ".ascii \"    def _memory_resource_ptr():\\n\"\n"
  ".ascii \"        return gdb.lookup_type(\\n\"\n"
  ".ascii \"            'boost::container::pmr::memory_resource').pointer()\\n\"\n"

  ".ascii \"    def __init__(self, val):\\n\"\n"
  ".ascii \"        self.val = val['i_']\\n\"\n"

  ".ascii \"    def to_string(self):\\n\"\n"
  ".ascii \"        items = []\\n\"\n"

  ".ascii \"        if bool(self.val & 2):\\n\"\n"
  ".ascii \"            items.append('trivial')\\n\"\n"
  ".ascii \"        shared = bool(self.val & 1)\\n\"\n"
  ".ascii \"        if shared:\\n\"\n"
  ".ascii \"            items.append('shared')\\n\"\n"

  ".ascii \"        pointer = self.val & ~3\\n\"\n"
  ".ascii \"        if not pointer:\\n\"\n"
  ".ascii \"            items.append('resource=default')\\n\"\n"
  ".ascii \"        else:\\n\"\n"
  ".ascii \"            if shared:\\n\"\n"
  ".ascii \"                resource = pointer.cast(\\n\"\n"
  ".ascii \"                    self._shared_resource_ptr).dereference()\\n\"\n"
  ".ascii \"                impl_t = resource.dynamic_type\\n\"\n"
  ".ascii \"                impl_ptr = impl_t.pointer()\\n\"\n"
  ".ascii \"                resource = resource.address.cast(impl_ptr).dereference()\\n\"\n"

  ".ascii \"                items.append(\\n\"\n"
  ".ascii \"                    'refs=%s' % resource['refs'].cast(self._size_t))\\n\"\n"

  ".ascii \"                resource = resource['t']\\n\"\n"
  ".ascii \"            else:\\n\"\n"
  ".ascii \"                resource = pointer.cast(\\n\"\n"
  ".ascii \"                    self._memory_resource_ptr).dereference()\\n\"\n"


  ".ascii \"            derived_t = resource.dynamic_type\\n\"\n"
  ".ascii \"            derived_ptr = derived_t.pointer()\\n\"\n"
  ".ascii \"            resource = resource.address.cast(derived_ptr).dereference()\\n\"\n"
  ".ascii \"            items.append('resource=%s' % resource)\\n\"\n"

  ".ascii \"        return 'storage_ptr [' + ', '.join(items) + ']'\\n\"\n"


  ".ascii \"@pretty_printer\\n\"\n"
  ".ascii \"class monotonic_resource:\\n\"\n"
  ".ascii \"    '''boost::json::monotonic_resource pretty printer'''\\n\"\n"

  ".ascii \"    def __init__(self, val):\\n\"\n"
  ".ascii \"        self.val = val\\n\"\n"

  ".ascii \"    def to_string(self):\\n\"\n"
  ".ascii \"        buffer = self.val['buffer_']\\n\"\n"
  ".ascii \"        buffer = buffer['p'] - ( int(buffer['size']) - int(buffer['avail']) )\\n\"\n"

  ".ascii \"        head = self.val['head_'].dereference()\\n\"\n"

  ".ascii \"        block = head['p'] - ( int(head['size']) - int(head['avail']) )\\n\"\n"

  ".ascii \"        upstream = self.val['upstream_']\\n\"\n"

  ".ascii \"        items = []\\n\"\n"
  ".ascii \"        items.append('buffer=%s' % buffer)\\n\"\n"
  ".ascii \"        items.append('block=%s' % block)\\n\"\n"
  ".ascii \"        items.append('head=%s' % head['p'])\\n\"\n"
  ".ascii \"        items.append('free=%s' % head['avail'])\\n\"\n"
  ".ascii \"        if upstream['i_'] != 0:\\n\"\n"
  ".ascii \"            items.append('upstream=%s' % upstream)\\n\"\n"

  ".ascii \"        return 'monotonic_resource [%s]' % ', '.join(items)\\n\"\n"


  ".ascii \"@pretty_printer\\n\"\n"
  ".ascii \"class static_resource:\\n\"\n"
  ".ascii \"    '''boost::json::static_resource pretty printer'''\\n\"\n"

  ".ascii \"    def __init__(self, val):\\n\"\n"
  ".ascii \"        self.val = val\\n\"\n"

  ".ascii \"    def to_string(self):\\n\"\n"
  ".ascii \"        buf = self.val['p_'] - ( int(self.val['size_']) - int(self.val['n_']) )\\n\"\n"
  ".ascii \"        return 'static_resource [buffer=%s, head=%s, free=%s]' % (\\n\"\n"
  ".ascii \"            buf, self.val['p_'], self.val['n_'])\\n\"\n"


  ".ascii \"@pretty_printer\\n\"\n"
  ".ascii \"class string:\\n\"\n"
  ".ascii \"    '''boost::json::string pretty printer'''\\n\"\n"

  ".ascii \"    @static_property\\n\"\n"
  ".ascii \"    def _char_const_ptr():\\n\"\n"
  ".ascii \"        return gdb.lookup_type('char').const().pointer()\\n\"\n"

  ".ascii \"    def __init__(self, val):\\n\"\n"
  ".ascii \"        self.impl = val['impl_']\\n\"\n"

  ".ascii \"    def display_hint(self):\\n\"\n"
  ".ascii \"        return 'string'\\n\"\n"

  ".ascii \"    def to_string(self):\\n\"\n"
  ".ascii \"        kind = self.impl['s_']['k']\\n\"\n"
  ".ascii \"        if kind == self.impl['short_string_']:\\n\"\n"
  ".ascii \"            sbo_size = self.impl['sbo_chars_']\\n\"\n"
  ".ascii \"            size = sbo_size - self.impl['s_']['buf'][sbo_size]\\n\"\n"
  ".ascii \"            pointer = self.impl['s_']['buf']\\n\"\n"
  ".ascii \"        elif kind == self.impl['key_string_']:\\n\"\n"
  ".ascii \"            size = self.impl['k_']['n']\\n\"\n"
  ".ascii \"            pointer = self.impl['k_']['s']\\n\"\n"
  ".ascii \"        else:\\n\"\n"
  ".ascii \"            size = self.impl['p_']['t'].dereference()['size']\\n\"\n"
  ".ascii \"            pointer = self.impl['p_']['t']\\n\"\n"
  ".ascii \"            pointer += 1\\n\"\n"
  ".ascii \"            pointer = pointer.cast(self._char_const_ptr)\\n\"\n"
  ".ascii \"        return pointer.lazy_string(length=size)\\n\"\n"


  ".ascii \"@pretty_printer\\n\"\n"
  ".ascii \"class array:\\n\"\n"
  ".ascii \"    '''boost::json::array pretty printer'''\\n\"\n"

  ".ascii \"    @static_property\\n\"\n"
  ".ascii \"    def _value_ptr():\\n\"\n"
  ".ascii \"        return gdb.lookup_type('boost::json::value').pointer()\\n\"\n"

  ".ascii \"    def __init__(self, val):\\n\"\n"
  ".ascii \"        self.val = val\\n\"\n"

  ".ascii \"    def display_hint(self):\\n\"\n"
  ".ascii \"        return 'array'\\n\"\n"

  ".ascii \"    def to_string(self):\\n\"\n"
  ".ascii \"        capacity = int(self.val['t_'].dereference()['capacity'])\\n\"\n"
  ".ascii \"        return 'array [size={0}, capacity={1}]'.format(\\n\"\n"
  ".ascii \"            self.num_children(), capacity)\\n\"\n"

  ".ascii \"    def num_children(self):\\n\"\n"
  ".ascii \"        return int(self.val['t_'].dereference()['size'])\\n\"\n"

  ".ascii \"    def children(self):\\n\"\n"
  ".ascii \"        for i in range(0, self.num_children()):\\n\"\n"
  ".ascii \"            yield self.child(i)\\n\"\n"

  ".ascii \"    def child(self, n):\\n\"\n"
  ".ascii \"        table = (self.val['t_'] + 1).cast(self._value_ptr)\\n\"\n"
  ".ascii \"        return str(n), table[n]\\n\"\n"


  ".ascii \"@pretty_printer\\n\"\n"
  ".ascii \"class key_value_pair:\\n\"\n"
  ".ascii \"    '''boost::json::key_value_pair pretty printer'''\\n\"\n"

  ".ascii \"    @staticmethod\\n\"\n"
  ".ascii \"    def _pair(kv):\\n\"\n"
  ".ascii \"        return kv['key_'].lazy_string(length=kv['len_']), kv['value_']\\n\"\n"

  ".ascii \"    def __init__(self, val):\\n\"\n"
  ".ascii \"        self.val = val\\n\"\n"

  ".ascii \"    def to_string(self):\\n\"\n"
  ".ascii \"        k, v = self._pair(self.val)\\n\"\n"
  ".ascii \"        return '[%s] = %s' % (k.value(), v)\\n\"\n"


  ".ascii \"@pretty_printer\\n\"\n"
  ".ascii \"class object:\\n\"\n"
  ".ascii \"    '''boost::json::object pretty printer'''\\n\"\n"

  ".ascii \"    def __init__(self, val):\\n\"\n"
  ".ascii \"        self.val = val\\n\"\n"
  ".ascii \"        self.kv_ptr = gdb.lookup_type('boost::json::key_value_pair').pointer()\\n\"\n"

  ".ascii \"    def display_hint(self):\\n\"\n"
  ".ascii \"        return 'map'\\n\"\n"

  ".ascii \"    def to_string(self):\\n\"\n"
  ".ascii \"        capacity = int(self.val['t_'].dereference()['capacity'])\\n\"\n"
  ".ascii \"        return 'object [size={}, capacity={}]'.format(\\n\"\n"
  ".ascii \"            self.num_children(), capacity)\\n\"\n"

  ".ascii \"    def num_children(self):\\n\"\n"
  ".ascii \"        return int(self.val['t_'].dereference()['size'])\\n\"\n"

  ".ascii \"    def children(self):\\n\"\n"
  ".ascii \"        table = (self.val['t_'] + 1).cast(self.kv_ptr)\\n\"\n"
  ".ascii \"        for i in range(0, self.num_children()):\\n\"\n"
  ".ascii \"            k, v = key_value_pair._pair(table[i])\\n\"\n"
  ".ascii \"            yield str(2 * i), k\\n\"\n"
  ".ascii \"            yield str(2 * i + 1), v\\n\"\n"


  ".ascii \"@pretty_printer\\n\"\n"
  ".ascii \"class value:\\n\"\n"
  ".ascii \"    '''boost::json::value pretty printer'''\\n\"\n"

  ".ascii \"    @static_property\\n\"\n"
  ".ascii \"    def _kind_t():\\n\"\n"
  ".ascii \"        result = gdb.lookup_type('boost::json::kind')\\n\"\n"
  ".ascii \"        return dict(result.items())\\n\"\n"

  ".ascii \"    def __init__(self, val):\\n\"\n"
  ".ascii \"        self.val = val\\n\"\n"

  ".ascii \"    def to_string(self):\\n\"\n"
  ".ascii \"        kind = self.val['sca_']['k']\\n\"\n"

  ".ascii \"        if self._compare_kind(kind, 'null'):\\n\"\n"
  ".ascii \"            return 'null'\\n\"\n"

  ".ascii \"        elif self._compare_kind(kind, 'bool_'):\\n\"\n"
  ".ascii \"            return self.val['sca_']['b']\\n\"\n"

  ".ascii \"        elif self._compare_kind(kind, 'int64'):\\n\"\n"
  ".ascii \"            return self.val['sca_']['i']\\n\"\n"

  ".ascii \"        elif self._compare_kind(kind, 'uint64'):\\n\"\n"
  ".ascii \"            return self.val['sca_']['u']\\n\"\n"

  ".ascii \"        elif self._compare_kind(kind, 'double_'):\\n\"\n"
  ".ascii \"            return self.val['sca_']['d']\\n\"\n"

  ".ascii \"        elif self._compare_kind(kind, 'array'):\\n\"\n"
  ".ascii \"            return self.val['arr_']\\n\"\n"

  ".ascii \"        elif self._compare_kind(kind, 'object'):\\n\"\n"
  ".ascii \"            return self.val['obj_']\\n\"\n"

  ".ascii \"        else:\\n\"\n"
  ".ascii \"            return self.val['str_']\\n\"\n"

  ".ascii \"    def _compare_kind(self, kind, name):\\n\"\n"
  ".ascii \"        return kind == self._kind_t['boost::json::kind::' + name].enumval\\n\"\n"


  ".ascii \"def register(obj_file):\\n\"\n"
  ".ascii \"    mod = obj_file or gdb\\n\"\n"
  ".ascii \"    for printer in getattr(mod, 'pretty_printers', []):\\n\"\n"
  ".ascii \"        if getattr(printer, 'name') == pretty_printer.result.name:\\n\"\n"
  ".ascii \"            return\\n\"\n"

  ".ascii \"    gdb.printing.register_pretty_printer(\\n\"\n"
  ".ascii \"        obj_file,\\n\"\n"
  ".ascii \"        pretty_printer.result)\\n\"\n"


  ".ascii \"if __name__ == '__main__':\\n\"\n"
  ".ascii \"    register(gdb.current_objfile())\\n\"\n"
  ".byte 0\n"
  ".popsection\n");
#if defined(__clang__)
#  pragma clang diagnostic pop
#elif defined(__GNUC__)
#  pragma GCC diagnostic pop
#endif

#endif // defined(__ELF__)

#endif // BOOST_JSON_DETAIL_GDB_PRINTERS_HPP
