#! /usr/bin/env nix-shell
#! nix-shell -i bash --pure --keep GITHUB_TOKEN -p nix git curl cacert nix-prefetch-git gzip

base_url_suffix="https://pro-store-packages.uniontech.com/appstore/dists/eagle/appstore/binary-"
base_url_appendix="/Packages.gz"
target_package="com.tencent.wechat"
packages_file="Packages.gz"

url=()
version=()  # TODO: Currently, there is no version differences between archs. This is reserved for future use.
hash=()

for i in amd64 arm64 loongarch64
do
    current_url=$base_url_suffix$i$base_url_appendix
    curl -A "Mozilla/5.0 (X11; Linux x86_64; rv:125.0) Gecko/20100101 Firefox/125.0" -v -L -O $current_url
    current_version=$(zgrep -A 20 "Package: $target_package" "$packages_file" | awk -v pkg="$target_package" '
    BEGIN { found = 0 }
    {
        if ($0 ~ "^Package: "pkg) {
            found = 1;
        }
        if (found && $1 == "Version:") {
            print $2;
            exit;
        }
    }
    ')
    version+=("$current_version")
    sha256sum=$(zgrep -A 20 "Package: $target_package" "$packages_file" | awk -v pkg="$target_package" '
    BEGIN { found = 0 }
        {
            if ($0 ~ "^Package: "pkg) {
            found = 1;
        }
        if (found && $1 == "SHA256:") {
            print $2;
            exit;
        }
    }
    ')
    url+=("https://pro-store-packages.uniontech.com/appstore/pool/appstore/c/com.tencent.wechat/com.tencent.wechat_"$version"_"$i".deb")
    hash+=("$(nix hash to-sri --type sha256 $sha256sum)")
done

cat >sources.nix <<EOF
# Generated by ./update.sh - do not update manually!
# Last updated: $(date +%F)
{
  version = "${version[0]}";
  amd64_url = "${url[0]}";
  arm64_url = "${url[1]}";
  loongarch64_url = "${url[2]}";
  amd64_hash = "${hash[0]}";
  arm64_hash = "${hash[1]}";
  loongarch64_hash = "${hash[2]}";
}
EOF

rm -r Packages.gz
