{
  lib,
  buildPythonPackage,
  fetchPypi,
  pdm-backend,
  tqdm,
  hypothesis,
  pytest,
}:

buildPythonPackage rec {
  pname = "partial-json-parser";
  version = "0.2.1.1.post5";
  pyproject = true;

  src = fetchPypi {
    pname = "partial_json_parser";
    inherit version;
    hash = "sha256-mScQrGfpCzZ5IdUnJ2mJKAQPdxO6fsszuWNx6nrsgso=";
  };

  build-system = [ pdm-backend ];

  dependencies = [ ];

  doCheck = true;

  pythonImportsCheck = [ "partial_json_parser" ];

  dev-dependencies = [
    hypothesis
    tqdm
    pytest
  ];

  meta = with lib; {
    description = "Parse partial JSON generated by LLM";
    homepage = "https://github.com/promplate/partial-json-parser";
    license = licenses.mit;
    maintainers = [ ];
  };
}
