# Release 22.11 (“Raccoon”, 2022.11/30) {#sec-release-22.11}

The NixOS release team is happy to announce a new version of NixOS 22.11. NixOS is a Linux distribution, whose set of packages can also be used on other Linux systems and macOS.

This release is supported until the end of June 2023, handing over to NixOS 23.05.

To upgrade to the latest release follow the [upgrade chapter](#sec-upgrading).

## Highlights {#sec-release-22.11-highlights}

In addition to numerous new and upgraded packages, this release includes the following highlights:

- Software that uses the `crypt` password hashing API is now using the implementation provided by [`libxcrypt`](https://github.com/besser82/libxcrypt) instead of glibc's, which enables support for more secure algorithms.
  - Support for algorithms that `libxcrypt` [does not consider strong](https://github.com/besser82/libxcrypt/blob/v4.4.28/lib/hashes.conf#L41) are **deprecated** as of this release, and will be removed in NixOS 23.05.
  - This includes system login passwords. Given this, we **strongly encourage** all users to update their system passwords, as you will be unable to login if password hashes are not migrated by the time their support is removed.
    - When using `users.users.<name>.hashedPassword` to configure user passwords, run `mkpasswd`, and use the yescrypt hash that is provided as the new value.
    - On the other hand, for interactively configured user passwords, re-set the passwords for all users with `passwd`.
    - This release introduces warnings for the use of deprecated hash algorithms for both methods of configuring passwords. To make sure you migrated correctly, run `nixos-rebuild switch`.

- The NixOS documentation is now generated from markdown. While docbook is still part of the documentation build process, it's a big step towards the full migration.

- `aarch64-linux` is now included in the `nixos-22.11` and `nixos-22.11-small` channels. This means that when those channel update, both `x86_64-linux` and `aarch64-linux` will be available in the binary cache.

- `aarch64-linux` ISOs are now available on the [downloads page](https://nixos.org/download.html).

- `nsncd` is now available as a replacement of `nscd`.

  `nscd` is responsible for resolving hostnames, users and more in NixOS and has been a long standing source of bugs, such as sporadic network freezes.

  More context in this [issue](https://github.com/NixOS/nixpkgs/issues/135888).

  Help us test the new implementation by setting `services.nscd.enableNsncd` to `true`.

  We plan to use `nsncd` by default in NixOS 23.05.

- Linode cloud images are now supported by importing `${modulesPath}/virtualisation/linode-image.nix` and accessing `system.build.linodeImage` on the output.

- `hardware.nvidia` has a new option, `hardware.nvidia.open`, that can be used to enable the usage of NVIDIA's open-source kernel driver. Note that the driver's support for GeForce and Workstation GPUs is still alpha quality, see [the release announcement](https://developer.nvidia.com/blog/nvidia-releases-open-source-gpu-kernel-modules/) for more information.

- The `emacs` package now makes use of native compilation which means:
  - Emacs packages from Nixpkgs, builtin or not, will do native compilation ahead of time so you can enjoy the benefit of native compilation without compiling them on you machine;
  - Emacs packages from somewhere else, e.g. `package-install`, will perform asynchronously deferred native compilation. If you do not want this, maybe to avoid CPU consumption for compilation, you can use `(setq native-comp-deferred-compilation nil)` to disable it while still benefiting from native compilation for packages from Nixpkgs.

## Internal changes {#sec-release-22.11-internal}

- Haskell `ghcWithPackages` is now up to 15 times faster to evaluate, thanks to changing `lib.closePropagation` from a quadratic to linear complexity. Please see backward incompatibilities notes below. <https://github.com/NixOS/nixpkgs/pull/194391>

- For cross-compilation targets that can also run on the building machine, we now run tests. This, for example, is the case for the `pkgsStatic` and `pkgsLLVM` package sets or i686 packages on `x86_64` machines.

- To simplify cross-compilation in NixOS, this release introduces the `nixpkgs.hostPlatform` and `nixpkgs.buildPlatform` options. These cover and override the `nixpkgs.{system,localSystem,crossSystem}` options.

   - `hostPlatform` is the platform or "`system`" string of the NixOS system
     described by the configuration.
   - `buildPlatform` is the platform that is responsible for building the NixOS
     configuration. It defaults to the `hostPlatform`, for a non-cross
     build configuration. To cross compile, set `buildPlatform` to a different
     value.

  The new options convey the same information, but with fewer options, and
  following the Nixpkgs terminology.

  The existing options `nixpkgs.{system,localSystem,crossSystem}` have not
  been formally deprecated, to allow for evaluation of the change and to allow
  for a transition period so that in time the ecosystem can switch without
  breaking compatibility with any supported NixOS release.

## Notable version updates {#sec-release-22.11-version-updates}

- Nix has been upgraded from v2.8.1 to v2.11.0. For more information, please see the release notes for [2.9](https://nixos.org/manual/nix/stable/release-notes/rl-2.9.html), [2.10](https://nixos.org/manual/nix/stable/release-notes/rl-2.10.html) and [2.11](https://nixos.org/manual/nix/stable/release-notes/rl-2.11.html).

- OpenSSL now defaults to OpenSSL 3, updated from 1.1.1.

- GNOME has been upgraded to version 43. Please see the [release notes](https://release.gnome.org/43/) for details.

- KDE Plasma has been upgraded from v5.24 to v5.26. Please see the release notes for [v5.25](https://kde.org/announcements/plasma/5/5.25.0/) and [v5.26](https://kde.org/announcements/plasma/5/5.26.0/) for more details on the included changes.

- Cinnamon has been updated to 5.4, and the Cinnamon module now defaults to
  Blueman as the Bluetooth manager and slick-greeter as the LightDM greeter, to match upstream.

- PHP now defaults to PHP 8.1, updated from 8.0.

- Perl has been updated to 5.36, and its core module `HTTP::Tiny` was patched to verify SSL/TLS certificates by default.

- Python now defaults to 3.10, updated from 3.9.

## Backward Incompatibilities {#sec-release-22.11-incompatibilities}

- Nixpkgs now requires Nix 2.3 or newer.

- The `isCompatible` predicate checking CPU compatibility is no longer exposed
  by the platform sets generated using `lib.systems.elaborate`. In most cases
  you will want to use the new `canExecute` predicate instead which also
  takes the kernel / syscall interface into account.
  `lib.systems.parse.isCompatible` still exists, but has changed semantically:
  Architectures with differing endianness modes are *no longer considered compatible*.

- `ngrok` has been upgraded from 2.3.40 to 3.0.4. Please see [the upgrade guide](https://ngrok.com/docs/guides/upgrade-v2-v3)
  and [changelog](https://ngrok.com/docs/ngrok-agent/changelog). Notably, breaking changes are that the config file format has
  changed and support for single hyphen arguments was dropped.

- `i18n.supportedLocales` is now only generated with the locales set in `i18n.defaultLocale` and `i18n.extraLocaleSettings`.
  - This reduces the final system closure size by up to 200MB.
  - If you require all locales installed, set the option to ``[ "all" ]``.

- Deprecated settings `logrotate.paths` and `logrotate.extraConfig` have
  been removed. Please convert any uses to
  [services.logrotate.settings](#opt-services.logrotate.settings) instead.

- The `isPowerPC` predicate, found on `platform` attrsets (`hostPlatform`, `buildPlatform`, `targetPlatform`, etc) has been removed in order to reduce confusion.  The predicate was was defined such that it matches only the 32-bit big-endian members of the POWER/PowerPC family, despite having a name which would imply a broader set of systems.  If you were using this predicate, you can replace `foo.isPowerPC` with `(with foo; isPower && is32bit && isBigEndian)`.

- The `fetchgit` fetcher now uses [cone mode](https://www.git-scm.com/docs/git-sparse-checkout/2.37.0#_internalscone_mode_handling) by default for sparse checkouts. [Non-cone mode](https://www.git-scm.com/docs/git-sparse-checkout/2.37.0#_internalsnon_cone_problems) can be enabled by passing `nonConeMode = true`, but note that non-cone mode is deprecated and this option may be removed alongside a future Git update without notice.

- The `fetchgit` fetcher supports sparse checkouts via the `sparseCheckout` option. This used to accept a multi-line string with directories/patterns to check out, but now requires a list of strings.

- `openssh` was updated to version 9.1, disabling the generation of DSA keys when using `ssh-keygen -A` as they are insecure. Also, `SetEnv` directives in `ssh_config` and `sshd_config` are now first-match-wins.

- `bsp-layout` no longer uses the command `cycle` to switch to other window layouts, as it got replaced by the commands `previous` and `next`.

- The Barco ClickShare driver/client package `pkgs.clickshare-csc1` and the option `programs.clickshare-csc1.enable` have been removed,
  as it requires `qt4`, which reached its end-of-life 2015 and will no longer be supported by nixpkgs.
  [According to Barco](https://www.barco.com/de/support/knowledge-base/4380-can-i-use-linux-os-with-clickshare-base-units) many of their base unit models can be used with Google Chrome and the Google Cast extension.

- `services.hbase` has been renamed to `services.hbase-standalone`.
  For production HBase clusters, use `services.hadoop.hbase` instead.

- The `p4` package now only includes the open-source Perforce Helix Core command-line client and APIs. It no longer installs the unfree Helix Core Server binaries `p4d`, `p4broker`, and `p4p`. To install the Helix Core Server binaries, use the `p4d` package instead.

- The OpenSSL extension for the PHP interpreter used by Nextcloud is built against OpenSSL 1.1 if
  [](#opt-system.stateVersion) is below `22.11`. This is to make sure that people using [server-side encryption](https://docs.nextcloud.com/server/latest/admin_manual/configuration_files/encryption_configuration.html)
  don't lose access to their files.

  In any other case, it's safe to use OpenSSL 3 for PHP's OpenSSL extension. This can be done by setting
  `services.nextcloud.enableBrokenCiphersForSSE` to `false`.

- The `coq` package and versioned variants starting at `coq_8_14` no
  longer include CoqIDE, which is now available through
  `coqPackages.coqide`. It is still possible to get CoqIDE as part of
  the `coq` package by overriding the `buildIde` argument of the
  derivation.

- PHP 7.4 is no longer supported due to upstream not supporting this
  version for the entire lifecycle of the 22.11 release.

- The ipfs package and module were renamed to kubo. The kubo module now uses an RFC42-style `settings` option instead of `extraConfig` and the `gatewayAddress`, `apiAddress` and `swarmAddress` options were renamed. Using the old names will print a warning but still work.

- `pkgs.cosign` does not provide the `cosigned` binary anymore. The `sget` binary has been moved into its own package.

- Emacs now uses the Lucid toolkit by default instead of GTK because of stability and compatibility issues.
  Users who still wish to remain using GTK can do so by using `emacs-gtk`.

- `kanidm` has been updated to 1.1.0-alpha.10 and now requires a TLS certificate and key. It will always start `https` and-–-if enabled-–-an LDAPS server and no HTTP and LDAP server anymore.

- riak package removed along with `services.riak` module, due to lack of maintainer to update the package.

- ppd files in `pkgs.cups-drv-rastertosag-gdi` are now gzipped.  If you refer to such a ppd file with its path (e.g. via [hardware.printers.ensurePrinters](options.html#opt-hardware.printers.ensurePrinters)) you will need to append `.gz` to the path.

- xow package removed along with the `hardware.xow` module, due to the project being deprecated in favor of `xone`,  which is available via the `hardware.xone` module.

- dd-agent package removed along with the `services.dd-agent` module, due to the project being deprecated in favor of `datadog-agent`,  which is available via the `services.datadog-agent` module.

- `teleport` has been upgraded to major version 10. Please see upstream [upgrade instructions](https://goteleport.com/docs/ver/10.0/management/operations/upgrading/) and [release notes](https://goteleport.com/docs/ver/10.0/changelog/#1000).

- `lib.closePropagation` now needs that all gathered sets have an `outPath` attribute.

- lemmy module option `services.lemmy.settings.database.createLocally`
  moved to `services.lemmy.database.createLocally`.

- virtlyst package and `services.virtlyst` module removed, due to lack of maintainers.

- The `nix.checkConfig` option now fully disables the config check. The new `nix.checkAllErrors` option behaves like `nix.checkConfig`  previously did.

- `generateOptparseApplicativeCompletions` and `generateOptparseApplicativeCompletion` from `haskell.lib.compose`
  (and `haskell.lib`) have been deprecated in favor of `generateOptparseApplicativeCompletions` (plural!) as
  provided by the haskell package sets (so `haskellPackages.generateOptparseApplicativeCompletions` etc.).
  The latter allows for cross-compilation (by automatically disabling generation of completion in the cross case).
  For it to work properly you need to make sure that the function comes from the same context as the package
  you are trying to override, i.e. always use the same package set as your package is coming from or – even
  better – use `self.generateOptparseApplicativeCompletions` if you are overriding a haskell package set.
  The old functions are retained for backwards compatibility, but yield are warning.

- The `services.graphite.api` and `services.graphite.beacon` NixOS options, and
  the `python3.pkgs.graphite_api`, `python3.pkgs.graphite_beacon` and
  `python3.pkgs.influxgraph` packages, have been removed due to lack of upstream
  maintenance.

- The `trace` binary from `perf-linux` package has been removed, due to being a duplicate of the `perf` binary.

- The `aws` package has been removed due to being abandoned by the upstream. It is recommended to use `awscli` or `awscli2` instead.

- The [CEmu TI-84 Plus CE emulator](https://ce-programming.github.io/CEmu) package has been renamed to `cemu-ti`. The [Cemu Wii U emulator](https://cemu.info) is now packaged as `cemu`.

- `systemd-networkd` v250 deprecated, renamed, and moved some sections and settings which leads to the following breaking module changes:

   * `systemd.network.networks.<name>.dhcpV6PrefixDelegationConfig` is renamed to `systemd.network.networks.<name>.dhcpPrefixDelegationConfig`.
   * `systemd.network.networks.<name>.dhcpV6Config` no longer accepts the `ForceDHCPv6PDOtherInformation=` setting. Please use the `WithoutRA=` and `UseDelegatedPrefix=` settings in your `systemd.network.networks.<name>.dhcpV6Config` and the `DHCPv6Client=` setting in your `systemd.network.networks.<name>.ipv6AcceptRAConfig` to control when the DHCPv6 client is started and how the delegated prefixes are handled by the DHCPv6 client.
   * `systemd.network.networks.<name>.networkConfig` no longer accepts the `IPv6Token=` setting. Use the `Token=` setting in your `systemd.network.networks.<name>.ipv6AcceptRAConfig` instead. The `systemd.network.networks.<name>.ipv6Prefixes.*.ipv6PrefixConfig` now also accepts the `Token=` setting.

- `arangodb` versions 3.3, 3.4, and 3.5 have been removed because they are at EOL upstream. The default is now 3.10.0. Support for aarch64-linux has been removed since the target cannot be built reproducibly. By default `arangodb` is now built for the `haswell` architecture. If you wish to build for a different architecture, you may override the `targetArchitecture` argument with a value from [this list supported upstream](https://github.com/arangodb/arangodb/blob/207ec6937e41a46e10aea34953879341f0606841/cmake/OptimizeForArchitecture.cmake#L594). Some architecture specific optimizations are also conditionally enabled. You may alter this behavior by overriding the `asmOptimizations` parameter. You may also add additional architecture support by adding more `-DHAS_XYZ` flags to `cmakeFlags` via `overrideAttrs`.

- The `meta.mainProgram` attribute of packages in `wineWowPackages` now defaults to `"wine64"`.

- The `paperless` module now defaults `PAPERLESS_TIME_ZONE` to your configured system timezone.

- The top-level `termonad-with-packages` alias for `termonad` has been removed.

- Linux 4.9 has been removed because it will reach its end of life within the lifespan of 22.11.

- (Neo)Vim can not be configured with `configure.pathogen` anymore to reduce maintenance burden.
  Use `configure.packages` instead.
- Neovim can not be configured with plug anymore (still works for vim).

- The `adguardhome` module no longer uses `host` and `port` options, use `settings.bind_host` and `settings.bind_port` instead.

- The default `kops` version is now 1.25.1 and support for 1.22 and older has been dropped.

- The `zrepl` package has been updated from 0.5.0 to 0.6.0. See the [changelog](https://zrepl.github.io/changelog.html) for details.

- `k3s` no longer supports Docker as runtime due to upstream dropping support.

- `cassandra_2_1` and `cassandra_2_2` have been removed. Please update to `cassandra_3_11` or `cassandra_3_0`. See the [changelog](https://github.com/apache/cassandra/blob/cassandra-3.11.14/NEWS.txt) for more information about the upgrade process.

- `mysql57` has been removed. Please update to `mysql80` or `mariadb`. See the [upgrade guide](https://mariadb.com/kb/en/upgrading-from-mysql-to-mariadb/) for more information.

- Consequently, `cqrlog` and `amorok` now use `mariadb` instead of `mysql57` for their embedded databases. Running `mysql_upgrade` may be necessary.
- `k3s` supports `clusterInit` option, and it is enabled by default, for servers.

- `percona-server56` has been removed. Please migrate to `mysql` or `mariadb` if possible.

- `obs-studio` hase been updated to version 28. If you have packaged custom plugins, check if they are compatible. `obs-websocket` has been integrated into `obs-studio`.

- `signald` has been bumped to `0.23.0`. For the upgrade, a migration process is necessary. It can be
  done by running a command like this before starting `signald.service`:

  ```
  signald -d /var/lib/signald/db \
    --database sqlite:/var/lib/signald/db \
    --migrate-data
  ```

  For further information, please read the upstream changelogs.

- `stylua` no longer accepts `lua52Support` and `luauSupport` overrides. Use `features` instead, which defaults to `[ "lua54" "luau" ]`.

- `ocamlPackages.ocaml_extlib` has been renamed to `ocamlPackages.extlib`.

- `pkgs.fetchNextcloudApp` has been rewritten to circumvent impurities in e.g. tarballs from GitHub and to make it easier to
  apply patches. This means that your hashes are out-of-date and the (previously required) attributes `name` and `version`
  are no longer accepted.

- The Syncthing service now only allows absolute paths---starting with `/` or
  `~/`---for `services.syncthing.folders.<name>.path`.
  In a future release other paths will be allowed again and interpreted
  relative to `services.syncthing.dataDir`.

- `services.github-runner` and `services.github-runners.<name>` gained the option `serviceOverrides` which allows overriding the systemd `serviceConfig`. If you have been overriding the systemd service configuration (i.e., by defining `systemd.services.github-runner.serviceConfig`), you have to use the `serviceOverrides` option now. Example:

  ```nix
  { services.github-runner.serviceOverrides.SupplementaryGroups = [ "docker" ]; }
  ```

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

## Other Notable Changes {#sec-release-22.11-notable-changes}

- PHP is now built in `NTS` (Non-Thread Safe) mode by default.
  - For Apache and `mod_php` usage, we enable `ZTS` (Zend Thread Safe) mode. This has been a
  common practice for a long time in other distributions.

- `firefox`, `thunderbird` and `librewolf` now come with Wayland support by default. The `firefox-wayland`, `firefox-esr-wayland`, `thunderbird-wayland` and `librewolf-wayland` attributes are obsolete and have been aliased to their generic attribute.

- The `xplr` package has been updated from 0.18.0 to 0.19.0, which brings some breaking changes. See the [upstream release notes](https://github.com/sayanarijit/xplr/releases/tag/v0.19.0) for more details.

- Configuring multiple GitHub runners is now possible through `services.github-runners.<name>`. The options under `services.github-runner` remain, to configure a single runner.

- `github-runner` gained support for ephemeral runners and registrations using a personal access token (PAT) instead of a registration token. See `services.github-runner.ephemeral` and `services.github-runner.tokenFile` for details.

- A new module was added to provide hardware support for the Saleae Logic device family, providing the options `hardware.saleae-logic.enable` and `hardware.saleae-logic.package`.

- ZFS module will no longer allow hibernation by default.
  - This is a safety measure to prevent data loss cases like the ones described at [OpenZFS/260](https://github.com/openzfs/zfs/issues/260) and [OpenZFS/12842](https://github.com/openzfs/zfs/issues/12842).
  - Use the `boot.zfs.allowHibernation` option to configure this behaviour.

- Mastodon now automatically removes remote media attachments older than 30 days. This is configurable through `services.mastodon.mediaAutoRemove`.

- The Redis module now disables RDB persistence when `services.redis.servers.<name>.save = []` instead of using the Redis default.

- Neo4j was updated from version 3 to version 4. See upstream's [migration guide](https://neo4j.com/docs/upgrade-migration-guide/current/) for information on how to migrate your instance.

- The `networking.wireguard` module now can set the mtu on interfaces and tag its packets with an fwmark.

- The option `overrideStrategy` was added to the different systemd unit options (`systemd.services.<name>`, `systemd.sockets.<name>`, …) to allow enforcing the creation of a dropin file, rather than the main unit file, by setting it to `asDropin`.
  This is useful in cases where the existence of the main unit file is not known to Nix at evaluation time, for example when the main unit file is provided by adding a package to `systemd.packages`.
  See the fix proposed in [NixOS's systemd abstraction doesn't work with systemd template units](https://github.com/NixOS/nixpkgs/issues/135557#issuecomment-1295392470) for an example.

- The `polymc` package has been removed due to a rogue maintainer. It has been
  replaced by `prismlauncher`, a fork by the rest of the maintainers. For more
  details, see [the PR that made this change](https://github.com/NixOS/nixpkgs/pull/196624) and
  [the issue detailing the vulnerability](https://github.com/NixOS/nixpkgs/issues/196460).
  Users with existing installations should rename `~/.local/share/polymc` to
  `~/.local/share/PrismLauncher`. The main config file's path has also moved
  from `~/.local/share/polymc/polymc.cfg` to
  `~/.local/share/PrismLauncher/prismlauncher.cfg`.

- The `bloat` package has been updated from unstable-2022-03-31 to unstable-2022-10-25, which brings a breaking change. See [this upstream commit message](https://git.freesoftwareextremist.com/bloat/commit/?id=887ed241d64ba5db3fd3d87194fb5595e5ad7d73) for details.

- Synapse's systemd unit has been hardened.

- The module `services.grafana` was refactored to be compliant with [RFC 0042](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md). To be precise, this means that the following things have changed:
  - The newly introduced option [](#opt-services.grafana.settings) is an attribute-set that
    will be converted into Grafana's INI format. This means that the configuration from
    [Grafana's configuration reference](https://grafana.com/docs/grafana/latest/setup-grafana/configure-grafana/)
    can be directly written as attribute-set in Nix within this option.
  - The option `services.grafana.extraOptions` has been removed. This option was an association
    of environment variables for Grafana. If you had an expression like

    ```nix
    { services.grafana.extraOptions.SECURITY_ADMIN_USER = "foobar"; }
    ```

    your Grafana instance was running with `GF_SECURITY_ADMIN_USER=foobar` in its environment.

    For the migration, it is recommended to turn it into the INI format, i.e.
    to declare

    ```nix
    { services.grafana.settings.security.admin_user = "foobar"; }
    ```

    instead.

    The keys in `services.grafana.extraOptions` have the format `<INI section name>_<Key Name>`.
    Further details are outlined in the [configuration reference](https://grafana.com/docs/grafana/latest/setup-grafana/configure-grafana/#override-configuration-with-environment-variables).

    Alternatively you can also set all your values from `extraOptions` to
    `systemd.services.grafana.environment`, make sure you don't forget to add
    the `GF_` prefix though!
  - Previously, the options [services.grafana.provision.datasources](#opt-services.grafana.provision.datasources) and
    [services.grafana.provision.dashboards](#opt-services.grafana.provision.dashboards) expected lists of datasources
    or dashboards for the [declarative provisioning](https://grafana.com/docs/grafana/latest/administration/provisioning/).

    To declare lists of
    - **datasources**, please rename your declarations to [services.grafana.provision.datasources.settings.datasources](#opt-services.grafana.provision.datasources.settings.datasources).
    - **dashboards**, please rename your declarations to [services.grafana.provision.dashboards.settings.providers](#opt-services.grafana.provision.dashboards.settings.providers).

    This change was made to support more features for that:

    - It's possible to declare the `apiVersion` of your dashboards and datasources
      by [services.grafana.provision.datasources.settings.apiVersion](#opt-services.grafana.provision.datasources.settings.apiVersion) (or
      [services.grafana.provision.dashboards.settings.apiVersion](#opt-services.grafana.provision.dashboards.settings.apiVersion)).

    - Instead of declaring datasources and dashboards in pure Nix, it's also possible
      to specify configuration files (or directories) with YAML instead using
      [services.grafana.provision.datasources.path](#opt-services.grafana.provision.datasources.path) (or
      [services.grafana.provision.dashboards.path](#opt-services.grafana.provision.dashboards.path). This is useful when having
      provisioning files from non-NixOS Grafana instances that you also want to
      deploy to NixOS.

      __Note:__ secrets from these files will be leaked into the store unless you use a
      [**file**-provider or env-var](https://grafana.com/docs/grafana/latest/setup-grafana/configure-grafana/#file-provider) for secrets!

    - `services.grafana.provision.notifiers` is not affected by this change because
      this feature is deprecated by Grafana and will probably be removed in Grafana 10.
      It's recommended to use `services.grafana.provision.alerting.contactPoints` instead.

- The `services.grafana.provision.alerting` option was added. It includes suboptions for every alerting-related objects (with the exception of `notifiers`), which means it's now possible to configure modern Grafana alerting declaratively.

- Synapse now requires entries in the `state_group_edges` table to be unique, in order to prevent accidentally introducing duplicate information (for example, because a database backup was restored multiple times). If your Synapse database already has duplicate rows in this table, this could fail with an error and require manual remediation.

- The `diamond` package has been update from 0.8.36 to 2.0.15. See the [upstream release notes](https://github.com/bbuchfink/diamond/releases) for more details.

- The `guake` package has been updated from 3.6.3 to 3.9.0, see the [changelog](https://github.com/Guake/guake/releases) for more details.

- The `netlify-cli` package has been updated from 6.13.2 to 12.2.4, see the [changelog](https://github.com/netlify/cli/releases) for more details.

- `dockerTools.buildImage`'s `contents` parameter has been deprecated in favor of `copyToRoot`.
  Use `copyToRoot = buildEnv { ... };` or similar if you intend to add packages to `/bin`.

- The `proxmox.qemuConf.bios` option was added, it corresponds to `Hardware->BIOS` field in Proxmox web interface. Use `"ovmf"` value to build UEFI image, default value remains `"bios"`. New option `proxmox.partitionTableType` defaults to either `"legacy"` or `"efi"`, depending on the `bios` value. Setting `partitionTableType` to `"hybrid"` results in an image, which supports both methods (`"bios"` and `"ovmf"`), thereby remaining bootable after change to Proxmox `Hardware->BIOS` field.

- memtest86+ was updated from 5.00-coreboot-002 to 6.00-beta2. It is now the upstream version from https://www.memtest.org/, as coreboot's fork is no longer available.

- Option descriptions, examples, and defaults writing in DocBook are now deprecated. Using CommonMark is preferred and will become the default in a future release.

- The `documentation.nixos.options.allowDocBook` option was added to ease the transition to CommonMark option documentation. Setting this option to `false` causes an error for every option included in the manual that uses DocBook documentation; it defaults to `true` to preserve the previous behavior and will be removed once the transition to CommonMark is complete.

- The Redis module now persists each instance's configuration file in the state directory, in order to support some more advanced use cases like Sentinel.

- `protonup` has been aliased to and replaced by `protonup-ng` due to upstream not maintaining it.

- The udisks2 service, available at `services.udisks2.enable`, is now disabled by default. It will automatically be enabled through services and desktop environments as needed.
  This also means that polkit will now actually be disabled by default. The default for `security.polkit.enable` was already flipped in the previous release, but udisks2 being enabled by default re-enabled it.

- Nextcloud has been updated to version **25**. Additionally the following things have changed
  for Nextcloud in NixOS:
  - For Nextcloud **>=24**, the default PHP version is 8.1.
  - Nextcloud **23** has been removed since it will reach its [end of life in December 2022](https://github.com/nextcloud/server/wiki/Maintenance-and-Release-Schedule/d76576a12a626d53305d480a6065b57cab705d3d).
  - If `system.stateVersion` is **>=22.11**, Nextcloud 25 will be installed by default. For older versions,
    Nextcloud 24 will be installed.
  - Please ensure that you only upgrade one major release at a time! Nextcloud doesn't support
    upgrades across multiple versions, i.e. an upgrade from **23** to **25** is only possible
    when upgrading to **24** first.

- systemd-oomd is enabled by default. Depending on which systemd units have
  `ManagedOOMSwap=kill` or `ManagedOOMMemoryPressure=kill`, systemd-oomd will
  SIGKILL all the processes under the appropriate descendant cgroups when the
  configured limits are exceeded. NixOS does currently not configure cgroups
  with oomd by default, this can be enabled using
  [systemd.oomd.enableRootSlice](options.html#opt-systemd.oomd.enableRootSlice),
  [systemd.oomd.enableSystemSlice](options.html#opt-systemd.oomd.enableSystemSlice),
  and [systemd.oomd.enableUserServices](options.html#opt-systemd.oomd.enableUserServices).

- The `tt-rss` service performs two database migrations when you first use its web UI after upgrade. Consider backing up its database before updating.

- The `pass-secret-service` package now includes systemd units from upstream, so adding it to the NixOS `services.dbus.packages` option will make it start automatically as a systemd user service when an application tries to talk to the libsecret D-Bus API.

- The Wordpress module now has support for installing language packs through a new option, `services.wordpress.sites.<site>.languages`.

- The default package for `services.mullvad-vpn.package` was changed to `pkgs.mullvad`, allowing cross-platform usage of Mullvad. `pkgs.mullvad` only contains the Mullvad CLI tool, so users who rely on the Mullvad GUI will want to change it back to `pkgs.mullvad-vpn`, or add `pkgs.mullvad-vpn` to their environment.

- PowerDNS has been updated from v4.6.2 to v4.7.2. Please be sure to review the [Upgrade Notes](https://doc.powerdns.com/authoritative/upgrading.html#to-4-7-0-or-master) provided by upstream before upgrading. Worth specifically noting is that the new Catalog Zones feature comes with a mandatory schema change for the GSQL database backends, which has to be manually applied.

- There is a new module for the `thunar` program (the Xfce file manager), which depends on the `xfconf` dbus service, and also has a dbus service and a systemd unit. The option `services.xserver.desktopManager.xfce.thunarPlugins` has been renamed to `programs.thunar.plugins`, and may be removed in a future release.

- There is a new module for `xfconf` (the Xfce configuration storage system), which has a dbus service.

- The Mastodon package has been upgraded to v4.0.0. See the [v4.0.0 release notes](https://github.com/mastodon/mastodon/releases/tag/v4.0.0) for a list of changes. On standard setups, no manual migration steps are required. Nevertheless, a database backup is recommended.

- The `nomad` package now defaults to v1.3, which no longer has a downgrade path to v1.2 or older.

- The `nodePackages` package set now defaults to the LTS release in the `nodejs` package again, instead of being pinned to `nodejs-14_x`. Several updates to node2nix have been made for compatibility with newer Node.js and npm versions and a new `postRebuild` hook has been added for packages to perform extra build steps before the npm install step prunes dev dependencies.

- `boot.kernel.sysctl` is defined as a freeformType and adds a custom merge option for `net.core.rmem_max` (taking the highest value defined to avoid conflicts between 2 services trying to set that value).

- The `mame` package does not ship with its tools anymore in the default output. They were moved to a separate `tools` output instead. For convenience, `mame-tools` package was added for those who want to use it.

- A NixOS module for Firefox has been added which allows preferences and [policies](https://github.com/mozilla/policy-templates/blob/master/README.md) to be set. This also allows extensions to be installed via the `ExtensionSettings` policy. The new options are under `programs.firefox`.

- The option `services.picom.experimentalBackends` was removed since it is now the default and the option will cause `picom` to quit instead.

- `haskellPackages.callHackage` is not always invalidated if `all-cabal-hashes` changes, leading to less rebuilds of haskell dependencies.

- `haskellPackages.callHackage` and `haskellPackages.callCabal2nix` (and related functions) no longer keep a reference to the `cabal2nix` call used to generate them. As a result, they will be garbage collected more often.

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

## New Services {#sec-release-22.11-new-services}

- [alps](https://git.sr.ht/~migadu/alps), a simple and extensible webmail. Available as [services.alps](#opt-services.alps.enable).

- [appvm](https://github.com/jollheef/appvm), Nix based app VMs. Available as [virtualisation.appvm](options.html#opt-virtualisation.appvm.enable).

- [AusweisApp2](https://www.ausweisapp.bund.de/), the authentication software for the German ID card. Available as [programs.ausweisapp](#opt-programs.ausweisapp.enable).

- [automatic-timezoned](https://github.com/maxbrunet/automatic-timezoned). a Linux daemon to automatically update the system timezone based on location. Available as [services.automatic-timezoned](#opt-services.automatic-timezoned.enable).

- [Dolibarr](https://www.dolibarr.org/), an enterprise resource planning and customer relationship manager. Enable using [services.dolibarr](#opt-services.dolibarr.enable).

- [dragonflydb](https://dragonflydb.io/), a modern replacement for Redis and Memcached. Available as [services.dragonflydb](#opt-services.dragonflydb.enable).

- [endlessh-go](https://github.com/shizunge/endlessh-go), an SSH tarpit that exposes Prometheus metrics. Available as [services.endlessh-go](#opt-services.endlessh-go.enable).

- [endlessh](https://github.com/skeeto/endlessh), an SSH tarpit. Available as [services.endlessh](#opt-services.endlessh.enable).

- [EVCC](https://evcc.io) is an EV charge controller with PV integration. It supports a multitude of chargers, meters, vehicle APIs and more and ties that together with a well-tested backend and a lightweight web frontend. Available as [services.evcc](#opt-services.evcc.enable).

- [expressvpn](https://www.expressvpn.com), the CLI client for ExpressVPN. Available as [services.expressvpn](#opt-services.expressvpn.enable).

- [FreshRSS](https://freshrss.org/), a free, self-hostable RSS feed aggregator. Available as [services.freshrss](#opt-services.freshrss.enable).

- [Garage](https://garagehq.deuxfleurs.fr/), a simple object storage server for geodistributed deployments, alternative to MinIO. Available as [services.garage](#opt-services.garage.enable).

- [go-autoconfig](https://github.com/L11R/go-autoconfig), IMAP/SMTP autodiscover server. Available as [services.go-autoconfig](#opt-services.go-autoconfig.enable).

- [Grafana Tempo](https://www.grafana.com/oss/tempo/), a distributed tracing store. Available as [services.tempo](#opt-services.tempo.enable).

- [HBase cluster](https://hbase.apache.org/), a distributed, scalable, big data store. Available as [services.hadoop.hbase](options.html#opt-services.hadoop.hbase.enable).

- [infnoise](https://github.com/leetronics/infnoise), a hardware True Random Number Generator dongle. Available as [services.infnoise](options.html#opt-services.infnoise.enable).

- [kanata](https://github.com/jtroo/kanata), a tool to improve keyboard comfort and usability with advanced customization. Available as [services.kanata](options.html#opt-services.kanata.enable).

- [karma](https://github.com/prymitive/karma), an alert dashboard for Prometheus Alertmanager. Available as [services.karma](options.html#opt-services.karma.enable)

- [Komga](https://komga.org/), a free and open source comics/mangas media server. Available as [services.komga](#opt-services.komga.enable).

- [kthxbye](https://github.com/prymitive/kthxbye), an alert acknowledgement management daemon for Prometheus Alertmanager. Available as [services.kthxbye](options.html#opt-services.kthxbye.enable)

- [languagetool](https://languagetool.org/), a multilingual grammar, style, and spell checker. Available as [services.languagetool](options.html#opt-services.languagetool.enable).

- [Listmonk](https://listmonk.app), a self-hosted newsletter manager. Enable using [services.listmonk](options.html#opt-services.listmonk.enable).

- [Mepo](https://mepo.milesalan.com), a fast, simple, hackable OSM map viewer for mobile and desktop Linux. Available as [programs.mepo.enable](#opt-programs.mepo.enable).

- [merecat](https://troglobit.com/projects/merecat/), a small and easy HTTP server based on thttpd. Available as [services.merecat](#opt-services.merecat.enable)

- [netbird](https://netbird.io), a zero configuration VPN. Available as [services.netbird](options.html#opt-services.netbird.enable).

- [ntfy.sh](https://ntfy.sh), a push notification service. Available as [services.ntfy-sh](#opt-services.ntfy-sh.enable)

- [OpenRGB](https://gitlab.com/CalcProgrammer1/OpenRGB/-/tree/master), a FOSS tool for controlling RGB lighting. Available as [services.hardware.openrgb.enable](options.html#opt-services.hardware.openrgb.enable).

- [Outline](https://www.getoutline.com/), a wiki and knowledge base similar to Notion. Available as [services.outline](#opt-services.outline.enable).

- [Patroni](https://github.com/zalando/patroni), a template for PostgreSQL HA with ZooKeeper, etcd or Consul. Available as [services.patroni](options.html#opt-services.patroni.enable).

- [persistent-evdev](https://github.com/aiberia/persistent-evdev), a daemon to add virtual proxy devices that mirror a physical input device but persist even if the underlying hardware is hot-plugged. Available as [services.persistent-evdev](#opt-services.persistent-evdev.enable).

- [Please](https://github.com/edneville/please), a Sudo clone written in Rust. Available as [security.please](#opt-security.please.enable).

- [Prometheus IPMI exporter](https://github.com/prometheus-community/ipmi_exporter), an IPMI exporter for Prometheus. Available as [services.prometheus.exporters.ipmi](#opt-services.prometheus.exporters.ipmi.enable).

- [Sachet](https://github.com/messagebird/sachet/), an SMS alerting tool for the Prometheus Alertmanager. Available as [services.prometheus.sachet](#opt-services.prometheus.sachet.enable).

- [schleuder](https://schleuder.org/), a mailing list manager with PGP support. Enable using [services.schleuder](#opt-services.schleuder.enable).

- [syncstorage-rs](https://github.com/mozilla-services/syncstorage-rs), a self-hostable sync server for Firefox. Available as [services.firefox-syncserver](options.html#opt-services.firefox-syncserver.enable).

- [Tandoor Recipes](https://tandoor.dev), a self-hosted multi-tenant recipe collection. Available as [services.tandoor-recipes](options.html#opt-services.tandoor-recipes.enable).

- [TAYGA](http://www.litech.org/tayga/), an out-of-kernel stateless NAT64 implementation. Available as [services.tayga](#opt-services.tayga.enable).

- [tmate-ssh-server](https://github.com/tmate-io/tmate-ssh-server), server side part of [tmate](https://tmate.io/). Available as [services.tmate-ssh-server](#opt-services.tmate-ssh-server.enable).

- [Uptime Kuma](https://uptime.kuma.pet/), a fancy self-hosted monitoring tool. Available as [services.uptime-kuma](#opt-services.uptime-kuma.enable).

- [WriteFreely](https://writefreely.org), a simple blogging platform with ActivityPub support. Available as [services.writefreely](options.html#opt-services.writefreely.enable).

- [xray](https://github.com/XTLS/Xray-core), a fully compatible v2ray-core replacement. Features XTLS, which when enabled on server and client, brings UDP FullCone NAT to proxy setups. Available as [services.xray](options.html#opt-services.xray.enable).

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->
