# generated by pkgs/applications/editors/vim/plugins/utils/nvim-treesitter/update.py

{
  buildGrammar,
  fetchCrate,
  fetchFromBitbucket,
  fetchFromGitHub,
  fetchFromGitLab,
  fetchFromGitea,
  fetchFromGitiles,
  fetchFromRepoOrCz,
  fetchFromSourcehut,
  fetchHex,
  fetchPypi,
  fetchgit,
  fetchhg,
  fetchsvn,
}:

{
  ada = buildGrammar {
    language = "ada";
    version = "0.0.0+rev=e8e2515";
    src = fetchFromGitHub {
      owner = "briot";
      repo = "tree-sitter-ada";
      rev = "e8e2515465cc2d7c444498e68bdb9f1d86767f95";
      hash = "sha256-qfuVoh3R418F1FMN6CTXNnCaAk5gQj5lI/NoaJgnkW8=";
    };
    meta.homepage = "https://github.com/briot/tree-sitter-ada";
  };
  agda = buildGrammar {
    language = "agda";
    version = "0.0.0+rev=b9b32fa";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-agda";
      rev = "b9b32fa042c2952a7bfca86847ea325e44ccc897";
      hash = "sha256-Goll4J6xrHO8YEuYoLR2rqy6lCMsr4JJbEs5C1jiX5Q=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-agda";
  };
  angular = buildGrammar {
    language = "angular";
    version = "0.0.0+rev=8435251";
    src = fetchFromGitHub {
      owner = "dlvandenberg";
      repo = "tree-sitter-angular";
      rev = "843525141575e397541e119698f0532755e959f6";
      hash = "sha256-SPBtbwEMGPrEUCbxSlQl44+hK4Yphngp8QsLkmMsDBk=";
    };
    meta.homepage = "https://github.com/dlvandenberg/tree-sitter-angular";
  };
  apex = buildGrammar {
    language = "apex";
    version = "0.0.0+rev=3597575";
    src = fetchFromGitHub {
      owner = "aheber";
      repo = "tree-sitter-sfapex";
      rev = "3597575a429766dd7ecce9f5bb97f6fec4419d5d";
      hash = "sha256-TOytPX/jBdVDYHBacpT9hAVVZcW+XGvIsubAqs9Dm80=";
    };
    location = "apex";
    meta.homepage = "https://github.com/aheber/tree-sitter-sfapex";
  };
  arduino = buildGrammar {
    language = "arduino";
    version = "0.0.0+rev=017696b";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-arduino";
      rev = "017696bdf47ca2b10948c5a511f9ab387722d0f3";
      hash = "sha256-zIs3ujkxfgCj6VBkNy/mobsAQ2mcxtjDMHxiQEMlWm8=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-arduino";
  };
  asm = buildGrammar {
    language = "asm";
    version = "0.0.0+rev=04962e1";
    src = fetchFromGitHub {
      owner = "RubixDev";
      repo = "tree-sitter-asm";
      rev = "04962e15f6b464cf1d75eada59506dc25090e186";
      hash = "sha256-a/wbmJQFddf+19E2uHmObQ5XfUkF5iaCSI1Y8avntGw=";
    };
    meta.homepage = "https://github.com/RubixDev/tree-sitter-asm";
  };
  astro = buildGrammar {
    language = "astro";
    version = "0.0.0+rev=0ad33e3";
    src = fetchFromGitHub {
      owner = "virchau13";
      repo = "tree-sitter-astro";
      rev = "0ad33e32ae9726e151d16ca20ba3e507ff65e01f";
      hash = "sha256-LhehKOhCDPExEgEiOj3TiuFk8/DohzYhy/9GmUSxaIg=";
    };
    meta.homepage = "https://github.com/virchau13/tree-sitter-astro";
  };
  authzed = buildGrammar {
    language = "authzed";
    version = "0.0.0+rev=1dec7e1";
    src = fetchFromGitHub {
      owner = "mleonidas";
      repo = "tree-sitter-authzed";
      rev = "1dec7e1af96c56924e3322cd85fdce15d0a31d00";
      hash = "sha256-qPSQF95DO7WByVy9YXEOus3q3U4QfWuUFbJGVXd4EtQ=";
    };
    meta.homepage = "https://github.com/mleonidas/tree-sitter-authzed";
  };
  awk = buildGrammar {
    language = "awk";
    version = "0.0.0+rev=34bbdc7";
    src = fetchFromGitHub {
      owner = "Beaglefoot";
      repo = "tree-sitter-awk";
      rev = "34bbdc7cce8e803096f47b625979e34c1be38127";
      hash = "sha256-MDfAtG6ZC0KttJ5bdW71Jgts+SAJitRnwu8xQ26N9K0=";
    };
    meta.homepage = "https://github.com/Beaglefoot/tree-sitter-awk";
  };
  bash = buildGrammar {
    language = "bash";
    version = "0.0.0+rev=0c46d79";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-bash";
      rev = "0c46d792d54c536be5ff7eb18eb95c70fccdb232";
      hash = "sha256-ODWgFpCLLPgzNYXFhfAVvDXPr5bW8/49ezsaS9MOWMk=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-bash";
  };
  bass = buildGrammar {
    language = "bass";
    version = "0.0.0+rev=28dc705";
    src = fetchFromGitHub {
      owner = "vito";
      repo = "tree-sitter-bass";
      rev = "28dc7059722be090d04cd751aed915b2fee2f89a";
      hash = "sha256-NKu60BbTKLsYQRtfEoqGQUKERJFnmZNVJE6HBz/BRIM=";
    };
    meta.homepage = "https://github.com/vito/tree-sitter-bass";
  };
  beancount = buildGrammar {
    language = "beancount";
    version = "0.0.0+rev=9bc460a";
    src = fetchFromGitHub {
      owner = "polarmutex";
      repo = "tree-sitter-beancount";
      rev = "9bc460a05b5f096d69568b5fb36105032ff4ff97";
      hash = "sha256-MSLM7Or1SZeqj0WzJ26o5cmYa5vWcSbMhDzMkqWRJgE=";
    };
    meta.homepage = "https://github.com/polarmutex/tree-sitter-beancount";
  };
  bibtex = buildGrammar {
    language = "bibtex";
    version = "0.0.0+rev=ccfd77d";
    src = fetchFromGitHub {
      owner = "latex-lsp";
      repo = "tree-sitter-bibtex";
      rev = "ccfd77db0ed799b6c22c214fe9d2937f47bc8b34";
      hash = "sha256-wgduSxlpbJy/ITenBLfj5lhziUM1BApX6MjXhWcb7lQ=";
    };
    meta.homepage = "https://github.com/latex-lsp/tree-sitter-bibtex";
  };
  bicep = buildGrammar {
    language = "bicep";
    version = "0.0.0+rev=bff5988";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-bicep";
      rev = "bff59884307c0ab009bd5e81afd9324b46a6c0f9";
      hash = "sha256-+qvhJgYqs8aj/Kmojr7lmjbXmskwVvbYBn4ia9wOv3k=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-bicep";
  };
  bitbake = buildGrammar {
    language = "bitbake";
    version = "0.0.0+rev=a5d04fd";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-bitbake";
      rev = "a5d04fdb5a69a02b8fa8eb5525a60dfb5309b73b";
      hash = "sha256-SzHFNIeR6ukWXKkLd2Trg9zuKLMwNAolXGPIDBDaFRg=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-bitbake";
  };
  blade = buildGrammar {
    language = "blade";
    version = "0.0.0+rev=bcdc4b0";
    src = fetchFromGitHub {
      owner = "EmranMR";
      repo = "tree-sitter-blade";
      rev = "bcdc4b01827cac21205f7453e9be02f906943128";
      hash = "sha256-Svco/cweC311fUlKi34sh0AWfP/VYRWJMXyAuUVRhAw=";
    };
    meta.homepage = "https://github.com/EmranMR/tree-sitter-blade";
  };
  blueprint = buildGrammar {
    language = "blueprint";
    version = "0.0.0+rev=60ba737";
    src = fetchFromGitLab {
      owner = "gabmus";
      repo = "tree-sitter-blueprint";
      rev = "60ba73739c6083c693d86a1a7cf039c07eb4ed59";
      hash = "sha256-ojm6OKgriKUqUcRBf8WgHv+BvPjUuYOaabC8VXE+Kwk=";
    };
    meta.homepage = "https://gitlab.com/gabmus/tree-sitter-blueprint.git";
  };
  bp = buildGrammar {
    language = "bp";
    version = "0.0.0+rev=16c4306";
    src = fetchFromGitHub {
      owner = "ambroisie";
      repo = "tree-sitter-bp";
      rev = "16c43068ec30828c5aed11e87262c56f36782595";
      hash = "sha256-hltHcGll7+pPSIfJdCwvNEBrRaFKqfnXD/qKSIdbM6U=";
    };
    meta.homepage = "https://github.com/ambroisie/tree-sitter-bp";
  };
  brightscript = buildGrammar {
    language = "brightscript";
    version = "0.0.0+rev=48ce168";
    src = fetchFromGitHub {
      owner = "ajdelcimmuto";
      repo = "tree-sitter-brightscript";
      rev = "48ce1687125c6dfefcc7a1bef19fa0f0f00426cc";
      hash = "sha256-eVHAl8qykIS90SpWHvpT6VEqjKuXCX8zIYlRGlhUm7w=";
    };
    meta.homepage = "https://github.com/ajdelcimmuto/tree-sitter-brightscript";
  };
  c = buildGrammar {
    language = "c";
    version = "0.0.0+rev=2a265d6";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-c";
      rev = "2a265d69a4caf57108a73ad2ed1e6922dd2f998c";
      hash = "sha256-6sebiNg9P/B/5HrbGO7bl3GHVMfVUepetJuszEeTh+8=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-c";
  };
  c_sharp = buildGrammar {
    language = "c_sharp";
    version = "0.0.0+rev=b5eb574";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-c-sharp";
      rev = "b5eb5742f6a7e9438bee22ce8026d6b927be2cd7";
      hash = "sha256-ORhtfxQ6N72UjFx6WRfdYpkM9mVkTkxQ3PX3ydjIvX4=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-c-sharp";
  };
  caddy = buildGrammar {
    language = "caddy";
    version = "0.0.0+rev=2686186";
    src = fetchFromGitHub {
      owner = "opa-oz";
      repo = "tree-sitter-caddy";
      rev = "2686186edb61be47960431c93a204fb249681360";
      hash = "sha256-pKKx2qCqP/8JLhNebTogM24qzxh6bdX5i4mqGzTJKkw=";
    };
    meta.homepage = "https://github.com/opa-oz/tree-sitter-caddy";
  };
  cairo = buildGrammar {
    language = "cairo";
    version = "0.0.0+rev=6238f60";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-cairo";
      rev = "6238f609bea233040fe927858156dee5515a0745";
      hash = "sha256-QjCt3sRINrNbaxtNwj43+g7D3xYmuh0BIAo6wWQ/54g=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-cairo";
  };
  capnp = buildGrammar {
    language = "capnp";
    version = "0.0.0+rev=7b0883c";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-capnp";
      rev = "7b0883c03e5edd34ef7bcf703194204299d7099f";
      hash = "sha256-WKrZuOMxmdGlvUI9y8JgwCNMdJ8MULucMhkmW8JCiXM=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-capnp";
  };
  chatito = buildGrammar {
    language = "chatito";
    version = "0.0.0+rev=b4cbe9a";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-chatito";
      rev = "b4cbe9ab7672d5106e9550d8413835395a1be362";
      hash = "sha256-te2Eg8J4Zf5H6FKLnCAyyKSjTABESUKzqQWwW/k/Y1c=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-chatito";
  };
  circom = buildGrammar {
    language = "circom";
    version = "0.0.0+rev=0215052";
    src = fetchFromGitHub {
      owner = "Decurity";
      repo = "tree-sitter-circom";
      rev = "02150524228b1e6afef96949f2d6b7cc0aaf999e";
      hash = "sha256-wosqwiDkK1rytGWMJApz1M42Sme9OaWXC0rmj7vM4g8=";
    };
    meta.homepage = "https://github.com/Decurity/tree-sitter-circom";
  };
  clojure = buildGrammar {
    language = "clojure";
    version = "0.0.0+rev=f4236d4";
    src = fetchFromGitHub {
      owner = "sogaiu";
      repo = "tree-sitter-clojure";
      rev = "f4236d4da8aa92bc105d9c118746474c608e6af7";
      hash = "sha256-UlK6D/xnuPFL/Cu5W7hBMQ/zbodFwrS1CeJDjVpZFpo=";
    };
    meta.homepage = "https://github.com/sogaiu/tree-sitter-clojure";
  };
  cmake = buildGrammar {
    language = "cmake";
    version = "0.0.0+rev=fe48221";
    src = fetchFromGitHub {
      owner = "uyha";
      repo = "tree-sitter-cmake";
      rev = "fe48221d4d9842d916d66b5e71ab3c6307ec28b3";
      hash = "sha256-lU6EU+ikUJ1Q/SzJ2/PzziRLO8PSS3oQ8hCANO4n8Tw=";
    };
    meta.homepage = "https://github.com/uyha/tree-sitter-cmake";
  };
  comment = buildGrammar {
    language = "comment";
    version = "0.0.0+rev=3555706";
    src = fetchFromGitHub {
      owner = "stsewd";
      repo = "tree-sitter-comment";
      rev = "3555706cef8b98d3e4c7379d7260548ff03ad363";
      hash = "sha256-7iY7D7wz+rYRWhi+429a2pcF0mUMBCnnecIssxlqvt0=";
    };
    meta.homepage = "https://github.com/stsewd/tree-sitter-comment";
  };
  commonlisp = buildGrammar {
    language = "commonlisp";
    version = "0.0.0+rev=3232350";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-commonlisp";
      rev = "32323509b3d9fe96607d151c2da2c9009eb13a2f";
      hash = "sha256-cNGxZXoxhnXGo4yhMHDSjF/j43JNXg1ClpqN2xJgLQU=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-commonlisp";
  };
  cooklang = buildGrammar {
    language = "cooklang";
    version = "0.0.0+rev=4ebe237";
    src = fetchFromGitHub {
      owner = "addcninblue";
      repo = "tree-sitter-cooklang";
      rev = "4ebe237c1cf64cf3826fc249e9ec0988fe07e58e";
      hash = "sha256-VB3BxSrhIbD8TytfOJx7IhTwl/aWasB8t3xnrO34rQE=";
    };
    meta.homepage = "https://github.com/addcninblue/tree-sitter-cooklang";
  };
  corn = buildGrammar {
    language = "corn";
    version = "0.0.0+rev=4646547";
    src = fetchFromGitHub {
      owner = "jakestanger";
      repo = "tree-sitter-corn";
      rev = "464654742cbfd3a3de560aba120998f1d5dfa844";
      hash = "sha256-fI7S+TkI2ofQ/Hal4CJ2HAaeQrjOju1rgJvyc6P3t9k=";
    };
    meta.homepage = "https://github.com/jakestanger/tree-sitter-corn";
  };
  cpon = buildGrammar {
    language = "cpon";
    version = "0.0.0+rev=594289e";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-cpon";
      rev = "594289eadfec719198e560f9d7fd243c4db678d5";
      hash = "sha256-Nr+98yrDkOS5Yh/EFmBWV9Yhv2tPfHGb4pPlLUwc+k8=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-cpon";
  };
  cpp = buildGrammar {
    language = "cpp";
    version = "0.0.0+rev=e5cea0e";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-cpp";
      rev = "e5cea0ec884c5c3d2d1e41a741a66ce13da4d945";
      hash = "sha256-2uVlKVnMKnugJv4Py3PtFI8rmx2RMwUIYfQ8zDNugGw=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-cpp";
  };
  css = buildGrammar {
    language = "css";
    version = "0.0.0+rev=6e327db";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-css";
      rev = "6e327db434fec0ee90f006697782e43ec855adf5";
      hash = "sha256-en379DlqzzvQNvKgE8CtiA00j7phUyipttqbnETGHKc=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-css";
  };
  csv = buildGrammar {
    language = "csv";
    version = "0.0.0+rev=7eb7297";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-csv";
      rev = "7eb7297823605392d2bbcc4c09b1cd18d6fa9529";
      hash = "sha256-5VL7uREH0lloAWo9rdJXsjDsWxgL6fngWJSmi4fM7UQ=";
    };
    location = "csv";
    meta.homepage = "https://github.com/amaanq/tree-sitter-csv";
  };
  cuda = buildGrammar {
    language = "cuda";
    version = "0.0.0+rev=014628a";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-cuda";
      rev = "014628ae8d2df391b88ddb9fa0260fd97f770829";
      hash = "sha256-zlG7/ERVZFLRBqu7q/wjcYG+iBlDY7s/SwKyqzIA0OM=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-cuda";
  };
  cue = buildGrammar {
    language = "cue";
    version = "0.0.0+rev=770737b";
    src = fetchFromGitHub {
      owner = "eonpatapon";
      repo = "tree-sitter-cue";
      rev = "770737bcff2c4aa3f624d439e32b07dbb07102d3";
      hash = "sha256-ujSBOwOnjsKuFhHtt4zvj90VcQsak8mEcWYJ0e5/mKc=";
    };
    meta.homepage = "https://github.com/eonpatapon/tree-sitter-cue";
  };
  cylc = buildGrammar {
    language = "cylc";
    version = "0.0.0+rev=8b895c2";
    src = fetchFromGitHub {
      owner = "elliotfontaine";
      repo = "tree-sitter-cylc";
      rev = "8b895c278f98d05e67997f5e3a43fb5531933023";
      hash = "sha256-+Afoxp+1hJZfRsekpz9WAEw/i/7uoXb0wl7/b6tlPro=";
    };
    meta.homepage = "https://github.com/elliotfontaine/tree-sitter-cylc";
  };
  d = buildGrammar {
    language = "d";
    version = "0.0.0+rev=45e5f1e";
    src = fetchFromGitHub {
      owner = "gdamore";
      repo = "tree-sitter-d";
      rev = "45e5f1e9d6de2c68591bc8e5ec662cf18e950b4a";
      hash = "sha256-q96RgJWrMop2HBBsQloVTspe3EaMtUL3wmVuT9xnE/g=";
    };
    meta.homepage = "https://github.com/gdamore/tree-sitter-d";
  };
  dart = buildGrammar {
    language = "dart";
    version = "0.0.0+rev=80e23c0";
    src = fetchFromGitHub {
      owner = "UserNobody14";
      repo = "tree-sitter-dart";
      rev = "80e23c07b64494f7e21090bb3450223ef0b192f4";
      hash = "sha256-bMFBSVAHTGstvalL5vZGahA5gL95IZQmJfBOE+trnwM=";
    };
    meta.homepage = "https://github.com/UserNobody14/tree-sitter-dart";
  };
  desktop = buildGrammar {
    language = "desktop";
    version = "0.0.0+rev=6d66eea";
    src = fetchFromGitHub {
      owner = "ValdezFOmar";
      repo = "tree-sitter-desktop";
      rev = "6d66eea37afa1d6bc1e25ef457113743df42416d";
      hash = "sha256-vaWcgt4bwO1PCG0BJrp6oSY6DEWfMiuWtOPUwKvzmPg=";
    };
    meta.homepage = "https://github.com/ValdezFOmar/tree-sitter-desktop";
  };
  devicetree = buildGrammar {
    language = "devicetree";
    version = "0.0.0+rev=16f640f";
    src = fetchFromGitHub {
      owner = "joelspadin";
      repo = "tree-sitter-devicetree";
      rev = "16f640f3c59117c9e749d581634afdb00e004f4c";
      hash = "sha256-0J1Q25JEWVAlBHAgWRtHAwIIDNoSLYrEdMC45/jf7Uc=";
    };
    meta.homepage = "https://github.com/joelspadin/tree-sitter-devicetree";
  };
  dhall = buildGrammar {
    language = "dhall";
    version = "0.0.0+rev=4a6c08a";
    src = fetchFromGitHub {
      owner = "jbellerb";
      repo = "tree-sitter-dhall";
      rev = "4a6c08abfb54827db4e722d6cdca81b093898988";
      hash = "sha256-EP6eL04ltnnP2ypNsq6rLrG3F4bVg7QtnK3k0KP2/MY=";
    };
    meta.homepage = "https://github.com/jbellerb/tree-sitter-dhall";
  };
  diff = buildGrammar {
    language = "diff";
    version = "0.0.0+rev=e42b8de";
    src = fetchFromGitHub {
      owner = "the-mikedavis";
      repo = "tree-sitter-diff";
      rev = "e42b8def4f75633568f1aecfe01817bf15164928";
      hash = "sha256-1ibGin1e6+geAQNoV/KLCBOoXYcZo7S5+Q2XgsZPIfU=";
    };
    meta.homepage = "https://github.com/the-mikedavis/tree-sitter-diff";
  };
  disassembly = buildGrammar {
    language = "disassembly";
    version = "0.0.0+rev=0229c02";
    src = fetchFromGitHub {
      owner = "ColinKennedy";
      repo = "tree-sitter-disassembly";
      rev = "0229c0211dba909c5d45129ac784a3f4d49c243a";
      hash = "sha256-IM3HzOhJmbb334PZ8q+r2EMi5Bv/rLoy+llPN0aghr8=";
    };
    meta.homepage = "https://github.com/ColinKennedy/tree-sitter-disassembly";
  };
  djot = buildGrammar {
    language = "djot";
    version = "0.0.0+rev=eb31845";
    src = fetchFromGitHub {
      owner = "treeman";
      repo = "tree-sitter-djot";
      rev = "eb31845d59b9ee8c1b2098e78e9ca72004bd1579";
      hash = "sha256-7qwBdueO33SdOp5KY12WMIkDgjS5Psz2eF804wn/aLk=";
    };
    meta.homepage = "https://github.com/treeman/tree-sitter-djot";
  };
  dockerfile = buildGrammar {
    language = "dockerfile";
    version = "0.0.0+rev=971acdd";
    src = fetchFromGitHub {
      owner = "camdencheek";
      repo = "tree-sitter-dockerfile";
      rev = "971acdd908568b4531b0ba28a445bf0bb720aba5";
      hash = "sha256-WJJ/rjFea1sudGIyjKGupwm39TJ1zbyWlLgoRf1KCBI=";
    };
    meta.homepage = "https://github.com/camdencheek/tree-sitter-dockerfile";
  };
  dot = buildGrammar {
    language = "dot";
    version = "0.0.0+rev=9ab8555";
    src = fetchFromGitHub {
      owner = "rydesun";
      repo = "tree-sitter-dot";
      rev = "9ab85550c896d8b294d9b9ca1e30698736f08cea";
      hash = "sha256-w4DInIT7mkTvQ6Hmi8yaAww6ktyNgRz0tPfBLGnOawQ=";
    };
    meta.homepage = "https://github.com/rydesun/tree-sitter-dot";
  };
  doxygen = buildGrammar {
    language = "doxygen";
    version = "0.0.0+rev=ccd998f";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-doxygen";
      rev = "ccd998f378c3f9345ea4eeb223f56d7b84d16687";
      hash = "sha256-Yh6FaRvWmeqnSnBgOojWbs1wJaeEoNJlvSEqgzjGh7o=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-doxygen";
  };
  dtd = buildGrammar {
    language = "dtd";
    version = "0.0.0+rev=0d9a809";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-xml";
      rev = "0d9a8099c963ed53e183425c1b47fa2622c8eaf7";
      hash = "sha256-0kqCDLCxsvrqu5pKrDZDJt9lSlxU6fzM/CxrWb/oodw=";
    };
    location = "dtd";
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-xml";
  };
  earthfile = buildGrammar {
    language = "earthfile";
    version = "0.0.0+rev=ae378d9";
    src = fetchFromGitHub {
      owner = "glehmann";
      repo = "tree-sitter-earthfile";
      rev = "ae378d9d1306e9a967698516041f6f8803db5592";
      hash = "sha256-BKosyoT2zv9A1at9N1P018nNlMUB2OPg2vu3sjNiW4Q=";
    };
    meta.homepage = "https://github.com/glehmann/tree-sitter-earthfile";
  };
  ebnf = buildGrammar {
    language = "ebnf";
    version = "0.0.0+rev=8e635b0";
    src = fetchFromGitHub {
      owner = "RubixDev";
      repo = "ebnf";
      rev = "8e635b0b723c620774dfb8abf382a7f531894b40";
      hash = "sha256-Cch6WCYq9bsWGypzDGapxBLJ0ZB432uAl6YjEjBJ5yg=";
    };
    location = "crates/tree-sitter-ebnf";
    meta.homepage = "https://github.com/RubixDev/ebnf";
  };
  editorconfig = buildGrammar {
    language = "editorconfig";
    version = "0.0.0+rev=3f2b371";
    src = fetchFromGitHub {
      owner = "ValdezFOmar";
      repo = "tree-sitter-editorconfig";
      rev = "3f2b371537355f6e53cc3af37f79ba450efb5132";
      hash = "sha256-z5pTG7EbmEZV+5RtXI8jGxxb0ifb67EJXquWQ0IA1a8=";
    };
    meta.homepage = "https://github.com/ValdezFOmar/tree-sitter-editorconfig";
  };
  eds = buildGrammar {
    language = "eds";
    version = "0.0.0+rev=26d529e";
    src = fetchFromGitHub {
      owner = "uyha";
      repo = "tree-sitter-eds";
      rev = "26d529e6cfecde391a03c21d1474eb51e0285805";
      hash = "sha256-+3BO4JxUrSc8OWHVZvd1lxjrNYkhN35q2YhcrUrFgMk=";
    };
    meta.homepage = "https://github.com/uyha/tree-sitter-eds";
  };
  eex = buildGrammar {
    language = "eex";
    version = "0.0.0+rev=f742f2f";
    src = fetchFromGitHub {
      owner = "connorlay";
      repo = "tree-sitter-eex";
      rev = "f742f2fe327463335e8671a87c0b9b396905d1d1";
      hash = "sha256-UPq62MkfGFh9m/UskoB9uBDIYOcotITCJXDyrbg/wKY=";
    };
    meta.homepage = "https://github.com/connorlay/tree-sitter-eex";
  };
  elixir = buildGrammar {
    language = "elixir";
    version = "0.0.0+rev=450a819";
    src = fetchFromGitHub {
      owner = "elixir-lang";
      repo = "tree-sitter-elixir";
      rev = "450a8194f5a66561135962cfc8d7545a27b61c4c";
      hash = "sha256-4cL8E7if7j5NeuMH/5IEgudHu2kcerpdTj4pVoYM0Ao=";
    };
    meta.homepage = "https://github.com/elixir-lang/tree-sitter-elixir";
  };
  elm = buildGrammar {
    language = "elm";
    version = "0.0.0+rev=e34bdc5";
    src = fetchFromGitHub {
      owner = "elm-tooling";
      repo = "tree-sitter-elm";
      rev = "e34bdc5c512918628b05b48e633f711123204e45";
      hash = "sha256-LKXYQk7W/2KUvHGM7DV041IdR7IbpnaaTf3fxIzAlxo=";
    };
    meta.homepage = "https://github.com/elm-tooling/tree-sitter-elm";
  };
  elsa = buildGrammar {
    language = "elsa";
    version = "0.0.0+rev=0a66b2b";
    src = fetchFromGitHub {
      owner = "glapa-grossklag";
      repo = "tree-sitter-elsa";
      rev = "0a66b2b3f3c1915e67ad2ef9f7dbd2a84820d9d7";
      hash = "sha256-zahi5hOXzad6R1+mqmYBFfn2X+SejQUIQzbabgCIJ8w=";
    };
    meta.homepage = "https://github.com/glapa-grossklag/tree-sitter-elsa";
  };
  elvish = buildGrammar {
    language = "elvish";
    version = "0.0.0+rev=5e7210d";
    src = fetchFromGitHub {
      owner = "elves";
      repo = "tree-sitter-elvish";
      rev = "5e7210d945425b77f82cbaebc5af4dd3e1ad40f5";
      hash = "sha256-POuQA2Ihi+qDYQ5Pv7hBAzHpPu/FcnuYscW4ItDOCZg=";
    };
    meta.homepage = "https://github.com/elves/tree-sitter-elvish";
  };
  embedded_template = buildGrammar {
    language = "embedded_template";
    version = "0.0.0+rev=8495d10";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-embedded-template";
      rev = "8495d106154741e6d35d37064f864758ece75de6";
      hash = "sha256-DCEno1QzPcM9853hldrm4IAqKsTNALe//laDn+Hcr8Q=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-embedded-template";
  };
  enforce = buildGrammar {
    language = "enforce";
    version = "0.0.0+rev=aedd0bb";
    src = fetchFromGitHub {
      owner = "simonvic";
      repo = "tree-sitter-enforce";
      rev = "aedd0bbab9dcc9caec9cc4e32bd303e86509522b";
      hash = "sha256-0oqp3tlbTrKtI5clrkOKP04M1zYb3yyJ6RHvQrHyWDM=";
    };
    meta.homepage = "https://github.com/simonvic/tree-sitter-enforce";
  };
  erlang = buildGrammar {
    language = "erlang";
    version = "0.0.0+rev=416ca60";
    src = fetchFromGitHub {
      owner = "WhatsApp";
      repo = "tree-sitter-erlang";
      rev = "416ca60d7d2a824c0d346163541153e230710780";
      hash = "sha256-sJpKSoxYUYM5b0Ku9OHmpLLLbKqVueryN+XmRz+i6zg=";
    };
    meta.homepage = "https://github.com/WhatsApp/tree-sitter-erlang";
  };
  facility = buildGrammar {
    language = "facility";
    version = "0.0.0+rev=e4bfd3e";
    src = fetchFromGitHub {
      owner = "FacilityApi";
      repo = "tree-sitter-facility";
      rev = "e4bfd3e960de9f4b4648acb1c92e9b95b47d8cfb";
      hash = "sha256-EwTkus2m0lwDwx5XO3Ee4ngretLPShx84JZytaHkZ4I=";
    };
    meta.homepage = "https://github.com/FacilityApi/tree-sitter-facility";
  };
  faust = buildGrammar {
    language = "faust";
    version = "0.0.0+rev=f3b9274";
    src = fetchFromGitHub {
      owner = "khiner";
      repo = "tree-sitter-faust";
      rev = "f3b9274514b5f9bf6b0dd4a01c30f9cc15c58bc4";
      hash = "sha256-JwR8LCEptgQmEG/ruK5ukIGCNtvKJw5bobZ0WXF1ulY=";
    };
    meta.homepage = "https://github.com/khiner/tree-sitter-faust";
  };
  fennel = buildGrammar {
    language = "fennel";
    version = "0.0.0+rev=cfbfa47";
    src = fetchFromGitHub {
      owner = "alexmozaidze";
      repo = "tree-sitter-fennel";
      rev = "cfbfa478dc2dbef267ee94ae4323d9c886f45e94";
      hash = "sha256-0LusII7BPGFQTyEkxZi6h9HUDF0eHvGwA4fiQE2h3YQ=";
    };
    meta.homepage = "https://github.com/alexmozaidze/tree-sitter-fennel";
  };
  fidl = buildGrammar {
    language = "fidl";
    version = "0.0.0+rev=0a8910f";
    src = fetchFromGitHub {
      owner = "google";
      repo = "tree-sitter-fidl";
      rev = "0a8910f293268e27ff554357c229ba172b0eaed2";
      hash = "sha256-QFAkxQo2w/+OR7nZn9ldBk2yHOd23kzciAcQvIZ5hrY=";
    };
    meta.homepage = "https://github.com/google/tree-sitter-fidl";
  };
  firrtl = buildGrammar {
    language = "firrtl";
    version = "0.0.0+rev=8503d3a";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-firrtl";
      rev = "8503d3a0fe0f9e427863cb0055699ff2d29ae5f5";
      hash = "sha256-I2EMcm6bTMRODmxOOOiv+U0fhm6yoNhjCyuINfTUtlY=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-firrtl";
  };
  fish = buildGrammar {
    language = "fish";
    version = "0.0.0+rev=70640c0";
    src = fetchFromGitHub {
      owner = "ram02z";
      repo = "tree-sitter-fish";
      rev = "70640c0696abde32622afc43291a385681afbd32";
      hash = "sha256-d+z43w7nl0ZzVjypwxk+xPivb/W6xJ21Uc63Ux9S74k=";
    };
    meta.homepage = "https://github.com/ram02z/tree-sitter-fish";
  };
  foam = buildGrammar {
    language = "foam";
    version = "0.0.0+rev=f08bb76";
    src = fetchFromGitHub {
      owner = "FoamScience";
      repo = "tree-sitter-foam";
      rev = "f08bb76892b93e5b23c45ac3bd6b1eea5df323cc";
      hash = "sha256-boH5WJNwJmZKN4JCcFvVdAU06ZRj6Zdsq3NibSWjAr8=";
    };
    meta.homepage = "https://github.com/FoamScience/tree-sitter-foam";
  };
  forth = buildGrammar {
    language = "forth";
    version = "0.0.0+rev=9018923";
    src = fetchFromGitHub {
      owner = "AlexanderBrevig";
      repo = "tree-sitter-forth";
      rev = "90189238385cf636b9ee99ce548b9e5b5e569d48";
      hash = "sha256-vySBDu9cMnubu4+7/sBttNxg1S4/MxWUKpjwEa14Rws=";
    };
    meta.homepage = "https://github.com/AlexanderBrevig/tree-sitter-forth";
  };
  fortran = buildGrammar {
    language = "fortran";
    version = "0.0.0+rev=d738334";
    src = fetchFromGitHub {
      owner = "stadelmanma";
      repo = "tree-sitter-fortran";
      rev = "d738334e4a21866a1ab81fb3f27f9b0b2ad2e515";
      hash = "sha256-NiGBc8o+WOegHm/2yl5EXAdjpKE+l9Lo5bUvOkCWXqo=";
    };
    meta.homepage = "https://github.com/stadelmanma/tree-sitter-fortran";
  };
  fsh = buildGrammar {
    language = "fsh";
    version = "0.0.0+rev=fad2e17";
    src = fetchFromGitHub {
      owner = "mgramigna";
      repo = "tree-sitter-fsh";
      rev = "fad2e175099a45efbc98f000cc196d3674cc45e0";
      hash = "sha256-91r1FCQTocDkhS5Tx0vnFliitMStVzNTpf6BwPyaqVM=";
    };
    meta.homepage = "https://github.com/mgramigna/tree-sitter-fsh";
  };
  fsharp = buildGrammar {
    language = "fsharp";
    version = "0.0.0+rev=02929f0";
    src = fetchFromGitHub {
      owner = "ionide";
      repo = "tree-sitter-fsharp";
      rev = "02929f084726db969e5b916d144436f248146824";
      hash = "sha256-64MF/777+pY+wcoyg4WMaKUlDRiz8VqwLO55TNotVbE=";
    };
    location = "fsharp";
    meta.homepage = "https://github.com/ionide/tree-sitter-fsharp";
  };
  func = buildGrammar {
    language = "func";
    version = "0.0.0+rev=f780ca5";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-func";
      rev = "f780ca55e65e7d7360d0229331763e16c452fc98";
      hash = "sha256-jM0VJZlfhenAZbhabpgsoRIGny3WSDoimZtwogcvaSI=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-func";
  };
  fusion = buildGrammar {
    language = "fusion";
    version = "0.0.0+rev=19db2f4";
    src = fetchFromGitLab {
      owner = "jirgn";
      repo = "tree-sitter-fusion";
      rev = "19db2f47ba4c3a0f6238d4ae0e2abfca16e61dd6";
      hash = "sha256-195q39pZYipT0G08kQlwnDE28ODjAz2/Sq1tzpEGFmU=";
    };
    meta.homepage = "https://gitlab.com/jirgn/tree-sitter-fusion.git";
  };
  gap = buildGrammar {
    language = "gap";
    version = "0.0.0+rev=7db7959";
    src = fetchFromGitHub {
      owner = "gap-system";
      repo = "tree-sitter-gap";
      rev = "7db79590d2f8b0e0246008ecfd569b4bfca587a9";
      hash = "sha256-M/nk1XM9vZe0XoFr6EttWCY4fjzw2r5I/XImJNjUwGk=";
    };
    meta.homepage = "https://github.com/gap-system/tree-sitter-gap";
  };
  gaptst = buildGrammar {
    language = "gaptst";
    version = "0.0.0+rev=69086d7";
    src = fetchFromGitHub {
      owner = "gap-system";
      repo = "tree-sitter-gaptst";
      rev = "69086d7627c03e1f4baf766bcef14c60d9e92331";
      hash = "sha256-U0P9QoOZST1h6XI83CI0/6/CDTvqkv1Yiq62h6YdHpI=";
    };
    meta.homepage = "https://github.com/gap-system/tree-sitter-gaptst";
  };
  gdscript = buildGrammar {
    language = "gdscript";
    version = "0.0.0+rev=48b4933";
    src = fetchFromGitHub {
      owner = "PrestonKnopp";
      repo = "tree-sitter-gdscript";
      rev = "48b49330888a4669b48619b211cc8da573827725";
      hash = "sha256-mGmrCK3nGSzi/66mOxvpRyTA9b74aTMSoIISqzj+l90=";
    };
    meta.homepage = "https://github.com/PrestonKnopp/tree-sitter-gdscript";
  };
  gdshader = buildGrammar {
    language = "gdshader";
    version = "0.0.0+rev=ffd9f95";
    src = fetchFromGitHub {
      owner = "GodOfAvacyn";
      repo = "tree-sitter-gdshader";
      rev = "ffd9f958df13cae04593781d7d2562295a872455";
      hash = "sha256-JWlDs0w10TqsPYgZvvaJwAueOciCYaws1Nr8rb0UKy4=";
    };
    meta.homepage = "https://github.com/GodOfAvacyn/tree-sitter-gdshader";
  };
  git_config = buildGrammar {
    language = "git_config";
    version = "0.0.0+rev=9c2a1b7";
    src = fetchFromGitHub {
      owner = "the-mikedavis";
      repo = "tree-sitter-git-config";
      rev = "9c2a1b7894e6d9eedfe99805b829b4ecd871375e";
      hash = "sha256-O0w0BhhPPwhnKfniAFSPMWfBsZUTrijifAsmFiAncWg=";
    };
    meta.homepage = "https://github.com/the-mikedavis/tree-sitter-git-config";
  };
  git_rebase = buildGrammar {
    language = "git_rebase";
    version = "0.0.0+rev=bff4b66";
    src = fetchFromGitHub {
      owner = "the-mikedavis";
      repo = "tree-sitter-git-rebase";
      rev = "bff4b66b44b020d918d67e2828eada1974a966aa";
      hash = "sha256-k4C7dJUkvQxIxcaoVmG2cBs/CeYzVqrip2+2mRvHtZc=";
    };
    meta.homepage = "https://github.com/the-mikedavis/tree-sitter-git-rebase";
  };
  gitattributes = buildGrammar {
    language = "gitattributes";
    version = "0.0.0+rev=5425944";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-gitattributes";
      rev = "5425944fd61bf2b3bad2c17c2dc9f53172b0f01d";
      hash = "sha256-X6M9/41xISnkDnXNgQAWexs68h8A0dwOz+aQa86H0pc=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-gitattributes";
  };
  gitcommit = buildGrammar {
    language = "gitcommit";
    version = "0.0.0+rev=a716678";
    src = fetchFromGitHub {
      owner = "gbprod";
      repo = "tree-sitter-gitcommit";
      rev = "a716678c0f00645fed1e6f1d0eb221481dbd6f6d";
      hash = "sha256-KYfcs99p03b0RiPYnZeKJf677fmVf658FLZcFk2v2Ws=";
    };
    meta.homepage = "https://github.com/gbprod/tree-sitter-gitcommit";
  };
  gitignore = buildGrammar {
    language = "gitignore";
    version = "0.0.0+rev=f4685bf";
    src = fetchFromGitHub {
      owner = "shunsambongi";
      repo = "tree-sitter-gitignore";
      rev = "f4685bf11ac466dd278449bcfe5fd014e94aa504";
      hash = "sha256-MjoY1tlVZgN6JqoTjhhg0zSdHzc8yplMr8824sfIKp8=";
    };
    meta.homepage = "https://github.com/shunsambongi/tree-sitter-gitignore";
  };
  gleam = buildGrammar {
    language = "gleam";
    version = "0.0.0+rev=99ec410";
    src = fetchFromGitHub {
      owner = "gleam-lang";
      repo = "tree-sitter-gleam";
      rev = "99ec4101504452c488b7c835fb65cfef75b090b7";
      hash = "sha256-FEecjw1nYYO8U+qLjOK28qTMCO1pJkwdUDzlDvmle4c=";
    };
    meta.homepage = "https://github.com/gleam-lang/tree-sitter-gleam";
  };
  glimmer = buildGrammar {
    language = "glimmer";
    version = "0.0.0+rev=da605af";
    src = fetchFromGitHub {
      owner = "ember-tooling";
      repo = "tree-sitter-glimmer";
      rev = "da605af8c5999b43e6839b575eae5e6cafabb06f";
      hash = "sha256-2ofCBhp/Trj5ivZpMGFm6dvAGic+w8Tl0osRk+IRLL4=";
    };
    meta.homepage = "https://github.com/ember-tooling/tree-sitter-glimmer";
  };
  glimmer_javascript = buildGrammar {
    language = "glimmer_javascript";
    version = "0.0.0+rev=5cc865a";
    src = fetchFromGitHub {
      owner = "NullVoxPopuli";
      repo = "tree-sitter-glimmer-javascript";
      rev = "5cc865a2a0a77cbfaf5062c8fcf2a9919bd54f87";
      hash = "sha256-4MSBaGdX5lvhvz2LyQb+NuQY9Vc5CFL0C6S3sO3Tz2U=";
    };
    meta.homepage = "https://github.com/NullVoxPopuli/tree-sitter-glimmer-javascript";
  };
  glimmer_typescript = buildGrammar {
    language = "glimmer_typescript";
    version = "0.0.0+rev=12d9894";
    src = fetchFromGitHub {
      owner = "NullVoxPopuli";
      repo = "tree-sitter-glimmer-typescript";
      rev = "12d98944c1d5077b957cbdb90d663a7c4d50118c";
      hash = "sha256-3cJI6vcbU62kUIhphprNeAl9RyY9TThrzVeArdLfxnI=";
    };
    meta.homepage = "https://github.com/NullVoxPopuli/tree-sitter-glimmer-typescript";
  };
  glsl = buildGrammar {
    language = "glsl";
    version = "0.0.0+rev=24a6c8e";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-glsl";
      rev = "24a6c8ef698e4480fecf8340d771fbcb5de8fbb4";
      hash = "sha256-TjF79WH3bX4nueYr8CbPptkNb2lNkHQNB0VZoMB35Nk=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-glsl";
  };
  gn = buildGrammar {
    language = "gn";
    version = "0.0.0+rev=bc06955";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-gn";
      rev = "bc06955bc1e3c9ff8e9b2b2a55b38b94da923c05";
      hash = "sha256-Sn6He4YRrKJe4QvGiaauquYBVQol0lWeIuOwkdUEzkQ=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-gn";
  };
  gnuplot = buildGrammar {
    language = "gnuplot";
    version = "0.0.0+rev=8923c1e";
    src = fetchFromGitHub {
      owner = "dpezto";
      repo = "tree-sitter-gnuplot";
      rev = "8923c1e38b9634a688a6c0dce7c18c8ffb823e79";
      hash = "sha256-fR3lIscfrBqpBH1jZ4RB1Qa8r+hxy6I0OzzoQqAe2aw=";
    };
    meta.homepage = "https://github.com/dpezto/tree-sitter-gnuplot";
  };
  go = buildGrammar {
    language = "go";
    version = "0.0.0+rev=5e73f47";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-go";
      rev = "5e73f476efafe5c768eda19bbe877f188ded6144";
      hash = "sha256-PgFdtkPMgkNK7Gv6dBf89lNjJrZyt9Wp5h5OIwd83aw=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-go";
  };
  goctl = buildGrammar {
    language = "goctl";
    version = "0.0.0+rev=49c4353";
    src = fetchFromGitHub {
      owner = "chaozwn";
      repo = "tree-sitter-goctl";
      rev = "49c43532689fe1f53e8b9e009d0521cab02c432b";
      hash = "sha256-HYPj95Kg+C5Ax++Z83yUnhrf2iIVTuwOBhVVLlYQaGs=";
    };
    meta.homepage = "https://github.com/chaozwn/tree-sitter-goctl";
  };
  godot_resource = buildGrammar {
    language = "godot_resource";
    version = "0.0.0+rev=91c55fd";
    src = fetchFromGitHub {
      owner = "PrestonKnopp";
      repo = "tree-sitter-godot-resource";
      rev = "91c55fdf325a832659e59cdf4a02bfe8a423f14c";
      hash = "sha256-Hmpc8JsbgCo/iuIxn9E3XL1kJPi8wADlSvH3inlacFc=";
    };
    meta.homepage = "https://github.com/PrestonKnopp/tree-sitter-godot-resource";
  };
  gomod = buildGrammar {
    language = "gomod";
    version = "0.0.0+rev=6efb596";
    src = fetchFromGitHub {
      owner = "camdencheek";
      repo = "tree-sitter-go-mod";
      rev = "6efb59652d30e0e9cd5f3b3a669afd6f1a926d3c";
      hash = "sha256-KD6Fio9qie3wbGAvQaYsMdYOK1QjnRrGExt1oL/6mis=";
    };
    meta.homepage = "https://github.com/camdencheek/tree-sitter-go-mod";
  };
  gosum = buildGrammar {
    language = "gosum";
    version = "0.0.0+rev=e2ac513";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-go-sum";
      rev = "e2ac513b2240c7ff1069ae33b2df29ce90777c11";
      hash = "sha256-2foA2sd5PQpmeX8OhXrW/dxoJaEyxDXzPWh+UD0dgzQ=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-go-sum";
  };
  gotmpl = buildGrammar {
    language = "gotmpl";
    version = "0.0.0+rev=5f19a36";
    src = fetchFromGitHub {
      owner = "ngalaiko";
      repo = "tree-sitter-go-template";
      rev = "5f19a36bb1eebb30454e277b222b278ceafed0dd";
      hash = "sha256-apZ5yhWzLxaJFxMcuugNTuCxdDUxhKTZecZFsvjyqdo=";
    };
    meta.homepage = "https://github.com/ngalaiko/tree-sitter-go-template";
  };
  gowork = buildGrammar {
    language = "gowork";
    version = "0.0.0+rev=949a8a4";
    src = fetchFromGitHub {
      owner = "omertuc";
      repo = "tree-sitter-go-work";
      rev = "949a8a470559543857a62102c84700d291fc984c";
      hash = "sha256-Tode7W05xaOKKD5QOp3rayFgLEOiMJUeGpVsIrizxto=";
    };
    meta.homepage = "https://github.com/omertuc/tree-sitter-go-work";
  };
  gpg = buildGrammar {
    language = "gpg";
    version = "0.0.0+rev=63e80cf";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-gpg-config";
      rev = "63e80cfe1302da9f9c7ee8d9df295f47d7d181bf";
      hash = "sha256-W8BglyjX/OytZCACpVi9V/k7A0Q4JaVQV+9NcyqtFsc=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-gpg-config";
  };
  graphql = buildGrammar {
    language = "graphql";
    version = "0.0.0+rev=5e66e96";
    src = fetchFromGitHub {
      owner = "bkegley";
      repo = "tree-sitter-graphql";
      rev = "5e66e961eee421786bdda8495ed1db045e06b5fe";
      hash = "sha256-NvE9Rpdp4sALqKSRWJpqxwl6obmqnIIdvrL1nK5peXc=";
    };
    meta.homepage = "https://github.com/bkegley/tree-sitter-graphql";
  };
  gren = buildGrammar {
    language = "gren";
    version = "0.0.0+rev=06389ec";
    src = fetchFromGitHub {
      owner = "MaeBrooks";
      repo = "tree-sitter-gren";
      rev = "06389ece5bc7344ed3931dc516bb609d8864dd2a";
      hash = "sha256-wh32+efWujW37jpNZbaVJGRKeMIa5NvRAezhG3WhUm4=";
    };
    meta.homepage = "https://github.com/MaeBrooks/tree-sitter-gren";
  };
  groovy = buildGrammar {
    language = "groovy";
    version = "0.0.0+rev=8691159";
    src = fetchFromGitHub {
      owner = "murtaza64";
      repo = "tree-sitter-groovy";
      rev = "86911590a8e46d71301c66468e5620d9faa5b6af";
      hash = "sha256-652wluH2C3pYmhthaj4eWDVLtEvvVIuu70bJNnt5em0=";
    };
    meta.homepage = "https://github.com/murtaza64/tree-sitter-groovy";
  };
  gstlaunch = buildGrammar {
    language = "gstlaunch";
    version = "0.0.0+rev=549aef2";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-gstlaunch";
      rev = "549aef253fd38a53995cda1bf55c501174372bf7";
      hash = "sha256-zNUx/9dxEqyqTXCxEiNnYPzplnR7l9b2L4frYpPOA9M=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-gstlaunch";
  };
  hack = buildGrammar {
    language = "hack";
    version = "0.0.0+rev=bc5b3a1";
    src = fetchFromGitHub {
      owner = "slackhq";
      repo = "tree-sitter-hack";
      rev = "bc5b3a10d6d27e8220a113a9a7fe9bec0a1574b0";
      hash = "sha256-dVDJRRn5pT7FPQN+RIUi/mFG6uS8rAzWJy2dBfuiNSM=";
    };
    meta.homepage = "https://github.com/slackhq/tree-sitter-hack";
  };
  hare = buildGrammar {
    language = "hare";
    version = "0.0.0+rev=4af5d82";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-hare";
      rev = "4af5d82cf9ec39f67cb1db5b7a9269d337406592";
      hash = "sha256-QEnE5IQJ60PXb6QjgEE5L4p7Fjy0p+N+dyDTMh3YsRg=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-hare";
  };
  haskell = buildGrammar {
    language = "haskell";
    version = "0.0.0+rev=0975ef7";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-haskell";
      rev = "0975ef72fc3c47b530309ca93937d7d143523628";
      hash = "sha256-0wmdbXHZbHkv4pTrB1fCbExx9E83l+zaocGa+SvQsZQ=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-haskell";
  };
  haskell_persistent = buildGrammar {
    language = "haskell_persistent";
    version = "0.0.0+rev=577259b";
    src = fetchFromGitHub {
      owner = "MercuryTechnologies";
      repo = "tree-sitter-haskell-persistent";
      rev = "577259b4068b2c281c9ebf94c109bd50a74d5857";
      hash = "sha256-ASdkBQ57GfpLF8NXgDzJMB/Marz9p1q03TZkwMgF/eQ=";
    };
    meta.homepage = "https://github.com/MercuryTechnologies/tree-sitter-haskell-persistent";
  };
  hcl = buildGrammar {
    language = "hcl";
    version = "0.0.0+rev=de10d49";
    src = fetchFromGitHub {
      owner = "MichaHoffmann";
      repo = "tree-sitter-hcl";
      rev = "de10d494dbd6b71cdf07a678fecbf404dbfe4398";
      hash = "sha256-oRNNxE5AnI0TyJl92pk0E9xGj5xom/+0kpPMUE/O/TY=";
    };
    meta.homepage = "https://github.com/MichaHoffmann/tree-sitter-hcl";
  };
  heex = buildGrammar {
    language = "heex";
    version = "0.0.0+rev=008626a";
    src = fetchFromGitHub {
      owner = "connorlay";
      repo = "tree-sitter-heex";
      rev = "008626a3fad379d17c81d5ed576edd9bd7a4fbf7";
      hash = "sha256-qBWiTT4K72zTfQE7BlMHbtpMOVVsv/cpzfc6JmTz7uk=";
    };
    meta.homepage = "https://github.com/connorlay/tree-sitter-heex";
  };
  helm = buildGrammar {
    language = "helm";
    version = "0.0.0+rev=5f19a36";
    src = fetchFromGitHub {
      owner = "ngalaiko";
      repo = "tree-sitter-go-template";
      rev = "5f19a36bb1eebb30454e277b222b278ceafed0dd";
      hash = "sha256-apZ5yhWzLxaJFxMcuugNTuCxdDUxhKTZecZFsvjyqdo=";
    };
    location = "dialects/helm";
    meta.homepage = "https://github.com/ngalaiko/tree-sitter-go-template";
  };
  hjson = buildGrammar {
    language = "hjson";
    version = "0.0.0+rev=02fa3b7";
    src = fetchFromGitHub {
      owner = "winston0410";
      repo = "tree-sitter-hjson";
      rev = "02fa3b79b3ff9a296066da6277adfc3f26cbc9e0";
      hash = "sha256-NsTf3DR3gHVMYZDmTNvThB5bJcDwTcJ1+3eJhvsiDn8=";
    };
    meta.homepage = "https://github.com/winston0410/tree-sitter-hjson";
  };
  hlsl = buildGrammar {
    language = "hlsl";
    version = "0.0.0+rev=bab9111";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-hlsl";
      rev = "bab9111922d53d43668fabb61869bec51bbcb915";
      hash = "sha256-BWjgXtMN6y/0ahD44Cm8a+MxxVMpCNhkf33V/vsCBTU=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-hlsl";
  };
  hlsplaylist = buildGrammar {
    language = "hlsplaylist";
    version = "0.0.0+rev=3bfda92";
    src = fetchFromGitHub {
      owner = "Freed-Wu";
      repo = "tree-sitter-hlsplaylist";
      rev = "3bfda9271e3adb08d35f47a2102fe957009e1c55";
      hash = "sha256-BvLT+BbnJgM14a896p39dywYy/4S45xOBtBukYTbW6E=";
    };
    meta.homepage = "https://github.com/Freed-Wu/tree-sitter-hlsplaylist";
  };
  hocon = buildGrammar {
    language = "hocon";
    version = "0.0.0+rev=c390f10";
    src = fetchFromGitHub {
      owner = "antosha417";
      repo = "tree-sitter-hocon";
      rev = "c390f10519ae69fdb03b3e5764f5592fb6924bcc";
      hash = "sha256-9Zo3YYoo9mJ4Buyj7ofSrlZURrwstBo0vgzeTq1jMGw=";
    };
    meta.homepage = "https://github.com/antosha417/tree-sitter-hocon";
  };
  hoon = buildGrammar {
    language = "hoon";
    version = "0.0.0+rev=1545137";
    src = fetchFromGitHub {
      owner = "urbit-pilled";
      repo = "tree-sitter-hoon";
      rev = "1545137aadcc63660c47db9ad98d02fa602655d0";
      hash = "sha256-RkSPoscrinmuSTWHzXkRNaiqECDXpKAbQ4z7a6Tpvek=";
    };
    meta.homepage = "https://github.com/urbit-pilled/tree-sitter-hoon";
  };
  html = buildGrammar {
    language = "html";
    version = "0.0.0+rev=cbb91a0";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-html";
      rev = "cbb91a0ff3621245e890d1c50cc811bffb77a26b";
      hash = "sha256-lNMiSDAQ49QpeyD1RzkIIUeRWdp2Wrv6+XQZdZ40c1g=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-html";
  };
  htmldjango = buildGrammar {
    language = "htmldjango";
    version = "0.0.0+rev=ea71012";
    src = fetchFromGitHub {
      owner = "interdependence";
      repo = "tree-sitter-htmldjango";
      rev = "ea71012d3fe14dd0b69f36be4f96bdfe9155ebae";
      hash = "sha256-z4PqUbUXOtqOyPYl2h+bWA0maZJqZd5aZB75og+Ye6A=";
    };
    meta.homepage = "https://github.com/interdependence/tree-sitter-htmldjango";
  };
  http = buildGrammar {
    language = "http";
    version = "0.0.0+rev=db8b439";
    src = fetchFromGitHub {
      owner = "rest-nvim";
      repo = "tree-sitter-http";
      rev = "db8b4398de90b6d0b6c780aba96aaa2cd8e9202c";
      hash = "sha256-T/O4oxPEIg3nLi3CxCwGW+iXC18fWW2xgsY5nrptk/M=";
    };
    meta.homepage = "https://github.com/rest-nvim/tree-sitter-http";
  };
  hurl = buildGrammar {
    language = "hurl";
    version = "0.0.0+rev=ff07a42";
    src = fetchFromGitHub {
      owner = "pfeiferj";
      repo = "tree-sitter-hurl";
      rev = "ff07a42d9ec95443b5c1b57ed793414bf7b79be5";
      hash = "sha256-9uRRlJWT0knZ3vvzGEq9CjyffQnYF53rnoBnsQ68zyE=";
    };
    meta.homepage = "https://github.com/pfeiferj/tree-sitter-hurl";
  };
  hyprlang = buildGrammar {
    language = "hyprlang";
    version = "0.0.0+rev=d719158";
    src = fetchFromGitHub {
      owner = "luckasRanarison";
      repo = "tree-sitter-hyprlang";
      rev = "d719158abe537b1916daaea6fa03287089f0b601";
      hash = "sha256-5iflQ4FDEvVRuaytPl08Q9CYXm2dfZ49qJyvcsOrzuI=";
    };
    meta.homepage = "https://github.com/luckasRanarison/tree-sitter-hyprlang";
  };
  idl = buildGrammar {
    language = "idl";
    version = "0.0.0+rev=b14e797";
    src = fetchFromGitHub {
      owner = "cathaysia";
      repo = "tree-sitter-idl";
      rev = "b14e7971cfbd64fa0ebcdeaa4dfbb3cb0bfabd7c";
      hash = "sha256-gVg1v2pL/c8ZFMBQoFeyIaqZ9QYDncHJv/4bJdTX/nw=";
    };
    meta.homepage = "https://github.com/cathaysia/tree-sitter-idl";
  };
  idris = buildGrammar {
    language = "idris";
    version = "0.0.0+rev=c56a25c";
    src = fetchFromGitHub {
      owner = "kayhide";
      repo = "tree-sitter-idris";
      rev = "c56a25cf57c68ff929356db25505c1cc4c7820f6";
      hash = "sha256-aOAxb0KjhSwlNX/IDvGwEysYvImgUEIDeNDOWRl1qNk=";
    };
    meta.homepage = "https://github.com/kayhide/tree-sitter-idris";
  };
  ini = buildGrammar {
    language = "ini";
    version = "0.0.0+rev=32b3186";
    src = fetchFromGitHub {
      owner = "justinmk";
      repo = "tree-sitter-ini";
      rev = "32b31863f222bf22eb43b07d4e9be8017e36fb31";
      hash = "sha256-kWCaOIC81GP5EHCqzPZP9EUgYy39CZ6/8TVS6soB6Wo=";
    };
    meta.homepage = "https://github.com/justinmk/tree-sitter-ini";
  };
  inko = buildGrammar {
    language = "inko";
    version = "0.0.0+rev=f58a87a";
    src = fetchFromGitHub {
      owner = "inko-lang";
      repo = "tree-sitter-inko";
      rev = "f58a87ac4dc6a7955c64c9e4408fbd693e804686";
      hash = "sha256-hZdbF9lw7fR5K8UfUaESS7/c4v9u7vEcSylEEbc6//4=";
    };
    meta.homepage = "https://github.com/inko-lang/tree-sitter-inko";
  };
  ipkg = buildGrammar {
    language = "ipkg";
    version = "0.0.0+rev=8d3e978";
    src = fetchFromGitHub {
      owner = "srghma";
      repo = "tree-sitter-ipkg";
      rev = "8d3e9782f2d091d0cd39c13bfb3068db0c675960";
      hash = "sha256-DyxD+Ehoqh0ywgU+J6EgnOQTcwOUJEuuXSOVjZ8M89c=";
    };
    meta.homepage = "https://github.com/srghma/tree-sitter-ipkg";
  };
  ispc = buildGrammar {
    language = "ispc";
    version = "0.0.0+rev=9b2f9ae";
    src = fetchFromGitHub {
      owner = "fab4100";
      repo = "tree-sitter-ispc";
      rev = "9b2f9aec2106b94b4e099fe75e73ebd8ae707c04";
      hash = "sha256-vxe+g7o0gXgB4GjhjkxqLqcLL2+8wqMB3tm1xQFSitI=";
    };
    meta.homepage = "https://github.com/fab4100/tree-sitter-ispc";
  };
  janet_simple = buildGrammar {
    language = "janet_simple";
    version = "0.0.0+rev=b08b402";
    src = fetchFromGitHub {
      owner = "sogaiu";
      repo = "tree-sitter-janet-simple";
      rev = "b08b402207fba0037d5152ce7c521351147f4388";
      hash = "sha256-9mNMur8oPdCCh5/gn5GLR9HFVM/phOOX2+b5EpI4Ey8=";
    };
    meta.homepage = "https://github.com/sogaiu/tree-sitter-janet-simple";
  };
  java = buildGrammar {
    language = "java";
    version = "0.0.0+rev=a7db522";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-java";
      rev = "a7db5227ec40fcfe94489559d8c9bc7c8181e25a";
      hash = "sha256-fNq5MMMr83wqn7lNgj0pfSZDF4XO98YbzfNsFjr3Kpw=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-java";
  };
  javadoc = buildGrammar {
    language = "javadoc";
    version = "0.0.0+rev=330cc9c";
    src = fetchFromGitHub {
      owner = "rmuir";
      repo = "tree-sitter-javadoc";
      rev = "330cc9cb4f33545f7bfce6c3b6aa77fe6db1b537";
      hash = "sha256-CohZaeMihAZ4PK3nZbp0aGybUZQOGrjFZ/T+z2qD6DU=";
    };
    meta.homepage = "https://github.com/rmuir/tree-sitter-javadoc";
  };
  javascript = buildGrammar {
    language = "javascript";
    version = "0.0.0+rev=6fbef40";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-javascript";
      rev = "6fbef40512dcd9f0a61ce03a4c9ae7597b36ab5c";
      hash = "sha256-X9DDCBF+gQYL0syfqgKVFvzoy2tnBl+veaYi7bUuRms=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-javascript";
  };
  jinja = buildGrammar {
    language = "jinja";
    version = "0.0.0+rev=9af6ce9";
    src = fetchFromGitHub {
      owner = "cathaysia";
      repo = "tree-sitter-jinja";
      rev = "9af6ce9380fabd3d5b19d0254b8c8936e879c471";
      hash = "sha256-9powNKoE5JpB+5vVtZLE5falMiS6I/ZXp4NrqabiWLs=";
    };
    location = "tree-sitter-jinja";
    meta.homepage = "https://github.com/cathaysia/tree-sitter-jinja";
  };
  jinja_inline = buildGrammar {
    language = "jinja_inline";
    version = "0.0.0+rev=9af6ce9";
    src = fetchFromGitHub {
      owner = "cathaysia";
      repo = "tree-sitter-jinja";
      rev = "9af6ce9380fabd3d5b19d0254b8c8936e879c471";
      hash = "sha256-9powNKoE5JpB+5vVtZLE5falMiS6I/ZXp4NrqabiWLs=";
    };
    location = "tree-sitter-jinja_inline";
    meta.homepage = "https://github.com/cathaysia/tree-sitter-jinja";
  };
  jq = buildGrammar {
    language = "jq";
    version = "0.0.0+rev=13990f5";
    src = fetchFromGitHub {
      owner = "flurie";
      repo = "tree-sitter-jq";
      rev = "13990f530e8e6709b7978503da9bc8701d366791";
      hash = "sha256-pek2Vg1osMYAdx6DfVdZhuIDb26op3i2cfvMrf5v3xY=";
    };
    meta.homepage = "https://github.com/flurie/tree-sitter-jq";
  };
  jsdoc = buildGrammar {
    language = "jsdoc";
    version = "0.0.0+rev=a417db5";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-jsdoc";
      rev = "a417db5dbdd869fccb6a8b75ec04459e1d4ccd2c";
      hash = "sha256-MMLgza5H9NWYn9jtOumwg3cz3hqb8GQGFc/yRSvUIVI=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-jsdoc";
  };
  json = buildGrammar {
    language = "json";
    version = "0.0.0+rev=46aa487";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-json";
      rev = "46aa487b3ade14b7b05ef92507fdaa3915a662a3";
      hash = "sha256-s8aAOrM4Mh4O60iSORMefN3nvFxThFk/On5DvK1BwWs=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-json";
  };
  json5 = buildGrammar {
    language = "json5";
    version = "0.0.0+rev=ab0ba82";
    src = fetchFromGitHub {
      owner = "Joakker";
      repo = "tree-sitter-json5";
      rev = "ab0ba8229d639ec4f3fa5f674c9133477f4b77bd";
      hash = "sha256-LaCCjvYnmofOVQ2Nqlzfh3KP3fNG0HBxkOng0gjYY1g=";
    };
    meta.homepage = "https://github.com/Joakker/tree-sitter-json5";
  };
  jsonc = buildGrammar {
    language = "jsonc";
    version = "0.0.0+rev=02b0165";
    src = fetchFromGitLab {
      owner = "WhyNotHugo";
      repo = "tree-sitter-jsonc";
      rev = "02b01653c8a1c198ae7287d566efa86a135b30d5";
      hash = "sha256-iWc2ePRiQnZ0FEdMAaAwa3iYt/SY0bEjQrZyqE9EhlU=";
    };
    meta.homepage = "https://gitlab.com/WhyNotHugo/tree-sitter-jsonc.git";
  };
  jsonnet = buildGrammar {
    language = "jsonnet";
    version = "0.0.0+rev=ddd075f";
    src = fetchFromGitHub {
      owner = "sourcegraph";
      repo = "tree-sitter-jsonnet";
      rev = "ddd075f1939aed8147b7aa67f042eda3fce22790";
      hash = "sha256-ODGRkirfUG8DqV6ZcGRjKeCyEtsU0r+ICK0kCG6Xza0=";
    };
    meta.homepage = "https://github.com/sourcegraph/tree-sitter-jsonnet";
  };
  julia = buildGrammar {
    language = "julia";
    version = "0.0.0+rev=12a3aed";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-julia";
      rev = "12a3aede757bc7fbdfb1909507c7a6fddd31df37";
      hash = "sha256-527US8LI8ZItb/O0em47+v4HnYnhJd48KBAWpasD62E=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-julia";
  };
  just = buildGrammar {
    language = "just";
    version = "0.0.0+rev=bb0c898";
    src = fetchFromGitHub {
      owner = "IndianBoy42";
      repo = "tree-sitter-just";
      rev = "bb0c898a80644de438e6efe5d88d30bf092935cd";
      hash = "sha256-FwEuH/2R745jsuFaVGNeUTv65xW+MPjbcakRNcAWfZU=";
    };
    meta.homepage = "https://github.com/IndianBoy42/tree-sitter-just";
  };
  kcl = buildGrammar {
    language = "kcl";
    version = "0.0.0+rev=b0b2eb3";
    src = fetchFromGitHub {
      owner = "kcl-lang";
      repo = "tree-sitter-kcl";
      rev = "b0b2eb38009e04035a6e266c7e11e541f3caab7c";
      hash = "sha256-Aeu1j77GdsNpo9PU+FcqN3ttT0eLaDKY4n8buftMiDc=";
    };
    meta.homepage = "https://github.com/kcl-lang/tree-sitter-kcl";
  };
  kconfig = buildGrammar {
    language = "kconfig";
    version = "0.0.0+rev=9ac99fe";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-kconfig";
      rev = "9ac99fe4c0c27a35dc6f757cef534c646e944881";
      hash = "sha256-8gZZLGL7giVHQIirjUIfsx3scP1L1VTFIZX7QOyjWvk=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-kconfig";
  };
  kdl = buildGrammar {
    language = "kdl";
    version = "0.0.0+rev=b37e3d5";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-kdl";
      rev = "b37e3d58e5c5cf8d739b315d6114e02d42e66664";
      hash = "sha256-irx8aMEdZG2WcQVE2c7ahwLjqEoUAOOjvhDDk69a6lE=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-kdl";
  };
  kotlin = buildGrammar {
    language = "kotlin";
    version = "0.0.0+rev=c4ddea3";
    src = fetchFromGitHub {
      owner = "fwcd";
      repo = "tree-sitter-kotlin";
      rev = "c4ddea359a7ff4d92360b2efcd6cfce5dc25afe6";
      hash = "sha256-7REd272fpCP/ggzg7wLf5DS6QX9SIO9YGPdvj2c2w58=";
    };
    meta.homepage = "https://github.com/fwcd/tree-sitter-kotlin";
  };
  koto = buildGrammar {
    language = "koto";
    version = "0.0.0+rev=46770ab";
    src = fetchFromGitHub {
      owner = "koto-lang";
      repo = "tree-sitter-koto";
      rev = "46770abba021e2ddd2c51d9fa3087fd1ab6b2aea";
      hash = "sha256-BMBwkWVvW4qBX6DqM29Ne17K116yUiH2njdKkzeXmTY=";
    };
    meta.homepage = "https://github.com/koto-lang/tree-sitter-koto";
  };
  kusto = buildGrammar {
    language = "kusto";
    version = "0.0.0+rev=8353a12";
    src = fetchFromGitHub {
      owner = "Willem-J-an";
      repo = "tree-sitter-kusto";
      rev = "8353a1296607d6ba33db7c7e312226e5fc83e8ce";
      hash = "sha256-CZCvgOtHjCgyzKFdys+ZvSWCj1I1/b2MnaJcdAtm2aY=";
    };
    meta.homepage = "https://github.com/Willem-J-an/tree-sitter-kusto";
  };
  lalrpop = buildGrammar {
    language = "lalrpop";
    version = "0.0.0+rev=8d38e97";
    src = fetchFromGitHub {
      owner = "traxys";
      repo = "tree-sitter-lalrpop";
      rev = "8d38e9755c05d37df8a24dadb0fc64f6588ac188";
      hash = "sha256-rqJ0Zr9zxPkqux+DCSaUszqijFpc35fUB6sAPdGdt/0=";
    };
    meta.homepage = "https://github.com/traxys/tree-sitter-lalrpop";
  };
  latex = buildGrammar {
    language = "latex";
    version = "0.0.0+rev=7b06f6e";
    src = fetchFromGitHub {
      owner = "latex-lsp";
      repo = "tree-sitter-latex";
      rev = "7b06f6ed394308e7407a1703d2724128c45fc9d7";
      hash = "sha256-HbRjblLBExpBkBBjHyEHfnK0oootjAsqkwjmGH3/UYI=";
    };
    generate = true;
    meta.homepage = "https://github.com/latex-lsp/tree-sitter-latex";
  };
  ledger = buildGrammar {
    language = "ledger";
    version = "0.0.0+rev=d313153";
    src = fetchFromGitHub {
      owner = "cbarrete";
      repo = "tree-sitter-ledger";
      rev = "d313153eef68c557ba4538b20de2d0e92f3ef6f8";
      hash = "sha256-/dE3Uqi5zuTWtbjPAm9j7+z6RnTKJeXdS5na+XoGCE0=";
    };
    meta.homepage = "https://github.com/cbarrete/tree-sitter-ledger";
  };
  leo = buildGrammar {
    language = "leo";
    version = "0.0.0+rev=6bc5564";
    src = fetchFromGitHub {
      owner = "r001";
      repo = "tree-sitter-leo";
      rev = "6bc5564917edacd070afc4d33cf5e2e677831ea9";
      hash = "sha256-FbV95Jm2w/9Xrqdl4bRnUyCYxFMXIuDXO4Hl4w2AUaM=";
    };
    meta.homepage = "https://github.com/r001/tree-sitter-leo";
  };
  linkerscript = buildGrammar {
    language = "linkerscript";
    version = "0.0.0+rev=f99011a";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-linkerscript";
      rev = "f99011a3554213b654985a4b0a65b3b032ec4621";
      hash = "sha256-Do8MIcl5DJo00V4wqIbdVC0to+2YYwfy08QWqSLMkQA=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-linkerscript";
  };
  liquid = buildGrammar {
    language = "liquid";
    version = "0.0.0+rev=d269f4d";
    src = fetchFromGitHub {
      owner = "hankthetank27";
      repo = "tree-sitter-liquid";
      rev = "d269f4d52cd08f6cbc6636ee23cc30a9f6c32e42";
      hash = "sha256-vOQirMsR+UqUyC7yJfuFynXEorkkUYjAB4C08Wf+zE4=";
    };
    meta.homepage = "https://github.com/hankthetank27/tree-sitter-liquid";
  };
  liquidsoap = buildGrammar {
    language = "liquidsoap";
    version = "0.0.0+rev=8e51fa6";
    src = fetchFromGitHub {
      owner = "savonet";
      repo = "tree-sitter-liquidsoap";
      rev = "8e51fa63ddb93ac179d4e34a311d3d3f03780b42";
      hash = "sha256-i6cQoMeKOS2hEId9bpqNchQDh2vjAfKk+hLTEMOUegU=";
    };
    meta.homepage = "https://github.com/savonet/tree-sitter-liquidsoap";
  };
  llvm = buildGrammar {
    language = "llvm";
    version = "0.0.0+rev=c14cb83";
    src = fetchFromGitHub {
      owner = "benwilliamgraham";
      repo = "tree-sitter-llvm";
      rev = "c14cb839003348692158b845db9edda201374548";
      hash = "sha256-L3XwPhvwIR/mUbugMbaHS9dXyhO7bApv/gdlxQ+2Bbo=";
    };
    meta.homepage = "https://github.com/benwilliamgraham/tree-sitter-llvm";
  };
  lua = buildGrammar {
    language = "lua";
    version = "0.0.0+rev=db16e76";
    src = fetchFromGitHub {
      owner = "MunifTanjim";
      repo = "tree-sitter-lua";
      rev = "db16e76558122e834ee214c8dc755b4a3edc82a9";
      hash = "sha256-uJdXqlDn8F8mjh/NukpkQA6jdd7YjYOBbugzIrBb6GA=";
    };
    meta.homepage = "https://github.com/MunifTanjim/tree-sitter-lua";
  };
  luadoc = buildGrammar {
    language = "luadoc";
    version = "0.0.0+rev=873612a";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-luadoc";
      rev = "873612aadd3f684dd4e631bdf42ea8990c57634e";
      hash = "sha256-ttGBB9sn+xd9jWzjNAzpo/lwYVYZGSUGEip4K3PfBP0=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-luadoc";
  };
  luap = buildGrammar {
    language = "luap";
    version = "0.0.0+rev=c134aae";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-luap";
      rev = "c134aaec6acf4fa95fe4aa0dc9aba3eacdbbe55a";
      hash = "sha256-4mMUHBsdK4U4uhh8GpKlG3p/s3ZCcLX1qATPyTD4Xhg=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-luap";
  };
  luau = buildGrammar {
    language = "luau";
    version = "0.0.0+rev=a8914d6";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-luau";
      rev = "a8914d6c1fc5131f8e1c13f769fa704c9f5eb02f";
      hash = "sha256-5qbZA2mxTvrsfUrpgD+4y3oeJsifA91c/hfcVwQBRgI=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-luau";
  };
  m68k = buildGrammar {
    language = "m68k";
    version = "0.0.0+rev=e128454";
    src = fetchFromGitHub {
      owner = "grahambates";
      repo = "tree-sitter-m68k";
      rev = "e128454c2210c0e0c10b68fe45ddb8fee80182a3";
      hash = "sha256-g7SZ/TrTaaeGDNOqId4eom9R/5gOyXcmmhWY4WW0fF4=";
    };
    meta.homepage = "https://github.com/grahambates/tree-sitter-m68k";
  };
  make = buildGrammar {
    language = "make";
    version = "0.0.0+rev=a4b9187";
    src = fetchFromGitHub {
      owner = "alemuller";
      repo = "tree-sitter-make";
      rev = "a4b9187417d6be349ee5fd4b6e77b4172c6827dd";
      hash = "sha256-qQqapnKKH5X8rkxbZG5PjnyxvnpyZHpFVi/CLkIn/x0=";
    };
    meta.homepage = "https://github.com/alemuller/tree-sitter-make";
  };
  markdown = buildGrammar {
    language = "markdown";
    version = "0.0.0+rev=4132852";
    src = fetchFromGitHub {
      owner = "MDeiml";
      repo = "tree-sitter-markdown";
      rev = "413285231ce8fa8b11e7074bbe265b48aa7277f9";
      hash = "sha256-Oe2iL5b1Cyv+dK0nQYFNLCCOCe+93nojxt6ukH2lEmU=";
    };
    location = "tree-sitter-markdown";
    meta.homepage = "https://github.com/MDeiml/tree-sitter-markdown";
  };
  markdown_inline = buildGrammar {
    language = "markdown_inline";
    version = "0.0.0+rev=4132852";
    src = fetchFromGitHub {
      owner = "MDeiml";
      repo = "tree-sitter-markdown";
      rev = "413285231ce8fa8b11e7074bbe265b48aa7277f9";
      hash = "sha256-Oe2iL5b1Cyv+dK0nQYFNLCCOCe+93nojxt6ukH2lEmU=";
    };
    location = "tree-sitter-markdown-inline";
    meta.homepage = "https://github.com/MDeiml/tree-sitter-markdown";
  };
  matlab = buildGrammar {
    language = "matlab";
    version = "0.0.0+rev=bbf1b3f";
    src = fetchFromGitHub {
      owner = "acristoffers";
      repo = "tree-sitter-matlab";
      rev = "bbf1b3f0bd7417c1efb8958fe95be3d0d540207a";
      hash = "sha256-dFsHOqleUTJCzidlKv/5kpawYhbn0jmOIpPrpJQJj80=";
    };
    meta.homepage = "https://github.com/acristoffers/tree-sitter-matlab";
  };
  menhir = buildGrammar {
    language = "menhir";
    version = "0.0.0+rev=be8866a";
    src = fetchFromGitHub {
      owner = "Kerl13";
      repo = "tree-sitter-menhir";
      rev = "be8866a6bcc2b563ab0de895af69daeffa88fe70";
      hash = "sha256-CQVEQurf8Ur5xnz+g7e1nck0a32o4oeMOT78thjx8MQ=";
    };
    meta.homepage = "https://github.com/Kerl13/tree-sitter-menhir";
  };
  mermaid = buildGrammar {
    language = "mermaid";
    version = "0.0.0+rev=90ae195";
    src = fetchFromGitHub {
      owner = "monaqa";
      repo = "tree-sitter-mermaid";
      rev = "90ae195b31933ceb9d079abfa8a3ad0a36fee4cc";
      hash = "sha256-Tt1bPqpL59FQzuI8CPljBmQoAfJPUkVC9Xe1GcfXzfE=";
    };
    meta.homepage = "https://github.com/monaqa/tree-sitter-mermaid";
  };
  meson = buildGrammar {
    language = "meson";
    version = "0.0.0+rev=a56af66";
    src = fetchFromGitHub {
      owner = "Decodetalkers";
      repo = "tree-sitter-meson";
      rev = "a56af662e8540412fed5e40cc20435b2b9a20502";
      hash = "sha256-RT/CXsbo+TZeG+6m9kwSoS5RImchTe5P/7tRlgTnPJo=";
    };
    meta.homepage = "https://github.com/Decodetalkers/tree-sitter-meson";
  };
  mlir = buildGrammar {
    language = "mlir";
    version = "0.0.0+rev=922cbb9";
    src = fetchFromGitHub {
      owner = "artagnon";
      repo = "tree-sitter-mlir";
      rev = "922cbb97f3d20044e6b4362b3d7af5e530ed8f34";
      hash = "sha256-b36hctcSJoWSCZmuQNoNqZWJ3w28ejyEfmFqdmiwuLc=";
    };
    generate = true;
    meta.homepage = "https://github.com/artagnon/tree-sitter-mlir";
  };
  muttrc = buildGrammar {
    language = "muttrc";
    version = "0.0.0+rev=173b0ab";
    src = fetchFromGitHub {
      owner = "neomutt";
      repo = "tree-sitter-muttrc";
      rev = "173b0ab53a9c07962c9777189c4c70e90f1c1837";
      hash = "sha256-zma/oyMFI+r+/616yXV9b4ptC1FNYpHlpqY/Fez++n0=";
    };
    meta.homepage = "https://github.com/neomutt/tree-sitter-muttrc";
  };
  nasm = buildGrammar {
    language = "nasm";
    version = "0.0.0+rev=d1b3638";
    src = fetchFromGitHub {
      owner = "naclsn";
      repo = "tree-sitter-nasm";
      rev = "d1b3638d017f2a8585e26dcfc66fe1df94185e30";
      hash = "sha256-38yRvaSkHZ7iRmHlXdCssJtd/RQRfBB437HzBwWv2mg=";
    };
    meta.homepage = "https://github.com/naclsn/tree-sitter-nasm";
  };
  nginx = buildGrammar {
    language = "nginx";
    version = "0.0.0+rev=989da76";
    src = fetchFromGitHub {
      owner = "opa-oz";
      repo = "tree-sitter-nginx";
      rev = "989da760be05a3334af3ec88705cbf57e6a9c41d";
      hash = "sha256-tIbwsh7cnpm1jkIKaXQ7NI/LXWzEOsZyNLfe/qTNkkM=";
    };
    meta.homepage = "https://github.com/opa-oz/tree-sitter-nginx";
  };
  nickel = buildGrammar {
    language = "nickel";
    version = "0.0.0+rev=25464b3";
    src = fetchFromGitHub {
      owner = "nickel-lang";
      repo = "tree-sitter-nickel";
      rev = "25464b33522c3f609fa512aa9651707c0b66d48b";
      hash = "sha256-dQeUoHQHkPYywYIm3TMnTWPXUlh2xh8M5CVUiXASBu8=";
    };
    meta.homepage = "https://github.com/nickel-lang/tree-sitter-nickel";
  };
  nim = buildGrammar {
    language = "nim";
    version = "0.0.0+rev=897e5d3";
    src = fetchFromGitHub {
      owner = "alaviss";
      repo = "tree-sitter-nim";
      rev = "897e5d346f0b59ed62b517cfb0f1a845ad8f0ab7";
      hash = "sha256-JwR5Og1pGDTHI49rFsnfStrTcZ7hOseK6YyFIVlQ1o4=";
    };
    meta.homepage = "https://github.com/alaviss/tree-sitter-nim";
  };
  nim_format_string = buildGrammar {
    language = "nim_format_string";
    version = "0.0.0+rev=d45f750";
    src = fetchFromGitHub {
      owner = "aMOPel";
      repo = "tree-sitter-nim-format-string";
      rev = "d45f75022d147cda056e98bfba68222c9c8eca3a";
      hash = "sha256-hbM0JIxtZ3e2JUV4jXYO4RIO6r63nf2csvsLeIxkMn0=";
    };
    meta.homepage = "https://github.com/aMOPel/tree-sitter-nim-format-string";
  };
  ninja = buildGrammar {
    language = "ninja";
    version = "0.0.0+rev=0a95cfd";
    src = fetchFromGitHub {
      owner = "alemuller";
      repo = "tree-sitter-ninja";
      rev = "0a95cfdc0745b6ae82f60d3a339b37f19b7b9267";
      hash = "sha256-e/LpQUL3UHHko4QvMeT40LCvPZRT7xTGZ9z1Zaboru4=";
    };
    meta.homepage = "https://github.com/alemuller/tree-sitter-ninja";
  };
  nix = buildGrammar {
    language = "nix";
    version = "0.0.0+rev=cfc53fd";
    src = fetchFromGitHub {
      owner = "cstrahan";
      repo = "tree-sitter-nix";
      rev = "cfc53fd287d23ab7281440a8526c73542984669b";
      hash = "sha256-eqqneqZqA73McjPZfy7GbUi4ccmDYC5O++Ezt9+lqi4=";
    };
    meta.homepage = "https://github.com/cstrahan/tree-sitter-nix";
  };
  norg = buildGrammar {
    language = "norg";
    version = "0.0.0+rev=d89d95a";
    src = fetchFromGitHub {
      owner = "nvim-neorg";
      repo = "tree-sitter-norg";
      rev = "d89d95af13d409f30a6c7676387bde311ec4a2c8";
      hash = "sha256-z3h5qMuNKnpQgV62xZ02F5vWEq4VEnm5lxwEnIFu+Rw=";
    };
    meta.homepage = "https://github.com/nvim-neorg/tree-sitter-norg";
  };
  nqc = buildGrammar {
    language = "nqc";
    version = "0.0.0+rev=14e6da1";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-nqc";
      rev = "14e6da1627aaef21d2b2aa0c37d04269766dcc1d";
      hash = "sha256-Gf6410cWLENCgI1uIBVBl4RnRuVCHkWkn6sxusmI6j4=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-nqc";
  };
  nu = buildGrammar {
    language = "nu";
    version = "0.0.0+rev=d5c71a1";
    src = fetchFromGitHub {
      owner = "nushell";
      repo = "tree-sitter-nu";
      rev = "d5c71a10b4d1b02e38967b05f8de70e847448dd1";
      hash = "sha256-7Ny3wXa5iE6s7szqTkPqaXWL/NL5yA2MbhdQHylxwE0=";
    };
    meta.homepage = "https://github.com/nushell/tree-sitter-nu";
  };
  objc = buildGrammar {
    language = "objc";
    version = "0.0.0+rev=181a81b";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-objc";
      rev = "181a81b8f23a2d593e7ab4259981f50122909fda";
      hash = "sha256-7W8ozhQJL+f+tQYz61EZexk9NkMu1pCAP5IIy1m3qak=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-objc";
  };
  objdump = buildGrammar {
    language = "objdump";
    version = "0.0.0+rev=28d3b2e";
    src = fetchFromGitHub {
      owner = "ColinKennedy";
      repo = "tree-sitter-objdump";
      rev = "28d3b2e25a0b1881d1b47ed1924ca276c7003d45";
      hash = "sha256-OPqIhgItghXplQ78Vlwd0G6KtDWTVkaG17RPqx1b5JY=";
    };
    meta.homepage = "https://github.com/ColinKennedy/tree-sitter-objdump";
  };
  ocaml = buildGrammar {
    language = "ocaml";
    version = "0.0.0+rev=91708de";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-ocaml";
      rev = "91708deb10cb4fe68ab3c50891426b9967dbf35a";
      hash = "sha256-HFFvg+4HrUJ12/rbXwCvYthx+yXqxa3OlY3j8/GnYFk=";
    };
    location = "grammars/ocaml";
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-ocaml";
  };
  ocaml_interface = buildGrammar {
    language = "ocaml_interface";
    version = "0.0.0+rev=91708de";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-ocaml";
      rev = "91708deb10cb4fe68ab3c50891426b9967dbf35a";
      hash = "sha256-HFFvg+4HrUJ12/rbXwCvYthx+yXqxa3OlY3j8/GnYFk=";
    };
    location = "grammars/interface";
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-ocaml";
  };
  ocamllex = buildGrammar {
    language = "ocamllex";
    version = "0.0.0+rev=c5cf996";
    src = fetchFromGitHub {
      owner = "atom-ocaml";
      repo = "tree-sitter-ocamllex";
      rev = "c5cf996c23e38a1537069fbe2d4bb83a75fc7b2f";
      hash = "sha256-eDJRTLYKHcL7yAgFL8vZQh9zp5fBxcZRsWChp8y3Am0=";
    };
    generate = true;
    meta.homepage = "https://github.com/atom-ocaml/tree-sitter-ocamllex";
  };
  odin = buildGrammar {
    language = "odin";
    version = "0.0.0+rev=d2ca8ef";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-odin";
      rev = "d2ca8efb4487e156a60d5bd6db2598b872629403";
      hash = "sha256-aPeaGERAP1Fav2QAjZy1zXciCuUTQYrsqXaSQsYG0oU=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-odin";
  };
  pascal = buildGrammar {
    language = "pascal";
    version = "0.0.0+rev=78426d9";
    src = fetchFromGitHub {
      owner = "Isopod";
      repo = "tree-sitter-pascal";
      rev = "78426d96bde7114af979e314283e45d087603428";
      hash = "sha256-KNVrXS7sYMXqZ5+sMnmp87vHr8NYrY+BTVVIdV2wnm0=";
    };
    meta.homepage = "https://github.com/Isopod/tree-sitter-pascal";
  };
  passwd = buildGrammar {
    language = "passwd";
    version = "0.0.0+rev=2023939";
    src = fetchFromGitHub {
      owner = "ath3";
      repo = "tree-sitter-passwd";
      rev = "20239395eacdc2e0923a7e5683ad3605aee7b716";
      hash = "sha256-3UfuyJeblQBKjqZvLYyO3GoCvYJp+DvBwQGkR3pFQQ4=";
    };
    meta.homepage = "https://github.com/ath3/tree-sitter-passwd";
  };
  pem = buildGrammar {
    language = "pem";
    version = "0.0.0+rev=1d16b8e";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-pem";
      rev = "1d16b8e063fdf4385e389096c4bc4999eaaef05f";
      hash = "sha256-NhiSqaLjzEJHj8JimFdcZBVAR00lKf9O5JLtwIUCKhw=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-pem";
  };
  perl = buildGrammar {
    language = "perl";
    version = "0.0.0+rev=ecd90bd";
    src = fetchFromGitHub {
      owner = "tree-sitter-perl";
      repo = "tree-sitter-perl";
      rev = "ecd90bd8b381bcc7219fed4fe351903630e761c6";
      hash = "sha256-iIa0FJ4kCgfOM/jKwSpaGyOlNwUtczhqoO5gKW7PAHI=";
    };
    meta.homepage = "https://github.com/tree-sitter-perl/tree-sitter-perl";
  };
  php = buildGrammar {
    language = "php";
    version = "0.0.0+rev=576a56f";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-php";
      rev = "576a56fa7f8b68c91524cdd211eb2ffc43e7bb11";
      hash = "sha256-kTiqj4KWHTZVJ6R6axubNGdcTNA+W02RTsBcoeR2xGU=";
    };
    location = "php";
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-php";
  };
  php_only = buildGrammar {
    language = "php_only";
    version = "0.0.0+rev=576a56f";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-php";
      rev = "576a56fa7f8b68c91524cdd211eb2ffc43e7bb11";
      hash = "sha256-kTiqj4KWHTZVJ6R6axubNGdcTNA+W02RTsBcoeR2xGU=";
    };
    location = "php_only";
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-php";
  };
  phpdoc = buildGrammar {
    language = "phpdoc";
    version = "0.0.0+rev=fe3202e";
    src = fetchFromGitHub {
      owner = "claytonrcarter";
      repo = "tree-sitter-phpdoc";
      rev = "fe3202e468bc17332bec8969f2b50ff1f1da3a46";
      hash = "sha256-sQ8jmVvZD0fIc9qlfyl6MaXvP/2ljzViKIl9RgVOJqw=";
    };
    meta.homepage = "https://github.com/claytonrcarter/tree-sitter-phpdoc";
  };
  pioasm = buildGrammar {
    language = "pioasm";
    version = "0.0.0+rev=afece58";
    src = fetchFromGitHub {
      owner = "leo60228";
      repo = "tree-sitter-pioasm";
      rev = "afece58efdb30440bddd151ef1347fa8d6f744a9";
      hash = "sha256-rUuolF/jPJGiqunD6SLUJ0x/MTIJ+mJ1QSBCasUw5T8=";
    };
    meta.homepage = "https://github.com/leo60228/tree-sitter-pioasm";
  };
  po = buildGrammar {
    language = "po";
    version = "0.0.0+rev=bd860a0";
    src = fetchFromGitHub {
      owner = "erasin";
      repo = "tree-sitter-po";
      rev = "bd860a0f57f697162bf28e576674be9c1500db5e";
      hash = "sha256-/St0VxDTAF872ZlBph1TukRoO0PBIOMT0D11DZ6nSLQ=";
    };
    meta.homepage = "https://github.com/erasin/tree-sitter-po";
  };
  pod = buildGrammar {
    language = "pod";
    version = "0.0.0+rev=0bf8387";
    src = fetchFromGitHub {
      owner = "tree-sitter-perl";
      repo = "tree-sitter-pod";
      rev = "0bf8387987c21bf2f8ed41d2575a8f22b139687f";
      hash = "sha256-yV2kVAxWxdyIJ3g2oivDc01SAQF0lc7UMT2sfv9lKzI=";
    };
    meta.homepage = "https://github.com/tree-sitter-perl/tree-sitter-pod";
  };
  poe_filter = buildGrammar {
    language = "poe_filter";
    version = "0.0.0+rev=2902dc4";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-poe-filter";
      rev = "2902dc45439125b9386812c1089a8e9b5f71c4ab";
      hash = "sha256-j/634pLyfgF7Pyjmh4ETuW0U38kH6Seik1w4pJKBmec=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-poe-filter";
  };
  pony = buildGrammar {
    language = "pony";
    version = "0.0.0+rev=73ff874";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-pony";
      rev = "73ff874ae4c9e9b45462673cbc0a1e350e2522a7";
      hash = "sha256-/9bTbep2AXLoiijeft9amMeFQ6fHXzItjH+bD/w6pDo=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-pony";
  };
  powershell = buildGrammar {
    language = "powershell";
    version = "0.0.0+rev=66d5e61";
    src = fetchFromGitHub {
      owner = "airbus-cert";
      repo = "tree-sitter-powershell";
      rev = "66d5e61126989c0aca57ff77d19b2064919b51e1";
      hash = "sha256-M2vOS2UleHpZC8PbUf+PHxjWz4BMBhyVxcuUsuMx34Q=";
    };
    meta.homepage = "https://github.com/airbus-cert/tree-sitter-powershell";
  };
  printf = buildGrammar {
    language = "printf";
    version = "0.0.0+rev=df6b699";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-printf";
      rev = "df6b69967db7d74ab338a86a9ab45c0966c5ee3c";
      hash = "sha256-54yEvxL6u+Mya4INj1AIb1ldYv1WdQV55z8+wgKdthc=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-printf";
  };
  prisma = buildGrammar {
    language = "prisma";
    version = "0.0.0+rev=73f39a6";
    src = fetchFromGitHub {
      owner = "victorhqc";
      repo = "tree-sitter-prisma";
      rev = "73f39a6d5401cfdcd143951e499336cf5ab2ffaa";
      hash = "sha256-0wHh+Gf2wer/35NdEWOCQFNdRH/wVWnRx9HnlX7vZho=";
    };
    meta.homepage = "https://github.com/victorhqc/tree-sitter-prisma";
  };
  problog = buildGrammar {
    language = "problog";
    version = "0.0.0+rev=d8d415f";
    src = fetchFromGitHub {
      owner = "foxyseta";
      repo = "tree-sitter-prolog";
      rev = "d8d415f6a1cf80ca138524bcc395810b176d40fa";
      hash = "sha256-SEqqmkfV/wsr1ObcBN5My29RY9TWfxnQlsnEEIZyR18=";
    };
    location = "grammars/problog";
    meta.homepage = "https://github.com/foxyseta/tree-sitter-prolog";
  };
  prolog = buildGrammar {
    language = "prolog";
    version = "0.0.0+rev=d8d415f";
    src = fetchFromGitHub {
      owner = "foxyseta";
      repo = "tree-sitter-prolog";
      rev = "d8d415f6a1cf80ca138524bcc395810b176d40fa";
      hash = "sha256-SEqqmkfV/wsr1ObcBN5My29RY9TWfxnQlsnEEIZyR18=";
    };
    location = "grammars/prolog";
    meta.homepage = "https://github.com/foxyseta/tree-sitter-prolog";
  };
  promql = buildGrammar {
    language = "promql";
    version = "0.0.0+rev=77625d7";
    src = fetchFromGitHub {
      owner = "MichaHoffmann";
      repo = "tree-sitter-promql";
      rev = "77625d78eebc3ffc44d114a07b2f348dff3061b0";
      hash = "sha256-IJbnC03pDfcSAF//Ux+LqqfjtagGSD5Nu46yUo0vT5Q=";
    };
    meta.homepage = "https://github.com/MichaHoffmann/tree-sitter-promql";
  };
  properties = buildGrammar {
    language = "properties";
    version = "0.0.0+rev=579b62f";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-properties";
      rev = "579b62f5ad8d96c2bb331f07d1408c92767531d9";
      hash = "sha256-4WgGbU6fthFH1DcvlQiqNGXucCfxA+hANZ7Y+r8eXHg=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-properties";
  };
  proto = buildGrammar {
    language = "proto";
    version = "0.0.0+rev=e9f6b43";
    src = fetchFromGitHub {
      owner = "treywood";
      repo = "tree-sitter-proto";
      rev = "e9f6b43f6844bd2189b50a422d4e2094313f6aa3";
      hash = "sha256-Ue6w6HWy+NTJt+AKTFfJIUf3HXHTwkUkDk4UdDMSD+U=";
    };
    meta.homepage = "https://github.com/treywood/tree-sitter-proto";
  };
  prql = buildGrammar {
    language = "prql";
    version = "0.0.0+rev=09e158c";
    src = fetchFromGitHub {
      owner = "PRQL";
      repo = "tree-sitter-prql";
      rev = "09e158cd3650581c0af4c49c2e5b10c4834c8646";
      hash = "sha256-bdT7LZ2x7BdUqLJRq4ENJTaIFnciac7l2dCxOSB09CI=";
    };
    meta.homepage = "https://github.com/PRQL/tree-sitter-prql";
  };
  psv = buildGrammar {
    language = "psv";
    version = "0.0.0+rev=7eb7297";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-csv";
      rev = "7eb7297823605392d2bbcc4c09b1cd18d6fa9529";
      hash = "sha256-5VL7uREH0lloAWo9rdJXsjDsWxgL6fngWJSmi4fM7UQ=";
    };
    location = "psv";
    meta.homepage = "https://github.com/amaanq/tree-sitter-csv";
  };
  pug = buildGrammar {
    language = "pug";
    version = "0.0.0+rev=13e9195";
    src = fetchFromGitHub {
      owner = "zealot128";
      repo = "tree-sitter-pug";
      rev = "13e9195370172c86a8b88184cc358b23b677cc46";
      hash = "sha256-Yk1oBv9Flz+QX5tyFZwx0y67I5qgbnLhwYuAvLi9eV8=";
    };
    meta.homepage = "https://github.com/zealot128/tree-sitter-pug";
  };
  puppet = buildGrammar {
    language = "puppet";
    version = "0.0.0+rev=15f1929";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-puppet";
      rev = "15f192929b7d317f5914de2b4accd37b349182a6";
      hash = "sha256-bO5g5AdhzpB13yHklpAndUHIX7Rvd7OMjH0Ds2ATA6Q=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-puppet";
  };
  purescript = buildGrammar {
    language = "purescript";
    version = "0.0.0+rev=daf9b3e";
    src = fetchFromGitHub {
      owner = "postsolar";
      repo = "tree-sitter-purescript";
      rev = "daf9b3e2be18b0b2996a1281f7783e0d041d8b80";
      hash = "sha256-eY2WF2n0fZUl1zxZZHJVYR8b1FwaAjkCeSeOdSf67m4=";
    };
    meta.homepage = "https://github.com/postsolar/tree-sitter-purescript";
  };
  pymanifest = buildGrammar {
    language = "pymanifest";
    version = "0.0.0+rev=be06258";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-pymanifest";
      rev = "be062582956165019d3253794b4d712f66dfeaaa";
      hash = "sha256-Kud/E67Sh9F4nc8nzW5UXFHW5+kGftLyFzwLOKLcpL8=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-pymanifest";
  };
  python = buildGrammar {
    language = "python";
    version = "0.0.0+rev=710796b";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-python";
      rev = "710796b8b877a970297106e5bbc8e2afa47f86ec";
      hash = "sha256-t9etfZcrliF7f9hfiomh2U9P+3ufAm8iSK1y9rOhP7s=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-python";
  };
  ql = buildGrammar {
    language = "ql";
    version = "0.0.0+rev=1fd627a";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-ql";
      rev = "1fd627a4e8bff8c24c11987474bd33112bead857";
      hash = "sha256-mJ/bj09mT1WTaiKoXiRXDM7dkenf5hv2ArXieeTVe6I=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-ql";
  };
  qmldir = buildGrammar {
    language = "qmldir";
    version = "0.0.0+rev=6b2b5e4";
    src = fetchFromGitHub {
      owner = "Decodetalkers";
      repo = "tree-sitter-qmldir";
      rev = "6b2b5e41734bd6f07ea4c36ac20fb6f14061c841";
      hash = "sha256-7ic9Xd+1G0JM25bY0f8N5r6YZx5NV5HrJXXHp6pXvo4=";
    };
    meta.homepage = "https://github.com/Decodetalkers/tree-sitter-qmldir";
  };
  qmljs = buildGrammar {
    language = "qmljs";
    version = "0.0.0+rev=0889da4";
    src = fetchFromGitHub {
      owner = "yuja";
      repo = "tree-sitter-qmljs";
      rev = "0889da4632bba3ec6f39ef4102625654890c15c1";
      hash = "sha256-Twj2taG7xFTPXTvzDcWeIqxUAkuhsybwZvtwK/HiruE=";
    };
    meta.homepage = "https://github.com/yuja/tree-sitter-qmljs";
  };
  query = buildGrammar {
    language = "query";
    version = "0.0.0+rev=930202c";
    src = fetchFromGitHub {
      owner = "nvim-treesitter";
      repo = "tree-sitter-query";
      rev = "930202c2a80965a7a9ca018b5b2a08b25dfa7f12";
      hash = "sha256-uXApakOZy9Gd/fl9C9qFZgptlT6rUlOmT6KW8sWP5Ag=";
    };
    meta.homepage = "https://github.com/nvim-treesitter/tree-sitter-query";
  };
  r = buildGrammar {
    language = "r";
    version = "0.0.0+rev=a0d3e33";
    src = fetchFromGitHub {
      owner = "r-lib";
      repo = "tree-sitter-r";
      rev = "a0d3e3307489c3ca54da8c7b5b4e0c5f5fd6953a";
      hash = "sha256-ryKgJ+3dv/O2AN5zIGtQnKml0zU0/s4Io8Tumpm62Gc=";
    };
    meta.homepage = "https://github.com/r-lib/tree-sitter-r";
  };
  racket = buildGrammar {
    language = "racket";
    version = "0.0.0+rev=5b211bf";
    src = fetchFromGitHub {
      owner = "6cdh";
      repo = "tree-sitter-racket";
      rev = "5b211bf93021d1c45f39aa96898be9f794f087e4";
      hash = "sha256-ry9j5nEcXiSD+xJYzT0mY37hGeDlVRYq7egUeuw1PfU=";
    };
    meta.homepage = "https://github.com/6cdh/tree-sitter-racket";
  };
  ralph = buildGrammar {
    language = "ralph";
    version = "0.0.0+rev=f6d81bf";
    src = fetchFromGitHub {
      owner = "alephium";
      repo = "tree-sitter-ralph";
      rev = "f6d81bf7a4599c77388035439cf5801cd461ff77";
      hash = "sha256-o+h43yMws4utPjqEQCt5swks3KfM3hb4mguclALsUsA=";
    };
    meta.homepage = "https://github.com/alephium/tree-sitter-ralph";
  };
  rasi = buildGrammar {
    language = "rasi";
    version = "0.0.0+rev=6c9bbcf";
    src = fetchFromGitHub {
      owner = "Fymyte";
      repo = "tree-sitter-rasi";
      rev = "6c9bbcfdf5f0f553d9ebc01750a3aa247a37b8aa";
      hash = "sha256-sPrIVgGGaBaXeqHNxjcdJ/S2FvxyV6rD9UPKU/tpspw=";
    };
    meta.homepage = "https://github.com/Fymyte/tree-sitter-rasi";
  };
  razor = buildGrammar {
    language = "razor";
    version = "0.0.0+rev=fe46ce5";
    src = fetchFromGitHub {
      owner = "tris203";
      repo = "tree-sitter-razor";
      rev = "fe46ce5ea7d844e53d59bc96f2175d33691c61c5";
      hash = "sha256-E4fgy588g6IP258TS2DvoILc1Aikvpfbtq20VIhBE4U=";
    };
    meta.homepage = "https://github.com/tris203/tree-sitter-razor";
  };
  rbs = buildGrammar {
    language = "rbs";
    version = "0.0.0+rev=de893b1";
    src = fetchFromGitHub {
      owner = "joker1007";
      repo = "tree-sitter-rbs";
      rev = "de893b166476205b09e79cd3689f95831269579a";
      hash = "sha256-87Z8XQfuqrWYj9Mc+whVu9o3ZwfjGYylbvxZNYnA3UM=";
    };
    meta.homepage = "https://github.com/joker1007/tree-sitter-rbs";
  };
  re2c = buildGrammar {
    language = "re2c";
    version = "0.0.0+rev=c18a3c2";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-re2c";
      rev = "c18a3c2f4b6665e35b7e50d6048ea3cff770c572";
      hash = "sha256-2htX4730fNAO2NKEurDOXH1OIXFd0OfuIbH1ou3a20A=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-re2c";
  };
  readline = buildGrammar {
    language = "readline";
    version = "0.0.0+rev=74addc9";
    src = fetchFromGitHub {
      owner = "ribru17";
      repo = "tree-sitter-readline";
      rev = "74addc90fc539d31d413c0c7cf7581997a7fa46e";
      hash = "sha256-cbQnAPtgMnA41CTI9OyY8WYvdlJOC9g0ZMbitNSvtmI=";
    };
    meta.homepage = "https://github.com/ribru17/tree-sitter-readline";
  };
  regex = buildGrammar {
    language = "regex";
    version = "0.0.0+rev=b638d29";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-regex";
      rev = "b638d29335ef41215b86732dd51be34c701ef683";
      hash = "sha256-KHPwvjqvgqLKGL/OeotF1djSSSrAsb2H3CNUmgiva18=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-regex";
  };
  rego = buildGrammar {
    language = "rego";
    version = "0.0.0+rev=20b5a59";
    src = fetchFromGitHub {
      owner = "FallenAngel97";
      repo = "tree-sitter-rego";
      rev = "20b5a5958c837bc9f74b231022a68a594a313f6d";
      hash = "sha256-XwlVsOlxYzB0x+T05iuIp7nFAoQkMByKiHXZ0t5QsjI=";
    };
    meta.homepage = "https://github.com/FallenAngel97/tree-sitter-rego";
  };
  requirements = buildGrammar {
    language = "requirements";
    version = "0.0.0+rev=7289100";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-requirements";
      rev = "728910099ddea7f1f94ea95a35a70d1ea76a1639";
      hash = "sha256-IiIvU4iyqlP9px6qCivmQXusp/vuhOJBfWqMfcdKN7s=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-requirements";
  };
  rescript = buildGrammar {
    language = "rescript";
    version = "0.0.0+rev=4606cd8";
    src = fetchFromGitHub {
      owner = "rescript-lang";
      repo = "tree-sitter-rescript";
      rev = "4606cd81c4c31d1d02390fee530858323410a74c";
      hash = "sha256-md3fgW+h99va2Rwxzub7nrsEe64fC52g6NPCaXGAaxg=";
    };
    meta.homepage = "https://github.com/rescript-lang/tree-sitter-rescript";
  };
  rnoweb = buildGrammar {
    language = "rnoweb";
    version = "0.0.0+rev=1a74dc0";
    src = fetchFromGitHub {
      owner = "bamonroe";
      repo = "tree-sitter-rnoweb";
      rev = "1a74dc0ed731ad07db39f063e2c5a6fe528cae7f";
      hash = "sha256-sCjSS6iunij2SXHNzQcTq0HKawH9i5h/vQ6yl77opXw=";
    };
    meta.homepage = "https://github.com/bamonroe/tree-sitter-rnoweb";
  };
  robot = buildGrammar {
    language = "robot";
    version = "0.0.0+rev=17c2300";
    src = fetchFromGitHub {
      owner = "Hubro";
      repo = "tree-sitter-robot";
      rev = "17c2300e91fc9da4ba14c16558bf4292941dc074";
      hash = "sha256-9f0xFmhEQnETvV2SAZW+jRtsVdl0ZT3CDmGkcd3Fn88=";
    };
    meta.homepage = "https://github.com/Hubro/tree-sitter-robot";
  };
  robots = buildGrammar {
    language = "robots";
    version = "0.0.0+rev=8e3a420";
    src = fetchFromGitHub {
      owner = "opa-oz";
      repo = "tree-sitter-robots-txt";
      rev = "8e3a4205b76236bb6dbebdbee5afc262ce38bb62";
      hash = "sha256-OePLE85CWbl0hnre4Apq5Ix2GA8juGV2TE891Py4AME=";
    };
    meta.homepage = "https://github.com/opa-oz/tree-sitter-robots-txt";
  };
  roc = buildGrammar {
    language = "roc";
    version = "0.0.0+rev=0b1afe8";
    src = fetchFromGitHub {
      owner = "faldor20";
      repo = "tree-sitter-roc";
      rev = "0b1afe88161cbd81f5ddea1bb4fa786314ed49a7";
      hash = "sha256-DO0c6xRpJvj35qifh9/sfj5Op9CPsKA+4X6A7FBTGLI=";
    };
    meta.homepage = "https://github.com/faldor20/tree-sitter-roc";
  };
  ron = buildGrammar {
    language = "ron";
    version = "0.0.0+rev=7893855";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-ron";
      rev = "78938553b93075e638035f624973083451b29055";
      hash = "sha256-Sp0g6AWKHNjyUmL5k3RIU+5KtfICfg3o/DH77XRRyI0=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-ron";
  };
  rst = buildGrammar {
    language = "rst";
    version = "0.0.0+rev=4e562e1";
    src = fetchFromGitHub {
      owner = "stsewd";
      repo = "tree-sitter-rst";
      rev = "4e562e1598b95b93db4f3f64fe40ddefbc677a15";
      hash = "sha256-C65FmrEUyMQN+rF3RTN1oNVJtGiTHMZvdRyy/tMjVqY=";
    };
    meta.homepage = "https://github.com/stsewd/tree-sitter-rst";
  };
  ruby = buildGrammar {
    language = "ruby";
    version = "0.0.0+rev=89bd7a8";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-ruby";
      rev = "89bd7a8e5450cb6a942418a619d30469f259e5d6";
      hash = "sha256-84Nqw6QyGqwKAT+7Cdrzl1SikfJ3doX3tngGZWaXkVc=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-ruby";
  };
  runescript = buildGrammar {
    language = "runescript";
    version = "0.0.0+rev=cf85bbd";
    src = fetchFromGitHub {
      owner = "2004Scape";
      repo = "tree-sitter-runescript";
      rev = "cf85bbd5da0c5ad243301d889c7f84d790a4cae4";
      hash = "sha256-LRHTy5XMU2FOru7YrFlwuDU7brtnI/8RhAdQnY7Fkpk=";
    };
    meta.homepage = "https://github.com/2004Scape/tree-sitter-runescript";
  };
  rust = buildGrammar {
    language = "rust";
    version = "0.0.0+rev=e86119b";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-rust";
      rev = "e86119bdb4968b9799f6a014ca2401c178d54b5f";
      hash = "sha256-zJHUx5ZQVJ80hWWWh/PlO0jrOcCHDm9EPUTmZChab6g=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-rust";
  };
  scala = buildGrammar {
    language = "scala";
    version = "0.0.0+rev=c118995";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-scala";
      rev = "c1189954df854977c3a52003ca8a247c5f4729ba";
      hash = "sha256-aomchVnOjYrgGA3hem/PEumkiUuIiJbb89hnz7uYAwI=";
    };
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-scala";
  };
  scfg = buildGrammar {
    language = "scfg";
    version = "0.0.0+rev=2f3709e";
    src = fetchFromGitHub {
      owner = "rockorager";
      repo = "tree-sitter-scfg";
      rev = "2f3709e7656fa2c443f92041c91a9f843f8cd625";
      hash = "sha256-2/n+pSR6Ojahm8iBnpNsQscrXQqzZflKBA42gX29u50=";
    };
    generate = true;
    meta.homepage = "https://github.com/rockorager/tree-sitter-scfg";
  };
  scheme = buildGrammar {
    language = "scheme";
    version = "0.0.0+rev=63e25a4";
    src = fetchFromGitHub {
      owner = "6cdh";
      repo = "tree-sitter-scheme";
      rev = "63e25a4a84142ae7ee0ee01fe3a32c985ca16745";
      hash = "sha256-FK3F7v2LqAtXZM/CKCijWfXTF6TUhLmiVXScZqt46Io=";
    };
    meta.homepage = "https://github.com/6cdh/tree-sitter-scheme";
  };
  scss = buildGrammar {
    language = "scss";
    version = "0.0.0+rev=c478c68";
    src = fetchFromGitHub {
      owner = "serenadeai";
      repo = "tree-sitter-scss";
      rev = "c478c6868648eff49eb04a4df90d703dc45b312a";
      hash = "sha256-BFtMT6eccBWUyq6b8UXRAbB1R1XD3CrrFf1DM3aUI5c=";
    };
    meta.homepage = "https://github.com/serenadeai/tree-sitter-scss";
  };
  sflog = buildGrammar {
    language = "sflog";
    version = "0.0.0+rev=3597575";
    src = fetchFromGitHub {
      owner = "aheber";
      repo = "tree-sitter-sfapex";
      rev = "3597575a429766dd7ecce9f5bb97f6fec4419d5d";
      hash = "sha256-TOytPX/jBdVDYHBacpT9hAVVZcW+XGvIsubAqs9Dm80=";
    };
    location = "sflog";
    meta.homepage = "https://github.com/aheber/tree-sitter-sfapex";
  };
  slang = buildGrammar {
    language = "slang";
    version = "0.0.0+rev=3ed23c0";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-slang";
      rev = "3ed23c04a412a0559162d9cadf96dfff7cb36079";
      hash = "sha256-X/QoG1Gl9zDzA3++FznypgeBuWElMaN4BFFuBKPXohk=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-slang";
  };
  slim = buildGrammar {
    language = "slim";
    version = "0.0.0+rev=546e3aa";
    src = fetchFromGitHub {
      owner = "theoo";
      repo = "tree-sitter-slim";
      rev = "546e3aa1af8a3b355c7734efccd9a759ffc0b43a";
      hash = "sha256-G9+9TdEDqIDt3HvXWxMrjKixtgey7qkFNNp9fWx7Uec=";
    };
    meta.homepage = "https://github.com/theoo/tree-sitter-slim";
  };
  slint = buildGrammar {
    language = "slint";
    version = "0.0.0+rev=f11da7e";
    src = fetchFromGitHub {
      owner = "slint-ui";
      repo = "tree-sitter-slint";
      rev = "f11da7e62051ba8b9d4faa299c26de8aeedfc1cd";
      hash = "sha256-NTxJwVYq3o+9+BbBi4Lcj++mB4hvKAN3N+dRadXuBNo=";
    };
    meta.homepage = "https://github.com/slint-ui/tree-sitter-slint";
  };
  smali = buildGrammar {
    language = "smali";
    version = "0.0.0+rev=fdfa6a1";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-smali";
      rev = "fdfa6a1febc43c7467aa7e937b87b607956f2346";
      hash = "sha256-S0U6Xuntz16DrpYwSqMQu8Cu7UuD/JufHUxIHv826yw=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-smali";
  };
  smithy = buildGrammar {
    language = "smithy";
    version = "0.0.0+rev=fa898ac";
    src = fetchFromGitHub {
      owner = "indoorvivants";
      repo = "tree-sitter-smithy";
      rev = "fa898ac0885d1da9a253695c3e0e91f5efc587cd";
      hash = "sha256-tB+q4RNru4Zi3jU9fBLKdzsXT0uP1PECLfeCCNTyaIo=";
    };
    meta.homepage = "https://github.com/indoorvivants/tree-sitter-smithy";
  };
  snakemake = buildGrammar {
    language = "snakemake";
    version = "0.0.0+rev=f36c158";
    src = fetchFromGitHub {
      owner = "osthomas";
      repo = "tree-sitter-snakemake";
      rev = "f36c1587624d6d84376c82a357c20fc319cbf02c";
      hash = "sha256-yiEfMB67bIaIj+iXQ/ShvVQES6HCWnKI6DzWxsrIrRk=";
    };
    meta.homepage = "https://github.com/osthomas/tree-sitter-snakemake";
  };
  solidity = buildGrammar {
    language = "solidity";
    version = "0.0.0+rev=d38dcd0";
    src = fetchFromGitHub {
      owner = "JoranHonig";
      repo = "tree-sitter-solidity";
      rev = "d38dcd0b58b223c43e3f9265914fb3167dc624c6";
      hash = "sha256-NdulFV/uu6qqZGeUrnNe11aG7Q9Qmr0RU5aUbeu3pL8=";
    };
    meta.homepage = "https://github.com/JoranHonig/tree-sitter-solidity";
  };
  soql = buildGrammar {
    language = "soql";
    version = "0.0.0+rev=3597575";
    src = fetchFromGitHub {
      owner = "aheber";
      repo = "tree-sitter-sfapex";
      rev = "3597575a429766dd7ecce9f5bb97f6fec4419d5d";
      hash = "sha256-TOytPX/jBdVDYHBacpT9hAVVZcW+XGvIsubAqs9Dm80=";
    };
    location = "soql";
    meta.homepage = "https://github.com/aheber/tree-sitter-sfapex";
  };
  sosl = buildGrammar {
    language = "sosl";
    version = "0.0.0+rev=3597575";
    src = fetchFromGitHub {
      owner = "aheber";
      repo = "tree-sitter-sfapex";
      rev = "3597575a429766dd7ecce9f5bb97f6fec4419d5d";
      hash = "sha256-TOytPX/jBdVDYHBacpT9hAVVZcW+XGvIsubAqs9Dm80=";
    };
    location = "sosl";
    meta.homepage = "https://github.com/aheber/tree-sitter-sfapex";
  };
  sourcepawn = buildGrammar {
    language = "sourcepawn";
    version = "0.0.0+rev=f2af8d0";
    src = fetchFromGitHub {
      owner = "nilshelmig";
      repo = "tree-sitter-sourcepawn";
      rev = "f2af8d0dc14c6790130cceb2a20027eb41a8297c";
      hash = "sha256-u8/wM2Dj+uO3g24MsGZfH9zkABCEaWWFI8EX3fxuljk=";
    };
    meta.homepage = "https://github.com/nilshelmig/tree-sitter-sourcepawn";
  };
  sparql = buildGrammar {
    language = "sparql";
    version = "0.0.0+rev=d853661";
    src = fetchFromGitHub {
      owner = "GordianDziwis";
      repo = "tree-sitter-sparql";
      rev = "d853661ca680d8ff7f8d800182d5782b61d0dd58";
      hash = "sha256-0BV0y8IyeIPpuxTixlJL1PsDCuhXbGaImu8JU8WFoPU=";
    };
    meta.homepage = "https://github.com/GordianDziwis/tree-sitter-sparql";
  };
  sql = buildGrammar {
    language = "sql";
    version = "0.0.0+rev=b9d1095";
    src = fetchFromGitHub {
      owner = "derekstride";
      repo = "tree-sitter-sql";
      rev = "b9d109588d5b5ed986c857464830c2f0bef53f18";
      hash = "sha256-uEiwHIlLC6AyqD3/fH9KmXMdgQUb30MwBGrjPoyAPbc=";
    };
    meta.homepage = "https://github.com/derekstride/tree-sitter-sql";
  };
  squirrel = buildGrammar {
    language = "squirrel";
    version = "0.0.0+rev=072c969";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-squirrel";
      rev = "072c969749e66f000dba35a33c387650e203e96e";
      hash = "sha256-tJBmxTD4hi9zxXMEuAX+uslo45zEawh09+tgv56s/AU=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-squirrel";
  };
  ssh_config = buildGrammar {
    language = "ssh_config";
    version = "0.0.0+rev=0dd3c7e";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-ssh-config";
      rev = "0dd3c7e9f301758f6c69a6efde43d3048deb4d8a";
      hash = "sha256-jNB9cHOfHDIRPELm8LedJjNzjx16/ApcPGi8eaaJKZs=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-ssh-config";
  };
  starlark = buildGrammar {
    language = "starlark";
    version = "0.0.0+rev=a453dbf";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-starlark";
      rev = "a453dbf3ba433db0e5ec621a38a7e59d72e4dc69";
      hash = "sha256-iBchBq9NE4QqHc8MbWs4YgzUH6EB0W7RCIk07I6Zm+I=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-starlark";
  };
  strace = buildGrammar {
    language = "strace";
    version = "0.0.0+rev=d819cdd";
    src = fetchFromGitHub {
      owner = "sigmaSd";
      repo = "tree-sitter-strace";
      rev = "d819cdd5dbe455bd3c859193633c8d91c0df7c36";
      hash = "sha256-u2LznohljEq7WEoVbwr1ZyV+qbchDuoktJFCeh4iePg=";
    };
    meta.homepage = "https://github.com/sigmaSd/tree-sitter-strace";
  };
  styled = buildGrammar {
    language = "styled";
    version = "0.0.0+rev=319cdca";
    src = fetchFromGitHub {
      owner = "mskelton";
      repo = "tree-sitter-styled";
      rev = "319cdcaa0346ba6db668a222d938e5c3569e2a51";
      hash = "sha256-sKRSgN5mSF+uolWD6iKrCR83Ssroytr8ZGduTTyyxGQ=";
    };
    meta.homepage = "https://github.com/mskelton/tree-sitter-styled";
  };
  supercollider = buildGrammar {
    language = "supercollider";
    version = "0.0.0+rev=1a8ee0d";
    src = fetchFromGitHub {
      owner = "madskjeldgaard";
      repo = "tree-sitter-supercollider";
      rev = "1a8ee0da9a4f2df5a8a22f4d637ac863623a78a7";
      hash = "sha256-G23AZO1zvTvRE9ciV7qMuSoaCYulhyOkwiRwgK06NRQ=";
    };
    meta.homepage = "https://github.com/madskjeldgaard/tree-sitter-supercollider";
  };
  superhtml = buildGrammar {
    language = "superhtml";
    version = "0.0.0+rev=16887e9";
    src = fetchFromGitHub {
      owner = "kristoff-it";
      repo = "superhtml";
      rev = "16887e9fa3122c36a3d4942470e33c1c282fe859";
      hash = "sha256-XK3a+FTdVC7VAyZ8/I5rxipx4kDoppRNlpOMm/7emrQ=";
    };
    location = "tree-sitter-superhtml";
    meta.homepage = "https://github.com/kristoff-it/superhtml";
  };
  surface = buildGrammar {
    language = "surface";
    version = "0.0.0+rev=f4586b3";
    src = fetchFromGitHub {
      owner = "connorlay";
      repo = "tree-sitter-surface";
      rev = "f4586b35ac8548667a9aaa4eae44456c1f43d032";
      hash = "sha256-Fn/pF8yvU+Ll7WmoMHnEcNxb3dsfNhuKhXA1UgXeviA=";
    };
    meta.homepage = "https://github.com/connorlay/tree-sitter-surface";
  };
  svelte = buildGrammar {
    language = "svelte";
    version = "0.0.0+rev=ae5199d";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-svelte";
      rev = "ae5199db47757f785e43a14b332118a5474de1a2";
      hash = "sha256-cH9h7i6MImw7KlcuVQ6XVKNjd9dFjo93J1JdTWmEpV4=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-svelte";
  };
  sway = buildGrammar {
    language = "sway";
    version = "0.0.0+rev=3950067";
    src = fetchFromGitHub {
      owner = "FuelLabs";
      repo = "tree-sitter-sway";
      rev = "395006713db3bbb90d267ebdfcbf1881b399b05c";
      hash = "sha256-5Js5WbpQAln6cfdjEd0emMtkC6uFGWA2LXQZkiXbap4=";
    };
    meta.homepage = "https://github.com/FuelLabs/tree-sitter-sway.git";
  };
  swift = buildGrammar {
    language = "swift";
    version = "0.0.0+rev=aca5a52";
    src = fetchFromGitHub {
      owner = "alex-pinkus";
      repo = "tree-sitter-swift";
      rev = "aca5a52aa3cab858944d3c02701ccf5b2d8fd0f9";
      hash = "sha256-F0Fijad6Yry71Xc5b92EiqgtEkvVqRM8WKRt6U07TxY=";
    };
    generate = true;
    meta.homepage = "https://github.com/alex-pinkus/tree-sitter-swift";
  };
  sxhkdrc = buildGrammar {
    language = "sxhkdrc";
    version = "0.0.0+rev=440d5f9";
    src = fetchFromGitHub {
      owner = "RaafatTurki";
      repo = "tree-sitter-sxhkdrc";
      rev = "440d5f913d9465c9c776a1bd92334d32febcf065";
      hash = "sha256-AGhGYomrMe6Wj+EHLQT4v0BiU4jxhxXpVQkU2xU/1ZI=";
    };
    meta.homepage = "https://github.com/RaafatTurki/tree-sitter-sxhkdrc";
  };
  systemtap = buildGrammar {
    language = "systemtap";
    version = "0.0.0+rev=f2b378a";
    src = fetchFromGitHub {
      owner = "ok-ryoko";
      repo = "tree-sitter-systemtap";
      rev = "f2b378a9af0b7e1192cff67a5fb45508c927205d";
      hash = "sha256-HzV6RZMTSa41Q5hMiM1FwiHLbho62fuywtKzqrwjNDQ=";
    };
    meta.homepage = "https://github.com/ok-ryoko/tree-sitter-systemtap";
  };
  t32 = buildGrammar {
    language = "t32";
    version = "0.0.0+rev=e5a12f7";
    src = fetchFromGitLab {
      owner = "xasc";
      repo = "tree-sitter-t32";
      rev = "e5a12f798f056049642aa03fbb83786e3a5b95d4";
      hash = "sha256-oOykmtAFPQiqK02nia8/m8pg2fi5yKt7dzZOGr9f3dQ=";
    };
    meta.homepage = "https://gitlab.com/xasc/tree-sitter-t32.git";
  };
  tablegen = buildGrammar {
    language = "tablegen";
    version = "0.0.0+rev=b117088";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-tablegen";
      rev = "b1170880c61355aaf38fc06f4af7d3c55abdabc4";
      hash = "sha256-uJCn2RdTnOf/guBUhfodgQ8pMshNh+xUJZunoLwNgrM=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-tablegen";
  };
  tact = buildGrammar {
    language = "tact";
    version = "0.0.0+rev=47af202";
    src = fetchFromGitHub {
      owner = "tact-lang";
      repo = "tree-sitter-tact";
      rev = "47af20264abbd24ea282ded0f8ee9cad3cf3bf2f";
      hash = "sha256-Zrnkvm1WjAlxuk2dEojIx0ldWqdv6gxMl/f9w6TsqBE=";
    };
    meta.homepage = "https://github.com/tact-lang/tree-sitter-tact";
  };
  tcl = buildGrammar {
    language = "tcl";
    version = "0.0.0+rev=f15e711";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-tcl";
      rev = "f15e711167661d1ba541d4f62b9dbfc4ce61ec56";
      hash = "sha256-173xUAc2/LMDQSTEM3l3R4UuF/R5fdUyhEpXv6Eh02s=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-tcl";
  };
  teal = buildGrammar {
    language = "teal";
    version = "0.0.0+rev=3db6559";
    src = fetchFromGitHub {
      owner = "euclidianAce";
      repo = "tree-sitter-teal";
      rev = "3db655924b2ff1c54fdf6371b5425ea6b5dccefe";
      hash = "sha256-9RX7QMrG8+EZQ5yeYGeAGxRz8wqPP6p1GcSyDY4OvlY=";
    };
    generate = true;
    meta.homepage = "https://github.com/euclidianAce/tree-sitter-teal";
  };
  templ = buildGrammar {
    language = "templ";
    version = "0.0.0+rev=def9849";
    src = fetchFromGitHub {
      owner = "vrischmann";
      repo = "tree-sitter-templ";
      rev = "def9849184de71a797c4e2b2837df85abeccf92c";
      hash = "sha256-LeCLVE0TxKIwkR1x1p4ZFUC/Q/qpOE64Ycn/GaWrZYA=";
    };
    meta.homepage = "https://github.com/vrischmann/tree-sitter-templ";
  };
  tera = buildGrammar {
    language = "tera";
    version = "0.0.0+rev=25a7c61";
    src = fetchFromGitHub {
      owner = "uncenter";
      repo = "tree-sitter-tera";
      rev = "25a7c617192253bddfa65e378975d8c476419010";
      hash = "sha256-5ahHmvvuOY+1FhfOdbNIQokodfG1WXG1gK7BA1sEyYk=";
    };
    meta.homepage = "https://github.com/uncenter/tree-sitter-tera";
  };
  terraform = buildGrammar {
    language = "terraform";
    version = "0.0.0+rev=de10d49";
    src = fetchFromGitHub {
      owner = "MichaHoffmann";
      repo = "tree-sitter-hcl";
      rev = "de10d494dbd6b71cdf07a678fecbf404dbfe4398";
      hash = "sha256-oRNNxE5AnI0TyJl92pk0E9xGj5xom/+0kpPMUE/O/TY=";
    };
    location = "dialects/terraform";
    meta.homepage = "https://github.com/MichaHoffmann/tree-sitter-hcl";
  };
  textproto = buildGrammar {
    language = "textproto";
    version = "0.0.0+rev=568471b";
    src = fetchFromGitHub {
      owner = "PorterAtGoogle";
      repo = "tree-sitter-textproto";
      rev = "568471b80fd8793d37ed01865d8c2208a9fefd1b";
      hash = "sha256-VAj8qSxbkFqNp0X8BOZNvGTggSXZvzDjODedY11J0BQ=";
    };
    meta.homepage = "https://github.com/PorterAtGoogle/tree-sitter-textproto";
  };
  thrift = buildGrammar {
    language = "thrift";
    version = "0.0.0+rev=68fd0d8";
    src = fetchFromGitHub {
      owner = "duskmoon314";
      repo = "tree-sitter-thrift";
      rev = "68fd0d80943a828d9e6f49c58a74be1e9ca142cf";
      hash = "sha256-owZbs8ttjKrqTA8fQ/NmBGyIUUItSUvvW4hRv0NPV8Y=";
    };
    meta.homepage = "https://github.com/duskmoon314/tree-sitter-thrift";
  };
  tiger = buildGrammar {
    language = "tiger";
    version = "0.0.0+rev=4a77b2d";
    src = fetchFromGitHub {
      owner = "ambroisie";
      repo = "tree-sitter-tiger";
      rev = "4a77b2d7a004587646bddc4e854779044b6db459";
      hash = "sha256-jLdJ3nLShoBxVCcUbnaswYG5d4UU8aaE1xexb2LnmTQ=";
    };
    meta.homepage = "https://github.com/ambroisie/tree-sitter-tiger";
  };
  tlaplus = buildGrammar {
    language = "tlaplus";
    version = "0.0.0+rev=4ba91b0";
    src = fetchFromGitHub {
      owner = "tlaplus-community";
      repo = "tree-sitter-tlaplus";
      rev = "4ba91b07b97741a67f61221d0d50e6d962e4987e";
      hash = "sha256-Oc+VYBLP1XcfMTWmcYyJRXzq1Ty838TnF2fPGIsjtOE=";
    };
    meta.homepage = "https://github.com/tlaplus-community/tree-sitter-tlaplus";
  };
  tmux = buildGrammar {
    language = "tmux";
    version = "0.0.0+rev=0252ecd";
    src = fetchFromGitHub {
      owner = "Freed-Wu";
      repo = "tree-sitter-tmux";
      rev = "0252ecd080016e45e6305ef1a943388f5ae2f4b4";
      hash = "sha256-8f78qYxqoiOAnl3HzEbF4Rci3rFy0SnELoU+QP7pUlk=";
    };
    meta.homepage = "https://github.com/Freed-Wu/tree-sitter-tmux";
  };
  todotxt = buildGrammar {
    language = "todotxt";
    version = "0.0.0+rev=3937c5c";
    src = fetchFromGitHub {
      owner = "arnarg";
      repo = "tree-sitter-todotxt";
      rev = "3937c5cd105ec4127448651a21aef45f52d19609";
      hash = "sha256-OeAh51rcFTiexAraRzIZUR/A8h9RPwKY7rmtc3ZzoRQ=";
    };
    meta.homepage = "https://github.com/arnarg/tree-sitter-todotxt";
  };
  toml = buildGrammar {
    language = "toml";
    version = "0.0.0+rev=64b5683";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-toml";
      rev = "64b56832c2cffe41758f28e05c756a3a98d16f41";
      hash = "sha256-m9RlGkHiOL/PNENrdEPqtPlahSqGymsx7gZrCoN/Lsk=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-toml";
  };
  tsv = buildGrammar {
    language = "tsv";
    version = "0.0.0+rev=7eb7297";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-csv";
      rev = "7eb7297823605392d2bbcc4c09b1cd18d6fa9529";
      hash = "sha256-5VL7uREH0lloAWo9rdJXsjDsWxgL6fngWJSmi4fM7UQ=";
    };
    location = "tsv";
    meta.homepage = "https://github.com/amaanq/tree-sitter-csv";
  };
  tsx = buildGrammar {
    language = "tsx";
    version = "0.0.0+rev=75b3874";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-typescript";
      rev = "75b3874edb2dc714fb1fd77a32013d0f8699989f";
      hash = "sha256-A0M6IBoY87ekSV4DfGHDU5zzFWdLjGqSyVr6VENgA+s=";
    };
    location = "tsx";
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-typescript";
  };
  turtle = buildGrammar {
    language = "turtle";
    version = "0.0.0+rev=7f789ea";
    src = fetchFromGitHub {
      owner = "GordianDziwis";
      repo = "tree-sitter-turtle";
      rev = "7f789ea7ef765080f71a298fc96b7c957fa24422";
      hash = "sha256-z6f73euFAG9du5owz7V9WLbWK81Jg0DwxN1metKPbTA=";
    };
    meta.homepage = "https://github.com/GordianDziwis/tree-sitter-turtle";
  };
  twig = buildGrammar {
    language = "twig";
    version = "0.0.0+rev=085648e";
    src = fetchFromGitHub {
      owner = "gbprod";
      repo = "tree-sitter-twig";
      rev = "085648e01d1422163a1702a44e72303b4e2a0bd1";
      hash = "sha256-87jFYAAnblTeEdlXqTjyiiNee/OgasPam1b2xyKQIHY=";
    };
    meta.homepage = "https://github.com/gbprod/tree-sitter-twig";
  };
  typescript = buildGrammar {
    language = "typescript";
    version = "0.0.0+rev=75b3874";
    src = fetchFromGitHub {
      owner = "tree-sitter";
      repo = "tree-sitter-typescript";
      rev = "75b3874edb2dc714fb1fd77a32013d0f8699989f";
      hash = "sha256-A0M6IBoY87ekSV4DfGHDU5zzFWdLjGqSyVr6VENgA+s=";
    };
    location = "typescript";
    meta.homepage = "https://github.com/tree-sitter/tree-sitter-typescript";
  };
  typespec = buildGrammar {
    language = "typespec";
    version = "0.0.0+rev=42fb163";
    src = fetchFromGitHub {
      owner = "happenslol";
      repo = "tree-sitter-typespec";
      rev = "42fb163442ef2691b9b720fb4e4e846809415d18";
      hash = "sha256-yWXfDC4etuXn1jV8DsSSL028LUXSnsvCaog6ggtd8ro=";
    };
    meta.homepage = "https://github.com/happenslol/tree-sitter-typespec";
  };
  typoscript = buildGrammar {
    language = "typoscript";
    version = "0.0.0+rev=5d8fde8";
    src = fetchFromGitHub {
      owner = "Teddytrombone";
      repo = "tree-sitter-typoscript";
      rev = "5d8fde870b0ded1f429ba5bb249a9d9f8589ff5f";
      hash = "sha256-GysGb879dk5e1U6OO26q1gVAhkWxc/GRpkNN785ZoQw=";
    };
    meta.homepage = "https://github.com/Teddytrombone/tree-sitter-typoscript";
  };
  typst = buildGrammar {
    language = "typst";
    version = "0.0.0+rev=46cf4de";
    src = fetchFromGitHub {
      owner = "uben0";
      repo = "tree-sitter-typst";
      rev = "46cf4ded12ee974a70bf8457263b67ad7ee0379d";
      hash = "sha256-s/9R3DKA6dix6BkU4mGXaVggE4bnzOyu20T1wuqHQxk=";
    };
    meta.homepage = "https://github.com/uben0/tree-sitter-typst";
  };
  udev = buildGrammar {
    language = "udev";
    version = "0.0.0+rev=18a1d18";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-udev";
      rev = "18a1d183c4c0cc40438bae2ebf8191aaf2dee8dc";
      hash = "sha256-ySo+vS+il1tmTPZ6OJMduyJxsjjI3eIkYSMYs10Bcnk=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-udev";
  };
  ungrammar = buildGrammar {
    language = "ungrammar";
    version = "0.0.0+rev=debd26f";
    src = fetchFromGitHub {
      owner = "Philipp-M";
      repo = "tree-sitter-ungrammar";
      rev = "debd26fed283d80456ebafa33a06957b0c52e451";
      hash = "sha256-ftvcD8I+hYqH3EGxaRZ0w8FHjBA34OSTTsrUsAOtayU=";
    };
    meta.homepage = "https://github.com/Philipp-M/tree-sitter-ungrammar";
  };
  unison = buildGrammar {
    language = "unison";
    version = "0.0.0+rev=169e7f7";
    src = fetchFromGitHub {
      owner = "kylegoetz";
      repo = "tree-sitter-unison";
      rev = "169e7f748a540ec360c0cb086b448faad012caa4";
      hash = "sha256-0HOLtLh1zRdaGQqchT5zFegWKJHkQe9r7DGKL6sSkPo=";
    };
    generate = true;
    meta.homepage = "https://github.com/kylegoetz/tree-sitter-unison";
  };
  usd = buildGrammar {
    language = "usd";
    version = "0.0.0+rev=4e0875f";
    src = fetchFromGitHub {
      owner = "ColinKennedy";
      repo = "tree-sitter-usd";
      rev = "4e0875f724d94d0c2ff36f9b8cb0b12f8b20d216";
      hash = "sha256-r6Sm8FiTgxdYc5cAG5JXVtA5/2jID5H/xmKbjSYn/zI=";
    };
    meta.homepage = "https://github.com/ColinKennedy/tree-sitter-usd";
  };
  uxntal = buildGrammar {
    language = "uxntal";
    version = "0.0.0+rev=ad9b638";
    src = fetchFromGitHub {
      owner = "amaanq";
      repo = "tree-sitter-uxntal";
      rev = "ad9b638b914095320de85d59c49ab271603af048";
      hash = "sha256-hR0EaYv1++MJ0pdBl3ZtyEljitnp5hgFWQa9F6b1KE4=";
    };
    meta.homepage = "https://github.com/amaanq/tree-sitter-uxntal";
  };
  v = buildGrammar {
    language = "v";
    version = "0.0.0+rev=26c2c4c";
    src = fetchFromGitHub {
      owner = "vlang";
      repo = "v-analyzer";
      rev = "26c2c4c2b3fb4f7a07ae78d298b36998b7ffa956";
      hash = "sha256-sKD4CoClychNS5B6JmnGCPLiNxWbOLt0t2PV30mvjoI=";
    };
    location = "tree_sitter_v";
    meta.homepage = "https://github.com/vlang/v-analyzer";
  };
  vala = buildGrammar {
    language = "vala";
    version = "0.0.0+rev=97e6db3";
    src = fetchFromGitHub {
      owner = "vala-lang";
      repo = "tree-sitter-vala";
      rev = "97e6db3c8c73b15a9541a458d8e797a07f588ef4";
      hash = "sha256-hAekweZGDHVrWVd04RrN+9Jz0D2kode+DpceTlUXii0=";
    };
    meta.homepage = "https://github.com/vala-lang/tree-sitter-vala";
  };
  vento = buildGrammar {
    language = "vento";
    version = "0.0.0+rev=3b32474";
    src = fetchFromGitHub {
      owner = "ventojs";
      repo = "tree-sitter-vento";
      rev = "3b32474bc29584ea214e4e84b47102408263fe0e";
      hash = "sha256-h8yC+MJIAH7DM69UQ8moJBmcmrSZkxvWrMb+NqtYB2Y=";
    };
    meta.homepage = "https://github.com/ventojs/tree-sitter-vento";
  };
  verilog = buildGrammar {
    language = "verilog";
    version = "0.0.0+rev=15fbf73";
    src = fetchFromGitHub {
      owner = "gmlarumbe";
      repo = "tree-sitter-systemverilog";
      rev = "15fbf73dafaffc89050d247857beb27500ea30e8";
      hash = "sha256-cCnFq2cL2lnTBXSVTVbHiGW/MDJARgqgGUjKmaTpOJI=";
    };
    meta.homepage = "https://github.com/gmlarumbe/tree-sitter-systemverilog";
  };
  vhdl = buildGrammar {
    language = "vhdl";
    version = "0.0.0+rev=35ed277";
    src = fetchFromGitHub {
      owner = "jpt13653903";
      repo = "tree-sitter-vhdl";
      rev = "35ed277d3e98836796bc764010dc3fb800d14ee4";
      hash = "sha256-BuPqRNzsPKaUwXNp10KoZwnW5+/rFQ/11TcY0DpNUuk=";
    };
    meta.homepage = "https://github.com/jpt13653903/tree-sitter-vhdl";
  };
  vhs = buildGrammar {
    language = "vhs";
    version = "0.0.0+rev=0c6fae9";
    src = fetchFromGitHub {
      owner = "charmbracelet";
      repo = "tree-sitter-vhs";
      rev = "0c6fae9d2cfc5b217bfd1fe84a7678f5917116db";
      hash = "sha256-o7Q/3wwiCjxO6hBfj1Wxoz2y6+wxLH+oCLiapox7+Hk=";
    };
    meta.homepage = "https://github.com/charmbracelet/tree-sitter-vhs";
  };
  vim = buildGrammar {
    language = "vim";
    version = "0.0.0+rev=11b688a";
    src = fetchFromGitHub {
      owner = "neovim";
      repo = "tree-sitter-vim";
      rev = "11b688a1f0e97c0c4e3dbabf4a38016335f4d237";
      hash = "sha256-UvH/k0gWEhrgxG1HnrdmaLHzygkaKk4hx2gK/6TZYNM=";
    };
    meta.homepage = "https://github.com/neovim/tree-sitter-vim";
  };
  vimdoc = buildGrammar {
    language = "vimdoc";
    version = "0.0.0+rev=2694c3d";
    src = fetchFromGitHub {
      owner = "neovim";
      repo = "tree-sitter-vimdoc";
      rev = "2694c3d27e2ca98a0ccde72f33887394300d524e";
      hash = "sha256-DAHOhNqd9DQ9KNkJdjbUmSV6qhTOmPrIaC/7rBNCqzY=";
    };
    meta.homepage = "https://github.com/neovim/tree-sitter-vimdoc";
  };
  vrl = buildGrammar {
    language = "vrl";
    version = "0.0.0+rev=274b3ce";
    src = fetchFromGitHub {
      owner = "belltoy";
      repo = "tree-sitter-vrl";
      rev = "274b3ce63f72aa8ffea18e7fc280d3062d28f0ba";
      hash = "sha256-R+wuG8UkvGA11uTiiUAdzzgjRv1ik4W+qh3YwIREUd4=";
    };
    meta.homepage = "https://github.com/belltoy/tree-sitter-vrl";
  };
  vue = buildGrammar {
    language = "vue";
    version = "0.0.0+rev=22bdfa6";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-vue";
      rev = "22bdfa6c9fc0f5ffa44c6e938ec46869ac8a99ff";
      hash = "sha256-LnmUtJJpBIZPTJqrQQ7WI8V44hPw3yxR+j2jR0pHIdY=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-vue";
  };
  wgsl = buildGrammar {
    language = "wgsl";
    version = "0.0.0+rev=40259f3";
    src = fetchFromGitHub {
      owner = "szebniok";
      repo = "tree-sitter-wgsl";
      rev = "40259f3c77ea856841a4e0c4c807705f3e4a2b65";
      hash = "sha256-voLkcJ/062hzipb3Ak/mgQvFbrLUJdnXq1IupzjMJXA=";
    };
    meta.homepage = "https://github.com/szebniok/tree-sitter-wgsl";
  };
  wgsl_bevy = buildGrammar {
    language = "wgsl_bevy";
    version = "0.0.0+rev=47c1818";
    src = fetchFromGitHub {
      owner = "theHamsta";
      repo = "tree-sitter-wgsl-bevy";
      rev = "47c1818d245a6156a488c4c4d06e9336714bae9b";
      hash = "sha256-oL9HDMDl6MgDLZw4NWtdX7W775JZKwD2BweAO+9iI/k=";
    };
    meta.homepage = "https://github.com/theHamsta/tree-sitter-wgsl-bevy";
  };
  wing = buildGrammar {
    language = "wing";
    version = "0.0.0+rev=76e0c25";
    src = fetchFromGitHub {
      owner = "winglang";
      repo = "tree-sitter-wing";
      rev = "76e0c25844a66ebc6e866d690fcc5f4e90698947";
      hash = "sha256-N16cZK1dERqFd1FR35AfrsBy5EeeOPSp0FaZ83pMt7I=";
    };
    meta.homepage = "https://github.com/winglang/tree-sitter-wing";
  };
  wit = buildGrammar {
    language = "wit";
    version = "0.0.0+rev=81490b4";
    src = fetchFromGitHub {
      owner = "liamwh";
      repo = "tree-sitter-wit";
      rev = "81490b4e74c792369e005f72b0d46fe082d3fed2";
      hash = "sha256-L8dIOVJ3L2TXg1l4BXMOQeOsNxVkGPZimG619n3kHZE=";
    };
    meta.homepage = "https://github.com/liamwh/tree-sitter-wit";
  };
  xcompose = buildGrammar {
    language = "xcompose";
    version = "0.0.0+rev=fff3e72";
    src = fetchFromGitHub {
      owner = "ObserverOfTime";
      repo = "tree-sitter-xcompose";
      rev = "fff3e72242aa110ebba6441946ea4d12d200fa68";
      hash = "sha256-PNg1z+7CuvpQdksKJOCQ59dZrv4PORdYo6CSw3GrBtk=";
    };
    meta.homepage = "https://github.com/ObserverOfTime/tree-sitter-xcompose";
  };
  xml = buildGrammar {
    language = "xml";
    version = "0.0.0+rev=0d9a809";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-xml";
      rev = "0d9a8099c963ed53e183425c1b47fa2622c8eaf7";
      hash = "sha256-0kqCDLCxsvrqu5pKrDZDJt9lSlxU6fzM/CxrWb/oodw=";
    };
    location = "xml";
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-xml";
  };
  xresources = buildGrammar {
    language = "xresources";
    version = "0.0.0+rev=d0f9dc7";
    src = fetchFromGitHub {
      owner = "ValdezFOmar";
      repo = "tree-sitter-xresources";
      rev = "d0f9dc7cec4dc15fc6f9d556bb4e9dd5050328a6";
      hash = "sha256-3TBpNdIsmOutazBlMKAsQaq7RPu4vUeZMFuZ2/2HDKo=";
    };
    meta.homepage = "https://github.com/ValdezFOmar/tree-sitter-xresources";
  };
  yaml = buildGrammar {
    language = "yaml";
    version = "0.0.0+rev=1805917";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-yaml";
      rev = "1805917414a9a8ba2473717fd69447277a175fae";
      hash = "sha256-lcdlvzDhl0mDCe4olMoEynxFFLfn3w4p24C1k/7DItA=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-yaml";
  };
  yang = buildGrammar {
    language = "yang";
    version = "0.0.0+rev=2c0e6be";
    src = fetchFromGitHub {
      owner = "Hubro";
      repo = "tree-sitter-yang";
      rev = "2c0e6be8dd4dcb961c345fa35c309ad4f5bd3502";
      hash = "sha256-6EIK1EStHrUHBLZBsZqd1LL05ZAJ6PKUyIzBBsTVjO8=";
    };
    meta.homepage = "https://github.com/Hubro/tree-sitter-yang";
  };
  yuck = buildGrammar {
    language = "yuck";
    version = "0.0.0+rev=e877f6a";
    src = fetchFromGitHub {
      owner = "Philipp-M";
      repo = "tree-sitter-yuck";
      rev = "e877f6ade4b77d5ef8787075141053631ba12318";
      hash = "sha256-l8c1/7q8S78jGyl+VAVVgs8wq58PrrjycyJfWXsCgAI=";
    };
    meta.homepage = "https://github.com/Philipp-M/tree-sitter-yuck";
  };
  zathurarc = buildGrammar {
    language = "zathurarc";
    version = "0.0.0+rev=0554b4a";
    src = fetchFromGitHub {
      owner = "Freed-Wu";
      repo = "tree-sitter-zathurarc";
      rev = "0554b4a5d313244b7fc000cbb41c04afae4f4e31";
      hash = "sha256-edwLcz1WlcRJOoV2Unpho8wmi7TmcpwysBOAdRKprNw=";
    };
    meta.homepage = "https://github.com/Freed-Wu/tree-sitter-zathurarc";
  };
  zig = buildGrammar {
    language = "zig";
    version = "0.0.0+rev=b670c8d";
    src = fetchFromGitHub {
      owner = "tree-sitter-grammars";
      repo = "tree-sitter-zig";
      rev = "b670c8df85a1568f498aa5c8cae42f51a90473c0";
      hash = "sha256-lDMmnmeGr2ti9W692ZqySWObzSUa9vY7f+oHZiE8N+U=";
    };
    meta.homepage = "https://github.com/tree-sitter-grammars/tree-sitter-zig";
  };
  ziggy = buildGrammar {
    language = "ziggy";
    version = "0.0.0+rev=8a29017";
    src = fetchFromGitHub {
      owner = "kristoff-it";
      repo = "ziggy";
      rev = "8a29017169f43dc2c3526817e98142eb9a335087";
      hash = "sha256-w4qq/SBlRQw3r9iIZ2RY3infa/ysopOQX5QDS7+8kt8=";
    };
    location = "tree-sitter-ziggy";
    meta.homepage = "https://github.com/kristoff-it/ziggy";
  };
  ziggy_schema = buildGrammar {
    language = "ziggy_schema";
    version = "0.0.0+rev=8a29017";
    src = fetchFromGitHub {
      owner = "kristoff-it";
      repo = "ziggy";
      rev = "8a29017169f43dc2c3526817e98142eb9a335087";
      hash = "sha256-w4qq/SBlRQw3r9iIZ2RY3infa/ysopOQX5QDS7+8kt8=";
    };
    location = "tree-sitter-ziggy-schema";
    meta.homepage = "https://github.com/kristoff-it/ziggy";
  };
}
