# shellcheck shell=bash
set -e

export PATH="@binPath@:$PATH"

LOCKFILE_OUTPUT="$1"

genericBuild

nuget-to-json "${NUGET_PACKAGES%/}" >deps.json

if [[ "$LOCKFILE_OUTPUT" == *.nix ]]; then
    trap 'rm deps.json' exit

    (
        echo "# This file was automatically generated by passthru.fetch-deps."
        echo "# Please dont edit it manually, your changes might get overwritten!"
        echo -e "# TODO: This format file is obsolete, consider migrating to JSON.\n"
        nuget-to-nix --convert deps.json
    ) >deps.nix
    nixfmt deps.nix

    mv deps.nix "$LOCKFILE_OUTPUT"
else
    mv deps.json "$LOCKFILE_OUTPUT"
fi

echo "Succesfully wrote lockfile to $LOCKFILE_OUTPUT"
