/*
 *  Write through a TypedArray view
 */

/*@include util-buffer.js@*/
/*@include util-string.js@*/

/*---
{
    "custom": true,
    "endianness": "little",
    "slow": true
}
---*/

/*===
write TypedArray test, arrayLength 16
-100 undefined 34052171
-100 0 34717833
-100 1 34723113
-100 2 34728393
-100 3 34733673
-100 4 34738953
-100 5 34744233
-100 6 34749513
-100 7 34754793
-100 8 34760073
-100 100 35282499
-10 undefined 33533151
-10 0 34199241
-10 1 34204671
-10 2 34210101
-10 3 34215531
-10 4 34220961
-10 5 34226391
-10 6 34231821
-10 7 34237251
-10 8 34242681
-10 100 34671511
-9 undefined 33027681
-9 0 33702959
-9 1 33708275
-9 2 33713591
-9 3 33718907
-9 4 33724223
-9 5 33729539
-9 6 33734855
-9 7 33740171
-9 8 33745487
-9 100 34263615
-8 undefined 33016751
-8 0 33691963
-8 1 33697279
-8 2 33702595
-8 3 33707911
-8 4 33713227
-8 5 33718543
-8 6 33723859
-8 7 33729175
-8 8 33734491
-8 100 34252485
-7 undefined 33005821
-7 0 33680967
-7 1 33686283
-7 2 33691599
-7 3 33696915
-7 4 33702231
-7 5 33707547
-7 6 33712863
-7 7 33718179
-7 8 33723495
-7 100 34241355
-6 undefined 32994891
-6 0 33669971
-6 1 33675287
-6 2 33680603
-6 3 33685919
-6 4 33691235
-6 5 33696551
-6 6 33701867
-6 7 33707183
-6 8 33712499
-6 100 34230225
-5 undefined 32983961
-5 0 33658975
-5 1 33664291
-5 2 33669607
-5 3 33674923
-5 4 33680239
-5 5 33685555
-5 6 33690871
-5 7 33696187
-5 8 33701503
-5 100 34219095
-4 undefined 32973031
-4 0 33647979
-4 1 33653295
-4 2 33658611
-4 3 33663927
-4 4 33669243
-4 5 33674559
-4 6 33679875
-4 7 33685191
-4 8 33690507
-4 100 34207965
-3 undefined 32962101
-3 0 33636983
-3 1 33642299
-3 2 33647615
-3 3 33652931
-3 4 33658247
-3 5 33663563
-3 6 33668879
-3 7 33674195
-3 8 33679511
-3 100 34196835
-2 undefined 32951171
-2 0 33625987
-2 1 33631303
-2 2 33636619
-2 3 33641935
-2 4 33647251
-2 5 33652567
-2 6 33657883
-2 7 33663199
-2 8 33668515
-2 100 34185705
-1 undefined 32940241
-1 0 33614991
-1 1 33620307
-1 2 33625623
-1 3 33630939
-1 4 33636255
-1 5 33641571
-1 6 33646887
-1 7 33652203
-1 8 33657519
-1 100 34174575
0 undefined 35778667
0 0 35390235
0 1 35916845
0 2 36423891
0 3 36020133
0 4 36025625
0 5 34784193
0 6 34789753
0 7 34795313
0 8 34800873
0 100 33689235
1 undefined 33174169
1 0 33945905
1 1 34005803
1 2 34080455
1 3 34086357
1 4 34092259
1 5 34098161
1 6 34104063
1 7 34109965
1 8 34115867
1 100 33700559
2 undefined 34085055
2 0 34476411
2 1 34630887
2 2 34796373
2 3 34801933
2 4 34807493
2 5 34813053
2 6 34818613
2 7 34824173
2 8 34151269
2 100 33711883
3 undefined 33216403
3 0 33966137
3 1 34051321
3 2 34104643
3 3 34110545
3 4 34116447
3 5 34122349
3 6 34128251
3 7 34134153
3 8 34140055
3 100 33723207
4 undefined 35378937
4 0 35235391
4 1 35644212
4 2 36048383
4 3 36053875
4 4 34824557
4 5 34830117
4 6 34835677
4 7 34117197
4 8 34123099
4 100 33734531
5 undefined 33234287
5 0 33986369
5 1 34044481
5 2 34108557
5 3 34114459
5 4 34120361
5 5 34126263
5 6 34132165
5 7 34138067
5 8 34143969
5 100 33745855
6 undefined 34115833
6 0 34519659
6 1 34673893
6 2 34832609
6 3 34838169
6 4 34843729
6 5 34849289
6 6 34162537
6 7 34168439
6 8 34174341
6 100 33757179
7 undefined 33243715
7 0 34006601
7 1 34084969
7 2 34158657
7 3 34164559
7 4 34170461
7 5 34176363
7 6 34182265
7 7 34188167
7 8 34194069
7 100 33768503
8 undefined 35718878
8 0 35477419
8 1 35979659
8 2 36094191
8 3 34868537
8 4 34874097
8 5 34160607
8 6 34166509
8 7 34172411
8 8 34178313
8 100 33779827
9 undefined 33279741
9 0 34026833
9 1 34079329
9 2 34139227
9 3 34145129
9 4 34151031
9 5 34156933
9 6 34162835
9 7 34168737
9 8 33295067
9 100 33791151
10 undefined 34618447
10 0 34985929
10 1 35147669
10 2 35303291
10 3 35309013
10 4 34821459
10 5 34826937
10 6 34832415
10 7 33685159
10 8 33690475
10 100 34206565
11 undefined 33688635
11 0 34669381
11 1 34741749
11 2 34793733
11 3 34799211
11 4 34804689
11 5 34810167
11 6 33690839
11 7 33696155
11 8 33701471
11 100 34217695
12 undefined 35632832
12 0 35765795
12 1 36180536
12 2 35327173
12 3 34796851
12 4 34802329
12 5 33696519
12 6 33701835
12 7 33707151
12 8 33712467
12 100 34228825
13 undefined 33697427
13 0 34689357
13 1 34749377
13 2 34822607
13 3 34828085
13 4 33702199
13 5 33707515
13 6 33712831
13 7 33718147
13 8 33723463
13 100 34239955
14 undefined 34563123
14 0 35030273
14 1 35196511
14 2 34845881
14 3 33707879
14 4 33713195
14 5 33718511
14 6 33723827
14 7 33729143
14 8 33734459
14 100 34251085
15 undefined 33648773
15 0 34709333
15 1 34782639
15 2 33713559
15 3 33718875
15 4 33724191
15 5 33729507
15 6 33734823
15 7 33740139
15 8 33745455
15 100 34262215
16 undefined 35374493
16 0 36042427
16 1 33719239
16 2 33724555
16 3 33729871
16 4 33735187
16 5 33740503
16 6 33745819
16 7 33751135
16 8 33756451
16 100 34273345
17 undefined 33049253
17 0 33724919
17 1 33730235
17 2 33735551
17 3 33740867
17 4 33746183
17 5 33751499
17 6 33756815
17 7 33762131
17 8 33767447
17 100 34284475
100 undefined 33567635
100 0 34233563
100 1 34238993
100 2 34244423
100 3 34249853
100 4 34255283
100 5 34260713
100 6 34266143
100 7 34271573
100 8 34277003
100 100 34703211
write TypedArray test, arrayLength 17
-100 undefined 34612197
-100 0 35320321
-100 1 35326029
-100 2 35331737
-100 3 35337445
-100 4 35343153
-100 5 35348861
-100 6 35354569
-100 7 35360277
-100 8 35365985
-100 100 35790481
-10 undefined 34030991
-10 0 34732653
-10 1 34738583
-10 2 34744513
-10 3 34750443
-10 4 34756373
-10 5 34762303
-10 6 34768233
-10 7 34774163
-10 8 34780093
-10 100 35308059
-9 undefined 33643281
-9 0 34312261
-9 1 34318171
-9 2 34324081
-9 3 34329991
-9 4 34335901
-9 5 34341811
-9 6 34347721
-9 7 34353631
-9 8 34359541
-9 100 34889129
-8 undefined 33632075
-8 0 34301131
-8 1 34307041
-8 2 34312951
-8 3 34318861
-8 4 34324771
-8 5 34330681
-8 6 34336591
-8 7 34342501
-8 8 34348411
-8 100 34878495
-7 undefined 33620869
-7 0 34290001
-7 1 34295911
-7 2 34301821
-7 3 34307731
-7 4 34313641
-7 5 34319551
-7 6 34325461
-7 7 34331371
-7 8 34337281
-7 100 34867861
-6 undefined 33609663
-6 0 34278871
-6 1 34284781
-6 2 34290691
-6 3 34296601
-6 4 34302511
-6 5 34308421
-6 6 34314331
-6 7 34320241
-6 8 34326151
-6 100 34857227
-5 undefined 33598457
-5 0 34267741
-5 1 34273651
-5 2 34279561
-5 3 34285471
-5 4 34291381
-5 5 34297291
-5 6 34303201
-5 7 34309111
-5 8 34315021
-5 100 34846593
-4 undefined 33587251
-4 0 34256611
-4 1 34262521
-4 2 34268431
-4 3 34274341
-4 4 34280251
-4 5 34286161
-4 6 34292071
-4 7 34297981
-4 8 34303891
-4 100 34835959
-3 undefined 33576045
-3 0 34245481
-3 1 34251391
-3 2 34257301
-3 3 34263211
-3 4 34269121
-3 5 34275031
-3 6 34280941
-3 7 34286851
-3 8 34292761
-3 100 34825325
-2 undefined 33564839
-2 0 34234351
-2 1 34240261
-2 2 34246171
-2 3 34252081
-2 4 34257991
-2 5 34263901
-2 6 34269811
-2 7 34275721
-2 8 34281631
-2 100 34814691
-1 undefined 33553633
-1 0 34223221
-1 1 34229131
-1 2 34235041
-1 3 34240951
-1 4 34246861
-1 5 34252771
-1 6 34258681
-1 7 34264591
-1 8 34270501
-1 100 34804057
0 undefined 33754493
0 0 36060647
0 1 36570129
0 2 37079739
0 3 36598869
0 4 36604483
0 5 35321791
0 6 35327505
0 7 35333219
0 8 35338933
0 100 34215775
1 undefined 33738531
1 0 34774585
1 1 34838839
1 2 34917633
1 3 34923163
1 4 34928693
1 5 34934223
1 6 34939753
1 7 34945283
1 8 34950813
1 100 34226673
2 undefined 33758503
2 0 34999871
2 1 35161603
2 2 35317217
2 3 35322931
2 4 35328645
2 5 35334359
2 6 35340073
2 7 35345787
2 8 34969223
2 100 34237571
3 undefined 33790047
3 0 34795073
3 1 34867493
3 2 34919529
3 3 34925059
3 4 34930589
3 5 34936119
3 6 34941649
3 7 34947179
3 8 34952709
3 100 34248469
4 undefined 33806399
4 0 35802611
4 1 36217490
4 2 36637935
4 3 36643549
4 4 35351811
4 5 35357525
4 6 35363239
4 7 34945075
4 8 34950605
4 100 34259367
5 undefined 33798531
5 0 34815561
5 1 34875633
5 2 34948915
5 3 34954445
5 4 34959975
5 5 34965505
5 6 34971035
5 7 34976565
5 8 34982095
5 100 34270265
6 undefined 33790343
6 0 35042783
6 1 35209013
6 2 35362139
6 3 35367853
6 4 35373567
6 5 35379281
6 6 34994565
6 7 35000095
6 8 35005625
6 100 34281163
7 undefined 33816801
7 0 34836049
7 1 34909407
7 2 34971645
7 3 34977175
7 4 34982705
7 5 34988235
7 6 34993765
7 7 34999295
7 8 35004825
7 100 34292061
8 undefined 33852185
8 0 36145239
8 1 36671607
8 2 36680145
8 3 35385211
8 4 35390925
8 5 34985115
8 6 34990645
8 7 34996175
8 8 35001705
8 100 34302959
9 undefined 33848813
9 0 34856537
9 1 34916531
9 2 34980785
9 3 34986315
9 4 34991845
9 5 34997375
9 6 35002905
9 7 35008435
9 8 35013965
9 100 34313857
10 undefined 34567243
10 0 35568291
10 1 35724589
10 2 35892019
10 3 35897559
10 4 35251901
10 5 35257609
10 6 35263317
10 7 35269025
10 8 34302491
10 100 34838103
11 undefined 34610683
11 0 35116723
11 1 35191733
11 2 35258743
11 3 35264451
11 4 35270159
11 5 35275867
11 6 35281575
11 7 34307711
11 8 34313621
11 100 34848737
12 undefined 34613071
12 0 36323793
12 1 36727936
12 2 35908009
12 3 35259043
12 4 35264751
12 5 35270459
12 6 34312931
12 7 34318841
12 8 34324751
12 100 34859371
13 undefined 34593269
13 0 35137051
13 1 35196489
13 2 35260053
13 3 35265761
13 4 35271469
13 5 34318151
13 6 34324061
13 7 34329971
13 8 34335881
13 100 34870005
14 undefined 34606787
14 0 35612059
14 1 35769239
14 2 35280579
14 3 35286287
14 4 34323371
14 5 34329281
14 6 34335191
14 7 34341101
14 8 34347011
14 100 34880639
15 undefined 34636551
15 0 35157379
15 1 35227179
15 2 35298167
15 3 34328591
15 4 34334501
15 5 34340411
15 6 34346321
15 7 34352231
15 8 34358141
15 100 34891273
16 undefined 34591025
16 0 36611049
16 1 35238531
16 2 34333811
16 3 34339721
16 4 34345631
16 5 34351541
16 6 34357451
16 7 34363361
16 8 34369271
16 100 34901907
17 undefined 34532859
17 0 35177707
17 1 34339031
17 2 34344941
17 3 34350851
17 4 34356761
17 5 34362671
17 6 34368581
17 7 34374491
17 8 34380401
17 100 34912541
100 undefined 34062899
100 0 34764353
100 1 34770283
100 2 34776213
100 3 34782143
100 4 34788073
100 5 34794003
100 6 34799933
100 7 34805863
100 8 34811793
100 100 35340173
===*/

function writeTypedArrayTest(arrayLength) {
    [ -100, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7,
      8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 100 ].forEach(function (offset, idx1) {
        [ undefined, 0, 1, 2, 3, 4, 5, 6, 7, 8, 100 ].forEach(function (length, idx2) {
            var tmp = [];

            [ -0x100000000, -0xffffffff, -0xdeadbeef,
              -0x80000001, -0x80000000, -0x7fffffff, -0x10000, -0xffff, -0x8001,
              -0x8000, -0x7fff, -0x100, -0xff, -0x81, -0x80, -0x7f, -1, -0, 0, 1,
              0x7f, 0x80, 0x81, 0xff, 0x100, 0x7fff, 0x8000, 0x8001, 0xffff, 0x10000,
              0x7fffffff, 0x80000000, 0x80000001, 0xdeadbeef, 0xffffffff, 0x100000000,
              Number.NEGATIVE_INFINITY, Number.POSITIVE_INFINITY,

              // Leave NaN intentionally out because its representation is
              // platform and engine specific.

              2.1, 2.5, 2.9, 3.1, 3.5, 3.9, 4.1, 4.5, 4.9,
              -2.1, -2.5, -2.9, -3.1, -3.5, -3.9, -4.1, -4.5, -4.9,
            ].forEach(function (value, idx3) {
                [ 'Int8Array', 'Uint8Array', 'Uint8ClampedArray', 'Int16Array',
                  'Uint16Array', 'Int32Array', 'Uint32Array', 'Float32Array',
                  'Float64Array' ].forEach(function (consname) {
                    var evalstr;
                    var b, b_u8;
                    var i;

                    b = new ArrayBuffer(arrayLength);
                    b_u8 = new Uint8Array(b);

                    for (i = 0; i < b_u8.length; i++) {
                        b_u8[i] = 0x11;
                    }

                    evalstr = 'new ' + consname + '(b, ' + offset;
                    if (length !== undefined) {
                        evalstr += ', ' + length;
                    }
                    evalstr += ')';

                    tmp.push(offset + ' ' + value + ' ' + consname + ' ' + evalstr);
                    try {
                        // workaround because there's no programmatic 'construct' call
                        var v = eval(evalstr);
                        v[0] = value;
                        v[1] = value;
                        tmp.push(success);
                    } catch (e) {
                        tmp.push(e.name);
                    }
                    tmp.push(printableBuffer(b));
                });
            });

            print(offset, length, checksumString(tmp.join('\n')));
        });
    });
}

try {
    /* Attempt to create a view using default length fails if starting offset
     * is not aligned and the underlying ArrayBuffer doesn't end up evenly at
     * an element boundary.  Run the testcase with two ArrayBuffer lengths to
     * cover these cases properly.
     */

    print('write TypedArray test, arrayLength 16');
    writeTypedArrayTest(16);

    print('write TypedArray test, arrayLength 17');
    writeTypedArrayTest(17);
} catch (e) {
    print(e.stack || e);
}
