var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;

var jumlib = {};
Components.utils.import("resource://mozmill/modules/jum.js", jumlib);

Cu.import("resource://unity/unity-favicon-utils.js");

var topsrcDir;

function setupModule(module) {
    var localFile = Components.classes["@mozilla.org/file/local;1"]
        .createInstance(Components.interfaces.nsILocalFile);
    localFile.initWithPath(module.__file__);
    topsrcDir = localFile.parent.parent.path;

    module.controller = mozmill.getBrowserController();
}

function testGeneral(){
    controller.open(topsrcDir + '/html-tests/big-test/big-test.html');
    controller.waitForPageLoad();

    var icon = UnityFaviconUtils.getFaviconForDocument(controller.tabs.activeTab);
    jumlib.assertEquals(icon, 'http://example.com/test.ico');

    controller.open(topsrcDir + '/html-tests/big-test/big-test.html');
    controller.waitForPageLoad();
}
