------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--                 G N A T S Y N C . G L O B A L _ I N F O                  --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                    Copyright (C) 2007-2008, AdaCore                      --
--                                                                          --
-- GNATSYNC  is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATSYNC is maintained by AdaCore (http://www.adacore.com).              --
--                                                                          --
------------------------------------------------------------------------------

--  Defines the top-level routines for collecting the global information
--  from the argument sources.

with Asis;          use Asis;
with Asis.Iterator; use Asis.Iterator;

package Gnatsync.Global_Info is

   type Global_Info_Collection_State is record
      Level_Of_Nonexecutable_Construct : Natural := 0;
      --  Nonexecutable construct is any construct that does not result in any
      --  actions during the program execution. For example, a generic template
      --  and a type definition are nonexecutable constructs, and if they
      --  contain a subprogram call, this call can never be issued from their
      --  code, it can be issued only from the instantiation of this generic or
      --  from the declaration of an object of this type if the default
      --  expression defined in the type definition is really evaluated.

   end record;

   Initial_State : Global_Info_Collection_State := (
      Level_Of_Nonexecutable_Construct => 0);

   procedure Pre_Operation
     (Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Global_Info_Collection_State);

   procedure Post_Operation
     (Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Global_Info_Collection_State);

   procedure Collect_Global_Info is new Traverse_Element
     (Global_Info_Collection_State,
      Pre_Operation,
      Post_Operation);

end Gnatsync.Global_Info;
