/*
  Copyright (c) 2006-2010 Gordon Gremme <gremme@zbh.uni-hamburg.de>
  Copyright (c) 2006-2008 Center for Bioinformatics, University of Hamburg

  Permission to use, copy, modify, and distribute this software for any
  purpose with or without fee is hereby granted, provided that the above
  copyright notice and this permission notice appear in all copies.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

#ifndef PROGRESSBAR_H
#define PROGRESSBAR_H

/* Start showing a progress bar on stdout if possible. */
void gt_progressbar_start(const unsigned long long *current_computation,
                          unsigned long long number_of_computations);

/* Stop showing a progress bar. */
void gt_progressbar_stop(void);

#if 0
  a typical use of the progressbar:

  i = 0;
  gt_progressbar_start(&i, number_of_computations);
  for (; i < number_of_computations; i++) {
    /* perform the ith computation */
  }
  gt_progressbar_stop();

#endif

#endif
