/*
  Copyright (c) 2011-2012 Stefan Kurtz <kurtz@zbh.uni-hamburg.de>
  Copyright (c) 2011-2012 Center for Bioinformatics, University of Hamburg

  Permission to use, copy, modify, and distribute this software for any
  purpose with or without fee is hereby granted, provided that the above
  copyright notice and this permission notice appear in all copies.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

/*
  THIS FILE IS GENERATED by
  scripts/gen-esa-bottomup.rb
  --key rdjcv
  --reader
  --absolute
  --no_process_lcpinterval.
  DO NOT EDIT.
*/

#include <limits.h>
#include "core/ma.h"
#include "esa-seqread.h"
/* no include for seqnumrelpos.h */

static void initBUinfo_rdjcv(GtBUinfo_rdjcv *,GtBUstate_rdjcv *);

static void freeBUinfo_rdjcv(GtBUinfo_rdjcv *,GtBUstate_rdjcv *);

static int processleafedge_rdjcv(bool,
    unsigned long,
    GtBUinfo_rdjcv *,
    unsigned long, /* position */
    GtBUstate_rdjcv *,
    GtError *err);

static int processbranchingedge_rdjcv(bool firstsucc,
    unsigned long,
    GtBUinfo_rdjcv *,
    unsigned long,
    unsigned long,
    GtBUinfo_rdjcv *,
    GtBUstate_rdjcv *,
    GtError *);

/* no declaration of processlcpinterval_rdjcv */

#define TOP_ESA_BOTTOMUP_rdjcv\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo-1]

#define POP_ESA_BOTTOMUP_rdjcv\
        (stack->spaceGtBUItvinfo + (--stack->nextfreeGtBUItvinfo))

#define PUSH_ESA_BOTTOMUP_rdjcv(LCP,LB)\
        if (stack->nextfreeGtBUItvinfo >= stack->allocatedGtBUItvinfo)\
        {\
          gt_assert(stack->nextfreeGtBUItvinfo ==\
                    stack->allocatedGtBUItvinfo);\
          stack->spaceGtBUItvinfo\
            = allocateBUstack_rdjcv(stack->spaceGtBUItvinfo,\
                              stack->allocatedGtBUItvinfo,\
                              stack->allocatedGtBUItvinfo+incrementstacksize,\
                              bustate);\
          stack->allocatedGtBUItvinfo += incrementstacksize;\
        }\
        gt_assert(stack->spaceGtBUItvinfo != NULL);\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo].lcp = LCP;\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo].lb = LB;\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo++].rb = ULONG_MAX

typedef struct
{
  unsigned long lcp, lb, rb;
  GtBUinfo_rdjcv info;
} GtBUItvinfo_rdjcv;

typedef struct
{
  GtBUItvinfo_rdjcv *spaceGtBUItvinfo;
  unsigned long allocatedGtBUItvinfo,
                nextfreeGtBUItvinfo;
} GtArrayGtBUItvinfo_rdjcv;

GtArrayGtBUItvinfo_rdjcv *gt_GtArrayGtBUItvinfo_new_rdjcv(void)
{
  GtArrayGtBUItvinfo_rdjcv *stack = gt_malloc(sizeof (*stack));

  stack->spaceGtBUItvinfo = NULL;
  stack->allocatedGtBUItvinfo = stack->nextfreeGtBUItvinfo = 0;
  return stack;
}

void gt_GtArrayGtBUItvinfo_delete_rdjcv(GtArrayGtBUItvinfo_rdjcv *stack,
                                  GtBUstate_rdjcv *state)
{
  unsigned long idx;

  for (idx=0; idx<stack->allocatedGtBUItvinfo; idx++)
  {
    freeBUinfo_rdjcv(&stack->spaceGtBUItvinfo[idx].info,state);
  }
  gt_free(stack->spaceGtBUItvinfo);
  gt_free(stack);
}

static GtBUItvinfo_rdjcv *allocateBUstack_rdjcv(GtBUItvinfo_rdjcv *ptr,
                                   unsigned long currentallocated,
                                   unsigned long allocated,
                                   GtBUstate_rdjcv *state)
{
  unsigned long idx;
  GtBUItvinfo_rdjcv *itvinfo;

  itvinfo = gt_realloc(ptr,sizeof (*itvinfo) * allocated);
  gt_assert(allocated > currentallocated);
  for (idx=currentallocated; idx<allocated; idx++)
  {
    initBUinfo_rdjcv(&itvinfo[idx].info,state);
  }
  gt_assert(itvinfo != NULL);
  return itvinfo;
}

static int gt_esa_bottomup_rdjcv(Sequentialsuffixarrayreader *ssar,
                    GtBUstate_rdjcv *bustate,
                    /* no parameter snrp */
                    GtError *err)
{
  const unsigned long incrementstacksize = 32UL;
  unsigned long lcpvalue,
                previoussuffix = 0,
                idx,
                numberofsuffixes,
                lastsuftabvalue = 0;
  GtBUItvinfo_rdjcv *lastinterval = NULL;
  bool haserr = false, firstedge, firstedgefromroot = true;
  GtArrayGtBUItvinfo_rdjcv *stack;

  stack = gt_GtArrayGtBUItvinfo_new_rdjcv();
  PUSH_ESA_BOTTOMUP_rdjcv(0,0);
  numberofsuffixes = gt_Sequentialsuffixarrayreader_nonspecials(ssar);
  for (idx = 0; !haserr && idx < numberofsuffixes; idx++)
  {
    NEXTSEQUENTIALLCPTABVALUEWITHLAST(lcpvalue,lastsuftabvalue,ssar);
    NEXTSEQUENTIALSUFTABVALUE(previoussuffix,ssar);
    gt_assert(stack->nextfreeGtBUItvinfo > 0);
    if (lcpvalue <= TOP_ESA_BOTTOMUP_rdjcv.lcp)
    {
      if (TOP_ESA_BOTTOMUP_rdjcv.lcp > 0 || !firstedgefromroot)
      {
        firstedge = false;
      } else
      {
        firstedge = true;
        firstedgefromroot = false;
      }
      if (processleafedge_rdjcv(firstedge,
                          TOP_ESA_BOTTOMUP_rdjcv.lcp,
                          &TOP_ESA_BOTTOMUP_rdjcv.info,
                          previoussuffix,
                          bustate,
                          err) != 0)
      {
        haserr = true;
      }
    }
    gt_assert(lastinterval == NULL);
    while (!haserr && lcpvalue < TOP_ESA_BOTTOMUP_rdjcv.lcp)
    {
      lastinterval = POP_ESA_BOTTOMUP_rdjcv;
      lastinterval->rb = idx;
      /* no call to processlcpinterval_rdjcv */
      if (lcpvalue <= TOP_ESA_BOTTOMUP_rdjcv.lcp)
      {
        if (TOP_ESA_BOTTOMUP_rdjcv.lcp > 0 || !firstedgefromroot)
        {
          firstedge = false;
        } else
        {
          firstedge = true;
          firstedgefromroot = false;
        }
        if (processbranchingedge_rdjcv(firstedge,
                   TOP_ESA_BOTTOMUP_rdjcv.lcp,
                   &TOP_ESA_BOTTOMUP_rdjcv.info,
                   lastinterval->lcp,
                   lastinterval->rb - lastinterval->lb + 1,
                   &lastinterval->info,
                   bustate,
                   err) != 0)
        {
          haserr = true;
        }
        lastinterval = NULL;
      }
    }
    if (!haserr && lcpvalue > TOP_ESA_BOTTOMUP_rdjcv.lcp)
    {
      if (lastinterval != NULL)
      {
        unsigned long lastintervallb = lastinterval->lb;
        unsigned long lastintervallcp = lastinterval->lcp,
              lastintervalrb = lastinterval->rb;
        PUSH_ESA_BOTTOMUP_rdjcv(lcpvalue,lastintervallb);
        if (processbranchingedge_rdjcv(true,
                       TOP_ESA_BOTTOMUP_rdjcv.lcp,
                       &TOP_ESA_BOTTOMUP_rdjcv.info,
                       lastintervallcp,
                       lastintervalrb - lastintervallb + 1,
                       NULL,
                       bustate,
                       err) != 0)
        {
          haserr = true;
        }
        lastinterval = NULL;
      } else
      {
        PUSH_ESA_BOTTOMUP_rdjcv(lcpvalue,idx);
        if (processleafedge_rdjcv(true,
                            TOP_ESA_BOTTOMUP_rdjcv.lcp,
                            &TOP_ESA_BOTTOMUP_rdjcv.info,
                            previoussuffix,
                            bustate,
                            err) != 0)
        {
          haserr = true;
        }
      }
    }
  }
  gt_assert(stack->nextfreeGtBUItvinfo > 0);
  if (!haserr && TOP_ESA_BOTTOMUP_rdjcv.lcp > 0)
  {
    /* no assignment to lastsuftabvalue */
    if (processleafedge_rdjcv(false,
                        TOP_ESA_BOTTOMUP_rdjcv.lcp,
                        &TOP_ESA_BOTTOMUP_rdjcv.info,
                        lastsuftabvalue,
                        bustate,
                        err) != 0)
    {
      haserr = true;
    } else
    {
      TOP_ESA_BOTTOMUP_rdjcv.rb = idx;
      /* no call to processlcpinterval_rdjcv */
    }
  }
  gt_GtArrayGtBUItvinfo_delete_rdjcv(stack,bustate);
  return haserr ? -1 : 0;
}
