/*
  Copyright (c) 2011-2012 Stefan Kurtz <kurtz@zbh.uni-hamburg.de>
  Copyright (c) 2011-2012 Center for Bioinformatics, University of Hamburg

  Permission to use, copy, modify, and distribute this software for any
  purpose with or without fee is hereby granted, provided that the above
  copyright notice and this permission notice appear in all copies.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

/*
  THIS FILE IS GENERATED by
  scripts/gen-esa-bottomup.rb
  --key spmeq
  --no_process_lcpinterval.
  DO NOT EDIT.
*/

#include <limits.h>
#include "core/ma.h"
#include "esa-seqread.h"
#include "seqnumrelpos.h"

static void initBUinfo_spmeq(GtBUinfo_spmeq *,GtBUstate_spmeq *);

static void freeBUinfo_spmeq(GtBUinfo_spmeq *,GtBUstate_spmeq *);

static int processleafedge_spmeq(bool,
    unsigned long,
    GtBUinfo_spmeq *,
    unsigned long, /* seqnum */
    unsigned long, /* relpos */
    GtBUstate_spmeq *,
    GtError *err);

static int processbranchingedge_spmeq(bool firstsucc,
    unsigned long,
    GtBUinfo_spmeq *,
    unsigned long,
    unsigned long,
    GtBUinfo_spmeq *,
    GtBUstate_spmeq *,
    GtError *);

/* no declaration of processlcpinterval_spmeq */

#define TOP_ESA_BOTTOMUP_spmeq\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo-1]

#define POP_ESA_BOTTOMUP_spmeq\
        (stack->spaceGtBUItvinfo + (--stack->nextfreeGtBUItvinfo))

#define PUSH_ESA_BOTTOMUP_spmeq(LCP,LB)\
        if (stack->nextfreeGtBUItvinfo >= stack->allocatedGtBUItvinfo)\
        {\
          gt_assert(stack->nextfreeGtBUItvinfo ==\
                    stack->allocatedGtBUItvinfo);\
          stack->spaceGtBUItvinfo\
            = allocateBUstack_spmeq(stack->spaceGtBUItvinfo,\
                              stack->allocatedGtBUItvinfo,\
                              stack->allocatedGtBUItvinfo+incrementstacksize,\
                              bustate);\
          stack->allocatedGtBUItvinfo += incrementstacksize;\
        }\
        gt_assert(stack->spaceGtBUItvinfo != NULL);\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo].lcp = LCP;\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo].lb = LB;\
        stack->spaceGtBUItvinfo[stack->nextfreeGtBUItvinfo++].rb = ULONG_MAX

typedef struct
{
  unsigned long lcp, lb, rb;
  GtBUinfo_spmeq info;
} GtBUItvinfo_spmeq;

typedef struct
{
  GtBUItvinfo_spmeq *spaceGtBUItvinfo;
  unsigned long allocatedGtBUItvinfo,
                nextfreeGtBUItvinfo;
} GtArrayGtBUItvinfo_spmeq;

GtArrayGtBUItvinfo_spmeq *gt_GtArrayGtBUItvinfo_new_spmeq(void)
{
  GtArrayGtBUItvinfo_spmeq *stack = gt_malloc(sizeof (*stack));

  stack->spaceGtBUItvinfo = NULL;
  stack->allocatedGtBUItvinfo = stack->nextfreeGtBUItvinfo = 0;
  return stack;
}

void gt_GtArrayGtBUItvinfo_delete_spmeq(GtArrayGtBUItvinfo_spmeq *stack,
                                  GtBUstate_spmeq *state)
{
  unsigned long idx;

  for (idx=0; idx<stack->allocatedGtBUItvinfo; idx++)
  {
    freeBUinfo_spmeq(&stack->spaceGtBUItvinfo[idx].info,state);
  }
  gt_free(stack->spaceGtBUItvinfo);
  gt_free(stack);
}

static GtBUItvinfo_spmeq *allocateBUstack_spmeq(GtBUItvinfo_spmeq *ptr,
                                   unsigned long currentallocated,
                                   unsigned long allocated,
                                   GtBUstate_spmeq *state)
{
  unsigned long idx;
  GtBUItvinfo_spmeq *itvinfo;

  itvinfo = gt_realloc(ptr,sizeof (*itvinfo) * allocated);
  gt_assert(allocated > currentallocated);
  for (idx=currentallocated; idx<allocated; idx++)
  {
    initBUinfo_spmeq(&itvinfo[idx].info,state);
  }
  gt_assert(itvinfo != NULL);
  return itvinfo;
}

static int gt_esa_bottomup_RAM_spmeq(const unsigned long *bucketofsuffixes,
                        const uint16_t *lcptab_bucket,
                        unsigned long numberofsuffixes,
                        GtArrayGtBUItvinfo_spmeq *stack,
                        GtBUstate_spmeq *bustate,
                        const GtSeqnumrelpos *snrp,
                        GtError *err)
{
  const unsigned long incrementstacksize = 32UL;
  unsigned long lcpvalue,
                previoussuffix,
                idx;
  GtBUItvinfo_spmeq *lastinterval = NULL;
  bool haserr = false, firstedge, firstedgefromroot;

  PUSH_ESA_BOTTOMUP_spmeq(0,0);
  firstedgefromroot = true;
  gt_assert (numberofsuffixes > 0);
  for (idx = 0; !haserr && idx < numberofsuffixes-1; idx++)
  {
    lcpvalue = (unsigned long) lcptab_bucket[idx+1];
    previoussuffix = bucketofsuffixes[idx];
    gt_assert(stack->nextfreeGtBUItvinfo > 0);
    if (lcpvalue <= TOP_ESA_BOTTOMUP_spmeq.lcp)
    {
      if (TOP_ESA_BOTTOMUP_spmeq.lcp > 0 || !firstedgefromroot)
      {
        firstedge = false;
      } else
      {
        firstedge = true;
        firstedgefromroot = false;
      }
      if (processleafedge_spmeq(firstedge,
                          TOP_ESA_BOTTOMUP_spmeq.lcp,
                          &TOP_ESA_BOTTOMUP_spmeq.info,
                          gt_seqnumrelpos_decode_seqnum(snrp,previoussuffix),
                          gt_seqnumrelpos_decode_relpos(snrp,previoussuffix),
                          bustate,
                          err) != 0)
      {
        haserr = true;
      }
    }
    gt_assert(lastinterval == NULL);
    while (!haserr && lcpvalue < TOP_ESA_BOTTOMUP_spmeq.lcp)
    {
      lastinterval = POP_ESA_BOTTOMUP_spmeq;
      lastinterval->rb = idx;
      /* no call to processlcpinterval_spmeq */
      if (lcpvalue <= TOP_ESA_BOTTOMUP_spmeq.lcp)
      {
        if (TOP_ESA_BOTTOMUP_spmeq.lcp > 0 || !firstedgefromroot)
        {
          firstedge = false;
        } else
        {
          firstedge = true;
          firstedgefromroot = false;
        }
        if (processbranchingedge_spmeq(firstedge,
                   TOP_ESA_BOTTOMUP_spmeq.lcp,
                   &TOP_ESA_BOTTOMUP_spmeq.info,
                   lastinterval->lcp,
                   lastinterval->rb - lastinterval->lb + 1,
                   &lastinterval->info,
                   bustate,
                   err) != 0)
        {
          haserr = true;
        }
        lastinterval = NULL;
      }
    }
    if (!haserr && lcpvalue > TOP_ESA_BOTTOMUP_spmeq.lcp)
    {
      if (lastinterval != NULL)
      {
        unsigned long lastintervallb = lastinterval->lb;
        unsigned long lastintervallcp = lastinterval->lcp,
              lastintervalrb = lastinterval->rb;
        PUSH_ESA_BOTTOMUP_spmeq(lcpvalue,lastintervallb);
        if (processbranchingedge_spmeq(true,
                       TOP_ESA_BOTTOMUP_spmeq.lcp,
                       &TOP_ESA_BOTTOMUP_spmeq.info,
                       lastintervallcp,
                       lastintervalrb - lastintervallb + 1,
                       NULL,
                       bustate,
                       err) != 0)
        {
          haserr = true;
        }
        lastinterval = NULL;
      } else
      {
        PUSH_ESA_BOTTOMUP_spmeq(lcpvalue,idx);
        if (processleafedge_spmeq(true,
                            TOP_ESA_BOTTOMUP_spmeq.lcp,
                            &TOP_ESA_BOTTOMUP_spmeq.info,
                            gt_seqnumrelpos_decode_seqnum(snrp,previoussuffix),
                            gt_seqnumrelpos_decode_relpos(snrp,previoussuffix),
                            bustate,
                            err) != 0)
        {
          haserr = true;
        }
      }
    }
  }
  gt_assert(stack->nextfreeGtBUItvinfo > 0);
  if (!haserr && TOP_ESA_BOTTOMUP_spmeq.lcp > 0)
  {
    unsigned long lastsuftabvalue = bucketofsuffixes[numberofsuffixes-1];
    if (processleafedge_spmeq(false,
                        TOP_ESA_BOTTOMUP_spmeq.lcp,
                        &TOP_ESA_BOTTOMUP_spmeq.info,
                        gt_seqnumrelpos_decode_seqnum(snrp,lastsuftabvalue),
                        gt_seqnumrelpos_decode_relpos(snrp,lastsuftabvalue),
                        bustate,
                        err) != 0)
    {
      haserr = true;
    } else
    {
      TOP_ESA_BOTTOMUP_spmeq.rb = idx;
      /* no call to processlcpinterval_spmeq */
    }
  }
  stack->nextfreeGtBUItvinfo = 0; /* empty the stack */
  return haserr ? -1 : 0;
}
